/*
 * Copyright (C) 2006-2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "glue.h"

struct conv_gen {
	enum { CONV_GEN_MAGIC = 0x12348765 } magic;
	struct storage_simple *file;
	uint64_t size;
};

void *
conv_gen_open(const char *filename, uint64_t size)
{
	struct conv_gen *c;

	c = shm_alloc(sizeof(*c));
	assert(c);
	c->magic = CONV_GEN_MAGIC;

	c->file = storage_simple_open(filename, 0);
	if (! c->file) {
		shm_free(c);
		return NULL;
	}

	c->size = size;

	return c;
}

int
conv_gen_close(void *_c)
{
	struct conv_gen *c = _c;
	int ret;

	assert(c->magic == CONV_GEN_MAGIC);

	ret = storage_simple_close(c->file);

	c->magic = 0;
	shm_free(c);

	return ret;
}

int64_t
conv_gen_read(void *_c, void *_buf, uint64_t buflen, uint64_t pos)
{
	struct conv_gen *c = _c;
	char *buf = _buf;
	uint64_t len;
	int64_t ret;

	assert(c->magic == CONV_GEN_MAGIC);

	if (pos < storage_simple_size(c->file)) {
		/*
		 * Read from file.
		 */
		len = storage_simple_size(c->file) - pos;
		if (buflen < len) {
			len = buflen;
		}
		ret = storage_simple_read(c->file, buf, len, pos);
		assert(ret == len);

		buf += len;
		buflen -= len;
		pos += len;

		ret = len;
	} else {
		ret = 0;
	}
	if (pos < c->size) {
		/*
		 * Clear bytes.
		 */
		len = c->size - pos;
		if (buflen < len) {
			len = buflen;
		}
		memset(buf, 0, len);

		buf += len;
		buflen -= len;
		pos += len;

		ret += len;
	}
	/*
	 * Ignore rest.
	 */
	ret += buflen;

	return ret;
}
