/*
 * Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/*
 * Program the PIT (connected to irq 0) as well as provide utility 
 * sleep functions.
 */

.text

/* keyboard controller is irq0
 * io: 0x0040,41,42
 */

.globl setup_pit
setup_pit:
	/* only counter 0 */
	/* control word counter 0 (2 b)
	 * write both high/low byte, (2 b)
	 * select mode 2, (3b)
	 * don't use bcd (1b)
	 */
	movb $0b00110100, %al
	outb %al, $0x43

	/* get interrupts every 0.01 s:
	 * PIT frequency: 1.193182 MHz
	 * counter = 1.193182 * 10^6 * 0.01 s / s
	 *         = 1.193182 * 10^4 * 1
	 *         = 11931.82 
	 *         -> 11932
	 */
	movl $11932, %eax
	/* fist LSB */
	outb %al, $0x40
	/* then MSB */
	movb %ah, %al
	outb %al, $0x40

	/* all right, interrupts shall come */
	ret


.globl handle_pit_irq
handle_pit_irq:
	incl pit_counter_100th_sec
	cmpb $0, pit_callback
	jne _check_timer
	ret
_check_timer:
	pushl %eax
	movl pit_counter_100th_sec_wake, %eax
	cmpl pit_counter_100th_sec, %eax
	jbe _wake_timer
	popl %eax
	ret
_wake_timer:
	popl %eax
	pusha
	call *pit_callback
	popa
	movl $0, pit_callback
	ret

/* Call a callback (pointer in %edx) after %eax seconds
 * have passed.
 * Only one callback is supported, calling time_call_after 
 * again will overwrite the set counter.
 */
.globl time_call_after
time_call_after:
	movl %edx, pit_callback
	pushl %edx
	movl $100, %edx
	mull %edx
	addl pit_counter_100th_sec, %eax
	movl %eax, pit_counter_100th_sec_wake
	popl %edx
	ret

/* delay for %eax 1/100 seconds. */
.globl delay
delay:
	addl pit_counter_100th_sec, %eax
_delay_loop:
	hlt
	cmpl pit_counter_100th_sec, %eax
	ja _delay_loop
	ret

.globl rand6
rand6:
	movl pit_counter_100th_sec, %eax
	andl $0x7, %eax
	cmpb $6, %eax
	jb _rand6_out
	/* that's why the bank always wins :) */
	shrl $1, %eax
_rand6_out:
	incl %eax
	ret


.data
pit_counter_100th_sec:
	.long 0
pit_callback:
	.long 0
pit_counter_100th_sec_wake:
	.long 0
