QT += core gui concurrent
QT += dbus
QT += gui-private widgets-private

greaterThan(QT_MAJOR_VERSION, 4): QT += widgets

TARGET = deepin-phone-master
TEMPLATE = app
CONFIG += c++11 link_pkgconfig
PKGCONFIG += dtkwidget gio-unix-2.0 gio-qt udisks2-qt5 taglib

RESOURCES +=         \
    resources.qrc

LIBS +=  \
#        -lffmpegthumbnailer \
        -lavcodec \
        -lavdevice \
        -lavfilter \
        -lavformat \
        -lavutil \
#        -lpostproc \
        -lswresample \
        -lswscale \
        -ltag

DISTFILES += \
    apk/com.ut.phoneassistant.apk \
    deepin-phone-master.desktop

isEmpty(BINDIR):BINDIR=/usr/bin
isEmpty(APPDIR):APPDIR=/usr/share/applications
isEmpty(DSRDIR):DSRDIR=/usr/share/$$TARGET

target.path = $$INSTROOT$$BINDIR
desktop.path = $$INSTROOT$$APPDIR
desktop.files = $$PWD/deepin-phone-master.desktop

apk.path = /usr/share/$$TARGET/apk
apk.files = $$PWD/apk/com.ut.phoneassistant.apk

INSTALLS += target desktop apk

HEADERS += \
    accessible.h \
    accessibledefine.h \
    Application.h

SOURCES += \
    Application.cpp \
    main.cpp

unix:!macx: LIBS += -L$$OUT_PWD/../BasicService/TranslationService/ -lPhoneMasterTranslationService

INCLUDEPATH += $$PWD/../BasicService/TranslationService
DEPENDPATH += $$PWD/../BasicService/TranslationService

unix:!macx: LIBS += -L$$OUT_PWD/../BasicService/Model/ -lPhoneMasterModel

INCLUDEPATH += $$PWD/../BasicService/Model
DEPENDPATH += $$PWD/../BasicService/Model

unix:!macx: LIBS += -L$$OUT_PWD/../MountService/ -lPhoneMasterMountService

INCLUDEPATH += $$PWD/../MountService
DEPENDPATH += $$PWD/../MountService

unix:!macx: LIBS += -L$$OUT_PWD/../ThreadService/ -lPhoneMasterThreadService

INCLUDEPATH += $$PWD/../ThreadService
DEPENDPATH += $$PWD/../ThreadService

unix:!macx: LIBS += -L$$OUT_PWD/../UIService/ -lPhoneMasterUIService

INCLUDEPATH += $$PWD/../UIService
DEPENDPATH += $$PWD/../UIService

#QMAKE_CXXFLAGS += "-fsanitize=undefined,address,leak -fno-omit-frame-pointer"
#QMAKE_CFLAGS += "-fsanitize=undefined,address,leak -fno-omit-frame-pointer"
#QMAKE_LFLAGS += "-fsanitize=undefined,address,leak -fno-omit-frame-pointer"

unix:!macx: LIBS += -L$$OUT_PWD/../BasicService/Util/ -lPhoneMasterUtil

INCLUDEPATH += $$PWD/../BasicService/Util
DEPENDPATH += $$PWD/../BasicService/Util

unix:!macx: LIBS += -L$$OUT_PWD/../Engine/ -lPhoneMasterEngine

INCLUDEPATH += $$PWD/../Engine
DEPENDPATH += $$PWD/../Engine
