//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// copyright            : (C) 2013 by Eran Ifrah
// file name            : ps_linker_page.h
//
// -------------------------------------------------------------------------
// A
//              _____           _      _     _ _
//             /  __ \         | |    | |   (_) |
//             | /  \/ ___   __| | ___| |    _| |_ ___
//             | |    / _ \ / _  |/ _ \ |   | | __/ _ )
//             | \__/\ (_) | (_| |  __/ |___| | ||  __/
//              \____/\___/ \__,_|\___\_____/_|\__\___|
//
//                                                  F i l e
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

#ifndef __ps_linker_page__
#define __ps_linker_page__

/**
@file
Subclass of PSLinkPageBase, which is generated by wxFormBuilder.
*/

#include "project_settings_base_dlg.h"
#include "project_settings_dlg.h"

//// end generated include
class ProjectSettingsDlg;
class PSGeneralPage;

/** Implementing PSLinkPageBase */
class PSLinkerPage : public PSLinkPageBase, public IProjectSettingsPage
{
    ProjectSettingsDlg *m_dlg;
    PSGeneralPage*      m_gp;

protected:
    virtual void OnPropertyChanged(wxPropertyGridEvent& event);
    virtual void OnCheckLinkerNeeded(wxCommandEvent& event);
    virtual void OnLinkerNotNeededUI(wxUpdateUIEvent& event);
    virtual void OnProjectCustumBuildUI(wxUpdateUIEvent& event);
    virtual void OnCustomEditorClicked(wxCommandEvent& event);
    virtual void OnProjectEnabledUI(wxUpdateUIEvent& event);

public:
    /** Constructor */
    PSLinkerPage( wxWindow* parent, ProjectSettingsDlg *dlg, PSGeneralPage *gp );
    //// end generated class members

    virtual void Load(BuildConfigPtr buildConf);
    virtual void Save(BuildConfigPtr buildConf, ProjectSettingsPtr projSettingsPtr);
    virtual void Clear();

};

#endif // __ps_linker_page__
