{-# OPTIONS_GHC -w #-}
{-# OPTIONS -XMagicHash -XBangPatterns -XTypeSynonymInstances -XFlexibleInstances -cpp #-}
#if __GLASGOW_HASKELL__ >= 710
{-# OPTIONS_GHC -XPartialTypeSignatures #-}
#endif
{-# LANGUAGE TupleSections #-}

{-| The parser is generated by Happy (<http://www.haskell.org/happy>).
 -
 - Ideally, ranges should be as precise as possible, to get messages that
 - emphasize precisely the faulting term(s) upon error.
 -
 - However, interactive highlighting is only applied at the end of each
 - mutual block, keywords are only highlighted once (see
 - `TypeChecking.Rules.Decl'). So if the ranges of two declarations
 - interleave, one must ensure that keyword ranges are not included in
 - the intersection. (Otherwise they are uncolored by the interactive
 - highlighting.)
 -
 -}
module Agda.Syntax.Parser.Parser (
      moduleParser
    , moduleNameParser
    , exprParser
    , exprWhereParser
    , tokensParser
    , holeContentParser
    , splitOnDots  -- only used by the internal test-suite
    ) where

import Control.Monad

import Data.Char
import Data.Functor
import Data.List
import Data.Maybe
import Data.Monoid
import qualified Data.Traversable as T

import Debug.Trace

import Agda.Syntax.Position hiding (tests)
import Agda.Syntax.Parser.Monad
import Agda.Syntax.Parser.Lexer
import Agda.Syntax.Parser.Tokens
import Agda.Syntax.Concrete as C
import Agda.Syntax.Concrete.Pattern
import Agda.Syntax.Concrete.Pretty ()
import Agda.Syntax.Common
import Agda.Syntax.Fixity
import Agda.Syntax.Notation
import Agda.Syntax.Literal

import Agda.TypeChecking.Positivity.Occurrence hiding (tests)

import Agda.Utils.Either hiding (tests)
import Agda.Utils.Functor
import Agda.Utils.Hash
import Agda.Utils.List ( spanJust, chopWhen )
import Agda.Utils.Monad
import Agda.Utils.Pretty
import Agda.Utils.Singleton
import Agda.Utils.Tuple

import Agda.Utils.Impossible
#include "undefined.h"
import qualified Data.Array as Happy_Data_Array
import qualified Data.Bits as Bits
import qualified GHC.Exts as Happy_GHC_Exts
import Control.Applicative(Applicative(..))
import Control.Monad (ap)

-- parser produced by Happy Version 1.19.9

newtype HappyAbsSyn  = HappyAbsSyn HappyAny
#if __GLASGOW_HASKELL__ >= 607
type HappyAny = Happy_GHC_Exts.Any
#else
type HappyAny = forall a . a
#endif
happyIn10 :: ([Token]) -> (HappyAbsSyn )
happyIn10 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn10 #-}
happyOut10 :: (HappyAbsSyn ) -> ([Token])
happyOut10 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut10 #-}
happyIn11 :: ([Token]) -> (HappyAbsSyn )
happyIn11 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn11 #-}
happyOut11 :: (HappyAbsSyn ) -> ([Token])
happyOut11 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut11 #-}
happyIn12 :: (Token) -> (HappyAbsSyn )
happyIn12 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn12 #-}
happyOut12 :: (HappyAbsSyn ) -> (Token)
happyOut12 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut12 #-}
happyIn13 :: (([Pragma], [Declaration])) -> (HappyAbsSyn )
happyIn13 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn13 #-}
happyOut13 :: (HappyAbsSyn ) -> (([Pragma], [Declaration]))
happyOut13 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut13 #-}
happyIn14 :: (()) -> (HappyAbsSyn )
happyIn14 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn14 #-}
happyOut14 :: (HappyAbsSyn ) -> (())
happyOut14 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut14 #-}
happyIn15 :: (()) -> (HappyAbsSyn )
happyIn15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn15 #-}
happyOut15 :: (HappyAbsSyn ) -> (())
happyOut15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut15 #-}
happyIn16 :: (Interval) -> (HappyAbsSyn )
happyIn16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn16 #-}
happyOut16 :: (HappyAbsSyn ) -> (Interval)
happyOut16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut16 #-}
happyIn17 :: (()) -> (HappyAbsSyn )
happyIn17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn17 #-}
happyOut17 :: (HappyAbsSyn ) -> (())
happyOut17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut17 #-}
happyIn18 :: (Integer) -> (HappyAbsSyn )
happyIn18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn18 #-}
happyOut18 :: (HappyAbsSyn ) -> (Integer)
happyOut18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut18 #-}
happyIn19 :: (Name) -> (HappyAbsSyn )
happyIn19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn19 #-}
happyOut19 :: (HappyAbsSyn ) -> (Name)
happyOut19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut19 #-}
happyIn20 :: ([Name]) -> (HappyAbsSyn )
happyIn20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn20 #-}
happyOut20 :: (HappyAbsSyn ) -> ([Name])
happyOut20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut20 #-}
happyIn21 :: (Range) -> (HappyAbsSyn )
happyIn21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn21 #-}
happyOut21 :: (HappyAbsSyn ) -> (Range)
happyOut21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut21 #-}
happyIn22 :: (Arg Name) -> (HappyAbsSyn )
happyIn22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn22 #-}
happyOut22 :: (HappyAbsSyn ) -> (Arg Name)
happyOut22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut22 #-}
happyIn23 :: ([Arg Name]) -> (HappyAbsSyn )
happyIn23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn23 #-}
happyOut23 :: (HappyAbsSyn ) -> ([Arg Name])
happyOut23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut23 #-}
happyIn24 :: ([Arg Name]) -> (HappyAbsSyn )
happyIn24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn24 #-}
happyOut24 :: (HappyAbsSyn ) -> ([Arg Name])
happyOut24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut24 #-}
happyIn25 :: (QName) -> (HappyAbsSyn )
happyIn25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn25 #-}
happyOut25 :: (HappyAbsSyn ) -> (QName)
happyOut25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut25 #-}
happyIn26 :: (QName) -> (HappyAbsSyn )
happyIn26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn26 #-}
happyOut26 :: (HappyAbsSyn ) -> (QName)
happyOut26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut26 #-}
happyIn27 :: (Name) -> (HappyAbsSyn )
happyIn27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn27 #-}
happyOut27 :: (HappyAbsSyn ) -> (Name)
happyOut27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut27 #-}
happyIn28 :: ([Name]) -> (HappyAbsSyn )
happyIn28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn28 #-}
happyOut28 :: (HappyAbsSyn ) -> ([Name])
happyOut28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut28 #-}
happyIn29 :: ([Name]) -> (HappyAbsSyn )
happyIn29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn29 #-}
happyOut29 :: (HappyAbsSyn ) -> ([Name])
happyOut29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut29 #-}
happyIn30 :: (Either [Name] [Expr]) -> (HappyAbsSyn )
happyIn30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn30 #-}
happyOut30 :: (HappyAbsSyn ) -> (Either [Name] [Expr])
happyOut30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut30 #-}
happyIn31 :: ([WithHiding Name]) -> (HappyAbsSyn )
happyIn31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn31 #-}
happyOut31 :: (HappyAbsSyn ) -> ([WithHiding Name])
happyOut31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut31 #-}
happyIn32 :: ([String]) -> (HappyAbsSyn )
happyIn32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn32 #-}
happyOut32 :: (HappyAbsSyn ) -> ([String])
happyOut32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut32 #-}
happyIn33 :: (String) -> (HappyAbsSyn )
happyIn33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn33 #-}
happyOut33 :: (HappyAbsSyn ) -> (String)
happyOut33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut33 #-}
happyIn34 :: ([(Interval, String)]) -> (HappyAbsSyn )
happyIn34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn34 #-}
happyOut34 :: (HappyAbsSyn ) -> ([(Interval, String)])
happyOut34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut34 #-}
happyIn35 :: ([(Interval, String)]) -> (HappyAbsSyn )
happyIn35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn35 #-}
happyOut35 :: (HappyAbsSyn ) -> ([(Interval, String)])
happyOut35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut35 #-}
happyIn36 :: (Name) -> (HappyAbsSyn )
happyIn36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn36 #-}
happyOut36 :: (HappyAbsSyn ) -> (Name)
happyOut36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut36 #-}
happyIn37 :: (QName) -> (HappyAbsSyn )
happyIn37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn37 #-}
happyOut37 :: (HappyAbsSyn ) -> (QName)
happyOut37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut37 #-}
happyIn38 :: ([QName]) -> (HappyAbsSyn )
happyIn38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn38 #-}
happyOut38 :: (HappyAbsSyn ) -> ([QName])
happyOut38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut38 #-}
happyIn39 :: (Expr) -> (HappyAbsSyn )
happyIn39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn39 #-}
happyOut39 :: (HappyAbsSyn ) -> (Expr)
happyOut39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut39 #-}
happyIn40 :: (Expr) -> (HappyAbsSyn )
happyIn40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn40 #-}
happyOut40 :: (HappyAbsSyn ) -> (Expr)
happyOut40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut40 #-}
happyIn41 :: ([Expr]) -> (HappyAbsSyn )
happyIn41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn41 #-}
happyOut41 :: (HappyAbsSyn ) -> ([Expr])
happyOut41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut41 #-}
happyIn42 :: ([Expr]) -> (HappyAbsSyn )
happyIn42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn42 #-}
happyOut42 :: (HappyAbsSyn ) -> ([Expr])
happyOut42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut42 #-}
happyIn43 :: (Expr) -> (HappyAbsSyn )
happyIn43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn43 #-}
happyOut43 :: (HappyAbsSyn ) -> (Expr)
happyOut43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut43 #-}
happyIn44 :: (Maybe Expr) -> (HappyAbsSyn )
happyIn44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn44 #-}
happyOut44 :: (HappyAbsSyn ) -> (Maybe Expr)
happyOut44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut44 #-}
happyIn45 :: (Expr) -> (HappyAbsSyn )
happyIn45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn45 #-}
happyOut45 :: (HappyAbsSyn ) -> (Expr)
happyOut45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut45 #-}
happyIn46 :: ([Expr]) -> (HappyAbsSyn )
happyIn46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn46 #-}
happyOut46 :: (HappyAbsSyn ) -> ([Expr])
happyOut46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut46 #-}
happyIn47 :: ([Expr]) -> (HappyAbsSyn )
happyIn47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn47 #-}
happyOut47 :: (HappyAbsSyn ) -> ([Expr])
happyOut47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut47 #-}
happyIn48 :: (Expr) -> (HappyAbsSyn )
happyIn48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn48 #-}
happyOut48 :: (HappyAbsSyn ) -> (Expr)
happyOut48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut48 #-}
happyIn49 :: (Expr) -> (HappyAbsSyn )
happyIn49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn49 #-}
happyOut49 :: (HappyAbsSyn ) -> (Expr)
happyOut49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut49 #-}
happyIn50 :: (Expr) -> (HappyAbsSyn )
happyIn50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn50 #-}
happyOut50 :: (HappyAbsSyn ) -> (Expr)
happyOut50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut50 #-}
happyIn51 :: (RecordAssignments) -> (HappyAbsSyn )
happyIn51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn51 #-}
happyOut51 :: (HappyAbsSyn ) -> (RecordAssignments)
happyOut51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut51 #-}
happyIn52 :: (RecordAssignments) -> (HappyAbsSyn )
happyIn52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn52 #-}
happyOut52 :: (HappyAbsSyn ) -> (RecordAssignments)
happyOut52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut52 #-}
happyIn53 :: (RecordAssignment) -> (HappyAbsSyn )
happyIn53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn53 #-}
happyOut53 :: (HappyAbsSyn ) -> (RecordAssignment)
happyOut53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut53 #-}
happyIn54 :: (ModuleAssignment) -> (HappyAbsSyn )
happyIn54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn54 #-}
happyOut54 :: (HappyAbsSyn ) -> (ModuleAssignment)
happyOut54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut54 #-}
happyIn55 :: ([FieldAssignment]) -> (HappyAbsSyn )
happyIn55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn55 #-}
happyOut55 :: (HappyAbsSyn ) -> ([FieldAssignment])
happyOut55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut55 #-}
happyIn56 :: ([FieldAssignment]) -> (HappyAbsSyn )
happyIn56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn56 #-}
happyOut56 :: (HappyAbsSyn ) -> ([FieldAssignment])
happyOut56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut56 #-}
happyIn57 :: (FieldAssignment) -> (HappyAbsSyn )
happyIn57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn57 #-}
happyOut57 :: (HappyAbsSyn ) -> (FieldAssignment)
happyOut57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut57 #-}
happyIn58 :: (Telescope) -> (HappyAbsSyn )
happyIn58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn58 #-}
happyOut58 :: (HappyAbsSyn ) -> (Telescope)
happyOut58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut58 #-}
happyIn59 :: (Telescope) -> (HappyAbsSyn )
happyIn59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn59 #-}
happyOut59 :: (HappyAbsSyn ) -> (Telescope)
happyOut59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut59 #-}
happyIn60 :: ([TypedBindings]) -> (HappyAbsSyn )
happyIn60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn60 #-}
happyOut60 :: (HappyAbsSyn ) -> ([TypedBindings])
happyOut60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut60 #-}
happyIn61 :: (TypedBindings) -> (HappyAbsSyn )
happyIn61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn61 #-}
happyOut61 :: (HappyAbsSyn ) -> (TypedBindings)
happyOut61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut61 #-}
happyIn62 :: (TypedBindings) -> (HappyAbsSyn )
happyIn62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn62 #-}
happyOut62 :: (HappyAbsSyn ) -> (TypedBindings)
happyOut62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut62 #-}
happyIn63 :: (TypedBindings) -> (HappyAbsSyn )
happyIn63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn63 #-}
happyOut63 :: (HappyAbsSyn ) -> (TypedBindings)
happyOut63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut63 #-}
happyIn64 :: ([LamBinding]) -> (HappyAbsSyn )
happyIn64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn64 #-}
happyOut64 :: (HappyAbsSyn ) -> ([LamBinding])
happyOut64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut64 #-}
happyIn65 :: (Either ([LamBinding], Hiding) [Expr]) -> (HappyAbsSyn )
happyIn65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn65 #-}
happyOut65 :: (HappyAbsSyn ) -> (Either ([LamBinding], Hiding) [Expr])
happyOut65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut65 #-}
happyIn66 :: ([Either Hiding LamBinding]) -> (HappyAbsSyn )
happyIn66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn66 #-}
happyOut66 :: (HappyAbsSyn ) -> ([Either Hiding LamBinding])
happyOut66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut66 #-}
happyIn67 :: (Either [Either Hiding LamBinding] [Expr]) -> (HappyAbsSyn )
happyIn67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn67 #-}
happyOut67 :: (HappyAbsSyn ) -> (Either [Either Hiding LamBinding] [Expr])
happyOut67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut67 #-}
happyIn68 :: (LamClause) -> (HappyAbsSyn )
happyIn68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn68 #-}
happyOut68 :: (HappyAbsSyn ) -> (LamClause)
happyOut68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut68 #-}
happyIn69 :: (LamClause) -> (HappyAbsSyn )
happyIn69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn69 #-}
happyOut69 :: (HappyAbsSyn ) -> (LamClause)
happyOut69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut69 #-}
happyIn70 :: (LamClause) -> (HappyAbsSyn )
happyIn70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn70 #-}
happyOut70 :: (HappyAbsSyn ) -> (LamClause)
happyOut70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut70 #-}
happyIn71 :: ([LamClause]) -> (HappyAbsSyn )
happyIn71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn71 #-}
happyOut71 :: (HappyAbsSyn ) -> ([LamClause])
happyOut71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut71 #-}
happyIn72 :: ([LamClause]) -> (HappyAbsSyn )
happyIn72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn72 #-}
happyOut72 :: (HappyAbsSyn ) -> ([LamClause])
happyOut72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut72 #-}
happyIn73 :: ([LamBinding]) -> (HappyAbsSyn )
happyIn73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn73 #-}
happyOut73 :: (HappyAbsSyn ) -> ([LamBinding])
happyOut73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut73 #-}
happyIn74 :: ([LamBinding]) -> (HappyAbsSyn )
happyIn74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn74 #-}
happyOut74 :: (HappyAbsSyn ) -> ([LamBinding])
happyOut74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut74 #-}
happyIn75 :: ([LamBinding]) -> (HappyAbsSyn )
happyIn75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn75 #-}
happyOut75 :: (HappyAbsSyn ) -> ([LamBinding])
happyOut75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut75 #-}
happyIn76 :: ([LamBinding]) -> (HappyAbsSyn )
happyIn76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn76 #-}
happyOut76 :: (HappyAbsSyn ) -> ([LamBinding])
happyOut76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut76 #-}
happyIn77 :: (Either [LamBinding] [Expr]) -> (HappyAbsSyn )
happyIn77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn77 #-}
happyOut77 :: (HappyAbsSyn ) -> (Either [LamBinding] [Expr])
happyOut77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut77 #-}
happyIn78 :: ([DoStmt]) -> (HappyAbsSyn )
happyIn78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn78 #-}
happyOut78 :: (HappyAbsSyn ) -> ([DoStmt])
happyOut78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut78 #-}
happyIn79 :: (DoStmt) -> (HappyAbsSyn )
happyIn79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn79 #-}
happyOut79 :: (HappyAbsSyn ) -> (DoStmt)
happyOut79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut79 #-}
happyIn80 :: ([LamClause]) -> (HappyAbsSyn )
happyIn80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn80 #-}
happyOut80 :: (HappyAbsSyn ) -> ([LamClause])
happyOut80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut80 #-}
happyIn81 :: (ImportDirective) -> (HappyAbsSyn )
happyIn81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn81 #-}
happyOut81 :: (HappyAbsSyn ) -> (ImportDirective)
happyOut81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut81 #-}
happyIn82 :: ([ImportDirective]) -> (HappyAbsSyn )
happyIn82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn82 #-}
happyOut82 :: (HappyAbsSyn ) -> ([ImportDirective])
happyOut82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut82 #-}
happyIn83 :: (ImportDirective) -> (HappyAbsSyn )
happyIn83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn83 #-}
happyOut83 :: (HappyAbsSyn ) -> (ImportDirective)
happyOut83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut83 #-}
happyIn84 :: ((Using, Range)) -> (HappyAbsSyn )
happyIn84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn84 #-}
happyOut84 :: (HappyAbsSyn ) -> ((Using, Range))
happyOut84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut84 #-}
happyIn85 :: (([ImportedName], Range)) -> (HappyAbsSyn )
happyIn85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn85 #-}
happyOut85 :: (HappyAbsSyn ) -> (([ImportedName], Range))
happyOut85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut85 #-}
happyIn86 :: (([Renaming] , Range)) -> (HappyAbsSyn )
happyIn86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn86 #-}
happyOut86 :: (HappyAbsSyn ) -> (([Renaming] , Range))
happyOut86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut86 #-}
happyIn87 :: ([Renaming]) -> (HappyAbsSyn )
happyIn87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn87 #-}
happyOut87 :: (HappyAbsSyn ) -> ([Renaming])
happyOut87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut87 #-}
happyIn88 :: (Renaming) -> (HappyAbsSyn )
happyIn88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn88 #-}
happyOut88 :: (HappyAbsSyn ) -> (Renaming)
happyOut88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut88 #-}
happyIn89 :: (ImportedName) -> (HappyAbsSyn )
happyIn89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn89 #-}
happyOut89 :: (HappyAbsSyn ) -> (ImportedName)
happyOut89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut89 #-}
happyIn90 :: (ImportedName) -> (HappyAbsSyn )
happyIn90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn90 #-}
happyOut90 :: (HappyAbsSyn ) -> (ImportedName)
happyOut90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut90 #-}
happyIn91 :: ([ImportedName]) -> (HappyAbsSyn )
happyIn91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn91 #-}
happyOut91 :: (HappyAbsSyn ) -> ([ImportedName])
happyOut91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut91 #-}
happyIn92 :: ([ImportedName]) -> (HappyAbsSyn )
happyIn92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn92 #-}
happyOut92 :: (HappyAbsSyn ) -> ([ImportedName])
happyOut92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut92 #-}
happyIn93 :: (LHS) -> (HappyAbsSyn )
happyIn93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn93 #-}
happyOut93 :: (HappyAbsSyn ) -> (LHS)
happyOut93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut93 #-}
happyIn94 :: ([Expr]) -> (HappyAbsSyn )
happyIn94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn94 #-}
happyOut94 :: (HappyAbsSyn ) -> ([Expr])
happyOut94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut94 #-}
happyIn95 :: ([Expr]) -> (HappyAbsSyn )
happyIn95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn95 #-}
happyOut95 :: (HappyAbsSyn ) -> ([Expr])
happyOut95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut95 #-}
happyIn96 :: (HoleContent) -> (HappyAbsSyn )
happyIn96 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn96 #-}
happyOut96 :: (HappyAbsSyn ) -> (HoleContent)
happyOut96 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut96 #-}
happyIn97 :: (WhereClause) -> (HappyAbsSyn )
happyIn97 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn97 #-}
happyOut97 :: (HappyAbsSyn ) -> (WhereClause)
happyOut97 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut97 #-}
happyIn98 :: (ExprWhere) -> (HappyAbsSyn )
happyIn98 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn98 #-}
happyOut98 :: (HappyAbsSyn ) -> (ExprWhere)
happyOut98 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut98 #-}
happyIn99 :: ([Declaration]) -> (HappyAbsSyn )
happyIn99 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn99 #-}
happyOut99 :: (HappyAbsSyn ) -> ([Declaration])
happyOut99 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut99 #-}
happyIn100 :: ([Declaration]) -> (HappyAbsSyn )
happyIn100 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn100 #-}
happyOut100 :: (HappyAbsSyn ) -> ([Declaration])
happyOut100 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut100 #-}
happyIn101 :: ([Arg Declaration]) -> (HappyAbsSyn )
happyIn101 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn101 #-}
happyOut101 :: (HappyAbsSyn ) -> ([Arg Declaration])
happyOut101 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut101 #-}
happyIn102 :: ([Declaration]) -> (HappyAbsSyn )
happyIn102 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn102 #-}
happyOut102 :: (HappyAbsSyn ) -> ([Declaration])
happyOut102 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut102 #-}
happyIn103 :: (RHSOrTypeSigs) -> (HappyAbsSyn )
happyIn103 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn103 #-}
happyOut103 :: (HappyAbsSyn ) -> (RHSOrTypeSigs)
happyOut103 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut103 #-}
happyIn104 :: (Declaration) -> (HappyAbsSyn )
happyIn104 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn104 #-}
happyOut104 :: (HappyAbsSyn ) -> (Declaration)
happyOut104 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut104 #-}
happyIn105 :: (Declaration) -> (HappyAbsSyn )
happyIn105 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn105 #-}
happyOut105 :: (HappyAbsSyn ) -> (Declaration)
happyOut105 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut105 #-}
happyIn106 :: (Declaration) -> (HappyAbsSyn )
happyIn106 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn106 #-}
happyOut106 :: (HappyAbsSyn ) -> (Declaration)
happyOut106 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut106 #-}
happyIn107 :: (Declaration) -> (HappyAbsSyn )
happyIn107 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn107 #-}
happyOut107 :: (HappyAbsSyn ) -> (Declaration)
happyOut107 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut107 #-}
happyIn108 :: ((Name, IsInstance)) -> (HappyAbsSyn )
happyIn108 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn108 #-}
happyOut108 :: (HappyAbsSyn ) -> ((Name, IsInstance))
happyOut108 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut108 #-}
happyIn109 :: (Declaration) -> (HappyAbsSyn )
happyIn109 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn109 #-}
happyOut109 :: (HappyAbsSyn ) -> (Declaration)
happyOut109 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut109 #-}
happyIn110 :: ([Declaration]) -> (HappyAbsSyn )
happyIn110 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn110 #-}
happyOut110 :: (HappyAbsSyn ) -> ([Declaration])
happyOut110 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut110 #-}
happyIn111 :: (Declaration) -> (HappyAbsSyn )
happyIn111 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn111 #-}
happyOut111 :: (HappyAbsSyn ) -> (Declaration)
happyOut111 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut111 #-}
happyIn112 :: (Declaration) -> (HappyAbsSyn )
happyIn112 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn112 #-}
happyOut112 :: (HappyAbsSyn ) -> (Declaration)
happyOut112 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut112 #-}
happyIn113 :: (Declaration) -> (HappyAbsSyn )
happyIn113 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn113 #-}
happyOut113 :: (HappyAbsSyn ) -> (Declaration)
happyOut113 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut113 #-}
happyIn114 :: (Declaration) -> (HappyAbsSyn )
happyIn114 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn114 #-}
happyOut114 :: (HappyAbsSyn ) -> (Declaration)
happyOut114 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut114 #-}
happyIn115 :: (Declaration) -> (HappyAbsSyn )
happyIn115 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn115 #-}
happyOut115 :: (HappyAbsSyn ) -> (Declaration)
happyOut115 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut115 #-}
happyIn116 :: (Declaration) -> (HappyAbsSyn )
happyIn116 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn116 #-}
happyOut116 :: (HappyAbsSyn ) -> (Declaration)
happyOut116 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut116 #-}
happyIn117 :: (Declaration) -> (HappyAbsSyn )
happyIn117 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn117 #-}
happyOut117 :: (HappyAbsSyn ) -> (Declaration)
happyOut117 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut117 #-}
happyIn118 :: (Declaration) -> (HappyAbsSyn )
happyIn118 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn118 #-}
happyOut118 :: (HappyAbsSyn ) -> (Declaration)
happyOut118 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut118 #-}
happyIn119 :: (Declaration) -> (HappyAbsSyn )
happyIn119 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn119 #-}
happyOut119 :: (HappyAbsSyn ) -> (Declaration)
happyOut119 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut119 #-}
happyIn120 :: (Declaration) -> (HappyAbsSyn )
happyIn120 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn120 #-}
happyOut120 :: (HappyAbsSyn ) -> (Declaration)
happyOut120 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut120 #-}
happyIn121 :: ([Arg Name]) -> (HappyAbsSyn )
happyIn121 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn121 #-}
happyOut121 :: (HappyAbsSyn ) -> ([Arg Name])
happyOut121 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut121 #-}
happyIn122 :: ([RString]) -> (HappyAbsSyn )
happyIn122 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn122 #-}
happyOut122 :: (HappyAbsSyn ) -> ([RString])
happyOut122 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut122 #-}
happyIn123 :: ([NamedArg HoleName]) -> (HappyAbsSyn )
happyIn123 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn123 #-}
happyOut123 :: (HappyAbsSyn ) -> ([NamedArg HoleName])
happyOut123 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut123 #-}
happyIn124 :: (NamedArg HoleName) -> (HappyAbsSyn )
happyIn124 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn124 #-}
happyOut124 :: (HappyAbsSyn ) -> (NamedArg HoleName)
happyOut124 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut124 #-}
happyIn125 :: (HoleName) -> (HappyAbsSyn )
happyIn125 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn125 #-}
happyOut125 :: (HappyAbsSyn ) -> (HoleName)
happyOut125 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut125 #-}
happyIn126 :: (HoleName) -> (HappyAbsSyn )
happyIn126 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn126 #-}
happyOut126 :: (HappyAbsSyn ) -> (HoleName)
happyOut126 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut126 #-}
happyIn127 :: (RString) -> (HappyAbsSyn )
happyIn127 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn127 #-}
happyOut127 :: (HappyAbsSyn ) -> (RString)
happyOut127 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut127 #-}
happyIn128 :: (Maybe Range) -> (HappyAbsSyn )
happyIn128 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn128 #-}
happyOut128 :: (HappyAbsSyn ) -> (Maybe Range)
happyOut128 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut128 #-}
happyIn129 :: ([Declaration]) -> (HappyAbsSyn )
happyIn129 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn129 #-}
happyOut129 :: (HappyAbsSyn ) -> ([Declaration])
happyOut129 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut129 #-}
happyIn130 :: ([Expr]) -> (HappyAbsSyn )
happyIn130 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn130 #-}
happyOut130 :: (HappyAbsSyn ) -> ([Expr])
happyOut130 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut130 #-}
happyIn131 :: ([TypedBindings] -> Parser ModuleApplication) -> (HappyAbsSyn )
happyIn131 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn131 #-}
happyOut131 :: (HappyAbsSyn ) -> ([TypedBindings] -> Parser ModuleApplication)
happyOut131 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut131 #-}
happyIn132 :: (Declaration) -> (HappyAbsSyn )
happyIn132 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn132 #-}
happyOut132 :: (HappyAbsSyn ) -> (Declaration)
happyOut132 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut132 #-}
happyIn133 :: (Declaration) -> (HappyAbsSyn )
happyIn133 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn133 #-}
happyOut133 :: (HappyAbsSyn ) -> (Declaration)
happyOut133 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut133 #-}
happyIn134 :: (Name) -> (HappyAbsSyn )
happyIn134 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn134 #-}
happyOut134 :: (HappyAbsSyn ) -> (Name)
happyOut134 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut134 #-}
happyIn135 :: ([Declaration]) -> (HappyAbsSyn )
happyIn135 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn135 #-}
happyOut135 :: (HappyAbsSyn ) -> ([Declaration])
happyOut135 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut135 #-}
happyIn136 :: (Declaration) -> (HappyAbsSyn )
happyIn136 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn136 #-}
happyOut136 :: (HappyAbsSyn ) -> (Declaration)
happyOut136 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut136 #-}
happyIn137 :: (Pragma) -> (HappyAbsSyn )
happyIn137 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn137 #-}
happyOut137 :: (HappyAbsSyn ) -> (Pragma)
happyOut137 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut137 #-}
happyIn138 :: (Pragma) -> (HappyAbsSyn )
happyIn138 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn138 #-}
happyOut138 :: (HappyAbsSyn ) -> (Pragma)
happyOut138 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut138 #-}
happyIn139 :: (Pragma) -> (HappyAbsSyn )
happyIn139 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn139 #-}
happyOut139 :: (HappyAbsSyn ) -> (Pragma)
happyOut139 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut139 #-}
happyIn140 :: (Pragma) -> (HappyAbsSyn )
happyIn140 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn140 #-}
happyOut140 :: (HappyAbsSyn ) -> (Pragma)
happyOut140 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut140 #-}
happyIn141 :: (Pragma) -> (HappyAbsSyn )
happyIn141 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn141 #-}
happyOut141 :: (HappyAbsSyn ) -> (Pragma)
happyOut141 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut141 #-}
happyIn142 :: (Pragma) -> (HappyAbsSyn )
happyIn142 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn142 #-}
happyOut142 :: (HappyAbsSyn ) -> (Pragma)
happyOut142 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut142 #-}
happyIn143 :: (Pragma) -> (HappyAbsSyn )
happyIn143 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn143 #-}
happyOut143 :: (HappyAbsSyn ) -> (Pragma)
happyOut143 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut143 #-}
happyIn144 :: (Pragma) -> (HappyAbsSyn )
happyIn144 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn144 #-}
happyOut144 :: (HappyAbsSyn ) -> (Pragma)
happyOut144 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut144 #-}
happyIn145 :: (Pragma) -> (HappyAbsSyn )
happyIn145 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn145 #-}
happyOut145 :: (HappyAbsSyn ) -> (Pragma)
happyOut145 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut145 #-}
happyIn146 :: (Pragma) -> (HappyAbsSyn )
happyIn146 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn146 #-}
happyOut146 :: (HappyAbsSyn ) -> (Pragma)
happyOut146 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut146 #-}
happyIn147 :: (Pragma) -> (HappyAbsSyn )
happyIn147 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn147 #-}
happyOut147 :: (HappyAbsSyn ) -> (Pragma)
happyOut147 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut147 #-}
happyIn148 :: (Pragma) -> (HappyAbsSyn )
happyIn148 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn148 #-}
happyOut148 :: (HappyAbsSyn ) -> (Pragma)
happyOut148 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut148 #-}
happyIn149 :: (Pragma) -> (HappyAbsSyn )
happyIn149 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn149 #-}
happyOut149 :: (HappyAbsSyn ) -> (Pragma)
happyOut149 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut149 #-}
happyIn150 :: (Pragma) -> (HappyAbsSyn )
happyIn150 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn150 #-}
happyOut150 :: (HappyAbsSyn ) -> (Pragma)
happyOut150 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut150 #-}
happyIn151 :: (Pragma) -> (HappyAbsSyn )
happyIn151 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn151 #-}
happyOut151 :: (HappyAbsSyn ) -> (Pragma)
happyOut151 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut151 #-}
happyIn152 :: (Pragma) -> (HappyAbsSyn )
happyIn152 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn152 #-}
happyOut152 :: (HappyAbsSyn ) -> (Pragma)
happyOut152 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut152 #-}
happyIn153 :: (Pragma) -> (HappyAbsSyn )
happyIn153 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn153 #-}
happyOut153 :: (HappyAbsSyn ) -> (Pragma)
happyOut153 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut153 #-}
happyIn154 :: (Pragma) -> (HappyAbsSyn )
happyIn154 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn154 #-}
happyOut154 :: (HappyAbsSyn ) -> (Pragma)
happyOut154 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut154 #-}
happyIn155 :: (Pragma) -> (HappyAbsSyn )
happyIn155 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn155 #-}
happyOut155 :: (HappyAbsSyn ) -> (Pragma)
happyOut155 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut155 #-}
happyIn156 :: (Pragma) -> (HappyAbsSyn )
happyIn156 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn156 #-}
happyOut156 :: (HappyAbsSyn ) -> (Pragma)
happyOut156 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut156 #-}
happyIn157 :: (Pragma) -> (HappyAbsSyn )
happyIn157 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn157 #-}
happyOut157 :: (HappyAbsSyn ) -> (Pragma)
happyOut157 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut157 #-}
happyIn158 :: (Pragma) -> (HappyAbsSyn )
happyIn158 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn158 #-}
happyOut158 :: (HappyAbsSyn ) -> (Pragma)
happyOut158 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut158 #-}
happyIn159 :: (Pragma) -> (HappyAbsSyn )
happyIn159 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn159 #-}
happyOut159 :: (HappyAbsSyn ) -> (Pragma)
happyOut159 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut159 #-}
happyIn160 :: (Pragma) -> (HappyAbsSyn )
happyIn160 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn160 #-}
happyOut160 :: (HappyAbsSyn ) -> (Pragma)
happyOut160 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut160 #-}
happyIn161 :: (Pragma) -> (HappyAbsSyn )
happyIn161 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn161 #-}
happyOut161 :: (HappyAbsSyn ) -> (Pragma)
happyOut161 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut161 #-}
happyIn162 :: (Pragma) -> (HappyAbsSyn )
happyIn162 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn162 #-}
happyOut162 :: (HappyAbsSyn ) -> (Pragma)
happyOut162 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut162 #-}
happyIn163 :: (Pragma) -> (HappyAbsSyn )
happyIn163 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn163 #-}
happyOut163 :: (HappyAbsSyn ) -> (Pragma)
happyOut163 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut163 #-}
happyIn164 :: (Pragma) -> (HappyAbsSyn )
happyIn164 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn164 #-}
happyOut164 :: (HappyAbsSyn ) -> (Pragma)
happyOut164 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut164 #-}
happyIn165 :: (Pragma) -> (HappyAbsSyn )
happyIn165 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn165 #-}
happyOut165 :: (HappyAbsSyn ) -> (Pragma)
happyOut165 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut165 #-}
happyIn166 :: (Pragma) -> (HappyAbsSyn )
happyIn166 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn166 #-}
happyOut166 :: (HappyAbsSyn ) -> (Pragma)
happyOut166 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut166 #-}
happyIn167 :: (Pragma) -> (HappyAbsSyn )
happyIn167 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn167 #-}
happyOut167 :: (HappyAbsSyn ) -> (Pragma)
happyOut167 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut167 #-}
happyIn168 :: ([(Range, Occurrence)]) -> (HappyAbsSyn )
happyIn168 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn168 #-}
happyOut168 :: (HappyAbsSyn ) -> ([(Range, Occurrence)])
happyOut168 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut168 #-}
happyIn169 :: ((Range, Occurrence)) -> (HappyAbsSyn )
happyIn169 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn169 #-}
happyOut169 :: (HappyAbsSyn ) -> ((Range, Occurrence))
happyOut169 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut169 #-}
happyIn170 :: ([TypeSignature]) -> (HappyAbsSyn )
happyIn170 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn170 #-}
happyOut170 :: (HappyAbsSyn ) -> ([TypeSignature])
happyOut170 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut170 #-}
happyIn171 :: ([TypeSignature]) -> (HappyAbsSyn )
happyIn171 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn171 #-}
happyOut171 :: (HappyAbsSyn ) -> ([TypeSignature])
happyOut171 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut171 #-}
happyIn172 :: ([Arg TypeSignature]) -> (HappyAbsSyn )
happyIn172 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn172 #-}
happyOut172 :: (HappyAbsSyn ) -> ([Arg TypeSignature])
happyOut172 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut172 #-}
happyIn173 :: ([Arg TypeSignature]) -> (HappyAbsSyn )
happyIn173 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn173 #-}
happyOut173 :: (HappyAbsSyn ) -> ([Arg TypeSignature])
happyOut173 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut173 #-}
happyIn174 :: (((Maybe (Ranged Induction), Maybe HasEta, Maybe (Name, IsInstance)), [Declaration])) -> (HappyAbsSyn )
happyIn174 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn174 #-}
happyOut174 :: (HappyAbsSyn ) -> (((Maybe (Ranged Induction), Maybe HasEta, Maybe (Name, IsInstance)), [Declaration]))
happyOut174 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut174 #-}
happyIn175 :: ([RecordDirective]) -> (HappyAbsSyn )
happyIn175 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn175 #-}
happyOut175 :: (HappyAbsSyn ) -> ([RecordDirective])
happyOut175 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut175 #-}
happyIn176 :: (RecordDirective) -> (HappyAbsSyn )
happyIn176 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn176 #-}
happyOut176 :: (HappyAbsSyn ) -> (RecordDirective)
happyOut176 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut176 #-}
happyIn177 :: (Ranged HasEta) -> (HappyAbsSyn )
happyIn177 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn177 #-}
happyOut177 :: (HappyAbsSyn ) -> (Ranged HasEta)
happyOut177 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut177 #-}
happyIn178 :: (Ranged Induction) -> (HappyAbsSyn )
happyIn178 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn178 #-}
happyOut178 :: (HappyAbsSyn ) -> (Ranged Induction)
happyOut178 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut178 #-}
happyIn179 :: ([Declaration]) -> (HappyAbsSyn )
happyIn179 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn179 #-}
happyOut179 :: (HappyAbsSyn ) -> ([Declaration])
happyOut179 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut179 #-}
happyIn180 :: ([Declaration]) -> (HappyAbsSyn )
happyIn180 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn180 #-}
happyOut180 :: (HappyAbsSyn ) -> ([Declaration])
happyOut180 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut180 #-}
happyIn181 :: ([Declaration]) -> (HappyAbsSyn )
happyIn181 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn181 #-}
happyOut181 :: (HappyAbsSyn ) -> ([Declaration])
happyOut181 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut181 #-}
happyIn182 :: ([Declaration]) -> (HappyAbsSyn )
happyIn182 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn182 #-}
happyOut182 :: (HappyAbsSyn ) -> ([Declaration])
happyOut182 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut182 #-}
happyInTok :: (Token) -> (HappyAbsSyn )
happyInTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyInTok #-}
happyOutTok :: (HappyAbsSyn ) -> (Token)
happyOutTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOutTok #-}


happyExpList :: HappyAddr
happyExpList = HappyA# "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x1c\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x14\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x56\x08\x00\x00\x00\xc8\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\x48\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x1c\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x44\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x41\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xda\x44\x00\x00\x00\x00\x48\x31\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x14\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x4d\x04\x00\x00\x00\x80\x14\x43\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x4d\x04\x00\x00\x00\x80\x14\x43\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x80\x11\x44\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa1\x4f\x85\x00\x00\x00\x80\x1c\xcb\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x1c\x4b\x3d\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x54\x83\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xda\x44\x00\x00\x00\x00\x48\x31\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x1c\xcb\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\xd4\x83\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x1c\x4b\x35\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x34\xbc\xf7\xfb\xdc\x09\x00\x00\x00\x48\xb1\x54\xa1\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x4d\x04\x00\x00\x00\x80\x14\x43\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\xff\xff\x7f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x1c\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\x48\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x11\x44\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x1c\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x41\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x44\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x41\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa1\x4f\x85\x00\x00\x00\x80\x14\xcb\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\x48\xb1\xd4\x83\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x14\x4b\x35\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x5c\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x1c\x4b\x3d\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x54\x83\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x14\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\x48\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x14\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xda\x44\x00\x00\x00\x00\x48\x31\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x34\xbc\xf7\xfb\xdc\x09\x00\x00\x00\x48\xb1\x54\xa1\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x41\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x11\x44\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x10\xfa\x54\x08\x00\x00\x00\x48\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x14\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\x48\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x14\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\x48\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x1c\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x4d\x04\x00\x00\x00\x80\x14\x43\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\x48\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x14\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\x48\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x14\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x1c\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xda\x44\x00\x00\x00\x00\x48\x31\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x14\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x14\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x14\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x14\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\x48\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\x48\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x14\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\x48\xb1\x54\xa1\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x41\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x41\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x10\xfa\x54\x08\x00\x00\x00\x48\xb1\x5c\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x14\x4b\x3d\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\x48\xb1\x54\x83\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xda\x44\x00\x00\x00\x00\x48\x31\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x11\x44\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\xc3\x7b\xbf\xcf\x9d\x00\x00\x00\x80\x14\x4b\x95\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x41\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x11\x44\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x41\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x60\x00\x00\x00\x00\x00\x00\x00\x80\x01\x40\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x41\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x11\x44\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\xc3\x7b\xbf\xcf\x9d\x00\x00\x00\x80\x14\x4b\x15\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xda\x44\x00\x00\x00\x00\x48\x31\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x41\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x41\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x40\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x11\x44\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\x48\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x40\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x1c\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x4d\x04\x00\x00\x00\x80\x14\x43\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x04\x01\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x1c\x4b\x3d\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\x48\xb1\x54\xa1\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x14\x4b\x15\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x1c\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x04\x01\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x1c\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x04\x01\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x14\x4b\x15\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\x48\xb1\x54\xa1\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x1c\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x60\x00\x00\x00\x00\x00\x00\x00\x80\x01\x40\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x1c\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x1c\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x40\x10\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08\xa0\x4f\x85\x00\x00\x00\x80\x1c\x4b\x15\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x40\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xda\x44\x00\x00\x00\x00\x48\x31\x54\x81\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x40\x10\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xe3\xfb\xbf\xcf\x9d\x00\x00\x00\x80\x14\x4b\x15\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x40\x10\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x40\x10\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x80\x00\xfa\x54\x08\x00\x00\x00\xc8\xb1\xd4\x83\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x40\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x14\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x40\x81\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\xc3\x7b\xbf\xcf\x9d\x00\x00\x00\x80\x14\x4b\x95\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xe3\xfb\xbf\xcf\x9d\x00\x00\x00\x80\x14\x4b\x15\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

{-# NOINLINE happyExpListPerState #-}
happyExpListPerState st =
    token_strs_expected
  where token_strs = ["error","%dummy","%start_tokensParser","%start_exprParser","%start_exprWhereParser","%start_moduleParser","%start_moduleNameParser","%start_funclauseParser","%start_holeContentParser","Tokens","TokensR","Token","File","maybe_vclose","close","semi","beginImpDir","Int","Id","SpaceIds","DoubleCloseBrace","MaybeDottedId","MaybeDottedIds","ArgIds","QId","ModuleName","BId","SpaceBIds","CommaBIds","CommaBIdAndAbsurds","BIdsWithHiding","PragmaStrings","PragmaString","Strings","ForeignCode","PragmaName","PragmaQName","PragmaQNames","Expr","Expr1","WithExprs","Application","Expr2","LetBody","ExtendedOrAbsurdLam","Application3","Application3PossiblyEmpty","Expr3Curly","Expr3NoCurly","Expr3","RecordAssignments","RecordAssignments1","RecordAssignment","ModuleAssignment","FieldAssignments","FieldAssignments1","FieldAssignment","TeleArrow","Telescope1","TypedBindingss","TypedBindings","TBind","TBindWithHiding","LamBindings","AbsurdLamBindings","LamBinds","LamBindsAbsurd","NonAbsurdLamClause","AbsurdLamClause","LamClause","LamClauses","LamWhereClauses","ForallBindings","TypedUntypedBindings1","TypedUntypedBindings","DomainFreeBinding","DomainFreeBindingAbsurd","DoStmts","DoStmt","DoWhere","ImportDirective","ImportDirectives","ImportDirective1","Using","Hiding","RenamingDir","Renamings","Renaming","ImportName_","ImportName","CommaImportNames","CommaImportNames1","LHS","WithExpressions","RewriteEquations","HoleContent","WhereClause","ExprWhere","Declaration","TypeSigs","ArgTypeSigs","FunClause","RHS","Data","DataSig","Record","RecordSig","RecordConstructorName","Infix","Fields","Mutual","Abstract","Private","Instance","Macro","Postulate","Primitive","UnquoteDecl","Syntax","PatternSyn","PatternSynArgs","SimpleIds","HoleNames","HoleName","SimpleTopHole","SimpleHole","SimpleId","MaybeOpen","Open","OpenArgs","ModuleApplication","ModuleMacro","Module","Underscore","TopLevel","Pragma","DeclarationPragma","OptionsPragma","BuiltinPragma","RewritePragma","CompiledPragma","CompiledExportPragma","CompiledTypePragma","CompiledDataPragma","CompiledJSPragma","CompiledUHCPragma","CompiledDataUHCPragma","HaskellPragma","ForeignPragma","CompilePragma","StaticPragma","InlinePragma","NoInlinePragma","InjectivePragma","DisplayPragma","EtaPragma","NoTerminationCheckPragma","NonTerminatingPragma","TerminatingPragma","MeasurePragma","CatchallPragma","ImportPragma","ImportUHCPragma","ImpossiblePragma","NoPositivityCheckPragma","PolarityPragma","WarningOnUsagePragma","Polarities","Polarity","TypeSignatures","TypeSignatures1","ArgTypeSignatures","ArgTypeSignatures1","RecordDeclarations","RecordDirectives","RecordDirective","RecordEta","RecordInduction","Declarations","Declarations0","Declarations1","TopDeclarations","'abstract'","'codata'","'coinductive'","'constructor'","'data'","'eta-equality'","'field'","'forall'","'hiding'","'import'","'in'","'inductive'","'infix'","'infixl'","'infixr'","'instance'","'overlap'","'let'","'macro'","'module'","'mutual'","'no-eta-equality'","'open'","'pattern'","'postulate'","'primitive'","'private'","'Prop'","'public'","'quote'","'quoteContext'","'quoteGoal'","'quoteTerm'","'record'","'renaming'","'rewrite'","'Set'","'syntax'","'tactic'","'to'","'unquote'","'unquoteDecl'","'unquoteDef'","'using'","'where'","'do'","'with'","'BUILTIN'","'CATCHALL'","'COMPILED'","'COMPILED_DATA'","'COMPILED_DATA_UHC'","'COMPILED_EXPORT'","'COMPILED_JS'","'COMPILED_TYPE'","'COMPILED_UHC'","'DISPLAY'","'ETA'","'HASKELL'","'IMPORT'","'IMPORT_UHC'","'FOREIGN'","'COMPILE'","'IMPOSSIBLE'","'INJECTIVE'","'INLINE'","'NOINLINE'","'MEASURE'","'NO_TERMINATION_CHECK'","'NO_POSITIVITY_CHECK'","'NON_TERMINATING'","'OPTIONS'","'POLARITY'","'WARNING_ON_USAGE'","'REWRITE'","'STATIC'","'TERMINATING'","setN","tex","comment","'...'","'..'","'.'","';'","':'","'='","'_'","'?'","'->'","'\\\\'","'@'","'|'","'('","')'","'(|'","'|)'","'{{'","'}}'","'{'","'}'","vopen","vclose","vsemi","'{-#'","'#-}'","id","q_id","string","literal","%eof"]
        bit_start = st * 292
        bit_end = (st + 1) * 292
        read_bit = readArrayBit happyExpList
        bits = map read_bit [bit_start..bit_end - 1]
        bits_indexed = zip bits [0..291]
        token_strs_expected = concatMap f bits_indexed
        f (False, _) = []
        f (True, nr) = [token_strs !! nr]

happyActOffsets :: HappyAddr
happyActOffsets = HappyA# "\x00\x00\x8f\x0a\x8f\x0a\xb4\xff\x62\x02\xfd\x0d\xe8\x07\x00\x00\x2e\x05\xed\xff\x00\x00\x00\x00\xfe\xff\x00\x00\x00\x00\x00\x00\x00\x00\xf5\xff\x00\x00\x00\x00\x3b\x08\x8f\x0a\x20\x00\x00\x00\xca\x02\x00\x00\x48\x00\xd1\x03\x82\x00\x00\x00\x00\x00\x00\x00\xca\x00\x00\x00\x18\x0e\xfd\x0d\x00\x00\x68\x0e\x00\x00\xee\x00\x00\x00\x00\x00\x95\x01\x83\x0e\x00\x00\x00\x00\xa7\x01\x06\x07\x8f\x0a\x59\x07\x59\x08\x00\x00\x00\x00\x00\x00\x41\x01\x12\x01\xde\x01\x15\x01\xd3\x0e\xac\x08\x59\x07\xca\x08\x00\x00\x00\x00\x15\x01\x15\x01\xc0\x04\x16\x00\x15\x01\x15\x01\x15\x01\x00\x00\x6f\x00\x60\x01\x77\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x01\x00\x00\x00\x00\x00\x00\x7a\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\x01\x99\x01\x99\x01\xa1\x01\x9f\x01\x9f\x01\x9f\x01\xaa\x01\xaa\x01\x7b\x00\xaa\x01\x02\x00\xae\x01\xd2\x01\x0d\x02\x15\x02\xee\x0e\x13\x02\x01\x00\x13\x02\x6c\x15\x1d\x02\x00\x00\x00\x00\x46\x00\x00\x00\x24\x02\x30\x02\x00\x00\x00\x00\x16\x00\x8f\x0a\x8f\x0a\xfd\x0d\x68\x02\x5d\x02\x00\x00\x23\x02\x61\x02\x46\x00\x69\x02\x9e\x02\xb6\xff\x63\x02\x9b\x02\x9a\x02\xbb\x02\x00\x00\x00\x00\x7e\x03\x8f\x0a\x00\x00\xa8\x02\x00\x00\x3f\x04\xaf\x04\xa2\x02\xa8\x01\x59\x03\x00\x00\x24\x09\x3f\x09\x92\x09\xb0\x09\x59\x07\x03\x0a\xfd\x0d\xfd\x0d\xfd\x0d\x8f\x0a\xb7\x02\x3e\x0f\x00\x00\xb3\x02\xbb\x02\x1d\x03\x28\x03\xe2\x06\x80\x05\x8f\x0a\xd5\x02\x80\x05\x00\x00\xe9\x0a\xfd\x0d\xfd\x0d\x00\x00\x21\x02\xfd\x0d\xfd\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x07\x0b\x07\x0b\x3e\x0f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfd\x0d\xfd\x0d\xfd\x0d\xfd\x0d\xd9\x02\x9e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x07\x0b\x07\x0b\xe9\x02\x3e\x0f\xe3\x02\x00\x00\xee\x02\x00\x00\x00\x00\xea\x02\xfd\x0d\x2d\x03\x08\x00\xfd\x00\x2a\x03\x46\x00\x33\x03\x43\x03\x46\x00\x55\x03\x88\x00\x60\x03\x5a\x0b\x00\x00\x09\x01\x13\x01\xfd\x0d\x68\x03\x93\x03\x73\x03\x76\x03\x00\x00\xfd\x0d\xfd\x0d\x00\x00\xfd\x0d\xfd\x0d\x75\x0b\x58\x06\x79\x03\x58\x06\x1e\x0a\x71\x0a\xc8\x0b\x00\x00\x00\x00\x84\x03\x59\x0f\x1a\x00\x00\x00\x00\x00\xe6\x0b\x00\x00\x00\x00\x00\x00\xe6\x0b\x00\x00\xe6\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc5\xff\x6d\x03\x6e\x03\x6e\x03\x6e\x03\x6e\x03\x6e\x03\x6e\x03\x6e\x03\x74\x03\x78\x03\xa1\x00\x7f\x03\x82\x03\x8a\x03\x8f\x03\xa4\x03\x9d\x03\x9d\x03\x9d\x03\xa5\x03\xab\x03\xae\x03\xb2\x03\xb6\x03\xbf\x03\xc1\x03\xc9\x03\xcb\x03\xe8\x03\xe4\x03\x03\x04\x06\x04\xe6\x0b\x94\x02\x6d\x06\x00\x00\x00\x00\x53\x04\x00\x00\xfa\x03\x00\x00\xa4\x08\xfa\x03\x00\x00\x1c\x09\x1c\x09\x00\x00\x00\x00\x00\x00\x0c\x01\x00\x00\x0c\x01\x0c\x01\x00\x00\x92\x01\x1c\x09\x1c\x09\x00\x00\x00\x00\x00\x00\xbb\x02\xe2\x06\x00\x00\x75\x06\x00\x00\x3c\x04\x4a\x04\x16\x04\x16\x04\x00\x00\xa9\x0f\x1c\x09\xe4\xff\x1c\x09\xe5\xff\x00\x00\x43\x02\x34\x04\x00\x00\x74\x00\x27\x04\x43\x02\xa0\x00\x23\x03\x72\x00\x72\x00\x0c\x01\x00\x00\x00\x00\x00\x00\x63\x04\xdd\xff\x1c\x09\x00\x00\x45\x04\x40\x04\x00\x00\x74\x00\x00\x00\x00\x00\x00\x00\xe6\xff\xfd\x0d\x05\x01\x00\x00\x00\x00\x00\x00\x49\x04\x7e\x00\x7e\x00\x00\x00\x00\x00\xe6\x0b\xe6\x0b\x00\x00\x00\x00\x36\x04\x00\x00\x00\x00\x43\x04\x39\x04\x44\x04\x00\x00\x00\x00\x4c\x04\x47\x04\x00\x00\x00\x00\x00\x00\x51\x04\x5b\x04\x5d\x04\x68\x04\x00\x00\x50\x04\xa1\x00\x6d\x04\x7f\x04\x83\x04\xa1\x00\xa1\x00\x92\x04\x60\x04\x60\x04\x60\x04\x60\x04\x9b\x04\xa3\x04\xaa\x04\xb4\x04\x00\x00\xb6\x04\xb6\x04\x00\x00\x00\x00\x00\x00\x00\x00\xa9\x0f\xaa\x00\x77\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x00\xdd\x00\x9e\x00\x09\x02\x9e\x00\x00\x00\xc5\x04\x39\x0c\x00\x00\x00\x00\x39\x0c\x00\x00\x57\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x57\x0c\xaa\x0c\x00\x00\x00\x00\xc2\x04\x00\x00\xd3\x04\xc8\x04\x00\x00\x50\x05\xbb\x02\x00\x00\xaa\x00\xc8\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xaa\x00\x00\x00\x00\x00\x00\x00\x49\x05\x00\x00\x4f\x05\x66\x05\x00\x00\x72\x05\x00\x00\x1b\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x39\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x0d\x46\x00\x00\x00\x00\x00\x7b\x05\x7f\x05\x82\x05\x81\x05\x81\x05\x8e\x05\x00\x00\x90\x05\x92\x05\x94\x05\x96\x05\x00\x00\x00\x00\x99\x05\x00\x00\x00\x00\x00\x00\x9e\x05\x98\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\xaa\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb5\x05\xcf\x05\x91\x01\xce\x05\xe1\x05\x9d\x01\x00\x00\xd0\x05\x16\x01\xe4\x05\xaa\x0d\x00\x00\xe7\x05\xaa\x0d\xaa\x0d\xf8\x05\xf0\x05\xbb\x02\xf0\x05\x00\x00\x72\x00\xfd\x05\xfe\x05\xfe\x05\x46\x00\x00\x00\xfe\x05\xfe\x05\x00\x00\xfe\x05\xfe\x05\x05\x06\x00\x00\x00\x00\x92\x01\xaa\x0d\x00\x00\x01\x06\xaa\x0d\x00\x00\x01\x06\xaa\x0d\x00\x00\xaa\x00\x00\x00\x00\x00\x00\x00\x3d\x06\x00\x00\x42\x06\x00\x00\x00\x00\x00\x00\xaa\x0d\x0d\x06\x46\x00\x10\x06\x46\x00\x43\x02\x43\x02\x00\x00\x00\x00\xc4\x0f\xaa\x00\x00\x00\xbb\x02\x00\x00\x00\x00\x00\x00\x4c\x06\x00\x00\x9b\x05\x11\x06\x00\x00\x25\x06\x28\x06\x7e\x00\x00\x00\x2d\x06\x32\x06\x7e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x06\x00\x00\xa1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x06\x3e\x06\x00\x00\x00\x00\x00\x00\xaa\x00\x00\x00\x00\x00\x74\x00\x00\x00\xef\xff\xf2\xff\xef\xff\x00\x00\x00\x00\x54\x06\x48\x06\x00\x00\x43\x06\x43\x06\x4e\x06\x5a\x06\x8b\x06\x00\x00\x00\x00\x59\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x56\x06\x00\x00\x53\x06\x53\x06\x5c\x06\x5b\x06\x5b\x06\x00\x00\x00\x00\x74\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x5d\x06\x00\x00\x00\x00\x51\x06\x00\x00\x64\x06\xaa\x00\x00\x00\x00\x00\xca\x07\x00\x00\x00\x00\x43\x02\x43\x02\x43\x02\x43\x02\x00\x00\x6c\x06\x6c\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\xe5\x03\x00\x00\x00\x00\x00\x00\x08\x06\x63\x06\x77\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x69\x06\x69\x06\xa4\x06\x00\x00\x00\x00\x00\x00\x00\x00\xef\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x72\x06\x00\x00\x7b\x06\x00\x00\x00\x00\x00\x00"#

happyGotoOffsets :: HappyAddr
happyGotoOffsets = HappyA# "\x5d\x03\x3e\x12\x67\x04\xe3\x06\xed\x02\x6c\x02\x15\x10\xe4\x06\xe6\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x15\x5a\x12\x00\x00\x00\x00\x2f\x03\x00\x00\x00\x00\x8b\x03\x4a\x06\x00\x00\x00\x00\x00\x00\xef\x06\x00\x00\x31\x01\x2c\x06\x00\x00\x9c\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6f\x01\x00\x00\x00\x00\xf9\x02\x7a\x03\x76\x12\x88\x10\xda\x10\x00\x00\x00\x00\x00\x00\x96\x06\x00\x00\xa2\x06\x00\x00\x6f\x01\x92\x12\x22\x12\xae\x12\x00\x00\x00\x00\x00\x00\x00\x00\x91\x00\xae\x06\x00\x00\x00\x00\x00\x00\x00\x00\xf9\xff\xde\x02\x00\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0b\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xec\x02\x01\x07\x0e\x07\x78\x06\x11\x07\x13\x07\x14\x07\xfa\x02\x1f\x03\x2f\x00\x7d\x03\x7c\x03\x15\x07\x90\x03\x7f\x06\xb5\x03\xee\x01\x17\x07\x76\x04\x79\x04\x00\x00\x00\x00\x00\x00\x00\x00\x16\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcc\x06\xca\x12\xe6\x12\x1c\x11\xd5\x06\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x83\x06\x7c\x03\x00\x00\x00\x00\x3a\x01\x02\x13\x00\x00\x00\x00\x00\x00\xa0\x03\x00\x00\x00\x00\x9b\x00\x2e\x01\x00\x00\x9f\x03\x1f\x0e\x9a\x00\x5d\x10\xb4\x10\x00\x11\x09\x04\xf5\x0e\x60\x0f\xf1\x02\x00\x00\x31\x03\x00\x00\x00\x00\xaf\x05\x00\x00\x0c\x07\x50\x02\x27\x02\x1e\x13\x00\x00\xba\x04\x00\x00\x9f\x03\xcb\x0f\x3c\x11\x00\x00\x00\x00\x52\x11\x68\x11\x00\x00\x00\x00\x00\x00\x00\x00\x3a\x13\x56\x13\xc9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf9\x03\xbf\x05\x7e\x11\x94\x11\x00\x00\x26\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2d\x07\x00\x00\x72\x13\x8e\x13\x00\x00\x72\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x6a\x15\xf0\x06\x32\x07\x35\x07\x00\x00\x33\x07\x00\x00\x00\x00\x37\x07\x00\x00\x00\x00\x00\x00\x47\x08\x00\x00\x3a\x07\x3e\x07\xb8\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xaa\x11\xc0\x11\x00\x00\xd6\x11\xec\x11\x06\x00\x14\x04\x00\x00\xbe\x05\x9f\x03\x8a\x0e\x02\x12\x00\x00\x00\x00\x00\x00\x04\x02\x1b\x07\x00\x00\x00\x00\xaa\x13\x00\x00\x00\x00\x00\x00\xc6\x13\x00\x00\xe2\x13\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1d\x07\x2b\x07\x2c\x07\x2e\x07\x30\x07\x36\x07\x38\x07\x00\x00\x3b\x07\x2f\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x07\x41\x07\x44\x07\x34\x07\x00\x00\x00\x00\x00\x00\x3f\x07\x48\x07\x4b\x07\x83\x01\x4d\x07\x00\x00\x8a\x04\x00\x00\x00\x00\xfe\x13\x98\x04\x2b\x06\x00\x00\x00\x00\xfc\xff\x00\x00\x04\x00\x00\x00\xe7\x02\x47\x07\x00\x00\x6f\x06\x98\x06\x00\x00\x00\x00\x00\x00\x53\x02\x00\x00\x88\x02\x81\x03\x00\x00\xfb\xff\xab\x06\x49\x07\x00\x00\x00\x00\x00\x00\x96\x03\xe5\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf4\x03\xfe\x03\x00\x00\x07\x02\x61\x07\x00\x00\x7f\x07\x00\x00\x00\x00\xc3\x00\x00\x00\x00\x00\xa9\x04\xcb\x06\x2d\x01\x63\x07\x65\x07\xca\x01\x5f\x02\x38\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9d\x07\x00\x00\x00\x00\x00\x00\x00\x00\xb2\x04\x00\x00\x00\x00\x00\x00\x00\x00\x26\x11\x35\x02\x00\x00\x00\x00\x00\x00\x00\x00\x55\x04\x90\x04\x00\x00\x00\x00\x1a\x14\x36\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x57\x07\x00\x00\xd6\x06\x00\x00\x00\x00\x60\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x62\x07\x68\x07\x00\x00\x00\x00\x00\x00\x6a\x07\x6b\x07\x00\x00\x6f\x07\x70\x07\x78\x07\x79\x07\x76\x07\x00\x00\x00\x00\x7b\x07\x00\x00\x80\x07\x82\x07\x00\x00\x00\x00\x00\x00\x00\x00\x77\x02\xa8\x04\x22\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x05\x00\x00\x87\x07\x00\x00\x8f\x07\x00\x00\x00\x00\x2f\x01\x00\x00\x00\x00\x39\x01\x00\x00\x52\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd4\x04\x00\x00\xf6\x05\x6e\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xad\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x00\x00\x00\x0f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8a\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc6\x01\x94\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x07\x92\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\x07\x00\x00\x00\x00\x4a\x07\x00\x00\xeb\x01\x00\x00\x09\x07\xa6\x14\x00\x00\xd6\x00\xc2\x14\xde\x14\x00\x00\x72\x04\x43\x00\x7b\x04\x00\x00\x8f\x02\x00\x00\xab\x07\xac\x07\xae\x07\x00\x00\xc1\x05\xc3\x05\x00\x00\xc7\x05\xcc\x05\x00\x00\x00\x00\x00\x00\x93\x00\xfa\x14\x00\x00\x46\x05\x16\x15\x00\x00\x68\x05\x32\x15\x00\x00\xfc\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x15\x00\x00\xb3\x07\x00\x00\xbc\x07\x12\x03\x2b\x03\x00\x00\x00\x00\x7a\x02\xca\x06\x00\x00\xba\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x01\x56\x07\x00\x00\x00\x00\x00\x00\xb7\x05\x00\x00\x00\x00\x00\x00\xc4\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xba\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb4\x07\x00\x00\x00\x00\x52\x06\x00\x00\x1f\x00\x94\x00\x77\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc3\x07\xc4\x07\x00\x00\x00\x00\x00\x00\xce\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6e\x07\x72\x07\x00\x00\x7d\x07\x81\x07\x00\x00\x00\x00\x57\x06\x00\x00\x00\x00\x00\x00\xd2\x07\x00\x00\xd4\x07\x00\x00\x00\x00\xba\x05\x00\x00\x50\x07\x58\x08\x00\x00\x00\x00\x22\x12\x00\x00\x00\x00\xa9\x03\xaf\x03\xd0\x03\x37\x04\x00\x00\xef\x05\xfb\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xda\x07\x00\x00\x00\x00\xfc\xff\x00\x00\x00\x00\x00\x00\xbb\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe4\x07\xe5\x07\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x07\xee\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyAdjustOffset :: Happy_GHC_Exts.Int# -> Happy_GHC_Exts.Int#
happyAdjustOffset off = off

happyDefActions :: HappyAddr
happyDefActions = HappyA# "\xf6\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb5\xfe\x00\x00\xf8\xff\x66\xff\x35\xff\xb3\xfe\x4f\xff\x4e\xff\x4c\xff\x4b\xff\x48\xff\x00\x00\x20\xff\x1f\xff\x44\xff\x00\x00\x00\x00\x11\xff\x0f\xff\xb2\xfe\x00\x00\x00\x00\x00\x00\x31\xff\x2f\xff\x2d\xff\x00\x00\x2e\xff\x00\x00\x00\x00\x30\xff\x00\x00\x2c\xff\x00\x00\x2b\xff\x21\xff\x00\x00\x00\x00\x32\xff\x33\xff\x00\x00\x62\xfe\x00\x00\x00\x00\x00\x00\x7f\xff\x67\xff\x34\xff\xb5\xfe\x00\x00\x90\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x66\xff\x65\xff\x00\x00\x00\x00\x62\xfe\xb1\xfe\x00\x00\x00\x00\x00\x00\xad\xfe\x00\x00\x00\x00\xfb\xfd\xab\xfe\xaa\xfe\xa9\xfe\xa8\xfe\xa7\xfe\xa6\xfe\xac\xfe\xa5\xfe\xa4\xfe\xa3\xfe\xa2\xfe\xa1\xfe\xa0\xfe\x9f\xfe\x98\xfe\x9a\xfe\x99\xfe\x00\x00\x9e\xfe\x9d\xfe\x9c\xfe\x87\xff\x9b\xfe\x54\xfe\x36\xfe\x53\xfe\x52\xfe\x51\xfe\x50\xfe\x4e\xfe\x4f\xfe\x4d\xfe\x4c\xfe\x4b\xfe\x4a\xfe\x48\xfe\x49\xfe\x47\xfe\x45\xfe\x44\xfe\x46\xfe\x3a\xfe\x39\xfe\x3e\xfe\x3f\xfe\x40\xfe\x3c\xfe\x3b\xfe\x43\xfe\x42\xfe\x41\xfe\x38\xfe\x37\xfe\x3d\xfe\xf9\xfd\x55\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x63\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x36\xff\x26\xff\x00\x00\x7c\xff\x00\x00\x00\x00\x27\xff\x24\xff\xb1\xfe\x00\x00\x00\x00\x00\x00\xb7\xfe\x00\x00\x60\xff\x5f\xff\x00\x00\x00\x00\x00\x00\x00\x00\x5e\xff\x00\x00\x00\x00\x00\x00\x63\xfe\x64\xff\xdd\xfe\xf5\xfe\x00\x00\x3c\xff\x00\x00\x00\xff\xfd\xfe\xf6\xfe\x00\x00\x00\x00\x00\x00\x63\xff\x62\xfe\x00\x00\x39\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x42\xff\x3b\xff\xb4\xfe\x00\x00\x1e\xff\x00\x00\x3f\xff\x62\xfe\xe2\xfe\x00\x00\x00\x00\xe3\xfe\xde\xfe\x62\xfe\x00\x00\x00\x00\x10\xff\x00\x00\x00\x00\x00\x00\x12\xff\x52\xff\x4a\xff\x3a\xff\x00\x00\x00\x00\x00\x00\xf7\xff\xf5\xff\xf4\xff\xf3\xff\xf2\xff\xf1\xff\xf0\xff\xef\xff\xee\xff\xed\xff\xec\xff\xeb\xff\xea\xff\xe9\xff\xe8\xff\xe7\xff\xe6\xff\xe5\xff\xe4\xff\xe3\xff\xe2\xff\xe1\xff\xe0\xff\xdf\xff\xde\xff\xdd\xff\xdc\xff\xdb\xff\xda\xff\xd9\xff\xd8\xff\xd7\xff\xd6\xff\xd5\xff\xd4\xff\xd3\xff\xd2\xff\xd1\xff\xd0\xff\xcf\xff\xce\xff\xcd\xff\xcc\xff\xcb\xff\xca\xff\xc9\xff\xc8\xff\xc7\xff\xc6\xff\xc5\xff\xc4\xff\xc3\xff\xc2\xff\xc1\xff\xc0\xff\xbf\xff\xbe\xff\xbd\xff\xbc\xff\xbb\xff\xba\xff\xb9\xff\xb8\xff\xb7\xff\xb6\xff\xb5\xff\xb4\xff\xb3\xff\xb2\xff\xb1\xff\xb0\xff\xaf\xff\xae\xff\xad\xff\xa9\xff\xac\xff\xab\xff\xaa\xff\xa8\xff\xa7\xff\xa6\xff\xa5\xff\xa4\xff\xa3\xff\xa2\xff\xa1\xff\xa0\xff\x9f\xff\x9e\xff\x9d\xff\x9c\xff\x9b\xff\x9a\xff\x99\xff\x98\xff\x97\xff\x96\xff\x95\xff\x94\xff\x93\xff\x92\xff\x91\xff\x90\xff\x8f\xff\x8e\xff\x8d\xff\x8c\xff\x8b\xff\x8a\xff\x89\xff\x25\xff\x50\xff\x51\xff\x5f\xff\x44\xff\x00\x00\x00\x00\x00\x00\x60\xff\x00\x00\x5e\xff\xe5\xfe\xe6\xfe\x47\xff\xe4\xfe\x00\x00\x46\xff\x00\x00\x00\x00\x66\xff\x5e\xfe\x00\x00\x1d\xff\x1c\xff\x19\xff\x1a\xff\x17\xff\x00\x00\xd0\xfe\x00\x00\xd4\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xef\xfe\x00\x00\x44\xff\xe9\xfe\x00\x00\x00\x00\x39\xff\xf3\xfe\x00\x00\xf2\xfe\xf4\xfe\xdc\xfe\x00\x00\x00\x00\xdb\xfe\x00\x00\x00\x00\x39\xff\xfc\xfe\xf8\xfe\xfd\xfe\x62\xfe\x00\x00\x00\x00\x01\xff\x49\xff\xf7\xfe\x5e\xfe\x3f\xff\x05\xff\x08\xff\x00\x00\x28\xff\x07\xff\x06\xff\x00\x00\xb8\xfe\x00\x00\x4d\xff\x92\xfe\x91\xfe\x93\xfe\x29\xff\x7b\xff\x2a\xff\x37\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5d\xff\x00\x00\x00\x00\x5a\xff\x00\x00\x00\x00\x7d\xff\x00\x00\x00\x00\x00\x00\x00\x00\xdf\xfe\xfe\xfd\x7f\xfe\x00\x00\x7b\xfe\x00\x00\x7c\xfe\x75\xfe\x00\x00\x81\xfe\xdf\xfe\xdf\xfe\x56\xfe\x7d\xfe\x7e\xfe\x00\x00\x80\xff\x00\x00\x00\x00\x82\xfe\x00\x00\xdf\xfe\xdf\xfe\x80\xfe\x88\xff\x86\xff\x00\x00\x62\xfe\x83\xff\xfc\xfd\xb0\xfe\x00\x00\x00\x00\x00\x00\x00\x00\xfd\xfd\x5e\xfe\xdf\xfe\x00\x00\xdf\xfe\x00\x00\x78\xff\x74\xff\x00\x00\x0e\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\xff\x85\xfe\x84\xfe\x83\xfe\x00\x00\x00\x00\xdf\xfe\x74\xfe\x00\x00\x00\x00\x11\xfe\x00\x00\xff\xfd\x84\xff\x85\xff\x00\x00\x17\xff\x00\x00\x71\xfe\x6f\xfe\x6a\xfe\x00\x00\x00\x00\x00\x00\x64\xfe\x7a\xfe\x00\x00\x00\x00\x7e\xff\x1f\xfe\x00\x00\x54\xff\x53\xff\x00\x00\x5a\xff\x00\x00\x16\xfe\x55\xff\x00\x00\x5d\xff\x20\xfe\x19\xfe\x21\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x1a\xfe\x00\x00\x58\xff\x00\x00\x00\x00\x00\x00\x58\xff\x58\xff\x00\x00\x5d\xff\x5d\xff\x5d\xff\x5d\xff\x00\x00\x00\x00\x00\x00\x5d\xff\x1d\xfe\x00\x00\x00\x00\xb6\xfe\x03\xff\x02\xff\x04\xff\x5e\xfe\xcc\xfe\x00\x00\xfa\xfe\xf9\xfe\xfb\xfe\xff\xfe\xfe\xfe\xef\xfe\xed\xfe\xec\xfe\xe7\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xee\xfe\x00\x00\x39\xff\x3e\xff\x82\xff\x39\xff\x38\xff\x00\x00\x0e\xff\x0c\xff\x0d\xff\x0b\xff\x09\xff\x0a\xff\x00\x00\xd3\xfe\x45\xff\xd1\xfe\x00\x00\x41\xff\x00\x00\x00\x00\x16\xff\x15\xff\x00\x00\x23\xff\xcc\xfe\x00\x00\x43\xff\x40\xff\x00\xfe\xd9\xfe\xda\xfe\x13\xff\x18\xff\xce\xfe\xcc\xfe\xca\xfe\xc9\xfe\xc8\xfe\x00\x00\xcb\xfe\x00\x00\x00\x00\x1b\xff\x00\x00\x22\xff\x39\xff\xd2\xfe\xf1\xfe\xea\xfe\xeb\xfe\x00\x00\xd7\xfe\xd8\xfe\xd5\xfe\xd6\xfe\x3d\xff\x39\xff\x21\xff\x60\xfe\x5d\xfe\x00\x00\x00\x00\x00\x00\x5d\xff\x5d\xff\x00\x00\x5b\xff\x00\x00\x00\x00\x00\x00\x00\x00\x22\xfe\x57\xff\x00\x00\x2a\xfe\x1c\xfe\x1b\xfe\x00\x00\x5d\xff\x24\xfe\x26\xfe\x25\xfe\x1e\xfe\x5c\xff\x35\xfe\x00\x00\x00\x00\x59\xff\x32\xfe\x27\xfe\x78\xfe\x79\xfe\x00\x00\x67\xfe\x00\x00\x00\x00\x67\xfe\x00\x00\x70\xfe\x00\x00\x66\xff\x00\x00\x00\x00\x13\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x62\xff\x76\xff\x00\x00\x00\x00\x00\x00\x00\x00\x79\xff\x00\x00\x00\x00\x7a\xff\x00\x00\x00\x00\x00\x00\x94\xfe\x10\xfe\x00\x00\x00\x00\x75\xff\x00\x00\x00\x00\xe1\xfe\x00\x00\x00\x00\xe0\xfe\xcc\xfe\xaf\xfe\xae\xfe\x61\xfe\x00\x00\x8c\xfe\x8b\xfe\x8d\xfe\x96\xfe\x0f\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x72\xff\x70\xff\x77\xff\x57\xfe\x5e\xfe\xcc\xfe\x58\xfe\x00\x00\x76\xfe\x97\xfe\x12\xfe\x88\xfe\x89\xfe\x0a\xfe\x77\xfe\x73\xfe\x00\x00\x00\x00\x00\x00\x6d\xfe\x00\x00\x00\x00\x00\x00\x6e\xfe\x17\xfe\x15\xfe\x18\xfe\x14\xfe\x00\x00\x29\xfe\x58\xff\x23\xfe\x2c\xfe\x2f\xfe\x2d\xfe\x30\xfe\x00\x00\x00\x00\x31\xfe\x33\xfe\x34\xfe\xcc\xfe\xe8\xfe\xf0\xfe\x00\x00\x14\xff\xbc\xfe\x81\xff\xbc\xfe\xcd\xfe\xbe\xfe\xba\xfe\x00\x00\xbb\xfe\x00\x00\x00\x00\x00\x00\xc2\xfe\x00\x00\x81\xff\xc4\xfe\x00\x00\xcf\xfe\x5f\xfe\x2e\xfe\x2b\xfe\x56\xff\x28\xfe\x00\x00\x67\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x72\xfe\x07\xfe\x00\x00\x08\xfe\x05\xfe\x06\xfe\x00\x00\x01\xfe\x00\x00\x04\xfe\x02\xfe\x00\x00\x03\xfe\x00\x00\xcc\xfe\x5a\xfe\x5b\xfe\x00\x00\x71\xff\x73\xff\x6c\xff\x6e\xff\x68\xff\x6a\xff\x95\xfe\x00\x00\x00\x00\x8e\xfe\x8f\xfe\x6b\xff\x69\xff\x6f\xff\x6d\xff\x21\xff\x59\xfe\x8a\xfe\x00\x00\x87\xfe\x0b\xfe\x0d\xfe\x62\xfe\x00\x00\x00\x00\x6b\xfe\x66\xfe\x65\xfe\x6c\xfe\xc7\xfe\x00\x00\x00\x00\x81\xff\xc5\xfe\xc0\xfe\xbd\xfe\xc6\xfe\x00\x00\xb9\xfe\xc3\xfe\xc1\xfe\xbf\xfe\x68\xfe\x69\xfe\x09\xfe\x00\x00\x00\x00\x5c\xfe\x00\x00\x0c\xfe\x86\xfe"#

happyCheck :: HappyAddr
happyCheck = HappyA# "\xff\xff\x05\x00\x09\x00\x14\x00\x09\x00\x09\x00\x14\x00\x0c\x00\x00\x00\x0e\x00\x2d\x00\x0f\x00\x56\x00\x09\x00\x0a\x00\x09\x00\x4b\x00\x2d\x00\x2d\x00\x2d\x00\x5e\x00\x0f\x00\x14\x00\x09\x00\x09\x00\x65\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x0f\x00\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\x0b\x00\x20\x00\x21\x00\x09\x00\x23\x00\x14\x00\x25\x00\x26\x00\x27\x00\x28\x00\x20\x00\x21\x00\x6c\x00\x23\x00\x56\x00\x25\x00\x26\x00\x27\x00\x28\x00\x09\x00\x55\x00\x55\x00\x55\x00\x2e\x00\x2f\x00\x0f\x00\x10\x00\x3a\x00\x3b\x00\x3c\x00\x2d\x00\x3e\x00\x2d\x00\x2e\x00\x2f\x00\x5b\x00\x3a\x00\x3b\x00\x3c\x00\x09\x00\x3e\x00\x59\x00\x53\x00\x5e\x00\x5c\x00\x0f\x00\x10\x00\x56\x00\x59\x00\x5b\x00\x56\x00\x5c\x00\x6a\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x5a\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6a\x00\x6a\x00\x6b\x00\x66\x00\x50\x00\x51\x00\x52\x00\x76\x00\x77\x00\x00\x00\x7c\x00\x7a\x00\x7b\x00\x5e\x00\x59\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x09\x00\x07\x00\x09\x00\x97\x00\xa3\x00\x0c\x00\x0f\x00\x0e\x00\x09\x00\x09\x00\x09\x00\xa1\x00\x97\x00\xab\x00\x62\x00\x0f\x00\x64\x00\x7c\x00\x11\x00\x13\x00\x14\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x09\x00\x23\x00\x24\x00\x6e\x00\x26\x00\x27\x00\x28\x00\x20\x00\x21\x00\x79\x00\x23\x00\x07\x00\x25\x00\x26\x00\x27\x00\x28\x00\x09\x00\x52\x00\x53\x00\x57\x00\x1d\x00\x54\x00\x0f\x00\x10\x00\x54\x00\x09\x00\x23\x00\x34\x00\x0c\x00\x69\x00\x0e\x00\x57\x00\x6c\x00\x3a\x00\x3b\x00\x2c\x00\x3d\x00\x5a\x00\x6a\x00\x66\x00\x67\x00\x6a\x00\x55\x00\x67\x00\x09\x00\x0a\x00\x4d\x00\x4e\x00\x4f\x00\x53\x00\x6a\x00\x6b\x00\x65\x00\x6a\x00\x50\x00\x59\x00\x52\x00\x64\x00\x5c\x00\x5b\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x55\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x62\x00\x61\x00\x64\x00\x63\x00\x4d\x00\x4e\x00\x4f\x00\x76\x00\x77\x00\x68\x00\x6a\x00\x7a\x00\x7b\x00\x6c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x09\x00\x5a\x00\x97\x00\x55\x00\x79\x00\x6a\x00\x0f\x00\x09\x00\x09\x00\x09\x00\x0c\x00\x09\x00\x0e\x00\xab\x00\xac\x00\x0f\x00\x11\x00\x0f\x00\x64\x00\x09\x00\x09\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x0f\x00\x23\x00\x24\x00\x11\x00\x26\x00\x27\x00\x28\x00\x20\x00\x21\x00\x54\x00\x23\x00\x65\x00\x25\x00\x26\x00\x27\x00\x28\x00\x27\x00\x20\x00\x21\x00\x56\x00\x23\x00\x54\x00\x25\x00\x26\x00\x27\x00\x28\x00\x5d\x00\x57\x00\x67\x00\x24\x00\x61\x00\x54\x00\x63\x00\x3a\x00\x3b\x00\x3c\x00\x56\x00\x33\x00\x5c\x00\x6a\x00\x67\x00\x5b\x00\x38\x00\x3a\x00\x3b\x00\x3c\x00\x6a\x00\x64\x00\x09\x00\x53\x00\x67\x00\x09\x00\x42\x00\x43\x00\x0f\x00\x59\x00\x09\x00\x0f\x00\x5c\x00\x6e\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x26\x00\x27\x00\x28\x00\x26\x00\x27\x00\x28\x00\x18\x00\x76\x00\x77\x00\x0a\x00\x1c\x00\x7a\x00\x7b\x00\x10\x00\x11\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x09\x00\x65\x00\x97\x00\x50\x00\x51\x00\x52\x00\x0f\x00\xa5\x00\xa6\x00\xa7\x00\xa8\x00\x09\x00\x97\x00\xab\x00\x09\x00\x09\x00\x2d\x00\x0f\x00\x0c\x00\x0d\x00\x0f\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x65\x00\x23\x00\x24\x00\x66\x00\x26\x00\x27\x00\x28\x00\x52\x00\x53\x00\x20\x00\x21\x00\x57\x00\x23\x00\x78\x00\x25\x00\x26\x00\x27\x00\x28\x00\x26\x00\x27\x00\x28\x00\x5d\x00\x61\x00\x57\x00\x63\x00\x61\x00\x09\x00\x63\x00\x52\x00\x53\x00\x6a\x00\x6a\x00\x0f\x00\x57\x00\x57\x00\x3a\x00\x3b\x00\x3c\x00\x6a\x00\x5d\x00\x5d\x00\x65\x00\x6a\x00\x61\x00\x61\x00\x63\x00\x63\x00\x6d\x00\x09\x00\x53\x00\x65\x00\x09\x00\x6a\x00\x6a\x00\x0f\x00\x59\x00\x27\x00\x0f\x00\x5c\x00\x6a\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x26\x00\x27\x00\x28\x00\x26\x00\x27\x00\x28\x00\x09\x00\x76\x00\x77\x00\x55\x00\x56\x00\x7a\x00\x7b\x00\x65\x00\x11\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x09\x00\x33\x00\x70\x00\x09\x00\x97\x00\x55\x00\x0f\x00\x75\x00\xa6\x00\xa7\x00\xa8\x00\x11\x00\x12\x00\xab\x00\x40\x00\x09\x00\x42\x00\x43\x00\x0c\x00\x0d\x00\x64\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x65\x00\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\x56\x00\x65\x00\x0f\x00\x78\x00\x6a\x00\x5d\x00\x78\x00\x09\x00\x64\x00\x61\x00\x09\x00\x63\x00\x62\x00\x0f\x00\x64\x00\x64\x00\x0f\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x5e\x00\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\x52\x00\x53\x00\x2f\x00\x09\x00\x11\x00\x12\x00\x0c\x00\x0d\x00\x26\x00\x27\x00\x28\x00\x26\x00\x27\x00\x28\x00\x53\x00\x61\x00\x09\x00\x63\x00\x72\x00\x73\x00\x59\x00\x75\x00\x0f\x00\x5c\x00\x6a\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x55\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x53\x00\x24\x00\x5e\x00\x26\x00\x27\x00\x28\x00\x64\x00\x76\x00\x77\x00\x5c\x00\x60\x00\x7a\x00\x7b\x00\x6a\x00\x6b\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x09\x00\x78\x00\x09\x00\x5d\x00\x78\x00\x55\x00\x0f\x00\x61\x00\x09\x00\x63\x00\x11\x00\x5e\x00\x09\x00\xab\x00\x0f\x00\x10\x00\x6a\x00\x65\x00\x0f\x00\x59\x00\x09\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x65\x00\x23\x00\x24\x00\x11\x00\x26\x00\x27\x00\x28\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x5c\x00\x23\x00\x24\x00\x63\x00\x26\x00\x27\x00\x28\x00\x33\x00\x09\x00\x52\x00\x53\x00\x0c\x00\x38\x00\x0e\x00\x30\x00\x31\x00\x32\x00\x33\x00\x6a\x00\x6b\x00\x5d\x00\x0b\x00\x42\x00\x43\x00\x61\x00\x33\x00\x63\x00\x59\x00\x36\x00\x37\x00\x38\x00\x39\x00\x0b\x00\x09\x00\x44\x00\x45\x00\x0c\x00\x53\x00\x0e\x00\x09\x00\x42\x00\x43\x00\x64\x00\x59\x00\x56\x00\x0f\x00\x5c\x00\x54\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x64\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6a\x00\x24\x00\x6f\x00\x26\x00\x27\x00\x28\x00\x2d\x00\x76\x00\x77\x00\x00\x00\x01\x00\x7a\x00\x7b\x00\x32\x00\x33\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x09\x00\x61\x00\x09\x00\x63\x00\xa9\x00\xaa\x00\x0f\x00\x09\x00\x0f\x00\x10\x00\x6a\x00\x64\x00\x15\x00\xab\x00\x5e\x00\x11\x00\x12\x00\x09\x00\xa9\x00\xaa\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x11\x00\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xa9\x00\xaa\x00\x0f\x00\x10\x00\x64\x00\x09\x00\x09\x00\x30\x00\x31\x00\x32\x00\x33\x00\x0f\x00\x35\x00\x57\x00\x11\x00\x09\x00\x5e\x00\x15\x00\x0c\x00\x5d\x00\x0e\x00\x09\x00\x59\x00\x61\x00\x0c\x00\x63\x00\x0e\x00\x33\x00\x20\x00\x21\x00\x59\x00\x23\x00\x6a\x00\x31\x00\x26\x00\x27\x00\x28\x00\xa9\x00\xaa\x00\x3f\x00\x40\x00\x59\x00\x42\x00\x43\x00\x59\x00\x52\x00\x53\x00\x59\x00\x33\x00\x35\x00\x57\x00\x69\x00\x59\x00\x38\x00\x09\x00\x6c\x00\x5d\x00\x0c\x00\x59\x00\x0e\x00\x61\x00\x6c\x00\x63\x00\x42\x00\x43\x00\x6c\x00\x00\x00\x01\x00\x02\x00\x6a\x00\x04\x00\x05\x00\x6c\x00\x07\x00\x08\x00\x6c\x00\x0a\x00\x76\x00\x77\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x6c\x00\x12\x00\x13\x00\x14\x00\x15\x00\x6c\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x09\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x0f\x00\x6c\x00\x25\x00\x26\x00\x27\x00\x69\x00\x29\x00\x2a\x00\x2b\x00\x6c\x00\x09\x00\x2e\x00\x69\x00\x76\x00\x77\x00\x69\x00\x0f\x00\x20\x00\x21\x00\x69\x00\x23\x00\x09\x00\x15\x00\x26\x00\x27\x00\x28\x00\x6c\x00\x52\x00\x53\x00\x11\x00\xa9\x00\xaa\x00\x57\x00\x20\x00\x21\x00\x6c\x00\x23\x00\x6c\x00\x5d\x00\x26\x00\x27\x00\x28\x00\x61\x00\x4e\x00\x63\x00\x6c\x00\x51\x00\x6c\x00\x53\x00\xa9\x00\xaa\x00\x6a\x00\x57\x00\x58\x00\x35\x00\x5a\x00\x09\x00\x09\x00\x5d\x00\x0c\x00\x5f\x00\x0e\x00\x61\x00\x33\x00\x63\x00\x11\x00\x12\x00\x66\x00\x38\x00\x68\x00\x6a\x00\x6a\x00\x6b\x00\x69\x00\x6d\x00\x00\x00\x01\x00\x02\x00\x42\x00\x43\x00\x05\x00\x56\x00\x07\x00\x08\x00\x56\x00\x0a\x00\xa9\x00\xaa\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x6a\x00\x12\x00\x13\x00\x14\x00\x15\x00\x2d\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x09\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x0f\x00\x2d\x00\x25\x00\x26\x00\x27\x00\x65\x00\x29\x00\x2a\x00\x2b\x00\x09\x00\x0a\x00\x2e\x00\x09\x00\x0a\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x55\x00\x23\x00\x24\x00\x65\x00\x26\x00\x27\x00\x28\x00\x2d\x00\x52\x00\x53\x00\x09\x00\x0a\x00\x55\x00\x57\x00\x30\x00\x31\x00\x32\x00\x33\x00\x56\x00\x5d\x00\xa9\x00\xaa\x00\x69\x00\x61\x00\x4e\x00\x63\x00\x5a\x00\x51\x00\x6c\x00\x53\x00\xa9\x00\xaa\x00\x6a\x00\x57\x00\x58\x00\x69\x00\x5a\x00\x05\x00\x06\x00\x5d\x00\x6d\x00\x5f\x00\x6c\x00\x61\x00\x69\x00\x63\x00\x05\x00\x06\x00\x66\x00\x69\x00\x68\x00\x6c\x00\x6a\x00\x6b\x00\x58\x00\x6d\x00\x01\x00\x02\x00\x09\x00\x69\x00\x05\x00\x69\x00\x07\x00\x08\x00\x74\x00\x75\x00\x11\x00\x6c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x69\x00\x12\x00\x13\x00\x14\x00\x15\x00\x69\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x09\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x0f\x00\x10\x00\x25\x00\x26\x00\x27\x00\x69\x00\x29\x00\x2a\x00\x2b\x00\x69\x00\x33\x00\x2e\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x40\x00\x69\x00\x42\x00\x43\x00\x2a\x00\x2b\x00\x2c\x00\x52\x00\x53\x00\x2f\x00\x74\x00\x75\x00\x57\x00\x6c\x00\x59\x00\x71\x00\x72\x00\x73\x00\x5d\x00\x75\x00\x4e\x00\x6c\x00\x61\x00\x51\x00\x63\x00\x53\x00\x05\x00\x06\x00\x6c\x00\x57\x00\x58\x00\x6a\x00\x5a\x00\xa9\x00\xaa\x00\x5d\x00\x59\x00\x5f\x00\x6c\x00\x61\x00\x6c\x00\x63\x00\xa9\x00\xaa\x00\x66\x00\x65\x00\x68\x00\x56\x00\x6a\x00\x6b\x00\x64\x00\x6d\x00\x6e\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x08\x00\x54\x00\x0a\x00\x5d\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x5d\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x09\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x0f\x00\x10\x00\x25\x00\x26\x00\x27\x00\x5d\x00\x29\x00\x2a\x00\x2b\x00\x09\x00\x09\x00\x2e\x00\x09\x00\x0a\x00\x09\x00\x0a\x00\x0f\x00\x11\x00\x09\x00\x0a\x00\x52\x00\x53\x00\x15\x00\x09\x00\x0a\x00\x57\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x6a\x00\x5d\x00\x2f\x00\x20\x00\x21\x00\x61\x00\x23\x00\x63\x00\x69\x00\x26\x00\x27\x00\x28\x00\x69\x00\x4e\x00\x6a\x00\x69\x00\x51\x00\x6c\x00\x53\x00\xa9\x00\xaa\x00\x33\x00\x57\x00\x58\x00\x35\x00\x5a\x00\x38\x00\x69\x00\x5d\x00\x69\x00\x5f\x00\x69\x00\x61\x00\x69\x00\x63\x00\x69\x00\x42\x00\x43\x00\x69\x00\x68\x00\x6c\x00\x6a\x00\x6b\x00\x69\x00\x6d\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x08\x00\xa9\x00\xaa\x00\x69\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x64\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x56\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x74\x00\x75\x00\x25\x00\x26\x00\x27\x00\x62\x00\x29\x00\x2a\x00\x2b\x00\x09\x00\x09\x00\x2e\x00\x56\x00\x74\x00\x75\x00\x6a\x00\x0f\x00\x11\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x65\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x56\x00\x23\x00\x24\x00\x6a\x00\x26\x00\x27\x00\x28\x00\x65\x00\x4e\x00\x05\x00\x06\x00\x51\x00\x55\x00\x53\x00\x05\x00\x06\x00\x33\x00\x57\x00\x58\x00\x64\x00\x5a\x00\xa9\x00\xaa\x00\x5d\x00\x65\x00\x5f\x00\x6a\x00\x61\x00\x2d\x00\x63\x00\x41\x00\x42\x00\x43\x00\x2d\x00\x68\x00\x64\x00\x6a\x00\x6b\x00\x64\x00\x6d\x00\x01\x00\x02\x00\x09\x00\x2d\x00\x05\x00\x6a\x00\x07\x00\x08\x00\x59\x00\x0a\x00\x11\x00\x59\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x59\x00\x12\x00\x13\x00\x14\x00\x15\x00\x59\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x69\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xa9\x00\xaa\x00\x25\x00\x26\x00\x27\x00\x69\x00\x29\x00\x2a\x00\x2b\x00\x09\x00\x33\x00\x2e\x00\xa9\x00\xaa\x00\x5e\x00\x69\x00\x54\x00\x11\x00\x52\x00\x53\x00\x5e\x00\x6a\x00\x54\x00\x57\x00\x41\x00\x42\x00\x43\x00\x28\x00\x09\x00\x5d\x00\x65\x00\x5e\x00\x14\x00\x61\x00\x64\x00\x63\x00\x11\x00\x6a\x00\x62\x00\x52\x00\x53\x00\x5e\x00\x6a\x00\x4e\x00\x57\x00\x6a\x00\x51\x00\x6a\x00\x53\x00\x65\x00\x5d\x00\x33\x00\x57\x00\x58\x00\x61\x00\x5a\x00\x63\x00\x65\x00\x5d\x00\x6a\x00\x5f\x00\x5e\x00\x61\x00\x6a\x00\x63\x00\x41\x00\x42\x00\x43\x00\x6a\x00\x68\x00\x33\x00\x6a\x00\x6b\x00\x66\x00\x6d\x00\x01\x00\x02\x00\x01\x00\x03\x00\x05\x00\x02\x00\x07\x00\x08\x00\x55\x00\x41\x00\x42\x00\x43\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\xa9\x00\x12\x00\x13\x00\x14\x00\x15\x00\x09\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x5d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x57\x00\x06\x00\x25\x00\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x08\x00\x04\x00\x2e\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x09\x00\x12\x00\x08\x00\xa2\x00\x08\x00\x08\x00\x17\x00\x09\x00\xa0\x00\x09\x00\x0b\x00\x1c\x00\x57\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x54\x00\x0b\x00\x25\x00\xa9\x00\x27\x00\x22\x00\x29\x00\x4e\x00\x0b\x00\x05\x00\x51\x00\x2e\x00\x53\x00\x46\x00\x05\x00\x1b\x00\x57\x00\x58\x00\x06\x00\x5a\x00\x22\x00\x0b\x00\x5d\x00\x06\x00\x5f\x00\x0b\x00\x61\x00\x06\x00\x63\x00\x1b\x00\x1b\x00\x19\x00\x1b\x00\x68\x00\x1b\x00\x6a\x00\x6b\x00\x1a\x00\x6d\x00\x09\x00\x1b\x00\x09\x00\x1b\x00\x4e\x00\x16\x00\x1b\x00\x51\x00\x52\x00\x53\x00\x11\x00\x1b\x00\x1b\x00\x57\x00\x58\x00\x1b\x00\x5a\x00\x08\x00\x1a\x00\x5d\x00\x5e\x00\x5f\x00\x1b\x00\x61\x00\x1b\x00\x63\x00\x09\x00\x12\x00\x09\x00\xa2\x00\x09\x00\x18\x00\x6a\x00\x6b\x00\x11\x00\x6d\x00\x9e\x00\x1c\x00\x16\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x33\x00\x1b\x00\x25\x00\x08\x00\x27\x00\x19\x00\x29\x00\x19\x00\x19\x00\x16\x00\x16\x00\x2e\x00\x09\x00\x12\x00\x41\x00\x42\x00\x43\x00\x17\x00\x16\x00\x16\x00\x11\x00\x16\x00\x0b\x00\x1c\x00\x33\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x0b\x00\x1b\x00\x25\x00\x1b\x00\x27\x00\x0b\x00\x29\x00\x16\x00\x41\x00\x42\x00\x43\x00\x2e\x00\x09\x00\x4e\x00\x16\x00\x16\x00\x51\x00\x52\x00\x53\x00\xa4\x00\x11\x00\x9f\x00\x57\x00\x58\x00\x33\x00\x5a\x00\x09\x00\x09\x00\x5d\x00\x75\x00\x5f\x00\x0b\x00\x61\x00\x62\x00\x63\x00\x64\x00\x0b\x00\x75\x00\x41\x00\x42\x00\x43\x00\x6a\x00\x6b\x00\x4e\x00\x6d\x00\x0b\x00\x51\x00\x52\x00\x53\x00\x75\x00\x09\x00\x09\x00\x57\x00\x58\x00\x33\x00\x5a\x00\x08\x00\x19\x00\x5d\x00\x07\x00\x5f\x00\x05\x00\x61\x00\x62\x00\x63\x00\x64\x00\x12\x00\x09\x00\x41\x00\x42\x00\x43\x00\x6a\x00\x6b\x00\x75\x00\x6d\x00\x0b\x00\x1c\x00\x75\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x09\x00\x09\x00\x25\x00\x08\x00\x27\x00\x75\x00\x29\x00\xa4\x00\x05\x00\x75\x00\x09\x00\x2e\x00\xff\xff\x12\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\x24\x00\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x4e\x00\xff\xff\xff\xff\x51\x00\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x4e\x00\x6d\x00\xff\xff\x51\x00\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\x08\x00\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x12\x00\xff\xff\xff\xff\x09\x00\xff\xff\x6a\x00\x6b\x00\xff\xff\x6d\x00\x0f\x00\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\x08\x00\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\x20\x00\x21\x00\x2e\x00\x23\x00\x12\x00\x25\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x4e\x00\xff\xff\xff\xff\x51\x00\xff\xff\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\xff\xff\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x6a\x00\x6b\x00\x4e\x00\x6d\x00\xff\xff\x51\x00\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\x08\x00\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\x64\x00\x12\x00\xff\xff\xff\xff\x09\x00\xff\xff\x6a\x00\x6b\x00\xff\xff\x6d\x00\x0f\x00\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\x08\x00\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\x20\x00\x21\x00\x2e\x00\x23\x00\x12\x00\x25\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\x52\x00\x53\x00\x2e\x00\xff\xff\x4e\x00\x57\x00\xff\xff\x51\x00\x52\x00\x53\x00\xff\xff\x5d\x00\xff\xff\x57\x00\x58\x00\x61\x00\x5a\x00\x63\x00\xff\xff\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\x6a\x00\x63\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x4e\x00\x6d\x00\xff\xff\x51\x00\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\x08\x00\x63\x00\x64\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x12\x00\x6d\x00\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x08\x00\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\x12\x00\x2e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\x52\x00\x53\x00\xff\xff\xff\xff\x4e\x00\x57\x00\xff\xff\x51\x00\xff\xff\x53\x00\xff\xff\x5d\x00\xff\xff\x57\x00\x58\x00\x61\x00\x5a\x00\x63\x00\xff\xff\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\x6a\x00\x63\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\x6a\x00\x6b\x00\x51\x00\x6d\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\x08\x00\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\x6d\x00\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\x08\x00\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x4e\x00\xff\xff\xff\xff\x51\x00\xff\xff\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\x64\x00\xff\xff\xff\xff\xff\xff\x68\x00\xff\xff\x6a\x00\x6b\x00\x4e\x00\x6d\x00\xff\xff\x51\x00\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\x08\x00\xff\xff\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\x6d\x00\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x08\x00\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\x12\x00\x2e\x00\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\xff\xff\xff\xff\x51\x00\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\x64\x00\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\x6a\x00\x6b\x00\x51\x00\x6d\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\x08\x00\xff\xff\x5d\x00\x5e\x00\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\x6d\x00\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\x08\x00\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x4e\x00\xff\xff\xff\xff\x51\x00\xff\xff\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x4e\x00\x6d\x00\xff\xff\x51\x00\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\x08\x00\x63\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x12\x00\x6d\x00\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\x08\x00\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x4e\x00\xff\xff\xff\xff\x51\x00\xff\xff\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x4e\x00\x6d\x00\xff\xff\x51\x00\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\x08\x00\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\x6d\x00\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x08\x00\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\x12\x00\x2e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\xff\xff\xff\xff\x51\x00\xff\xff\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\x59\x00\x5a\x00\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\x6a\x00\x6b\x00\x51\x00\x6d\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\x08\x00\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x12\x00\xff\xff\xff\xff\x68\x00\xff\xff\x6a\x00\x6b\x00\xff\xff\x6d\x00\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\x08\x00\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x4e\x00\xff\xff\xff\xff\x51\x00\xff\xff\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\x64\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x4e\x00\x6d\x00\xff\xff\x51\x00\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\x08\x00\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\x6d\x00\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\x08\x00\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x4e\x00\xff\xff\xff\xff\x51\x00\xff\xff\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\xff\xff\x6a\x00\x6b\x00\x4e\x00\x6d\x00\xff\xff\x51\x00\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\x08\x00\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\x6d\x00\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\x08\x00\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x4e\x00\xff\xff\xff\xff\x51\x00\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x4e\x00\x6d\x00\xff\xff\x51\x00\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\x08\x00\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\x6d\x00\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\x08\x00\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x4e\x00\xff\xff\xff\xff\x51\x00\xff\xff\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\xff\xff\x6a\x00\x6b\x00\x4e\x00\x6d\x00\xff\xff\x51\x00\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\x08\x00\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\x6d\x00\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\x08\x00\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x4e\x00\xff\xff\xff\xff\x51\x00\xff\xff\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\xff\xff\x6a\x00\x6b\x00\x4e\x00\x6d\x00\xff\xff\x51\x00\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x5a\x00\x08\x00\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\x6d\x00\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\x09\x00\xff\xff\x0b\x00\x2e\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\x13\x00\x14\x00\x1c\x00\xff\xff\x1e\x00\x1f\x00\xff\xff\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x20\x00\x21\x00\x29\x00\x23\x00\xff\xff\xff\xff\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\xff\xff\x4e\x00\xff\xff\xff\xff\x51\x00\xff\xff\x53\x00\xff\xff\xff\xff\x34\x00\x57\x00\x58\x00\xff\xff\x5a\x00\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\x6a\x00\x6b\x00\x51\x00\x6d\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x1c\x00\x6d\x00\x1e\x00\x1f\x00\xff\xff\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\xff\xff\xff\xff\x29\x00\xff\xff\x09\x00\xff\xff\x0b\x00\xff\xff\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\x13\x00\x14\x00\x1c\x00\xff\xff\x1e\x00\x1f\x00\xff\xff\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x20\x00\x21\x00\x29\x00\x23\x00\xff\xff\xff\xff\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\xff\xff\x4e\x00\xff\xff\xff\xff\x51\x00\xff\xff\x53\x00\xff\xff\xff\xff\x34\x00\x57\x00\x58\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\x6a\x00\x6b\x00\x51\x00\x6d\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x1c\x00\x6d\x00\x1e\x00\x1f\x00\xff\xff\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\xff\xff\xff\xff\x29\x00\xff\xff\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\x13\x00\x14\x00\x1c\x00\xff\xff\x1e\x00\x1f\x00\xff\xff\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x20\x00\x21\x00\x29\x00\x23\x00\xff\xff\xff\xff\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\xff\xff\x4e\x00\xff\xff\xff\xff\x51\x00\xff\xff\x53\x00\xff\xff\xff\xff\x34\x00\x57\x00\x58\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\x6a\x00\x6b\x00\x51\x00\x6d\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x1c\x00\x6d\x00\x1e\x00\x1f\x00\xff\xff\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\xff\xff\xff\xff\x29\x00\xff\xff\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\x13\x00\x14\x00\x1c\x00\xff\xff\x1e\x00\x1f\x00\xff\xff\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x20\x00\x21\x00\x29\x00\x23\x00\xff\xff\xff\xff\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\xff\xff\x4e\x00\xff\xff\xff\xff\x51\x00\xff\xff\x53\x00\xff\xff\xff\xff\x34\x00\x57\x00\x58\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\x6a\x00\x6b\x00\x51\x00\x6d\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\x1c\x00\x6d\x00\x1e\x00\x1f\x00\xff\xff\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\xff\xff\xff\xff\x29\x00\xff\xff\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\x13\x00\x14\x00\x1c\x00\xff\xff\x1e\x00\x1f\x00\xff\xff\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x20\x00\x21\x00\x29\x00\x23\x00\xff\xff\xff\xff\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\xff\xff\x4e\x00\xff\xff\xff\xff\x51\x00\xff\xff\x53\x00\xff\xff\xff\xff\x34\x00\x57\x00\x58\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\x6a\x00\x6b\x00\x51\x00\x6d\x00\x53\x00\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\xff\xff\x09\x00\xff\xff\xff\xff\x5d\x00\xff\xff\x5f\x00\x0f\x00\x61\x00\xff\xff\x63\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6a\x00\x6b\x00\xff\xff\x6d\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\x09\x00\xff\xff\xff\xff\xff\xff\x55\x00\x56\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x15\x00\xff\xff\xff\xff\x44\x00\x45\x00\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x09\x00\x35\x00\x0b\x00\xff\xff\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x09\x00\xff\xff\x0b\x00\xff\xff\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x0f\x00\xff\xff\xff\xff\xff\xff\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x0f\x00\xff\xff\xff\xff\xff\xff\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\x09\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x0f\x00\xff\xff\xff\xff\xff\xff\x13\x00\x14\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x28\x00\x09\x00\x20\x00\x21\x00\xff\xff\x23\x00\xff\xff\x0f\x00\x26\x00\x27\x00\x28\x00\x13\x00\x14\x00\xff\xff\xff\xff\x2d\x00\x2e\x00\x2f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x09\x00\x20\x00\x21\x00\xff\xff\x23\x00\xff\xff\x0f\x00\x26\x00\x27\x00\x28\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x09\x00\x20\x00\x21\x00\xff\xff\x23\x00\xff\xff\x0f\x00\x26\x00\x27\x00\x28\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x09\x00\x20\x00\x21\x00\xff\xff\x23\x00\xff\xff\x0f\x00\x26\x00\x27\x00\x28\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x09\x00\x20\x00\x21\x00\xff\xff\x23\x00\xff\xff\x0f\x00\x26\x00\x27\x00\x28\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x09\x00\x20\x00\x21\x00\xff\xff\x23\x00\xff\xff\x0f\x00\x26\x00\x27\x00\x28\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x09\x00\x20\x00\x21\x00\xff\xff\x23\x00\xff\xff\x0f\x00\x26\x00\x27\x00\x28\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x09\x00\x20\x00\x21\x00\xff\xff\x23\x00\xff\xff\x0f\x00\x26\x00\x27\x00\x28\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x09\x00\x20\x00\x21\x00\xff\xff\x23\x00\xff\xff\x0f\x00\x26\x00\x27\x00\x28\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x09\x00\x20\x00\x21\x00\xff\xff\x23\x00\xff\xff\x0f\x00\x26\x00\x27\x00\x28\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\xff\xff\x20\x00\x21\x00\xff\xff\x23\x00\xff\xff\xff\xff\x26\x00\x27\x00\x28\x00\x09\x00\xff\xff\x0b\x00\xff\xff\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x09\x00\x26\x00\x27\x00\x28\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\x09\x00\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x28\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\xff\xff\x26\x00\x27\x00\x28\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"#

happyTable :: HappyAddr
happyTable = HappyA# "\x00\x00\x08\x02\xe7\x01\x23\x03\xf1\x01\x09\x00\x28\x03\xf2\x01\x0a\x02\xf3\x01\xc3\x02\x0a\x00\x4c\xff\xc3\x01\x05\x02\x09\x00\x3e\x02\xdb\x02\xd8\x02\xbc\x02\x4c\xff\x0a\x00\xd1\x01\x68\x02\x09\x00\x43\x00\x36\x00\x0d\x00\x0e\x00\x0f\x00\x0a\x00\x10\x00\x37\x00\x68\x02\x12\x00\x13\x00\x14\x00\x64\x01\x4b\x02\x0f\x00\x1e\x03\x10\x00\x49\x00\x78\x01\x12\x00\x13\x00\x79\x01\x4b\x02\x0f\x00\x3f\x02\x10\x00\xc4\x02\x78\x01\x12\x00\x13\x00\x79\x01\x3e\x00\xdc\x02\xd9\x02\xbd\x02\x19\x03\x6b\x02\x3f\x00\xd2\x01\x4c\x02\x4d\x02\x4e\x02\x4a\x00\x4f\x02\x69\x02\x6a\x02\x6b\x02\xe4\x00\x4c\x02\x4d\x02\x4e\x02\x3e\x00\x18\x03\xe2\x00\x38\x00\x29\x03\xa5\x00\x3f\x00\xf0\x02\xe3\x00\x4a\x00\xf4\x01\xc7\x01\x4b\x00\x34\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x06\x02\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x34\x00\x34\x00\x35\x00\x0b\x02\x1f\x03\x29\x03\x21\x03\x5c\x00\x5d\x00\x0a\x02\xe8\x01\x5e\x00\x5f\x00\x43\x02\xde\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x09\x00\x23\x03\xf1\x01\x7d\x01\xf5\x01\xf2\x01\x0a\x00\xf3\x01\x1e\x03\x09\x00\xb2\x00\x07\x02\x7d\x01\x61\x01\x9d\x00\x0a\x00\x9e\x00\xd3\x01\x85\x01\xa6\x00\x5a\x01\x36\x00\x0d\x00\x0e\x00\x0f\x00\x7d\x02\x10\x00\x37\x00\xff\xff\x12\x00\x13\x00\x14\x00\x77\x01\x0f\x00\xf1\x02\x10\x00\x23\x03\x78\x01\x12\x00\x13\x00\x79\x01\x3e\x00\xc9\x02\xca\x02\xd5\x01\x7e\x02\xe5\x01\x3f\x00\xf0\x02\xe5\x01\xf1\x01\x7f\x02\xa9\x00\xf2\x01\x07\x03\xd6\x02\xd5\x01\x08\x03\x7a\x01\x7b\x01\x80\x02\x7c\x01\xb5\x02\x34\x00\x0b\x02\x59\x02\x34\x00\x5f\xff\xe6\x01\xc3\x01\x05\x02\x24\x03\x25\x03\x26\x03\x38\x00\x34\x00\x35\x00\xd1\x00\x15\x02\x1f\x03\x4a\x00\x6f\x03\x5f\xff\x4b\x00\xe6\x02\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x9b\x01\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x9d\x00\xd0\x02\x9e\x00\xd1\x02\x70\x03\x25\x03\x26\x03\x5c\x00\x5d\x00\x32\x02\x34\x00\x5e\x00\x5f\x00\x33\x02\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x09\x00\xf6\x02\x7d\x01\x9b\x01\x45\x03\x34\x00\x0a\x00\xf1\x01\xb2\x00\x09\x00\xf2\x01\x09\x00\xd1\x02\x81\x00\x82\x00\x0a\x00\x82\x01\x0a\x00\x8d\x02\x09\x00\xb2\x00\x36\x00\x0d\x00\x0e\x00\x0f\x00\x0a\x00\x10\x00\x37\x00\xb3\x00\x12\x00\x13\x00\x14\x00\x4b\x02\x0f\x00\xe5\x01\x10\x00\xc9\x00\x78\x01\x12\x00\x13\x00\x79\x01\xcc\x00\x4b\x02\x0f\x00\xba\x02\x10\x00\xe5\x01\x78\x01\x12\x00\x13\x00\x79\x01\x12\x02\xbf\x00\x64\x02\x24\x00\x13\x02\xe5\x01\x14\x02\x4c\x02\x4d\x02\x87\x02\x70\x02\x89\x01\xa5\x00\x15\x02\x59\x02\xe4\x00\x91\x01\x4c\x02\x4d\x02\x86\x02\x34\x00\x58\x02\x09\x00\x38\x00\x59\x02\x09\x00\x8b\x01\xd5\x00\x0a\x00\x4a\x00\x1e\x03\x0a\x00\x4b\x00\xff\xff\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x38\x03\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x12\x00\x13\x00\xa0\x00\x12\x00\x13\x00\x43\x02\x1c\x02\x5c\x00\x5d\x00\xe3\x01\x1d\x02\x5e\x00\x5f\x00\xf7\x01\xf8\x01\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x09\x00\xcc\x01\x7d\x01\x1f\x03\x20\x03\x21\x03\x0a\x00\x39\x03\x3a\x03\x3b\x03\x3c\x03\x09\x00\x7d\x01\x3d\x03\x09\x00\xf1\x01\xbc\x00\x0a\x00\xc6\x02\xca\x02\x0a\x00\x36\x00\x0d\x00\x0e\x00\x0f\x00\xcc\x01\x10\x00\x37\x00\xe2\x01\x12\x00\x13\x00\x14\x00\xf9\x01\xfa\x01\x4b\x02\x0f\x00\x02\x03\x10\x00\x6e\x02\x78\x01\x12\x00\x13\x00\x79\x01\x12\x00\x13\x00\x52\x01\xc6\x00\xfb\x01\xfe\x02\xfc\x01\xc7\x00\x09\x00\xc8\x00\xbd\x00\xbe\x00\x15\x02\x34\x00\x0a\x00\xbf\x00\xbf\x00\x4c\x02\x4d\x02\x16\x03\x34\x00\xc0\x00\xc6\x00\xdd\x01\x15\x02\xc1\x00\x87\x01\xc2\x00\x88\x01\xd9\x01\x09\x00\x38\x00\xcc\x01\x09\x00\x34\x00\x34\x00\x0a\x00\x4a\x00\xc8\x01\x0a\x00\x4b\x00\x34\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x38\x03\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x12\x00\x13\x00\x43\x02\x12\x00\x13\x00\x43\x02\xb2\x00\x5c\x00\x5d\x00\xa3\x00\xa4\x00\x5e\x00\x5f\x00\xcc\x01\xb3\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x09\x00\xd1\x00\xfa\x02\xb2\x00\x7d\x01\x9b\x01\x0a\x00\xfb\x02\x75\x03\x3b\x03\x3c\x03\xfc\x01\xff\x01\x76\x03\x60\x01\xf1\x01\xd4\x00\xd5\x00\xc6\x02\xc7\x02\x8b\x02\x36\x00\x0d\x00\x0e\x00\x0f\x00\xce\x01\x10\x00\x37\x00\x09\x00\x12\x00\x13\x00\x14\x00\x4c\xff\xcc\x01\x0a\x00\x44\x02\x34\x00\x58\x01\xdd\x02\x09\x00\xa5\x01\x59\x01\x09\x00\x5a\x01\x4c\xff\x0a\x00\x4c\xff\xa3\x01\x0a\x00\x36\x00\x0d\x00\x0e\x00\x0f\x00\xa2\x01\x10\x00\x37\x00\xb2\x00\x12\x00\x13\x00\x14\x00\xf9\x01\xfa\x01\x9d\x01\xf1\x01\xfc\x01\xfe\x01\xc6\x02\xee\x02\x12\x00\x13\x00\x43\x02\x12\x00\x13\x00\x43\x02\x38\x00\xfb\x01\x09\x00\xfc\x01\xb8\x02\x0f\x02\x4a\x00\x10\x02\x0a\x00\x4b\x00\x34\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x9b\x01\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x38\x00\xc9\x00\x96\x01\x12\x00\x13\x00\xca\x00\x9a\x01\x5c\x00\x5d\x00\x39\x00\x98\x01\x5e\x00\x5f\x00\x34\x00\x35\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x09\x00\x91\x02\xb2\x00\x12\x02\x47\x03\x97\x01\x0a\x00\x13\x02\x3e\x00\x14\x02\xb3\x00\x95\x01\x09\x00\x61\x01\x3f\x00\x40\x00\x15\x02\xd1\x00\x0a\x00\x90\x01\xb2\x00\x36\x00\x0d\x00\x0e\x00\x0f\x00\x89\x01\x10\x00\x37\x00\xb3\x00\x12\x00\x13\x00\x14\x00\x6e\x01\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x6e\x01\x10\x00\x11\x00\x6d\x01\x12\x00\x13\x00\x14\x00\x89\x01\xf1\x01\x2b\x00\xdb\x00\xf2\x01\x03\x02\x4a\x03\x15\x00\x16\x00\x17\x00\x18\x00\x34\x00\x35\x00\xd7\x00\x65\x01\x8b\x01\xd5\x00\xdc\x00\xb4\x00\xdd\x00\x5f\x01\xb5\x00\xb6\x00\xb7\x00\xb8\x00\x64\x01\xf1\x01\x6f\x01\x70\x01\xf2\x01\x38\x00\x49\x03\x09\x00\xb9\x00\xba\x00\x75\x02\x4a\x00\x70\x02\x0a\x00\x4b\x00\x6d\x02\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x6e\x02\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x34\x00\xe0\x00\x04\x02\x12\x00\x13\x00\xca\x00\x67\x02\x5c\x00\x5d\x00\x46\x00\x08\x00\x5e\x00\x5f\x00\xd9\x00\x18\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x09\x00\xcd\x02\x3e\x00\xce\x02\xc9\x01\xe6\x01\x0a\x00\xb2\x00\x3f\x00\x92\x01\x34\x00\x62\x02\xac\x00\xeb\x01\x60\x02\xfc\x01\xfd\x01\xb2\x00\xc9\x01\xdf\x01\x9e\x00\x0c\x00\x0d\x00\xad\x00\x0f\x00\xb3\x00\x10\x00\x11\x00\x3e\x00\x12\x00\x13\x00\x14\x00\xc9\x01\xd6\x01\x3f\x00\xec\x01\x5f\x02\x09\x00\xb2\x00\x15\x00\x16\x00\x17\x00\x18\x00\x0a\x00\xae\x00\xbf\x00\xb3\x00\xf1\x01\x5d\x02\xac\x00\xf2\x01\x58\x01\x57\x03\xf1\x01\x5c\x02\x84\x01\xf2\x01\x85\x01\x56\x03\xd1\x00\x5c\x01\x0f\x00\xfa\xfe\x10\x00\x34\x00\xa7\x01\x12\x00\x13\x00\x56\x01\xc9\x01\xd5\x01\xd2\x00\xd3\x00\xf9\xfe\xd4\x00\xd5\x00\xfb\xfe\xbd\x00\xbe\x00\xff\xfe\x89\x01\xae\x00\xbf\x00\x3d\x02\xfc\xfe\x8a\x01\xf1\x01\x1c\x02\x8d\x01\xf2\x01\xfe\xfe\x55\x03\x8e\x01\x35\x02\x8f\x01\x8b\x01\xd5\x00\x1c\x02\x0a\x02\x84\x00\x85\x00\x34\x00\x78\x03\x86\x00\x30\x02\x87\x00\x1c\x00\x2f\x02\x62\xfe\x5c\x00\xaf\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x2e\x02\x1d\x00\x8c\x00\x8d\x00\x8e\x00\x2d\x02\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x1e\x00\x09\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x94\x00\x0a\x00\x1c\x02\x25\x00\x95\x00\x26\x00\x2c\x02\x27\x00\x96\x00\x97\x00\x22\x02\x09\x00\x28\x00\x27\x02\x5c\x00\xaf\x00\x26\x02\x0a\x00\xdf\x00\x0f\x00\x25\x02\x10\x00\xb2\x00\xac\x00\x12\x00\x13\x00\x56\x01\x24\x02\xbd\x00\xbe\x00\xb3\x00\xc9\x01\xd1\x01\xbf\x00\x5c\x01\x0f\x00\x22\x02\x10\x00\x1c\x02\xd7\x00\x12\x00\x13\x00\x56\x01\xd8\x00\x29\x00\xd9\x00\x1f\x02\x2a\x00\x1c\x02\x3b\x00\xc9\x01\xce\x01\x34\x00\x2d\x00\x2e\x00\x73\x01\x2f\x00\xf1\x01\xb2\x00\x3c\x00\xf2\x01\x31\x00\x54\x03\x3d\x00\x89\x01\x3e\x00\xfc\x01\xc5\x02\x0b\x02\x4a\x02\x98\x00\x34\x00\x34\x00\x35\x00\x1a\x02\x36\x00\x0a\x02\x84\x00\x85\x00\x8b\x01\xd5\x00\x86\x00\x18\x02\x87\x00\x1c\x00\x17\x02\x62\xfe\xc9\x01\xca\x01\x88\x00\x89\x00\x8a\x00\x8b\x00\x34\x00\x1d\x00\x8c\x00\x8d\x00\x8e\x00\xeb\x01\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x1e\x00\x09\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x94\x00\x0a\x00\xea\x01\x25\x00\x95\x00\x26\x00\xcc\x01\x27\x00\x96\x00\x97\x00\xc3\x01\xc5\x01\x28\x00\xc3\x01\xc4\x01\x43\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\xd6\x02\x10\x00\x11\x00\xdd\x01\x12\x00\x13\x00\x14\x00\xc5\x02\xbd\x00\xbe\x00\xc3\x01\x18\x02\xc0\x02\xbf\x00\x15\x00\x16\x00\x17\x00\x18\x00\xc1\x02\x8d\x01\xc9\x01\xdf\x02\xb0\x02\x8e\x01\x29\x00\x8f\x01\xb8\x02\x2a\x00\x1f\x02\x3b\x00\xc9\x01\xde\x02\x34\x00\x2d\x00\x2e\x00\xaf\x02\x2f\x00\xd3\x02\xd4\x02\x3c\x00\xad\x02\x31\x00\x24\x02\x3d\x00\xab\x02\x3e\x00\xbd\x02\xbe\x02\x0b\x02\xa9\x02\x98\x00\x1c\x02\x34\x00\x35\x00\x44\x00\x36\x00\x84\x00\x85\x00\xb2\x00\xa8\x02\x86\x00\xa7\x02\x87\x00\x1c\x00\xb5\x02\xb6\x02\xb3\x00\x24\x02\x88\x00\x89\x00\x8a\x00\x8b\x00\xa6\x02\x1d\x00\x8c\x00\x8d\x00\x8e\x00\xa3\x02\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x1e\x00\x65\x01\x1f\x00\x20\x00\x21\x00\x22\x00\x94\x00\x3f\x00\x66\x01\x25\x00\x95\x00\x26\x00\xa2\x02\x27\x00\x96\x00\x97\x00\xa1\x02\xd1\x00\x28\x00\x90\x02\x77\x02\x78\x02\x79\x02\x7a\x02\x7b\x02\x1d\x03\x78\x02\x79\x02\x7a\x02\x7b\x02\x5d\x01\x9e\x02\xd4\x00\xd5\x00\x80\x02\x69\x01\x6a\x01\xde\xfe\xde\xfe\x6b\x01\xb2\x02\xb3\x02\xde\xfe\x99\x02\xde\xfe\x0d\x02\x0e\x02\x0f\x02\xde\xfe\x10\x02\x29\x00\x97\x02\xde\xfe\x2a\x00\xde\xfe\x3b\x00\x8d\x02\x8e\x02\x96\x02\x2d\x00\x2e\x00\xde\xfe\x2f\x00\xc9\x01\xf2\x02\x3c\x00\x89\x02\x31\x00\x24\x02\x3d\x00\x1c\x02\x3e\x00\xc9\x01\xef\x02\xfa\xfd\x84\x02\x98\x00\x70\x02\x34\x00\x35\x00\x83\x02\x36\x00\xfa\xfd\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x00\x01\x01\x01\x02\x01\x03\x01\x04\x01\x05\x01\x06\x01\x07\x01\x08\x01\x09\x01\x0a\x01\x0b\x01\x0c\x01\x0d\x01\x0e\x01\x0f\x01\x10\x01\x11\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01\x20\x01\x21\x01\x22\x01\x23\x01\x24\x01\x25\x01\x26\x01\x27\x01\x28\x01\x29\x01\x2a\x01\x2b\x01\x2c\x01\x2d\x01\x2e\x01\x2f\x01\x30\x01\x31\x01\x32\x01\x33\x01\x34\x01\x35\x01\x36\x01\x37\x01\x38\x01\x39\x01\x3a\x01\x3b\x01\x3c\x01\x3d\x01\x3e\x01\x3f\x01\x40\x01\x41\x01\x42\x01\x43\x01\x44\x01\x45\x01\x46\x01\x47\x01\x48\x01\x49\x01\x4a\x01\x4b\x01\x4c\x01\x4d\x01\x4e\x01\x4f\x01\x50\x01\x51\x01\x52\x01\x84\x00\x85\x00\x3f\x03\x40\x03\x86\x00\x41\x03\x87\x00\x1c\x00\x82\x02\x62\xfe\x1d\x03\x42\x03\x88\x00\x89\x00\x8a\x00\x43\x03\x1c\x03\x1d\x00\x8c\x00\x8d\x00\x8e\x00\x44\x03\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x1e\x00\x65\x01\x1f\x00\x20\x00\x21\x00\x22\x00\x94\x00\x3f\x00\x66\x01\x25\x00\x95\x00\x26\x00\x1b\x03\x27\x00\x96\x00\x97\x00\xb2\x00\x09\x00\x28\x00\xc3\x01\xeb\x02\xc3\x01\xea\x02\x0a\x00\xb3\x00\xc3\x01\xe9\x02\xbd\x00\xbe\x00\xac\x00\xc3\x01\xe8\x02\xbf\x00\x67\x01\x68\x01\x69\x01\x6a\x01\x34\x00\xd7\x00\x6b\x01\x5c\x01\x0f\x00\xd8\x00\x10\x00\xd9\x00\x15\x03\x12\x00\x13\x00\x56\x01\x14\x03\x29\x00\x34\x00\x13\x03\x2a\x00\x24\x02\x3b\x00\xc9\x01\xe4\x02\x89\x01\x2d\x00\x2e\x00\x76\x01\x2f\x00\x49\x02\x10\x03\x3c\x00\x0f\x03\x31\x00\x0e\x03\x3d\x00\x0d\x03\x3e\x00\x0c\x03\x8b\x01\xd5\x00\x0b\x03\x98\x00\x24\x02\x34\x00\x35\x00\x0a\x03\x36\x00\x84\x00\x85\x00\x3f\x03\x40\x03\x86\x00\x41\x03\x87\x00\x1c\x00\xc9\x01\xe2\x02\x05\x03\x42\x03\x88\x00\x89\x00\x8a\x00\x43\x03\x04\x03\x1d\x00\x8c\x00\x8d\x00\x8e\x00\x44\x03\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x1e\x00\x03\x03\x1f\x00\x20\x00\x21\x00\x22\x00\x94\x00\x34\x03\x31\x03\x25\x00\x95\x00\x26\x00\x00\x03\x27\x00\x96\x00\x97\x00\xb2\x00\x09\x00\x28\x00\xff\x02\x30\x03\x31\x03\x15\x02\x0a\x00\xb3\x00\x76\x02\x77\x02\x78\x02\x79\x02\x7a\x02\x7b\x02\xe0\x02\x77\x02\x78\x02\x79\x02\x7a\x02\x7b\x02\xfa\x02\xcb\x00\x0d\x00\x0e\x00\x0f\x00\xf4\x02\x10\x00\x37\x00\x34\x00\x12\x00\x13\x00\x14\x00\xcc\x01\x29\x00\x2a\x03\x8e\x02\x2a\x00\xe8\x02\x3b\x00\x5e\x03\x5f\x03\xed\x01\x2d\x00\x2e\x00\xee\x02\x2f\x00\xc9\x01\xd6\x01\x3c\x00\xcc\x01\x31\x00\x34\x00\x3d\x00\x52\x03\x3e\x00\x0b\x02\xef\x01\xd5\x00\x51\x03\x98\x00\x4f\x03\x34\x00\x35\x00\x4d\x03\x36\x00\x82\xff\x82\xff\xb2\x00\x45\x03\x82\xff\x15\x02\x82\xff\x82\xff\x37\x03\x82\xff\xb3\x00\x36\x03\x82\xff\x82\xff\x82\xff\x82\xff\x34\x03\x82\xff\x82\xff\x82\xff\x82\xff\x33\x03\x82\xff\x82\xff\x82\xff\x82\xff\x82\xff\x82\xff\x30\x03\x82\xff\x82\xff\x82\xff\x82\xff\x82\xff\xc9\x01\x53\x03\x82\xff\x82\xff\x82\xff\x2e\x03\x82\xff\x82\xff\x82\xff\xb2\x00\xed\x01\x82\xff\xc9\x01\x52\x03\x6e\x03\x2d\x03\x6f\x03\xb3\x00\xbd\x00\xbe\x00\x6b\x03\x34\x00\x6a\x03\xbf\x00\x01\x02\xef\x01\xd5\x00\x69\x03\xb2\x00\x8d\x01\x5c\x03\x67\x03\x28\x03\x8e\x01\x66\x03\x8f\x01\xb3\x00\x15\x02\x63\x03\xbd\x00\xbe\x00\x75\x03\x34\x00\x82\xff\xbf\x00\x15\x02\x82\xff\x34\x00\x82\xff\xfa\x02\xd7\x00\xed\x01\x82\xff\x82\xff\xd8\x00\x82\xff\x0d\x02\xcc\x01\x82\xff\x34\x00\x82\xff\x74\x03\x82\xff\x34\x00\x82\xff\x00\x02\xef\x01\xd5\x00\x34\x00\x82\xff\xed\x01\x82\xff\x82\xff\x7c\x03\x82\xff\x84\x00\x85\x00\x08\x00\x41\x00\x86\x00\xe4\x00\x87\x00\x1c\x00\xa5\x00\xf0\x01\xef\x01\xd5\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\xcf\x00\x1d\x00\x8c\x00\x8d\x00\x8e\x00\xce\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x1e\x00\xa1\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x94\x00\x47\x00\xe3\x01\x25\x00\x95\x00\x26\x00\xde\x01\x27\x00\x96\x00\x97\x00\x1c\x00\xe0\x01\x28\x00\x46\x03\x77\x02\x78\x02\x79\x02\x7a\x02\x7b\x02\xdd\x01\xb1\x00\xda\x01\xdb\x01\xd9\x01\xd7\x01\xb2\x00\xcf\x01\xcc\x01\xc7\x01\xa3\x01\x1e\x00\xa0\x01\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x9b\x01\x98\x01\x25\x00\x93\x01\x26\x00\x62\x01\x27\x00\x29\x00\x73\x02\x72\x02\x2a\x00\x28\x00\x3b\x00\x65\x02\x64\x02\x3b\x02\x2d\x00\x2e\x00\x62\x02\x2f\x00\x62\x01\x60\x02\x3c\x00\x59\x02\x31\x00\x5d\x02\x3d\x00\x56\x02\x3e\x00\x3a\x02\x39\x02\x30\x02\x38\x02\x98\x00\x37\x02\x34\x00\x35\x00\x27\x02\x36\x00\x02\x02\x36\x02\xb2\x00\x35\x02\x29\x00\x22\x02\x33\x02\x2a\x00\x2b\x00\x2c\x00\xb3\x00\x2a\x02\x29\x02\x2d\x00\x2e\x00\x28\x02\x2f\x00\x1c\x00\x20\x02\x30\x00\xa0\x00\x31\x00\x1f\x02\x32\x00\x1a\x02\x33\x00\xb2\x00\x1d\x00\xce\x02\xd2\x02\xcb\x02\xad\x02\x34\x00\x35\x00\xb3\x00\x36\x00\xab\x02\x1e\x00\xa9\x02\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\xed\x01\xa4\x02\x25\x00\x1c\x00\x26\x00\xa3\x02\x27\x00\x9f\x02\x9e\x02\x9c\x02\x9b\x02\x28\x00\xb2\x00\x1d\x00\xee\x01\xef\x01\xd5\x00\x97\x02\x9a\x02\x99\x02\xb3\x00\x94\x02\x8b\x02\x1e\x00\xed\x01\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x89\x02\x93\x02\x25\x00\x92\x02\x26\x00\x15\x03\x27\x00\x11\x03\xdc\x02\xef\x01\xd5\x00\x28\x00\xb2\x00\x29\x00\x10\x03\x08\x03\x2a\x00\x2b\x00\x2c\x00\xf8\x02\xb3\x00\x05\x03\x2d\x00\x2e\x00\xed\x01\x2f\x00\xce\x02\xcb\x02\x30\x00\x00\x03\x31\x00\xec\x02\x32\x00\x9d\x00\x33\x00\x9e\x00\x4d\x03\xfc\x02\xd9\x02\xef\x01\xd5\x00\x34\x00\x35\x00\x29\x00\x36\x00\x4b\x03\x90\x02\x2b\x00\x2c\x00\x37\x03\x6c\x03\x6b\x03\x2d\x00\x2e\x00\xed\x01\x2f\x00\x1c\x00\x2e\x03\x30\x00\x67\x03\x31\x00\x5d\x03\x32\x00\x9d\x00\x33\x00\x9e\x00\x1d\x00\x5c\x03\xc1\x02\xef\x01\xd5\x00\x34\x00\x35\x00\x64\x03\x36\x00\x78\x03\x1e\x00\x63\x03\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x72\x03\x71\x03\x25\x00\x1c\x00\x26\x00\x61\x03\x27\x00\x5a\x03\x7a\x03\x60\x03\x79\x03\x28\x00\x00\x00\x1d\x00\x2b\x03\x77\x02\x78\x02\x79\x02\x7a\x02\x7b\x02\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x24\x00\x25\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x59\x03\x2b\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x00\x00\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x9d\x00\x33\x00\x9e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\x29\x00\x36\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x1c\x00\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x09\x00\x00\x00\x34\x00\x35\x00\x00\x00\x36\x00\x0a\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x1c\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\xdf\x00\x0f\x00\x28\x00\x10\x00\x1d\x00\x5a\x02\x12\x00\x13\x00\x79\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x2a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x3b\xff\x2f\x00\x00\x00\x3b\xff\x3c\x00\x00\x00\x31\x00\x00\x00\x3d\x00\x00\x00\x3e\x00\x59\x03\x77\x02\x78\x02\x79\x02\x7a\x02\x7b\x02\x34\x00\x35\x00\x29\x00\x36\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x1c\x00\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x9a\x00\x1d\x00\x00\x00\x00\x00\x09\x00\x00\x00\x34\x00\x35\x00\x00\x00\x36\x00\x0a\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x1c\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x54\x02\x0f\x00\x28\x00\x10\x00\x1d\x00\x55\x02\x12\x00\x13\x00\x79\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\xbd\x00\xbe\x00\x28\x00\x00\x00\x29\x00\xbf\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x00\x00\x8d\x01\x00\x00\x2d\x00\x2e\x00\x8e\x01\x2f\x00\x8f\x01\x00\x00\x30\x00\xa0\x00\x31\x00\x00\x00\x32\x00\x34\x00\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\x29\x00\x36\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x00\x00\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x1c\x00\x33\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\xb1\x00\x36\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x1c\x00\x00\x00\x25\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\xbd\x00\xbe\x00\x00\x00\x00\x00\x29\x00\xbf\x00\x00\x00\x2a\x00\x00\x00\x3b\x00\x00\x00\xd7\x00\x00\x00\x2d\x00\x2e\x00\xd8\x00\x2f\x00\xd9\x00\x00\x00\x3c\x00\x82\x01\x31\x00\x00\x00\x3d\x00\x34\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x34\x00\x35\x00\x2a\x00\x36\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x1c\x00\x00\x00\x3c\x00\x00\x00\x31\x00\x00\x00\x3d\x00\x9d\x00\x3e\x00\x9e\x00\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\x00\x00\x36\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x1c\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x2a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x00\x00\x00\x00\x3c\x00\x00\x00\x31\x00\x00\x00\x3d\x00\x00\x00\x3e\x00\x7f\x01\x00\x00\x00\x00\x00\x00\x80\x01\x00\x00\x34\x00\x35\x00\x29\x00\x36\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x1c\x00\x00\x00\x30\x00\xa0\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\x00\x00\x36\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x1c\x00\x00\x00\x25\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\xb1\x00\x28\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x00\x00\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x34\x00\x35\x00\x2a\x00\x36\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x1c\x00\x00\x00\x3c\x00\x49\x02\x31\x00\x00\x00\x3d\x00\x00\x00\x3e\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\x00\x00\x36\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x1c\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x2a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x00\x00\x00\x00\x3c\x00\x00\x00\x31\x00\x00\x00\x3d\x00\x9d\x00\x3e\x00\x9e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\x29\x00\x36\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x00\x00\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x1c\x00\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\xb1\x00\x36\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x1c\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x2a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x00\x00\x00\x00\x3c\x00\x00\x00\x31\x00\x00\x00\x3d\x00\x00\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\x29\x00\x36\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x1c\x00\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\x00\x00\x36\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x1c\x00\x00\x00\x25\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x2a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x39\xff\x2f\x00\x00\x00\x00\x00\x3c\x00\x00\x00\x31\x00\x00\x00\x3d\x00\x00\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x34\x00\x35\x00\x2a\x00\x36\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x1c\x00\x00\x00\x3c\x00\x00\x00\x31\x00\x00\x00\x3d\x00\x00\x00\x3e\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x80\x01\x00\x00\x34\x00\x35\x00\x00\x00\x36\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x1c\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x2a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x00\x00\x00\x00\x3c\x00\x00\x00\x31\x00\x00\x00\x3d\x00\x00\x00\x3e\x00\x47\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\x29\x00\x36\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x1c\x00\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\x00\x00\x36\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x1c\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x2a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x00\x00\x00\x00\x3c\x00\x00\x00\x31\x00\x00\x00\x3d\x00\x00\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x00\x00\x34\x00\x35\x00\x29\x00\x36\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x82\xff\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x00\x00\x82\xff\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\x00\x00\x36\x00\x00\x00\x82\xff\x00\x00\x82\xff\x82\xff\x82\xff\x82\xff\x82\xff\x00\x00\x00\x00\x82\xff\x1c\x00\x82\xff\x00\x00\x82\xff\x00\x00\x00\x00\x00\x00\x00\x00\x82\xff\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x82\xff\x00\x00\x00\x00\x82\xff\x82\xff\x82\xff\x00\x00\x00\x00\x00\x00\x82\xff\x82\xff\x00\x00\x82\xff\x00\x00\x00\x00\x82\xff\x00\x00\x82\xff\x00\x00\x82\xff\x00\x00\x82\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x82\xff\x82\xff\x29\x00\x82\xff\x00\x00\x2a\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x1c\x00\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\x00\x00\x36\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x1c\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x2a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x00\x00\x00\x00\x3c\x00\x00\x00\x31\x00\x00\x00\x3d\x00\x00\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x00\x00\x34\x00\x35\x00\x29\x00\x36\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x1c\x00\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\x00\x00\x36\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x1c\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x2a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x00\x00\x00\x00\x3c\x00\x00\x00\x31\x00\x00\x00\x3d\x00\x00\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x00\x00\x34\x00\x35\x00\x29\x00\x36\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x1c\x00\x00\x00\x30\x00\x00\x00\x31\x00\x00\x00\x32\x00\x00\x00\x33\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\x00\x00\x36\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x26\x00\x00\x00\x27\x00\x00\x00\x09\x00\x00\x00\x80\x01\x28\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x5b\x01\xa7\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x00\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x55\x01\x0f\x00\x27\x00\x10\x00\x00\x00\x00\x00\x12\x00\x13\x00\x56\x01\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x2a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\xaa\x00\x2d\x00\x2e\x00\x00\x00\x2f\x00\x00\x00\x00\x00\x3c\x00\x00\x00\x31\x00\x00\x00\x3d\x00\x00\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x34\x00\x35\x00\x2a\x00\x36\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x00\x00\x31\x00\x00\x00\x3d\x00\x00\x00\xce\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\x1e\x00\x36\x00\x1f\x00\x20\x00\x00\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x00\x00\x00\x00\x27\x00\x00\x00\x09\x00\x00\x00\x47\x02\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x5b\x01\xa7\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x00\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x55\x01\x0f\x00\x27\x00\x10\x00\x00\x00\x00\x00\x12\x00\x13\x00\x56\x01\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x2a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\xaa\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x00\x00\x31\x00\x00\x00\x3d\x00\x00\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x34\x00\x35\x00\x2a\x00\x36\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc3\x00\x00\x00\x31\x00\x00\x00\xc4\x00\x00\x00\xc5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\x1e\x00\x36\x00\x1f\x00\x20\x00\x00\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x00\x00\x00\x00\x27\x00\x00\x00\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\xa6\x00\xa7\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x00\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x55\x01\x0f\x00\x27\x00\x10\x00\x00\x00\x00\x00\x12\x00\x13\x00\x56\x01\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x2a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x72\x01\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x00\x00\x31\x00\x00\x00\x3d\x00\x00\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x34\x00\x35\x00\x2a\x00\x36\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x00\x00\x31\x00\x00\x00\x3d\x00\x00\x00\xce\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\x1e\x00\x36\x00\x1f\x00\x20\x00\x00\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x00\x00\x00\x00\x27\x00\x00\x00\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\xa6\x00\xa7\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x00\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x55\x01\x0f\x00\x27\x00\x10\x00\x00\x00\x00\x00\x12\x00\x13\x00\x56\x01\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x2a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\x71\x01\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x00\x00\x31\x00\x00\x00\x3d\x00\x00\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x34\x00\x35\x00\x2a\x00\x36\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x00\x00\x31\x00\x00\x00\x46\x02\x00\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\x1e\x00\x36\x00\x1f\x00\x20\x00\x00\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x00\x00\x00\x00\x27\x00\x00\x00\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x5b\x01\xa7\x00\x1e\x00\x00\x00\x1f\x00\x20\x00\x00\x00\x22\x00\x23\x00\x00\x00\x00\x00\x25\x00\x00\x00\x55\x01\x0f\x00\x27\x00\x10\x00\x00\x00\x00\x00\x12\x00\x13\x00\x56\x01\x00\x00\x00\x00\x00\x00\x29\x00\x00\x00\x00\x00\x2a\x00\x00\x00\x3b\x00\x00\x00\x00\x00\xaa\x00\x2d\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x00\x00\x31\x00\x00\x00\x3d\x00\x00\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x34\x00\x35\x00\x2a\x00\x36\x00\x3b\x00\x00\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x00\x00\x09\x00\x00\x00\x00\x00\x3c\x00\x00\x00\x31\x00\x0a\x00\x49\x03\x00\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x35\x00\x00\x00\x36\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6e\x01\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x09\x00\x00\x00\x00\x00\x00\x00\x19\x00\x1a\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x00\x00\x00\x00\x00\x84\x02\x70\x01\x00\x00\x00\x00\x00\x00\x9e\x00\x0c\x00\x0d\x00\xad\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x09\x00\x76\x01\x9a\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\xa6\x00\xa7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x0c\x00\x0d\x00\xa8\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\xaa\x00\x09\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\xa6\x00\xa7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x0c\x00\x0d\x00\xa8\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x15\x00\x16\x00\x17\x00\x18\x00\x75\x01\x0a\x00\x00\x00\x00\x00\x00\x00\xa6\x00\xa7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x00\x0c\x00\x0d\x00\xa8\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x00\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x15\x00\x16\x00\x17\x00\x18\x00\xa9\x00\x0a\x00\x00\x00\x00\x00\x00\x00\xa6\x00\xa7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x00\x0c\x00\x0d\x00\xa8\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\xba\x02\x15\x00\x16\x00\x17\x00\x18\x00\x74\x01\x0a\x00\x00\x00\x00\x00\x00\x00\xa6\x00\x5a\x01\x9d\x01\x0e\x00\x0f\x00\x00\x00\x10\x00\x37\x00\x00\x00\x12\x00\x13\x00\x14\x00\x09\x00\x55\x01\x0f\x00\x00\x00\x10\x00\x00\x00\x0a\x00\x12\x00\x13\x00\x56\x01\xa6\x00\x5a\x01\x00\x00\x00\x00\x69\x02\x6a\x02\x6b\x02\x00\x00\x00\x00\x00\x00\x00\x00\xa9\x00\x09\x00\x55\x01\x0f\x00\x00\x00\x10\x00\x00\x00\x0a\x00\x12\x00\x13\x00\x56\x01\xa6\x00\xa7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa9\x00\x09\x00\x55\x01\x0f\x00\x00\x00\x10\x00\x00\x00\x0a\x00\x12\x00\x13\x00\x56\x01\xa6\x00\xa7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xaa\x00\x09\x00\x55\x01\x0f\x00\x00\x00\x10\x00\x00\x00\x0a\x00\x12\x00\x13\x00\x56\x01\xa6\x00\xa7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa9\x00\x09\x00\x55\x01\x0f\x00\x00\x00\x10\x00\x00\x00\x0a\x00\x12\x00\x13\x00\x56\x01\xa6\x00\xa7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x01\x09\x00\x55\x01\x0f\x00\x00\x00\x10\x00\x00\x00\x0a\x00\x12\x00\x13\x00\x56\x01\x53\x02\xa7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x01\x09\x00\x55\x01\x0f\x00\x00\x00\x10\x00\x00\x00\x0a\x00\x12\x00\x13\x00\x56\x01\x52\x02\xa7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x01\x09\x00\x55\x01\x0f\x00\x00\x00\x10\x00\x00\x00\x0a\x00\x12\x00\x13\x00\x56\x01\x51\x02\xa7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x01\x09\x00\x55\x01\x0f\x00\x00\x00\x10\x00\x00\x00\x0a\x00\x12\x00\x13\x00\x56\x01\x50\x02\xa7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x72\x01\x09\x00\x55\x01\x0f\x00\x00\x00\x10\x00\x00\x00\x0a\x00\x12\x00\x13\x00\x56\x01\xa6\x00\x5a\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x01\x00\x00\x55\x01\x0f\x00\x00\x00\x10\x00\x00\x00\x00\x00\x12\x00\x13\x00\x56\x01\x09\x00\x00\x00\x9a\x00\x00\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa9\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x45\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xde\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xab\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9f\x01\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x01\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x01\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5f\x01\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x01\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x53\x01\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x02\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x02\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x41\x02\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x02\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x02\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x02\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb1\x02\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb0\x02\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\x02\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x02\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x17\x03\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf7\x02\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf5\x02\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf4\x02\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe5\x02\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe3\x02\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe1\x02\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\x03\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x00\x00\x10\x00\x11\x00\x09\x00\x12\x00\x13\x00\x14\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x09\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x02\x0e\x00\x0f\x00\x00\x00\x10\x00\x37\x00\x00\x00\x12\x00\x13\x00\x14\x00\xdf\x00\x0f\x00\x00\x00\x10\x00\xe0\x00\x00\x00\x12\x00\x13\x00\x14\x00\xa6\x01\xa7\x01\xa8\x01\xa9\x01\xaa\x01\xab\x01\xac\x01\xad\x01\xae\x01\xaf\x01\xb0\x01\xb1\x01\xb2\x01\xb3\x01\xb4\x01\xb5\x01\xb6\x01\xb7\x01\xb8\x01\xb9\x01\xba\x01\xbb\x01\xbc\x01\xbd\x01\xbe\x01\xbf\x01\xc0\x01\xc1\x01\xc2\x01\xc3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyReduceArr = Happy_Data_Array.array (7, 518) [
	(7 , happyReduce_7),
	(8 , happyReduce_8),
	(9 , happyReduce_9),
	(10 , happyReduce_10),
	(11 , happyReduce_11),
	(12 , happyReduce_12),
	(13 , happyReduce_13),
	(14 , happyReduce_14),
	(15 , happyReduce_15),
	(16 , happyReduce_16),
	(17 , happyReduce_17),
	(18 , happyReduce_18),
	(19 , happyReduce_19),
	(20 , happyReduce_20),
	(21 , happyReduce_21),
	(22 , happyReduce_22),
	(23 , happyReduce_23),
	(24 , happyReduce_24),
	(25 , happyReduce_25),
	(26 , happyReduce_26),
	(27 , happyReduce_27),
	(28 , happyReduce_28),
	(29 , happyReduce_29),
	(30 , happyReduce_30),
	(31 , happyReduce_31),
	(32 , happyReduce_32),
	(33 , happyReduce_33),
	(34 , happyReduce_34),
	(35 , happyReduce_35),
	(36 , happyReduce_36),
	(37 , happyReduce_37),
	(38 , happyReduce_38),
	(39 , happyReduce_39),
	(40 , happyReduce_40),
	(41 , happyReduce_41),
	(42 , happyReduce_42),
	(43 , happyReduce_43),
	(44 , happyReduce_44),
	(45 , happyReduce_45),
	(46 , happyReduce_46),
	(47 , happyReduce_47),
	(48 , happyReduce_48),
	(49 , happyReduce_49),
	(50 , happyReduce_50),
	(51 , happyReduce_51),
	(52 , happyReduce_52),
	(53 , happyReduce_53),
	(54 , happyReduce_54),
	(55 , happyReduce_55),
	(56 , happyReduce_56),
	(57 , happyReduce_57),
	(58 , happyReduce_58),
	(59 , happyReduce_59),
	(60 , happyReduce_60),
	(61 , happyReduce_61),
	(62 , happyReduce_62),
	(63 , happyReduce_63),
	(64 , happyReduce_64),
	(65 , happyReduce_65),
	(66 , happyReduce_66),
	(67 , happyReduce_67),
	(68 , happyReduce_68),
	(69 , happyReduce_69),
	(70 , happyReduce_70),
	(71 , happyReduce_71),
	(72 , happyReduce_72),
	(73 , happyReduce_73),
	(74 , happyReduce_74),
	(75 , happyReduce_75),
	(76 , happyReduce_76),
	(77 , happyReduce_77),
	(78 , happyReduce_78),
	(79 , happyReduce_79),
	(80 , happyReduce_80),
	(81 , happyReduce_81),
	(82 , happyReduce_82),
	(83 , happyReduce_83),
	(84 , happyReduce_84),
	(85 , happyReduce_85),
	(86 , happyReduce_86),
	(87 , happyReduce_87),
	(88 , happyReduce_88),
	(89 , happyReduce_89),
	(90 , happyReduce_90),
	(91 , happyReduce_91),
	(92 , happyReduce_92),
	(93 , happyReduce_93),
	(94 , happyReduce_94),
	(95 , happyReduce_95),
	(96 , happyReduce_96),
	(97 , happyReduce_97),
	(98 , happyReduce_98),
	(99 , happyReduce_99),
	(100 , happyReduce_100),
	(101 , happyReduce_101),
	(102 , happyReduce_102),
	(103 , happyReduce_103),
	(104 , happyReduce_104),
	(105 , happyReduce_105),
	(106 , happyReduce_106),
	(107 , happyReduce_107),
	(108 , happyReduce_108),
	(109 , happyReduce_109),
	(110 , happyReduce_110),
	(111 , happyReduce_111),
	(112 , happyReduce_112),
	(113 , happyReduce_113),
	(114 , happyReduce_114),
	(115 , happyReduce_115),
	(116 , happyReduce_116),
	(117 , happyReduce_117),
	(118 , happyReduce_118),
	(119 , happyReduce_119),
	(120 , happyReduce_120),
	(121 , happyReduce_121),
	(122 , happyReduce_122),
	(123 , happyReduce_123),
	(124 , happyReduce_124),
	(125 , happyReduce_125),
	(126 , happyReduce_126),
	(127 , happyReduce_127),
	(128 , happyReduce_128),
	(129 , happyReduce_129),
	(130 , happyReduce_130),
	(131 , happyReduce_131),
	(132 , happyReduce_132),
	(133 , happyReduce_133),
	(134 , happyReduce_134),
	(135 , happyReduce_135),
	(136 , happyReduce_136),
	(137 , happyReduce_137),
	(138 , happyReduce_138),
	(139 , happyReduce_139),
	(140 , happyReduce_140),
	(141 , happyReduce_141),
	(142 , happyReduce_142),
	(143 , happyReduce_143),
	(144 , happyReduce_144),
	(145 , happyReduce_145),
	(146 , happyReduce_146),
	(147 , happyReduce_147),
	(148 , happyReduce_148),
	(149 , happyReduce_149),
	(150 , happyReduce_150),
	(151 , happyReduce_151),
	(152 , happyReduce_152),
	(153 , happyReduce_153),
	(154 , happyReduce_154),
	(155 , happyReduce_155),
	(156 , happyReduce_156),
	(157 , happyReduce_157),
	(158 , happyReduce_158),
	(159 , happyReduce_159),
	(160 , happyReduce_160),
	(161 , happyReduce_161),
	(162 , happyReduce_162),
	(163 , happyReduce_163),
	(164 , happyReduce_164),
	(165 , happyReduce_165),
	(166 , happyReduce_166),
	(167 , happyReduce_167),
	(168 , happyReduce_168),
	(169 , happyReduce_169),
	(170 , happyReduce_170),
	(171 , happyReduce_171),
	(172 , happyReduce_172),
	(173 , happyReduce_173),
	(174 , happyReduce_174),
	(175 , happyReduce_175),
	(176 , happyReduce_176),
	(177 , happyReduce_177),
	(178 , happyReduce_178),
	(179 , happyReduce_179),
	(180 , happyReduce_180),
	(181 , happyReduce_181),
	(182 , happyReduce_182),
	(183 , happyReduce_183),
	(184 , happyReduce_184),
	(185 , happyReduce_185),
	(186 , happyReduce_186),
	(187 , happyReduce_187),
	(188 , happyReduce_188),
	(189 , happyReduce_189),
	(190 , happyReduce_190),
	(191 , happyReduce_191),
	(192 , happyReduce_192),
	(193 , happyReduce_193),
	(194 , happyReduce_194),
	(195 , happyReduce_195),
	(196 , happyReduce_196),
	(197 , happyReduce_197),
	(198 , happyReduce_198),
	(199 , happyReduce_199),
	(200 , happyReduce_200),
	(201 , happyReduce_201),
	(202 , happyReduce_202),
	(203 , happyReduce_203),
	(204 , happyReduce_204),
	(205 , happyReduce_205),
	(206 , happyReduce_206),
	(207 , happyReduce_207),
	(208 , happyReduce_208),
	(209 , happyReduce_209),
	(210 , happyReduce_210),
	(211 , happyReduce_211),
	(212 , happyReduce_212),
	(213 , happyReduce_213),
	(214 , happyReduce_214),
	(215 , happyReduce_215),
	(216 , happyReduce_216),
	(217 , happyReduce_217),
	(218 , happyReduce_218),
	(219 , happyReduce_219),
	(220 , happyReduce_220),
	(221 , happyReduce_221),
	(222 , happyReduce_222),
	(223 , happyReduce_223),
	(224 , happyReduce_224),
	(225 , happyReduce_225),
	(226 , happyReduce_226),
	(227 , happyReduce_227),
	(228 , happyReduce_228),
	(229 , happyReduce_229),
	(230 , happyReduce_230),
	(231 , happyReduce_231),
	(232 , happyReduce_232),
	(233 , happyReduce_233),
	(234 , happyReduce_234),
	(235 , happyReduce_235),
	(236 , happyReduce_236),
	(237 , happyReduce_237),
	(238 , happyReduce_238),
	(239 , happyReduce_239),
	(240 , happyReduce_240),
	(241 , happyReduce_241),
	(242 , happyReduce_242),
	(243 , happyReduce_243),
	(244 , happyReduce_244),
	(245 , happyReduce_245),
	(246 , happyReduce_246),
	(247 , happyReduce_247),
	(248 , happyReduce_248),
	(249 , happyReduce_249),
	(250 , happyReduce_250),
	(251 , happyReduce_251),
	(252 , happyReduce_252),
	(253 , happyReduce_253),
	(254 , happyReduce_254),
	(255 , happyReduce_255),
	(256 , happyReduce_256),
	(257 , happyReduce_257),
	(258 , happyReduce_258),
	(259 , happyReduce_259),
	(260 , happyReduce_260),
	(261 , happyReduce_261),
	(262 , happyReduce_262),
	(263 , happyReduce_263),
	(264 , happyReduce_264),
	(265 , happyReduce_265),
	(266 , happyReduce_266),
	(267 , happyReduce_267),
	(268 , happyReduce_268),
	(269 , happyReduce_269),
	(270 , happyReduce_270),
	(271 , happyReduce_271),
	(272 , happyReduce_272),
	(273 , happyReduce_273),
	(274 , happyReduce_274),
	(275 , happyReduce_275),
	(276 , happyReduce_276),
	(277 , happyReduce_277),
	(278 , happyReduce_278),
	(279 , happyReduce_279),
	(280 , happyReduce_280),
	(281 , happyReduce_281),
	(282 , happyReduce_282),
	(283 , happyReduce_283),
	(284 , happyReduce_284),
	(285 , happyReduce_285),
	(286 , happyReduce_286),
	(287 , happyReduce_287),
	(288 , happyReduce_288),
	(289 , happyReduce_289),
	(290 , happyReduce_290),
	(291 , happyReduce_291),
	(292 , happyReduce_292),
	(293 , happyReduce_293),
	(294 , happyReduce_294),
	(295 , happyReduce_295),
	(296 , happyReduce_296),
	(297 , happyReduce_297),
	(298 , happyReduce_298),
	(299 , happyReduce_299),
	(300 , happyReduce_300),
	(301 , happyReduce_301),
	(302 , happyReduce_302),
	(303 , happyReduce_303),
	(304 , happyReduce_304),
	(305 , happyReduce_305),
	(306 , happyReduce_306),
	(307 , happyReduce_307),
	(308 , happyReduce_308),
	(309 , happyReduce_309),
	(310 , happyReduce_310),
	(311 , happyReduce_311),
	(312 , happyReduce_312),
	(313 , happyReduce_313),
	(314 , happyReduce_314),
	(315 , happyReduce_315),
	(316 , happyReduce_316),
	(317 , happyReduce_317),
	(318 , happyReduce_318),
	(319 , happyReduce_319),
	(320 , happyReduce_320),
	(321 , happyReduce_321),
	(322 , happyReduce_322),
	(323 , happyReduce_323),
	(324 , happyReduce_324),
	(325 , happyReduce_325),
	(326 , happyReduce_326),
	(327 , happyReduce_327),
	(328 , happyReduce_328),
	(329 , happyReduce_329),
	(330 , happyReduce_330),
	(331 , happyReduce_331),
	(332 , happyReduce_332),
	(333 , happyReduce_333),
	(334 , happyReduce_334),
	(335 , happyReduce_335),
	(336 , happyReduce_336),
	(337 , happyReduce_337),
	(338 , happyReduce_338),
	(339 , happyReduce_339),
	(340 , happyReduce_340),
	(341 , happyReduce_341),
	(342 , happyReduce_342),
	(343 , happyReduce_343),
	(344 , happyReduce_344),
	(345 , happyReduce_345),
	(346 , happyReduce_346),
	(347 , happyReduce_347),
	(348 , happyReduce_348),
	(349 , happyReduce_349),
	(350 , happyReduce_350),
	(351 , happyReduce_351),
	(352 , happyReduce_352),
	(353 , happyReduce_353),
	(354 , happyReduce_354),
	(355 , happyReduce_355),
	(356 , happyReduce_356),
	(357 , happyReduce_357),
	(358 , happyReduce_358),
	(359 , happyReduce_359),
	(360 , happyReduce_360),
	(361 , happyReduce_361),
	(362 , happyReduce_362),
	(363 , happyReduce_363),
	(364 , happyReduce_364),
	(365 , happyReduce_365),
	(366 , happyReduce_366),
	(367 , happyReduce_367),
	(368 , happyReduce_368),
	(369 , happyReduce_369),
	(370 , happyReduce_370),
	(371 , happyReduce_371),
	(372 , happyReduce_372),
	(373 , happyReduce_373),
	(374 , happyReduce_374),
	(375 , happyReduce_375),
	(376 , happyReduce_376),
	(377 , happyReduce_377),
	(378 , happyReduce_378),
	(379 , happyReduce_379),
	(380 , happyReduce_380),
	(381 , happyReduce_381),
	(382 , happyReduce_382),
	(383 , happyReduce_383),
	(384 , happyReduce_384),
	(385 , happyReduce_385),
	(386 , happyReduce_386),
	(387 , happyReduce_387),
	(388 , happyReduce_388),
	(389 , happyReduce_389),
	(390 , happyReduce_390),
	(391 , happyReduce_391),
	(392 , happyReduce_392),
	(393 , happyReduce_393),
	(394 , happyReduce_394),
	(395 , happyReduce_395),
	(396 , happyReduce_396),
	(397 , happyReduce_397),
	(398 , happyReduce_398),
	(399 , happyReduce_399),
	(400 , happyReduce_400),
	(401 , happyReduce_401),
	(402 , happyReduce_402),
	(403 , happyReduce_403),
	(404 , happyReduce_404),
	(405 , happyReduce_405),
	(406 , happyReduce_406),
	(407 , happyReduce_407),
	(408 , happyReduce_408),
	(409 , happyReduce_409),
	(410 , happyReduce_410),
	(411 , happyReduce_411),
	(412 , happyReduce_412),
	(413 , happyReduce_413),
	(414 , happyReduce_414),
	(415 , happyReduce_415),
	(416 , happyReduce_416),
	(417 , happyReduce_417),
	(418 , happyReduce_418),
	(419 , happyReduce_419),
	(420 , happyReduce_420),
	(421 , happyReduce_421),
	(422 , happyReduce_422),
	(423 , happyReduce_423),
	(424 , happyReduce_424),
	(425 , happyReduce_425),
	(426 , happyReduce_426),
	(427 , happyReduce_427),
	(428 , happyReduce_428),
	(429 , happyReduce_429),
	(430 , happyReduce_430),
	(431 , happyReduce_431),
	(432 , happyReduce_432),
	(433 , happyReduce_433),
	(434 , happyReduce_434),
	(435 , happyReduce_435),
	(436 , happyReduce_436),
	(437 , happyReduce_437),
	(438 , happyReduce_438),
	(439 , happyReduce_439),
	(440 , happyReduce_440),
	(441 , happyReduce_441),
	(442 , happyReduce_442),
	(443 , happyReduce_443),
	(444 , happyReduce_444),
	(445 , happyReduce_445),
	(446 , happyReduce_446),
	(447 , happyReduce_447),
	(448 , happyReduce_448),
	(449 , happyReduce_449),
	(450 , happyReduce_450),
	(451 , happyReduce_451),
	(452 , happyReduce_452),
	(453 , happyReduce_453),
	(454 , happyReduce_454),
	(455 , happyReduce_455),
	(456 , happyReduce_456),
	(457 , happyReduce_457),
	(458 , happyReduce_458),
	(459 , happyReduce_459),
	(460 , happyReduce_460),
	(461 , happyReduce_461),
	(462 , happyReduce_462),
	(463 , happyReduce_463),
	(464 , happyReduce_464),
	(465 , happyReduce_465),
	(466 , happyReduce_466),
	(467 , happyReduce_467),
	(468 , happyReduce_468),
	(469 , happyReduce_469),
	(470 , happyReduce_470),
	(471 , happyReduce_471),
	(472 , happyReduce_472),
	(473 , happyReduce_473),
	(474 , happyReduce_474),
	(475 , happyReduce_475),
	(476 , happyReduce_476),
	(477 , happyReduce_477),
	(478 , happyReduce_478),
	(479 , happyReduce_479),
	(480 , happyReduce_480),
	(481 , happyReduce_481),
	(482 , happyReduce_482),
	(483 , happyReduce_483),
	(484 , happyReduce_484),
	(485 , happyReduce_485),
	(486 , happyReduce_486),
	(487 , happyReduce_487),
	(488 , happyReduce_488),
	(489 , happyReduce_489),
	(490 , happyReduce_490),
	(491 , happyReduce_491),
	(492 , happyReduce_492),
	(493 , happyReduce_493),
	(494 , happyReduce_494),
	(495 , happyReduce_495),
	(496 , happyReduce_496),
	(497 , happyReduce_497),
	(498 , happyReduce_498),
	(499 , happyReduce_499),
	(500 , happyReduce_500),
	(501 , happyReduce_501),
	(502 , happyReduce_502),
	(503 , happyReduce_503),
	(504 , happyReduce_504),
	(505 , happyReduce_505),
	(506 , happyReduce_506),
	(507 , happyReduce_507),
	(508 , happyReduce_508),
	(509 , happyReduce_509),
	(510 , happyReduce_510),
	(511 , happyReduce_511),
	(512 , happyReduce_512),
	(513 , happyReduce_513),
	(514 , happyReduce_514),
	(515 , happyReduce_515),
	(516 , happyReduce_516),
	(517 , happyReduce_517),
	(518 , happyReduce_518)
	]

happy_n_terms = 111 :: Int
happy_n_nonterms = 173 :: Int

happyReduce_7 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_7 = happySpecReduce_1  0# happyReduction_7
happyReduction_7 happy_x_1
	 =  case happyOut11 happy_x_1 of { happy_var_1 -> 
	happyIn10
		 (reverse happy_var_1
	)}

happyReduce_8 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_8 = happySpecReduce_2  1# happyReduction_8
happyReduction_8 happy_x_2
	happy_x_1
	 =  case happyOut11 happy_x_1 of { happy_var_1 -> 
	case happyOut12 happy_x_2 of { happy_var_2 -> 
	happyIn11
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_9 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_9 = happySpecReduce_0  1# happyReduction_9
happyReduction_9  =  happyIn11
		 ([]
	)

happyReduce_10 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_10 = happySpecReduce_1  2# happyReduction_10
happyReduction_10 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwAbstract happy_var_1) -> 
	happyIn12
		 (TokKeyword KwAbstract happy_var_1
	)}

happyReduce_11 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_11 = happySpecReduce_1  2# happyReduction_11
happyReduction_11 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCoData happy_var_1) -> 
	happyIn12
		 (TokKeyword KwCoData happy_var_1
	)}

happyReduce_12 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_12 = happySpecReduce_1  2# happyReduction_12
happyReduction_12 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCoInductive happy_var_1) -> 
	happyIn12
		 (TokKeyword KwCoInductive happy_var_1
	)}

happyReduce_13 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_13 = happySpecReduce_1  2# happyReduction_13
happyReduction_13 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwConstructor happy_var_1) -> 
	happyIn12
		 (TokKeyword KwConstructor happy_var_1
	)}

happyReduce_14 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_14 = happySpecReduce_1  2# happyReduction_14
happyReduction_14 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwData happy_var_1) -> 
	happyIn12
		 (TokKeyword KwData happy_var_1
	)}

happyReduce_15 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_15 = happySpecReduce_1  2# happyReduction_15
happyReduction_15 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwEta happy_var_1) -> 
	happyIn12
		 (TokKeyword KwEta happy_var_1
	)}

happyReduce_16 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_16 = happySpecReduce_1  2# happyReduction_16
happyReduction_16 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwField happy_var_1) -> 
	happyIn12
		 (TokKeyword KwField happy_var_1
	)}

happyReduce_17 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_17 = happySpecReduce_1  2# happyReduction_17
happyReduction_17 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwForall happy_var_1) -> 
	happyIn12
		 (TokKeyword KwForall happy_var_1
	)}

happyReduce_18 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_18 = happySpecReduce_1  2# happyReduction_18
happyReduction_18 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwHiding happy_var_1) -> 
	happyIn12
		 (TokKeyword KwHiding happy_var_1
	)}

happyReduce_19 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_19 = happySpecReduce_1  2# happyReduction_19
happyReduction_19 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwImport happy_var_1) -> 
	happyIn12
		 (TokKeyword KwImport happy_var_1
	)}

happyReduce_20 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_20 = happySpecReduce_1  2# happyReduction_20
happyReduction_20 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwIn happy_var_1) -> 
	happyIn12
		 (TokKeyword KwIn happy_var_1
	)}

happyReduce_21 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_21 = happySpecReduce_1  2# happyReduction_21
happyReduction_21 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInductive happy_var_1) -> 
	happyIn12
		 (TokKeyword KwInductive happy_var_1
	)}

happyReduce_22 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_22 = happySpecReduce_1  2# happyReduction_22
happyReduction_22 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfix happy_var_1) -> 
	happyIn12
		 (TokKeyword KwInfix happy_var_1
	)}

happyReduce_23 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_23 = happySpecReduce_1  2# happyReduction_23
happyReduction_23 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfixL happy_var_1) -> 
	happyIn12
		 (TokKeyword KwInfixL happy_var_1
	)}

happyReduce_24 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_24 = happySpecReduce_1  2# happyReduction_24
happyReduction_24 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfixR happy_var_1) -> 
	happyIn12
		 (TokKeyword KwInfixR happy_var_1
	)}

happyReduce_25 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_25 = happySpecReduce_1  2# happyReduction_25
happyReduction_25 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInstance happy_var_1) -> 
	happyIn12
		 (TokKeyword KwInstance happy_var_1
	)}

happyReduce_26 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_26 = happySpecReduce_1  2# happyReduction_26
happyReduction_26 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwOverlap happy_var_1) -> 
	happyIn12
		 (TokKeyword KwOverlap happy_var_1
	)}

happyReduce_27 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_27 = happySpecReduce_1  2# happyReduction_27
happyReduction_27 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwLet happy_var_1) -> 
	happyIn12
		 (TokKeyword KwLet happy_var_1
	)}

happyReduce_28 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_28 = happySpecReduce_1  2# happyReduction_28
happyReduction_28 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwMacro happy_var_1) -> 
	happyIn12
		 (TokKeyword KwMacro happy_var_1
	)}

happyReduce_29 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_29 = happySpecReduce_1  2# happyReduction_29
happyReduction_29 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwModule happy_var_1) -> 
	happyIn12
		 (TokKeyword KwModule happy_var_1
	)}

happyReduce_30 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_30 = happySpecReduce_1  2# happyReduction_30
happyReduction_30 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwMutual happy_var_1) -> 
	happyIn12
		 (TokKeyword KwMutual happy_var_1
	)}

happyReduce_31 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_31 = happySpecReduce_1  2# happyReduction_31
happyReduction_31 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNoEta happy_var_1) -> 
	happyIn12
		 (TokKeyword KwNoEta happy_var_1
	)}

happyReduce_32 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_32 = happySpecReduce_1  2# happyReduction_32
happyReduction_32 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwOpen happy_var_1) -> 
	happyIn12
		 (TokKeyword KwOpen happy_var_1
	)}

happyReduce_33 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_33 = happySpecReduce_1  2# happyReduction_33
happyReduction_33 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPatternSyn happy_var_1) -> 
	happyIn12
		 (TokKeyword KwPatternSyn happy_var_1
	)}

happyReduce_34 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_34 = happySpecReduce_1  2# happyReduction_34
happyReduction_34 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPostulate happy_var_1) -> 
	happyIn12
		 (TokKeyword KwPostulate happy_var_1
	)}

happyReduce_35 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_35 = happySpecReduce_1  2# happyReduction_35
happyReduction_35 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPrimitive happy_var_1) -> 
	happyIn12
		 (TokKeyword KwPrimitive happy_var_1
	)}

happyReduce_36 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_36 = happySpecReduce_1  2# happyReduction_36
happyReduction_36 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPrivate happy_var_1) -> 
	happyIn12
		 (TokKeyword KwPrivate happy_var_1
	)}

happyReduce_37 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_37 = happySpecReduce_1  2# happyReduction_37
happyReduction_37 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwProp happy_var_1) -> 
	happyIn12
		 (TokKeyword KwProp happy_var_1
	)}

happyReduce_38 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_38 = happySpecReduce_1  2# happyReduction_38
happyReduction_38 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPublic happy_var_1) -> 
	happyIn12
		 (TokKeyword KwPublic happy_var_1
	)}

happyReduce_39 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_39 = happySpecReduce_1  2# happyReduction_39
happyReduction_39 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuote happy_var_1) -> 
	happyIn12
		 (TokKeyword KwQuote happy_var_1
	)}

happyReduce_40 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_40 = happySpecReduce_1  2# happyReduction_40
happyReduction_40 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuoteContext happy_var_1) -> 
	happyIn12
		 (TokKeyword KwQuoteContext happy_var_1
	)}

happyReduce_41 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_41 = happySpecReduce_1  2# happyReduction_41
happyReduction_41 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuoteGoal happy_var_1) -> 
	happyIn12
		 (TokKeyword KwQuoteGoal happy_var_1
	)}

happyReduce_42 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_42 = happySpecReduce_1  2# happyReduction_42
happyReduction_42 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuoteTerm happy_var_1) -> 
	happyIn12
		 (TokKeyword KwQuoteTerm happy_var_1
	)}

happyReduce_43 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_43 = happySpecReduce_1  2# happyReduction_43
happyReduction_43 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	happyIn12
		 (TokKeyword KwRecord happy_var_1
	)}

happyReduce_44 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_44 = happySpecReduce_1  2# happyReduction_44
happyReduction_44 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwRenaming happy_var_1) -> 
	happyIn12
		 (TokKeyword KwRenaming happy_var_1
	)}

happyReduce_45 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_45 = happySpecReduce_1  2# happyReduction_45
happyReduction_45 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwRewrite happy_var_1) -> 
	happyIn12
		 (TokKeyword KwRewrite happy_var_1
	)}

happyReduce_46 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_46 = happySpecReduce_1  2# happyReduction_46
happyReduction_46 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwSet happy_var_1) -> 
	happyIn12
		 (TokKeyword KwSet happy_var_1
	)}

happyReduce_47 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_47 = happySpecReduce_1  2# happyReduction_47
happyReduction_47 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwSyntax happy_var_1) -> 
	happyIn12
		 (TokKeyword KwSyntax happy_var_1
	)}

happyReduce_48 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_48 = happySpecReduce_1  2# happyReduction_48
happyReduction_48 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwTactic happy_var_1) -> 
	happyIn12
		 (TokKeyword KwTactic happy_var_1
	)}

happyReduce_49 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_49 = happySpecReduce_1  2# happyReduction_49
happyReduction_49 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwTo happy_var_1) -> 
	happyIn12
		 (TokKeyword KwTo happy_var_1
	)}

happyReduce_50 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_50 = happySpecReduce_1  2# happyReduction_50
happyReduction_50 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUnquote happy_var_1) -> 
	happyIn12
		 (TokKeyword KwUnquote happy_var_1
	)}

happyReduce_51 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_51 = happySpecReduce_1  2# happyReduction_51
happyReduction_51 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUnquoteDecl happy_var_1) -> 
	happyIn12
		 (TokKeyword KwUnquoteDecl happy_var_1
	)}

happyReduce_52 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_52 = happySpecReduce_1  2# happyReduction_52
happyReduction_52 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUnquoteDef happy_var_1) -> 
	happyIn12
		 (TokKeyword KwUnquoteDef happy_var_1
	)}

happyReduce_53 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_53 = happySpecReduce_1  2# happyReduction_53
happyReduction_53 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUsing happy_var_1) -> 
	happyIn12
		 (TokKeyword KwUsing happy_var_1
	)}

happyReduce_54 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_54 = happySpecReduce_1  2# happyReduction_54
happyReduction_54 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwWhere happy_var_1) -> 
	happyIn12
		 (TokKeyword KwWhere happy_var_1
	)}

happyReduce_55 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_55 = happySpecReduce_1  2# happyReduction_55
happyReduction_55 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwDo happy_var_1) -> 
	happyIn12
		 (TokKeyword KwDo happy_var_1
	)}

happyReduce_56 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_56 = happySpecReduce_1  2# happyReduction_56
happyReduction_56 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwWith happy_var_1) -> 
	happyIn12
		 (TokKeyword KwWith happy_var_1
	)}

happyReduce_57 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_57 = happySpecReduce_1  2# happyReduction_57
happyReduction_57 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwBUILTIN happy_var_1) -> 
	happyIn12
		 (TokKeyword KwBUILTIN happy_var_1
	)}

happyReduce_58 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_58 = happySpecReduce_1  2# happyReduction_58
happyReduction_58 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCATCHALL happy_var_1) -> 
	happyIn12
		 (TokKeyword KwCATCHALL happy_var_1
	)}

happyReduce_59 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_59 = happySpecReduce_1  2# happyReduction_59
happyReduction_59 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED happy_var_1) -> 
	happyIn12
		 (TokKeyword KwCOMPILED happy_var_1
	)}

happyReduce_60 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_60 = happySpecReduce_1  2# happyReduction_60
happyReduction_60 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED_DATA happy_var_1) -> 
	happyIn12
		 (TokKeyword KwCOMPILED_DATA happy_var_1
	)}

happyReduce_61 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_61 = happySpecReduce_1  2# happyReduction_61
happyReduction_61 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED_DATA_UHC happy_var_1) -> 
	happyIn12
		 (TokKeyword KwCOMPILED_DATA_UHC happy_var_1
	)}

happyReduce_62 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_62 = happySpecReduce_1  2# happyReduction_62
happyReduction_62 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED_EXPORT happy_var_1) -> 
	happyIn12
		 (TokKeyword KwCOMPILED_EXPORT happy_var_1
	)}

happyReduce_63 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_63 = happySpecReduce_1  2# happyReduction_63
happyReduction_63 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED_JS happy_var_1) -> 
	happyIn12
		 (TokKeyword KwCOMPILED_JS happy_var_1
	)}

happyReduce_64 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_64 = happySpecReduce_1  2# happyReduction_64
happyReduction_64 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED_TYPE happy_var_1) -> 
	happyIn12
		 (TokKeyword KwCOMPILED_TYPE happy_var_1
	)}

happyReduce_65 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_65 = happySpecReduce_1  2# happyReduction_65
happyReduction_65 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED_UHC happy_var_1) -> 
	happyIn12
		 (TokKeyword KwCOMPILED_UHC happy_var_1
	)}

happyReduce_66 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_66 = happySpecReduce_1  2# happyReduction_66
happyReduction_66 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwDISPLAY happy_var_1) -> 
	happyIn12
		 (TokKeyword KwDISPLAY happy_var_1
	)}

happyReduce_67 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_67 = happySpecReduce_1  2# happyReduction_67
happyReduction_67 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwETA happy_var_1) -> 
	happyIn12
		 (TokKeyword KwETA happy_var_1
	)}

happyReduce_68 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_68 = happySpecReduce_1  2# happyReduction_68
happyReduction_68 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwHASKELL happy_var_1) -> 
	happyIn12
		 (TokKeyword KwHASKELL happy_var_1
	)}

happyReduce_69 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_69 = happySpecReduce_1  2# happyReduction_69
happyReduction_69 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwIMPORT happy_var_1) -> 
	happyIn12
		 (TokKeyword KwIMPORT happy_var_1
	)}

happyReduce_70 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_70 = happySpecReduce_1  2# happyReduction_70
happyReduction_70 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwIMPORT_UHC happy_var_1) -> 
	happyIn12
		 (TokKeyword KwIMPORT_UHC happy_var_1
	)}

happyReduce_71 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_71 = happySpecReduce_1  2# happyReduction_71
happyReduction_71 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwFOREIGN happy_var_1) -> 
	happyIn12
		 (TokKeyword KwFOREIGN happy_var_1
	)}

happyReduce_72 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_72 = happySpecReduce_1  2# happyReduction_72
happyReduction_72 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILE happy_var_1) -> 
	happyIn12
		 (TokKeyword KwCOMPILE happy_var_1
	)}

happyReduce_73 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_73 = happySpecReduce_1  2# happyReduction_73
happyReduction_73 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwIMPOSSIBLE happy_var_1) -> 
	happyIn12
		 (TokKeyword KwIMPOSSIBLE happy_var_1
	)}

happyReduce_74 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_74 = happySpecReduce_1  2# happyReduction_74
happyReduction_74 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwINJECTIVE happy_var_1) -> 
	happyIn12
		 (TokKeyword KwINJECTIVE happy_var_1
	)}

happyReduce_75 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_75 = happySpecReduce_1  2# happyReduction_75
happyReduction_75 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwINLINE happy_var_1) -> 
	happyIn12
		 (TokKeyword KwINLINE happy_var_1
	)}

happyReduce_76 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_76 = happySpecReduce_1  2# happyReduction_76
happyReduction_76 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNOINLINE happy_var_1) -> 
	happyIn12
		 (TokKeyword KwNOINLINE happy_var_1
	)}

happyReduce_77 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_77 = happySpecReduce_1  2# happyReduction_77
happyReduction_77 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwMEASURE happy_var_1) -> 
	happyIn12
		 (TokKeyword KwMEASURE happy_var_1
	)}

happyReduce_78 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_78 = happySpecReduce_1  2# happyReduction_78
happyReduction_78 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNO_TERMINATION_CHECK happy_var_1) -> 
	happyIn12
		 (TokKeyword KwNO_TERMINATION_CHECK happy_var_1
	)}

happyReduce_79 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_79 = happySpecReduce_1  2# happyReduction_79
happyReduction_79 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNO_POSITIVITY_CHECK happy_var_1) -> 
	happyIn12
		 (TokKeyword KwNO_POSITIVITY_CHECK happy_var_1
	)}

happyReduce_80 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_80 = happySpecReduce_1  2# happyReduction_80
happyReduction_80 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNON_TERMINATING happy_var_1) -> 
	happyIn12
		 (TokKeyword KwNON_TERMINATING happy_var_1
	)}

happyReduce_81 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_81 = happySpecReduce_1  2# happyReduction_81
happyReduction_81 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwOPTIONS happy_var_1) -> 
	happyIn12
		 (TokKeyword KwOPTIONS happy_var_1
	)}

happyReduce_82 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_82 = happySpecReduce_1  2# happyReduction_82
happyReduction_82 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPOLARITY happy_var_1) -> 
	happyIn12
		 (TokKeyword KwPOLARITY happy_var_1
	)}

happyReduce_83 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_83 = happySpecReduce_1  2# happyReduction_83
happyReduction_83 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwREWRITE happy_var_1) -> 
	happyIn12
		 (TokKeyword KwREWRITE happy_var_1
	)}

happyReduce_84 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_84 = happySpecReduce_1  2# happyReduction_84
happyReduction_84 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwSTATIC happy_var_1) -> 
	happyIn12
		 (TokKeyword KwSTATIC happy_var_1
	)}

happyReduce_85 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_85 = happySpecReduce_1  2# happyReduction_85
happyReduction_85 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwTERMINATING happy_var_1) -> 
	happyIn12
		 (TokKeyword KwTERMINATING happy_var_1
	)}

happyReduce_86 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_86 = happySpecReduce_1  2# happyReduction_86
happyReduction_86 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwWARNING_ON_USAGE happy_var_1) -> 
	happyIn12
		 (TokKeyword KwWARNING_ON_USAGE happy_var_1
	)}

happyReduce_87 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_87 = happySpecReduce_1  2# happyReduction_87
happyReduction_87 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSetN happy_var_1) -> 
	happyIn12
		 (TokSetN happy_var_1
	)}

happyReduce_88 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_88 = happySpecReduce_1  2# happyReduction_88
happyReduction_88 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokTeX happy_var_1) -> 
	happyIn12
		 (TokTeX happy_var_1
	)}

happyReduce_89 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_89 = happySpecReduce_1  2# happyReduction_89
happyReduction_89 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokComment happy_var_1) -> 
	happyIn12
		 (TokComment happy_var_1
	)}

happyReduce_90 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_90 = happySpecReduce_1  2# happyReduction_90
happyReduction_90 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymEllipsis happy_var_1) -> 
	happyIn12
		 (TokSymbol SymEllipsis happy_var_1
	)}

happyReduce_91 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_91 = happySpecReduce_1  2# happyReduction_91
happyReduction_91 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDotDot happy_var_1) -> 
	happyIn12
		 (TokSymbol SymDotDot happy_var_1
	)}

happyReduce_92 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_92 = happySpecReduce_1  2# happyReduction_92
happyReduction_92 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDot happy_var_1) -> 
	happyIn12
		 (TokSymbol SymDot happy_var_1
	)}

happyReduce_93 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_93 = happySpecReduce_1  2# happyReduction_93
happyReduction_93 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymSemi happy_var_1) -> 
	happyIn12
		 (TokSymbol SymSemi happy_var_1
	)}

happyReduce_94 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_94 = happySpecReduce_1  2# happyReduction_94
happyReduction_94 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymColon happy_var_1) -> 
	happyIn12
		 (TokSymbol SymColon happy_var_1
	)}

happyReduce_95 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_95 = happySpecReduce_1  2# happyReduction_95
happyReduction_95 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymEqual happy_var_1) -> 
	happyIn12
		 (TokSymbol SymEqual happy_var_1
	)}

happyReduce_96 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_96 = happySpecReduce_1  2# happyReduction_96
happyReduction_96 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymUnderscore happy_var_1) -> 
	happyIn12
		 (TokSymbol SymUnderscore happy_var_1
	)}

happyReduce_97 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_97 = happySpecReduce_1  2# happyReduction_97
happyReduction_97 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymQuestionMark happy_var_1) -> 
	happyIn12
		 (TokSymbol SymQuestionMark happy_var_1
	)}

happyReduce_98 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_98 = happySpecReduce_1  2# happyReduction_98
happyReduction_98 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymArrow happy_var_1) -> 
	happyIn12
		 (TokSymbol SymArrow happy_var_1
	)}

happyReduce_99 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_99 = happySpecReduce_1  2# happyReduction_99
happyReduction_99 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymLambda happy_var_1) -> 
	happyIn12
		 (TokSymbol SymLambda happy_var_1
	)}

happyReduce_100 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_100 = happySpecReduce_1  2# happyReduction_100
happyReduction_100 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymAs happy_var_1) -> 
	happyIn12
		 (TokSymbol SymAs happy_var_1
	)}

happyReduce_101 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_101 = happySpecReduce_1  2# happyReduction_101
happyReduction_101 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymBar happy_var_1) -> 
	happyIn12
		 (TokSymbol SymBar happy_var_1
	)}

happyReduce_102 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_102 = happySpecReduce_1  2# happyReduction_102
happyReduction_102 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	happyIn12
		 (TokSymbol SymOpenParen happy_var_1
	)}

happyReduce_103 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_103 = happySpecReduce_1  2# happyReduction_103
happyReduction_103 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymCloseParen happy_var_1) -> 
	happyIn12
		 (TokSymbol SymCloseParen happy_var_1
	)}

happyReduce_104 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_104 = happySpecReduce_1  2# happyReduction_104
happyReduction_104 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenIdiomBracket happy_var_1) -> 
	happyIn12
		 (TokSymbol SymOpenIdiomBracket happy_var_1
	)}

happyReduce_105 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_105 = happySpecReduce_1  2# happyReduction_105
happyReduction_105 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymCloseIdiomBracket happy_var_1) -> 
	happyIn12
		 (TokSymbol SymCloseIdiomBracket happy_var_1
	)}

happyReduce_106 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_106 = happySpecReduce_1  2# happyReduction_106
happyReduction_106 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleOpenBrace happy_var_1) -> 
	happyIn12
		 (TokSymbol SymDoubleOpenBrace happy_var_1
	)}

happyReduce_107 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_107 = happySpecReduce_1  2# happyReduction_107
happyReduction_107 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleCloseBrace happy_var_1) -> 
	happyIn12
		 (TokSymbol SymDoubleCloseBrace happy_var_1
	)}

happyReduce_108 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_108 = happySpecReduce_1  2# happyReduction_108
happyReduction_108 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenBrace happy_var_1) -> 
	happyIn12
		 (TokSymbol SymOpenBrace happy_var_1
	)}

happyReduce_109 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_109 = happySpecReduce_1  2# happyReduction_109
happyReduction_109 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymCloseBrace happy_var_1) -> 
	happyIn12
		 (TokSymbol SymCloseBrace happy_var_1
	)}

happyReduce_110 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_110 = happySpecReduce_1  2# happyReduction_110
happyReduction_110 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenVirtualBrace happy_var_1) -> 
	happyIn12
		 (TokSymbol SymOpenVirtualBrace happy_var_1
	)}

happyReduce_111 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_111 = happySpecReduce_1  2# happyReduction_111
happyReduction_111 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymCloseVirtualBrace happy_var_1) -> 
	happyIn12
		 (TokSymbol SymCloseVirtualBrace happy_var_1
	)}

happyReduce_112 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_112 = happySpecReduce_1  2# happyReduction_112
happyReduction_112 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymVirtualSemi happy_var_1) -> 
	happyIn12
		 (TokSymbol SymVirtualSemi happy_var_1
	)}

happyReduce_113 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_113 = happySpecReduce_1  2# happyReduction_113
happyReduction_113 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	happyIn12
		 (TokSymbol SymOpenPragma happy_var_1
	)}

happyReduce_114 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_114 = happySpecReduce_1  2# happyReduction_114
happyReduction_114 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymClosePragma happy_var_1) -> 
	happyIn12
		 (TokSymbol SymClosePragma happy_var_1
	)}

happyReduce_115 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_115 = happySpecReduce_1  2# happyReduction_115
happyReduction_115 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokId happy_var_1) -> 
	happyIn12
		 (TokId happy_var_1
	)}

happyReduce_116 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_116 = happySpecReduce_1  2# happyReduction_116
happyReduction_116 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokQId happy_var_1) -> 
	happyIn12
		 (TokQId happy_var_1
	)}

happyReduce_117 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_117 = happySpecReduce_1  2# happyReduction_117
happyReduction_117 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	happyIn12
		 (TokString happy_var_1
	)}

happyReduce_118 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_118 = happySpecReduce_1  2# happyReduction_118
happyReduction_118 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokLiteral happy_var_1) -> 
	happyIn12
		 (TokLiteral happy_var_1
	)}

happyReduce_119 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_119 = happySpecReduce_3  3# happyReduction_119
happyReduction_119 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut135 happy_x_2 of { happy_var_2 -> 
	happyIn13
		 (takeOptionsPragmas happy_var_2
	)}

happyReduce_120 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_120 = happySpecReduce_0  4# happyReduction_120
happyReduction_120  =  happyIn14
		 (()
	)

happyReduce_121 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_121 = happySpecReduce_1  4# happyReduction_121
happyReduction_121 happy_x_1
	 =  happyIn14
		 (()
	)

happyReduce_122 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_122 = happySpecReduce_1  5# happyReduction_122
happyReduction_122 happy_x_1
	 =  happyIn15
		 (()
	)

happyReduce_123 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_123 = happyMonadReduce 1# 5# happyReduction_123
happyReduction_123 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((( popContext))
	) (\r -> happyReturn (happyIn15 r))

happyReduce_124 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_124 = happySpecReduce_1  6# happyReduction_124
happyReduction_124 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymSemi happy_var_1) -> 
	happyIn16
		 (happy_var_1
	)}

happyReduce_125 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_125 = happySpecReduce_1  6# happyReduction_125
happyReduction_125 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymVirtualSemi happy_var_1) -> 
	happyIn16
		 (happy_var_1
	)}

happyReduce_126 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_126 = happyMonadReduce 0# 7# happyReduction_126
happyReduction_126 (happyRest) tk
	 = happyThen ((( pushLexState imp_dir))
	) (\r -> happyReturn (happyIn17 r))

happyReduce_127 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_127 = happyMonadReduce 1# 8# happyReduction_127
happyReduction_127 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokLiteral happy_var_1) -> 
	( case happy_var_1 of {
                     LitNat _ i -> return i;
                     _          -> fail $ "Expected integer"
                   })})
	) (\r -> happyReturn (happyIn18 r))

happyReduce_128 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_128 = happyMonadReduce 1# 9# happyReduction_128
happyReduction_128 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokId happy_var_1) -> 
	( mkName happy_var_1)})
	) (\r -> happyReturn (happyIn19 r))

happyReduce_129 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_129 = happySpecReduce_2  10# happyReduction_129
happyReduction_129 happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_1 of { happy_var_1 -> 
	case happyOut20 happy_x_2 of { happy_var_2 -> 
	happyIn20
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_130 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_130 = happySpecReduce_1  10# happyReduction_130
happyReduction_130 happy_x_1
	 =  case happyOut19 happy_x_1 of { happy_var_1 -> 
	happyIn20
		 ([happy_var_1]
	)}

happyReduce_131 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_131 = happySpecReduce_1  11# happyReduction_131
happyReduction_131 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleCloseBrace happy_var_1) -> 
	happyIn21
		 (getRange happy_var_1
	)}

happyReduce_132 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_132 = happyMonadReduce 2# 11# happyReduction_132
happyReduction_132 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokSymbol SymCloseBrace happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymCloseBrace happy_var_2) -> 
	(
      if posPos (fromJust (rEnd' (getRange happy_var_2))) -
         posPos (fromJust (rStart' (getRange happy_var_1))) > 2
      then parseErrorAt (fromJust (rStart' (getRange happy_var_2)))
         "Expecting '}}', found separated '}'s."
      else return $ getRange (happy_var_1, happy_var_2))}})
	) (\r -> happyReturn (happyIn21 r))

happyReduce_133 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_133 = happySpecReduce_2  12# happyReduction_133
happyReduction_133 happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_2 of { happy_var_2 -> 
	happyIn22
		 (setRelevance NonStrict $ defaultArg happy_var_2
	)}

happyReduce_134 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_134 = happySpecReduce_2  12# happyReduction_134
happyReduction_134 happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_2 of { happy_var_2 -> 
	happyIn22
		 (setRelevance Irrelevant $ defaultArg happy_var_2
	)}

happyReduce_135 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_135 = happySpecReduce_1  12# happyReduction_135
happyReduction_135 happy_x_1
	 =  case happyOut19 happy_x_1 of { happy_var_1 -> 
	happyIn22
		 (defaultArg happy_var_1
	)}

happyReduce_136 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_136 = happySpecReduce_2  13# happyReduction_136
happyReduction_136 happy_x_2
	happy_x_1
	 =  case happyOut22 happy_x_1 of { happy_var_1 -> 
	case happyOut23 happy_x_2 of { happy_var_2 -> 
	happyIn23
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_137 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_137 = happySpecReduce_1  13# happyReduction_137
happyReduction_137 happy_x_1
	 =  case happyOut22 happy_x_1 of { happy_var_1 -> 
	happyIn23
		 ([happy_var_1]
	)}

happyReduce_138 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_138 = happySpecReduce_2  14# happyReduction_138
happyReduction_138 happy_x_2
	happy_x_1
	 =  case happyOut22 happy_x_1 of { happy_var_1 -> 
	case happyOut24 happy_x_2 of { happy_var_2 -> 
	happyIn24
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_139 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_139 = happySpecReduce_1  14# happyReduction_139
happyReduction_139 happy_x_1
	 =  case happyOut22 happy_x_1 of { happy_var_1 -> 
	happyIn24
		 ([happy_var_1]
	)}

happyReduce_140 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_140 = happyReduce 4# 14# happyReduction_140
happyReduction_140 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut23 happy_x_2 of { happy_var_2 -> 
	case happyOut24 happy_x_4 of { happy_var_4 -> 
	happyIn24
		 (map makeInstance happy_var_2 ++ happy_var_4
	) `HappyStk` happyRest}}

happyReduce_141 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_141 = happySpecReduce_3  14# happyReduction_141
happyReduction_141 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut23 happy_x_2 of { happy_var_2 -> 
	happyIn24
		 (map makeInstance happy_var_2
	)}

happyReduce_142 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_142 = happyReduce 4# 14# happyReduction_142
happyReduction_142 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut23 happy_x_2 of { happy_var_2 -> 
	case happyOut24 happy_x_4 of { happy_var_4 -> 
	happyIn24
		 (map hide happy_var_2 ++ happy_var_4
	) `HappyStk` happyRest}}

happyReduce_143 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_143 = happySpecReduce_3  14# happyReduction_143
happyReduction_143 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut23 happy_x_2 of { happy_var_2 -> 
	happyIn24
		 (map hide happy_var_2
	)}

happyReduce_144 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_144 = happyReduce 5# 14# happyReduction_144
happyReduction_144 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut20 happy_x_3 of { happy_var_3 -> 
	case happyOut24 happy_x_5 of { happy_var_5 -> 
	happyIn24
		 (map (hide . setRelevance Irrelevant . defaultArg) happy_var_3 ++ happy_var_5
	) `HappyStk` happyRest}}

happyReduce_145 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_145 = happyReduce 4# 14# happyReduction_145
happyReduction_145 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut20 happy_x_3 of { happy_var_3 -> 
	happyIn24
		 (map (hide . setRelevance Irrelevant . defaultArg) happy_var_3
	) `HappyStk` happyRest}

happyReduce_146 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_146 = happyReduce 5# 14# happyReduction_146
happyReduction_146 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut20 happy_x_3 of { happy_var_3 -> 
	case happyOut24 happy_x_5 of { happy_var_5 -> 
	happyIn24
		 (map (makeInstance . setRelevance Irrelevant . defaultArg) happy_var_3 ++ happy_var_5
	) `HappyStk` happyRest}}

happyReduce_147 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_147 = happyReduce 4# 14# happyReduction_147
happyReduction_147 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut20 happy_x_3 of { happy_var_3 -> 
	happyIn24
		 (map (makeInstance . setRelevance Irrelevant . defaultArg) happy_var_3
	) `HappyStk` happyRest}

happyReduce_148 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_148 = happyReduce 5# 14# happyReduction_148
happyReduction_148 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut20 happy_x_3 of { happy_var_3 -> 
	case happyOut24 happy_x_5 of { happy_var_5 -> 
	happyIn24
		 (map (hide . setRelevance NonStrict . defaultArg) happy_var_3 ++ happy_var_5
	) `HappyStk` happyRest}}

happyReduce_149 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_149 = happyReduce 4# 14# happyReduction_149
happyReduction_149 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut20 happy_x_3 of { happy_var_3 -> 
	happyIn24
		 (map (hide . setRelevance NonStrict . defaultArg) happy_var_3
	) `HappyStk` happyRest}

happyReduce_150 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_150 = happyReduce 5# 14# happyReduction_150
happyReduction_150 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut20 happy_x_3 of { happy_var_3 -> 
	case happyOut24 happy_x_5 of { happy_var_5 -> 
	happyIn24
		 (map (makeInstance . setRelevance NonStrict . defaultArg) happy_var_3 ++ happy_var_5
	) `HappyStk` happyRest}}

happyReduce_151 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_151 = happyReduce 4# 14# happyReduction_151
happyReduction_151 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut20 happy_x_3 of { happy_var_3 -> 
	happyIn24
		 (map (makeInstance . setRelevance NonStrict . defaultArg) happy_var_3
	) `HappyStk` happyRest}

happyReduce_152 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_152 = happyMonadReduce 1# 15# happyReduction_152
happyReduction_152 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokQId happy_var_1) -> 
	( mkQName happy_var_1)})
	) (\r -> happyReturn (happyIn25 r))

happyReduce_153 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_153 = happySpecReduce_1  15# happyReduction_153
happyReduction_153 happy_x_1
	 =  case happyOut19 happy_x_1 of { happy_var_1 -> 
	happyIn25
		 (QName happy_var_1
	)}

happyReduce_154 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_154 = happySpecReduce_1  16# happyReduction_154
happyReduction_154 happy_x_1
	 =  case happyOut25 happy_x_1 of { happy_var_1 -> 
	happyIn26
		 (happy_var_1
	)}

happyReduce_155 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_155 = happySpecReduce_1  17# happyReduction_155
happyReduction_155 happy_x_1
	 =  case happyOut19 happy_x_1 of { happy_var_1 -> 
	happyIn27
		 (happy_var_1
	)}

happyReduce_156 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_156 = happySpecReduce_1  17# happyReduction_156
happyReduction_156 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymUnderscore happy_var_1) -> 
	happyIn27
		 (Name (getRange happy_var_1) [Hole]
	)}

happyReduce_157 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_157 = happySpecReduce_2  18# happyReduction_157
happyReduction_157 happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	happyIn28
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_158 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_158 = happySpecReduce_1  18# happyReduction_158
happyReduction_158 happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	happyIn28
		 ([happy_var_1]
	)}

happyReduce_159 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_159 = happySpecReduce_1  19# happyReduction_159
happyReduction_159 happy_x_1
	 =  case happyOut30 happy_x_1 of { happy_var_1 -> 
	happyIn29
		 (case happy_var_1 of
      Left ns -> ns
      Right _ -> fail $ "expected sequence of bound identifiers, not absurd pattern"
	)}

happyReduce_160 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_160 = happyMonadReduce 1# 20# happyReduction_160
happyReduction_160 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut42 happy_x_1 of { happy_var_1 -> 
	(
    let getName :: Expr -> Maybe Name
        getName (Ident (QName x)) = Just x
        getName (Underscore r _)  = Just (Name r [Hole])
        getName _                 = Nothing

        isAbsurd :: Expr -> Bool
        isAbsurd (Absurd _)                  = True
        isAbsurd (HiddenArg _ (Named _ e))   = isAbsurd e
        isAbsurd (InstanceArg _ (Named _ e)) = isAbsurd e
        isAbsurd (Paren _ expr)              = isAbsurd expr
        isAbsurd (RawApp _ exprs)            = any isAbsurd exprs
        isAbsurd _                           = False
    in
    if any isAbsurd happy_var_1 then return $ Right happy_var_1 else
    case mapM getName happy_var_1 of
        Just good -> return $ Left good
        Nothing   -> fail $ "expected sequence of bound identifiers")})
	) (\r -> happyReturn (happyIn30 r))

happyReduce_161 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_161 = happyMonadReduce 1# 21# happyReduction_161
happyReduction_161 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut42 happy_x_1 of { happy_var_1 -> 
	(
    let -- interpret an expression as name
        getName :: Expr -> Maybe Name
        getName (Ident (QName x)) = Just x
        getName (Underscore r _)  = Just (Name r [Hole])
        getName _                 = Nothing

        getNames :: Expr -> Maybe [Name]
        getNames (RawApp _ es) = mapM getName es
        getNames e             = singleton `fmap` getName e

        -- interpret an expression as name or list of hidden names
        getName1 :: Expr -> Maybe [WithHiding Name]
        getName1 (Ident (QName x)) = Just [WithHiding NotHidden x]
        getName1 (Underscore r _)  = Just [WithHiding NotHidden $ Name r [Hole]]
        getName1 (HiddenArg _ (Named Nothing e))
                                   = map (WithHiding Hidden) `fmap` getNames e
        getName1 _                 = Nothing

    in
    case mapM getName1 happy_var_1 of
        Just good -> return $ concat good
        Nothing   -> fail $ "expected sequence of possibly hidden bound identifiers")})
	) (\r -> happyReturn (happyIn31 r))

happyReduce_162 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_162 = happySpecReduce_0  22# happyReduction_162
happyReduction_162  =  happyIn32
		 ([]
	)

happyReduce_163 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_163 = happySpecReduce_2  22# happyReduction_163
happyReduction_163 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	case happyOut32 happy_x_2 of { happy_var_2 -> 
	happyIn32
		 (snd happy_var_1 : happy_var_2
	)}}

happyReduce_164 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_164 = happySpecReduce_1  23# happyReduction_164
happyReduction_164 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	happyIn33
		 (snd happy_var_1
	)}

happyReduce_165 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_165 = happySpecReduce_0  24# happyReduction_165
happyReduction_165  =  happyIn34
		 ([]
	)

happyReduce_166 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_166 = happySpecReduce_2  24# happyReduction_166
happyReduction_166 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	case happyOut34 happy_x_2 of { happy_var_2 -> 
	happyIn34
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_167 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_167 = happySpecReduce_0  25# happyReduction_167
happyReduction_167  =  happyIn35
		 ([]
	)

happyReduce_168 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_168 = happySpecReduce_2  25# happyReduction_168
happyReduction_168 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	case happyOut35 happy_x_2 of { happy_var_2 -> 
	happyIn35
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_169 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_169 = happyReduce 4# 25# happyReduction_169
happyReduction_169 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOut35 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	case happyOut35 happy_x_4 of { happy_var_4 -> 
	happyIn35
		 ([(happy_var_1, "{-#")] ++ happy_var_2 ++ [(happy_var_3, "#-}")] ++ happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_170 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_170 = happyMonadReduce 1# 26# happyReduction_170
happyReduction_170 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	( mkName happy_var_1)})
	) (\r -> happyReturn (happyIn36 r))

happyReduce_171 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_171 = happyMonadReduce 1# 27# happyReduction_171
happyReduction_171 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	( pragmaQName happy_var_1)})
	) (\r -> happyReturn (happyIn37 r))

happyReduce_172 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_172 = happyMonadReduce 1# 28# happyReduction_172
happyReduction_172 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut34 happy_x_1 of { happy_var_1 -> 
	( mapM pragmaQName happy_var_1)})
	) (\r -> happyReturn (happyIn38 r))

happyReduce_173 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_173 = happySpecReduce_2  29# happyReduction_173
happyReduction_173 happy_x_2
	happy_x_1
	 =  case happyOut58 happy_x_1 of { happy_var_1 -> 
	case happyOut39 happy_x_2 of { happy_var_2 -> 
	happyIn39
		 (Pi happy_var_1 happy_var_2
	)}}

happyReduce_174 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_174 = happySpecReduce_3  29# happyReduction_174
happyReduction_174 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut46 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymArrow happy_var_2) -> 
	case happyOut39 happy_x_3 of { happy_var_3 -> 
	happyIn39
		 (Fun (getRange (happy_var_1,happy_var_2,happy_var_3))
                                              (RawApp (getRange happy_var_1) happy_var_1)
                                              happy_var_3
	)}}}

happyReduce_175 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_175 = happySpecReduce_3  29# happyReduction_175
happyReduction_175 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut40 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymEqual happy_var_2) -> 
	case happyOut39 happy_x_3 of { happy_var_3 -> 
	happyIn39
		 (Equal (getRange (happy_var_1, happy_var_2, happy_var_3)) happy_var_1 happy_var_3
	)}}}

happyReduce_176 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_176 = happySpecReduce_1  29# happyReduction_176
happyReduction_176 happy_x_1
	 =  case happyOut40 happy_x_1 of { happy_var_1 -> 
	happyIn39
		 (happy_var_1
	)}

happyReduce_177 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_177 = happyMonadReduce 1# 30# happyReduction_177
happyReduction_177 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut41 happy_x_1 of { happy_var_1 -> 
	( case happy_var_1 of
                      { [e]    -> return e
                      ; e : es -> return $ WithApp (fuseRange e es) e es
                      ; []     -> fail "impossible: empty with expressions"
                      })})
	) (\r -> happyReturn (happyIn40 r))

happyReduce_178 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_178 = happySpecReduce_3  31# happyReduction_178
happyReduction_178 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut46 happy_x_1 of { happy_var_1 -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (RawApp (getRange happy_var_1) happy_var_1 :  happy_var_3
	)}}

happyReduce_179 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_179 = happySpecReduce_1  31# happyReduction_179
happyReduction_179 happy_x_1
	 =  case happyOut42 happy_x_1 of { happy_var_1 -> 
	happyIn41
		 ([RawApp (getRange happy_var_1) happy_var_1]
	)}

happyReduce_180 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_180 = happySpecReduce_1  32# happyReduction_180
happyReduction_180 happy_x_1
	 =  case happyOut43 happy_x_1 of { happy_var_1 -> 
	happyIn42
		 ([happy_var_1]
	)}

happyReduce_181 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_181 = happySpecReduce_2  32# happyReduction_181
happyReduction_181 happy_x_2
	happy_x_1
	 =  case happyOut50 happy_x_1 of { happy_var_1 -> 
	case happyOut42 happy_x_2 of { happy_var_2 -> 
	happyIn42
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_182 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_182 = happySpecReduce_3  33# happyReduction_182
happyReduction_182 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymLambda happy_var_1) -> 
	case happyOut64 happy_x_2 of { happy_var_2 -> 
	case happyOut39 happy_x_3 of { happy_var_3 -> 
	happyIn43
		 (Lam (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_2 happy_var_3
	)}}}

happyReduce_183 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_183 = happySpecReduce_1  33# happyReduction_183
happyReduction_183 happy_x_1
	 =  case happyOut45 happy_x_1 of { happy_var_1 -> 
	happyIn43
		 (happy_var_1
	)}

happyReduce_184 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_184 = happySpecReduce_3  33# happyReduction_184
happyReduction_184 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut73 happy_x_2 of { happy_var_2 -> 
	case happyOut39 happy_x_3 of { happy_var_3 -> 
	happyIn43
		 (forallPi happy_var_2 happy_var_3
	)}}

happyReduce_185 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_185 = happySpecReduce_3  33# happyReduction_185
happyReduction_185 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwLet happy_var_1) -> 
	case happyOut179 happy_x_2 of { happy_var_2 -> 
	case happyOut44 happy_x_3 of { happy_var_3 -> 
	happyIn43
		 (Let (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_2 happy_var_3
	)}}}

happyReduce_186 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_186 = happyReduce 4# 33# happyReduction_186
happyReduction_186 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwDo happy_var_1) -> 
	case happyOut78 happy_x_3 of { happy_var_3 -> 
	happyIn43
		 (DoBlock (getRange (happy_var_1, happy_var_3)) happy_var_3
	) `HappyStk` happyRest}}

happyReduce_187 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_187 = happySpecReduce_1  33# happyReduction_187
happyReduction_187 happy_x_1
	 =  case happyOut50 happy_x_1 of { happy_var_1 -> 
	happyIn43
		 (happy_var_1
	)}

happyReduce_188 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_188 = happyReduce 4# 33# happyReduction_188
happyReduction_188 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwQuoteGoal happy_var_1) -> 
	case happyOut19 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokKeyword KwIn happy_var_3) -> 
	case happyOut39 happy_x_4 of { happy_var_4 -> 
	happyIn43
		 (QuoteGoal (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_189 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_189 = happySpecReduce_2  33# happyReduction_189
happyReduction_189 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwTactic happy_var_1) -> 
	case happyOut46 happy_x_2 of { happy_var_2 -> 
	happyIn43
		 (Tactic (getRange (happy_var_1, happy_var_2)) (RawApp (getRange happy_var_2) happy_var_2) []
	)}}

happyReduce_190 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_190 = happyReduce 4# 33# happyReduction_190
happyReduction_190 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwTactic happy_var_1) -> 
	case happyOut46 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymBar happy_var_3) -> 
	case happyOut41 happy_x_4 of { happy_var_4 -> 
	happyIn43
		 (Tactic (getRange (happy_var_1, happy_var_2, happy_var_3, happy_var_4)) (RawApp (getRange happy_var_2) happy_var_2) happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_191 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_191 = happySpecReduce_2  34# happyReduction_191
happyReduction_191 happy_x_2
	happy_x_1
	 =  case happyOut39 happy_x_2 of { happy_var_2 -> 
	happyIn44
		 (Just happy_var_2
	)}

happyReduce_192 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_192 = happySpecReduce_0  34# happyReduction_192
happyReduction_192  =  happyIn44
		 (Nothing
	)

happyReduce_193 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_193 = happyReduce 4# 35# happyReduction_193
happyReduction_193 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymLambda happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenBrace happy_var_2) -> 
	case happyOut71 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseBrace happy_var_4) -> 
	happyIn45
		 (ExtendedLam (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) (reverse happy_var_3)
	) `HappyStk` happyRest}}}}

happyReduce_194 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_194 = happyReduce 5# 35# happyReduction_194
happyReduction_194 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymLambda happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwWhere happy_var_2) -> 
	case happyOut72 happy_x_4 of { happy_var_4 -> 
	happyIn45
		 (ExtendedLam (getRange (happy_var_1, happy_var_2, happy_var_4)) (reverse happy_var_4)
	) `HappyStk` happyRest}}}

happyReduce_195 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_195 = happyMonadReduce 2# 35# happyReduction_195
happyReduction_195 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokSymbol SymLambda happy_var_1) -> 
	case happyOut65 happy_x_2 of { happy_var_2 -> 
	( case happy_var_2 of
                                       Left (bs, h) -> if null bs then return $ AbsurdLam r h else
                                                       return $ Lam r bs (AbsurdLam r h)
                                                         where r = fuseRange happy_var_1 bs
                                       Right es -> do -- it is of the form @\ { p1 ... () }@
                                                     p <- exprToLHS (RawApp (getRange es) es);
                                                     return $ ExtendedLam (fuseRange happy_var_1 es)
                                                                     [LamClause (p [] []) AbsurdRHS NoWhere False])}})
	) (\r -> happyReturn (happyIn45 r))

happyReduce_196 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_196 = happySpecReduce_1  36# happyReduction_196
happyReduction_196 happy_x_1
	 =  case happyOut50 happy_x_1 of { happy_var_1 -> 
	happyIn46
		 ([happy_var_1]
	)}

happyReduce_197 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_197 = happySpecReduce_2  36# happyReduction_197
happyReduction_197 happy_x_2
	happy_x_1
	 =  case happyOut50 happy_x_1 of { happy_var_1 -> 
	case happyOut46 happy_x_2 of { happy_var_2 -> 
	happyIn46
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_198 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_198 = happySpecReduce_0  37# happyReduction_198
happyReduction_198  =  happyIn47
		 ([]
	)

happyReduce_199 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_199 = happySpecReduce_2  37# happyReduction_199
happyReduction_199 happy_x_2
	happy_x_1
	 =  case happyOut50 happy_x_1 of { happy_var_1 -> 
	case happyOut47 happy_x_2 of { happy_var_2 -> 
	happyIn47
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_200 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_200 = happySpecReduce_3  38# happyReduction_200
happyReduction_200 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenBrace happy_var_1) -> 
	case happyOut39 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseBrace happy_var_3) -> 
	happyIn48
		 (HiddenArg (getRange (happy_var_1,happy_var_2,happy_var_3)) (maybeNamed happy_var_2)
	)}}}

happyReduce_201 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_201 = happySpecReduce_2  38# happyReduction_201
happyReduction_201 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenBrace happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymCloseBrace happy_var_2) -> 
	happyIn48
		 (let r = fuseRange happy_var_1 happy_var_2 in HiddenArg r $ unnamed $ Absurd r
	)}}

happyReduce_202 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_202 = happySpecReduce_1  39# happyReduction_202
happyReduction_202 happy_x_1
	 =  case happyOut25 happy_x_1 of { happy_var_1 -> 
	happyIn49
		 (Ident happy_var_1
	)}

happyReduce_203 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_203 = happySpecReduce_1  39# happyReduction_203
happyReduction_203 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokLiteral happy_var_1) -> 
	happyIn49
		 (Lit happy_var_1
	)}

happyReduce_204 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_204 = happySpecReduce_1  39# happyReduction_204
happyReduction_204 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymQuestionMark happy_var_1) -> 
	happyIn49
		 (QuestionMark (getRange happy_var_1) Nothing
	)}

happyReduce_205 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_205 = happySpecReduce_1  39# happyReduction_205
happyReduction_205 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymUnderscore happy_var_1) -> 
	happyIn49
		 (Underscore (getRange happy_var_1) Nothing
	)}

happyReduce_206 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_206 = happySpecReduce_1  39# happyReduction_206
happyReduction_206 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwProp happy_var_1) -> 
	happyIn49
		 (Prop (getRange happy_var_1)
	)}

happyReduce_207 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_207 = happySpecReduce_1  39# happyReduction_207
happyReduction_207 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwSet happy_var_1) -> 
	happyIn49
		 (Set (getRange happy_var_1)
	)}

happyReduce_208 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_208 = happySpecReduce_1  39# happyReduction_208
happyReduction_208 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuote happy_var_1) -> 
	happyIn49
		 (Quote (getRange happy_var_1)
	)}

happyReduce_209 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_209 = happySpecReduce_1  39# happyReduction_209
happyReduction_209 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuoteTerm happy_var_1) -> 
	happyIn49
		 (QuoteTerm (getRange happy_var_1)
	)}

happyReduce_210 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_210 = happySpecReduce_1  39# happyReduction_210
happyReduction_210 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuoteContext happy_var_1) -> 
	happyIn49
		 (QuoteContext (getRange happy_var_1)
	)}

happyReduce_211 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_211 = happySpecReduce_1  39# happyReduction_211
happyReduction_211 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUnquote happy_var_1) -> 
	happyIn49
		 (Unquote (getRange happy_var_1)
	)}

happyReduce_212 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_212 = happySpecReduce_1  39# happyReduction_212
happyReduction_212 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSetN happy_var_1) -> 
	happyIn49
		 (SetN (getRange (fst happy_var_1)) (snd happy_var_1)
	)}

happyReduce_213 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_213 = happySpecReduce_3  39# happyReduction_213
happyReduction_213 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleOpenBrace happy_var_1) -> 
	case happyOut39 happy_x_2 of { happy_var_2 -> 
	case happyOut21 happy_x_3 of { happy_var_3 -> 
	happyIn49
		 (InstanceArg (getRange (happy_var_1,happy_var_2,happy_var_3))
                                                          (maybeNamed happy_var_2)
	)}}}

happyReduce_214 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_214 = happySpecReduce_3  39# happyReduction_214
happyReduction_214 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOut39 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseParen happy_var_3) -> 
	happyIn49
		 (Paren (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_2
	)}}}

happyReduce_215 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_215 = happySpecReduce_3  39# happyReduction_215
happyReduction_215 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenIdiomBracket happy_var_1) -> 
	case happyOut39 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseIdiomBracket happy_var_3) -> 
	happyIn49
		 (IdiomBrackets (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_2
	)}}}

happyReduce_216 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_216 = happySpecReduce_2  39# happyReduction_216
happyReduction_216 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymCloseParen happy_var_2) -> 
	happyIn49
		 (Absurd (fuseRange happy_var_1 happy_var_2)
	)}}

happyReduce_217 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_217 = happySpecReduce_2  39# happyReduction_217
happyReduction_217 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleOpenBrace happy_var_1) -> 
	case happyOut21 happy_x_2 of { happy_var_2 -> 
	happyIn49
		 (let r = fuseRange happy_var_1 happy_var_2 in InstanceArg r $ unnamed $ Absurd r
	)}}

happyReduce_218 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_218 = happySpecReduce_3  39# happyReduction_218
happyReduction_218 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymAs happy_var_2) -> 
	case happyOut50 happy_x_3 of { happy_var_3 -> 
	happyIn49
		 (As (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_1 happy_var_3
	)}}}

happyReduce_219 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_219 = happySpecReduce_2  39# happyReduction_219
happyReduction_219 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDot happy_var_1) -> 
	case happyOut50 happy_x_2 of { happy_var_2 -> 
	happyIn49
		 (Dot (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_220 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_220 = happyReduce 4# 39# happyReduction_220
happyReduction_220 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenBrace happy_var_2) -> 
	case happyOut51 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseBrace happy_var_4) -> 
	happyIn49
		 (Rec (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_221 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_221 = happyReduce 5# 39# happyReduction_221
happyReduction_221 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOut49 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymOpenBrace happy_var_3) -> 
	case happyOut55 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymCloseBrace happy_var_5) -> 
	happyIn49
		 (RecUpdate (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_222 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_222 = happySpecReduce_1  39# happyReduction_222
happyReduction_222 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymEllipsis happy_var_1) -> 
	happyIn49
		 (Ellipsis (getRange happy_var_1)
	)}

happyReduce_223 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_223 = happySpecReduce_1  40# happyReduction_223
happyReduction_223 happy_x_1
	 =  case happyOut48 happy_x_1 of { happy_var_1 -> 
	happyIn50
		 (happy_var_1
	)}

happyReduce_224 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_224 = happySpecReduce_1  40# happyReduction_224
happyReduction_224 happy_x_1
	 =  case happyOut49 happy_x_1 of { happy_var_1 -> 
	happyIn50
		 (happy_var_1
	)}

happyReduce_225 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_225 = happySpecReduce_0  41# happyReduction_225
happyReduction_225  =  happyIn51
		 ([]
	)

happyReduce_226 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_226 = happySpecReduce_1  41# happyReduction_226
happyReduction_226 happy_x_1
	 =  case happyOut52 happy_x_1 of { happy_var_1 -> 
	happyIn51
		 (happy_var_1
	)}

happyReduce_227 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_227 = happySpecReduce_1  42# happyReduction_227
happyReduction_227 happy_x_1
	 =  case happyOut53 happy_x_1 of { happy_var_1 -> 
	happyIn52
		 ([happy_var_1]
	)}

happyReduce_228 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_228 = happySpecReduce_3  42# happyReduction_228
happyReduction_228 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut53 happy_x_1 of { happy_var_1 -> 
	case happyOut52 happy_x_3 of { happy_var_3 -> 
	happyIn52
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_229 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_229 = happySpecReduce_1  43# happyReduction_229
happyReduction_229 happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	happyIn53
		 (Left  happy_var_1
	)}

happyReduce_230 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_230 = happySpecReduce_1  43# happyReduction_230
happyReduction_230 happy_x_1
	 =  case happyOut54 happy_x_1 of { happy_var_1 -> 
	happyIn53
		 (Right happy_var_1
	)}

happyReduce_231 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_231 = happySpecReduce_3  44# happyReduction_231
happyReduction_231 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut26 happy_x_1 of { happy_var_1 -> 
	case happyOut130 happy_x_2 of { happy_var_2 -> 
	case happyOut81 happy_x_3 of { happy_var_3 -> 
	happyIn54
		 (ModuleAssignment happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_232 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_232 = happySpecReduce_0  45# happyReduction_232
happyReduction_232  =  happyIn55
		 ([]
	)

happyReduce_233 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_233 = happySpecReduce_1  45# happyReduction_233
happyReduction_233 happy_x_1
	 =  case happyOut56 happy_x_1 of { happy_var_1 -> 
	happyIn55
		 (happy_var_1
	)}

happyReduce_234 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_234 = happySpecReduce_1  46# happyReduction_234
happyReduction_234 happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	happyIn56
		 ([happy_var_1]
	)}

happyReduce_235 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_235 = happySpecReduce_3  46# happyReduction_235
happyReduction_235 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	case happyOut56 happy_x_3 of { happy_var_3 -> 
	happyIn56
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_236 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_236 = happySpecReduce_3  47# happyReduction_236
happyReduction_236 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_1 of { happy_var_1 -> 
	case happyOut39 happy_x_3 of { happy_var_3 -> 
	happyIn57
		 (FieldAssignment happy_var_1 happy_var_3
	)}}

happyReduce_237 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_237 = happySpecReduce_2  48# happyReduction_237
happyReduction_237 happy_x_2
	happy_x_1
	 =  case happyOut59 happy_x_1 of { happy_var_1 -> 
	happyIn58
		 (happy_var_1
	)}

happyReduce_238 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_238 = happySpecReduce_1  49# happyReduction_238
happyReduction_238 happy_x_1
	 =  case happyOut60 happy_x_1 of { happy_var_1 -> 
	happyIn59
		 ({-TeleBind-} happy_var_1
	)}

happyReduce_239 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_239 = happySpecReduce_2  50# happyReduction_239
happyReduction_239 happy_x_2
	happy_x_1
	 =  case happyOut61 happy_x_1 of { happy_var_1 -> 
	case happyOut60 happy_x_2 of { happy_var_2 -> 
	happyIn60
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_240 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_240 = happySpecReduce_1  50# happyReduction_240
happyReduction_240 happy_x_1
	 =  case happyOut61 happy_x_1 of { happy_var_1 -> 
	happyIn60
		 ([happy_var_1]
	)}

happyReduce_241 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_241 = happyReduce 4# 51# happyReduction_241
happyReduction_241 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut63 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn61
		 (setRange (getRange (happy_var_2,happy_var_3,happy_var_4)) $
                             setRelevance Irrelevant happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_242 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_242 = happyReduce 4# 51# happyReduction_242
happyReduction_242 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymOpenBrace happy_var_2) -> 
	case happyOut62 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseBrace happy_var_4) -> 
	happyIn61
		 (setRange (getRange (happy_var_2,happy_var_3,happy_var_4)) $
                             setHiding Hidden $
                             setRelevance Irrelevant happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_243 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_243 = happyReduce 4# 51# happyReduction_243
happyReduction_243 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymDoubleOpenBrace happy_var_2) -> 
	case happyOut62 happy_x_3 of { happy_var_3 -> 
	case happyOut21 happy_x_4 of { happy_var_4 -> 
	happyIn61
		 (setRange (getRange (happy_var_2,happy_var_3,happy_var_4)) $
                             makeInstance $
                             setRelevance Irrelevant happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_244 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_244 = happyReduce 4# 51# happyReduction_244
happyReduction_244 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut63 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn61
		 (setRange (getRange (happy_var_2,happy_var_3,happy_var_4)) $
                             setRelevance NonStrict happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_245 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_245 = happyReduce 4# 51# happyReduction_245
happyReduction_245 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymOpenBrace happy_var_2) -> 
	case happyOut62 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseBrace happy_var_4) -> 
	happyIn61
		 (setRange (getRange (happy_var_2,happy_var_3,happy_var_4)) $
                             setHiding Hidden $
                             setRelevance NonStrict happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_246 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_246 = happyReduce 4# 51# happyReduction_246
happyReduction_246 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymDoubleOpenBrace happy_var_2) -> 
	case happyOut62 happy_x_3 of { happy_var_3 -> 
	case happyOut21 happy_x_4 of { happy_var_4 -> 
	happyIn61
		 (setRange (getRange (happy_var_2,happy_var_3,happy_var_4)) $
                             makeInstance $
                             setRelevance NonStrict happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_247 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_247 = happySpecReduce_3  51# happyReduction_247
happyReduction_247 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOut63 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseParen happy_var_3) -> 
	happyIn61
		 (setRange (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_2
	)}}}

happyReduce_248 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_248 = happySpecReduce_3  51# happyReduction_248
happyReduction_248 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleOpenBrace happy_var_1) -> 
	case happyOut62 happy_x_2 of { happy_var_2 -> 
	case happyOut21 happy_x_3 of { happy_var_3 -> 
	happyIn61
		 (setRange (getRange (happy_var_1,happy_var_2,happy_var_3)) $
                             makeInstance happy_var_2
	)}}}

happyReduce_249 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_249 = happySpecReduce_3  51# happyReduction_249
happyReduction_249 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenBrace happy_var_1) -> 
	case happyOut62 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseBrace happy_var_3) -> 
	happyIn61
		 (setRange (getRange (happy_var_1,happy_var_2,happy_var_3)) $
                             setHiding Hidden happy_var_2
	)}}}

happyReduce_250 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_250 = happySpecReduce_3  51# happyReduction_250
happyReduction_250 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOut129 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseParen happy_var_3) -> 
	happyIn61
		 (tLet (getRange (happy_var_1,happy_var_3)) happy_var_2
	)}}}

happyReduce_251 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_251 = happyReduce 4# 51# happyReduction_251
happyReduction_251 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOut179 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn61
		 (tLet (getRange (happy_var_1,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_252 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_252 = happySpecReduce_3  52# happyReduction_252
happyReduction_252 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut29 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymColon happy_var_2) -> 
	case happyOut39 happy_x_3 of { happy_var_3 -> 
	happyIn62
		 (let r = getRange (happy_var_1,happy_var_2,happy_var_3) -- the range is approximate only for TypedBindings
    in TypedBindings r $ defaultArg $ TBind r (map (pure . mkBoundName_) happy_var_1) happy_var_3
	)}}}

happyReduce_253 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_253 = happySpecReduce_3  53# happyReduction_253
happyReduction_253 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut31 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymColon happy_var_2) -> 
	case happyOut39 happy_x_3 of { happy_var_3 -> 
	happyIn63
		 (let r = getRange (happy_var_1,happy_var_2,happy_var_3) -- the range is approximate only for TypedBindings
    in TypedBindings r $ defaultArg $ TBind r (map (fmap mkBoundName_) happy_var_1) happy_var_3
	)}}}

happyReduce_254 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_254 = happyMonadReduce 2# 54# happyReduction_254
happyReduction_254 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut66 happy_x_1 of { happy_var_1 -> 
	(
      case reverse happy_var_1 of
        Left _ : _ -> parseError "Absurd lambda cannot have a body."
        _ : _      -> return [ b | Right b <- happy_var_1 ]
        []         -> parsePanic "Empty LamBinds")})
	) (\r -> happyReturn (happyIn64 r))

happyReduce_255 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_255 = happyMonadReduce 1# 55# happyReduction_255
happyReduction_255 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut67 happy_x_1 of { happy_var_1 -> 
	(
    case happy_var_1 of
      Left lb -> case reverse lb of
                   Right _ : _ -> parseError "Missing body for lambda"
                   Left h  : _ -> return $ Left ([ b | Right b <- init lb], h)
                   _           -> parseError "Unsupported variant of lambda"
      Right es -> return $ Right es)})
	) (\r -> happyReturn (happyIn65 r))

happyReduce_256 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_256 = happySpecReduce_2  56# happyReduction_256
happyReduction_256 happy_x_2
	happy_x_1
	 =  case happyOut76 happy_x_1 of { happy_var_1 -> 
	case happyOut66 happy_x_2 of { happy_var_2 -> 
	happyIn66
		 (map Right happy_var_1 ++ happy_var_2
	)}}

happyReduce_257 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_257 = happySpecReduce_2  56# happyReduction_257
happyReduction_257 happy_x_2
	happy_x_1
	 =  case happyOut61 happy_x_1 of { happy_var_1 -> 
	case happyOut66 happy_x_2 of { happy_var_2 -> 
	happyIn66
		 (Right (DomainFull happy_var_1) : happy_var_2
	)}}

happyReduce_258 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_258 = happySpecReduce_1  56# happyReduction_258
happyReduction_258 happy_x_1
	 =  case happyOut76 happy_x_1 of { happy_var_1 -> 
	happyIn66
		 (map Right happy_var_1
	)}

happyReduce_259 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_259 = happySpecReduce_1  56# happyReduction_259
happyReduction_259 happy_x_1
	 =  case happyOut61 happy_x_1 of { happy_var_1 -> 
	happyIn66
		 ([Right $ DomainFull happy_var_1]
	)}

happyReduce_260 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_260 = happySpecReduce_2  56# happyReduction_260
happyReduction_260 happy_x_2
	happy_x_1
	 =  happyIn66
		 ([Left NotHidden]
	)

happyReduce_261 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_261 = happySpecReduce_2  56# happyReduction_261
happyReduction_261 happy_x_2
	happy_x_1
	 =  happyIn66
		 ([Left Hidden]
	)

happyReduce_262 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_262 = happySpecReduce_2  56# happyReduction_262
happyReduction_262 happy_x_2
	happy_x_1
	 =  happyIn66
		 ([Left (Instance NoOverlap)]
	)

happyReduce_263 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_263 = happySpecReduce_2  57# happyReduction_263
happyReduction_263 happy_x_2
	happy_x_1
	 =  case happyOut76 happy_x_1 of { happy_var_1 -> 
	case happyOut66 happy_x_2 of { happy_var_2 -> 
	happyIn67
		 (Left $ map Right happy_var_1 ++ happy_var_2
	)}}

happyReduce_264 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_264 = happySpecReduce_2  57# happyReduction_264
happyReduction_264 happy_x_2
	happy_x_1
	 =  case happyOut61 happy_x_1 of { happy_var_1 -> 
	case happyOut66 happy_x_2 of { happy_var_2 -> 
	happyIn67
		 (Left $ Right (DomainFull happy_var_1) : happy_var_2
	)}}

happyReduce_265 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_265 = happySpecReduce_1  57# happyReduction_265
happyReduction_265 happy_x_1
	 =  case happyOut77 happy_x_1 of { happy_var_1 -> 
	happyIn67
		 (case happy_var_1 of
                                    Left lb -> Left $ map Right lb
                                    Right es -> Right es
	)}

happyReduce_266 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_266 = happySpecReduce_1  57# happyReduction_266
happyReduction_266 happy_x_1
	 =  case happyOut61 happy_x_1 of { happy_var_1 -> 
	happyIn67
		 (Left [Right $ DomainFull happy_var_1]
	)}

happyReduce_267 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_267 = happySpecReduce_2  57# happyReduction_267
happyReduction_267 happy_x_2
	happy_x_1
	 =  happyIn67
		 (Left [Left NotHidden]
	)

happyReduce_268 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_268 = happySpecReduce_2  57# happyReduction_268
happyReduction_268 happy_x_2
	happy_x_1
	 =  happyIn67
		 (Left [Left Hidden]
	)

happyReduce_269 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_269 = happySpecReduce_2  57# happyReduction_269
happyReduction_269 happy_x_2
	happy_x_1
	 =  happyIn67
		 (Left [Left (Instance NoOverlap)]
	)

happyReduce_270 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_270 = happyMonadReduce 3# 58# happyReduction_270
happyReduction_270 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut47 happy_x_1 of { happy_var_1 -> 
	case happyOut39 happy_x_3 of { happy_var_3 -> 
	( do
      p <- exprToLHS (RawApp (getRange happy_var_1) happy_var_1) ;
      return LamClause{ lamLHS      = p [] []
                      , lamRHS      = RHS happy_var_3
                      , lamWhere    = NoWhere
                      , lamCatchAll = False })}})
	) (\r -> happyReturn (happyIn68 r))

happyReduce_271 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_271 = happyMonadReduce 4# 58# happyReduction_271
happyReduction_271 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut47 happy_x_2 of { happy_var_2 -> 
	case happyOut39 happy_x_4 of { happy_var_4 -> 
	( do
      p <- exprToLHS (RawApp (getRange happy_var_2) happy_var_2) ;
      return LamClause{ lamLHS      = p [] []
                      , lamRHS      = RHS happy_var_4
                      , lamWhere    = NoWhere
                      , lamCatchAll = True })}})
	) (\r -> happyReturn (happyIn68 r))

happyReduce_272 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_272 = happyMonadReduce 1# 59# happyReduction_272
happyReduction_272 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut42 happy_x_1 of { happy_var_1 -> 
	( do
      p <- exprToLHS (RawApp (getRange happy_var_1) happy_var_1);
      return LamClause{ lamLHS      = p [] []
                      , lamRHS      = AbsurdRHS
                      , lamWhere    = NoWhere
                      , lamCatchAll = False })})
	) (\r -> happyReturn (happyIn69 r))

happyReduce_273 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_273 = happyMonadReduce 2# 59# happyReduction_273
happyReduction_273 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut42 happy_x_2 of { happy_var_2 -> 
	( do
      p <- exprToLHS (RawApp (getRange happy_var_2) happy_var_2);
      return LamClause{ lamLHS      = p [] []
                      , lamRHS      = AbsurdRHS
                      , lamWhere    = NoWhere
                      , lamCatchAll = True })})
	) (\r -> happyReturn (happyIn69 r))

happyReduce_274 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_274 = happySpecReduce_1  60# happyReduction_274
happyReduction_274 happy_x_1
	 =  case happyOut68 happy_x_1 of { happy_var_1 -> 
	happyIn70
		 (happy_var_1
	)}

happyReduce_275 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_275 = happySpecReduce_1  60# happyReduction_275
happyReduction_275 happy_x_1
	 =  case happyOut69 happy_x_1 of { happy_var_1 -> 
	happyIn70
		 (happy_var_1
	)}

happyReduce_276 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_276 = happySpecReduce_3  61# happyReduction_276
happyReduction_276 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn71
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_277 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_277 = happySpecReduce_3  61# happyReduction_277
happyReduction_277 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut69 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn71
		 ([happy_var_3, happy_var_1]
	)}}

happyReduce_278 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_278 = happySpecReduce_1  61# happyReduction_278
happyReduction_278 happy_x_1
	 =  case happyOut68 happy_x_1 of { happy_var_1 -> 
	happyIn71
		 ([happy_var_1]
	)}

happyReduce_279 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_279 = happySpecReduce_3  62# happyReduction_279
happyReduction_279 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut72 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn72
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_280 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_280 = happySpecReduce_1  62# happyReduction_280
happyReduction_280 happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	happyIn72
		 ([happy_var_1]
	)}

happyReduce_281 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_281 = happySpecReduce_2  63# happyReduction_281
happyReduction_281 happy_x_2
	happy_x_1
	 =  case happyOut74 happy_x_1 of { happy_var_1 -> 
	happyIn73
		 (happy_var_1
	)}

happyReduce_282 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_282 = happySpecReduce_2  64# happyReduction_282
happyReduction_282 happy_x_2
	happy_x_1
	 =  case happyOut76 happy_x_1 of { happy_var_1 -> 
	case happyOut74 happy_x_2 of { happy_var_2 -> 
	happyIn74
		 (happy_var_1 ++ happy_var_2
	)}}

happyReduce_283 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_283 = happySpecReduce_2  64# happyReduction_283
happyReduction_283 happy_x_2
	happy_x_1
	 =  case happyOut61 happy_x_1 of { happy_var_1 -> 
	case happyOut74 happy_x_2 of { happy_var_2 -> 
	happyIn74
		 (DomainFull happy_var_1 : happy_var_2
	)}}

happyReduce_284 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_284 = happySpecReduce_1  64# happyReduction_284
happyReduction_284 happy_x_1
	 =  case happyOut76 happy_x_1 of { happy_var_1 -> 
	happyIn74
		 (happy_var_1
	)}

happyReduce_285 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_285 = happySpecReduce_1  64# happyReduction_285
happyReduction_285 happy_x_1
	 =  case happyOut61 happy_x_1 of { happy_var_1 -> 
	happyIn74
		 ([DomainFull happy_var_1]
	)}

happyReduce_286 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_286 = happySpecReduce_2  65# happyReduction_286
happyReduction_286 happy_x_2
	happy_x_1
	 =  case happyOut76 happy_x_1 of { happy_var_1 -> 
	case happyOut75 happy_x_2 of { happy_var_2 -> 
	happyIn75
		 (happy_var_1 ++ happy_var_2
	)}}

happyReduce_287 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_287 = happySpecReduce_2  65# happyReduction_287
happyReduction_287 happy_x_2
	happy_x_1
	 =  case happyOut61 happy_x_1 of { happy_var_1 -> 
	case happyOut75 happy_x_2 of { happy_var_2 -> 
	happyIn75
		 (DomainFull happy_var_1 : happy_var_2
	)}}

happyReduce_288 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_288 = happySpecReduce_0  65# happyReduction_288
happyReduction_288  =  happyIn75
		 ([]
	)

happyReduce_289 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_289 = happySpecReduce_1  66# happyReduction_289
happyReduction_289 happy_x_1
	 =  case happyOut77 happy_x_1 of { happy_var_1 -> 
	happyIn76
		 (case happy_var_1 of
                             Left lbs -> lbs
                             Right _ -> fail "expected sequence of bound identifiers, not absurd pattern"
	)}

happyReduce_290 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_290 = happySpecReduce_1  67# happyReduction_290
happyReduction_290 happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 (Left [DomainFree defaultArgInfo $ mkBoundName_ happy_var_1]
	)}

happyReduce_291 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_291 = happySpecReduce_2  67# happyReduction_291
happyReduction_291 happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_2 of { happy_var_2 -> 
	happyIn77
		 (Left [DomainFree (setRelevance Irrelevant $ defaultArgInfo) $ mkBoundName_ happy_var_2]
	)}

happyReduce_292 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_292 = happySpecReduce_2  67# happyReduction_292
happyReduction_292 happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_2 of { happy_var_2 -> 
	happyIn77
		 (Left [DomainFree (setRelevance NonStrict $ defaultArgInfo) $ mkBoundName_ happy_var_2]
	)}

happyReduce_293 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_293 = happySpecReduce_3  67# happyReduction_293
happyReduction_293 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut30 happy_x_2 of { happy_var_2 -> 
	happyIn77
		 (mapLeft (map (DomainFree (setHiding Hidden $ defaultArgInfo) . mkBoundName_)) happy_var_2
	)}

happyReduce_294 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_294 = happySpecReduce_3  67# happyReduction_294
happyReduction_294 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut29 happy_x_2 of { happy_var_2 -> 
	happyIn77
		 (Left $ map (DomainFree (makeInstance $ defaultArgInfo) . mkBoundName_) happy_var_2
	)}

happyReduce_295 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_295 = happyReduce 4# 67# happyReduction_295
happyReduction_295 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut29 happy_x_3 of { happy_var_3 -> 
	happyIn77
		 (Left $ map (DomainFree (setHiding Hidden $ setRelevance Irrelevant $ defaultArgInfo) . mkBoundName_) happy_var_3
	) `HappyStk` happyRest}

happyReduce_296 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_296 = happyReduce 4# 67# happyReduction_296
happyReduction_296 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut29 happy_x_3 of { happy_var_3 -> 
	happyIn77
		 (Left $ map (DomainFree (makeInstance $ setRelevance Irrelevant $ defaultArgInfo) . mkBoundName_) happy_var_3
	) `HappyStk` happyRest}

happyReduce_297 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_297 = happyReduce 4# 67# happyReduction_297
happyReduction_297 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut29 happy_x_3 of { happy_var_3 -> 
	happyIn77
		 (Left $ map (DomainFree (setHiding Hidden $ setRelevance NonStrict $ defaultArgInfo) . mkBoundName_) happy_var_3
	) `HappyStk` happyRest}

happyReduce_298 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_298 = happyReduce 4# 67# happyReduction_298
happyReduction_298 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut29 happy_x_3 of { happy_var_3 -> 
	happyIn77
		 (Left $ map (DomainFree  (makeInstance $ setRelevance NonStrict $ defaultArgInfo) . mkBoundName_) happy_var_3
	) `HappyStk` happyRest}

happyReduce_299 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_299 = happySpecReduce_1  68# happyReduction_299
happyReduction_299 happy_x_1
	 =  case happyOut79 happy_x_1 of { happy_var_1 -> 
	happyIn78
		 ([happy_var_1]
	)}

happyReduce_300 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_300 = happySpecReduce_2  68# happyReduction_300
happyReduction_300 happy_x_2
	happy_x_1
	 =  case happyOut79 happy_x_1 of { happy_var_1 -> 
	happyIn78
		 ([happy_var_1]
	)}

happyReduce_301 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_301 = happySpecReduce_3  68# happyReduction_301
happyReduction_301 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut79 happy_x_1 of { happy_var_1 -> 
	case happyOut78 happy_x_3 of { happy_var_3 -> 
	happyIn78
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_302 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_302 = happyMonadReduce 2# 69# happyReduction_302
happyReduction_302 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut39 happy_x_1 of { happy_var_1 -> 
	case happyOut80 happy_x_2 of { happy_var_2 -> 
	( buildDoStmt happy_var_1 happy_var_2)}})
	) (\r -> happyReturn (happyIn79 r))

happyReduce_303 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_303 = happySpecReduce_0  70# happyReduction_303
happyReduction_303  =  happyIn80
		 ([]
	)

happyReduce_304 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_304 = happyReduce 4# 70# happyReduction_304
happyReduction_304 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut72 happy_x_3 of { happy_var_3 -> 
	happyIn80
		 (reverse happy_var_3
	) `HappyStk` happyRest}

happyReduce_305 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_305 = happyMonadReduce 1# 71# happyReduction_305
happyReduction_305 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut82 happy_x_1 of { happy_var_1 -> 
	( mergeImportDirectives happy_var_1)})
	) (\r -> happyReturn (happyIn81 r))

happyReduce_306 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_306 = happySpecReduce_2  72# happyReduction_306
happyReduction_306 happy_x_2
	happy_x_1
	 =  case happyOut83 happy_x_1 of { happy_var_1 -> 
	case happyOut82 happy_x_2 of { happy_var_2 -> 
	happyIn82
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_307 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_307 = happySpecReduce_0  72# happyReduction_307
happyReduction_307  =  happyIn82
		 ([]
	)

happyReduce_308 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_308 = happySpecReduce_1  73# happyReduction_308
happyReduction_308 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPublic happy_var_1) -> 
	happyIn83
		 (defaultImportDir { importDirRange = getRange happy_var_1, publicOpen = True }
	)}

happyReduce_309 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_309 = happySpecReduce_1  73# happyReduction_309
happyReduction_309 happy_x_1
	 =  case happyOut84 happy_x_1 of { happy_var_1 -> 
	happyIn83
		 (defaultImportDir { importDirRange = snd happy_var_1, using    = fst happy_var_1 }
	)}

happyReduce_310 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_310 = happySpecReduce_1  73# happyReduction_310
happyReduction_310 happy_x_1
	 =  case happyOut85 happy_x_1 of { happy_var_1 -> 
	happyIn83
		 (defaultImportDir { importDirRange = snd happy_var_1, hiding   = fst happy_var_1 }
	)}

happyReduce_311 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_311 = happySpecReduce_1  73# happyReduction_311
happyReduction_311 happy_x_1
	 =  case happyOut86 happy_x_1 of { happy_var_1 -> 
	happyIn83
		 (defaultImportDir { importDirRange = snd happy_var_1, impRenaming = fst happy_var_1 }
	)}

happyReduce_312 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_312 = happyReduce 4# 74# happyReduction_312
happyReduction_312 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwUsing happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut91 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn84
		 ((Using happy_var_3 , getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4))
	) `HappyStk` happyRest}}}}

happyReduce_313 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_313 = happyReduce 4# 75# happyReduction_313
happyReduction_313 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwHiding happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut91 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn85
		 ((happy_var_3 , getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4))
	) `HappyStk` happyRest}}}}

happyReduce_314 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_314 = happyReduce 4# 76# happyReduction_314
happyReduction_314 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwRenaming happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut87 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn86
		 ((happy_var_3 , getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4))
	) `HappyStk` happyRest}}}}

happyReduce_315 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_315 = happySpecReduce_3  76# happyReduction_315
happyReduction_315 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwRenaming happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseParen happy_var_3) -> 
	happyIn86
		 (([] , getRange (happy_var_1,happy_var_2,happy_var_3))
	)}}}

happyReduce_316 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_316 = happySpecReduce_3  77# happyReduction_316
happyReduction_316 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut88 happy_x_1 of { happy_var_1 -> 
	case happyOut87 happy_x_3 of { happy_var_3 -> 
	happyIn87
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_317 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_317 = happySpecReduce_1  77# happyReduction_317
happyReduction_317 happy_x_1
	 =  case happyOut88 happy_x_1 of { happy_var_1 -> 
	happyIn87
		 ([happy_var_1]
	)}

happyReduce_318 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_318 = happySpecReduce_3  78# happyReduction_318
happyReduction_318 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut89 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwTo happy_var_2) -> 
	case happyOut19 happy_x_3 of { happy_var_3 -> 
	happyIn88
		 (Renaming happy_var_1 (setImportedName happy_var_1 happy_var_3) (getRange happy_var_2)
	)}}}

happyReduce_319 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_319 = happySpecReduce_2  79# happyReduction_319
happyReduction_319 happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_2 of { happy_var_2 -> 
	happyIn89
		 (ImportedName happy_var_2
	)}

happyReduce_320 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_320 = happySpecReduce_3  79# happyReduction_320
happyReduction_320 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_3 of { happy_var_3 -> 
	happyIn89
		 (ImportedModule happy_var_3
	)}

happyReduce_321 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_321 = happySpecReduce_1  80# happyReduction_321
happyReduction_321 happy_x_1
	 =  case happyOut19 happy_x_1 of { happy_var_1 -> 
	happyIn90
		 (ImportedName happy_var_1
	)}

happyReduce_322 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_322 = happySpecReduce_2  80# happyReduction_322
happyReduction_322 happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_2 of { happy_var_2 -> 
	happyIn90
		 (ImportedModule happy_var_2
	)}

happyReduce_323 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_323 = happySpecReduce_0  81# happyReduction_323
happyReduction_323  =  happyIn91
		 ([]
	)

happyReduce_324 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_324 = happySpecReduce_1  81# happyReduction_324
happyReduction_324 happy_x_1
	 =  case happyOut92 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 (happy_var_1
	)}

happyReduce_325 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_325 = happySpecReduce_1  82# happyReduction_325
happyReduction_325 happy_x_1
	 =  case happyOut90 happy_x_1 of { happy_var_1 -> 
	happyIn92
		 ([happy_var_1]
	)}

happyReduce_326 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_326 = happySpecReduce_3  82# happyReduction_326
happyReduction_326 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut90 happy_x_1 of { happy_var_1 -> 
	case happyOut92 happy_x_3 of { happy_var_3 -> 
	happyIn92
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_327 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_327 = happyMonadReduce 3# 83# happyReduction_327
happyReduction_327 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut40 happy_x_1 of { happy_var_1 -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	case happyOut94 happy_x_3 of { happy_var_3 -> 
	( exprToLHS happy_var_1 >>= \p -> return (p happy_var_2 happy_var_3))}}})
	) (\r -> happyReturn (happyIn93 r))

happyReduce_328 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_328 = happySpecReduce_0  84# happyReduction_328
happyReduction_328  =  happyIn94
		 ([]
	)

happyReduce_329 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_329 = happySpecReduce_2  84# happyReduction_329
happyReduction_329 happy_x_2
	happy_x_1
	 =  case happyOut39 happy_x_2 of { happy_var_2 -> 
	happyIn94
		 (case happy_var_2 of { WithApp _ e es -> e : es; e -> [e] }
	)}

happyReduce_330 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_330 = happySpecReduce_0  85# happyReduction_330
happyReduction_330  =  happyIn95
		 ([]
	)

happyReduce_331 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_331 = happySpecReduce_2  85# happyReduction_331
happyReduction_331 happy_x_2
	happy_x_1
	 =  case happyOut40 happy_x_2 of { happy_var_2 -> 
	happyIn95
		 (case happy_var_2 of { WithApp _ e es -> e : es; e -> [e] }
	)}

happyReduce_332 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_332 = happySpecReduce_1  86# happyReduction_332
happyReduction_332 happy_x_1
	 =  case happyOut39 happy_x_1 of { happy_var_1 -> 
	happyIn96
		 (HoleContentExpr    happy_var_1
	)}

happyReduce_333 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_333 = happySpecReduce_1  86# happyReduction_333
happyReduction_333 happy_x_1
	 =  case happyOut95 happy_x_1 of { happy_var_1 -> 
	happyIn96
		 (HoleContentRewrite happy_var_1
	)}

happyReduce_334 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_334 = happySpecReduce_0  87# happyReduction_334
happyReduction_334  =  happyIn97
		 (NoWhere
	)

happyReduce_335 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_335 = happySpecReduce_2  87# happyReduction_335
happyReduction_335 happy_x_2
	happy_x_1
	 =  case happyOut180 happy_x_2 of { happy_var_2 -> 
	happyIn97
		 (AnyWhere happy_var_2
	)}

happyReduce_336 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_336 = happyReduce 4# 87# happyReduction_336
happyReduction_336 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut19 happy_x_2 of { happy_var_2 -> 
	case happyOut180 happy_x_4 of { happy_var_4 -> 
	happyIn97
		 (SomeWhere happy_var_2 PublicAccess happy_var_4
	) `HappyStk` happyRest}}

happyReduce_337 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_337 = happyReduce 4# 87# happyReduction_337
happyReduction_337 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut134 happy_x_2 of { happy_var_2 -> 
	case happyOut180 happy_x_4 of { happy_var_4 -> 
	happyIn97
		 (SomeWhere happy_var_2 PublicAccess happy_var_4
	) `HappyStk` happyRest}}

happyReduce_338 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_338 = happySpecReduce_2  88# happyReduction_338
happyReduction_338 happy_x_2
	happy_x_1
	 =  case happyOut39 happy_x_1 of { happy_var_1 -> 
	case happyOut97 happy_x_2 of { happy_var_2 -> 
	happyIn98
		 (ExprWhere happy_var_1 happy_var_2
	)}}

happyReduce_339 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_339 = happySpecReduce_1  89# happyReduction_339
happyReduction_339 happy_x_1
	 =  case happyOut110 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 (happy_var_1
	)}

happyReduce_340 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_340 = happySpecReduce_1  89# happyReduction_340
happyReduction_340 happy_x_1
	 =  case happyOut102 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 (happy_var_1
	)}

happyReduce_341 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_341 = happySpecReduce_1  89# happyReduction_341
happyReduction_341 happy_x_1
	 =  case happyOut104 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 ([happy_var_1]
	)}

happyReduce_342 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_342 = happySpecReduce_1  89# happyReduction_342
happyReduction_342 happy_x_1
	 =  case happyOut105 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 ([happy_var_1]
	)}

happyReduce_343 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_343 = happySpecReduce_1  89# happyReduction_343
happyReduction_343 happy_x_1
	 =  case happyOut106 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 ([happy_var_1]
	)}

happyReduce_344 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_344 = happySpecReduce_1  89# happyReduction_344
happyReduction_344 happy_x_1
	 =  case happyOut107 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 ([happy_var_1]
	)}

happyReduce_345 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_345 = happySpecReduce_1  89# happyReduction_345
happyReduction_345 happy_x_1
	 =  case happyOut109 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 ([happy_var_1]
	)}

happyReduce_346 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_346 = happySpecReduce_1  89# happyReduction_346
happyReduction_346 happy_x_1
	 =  case happyOut111 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 ([happy_var_1]
	)}

happyReduce_347 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_347 = happySpecReduce_1  89# happyReduction_347
happyReduction_347 happy_x_1
	 =  case happyOut112 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 ([happy_var_1]
	)}

happyReduce_348 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_348 = happySpecReduce_1  89# happyReduction_348
happyReduction_348 happy_x_1
	 =  case happyOut113 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 ([happy_var_1]
	)}

happyReduce_349 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_349 = happySpecReduce_1  89# happyReduction_349
happyReduction_349 happy_x_1
	 =  case happyOut114 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 ([happy_var_1]
	)}

happyReduce_350 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_350 = happySpecReduce_1  89# happyReduction_350
happyReduction_350 happy_x_1
	 =  case happyOut115 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 ([happy_var_1]
	)}

happyReduce_351 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_351 = happySpecReduce_1  89# happyReduction_351
happyReduction_351 happy_x_1
	 =  case happyOut116 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 ([happy_var_1]
	)}

happyReduce_352 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_352 = happySpecReduce_1  89# happyReduction_352
happyReduction_352 happy_x_1
	 =  case happyOut117 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 ([happy_var_1]
	)}

happyReduce_353 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_353 = happySpecReduce_1  89# happyReduction_353
happyReduction_353 happy_x_1
	 =  case happyOut129 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 (happy_var_1
	)}

happyReduce_354 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_354 = happySpecReduce_1  89# happyReduction_354
happyReduction_354 happy_x_1
	 =  case happyOut132 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 ([happy_var_1]
	)}

happyReduce_355 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_355 = happySpecReduce_1  89# happyReduction_355
happyReduction_355 happy_x_1
	 =  case happyOut133 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 ([happy_var_1]
	)}

happyReduce_356 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_356 = happySpecReduce_1  89# happyReduction_356
happyReduction_356 happy_x_1
	 =  case happyOut136 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 ([happy_var_1]
	)}

happyReduce_357 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_357 = happySpecReduce_1  89# happyReduction_357
happyReduction_357 happy_x_1
	 =  case happyOut119 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 ([happy_var_1]
	)}

happyReduce_358 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_358 = happySpecReduce_1  89# happyReduction_358
happyReduction_358 happy_x_1
	 =  case happyOut120 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 ([happy_var_1]
	)}

happyReduce_359 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_359 = happySpecReduce_1  89# happyReduction_359
happyReduction_359 happy_x_1
	 =  case happyOut118 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 ([happy_var_1]
	)}

happyReduce_360 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_360 = happySpecReduce_3  90# happyReduction_360
happyReduction_360 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut20 happy_x_1 of { happy_var_1 -> 
	case happyOut39 happy_x_3 of { happy_var_3 -> 
	happyIn100
		 (map (\ x -> TypeSig defaultArgInfo x happy_var_3) happy_var_1
	)}}

happyReduce_361 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_361 = happySpecReduce_3  91# happyReduction_361
happyReduction_361 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut24 happy_x_1 of { happy_var_1 -> 
	case happyOut39 happy_x_3 of { happy_var_3 -> 
	happyIn101
		 (map (fmap (\ x -> TypeSig defaultArgInfo x happy_var_3)) happy_var_1
	)}}

happyReduce_362 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_362 = happyMonadReduce 4# 91# happyReduction_362
happyReduction_362 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokKeyword KwOverlap happy_var_1) -> 
	case happyOut24 happy_x_2 of { happy_var_2 -> 
	case happyOut39 happy_x_4 of { happy_var_4 -> 
	(
      let setOverlap x =
            case getHiding x of
              Instance _ -> return $ makeInstance' YesOverlap x
              _          ->
                parseErrorAt (fromJust $ rStart' $ getRange happy_var_1)
                             "The 'overlap' keyword only applies to instance fields (fields marked with {{ }})"
      in T.traverse (setOverlap . fmap (\ x -> TypeSig defaultArgInfo x happy_var_4)) happy_var_2)}}})
	) (\r -> happyReturn (happyIn101 r))

happyReduce_363 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_363 = happySpecReduce_2  91# happyReduction_363
happyReduction_363 happy_x_2
	happy_x_1
	 =  case happyOut172 happy_x_2 of { happy_var_2 -> 
	happyIn101
		 (let
      setInstance (TypeSig info x t) = TypeSig (makeInstance info) x t
      setInstance _ = __IMPOSSIBLE__ in
    map (fmap setInstance) happy_var_2
	)}

happyReduce_364 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_364 = happyMonadReduce 3# 92# happyReduction_364
happyReduction_364 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut93 happy_x_1 of { happy_var_1 -> 
	case happyOut103 happy_x_2 of { happy_var_2 -> 
	case happyOut97 happy_x_3 of { happy_var_3 -> 
	( funClauseOrTypeSigs happy_var_1 happy_var_2 happy_var_3)}}})
	) (\r -> happyReturn (happyIn102 r))

happyReduce_365 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_365 = happySpecReduce_2  93# happyReduction_365
happyReduction_365 happy_x_2
	happy_x_1
	 =  case happyOut39 happy_x_2 of { happy_var_2 -> 
	happyIn103
		 (JustRHS (RHS happy_var_2)
	)}

happyReduce_366 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_366 = happySpecReduce_2  93# happyReduction_366
happyReduction_366 happy_x_2
	happy_x_1
	 =  case happyOut39 happy_x_2 of { happy_var_2 -> 
	happyIn103
		 (TypeSigsRHS happy_var_2
	)}

happyReduce_367 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_367 = happySpecReduce_0  93# happyReduction_367
happyReduction_367  =  happyIn103
		 (JustRHS AbsurdRHS
	)

happyReduce_368 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_368 = happyReduce 7# 94# happyReduction_368
happyReduction_368 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwData happy_var_1) -> 
	case happyOut19 happy_x_2 of { happy_var_2 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymColon happy_var_4) -> 
	case happyOut39 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (TokKeyword KwWhere happy_var_6) -> 
	case happyOut180 happy_x_7 of { happy_var_7 -> 
	happyIn104
		 (Data (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5,happy_var_6,happy_var_7)) Inductive happy_var_2 happy_var_3 (Just happy_var_5) happy_var_7
	) `HappyStk` happyRest}}}}}}}

happyReduce_369 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_369 = happyReduce 7# 94# happyReduction_369
happyReduction_369 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwCoData happy_var_1) -> 
	case happyOut19 happy_x_2 of { happy_var_2 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymColon happy_var_4) -> 
	case happyOut39 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (TokKeyword KwWhere happy_var_6) -> 
	case happyOut180 happy_x_7 of { happy_var_7 -> 
	happyIn104
		 (Data (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5,happy_var_6,happy_var_7)) CoInductive happy_var_2 happy_var_3 (Just happy_var_5) happy_var_7
	) `HappyStk` happyRest}}}}}}}

happyReduce_370 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_370 = happyReduce 5# 94# happyReduction_370
happyReduction_370 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwData happy_var_1) -> 
	case happyOut19 happy_x_2 of { happy_var_2 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokKeyword KwWhere happy_var_4) -> 
	case happyOut180 happy_x_5 of { happy_var_5 -> 
	happyIn104
		 (Data (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) Inductive happy_var_2 happy_var_3 Nothing happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_371 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_371 = happyReduce 5# 94# happyReduction_371
happyReduction_371 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwCoData happy_var_1) -> 
	case happyOut19 happy_x_2 of { happy_var_2 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokKeyword KwWhere happy_var_4) -> 
	case happyOut180 happy_x_5 of { happy_var_5 -> 
	happyIn104
		 (Data (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) CoInductive happy_var_2 happy_var_3 Nothing happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_372 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_372 = happyReduce 5# 95# happyReduction_372
happyReduction_372 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwData happy_var_1) -> 
	case happyOut19 happy_x_2 of { happy_var_2 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymColon happy_var_4) -> 
	case happyOut39 happy_x_5 of { happy_var_5 -> 
	happyIn105
		 (DataSig (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) Inductive happy_var_2 happy_var_3 happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_373 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_373 = happyMonadReduce 7# 96# happyReduction_373
happyReduction_373 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOut49 happy_x_2 of { happy_var_2 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymColon happy_var_4) -> 
	case happyOut39 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (TokKeyword KwWhere happy_var_6) -> 
	case happyOut174 happy_x_7 of { happy_var_7 -> 
	( exprToName happy_var_2 >>= \ n -> let ((x,y,z),ds) = happy_var_7 in return $ Record (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5,happy_var_6,happy_var_7)) n x y z happy_var_3 (Just happy_var_5) ds)}}}}}}})
	) (\r -> happyReturn (happyIn106 r))

happyReduce_374 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_374 = happyMonadReduce 5# 96# happyReduction_374
happyReduction_374 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOut49 happy_x_2 of { happy_var_2 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokKeyword KwWhere happy_var_4) -> 
	case happyOut174 happy_x_5 of { happy_var_5 -> 
	( exprToName happy_var_2 >>= \ n -> let ((x,y,z),ds) = happy_var_5 in return $ Record (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) n x y z happy_var_3 Nothing ds)}}}}})
	) (\r -> happyReturn (happyIn106 r))

happyReduce_375 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_375 = happyMonadReduce 5# 97# happyReduction_375
happyReduction_375 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOut49 happy_x_2 of { happy_var_2 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymColon happy_var_4) -> 
	case happyOut39 happy_x_5 of { happy_var_5 -> 
	( exprToName happy_var_2 >>= \ n -> return $ RecordSig (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) n happy_var_3 happy_var_5)}}}}})
	) (\r -> happyReturn (happyIn107 r))

happyReduce_376 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_376 = happySpecReduce_2  98# happyReduction_376
happyReduction_376 happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_2 of { happy_var_2 -> 
	happyIn108
		 ((happy_var_2, NotInstanceDef)
	)}

happyReduce_377 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_377 = happyReduce 5# 98# happyReduction_377
happyReduction_377 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut19 happy_x_4 of { happy_var_4 -> 
	happyIn108
		 ((happy_var_4, InstanceDef)
	) `HappyStk` happyRest}

happyReduce_378 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_378 = happySpecReduce_3  99# happyReduction_378
happyReduction_378 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfix happy_var_1) -> 
	case happyOut18 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn109
		 (Infix (Fixity (getRange (happy_var_1,happy_var_3)) (Related happy_var_2) NonAssoc)   happy_var_3
	)}}}

happyReduce_379 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_379 = happySpecReduce_3  99# happyReduction_379
happyReduction_379 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfixL happy_var_1) -> 
	case happyOut18 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn109
		 (Infix (Fixity (getRange (happy_var_1,happy_var_3)) (Related happy_var_2) LeftAssoc)  happy_var_3
	)}}}

happyReduce_380 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_380 = happySpecReduce_3  99# happyReduction_380
happyReduction_380 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfixR happy_var_1) -> 
	case happyOut18 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn109
		 (Infix (Fixity (getRange (happy_var_1,happy_var_3)) (Related happy_var_2) RightAssoc) happy_var_3
	)}}}

happyReduce_381 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_381 = happySpecReduce_2  100# happyReduction_381
happyReduction_381 happy_x_2
	happy_x_1
	 =  case happyOut172 happy_x_2 of { happy_var_2 -> 
	happyIn110
		 (let
                inst i = case getHiding i of
                           Instance _ -> InstanceDef
                           _          -> NotInstanceDef
                toField (Arg info (TypeSig info' x t)) = Field (inst info') x (Arg info t)
              in map toField happy_var_2
	)}

happyReduce_382 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_382 = happySpecReduce_2  101# happyReduction_382
happyReduction_382 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwMutual happy_var_1) -> 
	case happyOut180 happy_x_2 of { happy_var_2 -> 
	happyIn111
		 (Mutual (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_383 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_383 = happySpecReduce_2  102# happyReduction_383
happyReduction_383 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwAbstract happy_var_1) -> 
	case happyOut180 happy_x_2 of { happy_var_2 -> 
	happyIn112
		 (Abstract (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_384 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_384 = happySpecReduce_2  103# happyReduction_384
happyReduction_384 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPrivate happy_var_1) -> 
	case happyOut180 happy_x_2 of { happy_var_2 -> 
	happyIn113
		 (Private (fuseRange happy_var_1 happy_var_2) UserWritten happy_var_2
	)}}

happyReduce_385 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_385 = happySpecReduce_2  104# happyReduction_385
happyReduction_385 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInstance happy_var_1) -> 
	case happyOut180 happy_x_2 of { happy_var_2 -> 
	happyIn114
		 (InstanceB (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_386 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_386 = happySpecReduce_2  105# happyReduction_386
happyReduction_386 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwMacro happy_var_1) -> 
	case happyOut180 happy_x_2 of { happy_var_2 -> 
	happyIn115
		 (Macro (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_387 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_387 = happySpecReduce_2  106# happyReduction_387
happyReduction_387 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPostulate happy_var_1) -> 
	case happyOut180 happy_x_2 of { happy_var_2 -> 
	happyIn116
		 (Postulate (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_388 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_388 = happySpecReduce_2  107# happyReduction_388
happyReduction_388 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPrimitive happy_var_1) -> 
	case happyOut170 happy_x_2 of { happy_var_2 -> 
	happyIn117
		 (Primitive (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_389 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_389 = happySpecReduce_3  108# happyReduction_389
happyReduction_389 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUnquoteDecl happy_var_1) -> 
	case happyOut39 happy_x_3 of { happy_var_3 -> 
	happyIn118
		 (UnquoteDecl (fuseRange happy_var_1 happy_var_3) [] happy_var_3
	)}}

happyReduce_390 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_390 = happyReduce 4# 108# happyReduction_390
happyReduction_390 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwUnquoteDecl happy_var_1) -> 
	case happyOut20 happy_x_2 of { happy_var_2 -> 
	case happyOut39 happy_x_4 of { happy_var_4 -> 
	happyIn118
		 (UnquoteDecl (fuseRange happy_var_1 happy_var_4) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}

happyReduce_391 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_391 = happyReduce 4# 108# happyReduction_391
happyReduction_391 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwUnquoteDef happy_var_1) -> 
	case happyOut20 happy_x_2 of { happy_var_2 -> 
	case happyOut39 happy_x_4 of { happy_var_4 -> 
	happyIn118
		 (UnquoteDef (fuseRange happy_var_1 happy_var_4) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}

happyReduce_392 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_392 = happyMonadReduce 5# 109# happyReduction_392
happyReduction_392 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut19 happy_x_2 of { happy_var_2 -> 
	case happyOut123 happy_x_3 of { happy_var_3 -> 
	case happyOut122 happy_x_5 of { happy_var_5 -> 
	(
  case happy_var_2 of
    Name _ [_] -> case mkNotation happy_var_3 (map rangedThing happy_var_5) of
      Left err -> parseError $ "Malformed syntax declaration: " ++ err
      Right n -> return $ Syntax happy_var_2 n
    _ -> parseError "Syntax declarations are allowed only for simple names (without holes)")}}})
	) (\r -> happyReturn (happyIn119 r))

happyReduce_393 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_393 = happyMonadReduce 5# 110# happyReduction_393
happyReduction_393 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokKeyword KwPatternSyn happy_var_1) -> 
	case happyOut19 happy_x_2 of { happy_var_2 -> 
	case happyOut121 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymEqual happy_var_4) -> 
	case happyOut39 happy_x_5 of { happy_var_5 -> 
	( do
  p <- exprToPattern happy_var_5
  return (PatternSyn (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) happy_var_2 happy_var_3 p))}}}}})
	) (\r -> happyReturn (happyIn120 r))

happyReduce_394 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_394 = happySpecReduce_0  111# happyReduction_394
happyReduction_394  =  happyIn121
		 ([]
	)

happyReduce_395 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_395 = happyMonadReduce 1# 111# happyReduction_395
happyReduction_395 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut66 happy_x_1 of { happy_var_1 -> 
	( patternSynArgs happy_var_1)})
	) (\r -> happyReturn (happyIn121 r))

happyReduce_396 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_396 = happySpecReduce_1  112# happyReduction_396
happyReduction_396 happy_x_1
	 =  case happyOut127 happy_x_1 of { happy_var_1 -> 
	happyIn122
		 ([happy_var_1]
	)}

happyReduce_397 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_397 = happySpecReduce_2  112# happyReduction_397
happyReduction_397 happy_x_2
	happy_x_1
	 =  case happyOut122 happy_x_1 of { happy_var_1 -> 
	case happyOut127 happy_x_2 of { happy_var_2 -> 
	happyIn122
		 (happy_var_1 ++ [happy_var_2]
	)}}

happyReduce_398 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_398 = happySpecReduce_1  113# happyReduction_398
happyReduction_398 happy_x_1
	 =  case happyOut124 happy_x_1 of { happy_var_1 -> 
	happyIn123
		 ([happy_var_1]
	)}

happyReduce_399 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_399 = happySpecReduce_2  113# happyReduction_399
happyReduction_399 happy_x_2
	happy_x_1
	 =  case happyOut123 happy_x_1 of { happy_var_1 -> 
	case happyOut124 happy_x_2 of { happy_var_2 -> 
	happyIn123
		 (happy_var_1 ++ [happy_var_2]
	)}}

happyReduce_400 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_400 = happySpecReduce_1  114# happyReduction_400
happyReduction_400 happy_x_1
	 =  case happyOut125 happy_x_1 of { happy_var_1 -> 
	happyIn124
		 (defaultNamedArg happy_var_1
	)}

happyReduce_401 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_401 = happySpecReduce_3  114# happyReduction_401
happyReduction_401 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut126 happy_x_2 of { happy_var_2 -> 
	happyIn124
		 (hide         $ defaultNamedArg happy_var_2
	)}

happyReduce_402 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_402 = happySpecReduce_3  114# happyReduction_402
happyReduction_402 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut126 happy_x_2 of { happy_var_2 -> 
	happyIn124
		 (makeInstance $ defaultNamedArg happy_var_2
	)}

happyReduce_403 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_403 = happyReduce 5# 114# happyReduction_403
happyReduction_403 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut127 happy_x_2 of { happy_var_2 -> 
	case happyOut126 happy_x_4 of { happy_var_4 -> 
	happyIn124
		 (hide         $ defaultArg $ named happy_var_2 happy_var_4
	) `HappyStk` happyRest}}

happyReduce_404 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_404 = happyReduce 5# 114# happyReduction_404
happyReduction_404 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut127 happy_x_2 of { happy_var_2 -> 
	case happyOut126 happy_x_4 of { happy_var_4 -> 
	happyIn124
		 (makeInstance $ defaultArg $ named happy_var_2 happy_var_4
	) `HappyStk` happyRest}}

happyReduce_405 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_405 = happySpecReduce_1  115# happyReduction_405
happyReduction_405 happy_x_1
	 =  case happyOut127 happy_x_1 of { happy_var_1 -> 
	happyIn125
		 (ExprHole (rangedThing happy_var_1)
	)}

happyReduce_406 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_406 = happyReduce 6# 115# happyReduction_406
happyReduction_406 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut127 happy_x_3 of { happy_var_3 -> 
	case happyOut127 happy_x_5 of { happy_var_5 -> 
	happyIn125
		 (LambdaHole (rangedThing happy_var_3) (rangedThing happy_var_5)
	) `HappyStk` happyRest}}

happyReduce_407 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_407 = happyReduce 6# 115# happyReduction_407
happyReduction_407 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut127 happy_x_5 of { happy_var_5 -> 
	happyIn125
		 (LambdaHole "_" (rangedThing happy_var_5)
	) `HappyStk` happyRest}

happyReduce_408 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_408 = happySpecReduce_1  116# happyReduction_408
happyReduction_408 happy_x_1
	 =  case happyOut127 happy_x_1 of { happy_var_1 -> 
	happyIn126
		 (ExprHole (rangedThing happy_var_1)
	)}

happyReduce_409 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_409 = happyReduce 4# 116# happyReduction_409
happyReduction_409 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut127 happy_x_2 of { happy_var_2 -> 
	case happyOut127 happy_x_4 of { happy_var_4 -> 
	happyIn126
		 (LambdaHole (rangedThing happy_var_2) (rangedThing happy_var_4)
	) `HappyStk` happyRest}}

happyReduce_410 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_410 = happyReduce 4# 116# happyReduction_410
happyReduction_410 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut127 happy_x_4 of { happy_var_4 -> 
	happyIn126
		 (LambdaHole "_" (rangedThing happy_var_4)
	) `HappyStk` happyRest}

happyReduce_411 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_411 = happySpecReduce_1  117# happyReduction_411
happyReduction_411 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokId happy_var_1) -> 
	happyIn127
		 (Ranged (getRange $ fst happy_var_1) (stringToRawName $ snd happy_var_1)
	)}

happyReduce_412 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_412 = happySpecReduce_1  118# happyReduction_412
happyReduction_412 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwOpen happy_var_1) -> 
	happyIn128
		 (Just (getRange happy_var_1)
	)}

happyReduce_413 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_413 = happySpecReduce_0  118# happyReduction_413
happyReduction_413  =  happyIn128
		 (Nothing
	)

happyReduce_414 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_414 = happyMonadReduce 5# 119# happyReduction_414
happyReduction_414 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut128 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwImport happy_var_2) -> 
	case happyOut26 happy_x_3 of { happy_var_3 -> 
	case happyOut130 happy_x_4 of { happy_var_4 -> 
	case happyOut81 happy_x_5 of { happy_var_5 -> 
	(
    let
    { doOpen = maybe DontOpen (const DoOpen) happy_var_1
    ; m   = happy_var_3
    ; es  = happy_var_4
    ; dir = happy_var_5
    ; r   = getRange (m, es, dir)
    ; mr  = getRange m
    ; unique = hashString $ show $ (Nothing :: Maybe ()) <$ r
         -- turn range into unique id, but delete file path
         -- which is absolute and messes up suite of failing tests
         -- (different hashs on different installations)
         -- TODO: Don't use (insecure) hashes in this way.
    ; fresh = Name mr [ Id $ stringToRawName $ ".#" ++ show m ++ "-" ++ show unique ]
    ; impStm asR = Import mr m (Just (AsName fresh asR)) DontOpen defaultImportDir
    ; appStm m' es =
        let r = getRange (m, es) in
        Private r Inserted
          [ ModuleMacro r m'
             (SectionApp (getRange es) []
               (RawApp (getRange es) (Ident (QName fresh) : es)))
             doOpen dir
          ]
    ; (initArgs, last2Args) = splitAt (length es - 2) es
    ; parseAsClause = case last2Args of
      { [ Ident (QName (Name asR [Id x]))
        , Ident (QName m')
        ] | rawNameToString x == "as" -> Just (asR, m')
      ; _ -> Nothing
      }
    } in
    case es of
      { [] -> return [Import mr m Nothing doOpen dir]
      ; _ | Just (asR, m') <- parseAsClause ->
              if null initArgs then return
                 [ Import (getRange (m, asR, m', dir)) m
                     (Just (AsName m' asR)) doOpen dir
                 ]
              else return [ impStm asR, appStm m' initArgs ]
          -- Andreas, 2017-05-13, issue #2579
          -- Nisse reports that importing with instantation but without open
          -- could be usefule for bringing instances into scope.
          -- -- | DontOpen <- doOpen -> parseErrorAt (fromJust $ rStart' $ getRange happy_var_2) "An import statement with module instantiation does not actually import the module.  This statement achieves nothing.  Either add the `open' keyword or bind the instantiated module with an `as' clause."
          | otherwise -> return
              [ impStm noRange
              , appStm (noName $ beginningOf $ getRange m) es
              ]
      })}}}}})
	) (\r -> happyReturn (happyIn129 r))

happyReduce_415 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_415 = happyReduce 4# 119# happyReduction_415
happyReduction_415 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut26 happy_x_2 of { happy_var_2 -> 
	case happyOut130 happy_x_3 of { happy_var_3 -> 
	case happyOut81 happy_x_4 of { happy_var_4 -> 
	happyIn129
		 (let
    { m   = happy_var_2
    ; es  = happy_var_3
    ; dir = happy_var_4
    ; r   = getRange (m, es, dir)
    } in
    [ case es of
      { []  -> Open r m dir
      ; _   -> Private r Inserted
                 [ ModuleMacro r (noName $ beginningOf $ getRange m)
                             (SectionApp (getRange (m , es)) [] (RawApp (fuseRange m es) (Ident m : es)))
                             DoOpen dir
                 ]
      }
    ]
	) `HappyStk` happyRest}}}

happyReduce_416 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_416 = happyReduce 6# 119# happyReduction_416
happyReduction_416 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut26 happy_x_2 of { happy_var_2 -> 
	case happyOut81 happy_x_6 of { happy_var_6 -> 
	happyIn129
		 (let r = getRange happy_var_2 in
    [ Private r Inserted
      [ ModuleMacro r (noName $ beginningOf $ getRange happy_var_2) (RecordModuleIFS r happy_var_2) DoOpen happy_var_6
      ]
    ]
	) `HappyStk` happyRest}}

happyReduce_417 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_417 = happySpecReduce_0  120# happyReduction_417
happyReduction_417  =  happyIn130
		 ([]
	)

happyReduce_418 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_418 = happySpecReduce_2  120# happyReduction_418
happyReduction_418 happy_x_2
	happy_x_1
	 =  case happyOut50 happy_x_1 of { happy_var_1 -> 
	case happyOut130 happy_x_2 of { happy_var_2 -> 
	happyIn130
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_419 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_419 = happyReduce 4# 121# happyReduction_419
happyReduction_419 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut26 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymDoubleOpenBrace happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymEllipsis happy_var_3) -> 
	case happyOut21 happy_x_4 of { happy_var_4 -> 
	happyIn131
		 ((\ts ->
                    if null ts then return $ RecordModuleIFS (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_1
                    else parseError "No bindings allowed for record module with non-canonical implicits" )
	) `HappyStk` happyRest}}}}

happyReduce_420 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_420 = happySpecReduce_2  121# happyReduction_420
happyReduction_420 happy_x_2
	happy_x_1
	 =  case happyOut26 happy_x_1 of { happy_var_1 -> 
	case happyOut130 happy_x_2 of { happy_var_2 -> 
	happyIn131
		 ((\ts -> return $ SectionApp (getRange (happy_var_1, happy_var_2)) ts (RawApp (fuseRange happy_var_1 happy_var_2) (Ident happy_var_1 : happy_var_2)) )
	)}}

happyReduce_421 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_421 = happyMonadReduce 6# 122# happyReduction_421
happyReduction_421 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokKeyword KwModule happy_var_1) -> 
	case happyOut26 happy_x_2 of { happy_var_2 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	case happyOut131 happy_x_5 of { happy_var_5 -> 
	case happyOut81 happy_x_6 of { happy_var_6 -> 
	( do { ma <- happy_var_5 (map addType happy_var_3)
                          ; name <- ensureUnqual happy_var_2
                          ; return $ ModuleMacro (getRange (happy_var_1, happy_var_2, ma, happy_var_6)) name ma DontOpen happy_var_6 })}}}}})
	) (\r -> happyReturn (happyIn132 r))

happyReduce_422 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_422 = happyMonadReduce 7# 122# happyReduction_422
happyReduction_422 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokKeyword KwOpen happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwModule happy_var_2) -> 
	case happyOut19 happy_x_3 of { happy_var_3 -> 
	case happyOut75 happy_x_4 of { happy_var_4 -> 
	case happyOut131 happy_x_6 of { happy_var_6 -> 
	case happyOut81 happy_x_7 of { happy_var_7 -> 
	( do {ma <- happy_var_6 (map addType happy_var_4); return $ ModuleMacro (getRange (happy_var_1, happy_var_2, happy_var_3, ma, happy_var_7)) happy_var_3 ma DoOpen happy_var_7 })}}}}}})
	) (\r -> happyReturn (happyIn132 r))

happyReduce_423 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_423 = happyReduce 5# 123# happyReduction_423
happyReduction_423 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwModule happy_var_1) -> 
	case happyOut26 happy_x_2 of { happy_var_2 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokKeyword KwWhere happy_var_4) -> 
	case happyOut180 happy_x_5 of { happy_var_5 -> 
	happyIn133
		 (Module (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) happy_var_2 (map addType happy_var_3) happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_424 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_424 = happyReduce 5# 123# happyReduction_424
happyReduction_424 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwModule happy_var_1) -> 
	case happyOut134 happy_x_2 of { happy_var_2 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokKeyword KwWhere happy_var_4) -> 
	case happyOut180 happy_x_5 of { happy_var_5 -> 
	happyIn133
		 (Module (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) (QName happy_var_2) (map addType happy_var_3) happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_425 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_425 = happySpecReduce_1  124# happyReduction_425
happyReduction_425 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymUnderscore happy_var_1) -> 
	happyIn134
		 (noName (getRange happy_var_1)
	)}

happyReduce_426 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_426 = happySpecReduce_1  125# happyReduction_426
happyReduction_426 happy_x_1
	 =  case happyOut182 happy_x_1 of { happy_var_1 -> 
	happyIn135
		 (figureOutTopLevelModule happy_var_1
	)}

happyReduce_427 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_427 = happySpecReduce_1  126# happyReduction_427
happyReduction_427 happy_x_1
	 =  case happyOut137 happy_x_1 of { happy_var_1 -> 
	happyIn136
		 (Pragma happy_var_1
	)}

happyReduce_428 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_428 = happySpecReduce_1  127# happyReduction_428
happyReduction_428 happy_x_1
	 =  case happyOut139 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_429 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_429 = happySpecReduce_1  127# happyReduction_429
happyReduction_429 happy_x_1
	 =  case happyOut140 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_430 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_430 = happySpecReduce_1  127# happyReduction_430
happyReduction_430 happy_x_1
	 =  case happyOut141 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_431 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_431 = happySpecReduce_1  127# happyReduction_431
happyReduction_431 happy_x_1
	 =  case happyOut142 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_432 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_432 = happySpecReduce_1  127# happyReduction_432
happyReduction_432 happy_x_1
	 =  case happyOut144 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_433 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_433 = happySpecReduce_1  127# happyReduction_433
happyReduction_433 happy_x_1
	 =  case happyOut143 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_434 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_434 = happySpecReduce_1  127# happyReduction_434
happyReduction_434 happy_x_1
	 =  case happyOut145 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_435 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_435 = happySpecReduce_1  127# happyReduction_435
happyReduction_435 happy_x_1
	 =  case happyOut146 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_436 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_436 = happySpecReduce_1  127# happyReduction_436
happyReduction_436 happy_x_1
	 =  case happyOut147 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_437 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_437 = happySpecReduce_1  127# happyReduction_437
happyReduction_437 happy_x_1
	 =  case happyOut148 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_438 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_438 = happySpecReduce_1  127# happyReduction_438
happyReduction_438 happy_x_1
	 =  case happyOut150 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_439 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_439 = happySpecReduce_1  127# happyReduction_439
happyReduction_439 happy_x_1
	 =  case happyOut149 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_440 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_440 = happySpecReduce_1  127# happyReduction_440
happyReduction_440 happy_x_1
	 =  case happyOut151 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_441 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_441 = happySpecReduce_1  127# happyReduction_441
happyReduction_441 happy_x_1
	 =  case happyOut154 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_442 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_442 = happySpecReduce_1  127# happyReduction_442
happyReduction_442 happy_x_1
	 =  case happyOut152 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_443 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_443 = happySpecReduce_1  127# happyReduction_443
happyReduction_443 happy_x_1
	 =  case happyOut153 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_444 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_444 = happySpecReduce_1  127# happyReduction_444
happyReduction_444 happy_x_1
	 =  case happyOut162 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_445 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_445 = happySpecReduce_1  127# happyReduction_445
happyReduction_445 happy_x_1
	 =  case happyOut163 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_446 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_446 = happySpecReduce_1  127# happyReduction_446
happyReduction_446 happy_x_1
	 =  case happyOut164 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_447 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_447 = happySpecReduce_1  127# happyReduction_447
happyReduction_447 happy_x_1
	 =  case happyOut159 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_448 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_448 = happySpecReduce_1  127# happyReduction_448
happyReduction_448 happy_x_1
	 =  case happyOut158 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_449 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_449 = happySpecReduce_1  127# happyReduction_449
happyReduction_449 happy_x_1
	 =  case happyOut157 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_450 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_450 = happySpecReduce_1  127# happyReduction_450
happyReduction_450 happy_x_1
	 =  case happyOut167 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_451 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_451 = happySpecReduce_1  127# happyReduction_451
happyReduction_451 happy_x_1
	 =  case happyOut160 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_452 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_452 = happySpecReduce_1  127# happyReduction_452
happyReduction_452 happy_x_1
	 =  case happyOut161 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_453 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_453 = happySpecReduce_1  127# happyReduction_453
happyReduction_453 happy_x_1
	 =  case happyOut155 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_454 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_454 = happySpecReduce_1  127# happyReduction_454
happyReduction_454 happy_x_1
	 =  case happyOut156 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_455 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_455 = happySpecReduce_1  127# happyReduction_455
happyReduction_455 happy_x_1
	 =  case happyOut165 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_456 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_456 = happySpecReduce_1  127# happyReduction_456
happyReduction_456 happy_x_1
	 =  case happyOut166 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_457 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_457 = happySpecReduce_1  127# happyReduction_457
happyReduction_457 happy_x_1
	 =  case happyOut138 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_458 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_458 = happyReduce 4# 128# happyReduction_458
happyReduction_458 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwOPTIONS happy_var_2) -> 
	case happyOut32 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn138
		 (OptionsPragma (getRange (happy_var_1,happy_var_2,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_459 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_459 = happyReduce 5# 129# happyReduction_459
happyReduction_459 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwBUILTIN happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokString happy_var_3) -> 
	case happyOut37 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn139
		 (BuiltinPragma (getRange (happy_var_1,happy_var_2,fst happy_var_3,happy_var_4,happy_var_5)) (snd happy_var_3) happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_460 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_460 = happyReduce 5# 129# happyReduction_460
happyReduction_460 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwBUILTIN happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokKeyword KwREWRITE happy_var_3) -> 
	case happyOut37 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn139
		 (BuiltinPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) "REWRITE" happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_461 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_461 = happyReduce 4# 130# happyReduction_461
happyReduction_461 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwREWRITE happy_var_2) -> 
	case happyOut38 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn140
		 (RewritePragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_462 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_462 = happyReduce 5# 131# happyReduction_462
happyReduction_462 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED happy_var_2) -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	case happyOut32 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn141
		 (CompiledPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_5)) happy_var_3 (unwords happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_463 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_463 = happyReduce 5# 132# happyReduction_463
happyReduction_463 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED_EXPORT happy_var_2) -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	case happyOut33 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn142
		 (CompiledExportPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_5)) happy_var_3 happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_464 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_464 = happyReduce 5# 133# happyReduction_464
happyReduction_464 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED_TYPE happy_var_2) -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	case happyOut32 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn143
		 (CompiledTypePragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_5)) happy_var_3 (unwords happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_465 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_465 = happyReduce 6# 134# happyReduction_465
happyReduction_465 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED_DATA happy_var_2) -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokString happy_var_4) -> 
	case happyOut32 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (TokSymbol SymClosePragma happy_var_6) -> 
	happyIn144
		 (CompiledDataPragma (getRange (happy_var_1,happy_var_2,happy_var_3,fst happy_var_4,happy_var_6)) happy_var_3 (snd happy_var_4) happy_var_5
	) `HappyStk` happyRest}}}}}}

happyReduce_466 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_466 = happyReduce 5# 135# happyReduction_466
happyReduction_466 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED_JS happy_var_2) -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	case happyOut32 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn145
		 (CompiledJSPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_5)) happy_var_3 (unwords happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_467 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_467 = happyReduce 5# 136# happyReduction_467
happyReduction_467 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED_UHC happy_var_2) -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	case happyOut32 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn146
		 (CompiledUHCPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_5)) happy_var_3 (unwords happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_468 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_468 = happyReduce 6# 137# happyReduction_468
happyReduction_468 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED_DATA_UHC happy_var_2) -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokString happy_var_4) -> 
	case happyOut32 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (TokSymbol SymClosePragma happy_var_6) -> 
	happyIn147
		 (CompiledDataUHCPragma (getRange (happy_var_1,happy_var_2,happy_var_3,fst happy_var_4,happy_var_6)) happy_var_3 (snd happy_var_4) happy_var_5
	) `HappyStk` happyRest}}}}}}

happyReduce_469 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_469 = happyReduce 4# 138# happyReduction_469
happyReduction_469 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwHASKELL happy_var_2) -> 
	case happyOut35 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn148
		 (HaskellCodePragma (getRange (happy_var_1, happy_var_2, happy_var_4)) (recoverLayout happy_var_3)
	) `HappyStk` happyRest}}}}

happyReduce_470 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_470 = happyReduce 5# 139# happyReduction_470
happyReduction_470 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwFOREIGN happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokString happy_var_3) -> 
	case happyOut35 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn149
		 (ForeignPragma (getRange (happy_var_1, happy_var_2, fst happy_var_3, happy_var_5)) (snd happy_var_3) (recoverLayout happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_471 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_471 = happyReduce 6# 140# happyReduction_471
happyReduction_471 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILE happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokString happy_var_3) -> 
	case happyOut37 happy_x_4 of { happy_var_4 -> 
	case happyOut32 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (TokSymbol SymClosePragma happy_var_6) -> 
	happyIn150
		 (CompilePragma (getRange (happy_var_1,happy_var_2,fst happy_var_3,happy_var_4,happy_var_6)) (snd happy_var_3) happy_var_4 (unwords happy_var_5)
	) `HappyStk` happyRest}}}}}}

happyReduce_472 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_472 = happyReduce 4# 141# happyReduction_472
happyReduction_472 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwSTATIC happy_var_2) -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn151
		 (StaticPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_473 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_473 = happyReduce 4# 142# happyReduction_473
happyReduction_473 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwINLINE happy_var_2) -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn152
		 (InlinePragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) True happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_474 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_474 = happyReduce 4# 143# happyReduction_474
happyReduction_474 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwNOINLINE happy_var_2) -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn153
		 (InlinePragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) False happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_475 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_475 = happyReduce 4# 144# happyReduction_475
happyReduction_475 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwINJECTIVE happy_var_2) -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn154
		 (InjectivePragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_476 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_476 = happyMonadReduce 5# 145# happyReduction_476
happyReduction_476 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_3 of { (TokString happy_var_3) -> 
	case happyOut32 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	(
      let (r, s) = happy_var_3 in
      parseDisplayPragma (fuseRange happy_var_1 happy_var_5) (iStart r) (unwords (s : happy_var_4)))}}}})
	) (\r -> happyReturn (happyIn155 r))

happyReduce_477 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_477 = happyReduce 4# 146# happyReduction_477
happyReduction_477 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwETA happy_var_2) -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn156
		 (EtaPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_478 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_478 = happySpecReduce_3  147# happyReduction_478
happyReduction_478 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwNO_TERMINATION_CHECK happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn157
		 (TerminationCheckPragma (getRange (happy_var_1,happy_var_2,happy_var_3)) NoTerminationCheck
	)}}}

happyReduce_479 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_479 = happySpecReduce_3  148# happyReduction_479
happyReduction_479 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwNON_TERMINATING happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn158
		 (TerminationCheckPragma (getRange (happy_var_1,happy_var_2,happy_var_3)) NonTerminating
	)}}}

happyReduce_480 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_480 = happySpecReduce_3  149# happyReduction_480
happyReduction_480 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwTERMINATING happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn159
		 (TerminationCheckPragma (getRange (happy_var_1,happy_var_2,happy_var_3)) Terminating
	)}}}

happyReduce_481 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_481 = happyReduce 4# 150# happyReduction_481
happyReduction_481 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwMEASURE happy_var_2) -> 
	case happyOut36 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn160
		 (let r = getRange (happy_var_1, happy_var_2, happy_var_3, happy_var_4) in
      TerminationCheckPragma r (TerminationMeasure r happy_var_3)
	) `HappyStk` happyRest}}}}

happyReduce_482 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_482 = happySpecReduce_3  151# happyReduction_482
happyReduction_482 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCATCHALL happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn161
		 (CatchallPragma (getRange (happy_var_1,happy_var_2,happy_var_3))
	)}}}

happyReduce_483 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_483 = happyMonadReduce 4# 152# happyReduction_483
happyReduction_483 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwIMPORT happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokString happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	( let s = snd happy_var_3 in
       if validHaskellModuleName s
       then return $ ImportPragma (getRange (happy_var_1,happy_var_2,fst happy_var_3,happy_var_4)) s
       else parseError $ "Malformed module name: " ++ s ++ ".")}}}})
	) (\r -> happyReturn (happyIn162 r))

happyReduce_484 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_484 = happyMonadReduce 4# 153# happyReduction_484
happyReduction_484 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwIMPORT_UHC happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokString happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	( let s = snd happy_var_3 in
       if validHaskellModuleName s
       then return $ ImportUHCPragma (getRange (happy_var_1,happy_var_2,fst happy_var_3,happy_var_4)) s
       else parseError $ "Malformed module name: " ++ s ++ ".")}}}})
	) (\r -> happyReturn (happyIn163 r))

happyReduce_485 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_485 = happySpecReduce_3  154# happyReduction_485
happyReduction_485 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwIMPOSSIBLE happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn164
		 (ImpossiblePragma (getRange (happy_var_1,happy_var_2,happy_var_3))
	)}}}

happyReduce_486 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_486 = happySpecReduce_3  155# happyReduction_486
happyReduction_486 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwNO_POSITIVITY_CHECK happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn165
		 (NoPositivityCheckPragma (getRange (happy_var_1,happy_var_2,happy_var_3))
	)}}}

happyReduce_487 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_487 = happyReduce 5# 156# happyReduction_487
happyReduction_487 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwPOLARITY happy_var_2) -> 
	case happyOut36 happy_x_3 of { happy_var_3 -> 
	case happyOut168 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn166
		 (let (rs, occs) = unzip (reverse happy_var_4) in
      PolarityPragma (getRange (happy_var_1,happy_var_2,happy_var_3,rs,happy_var_5)) happy_var_3 occs
	) `HappyStk` happyRest}}}}}

happyReduce_488 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_488 = happyMonadReduce 5# 157# happyReduction_488
happyReduction_488 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwWARNING_ON_USAGE happy_var_2) -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokLiteral happy_var_4) -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	(  case happy_var_4 of
        { LitString r str -> return $ WarningOnUsage (getRange (happy_var_1,happy_var_2,happy_var_3,r,happy_var_5)) happy_var_3 str
        ; _ -> parseError "Expected string literal"
        })}}}}})
	) (\r -> happyReturn (happyIn167 r))

happyReduce_489 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_489 = happySpecReduce_0  158# happyReduction_489
happyReduction_489  =  happyIn168
		 ([]
	)

happyReduce_490 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_490 = happySpecReduce_2  158# happyReduction_490
happyReduction_490 happy_x_2
	happy_x_1
	 =  case happyOut168 happy_x_1 of { happy_var_1 -> 
	case happyOut169 happy_x_2 of { happy_var_2 -> 
	happyIn168
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_491 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_491 = happyMonadReduce 1# 159# happyReduction_491
happyReduction_491 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	( polarity happy_var_1)})
	) (\r -> happyReturn (happyIn169 r))

happyReduce_492 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_492 = happySpecReduce_3  160# happyReduction_492
happyReduction_492 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut171 happy_x_2 of { happy_var_2 -> 
	happyIn170
		 (reverse happy_var_2
	)}

happyReduce_493 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_493 = happySpecReduce_3  161# happyReduction_493
happyReduction_493 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut171 happy_x_1 of { happy_var_1 -> 
	case happyOut100 happy_x_3 of { happy_var_3 -> 
	happyIn171
		 (reverse happy_var_3 ++ happy_var_1
	)}}

happyReduce_494 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_494 = happySpecReduce_1  161# happyReduction_494
happyReduction_494 happy_x_1
	 =  case happyOut100 happy_x_1 of { happy_var_1 -> 
	happyIn171
		 (reverse happy_var_1
	)}

happyReduce_495 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_495 = happySpecReduce_3  162# happyReduction_495
happyReduction_495 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut173 happy_x_2 of { happy_var_2 -> 
	happyIn172
		 (reverse happy_var_2
	)}

happyReduce_496 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_496 = happySpecReduce_3  163# happyReduction_496
happyReduction_496 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut173 happy_x_1 of { happy_var_1 -> 
	case happyOut101 happy_x_3 of { happy_var_3 -> 
	happyIn173
		 (reverse happy_var_3 ++ happy_var_1
	)}}

happyReduce_497 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_497 = happySpecReduce_1  163# happyReduction_497
happyReduction_497 happy_x_1
	 =  case happyOut101 happy_x_1 of { happy_var_1 -> 
	happyIn173
		 (reverse happy_var_1
	)}

happyReduce_498 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_498 = happyMonadReduce 3# 164# happyReduction_498
happyReduction_498 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut175 happy_x_2 of { happy_var_2 -> 
	( ((,) `fmap` verifyRecordDirectives happy_var_2 <*> pure []))})
	) (\r -> happyReturn (happyIn174 r))

happyReduce_499 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_499 = happyMonadReduce 5# 164# happyReduction_499
happyReduction_499 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut175 happy_x_2 of { happy_var_2 -> 
	case happyOut181 happy_x_4 of { happy_var_4 -> 
	( ((,) `fmap` verifyRecordDirectives happy_var_2 <*> pure happy_var_4))}})
	) (\r -> happyReturn (happyIn174 r))

happyReduce_500 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_500 = happyMonadReduce 3# 164# happyReduction_500
happyReduction_500 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen ((case happyOut181 happy_x_2 of { happy_var_2 -> 
	( ((,) `fmap` verifyRecordDirectives [] <*> pure happy_var_2))})
	) (\r -> happyReturn (happyIn174 r))

happyReduce_501 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_501 = happySpecReduce_0  165# happyReduction_501
happyReduction_501  =  happyIn175
		 ([]
	)

happyReduce_502 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_502 = happySpecReduce_3  165# happyReduction_502
happyReduction_502 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut175 happy_x_1 of { happy_var_1 -> 
	case happyOut176 happy_x_3 of { happy_var_3 -> 
	happyIn175
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_503 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_503 = happySpecReduce_1  165# happyReduction_503
happyReduction_503 happy_x_1
	 =  case happyOut176 happy_x_1 of { happy_var_1 -> 
	happyIn175
		 ([happy_var_1]
	)}

happyReduce_504 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_504 = happySpecReduce_1  166# happyReduction_504
happyReduction_504 happy_x_1
	 =  case happyOut108 happy_x_1 of { happy_var_1 -> 
	happyIn176
		 (Constructor happy_var_1
	)}

happyReduce_505 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_505 = happySpecReduce_1  166# happyReduction_505
happyReduction_505 happy_x_1
	 =  case happyOut178 happy_x_1 of { happy_var_1 -> 
	happyIn176
		 (Induction happy_var_1
	)}

happyReduce_506 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_506 = happySpecReduce_1  166# happyReduction_506
happyReduction_506 happy_x_1
	 =  case happyOut177 happy_x_1 of { happy_var_1 -> 
	happyIn176
		 (Eta happy_var_1
	)}

happyReduce_507 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_507 = happySpecReduce_1  167# happyReduction_507
happyReduction_507 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwEta happy_var_1) -> 
	happyIn177
		 (Ranged (getRange happy_var_1) YesEta
	)}

happyReduce_508 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_508 = happySpecReduce_1  167# happyReduction_508
happyReduction_508 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNoEta happy_var_1) -> 
	happyIn177
		 (Ranged (getRange happy_var_1) NoEta
	)}

happyReduce_509 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_509 = happySpecReduce_1  168# happyReduction_509
happyReduction_509 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInductive happy_var_1) -> 
	happyIn178
		 (Ranged (getRange happy_var_1) Inductive
	)}

happyReduce_510 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_510 = happySpecReduce_1  168# happyReduction_510
happyReduction_510 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCoInductive happy_var_1) -> 
	happyIn178
		 (Ranged (getRange happy_var_1) CoInductive
	)}

happyReduce_511 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_511 = happySpecReduce_3  169# happyReduction_511
happyReduction_511 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut181 happy_x_2 of { happy_var_2 -> 
	happyIn179
		 (happy_var_2
	)}

happyReduce_512 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_512 = happySpecReduce_2  170# happyReduction_512
happyReduction_512 happy_x_2
	happy_x_1
	 =  happyIn180
		 ([]
	)

happyReduce_513 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_513 = happySpecReduce_1  170# happyReduction_513
happyReduction_513 happy_x_1
	 =  case happyOut179 happy_x_1 of { happy_var_1 -> 
	happyIn180
		 (happy_var_1
	)}

happyReduce_514 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_514 = happySpecReduce_3  171# happyReduction_514
happyReduction_514 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut99 happy_x_1 of { happy_var_1 -> 
	case happyOut181 happy_x_3 of { happy_var_3 -> 
	happyIn181
		 (happy_var_1 ++ happy_var_3
	)}}

happyReduce_515 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_515 = happySpecReduce_2  171# happyReduction_515
happyReduction_515 happy_x_2
	happy_x_1
	 =  case happyOut99 happy_x_1 of { happy_var_1 -> 
	happyIn181
		 (happy_var_1
	)}

happyReduce_516 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_516 = happySpecReduce_1  171# happyReduction_516
happyReduction_516 happy_x_1
	 =  case happyOut99 happy_x_1 of { happy_var_1 -> 
	happyIn181
		 (happy_var_1
	)}

happyReduce_517 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_517 = happySpecReduce_0  172# happyReduction_517
happyReduction_517  =  happyIn182
		 ([]
	)

happyReduce_518 :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )
happyReduce_518 = happySpecReduce_1  172# happyReduction_518
happyReduction_518 happy_x_1
	 =  case happyOut181 happy_x_1 of { happy_var_1 -> 
	happyIn182
		 (happy_var_1
	)}

happyNewToken action sts stk
	= lexer(\tk -> 
	let cont i = happyDoAction i tk action sts stk in
	case tk of {
	TokEOF -> happyDoAction 110# tk action sts stk;
	TokKeyword KwAbstract happy_dollar_dollar -> cont 1#;
	TokKeyword KwCoData happy_dollar_dollar -> cont 2#;
	TokKeyword KwCoInductive happy_dollar_dollar -> cont 3#;
	TokKeyword KwConstructor happy_dollar_dollar -> cont 4#;
	TokKeyword KwData happy_dollar_dollar -> cont 5#;
	TokKeyword KwEta happy_dollar_dollar -> cont 6#;
	TokKeyword KwField happy_dollar_dollar -> cont 7#;
	TokKeyword KwForall happy_dollar_dollar -> cont 8#;
	TokKeyword KwHiding happy_dollar_dollar -> cont 9#;
	TokKeyword KwImport happy_dollar_dollar -> cont 10#;
	TokKeyword KwIn happy_dollar_dollar -> cont 11#;
	TokKeyword KwInductive happy_dollar_dollar -> cont 12#;
	TokKeyword KwInfix happy_dollar_dollar -> cont 13#;
	TokKeyword KwInfixL happy_dollar_dollar -> cont 14#;
	TokKeyword KwInfixR happy_dollar_dollar -> cont 15#;
	TokKeyword KwInstance happy_dollar_dollar -> cont 16#;
	TokKeyword KwOverlap happy_dollar_dollar -> cont 17#;
	TokKeyword KwLet happy_dollar_dollar -> cont 18#;
	TokKeyword KwMacro happy_dollar_dollar -> cont 19#;
	TokKeyword KwModule happy_dollar_dollar -> cont 20#;
	TokKeyword KwMutual happy_dollar_dollar -> cont 21#;
	TokKeyword KwNoEta happy_dollar_dollar -> cont 22#;
	TokKeyword KwOpen happy_dollar_dollar -> cont 23#;
	TokKeyword KwPatternSyn happy_dollar_dollar -> cont 24#;
	TokKeyword KwPostulate happy_dollar_dollar -> cont 25#;
	TokKeyword KwPrimitive happy_dollar_dollar -> cont 26#;
	TokKeyword KwPrivate happy_dollar_dollar -> cont 27#;
	TokKeyword KwProp happy_dollar_dollar -> cont 28#;
	TokKeyword KwPublic happy_dollar_dollar -> cont 29#;
	TokKeyword KwQuote happy_dollar_dollar -> cont 30#;
	TokKeyword KwQuoteContext happy_dollar_dollar -> cont 31#;
	TokKeyword KwQuoteGoal happy_dollar_dollar -> cont 32#;
	TokKeyword KwQuoteTerm happy_dollar_dollar -> cont 33#;
	TokKeyword KwRecord happy_dollar_dollar -> cont 34#;
	TokKeyword KwRenaming happy_dollar_dollar -> cont 35#;
	TokKeyword KwRewrite happy_dollar_dollar -> cont 36#;
	TokKeyword KwSet happy_dollar_dollar -> cont 37#;
	TokKeyword KwSyntax happy_dollar_dollar -> cont 38#;
	TokKeyword KwTactic happy_dollar_dollar -> cont 39#;
	TokKeyword KwTo happy_dollar_dollar -> cont 40#;
	TokKeyword KwUnquote happy_dollar_dollar -> cont 41#;
	TokKeyword KwUnquoteDecl happy_dollar_dollar -> cont 42#;
	TokKeyword KwUnquoteDef happy_dollar_dollar -> cont 43#;
	TokKeyword KwUsing happy_dollar_dollar -> cont 44#;
	TokKeyword KwWhere happy_dollar_dollar -> cont 45#;
	TokKeyword KwDo happy_dollar_dollar -> cont 46#;
	TokKeyword KwWith happy_dollar_dollar -> cont 47#;
	TokKeyword KwBUILTIN happy_dollar_dollar -> cont 48#;
	TokKeyword KwCATCHALL happy_dollar_dollar -> cont 49#;
	TokKeyword KwCOMPILED happy_dollar_dollar -> cont 50#;
	TokKeyword KwCOMPILED_DATA happy_dollar_dollar -> cont 51#;
	TokKeyword KwCOMPILED_DATA_UHC happy_dollar_dollar -> cont 52#;
	TokKeyword KwCOMPILED_EXPORT happy_dollar_dollar -> cont 53#;
	TokKeyword KwCOMPILED_JS happy_dollar_dollar -> cont 54#;
	TokKeyword KwCOMPILED_TYPE happy_dollar_dollar -> cont 55#;
	TokKeyword KwCOMPILED_UHC happy_dollar_dollar -> cont 56#;
	TokKeyword KwDISPLAY happy_dollar_dollar -> cont 57#;
	TokKeyword KwETA happy_dollar_dollar -> cont 58#;
	TokKeyword KwHASKELL happy_dollar_dollar -> cont 59#;
	TokKeyword KwIMPORT happy_dollar_dollar -> cont 60#;
	TokKeyword KwIMPORT_UHC happy_dollar_dollar -> cont 61#;
	TokKeyword KwFOREIGN happy_dollar_dollar -> cont 62#;
	TokKeyword KwCOMPILE happy_dollar_dollar -> cont 63#;
	TokKeyword KwIMPOSSIBLE happy_dollar_dollar -> cont 64#;
	TokKeyword KwINJECTIVE happy_dollar_dollar -> cont 65#;
	TokKeyword KwINLINE happy_dollar_dollar -> cont 66#;
	TokKeyword KwNOINLINE happy_dollar_dollar -> cont 67#;
	TokKeyword KwMEASURE happy_dollar_dollar -> cont 68#;
	TokKeyword KwNO_TERMINATION_CHECK happy_dollar_dollar -> cont 69#;
	TokKeyword KwNO_POSITIVITY_CHECK happy_dollar_dollar -> cont 70#;
	TokKeyword KwNON_TERMINATING happy_dollar_dollar -> cont 71#;
	TokKeyword KwOPTIONS happy_dollar_dollar -> cont 72#;
	TokKeyword KwPOLARITY happy_dollar_dollar -> cont 73#;
	TokKeyword KwWARNING_ON_USAGE happy_dollar_dollar -> cont 74#;
	TokKeyword KwREWRITE happy_dollar_dollar -> cont 75#;
	TokKeyword KwSTATIC happy_dollar_dollar -> cont 76#;
	TokKeyword KwTERMINATING happy_dollar_dollar -> cont 77#;
	TokSetN happy_dollar_dollar -> cont 78#;
	TokTeX happy_dollar_dollar -> cont 79#;
	TokComment happy_dollar_dollar -> cont 80#;
	TokSymbol SymEllipsis happy_dollar_dollar -> cont 81#;
	TokSymbol SymDotDot happy_dollar_dollar -> cont 82#;
	TokSymbol SymDot happy_dollar_dollar -> cont 83#;
	TokSymbol SymSemi happy_dollar_dollar -> cont 84#;
	TokSymbol SymColon happy_dollar_dollar -> cont 85#;
	TokSymbol SymEqual happy_dollar_dollar -> cont 86#;
	TokSymbol SymUnderscore happy_dollar_dollar -> cont 87#;
	TokSymbol SymQuestionMark happy_dollar_dollar -> cont 88#;
	TokSymbol SymArrow happy_dollar_dollar -> cont 89#;
	TokSymbol SymLambda happy_dollar_dollar -> cont 90#;
	TokSymbol SymAs happy_dollar_dollar -> cont 91#;
	TokSymbol SymBar happy_dollar_dollar -> cont 92#;
	TokSymbol SymOpenParen happy_dollar_dollar -> cont 93#;
	TokSymbol SymCloseParen happy_dollar_dollar -> cont 94#;
	TokSymbol SymOpenIdiomBracket happy_dollar_dollar -> cont 95#;
	TokSymbol SymCloseIdiomBracket happy_dollar_dollar -> cont 96#;
	TokSymbol SymDoubleOpenBrace happy_dollar_dollar -> cont 97#;
	TokSymbol SymDoubleCloseBrace happy_dollar_dollar -> cont 98#;
	TokSymbol SymOpenBrace happy_dollar_dollar -> cont 99#;
	TokSymbol SymCloseBrace happy_dollar_dollar -> cont 100#;
	TokSymbol SymOpenVirtualBrace happy_dollar_dollar -> cont 101#;
	TokSymbol SymCloseVirtualBrace happy_dollar_dollar -> cont 102#;
	TokSymbol SymVirtualSemi happy_dollar_dollar -> cont 103#;
	TokSymbol SymOpenPragma happy_dollar_dollar -> cont 104#;
	TokSymbol SymClosePragma happy_dollar_dollar -> cont 105#;
	TokId happy_dollar_dollar -> cont 106#;
	TokQId happy_dollar_dollar -> cont 107#;
	TokString happy_dollar_dollar -> cont 108#;
	TokLiteral happy_dollar_dollar -> cont 109#;
	_ -> happyError' (tk, [])
	})

happyError_ explist 110# tk = happyError' (tk, explist)
happyError_ explist _ tk = happyError' (tk, explist)

happyThen :: () => Parser a -> (a -> Parser b) -> Parser b
happyThen = (>>=)
happyReturn :: () => a -> Parser a
happyReturn = (return)
happyParse :: () => Happy_GHC_Exts.Int# -> Parser (HappyAbsSyn )

happyNewToken :: () => Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )

happyDoAction :: () => Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn )

happyReduceArr :: () => Happy_Data_Array.Array Int (Happy_GHC_Exts.Int# -> Token -> Happy_GHC_Exts.Int# -> Happy_IntList -> HappyStk (HappyAbsSyn ) -> Parser (HappyAbsSyn ))

happyThen1 :: () => Parser a -> (a -> Parser b) -> Parser b
happyThen1 = happyThen
happyReturn1 :: () => a -> Parser a
happyReturn1 = happyReturn
happyError' :: () => ((Token), [String]) -> Parser a
happyError' tk = (\(tokens, explist) -> happyError) tk
tokensParser = happySomeParser where
 happySomeParser = happyThen (happyParse 0#) (\x -> happyReturn (happyOut10 x))

exprParser = happySomeParser where
 happySomeParser = happyThen (happyParse 1#) (\x -> happyReturn (happyOut39 x))

exprWhereParser = happySomeParser where
 happySomeParser = happyThen (happyParse 2#) (\x -> happyReturn (happyOut98 x))

moduleParser = happySomeParser where
 happySomeParser = happyThen (happyParse 3#) (\x -> happyReturn (happyOut13 x))

moduleNameParser = happySomeParser where
 happySomeParser = happyThen (happyParse 4#) (\x -> happyReturn (happyOut26 x))

funclauseParser = happySomeParser where
 happySomeParser = happyThen (happyParse 5#) (\x -> happyReturn (happyOut102 x))

holeContentParser = happySomeParser where
 happySomeParser = happyThen (happyParse 6#) (\x -> happyReturn (happyOut96 x))

happySeq = happyDontSeq


{--------------------------------------------------------------------------
    Parsers
 --------------------------------------------------------------------------}

-- | Parse the token stream. Used by the TeX compiler.
tokensParser :: Parser [Token]

-- | Parse an expression. Could be used in interactions.
exprParser :: Parser Expr

-- | Parse an expression followed by a where clause. Could be used in interactions.
exprWhereParser :: Parser ExprWhere

-- | Parse a module.
moduleParser :: Parser Module


{--------------------------------------------------------------------------
    Happy stuff
 --------------------------------------------------------------------------}

-- | Required by Happy.
happyError :: Parser a
happyError = parseError "Parse error"


{--------------------------------------------------------------------------
    Utility functions
 --------------------------------------------------------------------------}

-- | Grab leading OPTIONS pragmas.
takeOptionsPragmas :: [Declaration] -> ([Pragma], [Declaration])
takeOptionsPragmas = spanJust $ \ d -> case d of
  Pragma p@OptionsPragma{} -> Just p
  _                        -> Nothing

-- | Insert a top-level module if there is none.
--   Also fix-up for the case the declarations in the top-level module
--   are not indented (this is allowed as a special case).
figureOutTopLevelModule :: [Declaration] -> [Declaration]
figureOutTopLevelModule ds =
  case spanAllowedBeforeModule ds of
    -- Andreas 2016-02-01, issue #1388.
    -- We need to distinguish two additional cases.

    -- Case 1: Regular file layout: imports followed by one module. Nothing to do.
    (ds0, [ Module{} ]) -> ds

    -- Case 2: The declarations in the module are not indented.
    -- This is allowed for the top level module, and thus rectified here.
    (ds0, Module r m tel [] : ds2) -> ds0 ++ [Module r m tel ds2]

    -- Case 3: There is a module with indented declarations,
    -- followed by non-indented declarations.  This should be a
    -- parse error and be reported later (see @toAbstract TopLevel{}@),
    -- thus, we do not do anything here.
    (ds0, Module r m tel ds1 : ds2) -> ds  -- Gives parse error in scope checker.
    -- OLD code causing issue 1388:
    -- (ds0, Module r m tel ds1 : ds2) -> ds0 ++ [Module r m tel $ ds1 ++ ds2]

    -- Case 4: a top-level module declaration is missing.
    -- Andreas, 2017-01-01, issue #2229:
    -- Put everything (except OPTIONS pragmas) into an anonymous module.
    _ -> ds0 ++ [Module r (QName $ noName r) [] ds1]
      where
      (ds0, ds1) = (`span` ds) $ \case
        Pragma OptionsPragma{} -> True
        _ -> False
      -- Andreas, 2017-05-17, issue #2574.
      -- Since the module noName will act as jump target, it needs a range.
      -- We use the beginning of the file as beginning of the top level module.
      r = beginningOfFile $ getRange ds1

-- | Create a name from a string.

mkName :: (Interval, String) -> Parser Name
mkName (i, s) = do
    let xs = C.stringNameParts s
    mapM_ isValidId xs
    unless (alternating xs) $ fail $ "a name cannot contain two consecutive underscores"
    return $ Name (getRange i) xs
    where
        isValidId Hole   = return ()
        isValidId (Id y) = do
          let x = rawNameToString y
              err = "in the name " ++ s ++ ", the part " ++ x ++ " is not valid"
          case parse defaultParseFlags [0] (lexer return) x of
            ParseOk _ TokId{}  -> return ()
            ParseFailed{}      -> fail err
            ParseOk _ TokEOF{} -> fail err
            ParseOk _ t   -> fail . ((err ++ " because it is ") ++) $ case t of
              TokId{}       -> __IMPOSSIBLE__
              TokQId{}      -> __IMPOSSIBLE__ -- "qualified"
              TokKeyword{}  -> "a keyword"
              TokLiteral{}  -> "a literal"
              TokSymbol s _ -> case s of
                SymDot               -> __IMPOSSIBLE__ -- "reserved"
                SymSemi              -> "used to separate declarations"
                SymVirtualSemi       -> __IMPOSSIBLE__
                SymBar               -> "used for with-arguments"
                SymColon             -> "part of declaration syntax"
                SymArrow             -> "the function arrow"
                SymEqual             -> "part of declaration syntax"
                SymLambda            -> "used for lambda-abstraction"
                SymUnderscore        -> "used for anonymous identifiers"
                SymQuestionMark      -> "a meta variable"
                SymAs                -> "used for as-patterns"
                SymOpenParen         -> "used to parenthesize expressions"
                SymCloseParen        -> "used to parenthesize expressions"
                SymOpenIdiomBracket  -> "an idiom bracket"
                SymCloseIdiomBracket -> "an idiom bracket"
                SymDoubleOpenBrace   -> "used for instance arguments"
                SymDoubleCloseBrace  -> "used for instance arguments"
                SymOpenBrace         -> "used for hidden arguments"
                SymCloseBrace        -> "used for hidden arguments"
                SymOpenVirtualBrace  -> __IMPOSSIBLE__
                SymCloseVirtualBrace -> __IMPOSSIBLE__
                SymOpenPragma        -> __IMPOSSIBLE__ -- "used for pragmas"
                SymClosePragma       -> __IMPOSSIBLE__ -- "used for pragmas"
                SymEllipsis          -> __IMPOSSIBLE__ -- "used for function clauses"
                SymDotDot            -> __IMPOSSIBLE__ -- "a modality"
                SymEndComment        -> "the end-of-comment brace"
              TokString{}   -> __IMPOSSIBLE__
              TokSetN{}     -> "a type universe"
              TokTeX{}      -> __IMPOSSIBLE__  -- used by the LaTeX backend only
              TokComment{}  -> __IMPOSSIBLE__
              TokDummy{}    -> __IMPOSSIBLE__
              TokEOF{}      -> __IMPOSSIBLE__

        -- we know that there are no two Ids in a row
        alternating (Hole : Hole : _) = False
        alternating (_ : xs)          = alternating xs
        alternating []                = True

-- | Create a qualified name from a list of strings
mkQName :: [(Interval, String)] -> Parser QName
mkQName ss = do
    xs <- mapM mkName ss
    return $ foldr Qual (QName $ last xs) (init xs)

-- | Create a qualified name from a string (used in pragmas).
--   Range of each name component is range of whole string.
--   TODO: precise ranges!

pragmaQName :: (Interval, String) -> Parser QName
pragmaQName (r, s) = do
  let ss = chopWhen (== '.') s
  mkQName $ map (r,) ss

-- | Polarity parser.

polarity :: (Interval, String) -> Parser (Range, Occurrence)
polarity (i, s) =
  case s of
    "_"  -> ret Unused
    "++" -> ret StrictPos
    "+"  -> ret JustPos
    "-"  -> ret JustNeg
    "*"  -> ret Mixed
    _    -> fail $ "Not a valid polarity: " ++ s
  where
  ret x = return (getRange i, x)

recoverLayout :: [(Interval, String)] -> String
recoverLayout [] = ""
recoverLayout xs@((i, _) : _) = go (iStart i) xs
  where
    c0 = posCol (iStart i)

    go cur [] = ""
    go cur ((i, s) : xs) = padding cur (iStart i) ++ s ++ go (iEnd i) xs

    padding Pn{ posLine = l1, posCol = c1 } Pn{ posLine = l2, posCol = c2 }
      | l1 < l2  = genericReplicate (l2 - l1) '\n' ++ genericReplicate (max 0 (c2 - c0)) ' '
      | l1 == l2 = genericReplicate (c2 - c1) ' '

ensureUnqual :: QName -> Parser Name
ensureUnqual (QName x) = return x
ensureUnqual q@Qual{}  = parseError' (rStart' $ getRange q) "Qualified name not allowed here"

-- | Match a particular name.
isName :: String -> (Interval, String) -> Parser ()
isName s (_,s')
    | s == s'   = return ()
    | otherwise = fail $ "expected " ++ s ++ ", found " ++ s'

-- | Build a forall pi (forall x y z -> ...)
forallPi :: [LamBinding] -> Expr -> Expr
forallPi bs e = Pi (map addType bs) e

-- | Build a telescoping let (let Ds)
tLet :: Range -> [Declaration] -> TypedBindings
tLet r = TypedBindings r . Arg defaultArgInfo . TLet r

-- | Converts lambda bindings to typed bindings.
addType :: LamBinding -> TypedBindings
addType (DomainFull b)   = b
addType (DomainFree info x) = TypedBindings r $ Arg info $ TBind r [pure x] $ Underscore r Nothing
  where r = getRange x

-- | Build a do-statement
buildDoStmt :: Expr -> [LamClause] -> Parser DoStmt
buildDoStmt (RawApp r [e]) cs = buildDoStmt e cs
buildDoStmt (Let r ds Nothing) [] = return $ DoLet r ds
buildDoStmt (RawApp r es) cs
  | (es1, arr : es2) <- break isLeftArrow es =
    case filter isLeftArrow es2 of
      arr : _ -> parseError' (rStart' $ getRange arr) $ "Unexpected " ++ prettyShow arr
      [] -> DoBind (getRange arr)
              <$> exprToPattern (RawApp (getRange es1) es1)
              <*> pure (RawApp (getRange es2) es2)
              <*> pure cs
  where
    isLeftArrow (Ident (QName (Name _ [Id arr]))) = elem arr ["<-", "←"]
    isLeftArrow _ = False
buildDoStmt e (_ : _) = parseError' (rStart' $ getRange e) "Only pattern matching do-statements can have where clauses."
buildDoStmt e [] = return $ DoThen e

mergeImportDirectives :: [ImportDirective] -> Parser ImportDirective
mergeImportDirectives is = do
  i <- foldl merge (return defaultImportDir) is
  verifyImportDirective i
  where
    merge mi i2 = do
      i1 <- mi
      let err = parseError' (rStart' $ getRange i2) "Cannot mix using and hiding module directives"
      return $ ImportDirective
        { importDirRange = fuseRange i1 i2
        , using          = mappend (using i1) (using i2)
        , hiding         = hiding i1 ++ hiding i2
        , impRenaming    = impRenaming i1 ++ impRenaming i2
        , publicOpen     = publicOpen i1 || publicOpen i2 }

-- | Check that an import directive doesn't contain repeated names
verifyImportDirective :: ImportDirective -> Parser ImportDirective
verifyImportDirective i =
    case filter ((>1) . length)
         $ group
         $ sort xs
    of
        []  -> return i
        yss -> let Just pos = rStart' $ getRange $ head $ concat yss in
               parseErrorAt pos $
                "Repeated name" ++ s ++ " in import directive: " ++
                concat (intersperse ", " $ map (show . head) yss)
            where
                s = case yss of
                        [_] -> ""
                        _   -> "s"
    where
        xs = names (using i) ++ hiding i ++ map renFrom (impRenaming i)
        names (Using xs)    = xs
        names UseEverything = []

data RecordDirective
   = Induction (Ranged Induction)
   | Constructor (Name, IsInstance)
   | Eta         (Ranged HasEta)
   deriving (Eq,Show)

verifyRecordDirectives :: [RecordDirective] -> Parser (Maybe (Ranged Induction), Maybe HasEta, Maybe (Name, IsInstance))
verifyRecordDirectives xs | null rs = return (ltm is, ltm es, ltm cs)
                          | otherwise = let Just pos = rStart' $ (head rs) in
                                          parseErrorAt pos $ "Repeated record directives at: \n" ++ intercalate "\n" (map show rs)

 where
  ltm :: [a] -> Maybe a
  ltm [] = Nothing
  ltm (x:xs) = Just x
  errorFromList [] = []
  errorFromList [x] = []
  errorFromList xs = map getRange xs
  rs = sort (concat ([errorFromList is, errorFromList es', errorFromList cs]))
  is = [ i | Induction i <- xs ]
  es' = [ i | Eta i <- xs ]
  es = map rangedThing es'
  cs = [ i | Constructor i <- xs ]


-- | Breaks up a string into substrings. Returns every maximal
-- subsequence of zero or more characters distinct from @'.'@.
--
-- > splitOnDots ""         == [""]
-- > splitOnDots "foo.bar"  == ["foo", "bar"]
-- > splitOnDots ".foo.bar" == ["", "foo", "bar"]
-- > splitOnDots "foo.bar." == ["foo", "bar", ""]
-- > splitOnDots "foo..bar" == ["foo", "", "bar"]
splitOnDots :: String -> [String]
splitOnDots ""        = [""]
splitOnDots ('.' : s) = [] : splitOnDots s
splitOnDots (c   : s) = case splitOnDots s of
  p : ps -> (c : p) : ps


-- | Returns 'True' iff the name is a valid Haskell (hierarchical)
-- module name.
validHaskellModuleName :: String -> Bool
validHaskellModuleName = all ok . splitOnDots
  where
  -- Checks if a dot-less module name is well-formed.
  ok :: String -> Bool
  ok []      = False
  ok (c : s) =
    isUpper c &&
    all (\c -> isLower c || c == '_' ||
               isUpper c ||
               generalCategory c == DecimalNumber ||
               c == '\'')
        s

{--------------------------------------------------------------------------
    Patterns
 --------------------------------------------------------------------------}

-- | Turn an expression into a left hand side.
exprToLHS :: Expr -> Parser ([Expr] -> [Expr] -> LHS)
exprToLHS e = LHS <$> exprToPattern e

-- | Turn an expression into a pattern. Fails if the expression is not a
--   valid pattern.
exprToPattern :: Expr -> Parser Pattern
exprToPattern e = do
    let Just pos = rStart' $ getRange e
        failure = parseErrorAt pos $ "Not a valid pattern: " ++ show e
    case e of
        Ident x                 -> return $ IdentP x
        App _ e1 e2             -> AppP <$> exprToPattern e1
                                        <*> T.mapM (T.mapM exprToPattern) e2
        Paren r e               -> ParenP r
                                        <$> exprToPattern e
        Underscore r _          -> return $ WildP r
        Absurd r                -> return $ AbsurdP r
        As r x e                -> AsP r x <$> exprToPattern e
        Dot r (HiddenArg _ e)   -> return $ HiddenP r $ fmap (DotP r) e
        Dot r e                 -> return $ DotP r e
        Lit l                   -> return $ LitP l
        HiddenArg r e           -> HiddenP r <$> T.mapM exprToPattern e
        InstanceArg r e         -> InstanceP r <$> T.mapM exprToPattern e
        RawApp r es             -> RawAppP r <$> mapM exprToPattern es
        Quote r                 -> return $ QuoteP r
        Rec r es | Just fs <- mapM maybeLeft es -> do
          RecP r <$> T.mapM (T.mapM exprToPattern) fs
        Ellipsis r              -> return $ EllipsisP r
        -- WithApp has already lost the range information of the bars '|'
        WithApp r e es          -> do
          p  <- exprToPattern e
          ps <- forM es $ \ e -> defaultNamedArg . WithP (getRange e) <$> exprToPattern e  -- TODO #2822: Range!
          return $ foldl AppP p ps
        _ -> failure

opAppExprToPattern :: OpApp Expr -> Parser Pattern
opAppExprToPattern (SyntaxBindingLambda _ _ _) = parseError "Syntax binding lambda cannot appear in a pattern"
opAppExprToPattern (Ordinary e) = exprToPattern e

-- | Turn an expression into a name. Fails if the expression is not a
--   valid identifier.
exprToName :: Expr -> Parser Name
exprToName (Ident (QName x)) = return x
exprToName e =
  let Just pos = rStart' $ getRange e in
  parseErrorAt pos $ "Not a valid identifier: " ++ show e

stripSingletonRawApp :: Expr -> Expr
stripSingletonRawApp (RawApp _ [e]) = stripSingletonRawApp e
stripSingletonRawApp e = e

isEqual :: Expr -> Maybe (Expr, Expr)
isEqual e =
  case stripSingletonRawApp e of
    Equal _ a b -> Just (stripSingletonRawApp a, stripSingletonRawApp b)
    _           -> Nothing

maybeNamed :: Expr -> Named_ Expr
maybeNamed e =
  case isEqual e of
    Just (Ident (QName x), b) -> named (Ranged (getRange x) (nameToRawName x)) b
    _                         -> unnamed e

patternSynArgs :: [Either Hiding LamBinding] -> Parser [Arg Name]
patternSynArgs = mapM pSynArg
  where
    pSynArg Left{}                   = parseError "Absurd patterns are not allowed in pattern synonyms"
    pSynArg (Right DomainFull{})     = parseError "Unexpected type signature in pattern synonym argument"
    pSynArg (Right (DomainFree a x))
      | getHiding a `notElem` [Hidden, NotHidden] = parseError $ show (getHiding a) ++ " arguments not allowed to pattern synonyms"
      | getRelevance a /= Relevant                = parseError "Arguments to pattern synonyms must be relevant"
      | otherwise                                 = return $ Arg a (boundName x)

parsePanic s = parseError $ "Internal parser error: " ++ s ++ ". Please report this as a bug."

{- RHS or type signature -}

data RHSOrTypeSigs
 = JustRHS RHS
 | TypeSigsRHS Expr
 deriving Show

patternToNames :: Pattern -> Parser [(ArgInfo, Name)]
patternToNames p =
  case p of
    IdentP (QName i)         -> return [(defaultArgInfo, i)]
    WildP r                  -> return [(defaultArgInfo, C.noName r)]
    DotP _ (Ident (QName i)) -> return [(setRelevance Irrelevant defaultArgInfo, i)]
    RawAppP _ ps             -> concat <$> mapM patternToNames ps
    _                        -> parseError $
      "Illegal name in type signature: " ++ prettyShow p

funClauseOrTypeSigs :: LHS -> RHSOrTypeSigs -> WhereClause -> Parser [Declaration]
funClauseOrTypeSigs lhs mrhs wh = do
  -- traceShowM lhs
  case mrhs of
    JustRHS rhs   -> return [FunClause lhs rhs wh False]
    TypeSigsRHS e -> case wh of
      NoWhere -> case lhs of
        LHS p _ _ | hasEllipsis p -> parseError "The ellipsis ... cannot have a type signature"
        LHS _ _ (_:_) -> parseError "Illegal: with in type signature"
        LHS _ (_:_) _ -> parseError "Illegal: rewrite in type signature"
        LHS p _ _ | hasWithPatterns p -> parseError "Illegal: with patterns in type signature"
        LHS p [] []  -> map (\ (x, y) -> TypeSig x y e) <$> patternToNames p
      _ -> parseError "A type signature cannot have a where clause"

parseDisplayPragma :: Range -> Position -> String -> Parser Pragma
parseDisplayPragma r pos s =
  case parsePosString pos defaultParseFlags [normal] funclauseParser s of
    ParseOk s [FunClause (LHS lhs [] []) (RHS rhs) NoWhere ca] | null (parseInp s) ->
      return $ DisplayPragma r lhs rhs
    _ -> parseError "Invalid DISPLAY pragma. Should have form {-# DISPLAY LHS = RHS #-}."
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "<built-in>" #-}
{-# LINE 1 "<command-line>" #-}
{-# LINE 10 "<command-line>" #-}
# 1 "/usr/include/stdc-predef.h" 1 3 4

# 17 "/usr/include/stdc-predef.h" 3 4











































{-# LINE 10 "<command-line>" #-}
{-# LINE 1 "/usr/local/stow/ghc-8.4.3/lib/ghc-8.4.3/include/ghcversion.h" #-}















{-# LINE 10 "<command-line>" #-}
{-# LINE 1 "/tmp/ghc8142_0/ghc_2.h" #-}




















































































































































































{-# LINE 10 "<command-line>" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
-- Id: GenericTemplate.hs,v 1.26 2005/01/14 14:47:22 simonmar Exp 













-- Do not remove this comment. Required to fix CPP parsing when using GCC and a clang-compiled alex.
#if __GLASGOW_HASKELL__ > 706
#define LT(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.<# m)) :: Bool)
#define GTE(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.>=# m)) :: Bool)
#define EQ(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.==# m)) :: Bool)
#else
#define LT(n,m) (n Happy_GHC_Exts.<# m)
#define GTE(n,m) (n Happy_GHC_Exts.>=# m)
#define EQ(n,m) (n Happy_GHC_Exts.==# m)
#endif
{-# LINE 43 "templates/GenericTemplate.hs" #-}

data Happy_IntList = HappyCons Happy_GHC_Exts.Int# Happy_IntList







{-# LINE 65 "templates/GenericTemplate.hs" #-}

{-# LINE 75 "templates/GenericTemplate.hs" #-}

{-# LINE 84 "templates/GenericTemplate.hs" #-}

infixr 9 `HappyStk`
data HappyStk a = HappyStk a (HappyStk a)

-----------------------------------------------------------------------------
-- starting the parse

happyParse start_state = happyNewToken start_state notHappyAtAll notHappyAtAll

-----------------------------------------------------------------------------
-- Accepting the parse

-- If the current token is 0#, it means we've just accepted a partial
-- parse (a %partial parser).  We must ignore the saved token on the top of
-- the stack in this case.
happyAccept 0# tk st sts (_ `HappyStk` ans `HappyStk` _) =
        happyReturn1 ans
happyAccept j tk st sts (HappyStk ans _) = 
        (happyTcHack j (happyTcHack st)) (happyReturn1 ans)

-----------------------------------------------------------------------------
-- Arrays only: do the next action



happyDoAction i tk st
        = {- nothing -}


          case action of
                0#           -> {- nothing -}
                                     happyFail (happyExpListPerState ((Happy_GHC_Exts.I# (st)) :: Int)) i tk st
                -1#          -> {- nothing -}
                                     happyAccept i tk st
                n | LT(n,(0# :: Happy_GHC_Exts.Int#)) -> {- nothing -}

                                                   (happyReduceArr Happy_Data_Array.! rule) i tk st
                                                   where rule = (Happy_GHC_Exts.I# ((Happy_GHC_Exts.negateInt# ((n Happy_GHC_Exts.+# (1# :: Happy_GHC_Exts.Int#))))))
                n                 -> {- nothing -}


                                     happyShift new_state i tk st
                                     where new_state = (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#))
   where off    = happyAdjustOffset (indexShortOffAddr happyActOffsets st)
         off_i  = (off Happy_GHC_Exts.+#  i)
         check  = if GTE(off_i,(0# :: Happy_GHC_Exts.Int#))
                  then EQ(indexShortOffAddr happyCheck off_i, i)
                  else False
         action
          | check     = indexShortOffAddr happyTable off_i
          | otherwise = indexShortOffAddr happyDefActions st




indexShortOffAddr (HappyA# arr) off =
        Happy_GHC_Exts.narrow16Int# i
  where
        i = Happy_GHC_Exts.word2Int# (Happy_GHC_Exts.or# (Happy_GHC_Exts.uncheckedShiftL# high 8#) low)
        high = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr (off' Happy_GHC_Exts.+# 1#)))
        low  = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr off'))
        off' = off Happy_GHC_Exts.*# 2#




{-# INLINE happyLt #-}
happyLt x y = LT(x,y)


readArrayBit arr bit =
    Bits.testBit (Happy_GHC_Exts.I# (indexShortOffAddr arr ((unbox_int bit) `Happy_GHC_Exts.iShiftRA#` 4#))) (bit `mod` 16)
  where unbox_int (Happy_GHC_Exts.I# x) = x






data HappyAddr = HappyA# Happy_GHC_Exts.Addr#


-----------------------------------------------------------------------------
-- HappyState data type (not arrays)

{-# LINE 180 "templates/GenericTemplate.hs" #-}

-----------------------------------------------------------------------------
-- Shifting a token

happyShift new_state 0# tk st sts stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--     trace "shifting the error token" $
     happyDoAction i tk new_state (HappyCons (st) (sts)) (stk)

happyShift new_state i tk st sts stk =
     happyNewToken new_state (HappyCons (st) (sts)) ((happyInTok (tk))`HappyStk`stk)

-- happyReduce is specialised for the common cases.

happySpecReduce_0 i fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happySpecReduce_0 nt fn j tk st@((action)) sts stk
     = happyGoto nt j tk st (HappyCons (st) (sts)) (fn `HappyStk` stk)

happySpecReduce_1 i fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happySpecReduce_1 nt fn j tk _ sts@((HappyCons (st@(action)) (_))) (v1`HappyStk`stk')
     = let r = fn v1 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_2 i fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happySpecReduce_2 nt fn j tk _ (HappyCons (_) (sts@((HappyCons (st@(action)) (_))))) (v1`HappyStk`v2`HappyStk`stk')
     = let r = fn v1 v2 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_3 i fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happySpecReduce_3 nt fn j tk _ (HappyCons (_) ((HappyCons (_) (sts@((HappyCons (st@(action)) (_))))))) (v1`HappyStk`v2`HappyStk`v3`HappyStk`stk')
     = let r = fn v1 v2 v3 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happyReduce k i fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happyReduce k nt fn j tk st sts stk
     = case happyDrop (k Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) sts of
         sts1@((HappyCons (st1@(action)) (_))) ->
                let r = fn stk in  -- it doesn't hurt to always seq here...
                happyDoSeq r (happyGoto nt j tk st1 sts1 r)

happyMonadReduce k nt fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happyMonadReduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
          let drop_stk = happyDropStk k stk in
          happyThen1 (fn stk tk) (\r -> happyGoto nt j tk st1 sts1 (r `HappyStk` drop_stk))

happyMonad2Reduce k nt fn 0# tk st sts stk
     = happyFail [] 0# tk st sts stk
happyMonad2Reduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
         let drop_stk = happyDropStk k stk

             off = happyAdjustOffset (indexShortOffAddr happyGotoOffsets st1)
             off_i = (off Happy_GHC_Exts.+#  nt)
             new_state = indexShortOffAddr happyTable off_i




          in
          happyThen1 (fn stk tk) (\r -> happyNewToken new_state sts1 (r `HappyStk` drop_stk))

happyDrop 0# l = l
happyDrop n (HappyCons (_) (t)) = happyDrop (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) t

happyDropStk 0# l = l
happyDropStk n (x `HappyStk` xs) = happyDropStk (n Happy_GHC_Exts.-# (1#::Happy_GHC_Exts.Int#)) xs

-----------------------------------------------------------------------------
-- Moving to a new state after a reduction


happyGoto nt j tk st = 
   {- nothing -}
   happyDoAction j tk new_state
   where off = happyAdjustOffset (indexShortOffAddr happyGotoOffsets st)
         off_i = (off Happy_GHC_Exts.+#  nt)
         new_state = indexShortOffAddr happyTable off_i




-----------------------------------------------------------------------------
-- Error recovery (0# is the error token)

-- parse error if we are in recovery and we fail again
happyFail explist 0# tk old_st _ stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--      trace "failing" $ 
        happyError_ explist i tk

{-  We don't need state discarding for our restricted implementation of
    "error".  In fact, it can cause some bogus parses, so I've disabled it
    for now --SDM

-- discard a state
happyFail  0# tk old_st (HappyCons ((action)) (sts)) 
                                                (saved_tok `HappyStk` _ `HappyStk` stk) =
--      trace ("discarding state, depth " ++ show (length stk))  $
        happyDoAction 0# tk action sts ((saved_tok`HappyStk`stk))
-}

-- Enter error recovery: generate an error token,
--                       save the old token and carry on.
happyFail explist i tk (action) sts stk =
--      trace "entering error recovery" $
        happyDoAction 0# tk action sts ( (Happy_GHC_Exts.unsafeCoerce# (Happy_GHC_Exts.I# (i))) `HappyStk` stk)

-- Internal happy errors:

notHappyAtAll :: a
notHappyAtAll = error "Internal Happy error\n"

-----------------------------------------------------------------------------
-- Hack to get the typechecker to accept our action functions


happyTcHack :: Happy_GHC_Exts.Int# -> a -> a
happyTcHack x y = y
{-# INLINE happyTcHack #-}


-----------------------------------------------------------------------------
-- Seq-ing.  If the --strict flag is given, then Happy emits 
--      happySeq = happyDoSeq
-- otherwise it emits
--      happySeq = happyDontSeq

happyDoSeq, happyDontSeq :: a -> b -> b
happyDoSeq   a b = a `seq` b
happyDontSeq a b = b

-----------------------------------------------------------------------------
-- Don't inline any functions from the template.  GHC has a nasty habit
-- of deciding to inline happyGoto everywhere, which increases the size of
-- the generated parser quite a bit.


{-# NOINLINE happyDoAction #-}
{-# NOINLINE happyTable #-}
{-# NOINLINE happyCheck #-}
{-# NOINLINE happyActOffsets #-}
{-# NOINLINE happyGotoOffsets #-}
{-# NOINLINE happyDefActions #-}

{-# NOINLINE happyShift #-}
{-# NOINLINE happySpecReduce_0 #-}
{-# NOINLINE happySpecReduce_1 #-}
{-# NOINLINE happySpecReduce_2 #-}
{-# NOINLINE happySpecReduce_3 #-}
{-# NOINLINE happyReduce #-}
{-# NOINLINE happyMonadReduce #-}
{-# NOINLINE happyGoto #-}
{-# NOINLINE happyFail #-}

-- end of Happy Template.
