/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.algorithmic.compression;

import edu.cornell.med.icb.goby.algorithmic.compression.FastArithmeticDecoder;
import edu.cornell.med.icb.goby.algorithmic.compression.FastArithmeticDecoderI;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.io.InputBitStream;
import java.io.IOException;

public final class FastArithmeticDecoderOrder1
implements FastArithmeticDecoderI {
    FastArithmeticDecoderI[] delegates;
    private int numSymbols;
    private int previousSymbol;
    IntArrayList[] decodedLists;
    private boolean decoded = false;
    private int[] currentIndex;
    private int symbolRetrievalCount;
    private int[] lengths;

    public FastArithmeticDecoderOrder1(int numSymbols) {
        this.delegates = new FastArithmeticDecoderI[numSymbols];
        this.decodedLists = new IntArrayList[numSymbols];
        this.lengths = new int[numSymbols];
        for (int i = 0; i < numSymbols; ++i) {
            this.delegates[i] = new FastArithmeticDecoder(numSymbols);
            this.decodedLists[i] = new IntArrayList();
        }
        this.currentIndex = new int[numSymbols];
        this.numSymbols = numSymbols;
    }

    @Override
    public void reset() {
        this.previousSymbol = 0;
        this.decoded = false;
        int i = 0;
        for (FastArithmeticDecoderI delegate : this.delegates) {
            delegate.reset();
            this.decodedLists[i].clear();
            ++i;
        }
    }

    @Override
    public int decode(InputBitStream ibs) throws IOException {
        int symbol;
        if (!this.decoded) {
            for (int delegateIndex = 0; delegateIndex < this.numSymbols; ++delegateIndex) {
                int size = this.lengths[delegateIndex] = ibs.readNibble();
                for (int i = 0; i < size; ++i) {
                    int x = this.delegates[delegateIndex].decode(ibs);
                    this.decodedLists[delegateIndex].add(x);
                }
                this.reposition(ibs, delegateIndex);
            }
            this.decoded = true;
        }
        int n = this.previousSymbol;
        int n2 = this.currentIndex[n];
        this.currentIndex[n] = n2 + 1;
        this.previousSymbol = symbol = this.decodedLists[this.previousSymbol].getInt(n2);
        ++this.symbolRetrievalCount;
        return symbol;
    }

    @Override
    public void flush(InputBitStream ibs) throws IOException {
        throw new UnsupportedOperationException("flush is not supported by this implementation.");
    }

    public void flush(InputBitStream input, int delegateIndex) throws IOException {
        this.delegates[delegateIndex].flush(input);
    }

    @Override
    public long getWindow() {
        throw new UnsupportedOperationException("getWindow is not supported by this implementation.");
    }

    @Override
    public void reposition(InputBitStream input) throws IOException {
        throw new UnsupportedOperationException("reposition is not supported by this implementation.");
    }

    public void reposition(InputBitStream input, int delegateIndex) throws IOException {
        this.flush(input, delegateIndex);
        long readBits = input.readBits();
        long position = readBits - 63L;
        input.flush();
        if (position >= 0L) {
            input.position(position);
            input.readBits(position);
        }
    }
}

