-------------------------------------------------------------------------------
--
-- Copyright 2018 Ettus Research, a National Instruments Company
--
-- SPDX-License-Identifier: LGPL-3.0-or-later
--
--
-- Purpose:
--   The constants in this file are autogenerated by XmlParse and should
-- be used by testbench code to access specific register fields.
--
-------------------------------------------------------------------------------

library ieee;
  use ieee.std_logic_1164.all;
  use ieee.numeric_std.all;

package PkgClockingRegMap is

--===============================================================================
-- A numerically ordered list of registers and their VHDL source files
--===============================================================================

  -- RadioClkMmcm      : 0x20 (ClockingRegs.vhd)
  -- PhaseShiftControl : 0x24 (ClockingRegs.vhd)
  -- RadioClkEnables   : 0x28 (ClockingRegs.vhd)
  -- MgtRefClkStatus   : 0x30 (ClockingRegs.vhd)

--===============================================================================
-- RegTypes
--===============================================================================

--===============================================================================
-- Register Group ClockingRegs
--===============================================================================

  -- RadioClkMmcm Register (from ClockingRegs.vhd)
  constant kRadioClkMmcm : integer := 16#20#; -- Register Offset
  constant kRadioClkMmcmSize: integer := 32;  -- register width in bits
  constant kRadioClkMmcmMask : std_logic_vector(31 downto 0) := X"00000013";
  constant kRadioClkMmcmResetSetSize       : integer := 1;  --RadioClkMmcm:RadioClkMmcmResetSet
  constant kRadioClkMmcmResetSetMsb        : integer := 0;  --RadioClkMmcm:RadioClkMmcmResetSet
  constant kRadioClkMmcmResetSet           : integer := 0;  --RadioClkMmcm:RadioClkMmcmResetSet
  constant kRadioClkMmcmResetClearSize       : integer := 1;  --RadioClkMmcm:RadioClkMmcmResetClear
  constant kRadioClkMmcmResetClearMsb        : integer := 1;  --RadioClkMmcm:RadioClkMmcmResetClear
  constant kRadioClkMmcmResetClear           : integer := 1;  --RadioClkMmcm:RadioClkMmcmResetClear
  constant kRadioClkMmcmLockedSize       : integer := 1;  --RadioClkMmcm:RadioClkMmcmLocked
  constant kRadioClkMmcmLockedMsb        : integer := 4;  --RadioClkMmcm:RadioClkMmcmLocked
  constant kRadioClkMmcmLocked           : integer := 4;  --RadioClkMmcm:RadioClkMmcmLocked

  -- PhaseShiftControl Register (from ClockingRegs.vhd)
  constant kPhaseShiftControl : integer := 16#24#; -- Register Offset
  constant kPhaseShiftControlSize: integer := 32;  -- register width in bits
  constant kPhaseShiftControlMask : std_logic_vector(31 downto 0) := X"10010011";
  constant kPsIncSize       : integer := 1;  --PhaseShiftControl:PsInc
  constant kPsIncMsb        : integer := 0;  --PhaseShiftControl:PsInc
  constant kPsInc           : integer := 0;  --PhaseShiftControl:PsInc
  constant kPsDecSize       : integer := 1;  --PhaseShiftControl:PsDec
  constant kPsDecMsb        : integer := 4;  --PhaseShiftControl:PsDec
  constant kPsDec           : integer := 4;  --PhaseShiftControl:PsDec
  constant kPsEnabledForFdbClkSize       : integer :=  1;  --PhaseShiftControl:PsEnabledForFdbClk
  constant kPsEnabledForFdbClkMsb        : integer := 16;  --PhaseShiftControl:PsEnabledForFdbClk
  constant kPsEnabledForFdbClk           : integer := 16;  --PhaseShiftControl:PsEnabledForFdbClk
  constant kPsDoneSize       : integer :=  1;  --PhaseShiftControl:PsDone
  constant kPsDoneMsb        : integer := 28;  --PhaseShiftControl:PsDone
  constant kPsDone           : integer := 28;  --PhaseShiftControl:PsDone

  -- RadioClkEnables Register (from ClockingRegs.vhd)
  constant kRadioClkEnables : integer := 16#28#; -- Register Offset
  constant kRadioClkEnablesSize: integer := 32;  -- register width in bits
  constant kRadioClkEnablesMask : std_logic_vector(31 downto 0) := X"00000111";
  constant kRadioClk1xEnabledSize       : integer := 1;  --RadioClkEnables:RadioClk1xEnabled
  constant kRadioClk1xEnabledMsb        : integer := 0;  --RadioClkEnables:RadioClk1xEnabled
  constant kRadioClk1xEnabled           : integer := 0;  --RadioClkEnables:RadioClk1xEnabled
  constant kRadioClk2xEnabledSize       : integer := 1;  --RadioClkEnables:RadioClk2xEnabled
  constant kRadioClk2xEnabledMsb        : integer := 4;  --RadioClkEnables:RadioClk2xEnabled
  constant kRadioClk2xEnabled           : integer := 4;  --RadioClkEnables:RadioClk2xEnabled
  constant kRadioClk3xEnabledSize       : integer := 1;  --RadioClkEnables:RadioClk3xEnabled
  constant kRadioClk3xEnabledMsb        : integer := 8;  --RadioClkEnables:RadioClk3xEnabled
  constant kRadioClk3xEnabled           : integer := 8;  --RadioClkEnables:RadioClk3xEnabled

  -- MgtRefClkStatus Register (from ClockingRegs.vhd)
  constant kMgtRefClkStatus : integer := 16#30#; -- Register Offset
  constant kMgtRefClkStatusSize: integer := 32;  -- register width in bits
  constant kMgtRefClkStatusMask : std_logic_vector(31 downto 0) := X"00000001";
  constant kJesdRefClkPresentSize       : integer := 1;  --MgtRefClkStatus:JesdRefClkPresent
  constant kJesdRefClkPresentMsb        : integer := 0;  --MgtRefClkStatus:JesdRefClkPresent
  constant kJesdRefClkPresent           : integer := 0;  --MgtRefClkStatus:JesdRefClkPresent

end package;

package body PkgClockingRegMap is

  -- function kRadioClkMmcmRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kPhaseShiftControlRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kRadioClkEnablesRec not implemented because PkgXReg in this project does not support XReg2_t.

  -- function kMgtRefClkStatusRec not implemented because PkgXReg in this project does not support XReg2_t.

end package body;
