// List of Windows system error codes with descriptions:
// https://docs.microsoft.com/en-us/windows/win32/debug/system-error-codes#system-error-codes

#![allow(dead_code)]

use super::{c_int, DWORD};

pub const ERROR_DIRECTORY_NOT_SUPPORTED: DWORD = 336;
pub const ERROR_DRIVER_CANCEL_TIMEOUT: DWORD = 594;
pub const ERROR_DISK_QUOTA_EXCEEDED: DWORD = 1295;
pub const ERROR_RESOURCE_CALL_TIMED_OUT: DWORD = 5910;
pub const FRS_ERR_SYSVOL_POPULATE_TIMEOUT: DWORD = 8014;
pub const DNS_ERROR_RECORD_TIMED_OUT: DWORD = 9705;

// The followiung list was obtained from
//   `/usr/x86_64-w64-mingw32/include/winerror.h`
// in the Debian package
//   mingw-w64_6.0.0-3_all.deb
//
// The header of that file says:
//   * This file has no copyright assigned and is placed in the Public Domain.
//   * This file is part of the mingw-w64 runtime package.
//   * No warranty is given; refer to the file DISCLAIMER.PD within this package.
//
// The text here is the result of the following rune:
//   grep -P '#define ERROR' /usr/x86_64-w64-mingw32/include/winerror.h >>library/std/src/sys/windows/c/errors.rs
//   grep -P '#define WSA' /usr/x86_64-w64-mingw32/include/winerror.h >>library/std/src/sys/windows/c/errors.rs
// and then using some manually-invented but rather obvious editor search-and-replace
// invocations, plus some straightforward manual fixups, to turn it into Rust syntax
// and remove all the duplicates from the manual table above.

pub const ERROR_SUCCESS: DWORD = 0;
pub const ERROR_INVALID_FUNCTION: DWORD = 1;
pub const ERROR_FILE_NOT_FOUND: DWORD = 2;
pub const ERROR_PATH_NOT_FOUND: DWORD = 3;
pub const ERROR_TOO_MANY_OPEN_FILES: DWORD = 4;
pub const ERROR_ACCESS_DENIED: DWORD = 5;
pub const ERROR_INVALID_HANDLE: DWORD = 6;
pub const ERROR_ARENA_TRASHED: DWORD = 7;
pub const ERROR_NOT_ENOUGH_MEMORY: DWORD = 8;
pub const ERROR_INVALID_BLOCK: DWORD = 9;
pub const ERROR_BAD_ENVIRONMENT: DWORD = 10;
pub const ERROR_BAD_FORMAT: DWORD = 11;
pub const ERROR_INVALID_ACCESS: DWORD = 12;
pub const ERROR_INVALID_DATA: DWORD = 13;
pub const ERROR_OUTOFMEMORY: DWORD = 14;
pub const ERROR_INVALID_DRIVE: DWORD = 15;
pub const ERROR_CURRENT_DIRECTORY: DWORD = 16;
pub const ERROR_NOT_SAME_DEVICE: DWORD = 17;
pub const ERROR_NO_MORE_FILES: DWORD = 18;
pub const ERROR_WRITE_PROTECT: DWORD = 19;
pub const ERROR_BAD_UNIT: DWORD = 20;
pub const ERROR_NOT_READY: DWORD = 21;
pub const ERROR_BAD_COMMAND: DWORD = 22;
pub const ERROR_CRC: DWORD = 23;
pub const ERROR_BAD_LENGTH: DWORD = 24;
pub const ERROR_SEEK: DWORD = 25;
pub const ERROR_NOT_DOS_DISK: DWORD = 26;
pub const ERROR_SECTOR_NOT_FOUND: DWORD = 27;
pub const ERROR_OUT_OF_PAPER: DWORD = 28;
pub const ERROR_WRITE_FAULT: DWORD = 29;
pub const ERROR_READ_FAULT: DWORD = 30;
pub const ERROR_GEN_FAILURE: DWORD = 31;
pub const ERROR_SHARING_VIOLATION: DWORD = 32;
pub const ERROR_LOCK_VIOLATION: DWORD = 33;
pub const ERROR_WRONG_DISK: DWORD = 34;
pub const ERROR_SHARING_BUFFER_EXCEEDED: DWORD = 36;
pub const ERROR_HANDLE_EOF: DWORD = 38;
pub const ERROR_HANDLE_DISK_FULL: DWORD = 39;
pub const ERROR_NOT_SUPPORTED: DWORD = 50;
pub const ERROR_REM_NOT_LIST: DWORD = 51;
pub const ERROR_DUP_NAME: DWORD = 52;
pub const ERROR_BAD_NETPATH: DWORD = 53;
pub const ERROR_NETWORK_BUSY: DWORD = 54;
pub const ERROR_DEV_NOT_EXIST: DWORD = 55;
pub const ERROR_TOO_MANY_CMDS: DWORD = 56;
pub const ERROR_ADAP_HDW_ERR: DWORD = 57;
pub const ERROR_BAD_NET_RESP: DWORD = 58;
pub const ERROR_UNEXP_NET_ERR: DWORD = 59;
pub const ERROR_BAD_REM_ADAP: DWORD = 60;
pub const ERROR_PRINTQ_FULL: DWORD = 61;
pub const ERROR_NO_SPOOL_SPACE: DWORD = 62;
pub const ERROR_PRINT_CANCELLED: DWORD = 63;
pub const ERROR_NETNAME_DELETED: DWORD = 64;
pub const ERROR_NETWORK_ACCESS_DENIED: DWORD = 65;
pub const ERROR_BAD_DEV_TYPE: DWORD = 66;
pub const ERROR_BAD_NET_NAME: DWORD = 67;
pub const ERROR_TOO_MANY_NAMES: DWORD = 68;
pub const ERROR_TOO_MANY_SESS: DWORD = 69;
pub const ERROR_SHARING_PAUSED: DWORD = 70;
pub const ERROR_REQ_NOT_ACCEP: DWORD = 71;
pub const ERROR_REDIR_PAUSED: DWORD = 72;
pub const ERROR_FILE_EXISTS: DWORD = 80;
pub const ERROR_CANNOT_MAKE: DWORD = 82;
pub const ERROR_FAIL_I24: DWORD = 83;
pub const ERROR_OUT_OF_STRUCTURES: DWORD = 84;
pub const ERROR_ALREADY_ASSIGNED: DWORD = 85;
pub const ERROR_INVALID_PASSWORD: DWORD = 86;
pub const ERROR_INVALID_PARAMETER: DWORD = 87;
pub const ERROR_NET_WRITE_FAULT: DWORD = 88;
pub const ERROR_NO_PROC_SLOTS: DWORD = 89;
pub const ERROR_TOO_MANY_SEMAPHORES: DWORD = 100;
pub const ERROR_EXCL_SEM_ALREADY_OWNED: DWORD = 101;
pub const ERROR_SEM_IS_SET: DWORD = 102;
pub const ERROR_TOO_MANY_SEM_REQUESTS: DWORD = 103;
pub const ERROR_INVALID_AT_INTERRUPT_TIME: DWORD = 104;
pub const ERROR_SEM_OWNER_DIED: DWORD = 105;
pub const ERROR_SEM_USER_LIMIT: DWORD = 106;
pub const ERROR_DISK_CHANGE: DWORD = 107;
pub const ERROR_DRIVE_LOCKED: DWORD = 108;
pub const ERROR_BROKEN_PIPE: DWORD = 109;
pub const ERROR_OPEN_FAILED: DWORD = 110;
pub const ERROR_BUFFER_OVERFLOW: DWORD = 111;
pub const ERROR_DISK_FULL: DWORD = 112;
pub const ERROR_NO_MORE_SEARCH_HANDLES: DWORD = 113;
pub const ERROR_INVALID_TARGET_HANDLE: DWORD = 114;
pub const ERROR_INVALID_CATEGORY: DWORD = 117;
pub const ERROR_INVALID_VERIFY_SWITCH: DWORD = 118;
pub const ERROR_BAD_DRIVER_LEVEL: DWORD = 119;
pub const ERROR_CALL_NOT_IMPLEMENTED: DWORD = 120;
pub const ERROR_SEM_TIMEOUT: DWORD = 121;
pub const ERROR_INSUFFICIENT_BUFFER: DWORD = 122;
pub const ERROR_INVALID_NAME: DWORD = 123;
pub const ERROR_INVALID_LEVEL: DWORD = 124;
pub const ERROR_NO_VOLUME_LABEL: DWORD = 125;
pub const ERROR_MOD_NOT_FOUND: DWORD = 126;
pub const ERROR_PROC_NOT_FOUND: DWORD = 127;
pub const ERROR_WAIT_NO_CHILDREN: DWORD = 128;
pub const ERROR_CHILD_NOT_COMPLETE: DWORD = 129;
pub const ERROR_DIRECT_ACCESS_HANDLE: DWORD = 130;
pub const ERROR_NEGATIVE_SEEK: DWORD = 131;
pub const ERROR_SEEK_ON_DEVICE: DWORD = 132;
pub const ERROR_IS_JOIN_TARGET: DWORD = 133;
pub const ERROR_IS_JOINED: DWORD = 134;
pub const ERROR_IS_SUBSTED: DWORD = 135;
pub const ERROR_NOT_JOINED: DWORD = 136;
pub const ERROR_NOT_SUBSTED: DWORD = 137;
pub const ERROR_JOIN_TO_JOIN: DWORD = 138;
pub const ERROR_SUBST_TO_SUBST: DWORD = 139;
pub const ERROR_JOIN_TO_SUBST: DWORD = 140;
pub const ERROR_SUBST_TO_JOIN: DWORD = 141;
pub const ERROR_BUSY_DRIVE: DWORD = 142;
pub const ERROR_SAME_DRIVE: DWORD = 143;
pub const ERROR_DIR_NOT_ROOT: DWORD = 144;
pub const ERROR_DIR_NOT_EMPTY: DWORD = 145;
pub const ERROR_IS_SUBST_PATH: DWORD = 146;
pub const ERROR_IS_JOIN_PATH: DWORD = 147;
pub const ERROR_PATH_BUSY: DWORD = 148;
pub const ERROR_IS_SUBST_TARGET: DWORD = 149;
pub const ERROR_SYSTEM_TRACE: DWORD = 150;
pub const ERROR_INVALID_EVENT_COUNT: DWORD = 151;
pub const ERROR_TOO_MANY_MUXWAITERS: DWORD = 152;
pub const ERROR_INVALID_LIST_FORMAT: DWORD = 153;
pub const ERROR_LABEL_TOO_LONG: DWORD = 154;
pub const ERROR_TOO_MANY_TCBS: DWORD = 155;
pub const ERROR_SIGNAL_REFUSED: DWORD = 156;
pub const ERROR_DISCARDED: DWORD = 157;
pub const ERROR_NOT_LOCKED: DWORD = 158;
pub const ERROR_BAD_THREADID_ADDR: DWORD = 159;
pub const ERROR_BAD_ARGUMENTS: DWORD = 160;
pub const ERROR_BAD_PATHNAME: DWORD = 161;
pub const ERROR_SIGNAL_PENDING: DWORD = 162;
pub const ERROR_MAX_THRDS_REACHED: DWORD = 164;
pub const ERROR_LOCK_FAILED: DWORD = 167;
pub const ERROR_BUSY: DWORD = 170;
pub const ERROR_CANCEL_VIOLATION: DWORD = 173;
pub const ERROR_ATOMIC_LOCKS_NOT_SUPPORTED: DWORD = 174;
pub const ERROR_INVALID_SEGMENT_NUMBER: DWORD = 180;
pub const ERROR_INVALID_ORDINAL: DWORD = 182;
pub const ERROR_ALREADY_EXISTS: DWORD = 183;
pub const ERROR_INVALID_FLAG_NUMBER: DWORD = 186;
pub const ERROR_SEM_NOT_FOUND: DWORD = 187;
pub const ERROR_INVALID_STARTING_CODESEG: DWORD = 188;
pub const ERROR_INVALID_STACKSEG: DWORD = 189;
pub const ERROR_INVALID_MODULETYPE: DWORD = 190;
pub const ERROR_INVALID_EXE_SIGNATURE: DWORD = 191;
pub const ERROR_EXE_MARKED_INVALID: DWORD = 192;
pub const ERROR_BAD_EXE_FORMAT: DWORD = 193;
pub const ERROR_ITERATED_DATA_EXCEEDS_64k: DWORD = 194;
pub const ERROR_INVALID_MINALLOCSIZE: DWORD = 195;
pub const ERROR_DYNLINK_FROM_INVALID_RING: DWORD = 196;
pub const ERROR_IOPL_NOT_ENABLED: DWORD = 197;
pub const ERROR_INVALID_SEGDPL: DWORD = 198;
pub const ERROR_AUTODATASEG_EXCEEDS_64k: DWORD = 199;
pub const ERROR_RING2SEG_MUST_BE_MOVABLE: DWORD = 200;
pub const ERROR_RELOC_CHAIN_XEEDS_SEGLIM: DWORD = 201;
pub const ERROR_INFLOOP_IN_RELOC_CHAIN: DWORD = 202;
pub const ERROR_ENVVAR_NOT_FOUND: DWORD = 203;
pub const ERROR_NO_SIGNAL_SENT: DWORD = 205;
pub const ERROR_FILENAME_EXCED_RANGE: DWORD = 206;
pub const ERROR_RING2_STACK_IN_USE: DWORD = 207;
pub const ERROR_META_EXPANSION_TOO_LONG: DWORD = 208;
pub const ERROR_INVALID_SIGNAL_NUMBER: DWORD = 209;
pub const ERROR_THREAD_1_INACTIVE: DWORD = 210;
pub const ERROR_LOCKED: DWORD = 212;
pub const ERROR_TOO_MANY_MODULES: DWORD = 214;
pub const ERROR_NESTING_NOT_ALLOWED: DWORD = 215;
pub const ERROR_EXE_MACHINE_TYPE_MISMATCH: DWORD = 216;
pub const ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY: DWORD = 217;
pub const ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY: DWORD = 218;
pub const ERROR_FILE_CHECKED_OUT: DWORD = 220;
pub const ERROR_CHECKOUT_REQUIRED: DWORD = 221;
pub const ERROR_BAD_FILE_TYPE: DWORD = 222;
pub const ERROR_FILE_TOO_LARGE: DWORD = 223;
pub const ERROR_FORMS_AUTH_REQUIRED: DWORD = 224;
pub const ERROR_PIPE_LOCAL: DWORD = 229;
pub const ERROR_BAD_PIPE: DWORD = 230;
pub const ERROR_PIPE_BUSY: DWORD = 231;
pub const ERROR_NO_DATA: DWORD = 232;
pub const ERROR_PIPE_NOT_CONNECTED: DWORD = 233;
pub const ERROR_MORE_DATA: DWORD = 234;
pub const ERROR_VC_DISCONNECTED: DWORD = 240;
pub const ERROR_INVALID_EA_NAME: DWORD = 254;
pub const ERROR_EA_LIST_INCONSISTENT: DWORD = 255;
pub const ERROR_NO_MORE_ITEMS: DWORD = 259;
pub const ERROR_CANNOT_COPY: DWORD = 266;
pub const ERROR_DIRECTORY: DWORD = 267;
pub const ERROR_EAS_DIDNT_FIT: DWORD = 275;
pub const ERROR_EA_FILE_CORRUPT: DWORD = 276;
pub const ERROR_EA_TABLE_FULL: DWORD = 277;
pub const ERROR_INVALID_EA_HANDLE: DWORD = 278;
pub const ERROR_EAS_NOT_SUPPORTED: DWORD = 282;
pub const ERROR_NOT_OWNER: DWORD = 288;
pub const ERROR_TOO_MANY_POSTS: DWORD = 298;
pub const ERROR_PARTIAL_COPY: DWORD = 299;
pub const ERROR_OPLOCK_NOT_GRANTED: DWORD = 300;
pub const ERROR_INVALID_OPLOCK_PROTOCOL: DWORD = 301;
pub const ERROR_DISK_TOO_FRAGMENTED: DWORD = 302;
pub const ERROR_DELETE_PENDING: DWORD = 303;
pub const ERROR_INVALID_TOKEN: DWORD = 315;
pub const ERROR_MR_MID_NOT_FOUND: DWORD = 317;
pub const ERROR_SCOPE_NOT_FOUND: DWORD = 318;
pub const ERROR_INVALID_ADDRESS: DWORD = 487;
pub const ERROR_ARITHMETIC_OVERFLOW: DWORD = 534;
pub const ERROR_PIPE_CONNECTED: DWORD = 535;
pub const ERROR_PIPE_LISTENING: DWORD = 536;
pub const ERROR_WAKE_SYSTEM: DWORD = 730;
pub const ERROR_WAIT_1: DWORD = 731;
pub const ERROR_WAIT_2: DWORD = 732;
pub const ERROR_WAIT_3: DWORD = 733;
pub const ERROR_WAIT_63: DWORD = 734;
pub const ERROR_ABANDONED_WAIT_0: DWORD = 735;
pub const ERROR_ABANDONED_WAIT_63: DWORD = 736;
pub const ERROR_USER_APC: DWORD = 737;
pub const ERROR_KERNEL_APC: DWORD = 738;
pub const ERROR_ALERTED: DWORD = 739;
pub const ERROR_EA_ACCESS_DENIED: DWORD = 994;
pub const ERROR_OPERATION_ABORTED: DWORD = 995;
pub const ERROR_IO_INCOMPLETE: DWORD = 996;
pub const ERROR_IO_PENDING: DWORD = 997;
pub const ERROR_NOACCESS: DWORD = 998;
pub const ERROR_SWAPERROR: DWORD = 999;
pub const ERROR_STACK_OVERFLOW: DWORD = 1001;
pub const ERROR_INVALID_MESSAGE: DWORD = 1002;
pub const ERROR_CAN_NOT_COMPLETE: DWORD = 1003;
pub const ERROR_INVALID_FLAGS: DWORD = 1004;
pub const ERROR_UNRECOGNIZED_VOLUME: DWORD = 1005;
pub const ERROR_FILE_INVALID: DWORD = 1006;
pub const ERROR_FULLSCREEN_MODE: DWORD = 1007;
pub const ERROR_NO_TOKEN: DWORD = 1008;
pub const ERROR_BADDB: DWORD = 1009;
pub const ERROR_BADKEY: DWORD = 1010;
pub const ERROR_CANTOPEN: DWORD = 1011;
pub const ERROR_CANTREAD: DWORD = 1012;
pub const ERROR_CANTWRITE: DWORD = 1013;
pub const ERROR_REGISTRY_RECOVERED: DWORD = 1014;
pub const ERROR_REGISTRY_CORRUPT: DWORD = 1015;
pub const ERROR_REGISTRY_IO_FAILED: DWORD = 1016;
pub const ERROR_NOT_REGISTRY_FILE: DWORD = 1017;
pub const ERROR_KEY_DELETED: DWORD = 1018;
pub const ERROR_NO_LOG_SPACE: DWORD = 1019;
pub const ERROR_KEY_HAS_CHILDREN: DWORD = 1020;
pub const ERROR_CHILD_MUST_BE_VOLATILE: DWORD = 1021;
pub const ERROR_NOTIFY_ENUM_DIR: DWORD = 1022;
pub const ERROR_DEPENDENT_SERVICES_RUNNING: DWORD = 1051;
pub const ERROR_INVALID_SERVICE_CONTROL: DWORD = 1052;
pub const ERROR_SERVICE_REQUEST_TIMEOUT: DWORD = 1053;
pub const ERROR_SERVICE_NO_THREAD: DWORD = 1054;
pub const ERROR_SERVICE_DATABASE_LOCKED: DWORD = 1055;
pub const ERROR_SERVICE_ALREADY_RUNNING: DWORD = 1056;
pub const ERROR_INVALID_SERVICE_ACCOUNT: DWORD = 1057;
pub const ERROR_SERVICE_DISABLED: DWORD = 1058;
pub const ERROR_CIRCULAR_DEPENDENCY: DWORD = 1059;
pub const ERROR_SERVICE_DOES_NOT_EXIST: DWORD = 1060;
pub const ERROR_SERVICE_CANNOT_ACCEPT_CTRL: DWORD = 1061;
pub const ERROR_SERVICE_NOT_ACTIVE: DWORD = 1062;
pub const ERROR_FAILED_SERVICE_CONTROLLER_CONNECT: DWORD = 1063;
pub const ERROR_EXCEPTION_IN_SERVICE: DWORD = 1064;
pub const ERROR_DATABASE_DOES_NOT_EXIST: DWORD = 1065;
pub const ERROR_SERVICE_SPECIFIC_ERROR: DWORD = 1066;
pub const ERROR_PROCESS_ABORTED: DWORD = 1067;
pub const ERROR_SERVICE_DEPENDENCY_FAIL: DWORD = 1068;
pub const ERROR_SERVICE_LOGON_FAILED: DWORD = 1069;
pub const ERROR_SERVICE_START_HANG: DWORD = 1070;
pub const ERROR_INVALID_SERVICE_LOCK: DWORD = 1071;
pub const ERROR_SERVICE_MARKED_FOR_DELETE: DWORD = 1072;
pub const ERROR_SERVICE_EXISTS: DWORD = 1073;
pub const ERROR_ALREADY_RUNNING_LKG: DWORD = 1074;
pub const ERROR_SERVICE_DEPENDENCY_DELETED: DWORD = 1075;
pub const ERROR_BOOT_ALREADY_ACCEPTED: DWORD = 1076;
pub const ERROR_SERVICE_NEVER_STARTED: DWORD = 1077;
pub const ERROR_DUPLICATE_SERVICE_NAME: DWORD = 1078;
pub const ERROR_DIFFERENT_SERVICE_ACCOUNT: DWORD = 1079;
pub const ERROR_CANNOT_DETECT_DRIVER_FAILURE: DWORD = 1080;
pub const ERROR_CANNOT_DETECT_PROCESS_ABORT: DWORD = 1081;
pub const ERROR_NO_RECOVERY_PROGRAM: DWORD = 1082;
pub const ERROR_SERVICE_NOT_IN_EXE: DWORD = 1083;
pub const ERROR_NOT_SAFEBOOT_SERVICE: DWORD = 1084;
pub const ERROR_END_OF_MEDIA: DWORD = 1100;
pub const ERROR_FILEMARK_DETECTED: DWORD = 1101;
pub const ERROR_BEGINNING_OF_MEDIA: DWORD = 1102;
pub const ERROR_SETMARK_DETECTED: DWORD = 1103;
pub const ERROR_NO_DATA_DETECTED: DWORD = 1104;
pub const ERROR_PARTITION_FAILURE: DWORD = 1105;
pub const ERROR_INVALID_BLOCK_LENGTH: DWORD = 1106;
pub const ERROR_DEVICE_NOT_PARTITIONED: DWORD = 1107;
pub const ERROR_UNABLE_TO_LOCK_MEDIA: DWORD = 1108;
pub const ERROR_UNABLE_TO_UNLOAD_MEDIA: DWORD = 1109;
pub const ERROR_MEDIA_CHANGED: DWORD = 1110;
pub const ERROR_BUS_RESET: DWORD = 1111;
pub const ERROR_NO_MEDIA_IN_DRIVE: DWORD = 1112;
pub const ERROR_NO_UNICODE_TRANSLATION: DWORD = 1113;
pub const ERROR_DLL_INIT_FAILED: DWORD = 1114;
pub const ERROR_SHUTDOWN_IN_PROGRESS: DWORD = 1115;
pub const ERROR_NO_SHUTDOWN_IN_PROGRESS: DWORD = 1116;
pub const ERROR_IO_DEVICE: DWORD = 1117;
pub const ERROR_SERIAL_NO_DEVICE: DWORD = 1118;
pub const ERROR_IRQ_BUSY: DWORD = 1119;
pub const ERROR_MORE_WRITES: DWORD = 1120;
pub const ERROR_COUNTER_TIMEOUT: DWORD = 1121;
pub const ERROR_FLOPPY_ID_MARK_NOT_FOUND: DWORD = 1122;
pub const ERROR_FLOPPY_WRONG_CYLINDER: DWORD = 1123;
pub const ERROR_FLOPPY_UNKNOWN_ERROR: DWORD = 1124;
pub const ERROR_FLOPPY_BAD_REGISTERS: DWORD = 1125;
pub const ERROR_DISK_RECALIBRATE_FAILED: DWORD = 1126;
pub const ERROR_DISK_OPERATION_FAILED: DWORD = 1127;
pub const ERROR_DISK_RESET_FAILED: DWORD = 1128;
pub const ERROR_EOM_OVERFLOW: DWORD = 1129;
pub const ERROR_NOT_ENOUGH_SERVER_MEMORY: DWORD = 1130;
pub const ERROR_POSSIBLE_DEADLOCK: DWORD = 1131;
pub const ERROR_MAPPED_ALIGNMENT: DWORD = 1132;
pub const ERROR_SET_POWER_STATE_VETOED: DWORD = 1140;
pub const ERROR_SET_POWER_STATE_FAILED: DWORD = 1141;
pub const ERROR_TOO_MANY_LINKS: DWORD = 1142;
pub const ERROR_OLD_WIN_VERSION: DWORD = 1150;
pub const ERROR_APP_WRONG_OS: DWORD = 1151;
pub const ERROR_SINGLE_INSTANCE_APP: DWORD = 1152;
pub const ERROR_RMODE_APP: DWORD = 1153;
pub const ERROR_INVALID_DLL: DWORD = 1154;
pub const ERROR_NO_ASSOCIATION: DWORD = 1155;
pub const ERROR_DDE_FAIL: DWORD = 1156;
pub const ERROR_DLL_NOT_FOUND: DWORD = 1157;
pub const ERROR_NO_MORE_USER_HANDLES: DWORD = 1158;
pub const ERROR_MESSAGE_SYNC_ONLY: DWORD = 1159;
pub const ERROR_SOURCE_ELEMENT_EMPTY: DWORD = 1160;
pub const ERROR_DESTINATION_ELEMENT_FULL: DWORD = 1161;
pub const ERROR_ILLEGAL_ELEMENT_ADDRESS: DWORD = 1162;
pub const ERROR_MAGAZINE_NOT_PRESENT: DWORD = 1163;
pub const ERROR_DEVICE_REINITIALIZATION_NEEDED: DWORD = 1164;
pub const ERROR_DEVICE_REQUIRES_CLEANING: DWORD = 1165;
pub const ERROR_DEVICE_DOOR_OPEN: DWORD = 1166;
pub const ERROR_DEVICE_NOT_CONNECTED: DWORD = 1167;
pub const ERROR_NOT_FOUND: DWORD = 1168;
pub const ERROR_NO_MATCH: DWORD = 1169;
pub const ERROR_SET_NOT_FOUND: DWORD = 1170;
pub const ERROR_POINT_NOT_FOUND: DWORD = 1171;
pub const ERROR_NO_TRACKING_SERVICE: DWORD = 1172;
pub const ERROR_NO_VOLUME_ID: DWORD = 1173;
pub const ERROR_UNABLE_TO_REMOVE_REPLACED: DWORD = 1175;
pub const ERROR_UNABLE_TO_MOVE_REPLACEMENT: DWORD = 1176;
pub const ERROR_UNABLE_TO_MOVE_REPLACEMENT_2: DWORD = 1177;
pub const ERROR_JOURNAL_DELETE_IN_PROGRESS: DWORD = 1178;
pub const ERROR_JOURNAL_NOT_ACTIVE: DWORD = 1179;
pub const ERROR_POTENTIAL_FILE_FOUND: DWORD = 1180;
pub const ERROR_JOURNAL_ENTRY_DELETED: DWORD = 1181;
pub const ERROR_BAD_DEVICE: DWORD = 1200;
pub const ERROR_CONNECTION_UNAVAIL: DWORD = 1201;
pub const ERROR_DEVICE_ALREADY_REMEMBERED: DWORD = 1202;
pub const ERROR_NO_NET_OR_BAD_PATH: DWORD = 1203;
pub const ERROR_BAD_PROVIDER: DWORD = 1204;
pub const ERROR_CANNOT_OPEN_PROFILE: DWORD = 1205;
pub const ERROR_BAD_PROFILE: DWORD = 1206;
pub const ERROR_NOT_CONTAINER: DWORD = 1207;
pub const ERROR_EXTENDED_ERROR: DWORD = 1208;
pub const ERROR_INVALID_GROUPNAME: DWORD = 1209;
pub const ERROR_INVALID_COMPUTERNAME: DWORD = 1210;
pub const ERROR_INVALID_EVENTNAME: DWORD = 1211;
pub const ERROR_INVALID_DOMAINNAME: DWORD = 1212;
pub const ERROR_INVALID_SERVICENAME: DWORD = 1213;
pub const ERROR_INVALID_NETNAME: DWORD = 1214;
pub const ERROR_INVALID_SHARENAME: DWORD = 1215;
pub const ERROR_INVALID_PASSWORDNAME: DWORD = 1216;
pub const ERROR_INVALID_MESSAGENAME: DWORD = 1217;
pub const ERROR_INVALID_MESSAGEDEST: DWORD = 1218;
pub const ERROR_SESSION_CREDENTIAL_CONFLICT: DWORD = 1219;
pub const ERROR_REMOTE_SESSION_LIMIT_EXCEEDED: DWORD = 1220;
pub const ERROR_DUP_DOMAINNAME: DWORD = 1221;
pub const ERROR_NO_NETWORK: DWORD = 1222;
pub const ERROR_CANCELLED: DWORD = 1223;
pub const ERROR_USER_MAPPED_FILE: DWORD = 1224;
pub const ERROR_CONNECTION_REFUSED: DWORD = 1225;
pub const ERROR_GRACEFUL_DISCONNECT: DWORD = 1226;
pub const ERROR_ADDRESS_ALREADY_ASSOCIATED: DWORD = 1227;
pub const ERROR_ADDRESS_NOT_ASSOCIATED: DWORD = 1228;
pub const ERROR_CONNECTION_INVALID: DWORD = 1229;
pub const ERROR_CONNECTION_ACTIVE: DWORD = 1230;
pub const ERROR_NETWORK_UNREACHABLE: DWORD = 1231;
pub const ERROR_HOST_UNREACHABLE: DWORD = 1232;
pub const ERROR_PROTOCOL_UNREACHABLE: DWORD = 1233;
pub const ERROR_PORT_UNREACHABLE: DWORD = 1234;
pub const ERROR_REQUEST_ABORTED: DWORD = 1235;
pub const ERROR_CONNECTION_ABORTED: DWORD = 1236;
pub const ERROR_RETRY: DWORD = 1237;
pub const ERROR_CONNECTION_COUNT_LIMIT: DWORD = 1238;
pub const ERROR_LOGIN_TIME_RESTRICTION: DWORD = 1239;
pub const ERROR_LOGIN_WKSTA_RESTRICTION: DWORD = 1240;
pub const ERROR_INCORRECT_ADDRESS: DWORD = 1241;
pub const ERROR_ALREADY_REGISTERED: DWORD = 1242;
pub const ERROR_SERVICE_NOT_FOUND: DWORD = 1243;
pub const ERROR_NOT_AUTHENTICATED: DWORD = 1244;
pub const ERROR_NOT_LOGGED_ON: DWORD = 1245;
pub const ERROR_CONTINUE: DWORD = 1246;
pub const ERROR_ALREADY_INITIALIZED: DWORD = 1247;
pub const ERROR_NO_MORE_DEVICES: DWORD = 1248;
pub const ERROR_NO_SUCH_SITE: DWORD = 1249;
pub const ERROR_DOMAIN_CONTROLLER_EXISTS: DWORD = 1250;
pub const ERROR_ONLY_IF_CONNECTED: DWORD = 1251;
pub const ERROR_OVERRIDE_NOCHANGES: DWORD = 1252;
pub const ERROR_BAD_USER_PROFILE: DWORD = 1253;
pub const ERROR_NOT_SUPPORTED_ON_SBS: DWORD = 1254;
pub const ERROR_SERVER_SHUTDOWN_IN_PROGRESS: DWORD = 1255;
pub const ERROR_HOST_DOWN: DWORD = 1256;
pub const ERROR_NON_ACCOUNT_SID: DWORD = 1257;
pub const ERROR_NON_DOMAIN_SID: DWORD = 1258;
pub const ERROR_APPHELP_BLOCK: DWORD = 1259;
pub const ERROR_ACCESS_DISABLED_BY_POLICY: DWORD = 1260;
pub const ERROR_REG_NAT_CONSUMPTION: DWORD = 1261;
pub const ERROR_CSCSHARE_OFFLINE: DWORD = 1262;
pub const ERROR_PKINIT_FAILURE: DWORD = 1263;
pub const ERROR_SMARTCARD_SUBSYSTEM_FAILURE: DWORD = 1264;
pub const ERROR_DOWNGRADE_DETECTED: DWORD = 1265;
pub const ERROR_MACHINE_LOCKED: DWORD = 1271;
pub const ERROR_CALLBACK_SUPPLIED_INVALID_DATA: DWORD = 1273;
pub const ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED: DWORD = 1274;
pub const ERROR_DRIVER_BLOCKED: DWORD = 1275;
pub const ERROR_INVALID_IMPORT_OF_NON_DLL: DWORD = 1276;
pub const ERROR_ACCESS_DISABLED_WEBBLADE: DWORD = 1277;
pub const ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER: DWORD = 1278;
pub const ERROR_RECOVERY_FAILURE: DWORD = 1279;
pub const ERROR_ALREADY_FIBER: DWORD = 1280;
pub const ERROR_ALREADY_THREAD: DWORD = 1281;
pub const ERROR_STACK_BUFFER_OVERRUN: DWORD = 1282;
pub const ERROR_PARAMETER_QUOTA_EXCEEDED: DWORD = 1283;
pub const ERROR_DEBUGGER_INACTIVE: DWORD = 1284;
pub const ERROR_DELAY_LOAD_FAILED: DWORD = 1285;
pub const ERROR_VDM_DISALLOWED: DWORD = 1286;
pub const ERROR_UNIDENTIFIED_ERROR: DWORD = 1287;
pub const ERROR_NOT_ALL_ASSIGNED: DWORD = 1300;
pub const ERROR_SOME_NOT_MAPPED: DWORD = 1301;
pub const ERROR_NO_QUOTAS_FOR_ACCOUNT: DWORD = 1302;
pub const ERROR_LOCAL_USER_SESSION_KEY: DWORD = 1303;
pub const ERROR_NULL_LM_PASSWORD: DWORD = 1304;
pub const ERROR_UNKNOWN_REVISION: DWORD = 1305;
pub const ERROR_REVISION_MISMATCH: DWORD = 1306;
pub const ERROR_INVALID_OWNER: DWORD = 1307;
pub const ERROR_INVALID_PRIMARY_GROUP: DWORD = 1308;
pub const ERROR_NO_IMPERSONATION_TOKEN: DWORD = 1309;
pub const ERROR_CANT_DISABLE_MANDATORY: DWORD = 1310;
pub const ERROR_NO_LOGON_SERVERS: DWORD = 1311;
pub const ERROR_NO_SUCH_LOGON_SESSION: DWORD = 1312;
pub const ERROR_NO_SUCH_PRIVILEGE: DWORD = 1313;
pub const ERROR_PRIVILEGE_NOT_HELD: DWORD = 1314;
pub const ERROR_INVALID_ACCOUNT_NAME: DWORD = 1315;
pub const ERROR_USER_EXISTS: DWORD = 1316;
pub const ERROR_NO_SUCH_USER: DWORD = 1317;
pub const ERROR_GROUP_EXISTS: DWORD = 1318;
pub const ERROR_NO_SUCH_GROUP: DWORD = 1319;
pub const ERROR_MEMBER_IN_GROUP: DWORD = 1320;
pub const ERROR_MEMBER_NOT_IN_GROUP: DWORD = 1321;
pub const ERROR_LAST_ADMIN: DWORD = 1322;
pub const ERROR_WRONG_PASSWORD: DWORD = 1323;
pub const ERROR_ILL_FORMED_PASSWORD: DWORD = 1324;
pub const ERROR_PASSWORD_RESTRICTION: DWORD = 1325;
pub const ERROR_LOGON_FAILURE: DWORD = 1326;
pub const ERROR_ACCOUNT_RESTRICTION: DWORD = 1327;
pub const ERROR_INVALID_LOGON_HOURS: DWORD = 1328;
pub const ERROR_INVALID_WORKSTATION: DWORD = 1329;
pub const ERROR_PASSWORD_EXPIRED: DWORD = 1330;
pub const ERROR_ACCOUNT_DISABLED: DWORD = 1331;
pub const ERROR_NONE_MAPPED: DWORD = 1332;
pub const ERROR_TOO_MANY_LUIDS_REQUESTED: DWORD = 1333;
pub const ERROR_LUIDS_EXHAUSTED: DWORD = 1334;
pub const ERROR_INVALID_SUB_AUTHORITY: DWORD = 1335;
pub const ERROR_INVALID_ACL: DWORD = 1336;
pub const ERROR_INVALID_SID: DWORD = 1337;
pub const ERROR_INVALID_SECURITY_DESCR: DWORD = 1338;
pub const ERROR_BAD_INHERITANCE_ACL: DWORD = 1340;
pub const ERROR_SERVER_DISABLED: DWORD = 1341;
pub const ERROR_SERVER_NOT_DISABLED: DWORD = 1342;
pub const ERROR_INVALID_ID_AUTHORITY: DWORD = 1343;
pub const ERROR_ALLOTTED_SPACE_EXCEEDED: DWORD = 1344;
pub const ERROR_INVALID_GROUP_ATTRIBUTES: DWORD = 1345;
pub const ERROR_BAD_IMPERSONATION_LEVEL: DWORD = 1346;
pub const ERROR_CANT_OPEN_ANONYMOUS: DWORD = 1347;
pub const ERROR_BAD_VALIDATION_CLASS: DWORD = 1348;
pub const ERROR_BAD_TOKEN_TYPE: DWORD = 1349;
pub const ERROR_NO_SECURITY_ON_OBJECT: DWORD = 1350;
pub const ERROR_CANT_ACCESS_DOMAIN_INFO: DWORD = 1351;
pub const ERROR_INVALID_SERVER_STATE: DWORD = 1352;
pub const ERROR_INVALID_DOMAIN_STATE: DWORD = 1353;
pub const ERROR_INVALID_DOMAIN_ROLE: DWORD = 1354;
pub const ERROR_NO_SUCH_DOMAIN: DWORD = 1355;
pub const ERROR_DOMAIN_EXISTS: DWORD = 1356;
pub const ERROR_DOMAIN_LIMIT_EXCEEDED: DWORD = 1357;
pub const ERROR_INTERNAL_DB_CORRUPTION: DWORD = 1358;
pub const ERROR_INTERNAL_ERROR: DWORD = 1359;
pub const ERROR_GENERIC_NOT_MAPPED: DWORD = 1360;
pub const ERROR_BAD_DESCRIPTOR_FORMAT: DWORD = 1361;
pub const ERROR_NOT_LOGON_PROCESS: DWORD = 1362;
pub const ERROR_LOGON_SESSION_EXISTS: DWORD = 1363;
pub const ERROR_NO_SUCH_PACKAGE: DWORD = 1364;
pub const ERROR_BAD_LOGON_SESSION_STATE: DWORD = 1365;
pub const ERROR_LOGON_SESSION_COLLISION: DWORD = 1366;
pub const ERROR_INVALID_LOGON_TYPE: DWORD = 1367;
pub const ERROR_CANNOT_IMPERSONATE: DWORD = 1368;
pub const ERROR_RXACT_INVALID_STATE: DWORD = 1369;
pub const ERROR_RXACT_COMMIT_FAILURE: DWORD = 1370;
pub const ERROR_SPECIAL_ACCOUNT: DWORD = 1371;
pub const ERROR_SPECIAL_GROUP: DWORD = 1372;
pub const ERROR_SPECIAL_USER: DWORD = 1373;
pub const ERROR_MEMBERS_PRIMARY_GROUP: DWORD = 1374;
pub const ERROR_TOKEN_ALREADY_IN_USE: DWORD = 1375;
pub const ERROR_NO_SUCH_ALIAS: DWORD = 1376;
pub const ERROR_MEMBER_NOT_IN_ALIAS: DWORD = 1377;
pub const ERROR_MEMBER_IN_ALIAS: DWORD = 1378;
pub const ERROR_ALIAS_EXISTS: DWORD = 1379;
pub const ERROR_LOGON_NOT_GRANTED: DWORD = 1380;
pub const ERROR_TOO_MANY_SECRETS: DWORD = 1381;
pub const ERROR_SECRET_TOO_LONG: DWORD = 1382;
pub const ERROR_INTERNAL_DB_ERROR: DWORD = 1383;
pub const ERROR_TOO_MANY_CONTEXT_IDS: DWORD = 1384;
pub const ERROR_LOGON_TYPE_NOT_GRANTED: DWORD = 1385;
pub const ERROR_NT_CROSS_ENCRYPTION_REQUIRED: DWORD = 1386;
pub const ERROR_NO_SUCH_MEMBER: DWORD = 1387;
pub const ERROR_INVALID_MEMBER: DWORD = 1388;
pub const ERROR_TOO_MANY_SIDS: DWORD = 1389;
pub const ERROR_LM_CROSS_ENCRYPTION_REQUIRED: DWORD = 1390;
pub const ERROR_NO_INHERITANCE: DWORD = 1391;
pub const ERROR_FILE_CORRUPT: DWORD = 1392;
pub const ERROR_DISK_CORRUPT: DWORD = 1393;
pub const ERROR_NO_USER_SESSION_KEY: DWORD = 1394;
pub const ERROR_LICENSE_QUOTA_EXCEEDED: DWORD = 1395;
pub const ERROR_WRONG_TARGET_NAME: DWORD = 1396;
pub const ERROR_MUTUAL_AUTH_FAILED: DWORD = 1397;
pub const ERROR_TIME_SKEW: DWORD = 1398;
pub const ERROR_CURRENT_DOMAIN_NOT_ALLOWED: DWORD = 1399;
pub const ERROR_INVALID_WINDOW_HANDLE: DWORD = 1400;
pub const ERROR_INVALID_MENU_HANDLE: DWORD = 1401;
pub const ERROR_INVALID_CURSOR_HANDLE: DWORD = 1402;
pub const ERROR_INVALID_ACCEL_HANDLE: DWORD = 1403;
pub const ERROR_INVALID_HOOK_HANDLE: DWORD = 1404;
pub const ERROR_INVALID_DWP_HANDLE: DWORD = 1405;
pub const ERROR_TLW_WITH_WSCHILD: DWORD = 1406;
pub const ERROR_CANNOT_FIND_WND_CLASS: DWORD = 1407;
pub const ERROR_WINDOW_OF_OTHER_THREAD: DWORD = 1408;
pub const ERROR_HOTKEY_ALREADY_REGISTERED: DWORD = 1409;
pub const ERROR_CLASS_ALREADY_EXISTS: DWORD = 1410;
pub const ERROR_CLASS_DOES_NOT_EXIST: DWORD = 1411;
pub const ERROR_CLASS_HAS_WINDOWS: DWORD = 1412;
pub const ERROR_INVALID_INDEX: DWORD = 1413;
pub const ERROR_INVALID_ICON_HANDLE: DWORD = 1414;
pub const ERROR_PRIVATE_DIALOG_INDEX: DWORD = 1415;
pub const ERROR_LISTBOX_ID_NOT_FOUND: DWORD = 1416;
pub const ERROR_NO_WILDCARD_CHARACTERS: DWORD = 1417;
pub const ERROR_CLIPBOARD_NOT_OPEN: DWORD = 1418;
pub const ERROR_HOTKEY_NOT_REGISTERED: DWORD = 1419;
pub const ERROR_WINDOW_NOT_DIALOG: DWORD = 1420;
pub const ERROR_CONTROL_ID_NOT_FOUND: DWORD = 1421;
pub const ERROR_INVALID_COMBOBOX_MESSAGE: DWORD = 1422;
pub const ERROR_WINDOW_NOT_COMBOBOX: DWORD = 1423;
pub const ERROR_INVALID_EDIT_HEIGHT: DWORD = 1424;
pub const ERROR_DC_NOT_FOUND: DWORD = 1425;
pub const ERROR_INVALID_HOOK_FILTER: DWORD = 1426;
pub const ERROR_INVALID_FILTER_PROC: DWORD = 1427;
pub const ERROR_HOOK_NEEDS_HMOD: DWORD = 1428;
pub const ERROR_GLOBAL_ONLY_HOOK: DWORD = 1429;
pub const ERROR_JOURNAL_HOOK_SET: DWORD = 1430;
pub const ERROR_HOOK_NOT_INSTALLED: DWORD = 1431;
pub const ERROR_INVALID_LB_MESSAGE: DWORD = 1432;
pub const ERROR_SETCOUNT_ON_BAD_LB: DWORD = 1433;
pub const ERROR_LB_WITHOUT_TABSTOPS: DWORD = 1434;
pub const ERROR_DESTROY_OBJECT_OF_OTHER_THREAD: DWORD = 1435;
pub const ERROR_CHILD_WINDOW_MENU: DWORD = 1436;
pub const ERROR_NO_SYSTEM_MENU: DWORD = 1437;
pub const ERROR_INVALID_MSGBOX_STYLE: DWORD = 1438;
pub const ERROR_INVALID_SPI_VALUE: DWORD = 1439;
pub const ERROR_SCREEN_ALREADY_LOCKED: DWORD = 1440;
pub const ERROR_HWNDS_HAVE_DIFF_PARENT: DWORD = 1441;
pub const ERROR_NOT_CHILD_WINDOW: DWORD = 1442;
pub const ERROR_INVALID_GW_COMMAND: DWORD = 1443;
pub const ERROR_INVALID_THREAD_ID: DWORD = 1444;
pub const ERROR_NON_MDICHILD_WINDOW: DWORD = 1445;
pub const ERROR_POPUP_ALREADY_ACTIVE: DWORD = 1446;
pub const ERROR_NO_SCROLLBARS: DWORD = 1447;
pub const ERROR_INVALID_SCROLLBAR_RANGE: DWORD = 1448;
pub const ERROR_INVALID_SHOWWIN_COMMAND: DWORD = 1449;
pub const ERROR_NO_SYSTEM_RESOURCES: DWORD = 1450;
pub const ERROR_NONPAGED_SYSTEM_RESOURCES: DWORD = 1451;
pub const ERROR_PAGED_SYSTEM_RESOURCES: DWORD = 1452;
pub const ERROR_WORKING_SET_QUOTA: DWORD = 1453;
pub const ERROR_PAGEFILE_QUOTA: DWORD = 1454;
pub const ERROR_COMMITMENT_LIMIT: DWORD = 1455;
pub const ERROR_MENU_ITEM_NOT_FOUND: DWORD = 1456;
pub const ERROR_INVALID_KEYBOARD_HANDLE: DWORD = 1457;
pub const ERROR_HOOK_TYPE_NOT_ALLOWED: DWORD = 1458;
pub const ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION: DWORD = 1459;
pub const ERROR_TIMEOUT: DWORD = 1460;
pub const ERROR_INVALID_MONITOR_HANDLE: DWORD = 1461;
pub const ERROR_INCORRECT_SIZE: DWORD = 1462;
pub const ERROR_SYMLINK_CLASS_DISABLED: DWORD = 1463;
pub const ERROR_SYMLINK_NOT_SUPPORTED: DWORD = 1464;
pub const ERROR_XML_PARSE_ERROR: DWORD = 1465;
pub const ERROR_XMLDSIG_ERROR: DWORD = 1466;
pub const ERROR_RESTART_APPLICATION: DWORD = 1467;
pub const ERROR_WRONG_COMPARTMENT: DWORD = 1468;
pub const ERROR_AUTHIP_FAILURE: DWORD = 1469;
pub const ERROR_NO_NVRAM_RESOURCES: DWORD = 1470;
pub const ERROR_NOT_GUI_PROCESS: DWORD = 1471;
pub const ERROR_EVENTLOG_FILE_CORRUPT: DWORD = 1500;
pub const ERROR_EVENTLOG_CANT_START: DWORD = 1501;
pub const ERROR_LOG_FILE_FULL: DWORD = 1502;
pub const ERROR_EVENTLOG_FILE_CHANGED: DWORD = 1503;
pub const ERROR_INSTALL_SERVICE_FAILURE: DWORD = 1601;
pub const ERROR_INSTALL_USEREXIT: DWORD = 1602;
pub const ERROR_INSTALL_FAILURE: DWORD = 1603;
pub const ERROR_INSTALL_SUSPEND: DWORD = 1604;
pub const ERROR_UNKNOWN_PRODUCT: DWORD = 1605;
pub const ERROR_UNKNOWN_FEATURE: DWORD = 1606;
pub const ERROR_UNKNOWN_COMPONENT: DWORD = 1607;
pub const ERROR_UNKNOWN_PROPERTY: DWORD = 1608;
pub const ERROR_INVALID_HANDLE_STATE: DWORD = 1609;
pub const ERROR_BAD_CONFIGURATION: DWORD = 1610;
pub const ERROR_INDEX_ABSENT: DWORD = 1611;
pub const ERROR_INSTALL_SOURCE_ABSENT: DWORD = 1612;
pub const ERROR_INSTALL_PACKAGE_VERSION: DWORD = 1613;
pub const ERROR_PRODUCT_UNINSTALLED: DWORD = 1614;
pub const ERROR_BAD_QUERY_SYNTAX: DWORD = 1615;
pub const ERROR_INVALID_FIELD: DWORD = 1616;
pub const ERROR_DEVICE_REMOVED: DWORD = 1617;
pub const ERROR_INSTALL_ALREADY_RUNNING: DWORD = 1618;
pub const ERROR_INSTALL_PACKAGE_OPEN_FAILED: DWORD = 1619;
pub const ERROR_INSTALL_PACKAGE_INVALID: DWORD = 1620;
pub const ERROR_INSTALL_UI_FAILURE: DWORD = 1621;
pub const ERROR_INSTALL_LOG_FAILURE: DWORD = 1622;
pub const ERROR_INSTALL_LANGUAGE_UNSUPPORTED: DWORD = 1623;
pub const ERROR_INSTALL_TRANSFORM_FAILURE: DWORD = 1624;
pub const ERROR_INSTALL_PACKAGE_REJECTED: DWORD = 1625;
pub const ERROR_FUNCTION_NOT_CALLED: DWORD = 1626;
pub const ERROR_FUNCTION_FAILED: DWORD = 1627;
pub const ERROR_INVALID_TABLE: DWORD = 1628;
pub const ERROR_DATATYPE_MISMATCH: DWORD = 1629;
pub const ERROR_UNSUPPORTED_TYPE: DWORD = 1630;
pub const ERROR_CREATE_FAILED: DWORD = 1631;
pub const ERROR_INSTALL_TEMP_UNWRITABLE: DWORD = 1632;
pub const ERROR_INSTALL_PLATFORM_UNSUPPORTED: DWORD = 1633;
pub const ERROR_INSTALL_NOTUSED: DWORD = 1634;
pub const ERROR_PATCH_PACKAGE_OPEN_FAILED: DWORD = 1635;
pub const ERROR_PATCH_PACKAGE_INVALID: DWORD = 1636;
pub const ERROR_PATCH_PACKAGE_UNSUPPORTED: DWORD = 1637;
pub const ERROR_PRODUCT_VERSION: DWORD = 1638;
pub const ERROR_INVALID_COMMAND_LINE: DWORD = 1639;
pub const ERROR_INSTALL_REMOTE_DISALLOWED: DWORD = 1640;
pub const ERROR_SUCCESS_REBOOT_INITIATED: DWORD = 1641;
pub const ERROR_PATCH_TARGET_NOT_FOUND: DWORD = 1642;
pub const ERROR_PATCH_PACKAGE_REJECTED: DWORD = 1643;
pub const ERROR_INSTALL_TRANSFORM_REJECTED: DWORD = 1644;
pub const ERROR_INSTALL_REMOTE_PROHIBITED: DWORD = 1645;
pub const ERROR_INVALID_USER_BUFFER: DWORD = 1784;
pub const ERROR_UNRECOGNIZED_MEDIA: DWORD = 1785;
pub const ERROR_NO_TRUST_LSA_SECRET: DWORD = 1786;
pub const ERROR_NO_TRUST_SAM_ACCOUNT: DWORD = 1787;
pub const ERROR_TRUSTED_DOMAIN_FAILURE: DWORD = 1788;
pub const ERROR_TRUSTED_RELATIONSHIP_FAILURE: DWORD = 1789;
pub const ERROR_TRUST_FAILURE: DWORD = 1790;
pub const ERROR_NETLOGON_NOT_STARTED: DWORD = 1792;
pub const ERROR_ACCOUNT_EXPIRED: DWORD = 1793;
pub const ERROR_REDIRECTOR_HAS_OPEN_HANDLES: DWORD = 1794;
pub const ERROR_PRINTER_DRIVER_ALREADY_INSTALLED: DWORD = 1795;
pub const ERROR_UNKNOWN_PORT: DWORD = 1796;
pub const ERROR_UNKNOWN_PRINTER_DRIVER: DWORD = 1797;
pub const ERROR_UNKNOWN_PRINTPROCESSOR: DWORD = 1798;
pub const ERROR_INVALID_SEPARATOR_FILE: DWORD = 1799;
pub const ERROR_INVALID_PRIORITY: DWORD = 1800;
pub const ERROR_INVALID_PRINTER_NAME: DWORD = 1801;
pub const ERROR_PRINTER_ALREADY_EXISTS: DWORD = 1802;
pub const ERROR_INVALID_PRINTER_COMMAND: DWORD = 1803;
pub const ERROR_INVALID_DATATYPE: DWORD = 1804;
pub const ERROR_INVALID_ENVIRONMENT: DWORD = 1805;
pub const ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT: DWORD = 1807;
pub const ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT: DWORD = 1808;
pub const ERROR_NOLOGON_SERVER_TRUST_ACCOUNT: DWORD = 1809;
pub const ERROR_DOMAIN_TRUST_INCONSISTENT: DWORD = 1810;
pub const ERROR_SERVER_HAS_OPEN_HANDLES: DWORD = 1811;
pub const ERROR_RESOURCE_DATA_NOT_FOUND: DWORD = 1812;
pub const ERROR_RESOURCE_TYPE_NOT_FOUND: DWORD = 1813;
pub const ERROR_RESOURCE_NAME_NOT_FOUND: DWORD = 1814;
pub const ERROR_RESOURCE_LANG_NOT_FOUND: DWORD = 1815;
pub const ERROR_NOT_ENOUGH_QUOTA: DWORD = 1816;
pub const ERROR_INVALID_TIME: DWORD = 1901;
pub const ERROR_INVALID_FORM_NAME: DWORD = 1902;
pub const ERROR_INVALID_FORM_SIZE: DWORD = 1903;
pub const ERROR_ALREADY_WAITING: DWORD = 1904;
pub const ERROR_PRINTER_DELETED: DWORD = 1905;
pub const ERROR_INVALID_PRINTER_STATE: DWORD = 1906;
pub const ERROR_PASSWORD_MUST_CHANGE: DWORD = 1907;
pub const ERROR_DOMAIN_CONTROLLER_NOT_FOUND: DWORD = 1908;
pub const ERROR_ACCOUNT_LOCKED_OUT: DWORD = 1909;
pub const ERROR_NO_SITENAME: DWORD = 1919;
pub const ERROR_CANT_ACCESS_FILE: DWORD = 1920;
pub const ERROR_CANT_RESOLVE_FILENAME: DWORD = 1921;
pub const ERROR_KM_DRIVER_BLOCKED: DWORD = 1930;
pub const ERROR_CONTEXT_EXPIRED: DWORD = 1931;
pub const ERROR_PER_USER_TRUST_QUOTA_EXCEEDED: DWORD = 1932;
pub const ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED: DWORD = 1933;
pub const ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED: DWORD = 1934;
pub const ERROR_AUTHENTICATION_FIREWALL_FAILED: DWORD = 1935;
pub const ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED: DWORD = 1936;
pub const ERROR_INVALID_PIXEL_FORMAT: DWORD = 2000;
pub const ERROR_BAD_DRIVER: DWORD = 2001;
pub const ERROR_INVALID_WINDOW_STYLE: DWORD = 2002;
pub const ERROR_METAFILE_NOT_SUPPORTED: DWORD = 2003;
pub const ERROR_TRANSFORM_NOT_SUPPORTED: DWORD = 2004;
pub const ERROR_CLIPPING_NOT_SUPPORTED: DWORD = 2005;
pub const ERROR_INVALID_CMM: DWORD = 2010;
pub const ERROR_INVALID_PROFILE: DWORD = 2011;
pub const ERROR_TAG_NOT_FOUND: DWORD = 2012;
pub const ERROR_TAG_NOT_PRESENT: DWORD = 2013;
pub const ERROR_DUPLICATE_TAG: DWORD = 2014;
pub const ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE: DWORD = 2015;
pub const ERROR_PROFILE_NOT_FOUND: DWORD = 2016;
pub const ERROR_INVALID_COLORSPACE: DWORD = 2017;
pub const ERROR_ICM_NOT_ENABLED: DWORD = 2018;
pub const ERROR_DELETING_ICM_XFORM: DWORD = 2019;
pub const ERROR_INVALID_TRANSFORM: DWORD = 2020;
pub const ERROR_COLORSPACE_MISMATCH: DWORD = 2021;
pub const ERROR_INVALID_COLORINDEX: DWORD = 2022;
pub const ERROR_CONNECTED_OTHER_PASSWORD: DWORD = 2108;
pub const ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT: DWORD = 2109;
pub const ERROR_BAD_USERNAME: DWORD = 2202;
pub const ERROR_NOT_CONNECTED: DWORD = 2250;
pub const ERROR_OPEN_FILES: DWORD = 2401;
pub const ERROR_ACTIVE_CONNECTIONS: DWORD = 2402;
pub const ERROR_DEVICE_IN_USE: DWORD = 2404;
pub const ERROR_UNKNOWN_PRINT_MONITOR: DWORD = 3000;
pub const ERROR_PRINTER_DRIVER_IN_USE: DWORD = 3001;
pub const ERROR_SPOOL_FILE_NOT_FOUND: DWORD = 3002;
pub const ERROR_SPL_NO_STARTDOC: DWORD = 3003;
pub const ERROR_SPL_NO_ADDJOB: DWORD = 3004;
pub const ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED: DWORD = 3005;
pub const ERROR_PRINT_MONITOR_ALREADY_INSTALLED: DWORD = 3006;
pub const ERROR_INVALID_PRINT_MONITOR: DWORD = 3007;
pub const ERROR_PRINT_MONITOR_IN_USE: DWORD = 3008;
pub const ERROR_PRINTER_HAS_JOBS_QUEUED: DWORD = 3009;
pub const ERROR_SUCCESS_REBOOT_REQUIRED: DWORD = 3010;
pub const ERROR_SUCCESS_RESTART_REQUIRED: DWORD = 3011;
pub const ERROR_PRINTER_NOT_FOUND: DWORD = 3012;
pub const ERROR_PRINTER_DRIVER_WARNED: DWORD = 3013;
pub const ERROR_PRINTER_DRIVER_BLOCKED: DWORD = 3014;
pub const ERROR_WINS_INTERNAL: DWORD = 4000;
pub const ERROR_CAN_NOT_DEL_LOCAL_WINS: DWORD = 4001;
pub const ERROR_STATIC_INIT: DWORD = 4002;
pub const ERROR_INC_BACKUP: DWORD = 4003;
pub const ERROR_FULL_BACKUP: DWORD = 4004;
pub const ERROR_REC_NON_EXISTENT: DWORD = 4005;
pub const ERROR_RPL_NOT_ALLOWED: DWORD = 4006;
pub const ERROR_DHCP_ADDRESS_CONFLICT: DWORD = 4100;
pub const ERROR_WMI_GUID_NOT_FOUND: DWORD = 4200;
pub const ERROR_WMI_INSTANCE_NOT_FOUND: DWORD = 4201;
pub const ERROR_WMI_ITEMID_NOT_FOUND: DWORD = 4202;
pub const ERROR_WMI_TRY_AGAIN: DWORD = 4203;
pub const ERROR_WMI_DP_NOT_FOUND: DWORD = 4204;
pub const ERROR_WMI_UNRESOLVED_INSTANCE_REF: DWORD = 4205;
pub const ERROR_WMI_ALREADY_ENABLED: DWORD = 4206;
pub const ERROR_WMI_GUID_DISCONNECTED: DWORD = 4207;
pub const ERROR_WMI_SERVER_UNAVAILABLE: DWORD = 4208;
pub const ERROR_WMI_DP_FAILED: DWORD = 4209;
pub const ERROR_WMI_INVALID_MOF: DWORD = 4210;
pub const ERROR_WMI_INVALID_REGINFO: DWORD = 4211;
pub const ERROR_WMI_ALREADY_DISABLED: DWORD = 4212;
pub const ERROR_WMI_READ_ONLY: DWORD = 4213;
pub const ERROR_WMI_SET_FAILURE: DWORD = 4214;
pub const ERROR_INVALID_MEDIA: DWORD = 4300;
pub const ERROR_INVALID_LIBRARY: DWORD = 4301;
pub const ERROR_INVALID_MEDIA_POOL: DWORD = 4302;
pub const ERROR_DRIVE_MEDIA_MISMATCH: DWORD = 4303;
pub const ERROR_MEDIA_OFFLINE: DWORD = 4304;
pub const ERROR_LIBRARY_OFFLINE: DWORD = 4305;
pub const ERROR_EMPTY: DWORD = 4306;
pub const ERROR_NOT_EMPTY: DWORD = 4307;
pub const ERROR_MEDIA_UNAVAILABLE: DWORD = 4308;
pub const ERROR_RESOURCE_DISABLED: DWORD = 4309;
pub const ERROR_INVALID_CLEANER: DWORD = 4310;
pub const ERROR_UNABLE_TO_CLEAN: DWORD = 4311;
pub const ERROR_OBJECT_NOT_FOUND: DWORD = 4312;
pub const ERROR_DATABASE_FAILURE: DWORD = 4313;
pub const ERROR_DATABASE_FULL: DWORD = 4314;
pub const ERROR_MEDIA_INCOMPATIBLE: DWORD = 4315;
pub const ERROR_RESOURCE_NOT_PRESENT: DWORD = 4316;
pub const ERROR_INVALID_OPERATION: DWORD = 4317;
pub const ERROR_MEDIA_NOT_AVAILABLE: DWORD = 4318;
pub const ERROR_DEVICE_NOT_AVAILABLE: DWORD = 4319;
pub const ERROR_REQUEST_REFUSED: DWORD = 4320;
pub const ERROR_INVALID_DRIVE_OBJECT: DWORD = 4321;
pub const ERROR_LIBRARY_FULL: DWORD = 4322;
pub const ERROR_MEDIUM_NOT_ACCESSIBLE: DWORD = 4323;
pub const ERROR_UNABLE_TO_LOAD_MEDIUM: DWORD = 4324;
pub const ERROR_UNABLE_TO_INVENTORY_DRIVE: DWORD = 4325;
pub const ERROR_UNABLE_TO_INVENTORY_SLOT: DWORD = 4326;
pub const ERROR_UNABLE_TO_INVENTORY_TRANSPORT: DWORD = 4327;
pub const ERROR_TRANSPORT_FULL: DWORD = 4328;
pub const ERROR_CONTROLLING_IEPORT: DWORD = 4329;
pub const ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA: DWORD = 4330;
pub const ERROR_CLEANER_SLOT_SET: DWORD = 4331;
pub const ERROR_CLEANER_SLOT_NOT_SET: DWORD = 4332;
pub const ERROR_CLEANER_CARTRIDGE_SPENT: DWORD = 4333;
pub const ERROR_UNEXPECTED_OMID: DWORD = 4334;
pub const ERROR_CANT_DELETE_LAST_ITEM: DWORD = 4335;
pub const ERROR_MESSAGE_EXCEEDS_MAX_SIZE: DWORD = 4336;
pub const ERROR_VOLUME_CONTAINS_SYS_FILES: DWORD = 4337;
pub const ERROR_INDIGENOUS_TYPE: DWORD = 4338;
pub const ERROR_NO_SUPPORTING_DRIVES: DWORD = 4339;
pub const ERROR_CLEANER_CARTRIDGE_INSTALLED: DWORD = 4340;
pub const ERROR_IEPORT_FULL: DWORD = 4341;
pub const ERROR_FILE_OFFLINE: DWORD = 4350;
pub const ERROR_REMOTE_STORAGE_NOT_ACTIVE: DWORD = 4351;
pub const ERROR_REMOTE_STORAGE_MEDIA_ERROR: DWORD = 4352;
pub const ERROR_NOT_A_REPARSE_POINT: DWORD = 4390;
pub const ERROR_REPARSE_ATTRIBUTE_CONFLICT: DWORD = 4391;
pub const ERROR_INVALID_REPARSE_DATA: DWORD = 4392;
pub const ERROR_REPARSE_TAG_INVALID: DWORD = 4393;
pub const ERROR_REPARSE_TAG_MISMATCH: DWORD = 4394;
pub const ERROR_VOLUME_NOT_SIS_ENABLED: DWORD = 4500;
pub const ERROR_DEPENDENT_RESOURCE_EXISTS: DWORD = 5001;
pub const ERROR_DEPENDENCY_NOT_FOUND: DWORD = 5002;
pub const ERROR_DEPENDENCY_ALREADY_EXISTS: DWORD = 5003;
pub const ERROR_RESOURCE_NOT_ONLINE: DWORD = 5004;
pub const ERROR_HOST_NODE_NOT_AVAILABLE: DWORD = 5005;
pub const ERROR_RESOURCE_NOT_AVAILABLE: DWORD = 5006;
pub const ERROR_RESOURCE_NOT_FOUND: DWORD = 5007;
pub const ERROR_SHUTDOWN_CLUSTER: DWORD = 5008;
pub const ERROR_CANT_EVICT_ACTIVE_NODE: DWORD = 5009;
pub const ERROR_OBJECT_ALREADY_EXISTS: DWORD = 5010;
pub const ERROR_OBJECT_IN_LIST: DWORD = 5011;
pub const ERROR_GROUP_NOT_AVAILABLE: DWORD = 5012;
pub const ERROR_GROUP_NOT_FOUND: DWORD = 5013;
pub const ERROR_GROUP_NOT_ONLINE: DWORD = 5014;
pub const ERROR_HOST_NODE_NOT_RESOURCE_OWNER: DWORD = 5015;
pub const ERROR_HOST_NODE_NOT_GROUP_OWNER: DWORD = 5016;
pub const ERROR_RESMON_CREATE_FAILED: DWORD = 5017;
pub const ERROR_RESMON_ONLINE_FAILED: DWORD = 5018;
pub const ERROR_RESOURCE_ONLINE: DWORD = 5019;
pub const ERROR_QUORUM_RESOURCE: DWORD = 5020;
pub const ERROR_NOT_QUORUM_CAPABLE: DWORD = 5021;
pub const ERROR_CLUSTER_SHUTTING_DOWN: DWORD = 5022;
pub const ERROR_INVALID_STATE: DWORD = 5023;
pub const ERROR_RESOURCE_PROPERTIES_STORED: DWORD = 5024;
pub const ERROR_NOT_QUORUM_CLASS: DWORD = 5025;
pub const ERROR_CORE_RESOURCE: DWORD = 5026;
pub const ERROR_QUORUM_RESOURCE_ONLINE_FAILED: DWORD = 5027;
pub const ERROR_QUORUMLOG_OPEN_FAILED: DWORD = 5028;
pub const ERROR_CLUSTERLOG_CORRUPT: DWORD = 5029;
pub const ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE: DWORD = 5030;
pub const ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE: DWORD = 5031;
pub const ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND: DWORD = 5032;
pub const ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE: DWORD = 5033;
pub const ERROR_QUORUM_OWNER_ALIVE: DWORD = 5034;
pub const ERROR_NETWORK_NOT_AVAILABLE: DWORD = 5035;
pub const ERROR_NODE_NOT_AVAILABLE: DWORD = 5036;
pub const ERROR_ALL_NODES_NOT_AVAILABLE: DWORD = 5037;
pub const ERROR_RESOURCE_FAILED: DWORD = 5038;
pub const ERROR_CLUSTER_INVALID_NODE: DWORD = 5039;
pub const ERROR_CLUSTER_NODE_EXISTS: DWORD = 5040;
pub const ERROR_CLUSTER_JOIN_IN_PROGRESS: DWORD = 5041;
pub const ERROR_CLUSTER_NODE_NOT_FOUND: DWORD = 5042;
pub const ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND: DWORD = 5043;
pub const ERROR_CLUSTER_NETWORK_EXISTS: DWORD = 5044;
pub const ERROR_CLUSTER_NETWORK_NOT_FOUND: DWORD = 5045;
pub const ERROR_CLUSTER_NETINTERFACE_EXISTS: DWORD = 5046;
pub const ERROR_CLUSTER_NETINTERFACE_NOT_FOUND: DWORD = 5047;
pub const ERROR_CLUSTER_INVALID_REQUEST: DWORD = 5048;
pub const ERROR_CLUSTER_INVALID_NETWORK_PROVIDER: DWORD = 5049;
pub const ERROR_CLUSTER_NODE_DOWN: DWORD = 5050;
pub const ERROR_CLUSTER_NODE_UNREACHABLE: DWORD = 5051;
pub const ERROR_CLUSTER_NODE_NOT_MEMBER: DWORD = 5052;
pub const ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS: DWORD = 5053;
pub const ERROR_CLUSTER_INVALID_NETWORK: DWORD = 5054;
pub const ERROR_CLUSTER_NODE_UP: DWORD = 5056;
pub const ERROR_CLUSTER_IPADDR_IN_USE: DWORD = 5057;
pub const ERROR_CLUSTER_NODE_NOT_PAUSED: DWORD = 5058;
pub const ERROR_CLUSTER_NO_SECURITY_CONTEXT: DWORD = 5059;
pub const ERROR_CLUSTER_NETWORK_NOT_INTERNAL: DWORD = 5060;
pub const ERROR_CLUSTER_NODE_ALREADY_UP: DWORD = 5061;
pub const ERROR_CLUSTER_NODE_ALREADY_DOWN: DWORD = 5062;
pub const ERROR_CLUSTER_NETWORK_ALREADY_ONLINE: DWORD = 5063;
pub const ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE: DWORD = 5064;
pub const ERROR_CLUSTER_NODE_ALREADY_MEMBER: DWORD = 5065;
pub const ERROR_CLUSTER_LAST_INTERNAL_NETWORK: DWORD = 5066;
pub const ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS: DWORD = 5067;
pub const ERROR_INVALID_OPERATION_ON_QUORUM: DWORD = 5068;
pub const ERROR_DEPENDENCY_NOT_ALLOWED: DWORD = 5069;
pub const ERROR_CLUSTER_NODE_PAUSED: DWORD = 5070;
pub const ERROR_NODE_CANT_HOST_RESOURCE: DWORD = 5071;
pub const ERROR_CLUSTER_NODE_NOT_READY: DWORD = 5072;
pub const ERROR_CLUSTER_NODE_SHUTTING_DOWN: DWORD = 5073;
pub const ERROR_CLUSTER_JOIN_ABORTED: DWORD = 5074;
pub const ERROR_CLUSTER_INCOMPATIBLE_VERSIONS: DWORD = 5075;
pub const ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED: DWORD = 5076;
pub const ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED: DWORD = 5077;
pub const ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND: DWORD = 5078;
pub const ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED: DWORD = 5079;
pub const ERROR_CLUSTER_RESNAME_NOT_FOUND: DWORD = 5080;
pub const ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED: DWORD = 5081;
pub const ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST: DWORD = 5082;
pub const ERROR_CLUSTER_DATABASE_SEQMISMATCH: DWORD = 5083;
pub const ERROR_RESMON_INVALID_STATE: DWORD = 5084;
pub const ERROR_CLUSTER_GUM_NOT_LOCKER: DWORD = 5085;
pub const ERROR_QUORUM_DISK_NOT_FOUND: DWORD = 5086;
pub const ERROR_DATABASE_BACKUP_CORRUPT: DWORD = 5087;
pub const ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT: DWORD = 5088;
pub const ERROR_RESOURCE_PROPERTY_UNCHANGEABLE: DWORD = 5089;
pub const ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE: DWORD = 5890;
pub const ERROR_CLUSTER_QUORUMLOG_NOT_FOUND: DWORD = 5891;
pub const ERROR_CLUSTER_MEMBERSHIP_HALT: DWORD = 5892;
pub const ERROR_CLUSTER_INSTANCE_ID_MISMATCH: DWORD = 5893;
pub const ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP: DWORD = 5894;
pub const ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH: DWORD = 5895;
pub const ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP: DWORD = 5896;
pub const ERROR_CLUSTER_PARAMETER_MISMATCH: DWORD = 5897;
pub const ERROR_NODE_CANNOT_BE_CLUSTERED: DWORD = 5898;
pub const ERROR_CLUSTER_WRONG_OS_VERSION: DWORD = 5899;
pub const ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME: DWORD = 5900;
pub const ERROR_CLUSCFG_ALREADY_COMMITTED: DWORD = 5901;
pub const ERROR_CLUSCFG_ROLLBACK_FAILED: DWORD = 5902;
pub const ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT: DWORD = 5903;
pub const ERROR_CLUSTER_OLD_VERSION: DWORD = 5904;
pub const ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME: DWORD = 5905;
pub const ERROR_ENCRYPTION_FAILED: DWORD = 6000;
pub const ERROR_DECRYPTION_FAILED: DWORD = 6001;
pub const ERROR_FILE_ENCRYPTED: DWORD = 6002;
pub const ERROR_NO_RECOVERY_POLICY: DWORD = 6003;
pub const ERROR_NO_EFS: DWORD = 6004;
pub const ERROR_WRONG_EFS: DWORD = 6005;
pub const ERROR_NO_USER_KEYS: DWORD = 6006;
pub const ERROR_FILE_NOT_ENCRYPTED: DWORD = 6007;
pub const ERROR_NOT_EXPORT_FORMAT: DWORD = 6008;
pub const ERROR_FILE_READ_ONLY: DWORD = 6009;
pub const ERROR_DIR_EFS_DISALLOWED: DWORD = 6010;
pub const ERROR_EFS_SERVER_NOT_TRUSTED: DWORD = 6011;
pub const ERROR_BAD_RECOVERY_POLICY: DWORD = 6012;
pub const ERROR_EFS_ALG_BLOB_TOO_BIG: DWORD = 6013;
pub const ERROR_VOLUME_NOT_SUPPORT_EFS: DWORD = 6014;
pub const ERROR_EFS_DISABLED: DWORD = 6015;
pub const ERROR_EFS_VERSION_NOT_SUPPORT: DWORD = 6016;
pub const ERROR_NO_BROWSER_SERVERS_FOUND: DWORD = 6118;
pub const ERROR_CTX_WINSTATION_NAME_INVALID: DWORD = 7001;
pub const ERROR_CTX_INVALID_PD: DWORD = 7002;
pub const ERROR_CTX_PD_NOT_FOUND: DWORD = 7003;
pub const ERROR_CTX_WD_NOT_FOUND: DWORD = 7004;
pub const ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY: DWORD = 7005;
pub const ERROR_CTX_SERVICE_NAME_COLLISION: DWORD = 7006;
pub const ERROR_CTX_CLOSE_PENDING: DWORD = 7007;
pub const ERROR_CTX_NO_OUTBUF: DWORD = 7008;
pub const ERROR_CTX_MODEM_INF_NOT_FOUND: DWORD = 7009;
pub const ERROR_CTX_INVALID_MODEMNAME: DWORD = 7010;
pub const ERROR_CTX_MODEM_RESPONSE_ERROR: DWORD = 7011;
pub const ERROR_CTX_MODEM_RESPONSE_TIMEOUT: DWORD = 7012;
pub const ERROR_CTX_MODEM_RESPONSE_NO_CARRIER: DWORD = 7013;
pub const ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE: DWORD = 7014;
pub const ERROR_CTX_MODEM_RESPONSE_BUSY: DWORD = 7015;
pub const ERROR_CTX_MODEM_RESPONSE_VOICE: DWORD = 7016;
pub const ERROR_CTX_TD_ERROR: DWORD = 7017;
pub const ERROR_CTX_WINSTATION_NOT_FOUND: DWORD = 7022;
pub const ERROR_CTX_WINSTATION_ALREADY_EXISTS: DWORD = 7023;
pub const ERROR_CTX_WINSTATION_BUSY: DWORD = 7024;
pub const ERROR_CTX_BAD_VIDEO_MODE: DWORD = 7025;
pub const ERROR_CTX_GRAPHICS_INVALID: DWORD = 7035;
pub const ERROR_CTX_LOGON_DISABLED: DWORD = 7037;
pub const ERROR_CTX_NOT_CONSOLE: DWORD = 7038;
pub const ERROR_CTX_CLIENT_QUERY_TIMEOUT: DWORD = 7040;
pub const ERROR_CTX_CONSOLE_DISCONNECT: DWORD = 7041;
pub const ERROR_CTX_CONSOLE_CONNECT: DWORD = 7042;
pub const ERROR_CTX_SHADOW_DENIED: DWORD = 7044;
pub const ERROR_CTX_WINSTATION_ACCESS_DENIED: DWORD = 7045;
pub const ERROR_CTX_INVALID_WD: DWORD = 7049;
pub const ERROR_CTX_SHADOW_INVALID: DWORD = 7050;
pub const ERROR_CTX_SHADOW_DISABLED: DWORD = 7051;
pub const ERROR_CTX_CLIENT_LICENSE_IN_USE: DWORD = 7052;
pub const ERROR_CTX_CLIENT_LICENSE_NOT_SET: DWORD = 7053;
pub const ERROR_CTX_LICENSE_NOT_AVAILABLE: DWORD = 7054;
pub const ERROR_CTX_LICENSE_CLIENT_INVALID: DWORD = 7055;
pub const ERROR_CTX_LICENSE_EXPIRED: DWORD = 7056;
pub const ERROR_CTX_SHADOW_NOT_RUNNING: DWORD = 7057;
pub const ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE: DWORD = 7058;
pub const ERROR_ACTIVATION_COUNT_EXCEEDED: DWORD = 7059;
pub const ERROR_DS_NOT_INSTALLED: DWORD = 8200;
pub const ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY: DWORD = 8201;
pub const ERROR_DS_NO_ATTRIBUTE_OR_VALUE: DWORD = 8202;
pub const ERROR_DS_INVALID_ATTRIBUTE_SYNTAX: DWORD = 8203;
pub const ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED: DWORD = 8204;
pub const ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS: DWORD = 8205;
pub const ERROR_DS_BUSY: DWORD = 8206;
pub const ERROR_DS_UNAVAILABLE: DWORD = 8207;
pub const ERROR_DS_NO_RIDS_ALLOCATED: DWORD = 8208;
pub const ERROR_DS_NO_MORE_RIDS: DWORD = 8209;
pub const ERROR_DS_INCORRECT_ROLE_OWNER: DWORD = 8210;
pub const ERROR_DS_RIDMGR_INIT_ERROR: DWORD = 8211;
pub const ERROR_DS_OBJ_CLASS_VIOLATION: DWORD = 8212;
pub const ERROR_DS_CANT_ON_NON_LEAF: DWORD = 8213;
pub const ERROR_DS_CANT_ON_RDN: DWORD = 8214;
pub const ERROR_DS_CANT_MOD_OBJ_CLASS: DWORD = 8215;
pub const ERROR_DS_CROSS_DOM_MOVE_ERROR: DWORD = 8216;
pub const ERROR_DS_GC_NOT_AVAILABLE: DWORD = 8217;
pub const ERROR_SHARED_POLICY: DWORD = 8218;
pub const ERROR_POLICY_OBJECT_NOT_FOUND: DWORD = 8219;
pub const ERROR_POLICY_ONLY_IN_DS: DWORD = 8220;
pub const ERROR_PROMOTION_ACTIVE: DWORD = 8221;
pub const ERROR_NO_PROMOTION_ACTIVE: DWORD = 8222;
pub const ERROR_DS_OPERATIONS_ERROR: DWORD = 8224;
pub const ERROR_DS_PROTOCOL_ERROR: DWORD = 8225;
pub const ERROR_DS_TIMELIMIT_EXCEEDED: DWORD = 8226;
pub const ERROR_DS_SIZELIMIT_EXCEEDED: DWORD = 8227;
pub const ERROR_DS_ADMIN_LIMIT_EXCEEDED: DWORD = 8228;
pub const ERROR_DS_COMPARE_FALSE: DWORD = 8229;
pub const ERROR_DS_COMPARE_TRUE: DWORD = 8230;
pub const ERROR_DS_AUTH_METHOD_NOT_SUPPORTED: DWORD = 8231;
pub const ERROR_DS_STRONG_AUTH_REQUIRED: DWORD = 8232;
pub const ERROR_DS_INAPPROPRIATE_AUTH: DWORD = 8233;
pub const ERROR_DS_AUTH_UNKNOWN: DWORD = 8234;
pub const ERROR_DS_REFERRAL: DWORD = 8235;
pub const ERROR_DS_UNAVAILABLE_CRIT_EXTENSION: DWORD = 8236;
pub const ERROR_DS_CONFIDENTIALITY_REQUIRED: DWORD = 8237;
pub const ERROR_DS_INAPPROPRIATE_MATCHING: DWORD = 8238;
pub const ERROR_DS_CONSTRAINT_VIOLATION: DWORD = 8239;
pub const ERROR_DS_NO_SUCH_OBJECT: DWORD = 8240;
pub const ERROR_DS_ALIAS_PROBLEM: DWORD = 8241;
pub const ERROR_DS_INVALID_DN_SYNTAX: DWORD = 8242;
pub const ERROR_DS_IS_LEAF: DWORD = 8243;
pub const ERROR_DS_ALIAS_DEREF_PROBLEM: DWORD = 8244;
pub const ERROR_DS_UNWILLING_TO_PERFORM: DWORD = 8245;
pub const ERROR_DS_LOOP_DETECT: DWORD = 8246;
pub const ERROR_DS_NAMING_VIOLATION: DWORD = 8247;
pub const ERROR_DS_OBJECT_RESULTS_TOO_LARGE: DWORD = 8248;
pub const ERROR_DS_AFFECTS_MULTIPLE_DSAS: DWORD = 8249;
pub const ERROR_DS_SERVER_DOWN: DWORD = 8250;
pub const ERROR_DS_LOCAL_ERROR: DWORD = 8251;
pub const ERROR_DS_ENCODING_ERROR: DWORD = 8252;
pub const ERROR_DS_DECODING_ERROR: DWORD = 8253;
pub const ERROR_DS_FILTER_UNKNOWN: DWORD = 8254;
pub const ERROR_DS_PARAM_ERROR: DWORD = 8255;
pub const ERROR_DS_NOT_SUPPORTED: DWORD = 8256;
pub const ERROR_DS_NO_RESULTS_RETURNED: DWORD = 8257;
pub const ERROR_DS_CONTROL_NOT_FOUND: DWORD = 8258;
pub const ERROR_DS_CLIENT_LOOP: DWORD = 8259;
pub const ERROR_DS_REFERRAL_LIMIT_EXCEEDED: DWORD = 8260;
pub const ERROR_DS_SORT_CONTROL_MISSING: DWORD = 8261;
pub const ERROR_DS_OFFSET_RANGE_ERROR: DWORD = 8262;
pub const ERROR_DS_ROOT_MUST_BE_NC: DWORD = 8301;
pub const ERROR_DS_ADD_REPLICA_INHIBITED: DWORD = 8302;
pub const ERROR_DS_ATT_NOT_DEF_IN_SCHEMA: DWORD = 8303;
pub const ERROR_DS_MAX_OBJ_SIZE_EXCEEDED: DWORD = 8304;
pub const ERROR_DS_OBJ_STRING_NAME_EXISTS: DWORD = 8305;
pub const ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA: DWORD = 8306;
pub const ERROR_DS_RDN_DOESNT_MATCH_SCHEMA: DWORD = 8307;
pub const ERROR_DS_NO_REQUESTED_ATTS_FOUND: DWORD = 8308;
pub const ERROR_DS_USER_BUFFER_TO_SMALL: DWORD = 8309;
pub const ERROR_DS_ATT_IS_NOT_ON_OBJ: DWORD = 8310;
pub const ERROR_DS_ILLEGAL_MOD_OPERATION: DWORD = 8311;
pub const ERROR_DS_OBJ_TOO_LARGE: DWORD = 8312;
pub const ERROR_DS_BAD_INSTANCE_TYPE: DWORD = 8313;
pub const ERROR_DS_MASTERDSA_REQUIRED: DWORD = 8314;
pub const ERROR_DS_OBJECT_CLASS_REQUIRED: DWORD = 8315;
pub const ERROR_DS_MISSING_REQUIRED_ATT: DWORD = 8316;
pub const ERROR_DS_ATT_NOT_DEF_FOR_CLASS: DWORD = 8317;
pub const ERROR_DS_ATT_ALREADY_EXISTS: DWORD = 8318;
pub const ERROR_DS_CANT_ADD_ATT_VALUES: DWORD = 8320;
pub const ERROR_DS_SINGLE_VALUE_CONSTRAINT: DWORD = 8321;
pub const ERROR_DS_RANGE_CONSTRAINT: DWORD = 8322;
pub const ERROR_DS_ATT_VAL_ALREADY_EXISTS: DWORD = 8323;
pub const ERROR_DS_CANT_REM_MISSING_ATT: DWORD = 8324;
pub const ERROR_DS_CANT_REM_MISSING_ATT_VAL: DWORD = 8325;
pub const ERROR_DS_ROOT_CANT_BE_SUBREF: DWORD = 8326;
pub const ERROR_DS_NO_CHAINING: DWORD = 8327;
pub const ERROR_DS_NO_CHAINED_EVAL: DWORD = 8328;
pub const ERROR_DS_NO_PARENT_OBJECT: DWORD = 8329;
pub const ERROR_DS_PARENT_IS_AN_ALIAS: DWORD = 8330;
pub const ERROR_DS_CANT_MIX_MASTER_AND_REPS: DWORD = 8331;
pub const ERROR_DS_CHILDREN_EXIST: DWORD = 8332;
pub const ERROR_DS_OBJ_NOT_FOUND: DWORD = 8333;
pub const ERROR_DS_ALIASED_OBJ_MISSING: DWORD = 8334;
pub const ERROR_DS_BAD_NAME_SYNTAX: DWORD = 8335;
pub const ERROR_DS_ALIAS_POINTS_TO_ALIAS: DWORD = 8336;
pub const ERROR_DS_CANT_DEREF_ALIAS: DWORD = 8337;
pub const ERROR_DS_OUT_OF_SCOPE: DWORD = 8338;
pub const ERROR_DS_OBJECT_BEING_REMOVED: DWORD = 8339;
pub const ERROR_DS_CANT_DELETE_DSA_OBJ: DWORD = 8340;
pub const ERROR_DS_GENERIC_ERROR: DWORD = 8341;
pub const ERROR_DS_DSA_MUST_BE_INT_MASTER: DWORD = 8342;
pub const ERROR_DS_CLASS_NOT_DSA: DWORD = 8343;
pub const ERROR_DS_INSUFF_ACCESS_RIGHTS: DWORD = 8344;
pub const ERROR_DS_ILLEGAL_SUPERIOR: DWORD = 8345;
pub const ERROR_DS_ATTRIBUTE_OWNED_BY_SAM: DWORD = 8346;
pub const ERROR_DS_NAME_TOO_MANY_PARTS: DWORD = 8347;
pub const ERROR_DS_NAME_TOO_LONG: DWORD = 8348;
pub const ERROR_DS_NAME_VALUE_TOO_LONG: DWORD = 8349;
pub const ERROR_DS_NAME_UNPARSEABLE: DWORD = 8350;
pub const ERROR_DS_NAME_TYPE_UNKNOWN: DWORD = 8351;
pub const ERROR_DS_NOT_AN_OBJECT: DWORD = 8352;
pub const ERROR_DS_SEC_DESC_TOO_SHORT: DWORD = 8353;
pub const ERROR_DS_SEC_DESC_INVALID: DWORD = 8354;
pub const ERROR_DS_NO_DELETED_NAME: DWORD = 8355;
pub const ERROR_DS_SUBREF_MUST_HAVE_PARENT: DWORD = 8356;
pub const ERROR_DS_NCNAME_MUST_BE_NC: DWORD = 8357;
pub const ERROR_DS_CANT_ADD_SYSTEM_ONLY: DWORD = 8358;
pub const ERROR_DS_CLASS_MUST_BE_CONCRETE: DWORD = 8359;
pub const ERROR_DS_INVALID_DMD: DWORD = 8360;
pub const ERROR_DS_OBJ_GUID_EXISTS: DWORD = 8361;
pub const ERROR_DS_NOT_ON_BACKLINK: DWORD = 8362;
pub const ERROR_DS_NO_CROSSREF_FOR_NC: DWORD = 8363;
pub const ERROR_DS_SHUTTING_DOWN: DWORD = 8364;
pub const ERROR_DS_UNKNOWN_OPERATION: DWORD = 8365;
pub const ERROR_DS_INVALID_ROLE_OWNER: DWORD = 8366;
pub const ERROR_DS_COULDNT_CONTACT_FSMO: DWORD = 8367;
pub const ERROR_DS_CROSS_NC_DN_RENAME: DWORD = 8368;
pub const ERROR_DS_CANT_MOD_SYSTEM_ONLY: DWORD = 8369;
pub const ERROR_DS_REPLICATOR_ONLY: DWORD = 8370;
pub const ERROR_DS_OBJ_CLASS_NOT_DEFINED: DWORD = 8371;
pub const ERROR_DS_OBJ_CLASS_NOT_SUBCLASS: DWORD = 8372;
pub const ERROR_DS_NAME_REFERENCE_INVALID: DWORD = 8373;
pub const ERROR_DS_CROSS_REF_EXISTS: DWORD = 8374;
pub const ERROR_DS_CANT_DEL_MASTER_CROSSREF: DWORD = 8375;
pub const ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD: DWORD = 8376;
pub const ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX: DWORD = 8377;
pub const ERROR_DS_DUP_RDN: DWORD = 8378;
pub const ERROR_DS_DUP_OID: DWORD = 8379;
pub const ERROR_DS_DUP_MAPI_ID: DWORD = 8380;
pub const ERROR_DS_DUP_SCHEMA_ID_GUID: DWORD = 8381;
pub const ERROR_DS_DUP_LDAP_DISPLAY_NAME: DWORD = 8382;
pub const ERROR_DS_SEMANTIC_ATT_TEST: DWORD = 8383;
pub const ERROR_DS_SYNTAX_MISMATCH: DWORD = 8384;
pub const ERROR_DS_EXISTS_IN_MUST_HAVE: DWORD = 8385;
pub const ERROR_DS_EXISTS_IN_MAY_HAVE: DWORD = 8386;
pub const ERROR_DS_NONEXISTENT_MAY_HAVE: DWORD = 8387;
pub const ERROR_DS_NONEXISTENT_MUST_HAVE: DWORD = 8388;
pub const ERROR_DS_AUX_CLS_TEST_FAIL: DWORD = 8389;
pub const ERROR_DS_NONEXISTENT_POSS_SUP: DWORD = 8390;
pub const ERROR_DS_SUB_CLS_TEST_FAIL: DWORD = 8391;
pub const ERROR_DS_BAD_RDN_ATT_ID_SYNTAX: DWORD = 8392;
pub const ERROR_DS_EXISTS_IN_AUX_CLS: DWORD = 8393;
pub const ERROR_DS_EXISTS_IN_SUB_CLS: DWORD = 8394;
pub const ERROR_DS_EXISTS_IN_POSS_SUP: DWORD = 8395;
pub const ERROR_DS_RECALCSCHEMA_FAILED: DWORD = 8396;
pub const ERROR_DS_TREE_DELETE_NOT_FINISHED: DWORD = 8397;
pub const ERROR_DS_CANT_DELETE: DWORD = 8398;
pub const ERROR_DS_ATT_SCHEMA_REQ_ID: DWORD = 8399;
pub const ERROR_DS_BAD_ATT_SCHEMA_SYNTAX: DWORD = 8400;
pub const ERROR_DS_CANT_CACHE_ATT: DWORD = 8401;
pub const ERROR_DS_CANT_CACHE_CLASS: DWORD = 8402;
pub const ERROR_DS_CANT_REMOVE_ATT_CACHE: DWORD = 8403;
pub const ERROR_DS_CANT_REMOVE_CLASS_CACHE: DWORD = 8404;
pub const ERROR_DS_CANT_RETRIEVE_DN: DWORD = 8405;
pub const ERROR_DS_MISSING_SUPREF: DWORD = 8406;
pub const ERROR_DS_CANT_RETRIEVE_INSTANCE: DWORD = 8407;
pub const ERROR_DS_CODE_INCONSISTENCY: DWORD = 8408;
pub const ERROR_DS_DATABASE_ERROR: DWORD = 8409;
pub const ERROR_DS_GOVERNSID_MISSING: DWORD = 8410;
pub const ERROR_DS_MISSING_EXPECTED_ATT: DWORD = 8411;
pub const ERROR_DS_NCNAME_MISSING_CR_REF: DWORD = 8412;
pub const ERROR_DS_SECURITY_CHECKING_ERROR: DWORD = 8413;
pub const ERROR_DS_SCHEMA_NOT_LOADED: DWORD = 8414;
pub const ERROR_DS_SCHEMA_ALLOC_FAILED: DWORD = 8415;
pub const ERROR_DS_ATT_SCHEMA_REQ_SYNTAX: DWORD = 8416;
pub const ERROR_DS_GCVERIFY_ERROR: DWORD = 8417;
pub const ERROR_DS_DRA_SCHEMA_MISMATCH: DWORD = 8418;
pub const ERROR_DS_CANT_FIND_DSA_OBJ: DWORD = 8419;
pub const ERROR_DS_CANT_FIND_EXPECTED_NC: DWORD = 8420;
pub const ERROR_DS_CANT_FIND_NC_IN_CACHE: DWORD = 8421;
pub const ERROR_DS_CANT_RETRIEVE_CHILD: DWORD = 8422;
pub const ERROR_DS_SECURITY_ILLEGAL_MODIFY: DWORD = 8423;
pub const ERROR_DS_CANT_REPLACE_HIDDEN_REC: DWORD = 8424;
pub const ERROR_DS_BAD_HIERARCHY_FILE: DWORD = 8425;
pub const ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED: DWORD = 8426;
pub const ERROR_DS_CONFIG_PARAM_MISSING: DWORD = 8427;
pub const ERROR_DS_COUNTING_AB_INDICES_FAILED: DWORD = 8428;
pub const ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED: DWORD = 8429;
pub const ERROR_DS_INTERNAL_FAILURE: DWORD = 8430;
pub const ERROR_DS_UNKNOWN_ERROR: DWORD = 8431;
pub const ERROR_DS_ROOT_REQUIRES_CLASS_TOP: DWORD = 8432;
pub const ERROR_DS_REFUSING_FSMO_ROLES: DWORD = 8433;
pub const ERROR_DS_MISSING_FSMO_SETTINGS: DWORD = 8434;
pub const ERROR_DS_UNABLE_TO_SURRENDER_ROLES: DWORD = 8435;
pub const ERROR_DS_DRA_GENERIC: DWORD = 8436;
pub const ERROR_DS_DRA_INVALID_PARAMETER: DWORD = 8437;
pub const ERROR_DS_DRA_BUSY: DWORD = 8438;
pub const ERROR_DS_DRA_BAD_DN: DWORD = 8439;
pub const ERROR_DS_DRA_BAD_NC: DWORD = 8440;
pub const ERROR_DS_DRA_DN_EXISTS: DWORD = 8441;
pub const ERROR_DS_DRA_INTERNAL_ERROR: DWORD = 8442;
pub const ERROR_DS_DRA_INCONSISTENT_DIT: DWORD = 8443;
pub const ERROR_DS_DRA_CONNECTION_FAILED: DWORD = 8444;
pub const ERROR_DS_DRA_BAD_INSTANCE_TYPE: DWORD = 8445;
pub const ERROR_DS_DRA_OUT_OF_MEM: DWORD = 8446;
pub const ERROR_DS_DRA_MAIL_PROBLEM: DWORD = 8447;
pub const ERROR_DS_DRA_REF_ALREADY_EXISTS: DWORD = 8448;
pub const ERROR_DS_DRA_REF_NOT_FOUND: DWORD = 8449;
pub const ERROR_DS_DRA_OBJ_IS_REP_SOURCE: DWORD = 8450;
pub const ERROR_DS_DRA_DB_ERROR: DWORD = 8451;
pub const ERROR_DS_DRA_NO_REPLICA: DWORD = 8452;
pub const ERROR_DS_DRA_ACCESS_DENIED: DWORD = 8453;
pub const ERROR_DS_DRA_NOT_SUPPORTED: DWORD = 8454;
pub const ERROR_DS_DRA_RPC_CANCELLED: DWORD = 8455;
pub const ERROR_DS_DRA_SOURCE_DISABLED: DWORD = 8456;
pub const ERROR_DS_DRA_SINK_DISABLED: DWORD = 8457;
pub const ERROR_DS_DRA_NAME_COLLISION: DWORD = 8458;
pub const ERROR_DS_DRA_SOURCE_REINSTALLED: DWORD = 8459;
pub const ERROR_DS_DRA_MISSING_PARENT: DWORD = 8460;
pub const ERROR_DS_DRA_PREEMPTED: DWORD = 8461;
pub const ERROR_DS_DRA_ABANDON_SYNC: DWORD = 8462;
pub const ERROR_DS_DRA_SHUTDOWN: DWORD = 8463;
pub const ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET: DWORD = 8464;
pub const ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA: DWORD = 8465;
pub const ERROR_DS_DRA_EXTN_CONNECTION_FAILED: DWORD = 8466;
pub const ERROR_DS_INSTALL_SCHEMA_MISMATCH: DWORD = 8467;
pub const ERROR_DS_DUP_LINK_ID: DWORD = 8468;
pub const ERROR_DS_NAME_ERROR_RESOLVING: DWORD = 8469;
pub const ERROR_DS_NAME_ERROR_NOT_FOUND: DWORD = 8470;
pub const ERROR_DS_NAME_ERROR_NOT_UNIQUE: DWORD = 8471;
pub const ERROR_DS_NAME_ERROR_NO_MAPPING: DWORD = 8472;
pub const ERROR_DS_NAME_ERROR_DOMAIN_ONLY: DWORD = 8473;
pub const ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING: DWORD = 8474;
pub const ERROR_DS_CONSTRUCTED_ATT_MOD: DWORD = 8475;
pub const ERROR_DS_WRONG_OM_OBJ_CLASS: DWORD = 8476;
pub const ERROR_DS_DRA_REPL_PENDING: DWORD = 8477;
pub const ERROR_DS_DS_REQUIRED: DWORD = 8478;
pub const ERROR_DS_INVALID_LDAP_DISPLAY_NAME: DWORD = 8479;
pub const ERROR_DS_NON_BASE_SEARCH: DWORD = 8480;
pub const ERROR_DS_CANT_RETRIEVE_ATTS: DWORD = 8481;
pub const ERROR_DS_BACKLINK_WITHOUT_LINK: DWORD = 8482;
pub const ERROR_DS_EPOCH_MISMATCH: DWORD = 8483;
pub const ERROR_DS_SRC_NAME_MISMATCH: DWORD = 8484;
pub const ERROR_DS_SRC_AND_DST_NC_IDENTICAL: DWORD = 8485;
pub const ERROR_DS_DST_NC_MISMATCH: DWORD = 8486;
pub const ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC: DWORD = 8487;
pub const ERROR_DS_SRC_GUID_MISMATCH: DWORD = 8488;
pub const ERROR_DS_CANT_MOVE_DELETED_OBJECT: DWORD = 8489;
pub const ERROR_DS_PDC_OPERATION_IN_PROGRESS: DWORD = 8490;
pub const ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD: DWORD = 8491;
pub const ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION: DWORD = 8492;
pub const ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS: DWORD = 8493;
pub const ERROR_DS_NC_MUST_HAVE_NC_PARENT: DWORD = 8494;
pub const ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE: DWORD = 8495;
pub const ERROR_DS_DST_DOMAIN_NOT_NATIVE: DWORD = 8496;
pub const ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER: DWORD = 8497;
pub const ERROR_DS_CANT_MOVE_ACCOUNT_GROUP: DWORD = 8498;
pub const ERROR_DS_CANT_MOVE_RESOURCE_GROUP: DWORD = 8499;
pub const ERROR_DS_INVALID_SEARCH_FLAG: DWORD = 8500;
pub const ERROR_DS_NO_TREE_DELETE_ABOVE_NC: DWORD = 8501;
pub const ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE: DWORD = 8502;
pub const ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE: DWORD = 8503;
pub const ERROR_DS_SAM_INIT_FAILURE: DWORD = 8504;
pub const ERROR_DS_SENSITIVE_GROUP_VIOLATION: DWORD = 8505;
pub const ERROR_DS_CANT_MOD_PRIMARYGROUPID: DWORD = 8506;
pub const ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD: DWORD = 8507;
pub const ERROR_DS_NONSAFE_SCHEMA_CHANGE: DWORD = 8508;
pub const ERROR_DS_SCHEMA_UPDATE_DISALLOWED: DWORD = 8509;
pub const ERROR_DS_CANT_CREATE_UNDER_SCHEMA: DWORD = 8510;
pub const ERROR_DS_INSTALL_NO_SRC_SCH_VERSION: DWORD = 8511;
pub const ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE: DWORD = 8512;
pub const ERROR_DS_INVALID_GROUP_TYPE: DWORD = 8513;
pub const ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN: DWORD = 8514;
pub const ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN: DWORD = 8515;
pub const ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER: DWORD = 8516;
pub const ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER: DWORD = 8517;
pub const ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER: DWORD = 8518;
pub const ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER: DWORD = 8519;
pub const ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER: DWORD = 8520;
pub const ERROR_DS_HAVE_PRIMARY_MEMBERS: DWORD = 8521;
pub const ERROR_DS_STRING_SD_CONVERSION_FAILED: DWORD = 8522;
pub const ERROR_DS_NAMING_MASTER_GC: DWORD = 8523;
pub const ERROR_DS_DNS_LOOKUP_FAILURE: DWORD = 8524;
pub const ERROR_DS_COULDNT_UPDATE_SPNS: DWORD = 8525;
pub const ERROR_DS_CANT_RETRIEVE_SD: DWORD = 8526;
pub const ERROR_DS_KEY_NOT_UNIQUE: DWORD = 8527;
pub const ERROR_DS_WRONG_LINKED_ATT_SYNTAX: DWORD = 8528;
pub const ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD: DWORD = 8529;
pub const ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY: DWORD = 8530;
pub const ERROR_DS_CANT_START: DWORD = 8531;
pub const ERROR_DS_INIT_FAILURE: DWORD = 8532;
pub const ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION: DWORD = 8533;
pub const ERROR_DS_SOURCE_DOMAIN_IN_FOREST: DWORD = 8534;
pub const ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST: DWORD = 8535;
pub const ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED: DWORD = 8536;
pub const ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN: DWORD = 8537;
pub const ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER: DWORD = 8538;
pub const ERROR_DS_SRC_SID_EXISTS_IN_FOREST: DWORD = 8539;
pub const ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH: DWORD = 8540;
pub const ERROR_SAM_INIT_FAILURE: DWORD = 8541;
pub const ERROR_DS_DRA_SCHEMA_INFO_SHIP: DWORD = 8542;
pub const ERROR_DS_DRA_SCHEMA_CONFLICT: DWORD = 8543;
pub const ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT: DWORD = 8544;
pub const ERROR_DS_DRA_OBJ_NC_MISMATCH: DWORD = 8545;
pub const ERROR_DS_NC_STILL_HAS_DSAS: DWORD = 8546;
pub const ERROR_DS_GC_REQUIRED: DWORD = 8547;
pub const ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY: DWORD = 8548;
pub const ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS: DWORD = 8549;
pub const ERROR_DS_CANT_ADD_TO_GC: DWORD = 8550;
pub const ERROR_DS_NO_CHECKPOINT_WITH_PDC: DWORD = 8551;
pub const ERROR_DS_SOURCE_AUDITING_NOT_ENABLED: DWORD = 8552;
pub const ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC: DWORD = 8553;
pub const ERROR_DS_INVALID_NAME_FOR_SPN: DWORD = 8554;
pub const ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS: DWORD = 8555;
pub const ERROR_DS_UNICODEPWD_NOT_IN_QUOTES: DWORD = 8556;
pub const ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED: DWORD = 8557;
pub const ERROR_DS_MUST_BE_RUN_ON_DST_DC: DWORD = 8558;
pub const ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER: DWORD = 8559;
pub const ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ: DWORD = 8560;
pub const ERROR_DS_INIT_FAILURE_CONSOLE: DWORD = 8561;
pub const ERROR_DS_SAM_INIT_FAILURE_CONSOLE: DWORD = 8562;
pub const ERROR_DS_FOREST_VERSION_TOO_HIGH: DWORD = 8563;
pub const ERROR_DS_DOMAIN_VERSION_TOO_HIGH: DWORD = 8564;
pub const ERROR_DS_FOREST_VERSION_TOO_LOW: DWORD = 8565;
pub const ERROR_DS_DOMAIN_VERSION_TOO_LOW: DWORD = 8566;
pub const ERROR_DS_INCOMPATIBLE_VERSION: DWORD = 8567;
pub const ERROR_DS_LOW_DSA_VERSION: DWORD = 8568;
pub const ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN: DWORD = 8569;
pub const ERROR_DS_NOT_SUPPORTED_SORT_ORDER: DWORD = 8570;
pub const ERROR_DS_NAME_NOT_UNIQUE: DWORD = 8571;
pub const ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4: DWORD = 8572;
pub const ERROR_DS_OUT_OF_VERSION_STORE: DWORD = 8573;
pub const ERROR_DS_INCOMPATIBLE_CONTROLS_USED: DWORD = 8574;
pub const ERROR_DS_NO_REF_DOMAIN: DWORD = 8575;
pub const ERROR_DS_RESERVED_LINK_ID: DWORD = 8576;
pub const ERROR_DS_LINK_ID_NOT_AVAILABLE: DWORD = 8577;
pub const ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER: DWORD = 8578;
pub const ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE: DWORD = 8579;
pub const ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC: DWORD = 8580;
pub const ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG: DWORD = 8581;
pub const ERROR_DS_MODIFYDN_WRONG_GRANDPARENT: DWORD = 8582;
pub const ERROR_DS_NAME_ERROR_TRUST_REFERRAL: DWORD = 8583;
pub const ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER: DWORD = 8584;
pub const ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD: DWORD = 8585;
pub const ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2: DWORD = 8586;
pub const ERROR_DS_THREAD_LIMIT_EXCEEDED: DWORD = 8587;
pub const ERROR_DS_NOT_CLOSEST: DWORD = 8588;
pub const ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF: DWORD = 8589;
pub const ERROR_DS_SINGLE_USER_MODE_FAILED: DWORD = 8590;
pub const ERROR_DS_NTDSCRIPT_SYNTAX_ERROR: DWORD = 8591;
pub const ERROR_DS_NTDSCRIPT_PROCESS_ERROR: DWORD = 8592;
pub const ERROR_DS_DIFFERENT_REPL_EPOCHS: DWORD = 8593;
pub const ERROR_DS_DRS_EXTENSIONS_CHANGED: DWORD = 8594;
pub const ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR: DWORD = 8595;
pub const ERROR_DS_NO_MSDS_INTID: DWORD = 8596;
pub const ERROR_DS_DUP_MSDS_INTID: DWORD = 8597;
pub const ERROR_DS_EXISTS_IN_RDNATTID: DWORD = 8598;
pub const ERROR_DS_AUTHORIZATION_FAILED: DWORD = 8599;
pub const ERROR_DS_INVALID_SCRIPT: DWORD = 8600;
pub const ERROR_DS_REMOTE_CROSSREF_OP_FAILED: DWORD = 8601;
pub const ERROR_DS_CROSS_REF_BUSY: DWORD = 8602;
pub const ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN: DWORD = 8603;
pub const ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC: DWORD = 8604;
pub const ERROR_DS_DUPLICATE_ID_FOUND: DWORD = 8605;
pub const ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT: DWORD = 8606;
pub const ERROR_DS_GROUP_CONVERSION_ERROR: DWORD = 8607;
pub const ERROR_DS_CANT_MOVE_APP_BASIC_GROUP: DWORD = 8608;
pub const ERROR_DS_CANT_MOVE_APP_QUERY_GROUP: DWORD = 8609;
pub const ERROR_DS_ROLE_NOT_VERIFIED: DWORD = 8610;
pub const ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL: DWORD = 8611;
pub const ERROR_DS_DOMAIN_RENAME_IN_PROGRESS: DWORD = 8612;
pub const ERROR_DS_EXISTING_AD_CHILD_NC: DWORD = 8613;
pub const ERROR_DS_REPL_LIFETIME_EXCEEDED: DWORD = 8614;
pub const ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER: DWORD = 8615;
pub const ERROR_DS_LDAP_SEND_QUEUE_FULL: DWORD = 8616;
pub const ERROR_DS_DRA_OUT_SCHEDULE_WINDOW: DWORD = 8617;
pub const ERROR_SXS_SECTION_NOT_FOUND: DWORD = 14000;
pub const ERROR_SXS_CANT_GEN_ACTCTX: DWORD = 14001;
pub const ERROR_SXS_INVALID_ACTCTXDATA_FORMAT: DWORD = 14002;
pub const ERROR_SXS_ASSEMBLY_NOT_FOUND: DWORD = 14003;
pub const ERROR_SXS_MANIFEST_FORMAT_ERROR: DWORD = 14004;
pub const ERROR_SXS_MANIFEST_PARSE_ERROR: DWORD = 14005;
pub const ERROR_SXS_ACTIVATION_CONTEXT_DISABLED: DWORD = 14006;
pub const ERROR_SXS_KEY_NOT_FOUND: DWORD = 14007;
pub const ERROR_SXS_VERSION_CONFLICT: DWORD = 14008;
pub const ERROR_SXS_WRONG_SECTION_TYPE: DWORD = 14009;
pub const ERROR_SXS_THREAD_QUERIES_DISABLED: DWORD = 14010;
pub const ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET: DWORD = 14011;
pub const ERROR_SXS_UNKNOWN_ENCODING_GROUP: DWORD = 14012;
pub const ERROR_SXS_UNKNOWN_ENCODING: DWORD = 14013;
pub const ERROR_SXS_INVALID_XML_NAMESPACE_URI: DWORD = 14014;
pub const ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED: DWORD = 14015;
pub const ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED: DWORD = 14016;
pub const ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE: DWORD = 14017;
pub const ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE: DWORD = 14018;
pub const ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE: DWORD = 14019;
pub const ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT: DWORD = 14020;
pub const ERROR_SXS_DUPLICATE_DLL_NAME: DWORD = 14021;
pub const ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME: DWORD = 14022;
pub const ERROR_SXS_DUPLICATE_CLSID: DWORD = 14023;
pub const ERROR_SXS_DUPLICATE_IID: DWORD = 14024;
pub const ERROR_SXS_DUPLICATE_TLBID: DWORD = 14025;
pub const ERROR_SXS_DUPLICATE_PROGID: DWORD = 14026;
pub const ERROR_SXS_DUPLICATE_ASSEMBLY_NAME: DWORD = 14027;
pub const ERROR_SXS_FILE_HASH_MISMATCH: DWORD = 14028;
pub const ERROR_SXS_POLICY_PARSE_ERROR: DWORD = 14029;
pub const ERROR_SXS_XML_E_MISSINGQUOTE: DWORD = 14030;
pub const ERROR_SXS_XML_E_COMMENTSYNTAX: DWORD = 14031;
pub const ERROR_SXS_XML_E_BADSTARTNAMECHAR: DWORD = 14032;
pub const ERROR_SXS_XML_E_BADNAMECHAR: DWORD = 14033;
pub const ERROR_SXS_XML_E_BADCHARINSTRING: DWORD = 14034;
pub const ERROR_SXS_XML_E_XMLDECLSYNTAX: DWORD = 14035;
pub const ERROR_SXS_XML_E_BADCHARDATA: DWORD = 14036;
pub const ERROR_SXS_XML_E_MISSINGWHITESPACE: DWORD = 14037;
pub const ERROR_SXS_XML_E_EXPECTINGTAGEND: DWORD = 14038;
pub const ERROR_SXS_XML_E_MISSINGSEMICOLON: DWORD = 14039;
pub const ERROR_SXS_XML_E_UNBALANCEDPAREN: DWORD = 14040;
pub const ERROR_SXS_XML_E_INTERNALERROR: DWORD = 14041;
pub const ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE: DWORD = 14042;
pub const ERROR_SXS_XML_E_INCOMPLETE_ENCODING: DWORD = 14043;
pub const ERROR_SXS_XML_E_MISSING_PAREN: DWORD = 14044;
pub const ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE: DWORD = 14045;
pub const ERROR_SXS_XML_E_MULTIPLE_COLONS: DWORD = 14046;
pub const ERROR_SXS_XML_E_INVALID_DECIMAL: DWORD = 14047;
pub const ERROR_SXS_XML_E_INVALID_HEXIDECIMAL: DWORD = 14048;
pub const ERROR_SXS_XML_E_INVALID_UNICODE: DWORD = 14049;
pub const ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK: DWORD = 14050;
pub const ERROR_SXS_XML_E_UNEXPECTEDENDTAG: DWORD = 14051;
pub const ERROR_SXS_XML_E_UNCLOSEDTAG: DWORD = 14052;
pub const ERROR_SXS_XML_E_DUPLICATEATTRIBUTE: DWORD = 14053;
pub const ERROR_SXS_XML_E_MULTIPLEROOTS: DWORD = 14054;
pub const ERROR_SXS_XML_E_INVALIDATROOTLEVEL: DWORD = 14055;
pub const ERROR_SXS_XML_E_BADXMLDECL: DWORD = 14056;
pub const ERROR_SXS_XML_E_MISSINGROOT: DWORD = 14057;
pub const ERROR_SXS_XML_E_UNEXPECTEDEOF: DWORD = 14058;
pub const ERROR_SXS_XML_E_BADPEREFINSUBSET: DWORD = 14059;
pub const ERROR_SXS_XML_E_UNCLOSEDSTARTTAG: DWORD = 14060;
pub const ERROR_SXS_XML_E_UNCLOSEDENDTAG: DWORD = 14061;
pub const ERROR_SXS_XML_E_UNCLOSEDSTRING: DWORD = 14062;
pub const ERROR_SXS_XML_E_UNCLOSEDCOMMENT: DWORD = 14063;
pub const ERROR_SXS_XML_E_UNCLOSEDDECL: DWORD = 14064;
pub const ERROR_SXS_XML_E_UNCLOSEDCDATA: DWORD = 14065;
pub const ERROR_SXS_XML_E_RESERVEDNAMESPACE: DWORD = 14066;
pub const ERROR_SXS_XML_E_INVALIDENCODING: DWORD = 14067;
pub const ERROR_SXS_XML_E_INVALIDSWITCH: DWORD = 14068;
pub const ERROR_SXS_XML_E_BADXMLCASE: DWORD = 14069;
pub const ERROR_SXS_XML_E_INVALID_STANDALONE: DWORD = 14070;
pub const ERROR_SXS_XML_E_UNEXPECTED_STANDALONE: DWORD = 14071;
pub const ERROR_SXS_XML_E_INVALID_VERSION: DWORD = 14072;
pub const ERROR_SXS_XML_E_MISSINGEQUALS: DWORD = 14073;
pub const ERROR_SXS_PROTECTION_RECOVERY_FAILED: DWORD = 14074;
pub const ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT: DWORD = 14075;
pub const ERROR_SXS_PROTECTION_CATALOG_NOT_VALID: DWORD = 14076;
pub const ERROR_SXS_UNTRANSLATABLE_HRESULT: DWORD = 14077;
pub const ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING: DWORD = 14078;
pub const ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE: DWORD = 14079;
pub const ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME: DWORD = 14080;
pub const ERROR_SXS_ASSEMBLY_MISSING: DWORD = 14081;
pub const ERROR_SXS_CORRUPT_ACTIVATION_STACK: DWORD = 14082;
pub const ERROR_SXS_CORRUPTION: DWORD = 14083;
pub const ERROR_SXS_EARLY_DEACTIVATION: DWORD = 14084;
pub const ERROR_SXS_INVALID_DEACTIVATION: DWORD = 14085;
pub const ERROR_SXS_MULTIPLE_DEACTIVATION: DWORD = 14086;
pub const ERROR_SXS_PROCESS_TERMINATION_REQUESTED: DWORD = 14087;
pub const ERROR_SXS_RELEASE_ACTIVATION_CONTEXT: DWORD = 14088;
pub const ERROR_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY: DWORD = 14089;
pub const ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE: DWORD = 14090;
pub const ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME: DWORD = 14091;
pub const ERROR_SXS_IDENTITY_DUPLICATE_ATTRIBUTE: DWORD = 14092;
pub const ERROR_SXS_IDENTITY_PARSE_ERROR: DWORD = 14093;
pub const ERROR_MALFORMED_SUBSTITUTION_STRING: DWORD = 14094;
pub const ERROR_SXS_INCORRECT_PUBLIC_KEY_TOKEN: DWORD = 14095;
pub const ERROR_UNMAPPED_SUBSTITUTION_STRING: DWORD = 14096;
pub const ERROR_SXS_ASSEMBLY_NOT_LOCKED: DWORD = 14097;
pub const ERROR_SXS_COMPONENT_STORE_CORRUPT: DWORD = 14098;
pub const ERROR_ADVANCED_INSTALLER_FAILED: DWORD = 14099;
pub const ERROR_XML_ENCODING_MISMATCH: DWORD = 14100;
pub const ERROR_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT: DWORD = 14101;
pub const ERROR_SXS_IDENTITIES_DIFFERENT: DWORD = 14102;
pub const ERROR_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT: DWORD = 14103;
pub const ERROR_SXS_FILE_NOT_PART_OF_ASSEMBLY: DWORD = 14104;
pub const ERROR_SXS_MANIFEST_TOO_BIG: DWORD = 14105;
pub const ERROR_SXS_SETTING_NOT_REGISTERED: DWORD = 14106;
pub const ERROR_SXS_TRANSACTION_CLOSURE_INCOMPLETE: DWORD = 14107;
pub const ERROR_SMI_PRIMITIVE_INSTALLER_FAILED: DWORD = 14108;
pub const ERROR_GENERIC_COMMAND_FAILED: DWORD = 14109;
pub const ERROR_SXS_FILE_HASH_MISSING: DWORD = 14110;
pub const ERROR_IPSEC_QM_POLICY_EXISTS: DWORD = 13000;
pub const ERROR_IPSEC_QM_POLICY_NOT_FOUND: DWORD = 13001;
pub const ERROR_IPSEC_QM_POLICY_IN_USE: DWORD = 13002;
pub const ERROR_IPSEC_MM_POLICY_EXISTS: DWORD = 13003;
pub const ERROR_IPSEC_MM_POLICY_NOT_FOUND: DWORD = 13004;
pub const ERROR_IPSEC_MM_POLICY_IN_USE: DWORD = 13005;
pub const ERROR_IPSEC_MM_FILTER_EXISTS: DWORD = 13006;
pub const ERROR_IPSEC_MM_FILTER_NOT_FOUND: DWORD = 13007;
pub const ERROR_IPSEC_TRANSPORT_FILTER_EXISTS: DWORD = 13008;
pub const ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND: DWORD = 13009;
pub const ERROR_IPSEC_MM_AUTH_EXISTS: DWORD = 13010;
pub const ERROR_IPSEC_MM_AUTH_NOT_FOUND: DWORD = 13011;
pub const ERROR_IPSEC_MM_AUTH_IN_USE: DWORD = 13012;
pub const ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND: DWORD = 13013;
pub const ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND: DWORD = 13014;
pub const ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND: DWORD = 13015;
pub const ERROR_IPSEC_TUNNEL_FILTER_EXISTS: DWORD = 13016;
pub const ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND: DWORD = 13017;
pub const ERROR_IPSEC_MM_FILTER_PENDING_DELETION: DWORD = 13018;
pub const ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION: DWORD = 13019;
pub const ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION: DWORD = 13020;
pub const ERROR_IPSEC_MM_POLICY_PENDING_DELETION: DWORD = 13021;
pub const ERROR_IPSEC_MM_AUTH_PENDING_DELETION: DWORD = 13022;
pub const ERROR_IPSEC_QM_POLICY_PENDING_DELETION: DWORD = 13023;
pub const ERROR_IPSEC_IKE_NEG_STATUS_BEGIN: DWORD = 13800;
pub const ERROR_IPSEC_IKE_AUTH_FAIL: DWORD = 13801;
pub const ERROR_IPSEC_IKE_ATTRIB_FAIL: DWORD = 13802;
pub const ERROR_IPSEC_IKE_NEGOTIATION_PENDING: DWORD = 13803;
pub const ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR: DWORD = 13804;
pub const ERROR_IPSEC_IKE_TIMED_OUT: DWORD = 13805;
pub const ERROR_IPSEC_IKE_NO_CERT: DWORD = 13806;
pub const ERROR_IPSEC_IKE_SA_DELETED: DWORD = 13807;
pub const ERROR_IPSEC_IKE_SA_REAPED: DWORD = 13808;
pub const ERROR_IPSEC_IKE_MM_ACQUIRE_DROP: DWORD = 13809;
pub const ERROR_IPSEC_IKE_QM_ACQUIRE_DROP: DWORD = 13810;
pub const ERROR_IPSEC_IKE_QUEUE_DROP_MM: DWORD = 13811;
pub const ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM: DWORD = 13812;
pub const ERROR_IPSEC_IKE_DROP_NO_RESPONSE: DWORD = 13813;
pub const ERROR_IPSEC_IKE_MM_DELAY_DROP: DWORD = 13814;
pub const ERROR_IPSEC_IKE_QM_DELAY_DROP: DWORD = 13815;
pub const ERROR_IPSEC_IKE_ERROR: DWORD = 13816;
pub const ERROR_IPSEC_IKE_CRL_FAILED: DWORD = 13817;
pub const ERROR_IPSEC_IKE_INVALID_KEY_USAGE: DWORD = 13818;
pub const ERROR_IPSEC_IKE_INVALID_CERT_TYPE: DWORD = 13819;
pub const ERROR_IPSEC_IKE_NO_PRIVATE_KEY: DWORD = 13820;
pub const ERROR_IPSEC_IKE_DH_FAIL: DWORD = 13822;
pub const ERROR_IPSEC_IKE_INVALID_HEADER: DWORD = 13824;
pub const ERROR_IPSEC_IKE_NO_POLICY: DWORD = 13825;
pub const ERROR_IPSEC_IKE_INVALID_SIGNATURE: DWORD = 13826;
pub const ERROR_IPSEC_IKE_KERBEROS_ERROR: DWORD = 13827;
pub const ERROR_IPSEC_IKE_NO_PUBLIC_KEY: DWORD = 13828;
pub const ERROR_IPSEC_IKE_PROCESS_ERR: DWORD = 13829;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_SA: DWORD = 13830;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_PROP: DWORD = 13831;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_TRANS: DWORD = 13832;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_KE: DWORD = 13833;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_ID: DWORD = 13834;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_CERT: DWORD = 13835;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ: DWORD = 13836;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_HASH: DWORD = 13837;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_SIG: DWORD = 13838;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_NONCE: DWORD = 13839;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY: DWORD = 13840;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_DELETE: DWORD = 13841;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR: DWORD = 13842;
pub const ERROR_IPSEC_IKE_INVALID_PAYLOAD: DWORD = 13843;
pub const ERROR_IPSEC_IKE_LOAD_SOFT_SA: DWORD = 13844;
pub const ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN: DWORD = 13845;
pub const ERROR_IPSEC_IKE_INVALID_COOKIE: DWORD = 13846;
pub const ERROR_IPSEC_IKE_NO_PEER_CERT: DWORD = 13847;
pub const ERROR_IPSEC_IKE_PEER_CRL_FAILED: DWORD = 13848;
pub const ERROR_IPSEC_IKE_POLICY_CHANGE: DWORD = 13849;
pub const ERROR_IPSEC_IKE_NO_MM_POLICY: DWORD = 13850;
pub const ERROR_IPSEC_IKE_NOTCBPRIV: DWORD = 13851;
pub const ERROR_IPSEC_IKE_SECLOADFAIL: DWORD = 13852;
pub const ERROR_IPSEC_IKE_FAILSSPINIT: DWORD = 13853;
pub const ERROR_IPSEC_IKE_FAILQUERYSSP: DWORD = 13854;
pub const ERROR_IPSEC_IKE_SRVACQFAIL: DWORD = 13855;
pub const ERROR_IPSEC_IKE_SRVQUERYCRED: DWORD = 13856;
pub const ERROR_IPSEC_IKE_GETSPIFAIL: DWORD = 13857;
pub const ERROR_IPSEC_IKE_INVALID_FILTER: DWORD = 13858;
pub const ERROR_IPSEC_IKE_OUT_OF_MEMORY: DWORD = 13859;
pub const ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED: DWORD = 13860;
pub const ERROR_IPSEC_IKE_INVALID_POLICY: DWORD = 13861;
pub const ERROR_IPSEC_IKE_UNKNOWN_DOI: DWORD = 13862;
pub const ERROR_IPSEC_IKE_INVALID_SITUATION: DWORD = 13863;
pub const ERROR_IPSEC_IKE_DH_FAILURE: DWORD = 13864;
pub const ERROR_IPSEC_IKE_INVALID_GROUP: DWORD = 13865;
pub const ERROR_IPSEC_IKE_ENCRYPT: DWORD = 13866;
pub const ERROR_IPSEC_IKE_DECRYPT: DWORD = 13867;
pub const ERROR_IPSEC_IKE_POLICY_MATCH: DWORD = 13868;
pub const ERROR_IPSEC_IKE_UNSUPPORTED_ID: DWORD = 13869;
pub const ERROR_IPSEC_IKE_INVALID_HASH: DWORD = 13870;
pub const ERROR_IPSEC_IKE_INVALID_HASH_ALG: DWORD = 13871;
pub const ERROR_IPSEC_IKE_INVALID_HASH_SIZE: DWORD = 13872;
pub const ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG: DWORD = 13873;
pub const ERROR_IPSEC_IKE_INVALID_AUTH_ALG: DWORD = 13874;
pub const ERROR_IPSEC_IKE_INVALID_SIG: DWORD = 13875;
pub const ERROR_IPSEC_IKE_LOAD_FAILED: DWORD = 13876;
pub const ERROR_IPSEC_IKE_RPC_DELETE: DWORD = 13877;
pub const ERROR_IPSEC_IKE_BENIGN_REINIT: DWORD = 13878;
pub const ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY: DWORD = 13879;
pub const ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN: DWORD = 13881;
pub const ERROR_IPSEC_IKE_MM_LIMIT: DWORD = 13882;
pub const ERROR_IPSEC_IKE_NEGOTIATION_DISABLED: DWORD = 13883;
/*pub const ERROR_IPSEC_IKE_NEG_STATUS_END: DWORD = 13884)*/
pub const ERROR_IPSEC_IKE_QM_LIMIT: DWORD = 13884;
pub const ERROR_IPSEC_IKE_MM_EXPIRED: DWORD = 13885;
pub const ERROR_IPSEC_IKE_PEER_MM_ASSUMED_INVALID: DWORD = 13886;
pub const ERROR_IPSEC_IKE_CERT_CHAIN_POLICY_MISMATCH: DWORD = 13887;
pub const ERROR_IPSEC_IKE_UNEXPECTED_MESSAGE_ID: DWORD = 13888;
pub const ERROR_IPSEC_IKE_INVALID_AUTH_PAYLOAD: DWORD = 13889;
pub const ERROR_IPSEC_IKE_DOS_COOKIE_SENT: DWORD = 13890;
pub const ERROR_IPSEC_IKE_SHUTTING_DOWN: DWORD = 13891;
pub const ERROR_IPSEC_IKE_CGA_AUTH_FAILED: DWORD = 13892;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_NATOA: DWORD = 13893;
pub const ERROR_IPSEC_IKE_INVALID_MM_FOR_QM: DWORD = 13894;
pub const ERROR_IPSEC_IKE_QM_EXPIRED: DWORD = 13895;
pub const ERROR_IPSEC_IKE_TOO_MANY_FILTERS: DWORD = 13896;
pub const ERROR_IPSEC_IKE_NEG_STATUS_END: DWORD = 13897;
pub const ERROR_IPSEC_IKE_KILL_DUMMY_NAP_TUNNEL: DWORD = 13898;
pub const ERROR_IPSEC_IKE_INNER_IP_ASSIGNMENT_FAILURE: DWORD = 13899;
pub const ERROR_IPSEC_IKE_REQUIRE_CP_PAYLOAD_MISSING: DWORD = 13900;
pub const ERROR_IPSEC_KEY_MODULE_IMPERSONATION_NEGOTIATION_PENDING: DWORD = 13901;
pub const ERROR_IPSEC_IKE_COEXISTENCE_SUPPRESS: DWORD = 13902;
pub const ERROR_IPSEC_IKE_RATELIMIT_DROP: DWORD = 13903;
pub const ERROR_IPSEC_IKE_PEER_DOESNT_SUPPORT_MOBIKE: DWORD = 13904;
pub const ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE: DWORD = 13905;
pub const ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_FAILURE: DWORD = 13906;
pub const ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE_WITH_OPTIONAL_RETRY: DWORD = 13907;
pub const ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_AND_CERTMAP_FAILURE: DWORD = 13908;
pub const ERROR_IPSEC_IKE_NEG_STATUS_EXTENDED_END: DWORD = 13909;
pub const ERROR_IPSEC_BAD_SPI: DWORD = 13910;
pub const ERROR_IPSEC_SA_LIFETIME_EXPIRED: DWORD = 13911;
pub const ERROR_IPSEC_WRONG_SA: DWORD = 13912;
pub const ERROR_IPSEC_REPLAY_CHECK_FAILED: DWORD = 13913;
pub const ERROR_IPSEC_INVALID_PACKET: DWORD = 13914;
pub const ERROR_IPSEC_INTEGRITY_CHECK_FAILED: DWORD = 13915;
pub const ERROR_IPSEC_CLEAR_TEXT_DROP: DWORD = 13916;
pub const ERROR_IPSEC_AUTH_FIREWALL_DROP: DWORD = 13917;
pub const ERROR_IPSEC_THROTTLE_DROP: DWORD = 13918;
pub const ERROR_IPSEC_DOSP_BLOCK: DWORD = 13925;
pub const ERROR_IPSEC_DOSP_RECEIVED_MULTICAST: DWORD = 13926;
pub const ERROR_IPSEC_DOSP_INVALID_PACKET: DWORD = 13927;
pub const ERROR_IPSEC_DOSP_STATE_LOOKUP_FAILED: DWORD = 13928;
pub const ERROR_IPSEC_DOSP_MAX_ENTRIES: DWORD = 13929;
pub const ERROR_IPSEC_DOSP_KEYMOD_NOT_ALLOWED: DWORD = 13930;
pub const ERROR_IPSEC_DOSP_NOT_INSTALLED: DWORD = 13931;
pub const ERROR_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES: DWORD = 13932;
pub const ERROR_EVT_INVALID_CHANNEL_PATH: DWORD = 15000;
pub const ERROR_EVT_INVALID_QUERY: DWORD = 15001;
pub const ERROR_EVT_PUBLISHER_METADATA_NOT_FOUND: DWORD = 15002;
pub const ERROR_EVT_EVENT_TEMPLATE_NOT_FOUND: DWORD = 15003;
pub const ERROR_EVT_INVALID_PUBLISHER_NAME: DWORD = 15004;
pub const ERROR_EVT_INVALID_EVENT_DATA: DWORD = 15005;
pub const ERROR_EVT_CHANNEL_NOT_FOUND: DWORD = 15007;
pub const ERROR_EVT_MALFORMED_XML_TEXT: DWORD = 15008;
pub const ERROR_EVT_SUBSCRIPTION_TO_DIRECT_CHANNEL: DWORD = 15009;
pub const ERROR_EVT_CONFIGURATION_ERROR: DWORD = 15010;
pub const ERROR_EVT_QUERY_RESULT_STALE: DWORD = 15011;
pub const ERROR_EVT_QUERY_RESULT_INVALID_POSITION: DWORD = 15012;
pub const ERROR_EVT_NON_VALIDATING_MSXML: DWORD = 15013;
pub const ERROR_EVT_FILTER_ALREADYSCOPED: DWORD = 15014;
pub const ERROR_EVT_FILTER_NOTELTSET: DWORD = 15015;
pub const ERROR_EVT_FILTER_INVARG: DWORD = 15016;
pub const ERROR_EVT_FILTER_INVTEST: DWORD = 15017;
pub const ERROR_EVT_FILTER_INVTYPE: DWORD = 15018;
pub const ERROR_EVT_FILTER_PARSEERR: DWORD = 15019;
pub const ERROR_EVT_FILTER_UNSUPPORTEDOP: DWORD = 15020;
pub const ERROR_EVT_FILTER_UNEXPECTEDTOKEN: DWORD = 15021;
pub const ERROR_EVT_INVALID_OPERATION_OVER_ENABLED_DIRECT_CHANNEL: DWORD = 15022;
pub const ERROR_EVT_INVALID_CHANNEL_PROPERTY_VALUE: DWORD = 15023;
pub const ERROR_EVT_INVALID_PUBLISHER_PROPERTY_VALUE: DWORD = 15024;
pub const ERROR_EVT_CHANNEL_CANNOT_ACTIVATE: DWORD = 15025;
pub const ERROR_EVT_FILTER_TOO_COMPLEX: DWORD = 15026;
pub const ERROR_EVT_MESSAGE_NOT_FOUND: DWORD = 15027;
pub const ERROR_EVT_MESSAGE_ID_NOT_FOUND: DWORD = 15028;
pub const ERROR_EVT_UNRESOLVED_VALUE_INSERT: DWORD = 15029;
pub const ERROR_EVT_UNRESOLVED_PARAMETER_INSERT: DWORD = 15030;
pub const ERROR_EVT_MAX_INSERTS_REACHED: DWORD = 15031;
pub const ERROR_EVT_EVENT_DEFINITION_NOT_FOUND: DWORD = 15032;
pub const ERROR_EVT_MESSAGE_LOCALE_NOT_FOUND: DWORD = 15033;
pub const ERROR_EVT_VERSION_TOO_OLD: DWORD = 15034;
pub const ERROR_EVT_VERSION_TOO_NEW: DWORD = 15035;
pub const ERROR_EVT_CANNOT_OPEN_CHANNEL_OF_QUERY: DWORD = 15036;
pub const ERROR_EVT_PUBLISHER_DISABLED: DWORD = 15037;
pub const ERROR_EVT_FILTER_OUT_OF_RANGE: DWORD = 15038;
pub const ERROR_EC_SUBSCRIPTION_CANNOT_ACTIVATE: DWORD = 15080;
pub const ERROR_EC_LOG_DISABLED: DWORD = 15081;
pub const ERROR_EC_CIRCULAR_FORWARDING: DWORD = 15082;
pub const ERROR_EC_CREDSTORE_FULL: DWORD = 15083;
pub const ERROR_EC_CRED_NOT_FOUND: DWORD = 15084;
pub const ERROR_EC_NO_ACTIVE_CHANNEL: DWORD = 15085;
pub const ERROR_MUI_FILE_NOT_FOUND: DWORD = 15100;
pub const ERROR_MUI_INVALID_FILE: DWORD = 15101;
pub const ERROR_MUI_INVALID_RC_CONFIG: DWORD = 15102;
pub const ERROR_MUI_INVALID_LOCALE_NAME: DWORD = 15103;
pub const ERROR_MUI_INVALID_ULTIMATEFALLBACK_NAME: DWORD = 15104;
pub const ERROR_MUI_FILE_NOT_LOADED: DWORD = 15105;
pub const ERROR_RESOURCE_ENUM_USER_STOP: DWORD = 15106;
pub const ERROR_MUI_INTLSETTINGS_UILANG_NOT_INSTALLED: DWORD = 15107;
pub const ERROR_MUI_INTLSETTINGS_INVALID_LOCALE_NAME: DWORD = 15108;
pub const ERROR_MRM_RUNTIME_NO_DEFAULT_OR_NEUTRAL_RESOURCE: DWORD = 15110;
pub const ERROR_MRM_INVALID_PRICONFIG: DWORD = 15111;
pub const ERROR_MRM_INVALID_FILE_TYPE: DWORD = 15112;
pub const ERROR_MRM_UNKNOWN_QUALIFIER: DWORD = 15113;
pub const ERROR_MRM_INVALID_QUALIFIER_VALUE: DWORD = 15114;
pub const ERROR_MRM_NO_CANDIDATE: DWORD = 15115;
pub const ERROR_MRM_NO_MATCH_OR_DEFAULT_CANDIDATE: DWORD = 15116;
pub const ERROR_MRM_RESOURCE_TYPE_MISMATCH: DWORD = 15117;
pub const ERROR_MRM_DUPLICATE_MAP_NAME: DWORD = 15118;
pub const ERROR_MRM_DUPLICATE_ENTRY: DWORD = 15119;
pub const ERROR_MRM_INVALID_RESOURCE_IDENTIFIER: DWORD = 15120;
pub const ERROR_MRM_FILEPATH_TOO_LONG: DWORD = 15121;
pub const ERROR_MRM_UNSUPPORTED_DIRECTORY_TYPE: DWORD = 15122;
pub const ERROR_MRM_INVALID_PRI_FILE: DWORD = 15126;
pub const ERROR_MRM_NAMED_RESOURCE_NOT_FOUND: DWORD = 15127;
pub const ERROR_MRM_MAP_NOT_FOUND: DWORD = 15135;
pub const ERROR_MRM_UNSUPPORTED_PROFILE_TYPE: DWORD = 15136;
pub const ERROR_MRM_INVALID_QUALIFIER_OPERATOR: DWORD = 15137;
pub const ERROR_MRM_INDETERMINATE_QUALIFIER_VALUE: DWORD = 15138;
pub const ERROR_MRM_AUTOMERGE_ENABLED: DWORD = 15139;
pub const ERROR_MRM_TOO_MANY_RESOURCES: DWORD = 15140;
pub const ERROR_MCA_INVALID_CAPABILITIES_STRING: DWORD = 15200;
pub const ERROR_MCA_INVALID_VCP_VERSION: DWORD = 15201;
pub const ERROR_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION: DWORD = 15202;
pub const ERROR_MCA_MCCS_VERSION_MISMATCH: DWORD = 15203;
pub const ERROR_MCA_UNSUPPORTED_MCCS_VERSION: DWORD = 15204;
pub const ERROR_MCA_INTERNAL_ERROR: DWORD = 15205;
pub const ERROR_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED: DWORD = 15206;
pub const ERROR_MCA_UNSUPPORTED_COLOR_TEMPERATURE: DWORD = 15207;
pub const ERROR_AMBIGUOUS_SYSTEM_DEVICE: DWORD = 15250;
pub const ERROR_SYSTEM_DEVICE_NOT_FOUND: DWORD = 15299;
pub const ERROR_HASH_NOT_SUPPORTED: DWORD = 15300;
pub const ERROR_HASH_NOT_PRESENT: DWORD = 15301;
pub const ERROR_SECONDARY_IC_PROVIDER_NOT_REGISTERED: DWORD = 15321;
pub const ERROR_GPIO_CLIENT_INFORMATION_INVALID: DWORD = 15322;
pub const ERROR_GPIO_VERSION_NOT_SUPPORTED: DWORD = 15323;
pub const ERROR_GPIO_INVALID_REGISTRATION_PACKET: DWORD = 15324;
pub const ERROR_GPIO_OPERATION_DENIED: DWORD = 15325;
pub const ERROR_GPIO_INCOMPATIBLE_CONNECT_MODE: DWORD = 15326;
pub const ERROR_GPIO_INTERRUPT_ALREADY_UNMASKED: DWORD = 15327;
pub const ERROR_CANNOT_SWITCH_RUNLEVEL: DWORD = 15400;
pub const ERROR_INVALID_RUNLEVEL_SETTING: DWORD = 15401;
pub const ERROR_RUNLEVEL_SWITCH_TIMEOUT: DWORD = 15402;
pub const ERROR_RUNLEVEL_SWITCH_AGENT_TIMEOUT: DWORD = 15403;
pub const ERROR_RUNLEVEL_SWITCH_IN_PROGRESS: DWORD = 15404;
pub const ERROR_SERVICES_FAILED_AUTOSTART: DWORD = 15405;
pub const ERROR_COM_TASK_STOP_PENDING: DWORD = 15501;
pub const ERROR_INSTALL_OPEN_PACKAGE_FAILED: DWORD = 15600;
pub const ERROR_INSTALL_PACKAGE_NOT_FOUND: DWORD = 15601;
pub const ERROR_INSTALL_INVALID_PACKAGE: DWORD = 15602;
pub const ERROR_INSTALL_RESOLVE_DEPENDENCY_FAILED: DWORD = 15603;
pub const ERROR_INSTALL_OUT_OF_DISK_SPACE: DWORD = 15604;
pub const ERROR_INSTALL_NETWORK_FAILURE: DWORD = 15605;
pub const ERROR_INSTALL_REGISTRATION_FAILURE: DWORD = 15606;
pub const ERROR_INSTALL_DEREGISTRATION_FAILURE: DWORD = 15607;
pub const ERROR_INSTALL_CANCEL: DWORD = 15608;
pub const ERROR_INSTALL_FAILED: DWORD = 15609;
pub const ERROR_REMOVE_FAILED: DWORD = 15610;
pub const ERROR_PACKAGE_ALREADY_EXISTS: DWORD = 15611;
pub const ERROR_NEEDS_REMEDIATION: DWORD = 15612;
pub const ERROR_INSTALL_PREREQUISITE_FAILED: DWORD = 15613;
pub const ERROR_PACKAGE_REPOSITORY_CORRUPTED: DWORD = 15614;
pub const ERROR_INSTALL_POLICY_FAILURE: DWORD = 15615;
pub const ERROR_PACKAGE_UPDATING: DWORD = 15616;
pub const ERROR_DEPLOYMENT_BLOCKED_BY_POLICY: DWORD = 15617;
pub const ERROR_PACKAGES_IN_USE: DWORD = 15618;
pub const ERROR_RECOVERY_FILE_CORRUPT: DWORD = 15619;
pub const ERROR_INVALID_STAGED_SIGNATURE: DWORD = 15620;
pub const ERROR_DELETING_EXISTING_APPLICATIONDATA_STORE_FAILED: DWORD = 15621;
pub const ERROR_INSTALL_PACKAGE_DOWNGRADE: DWORD = 15622;
pub const ERROR_SYSTEM_NEEDS_REMEDIATION: DWORD = 15623;
pub const ERROR_APPX_INTEGRITY_FAILURE_CLR_NGEN: DWORD = 15624;
pub const ERROR_RESILIENCY_FILE_CORRUPT: DWORD = 15625;
pub const ERROR_INSTALL_FIREWALL_SERVICE_NOT_RUNNING: DWORD = 15626;
pub const ERROR_STATE_LOAD_STORE_FAILED: DWORD = 15800;
pub const ERROR_STATE_GET_VERSION_FAILED: DWORD = 15801;
pub const ERROR_STATE_SET_VERSION_FAILED: DWORD = 15802;
pub const ERROR_STATE_STRUCTURED_RESET_FAILED: DWORD = 15803;
pub const ERROR_STATE_OPEN_CONTAINER_FAILED: DWORD = 15804;
pub const ERROR_STATE_CREATE_CONTAINER_FAILED: DWORD = 15805;
pub const ERROR_STATE_DELETE_CONTAINER_FAILED: DWORD = 15806;
pub const ERROR_STATE_READ_SETTING_FAILED: DWORD = 15807;
pub const ERROR_STATE_WRITE_SETTING_FAILED: DWORD = 15808;
pub const ERROR_STATE_DELETE_SETTING_FAILED: DWORD = 15809;
pub const ERROR_STATE_QUERY_SETTING_FAILED: DWORD = 15810;
pub const ERROR_STATE_READ_COMPOSITE_SETTING_FAILED: DWORD = 15811;
pub const ERROR_STATE_WRITE_COMPOSITE_SETTING_FAILED: DWORD = 15812;
pub const ERROR_STATE_ENUMERATE_CONTAINER_FAILED: DWORD = 15813;
pub const ERROR_STATE_ENUMERATE_SETTINGS_FAILED: DWORD = 15814;
pub const ERROR_STATE_COMPOSITE_SETTING_VALUE_SIZE_LIMIT_EXCEEDED: DWORD = 15815;
pub const ERROR_STATE_SETTING_VALUE_SIZE_LIMIT_EXCEEDED: DWORD = 15816;
pub const ERROR_STATE_SETTING_NAME_SIZE_LIMIT_EXCEEDED: DWORD = 15817;
pub const ERROR_STATE_CONTAINER_NAME_SIZE_LIMIT_EXCEEDED: DWORD = 15818;
pub const ERROR_API_UNAVAILABLE: DWORD = 15841;
pub const ERROR_AUDITING_DISABLED: DWORD = 0xC0090001;
pub const ERROR_ALL_SIDS_FILTERED: DWORD = 0xC0090002;

pub const WSABASEERR: c_int = 10000;
pub const WSAEINTR: c_int = WSABASEERR + 4;
pub const WSAEBADF: c_int = WSABASEERR + 9;
pub const WSAEACCES: c_int = WSABASEERR + 13;
pub const WSAEFAULT: c_int = WSABASEERR + 14;
pub const WSAEINVAL: c_int = WSABASEERR + 22;
pub const WSAEMFILE: c_int = WSABASEERR + 24;
pub const WSAEWOULDBLOCK: c_int = WSABASEERR + 35;
pub const WSAEINPROGRESS: c_int = WSABASEERR + 36;
pub const WSAEALREADY: c_int = WSABASEERR + 37;
pub const WSAENOTSOCK: c_int = WSABASEERR + 38;
pub const WSAEDESTADDRREQ: c_int = WSABASEERR + 39;
pub const WSAEMSGSIZE: c_int = WSABASEERR + 40;
pub const WSAEPROTOTYPE: c_int = WSABASEERR + 41;
pub const WSAENOPROTOOPT: c_int = WSABASEERR + 42;
pub const WSAEPROTONOSUPPORT: c_int = WSABASEERR + 43;
pub const WSAESOCKTNOSUPPORT: c_int = WSABASEERR + 44;
pub const WSAEOPNOTSUPP: c_int = WSABASEERR + 45;
pub const WSAEPFNOSUPPORT: c_int = WSABASEERR + 46;
pub const WSAEAFNOSUPPORT: c_int = WSABASEERR + 47;
pub const WSAEADDRINUSE: c_int = WSABASEERR + 48;
pub const WSAEADDRNOTAVAIL: c_int = WSABASEERR + 49;
pub const WSAENETDOWN: c_int = WSABASEERR + 50;
pub const WSAENETUNREACH: c_int = WSABASEERR + 51;
pub const WSAENETRESET: c_int = WSABASEERR + 52;
pub const WSAECONNABORTED: c_int = WSABASEERR + 53;
pub const WSAECONNRESET: c_int = WSABASEERR + 54;
pub const WSAENOBUFS: c_int = WSABASEERR + 55;
pub const WSAEISCONN: c_int = WSABASEERR + 56;
pub const WSAENOTCONN: c_int = WSABASEERR + 57;
pub const WSAESHUTDOWN: c_int = WSABASEERR + 58;
pub const WSAETOOMANYREFS: c_int = WSABASEERR + 59;
pub const WSAETIMEDOUT: c_int = WSABASEERR + 60;
pub const WSAECONNREFUSED: c_int = WSABASEERR + 61;
pub const WSAELOOP: c_int = WSABASEERR + 62;
pub const WSAENAMETOOLONG: c_int = WSABASEERR + 63;
pub const WSAEHOSTDOWN: c_int = WSABASEERR + 64;
pub const WSAEHOSTUNREACH: c_int = WSABASEERR + 65;
pub const WSAENOTEMPTY: c_int = WSABASEERR + 66;
pub const WSAEPROCLIM: c_int = WSABASEERR + 67;
pub const WSAEUSERS: c_int = WSABASEERR + 68;
pub const WSAEDQUOT: c_int = WSABASEERR + 69;
pub const WSAESTALE: c_int = WSABASEERR + 70;
pub const WSAEREMOTE: c_int = WSABASEERR + 71;
pub const WSASYSNOTREADY: c_int = WSABASEERR + 91;
pub const WSAVERNOTSUPPORTED: c_int = WSABASEERR + 92;
pub const WSANOTINITIALISED: c_int = WSABASEERR + 93;
pub const WSAEDISCON: c_int = WSABASEERR + 101;
pub const WSAENOMORE: c_int = WSABASEERR + 102;
pub const WSAECANCELLED: c_int = WSABASEERR + 103;
pub const WSAEINVALIDPROCTABLE: c_int = WSABASEERR + 104;
pub const WSAEINVALIDPROVIDER: c_int = WSABASEERR + 105;
pub const WSAEPROVIDERFAILEDINIT: c_int = WSABASEERR + 106;
pub const WSASYSCALLFAILURE: c_int = WSABASEERR + 107;
pub const WSASERVICE_NOT_FOUND: c_int = WSABASEERR + 108;
pub const WSATYPE_NOT_FOUND: c_int = WSABASEERR + 109;
pub const WSA_E_NO_MORE: c_int = WSABASEERR + 110;
pub const WSA_E_CANCELLED: c_int = WSABASEERR + 111;
pub const WSAEREFUSED: c_int = WSABASEERR + 112;
pub const WSAHOST_NOT_FOUND: c_int = WSABASEERR + 1001;
pub const WSATRY_AGAIN: c_int = WSABASEERR + 1002;
pub const WSANO_RECOVERY: c_int = WSABASEERR + 1003;
pub const WSANO_DATA: c_int = WSABASEERR + 1004;
pub const WSA_QOS_RECEIVERS: c_int = WSABASEERR + 1005;
pub const WSA_QOS_SENDERS: c_int = WSABASEERR + 1006;
pub const WSA_QOS_NO_SENDERS: c_int = WSABASEERR + 1007;
pub const WSA_QOS_NO_RECEIVERS: c_int = WSABASEERR + 1008;
pub const WSA_QOS_REQUEST_CONFIRMED: c_int = WSABASEERR + 1009;
pub const WSA_QOS_ADMISSION_FAILURE: c_int = WSABASEERR + 1010;
pub const WSA_QOS_POLICY_FAILURE: c_int = WSABASEERR + 1011;
pub const WSA_QOS_BAD_STYLE: c_int = WSABASEERR + 1012;
pub const WSA_QOS_BAD_OBJECT: c_int = WSABASEERR + 1013;
pub const WSA_QOS_TRAFFIC_CTRL_ERROR: c_int = WSABASEERR + 1014;
pub const WSA_QOS_GENERIC_ERROR: c_int = WSABASEERR + 1015;
pub const WSA_QOS_ESERVICETYPE: c_int = WSABASEERR + 1016;
pub const WSA_QOS_EFLOWSPEC: c_int = WSABASEERR + 1017;
pub const WSA_QOS_EPROVSPECBUF: c_int = WSABASEERR + 1018;
pub const WSA_QOS_EFILTERSTYLE: c_int = WSABASEERR + 1019;
pub const WSA_QOS_EFILTERTYPE: c_int = WSABASEERR + 1020;
pub const WSA_QOS_EFILTERCOUNT: c_int = WSABASEERR + 1021;
pub const WSA_QOS_EOBJLENGTH: c_int = WSABASEERR + 1022;
pub const WSA_QOS_EFLOWCOUNT: c_int = WSABASEERR + 1023;
pub const WSA_QOS_EUNKNOWNPSOBJ: c_int = WSABASEERR + 1024;
pub const WSA_QOS_EUNKOWNPSOBJ: c_int = WSA_QOS_EUNKNOWNPSOBJ;
pub const WSA_QOS_EPOLICYOBJ: c_int = WSABASEERR + 1025;
pub const WSA_QOS_EFLOWDESC: c_int = WSABASEERR + 1026;
pub const WSA_QOS_EPSFLOWSPEC: c_int = WSABASEERR + 1027;
pub const WSA_QOS_EPSFILTERSPEC: c_int = WSABASEERR + 1028;
pub const WSA_QOS_ESDMODEOBJ: c_int = WSABASEERR + 1029;
pub const WSA_QOS_ESHAPERATEOBJ: c_int = WSABASEERR + 1030;
pub const WSA_QOS_RESERVED_PETYPE: c_int = WSABASEERR + 1031;
