#' @name Molecule
#' 
#' @title Operations on molecules
#' 
#' @description 
#' Various functions to perform operations on molecules.
#' 
#' \code{\link{get.exact.mass}} returns the exact mass of a molecule
#' \code{\link{get.natural.mass}} returns the natural exact mass of a molecule
#' \code{\link{convert.implicit.to.explicit}} converts implicit hydrogens to 
#'     explicit hydrogens. This function does not return any value but rather 
#'     modifies the molecule object passed to it 
#' \code{\link{is.neutral}} returns \code{TRUE} if all atoms in the molecule have
#'     a formal charge of \code{0}, otherwise \code{FALSE}
#' 
#' @section Usage:
#' get.exact.mass(mol)
#' get.natural.mass(mol)
#' convert.implicit.to.explicit(mol)
#' is.neutral(mol)
#' 
#' @section Arguments:
#'  mol  A jobjRef representing an IAtomContainer or IMolecule object
#' 
#' @details 
#' 
#' In some cases, a molecule may not have any hydrogens (such as when read in 
#' from an MDL MOLfile that did not have hydrogens). In such cases,
#' \code{\link{convert.implicit.to.explicit}} will add implicit hydrogens and 
#' then convert them to explicit ones.  In addition, for such cases, make sure 
#' that the molecule has been typed beforehand.
#' 
#' @section Value:
#'  \code{\link{get.exact.mass}} returns a numeric 
#'  \code{\link{get.natural.mass}} returns a numeric
#'  \code{\link{convert.implicit.to.explicit}} has no return value
#'  \code{\link{is.neutral}} returns a boolean.
#'  
#' @seealso 
#' \code{\link{get.atoms}}, \code{\link{set.atom.types}}
#' @aliases Molecule
#' @author Rajarshi Guha (\email{rajarshi.guha@@gmail.com})
NULL