% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getXrefList.R
\name{getXrefList}
\alias{getXrefList}
\title{Get Xref List}
\usage{
getXrefList(pathway, systemCode)
}
\arguments{
\item{pathway}{WikiPathways identifier (WPID) for the pathway to download, e.g. WP4}

\item{systemCode}{(\code{character}) The BridgeDb code associated with the data source or system, 
e.g., En (Ensembl), L (Entrez), Ch (HMDB), etc.
See column two of https://github.com/bridgedb/BridgeDb/blob/master/org.bridgedb.bio/resources/org/bridgedb/bio/datasources.txt.}
}
\value{
A \code{list} of Xrefs identifiers
}
\description{
Retrieve the Xref identifiers for a specific pathway in a particular system code
}
\examples{
{
xrefs = getXrefList("WP2338", "L")
}
}
