# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     generate_unicodedb.py --unidata_version=8.0.0 --output=unicodedb_8_0_0 --base=unicodedb_5_2_0

from rpython.rlib.rarithmetic import r_longlong


import unicodedb_5_2_0 as base_mod
version = '8.0.0'

#____________________________________________________________
# output from build_compression_tree

def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)

        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError(name)

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.append(substring)

        prevnode = charnode // 3
        charnode = parent

    res.reverse()
    return ''.join(res)


_stringtable = (
'\x01 '
'\x0c ALTERNATING'
'\x05 AND '
'\n AND ARROW'
'\x0f AND COLD SWEAT'
'\x1b AND LEFT SEMICIRCLE ARROWS'
'\x0c AND PICTURE'
'\x0b AND WRENCH'
'\r AND YEN SIGN'
'\x08 ANTENNA'
'\x07 ARROW '
') ARROW POINTING DOWNWARDS THEN NORTH EAST'
'\n ARROWHEAD'
'\x08 AT DUSK'
'\x08 AT LEFT'
'\x14 BEGIN LOGOGRAM MARK'
'\x06 BELOW'
'\x05 BENT'
'\x06 BLOCK'
'\x05 BOAT'
'\x12 BRIGHTNESS SYMBOL'
'\x07 BUBBLE'
'\x07 BUTTON'
'\x17 CAKE WITH SWIRL DESIGN'
'\x10 CAPPED MOUNTAIN'
'\x04 CAR'
'\x08 CENTRED'
'\n CHARACTER'
'\x06 CHART'
'\x05 CHWV'
'\x07 CIRCLE'
'\n CONJOINED'
'\x0b DECORATION'
'\x14 DIRECTIONAL ISOLATE'
'\t DIVIDERS'
'\x07 DOUBLE'
'\x1d DOWN INDEX THUMB HOOK MIDDLE'
'\x07 ENGINE'
'\x06 EPOCH'
'\x05 FACE'
'\x06 FACE '
'\x06 FINAL'
'\x12 FOR SIMALUNGUN SA'
'\x05 FUJI'
'\x05 GUNU'
'\t HITTING '
'\x05 HOOK'
'\x08 HUNDRED'
'\x05 ICON'
'\x10 IN BLACK SQUARE'
'\x0e IN SILHOUETTE'
'\x07 ISLAND'
'\x04 KEY'
'\x02 L'
'\x06 LARGE'
'\t LEERAEWA'
'\x07 LITTLE'
'\x0b LOCOMOTIVE'
'\x07 MAELEE'
'\x07 MAEMBA'
'\x08 MAKSURA'
'\x05 MARK'
'\x05 MFON'
'\t MILLIONS'
'\n MODIFIER-'
'\t MOVEMENT'
'\x07 MUOMAE'
'\x02 N'
'\x03 NJ'
'\x12 NOT LITTER SYMBOL'
'\x07 OCLOCK'
'\x04 OF '
'\x0c OF ANTIMONY'
'\x0b OF FLOWERS'
'\x08 OF FOOD'
'\x0b OF HYGIEIA'
'\r OF THE HORNS'
'\x05 OPEN'
'\x07 OPEN-O'
'\x04 ORE'
'\x04 OUT'
'\x0c OVER MIDDLE'
'\x0f OVER MOUNTAINS'
'\x11 OVER MUSH TIMES '
'\x16 OVER STAMPED ENVELOPE'
'\x11 OVER ZU PLUS SAR'
'\x02 P'
'\x03 PA'
'\x06 PLUS '
'\x0c PLUS KASKAL'
'\x12 PLUS PAP PLUS LU3'
'\x07 PLUS U'
'\x18 POINTING BACKHAND INDEX'
'\x04 POT'
'\x02 R'
'\x04 R S'
'\t RA OR RI'
'\x0f REVERSED-SCHWA'
'\x0c RING LITTLE'
'\x02 S'
'\x08 SATCHEL'
'\x07 SECANT'
'\x04 SET'
'\x06 SEVEN'
'\x05 SIDE'
'\x10 SMALL ROTATIONS'
'\t SPARKLER'
'\x06 SPLIT'
'\x12 SPREAD THUMB SIDE'
'\x05 STOP'
'\t STRAIGHT'
'\x07 SYMBOL'
'\x05 TABS'
'\x05 TENU'
'\t THOUSAND'
'\n THOUSANDS'
'\x06 THUMB'
'\x07 THUMB '
'\x0e THUMB FORWARD'
'\x12 THUMB INDEX THUMB'
'\x0b THUMB SIDE'
'\x0f THUMB STRAIGHT'
'\x08 TILTING'
'\x07 TIMES '
'\n TIMES KUR'
'\x0b TIMES TAK4'
'\x07 TO BAR'
'\x05 TONE'
'\x0f TOUCHING INDEX'
'\x05 TREE'
'\x02 U'
'\x04 U U'
'\x04 WEB'
'\x06 WITH '
'\t WITH BAR'
'\x11 WITH BULLET NOSE'
'\x10 WITH BUNNY EARS'
'\x19 WITH CANCELLATION STROKE'
'\x19 WITH CIRCLED ONE OVERLAY'
'\x12 WITH CROSSED-TAIL'
'\x16 WITH DECORATIVE COVER'
'\x0f WITH DIAERESIS'
'\t WITH DOT'
'2 WITH EXCLAMATION MARK WITH LEFT RIGHT ARROW ABOVE'
'\n WITH FACE'
'\x0b WITH FLASH'
'\x0e WITH FLOURISH'
'\x17 WITH HALF-CIRCLE BELOW'
'\r WITH INK PEN'
'\x0b WITH JACKS'
'\n WITH LOW '
'\x14 WITH OBLIQUE STROKE'
'\n WITH PAGE'
'\x12 WITH PALATAL HOOK'
'\x0b WITH PLATE'
'\n WITH RAIN'
'\n WITH RAYS'
'\n WITH RING'
'\x12 WITH SMILING EYES'
'\x11 WITH SOUND WAVES'
'\x0c WITH STROKE'
'\x12 WITH VERTICAL BAR'
'\x0b WITHIN DOT'
'\x0b WRIST FLEX'
'\x08 YUQ NAE'
'\x01-'
'\x02-2'
'\t-AMMONIAC'
'\x0b-COPPER ORE'
'\x08-EM DASH'
'\x08-HEADED '
'\t-LOW TONE'
'\x0c-MAIL SYMBOL'
'\t-MID TONE'
'\x0b-MOUTH FACE'
'\x0f-NO-EVIL MONKEY'
'\n-POINTING '
'\x0c-SHAPED SIGN'
'\x07-SHIFT-'
'\x06-SHIRT'
'\x07-THIRTY'
'\x010'
'\x050 BEE'
'\x040 BI'
'\x050 DOO'
'\x030 E'
'\x050 GBO'
'\x050 GEE'
'\x050 HAN'
'\x050 HEE'
'\x040 HO'
'\x050 JOO'
'\x040 JU'
'\t0 LONG LE'
'\x060 NGGI'
'\x060 NGGO'
'\x060 NYON'
'\x060 NYUN'
'\x040 PU'
'\x040 SA'
'\x030 W'
'\x040 YE'
'\x050-VAS'
'\x0600-102'
'\x04028B'
'\x0203'
'\x0208'
'\x011'
'\x031 A'
'\x041 BA'
'\x041 DO'
'\x051 FAN'
'\x041 GA'
'\x061 GBOO'
'\x041 HA'
'\x041 IN'
'\x041 KI'
'\n1 LONG MBE'
'\x061 NDEE'
'\x0e1 OVER LAK-081'
'\x041 PE'
'\x051 PEE'
'\x041 RA'
'\x041 SU'
'\x051 TEE'
'\x041 VU'
'\x051 WVI'
'\x031 X'
'\x041 YI'
'\x041 YO'
'\x051 YOO'
'\x031-2'
'\x051-VAS'
'\x0217'
'\x0218'
'\x012'
'\x022 '
'\x032 B'
'\x042 BU'
'\x052 HEN'
'\x052 HOO'
'\x042 KA'
'\x052 KPA'
'\x052 KPI'
'\x062 KPOO'
'\x042 L2'
'\n2 LONG MBO'
'\x052 MBA'
'\x052 MBE'
'\x062 MBOO'
'\x052 MBU'
'\x062 NGGU'
'\x052 NJA'
'\x052 NJU'
'\x052 POO'
'\x052 SEE'
'\x042 TI'
'\x082 TIMES '
'\t2 TIMES A'
'\x102 TIMES IGI GUNU'
'\n2 TIMES UD'
'\x042 VI'
'\x032 Y'
'\x042 YA'
'\x052-VAS'
'\x0320B'
'\x0222'
'\x0224'
'\x0726 EYYY'
'\x03272'
'\x013'
'\x053 BOO'
'\x033 D'
'\x043 EE'
'\x073 EIGHT'
'\x053 FOO'
'\x063 GBEE'
'\x063 HEEI'
'\x053 HIN'
'\x053 HON'
'\x033 I'
'\x043 JE'
'\x043 JO'
'\x043 KU'
'\x043 L3'
'\x043 LE'
'\x043 LO'
'\x0b3 LONG NGGO'
'\x053 NDI'
'\x063 NGGA'
'\x073 OMEGA'
'\x043 TA'
'\n3 TIMES ZA'
'\x053 VEE'
'\x053 WEI'
'\x043 YU'
'\x053-VAS'
'\x0230'
'\x0231'
'\x0331C'
'\x0532 JE'
'\x0236'
'\x0238'
'\x014'
'\x034 A'
'\x054 ABB'
'\x034 E'
'\x044 FI'
'\x054 GBI'
'\x064 KPEE'
'\x054 KPU'
'\x044 L4'
'\x054 LEE'
'\x054 LOO'
'\x054 MBO'
'\x054 MON'
'\x064 MUAN'
'\x054 NDO'
'\x064 NGEN'
'\x064 NJOO'
'\x064 NYIN'
'\x054 TOO'
'\x044 TU'
'\x054 VOO'
'\x044 WI'
'\x054 WOO'
'\x054 WUI'
'\x054-VAS'
'\x03408'
'\x0242'
'\x0248'
'\x0249'
'\x015'
'\x045 AN'
'\x045 BB'
'\x035 F'
'\x045 FA'
'\x045 FE'
'\x045 GI'
'\x045 IN'
'\x045 KE'
'\x055 KEE'
'\x045 LI'
'\t5 LONG JO'
'\x0b5 LONG MBOO'
'\x055 MBI'
'\x055 NDU'
'\x075 NGGEE'
'\x045 OO'
'\x045 TE'
'\x175 TIMES THREE DISH TENU'
'\x035 U'
'\x045 VA'
'\x045 VE'
'\x045 WA'
'\x045 WO'
'\x055-VAS'
'\x03533'
'\x03550'
'\x035B6'
'\x016'
'\x046 DI'
'\x046 FU'
'\x056 GBA'
'\x066 GUEI'
'\x036 H'
'\x046 HE'
'\x046 HI'
'\x046 HU'
'\x066 HUAN'
'\x056 KOO'
'\x046 L6'
'\x046 LA'
'\x0b6 LONG NGGE'
'\x0c6 LONG NGGOO'
'\x066 NGGE'
'\x076 NGGOO'
'\x046 PO'
'\x046 SE'
'\x056 SIA'
'\x056 SOO'
'\x056 WEE'
'\x046 WU'
'\x056-VAS'
'\x0262'
'\x0264'
'\x017'
'\x047 BE'
'\x047 DA'
'\x047 DD'
'\x047 EI'
'\x057 FUA'
'\x057 GBE'
'\x067 GUAN'
'\x057 HUN'
'\x037 J'
'\x057 JEE'
'\x047 LU'
'\x067 MBEE'
'\x067 MBUU'
'\x057 MIN'
'\x067 NDOO'
'\x057 NEN'
'\x077 NGGUA'
'\x067 NGON'
'\x077 NGUAN'
'\x057 NIN'
'\x037 O'
'\x047 VO'
'\x057-VAS'
'\x0270'
'\x0271'
'\x1479 OVER LAK-079 GUNU'
'\x018'
'\x048 BO'
'\x048 DU'
'\x048 EN'
'\x058 FEE'
'\x048 FO'
'\x058 GBU'
'\x048 GU'
'\x068 HOOU'
'\x048 JI'
'\x038 K'
'\x048 KO'
'\x058 KPE'
'\x058 KPO'
'\x058 MAN'
'\x068 MBEE'
'\x058 NAN'
'\x068 NYAN'
'\x068 NYEN'
'\x048 PI'
'\x048 WE'
'\x058-VAS'
'\x0280'
'\x0283'
'\x019'
'\x059 DEE'
'\x049 JA'
'\x059 KUA'
'\x059 MEN'
'\x069 MUEN'
'\x059 MUN'
'\x059 NDA'
'\x059 NDE'
'\x079 NGGAA'
'\x069 NJEE'
'\x059 NON'
'\x059 NUN'
'\x049 PA'
'\x049 SI'
'\x049 SO'
'\x049 TO'
'\x059 WVA'
'\x059 WVE'
'\x059 YEE'
'\x059-VAS'
'\x0290'
'\x0291'
'\x0292'
'\x03981'
'\x01A'
'\x02A '
'\x13A END LOGOGRAM MARK'
'\x06A MFON'
'\x0bA TENU GUNU'
'\x05A YUE'
'\x02A4'
'\x07A6 TENU'
'\x02A7'
'\x03A7A'
'\x02AA'
'\x03AAM'
'\x05AAMAE'
'\x05AARAE'
'\x06AASHAE'
'\x02AB'
'\x03AB2'
'\x03ABA'
'\nABATA TREE'
'\x12ABBREVIATION MARK '
'\x11ABBREVIATION SIGN'
'\x05ABIC '
'\x11ABLE WATER SYMBOL'
'\x05ABOVE'
'\x1eAC SUBLINEAR COLON SKEWED LEFT'
'\rACCOMMODATION'
'\x1cACE DIRECTION POSITION NOSE '
'\x07ACE OF '
'\x03ACK'
'\x04ACK '
'\x1fACK-TILTED SHADOWED WHITE ARROW'
'\x0bACKNOWLEDGE'
'\x16ACKSLANTED SOUTH ARROW'
'\x10ACTER TABULATION'
'\x05ACUTE'
'\x02AD'
'\x07AD NECK'
'\x18AD WITH THREE DOTS BELOW'
'\x02AE'
'\x03AEM'
'\x05AEMAE'
'\x05AEMLI'
'\x06AEMMAE'
'\x03AEN'
'\x08AEN NYAM'
'\x03AEP'
'\x05AEPEN'
'\x03AEQ'
'\x05AEREE'
'\x0bAESHAE NYAM'
'\x07AETMEUN'
'\x02AF'
'\x15AF FLUTTERING IN WIND'
'\x0eAFETY SCISSORS'
'\x06AFFIX '
'\x10AFFRICATION MARK'
'\x0cAFU LEERAEWA'
'\x03AG '
'\x05AGGER'
'\x06AGOGUE'
'\x04AGON'
'\x02AH'
'\x05AHMI '
'\x02AI'
'\x03AIN'
'\x04AIN '
'\x19AIN WITH THREE DOTS BELOW'
'\tAINTBRUSH'
'\x04AIR '
'\x08AIRPLANE'
'\rAISED KNUCKLE'
'\x0eAISED KNUCKLES'
'\x02AJ'
'\x02AK'
'\x03AK '
'\x06AK-668'
'\x0cAK4 PLUS SAG'
'\x0cAKAARAANSAYA'
'\x04AKER'
'\x06AKEUAE'
'\x08AKHA YAT'
'\x02AL'
'\x0bAL COMPUTER'
'\x07AL HORN'
'\x03ALE'
'\x05ALEPH'
'\x05ALETH'
'\x04ALF '
'\x0bALF-CIRCLE '
'\x05ALGAR'
'\x04ALL '
'\x05ALLOT'
'\x03ALO'
'\x05ALPHA'
'\x08ALTERNAT'
'\x0bALTERNATING'
'\x0cALTERNATING '
'\x06ALTIRE'
'\x02AM'
'\x12AM WITH DOUBLE BAR'
'\x04AMBA'
'\x07AME DIE'
'\tAME WITH '
'\x03AMI'
'\x04AMMA'
'\rAMMA WITH DOT'
'\x06AMOND '
'\x0bAMUSED FACE'
'\x02AN'
'\x03AN '
'\x04AN X'
'\x03ANA'
'\x04ANAE'
'\x08ANAGARI '
'\x03AND'
'\x12AND LOW RIGHT RING'
'\x17AND WOMAN HOLDING HANDS'
'\x04ANDA'
'\nANDHI MARK'
'\nANDRABINDU'
'\x03ANG'
'\tANGE BOOK'
'\x05ANGEL'
'\x0cANGER BUBBLE'
'\tANGGEUAET'
'\x07ANGKUOQ'
'\x05ANGLE'
'\x06ANGLED'
'\x07ANGLED '
'\x07ANGLONG'
'\x07ANGOLAT'
'\x04ANGU'
'\x04ANI '
'\x04ANJI'
'\x0fANS-SERIF ARROW'
'\x19ANTED NORTH ARROW WITH HO'
'\x0bANTIMONIATE'
'\x08ANTIMONY'
'\x08ANUSVARA'
'\x03AO '
'\x02AP'
'\x04APAQ'
'\x03APE'
'\x03APH'
'\x14APITAL H WITH STROKE'
'\rAPPED PRESENT'
'\x05APPLE'
'\x02AQ'
'\x02AR'
'\x0bAR A SIGN A'
'\x04ARAE'
'\x08ARCASITE'
'\x08ARCHAIC '
'\nARCHAIC II'
'\nARCHAIC YE'
'\x03ARD'
'\x15ARD SHELL FLOPPY DISK'
'\x07ARDSMAN'
'\nARFUL FACE'
'\x03ARK'
'\x03ARL'
'\x0bARM CIRCLE '
'\x18ARM CIRCLE HITTING WALL '
'\tARM CLOCK'
'\x0bARM SPIRAL '
'\rARRED TRIDENT'
'\x08ARRIVING'
'\x05ARROW'
'\x12ARROW SHAFT WIDTH '
'\x0bARROW WITH '
'\nARROWHEAD '
'\x1cARROWHEAD IN A RECTANGLE BOX'
'\x03ARS'
'\x05ARTAR'
'\x04ARUM'
'\x04ARY '
'\x02AS'
'\x05ASAL '
'\x17ASCENDING MUSICAL NOTES'
'\x03ASH'
'\x16ASH AMPERSAND ORNAMENT'
'\x05ASKAL'
'\nASPIRATION'
'\x12ASTED SWEET POTATO'
'\x02AT'
'\nAT ON BONE'
'\x07AT SIGN'
'\x03ATA'
'\x13ATED TELLER MACHINE'
'\x12ATERRESTRIAL ALIEN'
'\x07ATH OF '
'\x14ATIN CAPITAL LETTER '
'\nATIN CROSS'
'\x12ATIN SMALL LETTER '
'\x14ATOLIAN HIEROGLYPH A'
'\tATTACHED '
'\x06ATURE '
'\x16ATURE OPEN ET ORNAMENT'
'\x02AU'
'\x0eAU LENGTH MARK'
'\x07AU MARK'
'\x03AUJ'
'\x03AUM'
'\x03AUS'
'\nAUTOMOBILE'
'\x02AV'
'\x08AVAGRAHA'
'\x04AVE '
'\x17AVOURING DELICIOUS FOOD'
'\x02AW'
'\x05AWAY '
'\x02AY'
'\x08AY-NIGHT'
'\x03AYD'
'\nAYER BEADS'
'\x04AYIN'
'\x03AYN'
'\x01B'
'\x02B '
'\x0bB TIMES SHE'
'\x02BA'
'\x19BA ROTATED NINETY DEGREES'
'\nBA SATANGA'
'\x0eBACKHAND INDEX'
'\x08BACKWARD'
'\x03BAD'
'\x03BAG'
'\x03BAH'
'\x06BAHAR2'
'\x03BAL'
'\x04BALL'
'\rBALLPOINT PEN'
'\x03BAR'
'\x18BAR WITH SHORT RIGHT LEG'
'\nBARB ARROW'
'\rBASAN LETTER '
'\x08BATAEAN '
'\x04BAYI'
'\x02BB'
'\x04BBIT'
'\x04BBON'
'\x10BBREVIATION SIGN'
'\x02BE'
'\x11BE WITH MERIDIANS'
'\x03BEE'
'\x03BEH'
'\tBEH WITH '
'\x0cBEHIND CLOUD'
'\x03BEL'
'\x05BELOW'
'\x04BENT'
'\x0fBENT OVER INDEX'
'\x08BER POLE'
'\x07BERGINE'
'\x03BET'
'\x06BETAN '
'\x04BETH'
'\x07BETWEEN'
'\x08BETWEEN '
'\x0cBETWEEN LIPS'
'\x13BETWEEN MIDDLE RING'
'\x14BETWEEN PALM FACINGS'
'\x06BGBIEE'
'\x03BHA'
'\x0eBHATTIPROLU AA'
'\tBICYCLIST'
'\x0bBIDAKUON NG'
'\x08BIEE FON'
'\nBILE PHONE'
'\x08BILLIONS'
'\x07BINING '
'\x06BISCUS'
'\tBITE LIPS'
'\x16BKA- SHOG GI MGO RGYAN'
'\x06BLACK '
'\x0cBLACK CIRCLE'
'\x19BLACK CIRCLED WHITE ARROW'
'\nBLACK FLAG'
'\rBLACK OCTAGON'
'\x0eBLACK PENTAGON'
'\nBLACK STAR'
'\x04BLE '
'\x08BLE SIGN'
'\x18BLIC ADDRESS LOUDSPEAKER'
'\x06BLIMAT'
'\x06BLINK '
'\nBLOND HAIR'
'\x04BLOW'
'\x0cBLOWING FACE'
'\x05BLUE '
'\x0cBLUE DIAMOND'
'\x02BO'
'\x0fBOARD AND MOUSE'
'\x07BOARDER'
'\x10BOLD GREEK CROSS'
'\nBOLD SHAFT'
'\x11BOLD WHITE CIRCLE'
'\x06BOLD X'
'\x04BOOK'
'\x05BOOTS'
'\x08BOT FACE'
'\tBOTH BENT'
'\x06BOTTLE'
'\x15BOTTOM U-SHAPED ARROW'
'\rBOWING DEEPLY'
'\x03BOX'
'\x08BOX TRAY'
'\x02BR'
'\x0cBRATION MODE'
'\x19BREVE WITH INVERTED BREVE'
'\x11BRIGHTNESS SYMBOL'
'\x0fBROWS STRAIGHT '
'\x03BSP'
'\x02BU'
'\x03BUD'
'\x07BUFFALO'
'\x08BUILDING'
'\x07BULANCE'
'\x04BUNG'
'\x03BUR'
'\x06BURGER'
'\x03BUS'
'\x11BUT RELIEVED FACE'
'\x06BUTTON'
'\x0cBUTTON MOUSE'
'\x02BY'
'\x01C'
'\x02C '
'\x06C CLEF'
'\x06C SIGN'
'\x02CA'
'\x0cCABBAGE-TREE'
'\x07CABINET'
'\x08CABLEWAY'
'\x03CAH'
'\x04CAKE'
'\x05CAKRA'
'\x0cCALENDAR PAD'
'\x04CALL'
'\x06CAMERA'
'\x13CANCELLATION STROKE'
'\x0cCANDRA ABOVE'
'\x0bCANDRABINDU'
'\x04CANO'
'\x07CAP TEN'
'\x0fCAPITAL LETTER '
'\x1cCAPITAL LETTER BOHAIRIC KHEI'
'\x12CAPITAL LETTER YOT'
'\x0fCAPITAL LETTERS'
'\x03CAR'
'\x08CASSETTE'
'\x06CASTLE'
'\x08CAT FACE'
'\x0eCAT FACE WITH '
'\x19CAT FACE WITH CLOSED EYES'
'\x1aCAT FACE WITH SMILING EYES'
'\x05CCEPT'
'\x04CCHH'
'\x02CE'
'\x03CE '
'\x0bCE OF PIZZA'
'\rCE OF WORSHIP'
'\x07CEILING'
'\x08CEILING '
'\x03CEL'
'\x06CENTRE'
'\x07CENTRE '
'\x07CENTRED'
'\x0eCEPTER OF JOVE'
'\x03CER'
'\x0eCERTAINTY SIGN'
'\x04CESS'
'\x02CH'
'\x0bCH AND LAMP'
'\nCH BALLOON'
'\x10CH WITH UMBRELLA'
'\x03CHA'
'\x14CHARACTER INTRODUCER'
'\x04CHAU'
'\x03CHE'
'\x05CHECK'
'\nCHECK MARK'
'\rCHECKER BOARD'
'\x05CHED '
'\x08CHEIKHAN'
'\x14CHEMICAL SYMBOL FOR '
'\x05CHERY'
'\x05CHEST'
'\x05CHICK'
'\x05CHIME'
'\x0bCHING CHICK'
'\x03CHO'
'\x05CHOOI'
'\rCHRONOUS IDLE'
'\x03CHU'
'\x04CIM '
'\x05CING '
'\x06CIRCLE'
'$CIRCLE CONTAINING BLACK SMALL CIRCLE'
'\x1dCIRCLED LATIN CAPITAL LETTER '
'\x1dCIRCLED SANS-SERIF DIGIT ZERO'
'\x13CIRCLED WHITE ARROW'
'\x0cCIRCLES AND '
'\rCITATION MARK'
'\x02CK'
'\x08CK CHART'
'\x07CK LIME'
'\x0cCK-O-LANTERN'
'\x05CKAGE'
'\x04CKEN'
'\nCKER BOARD'
'\x04CKET'
'\x0fCKET CALCULATOR'
'\x0cCKTAIL GLASS'
'\x05CKTIE'
'\x07CLEAVER'
'\x05CLONE'
'\x07CLOSE E'
'\x06CLOSED'
'\x0bCLOSED EYES'
'\x06CLOSET'
'\x07CLOTHES'
'\x05CLUBS'
'\x02CO'
'\x06CODILE'
'\x08COENG QA'
'\nCOLD SWEAT'
'\x0bCOMBINATION'
'\x08COMBINED'
'\nCOMBINING '
'\x11COMBINING NUMBER '
'\x07COMING '
'\x05COMMA'
'\x1dCOMMA QUOTATION MARK ORNAMENT'
'\x10COMPRESSED ARROW'
'\x08COMPUTER'
'\tCONJOINED'
'\nCONSONANT '
'\x10CONSONANT JOINER'
'\x0fCONSONANT SIGN '
'\x15CONSONANT SIGN COENG '
'\x16CONSONANT SIGN MEDIAL '
'\x18CONSONANT SIGN PASANGAN '
'\x07CONTACT'
'\x11CONTAINING BLACK '
'\x11CONTINUATION SIGN'
'\x12CONTINUING OVERLAP'
'\x06COPPER'
'\x12COPPER ANTIMONIATE'
'\x04CORE'
'\x04CORN'
'\tCORN FACE'
'$CORNER ARROWS CIRCLING ANTICLOCKWISE'
'\x05COVER'
'\x02CR'
'\x07CRACKER'
'\x06CRAYON'
'\x05CREAM'
'\x10CREAMING IN FEAR'
'\x0cCRESCENT BAR'
'\x14CRESCENT MOON SYMBOL'
'\tCRESCENTS'
'\x07CRIPT G'
'\x1aCRIPT LIGATURE ET ORNAMENT'
'\x05CROSS'
'\nCROSS MARK'
'\x0cCROSS POMMEE'
'\x07CROSSED'
'\tCROSSED O'
'\x0cCROSSED-TAIL'
'\x15CRUCIFORM NUMBER FOUR'
'\x0bCTION MARK '
'\x0bCTION MARK-'
'\x06CTOPUS'
'\x06CTRIC '
'\x05CTURE'
'\x04CTUS'
'\rCULATED LORRY'
'\x06CUMENT'
'\x12CUP WITHOUT HANDLE'
'\x06CUPPED'
'\x08CURLICUE'
'\x06CURLY '
'\nCURLY LOOP'
'\x08CURSIVE '
'\x05CURVE'
'\x06CURVE '
'\x06CURVED'
'\x0bCURVED BEND'
'\x04CUSP'
'\x04CUTE'
'\nCY MESSAGE'
'\x04CYCL'
'\x01D'
'\x02D '
'\x07D APPLE'
'\x08D BUBBLE'
'\x13D CIRCUMFLEX ACCENT'
'\x08D CROSS '
'\x0bD MIDDLE UP'
'\x16D PLUS GISH TIMES TAK4'
'\x06D SIGN'
'\x11D TIMES DISH TENU'
'\x0cD TIMES ESH2'
'\x0eD-UP NEWSPAPER'
'\x02DA'
'\nDA SATANGA'
'\nDA2 TIMES '
'\x03DAA'
'\x03DAD'
'\x03DAH'
'\x05DAIC '
'\x19DAL WITH THREE DOTS BELOW'
'\x06DALETH'
'\x0bDALETH-RESH'
'\x05DAMMA'
'\x08DAMMATAN'
'\x05DANDA'
'\x07DANESE '
'\x05DARA3'
'\x0bDASH SYMBOL'
'\x0cDASHED ARROW'
'\x05DBOAT'
'\x02DD'
'\x03DDA'
'\x05DDING'
'\x02DE'
'\x0bDE KIKAKUI '
'\nDE-HEADED '
'\nDECORATION'
'\x03DEN'
'\tDENT AND '
'\x0bDENT EMBLEM'
'\x03DEO'
'\nDEOGRAPH A'
'\tDEPARTURE'
'\x05DEPTH'
'\x03DER'
'\tDESCENDER'
'\x18DESCENDING MUSICAL NOTES'
'\x0bDESK PERSON'
'\x08DESTRIAN'
'\x04DGER'
'\x02DH'
'\x05DHAM '
'\x03DHE'
'\x02DI'
'\tDIAERESIS'
'\x08DIAGONAL'
'\tDIAGONAL '
'\x0eDIAGONAL PATH '
'\x07DIAMOND'
'\x08DIAMONDS'
'\x04DIC '
'\rDIC MARK SIGN'
'\x06DIGIT '
'\x08DIM GUNU'
'\x0eDING CHARACTER'
'\x03DIO'
'\x04DISC'
'\x04DISH'
'\x08DIT CARD'
'\x04DIUM'
'\x05DIUM '
'\x05DLING'
'\x1fDMINTON RACQUET AND SHUTTLECOCK'
'\x10DMISSION TICKETS'
'\x02DO'
'\x08DOCUMENT'
'\x03DOG'
'\x03DOI'
'\x0bDOLLAR SIGN'
'\x05DOLLS'
'\x03DOT'
'\tDOT ABOVE'
'\x08DOT REPH'
'\x10DOTTED CRESCENTS'
'\x06DOUBLE'
'\x07DOUBLE '
'\x0fDOUBLE ANUSVARA'
'$DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x10DOUBLE CRESCENTS'
'\x18DOUBLE HORIZONTAL STROKE'
'\x0bDOUBLE MARK'
'\x13DOUBLE MIDDLE TILDE'
'\x08DOUBLE R'
'\x0bDOUBLE RING'
'\x11DOUBLE RING ABOVE'
'\x0fDOUBLE TRIANGLE'
'\x04DOWN'
'\x05DOWN '
'\x1dDOWN MIDDLE THUMB INDEX CROSS'
'\x0cDOWN NEUTRAL'
'\x13DOWN POINTING INDEX'
'\x0fDOWN SEQUENTIAL'
'\tDOWN SIGN'
'\tDOWN STEP'
'\x16DOWN-POINTING TRIANGLE'
'\tDOWNWARDS'
'\nDOWNWARDS '
'\x0eDOWNWARDS AND '
'(DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x0fDOWNWARDS ARROW'
'\x15DOWNWARDS ARROW ABOVE'
'\x0fDOWNWARDS TREND'
'\x06DPHONE'
'\x04DRAM'
'\x05DRINK'
'\x07DU NJAA'
'\x0bDUATION CAP'
'\x03DUB'
'\x06DUCEUS'
'\x0cDUG TIMES NI'
'\x0eDUN3 GUNU GUNU'
'\x08DUSHENNA'
'\x08DVANTAGE'
'\tDY BEETLE'
'\x04DZHA'
'\x01E'
'\x02E '
'\x0eE BUTTON MOUSE'
'\x07E GLASS'
'\x06E HOOK'
'\x05E OF '
'\x08E OF POO'
'\x07E WITH '
'\x0cE WITH GRAVE'
'\x0bE WITH VEIL'
'\x02E2'
'\x0bE2 TIMES AN'
'\x03E80'
'\x02EA'
'\x04EAAE'
'\x03EAD'
'\x07EAD ORE'
'\x04EANS'
'\x0bEARS OF JOY'
'\x10EART-SHAPED EYES'
'\x05EARTH'
'\x05EAST '
'\x0eEAST POINTING '
'\x12EAST POINTING LEAF'
'\x16EAST-POINTING AIRPLANE'
'\x05EATH '
'\x0fEAVY CHECK MARK'
'\nECH BUBBLE'
'\x03ECK'
'\x06ECTION'
'\x0bECTION MARK'
'\x02ED'
'\x08ED BRICK'
'\x07ED FACE'
'\x08ED FLAGS'
'\nED MIDDLE '
'\rED PAPERCLIPS'
'\x07ED RICE'
'\nEDESTRIANS'
'\x05EDIC '
'\x02EE'
'\x03EEE'
'\x04EEEE'
'\x03EEG'
'\x04EEJ '
'\x03EEM'
'\x04EEM '
'\x19EEM WITH THREE DOTS ABOVE'
'\x03EEN'
'\x03EEP'
'\x05EESHI'
'\x03EET'
'\x02EF'
'\x06EFCASE'
'\x15EFT HORIZONTAL SECANT'
'\x1bEFT POINTING BACKHAND INDEX'
'\x14EFTWARDS ARROW WITH '
'\x02EH'
'\x0cEH WITH LOOP'
'\x02EI'
'\x05EIGHT'
'\x06EIGHT '
'\tEIGHT OF '
'\x15EIGHT SPOKED ASTERISK'
'\x06EIGHTH'
'\x06EIGHTY'
'\x03EIN'
'\x02EK'
'\x05EKEET'
'\x02EL'
'\x03ELD'
'\x19ELD HOCKEY STICK AND BALL'
'\x0cELECTED AREA'
'\x0bELLOW HEART'
'\x0bELTIC CROSS'
'\x04ELVE'
'\x02EM'
'\x07EM DASH'
'\x05EMBIC'
'\x0cEMELY HEAVY '
'\x08EMICOLON'
'\x02EN'
'\x03EN '
'\x08EN NTEUM'
'\x06EN OF '
'\x0bEN STRAIGHT'
'\x0bEN TWELFTHS'
'\x04ENCH'
'\nENCH FRIES'
'\x05ENCIL'
'\rENCY EXCHANGE'
'\x03END'
'\x04END '
'\x10END OF TEXT MARK'
'\nENGER SHIP'
'\x06ENIS F'
'\x05ENJET'
'\x0eENNA WITH BARS'
'\x06ENNANT'
'\x03ENS'
'\nENS SYMBOL'
'\x07ENSHUET'
',ENT ARROW POINTING DOWNWARDS THEN NORTH EAST'
'\nENTRY SIGN'
'\x04ENTY'
'\x05EOPLE'
'\x02EP'
'\x06EPACT '
'\x05EPAYA'
'\x1cEPIGRAPHIC LETTER SIDEWAYS I'
'\x02EQ'
'\x08EQUENCE '
'\tEQUENTIAL'
'\x15EQUILATERAL ARROWHEAD'
'\x02ER'
'\x03ER '
'\x08ER BOARD'
'\x06ER MUG'
'\tER SYMBOL'
'\x03ERA'
'\x10ERCURY SUBLIMATE'
'\x08ERDIGRIS'
'\x04EREN'
'\rERIAL TRAMWAY'
'\x0fERICAN FOOTBALL'
'\x05ERIN2'
'\tERMOMETER'
'\x07ERNIN A'
'\x04ERSE'
'\x1aERSTRASS ELLIPTIC FUNCTION'
'\x03ERT'
'\x03ERU'
'\x02ES'
'\x03ES-'
'\x03ESC'
'\x0fESEL LOCOMOTIVE'
';ESENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRACKET'
'\x03ESH'
'\rESH2 ASTERISK'
'\rESH2 PLUS LAL'
'\x03ESS'
'\x02ET'
'\x06ET KUT'
'\x05ET TU'
'\x03ETA'
'\x03ETE'
'\x0bETEI MAYEK '
'\x03ETH'
'\x06ETTER '
'\tETTI BALL'
'\x02EU'
'\x06EU MBU'
'\x04EUAE'
'\x05EUAEM'
'\x05EUAEN'
'\x06EUAENA'
'\x05EUAEQ'
'\x08EUFEUAET'
'\x03EUM'
'\x03EUN'
'\x0bEUNJOMNDEUQ'
'\x06EUNYAM'
'\x03EUQ'
'\x05EURAE'
'\x06EUREUT'
'\x04EURI'
'\tEURO SIGN'
'\rEUROPE-AFRICA'
'\x03EUT'
'\x03EUX'
'\x04EVEN'
'\x08EVEN OF '
'\rEVEN TWELFTHS'
'\x13EVEN U VARIANT FORM'
'\x06EVENTY'
'\x0cEVERING FACE'
'\x0eEVERSED OPEN E'
'\x10EVERY OTHER TIME'
'\x02EW'
'\x06EWAYS '
'\x02EX'
'\x19EXCLAMATION MARK ORNAMENT'
'\x0bEXED BICEPS'
'\x06EXHALE'
'\x03EXT'
'\x06EXTRA-'
'\x02EY'
'\x03EYK'
'\x01F'
'\x02F '
'\x10F WITH DOT BELOW'
'\rF WITH STROKE'
'\x02FA'
'\x04FACE'
'\nFACE WITH '
'\x1dFACING ARMENIAN ETERNITY SIGN'
'\tFACING UP'
'\x04FAIB'
'\x03FAJ'
'\x10FALLING DIAGONAL'
'\x03FAM'
'\x04FAST'
'\x05FATHA'
'\x0bFATHA WITH '
'\x08FATHATAN'
'\x07FATIGUE'
'\x02FE'
'\x04FEED'
'\x04FEEM'
'\x03FEH'
"'FEH WITH DOT BELOW AND THREE DOTS ABOVE"
'\x04FEUQ'
'\x0eFFICE BUILDING'
'\x02FI'
'\x05FIER '
'\x08FILE BOX'
'\x07FINAGH '
'\x05FINAL'
'\x06FINAL '
'\tFINAL NUN'
'\x08FINGER C'
'\x11FINGER-POST ARROW'
'\x0fFINGERS SPLAYED'
'\x04FIRE'
'\x0bFIRE ENGINE'
'\x04FIRI'
'\x04FISH'
'\x04FIST'
'\x04FIVE'
'\x05FIVE '
'\x13FIVE FINGERS SPREAD'
'\x14FIVE SPOKED ASTERISK'
'\x0cFLAG ON POST'
'\x07FLEURON'
'\x11FLICK ALTERNATING'
'\x05FLOOR'
'\x06FLOOR '
'\x0bFLOORPLANE '
'\x10FLOORPLANE SPACE'
'\x13FLOORPLANE TWISTING'
'\x06FLOWER'
'\nFLUTTERING'
'\x04FO F'
'\x0cFOLDED HANDS'
'\x06FOLDER'
'\x03FOM'
'\x08FOR STOP'
'\nFORMATION '
'\x0cFORMING ARTS'
'\x06FORTIS'
'\x07FORWARD'
'\x0eFORWARD INDEX '
'\x0fFORWARD TILTING'
'\x0cFOUNTAIN PEN'
'\x04FOUR'
'\tFOUR BENT'
'\nFOUR DOTS '
'\x0fFOUR DOTS WITH '
'\x0fFOUR ENCLOSURES'
'\x0cFOUR FINGERS'
'\x16FOUR FINGERS CONJOINED'
'\x1bFOUR FINGERS CONJOINED BENT'
'\x14FOUR RAISED KNUCKLES'
'\tFRACTION '
'\x06FRAMES'
'\x0eFRANKS CASKET '
'\x04FREE'
'\x1cFROM BAR WITH HORIZONTAL BAR'
'\nFRONT WALL'
'\x05FROWN'
'\x08FROWNING'
'\rFROWNING FACE'
'\x02FT'
'\x03FT '
'\rFT ARROWHEAD '
'\x13FT-POINTING FLEURON'
'\x03FTY'
'\x03FUE'
'\tFULL STOP'
'\x01G'
'\x06G FACE'
'\x08G TIMES '
'\x13G WITH CROSSED-TAIL'
'\x02GA'
'\x03GAA'
'\nGAB TIMES '
'\x18GAF WITH INVERTED STROKE'
'\x03GAH'
'\x03GAI'
'\x05GALI '
'\x04GAME'
'\tGAN2 TENU'
'\x07GATIVE '
'\x05GAZE-'
'\x02GB'
'\x05GBASA'
'\x06GBASAQ'
'\x05GBIEE'
'\x0cGBY FOOTBALL'
'\x02GC'
'\x02GE'
'\x03GE '
'\x0bGE AT NIGHT'
' GEMINATION AND VOWEL LENGTH MARK'
'\x0fGEMINATION MARK'
'\x03GEN'
'\x03GER'
'\x06GERINE'
'\x0bGGAGE CLAIM'
'\x05GGER '
'\nGGING FACE'
'\x12GGLY VERTICAL LINE'
'\x02GH'
'\x03GHA'
'\x05GHAIN'
'\x06GHETTI'
'\x06GHEUAE'
'\x07GHEUGHE'
'\x05GHNUT'
'\x03GHT'
'\x1eGHT FOUR POINTED PINWHEEL STAR'
'\nGHT LIFTER'
'\x06GHTLY '
'\x02GI'
'\x13GIBBOUS MOON SYMBOL'
'\x05GIMEL'
'\x1fGIONAL INDICATOR SYMBOL LETTER '
'\x02GJ'
'\x07GLASSES'
'\x03GLE'
'\x0cGLOTTAL STOP'
'\x02GN'
'\x02GO'
'\x06GOBLIN'
'\x05GOLAT'
'\x07GRADUAL'
'\x08GRANTHA '
'\x1cGRAPHIC CHARACTER INTRODUCER'
'\x06GRASP '
'\x05GRAVE'
'\x0bGREEK CROSS'
'\x02GU'
'\nGUA PI MAO'
'\x0cGUARDED AREA'
'\x03GUD'
'\x04GUIN'
'\x05GULUS'
'\x0eGUNU TIMES ASH'
'\rGUNU TIMES HA'
'\x05GVANG'
'\x02GY'
'\x04GYAN'
'\x01H'
'\x0bH WITH HOOK'
'\x02HA'
'\tHA PLUS A'
'\x03HAA'
'\x03HAB'
'\x03HAH'
'\x0cHAH WITH DAL'
'\x03HAI'
'\x04HAIN'
'\x12HAIS LUS NTOG NTOG'
'\x07HAJANI '
'\x06HAKING'
'\x0fHAKING PARALLEL'
'\x03HAL'
'\x05HALA '
'\x04HALF'
'\x05HALF '
'\x08HALF GUR'
'\tHALF NOTE'
'\x05HALQA'
'\x06HAMEDH'
'\x0bHAMZA ABOVE'
'\x04HAND'
'\x0cHAND FORMAT '
'\tHAND SIGN'
'\x17HAND TELEPHONE RECEIVER'
' HAND WITH MIDDLE FINGER EXTENDED'
'\x1bHANDED INTERLACED PENTAGRAM'
'\nHANDS SIGN'
'\x0bHANG KHUDAM'
'\x04HAPH'
'\x03HAQ'
'\x0bHAR2 TIMES '
'\x16HARD SHELL FLOPPY DISK'
'\tHARD SIGN'
'\x03HAT'
'\x03HAU'
'\x03HAV'
'\x0bHAWH HMONG '
'\x05HAYIN'
'\x02HE'
'\x03HEA'
'\x0cHEAD-BANDAGE'
'\x07HEADING'
'\nHEADSTROKE'
'\x05HEART'
'\x11HEART-SHAPED EYES'
'\x06HEARTS'
'\x06HEAVY '
'\x10HEAVY BARB ARROW'
'\x0bHEAVY SHAFT'
'\x04HECK'
'\x05HECK '
'\x04HEEJ'
'\x06HEEKS '
'\x04HEEL'
'\x0bHEELED SHOE'
'\x04HEEM'
'\x04HEEN'
'\x03HEH'
'\x04HENG'
'\nHERMOMETER'
'\x04HETH'
'\x05HEUAE'
'\x06HEUAEP'
'\x04HEYS'
'\x04HEYT'
'\x02HH'
'\x03HHA'
'\x02HI'
'\rHI TIMES ASH2'
'\rHIEROGLYPHIC '
'\x04HIGH'
'\x05HIGH '
'\x1fHIGH EXTRA-LOW CONTOUR TONE BAR'
'\x03HII'
'\x12HILOSOPHERS SULFUR'
'\x05HIMEL'
'\x03HIN'
'\x05HINGE'
'\x06HINGE '
'\x06HINGED'
'\x07HIOPIC '
'\x04HIP '
'\x0eHIRD-STAGE HLI'
'\x05HIRTY'
'\x08HITTING '
'\x07HIUCHUS'
'\x15HOCKEY STICK AND PUCK'
'\x03HOI'
'\x03HOJ'
'\x03HOM'
'\x04HOM '
'\x04HOOK'
'\x0fHOOKED INDEX UP'
'\x04HOOL'
'\x08HOP BELL'
'\x04HOPH'
'\x11HORIZONTAL SECANT'
'\x11HORIZONTAL STROKE'
'\x06HORT I'
'\x04HOST'
'\x05HOTEL'
'\x08HOULDER '
'\x08HOUSANDS'
'\x03HOX'
'\x04HREE'
'\nHREE DOTS '
'\x0cHREE FINGERS'
'\x08HREE OF '
'\x17HREE POINTED BLACK STAR'
'\rHREE TWELFTHS'
'\x05HROOM'
'\x02HT'
'\x1eHT CENTRALIZATION STROKE BELOW'
'\x04HUB2'
'\x04HUET'
'\x04HUMB'
'\x05HUMP '
'\x07HUNDRED'
'\nHUNGARIAN '
'\x05HUTA '
'\x04HUVA'
'\tHWA WITH '
'\x04HWAH'
'\x02HY'
'\x06HYPHEN'
'\x01I'
'\x0eI AND SKI BOOT'
'\x06I GUNU'
'\x06I HOOK'
'\x07I NTEUM'
'\nI PLUS ZA7'
'\x06I SIGN'
'\x19I SYLLABLE ITERATION MARK'
'\x1dI TIMES ASH OVER HI TIMES ASH'
'\x0cI TIMES TAK4'
'\x02I2'
'\x03IAB'
'\rIAERESIS-RING'
'\tIAL LINE '
'\x0eIAMOND CENTRED'
'\x18IAMOND CONTAINING BLACK '
'\x0eIAN RUPEE SIGN'
'\x06IB YAM'
'\nIC LETTER '
'\x05ICAL '
'\x0cICE CONTROL '
'\tICE CREAM'
'\x08ICHAEAN '
'\x04ICK '
'\x12ICKET BAT AND BALL'
'\x0bICLOCKWISE '
'\x04ICON'
'\x07ICYCLES'
'\x02ID'
'\x03IDA'
'\x03IDE'
'\x0bIDUOUS TREE'
'\x02IE'
'\nIED SHRIMP'
'\x03IEE'
'\x0bIEN MONSTER'
'\x03IES'
'\x04IFTY'
'\x02IG'
'\nIGATING RA'
'\nIGATURE OE'
'\x18IGATURE OPEN ET ORNAMENT'
'\x0cIGATURE SHRI'
'\x06IGGLES'
'\x04IGHT'
'\nIGHT RULER'
'\rIGHT TWELFTHS'
'\x13IGHT U VARIANT FORM'
'\x0fIGHT WITH STARS'
'\x17IGHT-SHADED WHITE ARROW'
'\x10IGHTH NOTE STEM '
'\x03IGI'
'\x08IGI GUNU'
'\x05IGIT '
'\x06IGIT T'
'\x04IGN '
'\x15IGN INVERTED MCHU CAN'
'\tIGN NUKTA'
'\nIGN SAMVAT'
'\tIGN TOMPI'
'\x02IH'
'\x02II'
'\x03IKA'
'\x02IL'
'\x07IL DRUM'
'\tIL POLISH'
'\x05ILDE '
'\x13ILDING CONSTRUCTION'
'\nILE FOLDER'
'\x05ILED '
'\x04ILET'
'\x05ILVER'
'\x02IM'
'\x07IM GUNU'
'\nIMALUNGUN '
'\x04IMEL'
'\x05IMGBA'
'\x05IMMER'
'\x03IMN'
'\x0bIMULTANEOUS'
'\x02IN'
'\x1bIN BUSINESS SUIT LEVITATING'
'\x0cIN MIDDLE UP'
'\x05INAL '
'\tINAL NOTE'
'\tINARBORAS'
'\x1dINDEPENDENT VOWEL SIGN COENG '
'\x05INDEX'
'\x06INDEX '
'\nINDEX BENT'
'\x0cINDEX MIDDLE'
'\x12INDEX RING LITTLE '
'\x14INDEX RING LITTLE ON'
'\x1eINDEX THUMB CURVE THUMB INSIDE'
'\x10INDEX THUMB SIDE'
'\x08INDEX UP'
'\x04INDI'
'\x03INE'
'\x08INFINITY'
'\x03ING'
'\x04ING '
'\x08ING BELL'
'\x08ING BOWL'
'\x0eING HANDS SIGN'
'\x16ING HEAD IN SILHOUETTE'
'\tING HEART'
'\x0cING HITTING '
'\x06ING IN'
'\nING LITTLE'
'\x07ING OF '
'\x07ING OUT'
'\x11ING POLE AND FISH'
'\x13ING SHIRT WITH SASH'
'\x0eING TERMINATOR'
'\nING-SHIFT '
'\x04INGE'
'\x05INGED'
'\x10INGER-POST ARROW'
'\x06INGLE '
'\x06INHALE'
'\x08INITIAL '
'\x07INNABAR'
'\x0eINOLOGICAL DOT'
'\x06INSIDE'
'\x0cINSIDE MOUTH'
'\x14INSIDE MOUTH RELAXED'
'\x14INTERROBANG ORNAMENT'
'\x04INU '
'\x0cINUSOID SIGN'
'\x08INVERTED'
'\x14INVERTED BREVE BELOW'
'\x0fINVERTED LAZY S'
'\x11INVERTED MCHU CAN'
'\x04INY '
'\x03ION'
'\x02IP'
'\x12IPLE MUSICAL NOTES'
'\x10IPPER-MOUTH FACE'
'\x18IPT LIGATURE ET ORNAMENT'
'\x02IQ'
'\x02IR'
'\x03IR2'
'\x05IRACY'
'\x05IRAMA'
'\x05IRCLE'
'\x10IRCLE FOR RECORD'
'\x06IRCLED'
'\rIRCLED INDEX '
'\x0bIRCLED TEXT'
'\x07IRCLES '
'\x14IRCLES HITTING WALL '
'\x07IRCLING'
'\x05IRCUT'
'\x03IRL'
'\x04IRON'
'\x08IRPLANE '
'\x04IRTY'
'\x02IS'
'\x03ISA'
'\x03ISH'
'\rISH LIRA SIGN'
'\nISMUTH ORE'
'\x18ISOSCELES RIGHT TRIANGLE'
'\x03IST'
'\x17ISTED RIGHTWARDS ARROWS'
'\x02IT'
'\nIT MBAAKET'
'\x03ITA'
'\x08ITA MFON'
'\x11ITALIC LETTER ESS'
'\x04ITAR'
'\x0bITARY MEDAL'
'\x04ITE '
'\x07ITTING '
'\x03IVE'
'\x04IVE '
'\x12IVE FINGERS SPREAD'
'\x17IVE FINGERS SPREAD OPEN'
'\x07IVE OF '
'\x13IVE SPOKED ASTERISK'
'\x0cIVE TWELFTHS'
'\x12IVE U VARIANT FORM'
'\x0bIVERY TRUCK'
'\x0cIVISION SIGN'
'\x02IW'
'\x03IWR'
'\x02IX'
'\x03IX '
'\x06IX OF '
'\x12IX SPOKED ASTERISK'
'\x0bIX TWELFTHS'
'\x11IX U VARIANT FORM'
'\x04IXTY'
'\rIYA FRACTION '
'\x04IYAQ'
'\x03IYO'
'\x08IZONTAL '
'\x01J'
'\x13J WITH CROSSED-TAIL'
'\x02JA'
'\x08JACK OF '
'\x03JAH'
'\x07JAIN OM'
'\x03JAM'
'\x07JARATI '
'\x03JAW'
'\x02JE'
'\x04JEEM'
'\x18JEEM WITH TWO DOTS ABOVE'
'\x03JHA'
'\x0bJIHVAMULIYA'
'\x1eJK COMPATIBILITY IDEOGRAPH-FA2'
'\x15JK UNIFIED IDEOGRAPH-'
'\x02JO'
'\x06JOINER'
'\x05JUDUL'
'\x01K'
'\x02K '
'\x0bK AND KNIFE'
'\tK GESTURE'
'\x0bK HAND SIGN'
'\x10K PERMITTED HERE'
'\x15K WITH OBLIQUE STROKE'
'\x02K-'
'\x05K-020'
'\x02KA'
'\nKA SATANGA'
'\x03KAD'
'\x03KAH'
'\x03KAK'
'\x04KALI'
'\x03KAM'
'\x04KAPH'
'\x03KAQ'
'\x05KARO '
'\x07KARO BA'
'\x06KASKAL'
'\x05KASRA'
'\x14KASRA WITH DOT BELOW'
'\x08KASRATAN'
'\tKATAKANA '
'\x03KAU'
'\x05KBALL'
'\x02KE'
'\x11KE BOTTLE AND CUP'
'\x05KESH2'
'\x10KETBALL AND HOOP'
'\x07KEUAERI'
'\x04KEUP'
'\x03KEY'
'\x08KEYBOARD'
'\x04KHAH'
'\x05KHMU '
'\x06KILLER'
'\nKINDI MVOP'
'\tKING FACE'
'\x04KINI'
'\x19KISIM5 TIMES U2 PLUS MASH'
'\x04KISS'
'\x04KMA '
'\x05KNIFE'
'\x05KNOBS'
'\x02KO'
'\x04KOKE'
'\x04KOKO'
'\x03KOM'
'\x07KPAK WA'
'\x04KPEN'
'\x0bKRAINIAN IE'
'\x04KRI '
'\x05KTOP '
'\x03KU3'
'\x03KUE'
'\x13KULL AND CROSSBONES'
'\x03KUR'
'\x12KUSHU2 PLUS KASKAL'
'\x05KWAEN'
'\x06KY WAY'
'\tKYO TOWER'
'\x01L'
'\x0bL WITH BELT'
'\x10L WITH DESCENDER'
'\x1aL WITH DOUBLE MIDDLE TILDE'
'\x02LA'
'\x03LAA'
'\x0bLABIAL SIGN'
'\x05LACK '
'\x18LACK CIRCLED WHITE ARROW'
'\nLACK JOKER'
'\x0bLACK SULFUR'
'\x0bLACKLETTER '
'\x03LAH'
'\x07LAK-050'
'\x03LAM'
'\x06LAMEDH'
'\x07LAMITE '
'\tLAN SIGN '
'\x1aLANTED SOUTH ARROW WITH HO'
'\x05LARGE'
'\x06LARGE '
'\x0cLARGE DOUBLE'
'\x1bLARGE EQUILATERAL ARROWHEAD'
'\x18LARGE TRIANGLE ARROWHEAD'
'\x0cLARGE TRIPLE'
'\x07LASHES '
'\x14LASHING SWEAT SYMBOL'
'\x03LAT'
'\x08LAT SIGN'
'\x06LATIN '
'\x15LATIN CAPITAL LETTER '
'\x08LATION X'
'\x03LAU'
'\x03LAW'
'\x08LAYALAM '
'\x0bLCE TSA CAN'
'\x02LD'
'\x03LD '
'\x06LD MAP'
'\x11LD PERMIC LETTER '
'\x0bLD SCRIPT X'
'\tLD TAMIL '
'\x04LDER'
'\x0eLDREN CROSSING'
'\x02LE'
'\x19LE TENNIS PADDLE AND BALL'
'\x14LE WITH POPPING CORK'
'\x17LE WITH ROUNDED CORNERS'
'\x13LEADING MCHAN RTAGS'
'\x04LEAF'
'\x0bLEAF CLOVER'
'\x04LED '
'\x05LEERI'
'\x03LEF'
'\x04LEFT'
'\x05LEFT '
'\nLEFT GUARD'
'\tLEFT HALF'
'\x0fLEFT HALF BELOW'
'\x0fLEFT HAND INDEX'
'\tLEFT HOOK'
'\x13LEFT POINTING INDEX'
'\x1fLEFT SEMICIRCLE WITH THREE DOTS'
'\nLEFT SERIF'
'\x13LEFT U-SHAPED ARROW'
',LEFT-LIGHTED DOWNWARDS EQUILATERAL ARROWHEAD'
'\x16LEFT-POINTING TRIANGLE'
'\x17LEFT-SHADED WHITE ARROW'
'\x14LEFT-TO-RIGHT SECANT'
'\tLEFTWARDS'
'\nLEFTWARDS '
'\x0eLEFTWARDS AND '
'\x0fLEFTWARDS ARROW'
'\x1fLEFTWARDS EQUILATERAL ARROWHEAD'
',LEFTWARDS OF DOWNWARDS TRIANGLE-HEADED ARROW'
'*LEFTWARDS OF UPWARDS TRIANGLE-HEADED ARROW'
'\x03LEI'
'\x06LENDAR'
'\x07LENGTH-'
'\x04LEPH'
'\x06LETTER'
'\x07LETTER '
'\rLETTER KHINYA'
'\x0bLETTER LLLA'
'\tLETTER MV'
'\x0eLETTER OVERLAP'
'\x08LETTER S'
'\x1aLETTER SMALL CAPITAL OMEGA'
'\x08LETTER Y'
'\nLETTER ZHA'
'\x07LETTERS'
'\x03LEU'
'\x0bLEU SATANGA'
'\x05LEVEN'
'\x0eLEVEN TWELFTHS'
'\x07LEYBALL'
'\x03LF '
'\x07LF FACE'
'\x04LFER'
'\x04LFUR'
'\x02LH'
'\x11LHOUETTE OF JAPAN'
'\x02LI'
'\x05LICE '
'\x0cLICKING LIPS'
'\x08LICOPTER'
'\x05LICUE'
'\x19LID QUILT SQUARE ORNAMENT'
'\x0bLIEVED FACE'
'\x10LIGHT BARB ARROW'
'\nLIGHT BULB'
'\x1bLIGHT CENTRALIZATION STROKE'
'\x1dLIGHT FOUR POINTED BLACK CUSP'
'\x07LIGHT X'
'\x0eLIGHTLY SMALL '
'\tLIGHTNING'
'\x0cLIMBS DIGITS'
'\x04LINE'
'\x05LINE '
'\x0bLINE FILLER'
'\x05LING '
'\x03LIP'
'\x04LIPS'
'\x0bLITH DIGIT '
'\x06LITTLE'
'\x07LITTLE '
'\tLITTLE UP'
'\x0cLL MODIFIER-'
'\x03LLA'
'\tLLAR SIGN'
'\x03LLE'
'\tLLEN LEAF'
'\x07LLEYBUS'
'\x06LLHORN'
'\x07LLIARDS'
'\x06LLIPOP'
'\x0eLLISION SYMBOL'
'\x04LLLA'
'\x03LLO'
'\x02LM'
'\x02LO'
'\x05LOAN '
'\x04LOCK'
'\rLOCK WITH KEY'
'\x03LON'
'\x04LONG'
'\nLONG FINAL'
'\tLONG TIP '
'\x0fLOOK OF TRIUMPH'
'\x05LOOP '
'\x03LOS'
'\x06LOSED '
'\x03LOW'
'(LOW DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x1fLOW EXTRA-HIGH CONTOUR TONE BAR'
'\x19LOW QUILT SQUARE ORNAMENT'
'\x1dLOW-REVERSED-9 QUOTATION MARK'
'\x05LOWER'
'\x10LOWER OVER UPPER'
'\x0cLOWERED FLAG'
'\x07LOZENGE'
'\x04LPHA'
'\x05LPHIN'
'\x02LT'
'\tLTERNATE '
'\nLTERNATE U'
'\x05LTIRE'
'\x08LTRY LEG'
'\x03LU3'
'\x03LUB'
'\x07LUGGAGE'
'\x03LUM'
'\x05LURAL'
'\x05LWAY '
'\x02LX'
'\x07LY LOOP'
'\x01M'
'\x02M '
'\x06M FEED'
'\x0cM NSHUT NYAM'
'\x07M STONE'
'\x08M SYMBOL'
'\nM TIMES ME'
'\x13M WITH CROSSED-TAIL'
'\x02MA'
'\x03MAA'
'\x07MAAYYAA'
'\x07MACHINE'
'\x0bMACING FACE'
'\x07MACRON '
'\tMAEMGBIEE'
'\rMAILBOX WITH '
'\x05MAIZE'
'\x06MALGAM'
'\x04MALL'
'\x05MALL '
'\rMALL CAPITAL '
'\rMALL HIGH WAW'
'\x0cMALL LETTER '
'\x0cMALL SECTION'
'\x03MAN'
'\x03MAQ'
'\rMAR TIMES KUG'
'\x04MARK'
'\x05MARK '
'\tMARK CIM '
'\x0bMARWARI DDA'
'\x04MARY'
'\x04MASH'
'\x07MASSAGE'
'\x04MATO'
'\x03MAU'
'\x02MB'
'\x03MB '
'\x03MBA'
'\x03MBE'
'\x16MBOL FOR MARKS CHAPTER'
'\x0bMBU LETTER '
'\x08MCHU CAN'
'\x02ME'
'\x08ME BADGE'
'\x04MED '
'\x0cMEDARY CAMEL'
'\x0cMEDICAL MASK'
'\x06MEDIUM'
'\x07MEDIUM '
'\x11MEDIUM BARB ARROW'
'\x0eMEDIUM DIAMOND'
'\x0cMEDIUM SHAFT'
'\rMEDIUM SQUARE'
'\x19MEDIUM TRIANGLE ARROWHEAD'
'\x04MEEM'
'\x1aMEEM WITH HAH WITH TATWEEL'
'\x04MEGA'
'\x04MEKH'
'\x05MELON'
'\x03MEM'
'\x08MEM-QOPH'
'\x11MEN HOLDING HANDS'
'\x10MENIAN DRAM SIGN'
'\x05MENOE'
'\x03MER'
'\x04MER '
'\tMER CLOCK'
'\x07MERICAS'
'\x04MFAA'
'\x0bMFON PIPAEM'
'\x0bMIC LETTER '
'\x04MID '
'\x08MID TONE'
'\x0eMID-LEVEL TONE'
'\x06MIDDLE'
'\x07MIDDLE '
'\x0bMIDDLE BENT'
'\x0bMIDDLE RING'
'\x12MIDDLE RING LITTLE'
'\x1cMIDDLE RING LITTLE CONJOINED'
'\x15MIDDLE RING LITTLE ON'
'\x0cMIDDLE TILDE'
'\tMIDDLE UP'
'\x04MIL '
'\x0bMILING EYES'
'\x11MILITARY AIRPLANE'
'\x08MILLIONS'
'\x04MILY'
'\rMINDER RIBBON'
'\nMINUS SIGN'
'\x04MIZE'
'\x03MMA'
'\x02MO'
'\rMOBILE PHONES'
'"MODIFIER LETTER SHAN REDUPLICATION'
'\rMODIFIER MARK'
'\x03MON'
'\x04MONO'
'\x05MOON '
'\nMOTORCYCLE'
'\x08MOVEMENT'
'\x13MOVES AGAINST CHEEK'
'\x02MP'
'\rMPED ENVELOPE'
'\x11MPERSAND ORNAMENT'
'\x05MSHAE'
'\x13MSHELL MOBILE PHONE'
'\x03MSP'
'\x04MUAS'
'\x04MUCH'
'\x08MULTIPLE'
'\x11MUM LETTER PHASE-'
'\x04MUSH'
'\x08MY HOUSE'
'\x01N'
'\x02N '
'\nN NGGEUAET'
'\x11N PLUS KAK PLUS A'
'\x12N VIEWING CEREMONY'
'\x07N WITH '
'\x10N WITH LEFT HOOK'
'\x16N-POTABLE WATER SYMBOL'
'\x02NA'
'\x08NA METEK'
'\x03NAA'
'\x04NAKE'
'\x04NAM2'
'\x0cNARROW SHAFT'
'\x03NAU'
'\x04NBOW'
'\x04NBSP'
'\x02ND'
'\x0bND OF PIECE'
'\x03ND-'
'\x08NDA FACE'
'\nNDA PA NJI'
'\tNDAILING '
'\x05NDBAG'
'\x13NDRED POINTS SYMBOL'
'\x02NE'
'\x07NE FEED'
'\x04NED '
'\x05NEGAR'
'&NEGATIVE CIRCLED SANS-SERIF DIGIT ZERO'
'\x08NEIFORM '
'\x04NEMA'
'\x05NENOE'
'\x13NETWORKED COMPUTERS'
'\x07NEUTRAL'
'\x08NEUTRAL '
'\x03NEY'
'\x11NFORMATION SOURCE'
'\x02NG'
'\x0bNG LEFT LEG'
'\x14NG WITH CROSSED-TAIL'
'\x06NGBAT '
'\x03NGE'
'\x05NGENT'
'\x04NGER'
'\x04NGUE'
'\x05NGUE '
'\x02NI'
'\tNIGHT OF '
'\x0bNIKOLSBURG '
'\x04NINE'
'\x08NINE OF '
'\rNINE TWELFTHS'
'\x13NINE U VARIANT FORM'
'\x06NINETY'
'\x05NING '
'\tNING MOOD'
'\rNING MOVEMENT'
'\x04NJAM'
'\x03NJI'
'\x02NK'
'\x0fNKING BEER MUGS'
'\x06NKNOWN'
'\x03NNA'
'\x06NNADA '
'\x03NNI'
'\x06NNING '
'\x15NNIS RACQUET AND BALL'
'\x04NNNA'
'\x0fNO GOOD GESTURE'
'\x08NO THUMB'
'\x13NOGRAPHIC FULL STOP'
'\x04NOON'
'\x0fNOON WITH KEHEH'
'\x06NORTH '
'\x0eNORTH ARABIAN '
'\x04NOSE'
'\x0cNOTCHED TAIL'
'\x04NOTE'
'\x08NOTE PAD'
'\nNOTE WITH '
'\x04NOWC'
'\x08NOWLEDGE'
'\x08NRES TOS'
'\x04NRUA'
'\tNS-SERIF '
'\x1dNS-SERIF INTERROBANG ORNAMENT'
'\x06NSANAQ'
'\x0bNSE CHEEKS '
'\x04NSHE'
'\x05NSIEE'
'\x05NSUAE'
'\x02NT'
'\x14NT-FACING BABY CHICK'
'\x04NTAA'
'\tNTESSENCE'
'\x05NTHA '
'\x0bNTIMONY ORE'
'\x05NTXIV'
'\x03NUB'
'\x05NUKTA'
'\x07NUMBER '
'\x11NUMBER MARK ABOVE'
'\x08NUMBER T'
'\x07NUMBERS'
'\rNUMERIC SIGN '
'\x03NUN'
'\x07NUSVARA'
'\x08NVERTED '
'\x03NYA'
'\x03NYI'
'\x03NYO'
'\x05NZEUM'
'\x01O'
'\x05O BOX'
'\tO HUNDRED'
'\tO LETTER '
'\x06O MARK'
'\x07O WITH '
'\x04OALA'
'\x03OAP'
'\x05OBILE'
'\x0eOBLIQUE STROKE'
'\x07OCALIC '
'\x08OCALIC M'
'\x07OCATION'
'\x08OCK SALT'
'\x05OCKET'
'\x0bOCOLATE BAR'
'\x07OCTAGON'
'\x0cOCTET PRESET'
'\x08OCUS OF '
'\x08ODESTONE'
'\x04ODLE'
'\x02OE'
'\x03OF '
'\x0bOF ENVELOPE'
'\x03OFF'
'\x07OFFICER'
'\x04OFUM'
'\x07OGICAL '
'\x08OGOGRAM '
'\x04OGRE'
'\x02OH'
'\rOHIBITED SIGN'
'\x0bOHINGYA YEH'
'\x02OI'
'\x03OIL'
'\x1eOJI MODIFIER FITZPATRICK TYPE-'
'\x05OJKI '
'\x02OK'
'\x0cOK HAND SIGN'
'\tOKED HEAD'
'\tOKED TAIL'
'\x05OKEE '
'\nOKEN HEART'
'\x0cOKING SYMBOL'
'\x02OL'
'\x03OLD'
'\x04OLD '
'\x05OLDER'
'\x06OLIDUS'
'\x04OLIN'
'\x03OLL'
'\rOLVING HEARTS'
'\x02OM'
'\x14OM HALF BLACK CIRCLE'
'\x08OM NTEUM'
'\x08OMANIAN '
'\x17OMBINING ANUSVARA ABOVE'
'\x04OMBU'
'\x05OMEGA'
'\x0eOMING ENVELOPE'
'\x05OMMAE'
'\x03OMS'
'\x02ON'
'\x03ON '
'\x07ON FACE'
'\tON TEUAEQ'
'\x0fON TOP OF MODEM'
'\x0cON US SYMBOL'
'\x1eON WITH RIGHTWARDS ARROW ABOVE'
'\x03ONE'
'\x04ONE '
'\x08ONE DOT '
'\x0bONE HUNDRED'
'\x10ONE QUARTER SIGN'
'\x0eONE SOUND WAVE'
'\tONE THIRD'
'\x19ONE UNDER EIGHTEEN SYMBOL'
'\x04ONE-'
'\x04ONG '
'\tONG GRAVE'
'\x07ONGONAN'
'\x03ONI'
'\x0cONISHED FACE'
'\x08ONJOINED'
'\x0fONJOINED HINGED'
'\x16ONJOINING MACRON BELOW'
'\tONSONANT '
'\x06ONTACT'
'\x04ONTH'
'\x07ONTIEEN'
'\x02OO'
'\x03OOI'
'\x03OOK'
'\x05OOKED'
'\x11OOKED SCHWA WITH '
'\x03OOL'
'\x06OOPED '
'\x1aOORPLANE SHOULDER HIP MOVE'
'\x02OP'
'\nOP NKAARAE'
'\x15OP SHADED WHITE ARROW'
'\x05OPARD'
'\x04OPEN'
'\x05OPEN '
'\x11OPEN CIRCLE ARROW'
'\x0fOPEN MARK BELOW'
'\nOPEN MOUTH'
'\tOPERATOR '
'\x03OPH'
'\x06OPPER '
'\x02OQ'
'\x03OQ '
'\x0cOQ NSHUT YUM'
'\x05OQPEN'
'\x02OR'
'\x17ORAH WITH NINE BRANCHES'
'\x05ORAIL'
'\x0eORANGE DIAMOND'
'\x04ORAX'
'\rORD SEPARATOR'
'\x03ORE'
'\x08OREHEAD '
'\x07ORGIAN '
'\x06ORNER '
'\x06ORNERS'
'\x04ORNS'
'\x06ORPION'
'\nORTHERN TA'
'\x04ORTY'
'\x02OS'
'\x04OSE '
'\x06OSETTE'
'\x05OSTER'
'\x02OT'
'\nOT MACHINE'
'\x08OT MBUAE'
'\x07OT NGOM'
'\x07OTATION'
'\x0eOTHERS CIRCLED'
'\tOTIFIED E'
'\nOTING STAR'
'\x07OTLESS '
'\x08OTPRINTS'
'\x18OTTOM SHADED WHITE ARROW'
'\x18OTTOM-SHADED WHITE ARROW'
'\x04OTUS'
'\x02OU'
'\x06OUBLE '
'\x0bOUBLE DANDA'
'\x07OUBLE O'
'\x1bOUBLE RIGHT ARROWHEAD ABOVE'
'\x0cOUCHES THUMB'
'\x12OUCHTONE TELEPHONE'
'\rOUGHT BALLOON'
'\x05OUNCE'
'\x0bOUNDED FACE'
'\x03OUR'
'\x0bOUR FINGERS'
'\x15OUR FINGERS CONJOINED'
'\x0cOUR POINTED '
'\x12OUR POINTED BLACK '
'\x10OUR POINTED CUSP'
'\x0cOUR TWELFTHS'
'\x12OUR U VARIANT FORM'
'\x0bOUSEL HORSE'
'\x03OUT'
'\nOUT HANDLE'
'\nOUT INDEX '
'\rOUT MIDDLE UP'
'\tOUT MOUTH'
'\x05OUTH '
'\nOUTHERN TA'
'\x04OVAL'
'\x05OVER '
'$OVER LEFTWARDS TRIANGLE-HEADED ARROW'
'\x16OVER NU11 BUR OVER BUR'
'%OVER RIGHTWARDS TRIANGLE-HEADED ARROW'
'\x08OVER SHE'
'\x07OVERLAY'
'\x02OW'
'\x03OW '
'\x07OW ALEF'
'\x0fOW-FALLING TONE'
'\x03OWD'
'\nOWEL SIGN '
'\x03OWN'
'\rOWN POINTING '
'\x03OX '
'\x02OY'
'\x07OYSTICK'
'%OZENGE CONTAINING BLACK SMALL LOZENGE'
'\x01P'
'\x02P '
'\tP ELAMITE'
'\x07P PIEET'
'\nP STREAMER'
'\x02PA'
'\rPA NJI PIPAEM'
'\x04PACE'
'\x04PAGE'
'\x03PAH'
'\rPAIRED ARROWS'
'\x08PAKPAK E'
'\x0cPALATAL HOOK'
'\x03PAN'
'\x07PANESE '
'\x03PAP'
'\tPAP PLUS '
'\x0cPAP PLUS LU3'
'\x0cPAP PLUS PAP'
'\x15PAP PLUS PAP PLUS LU3'
'\x05PARAQ'
'\x07PARATOR'
'\x08PARATOR '
'\x0cPARENTHESES '
'\x11PARENTHESES ABOVE'
'\x0bPARENTHESIS'
'$PART BETWEEN MIDDLE AND RING FINGERS'
'\x0ePARTMENT STORE'
'\x06PBOARD'
'\x02PE'
'\x0cPE CARTRIDGE'
'\x06PEAKS '
'\x04PEEI'
'\x0ePEN MARK BELOW'
'\tPEN MOUTH'
'\x05PEN O'
'\x07PENNANT'
'\x0fPENSION RAILWAY'
'\x06PEPPER'
'\x03PER'
'\x1fPER RIGHT SHADOWED WHITE CIRCLE'
'\x07PERCLIP'
'\x03PES'
'\x04PEUX'
'\x02PH'
'\x04PHAB'
'\x05PHANT'
'\x05PHONE'
'\x06PHONE '
'\x05PHORA'
'\x02PI'
'\x06PICKET'
'\x07PICTURE'
'\x04PING'
'\rPINWHEEL STAR'
'\x05PIRIT'
'\x07PITULUM'
'\rPLE CRESCENTS'
'\tPLE HEART'
'\x08PLE LEAF'
'\x0ePLE WITH HEART'
'\x04PLET'
'\x05PLHAU'
'\x19PLICATION PROGRAM COMMAND'
'\x04PLUG'
'\x05PLUS '
'\tPLUS SIGN'
'\x05PLUTA'
'\x05PMUNK'
'\x08POINTED '
'\x12POINTED BLACK STAR'
'\tPOINTING '
'\x13POINTING DOWNWARDS '
'\x19POINTING MAGNIFYING GLASS'
'\nPOLICE CAR'
'\x06POMMEE'
'\x0ePOMOFO LETTER '
'\x03POQ'
'\x0cPORT CONTROL'
'\x12POSITION INDICATOR'
'\tPOSITIONS'
'\x0bPOST OFFICE'
'\nPOUND SIGN'
'\x0cPOUTING FACE'
'\x02PP'
'\x0ePPED MIDDLE UP'
'\nPPING BAGS'
'\x08PPY DISK'
'\x1bPPY PERSON RAISING ONE HAND'
'\x08PRESSION'
'\x11PRESSIONLESS FACE'
'\tPROJECTOR'
'\x0ePROTECTED AREA'
'\x02PS'
'\x05PTIC '
'\x04PTY '
'\x02PU'
'\x08PUB DAWB'
'\x06PUFFED'
'\x0bPUNCTUATION'
'\x0cPUNCTUATION '
'\x12PUNCTUATION BINDU '
'\x1dPUNCTUATION CHINOOK FULL STOP'
'#PUNCTUATION SIGN DIAGONAL QUADCOLON'
'\x03PUQ'
'\x07PUSHPIN'
'\x0bPUT MORTUUM'
'\x0fPUT SYMBOL FOR '
'\x06PWATCH'
'\x01Q'
'\x02QA'
'\x03QAF'
'\x12QAF WITH DOT BELOW'
'\x02QE'
'\x04QHAU'
'\x03QIG'
'\x04QOPH'
'\x02QU'
'\x03QUA'
'\x13QUADRUPLE CRESCENTS'
'\x05QUARE'
'\x06QUARE '
'\x0cQUARED ARROW'
'\x07QUARTER'
'\x08QUARTER '
'\x0bQUARTER GUR'
'\rQUARTER MOON '
'\x12QUARTER NOTE STEM '
'\x08QUARTERS'
'\tQUEEN OF '
'\x07QUEEZE '
'\x0bQUERED FLAG'
'\rQUESTION MARK'
'\x16QUESTION MARK ORNAMENT'
'\x03QUI'
'\x01R'
'\tR COASTER'
'\x06R FACE'
'\x07R PLUS '
'\x03R S'
'\x06R WITH'
'\x10R WITH RIGHT LEG'
'\x0eR-OFF CALENDAR'
'\x07R2 GUNU'
'\x02RA'
'\x0bRA SOMPENG '
'\x03RAA'
'\x06RACING'
'\x05RADA '
'\x03RAE'
'\x0cRAFFIC LIGHT'
'\x0eRAGANA LETTER '
'\x03RAH'
'\x04RAIL'
'\x07RAILWAY'
'\x04RAIN'
'\x0bRAISED FLAG'
' RAISED HAND WITH FINGERS SPLAYED'
'\x0eRAISED KNUCKLE'
'\x0fRAISED KNUCKLES'
'!RAISING BOTH HANDS IN CELEBRATION'
'\x04RAL '
'\x04RAMA'
'\x04RAN '
'\nRANG CITI '
'\x0bRANSMISSION'
'\x03RAT'
'\x15RATING SYSTEM COMMAND'
'\x13RATUM SUPER STRATUM'
'\x03RAU'
'\x06RAVEL-'
'\x04RAYS'
'\x05RAYS '
'\x10RAYS AND DOTTED '
'\x02RB'
'\x02RC'
'\x07RCHAIC '
'\x08RCHAIC E'
'\tRCHAIC SA'
'\x07RD DISK'
'\x07RD FACE'
'\nRDHACANDRA'
'\x02RE'
'\tREAK HERE'
'\x0fREAMY EYEBROWS '
'\x16REASE FONT SIZE SYMBOL'
'\x11REATIONAL VEHICLE'
'\x08RECEIVER'
'\nRECIPITATE'
'\x0fRECITATIVE MARK'
'\x08RECT HIT'
'\tRECTANGLE'
'\nRED CIRCLE'
'\tRED JOKER'
'\x0cRED KEYBOARD'
'\x0cRED TRIANGLE'
'\x03REE'
'\x0bREE HUNDRED'
'\x16REE-CIRCLE ALTERNATE I'
'\x13REE-QUARTER CIRCLE '
'\tREFORMED '
'\nREFORMED T'
'\x05REGIA'
'\x03REH'
'\x03REI'
'\x07RELAXED'
'\x15RELICT HOUSE BUILDING'
'\x06REMEDY'
'\x10REPETITION MARK-'
'\x04RESH'
'\x17RETROFLEX HOOK AND BELT'
'\x03REU'
'\x0fREVERSE SOLIDUS'
'\x0cREVERSED TSE'
'\x04RFER'
'\x18RGLASS WITH FLOWING SAND'
'\x03RHO'
'\x02RI'
'\x0cRIAGE RETURN'
'\x07RIANGLE'
'\x06RIBBON'
'\x04RICE'
'\x04RICK'
'\x06RIDENT'
'\tRIED FACE'
'\x05RIEEN'
'\x04RIFY'
'\x05RIGHT'
'\x06RIGHT '
'\x10RIGHT ARROWHEAD '
'\x0bRIGHT GUARD'
'\nRIGHT HALF'
'\x10RIGHT HALF BELOW'
'\x17RIGHT HORIZONTAL SECANT'
'\x1dRIGHT POINTING BACKHAND INDEX'
'\x14RIGHT POINTING INDEX'
'\nRIGHT RING'
' RIGHT SEMICIRCLE WITH THREE DOTS'
'\x1bRIGHT SHADOWED WHITE CIRCLE'
'\x14RIGHT U-SHAPED ARROW'
'+RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHEAD'
'\x16RIGHT-POINTING FLEURON'
'\x17RIGHT-POINTING TRIANGLE'
'\nRIGHTWARDS'
'\x0bRIGHTWARDS '
'\x0fRIGHTWARDS AND '
'\x10RIGHTWARDS ARROW'
'\x16RIGHTWARDS ARROW WITH '
' RIGHTWARDS EQUILATERAL ARROWHEAD'
'\x03RII'
'\x07RILLIC '
'\x08RILLIONS'
'\x03RIM'
'\x06RIN2 X'
'\x04RING'
'\x05RING '
'\nRING ABOVE'
'\x0bRING LITTLE'
'\x15RING LITTLE CONJOINED'
'\x0eRING MEGAPHONE'
'\nRING THUMB'
'\x07RINKLES'
'\tRIPLE DOT'
'\x07RIPPLE '
'\x05RIPT '
'\x04RISE'
'\x0fRISING DIAGONAL'
'\x0bRISING TONE'
'\x12RIST CIRCLE FRONT '
'\x19RIST CIRCLE HITTING WALL '
'\x0cRISTMAS TREE'
'\rRIZONTAL TAIL'
'\x17RK SIDEWAYS NOON GHUNNA'
'\rRK SUNGLASSES'
'\nRKING FACE'
'\x03RKL'
'\x06RLICUE'
'\x03RMT'
'\x02RO'
'\x03RO '
'\x06ROCKET'
'\x07ROITIC '
'\x0cROLLING EYES'
'\x03ROM'
'\x1bRONOMICAL SYMBOL FOR URANUS'
' RONT-TILTED SHADOWED WHITE ARROW'
'\x06ROPLET'
'\x04ROSS'
'\x14ROTATED ARDHAVISARGA'
'\x16ROTATED NINETY DEGREES'
'\x08ROTATION'
'\tROTATION-'
'\nROUNDED ER'
'\x02RR'
'\x03RRA'
'\x05RRED '
'\nRRIS WHEEL'
'\x05RRITO'
'\x04RROW'
'\x11RROW SHAFT WIDTH '
'\x04RRRA'
'\x08RSE DUNG'
'\x06RSENIC'
'\x04RSO-'
'\x02RT'
'\x06RT OF '
'\rRTABLE STEREO'
'\tRTS MEDAL'
'\x03RTY'
'\x02RU'
'\x04RUDA'
'\nRUDIMENTA '
'\x05RULAI'
'\x05RULER'
'\x05RUMP-'
'\x02RY'
'\x07RY FACE'
'\x01S'
'\x02S '
'\x0fS IN SILHOUETTE'
'\x12S INSIDE AND ABOVE'
'\x12S PRESSED TOGETHER'
'\x11S REVOLVING LIGHT'
'\x06S SHOE'
'\x08S SYMBOL'
'\x02SA'
'\x07SA VAH '
'\x03SAA'
'\x03SAD'
'\x03SAH'
'\nSALIZATION'
'\x08SALT OF '
'\x0fSALTER PAHLAVI '
'\x07SALTIRE'
'\x06SANDAL'
'\x07SANDHI '
'\x10SANS-SERIF ARROW'
'\x0bSAPPOINTED '
'\x03SAR'
'\x05SARGA'
'\x03SAU'
'\x02SC'
'\nSCENT MOON'
'\x05SCHWA'
'\x05SCOPE'
'\x08SCRIPT X'
'\x02SE'
'\x03SE '
'\x08SE WEDGE'
'\x06SECANT'
'\x0cSECTION MARK'
'\x0cSECTION SIGN'
'\x04SED '
'\x04SEEV'
'\rSELECTED AREA'
'\nSELINE ESH'
'\tSEPARATOR'
'\nSEPARATOR '
'\x0eSEPARATOR MARK'
'\x12SEPTUPLE CRESCENTS'
'\x13SEQUENCE INTRODUCER'
'\nSEQUENTIAL'
'\x03SET'
'\x12SET OVER BUILDINGS'
'\x02SH'
'\x0bSH PLUS SHU'
'\tSH SYMBOL'
'\x1bSH TIMES GISH CROSSING GISH'
'\x03SH2'
'\x11SH2 CROSSING ESH2'
'\x03SH3'
'\x03SHA'
'\tSHAB CEEB'
'\x06SHADDA'
'\x04SHAE'
'\x07SHAKING'
'\x08SHAN SAW'
'\x17SHAPE WITH A DOT INSIDE'
'\x0bSHE AT LEFT'
'\tSHED FACE'
'\x05SHELL'
'\x11SHELL FLOPPY DISK'
'\x04SHES'
'\rSHESH PLUS KI'
'\x0eSHESHIG TIMES '
'\x11SHESHIG TIMES BAD'
'\x13SHHA WITH DESCENDER'
'\x03SHI'
'\x07SHIFT T'
'\x04SHIM'
'\x04SHIN'
'\nSHMIRI YEH'
'\x06SHORT '
'\x08SHORT ER'
'\x0fSHORT RIGHT LEG'
'\x05SHPIN'
'\rSHTIN TIMES U'
'\x03SHU'
'\x04SHU2'
'\x04SHUL'
'\x02SI'
'\rSIA-AUSTRALIA'
'\x07SIDDHAM'
'\x04SIDE'
'\x05SIDE '
'\x15SIDE TO SIDE SCISSORS'
'\x0eSIDE-DOWN FACE'
'\x04SIGN'
'\x05SIGN '
'\x10SIGN CANDRABINDU'
' SIGN COMBINING CANDRABINDU ABOVE'
'\x11SIGN O WITH CROSS'
'\x0cSIGN SIDDHAM'
'\x07SIGN UD'
'\x0bSIGN VIRAMA'
'\x03SII'
'\x06SINGLE'
'$SINGLE COMMA QUOTATION MARK ORNAMENT'
'\x03SIU'
'\tSIVE FACE'
'\x03SIX'
'\x08SIX DOTS'
'\tSIXTEENTH'
'\nSIXTEENTHS'
'\x13SLANTED NORTH ARROW'
'\x05SMALL'
'\x06SMALL '
'\x0cSMALL DOUBLE'
'\rSMALL LETTER '
'\x1aSMALL LETTER BOHAIRIC KHEI'
'\rSMALL LETTERS'
'\x12SMALL RED TRIANGLE'
'\nSMALL TAH '
'\x0cSMALL TRIPLE'
'\rSMALL V BELOW'
'\x05SMILE'
'\x0cSMILING EYES'
'\x0cSMILING FACE'
'\x0eSMOKING SYMBOL'
'\x04SNOW'
'\tSOFT SIGN'
'\x08SOFTNESS'
'\x05SOLVE'
'\x0eSONAL COMPUTER'
'\x03SOS'
'\x06SOUTH '
'\x07SOV ROG'
'\x02SP'
'\x06SPADES'
'\x06SPAPER'
'\x03SPE'
'\rSPEECH BUBBLE'
'\x0eSPEECH BUBBLES'
'\x0bSPEED TRAIN'
'\x05SPINE'
'\x06SPITAL'
'\x06SPLIT '
'\x0fSPOKED ASTERISK'
'\x06SQUARE'
'\x08SQUARED '
'\x04SQUE'
'\x08SQUEEZED'
'\x02SS'
'\rSSAGE WAITING'
'\x0fSSICAL BUILDING'
'\x04SSOM'
'\x02ST'
'\x03ST '
'\nST PALETTE'
'\x10ST QUARTER MOON '
'\tSTAL BALL'
'\x04STAR'
'\x14STAR WITH MIDDLE DOT'
'\tSTEBASKET'
'\tSTER FACE'
'\x0cSTICKING OUT'
'\x10STICKING OUT FAR'
'\x07STITUTE'
'\x05STNUT'
'\x04STOL'
'\x08STRAIGHT'
'\tSTRAIGHT '
'\x11STRAIGHT MOVEMENT'
'\x10STRAIGHT STRETCH'
'\x13STRAIGHT THUMB BENT'
'\x06STRING'
'\x06STROKE'
'"STRONG CENTRALIZATION STROKE BELOW'
'\x0eSTRONG ISOLATE'
'\x06STROOM'
'\nSTRUCTION '
'\x10STUCK-OUT TONGUE'
'\x02SU'
'\x04SUAB'
'\x04SUCK'
'\x06SUCKED'
'\x05SURYA'
'\x03SUU'
'\x08SWIMMING'
'\tSYLLABLE '
'\nSYLLABLE M'
'\x18SYLLABLE REPETITION MARK'
'\x06SYMBOL'
'\x13SYMBOL FOR BEGINNER'
'\x0bSYMBOL VIDJ'
'\x07SYMBOLS'
'\x01T'
'\x02T '
'\nT AND BOLT'
'\x07T ASHES'
'\x1cT LITTER IN ITS PLACE SYMBOL'
'\x0cT MONGKEUAEQ'
'\x08T NGGEET'
'\x06T NJAQ'
'\x0bT SEPARATOR'
'\x10T TRANSMIT STATE'
'\x07T WITH '
'\x02TA'
'\x0eTA LINK ESCAPE'
'\nTABULATION'
'\x06TAGRAM'
'\x03TAH'
'\x17TAH WITH TWO DOTS ABOVE'
'\nTAI LAING '
'\x10TAI LAING DIGIT '
'\x0fTAI LAING TONE-'
'\x04TAK4'
'\x0eTAKANA LETTER '
'\x03TAN'
'\x06TARGET'
'\x06TATED '
'\x03TAW'
'\x04TAXI'
'\rTE ORDER MARK'
'\x06TE USE'
'\x0cTEARS OF JOY'
'\rTED HAND SIGN'
'\x03TEE'
'\x07TELLITE'
'\x0eTELPIECE CLOCK'
'\x03TEN'
'\x05TENSE'
'\x04TENU'
'\x03TER'
'\x04TERY'
'\x06TEUWEN'
'\x04TEXT'
'\x04TFON'
'\x02TH'
'\tTH GLOBE '
'\nTHDAY CAKE'
'\x0bTHEMATICAL '
'\x0eTHER CHRISTMAS'
'\x15THICK LETTER SELECTOR'
'\x05THIRD'
'\x0cTHLETIC SHOE'
'\x0eTHOUGHT BUBBLE'
'\x08THOUSAND'
'\tTHOUSANDS'
'\x0eTHOUSANDS MARK'
'\x06THREE '
'\nTHREE DISH'
'\x0eTHREE POINTED '
'\x11THREE SOUND WAVES'
'\x0fTHROWING A KISS'
'\x05THUMB'
'\x06THUMB '
'\rTHUMB FORWARD'
'\nTHUMB SIDE'
'\x07THUMBS '
'\x02TI'
'\x06TICAL '
'\nTICAL DISC'
'\x04TICK'
'\x0bTIEE SHEUOQ'
'\x0bTIGHT ACUTE'
'\x13TIGHTLY-CLOSED EYES'
'\x05TILES'
'\x04TILL'
'\x04TILT'
'\x12TILTING FROM WAIST'
'\x06TIMES '
'\tTIMES KUR'
'\x08TIMES UD'
'\x04TIN '
'\x05TING '
'\nTING HEART'
'\x0bTIONAL PARK'
'\x04TIP '
'\x0fTIP ON THE LEFT'
'\x08TIRRUP R'
'\x06TITLO '
'\x03TLE'
'\x06TLESS '
'\x02TO'
'\x06TO BAR'
'\x0fTO-LEFT ISOLATE'
'\x10TO-RIGHT ISOLATE'
'\x03TOM'
'\x04TONE'
'\x05TONE '
'\x06TONGUE'
'\tTOP RIGHT'
'\x12TOP U-SHAPED ARROW'
'\x0cTOP-LIGHTED '
'\x03TOR'
'\x05TORCH'
'\x07TORNADO'
'\x05TORSO'
'\x04TORT'
'\x04TORY'
'\x15TOUCHING INSIDE MOUTH'
'\x13TOUCHTONE TELEPHONE'
'\x03TOV'
'\x08TOWARDS '
'\x02TR'
'\x03TRA'
'\x05TRACK'
'\x0bTRAIGHT WAW'
'\x14TRAILING MCHAN RTAGS'
'\x03TRE'
'\nTREFACTION'
'\tTRETCHED '
'\x03TRI'
'\x0bTRIAN CAMEL'
'\x12TRIANGLE ARROWHEAD'
'!TRIANGLE WITH DOUBLE VERTICAL BAR'
'\x10TRIANGLE-HEADED '
'\x15TRIANGLE-HEADED ARROW'
'!TRIANGLE-HEADED OPEN CIRCLE ARROW'
'\x06TRIKE '
'\x05TRING'
'\x05TRIOL'
'\x06TRIPLE'
'\x07TRIPLE '
'\x10TRIPLE CRESCENTS'
'\x03TRO'
'\x05TROL '
'\x05TSEEB'
'\x02TT'
'\x03TTE'
'\x05TTER '
'\x03TTH'
'\x04TTTA'
'\x02TU'
'\x03TUB'
'\x03TUJ'
'\x06TURBAN'
'\x05TURN '
'\x07TURNED '
'$TURNED COMMA QUOTATION MARK ORNAMENT'
'\x08TURNED M'
'\x13TURNED SECTION MARK'
'\x07TWELFTH'
'\x0fTWELVE POINTED '
'\x03TWO'
'\x08TWO DOTS'
'\tTWO DOTS '
'\x0eTWO ENCLOSURES'
'\x0bTWO FINGERS'
'\nTWO THIRDS'
'\x02TY'
'\x0bTY THOUSAND'
'\x07TYSCAPE'
'\x01U'
'\x02U '
'\nU CIN HAU '
'\x06U MBIT'
'\x13U OVER BU TIMES NA2'
'\x08U TIMES '
'\x05U U U'
'\x07U WITH '
'\x10U WITH LEFT HOOK'
'\x07U-BRJGU'
'\x12U-SHAPED ORNAMENTS'
'\x04U11 '
'\x03U2 '
'\x08U2 PLUS '
'\nU2 PLUS BA'
'\x02U3'
'\x03UAE'
'\x04UAEM'
'\x04UAEN'
'\x04UAEP'
'\x06UAEQTU'
'\x04UAET'
'\x03UAM'
'\nUAM TSHOOJ'
'\x02UB'
'\x03UB '
'\x0eUBJOINED SIGN '
'\x04UBLE'
'\x08UBLE DOT'
'\x13UBLE DOT WITHIN DOT'
'\x17UBLE VERTICAL BAR BELOW'
'\x0cUBLE-STRUCK '
'\x16UBSCRIPT SMALL LETTER '
'\x11UCASIAN ALBANIAN '
'\x04UCH '
'\x06UCIBLE'
'\x02UD'
'\x08UD WITH '
'\x08UDAWADI '
'\x0fUDIO MICROPHONE'
'\x10UDLY CRYING FACE'
'\x02UE'
'\x03UE '
'\tUE MAEMBA'
'\rUE OF LIBERTY'
'\x03UEQ'
'\tUG TIMES '
'\x04UGU '
'\x02UH'
'\x0cUH PLUS GISH'
'\x02UI'
'\x04UIRY'
'\x0bUISHED FACE'
'\x08UKEUTNDA'
'\x02UL'
'\x05ULAR '
'\x07ULATION'
'\x03ULL'
'\tULL MOON '
'\x08ULL STOP'
'\x02UM'
'\tUM TIMES '
'\x08UMBRELLA'
'\x05UMBS '
'\x05UMPET'
'\x02UN'
'\x07UN MEUT'
'\x04UND '
'\x05UNDER'
'\x06UNDER '
'\x03UNG'
'\x06UNGAAM'
'\x05UNGBA'
'\tUNGLASSES'
'\x02UO'
'\x03UOM'
'\x03UOQ'
'\x02UP'
'\x03UP '
'\x10UP MIDDLE HINGED'
'\nUP NEUTRAL'
'\nUP OR DOWN'
'\x1aUP POINTING BACKHAND INDEX'
'\x11UP POINTING INDEX'
'\x0cUP SEPARATOR'
'\x07UP SIGN'
'\x17UP SPREAD THUMB FORWARD'
'\x07UP STEP'
'\rUP TACK ABOVE'
'\x18UP WITH EXCLAMATION MARK'
'\x14UP-POINTING TRIANGLE'
'\x0bUPADHMANIYA'
'\x08UPLOYAN '
'\x05UPPED'
'\x0eUPPED INDEX UP'
'"UPPER BODY TILTING FROM HIP JOINTS'
'\x10UPPER OVER LOWER'
'\x07UPWARDS'
'\x08UPWARDS '
'\x0cUPWARDS AND '
'\rUPWARDS ARROW'
'\x13UPWARDS ARROW WITH '
'\rUPWARDS TREND'
'\x02UQ'
'\x03UQA'
'\x05UQUET'
'\x02UR'
'\x03UR '
'\nUR HUNDRED'
'\x06UR OF '
'\x07URFACE '
'\x05URINE'
'\nURIPIGMENT'
'\x03URL'
'\x06URNAMA'
'\x11URNED DAMMA BELOW'
'\x08UROPEAN '
'\x04URVE'
'\x05URVE '
'\x05URVED'
'\x06URVED '
'\x02US'
'\x07US TENT'
'\tUSED FACE'
'\x03USH'
'\x04USH '
'\nUSHED FACE'
'\x07USHENNA'
'\x06USHPIN'
'\x02UT'
'\x04UTAE'
'\nUTBOX TRAY'
'\x05UTEUX'
'\x04UTH '
'\nUTH OR SPY'
'\x0bUTING WHALE'
'\tUTRA MARK'
'\nUTRAL FACE'
'\x04UTTY'
'\x02UU'
'\x02UX'
'\x01V'
'\x07V WITH '
'\x02VA'
'\x07VAGRAHA'
'\x03VAH'
'\x07VAPOURS'
'\x07VARIANT'
'\x03VAU'
'\x02VD'
'\x02VE'
'\x03VE '
'\nVE HUNDRED'
'\x0bVE OF PEACE'
'\tVE THUMB '
'\x07VED ICE'
'\x03VEE'
'\nVEL SLIDER'
'\x0cVELOPE WITH '
'\x07VEMENT-'
'\x0eVENIENCE STORE'
'\rVERGREEN TREE'
'\x06VERLAP'
'\x10VERTED PENTAGRAM'
'\x08VERTICAL'
'\x0cVERTICAL BAR'
'\x0fVERTICAL SECANT'
'\x0fVERTICAL STROKE'
'\x0bVERTICALLY '
'\x15VERY HEAVY BARB ARROW'
'\x10VERY HEAVY SHAFT'
'\x0bVERY SMALL '
'\x12VERY SMALL DIAMOND'
'\x11VERY SMALL SQUARE'
'\x03VEU'
'\tVEUAENGAM'
'\x04VEUM'
'\x04VEUX'
'\x04VEYZ'
'\x02VI'
'\x0cVICTORY HAND'
'\nVIE CAMERA'
'\tVINE LEAF'
'\x05VING '
'\x06VIRAMA'
'\x07VISARGA'
'\x06VISION'
'\x05VITAE'
'\x04VIYO'
'\x02VO'
'\x08VOCALIC '
'\tVOCALIC R'
'\x11VOCALIZATION MARK'
'\x07VOICING'
'\x08VOLAPUK '
'\x03VOP'
'\x04VOS '
'\x06VOWEL '
'\x07VOWEL K'
'\x11VOWEL LENGTH MARK'
'\x0bVOWEL SIGN '
'\x02VS'
'\x02VU'
'\x04VUEQ'
'\x03VY '
'\x01W'
'\x08W PRINTS'
'\x0cW RIGHT RING'
'\x02WA'
'\x03WAA'
'\x04WAEN'
'\x04WAET'
'\nWALLPLANE '
'\x1bWALLPLANE SHOULDER HIP MOVE'
'\x0fWALLPLANE SPACE'
'\x06WARDS '
'&WARDS AND LEFTWARDS OPEN CIRCLE ARROWS'
'\x1bWARDS EQUILATERAL ARROWHEAD'
'\x04WAVE'
'\x10WAVY HAMZA BELOW'
'\x03WAW'
'\x13WAW WITH DOT WITHIN'
'\rWAW-AYIN-RESH'
'\x03WAY'
'\x02WB'
'\x06WBERRY'
'\x05WBOAT'
'\x02WC'
'\x04WDER'
'\x0bWE PALAUNG '
'\x18WELVE POINTED BLACK STAR'
'\x05WENTY'
'\x03WER'
'\x11WER PLAYING CARDS'
'\x05WEST '
'\x0eWEST POINTING '
'\x12WEST POINTING LEAF'
'\x05WFISH'
'\x06WHITE '
'\x0cWHITE ARROW '
'%WHITE ARROW WITHIN TRIANGLE ARROWHEAD'
'\nWHITE FLAG'
'\x17WHITE FOUR POINTED CUSP'
'\x0bWHITE JOKER'
'\x0cWHITE SQUARE'
'\nWHOLE NOTE'
'\x02WI'
'\x04WIDE'
'\x05WIDTH'
'\x11WIGGLY LINE BELOW'
'\x06WINDOW'
'\nWING HEART'
'\tWING STAR'
'\x04WINK'
'\x0bWINKING EYE'
'\x05WISE '
'\x04WITH'
'\x05WITH '
'\x06WITH C'
'\x08WITH DOT'
'\tWITH FACE'
'\x0bWITH GARDEN'
'\x12WITH JUSTIFICATION'
'\x1aWITH LEFTWARDS ARROW ABOVE'
'\x1dWITH RIGHTWARDS ARROW AT LEFT'
'\nWITH SERIF'
'\x10WITH SMALL CLOUD'
'\x18WITH UPWARDS ARROW ABOVE'
'\nWITH WINGS'
'\x19WITHIN TRIANGLE ARROWHEAD'
'\x02WJ'
'\x02WM'
'\x02WN'
'\x1aWNING FACE WITH OPEN MOUTH'
'\rWNWARDS ARROW'
'\x13WNWARDS ARROW WITH '
'\x02WO'
'\x08WO DOTS '
'\nWO FINGERS'
'\x06WO OF '
'\x0bWO TWELFTHS'
'\x15WO-CIRCLE ALTERNATE I'
'(WO-HEADED ARROW WITH TRIANGLE ARROWHEADS'
'\x05WOMAN'
'\x13WOMEN HOLDING HANDS'
'\x03WOQ'
'\x14WORD REPETITION MARK'
'\x0eWORD SEPARATOR'
'\x04WORK'
'\x06WORKER'
'\x08WRINKLED'
'\tWRINKLES '
'\nWRIST FLEX'
'\x08WRITING '
'\x0cWRITING HAND'
'\tWRY SMILE'
'\x02WU'
'\x05WUAET'
'\x01X'
'\x02X '
'\nX POINTED '
'\x07X WITH '
'\tX WITH LO'
'\tX-X BELOW'
'\x02XA'
'\x03XAU'
'\tXCITEMENT'
'\x02XE'
'\x04XEYN'
'\nXHEEJ CEEV'
'\x02XI'
'\x06XIMIZE'
'\x05XING '
'\x07XOPHONE'
'\x07XT LINE'
'\x15XTRA SHORT VOWEL MARK'
'\x03XWV'
'\x05XYOOJ'
'\x01Y'
'\x02Y '
'\nY AND RICE'
'\tY BLOSSOM'
'\x06Y FACE'
'\x08Y POPPER'
'\nY THOUSAND'
'\x16Y WITH SHORT RIGHT LEG'
'\x02YA'
'\x03YAA'
'\x03YAH'
'\x03YAI'
'\x03YAN'
'\x07YANMAR '
'\x07YANSAYA'
'\x03YAU'
'\x04YAWN'
'\x03YAY'
'\x02YE'
'\x03YEE'
'\x03YEH'
'\x1aYEH WITH HAMZA ABOVE WITH '
'\x1cYEH WITH TWO DOTS BELOW AND '
'\x08YEN SIGN'
'\x04YEUX'
'\x02YI'
'\x03YI '
'\x03YIN'
'\nYING CARD '
'\rYING ENVELOPE'
'\x10YIR MKPARAQ MEUN'
'\x03YIT'
'\x06YMBOL '
'\x0cYMBOL BINDU '
'\rYMBOL KIEVAN '
'\rYMBOL TAU RHO'
'\x08YMBOL VI'
'\x02YN'
'\x07YNAMIC '
'\x02YO'
'\x04YODH'
'\x06YRENE '
'\x08YRILLIC '
'\x02YU'
'\x01Z'
'\x02ZA'
'\x03ZAH'
'\x1aZAIN WITH INVERTED V ABOVE'
'\x0eZAKAYA LANTERN'
'2ZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA VASIS'
'\x04ZATA'
'\x05ZAYIN'
'\x04ZAYN'
'\x04ZEN '
'\x04ZERO'
'\x07ZIGZAG '
'\x0cZIGZAG ARROW'
'\x04ZIZ2'
'\x02ZO'
'\nZU OVER ZU'
'\x08ZWJ THAJ'
'\x02ZY'
'\x03ZZA'
'\x04ZZHE'
'\x04ZZY '
)
_charnodes =[67203,
 -38929,
 -1,
 132262,
 14312,
 983080,
 197597,
 78541,
 -1,
 263132,
 164125,
 -1,
 328058,
 209788,
 -1,
 393581,
 265801,
 -1,
 459116,
 348078,
 -1,
 524501,
 404779,
 -1,
 590001,
 474778,
 121091,
 720895,
 524288,
 -1,
 721000,
 605016,
 120832,
 851967,
 655360,
 -1,
 852026,
 740673,
 120846,
 983039,
 786432,
 -1,
 983073,
 858699,
 -1,
 1048605,
 939513,
 120853,
 1179647,
 983040,
 -1,
 1179671,
 1077757,
 -1,
 1245206,
 1141553,
 120877,
 1376255,
 1179648,
 -1,
 -65515,
 1253046,
 120878,
 -1,
 1316664,
 120879,
 -1,
 1191817,
 120884,
 1572889,
 1128019,
 120857,
 -1,
 1508589,
 120882,
 1703963,
 1515758,
 120856,
 -1,
 1639627,
 120885,
 -65508,
 1658192,
 120855,
 -1,
 1784677,
 120854,
 2031615,
 1009403,
 -1,
 2031648,
 1910686,
 120858,
 -1,
 1967341,
 120883,
 -1,
 1966706,
 121001,
 2228269,
 946679,
 120862,
 2359295,
 2162688,
 -1,
 2359335,
 2234955,
 -1,
 -65499,
 2324747,
 120872,
 -65498,
 2381314,
 120893,
 -1,
 2440698,
 120873,
 2621482,
 2306940,
 -1,
 -65495,
 2578002,
 120874,
 -1,
 2636975,
 120875,
 2818092,
 2560675,
 120895,
 -1,
 2753352,
 120894,
 -1,
 2758456,
 120866,
 3014707,
 2187246,
 -1,
 3080242,
 2964464,
 120966,
 3211263,
 3014656,
 -1,
 -65487,
 3088054,
 120972,
 -1,
 3151672,
 120971,
 -1,
 3018976,
 120849,
 3407925,
 2963027,
 120850,
 -1,
 3343472,
 120867,
 3538999,
 3348280,
 120848,
 -1,
 3474681,
 120865,
 -65480,
 3504282,
 120871,
 -65479,
 3632806,
 120864,
 -1,
 3688619,
 120996,
 3866713,
 815613,
 -1,
 3932229,
 3828529,
 121052,
 4063231,
 3866624,
 -1,
 4063297,
 3961341,
 -1,
 -65473,
 4006718,
 121054,
 -65472,
 4071094,
 121055,
 -1,
 4134712,
 121056,
 4325444,
 4012894,
 -1,
 -65469,
 4273734,
 121059,
 -1,
 4331320,
 121057,
 -1,
 4266332,
 121058,
 4587599,
 3873355,
 -1,
 4653133,
 4552122,
 -1,
 4718668,
 4612078,
 -1,
 4784203,
 4684538,
 -1,
 -65462,
 4749303,
 121066,
 -1,
 4799732,
 121064,
 -1,
 4736969,
 121063,
 -1,
 4677069,
 120887,
 5177343,
 4603363,
 121067,
 -1,
 5054854,
 120892,
 5242963,
 4535988,
 121062,
 5373951,
 5187515,
 -1,
 -65454,
 5273642,
 120881,
 -1,
 5322323,
 120899,
 5505110,
 5189521,
 -1,
 -65451,
 5467760,
 121060,
 -1,
 5510968,
 121061,
 5767167,
 5444266,
 -1,
 -65448,
 5658978,
 120890,
 -1,
 5716755,
 120891,
 5898334,
 3814995,
 120843,
 6029311,
 5832704,
 -1,
 6029405,
 5918139,
 120852,
 -1,
 5965037,
 120870,
 -1,
 5982593,
 120844,
 6226018,
 5863473,
 120851,
 6356991,
 6161603,
 -1,
 -65439,
 6253361,
 120868,
 -1,
 6299318,
 120869,
 6488165,
 6184942,
 -1,
 -65436,
 6437967,
 121018,
 -1,
 6492370,
 120841,
 6684775,
 6428472,
 120838,
 -1,
 6619981,
 120861,
 -1,
 6627566,
 120842,
 6881407,
 684535,
 121077,
 7012351,
 6815744,
 -1,
 7012465,
 6911997,
 -1,
 7077998,
 6975393,
 -1,
 -65427,
 7045204,
 121086,
 -1,
 7092024,
 121088,
 -65425,
 7030970,
 120979,
 -65424,
 7224165,
 120840,
 -1,
 7286775,
 121089,
 7471222,
 6952822,
 -1,
 7536756,
 7420784,
 121083,
 -1,
 7472265,
 120876,
 -65419,
 7497099,
 121085,
 -1,
 7621980,
 121084,
 7798906,
 7433014,
 -1,
 -65416,
 7742270,
 121079,
 -65415,
 7806646,
 121080,
 -1,
 7870264,
 121081,
 8061053,
 7756176,
 -1,
 -65412,
 8025484,
 121087,
 -1,
 8073271,
 121090,
 -65410,
 8009097,
 121078,
 -1,
 8204169,
 121082,
 8388757,
 6835528,
 -1,
 8454285,
 8352253,
 -1,
 8519814,
 8395339,
 -1,
 8585349,
 8470017,
 -1,
 -65404,
 8550442,
 120888,
 -1,
 8599123,
 120889,
 -1,
 8550673,
 120886,
 8847499,
 8458922,
 -1,
 8913034,
 8804695,
 -1,
 -65399,
 8878122,
 120896,
 -1,
 8921184,
 120897,
 -1,
 8862677,
 120898,
 -65396,
 8800427,
 121035,
 -1,
 9123513,
 120880,
 9306255,
 8419370,
 121030,
 -1,
 9241837,
 121033,
 9437330,
 9265134,
 -1,
 -65391,
 9387087,
 121037,
 -1,
 9441490,
 121032,
 -65389,
 9390251,
 121036,
 -65388,
 9577743,
 121028,
 -1,
 9639741,
 120860,
 9830564,
 8341682,
 -1,
 9896092,
 9774351,
 120974,
 10027007,
 9830400,
 -1,
 10027163,
 9922009,
 -1,
 -65382,
 9989744,
 120975,
 -1,
 10035494,
 120976,
 -1,
 9983967,
 120977,
 10289311,
 9858977,
 -1,
 -65378,
 10246277,
 120985,
 -1,
 10303398,
 120986,
 10485921,
 10238808,
 120992,
 -1,
 10421436,
 120988,
 -65374,
 10450986,
 120978,
 -65373,
 10576063,
 120983,
 -1,
 10622776,
 120984,
 10813615,
 9790842,
 -1,
 10879145,
 10767681,
 121012,
 11010047,
 10813440,
 -1,
 -65368,
 10903758,
 121014,
 -1,
 10952374,
 121013,
 -65366,
 10844202,
 121006,
 -65365,
 11104759,
 121016,
 -65364,
 11165887,
 121007,
 -65363,
 11225259,
 121008,
 -65362,
 11287384,
 121015,
 -1,
 11347215,
 121003,
 -65360,
 10761609,
 121092,
 -1,
 11481115,
 120906,
 11730943,
 541670,
 120922,
 11796479,
 11599872,
 -1,
 11796675,
 11676971,
 -1,
 11862205,
 11747082,
 120908,
 11993087,
 11796480,
 -1,
 11993274,
 11875923,
 120919,
 12124159,
 11927552,
 -1,
 -65351,
 12022290,
 120920,
 -1,
 12079501,
 120921,
 -65349,
 11956740,
 120914,
 -65348,
 12201922,
 120910,
 -1,
 12261176,
 120912,
 12517375,
 11819209,
 120900,
 12582911,
 12386304,
 -1,
 12583105,
 12459702,
 120903,
 -1,
 12518505,
 120904,
 -65342,
 12531283,
 120902,
 -1,
 12654392,
 120901,
 12845257,
 11758985,
 -1,
 12910791,
 12786643,
 120930,
 13041663,
 12846317,
 120931,
 -1,
 12910823,
 120932,
 -65336,
 12863659,
 120933,
 -1,
 13056964,
 120929,
 13238480,
 12793225,
 120924,
 13369343,
 13172736,
 -1,
 13369551,
 13250212,
 120909,
 13500415,
 13303808,
 -1,
 -65330,
 13381570,
 120911,
 -1,
 13440824,
 120913,
 -1,
 13333010,
 120926,
 13697236,
 13201917,
 -1,
 -65326,
 13658929,
 120925,
 -65325,
 13709193,
 120928,
 -1,
 13768504,
 120927,
 -1,
 13637536,
 120923,
 14024977,
 465483,
 -1,
 14090480,
 13989306,
 -1,
 14156011,
 14047870,
 120941,
 14286847,
 14090240,
 -1,
 14287071,
 14177978,
 120940,
 14417919,
 14221312,
 -1,
 14418142,
 14316029,
 -1,
 -65315,
 14379825,
 120942,
 -1,
 14430089,
 120946,
 -1,
 14373261,
 120944,
 14680292,
 14236504,
 120834,
 14811135,
 14614528,
 -1,
 14811363,
 14709239,
 121068,
 -1,
 14746421,
 121069,
 -1,
 14771595,
 121024,
 15007975,
 14643709,
 -1,
 -65306,
 14969649,
 120943,
 -1,
 15019913,
 120947,
 15204585,
 14954148,
 120915,
 -1,
 15139637,
 120916,
 -65302,
 15159693,
 120945,
 -1,
 15289704,
 121040,
 15532031,
 14116485,
 120949,
 15597567,
 15400960,
 -1,
 -65298,
 15488698,
 120948,
 -65297,
 15551896,
 121039,
 -1,
 15612816,
 121020,
 15794439,
 14040547,
 120950,
 15925247,
 15728640,
 -1,
 15925503,
 15809368,
 120833,
 16056319,
 15859712,
 -1,
 16056572,
 15945025,
 120847,
 16187391,
 15990784,
 -1,
 16187641,
 16064578,
 -1,
 -65288,
 16131998,
 120859,
 -1,
 16188018,
 121002,
 -65286,
 16151031,
 120863,
 -65285,
 16344437,
 120967,
 -1,
 16402603,
 120997,
 -65283,
 16016779,
 121019,
 -65282,
 16528966,
 120845,
 -1,
 16586552,
 120839,
 16777475,
 15879496,
 -1,
 16843010,
 16737675,
 121038,
 -1,
 16777447,
 121045,
 -1,
 16807978,
 121031,
 17039622,
 16730290,
 -1,
 -65275,
 17004586,
 120980,
 -1,
 17054552,
 120993,
 -1,
 16999819,
 121009,
 17367039,
 15746077,
 120934,
 17432575,
 17235968,
 -1,
 17432844,
 17330685,
 -1,
 -65269,
 17394481,
 120935,
 -1,
 17444745,
 120937,
 17629454,
 17386875,
 121046,
 -1,
 17564744,
 121047,
 -65265,
 17584525,
 120936,
 -65264,
 17709989,
 121065,
 -1,
 17772548,
 120905,
 17957193,
 13972348,
 -1,
 18022715,
 17906858,
 120957,
 18153471,
 17956864,
 -1,
 18153763,
 18037592,
 120836,
 18284543,
 18087936,
 -1,
 18284829,
 18182647,
 121072,
 18415615,
 18219008,
 -1,
 18415899,
 18311151,
 -1,
 -65254,
 18369320,
 121073,
 -1,
 18430252,
 121053,
 -65252,
 18372282,
 121070,
 -1,
 18563949,
 121071,
 18743585,
 18238792,
 -1,
 18809120,
 18703733,
 120968,
 -1,
 18743668,
 120973,
 -1,
 18761899,
 120998,
 -65246,
 18703755,
 121025,
 -1,
 18953811,
 121051,
 19136809,
 18110138,
 120955,
 19267583,
 19070976,
 -1,
 19267880,
 19165693,
 -1,
 -65241,
 19229489,
 120959,
 -1,
 19279753,
 120956,
 -1,
 19222925,
 120961,
 19530030,
 19089579,
 120970,
 19660799,
 19464192,
 -1,
 19661101,
 19544920,
 120994,
 -1,
 19596476,
 120989,
 -1,
 19624439,
 120987,
 19857714,
 19493373,
 -1,
 19923249,
 19819313,
 120960,
 -1,
 19858751,
 120963,
 -1,
 19863436,
 120964,
 20119860,
 19817845,
 120999,
 -1,
 20054450,
 121004,
 20250934,
 20073793,
 121029,
 -1,
 20186139,
 121041,
 20382009,
 20196651,
 -1,
 -65224,
 20338901,
 120907,
 -1,
 20397853,
 120917,
 -65222,
 20343877,
 120958,
 -1,
 20533645,
 120962,
 20774911,
 17978958,
 120939,
 20840447,
 20643840,
 -1,
 20840771,
 20729160,
 -1,
 20906306,
 20800919,
 121050,
 21037055,
 20840448,
 -1,
 -65215,
 20928840,
 121048,
 -1,
 20986612,
 121049,
 -1,
 20869623,
 121034,
 21233991,
 20790141,
 -1,
 -65211,
 21198839,
 121023,
 -65210,
 21256520,
 121021,
 -1,
 21314292,
 121022,
 -65208,
 21194172,
 121017,
 -1,
 21438709,
 120938,
 21627234,
 17896093,
 120965,
 21757951,
 21561344,
 -1,
 21758294,
 21642072,
 120837,
 21889023,
 21692416,
 -1,
 21889361,
 21787127,
 121076,
 22020095,
 21823488,
 -1,
 -65200,
 21911880,
 121074,
 -1,
 21969652,
 121075,
 22151507,
 21849483,
 121027,
 -1,
 22086472,
 121026,
 22347775,
 22105416,
 -1,
 -65195,
 22242677,
 120969,
 -1,
 22300843,
 121000,
 22479195,
 21711026,
 -1,
 22544730,
 22428504,
 120995,
 22675455,
 22480090,
 120991,
 -1,
 22545224,
 120990,
 -1,
 22509610,
 120982,
 22806879,
 22433128,
 121044,
 22937599,
 22740992,
 -1,
 -65186,
 22829384,
 121042,
 -1,
 22887156,
 121043,
 23134207,
 22766970,
 -1,
 -65183,
 23021739,
 121011,
 -1,
 23078170,
 121005,
 23330815,
 21584267,
 120951,
 23396351,
 23199744,
 -1,
 23396711,
 23294461,
 -1,
 -65178,
 23358257,
 120952,
 -1,
 23408521,
 120954,
 -65176,
 23356811,
 121010,
 -65175,
 23548301,
 120953,
 -65174,
 23611578,
 120981,
 -65173,
 23673688,
 120835,
 -1,
 23735972,
 120918,
 -1,
 409040,
 121451,
 24051711,
 337651,
 121343,
 24117247,
 23920640,
 -1,
 24117625,
 24006260,
 -1,
 24183160,
 24053610,
 -1,
 24248693,
 24149263,
 -1,
 -65165,
 24212086,
 121346,
 -65164,
 24276592,
 121345,
 -1,
 24322329,
 121348,
 24575999,
 24194817,
 -1,
 -65161,
 24473200,
 121347,
 -1,
 24518937,
 121349,
 -1,
 24117612,
 121350,
 -1,
 24077674,
 121344,
 24838836,
 282136,
 -1,
 24904334,
 24804136,
 -1,
 24969717,
 24870159,
 -1,
 25035168,
 24910411,
 -1,
 25100694,
 25000455,
 -1,
 25166227,
 25034752,
 -1,
 25231753,
 25113468,
 -1,
 25297286,
 25170267,
 -1,
 25362820,
 25248621,
 121230,
 -1,
 25325028,
 121231,
 -65147,
 25324613,
 121228,
 -1,
 25447457,
 121229,
 25690111,
 25247481,
 -1,
 -65144,
 25571470,
 121254,
 -1,
 25631911,
 121261,
 25821582,
 25190248,
 -1,
 25887116,
 25772909,
 121226,
 -1,
 25849316,
 121227,
 -65139,
 25848901,
 121224,
 -1,
 25971745,
 121225,
 26214399,
 25784615,
 -1,
 26214802,
 26108554,
 -1,
 -65135,
 26176581,
 121232,
 -1,
 26233889,
 121233,
 -1,
 26159468,
 121247,
 26542079,
 25108861,
 -1,
 -65131,
 26438725,
 121248,
 -1,
 26496033,
 121249,
 26673563,
 25057145,
 -1,
 -65128,
 26635333,
 121147,
 -65127,
 26699564,
 121150,
 -65126,
 26758177,
 121148,
 -1,
 26821485,
 121149,
 27001247,
 26621303,
 -1,
 -65123,
 26963013,
 121151,
 -65122,
 27020321,
 121152,
 -1,
 27083629,
 121153,
 -1,
 26961659,
 121139,
 27328949,
 25001190,
 -1,
 27394482,
 27268563,
 -1,
 27460011,
 27336991,
 -1,
 27525543,
 27423917,
 -1,
 -65115,
 27487301,
 121244,
 -65114,
 27544609,
 121245,
 -1,
 27607917,
 121246,
 27852799,
 27468881,
 -1,
 -65111,
 27749445,
 121241,
 -65110,
 27806753,
 121242,
 -1,
 27870061,
 121243,
 28049839,
 27403089,
 -1,
 -65107,
 28011589,
 121268,
 -65106,
 28068897,
 121269,
 -1,
 28132205,
 121270,
 28377087,
 27997820,
 -1,
 -65103,
 28258446,
 121257,
 -1,
 28318887,
 121264,
 28573695,
 27354632,
 -1,
 -65100,
 28470229,
 121325,
 -1,
 28517450,
 121326,
 28705214,
 27289583,
 -1,
 28770749,
 28654790,
 -1,
 28836284,
 28733049,
 -1,
 28901818,
 28787565,
 121132,
 -1,
 28863972,
 121133,
 -65093,
 28863557,
 121130,
 -1,
 28986401,
 121131,
 -1,
 28803346,
 121134,
 -1,
 28718036,
 121253,
 29295046,
 28658032,
 -1,
 29360577,
 29256773,
 121237,
 -1,
 29295018,
 121240,
 29491652,
 29308540,
 -1,
 -65085,
 29438094,
 121256,
 -1,
 29498535,
 121263,
 -65083,
 29445153,
 121238,
 -1,
 29639533,
 121239,
 29819343,
 29234717,
 -1,
 29884875,
 29776457,
 -1,
 -65079,
 29846597,
 121154,
 -65078,
 29903905,
 121155,
 -1,
 29967213,
 121156,
 30212095,
 29829548,
 -1,
 -65075,
 30108741,
 121144,
 -65074,
 30166049,
 121145,
 -1,
 30229357,
 121146,
 30409174,
 29767595,
 -1,
 30474707,
 30357116,
 -1,
 -65070,
 30421134,
 121255,
 -1,
 30481575,
 121262,
 -65068,
 30436421,
 121234,
 -65067,
 30624801,
 121235,
 -1,
 30688109,
 121236,
 30867931,
 30373037,
 -1,
 30933465,
 30806411,
 121142,
 -1,
 30869333,
 121143,
 -65062,
 30900498,
 121141,
 -1,
 31026819,
 121140,
 31195616,
 30811217,
 -1,
 31261150,
 31134091,
 121137,
 -1,
 31197013,
 121138,
 -65057,
 31228178,
 121136,
 -1,
 31354480,
 121135,
 31523303,
 31134666,
 -1,
 31588836,
 31485003,
 -1,
 -65053,
 31550421,
 121315,
 -1,
 31597642,
 121317,
 31850495,
 31542312,
 -1,
 -65050,
 31747029,
 121316,
 -1,
 31794250,
 121318,
 31982059,
 31491003,
 -1,
 -65047,
 31943749,
 121157,
 -65046,
 32001057,
 121158,
 -1,
 32064365,
 121159,
 32244207,
 31939514,
 -1,
 -65043,
 32205893,
 121160,
 -65042,
 32263201,
 121161,
 -1,
 32326509,
 121162,
 32506356,
 32190030,
 -1,
 32571891,
 32456219,
 -1,
 -65038,
 32533461,
 121329,
 -1,
 32580682,
 121330,
 -1,
 32527923,
 121128,
 -1,
 32456751,
 121448,
 32899693,
 24915713,
 -1,
 32965130,
 32840267,
 -1,
 33030660,
 32930316,
 -1,
 33096191,
 32978556,
 -1,
 33161724,
 33042170,
 -1,
 -65029,
 33123397,
 121286,
 -1,
 33178477,
 121287,
 33423359,
 33102790,
 -1,
 -65026,
 33320005,
 121271,
 -1,
 33375085,
 121272,
 33554945,
 33047405,
 121303,
 -1,
 33517028,
 121304,
 -65022,
 33516613,
 121301,
 -65021,
 33639457,
 121302,
 -1,
 33693258,
 121305,
 33882632,
 32987001,
 -1,
 -65018,
 33844293,
 121204,
 -65017,
 33901601,
 121205,
 -1,
 33964909,
 121206,
 -65015,
 33842939,
 121198,
 -1,
 34092402,
 121207,
 34275866,
 32931046,
 -1,
 34341399,
 34215379,
 -1,
 34406931,
 34289276,
 -1,
 34472464,
 34352890,
 -1,
 -65009,
 34434117,
 121296,
 -1,
 34489197,
 121297,
 34734079,
 34413510,
 -1,
 -65006,
 34630725,
 121281,
 -1,
 34685805,
 121282,
 34865686,
 34367471,
 -1,
 -65003,
 34819962,
 121308,
 -1,
 34884392,
 121309,
 -1,
 34816877,
 121310,
 35192831,
 34301467,
 -1,
 -64999,
 35089365,
 121327,
 -1,
 35136586,
 121328,
 35324459,
 34228592,
 -1,
 35389994,
 35272316,
 -1,
 35455523,
 35335930,
 -1,
 35521056,
 35417163,
 -1,
 -64993,
 35482581,
 121292,
 -1,
 35529802,
 121294,
 35782655,
 35472243,
 -1,
 -64990,
 35679189,
 121293,
 -1,
 35726410,
 121295,
 35979263,
 35396550,
 -1,
 35979815,
 35875915,
 -1,
 -64986,
 35941333,
 121277,
 -1,
 35988554,
 121279,
 36241407,
 35930995,
 -1,
 -64983,
 36137941,
 121278,
 -1,
 36185162,
 121280,
 -1,
 35351621,
 121307,
 36438587,
 35272619,
 -1,
 36504122,
 36386428,
 -1,
 36569651,
 36450042,
 -1,
 36635185,
 36533421,
 -1,
 -64976,
 36596916,
 121290,
 -1,
 36651964,
 121291,
 -64974,
 36596818,
 121288,
 -1,
 36782970,
 121289,
 37027839,
 36510662,
 -1,
 37028407,
 36924491,
 -1,
 -64970,
 36992166,
 121275,
 -1,
 37037130,
 121273,
 37289983,
 36979571,
 -1,
 -64967,
 37188774,
 121276,
 -1,
 37233738,
 121274,
 -1,
 36465733,
 121306,
 37487172,
 36399087,
 -1,
 37552707,
 37436614,
 -1,
 37618242,
 37514873,
 -1,
 37683776,
 37569389,
 121191,
 -1,
 37645796,
 121192,
 -64959,
 37645381,
 121189,
 -1,
 37768225,
 121190,
 -1,
 37585170,
 121193,
 -1,
 37499867,
 121314,
 38077006,
 37426134,
 -1,
 38142536,
 38038603,
 -1,
 -64953,
 38104021,
 121319,
 -1,
 38151242,
 121322,
 38339147,
 38095912,
 -1,
 -64950,
 38300629,
 121320,
 -1,
 38347850,
 121323,
 38600703,
 38290291,
 -1,
 -64947,
 38497237,
 121321,
 -1,
 38544458,
 121324,
 38732372,
 38040749,
 -1,
 38797906,
 38670743,
 -1,
 -64943,
 38764818,
 121202,
 -1,
 38817396,
 121201,
 -64941,
 38764818,
 121200,
 -1,
 38956675,
 121199,
 39125593,
 38675537,
 -1,
 39191127,
 39063947,
 121196,
 -1,
 39126869,
 121197,
 -64936,
 39158034,
 121195,
 -1,
 39284336,
 121194,
 39453279,
 39065117,
 -1,
 39518814,
 39410249,
 -1,
 -64932,
 39480389,
 121208,
 -64931,
 39537697,
 121209,
 -1,
 39601005,
 121210,
 -1,
 39463336,
 121203,
 39846499,
 39420859,
 -1,
 -64927,
 39808069,
 121211,
 -64926,
 39865377,
 121212,
 -1,
 39928685,
 121213,
 40108647,
 39803834,
 -1,
 -64923,
 40070213,
 121214,
 -64922,
 40127521,
 121215,
 -1,
 40190829,
 121216,
 40370796,
 40054350,
 -1,
 40436331,
 40320547,
 -1,
 -64918,
 40397781,
 121331,
 -1,
 40445002,
 121332,
 -1,
 40392243,
 121129,
 -1,
 40321071,
 121449,
 40764035,
 32842567,
 -1,
 40829561,
 40703862,
 -1,
 40895092,
 40793013,
 -1,
 40960626,
 40846189,
 121187,
 -1,
 40922596,
 121188,
 -64909,
 40922181,
 121185,
 -1,
 41045025,
 121186,
 41287679,
 40834547,
 -1,
 41288311,
 41173869,
 121183,
 -1,
 41250276,
 121184,
 -64904,
 41249861,
 121181,
 -1,
 41372705,
 121182,
 41550462,
 40793013,
 -1,
 41615996,
 41501549,
 121179,
 -1,
 41577956,
 121180,
 -64899,
 41577541,
 121177,
 -1,
 41700385,
 121178,
 41943039,
 41489907,
 -1,
 41943681,
 41829229,
 121175,
 -1,
 41905636,
 121176,
 -64894,
 41905221,
 121173,
 -1,
 42028065,
 121174,
 42270719,
 40711756,
 -1,
 42271372,
 42170413,
 -1,
 42336907,
 42214676,
 -1,
 42402441,
 42275223,
 -1,
 -64888,
 42363973,
 121126,
 -1,
 42419053,
 121125,
 -64886,
 42363973,
 121122,
 -1,
 42550125,
 121121,
 -1,
 42297739,
 121123,
 -64883,
 42232636,
 121127,
 -1,
 42739033,
 121124,
 42991615,
 24869488,
 -1,
 42992283,
 42882751,
 -1,
 43057812,
 42951210,
 121418,
 43188223,
 42991616,
 -1,
 -64877,
 43090505,
 121420,
 -1,
 43155711,
 121419,
 43319960,
 43014539,
 121415,
 43450367,
 43253760,
 -1,
 -64873,
 43352649,
 121417,
 -1,
 43417855,
 121416,
 -64871,
 43286783,
 121414,
 -64870,
 43528073,
 121413,
 -1,
 43588844,
 121412,
 43778721,
 42932811,
 -1,
 43844256,
 43731322,
 -1,
 -64866,
 43798607,
 121403,
 -64865,
 43855753,
 121404,
 -1,
 43917106,
 121405,
 -1,
 43800448,
 121430,
 44171941,
 43741442,
 121424,
 44302335,
 44105728,
 -1,
 -64860,
 44199722,
 121426,
 -1,
 44248969,
 121425,
 44434089,
 44133583,
 121406,
 44564479,
 44367872,
 -1,
 -64856,
 44466431,
 121407,
 -1,
 44521146,
 121408,
 44696237,
 44384773,
 121421,
 44826623,
 44630016,
 -1,
 -64852,
 44728575,
 121423,
 -1,
 44773257,
 121422,
 44958385,
 44642457,
 121409,
 45088767,
 44892160,
 -1,
 -64848,
 44990719,
 121410,
 -1,
 45045434,
 121411,
 45285375,
 44925192,
 -1,
 -64845,
 45181909,
 121431,
 -1,
 45229130,
 121432,
 45417203,
 24801185,
 -1,
 45482704,
 45375832,
 -1,
 45548229,
 45448463,
 -1,
 45613760,
 45508405,
 -1,
 45679292,
 45579535,
 -1,
 -64838,
 45640661,
 121163,
 -64837,
 45687882,
 121164,
 -1,
 45748619,
 121165,
 46006271,
 45625089,
 -1,
 -64834,
 45902805,
 121166,
 -64833,
 45950026,
 121167,
 -1,
 46010763,
 121168,
 46203588,
 45552633,
 -1,
 -64830,
 46167206,
 121172,
 -64829,
 46230485,
 121170,
 -1,
 46277706,
 121171,
 -1,
 46164502,
 121169,
 46596095,
 45494017,
 -1,
 46596815,
 46491445,
 -1,
 46662347,
 46562575,
 -1,
 -64823,
 46623701,
 121220,
 -64822,
 46670922,
 121221,
 -1,
 46731659,
 121222,
 46989311,
 46608129,
 -1,
 -64819,
 46885845,
 121217,
 -64818,
 46933066,
 121218,
 -1,
 46993803,
 121219,
 -1,
 46557718,
 121223,
 47252197,
 45437713,
 -1,
 47317724,
 47206581,
 -1,
 47383253,
 47280842,
 -1,
 -64812,
 47346567,
 121436,
 -1,
 47388543,
 121435,
 47579864,
 47324122,
 -1,
 -64809,
 47541823,
 121439,
 -1,
 47594747,
 121440,
 -64807,
 47541836,
 121433,
 -64806,
 47730301,
 121438,
 -64805,
 47794099,
 121434,
 -1,
 47856904,
 121437,
 48038624,
 47281916,
 -1,
 -64802,
 47999957,
 121093,
 -64801,
 48058076,
 121094,
 -1,
 48109422,
 121095,
 48365567,
 47998868,
 -1,
 48366308,
 48266511,
 -1,
 -64797,
 48328341,
 121458,
 -1,
 48374061,
 121459,
 -1,
 48312094,
 121460,
 48693247,
 47195781,
 -1,
 48693999,
 48573412,
 121441,
 48824319,
 48627712,
 -1,
 48825069,
 48715032,
 -1,
 48890603,
 48788276,
 121443,
 -1,
 48825024,
 121444,
 49086463,
 48842906,
 121445,
 -1,
 48956096,
 121446,
 -64786,
 48778868,
 121442,
 -1,
 49092625,
 121447,
 49348607,
 48648779,
 -1,
 -64783,
 49237313,
 121390,
 -64782,
 49301889,
 121391,
 -1,
 49362426,
 121389,
 49546022,
 45375470,
 -1,
 49611554,
 49502167,
 -1,
 49677073,
 49547114,
 -1,
 49742596,
 49642767,
 -1,
 49808123,
 49703893,
 121250,
 49938431,
 49742354,
 -1,
 -64774,
 49819790,
 121258,
 -1,
 49880231,
 121265,
 50070271,
 49751114,
 121251,
 50200575,
 50004498,
 -1,
 -64770,
 50081934,
 121259,
 -1,
 50142375,
 121266,
 50397183,
 50008450,
 -1,
 50397955,
 50281531,
 -1,
 -64766,
 50344078,
 121260,
 -1,
 50404519,
 121267,
 -1,
 50341509,
 121252,
 50724863,
 49688321,
 -1,
 50725641,
 50621397,
 121311,
 50855935,
 50659858,
 -1,
 -64760,
 50736884,
 121298,
 -1,
 50797502,
 121283,
 50987789,
 50668618,
 121312,
 51118079,
 50922002,
 -1,
 -64756,
 50999028,
 121299,
 -1,
 51059646,
 121284,
 51314687,
 50925963,
 121313,
 51380223,
 51184146,
 -1,
 -64752,
 51261172,
 121300,
 -1,
 51321790,
 121285,
 51576831,
 49611445,
 -1,
 51577626,
 51447955,
 -1,
 -64748,
 51514374,
 121519,
 -64747,
 51579740,
 121518,
 -64746,
 51645120,
 121517,
 -64745,
 51710471,
 121516,
 -64744,
 51775791,
 121515,
 -64743,
 51841171,
 121514,
 -1,
 51906563,
 121513,
 -64741,
 51514819,
 121512,
 -64740,
 52038980,
 121511,
 -64739,
 52104350,
 121510,
 -64738,
 52169734,
 121509,
 -64737,
 52235100,
 121508,
 -64736,
 52300480,
 121507,
 -64735,
 52365831,
 121506,
 -1,
 52431151,
 121505,
 52690943,
 49575545,
 -1,
 -64732,
 52587477,
 121105,
 -64731,
 52645596,
 121106,
 -1,
 52696942,
 121107,
 52888400,
 49489541,
 -1,
 52953934,
 52855378,
 -1,
 53019447,
 52900199,
 -1,
 53084977,
 52985103,
 -1,
 53150510,
 53046896,
 121377,
 53280767,
 53084160,
 -1,
 -64723,
 53158986,
 121378,
 -1,
 53219723,
 121379,
 53477375,
 53090891,
 -1,
 -64720,
 53377554,
 121383,
 -1,
 53427768,
 121385,
 53673983,
 53030657,
 -1,
 53674806,
 53571184,
 121380,
 53805055,
 53608448,
 -1,
 -64715,
 53683274,
 121381,
 -1,
 53744011,
 121382,
 -1,
 53616934,
 121384,
 54002497,
 52979697,
 -1,
 54068027,
 53968603,
 -1,
 -64710,
 54022427,
 121372,
 -1,
 54068021,
 121370,
 54264638,
 54014970,
 -1,
 -64707,
 54220474,
 121369,
 -1,
 54271480,
 121371,
 -64705,
 54226357,
 121365,
 -64704,
 54417082,
 121364,
 -1,
 54468088,
 121366,
 54657861,
 53953481,
 -1,
 -64701,
 54622250,
 121374,
 -64700,
 54669113,
 121376,
 -1,
 54732047,
 121375,
 54920009,
 54598106,
 -1,
 -64697,
 54884394,
 121354,
 -64696,
 54939727,
 121355,
 -1,
 54994191,
 121356,
 55246847,
 54853632,
 -1,
 55247693,
 55122113,
 -1,
 -64692,
 55208917,
 121367,
 -1,
 55267036,
 121368,
 -1,
 55213844,
 121373,
 -64689,
 52920697,
 121452,
 -1,
 55448681,
 121392,
 55640941,
 52839066,
 -1,
 55706465,
 55588840,
 -1,
 55771996,
 55659454,
 -1,
 55837531,
 55723715,
 -1,
 -64683,
 55774366,
 121469,
 -64682,
 55839750,
 121468,
 -64681,
 55905116,
 121467,
 -64680,
 55970496,
 121466,
 -64679,
 56035847,
 121465,
 -64678,
 56101167,
 121464,
 -1,
 56166547,
 121463,
 -1,
 55778878,
 121462,
 56492031,
 55728766,
 -1,
 56492896,
 56360960,
 -1,
 -64673,
 56457539,
 121429,
 -1,
 56510988,
 121428,
 -1,
 56453143,
 121427,
 56819711,
 55661419,
 -1,
 56820586,
 56688640,
 -1,
 56886118,
 56767752,
 -1,
 -64667,
 56834473,
 121473,
 -1,
 56889272,
 121476,
 -64665,
 56852192,
 121474,
 -64664,
 57045879,
 121477,
 -64663,
 57100396,
 121478,
 -1,
 57156317,
 121475,
 57409535,
 56756074,
 -1,
 -64660,
 57310518,
 121471,
 -1,
 57356045,
 121472,
 57541514,
 55586091,
 -1,
 57607033,
 57492122,
 -1,
 57672568,
 57555188,
 -1,
 57738101,
 57632751,
 -1,
 57803636,
 57690925,
 -1,
 -64653,
 57764821,
 121116,
 -1,
 57822940,
 121118,
 -1,
 57748099,
 121119,
 58130431,
 57688947,
 -1,
 -64649,
 58026965,
 121115,
 -1,
 58085084,
 121117,
 -1,
 57628277,
 121456,
 58327937,
 57554920,
 -1,
 58393472,
 58280132,
 -1,
 -64644,
 58330118,
 121503,
 -64643,
 58395484,
 121502,
 -64642,
 58460864,
 121501,
 -64641,
 58526215,
 121500,
 -1,
 58591535,
 121499,
 -1,
 58347691,
 121470,
 58852229,
 58283880,
 -1,
 -64637,
 58818815,
 121363,
 -64636,
 58871887,
 121361,
 -1,
 58924850,
 121362,
 59114377,
 58789677,
 -1,
 59179912,
 59078733,
 121352,
 -1,
 59114761,
 121353,
 -1,
 59125664,
 121351,
 -1,
 59078588,
 121480,
 59442082,
 57501679,
 -1,
 59507605,
 59400113,
 -1,
 59573137,
 59467759,
 -1,
 59638672,
 59525933,
 -1,
 -64625,
 59599829,
 121111,
 -1,
 59657948,
 121113,
 -1,
 59583107,
 121114,
 59900820,
 59523955,
 -1,
 -64621,
 59861973,
 121110,
 -1,
 59920092,
 121112,
 -1,
 59846370,
 121120,
 60162969,
 59470995,
 -1,
 -64617,
 60124117,
 121099,
 -64616,
 60182236,
 121100,
 -1,
 60233582,
 121101,
 60425118,
 60110610,
 -1,
 60490653,
 60372578,
 -1,
 -64612,
 60452220,
 121453,
 -1,
 60513692,
 121454,
 -1,
 60453499,
 121457,
 60752801,
 60389832,
 -1,
 -64608,
 60714905,
 121108,
 -1,
 60757870,
 121109,
 -1,
 60696908,
 121481,
 61014966,
 59384147,
 -1,
 61080496,
 60982040,
 -1,
 61146024,
 61040623,
 -1,
 61211559,
 61094632,
 121339,
 -1,
 61145090,
 121340,
 -1,
 61163905,
 121336,
 61408171,
 61084737,
 -1,
 -64598,
 61369413,
 121333,
 -1,
 61424493,
 121334,
 -64596,
 61370626,
 121337,
 -64595,
 61563585,
 121338,
 -64594,
 61616864,
 121342,
 -64593,
 61681064,
 121335,
 -1,
 61746382,
 121341,
 61997055,
 61039044,
 -1,
 61998004,
 61886551,
 -1,
 -64589,
 61962282,
 121360,
 -1,
 62006543,
 121357,
 -64587,
 61962306,
 121359,
 -1,
 62137656,
 121358,
 62325694,
 60968709,
 -1,
 62391229,
 62281638,
 -1,
 62456763,
 62356710,
 -1,
 -64582,
 62416327,
 121395,
 -1,
 62470562,
 121396,
 -64580,
 62410831,
 121393,
 -1,
 62594866,
 121394,
 -1,
 62334855,
 121450,
 62849990,
 62265931,
 -1,
 62915523,
 62797186,
 -1,
 -64575,
 62877482,
 121388,
 -64574,
 62938714,
 121386,
 -1,
 63000655,
 121387,
 63242239,
 62870289,
 -1,
 -64571,
 63131156,
 121479,
 -1,
 63195458,
 121482,
 63374286,
 62790046,
 -1,
 63439819,
 63339064,
 -1,
 -64567,
 63400917,
 121102,
 -64566,
 63459036,
 121103,
 -1,
 63510382,
 121104,
 63766527,
 63383398,
 -1,
 -64563,
 63651021,
 121401,
 -1,
 63712530,
 121402,
 63898581,
 63312068,
 -1,
 63964114,
 63860517,
 -1,
 -64559,
 63913032,
 121398,
 -1,
 63964238,
 121400,
 64225279,
 63903955,
 -1,
 -64556,
 64109666,
 121397,
 -1,
 64160846,
 121399,
 64357337,
 63845134,
 -1,
 -64553,
 64318421,
 121096,
 -64552,
 64376540,
 121097,
 -1,
 64427886,
 121098,
 -64550,
 64322842,
 121455,
 -64549,
 64583968,
 121461,
 -1,
 64641891,
 121483,
 -1,
 197415,
 129304,
 64881765,
 139603,
 -1,
 64947290,
 64824103,
 -1,
 65012770,
 64898775,
 -1,
 65078250,
 64974753,
 -1,
 65143779,
 65044594,
 71129,
 -1,
 65091560,
 71130,
 65274854,
 65105825,
 -1,
 -64539,
 65221514,
 71065,
 -1,
 65277513,
 71064,
 65471465,
 65221500,
 -1,
 -64536,
 65430131,
 71128,
 -1,
 65474121,
 71070,
 -1,
 65408585,
 71069,
 65733617,
 65043116,
 -1,
 65799152,
 65688410,
 -1,
 65864686,
 65757166,
 71046,
 -1,
 65822702,
 71047,
 66060287,
 65815194,
 71048,
 -1,
 65946266,
 71049,
 -1,
 65736265,
 71082,
 66192374,
 65670729,
 71040,
 -64525,
 66155962,
 71053,
 -64524,
 66210378,
 71131,
 -64523,
 66271208,
 71051,
 -1,
 66326089,
 71041,
 66520059,
 66146053,
 -1,
 -64520,
 66486818,
 71063,
 -64519,
 66539370,
 71068,
 -64518,
 66597143,
 71058,
 -1,
 66653769,
 71073,
 66847745,
 66462035,
 -1,
 66913279,
 66789715,
 -1,
 -64514,
 66859914,
 71067,
 -1,
 66915913,
 71066,
 -64512,
 66859914,
 71072,
 -1,
 67046985,
 71071,
 67240965,
 66807791,
 -1,
 -64509,
 67201100,
 71084,
 -64508,
 67253130,
 71083,
 -1,
 67309129,
 71085,
 67503111,
 67204538,
 71044,
 -1,
 67466682,
 71045,
 67634186,
 67459710,
 -1,
 -64503,
 67580810,
 71075,
 -1,
 67636809,
 71074,
 67830797,
 67584169,
 -1,
 -64500,
 67777418,
 71055,
 -1,
 67833417,
 71054,
 68027408,
 67780597,
 -1,
 -64497,
 67974026,
 71062,
 -1,
 68030025,
 71061,
 68224018,
 67975144,
 71042,
 -1,
 68171752,
 71043,
 68355093,
 68169969,
 -1,
 -64492,
 68301706,
 71057,
 -1,
 68357705,
 71056,
 68551704,
 68295243,
 -1,
 -64489,
 68498314,
 71060,
 -1,
 68554313,
 71059,
 68748315,
 68490781,
 -1,
 -64486,
 68694922,
 71077,
 -1,
 68750921,
 71076,
 -64484,
 68715042,
 71079,
 -64483,
 68902972,
 71080,
 -64482,
 68965137,
 71052,
 -64481,
 69028568,
 71078,
 -64480,
 69092052,
 71081,
 -64479,
 69153674,
 71086,
 -1,
 69215877,
 71050,
 69403715,
 64972783,
 -1,
 69469243,
 69346949,
 -1,
 69534776,
 69410965,
 -1,
 69600310,
 69500720,
 -1,
 69665835,
 69563397,
 -1,
 69731370,
 69608110,
 -1,
 -64471,
 69694997,
 71114,
 -1,
 69739577,
 71115,
 -1,
 69688461,
 71122,
 69993519,
 69624170,
 -1,
 -64467,
 69956789,
 71118,
 -64466,
 70001806,
 71117,
 -1,
 70066197,
 71116,
 70255667,
 69934440,
 -1,
 -64463,
 70219133,
 71126,
 -64462,
 70279519,
 71125,
 -1,
 70332391,
 71127,
 -64460,
 70216036,
 71124,
 -64459,
 70475570,
 71123,
 -1,
 70526094,
 71121,
 70778879,
 69543137,
 71119,
 -1,
 70649582,
 71120,
 70909951,
 69491515,
 -1,
 -64454,
 70788130,
 71108,
 -1,
 70850200,
 71109,
 71106559,
 69417518,
 -1,
 71107647,
 71007260,
 -1,
 -64450,
 71067839,
 71102,
 -1,
 71131397,
 71103,
 -64448,
 71068457,
 71105,
 -64447,
 71258795,
 71104,
 -64446,
 71310024,
 71100,
 -1,
 71373584,
 71101,
 71566418,
 69369035,
 -1,
 71631946,
 71503433,
 -1,
 71697479,
 71584330,
 71132,
 -1,
 71660986,
 71133,
 -64440,
 71660986,
 71099,
 -64439,
 71776232,
 71097,
 -1,
 71831113,
 71087,
 72025164,
 71597172,
 71092,
 -1,
 71983086,
 71093,
 72156238,
 71988666,
 71090,
 -1,
 72119738,
 71091,
 72287312,
 72103912,
 71088,
 -1,
 72234984,
 71089,
 -64431,
 72241937,
 71098,
 -1,
 72361605,
 71096,
 72549462,
 71525094,
 -1,
 -64428,
 72485383,
 71112,
 -64427,
 72550703,
 71111,
 -1,
 72616083,
 71110,
 72811609,
 72491347,
 -1,
 -64424,
 72767573,
 71107,
 -1,
 72815183,
 71106,
 -1,
 72755633,
 71113,
 73138175,
 64892130,
 -1,
 73139296,
 73039447,
 -1,
 -64419,
 73103475,
 128414,
 -64418,
 73163800,
 128409,
 -64417,
 73221448,
 128408,
 -1,
 73278789,
 128415,
 73531391,
 73078834,
 -1,
 -64414,
 73431155,
 128416,
 -64413,
 73491480,
 128411,
 -64412,
 73549128,
 128410,
 -1,
 73606469,
 128417,
 73794722,
 64835333,
 -1,
 73860248,
 73741295,
 -1,
 73925765,
 73798518,
 -1,
 73991288,
 73880241,
 -1,
 74056813,
 73953185,
 -1,
 -64405,
 74022413,
 70123,
 -64404,
 74069622,
 70124,
 -1,
 74131797,
 70122,
 74318960,
 74016751,
 -1,
 -64401,
 74268624,
 70127,
 -1,
 74329259,
 70128,
 74515571,
 74274158,
 -1,
 -64398,
 74477970,
 70132,
 -1,
 74528689,
 70131,
 74712182,
 74460459,
 -1,
 -64395,
 74667934,
 70125,
 -1,
 74725726,
 70126,
 -64393,
 74666244,
 70130,
 -1,
 74852559,
 70129,
 75104255,
 73933700,
 -1,
 75105404,
 75001761,
 -1,
 -64389,
 75071560,
 70114,
 -1,
 75118376,
 70115,
 75302015,
 75065327,
 -1,
 -64386,
 75251601,
 70118,
 -1,
 75312251,
 70119,
 75498626,
 75246891,
 -1,
 -64383,
 75454661,
 70116,
 -1,
 75513601,
 70117,
 -64381,
 75453802,
 70113,
 -64380,
 75649236,
 70121,
 -1,
 75704475,
 70120,
 75891859,
 73877663,
 -1,
 75957385,
 75853729,
 -1,
 -64376,
 75923528,
 3560,
 -1,
 75970344,
 3561,
 76153996,
 75917295,
 -1,
 -64373,
 76103569,
 3564,
 -1,
 76164219,
 3565,
 76350607,
 76098859,
 -1,
 -64370,
 76306629,
 3562,
 -1,
 76365569,
 3563,
 -64368,
 76317622,
 3558,
 -64367,
 76502378,
 3559,
 -64366,
 76566740,
 3567,
 -1,
 76621979,
 3566,
 76873727,
 75833052,
 -1,
 76874903,
 76767214,
 -1,
 -64362,
 76819028,
 983923,
 -1,
 76878093,
 983922,
 -1,
 76841533,
 983921,
 77201407,
 73806524,
 -1,
 77202591,
 77070336,
 -1,
 77268125,
 77163193,
 -1,
 -64356,
 77234248,
 983154,
 -1,
 77281064,
 983157,
 -64354,
 77214449,
 983182,
 -1,
 77405248,
 983184,
 77660159,
 77137900,
 -1,
 -64351,
 77531655,
 983158,
 -1,
 77596975,
 983155,
 77792421,
 73761099,
 -1,
 -64348,
 77753878,
 128303,
 -1,
 77814897,
 128973,
 -1,
 77744024,
 128510,
 78054720,
 78716,
 -1,
 78120232,
 77991497,
 -1,
 78185767,
 78078038,
 -1,
 78251241,
 78137047,
 -1,
 78316721,
 78215852,
 -1,
 78382256,
 78271322,
 -1,
 78447790,
 78340078,
 70025,
 -1,
 78405614,
 70026,
 78643199,
 78398106,
 70027,
 -1,
 78529178,
 70028,
 -1,
 78319177,
 70062,
 78775479,
 78278561,
 -1,
 78841013,
 78737313,
 -1,
 -64332,
 78787466,
 70044,
 -1,
 78843465,
 70043,
 -64330,
 78787466,
 70049,
 -1,
 78974537,
 70048,
 79168700,
 78728965,
 -1,
 -64327,
 79135266,
 70042,
 -64326,
 79187818,
 70047,
 -64325,
 79245591,
 70037,
 -1,
 79302217,
 70052,
 79496386,
 79110483,
 -1,
 79561920,
 79438163,
 -1,
 -64321,
 79508362,
 70046,
 -1,
 79564361,
 70045,
 -64319,
 79508362,
 70051,
 -1,
 79695433,
 70050,
 79889606,
 79433289,
 70019,
 -64316,
 79852986,
 70032,
 -64315,
 79902696,
 70030,
 -1,
 79957577,
 70020,
 80151754,
 79849455,
 -1,
 -64312,
 80111692,
 70064,
 -64311,
 80163722,
 70063,
 -1,
 80219721,
 70065,
 80413900,
 80115130,
 70023,
 -1,
 80377274,
 70024,
 80544975,
 80370302,
 -1,
 -64306,
 80491402,
 70054,
 -1,
 80547401,
 70053,
 80741586,
 80495258,
 -1,
 -64303,
 80691924,
 70061,
 -1,
 80744009,
 70060,
 80938197,
 80691369,
 -1,
 -64300,
 80884618,
 70034,
 -1,
 80940617,
 70033,
 81134808,
 80887797,
 -1,
 -64297,
 81081226,
 70041,
 -1,
 81137225,
 70040,
 81331418,
 81082344,
 70021,
 -1,
 81278952,
 70022,
 81462493,
 81277169,
 -1,
 -64292,
 81408906,
 70036,
 -1,
 81464905,
 70035,
 81659104,
 81402443,
 -1,
 -64289,
 81605514,
 70039,
 -1,
 81661513,
 70038,
 81855715,
 81597981,
 -1,
 -64286,
 81802122,
 70056,
 -1,
 81858121,
 70055,
 -64284,
 81822242,
 70058,
 -64283,
 82010172,
 70059,
 -64282,
 82072337,
 70031,
 -64281,
 82135768,
 70057,
 -64280,
 82195338,
 70066,
 -1,
 82257541,
 70029,
 82445563,
 78216362,
 -1,
 82511098,
 82406246,
 -1,
 82576624,
 82476139,
 -1,
 82642158,
 82534382,
 70072,
 -1,
 82599918,
 70073,
 82837503,
 82592410,
 70074,
 -1,
 82723482,
 70075,
 82904308,
 82513481,
 -1,
 -64270,
 82867642,
 70079,
 -64269,
 82917352,
 70077,
 -1,
 82972233,
 70067,
 83166454,
 82867642,
 70070,
 -1,
 83129786,
 70071,
 83297528,
 83113960,
 70068,
 -1,
 83245032,
 70069,
 -64263,
 83251985,
 70078,
 -1,
 83371653,
 70076,
 -1,
 82464332,
 70091,
 83625231,
 82405359,
 -1,
 83690760,
 83573294,
 -1,
 83756288,
 83655708,
 -1,
 -64257,
 83716287,
 70018,
 -1,
 83779845,
 70080,
 83952899,
 83693129,
 -1,
 -64254,
 83917497,
 70081,
 -1,
 83972846,
 70017,
 -64252,
 83917046,
 70083,
 -64251,
 84110121,
 70107,
 -64250,
 84169387,
 70090,
 -64249,
 84230232,
 70082,
 -1,
 84286152,
 70016,
 84477197,
 83633797,
 -1,
 84542732,
 84418721,
 -1,
 -64245,
 84478255,
 70111,
 -1,
 84543635,
 70110,
 -1,
 84499251,
 70088,
 -64242,
 84441740,
 70093,
 -1,
 84742740,
 70089,
 84935968,
 83566931,
 -1,
 85001502,
 84884001,
 -1,
 85067028,
 84963233,
 -1,
 -64237,
 85033032,
 70098,
 -1,
 85079848,
 70099,
 85263639,
 85026799,
 -1,
 -64234,
 85213073,
 70102,
 -1,
 85273723,
 70103,
 85460250,
 85208363,
 -1,
 -64231,
 85416133,
 70100,
 -1,
 85475073,
 70101,
 -64229,
 85427126,
 70096,
 -64228,
 85611882,
 70097,
 -64227,
 85676244,
 70105,
 -1,
 85731483,
 70104,
 -64225,
 84957269,
 70086,
 -1,
 85856847,
 70085,
 86050083,
 84878981,
 -1,
 -64222,
 86016438,
 70092,
 -1,
 86065439,
 70106,
 -64220,
 86004911,
 70084,
 -64219,
 86193444,
 70108,
 -64218,
 86253388,
 70109,
 -1,
 86314704,
 70087,
 -1,
 78150404,
 127847,
 86574392,
 78074641,
 -1,
 86639925,
 86534041,
 -1,
 86705455,
 86586417,
 -1,
 -64212,
 86669490,
 113827,
 -64211,
 86722307,
 113824,
 -64210,
 86779251,
 113826,
 -1,
 86843230,
 113825,
 87033140,
 86638592,
 -1,
 87098675,
 86971933,
 -1,
 -64206,
 87042567,
 11103,
 -1,
 87101319,
 11087,
 -1,
 87059505,
 11086,
 -1,
 86973059,
 127856,
 -64202,
 86605331,
 128703,
 -64201,
 87383516,
 128717,
 -1,
 87447544,
 127776,
 87622974,
 86521832,
 -1,
 87688508,
 87568569,
 -1,
 -64197,
 87644488,
 983075,
 -1,
 87702260,
 983078,
 -64195,
 87644798,
 128674,
 -1,
 87828710,
 128737,
 -64193,
 87589334,
 983197,
 -1,
 87959593,
 128017,
 88147334,
 78009105,
 983077,
 88212845,
 88105023,
 -1,
 88278367,
 88164055,
 -1,
 88343879,
 88231685,
 -1,
 -64187,
 88310313,
 69857,
 -64186,
 88355138,
 69847,
 -1,
 88412299,
 69849,
 88606026,
 88296152,
 -1,
 -64183,
 88552316,
 69846,
 -1,
 88614533,
 69864,
 88802637,
 88548997,
 -1,
 -64180,
 88748924,
 69863,
 -1,
 88811656,
 69859,
 -64178,
 88769065,
 69852,
 -64177,
 88963777,
 69850,
 -64176,
 89028464,
 69861,
 -64175,
 89092156,
 69841,
 -64174,
 89155679,
 69840,
 -64173,
 89219196,
 69853,
 -64172,
 89283259,
 69851,
 -64171,
 89347060,
 69862,
 -64170,
 89408297,
 69848,
 -64169,
 89473298,
 69855,
 -64168,
 89538583,
 69856,
 -64167,
 89602664,
 69860,
 -64166,
 89666463,
 69854,
 -64165,
 89731394,
 69845,
 -64164,
 89793023,
 69844,
 -64163,
 89856639,
 69843,
 -64162,
 89921142,
 69842,
 -1,
 89985163,
 69858,
 90243071,
 88220548,
 -1,
 90244451,
 90140577,
 -1,
 -64158,
 90210376,
 69874,
 -1,
 90257192,
 69875,
 90441062,
 90204143,
 -1,
 -64155,
 90390417,
 69878,
 -1,
 90451067,
 69879,
 90637673,
 90385707,
 -1,
 -64152,
 90593477,
 69876,
 -1,
 90652417,
 69877,
 -64150,
 90604470,
 69872,
 -64149,
 90789226,
 69873,
 -64148,
 90853588,
 69881,
 -1,
 90908827,
 69880,
 91096446,
 88177264,
 -1,
 91161974,
 91061801,
 -1,
 91227507,
 91118879,
 -1,
 -64143,
 91192375,
 128601,
 -64142,
 91243742,
 128593,
 -1,
 91298289,
 128609,
 91489653,
 91190363,
 11113,
 -1,
 91424049,
 11129,
 -1,
 91449502,
 129111,
 91750399,
 91105063,
 -1,
 91751803,
 91643167,
 -1,
 -64135,
 91716663,
 128603,
 -64134,
 91768030,
 128595,
 -1,
 91822577,
 128611,
 92013949,
 91714651,
 11112,
 -1,
 91948337,
 11128,
 -1,
 91973790,
 129110,
 92210560,
 91047887,
 128618,
 -1,
 92144177,
 128619,
 92341635,
 92156089,
 -1,
 -64126,
 92301915,
 128428,
 -1,
 92354785,
 127846,
 -64124,
 92301295,
 983181,
 -64123,
 92493131,
 128284,
 -1,
 92550012,
 983043,
 92734915,
 88104774,
 -1,
 92800448,
 92676437,
 -1,
 92865954,
 92750490,
 -1,
 92931487,
 92804390,
 -1,
 -64117,
 92898107,
 127305,
 -64116,
 92963286,
 127304,
 -64115,
 93028678,
 127303,
 -64114,
 93092524,
 127301,
 -64113,
 93156794,
 127300,
 -64112,
 93220769,
 127299,
 -64111,
 93282286,
 127297,
 -64110,
 93347582,
 127296,
 -64109,
 93410065,
 127294,
 -64108,
 93473423,
 127292,
 -64107,
 93536922,
 127291,
 -64106,
 93601961,
 127290,
 -64105,
 93667317,
 127289,
 -64104,
 93730792,
 127288,
 -64103,
 93795196,
 127287,
 -64102,
 93860081,
 127286,
 -64101,
 93924651,
 127285,
 -64100,
 93988485,
 127284,
 -64099,
 94052691,
 127283,
 -64098,
 94116427,
 127282,
 -1,
 94178889,
 127280,
 94437375,
 92885982,
 -1,
 -64095,
 94328609,
 10191,
 -1,
 94376480,
 10190,
 94569907,
 92805707,
 -1,
 94635441,
 94519427,
 -1,
 94700968,
 94571678,
 -1,
 -64090,
 94637705,
 127539,
 -64089,
 94703173,
 127538,
 -1,
 94768122,
 127544,
 94963117,
 94637062,
 -1,
 95028652,
 94899497,
 -1,
 -64085,
 94965187,
 127542,
 -1,
 95030596,
 127543,
 -1,
 94971623,
 127541,
 95354879,
 94899036,
 -1,
 -64081,
 95226882,
 127546,
 -64080,
 95292239,
 127540,
 -1,
 95357443,
 127545,
 -64078,
 94590570,
 127378,
 -1,
 95503002,
 127377,
 95684022,
 94523141,
 -1,
 -64075,
 95629553,
 127382,
 -1,
 95694047,
 127381,
 95880633,
 95633765,
 -1,
 -64072,
 95840332,
 127490,
 -1,
 95896099,
 127489,
 -64070,
 95845856,
 127311,
 -64069,
 96042199,
 127386,
 -64068,
 96106696,
 127385,
 -64067,
 96169259,
 127384,
 -64066,
 96228413,
 127383,
 -64065,
 96287013,
 127380,
 -1,
 96350316,
 127379,
 96600063,
 92733440,
 -1,
 -64062,
 96497820,
 128918,
 -1,
 96558473,
 11216,
 96732647,
 92698042,
 -1,
 96798177,
 96685829,
 -1,
 96863708,
 96739915,
 -1,
 96929232,
 96820858,
 -1,
 96994762,
 96885374,
 -1,
 -64055,
 96958949,
 7362,
 -1,
 96998066,
 7361,
 -64053,
 96956209,
 7360,
 -64052,
 97142614,
 7364,
 -64051,
 97206531,
 7365,
 -64050,
 97264097,
 7366,
 -64049,
 97327752,
 7363,
 -1,
 97392203,
 7367,
 97584599,
 96880343,
 -1,
 97650132,
 97529405,
 -1,
 -64045,
 97602191,
 7103,
 -1,
 97665193,
 7102,
 -64043,
 97608468,
 7099,
 -64042,
 97797970,
 7100,
 -1,
 97851324,
 7101,
 98043354,
 97525529,
 -1,
 -64039,
 98008318,
 7085,
 -1,
 98061016,
 7084,
 -64037,
 98003909,
 7083,
 -1,
 98178506,
 7098,
 98371038,
 96822759,
 127749,
 -1,
 98304858,
 127748,
 -64033,
 98331034,
 127751,
 -64032,
 98447154,
 127803,
 -1,
 98502209,
 127774,
 98698724,
 96757743,
 -1,
 -64029,
 98655213,
 128671,
 -1,
 98711003,
 127843,
 98895334,
 98637341,
 983102,
 -1,
 98856541,
 983101,
 -1,
 98853685,
 127940,
 99091974,
 96694177,
 983189,
 99157494,
 99028553,
 -1,
 99223025,
 99116956,
 -1,
 99288557,
 99182575,
 -1,
 -64020,
 99251354,
 983180,
 -1,
 99297540,
 983132,
 -64018,
 99250461,
 983044,
 -64017,
 99442225,
 983175,
 -64016,
 99497244,
 983042,
 -1,
 99562293,
 983174,
 99747316,
 99184545,
 -1,
 -64013,
 99710799,
 128509,
 -1,
 99761545,
 128649,
 -64011,
 99700372,
 128387,
 -1,
 99886010,
 127967,
 100075003,
 99114990,
 -1,
 100140538,
 100011593,
 -1,
 -64007,
 100105683,
 127827,
 -1,
 100153774,
 128207,
 -1,
 100088976,
 983188,
 100402688,
 100017797,
 -1,
 100468223,
 100340139,
 -1,
 -64002,
 100416514,
 127836,
 -1,
 100467322,
 128642,
 -1,
 100422038,
 11836,
 100730371,
 100356881,
 -1,
 -63998,
 100687607,
 9201,
 -1,
 100736390,
 128480,
 -63996,
 100696390,
 983045,
 -63995,
 100890397,
 127897,
 -1,
 100952047,
 983169,
 101123619,
 99048062,
 983117,
 101189139,
 101066373,
 -1,
 101254672,
 101126386,
 -1,
 101320206,
 101198499,
 128264,
 101449727,
 101254498,
 -1,
 -63988,
 101347797,
 128266,
 -63987,
 101406105,
 128265,
 -1,
 101456551,
 128263,
 -63985,
 101268506,
 128483,
 -1,
 101582788,
 128586,
 101842943,
 101197445,
 -1,
 -63982,
 101720690,
 128676,
 -1,
 101784608,
 128172,
 101975578,
 101136360,
 -1,
 102041112,
 101933312,
 -1,
 -63978,
 102001237,
 128026,
 -63977,
 102060524,
 128466,
 -1,
 102111886,
 128467,
 102367231,
 101982947,
 128375,
 -1,
 102237533,
 128376,
 102434335,
 101912137,
 983176,
 102499870,
 102393473,
 -1,
 -63971,
 102448177,
 128150,
 -1,
 102509381,
 10024,
 -1,
 102445603,
 127837,
 102762018,
 102388497,
 -1,
 -63967,
 102726272,
 128051,
 -1,
 102786993,
 127941,
 -1,
 102712273,
 128166,
 103024188,
 101075599,
 -1,
 103089719,
 102971368,
 -1,
 103155254,
 103041168,
 -1,
 103220787,
 103099735,
 -1,
 103286316,
 103175911,
 128515,
 103415807,
 103219215,
 -1,
 -63958,
 103314007,
 128518,
 -63957,
 103378133,
 128516,
 -1,
 103423539,
 128517,
 103614000,
 103232380,
 -1,
 -63954,
 103569287,
 128520,
 -63953,
 103622416,
 128525,
 -1,
 103682424,
 128519,
 103940095,
 103573487,
 -1,
 -63950,
 103839765,
 128526,
 -1,
 103894474,
 128522,
 104136703,
 103160654,
 -1,
 -63947,
 104027879,
 128570,
 -1,
 104084789,
 128571,
 -1,
 103114358,
 128527,
 104334907,
 103027053,
 -1,
 -63943,
 104290114,
 128312,
 -63942,
 104339691,
 128313,
 -1,
 104403145,
 128745,
 -1,
 104289394,
 128684,
 104662606,
 102974106,
 -1,
 104728133,
 104605317,
 -1,
 104793668,
 104671818,
 -1,
 104859203,
 104741876,
 -1,
 -63935,
 104820594,
 128164,
 -63934,
 104869202,
 128564,
 -1,
 104927007,
 128716,
 -1,
 104825328,
 128554,
 -1,
 104757877,
 128373,
 105252426,
 104675304,
 -1,
 105317961,
 105198189,
 -1,
 -63928,
 105278690,
 128578,
 -1,
 105328808,
 128577,
 -1,
 105257892,
 127829,
 105580109,
 105190113,
 -1,
 -63924,
 105539138,
 11100,
 -1,
 105600077,
 11098,
 -1,
 105535419,
 127920,
 105842266,
 104599113,
 -1,
 105907798,
 105796124,
 -1,
 105973333,
 105854286,
 -1,
 106038868,
 105915473,
 -1,
 -63917,
 106001676,
 128630,
 -1,
 106045054,
 128631,
 -1,
 105990533,
 128632,
 -1,
 105921821,
 128634,
 106366552,
 105869543,
 128752,
 -1,
 106299507,
 128225,
 -63911,
 106332582,
 127927,
 -1,
 106447228,
 127862,
 106628707,
 105781835,
 -1,
 106694239,
 106586094,
 -1,
 -63907,
 106648733,
 128220,
 -63906,
 106708404,
 128624,
 -1,
 106768421,
 128437,
 106956385,
 106641097,
 127979,
 -1,
 106890283,
 127890,
 -63902,
 106911628,
 129410,
 -1,
 107034600,
 983185,
 107218539,
 106594774,
 -1,
 107284071,
 107171589,
 983094,
 -63898,
 107224271,
 983093,
 -1,
 107286655,
 128333,
 107480682,
 107242327,
 -1,
 -63895,
 107434145,
 128137,
 -1,
 107482880,
 983202,
 -1,
 107432906,
 128325,
 107742834,
 107171589,
 -1,
 107808367,
 107698697,
 -1,
 -63890,
 107747595,
 127938,
 -1,
 107807029,
 127956,
 108068863,
 107744841,
 -1,
 -63887,
 107954553,
 128013,
 -1,
 108018290,
 128012,
 108201592,
 107685509,
 -1,
 108267126,
 108144261,
 -1,
 -63883,
 108209093,
 127793,
 -1,
 108267460,
 128584,
 -63881,
 108228607,
 983168,
 -1,
 108401885,
 128186,
 108594812,
 108161007,
 -1,
 -63878,
 108531273,
 983133,
 -63877,
 108595719,
 983159,
 -1,
 108661039,
 983156,
 108856959,
 108559590,
 -1,
 -63874,
 108804830,
 127946,
 -1,
 108860578,
 128629,
 109053570,
 108806313,
 -1,
 -63871,
 109017006,
 128128,
 -1,
 109066218,
 127935,
 -1,
 108999056,
 983183,
 109316955,
 3657,
 -1,
 109381913,
 109268741,
 -1,
 109447435,
 109319513,
 -1,
 109512453,
 109381779,
 -1,
 109577885,
 109447171,
 -1,
 109643404,
 109513886,
 83070,
 -63862,
 109582923,
 83073,
 -63861,
 109647389,
 83072,
 -1,
 109710921,
 83071,
 109905552,
 109578944,
 83062,
 -63858,
 109845067,
 83065,
 -63857,
 109909533,
 83064,
 -1,
 109973065,
 83063,
 110167699,
 109841244,
 83066,
 -63854,
 110106141,
 83068,
 -1,
 110169673,
 83067,
 110364309,
 110102831,
 83059,
 -1,
 110300745,
 83060,
 110495383,
 110299283,
 83057,
 -1,
 110431817,
 83058,
 110626457,
 110430211,
 83055,
 -1,
 110562889,
 83056,
 -63846,
 110562755,
 83075,
 -63845,
 110693700,
 83074,
 -63844,
 110758918,
 83069,
 -1,
 110823943,
 83061,
 111019691,
 109512851,
 -1,
 111085217,
 110954499,
 83076,
 -63840,
 111023645,
 83078,
 -1,
 111087177,
 83077,
 111281827,
 111020892,
 83083,
 -1,
 111218249,
 83084,
 -63836,
 111218115,
 83088,
 -63835,
 111349060,
 83087,
 -63834,
 111414430,
 83086,
 -63833,
 111479814,
 83085,
 -63832,
 111545024,
 83082,
 -63831,
 111610375,
 83081,
 -63830,
 111675695,
 83080,
 -1,
 111741075,
 83079,
 111937207,
 110955015,
 -1,
 112002734,
 111872860,
 83105,
 -1,
 111939145,
 83106,
 -63825,
 111939011,
 83110,
 -63824,
 112069956,
 83109,
 -63823,
 112135326,
 83108,
 -63822,
 112200710,
 83107,
 -63821,
 112265920,
 83104,
 -63820,
 112331271,
 83103,
 -63819,
 112396591,
 83102,
 -63818,
 112461971,
 83101,
 -1,
 112527363,
 83100,
 112723651,
 111872303,
 -1,
 112789178,
 112659292,
 83094,
 -1,
 112725577,
 83095,
 -63813,
 112725443,
 83099,
 -63812,
 112856388,
 83098,
 -63811,
 112921758,
 83097,
 -63810,
 112987142,
 83096,
 -63809,
 113052352,
 83093,
 -63808,
 113117703,
 83092,
 -63807,
 113183023,
 83091,
 -63806,
 113248403,
 83090,
 -1,
 113313795,
 83089,
 113510094,
 112659907,
 -1,
 -63803,
 113446339,
 83170,
 -63802,
 113511748,
 83169,
 -63801,
 113577118,
 83168,
 -63800,
 113642502,
 83167,
 -63799,
 113707868,
 83166,
 -63798,
 113773248,
 83165,
 -63797,
 113838599,
 83164,
 -63796,
 113903919,
 83163,
 -63795,
 113969299,
 83162,
 -1,
 114034691,
 83161,
 114231001,
 113446212,
 -1,
 -63792,
 114167235,
 83160,
 -63791,
 114232644,
 83159,
 -63790,
 114298014,
 83158,
 -63789,
 114363398,
 83157,
 -63788,
 114428764,
 83156,
 -63787,
 114494144,
 83155,
 -63786,
 114559495,
 83154,
 -63785,
 114624815,
 83153,
 -63784,
 114690195,
 83152,
 -1,
 114755587,
 83151,
 114951908,
 114166942,
 -1,
 -63781,
 114888131,
 83150,
 -63780,
 114953540,
 83149,
 -63779,
 115018910,
 83148,
 -63778,
 115084294,
 83147,
 -63777,
 115149660,
 83146,
 -63776,
 115215040,
 83145,
 -63775,
 115280391,
 83144,
 -63774,
 115345711,
 83143,
 -63773,
 115411091,
 83142,
 -1,
 115476483,
 83141,
 115672815,
 114887686,
 -1,
 -63770,
 115609027,
 83140,
 -63769,
 115674436,
 83139,
 -63768,
 115739806,
 83138,
 -63767,
 115805190,
 83137,
 -63766,
 115870556,
 83136,
 -63765,
 115935936,
 83135,
 -63764,
 116001287,
 83134,
 -63763,
 116066607,
 83133,
 -63762,
 116131987,
 83132,
 -1,
 116197379,
 83131,
 116393722,
 115608412,
 -1,
 -63759,
 116329923,
 83130,
 -63758,
 116395332,
 83129,
 -63757,
 116460702,
 83128,
 -63756,
 116526086,
 83127,
 -63755,
 116591452,
 83126,
 -63754,
 116656832,
 83125,
 -63753,
 116722183,
 83124,
 -63752,
 116787503,
 83123,
 -63751,
 116852883,
 83122,
 -1,
 116918275,
 83121,
 117178367,
 116329152,
 -1,
 -63748,
 117050819,
 83120,
 -63747,
 117116228,
 83119,
 -63746,
 117181598,
 83118,
 -63745,
 117246982,
 83117,
 -63744,
 117312348,
 83116,
 -63743,
 117377728,
 83115,
 -63742,
 117443079,
 83114,
 -63741,
 117508399,
 83113,
 -63740,
 117573779,
 83112,
 -1,
 117639171,
 83111,
 117835652,
 109447687,
 -1,
 117901079,
 117770759,
 -1,
 117966603,
 117836806,
 83322,
 -63735,
 117905995,
 83325,
 -63734,
 117970461,
 83324,
 -1,
 118033993,
 83323,
 118228751,
 117901615,
 -1,
 -63731,
 118168139,
 83318,
 -63730,
 118232605,
 83317,
 -1,
 118296137,
 83316,
 -63728,
 118164931,
 83328,
 -63727,
 118426948,
 83327,
 -63726,
 118492318,
 83326,
 -63725,
 118557532,
 83321,
 -63724,
 118622912,
 83320,
 -63723,
 118688263,
 83319,
 -63722,
 118753427,
 83315,
 -1,
 118818819,
 83314,
 119015206,
 117837124,
 -1,
 119080730,
 118950918,
 83381,
 -1,
 119017033,
 83382,
 119211805,
 119015943,
 -1,
 -63716,
 119148105,
 83378,
 -1,
 119211009,
 83377,
 119408415,
 119146643,
 83374,
 -1,
 119344713,
 83375,
 -63712,
 119344579,
 83385,
 -63711,
 119475524,
 83384,
 -63710,
 119540894,
 83383,
 -63709,
 119606108,
 83380,
 -63708,
 119671488,
 83379,
 -63707,
 119736623,
 83376,
 -1,
 119801859,
 83373,
 119998259,
 118950918,
 -1,
 120063785,
 119934276,
 83359,
 -1,
 120000073,
 83360,
 120194859,
 119999168,
 83354,
 -1,
 120131145,
 83355,
 -63700,
 120131011,
 83361,
 -63699,
 120261790,
 83358,
 -63698,
 120327174,
 83357,
 -63697,
 120392540,
 83356,
 -63696,
 120457735,
 83353,
 -63695,
 120523055,
 83352,
 -63694,
 120588435,
 83351,
 -1,
 120653827,
 83350,
 120850239,
 119934110,
 -1,
 120915766,
 120785043,
 83363,
 -1,
 120852041,
 83364,
 -63689,
 120851907,
 83372,
 -63688,
 120982852,
 83371,
 -63687,
 121048222,
 83370,
 -63686,
 121113606,
 83369,
 -63685,
 121178972,
 83368,
 -63684,
 121244352,
 83367,
 -63683,
 121309703,
 83366,
 -63682,
 121375023,
 83365,
 -1,
 121440259,
 83362,
 121636683,
 120785756,
 -1,
 121702210,
 121572803,
 83348,
 -1,
 121638473,
 83349,
 -63677,
 121638212,
 83347,
 -63676,
 121769118,
 83346,
 -63675,
 121834502,
 83345,
 -63674,
 121899868,
 83344,
 -63673,
 121965248,
 83343,
 -63672,
 122030599,
 83342,
 -63671,
 122095919,
 83341,
 -63670,
 122161299,
 83340,
 -1,
 122226691,
 83339,
 122423127,
 121571631,
 -1,
 122488654,
 122359235,
 83312,
 -1,
 122424905,
 83313,
 -63665,
 122424644,
 83311,
 -63664,
 122555550,
 83310,
 -63663,
 122620934,
 83309,
 -63662,
 122686300,
 83308,
 -63661,
 122751680,
 83307,
 -63660,
 122817031,
 83306,
 -63659,
 122882351,
 83305,
 -63658,
 122947731,
 83304,
 -1,
 123013123,
 83303,
 123209571,
 122357763,
 -1,
 123275098,
 123145667,
 83291,
 -1,
 123211337,
 83292,
 -63653,
 123211076,
 83290,
 -63652,
 123341982,
 83289,
 -63651,
 123407366,
 83288,
 -63650,
 123472732,
 83287,
 -63649,
 123538112,
 83286,
 -63648,
 123603463,
 83285,
 -63647,
 123668783,
 83284,
 -63646,
 123734163,
 83283,
 -1,
 123799555,
 83282,
 123996014,
 123145667,
 -1,
 -63643,
 123932099,
 83395,
 -63642,
 123997508,
 83394,
 -63641,
 124062878,
 83393,
 -63640,
 124128262,
 83392,
 -63639,
 124193628,
 83391,
 -63638,
 124259008,
 83390,
 -63637,
 124324376,
 83389,
 -63636,
 124389679,
 83388,
 -63635,
 124455059,
 83387,
 -1,
 124520451,
 83386,
 124716921,
 123931328,
 -1,
 -63632,
 124652995,
 83338,
 -63631,
 124718404,
 83337,
 -63630,
 124783774,
 83336,
 -63629,
 124849158,
 83335,
 -63628,
 124914524,
 83334,
 -63627,
 124979904,
 83333,
 -63626,
 125045255,
 83332,
 -63625,
 125110575,
 83331,
 -63624,
 125175955,
 83330,
 -1,
 125241347,
 83329,
 125501439,
 124651667,
 -1,
 -63621,
 125373891,
 83302,
 -63620,
 125439300,
 83301,
 -63619,
 125504670,
 83300,
 -63618,
 125570054,
 83299,
 -63617,
 125635420,
 83298,
 -63616,
 125700800,
 83297,
 -63615,
 125766151,
 83296,
 -63614,
 125831471,
 83295,
 -63613,
 125896851,
 83294,
 -1,
 125962243,
 83293,
 126158846,
 117770543,
 -1,
 126224276,
 126093315,
 -1,
 126289801,
 126159151,
 83173,
 -63608,
 126227997,
 83175,
 -1,
 126291529,
 83174,
 126486411,
 126225859,
 83183,
 -1,
 126422601,
 83184,
 126617485,
 126422174,
 83180,
 -1,
 126553673,
 83181,
 -63602,
 126553412,
 83182,
 -63601,
 126684166,
 83179,
 -63600,
 126749532,
 83178,
 -63599,
 126814912,
 83177,
 -63598,
 126880263,
 83176,
 -63597,
 126945427,
 83172,
 -1,
 127010819,
 83171,
 127207329,
 126160323,
 -1,
 127272855,
 127143363,
 83280,
 -1,
 127209033,
 83281,
 127403929,
 127208128,
 83274,
 -1,
 127340105,
 83275,
 -63590,
 127339844,
 83279,
 -63589,
 127470750,
 83278,
 -63588,
 127536134,
 83277,
 -63587,
 127601500,
 83276,
 -63586,
 127666695,
 83273,
 -63585,
 127732015,
 83272,
 -63584,
 127797395,
 83271,
 -1,
 127862787,
 83270,
 128059310,
 127142035,
 -1,
 128124836,
 127994886,
 83192,
 -1,
 128061001,
 83193,
 128255910,
 128060252,
 83190,
 -1,
 128192073,
 83191,
 -63577,
 128191939,
 83196,
 -63576,
 128322884,
 83195,
 -63575,
 128388254,
 83194,
 -63574,
 128453312,
 83189,
 -63573,
 128518663,
 83188,
 -63572,
 128583983,
 83187,
 -63571,
 128649363,
 83186,
 -1,
 128714755,
 83185,
 128911290,
 127995204,
 -1,
 128976817,
 128847299,
 83268,
 -1,
 128912969,
 83269,
 -63566,
 128912708,
 83267,
 -63565,
 129043614,
 83266,
 -63564,
 129108998,
 83265,
 -63563,
 129174364,
 83264,
 -63562,
 129239744,
 83263,
 -63561,
 129305095,
 83262,
 -63560,
 129370415,
 83261,
 -63559,
 129435795,
 83260,
 -1,
 129501187,
 83259,
 129697734,
 128846854,
 -1,
 129763261,
 129633438,
 83245,
 -1,
 129699401,
 83246,
 -63554,
 129699267,
 83248,
 -63553,
 129830212,
 83247,
 -63552,
 129895430,
 83244,
 -63551,
 129960796,
 83243,
 -63550,
 130026176,
 83242,
 -63549,
 130091527,
 83241,
 -63548,
 130156847,
 83240,
 -63547,
 130222227,
 83239,
 -1,
 130287619,
 83238,
 130484178,
 129632559,
 -1,
 130549705,
 130419870,
 83204,
 -1,
 130485833,
 83205,
 -63542,
 130485699,
 83207,
 -63541,
 130616644,
 83206,
 -63540,
 130681862,
 83203,
 -63539,
 130747228,
 83202,
 -63538,
 130812608,
 83201,
 -63537,
 130877959,
 83200,
 -63536,
 130943279,
 83199,
 -63535,
 131008659,
 83198,
 -1,
 131074051,
 83197,
 131270621,
 130419870,
 -1,
 -63532,
 131206595,
 83258,
 -63531,
 131272004,
 83257,
 -63530,
 131337374,
 83256,
 -63529,
 131402758,
 83255,
 -63528,
 131468124,
 83254,
 -63527,
 131533504,
 83253,
 -63526,
 131598855,
 83252,
 -63525,
 131664175,
 83251,
 -63524,
 131729555,
 83250,
 -1,
 131794947,
 83249,
 131991528,
 131205980,
 -1,
 -63521,
 131927491,
 83237,
 -63520,
 131992900,
 83236,
 -63519,
 132058270,
 83235,
 -63518,
 132123654,
 83234,
 -63517,
 132189020,
 83233,
 -63516,
 132254400,
 83232,
 -63515,
 132319751,
 83231,
 -63514,
 132385071,
 83230,
 -63513,
 132450451,
 83229,
 -1,
 132515843,
 83228,
 132712435,
 131926720,
 -1,
 -63510,
 132648387,
 83227,
 -63509,
 132713796,
 83226,
 -63508,
 132779166,
 83225,
 -63507,
 132844550,
 83224,
 -63506,
 132909916,
 83223,
 -63505,
 132975296,
 83222,
 -63504,
 133040647,
 83221,
 -63503,
 133105967,
 83220,
 -63502,
 133171347,
 83219,
 -1,
 133236739,
 83218,
 133496831,
 132647431,
 -1,
 -63499,
 133369283,
 83217,
 -63498,
 133434692,
 83216,
 -63497,
 133500062,
 83215,
 -63496,
 133565446,
 83214,
 -63495,
 133630812,
 83213,
 -63494,
 133696192,
 83212,
 -63493,
 133761543,
 83211,
 -63492,
 133826863,
 83210,
 -63491,
 133892243,
 83209,
 -1,
 133957635,
 83208,
 134154360,
 126093315,
 -1,
 134219790,
 134089408,
 -1,
 134285315,
 134155270,
 82994,
 -63486,
 134223389,
 82996,
 -1,
 134286921,
 82995,
 134481925,
 134220636,
 82992,
 -1,
 134417993,
 82993,
 134612999,
 134416531,
 82987,
 -1,
 134549065,
 82988,
 -63480,
 134548931,
 82999,
 -63479,
 134679876,
 82998,
 -63478,
 134745246,
 82997,
 -63477,
 134810304,
 82991,
 -63476,
 134875655,
 82990,
 -63475,
 134940975,
 82989,
 -1,
 135006211,
 82986,
 135202844,
 134155270,
 -1,
 135268371,
 135138310,
 83016,
 -63471,
 135207499,
 83019,
 -63470,
 135271965,
 83018,
 -1,
 135335497,
 83017,
 -63468,
 135204291,
 83022,
 -63467,
 135466308,
 83021,
 -63466,
 135531678,
 83020,
 -63465,
 135596892,
 83015,
 -63464,
 135662272,
 83014,
 -63463,
 135727623,
 83013,
 -63462,
 135792943,
 83012,
 -63461,
 135858323,
 83011,
 -1,
 135923715,
 83010,
 136120361,
 135138755,
 -1,
 136185887,
 136056132,
 83052,
 -1,
 136121929,
 83053,
 136316961,
 136121502,
 83050,
 -1,
 136253001,
 83051,
 -63454,
 136252867,
 83054,
 -63453,
 136383494,
 83049,
 -63452,
 136448860,
 83048,
 -63451,
 136514240,
 83047,
 -63450,
 136579591,
 83046,
 -63449,
 136644911,
 83045,
 -63448,
 136710291,
 83044,
 -1,
 136775683,
 83043,
 136972341,
 136055303,
 -1,
 137037868,
 136908227,
 82984,
 -1,
 136973897,
 82985,
 -63443,
 136973636,
 82983,
 -63442,
 137104542,
 82982,
 -63441,
 137169926,
 82981,
 -63440,
 137235292,
 82980,
 -63439,
 137300672,
 82979,
 -63438,
 137366023,
 82978,
 -63437,
 137431343,
 82977,
 -63436,
 137496723,
 82976,
 -1,
 137562115,
 82975,
 137758785,
 136907055,
 -1,
 137824312,
 137694214,
 82970,
 -1,
 137760329,
 82971,
 -63431,
 137760195,
 82974,
 -63430,
 137891140,
 82973,
 -63429,
 137956510,
 82972,
 -63428,
 138021724,
 82969,
 -63427,
 138087104,
 82968,
 -63426,
 138152455,
 82967,
 -63425,
 138217775,
 82966,
 -63424,
 138283155,
 82965,
 -1,
 138348547,
 82964,
 138545229,
 137693331,
 -1,
 138610756,
 138479619,
 82953,
 -1,
 138546761,
 82954,
 -63419,
 138546627,
 82963,
 -63418,
 138677572,
 82962,
 -63417,
 138742942,
 82961,
 -63416,
 138808326,
 82960,
 -63415,
 138873692,
 82959,
 -63414,
 138939072,
 82958,
 -63413,
 139004423,
 82957,
 -63412,
 139069743,
 82956,
 -1,
 139135123,
 82955,
 139331672,
 138480964,
 -1,
 -63409,
 139267523,
 83042,
 -63408,
 139332932,
 83041,
 -63407,
 139398302,
 83040,
 -63406,
 139463686,
 83039,
 -63405,
 139529052,
 83038,
 -63404,
 139594432,
 83037,
 -63403,
 139659783,
 83036,
 -63402,
 139725103,
 83035,
 -63401,
 139790483,
 83034,
 -1,
 139855875,
 83033,
 140052579,
 139267230,
 -1,
 -63398,
 139988419,
 83032,
 -63397,
 140053828,
 83031,
 -63396,
 140119198,
 83030,
 -63395,
 140184582,
 83029,
 -63394,
 140249948,
 83028,
 -63393,
 140315328,
 83027,
 -63392,
 140380679,
 83026,
 -63391,
 140445999,
 83025,
 -63390,
 140511379,
 83024,
 -1,
 140576771,
 83023,
 140773486,
 139987804,
 -1,
 -63387,
 140709315,
 83009,
 -63386,
 140774724,
 83008,
 -63385,
 140840094,
 83007,
 -63384,
 140905478,
 83006,
 -63383,
 140970844,
 83005,
 -63382,
 141036224,
 83004,
 -63381,
 141101575,
 83003,
 -63380,
 141166895,
 83002,
 -63379,
 141232275,
 83001,
 -1,
 141297667,
 83000,
 141557759,
 140707843,
 -1,
 -63376,
 141430211,
 82952,
 -63375,
 141495620,
 82951,
 -63374,
 141560990,
 82950,
 -63373,
 141626374,
 82949,
 -63372,
 141691740,
 82948,
 -63371,
 141757120,
 82947,
 -63370,
 141822471,
 82946,
 -63369,
 141887791,
 82945,
 -1,
 141953171,
 82944,
 142149865,
 134089408,
 -1,
 142215302,
 142084956,
 -1,
 142280828,
 142150814,
 83455,
 -1,
 142216777,
 83456,
 142411902,
 142215171,
 83447,
 -1,
 142347849,
 83448,
 -63361,
 142347715,
 83458,
 -63360,
 142478660,
 83457,
 -63359,
 142543878,
 83454,
 -63358,
 142609244,
 83453,
 -63357,
 142674624,
 83452,
 -63356,
 142739975,
 83451,
 -63355,
 142805295,
 83450,
 -1,
 142870675,
 83449,
 143067283,
 142149779,
 -1,
 143132810,
 143001603,
 -1,
 -63351,
 143068750,
 83407,
 -1,
 143130827,
 83406,
 -63349,
 143068611,
 83416,
 -63348,
 143265092,
 83415,
 -63347,
 143330462,
 83414,
 -63346,
 143395846,
 83413,
 -63345,
 143461212,
 83412,
 -63344,
 143526592,
 83411,
 -63343,
 143591943,
 83410,
 -63342,
 143657263,
 83409,
 -1,
 143722643,
 83408,
 143919262,
 143002948,
 -1,
 -63339,
 143855043,
 83488,
 -63338,
 143920452,
 83487,
 -63337,
 143985822,
 83486,
 -63336,
 144051206,
 83485,
 -63335,
 144116572,
 83484,
 -63334,
 144181952,
 83483,
 -63333,
 144247303,
 83482,
 -63332,
 144312623,
 83481,
 -63331,
 144378003,
 83480,
 -1,
 144443395,
 83479,
 144640169,
 143854750,
 -1,
 -63328,
 144575939,
 83478,
 -63327,
 144641348,
 83477,
 -63326,
 144706718,
 83476,
 -63325,
 144772102,
 83475,
 -63324,
 144837468,
 83474,
 -63323,
 144902848,
 83473,
 -63322,
 144968199,
 83472,
 -63321,
 145033519,
 83471,
 -63320,
 145098899,
 83470,
 -1,
 145164291,
 83469,
 145361076,
 144575494,
 -1,
 -63317,
 145296835,
 83468,
 -63316,
 145362244,
 83467,
 -63315,
 145427614,
 83466,
 -63314,
 145492998,
 83465,
 -63313,
 145558364,
 83464,
 -63312,
 145623744,
 83463,
 -63311,
 145689095,
 83462,
 -63310,
 145754415,
 83461,
 -63309,
 145819795,
 83460,
 -1,
 145885187,
 83459,
 146081983,
 145296064,
 -1,
 -63306,
 146017731,
 83446,
 -63305,
 146083140,
 83445,
 -63304,
 146148510,
 83444,
 -63303,
 146213894,
 83443,
 -63302,
 146279260,
 83442,
 -63301,
 146344640,
 83441,
 -63300,
 146409991,
 83440,
 -63299,
 146475311,
 83439,
 -63298,
 146540691,
 83438,
 -1,
 146606083,
 83437,
 146802890,
 146016775,
 -1,
 -63295,
 146738627,
 83436,
 -63294,
 146804036,
 83435,
 -63293,
 146869406,
 83434,
 -63292,
 146934790,
 83433,
 -63291,
 147000156,
 83432,
 -63290,
 147065536,
 83431,
 -63289,
 147130887,
 83430,
 -63288,
 147196207,
 83429,
 -63287,
 147261587,
 83428,
 -1,
 147326979,
 83427,
 147523797,
 146737455,
 -1,
 -63284,
 147459523,
 83426,
 -63283,
 147524932,
 83425,
 -63282,
 147590302,
 83424,
 -63281,
 147655686,
 83423,
 -63280,
 147721052,
 83422,
 -63279,
 147786432,
 83421,
 -63278,
 147851783,
 83420,
 -63277,
 147917103,
 83419,
 -63276,
 147982483,
 83418,
 -1,
 148047875,
 83417,
 148244704,
 147458051,
 -1,
 -63273,
 148180419,
 83405,
 -63272,
 148245828,
 83404,
 -63271,
 148311198,
 83403,
 -63270,
 148376582,
 83402,
 -63269,
 148441948,
 83401,
 -63268,
 148507328,
 83400,
 -63267,
 148572679,
 83399,
 -63266,
 148637999,
 83398,
 -63265,
 148703379,
 83397,
 -1,
 148768771,
 83396,
 149028863,
 148180419,
 -1,
 -63262,
 148901022,
 83496,
 -63261,
 148966406,
 83495,
 -63260,
 149031772,
 83494,
 -63259,
 149097152,
 83493,
 -63258,
 149162503,
 83492,
 -63257,
 149227823,
 83491,
 -63256,
 149293203,
 83490,
 -1,
 149358595,
 83489,
 149618687,
 142084956,
 -1,
 149620981,
 149489967,
 -1,
 -63252,
 149556675,
 83525,
 -63251,
 149622084,
 83524,
 -63250,
 149687454,
 83523,
 -63249,
 149752838,
 83522,
 -63248,
 149818204,
 83521,
 -63247,
 149883584,
 83520,
 -63246,
 149948935,
 83519,
 -63245,
 150014255,
 83518,
 -63244,
 150079635,
 83517,
 -1,
 150145027,
 83516,
 150341888,
 149555347,
 -1,
 -63241,
 150277571,
 83515,
 -63240,
 150342980,
 83514,
 -63239,
 150408350,
 83513,
 -63238,
 150473734,
 83512,
 -63237,
 150539100,
 83511,
 -63236,
 150604480,
 83510,
 -63235,
 150669831,
 83509,
 -63234,
 150735151,
 83508,
 -63233,
 150800531,
 83507,
 -1,
 150865923,
 83506,
 151062794,
 150276099,
 -1,
 -63230,
 150998467,
 83505,
 -63229,
 151063876,
 83504,
 -63228,
 151129246,
 83503,
 -63227,
 151194630,
 83502,
 -63226,
 151259996,
 83501,
 -63225,
 151325376,
 83500,
 -63224,
 151390727,
 83499,
 -63223,
 151456047,
 83498,
 -1,
 151521427,
 83497,
 -1,
 150997674,
 83526,
 151783701,
 109408161,
 128028,
 151849236,
 151730444,
 -1,
 151914771,
 151811146,
 -1,
 -63217,
 151876421,
 11151,
 -63216,
 151938165,
 11148,
 -63215,
 152000197,
 11119,
 -63214,
 152061319,
 11150,
 -1,
 152115565,
 11149,
 -1,
 151856568,
 128260,
 -1,
 151792090,
 128246,
 152502271,
 151728369,
 -1,
 -63209,
 152401800,
 128551,
 -63208,
 152463335,
 128544,
 -1,
 152513210,
 128162,
 152701517,
 109338606,
 -1,
 152767049,
 152637154,
 -1,
 152832472,
 152718040,
 -1,
 152898007,
 152793407,
 -1,
 152963398,
 152838483,
 -1,
 153028931,
 152916753,
 -1,
 153094462,
 152991430,
 -1,
 153159974,
 153055137,
 -1,
 153225508,
 153105276,
 -1,
 -63197,
 153168008,
 126646,
 -1,
 153227567,
 126648,
 -63195,
 153168008,
 126645,
 -1,
 153358475,
 126632,
 153553194,
 153118703,
 -1,
 -63192,
 153499039,
 126644,
 -63191,
 153561125,
 126638,
 -1,
 153620405,
 126641,
 153815341,
 153518909,
 -1,
 -63188,
 153762548,
 126630,
 -1,
 153826172,
 126650,
 154011952,
 153756126,
 -1,
 -63185,
 153961114,
 126627,
 -1,
 154018131,
 126649,
 -63183,
 153977433,
 126633,
 -63182,
 154172838,
 126629,
 -63181,
 154231481,
 126643,
 -63180,
 154296067,
 126642,
 -63179,
 154358186,
 126637,
 -63178,
 154422406,
 126636,
 -63177,
 154485557,
 126635,
 -63176,
 154550719,
 126647,
 -63175,
 154615862,
 126626,
 -63174,
 154678175,
 126631,
 -63173,
 154743325,
 126651,
 -63172,
 154807773,
 126640,
 -63171,
 154867475,
 126625,
 -1,
 154931351,
 126639,
 155189247,
 153055987,
 -1,
 -63168,
 155082499,
 126495,
 -63167,
 155144618,
 126493,
 -63166,
 155200989,
 126494,
 -1,
 155260691,
 126492,
 155516927,
 152964681,
 -1,
 -63163,
 155402906,
 126467,
 -1,
 155459923,
 126489,
 155650411,
 152912538,
 -1,
 155715946,
 155604590,
 -1,
 155781454,
 155676577,
 -1,
 155846988,
 155726716,
 -1,
 -63157,
 155789448,
 126614,
 -1,
 155849007,
 126616,
 -63155,
 155789448,
 126613,
 -1,
 155979915,
 126600,
 156174674,
 155740143,
 -1,
 -63152,
 156120479,
 126612,
 -63151,
 156182565,
 126606,
 -1,
 156241845,
 126609,
 156436821,
 156140349,
 -1,
 -63148,
 156383988,
 126598,
 -1,
 156447612,
 126618,
 156633432,
 156382076,
 -1,
 -63145,
 156575880,
 126596,
 -1,
 156635275,
 126599,
 156830043,
 156574174,
 -1,
 -63142,
 156779162,
 126595,
 -1,
 156836179,
 126617,
 157026654,
 156765769,
 -1,
 -63139,
 156976378,
 126592,
 -1,
 157039348,
 126607,
 -63137,
 156992089,
 126601,
 -63136,
 157187494,
 126597,
 -63135,
 157246137,
 126611,
 -63134,
 157310723,
 126610,
 -63133,
 157372842,
 126605,
 -63132,
 157437062,
 126604,
 -63131,
 157500213,
 126603,
 -63130,
 157565375,
 126615,
 -63129,
 157630518,
 126594,
 -63128,
 157692445,
 126619,
 -63127,
 157756893,
 126608,
 -1,
 157816595,
 126593,
 -1,
 155652523,
 126475,
 158075277,
 155609071,
 -1,
 158140810,
 158036987,
 -1,
 158206321,
 158101409,
 -1,
 -63121,
 158152100,
 126582,
 -63120,
 158214280,
 126581,
 -1,
 158273675,
 126568,
 158468469,
 158164975,
 -1,
 -63117,
 158414239,
 126580,
 -63116,
 158476325,
 126574,
 -1,
 158535605,
 126577,
 158730618,
 158409043,
 -1,
 158796153,
 158685187,
 -1,
 -63112,
 158739933,
 126590,
 -1,
 158799635,
 126588,
 -1,
 158732213,
 126585,
 159058301,
 158679209,
 -1,
 -63108,
 159003551,
 126583,
 -1,
 159060008,
 126570,
 159254912,
 159003516,
 -1,
 -63105,
 159197320,
 126564,
 -1,
 159256715,
 126567,
 -63103,
 159220544,
 126586,
 -63102,
 159416921,
 126569,
 -63101,
 159473411,
 126578,
 -63100,
 159535530,
 126573,
 -63099,
 159599750,
 126572,
 -63098,
 159662134,
 126562,
 -63097,
 159724061,
 126587,
 -63096,
 159788509,
 126576,
 -63095,
 159848211,
 126561,
 -1,
 159912087,
 126575,
 -63093,
 158086559,
 126484,
 -63092,
 160049189,
 126478,
 -1,
 160108469,
 126481,
 160303526,
 158022868,
 -1,
 160369042,
 160262127,
 -1,
 -63088,
 160314783,
 126516,
 -63087,
 160376869,
 126510,
 -1,
 160436149,
 126513,
 160631189,
 160329633,
 -1,
 -63084,
 160576932,
 126518,
 -1,
 160639112,
 126517,
 160827800,
 160579753,
 -1,
 -63081,
 160773023,
 126519,
 -1,
 160829480,
 126506,
 161024411,
 160772988,
 -1,
 -63078,
 160966792,
 126500,
 -1,
 161026187,
 126503,
 -63076,
 160989785,
 126505,
 -63075,
 161177347,
 126514,
 -63074,
 161239466,
 126509,
 -63073,
 161303686,
 126508,
 -63072,
 161366837,
 126507,
 -63071,
 161431606,
 126498,
 -63070,
 161493533,
 126523,
 -63069,
 161557981,
 126512,
 -63068,
 161620475,
 126521,
 -63067,
 161683219,
 126497,
 -1,
 161747095,
 126511,
 161941952,
 160264097,
 -1,
 162007484,
 161877577,
 -1,
 162073019,
 161954476,
 -1,
 162138541,
 162031599,
 -1,
 -63061,
 162084255,
 126548,
 -63060,
 162146341,
 126542,
 -1,
 162205621,
 126545,
 162400690,
 162079059,
 -1,
 162466225,
 162355203,
 -1,
 -63056,
 162422531,
 126559,
 -1,
 162484650,
 126557,
 -1,
 162402229,
 126553,
 -63053,
 162366041,
 126537,
 -63052,
 162684675,
 126546,
 -63051,
 162746794,
 126541,
 -63050,
 162808629,
 126539,
 -63049,
 162873791,
 126551,
 -63048,
 162938934,
 126530,
 -63047,
 163001247,
 126535,
 -63046,
 163066397,
 126555,
 -1,
 163123351,
 126543,
 -1,
 162018172,
 126472,
 163383743,
 161952636,
 -1,
 -63042,
 163326088,
 126486,
 -1,
 163385647,
 126488,
 -1,
 163326088,
 126485,
 163645891,
 161907517,
 -1,
 -63038,
 163592948,
 126470,
 -1,
 163656572,
 126490,
 163842502,
 163600114,
 -1,
 -63035,
 163794059,
 126704,
 -1,
 163853219,
 126705,
 164039113,
 163791017,
 -1,
 -63032,
 163984287,
 126487,
 -1,
 164040744,
 126474,
 164235724,
 163974729,
 -1,
 -63029,
 164185338,
 126464,
 -1,
 164248308,
 126479,
 -63027,
 164201049,
 126473,
 -63026,
 164396454,
 126469,
 -63025,
 164455097,
 126483,
 -63024,
 164519683,
 126482,
 -63023,
 164581802,
 126477,
 -63022,
 164646022,
 126476,
 -63021,
 164708406,
 126466,
 -63020,
 164770719,
 126471,
 -63019,
 164835869,
 126491,
 -63018,
 164900317,
 126480,
 -1,
 164960019,
 126465,
 -1,
 152856144,
 2303,
 165218817,
 152791023,
 -1,
 165284339,
 165184220,
 -1,
 165349863,
 165244833,
 -1,
 165415393,
 165314635,
 -1,
 165480927,
 165378971,
 -1,
 -63010,
 165418802,
 64446,
 -1,
 165482234,
 64445,
 -63008,
 165418802,
 64437,
 -1,
 165613306,
 64436,
 165871615,
 165361453,
 -1,
 165874149,
 165764393,
 -1,
 -63004,
 165812018,
 64441,
 -1,
 165875450,
 64440,
 -63002,
 165812018,
 64439,
 -1,
 166006522,
 64438,
 166201836,
 165291004,
 -1,
 166267371,
 166162339,
 -1,
 -62998,
 166205234,
 64435,
 -1,
 166268666,
 64434,
 -1,
 166229678,
 64444,
 166529519,
 166161577,
 -1,
 -62994,
 166467378,
 64449,
 -1,
 166530810,
 64448,
 166726130,
 166473676,
 -1,
 -62991,
 166663986,
 64443,
 -1,
 166727418,
 64442,
 -1,
 166684021,
 64447,
 166988287,
 165227130,
 -1,
 167053822,
 166953565,
 -1,
 167119353,
 166989385,
 -1,
 167184888,
 167068922,
 983621,
 -1,
 167117462,
 983623,
 -1,
 167126661,
 983628,
 -62982,
 167084856,
 983626,
 -62981,
 167345574,
 983622,
 -62980,
 167409082,
 983625,
 -62979,
 167465914,
 983624,
 -1,
 167519877,
 983627,
 -1,
 167006639,
 983629,
 -62976,
 166939457,
 2291,
 -1,
 167721555,
 1540,
 167905828,
 165168256,
 -1,
 167971361,
 167867613,
 -1,
 168036870,
 167936632,
 -1,
 -62971,
 167982112,
 2216,
 -1,
 168043558,
 2217,
 168233481,
 167995375,
 -1,
 -62968,
 168195019,
 2225,
 -1,
 168234944,
 2223,
 168430092,
 168189934,
 -1,
 -62965,
 168383493,
 2220,
 -1,
 168437899,
 2218,
 168626703,
 168381071,
 -1,
 -62962,
 168568843,
 2215,
 -1,
 168629186,
 1564,
 168823314,
 168575642,
 -1,
 -62959,
 168778256,
 2221,
 -1,
 168825262,
 2214,
 169019925,
 168771840,
 -1,
 -62956,
 168979147,
 1568,
 -1,
 169028912,
 2228,
 169216536,
 168957719,
 -1,
 -62953,
 169176257,
 2208,
 -1,
 169227296,
 2209,
 -62951,
 169182020,
 2226,
 -62950,
 169377194,
 2219,
 -62949,
 169439296,
 2211,
 -62948,
 169500423,
 2213,
 -62947,
 169558075,
 2210,
 -62946,
 169619753,
 2224,
 -62945,
 169684449,
 2212,
 -62944,
 169746953,
 2222,
 -1,
 169808032,
 2227,
 170065919,
 167915709,
 -1,
 -62941,
 169940786,
 2297,
 -1,
 170004218,
 2295,
 170199600,
 167866273,
 -1,
 170265135,
 170153326,
 -1,
 170330665,
 170227059,
 -1,
 -62936,
 170268466,
 2286,
 -1,
 170331898,
 2283,
 170527276,
 170284403,
 -1,
 -62933,
 170465074,
 2285,
 -1,
 170528506,
 2282,
 170786815,
 170477936,
 -1,
 -62930,
 170661682,
 2287,
 -1,
 170725114,
 2284,
 -1,
 170228204,
 2275,
 170986039,
 170139902,
 -1,
 171051571,
 170934593,
 2278,
 -1,
 171012248,
 2281,
 171182645,
 170995117,
 2276,
 -1,
 171143320,
 2279,
 171376639,
 171123254,
 2277,
 -1,
 171274392,
 2280,
 171444795,
 170943401,
 -1,
 171510330,
 171380474,
 2296,
 -1,
 171443716,
 2301,
 -1,
 171448114,
 2298,
 171706943,
 171398847,
 -1,
 -62915,
 171655516,
 2290,
 -62914,
 171716031,
 2288,
 -1,
 171778620,
 2289,
 171969091,
 171647315,
 -1,
 172034626,
 171923561,
 2299,
 -1,
 171968004,
 2300,
 -1,
 171971041,
 2302,
 172231238,
 171912627,
 -1,
 -62907,
 172189045,
 2292,
 -1,
 172237862,
 2293,
 -62905,
 172195221,
 1631,
 -62904,
 172380857,
 1541,
 -1,
 172441927,
 2294,
 172624460,
 152728101,
 -1,
 -62901,
 172584427,
 127912,
 -1,
 172630214,
 128667,
 -1,
 172575957,
 1423,
 172886773,
 152650394,
 -1,
 172952305,
 172825740,
 -1,
 173017704,
 172910575,
 -1,
 173083226,
 172979642,
 -1,
 173148761,
 173021370,
 -1,
 173214296,
 173090472,
 -1,
 173279830,
 173172846,
 -1,
 -62891,
 173219697,
 128807,
 -1,
 173282055,
 128814,
 -62889,
 173219697,
 128802,
 -1,
 173413127,
 128812,
 -1,
 173161865,
 128862,
 -1,
 173098896,
 128781,
 173738592,
 173019439,
 -1,
 173804127,
 173698977,
 128788,
 173932543,
 173736692,
 -1,
 -62882,
 173809528,
 128806,
 -1,
 173871879,
 128813,
 -1,
 173737839,
 128825,
 174131812,
 173698977,
 -1,
 174197347,
 174088512,
 128860,
 -1,
 174131052,
 128861,
 -1,
 174134277,
 128850,
 -62875,
 174087295,
 128839,
 -62874,
 174347073,
 128852,
 -62873,
 174406327,
 128795,
 -1,
 174463978,
 128847,
 174656123,
 172953161,
 -1,
 174721648,
 174612270,
 -1,
 174787183,
 174653440,
 -1,
 174852717,
 174750813,
 128776,
 -1,
 174786412,
 128777,
 175046655,
 174809779,
 128774,
 -1,
 174917484,
 128775,
 -1,
 174731138,
 128773,
 175180405,
 174670490,
 -1,
 175245939,
 175128858,
 128822,
 -1,
 175179628,
 128823,
 -62860,
 175208389,
 128837,
 -1,
 175319353,
 128874,
 -62858,
 175143382,
 128829,
 -62857,
 175467117,
 128855,
 -62856,
 175531917,
 128826,
 -62855,
 175592085,
 128811,
 -62854,
 175655713,
 128859,
 -1,
 175717840,
 128769,
 175901327,
 174594635,
 -1,
 175966855,
 175857646,
 -1,
 176032387,
 175929089,
 128869,
 176160767,
 175966058,
 -1,
 -62848,
 176032604,
 128873,
 -62847,
 176097984,
 128872,
 -62846,
 176163335,
 128871,
 -1,
 176228655,
 128870,
 176488447,
 175985571,
 -1,
 176491142,
 176365425,
 128803,
 -1,
 176424812,
 128804,
 -1,
 176438858,
 128798,
 176687755,
 175902281,
 -1,
 -62839,
 176643803,
 128846,
 -62838,
 176704132,
 128844,
 -1,
 176760385,
 128848,
 176949902,
 176641792,
 -1,
 -62835,
 176904036,
 128800,
 -1,
 176952059,
 128805,
 -1,
 176897245,
 128787,
 177212063,
 175857646,
 -1,
 177277597,
 177153669,
 -1,
 177343130,
 177222475,
 128818,
 177408662,
 177276778,
 -1,
 -62828,
 177343168,
 128821,
 -62827,
 177408519,
 128820,
 -1,
 177473839,
 128819,
 177733631,
 177341172,
 -1,
 177736345,
 177607431,
 128816,
 -1,
 177669996,
 128817,
 -1,
 177684042,
 128799,
 177932956,
 177279335,
 128827,
 -1,
 177866604,
 128828,
 -1,
 177894269,
 128877,
 178192383,
 177230707,
 128792,
 -1,
 178063212,
 128793,
 178260650,
 177149469,
 -1,
 178326180,
 178214737,
 128834,
 178454527,
 178259818,
 -1,
 -62813,
 178326023,
 128836,
 -1,
 178391343,
 128835,
 178588327,
 178263326,
 -1,
 -62810,
 178551493,
 128876,
 -1,
 178604960,
 128875,
 -62808,
 178545531,
 128857,
 -62807,
 178733841,
 128783,
 -1,
 178798198,
 128830,
 178981556,
 178223788,
 -1,
 179047091,
 178927592,
 -1,
 179112625,
 178999290,
 128778,
 179178160,
 179046250,
 -1,
 -62801,
 179112455,
 128780,
 -1,
 179177775,
 128779,
 -1,
 179110649,
 128815,
 179503103,
 179074208,
 128790,
 -1,
 179373932,
 128791,
 -1,
 178989785,
 128808,
 179636926,
 178936446,
 -1,
 179702457,
 179589905,
 -1,
 179767992,
 179666403,
 128843,
 -1,
 179709857,
 128858,
 -1,
 179728305,
 128856,
 179964604,
 179664314,
 -1,
 -62789,
 179926000,
 128868,
 -1,
 179987351,
 128867,
 -62787,
 179921414,
 128863,
 -1,
 180106793,
 128782,
 180292294,
 179597217,
 -1,
 180357826,
 180239092,
 -1,
 -62783,
 180297915,
 128840,
 -1,
 180355907,
 128809,
 180554436,
 180294765,
 128831,
 -1,
 180488044,
 128832,
 -62779,
 180517537,
 128845,
 -1,
 180642688,
 128849,
 180816589,
 180243087,
 -1,
 180882123,
 180759240,
 128784,
 181010431,
 180815722,
 -1,
 -62774,
 180881927,
 128786,
 -1,
 180947247,
 128785,
 -62772,
 180835898,
 128881,
 -1,
 181080941,
 128824,
 181275348,
 180761468,
 -1,
 181340881,
 181228305,
 -1,
 -62768,
 181303727,
 128878,
 -1,
 181364612,
 128854,
 181600255,
 181277014,
 -1,
 -62765,
 181491891,
 128883,
 -1,
 181544478,
 128882,
 181734106,
 181215571,
 -1,
 181799641,
 181681757,
 -1,
 181865176,
 181759254,
 128865,
 -1,
 181798764,
 128866,
 -1,
 181826161,
 128864,
 -1,
 181736956,
 128880,
 182127326,
 181681738,
 -1,
 182192861,
 182059843,
 128796,
 -1,
 182126444,
 128797,
 -1,
 182126457,
 128801,
 182389473,
 182091006,
 -1,
 -62752,
 182354246,
 128842,
 -1,
 182415629,
 128772,
 182586084,
 182345706,
 -1,
 -62749,
 182538885,
 128768,
 -1,
 182590863,
 128833,
 182782695,
 182538427,
 -1,
 -62746,
 182744044,
 128789,
 -1,
 182792767,
 128879,
 182979306,
 182731418,
 -1,
 -62743,
 182932396,
 128851,
 -1,
 182986487,
 128810,
 183175917,
 182923505,
 -1,
 -62740,
 183138245,
 128841,
 -1,
 183194754,
 128794,
 -62738,
 183138768,
 128853,
 -62737,
 183325716,
 128838,
 -62736,
 183381625,
 128770,
 -1,
 183445281,
 128771,
 -62734,
 172903055,
 983201,
 -62733,
 183581006,
 128126,
 -62732,
 183642941,
 983054,
 -1,
 183702511,
 9200,
 183896900,
 172832431,
 -1,
 183962394,
 183846615,
 -1,
 184027899,
 183914245,
 -1,
 -62727,
 183992866,
 71440,
 -62726,
 184037655,
 71426,
 -1,
 184094281,
 71427,
 184290047,
 183963209,
 71442,
 184418303,
 184240704,
 -1,
 -62722,
 184315928,
 71429,
 -1,
 184365335,
 71446,
 184552194,
 184250273,
 -1,
 -62719,
 184497034,
 71436,
 -1,
 184553033,
 71428,
 184748805,
 184507006,
 -1,
 -62716,
 184693642,
 71431,
 -1,
 184749641,
 71430,
 184945416,
 184697001,
 -1,
 -62713,
 184890250,
 71425,
 -1,
 184946249,
 71424,
 185142027,
 184893429,
 -1,
 -62710,
 185086858,
 71449,
 -1,
 185142857,
 71434,
 185338638,
 185086193,
 -1,
 -62707,
 185283466,
 71447,
 -1,
 185339465,
 71445,
 185535249,
 185278803,
 -1,
 -62704,
 185480074,
 71444,
 -1,
 185536073,
 71443,
 185731860,
 185472541,
 -1,
 -62701,
 185676682,
 71448,
 -1,
 185732681,
 71432,
 -62699,
 185690188,
 71439,
 -62698,
 185884732,
 71437,
 -62697,
 185944792,
 71433,
 -62696,
 186008276,
 71438,
 -62695,
 186069898,
 71441,
 -1,
 186129468,
 71435,
 186321702,
 183925963,
 -1,
 186387232,
 186256969,
 71456,
 -62691,
 186350822,
 71463,
 -62690,
 186403471,
 71466,
 -62689,
 186464232,
 71465,
 -1,
 186519113,
 71457,
 186714914,
 186348986,
 71460,
 -1,
 186676666,
 71461,
 186845988,
 186660840,
 71458,
 -1,
 186791912,
 71459,
 -62683,
 186798865,
 71464,
 -1,
 186918533,
 71462,
 187108148,
 186262404,
 -1,
 187173674,
 187068321,
 -1,
 -62679,
 187138120,
 71474,
 -1,
 187184936,
 71475,
 187370285,
 187131887,
 -1,
 -62676,
 187318161,
 71478,
 -1,
 187378811,
 71479,
 187566896,
 187313451,
 -1,
 -62673,
 187521221,
 71476,
 -1,
 187580161,
 71477,
 -62671,
 187532214,
 71472,
 -62670,
 187716970,
 71473,
 -62669,
 187781332,
 71481,
 -1,
 187836571,
 71480,
 188025660,
 187066351,
 -1,
 188091195,
 187972142,
 -1,
 188156729,
 188049391,
 -1,
 -62664,
 188107612,
 71484,
 -1,
 188163979,
 71485,
 -62662,
 188114898,
 71486,
 -1,
 188301770,
 71467,
 -1,
 188056332,
 71487,
 188549953,
 187965186,
 -1,
 188615488,
 188498586,
 -1,
 -62657,
 188561766,
 71455,
 -1,
 188616265,
 71453,
 -1,
 188571708,
 71454,
 188940287,
 188502731,
 -1,
 -62653,
 188841485,
 71483,
 -1,
 188885333,
 71482,
 189074249,
 183858618,
 -1,
 189139784,
 189035301,
 -1,
 -62649,
 189092677,
 128663,
 -1,
 189142263,
 127975,
 -1,
 189077334,
 127814,
 189401933,
 189024911,
 -1,
 -62645,
 189357140,
 127994,
 -62644,
 189410037,
 127944,
 -1,
 189471238,
 128657,
 189664080,
 189361636,
 -1,
 -62641,
 189621943,
 9954,
 -1,
 189683180,
 128562,
 189860691,
 189618814,
 -1,
 -62638,
 189816008,
 983194,
 -1,
 189864523,
 983195,
 190057302,
 189808207,
 -1,
 -62635,
 189997779,
 128747,
 -1,
 190059539,
 128748,
 190253912,
 189996419,
 983053,
 -1,
 190206469,
 983052,
 -62631,
 190214518,
 128095,
 -62630,
 190327527,
 128673,
 -1,
 190391275,
 127903,
 190582912,
 109254173,
 -1,
 190648116,
 190516809,
 -1,
 190713487,
 190598885,
 -1,
 190778429,
 190654087,
 -1,
 190843803,
 190729989,
 -1,
 190909306,
 190787825,
 -1,
 190974826,
 190857385,
 -1,
 191040357,
 190936506,
 -1,
 -62620,
 190995070,
 92598,
 -1,
 191056527,
 92619,
 191236968,
 190983161,
 -1,
 -62617,
 191201606,
 92543,
 -1,
 191238108,
 92553,
 191496191,
 191172169,
 92531,
 -1,
 191369688,
 92601,
 191564659,
 190918897,
 -1,
 191630191,
 191526330,
 -1,
 -62611,
 191586396,
 92550,
 -62610,
 191650430,
 92624,
 -1,
 191696916,
 92563,
 191954943,
 191571589,
 -1,
 191957874,
 191854152,
 92607,
 -1,
 191917985,
 92535,
 -1,
 191899632,
 92557,
 192154485,
 191526472,
 92640,
 -1,
 192114593,
 92657,
 192285560,
 192107281,
 -1,
 -62601,
 192241406,
 92544,
 -1,
 192305790,
 92541,
 -62599,
 192228431,
 92579,
 -1,
 192417353,
 92658,
 192613252,
 190849363,
 -1,
 192678784,
 192548425,
 -1,
 192744319,
 192613963,
 -1,
 -62594,
 192703757,
 92562,
 -1,
 192761596,
 92637,
 -1,
 192699006,
 92518,
 193006467,
 192624616,
 -1,
 -62590,
 192962302,
 92558,
 -1,
 193008470,
 92592,
 -1,
 192968679,
 92528,
 193268618,
 192561141,
 -1,
 193334153,
 193209989,
 -1,
 193399688,
 193275525,
 92628,
 -1,
 193331672,
 92648,
 -1,
 193362601,
 92547,
 -1,
 193269734,
 92554,
 193661839,
 193227181,
 -1,
 193727374,
 193623482,
 -1,
 -62579,
 193681040,
 92527,
 -1,
 193734277,
 92545,
 -1,
 193673546,
 92540,
 193989522,
 193626939,
 -1,
 -62575,
 193952162,
 92609,
 -1,
 193991510,
 92583,
 194186133,
 193954470,
 -1,
 -62572,
 194125282,
 92589,
 -1,
 194189166,
 92608,
 194382744,
 194146209,
 -1,
 -62569,
 194344901,
 92604,
 -1,
 194384669,
 92622,
 194579354,
 194317897,
 92662,
 -1,
 194520709,
 92613,
 -1,
 194527784,
 92584,
 194775987,
 190798462,
 -1,
 194841506,
 194737594,
 92576,
 194907040,
 194776649,
 -1,
 -62561,
 194862846,
 92618,
 -1,
 194913925,
 92529,
 -62559,
 194857615,
 92561,
 -1,
 195044997,
 92649,
 195234728,
 194776649,
 -1,
 195300261,
 195169865,
 92524,
 -1,
 195250831,
 92536,
 195493887,
 195232677,
 -1,
 -62553,
 195381880,
 92634,
 -1,
 195439172,
 92625,
 195627948,
 195180520,
 92663,
 195756031,
 195569285,
 -1,
 -62549,
 195653537,
 92621,
 -1,
 195701367,
 92593,
 195890097,
 195569285,
 -1,
 195955632,
 195851706,
 -1,
 -62545,
 195920198,
 92647,
 -1,
 195981217,
 92605,
 -1,
 195897646,
 92548,
 196280319,
 195842833,
 92568,
 -1,
 196171029,
 92610,
 196348870,
 194726543,
 -1,
 196414393,
 196283977,
 92667,
 196479927,
 196355717,
 92600,
 -1,
 196430479,
 92542,
 -62536,
 196435710,
 92668,
 -1,
 196565630,
 92555,
 196742075,
 196360168,
 92654,
 -1,
 196683757,
 92611,
 196873150,
 196686189,
 -1,
 -62531,
 196815189,
 92581,
 -1,
 196873801,
 92551,
 197069761,
 196810490,
 -1,
 -62528,
 197031877,
 92520,
 -1,
 197076613,
 92582,
 -62526,
 197032988,
 92617,
 -62525,
 197228104,
 92614,
 -62524,
 197285141,
 92671,
 -62523,
 197340681,
 92591,
 -1,
 197405013,
 92666,
 197594073,
 196308897,
 -1,
 197659597,
 197529161,
 -1,
 197725130,
 197594697,
 92635,
 -1,
 197680894,
 92577,
 -62517,
 197680894,
 92636,
 -62516,
 197806735,
 92530,
 -1,
 197863772,
 92559,
 198052817,
 197621178,
 -1,
 198118352,
 198003343,
 92586,
 -1,
 198053849,
 92569,
 -1,
 198053849,
 92566,
 198314965,
 198005521,
 -1,
 198380500,
 198267665,
 92537,
 -1,
 198332165,
 92519,
 -1,
 198336254,
 92630,
 198639615,
 198256261,
 -1,
 198642648,
 198538682,
 92669,
 -1,
 198578186,
 92572,
 -1,
 198594309,
 92672,
 198839275,
 197558742,
 -1,
 198904799,
 198800826,
 -1,
 -62500,
 198860542,
 92644,
 -62499,
 198921989,
 92645,
 -62498,
 198978167,
 92594,
 -1,
 199036915,
 92641,
 199232484,
 198847481,
 -1,
 199298018,
 199167961,
 92567,
 -1,
 199258017,
 92623,
 -62493,
 199262534,
 92639,
 -1,
 199379599,
 92606,
 199560167,
 199186186,
 -1,
 -62490,
 199520059,
 92642,
 -1,
 199565252,
 92643,
 199756778,
 199505896,
 -1,
 -62487,
 199716769,
 92590,
 -1,
 199763949,
 92564,
 -1,
 199693085,
 92588,
 200018935,
 198797295,
 -1,
 200084465,
 199963516,
 -1,
 200149999,
 200037137,
 92659,
 -1,
 200105726,
 92660,
 -62480,
 200097229,
 92638,
 -1,
 200223771,
 92580,
 200412148,
 200025733,
 -1,
 -62477,
 200372129,
 92560,
 -1,
 200418949,
 92534,
 -62475,
 200373841,
 92571,
 -62474,
 200561839,
 92525,
 -1,
 200609421,
 92549,
 200805380,
 199967386,
 -1,
 200870910,
 200758033,
 -1,
 200936444,
 200823569,
 -1,
 -62469,
 200896417,
 92556,
 -1,
 200953605,
 92523,
 -62467,
 200892158,
 92664,
 -1,
 201083535,
 92539,
 201264130,
 200805961,
 -1,
 -62464,
 201219838,
 92633,
 -62463,
 201284222,
 92521,
 -1,
 201331115,
 92575,
 -62461,
 201225658,
 92653,
 -1,
 201468936,
 92595,
 201657361,
 200753321,
 -1,
 201722889,
 201618874,
 -1,
 -62457,
 201682849,
 92620,
 -62456,
 201741968,
 92538,
 -1,
 201796544,
 92587,
 201985038,
 201664133,
 -1,
 202050573,
 201946554,
 -1,
 -62452,
 202015046,
 92646,
 -1,
 202051545,
 92570,
 -1,
 202010529,
 92599,
 -62449,
 201940020,
 92532,
 -62448,
 202265361,
 92665,
 -1,
 202323944,
 92670,
 202509341,
 201600299,
 -1,
 202574873,
 202470842,
 -1,
 202640407,
 202506240,
 -1,
 -62443,
 202597087,
 92661,
 -62442,
 202651624,
 92616,
 -1,
 202709659,
 92626,
 202964991,
 202581637,
 92596,
 -1,
 202862497,
 92612,
 203033627,
 202509897,
 92603,
 -1,
 202989310,
 92673,
 -62436,
 202986671,
 92627,
 -1,
 203106285,
 92651,
 203295786,
 202453233,
 -1,
 203361319,
 203240316,
 -1,
 203426853,
 203302533,
 -1,
 203492388,
 203388346,
 -1,
 -62430,
 203456838,
 92552,
 -62429,
 203509509,
 92565,
 -1,
 203558873,
 92615,
 -1,
 203452321,
 92602,
 -62426,
 203379887,
 92674,
 -1,
 203755156,
 92578,
 204013567,
 203298554,
 -1,
 -62423,
 203913897,
 92597,
 -1,
 203976609,
 92585,
 204147760,
 203251694,
 -1,
 204213294,
 204082761,
 -1,
 -62419,
 204168958,
 92526,
 -1,
 204220037,
 92656,
 -62417,
 204159704,
 92546,
 -1,
 204352631,
 92655,
 204540981,
 204111078,
 -1,
 204606516,
 204502458,
 -1,
 -62413,
 204559121,
 92533,
 -1,
 204613253,
 92650,
 -1,
 204549239,
 92574,
 204868666,
 204503724,
 -1,
 204934201,
 204809861,
 -1,
 -62408,
 204895816,
 92573,
 -1,
 204940933,
 92652,
 -1,
 204887215,
 92522,
 -62405,
 204821265,
 92631,
 -62404,
 205141992,
 92632,
 -1,
 205196873,
 92629,
 205393124,
 190718293,
 -1,
 205458546,
 205344517,
 -1,
 205524048,
 205402353,
 -1,
 205589576,
 205471913,
 -1,
 205655108,
 205532153,
 -1,
 -62397,
 205611863,
 92432,
 -1,
 205656074,
 92457,
 -62395,
 205619797,
 92435,
 -62394,
 205813735,
 92412,
 -62393,
 205863242,
 92476,
 -1,
 205919005,
 92414,
 206176255,
 205533425,
 -1,
 206179405,
 206048841,
 -1,
 206244940,
 206115243,
 92465,
 -1,
 206180313,
 92409,
 -1,
 206199422,
 92483,
 -62386,
 206142725,
 92467,
 -62385,
 206403618,
 92485,
 -1,
 206449783,
 92475,
 206638168,
 205471733,
 -1,
 206703699,
 206583784,
 92403,
 -1,
 206645229,
 92405,
 206834774,
 206646265,
 -1,
 -62379,
 206794657,
 92407,
 -1,
 206835676,
 92430,
 -62377,
 206796637,
 92487,
 -1,
 206967581,
 92418,
 207162464,
 206596079,
 -1,
 207227996,
 207108426,
 -1,
 -62373,
 207187873,
 92459,
 -1,
 207247998,
 92447,
 207424607,
 207172476,
 -1,
 -62370,
 207387223,
 92486,
 -1,
 207431661,
 92408,
 -1,
 207386565,
 92480,
 207686757,
 207126998,
 -1,
 -62366,
 207648574,
 92463,
 -62365,
 207697896,
 92493,
 -62364,
 207760320,
 92450,
 -1,
 207819179,
 92410,
 208014443,
 207626579,
 -1,
 208079977,
 207955589,
 -1,
 -62360,
 208042665,
 92425,
 -1,
 208086661,
 92437,
 -62358,
 208033045,
 92440,
 -1,
 208212395,
 92471,
 208407664,
 207974305,
 -1,
 208473199,
 208348805,
 -1,
 -62354,
 208435141,
 92472,
 -1,
 208479877,
 92505,
 -1,
 208435878,
 92514,
 -62351,
 208369082,
 92503,
 -1,
 208680936,
 92507,
 208866445,
 205408911,
 92497,
 208931962,
 208809259,
 -1,
 208997494,
 208884497,
 92445,
 -1,
 208948997,
 92404,
 209128569,
 208940025,
 -1,
 -62344,
 209088417,
 92424,
 -1,
 209129433,
 92458,
 -1,
 209074506,
 92466,
 209390718,
 208875885,
 -1,
 -62340,
 209343449,
 92438,
 -62339,
 209402186,
 92444,
 -1,
 209464366,
 92442,
 209652867,
 209331845,
 -1,
 209718402,
 209614266,
 -1,
 -62335,
 209678241,
 92427,
 -1,
 209735429,
 92478,
 -1,
 209659888,
 92496,
 209980551,
 209589789,
 -1,
 210046086,
 209915533,
 92448,
 -1,
 209978433,
 92515,
 -1,
 210008095,
 92401,
 210242698,
 209915465,
 -1,
 -62327,
 210191604,
 92426,
 -1,
 210250196,
 92482,
 -62325,
 210205857,
 92510,
 -62324,
 210400698,
 92499,
 -1,
 210458088,
 92441,
 210635936,
 208824303,
 -1,
 210701463,
 210580348,
 -1,
 210766996,
 210642565,
 -1,
 210832531,
 210728378,
 -1,
 -62318,
 210796870,
 92501,
 -1,
 210833369,
 92417,
 -1,
 210773637,
 92413,
 -62315,
 210728378,
 92504,
 -62314,
 211048199,
 92508,
 -1,
 211106411,
 92500,
 211291291,
 210662842,
 -1,
 -62311,
 211252666,
 92498,
 -62310,
 211297925,
 92419,
 -1,
 211357657,
 92473,
 211553438,
 211226185,
 -1,
 -62307,
 211508990,
 92516,
 -1,
 211573374,
 92423,
 -62305,
 211507128,
 92452,
 -1,
 211692571,
 92428,
 211881134,
 210583721,
 -1,
 211946664,
 211822213,
 -1,
 212012199,
 211908026,
 -1,
 -62300,
 211966590,
 92460,
 -62299,
 212031430,
 92431,
 -62298,
 212093583,
 92454,
 -1,
 212144160,
 92415,
 -1,
 211972001,
 92420,
 212405420,
 211908026,
 92489,
 -62294,
 212360958,
 92479,
 -62293,
 212423855,
 92422,
 -1,
 212487941,
 92474,
 -62291,
 212370005,
 92502,
 -1,
 212630794,
 92449,
 212798650,
 211840929,
 -1,
 212864181,
 212739717,
 -1,
 212929716,
 212825530,
 -1,
 -62286,
 212889505,
 92416,
 -62285,
 212946693,
 92481,
 -1,
 212996083,
 92451,
 -1,
 212871152,
 92456,
 213257399,
 212825530,
 92433,
 -1,
 213211064,
 92477,
 -62280,
 213210887,
 92492,
 -62279,
 213333992,
 92513,
 -1,
 213389273,
 92491,
 213585092,
 212746906,
 -1,
 213650625,
 213526149,
 -1,
 213716159,
 213611962,
 -1,
 -62274,
 213666447,
 92484,
 -1,
 213716992,
 92439,
 -62272,
 213675937,
 92464,
 -1,
 213854192,
 92495,
 -62270,
 213612485,
 92446,
 -62269,
 213997319,
 92511,
 -1,
 214055242,
 92406,
 214240461,
 213539454,
 -1,
 214305992,
 214201786,
 -1,
 -62265,
 214268503,
 92443,
 -1,
 214327038,
 92509,
 214502603,
 214247045,
 -1,
 -62262,
 214465114,
 92462,
 -1,
 214509189,
 92506,
 -62260,
 214449549,
 92461,
 -1,
 214635293,
 92469,
 214830293,
 214204886,
 -1,
 214895827,
 214791610,
 -1,
 214961362,
 214848273,
 -1,
 -62255,
 214915710,
 92470,
 -1,
 214977167,
 92468,
 -1,
 214925515,
 92453,
 -62252,
 214837589,
 92429,
 -1,
 215158764,
 92421,
 215354587,
 214786030,
 -1,
 215420121,
 215296344,
 -1,
 -62248,
 215372930,
 92490,
 -1,
 215437015,
 92512,
 -62246,
 215366251,
 92494,
 -1,
 215551964,
 92455,
 215747806,
 215317734,
 -1,
 -62243,
 215709265,
 92411,
 -1,
 215749405,
 92402,
 215944417,
 215691798,
 -1,
 -62240,
 215886851,
 92488,
 -1,
 215944845,
 92434,
 216203263,
 215887147,
 -1,
 -62237,
 216083489,
 92436,
 -1,
 216141453,
 92517,
 216337783,
 205331021,
 -1,
 216403225,
 216289029,
 -1,
 216468723,
 216346865,
 -1,
 216534254,
 216412401,
 -1,
 216599789,
 216495546,
 92362,
 -62230,
 216552725,
 92341,
 -62229,
 216615567,
 92347,
 -62228,
 216672307,
 92370,
 -1,
 216731639,
 92336,
 -1,
 216541525,
 92307,
 216993009,
 216481961,
 -1,
 -62224,
 216954693,
 92303,
 -1,
 216994646,
 92309,
 -62222,
 216945839,
 92368,
 -1,
 217125718,
 92395,
 217320699,
 216426479,
 -1,
 217386231,
 217281978,
 -1,
 -62218,
 217339855,
 92359,
 -1,
 217403141,
 92374,
 -62216,
 217339055,
 92371,
 -62215,
 217527481,
 92351,
 -62214,
 217590798,
 92325,
 -1,
 217648713,
 92350,
 217844996,
 217260371,
 -1,
 217910527,
 217787385,
 -1,
 -62210,
 217870241,
 92349,
 -1,
 217911310,
 92308,
 218107138,
 217845321,
 -1,
 -62207,
 218061438,
 92378,
 -1,
 218122895,
 92375,
 -62205,
 218060017,
 92317,
 -1,
 218249512,
 92331,
 218434828,
 217792501,
 -1,
 218500360,
 218375813,
 -1,
 -62201,
 218462889,
 92389,
 -1,
 218507248,
 92360,
 218696971,
 218435145,
 -1,
 -62198,
 218647183,
 92367,
 -1,
 218704174,
 92356,
 -1,
 218658653,
 92333,
 218959122,
 218394529,
 -1,
 219024656,
 218900101,
 -1,
 -62193,
 218986511,
 92345,
 -1,
 219041541,
 92372,
 -62191,
 218985930,
 92314,
 -1,
 219156109,
 92340,
 219352341,
 218923835,
 -1,
 -62188,
 219294762,
 92323,
 -1,
 219352649,
 92304,
 219548952,
 219287113,
 -1,
 -62185,
 219504382,
 92396,
 -1,
 219566660,
 92338,
 -1,
 219513543,
 92313,
 219811126,
 216353423,
 -1,
 219876652,
 219747869,
 -1,
 219942177,
 219817605,
 -1,
 220007711,
 219903418,
 -1,
 -62178,
 219971910,
 92385,
 -1,
 220023439,
 92315,
 -62176,
 219963484,
 92354,
 -1,
 220145885,
 92311,
 220335396,
 219887592,
 92381,
 -62173,
 220295073,
 92326,
 -1,
 220357521,
 92343,
 220532009,
 220270153,
 -1,
 220597544,
 220466763,
 -1,
 -62169,
 220552285,
 92387,
 -1,
 220600929,
 92318,
 -1,
 220549891,
 92383,
 220921855,
 220493242,
 -1,
 -62165,
 220800645,
 92324,
 -1,
 220860380,
 92364,
 221056307,
 219811401,
 -1,
 221121840,
 220997253,
 -1,
 -62161,
 221080344,
 92363,
 -1,
 221137858,
 92382,
 221380607,
 221052928,
 -1,
 -62158,
 221270620,
 92376,
 -1,
 221331877,
 92339,
 -62156,
 221017672,
 92391,
 -62155,
 221460810,
 92390,
 -1,
 221524342,
 92344,
 221711687,
 219758761,
 -1,
 221777218,
 221652613,
 -1,
 221842750,
 221738426,
 -1,
 221908284,
 221800431,
 -1,
 -62149,
 221853123,
 92319,
 -1,
 221916279,
 92384,
 -62147,
 221858447,
 92386,
 -1,
 222052648,
 92321,
 222235969,
 221794055,
 -1,
 -62144,
 222184477,
 92393,
 -1,
 222244296,
 92394,
 -1,
 222195617,
 92361,
 222498117,
 221738426,
 -1,
 -62140,
 222457761,
 92366,
 -1,
 222516883,
 92373,
 -62138,
 222452525,
 92328,
 -1,
 222629517,
 92329,
 222825806,
 221675990,
 -1,
 222891340,
 222787002,
 -1,
 -62134,
 222855371,
 92388,
 -62133,
 222907023,
 92305,
 -1,
 222954186,
 92322,
 -62131,
 222833733,
 92327,
 -1,
 223088269,
 92377,
 223284566,
 222785441,
 -1,
 223350098,
 223231670,
 -1,
 -62127,
 223311446,
 92358,
 -1,
 223350389,
 92334,
 223546709,
 223291013,
 -1,
 -62124,
 223509098,
 92346,
 -1,
 223571873,
 92400,
 -1,
 223481504,
 92332,
 223808862,
 223242223,
 -1,
 223874394,
 223753084,
 -1,
 -62119,
 223835997,
 92379,
 -1,
 223886797,
 92392,
 224071005,
 223815301,
 -1,
 -62116,
 224033449,
 92330,
 -1,
 224096546,
 92380,
 -1,
 224032354,
 92335,
 224333156,
 223756954,
 -1,
 224398690,
 224267849,
 -1,
 -62111,
 224352894,
 92342,
 -1,
 224414351,
 92357,
 -62109,
 224359866,
 92365,
 -1,
 224542157,
 92397,
 224726377,
 224287358,
 -1,
 224791912,
 224671720,
 -1,
 -62105,
 224748433,
 92316,
 -1,
 224808709,
 92398,
 -1,
 224733525,
 92399,
 225054062,
 224669937,
 -1,
 225119597,
 224998282,
 -1,
 -62100,
 225075292,
 92310,
 -1,
 225139326,
 92320,
 -1,
 225056471,
 92312,
 225381745,
 225017062,
 -1,
 -62096,
 225343530,
 92369,
 -1,
 225383061,
 92306,
 225578356,
 225344511,
 -1,
 -62093,
 225542470,
 92337,
 -1,
 225579012,
 92353,
 -62091,
 225535935,
 92355,
 -62090,
 225718499,
 92348,
 -1,
 225778190,
 92352,
 225971701,
 216272459,
 -1,
 226037147,
 225922821,
 -1,
 226102655,
 225996705,
 -1,
 226168190,
 226038557,
 92223,
 226295807,
 226099200,
 -1,
 -62083,
 226185856,
 92194,
 -1,
 226249991,
 92185,
 -1,
 226121499,
 92178,
 226495877,
 226046193,
 -1,
 226561411,
 226443860,
 -1,
 -62078,
 226513675,
 92182,
 -1,
 226558629,
 92160,
 -62076,
 226505175,
 92229,
 -1,
 226693826,
 92173,
 226889097,
 226460118,
 -1,
 226954632,
 226834408,
 92239,
 -1,
 226914262,
 92225,
 -1,
 226896832,
 92233,
 227151244,
 226853691,
 -1,
 -62069,
 227112938,
 92191,
 -1,
 227151458,
 92167,
 227347855,
 227109293,
 -1,
 -62066,
 227293514,
 92237,
 -1,
 227348041,
 92241,
 227544466,
 227295401,
 -1,
 -62063,
 227490782,
 92180,
 -1,
 227544730,
 92227,
 227741077,
 227484126,
 -1,
 -62060,
 227676811,
 92212,
 -1,
 227738216,
 92201,
 227937688,
 227675721,
 -1,
 -62057,
 227892990,
 92245,
 -1,
 227937890,
 92164,
 -62055,
 227885091,
 92231,
 -62054,
 228080238,
 92204,
 -1,
 228141397,
 92244,
 228330930,
 225987215,
 -1,
 228396455,
 228265545,
 -1,
 228461989,
 228337285,
 -1,
 228527522,
 228412047,
 92238,
 -62048,
 228490258,
 92174,
 -62047,
 228540980,
 92203,
 -1,
 228595637,
 92171,
 -62045,
 228485912,
 92230,
 -62044,
 228741891,
 92210,
 -1,
 228802989,
 92186,
 -62042,
 228416141,
 92221,
 -1,
 228938338,
 92175,
 229117356,
 228348689,
 -1,
 229182891,
 229069999,
 -1,
 -62038,
 229138127,
 92198,
 -1,
 229190771,
 92214,
 -1,
 229134090,
 92190,
 229445039,
 229053998,
 -1,
 -62034,
 229400318,
 92246,
 -1,
 229462787,
 92232,
 -62032,
 229407747,
 92176,
 -62031,
 229585264,
 92196,
 -1,
 229649458,
 92197,
 229838274,
 228288495,
 -1,
 229903803,
 229782396,
 -1,
 229969335,
 229864890,
 -1,
 -62026,
 229919375,
 92215,
 -1,
 229976575,
 92165,
 230165946,
 229914600,
 -1,
 -62023,
 230121564,
 92222,
 -1,
 230182843,
 92168,
 -1,
 230119182,
 92224,
 230428095,
 229856017,
 -1,
 -62019,
 230387617,
 92235,
 -62018,
 230448894,
 92220,
 -1,
 230510889,
 92208,
 -62016,
 230390438,
 92181,
 -62015,
 230637152,
 92195,
 -1,
 230698046,
 92177,
 230886867,
 229792382,
 -1,
 230952394,
 230821449,
 -1,
 231017927,
 230886985,
 -1,
 -62010,
 230973532,
 92226,
 -1,
 231033487,
 92236,
 -62008,
 230976017,
 92187,
 -62007,
 231165620,
 92189,
 -1,
 231211624,
 92200,
 231411153,
 230905112,
 -1,
 231476686,
 231365283,
 -1,
 -62003,
 231420285,
 92169,
 -1,
 231478830,
 92170,
 231735295,
 231427340,
 -1,
 -62000,
 231616893,
 92162,
 -1,
 231675438,
 92163,
 -61998,
 231372842,
 92205,
 -1,
 231812032,
 92202,
 232000988,
 230834345,
 -1,
 232066519,
 231941765,
 -1,
 -61994,
 232028052,
 92179,
 -1,
 232091553,
 92211,
 232263130,
 232001097,
 -1,
 -61991,
 232218366,
 92240,
 -1,
 232271183,
 92199,
 -61989,
 232224806,
 92213,
 -1,
 232414584,
 92219,
 232590820,
 231960481,
 -1,
 232656352,
 232551866,
 -1,
 -61985,
 232591360,
 92206,
 -1,
 232653454,
 92172,
 232852963,
 232598521,
 -1,
 -61982,
 232812822,
 92209,
 -1,
 232853491,
 92234,
 -1,
 232799944,
 92166,
 233115114,
 232538778,
 -1,
 233180647,
 233076154,
 92243,
 -1,
 233115648,
 92207,
 -61976,
 233133323,
 92216,
 -61975,
 233253827,
 92184,
 -1,
 233313056,
 92183,
 233508335,
 233058545,
 -1,
 233573870,
 233452989,
 -1,
 -61971,
 233529436,
 92188,
 -1,
 233583146,
 92193,
 -1,
 233510885,
 92161,
 233836018,
 233469370,
 -1,
 -61967,
 233787717,
 92228,
 -1,
 233834337,
 92192,
 -61965,
 233798412,
 92242,
 -61964,
 233989811,
 92218,
 -1,
 234040970,
 92217,
 234229318,
 225908255,
 -1,
 234294793,
 234179215,
 -1,
 234360318,
 234231325,
 -1,
 234425851,
 234294857,
 -1,
 -61958,
 234361704,
 92255,
 -1,
 234422918,
 92252,
 -61956,
 234387494,
 92292,
 -61955,
 234569401,
 92268,
 -1,
 234630230,
 92286,
 234819074,
 234294857,
 92300,
 234946559,
 234750677,
 -1,
 -61951,
 234846629,
 92296,
 -1,
 234892308,
 92295,
 235081221,
 234761515,
 -1,
 -61948,
 235033892,
 92267,
 -1,
 235093987,
 92284,
 235277832,
 235023353,
 -1,
 -61945,
 235237347,
 92290,
 -1,
 235298558,
 92281,
 -1,
 235230783,
 92287,
 235539994,
 234245893,
 -1,
 235605522,
 235483377,
 -1,
 235671056,
 235548913,
 -1,
 235736590,
 235632678,
 92282,
 -1,
 235668065,
 92283,
 -61937,
 235678716,
 92277,
 -1,
 235802256,
 92298,
 -61935,
 235623599,
 92302,
 -1,
 235946449,
 92276,
 236129813,
 235569622,
 -1,
 -61932,
 236075015,
 92269,
 -1,
 236130272,
 92288,
 236326424,
 236087279,
 -1,
 -61929,
 236271521,
 92247,
 -1,
 236333397,
 92299,
 -61927,
 236286527,
 92260,
 -1,
 236463657,
 92261,
 236654114,
 235497455,
 -1,
 236719646,
 236598536,
 -1,
 -61923,
 236680795,
 92266,
 -1,
 236744684,
 92265,
 -61921,
 236681022,
 92285,
 -61920,
 236861770,
 92249,
 -61919,
 236923850,
 92250,
 -1,
 236982559,
 92279,
 237178411,
 236601513,
 -1,
 237243943,
 237120505,
 -1,
 -61915,
 237208222,
 92272,
 -61914,
 237264591,
 92270,
 -1,
 237309916,
 92294,
 237506090,
 237189096,
 -1,
 -61911,
 237461246,
 92301,
 -1,
 237512706,
 92253,
 -1,
 237441451,
 92256,
 237768240,
 237132414,
 -1,
 -61907,
 237729800,
 92289,
 -61906,
 237780662,
 92263,
 -61905,
 237840429,
 92257,
 -1,
 237900915,
 92274,
 238095926,
 237716122,
 -1,
 238161460,
 238030409,
 -1,
 -61901,
 238111387,
 92259,
 -1,
 238162450,
 92273,
 -61899,
 238113991,
 92251,
 -1,
 238300096,
 92297,
 238489147,
 238055329,
 -1,
 238554682,
 238450108,
 -1,
 -61895,
 238506588,
 92264,
 -1,
 238570243,
 92248,
 -1,
 238489232,
 92280,
 238816830,
 238453206,
 -1,
 -61891,
 238758985,
 92254,
 -1,
 238817384,
 92258,
 239013441,
 238760497,
 -1,
 -61888,
 238974540,
 92262,
 -1,
 239030021,
 92271,
 239210052,
 238955984,
 -1,
 -61885,
 239172265,
 92291,
 -1,
 239216261,
 92293,
 -61883,
 239173952,
 92278,
 -1,
 239369229,
 92275,
 239599615,
 234171693,
 -1,
 239603285,
 239488773,
 -1,
 239668810,
 239564218,
 92697,
 -1,
 239603673,
 92696,
 239799885,
 239615989,
 -1,
 -61876,
 239760968,
 92698,
 -1,
 239800284,
 92688,
 239996496,
 239743217,
 -1,
 -61873,
 239944323,
 92711,
 -1,
 240005399,
 92712,
 -61871,
 239960739,
 92681,
 -61870,
 240152803,
 92704,
 -61869,
 240216572,
 92702,
 -61868,
 240269288,
 92708,
 -1,
 240329207,
 92687,
 240520798,
 239560687,
 -1,
 240586330,
 240464764,
 -1,
 -61864,
 240547258,
 92700,
 -61863,
 240603921,
 92713,
 -1,
 240663147,
 92691,
 -61861,
 240548518,
 92690,
 -61860,
 240793576,
 92692,
 -61859,
 240856183,
 92693,
 -1,
 240914881,
 92727,
 241110631,
 240468137,
 -1,
 241176162,
 241051269,
 -1,
 -61855,
 241135521,
 92695,
 -1,
 241192709,
 92710,
 -61853,
 241140309,
 92694,
 -61852,
 241333690,
 92677,
 -61851,
 241392288,
 92726,
 -61850,
 241455889,
 92719,
 -1,
 241503817,
 92675,
 241700464,
 241065966,
 -1,
 241765996,
 241641093,
 -1,
 -61846,
 241728169,
 92709,
 -61845,
 241782533,
 92721,
 -1,
 241837701,
 92679,
 242028143,
 241711080,
 -1,
 -61842,
 241973224,
 92683,
 -1,
 242034669,
 92684,
 -1,
 241989050,
 92707,
 242290295,
 241650319,
 92689,
 242355828,
 242226717,
 -1,
 -61837,
 242297173,
 92720,
 -1,
 242355853,
 92724,
 -61835,
 242307857,
 92723,
 -61834,
 242493428,
 92685,
 -1,
 242552393,
 92722,
 242749052,
 242249633,
 -1,
 242814587,
 242683465,
 -1,
 -61830,
 242755205,
 92680,
 -1,
 242814537,
 92686,
 -1,
 242756544,
 92725,
 243076737,
 242702974,
 -1,
 243142272,
 243017349,
 -1,
 -61825,
 243104425,
 92703,
 -1,
 243148421,
 92706,
 -1,
 243103304,
 92714,
 243404421,
 243024538,
 -1,
 -61821,
 243357447,
 92718,
 -61820,
 243415016,
 92717,
 -1,
 243469897,
 92682,
 243666568,
 243368406,
 -1,
 -61817,
 243619591,
 92699,
 -1,
 243666505,
 92701,
 243863179,
 243629286,
 -1,
 -61814,
 243824446,
 92705,
 -1,
 243863113,
 92716,
 -61812,
 243825885,
 92728,
 -61811,
 244020666,
 92676,
 -61810,
 244068189,
 92715,
 -1,
 244131821,
 92678,
 244322009,
 190672801,
 -1,
 244387542,
 244257013,
 -1,
 244453053,
 244336343,
 -1,
 244518560,
 244410351,
 -1,
 244584094,
 244464328,
 -1,
 -61803,
 244548130,
 7132,
 -61802,
 244612350,
 7116,
 -61801,
 244672588,
 7129,
 -61800,
 244736060,
 7123,
 -61799,
 244800160,
 7112,
 -61798,
 244861656,
 7125,
 -61797,
 244925140,
 7135,
 -61796,
 244986762,
 7107,
 -61795,
 245051671,
 7119,
 -1,
 245108297,
 7105,
 -61793,
 244537728,
 7126,
 -1,
 245239369,
 7128,
 245436070,
 244469509,
 -1,
 -61790,
 245400098,
 7136,
 -61789,
 245454739,
 7127,
 -61788,
 245510423,
 7133,
 -61787,
 245572062,
 7138,
 -1,
 245632585,
 7113,
 245829293,
 245385871,
 -1,
 245894828,
 245763657,
 7124,
 246022143,
 245845958,
 -1,
 -61782,
 245917772,
 7130,
 -61781,
 245976938,
 7114,
 -1,
 246035338,
 7108,
 -1,
 245831214,
 7139,
 246288047,
 245783200,
 7111,
 -1,
 246235692,
 7117,
 -61776,
 246252066,
 7131,
 -61775,
 246381822,
 7115,
 -61774,
 246445498,
 7141,
 -61773,
 246505532,
 7122,
 -61772,
 246563540,
 7134,
 -61771,
 246628658,
 7110,
 -61770,
 246693899,
 7120,
 -61769,
 246757352,
 7140,
 -61768,
 246821770,
 7106,
 -61767,
 246886679,
 7118,
 -61766,
 246948318,
 7121,
 -61765,
 247011934,
 7137,
 -61764,
 247076398,
 7109,
 -1,
 247139913,
 7104,
 247336648,
 244415691,
 -1,
 247402176,
 247297466,
 7150,
 -1,
 247333363,
 7151,
 247533251,
 247349548,
 -1,
 -61758,
 247485201,
 7149,
 -1,
 247543784,
 7147,
 247729861,
 247473797,
 7143,
 -1,
 247670405,
 7145,
 -61754,
 247683789,
 7144,
 -61753,
 247812881,
 7148,
 -1,
 247871464,
 7146,
 248057552,
 247293935,
 -1,
 248123087,
 248021731,
 -1,
 248188621,
 248076926,
 -1,
 -61748,
 248134448,
 7165,
 -1,
 248189626,
 7167,
 -61746,
 248139629,
 7164,
 -1,
 248332451,
 7166,
 -1,
 248068702,
 7142,
 248581843,
 248011491,
 -1,
 -61742,
 248534496,
 7155,
 -1,
 248591066,
 7154,
 248840191,
 248520412,
 -1,
 -61739,
 248729718,
 7152,
 -1,
 248787836,
 7153,
 248975064,
 244331388,
 128704,
 -1,
 248935663,
 128705,
 -1,
 248934673,
 128267,
 249171720,
 244279279,
 -1,
 249237255,
 249129039,
 -1,
 249302782,
 249186007,
 -1,
 249368287,
 249243269,
 92908,
 -61730,
 249319767,
 92880,
 -1,
 249374341,
 92907,
 249564898,
 249332182,
 -1,
 -61727,
 249510204,
 92885,
 -1,
 249571542,
 92900,
 249761508,
 249527550,
 92891,
 -1,
 249700987,
 92902,
 249892582,
 249722298,
 92906,
 -1,
 249856317,
 92896,
 250023656,
 249844497,
 92904,
 -1,
 249975569,
 92905,
 250154731,
 249970857,
 -1,
 -61718,
 250108603,
 92888,
 -1,
 250154569,
 92881,
 250351342,
 250097905,
 -1,
 -61715,
 250288622,
 92893,
 -1,
 250351755,
 92886,
 250547953,
 250290515,
 -1,
 -61712,
 250499857,
 92894,
 -1,
 250557989,
 92887,
 -61710,
 250512341,
 92892,
 -61709,
 250707162,
 92899,
 -61708,
 250770170,
 92897,
 -61707,
 250833132,
 92882,
 -61706,
 250895008,
 92901,
 -61705,
 250956742,
 92884,
 -61704,
 251019417,
 92889,
 -61703,
 251082728,
 92909,
 -61702,
 251148249,
 92890,
 -61701,
 251211087,
 92883,
 -61700,
 251272093,
 92895,
 -61699,
 251336238,
 92898,
 -1,
 251399753,
 92903,
 251596550,
 249241171,
 -1,
 251662082,
 251545985,
 -1,
 -61695,
 251594670,
 92915,
 -1,
 251659577,
 92913,
 251858693,
 251606522,
 -1,
 -61692,
 251791255,
 92916,
 -1,
 251856185,
 92912,
 -1,
 251809065,
 92914,
 -1,
 251539687,
 92917,
 -1,
 249184660,
 127936,
 252251926,
 249121055,
 -1,
 252317461,
 252211107,
 -1,
 252382996,
 252254456,
 -1,
 252448531,
 252346710,
 -1,
 252514065,
 252384797,
 -1,
 252579600,
 252466310,
 -1,
 -61681,
 252537059,
 128503,
 -1,
 252583006,
 128505,
 -1,
 252514674,
 128499,
 -61678,
 252471523,
 128501,
 -1,
 252790859,
 11197,
 -1,
 252396630,
 128502,
 -1,
 252340451,
 128500,
 -1,
 252269845,
 127880,
 253169438,
 252202757,
 -1,
 253234973,
 253116585,
 127974,
 253362175,
 253186549,
 -1,
 -61670,
 253264533,
 128180,
 -61669,
 253320626,
 128183,
 -61668,
 253373531,
 128182,
 -1,
 253436944,
 128181,
 -1,
 253170190,
 127820,
 253693737,
 253106763,
 -1,
 253759272,
 253640873,
 -1,
 253824805,
 253716463,
 -1,
 253890340,
 253772626,
 -1,
 -61661,
 253847106,
 11101,
 -1,
 253908055,
 11099,
 -1,
 253844145,
 983056,
 254214143,
 253755392,
 -1,
 -61657,
 254115695,
 128281,
 -1,
 254170049,
 128386,
 -1,
 253719561,
 128043,
 254414639,
 253631048,
 128118,
 254541823,
 254345216,
 -1,
 -61652,
 254439282,
 128700,
 -61651,
 254483629,
 128036,
 -61650,
 254548326,
 127868,
 -1,
 254612088,
 128124,
 254807858,
 254369774,
 -1,
 -61647,
 254744397,
 128136,
 -1,
 254804319,
 128202,
 -61645,
 254751206,
 128708,
 -1,
 254944203,
 127992,
 255135699,
 190603246,
 -1,
 255201226,
 255070350,
 -1,
 255266682,
 255149783,
 -1,
 255332158,
 255228588,
 -1,
 255397693,
 255284058,
 -1,
 255463227,
 255352814,
 69643,
 -1,
 255418350,
 69644,
 255655935,
 255410842,
 69645,
 -1,
 255541914,
 69646,
 -1,
 255331913,
 69679,
 255790916,
 255291297,
 -1,
 255856450,
 255750049,
 -1,
 -61631,
 255800202,
 69662,
 -1,
 255856201,
 69661,
 -61629,
 255800202,
 69667,
 -1,
 255987273,
 69666,
 256184137,
 255742737,
 69649,
 256311295,
 256132194,
 -1,
 -61625,
 256206669,
 69686,
 -61624,
 256266616,
 69687,
 -1,
 256330010,
 69685,
 256511822,
 256134917,
 -1,
 -61621,
 256475682,
 69660,
 -61620,
 256528234,
 69665,
 -61619,
 256586007,
 69655,
 -1,
 256642633,
 69670,
 256839508,
 256450899,
 -1,
 256905042,
 256778579,
 -1,
 -61615,
 256848778,
 69664,
 -1,
 256904777,
 69663,
 -61613,
 256848778,
 69669,
 -1,
 257035849,
 69668,
 257232728,
 256773705,
 69637,
 -61610,
 257193402,
 69650,
 -61609,
 257243112,
 69648,
 -1,
 257297993,
 69638,
 257494876,
 257189871,
 -1,
 -61606,
 257452108,
 69681,
 -61605,
 257504138,
 69680,
 -1,
 257560137,
 69682,
 257757022,
 257455546,
 69641,
 -1,
 257717690,
 69642,
 257888097,
 257710718,
 -1,
 -61600,
 257831818,
 69672,
 -1,
 257887817,
 69671,
 258084708,
 257835674,
 -1,
 -61597,
 258032340,
 69684,
 -1,
 258084425,
 69678,
 258281319,
 258031785,
 -1,
 -61594,
 258225034,
 69652,
 -1,
 258281033,
 69651,
 258477930,
 258228213,
 -1,
 -61591,
 258421642,
 69659,
 -1,
 258477641,
 69658,
 258674540,
 258422760,
 69639,
 -1,
 258619368,
 69640,
 258805615,
 258617585,
 -1,
 -61586,
 258749322,
 69654,
 -1,
 258805321,
 69653,
 259002226,
 258742859,
 -1,
 -61583,
 258945930,
 69657,
 -1,
 259001929,
 69656,
 259198837,
 258938397,
 -1,
 -61580,
 259142538,
 69674,
 -1,
 259198537,
 69673,
 -61578,
 259162658,
 69676,
 -61577,
 259350588,
 69677,
 -61576,
 259410648,
 69675,
 -61575,
 259470218,
 69683,
 -1,
 259532421,
 69647,
 259723160,
 255218353,
 -1,
 259788675,
 259682209,
 -1,
 259854207,
 259751142,
 -1,
 -61570,
 259805969,
 69715,
 -1,
 259861055,
 69724,
 260050818,
 259797884,
 -1,
 -61567,
 260006499,
 69716,
 -1,
 260062808,
 69725,
 -1,
 259991893,
 69723,
 260312968,
 259745775,
 -1,
 260378502,
 260259729,
 69719,
 -1,
 260339107,
 69728,
 260571135,
 260320379,
 69720,
 -1,
 260470179,
 69729,
 260640655,
 260255019,
 -1,
 260706188,
 260592401,
 -1,
 -61557,
 260667823,
 69717,
 -1,
 260728763,
 69726,
 260964351,
 260650984,
 -1,
 -61554,
 260864732,
 69718,
 -1,
 260911327,
 69727,
 261099411,
 260593002,
 69714,
 261226495,
 261029888,
 -1,
 -61550,
 261124498,
 69733,
 -1,
 261175217,
 69732,
 261361557,
 261050580,
 69722,
 -1,
 261322147,
 69731,
 261492631,
 261302427,
 69721,
 -1,
 261456342,
 69730,
 -1,
 261439644,
 69759,
 261689259,
 259685036,
 -1,
 261754794,
 261642796,
 -1,
 261820319,
 261717099,
 -1,
 261885853,
 261775342,
 69694,
 -1,
 261840878,
 69695,
 262078463,
 261833370,
 69696,
 -1,
 261964442,
 69697,
 262148003,
 261754441,
 -1,
 -61535,
 262108602,
 69701,
 -61534,
 262158312,
 69699,
 -1,
 262213193,
 69688,
 262410149,
 262108602,
 69692,
 -1,
 262370746,
 69693,
 262541223,
 262354920,
 69690,
 -1,
 262485992,
 69691,
 -61528,
 262492945,
 69700,
 -61527,
 262612613,
 69698,
 -1,
 262674368,
 69689,
 -1,
 261701085,
 69702,
 262934460,
 261628243,
 -1,
 262999994,
 262879777,
 -1,
 263065520,
 262959009,
 -1,
 -61521,
 263028808,
 69736,
 -1,
 263075624,
 69737,
 263262131,
 263022575,
 -1,
 -61518,
 263208849,
 69740,
 -1,
 263269499,
 69741,
 263458742,
 263204139,
 -1,
 -61515,
 263411909,
 69738,
 -1,
 263470849,
 69739,
 -61513,
 263422902,
 69734,
 -61512,
 263607658,
 69735,
 -61511,
 263672020,
 69743,
 -1,
 263727259,
 69742,
 -61509,
 262953045,
 69704,
 -1,
 263852623,
 69703,
 264048578,
 262892390,
 -1,
 -61506,
 264010830,
 69634,
 -61505,
 264075510,
 69636,
 -61504,
 264126552,
 69635,
 -61503,
 264182472,
 69632,
 -1,
 264246032,
 69633,
 264503295,
 264003181,
 -1,
 264507334,
 264389274,
 -1,
 -61499,
 264460358,
 69709,
 -1,
 264518627,
 69707,
 264703945,
 264446972,
 -1,
 -61496,
 264664721,
 69706,
 -1,
 264728481,
 69705,
 -1,
 264642547,
 69708,
 264966095,
 255145960,
 -1,
 265031630,
 264905043,
 -1,
 -61491,
 264974746,
 127753,
 -1,
 265037516,
 128112,
 -1,
 264972346,
 128188,
 265293778,
 264906475,
 -1,
 -61487,
 265240784,
 983124,
 -1,
 265298259,
 127838,
 -1,
 265245799,
 128148,
 265556016,
 255083162,
 -1,
 265621546,
 265490262,
 -1,
 265687009,
 265571368,
 -1,
 265752536,
 265648353,
 9206,
 -1,
 265683275,
 11205,
 265883611,
 265710667,
 -1,
 -61478,
 265833002,
 128927,
 -1,
 265888608,
 128921,
 266080221,
 265839821,
 9205,
 -1,
 266010955,
 11208,
 266211295,
 266028488,
 9204,
 -1,
 266142027,
 11207,
 266403839,
 266151293,
 9207,
 -1,
 266273099,
 11206,
 266473456,
 265624139,
 -1,
 266538991,
 266435096,
 -1,
 266604518,
 266500453,
 -1,
 -61467,
 266560780,
 11179,
 -1,
 266618416,
 11178,
 266801129,
 266560764,
 -1,
 -61464,
 266762610,
 11181,
 -1,
 266806753,
 11183,
 266997740,
 266749473,
 -1,
 -61461,
 266959218,
 11180,
 -1,
 267003361,
 11182,
 267255807,
 266937769,
 -1,
 -61458,
 267150604,
 11177,
 -1,
 267208240,
 11176,
 -1,
 266485225,
 9210,
 267456506,
 266430447,
 -1,
 267522037,
 267411276,
 -1,
 -61453,
 267464545,
 9209,
 -61452,
 267525090,
 11200,
 -1,
 267590196,
 128306,
 267784184,
 267470931,
 -1,
 -61449,
 267742624,
 128909,
 -1,
 267787500,
 128900,
 -61447,
 267731544,
 128369,
 -1,
 267915329,
 9984,
 268111876,
 267411438,
 -1,
 268177411,
 268057001,
 -1,
 268242945,
 268109780,
 -1,
 268308479,
 268182783,
 9193,
 -1,
 268240694,
 9197,
 -61440,
 268268584,
 9199,
 -1,
 268385921,
 128898,
 -61438,
 268205428,
 11166,
 -1,
 268501979,
 128413,
 -1,
 268130219,
 127990,
 268767245,
 268050771,
 -1,
 268832779,
 268720695,
 -1,
 268898313,
 268765140,
 -1,
 -61432,
 268844673,
 128899,
 -1,
 268903679,
 9196,
 -61430,
 268860788,
 11167,
 -1,
 269026267,
 128419,
 -61428,
 268789492,
 127778,
 -1,
 269170821,
 11201,
 269357076,
 268715262,
 -1,
 269422610,
 269289428,
 -1,
 269488145,
 269362431,
 9194,
 -1,
 269420342,
 9198,
 -1,
 269434497,
 128896,
 -61421,
 269385076,
 11164,
 -1,
 269616091,
 128412,
 269815834,
 269318186,
 -1,
 269881368,
 269748180,
 -1,
 -61417,
 269827713,
 128897,
 -1,
 269886719,
 9195,
 -61415,
 269843828,
 11165,
 -1,
 270009307,
 128418,
 270209056,
 269774753,
 -1,
 270274591,
 270155140,
 -1,
 -61411,
 270232992,
 128908,
 -61410,
 270289450,
 128925,
 -1,
 270345056,
 128919,
 -1,
 270227602,
 128383,
 270602275,
 270171086,
 -1,
 -61406,
 270551594,
 128926,
 -1,
 270607200,
 128920,
 270798886,
 270555774,
 -1,
 -61403,
 270760528,
 128392,
 -1,
 270805481,
 127986,
 -61401,
 270753747,
 10067,
 -61400,
 270947214,
 11204,
 -61399,
 271004873,
 128426,
 -1,
 271069014,
 128447,
 271257645,
 265582401,
 -1,
 -61396,
 271201583,
 128153,
 -1,
 271259976,
 128216,
 271515647,
 271209233,
 -1,
 -61393,
 271416913,
 128033,
 -1,
 271478239,
 127804,
 271650898,
 265507601,
 -1,
 271716411,
 271598649,
 -1,
 271781941,
 271679063,
 -1,
 -61388,
 271740320,
 128912,
 -1,
 271785196,
 128902,
 271978552,
 271738863,
 -1,
 -61385,
 271925151,
 128951,
 -1,
 271978916,
 128939,
 -61383,
 271921947,
 128932,
 -61382,
 272117432,
 128945,
 -1,
 272181426,
 128957,
 272371775,
 271668285,
 128366,
 272437310,
 272321407,
 128278,
 -1,
 272368795,
 128209,
 -1,
 272394223,
 128218,
 272633924,
 272334054,
 -1,
 272699459,
 272581274,
 -1,
 -61374,
 272645104,
 127923,
 -1,
 272696091,
 128335,
 -1,
 272629781,
 127993,
 272961608,
 272588137,
 -1,
 -61370,
 272925676,
 12730,
 -61369,
 272975765,
 12729,
 -1,
 273035798,
 12728,
 273223754,
 272925142,
 128102,
 -1,
 273180739,
 128713,
 273354828,
 273185193,
 128144,
 -1,
 273285894,
 127893,
 273485903,
 273315030,
 -1,
 -61362,
 273437874,
 11211,
 -1,
 273499293,
 127870,
 273682513,
 273435279,
 983254,
 -1,
 273618461,
 128163,
 -1,
 273617753,
 128023,
 273879143,
 271591045,
 -1,
 273944666,
 273813065,
 -1,
 274010199,
 273894402,
 -1,
 -61354,
 273949425,
 127901,
 -1,
 274011270,
 127900,
 -61352,
 273969843,
 128147,
 -61351,
 274161658,
 128059,
 -1,
 274209835,
 127958,
 274403425,
 273895173,
 -1,
 274468958,
 274362273,
 -1,
 -61347,
 274420499,
 127857,
 -1,
 274464900,
 11102,
 274726911,
 274411850,
 -1,
 -61344,
 274613983,
 983630,
 -1,
 274666188,
 2432,
 274862181,
 274350746,
 983055,
 274989055,
 274809498,
 128276,
 -61340,
 274872014,
 128718,
 -1,
 274924950,
 128277,
 -61338,
 274803379,
 127866,
 -1,
 275063123,
 128719,
 275255410,
 273839546,
 -1,
 275320941,
 275212271,
 128652,
 275386476,
 275279777,
 -1,
 -61333,
 275343348,
 128101,
 -1,
 275382850,
 128100,
 -1,
 275317891,
 128655,
 275648623,
 275269877,
 128363,
 -1,
 275580695,
 128364,
 -61328,
 275605346,
 127791,
 -61327,
 275724941,
 127959,
 -1,
 275788017,
 128027,
 275976315,
 275199976,
 -1,
 276041846,
 275931118,
 -1,
 -61323,
 276001076,
 127874,
 -1,
 276046163,
 128038,
 276238457,
 275980622,
 -1,
 -61320,
 276184730,
 128692,
 -1,
 276244101,
 128690,
 -61318,
 276187388,
 127921,
 -1,
 276382182,
 128089,
 276566142,
 275939798,
 -1,
 -61315,
 276530030,
 983258,
 -1,
 276590771,
 983253,
 -61313,
 276522991,
 983057,
 -1,
 276716601,
 983125,
 276895014,
 190532239,
 -1,
 276959830,
 276833925,
 -1,
 277025147,
 276909829,
 -1,
 277090681,
 276963976,
 -1,
 277156192,
 277049166,
 -1,
 277221619,
 277088259,
 -1,
 277287057,
 277155267,
 -1,
 -61304,
 277220880,
 125069,
 -61303,
 277286310,
 125123,
 -61302,
 277351584,
 124959,
 -61301,
 277416995,
 125036,
 -61300,
 277482368,
 124932,
 -61299,
 277547775,
 124952,
 -61298,
 277613094,
 125097,
 -61297,
 277678414,
 125088,
 -61296,
 277743866,
 124999,
 -1,
 277809228,
 125047,
 278007964,
 277220676,
 -1,
 -61293,
 277941701,
 124993,
 -61292,
 278007131,
 125024,
 -61291,
 278072519,
 125043,
 -61290,
 278137929,
 125056,
 -61289,
 278203365,
 125117,
 -61288,
 278268653,
 124985,
 -61287,
 278333997,
 125039,
 -61286,
 278399370,
 125049,
 -61285,
 278464746,
 125071,
 -1,
 278530166,
 125015,
 278728871,
 277941406,
 -1,
 -61282,
 278662682,
 124980,
 -61281,
 278728021,
 125021,
 -61280,
 278793502,
 125119,
 -61279,
 278858809,
 124933,
 -61278,
 278924145,
 125022,
 -61277,
 278989538,
 125089,
 -61276,
 279054936,
 124986,
 -61275,
 279120247,
 125080,
 -61274,
 279185582,
 125099,
 -1,
 279250970,
 125100,
 279449778,
 278662150,
 -1,
 -61271,
 279383583,
 125002,
 -61270,
 279449005,
 125068,
 -61269,
 279514352,
 125107,
 -61268,
 279579761,
 125074,
 -61267,
 279645061,
 124931,
 -61266,
 279710476,
 125108,
 -61265,
 279775817,
 125009,
 -61264,
 279841137,
 125076,
 -61263,
 279906565,
 124945,
 -1,
 279971930,
 125124,
 280170685,
 279382876,
 -1,
 -61260,
 280104406,
 124951,
 -61259,
 280169887,
 125121,
 -61258,
 280235269,
 125066,
 -61257,
 280300562,
 125095,
 -61256,
 280366015,
 125000,
 -61255,
 280431347,
 124987,
 -61254,
 280496692,
 125041,
 -61253,
 280561981,
 125044,
 -61252,
 280627429,
 125072,
 -1,
 280692840,
 125070,
 280891592,
 280103616,
 -1,
 -61249,
 280825380,
 124946,
 -61248,
 280890747,
 124934,
 -61247,
 280956124,
 125078,
 -61246,
 281021490,
 125046,
 -61245,
 281086959,
 124942,
 -61244,
 281152219,
 125090,
 -61243,
 281217652,
 125048,
 -61242,
 281282883,
 125037,
 -61241,
 281348277,
 125033,
 -1,
 281413676,
 125035,
 281612499,
 280824327,
 -1,
 -61238,
 281546250,
 125029,
 -61237,
 281611673,
 125028,
 -61236,
 281677076,
 125027,
 -61235,
 281742349,
 125020,
 -61234,
 281807724,
 125019,
 -61233,
 281873104,
 125018,
 -61232,
 281938591,
 125013,
 -61231,
 282003942,
 125012,
 -61230,
 282069263,
 125011,
 -1,
 282134589,
 125005,
 282333406,
 281545007,
 -1,
 -61227,
 282267083,
 125004,
 -61226,
 282332530,
 125003,
 -61225,
 282397911,
 124984,
 -61224,
 282463300,
 124983,
 -61223,
 282528651,
 124982,
 -61222,
 282594093,
 124998,
 -61221,
 282659459,
 124997,
 -61220,
 282724777,
 124996,
 -61219,
 282790133,
 124976,
 -1,
 282855533,
 124975,
 283054313,
 282265747,
 -1,
 -61216,
 282988053,
 124974,
 -61215,
 283053387,
 124992,
 -61214,
 283118757,
 124991,
 -61213,
 283184136,
 124990,
 -61212,
 283249628,
 124964,
 -61211,
 283314882,
 124963,
 -61210,
 283380288,
 124962,
 -61209,
 283445560,
 124957,
 -61208,
 283510937,
 124956,
 -1,
 283576331,
 124955,
 283836415,
 282986499,
 -1,
 -61205,
 283708899,
 124950,
 -61204,
 283774348,
 124949,
 -61203,
 283839722,
 124948,
 -61202,
 283905165,
 124938,
 -61201,
 283970538,
 124937,
 -61200,
 284035896,
 124936,
 -61199,
 284101198,
 124930,
 -61198,
 284166473,
 124929,
 -1,
 284231871,
 124928,
 284491775,
 277153939,
 -1,
 284496127,
 284364100,
 -1,
 -61194,
 284429788,
 124954,
 -61193,
 284495250,
 125079,
 -61192,
 284560611,
 125083,
 -61191,
 284625965,
 125034,
 -61190,
 284691424,
 125114,
 -61189,
 284756754,
 125065,
 -61188,
 284822114,
 125058,
 -61187,
 284887517,
 125113,
 -61186,
 284952734,
 124995,
 -1,
 285018128,
 124994,
 285217034,
 284429470,
 -1,
 -61183,
 285150672,
 124935,
 -61182,
 285216080,
 124973,
 -61181,
 285281548,
 125067,
 -61180,
 285346856,
 125032,
 -61179,
 285412240,
 125010,
 -61178,
 285477625,
 125082,
 -61177,
 285543059,
 125116,
 -61176,
 285608317,
 125081,
 -61175,
 285673712,
 125101,
 -1,
 285739105,
 125122,
 285937941,
 285150214,
 -1,
 -61172,
 285871620,
 125031,
 -61171,
 285936998,
 125061,
 -61170,
 286002368,
 125064,
 -61169,
 286067736,
 125063,
 -61168,
 286133178,
 124967,
 -61167,
 286198560,
 125120,
 -61166,
 286263827,
 124965,
 -61165,
 286329251,
 124977,
 -61164,
 286394564,
 125084,
 -1,
 286459959,
 125008,
 286658848,
 285870940,
 -1,
 -61161,
 286592501,
 125054,
 -61160,
 286657926,
 125093,
 -61159,
 286723281,
 125006,
 -61158,
 286788713,
 125052,
 -61157,
 286854006,
 125059,
 -61156,
 286919429,
 124953,
 -61155,
 286984797,
 124988,
 -61154,
 287050129,
 125109,
 -61153,
 287115520,
 125115,
 -1,
 287180805,
 124958,
 287379755,
 286591680,
 -1,
 -61150,
 287313405,
 125111,
 -61149,
 287378784,
 125096,
 -61148,
 287444250,
 124968,
 -61147,
 287509602,
 125051,
 -61146,
 287574950,
 125075,
 -61145,
 287640370,
 125118,
 -61144,
 287705753,
 124944,
 -61143,
 287770982,
 125086,
 -61142,
 287836441,
 125016,
 -1,
 287901746,
 125038,
 288100662,
 287312391,
 -1,
 -61139,
 288034346,
 124947,
 -61138,
 288099654,
 124961,
 -61137,
 288165039,
 124969,
 -61136,
 288230529,
 124979,
 -61135,
 288295803,
 124971,
 -61134,
 288361241,
 125112,
 -61133,
 288426528,
 125023,
 -61132,
 288491860,
 125087,
 -61131,
 288557242,
 124970,
 -1,
 288622630,
 125042,
 288821569,
 288033071,
 -1,
 -61128,
 288755177,
 125103,
 -61127,
 288820587,
 125040,
 -61126,
 288886013,
 125055,
 -61125,
 288951431,
 124939,
 -61124,
 289016748,
 125104,
 -61123,
 289082069,
 125094,
 -61122,
 289147502,
 125102,
 -61121,
 289212804,
 125077,
 -61120,
 289278228,
 125017,
 -1,
 289343571,
 125053,
 289542476,
 288753811,
 -1,
 -61117,
 289476079,
 125106,
 -61116,
 289541554,
 124940,
 -61115,
 289606903,
 125030,
 -61114,
 289672310,
 124978,
 -61113,
 289737650,
 125050,
 -61112,
 289803069,
 124941,
 -61111,
 289868356,
 125007,
 -61110,
 289933658,
 125092,
 -61109,
 289999017,
 125060,
 -1,
 290064450,
 124989,
 290263383,
 289474563,
 -1,
 -61106,
 290197040,
 125014,
 -61105,
 290262400,
 125091,
 -61104,
 290327738,
 125098,
 -61103,
 290393173,
 125057,
 -61102,
 290458522,
 125085,
 -61101,
 290523943,
 125001,
 -61100,
 290589193,
 124960,
 -61099,
 290654621,
 125073,
 -61098,
 290719907,
 125026,
 -1,
 290785302,
 124966,
 291045375,
 290196931,
 -1,
 -61095,
 290917556,
 125025,
 -61094,
 290983035,
 124981,
 -61093,
 291048286,
 124972,
 -61092,
 291113795,
 124943,
 -61091,
 291179066,
 125045,
 -61090,
 291244439,
 125110,
 -61089,
 291309775,
 125105,
 -1,
 291375136,
 125062,
 291574125,
 277095300,
 -1,
 291639652,
 291532705,
 -1,
 -61085,
 291602504,
 125128,
 -1,
 291649320,
 125129,
 291836263,
 291596271,
 -1,
 -61082,
 291782545,
 125132,
 -1,
 291843195,
 125133,
 292032874,
 291777835,
 -1,
 -61079,
 291985605,
 125130,
 -1,
 292044545,
 125131,
 -61077,
 291984746,
 125127,
 -61076,
 292180180,
 125135,
 -1,
 292235419,
 125134,
 292487167,
 291511902,
 -1,
 292491637,
 292384673,
 -1,
 292557172,
 292431493,
 -1,
 292622707,
 292507397,
 -1,
 -61070,
 292579311,
 125137,
 -1,
 292619441,
 125140,
 -1,
 292563440,
 125136,
 -1,
 292501275,
 125139,
 292950392,
 292435889,
 -1,
 -61065,
 292906991,
 125138,
 -1,
 292947121,
 125141,
 -1,
 292900328,
 125142,
 -61062,
 277047363,
 128697,
 -1,
 293164836,
 128334,
 293343771,
 276981406,
 -1,
 293409269,
 293282064,
 -1,
 293474754,
 293360305,
 -1,
 293540241,
 293433249,
 -1,
 293605767,
 293502182,
 -1,
 293671301,
 293557009,
 68033,
 293797887,
 293601280,
 -1,
 293802372,
 293681073,
 68051,
 -1,
 293733543,
 68078,
 -1,
 293761426,
 68060,
 294060031,
 293612095,
 68042,
 -1,
 293930151,
 68069,
 294130063,
 293548924,
 -1,
 294195597,
 294085219,
 68034,
 294322175,
 294125568,
 -1,
 294326668,
 294205361,
 68052,
 -1,
 294257831,
 68079,
 -1,
 294285714,
 68061,
 294584319,
 294141528,
 68043,
 -1,
 294454439,
 68070,
 294715391,
 294070613,
 68041,
 -1,
 294585511,
 68068,
 294785440,
 293496815,
 -1,
 294850969,
 294731665,
 68037,
 294916503,
 294780928,
 -1,
 294982038,
 294860721,
 68055,
 -1,
 294913191,
 68082,
 -1,
 294941074,
 68064,
 295239679,
 294876579,
 68046,
 -1,
 295109799,
 68073,
 295370751,
 294792315,
 68038,
 295375262,
 295239680,
 -1,
 295440797,
 295319473,
 68056,
 -1,
 295371943,
 68083,
 -1,
 295399826,
 68065,
 295698431,
 295335331,
 68047,
 -1,
 295568551,
 68074,
 295768497,
 294726955,
 -1,
 295834025,
 295719697,
 -1,
 295899559,
 295795119,
 68035,
 296026111,
 295829504,
 -1,
 296030630,
 295909297,
 68053,
 -1,
 295961767,
 68080,
 -1,
 295989650,
 68062,
 296288255,
 295856059,
 68044,
 -1,
 296158375,
 68071,
 296419327,
 295778280,
 -1,
 296423855,
 296319708,
 68036,
 296550399,
 296353792,
 -1,
 296554926,
 296433585,
 68054,
 -1,
 296486055,
 68081,
 -1,
 296513938,
 68063,
 296812543,
 296366303,
 68045,
 -1,
 296682663,
 68072,
 296882615,
 295719124,
 68040,
 296948150,
 296812544,
 -1,
 297013685,
 296892337,
 68058,
 -1,
 296944807,
 68085,
 -1,
 296972690,
 68067,
 -1,
 296908198,
 68076,
 297275837,
 296822939,
 68039,
 297341372,
 297205760,
 -1,
 297406907,
 297285553,
 68057,
 -1,
 297338023,
 68084,
 -1,
 297365906,
 68066,
 -1,
 297304576,
 68075,
 297730047,
 297227626,
 68032,
 297795583,
 297598976,
 -1,
 297800129,
 297678769,
 68050,
 -1,
 297731239,
 68077,
 -1,
 297759122,
 68059,
 297996771,
 293421722,
 -1,
 298062304,
 297937896,
 -1,
 298127816,
 298020769,
 -1,
 -60986,
 298078993,
 68022,
 -60985,
 298133125,
 68021,
 -1,
 298192457,
 68020,
 298389963,
 298084335,
 -1,
 -60982,
 298329733,
 68017,
 -1,
 298389065,
 68015,
 298586574,
 298340101,
 -1,
 -60979,
 298526341,
 68010,
 -1,
 298585673,
 68009,
 298783185,
 298533033,
 -1,
 -60976,
 298726282,
 68013,
 -1,
 298782281,
 68018,
 298979795,
 298716745,
 68000,
 -1,
 298934674,
 68016,
 -60972,
 298943010,
 68004,
 -60971,
 299072766,
 68005,
 -60970,
 299130940,
 68011,
 -60969,
 299196160,
 68019,
 -60968,
 299260576,
 68007,
 -60967,
 299324177,
 68003,
 -60966,
 299387608,
 68008,
 -60965,
 299451092,
 68012,
 -60964,
 299513832,
 68002,
 -60963,
 299578839,
 68014,
 -60962,
 299640453,
 68001,
 -60961,
 299704798,
 68023,
 -1,
 299767342,
 68006,
 300023807,
 298013670,
 -1,
 -60958,
 299918988,
 68030,
 -1,
 299973348,
 68031,
 300220415,
 297939020,
 -1,
 300225000,
 300117921,
 -1,
 -60954,
 300187750,
 68087,
 -60953,
 300234598,
 68088,
 -1,
 300296568,
 68095,
 300487147,
 300181487,
 -1,
 -60950,
 300433330,
 68091,
 -1,
 300493961,
 68092,
 300683758,
 300438894,
 -1,
 -60947,
 300643662,
 68086,
 -1,
 300692469,
 68029,
 300880369,
 300625195,
 -1,
 -60944,
 300833052,
 68089,
 -1,
 300891985,
 68090,
 301076980,
 300820101,
 -1,
 -60941,
 301025128,
 68028,
 -1,
 301087161,
 68093,
 -1,
 301027554,
 68094,
 301400063,
 293352940,
 -1,
 301404697,
 301287127,
 -1,
 301470205,
 301363105,
 -1,
 301535738,
 301409925,
 67994,
 -1,
 301467500,
 67995,
 301666812,
 301469257,
 67992,
 -1,
 301598572,
 67993,
 -1,
 301617937,
 67996,
 301863426,
 301420293,
 -1,
 301928960,
 301803141,
 67980,
 -1,
 301860716,
 67981,
 302120959,
 301862473,
 67978,
 -1,
 301991788,
 67979,
 302191110,
 301819887,
 -1,
 302256645,
 302124617,
 67987,
 -1,
 302188396,
 67988,
 -1,
 302196357,
 67989,
 302453256,
 302145596,
 67982,
 -1,
 302385004,
 67983,
 302584331,
 302399657,
 -1,
 -60918,
 302527370,
 67985,
 -1,
 302583369,
 67990,
 302780941,
 302519854,
 67974,
 -1,
 302712684,
 67975,
 -60914,
 302744098,
 67972,
 -60913,
 302873854,
 67973,
 -60912,
 302931712,
 67991,
 -60911,
 302996128,
 67976,
 -60910,
 303059729,
 67971,
 -60909,
 303123160,
 67977,
 -60908,
 303186644,
 67984,
 -60907,
 303249384,
 67970,
 -60906,
 303314391,
 67986,
 -60905,
 303376005,
 67969,
 -60904,
 303440350,
 67997,
 -1,
 303500873,
 67968,
 303759359,
 301363085,
 67998,
 -1,
 303630188,
 67999,
 303829565,
 293284824,
 -1,
 303895084,
 303777495,
 -1,
 303960608,
 303854806,
 -1,
 -60897,
 303903626,
 43749,
 -1,
 303959625,
 43748,
 304157219,
 303917039,
 -1,
 -60894,
 304113740,
 43754,
 -1,
 304165770,
 43753,
 304353830,
 304107269,
 -1,
 -60891,
 304316962,
 43747,
 -1,
 304369514,
 43752,
 304550441,
 304292472,
 -1,
 -60888,
 304493450,
 43751,
 -1,
 304549449,
 43750,
 -60886,
 304501521,
 43745,
 -60885,
 304686725,
 43744,
 -1,
 304749628,
 43746,
 304943671,
 303856300,
 -1,
 305009206,
 304896556,
 -1,
 305074739,
 304942665,
 -1,
 305140274,
 305008201,
 -1,
 -60879,
 305100218,
 43759,
 -1,
 305149928,
 43757,
 -1,
 305100218,
 43758,
 -60876,
 305036366,
 43765,
 -60875,
 305363622,
 43756,
 -1,
 305412715,
 43755,
 -1,
 304954845,
 43766,
 305664570,
 304877129,
 -1,
 -60871,
 305615150,
 43762,
 -1,
 305673384,
 43761,
 -60869,
 305627343,
 43764,
 -60868,
 305819481,
 43763,
 -1,
 305863811,
 43760,
 306057809,
 303768511,
 -1,
 306123331,
 306014191,
 -1,
 306188866,
 306069396,
 -1,
 -60863,
 306146704,
 128950,
 -1,
 306208012,
 128971,
 -1,
 306123172,
 128938,
 306451016,
 306064683,
 -1,
 306516551,
 306403563,
 -1,
 -60858,
 306470001,
 128967,
 -1,
 306518152,
 128965,
 -1,
 306462525,
 128944,
 306778699,
 306409926,
 -1,
 -60854,
 306732145,
 128963,
 -1,
 306780296,
 128961,
 306975310,
 306718881,
 -1,
 -60851,
 306933136,
 128956,
 -1,
 306994444,
 128974,
 -60849,
 306937536,
 128911,
 -60848,
 307114779,
 128931,
 -1,
 307173679,
 128901,
 -60846,
 306017478,
 128647,
 -60845,
 307326401,
 983172,
 -60844,
 307383832,
 128221,
 -60843,
 307448130,
 127816,
 -1,
 307500256,
 127830,
 307696401,
 276903912,
 -1,
 307761923,
 307630873,
 -1,
 307827405,
 307709655,
 -1,
 307892843,
 307785633,
 -1,
 307958370,
 307844556,
 -1,
 -60836,
 307891524,
 94105,
 -60835,
 307956894,
 94104,
 -60834,
 308022278,
 94103,
 -60833,
 308087644,
 94102,
 -60832,
 308153024,
 94101,
 -60831,
 308218375,
 94100,
 -1,
 308283695,
 94099,
 308482662,
 307914735,
 -1,
 -60828,
 308439116,
 93994,
 -60827,
 308491146,
 93998,
 -1,
 308547145,
 94007,
 308744809,
 308430741,
 -1,
 -60824,
 308707874,
 93980,
 -1,
 308743753,
 93978,
 -60822,
 308703256,
 93966,
 -1,
 308874825,
 93962,
 309072504,
 307842821,
 -1,
 309138031,
 309035478,
 -1,
 -60818,
 309080970,
 93997,
 -1,
 309136969,
 93996,
 309334642,
 309088005,
 -1,
 -60815,
 309277578,
 93973,
 -1,
 309333577,
 93972,
 309531253,
 309276913,
 -1,
 -60812,
 309474186,
 93988,
 -1,
 309530185,
 93987,
 309727863,
 309464649,
 93968,
 -1,
 309684323,
 94032,
 -1,
 309670794,
 93969,
 309924484,
 309035835,
 -1,
 309990015,
 309887803,
 -1,
 310055549,
 309946351,
 -1,
 -60804,
 310018594,
 94017,
 -1,
 310054473,
 94014,
 -60802,
 310018594,
 94016,
 -1,
 310185545,
 94013,
 310383234,
 309946351,
 -1,
 -60799,
 310326154,
 94006,
 -1,
 310382153,
 94012,
 -60797,
 310326154,
 94005,
 -1,
 310513225,
 94011,
 310710927,
 309887654,
 -1,
 310776459,
 310669217,
 -1,
 310841993,
 310732783,
 -1,
 -60792,
 310784906,
 94000,
 -1,
 310840905,
 94009,
 -60790,
 310800408,
 93964,
 -1,
 310971977,
 93965,
 -60788,
 310729376,
 93954,
 -60787,
 311120204,
 93970,
 -60786,
 311181568,
 93984,
 -1,
 311240320,
 94001,
 311431832,
 310665896,
 -1,
 311497367,
 311383500,
 -1,
 -60782,
 311430468,
 94111,
 -60781,
 311495686,
 94110,
 -60780,
 311561052,
 94109,
 -60779,
 311626432,
 94108,
 -60778,
 311691567,
 94107,
 -1,
 311756947,
 94106,
 -1,
 311454204,
 94002,
 312021666,
 311370067,
 -1,
 312087197,
 311984955,
 -1,
 -60773,
 312050493,
 93995,
 -60772,
 312095626,
 93999,
 -1,
 312151625,
 94008,
 312349344,
 312035221,
 -1,
 -60769,
 312312354,
 93981,
 -1,
 312348233,
 93979,
 -60767,
 312287710,
 93967,
 -1,
 312479305,
 93963,
 312677034,
 311955017,
 -1,
 312742569,
 312631681,
 -1,
 312808103,
 312692485,
 -1,
 -60762,
 312750359,
 93989,
 -1,
 312806985,
 93971,
 -60760,
 312771567,
 94015,
 -1,
 312953560,
 93958,
 -1,
 312685436,
 94019,
 313201328,
 312623770,
 -1,
 313266862,
 313144188,
 -1,
 -60755,
 313229858,
 93977,
 -1,
 313265737,
 93976,
 -60753,
 313229858,
 93975,
 -1,
 313396809,
 93974,
 313594548,
 313157615,
 -1,
 -60750,
 313550924,
 94004,
 -60749,
 313602954,
 94003,
 -1,
 313658953,
 94010,
 313856697,
 313536753,
 -1,
 313922232,
 313799548,
 -1,
 -60745,
 313865098,
 93993,
 -1,
 313921097,
 93992,
 -1,
 313855561,
 93983,
 314184380,
 313817772,
 -1,
 -60741,
 314125647,
 93961,
 -1,
 314183241,
 93960,
 314380991,
 314138366,
 -1,
 -60738,
 314323223,
 93986,
 -1,
 314379849,
 93985,
 314577602,
 314333822,
 -1,
 -60735,
 314524372,
 93955,
 -1,
 314576457,
 93952,
 314774213,
 314526351,
 -1,
 -60732,
 314717066,
 93957,
 -1,
 314773065,
 93956,
 314970824,
 314717052,
 -1,
 -60729,
 314913674,
 94020,
 -1,
 314969673,
 93990,
 -60727,
 314933618,
 93991,
 -60726,
 315129086,
 94018,
 -60725,
 315179264,
 93982,
 -60724,
 315239759,
 93959,
 -1,
 315299374,
 93953,
 315495161,
 307789003,
 -1,
 315560663,
 315439080,
 94049,
 315626194,
 315493961,
 94050,
 315752447,
 315576069,
 94051,
 -1,
 315633905,
 94052,
 -60717,
 315585978,
 94056,
 -60716,
 315773713,
 94053,
 -60715,
 315838582,
 94057,
 -60714,
 315897832,
 94055,
 -1,
 315958917,
 94054,
 316150496,
 315493961,
 94036,
 316216026,
 316100357,
 94039,
 -1,
 316158193,
 94040,
 316347100,
 316155525,
 94067,
 -1,
 316286597,
 94068,
 -60707,
 316306874,
 94075,
 -60706,
 316422120,
 94073,
 -60705,
 316487124,
 94038,
 -1,
 316542537,
 94037,
 316740327,
 316110266,
 94058,
 316805860,
 316673609,
 94059,
 316932095,
 316755717,
 94060,
 -1,
 316813553,
 94061,
 -60699,
 316765626,
 94062,
 -60698,
 316952694,
 94064,
 -1,
 317008024,
 94063,
 317199085,
 316679813,
 94045,
 317264618,
 317153262,
 94071,
 -1,
 317218798,
 94069,
 317395692,
 317214469,
 94046,
 -1,
 317337841,
 94047,
 -1,
 317339624,
 94074,
 317592305,
 317149969,
 94041,
 -60689,
 317552058,
 94076,
 -60688,
 317608721,
 94042,
 -1,
 317664548,
 94048,
 317854451,
 317555158,
 94065,
 -1,
 317798376,
 94066,
 317985525,
 317816038,
 94044,
 -1,
 317936401,
 94043,
 318116599,
 317941567,
 94072,
 -1,
 318070766,
 94070,
 318308351,
 318066437,
 94077,
 -1,
 318189809,
 94078,
 318378750,
 315454254,
 -1,
 -60677,
 318337851,
 94096,
 -60676,
 318399388,
 94095,
 -60675,
 318445362,
 94098,
 -1,
 318508794,
 94097,
 318767103,
 318335846,
 -1,
 318771970,
 318661278,
 -1,
 -60671,
 318733456,
 94034,
 -1,
 318772415,
 94035,
 -1,
 318706879,
 94033,
 319034122,
 307699658,
 -1,
 319099655,
 318984977,
 -1,
 -60666,
 319056093,
 128300,
 -1,
 319118407,
 127908,
 319356927,
 319029248,
 -1,
 -60663,
 319247678,
 983231,
 -1,
 319300185,
 983232,
 319492878,
 318984379,
 -1,
 -60660,
 319442447,
 128469,
 -60659,
 319497127,
 128189,
 -1,
 319560222,
 128656,
 319815679,
 319439514,
 -1,
 -60656,
 319701641,
 127756,
 -1,
 319766248,
 127894,
 319951814,
 307629641,
 -1,
 320017283,
 319901445,
 128104,
 320082777,
 319961323,
 -1,
 320148293,
 320030423,
 -1,
 320213787,
 320104431,
 -1,
 320279321,
 320147017,
 -1,
 -60648,
 320228523,
 68312,
 -1,
 320283437,
 68317,
 -60646,
 320236230,
 68323,
 -1,
 320419394,
 68322,
 320607007,
 320171937,
 -1,
 -60643,
 320549913,
 68309,
 -60642,
 320613348,
 68302,
 -1,
 320673264,
 68324,
 320869155,
 320540233,
 -1,
 -60639,
 320832170,
 68313,
 -60638,
 320882379,
 68288,
 -1,
 320935444,
 68314,
 321131302,
 320832315,
 -1,
 -60635,
 321074434,
 68298,
 -1,
 321132052,
 68297,
 321327913,
 321093958,
 -1,
 -60632,
 321279740,
 68319,
 -1,
 321327913,
 68305,
 321524524,
 321281790,
 -1,
 -60629,
 321476348,
 68318,
 -1,
 321533655,
 68320,
 321721135,
 321470633,
 -1,
 -60626,
 321664180,
 68306,
 -1,
 321721129,
 68304,
 321917746,
 321667061,
 -1,
 -60623,
 321860866,
 68300,
 -1,
 321918484,
 68299,
 322114356,
 321860872,
 68294,
 -1,
 322072871,
 68301,
 322245431,
 322056433,
 -1,
 -60618,
 322190035,
 68291,
 -1,
 322254396,
 68292,
 322442042,
 322183507,
 -1,
 -60615,
 322384921,
 68308,
 -1,
 322441552,
 68293,
 322638653,
 322377245,
 -1,
 -60612,
 322581944,
 68290,
 -1,
 322644964,
 68289,
 -60610,
 322601763,
 68303,
 -60609,
 322796966,
 68295,
 -60608,
 322855671,
 68321,
 -60607,
 322919338,
 68315,
 -60606,
 322982634,
 68311,
 -60605,
 323046582,
 68310,
 -60604,
 323109689,
 68307,
 -1,
 323169744,
 68316,
 323359566,
 320101997,
 -1,
 323425098,
 323298300,
 -1,
 323490633,
 323383201,
 68340,
 -1,
 323422025,
 68339,
 -1,
 323450522,
 68338,
 -60597,
 323384682,
 68341,
 -60596,
 323644945,
 68336,
 -60595,
 323700868,
 68342,
 -1,
 323759834,
 68337,
 323949397,
 323310257,
 -1,
 324014930,
 323907489,
 -1,
 -60591,
 323976717,
 68334,
 -1,
 324020565,
 68333,
 324211540,
 323966314,
 68331,
 -1,
 324141602,
 68335,
 -1,
 324152985,
 68332,
 324408152,
 323882685,
 -1,
 -60585,
 324343602,
 68326,
 -1,
 324407034,
 68325,
 -1,
 324365245,
 68296,
 324670330,
 320020995,
 -1,
 324735862,
 324617943,
 -1,
 324801391,
 324669001,
 -1,
 324866911,
 324757487,
 2126,
 -60578,
 324830011,
 2129,
 -1,
 324875132,
 2132,
 325063521,
 324824993,
 2133,
 -1,
 325021601,
 2120,
 325194595,
 325009577,
 2122,
 -1,
 325150796,
 2121,
 -60572,
 325157691,
 2118,
 -60571,
 325279726,
 2131,
 -60570,
 325345022,
 2130,
 -60569,
 325409406,
 2128,
 -60568,
 325472005,
 2125,
 -60567,
 325536399,
 2124,
 -60566,
 325599898,
 2123,
 -60565,
 325663476,
 2136,
 -60564,
 325727100,
 2116,
 -60563,
 325791985,
 2114,
 -60562,
 325853523,
 2115,
 -1,
 325916189,
 2113,
 326112114,
 324745192,
 -1,
 -60559,
 326070177,
 2119,
 -1,
 326127365,
 2127,
 -60557,
 326072904,
 2117,
 -60556,
 326254862,
 2135,
 -60555,
 326317075,
 2112,
 -1,
 326379108,
 2134,
 -60553,
 324697214,
 2138,
 -60552,
 326524513,
 2142,
 -60551,
 326578631,
 2139,
 -1,
 326635607,
 2137,
 326833024,
 324599808,
 -1,
 326898558,
 326795056,
 -1,
 -60547,
 326857975,
 128115,
 -1,
 326906666,
 128114,
 -60545,
 326843127,
 128372,
 -1,
 327029303,
 128107,
 -60543,
 326791407,
 128368,
 -60542,
 327182396,
 128094,
 -1,
 327226603,
 8380,
 327422906,
 319960012,
 -1,
 327488438,
 327369370,
 -1,
 327553973,
 327429096,
 -1,
 327619468,
 327511969,
 -1,
 327685002,
 327577505,
 -1,
 -60535,
 327627658,
 69983,
 -1,
 327683657,
 69982,
 -60533,
 327627658,
 69988,
 -1,
 327814729,
 69987,
 328012690,
 327557459,
 -1,
 328078224,
 327950675,
 -1,
 -60529,
 328020874,
 69985,
 -1,
 328076873,
 69984,
 -60527,
 328020874,
 69990,
 -1,
 328207945,
 69989,
 328405910,
 327962373,
 -1,
 -60524,
 328368674,
 69981,
 -60523,
 328421226,
 69986,
 -1,
 328470089,
 69991,
 328668057,
 328359918,
 -1,
 -60520,
 328622140,
 70002,
 -1,
 328666697,
 69997,
 328864668,
 328620670,
 -1,
 -60517,
 328807306,
 69993,
 -1,
 328863305,
 69992,
 329061279,
 328810665,
 -1,
 -60514,
 329003914,
 69974,
 -1,
 329059913,
 69973,
 329257890,
 329007093,
 -1,
 -60511,
 329200522,
 69980,
 -1,
 329256521,
 69979,
 329454501,
 329199857,
 -1,
 -60508,
 329397130,
 69976,
 -1,
 329453129,
 69975,
 329651112,
 329390667,
 -1,
 -60505,
 329593738,
 69978,
 -1,
 329649737,
 69977,
 329847723,
 329586205,
 -1,
 -60502,
 329790346,
 69995,
 -1,
 329846345,
 69994,
 -60500,
 329808566,
 69999,
 -60499,
 330003898,
 69970,
 -60498,
 330065996,
 70000,
 -60497,
 330126097,
 69972,
 -60496,
 330189528,
 69996,
 -60495,
 330253012,
 69998,
 -60494,
 330315752,
 69969,
 -60493,
 330380170,
 70001,
 -60492,
 330442373,
 69971,
 -1,
 330501705,
 69968,
 -1,
 327498133,
 70006,
 330765241,
 327444463,
 -1,
 -60488,
 330709577,
 70003,
 -1,
 330770322,
 70005,
 -1,
 330698448,
 70004,
 331027393,
 327369761,
 -1,
 331092928,
 330974935,
 -1,
 -60483,
 331052263,
 3386,
 -60482,
 331108728,
 3369,
 -60481,
 331162672,
 3406,
 -1,
 331223935,
 3423,
 -1,
 331049836,
 3329,
 331486148,
 330985791,
 -1,
 -60477,
 331441644,
 10187,
 -1,
 331492755,
 10189,
 -60475,
 331448729,
 128470,
 -1,
 331635877,
 127809,
 331813990,
 319902481,
 -1,
 331879494,
 331752241,
 -1,
 331945011,
 331808768,
 -1,
 332010505,
 331892439,
 -1,
 332075985,
 331971244,
 -1,
 332141520,
 332026714,
 -1,
 332207054,
 332095470,
 71174,
 -1,
 332161006,
 71175,
 332398591,
 332153498,
 71176,
 -1,
 332284570,
 71177,
 -1,
 332074569,
 71210,
 332534743,
 332033953,
 -1,
 332600277,
 332492705,
 -1,
 -60460,
 332542858,
 71193,
 -1,
 332598857,
 71192,
 -60458,
 332542858,
 71198,
 -1,
 332729929,
 71197,
 332927964,
 332484357,
 -1,
 -60455,
 332890658,
 71191,
 -60454,
 332943210,
 71196,
 -60453,
 333000983,
 71186,
 -1,
 333057609,
 71201,
 333255650,
 332865875,
 -1,
 333321184,
 333193555,
 -1,
 -60449,
 333263754,
 71195,
 -1,
 333319753,
 71194,
 -60447,
 333263754,
 71200,
 -1,
 333450825,
 71199,
 333648870,
 333188681,
 71168,
 -60444,
 333608378,
 71181,
 -60443,
 333658088,
 71179,
 -1,
 333712969,
 71169,
 333911018,
 333604847,
 -1,
 -60440,
 333867084,
 71212,
 -60439,
 333919114,
 71211,
 -1,
 333975113,
 71213,
 334173164,
 333870522,
 71172,
 -1,
 334132666,
 71173,
 334304239,
 334125694,
 -1,
 -60434,
 334246794,
 71203,
 -1,
 334302793,
 71202,
 334500850,
 334250650,
 -1,
 -60431,
 334447316,
 71215,
 -1,
 334499401,
 71209,
 334697461,
 334446761,
 -1,
 -60428,
 334640010,
 71183,
 -1,
 334696009,
 71182,
 334894072,
 334643189,
 -1,
 -60425,
 334836618,
 71190,
 -1,
 334892617,
 71189,
 335090682,
 334837736,
 71170,
 -1,
 335034344,
 71171,
 335221757,
 335032561,
 -1,
 -60420,
 335164298,
 71185,
 -1,
 335220297,
 71184,
 335418368,
 335157835,
 -1,
 -60417,
 335360906,
 71188,
 -1,
 335416905,
 71187,
 335614979,
 335353373,
 -1,
 -60414,
 335557514,
 71205,
 -1,
 335613513,
 71204,
 -60412,
 335577634,
 71207,
 -60411,
 335765564,
 71208,
 -60410,
 335827729,
 71180,
 -60409,
 335891160,
 71206,
 -60408,
 335950730,
 71214,
 -1,
 336012933,
 71178,
 336204825,
 331971787,
 -1,
 336270351,
 336165995,
 -1,
 336335885,
 336224238,
 71221,
 -1,
 336289774,
 71222,
 336527359,
 336282266,
 71223,
 -1,
 336413338,
 71224,
 336598035,
 336203337,
 -1,
 -60399,
 336557498,
 71228,
 -60398,
 336607208,
 71226,
 -1,
 336662089,
 71216,
 336860181,
 336557498,
 71219,
 -1,
 336819642,
 71220,
 336991255,
 336803816,
 71217,
 -1,
 336934888,
 71218,
 -60392,
 336941841,
 71227,
 -1,
 337061509,
 71225,
 337253418,
 336142675,
 -1,
 337318952,
 337197601,
 -1,
 337384478,
 337276833,
 -1,
 -60387,
 337346632,
 71250,
 -1,
 337393448,
 71251,
 337581089,
 337340399,
 -1,
 -60384,
 337526673,
 71254,
 -1,
 337587323,
 71255,
 337777700,
 337521963,
 -1,
 -60381,
 337729733,
 71252,
 -1,
 337788673,
 71253,
 -60379,
 337740726,
 71248,
 -60378,
 337925482,
 71249,
 -60377,
 337989844,
 71257,
 -1,
 338045083,
 71256,
 -60375,
 337270869,
 71234,
 -1,
 338170447,
 71233,
 338367538,
 337210214,
 -1,
 338433070,
 338328604,
 -1,
 -60371,
 338389183,
 71230,
 -1,
 338452741,
 71231,
 338629681,
 338366025,
 -1,
 -60368,
 338583980,
 71232,
 -1,
 338645742,
 71229,
 -1,
 338573258,
 71236,
 -1,
 338300624,
 71235,
 339017727,
 331886112,
 -1,
 339022917,
 338904791,
 -1,
 339088445,
 338979915,
 -1,
 339153979,
 339034778,
 -1,
 339219514,
 339084642,
 -1,
 -60359,
 339168686,
 43870,
 -1,
 339230050,
 43869,
 -1,
 339163505,
 43001,
 -60356,
 339113468,
 43871,
 -1,
 339424680,
 43868,
 339612738,
 339024459,
 -1,
 339678273,
 339575599,
 -1,
 -60352,
 339635459,
 42653,
 -1,
 339686624,
 42652,
 -1,
 339612461,
 43000,
 340000767,
 339553565,
 -1,
 -60348,
 339888558,
 983981,
 -1,
 339949061,
 983980,
 -1,
 338958766,
 43867,
 340202576,
 331838906,
 -1,
 340268109,
 340152936,
 -1,
 340333644,
 340201627,
 -1,
 -60342,
 340287621,
 128670,
 -60341,
 340335222,
 128672,
 -1,
 340400079,
 128693,
 -1,
 340263430,
 128507,
 340661327,
 340224236,
 128001,
 -1,
 340591071,
 128045,
 -1,
 340619559,
 128068,
 340857945,
 340152069,
 -1,
 340923478,
 340798756,
 -1,
 340989013,
 340852736,
 -1,
 -60332,
 340951005,
 128184,
 -1,
 340989554,
 128176,
 -1,
 340920248,
 129297,
 341251160,
 340869554,
 128018,
 -1,
 341180895,
 128053,
 -1,
 341202748,
 128669,
 341447773,
 340793326,
 128241,
 341573631,
 341377024,
 -1,
 -60324,
 341475210,
 128242,
 -1,
 341529549,
 128244,
 341709920,
 341406565,
 -1,
 -60321,
 341671372,
 128739,
 -1,
 341704948,
 128741,
 341906531,
 341660433,
 -1,
 -60318,
 341856039,
 127889,
 -1,
 341909856,
 128496,
 -60316,
 341869101,
 128511,
 -60315,
 342064172,
 127909,
 -1,
 342126000,
 128332,
 342299829,
 331773370,
 -1,
 342365341,
 342247997,
 -1,
 342430876,
 342299335,
 -1,
 342496411,
 342378199,
 -1,
 342561905,
 342434131,
 -1,
 342627439,
 342499667,
 -1,
 -60307,
 342569866,
 70292,
 -60306,
 342630878,
 70291,
 -1,
 342691401,
 70290,
 -60304,
 342569866,
 70297,
 -1,
 342822473,
 70296,
 343020663,
 342519713,
 -1,
 343086197,
 342978465,
 -1,
 -60300,
 343028618,
 70289,
 -1,
 343084617,
 70288,
 -60298,
 343028618,
 70295,
 -1,
 343215689,
 70294,
 343413883,
 342974446,
 -1,
 -60295,
 343367740,
 70311,
 -60294,
 343421834,
 70312,
 -1,
 343477833,
 70306,
 343676031,
 343363333,
 -1,
 -60291,
 343638562,
 70287,
 -60290,
 343691114,
 70293,
 -1,
 343739977,
 70298,
 343938178,
 343628414,
 -1,
 -60287,
 343880586,
 70300,
 -1,
 343936585,
 70299,
 344134789,
 343883945,
 -1,
 -60284,
 344077194,
 70277,
 -1,
 344133193,
 70276,
 344331400,
 344080373,
 -1,
 -60281,
 344277003,
 70285,
 -1,
 344329801,
 70284,
 344528011,
 344273137,
 -1,
 -60278,
 344470410,
 70280,
 -1,
 344526409,
 70278,
 344724622,
 344463947,
 -1,
 -60275,
 344667018,
 70283,
 -1,
 344723017,
 70282,
 344921233,
 344659485,
 -1,
 -60272,
 344863626,
 70303,
 -1,
 344919625,
 70301,
 -60270,
 344883746,
 70305,
 -60269,
 345078454,
 70308,
 -60268,
 345142714,
 70274,
 -60267,
 345204812,
 70309,
 -60266,
 345262808,
 70304,
 -60265,
 345326292,
 70307,
 -60264,
 345389032,
 70273,
 -60263,
 345453450,
 70310,
 -60262,
 345515653,
 70275,
 -1,
 345574985,
 70272,
 -1,
 342452483,
 70313,
 -1,
 342375824,
 127926,
 345964543,
 342321135,
 -1,
 345969844,
 345848014,
 -1,
 346035377,
 345925615,
 -1,
 346100912,
 345998064,
 -1,
 346166438,
 346039941,
 -1,
 346231973,
 346110467,
 -1,
 -60252,
 346191914,
 119271,
 -1,
 346236175,
 119270,
 -1,
 346181538,
 119263,
 346494121,
 346120075,
 -1,
 -60248,
 346454058,
 119269,
 -1,
 346498319,
 119268,
 346690732,
 346434859,
 -1,
 -60245,
 346637290,
 119272,
 -1,
 346700582,
 119264,
 -60243,
 346652365,
 119266,
 -60242,
 346841617,
 119265,
 -60241,
 346895369,
 119267,
 -1,
 346954320,
 119262,
 -1,
 346038155,
 127932,
 347215027,
 345981366,
 127929,
 -1,
 347145869,
 127896,
 -1,
 347165159,
 127925,
 -1,
 345913204,
 127812,
 347477230,
 342255251,
 -1,
 347542749,
 347424471,
 -1,
 347608251,
 347500449,
 -1,
 -60231,
 347550987,
 92757,
 -60230,
 347613402,
 92766,
 -1,
 347672137,
 92736,
 347870398,
 347558673,
 92754,
 -60227,
 347820817,
 92753,
 -1,
 347882138,
 92749,
 348067010,
 347816105,
 -1,
 -60224,
 348017425,
 92761,
 -60223,
 348074928,
 92744,
 -1,
 348137198,
 92748,
 348329157,
 348020718,
 -1,
 -60220,
 348279569,
 92755,
 -1,
 348338152,
 92765,
 348525768,
 348281470,
 -1,
 -60217,
 348468699,
 92743,
 -1,
 348524105,
 92752,
 348722379,
 348475141,
 -1,
 -60214,
 348666612,
 92751,
 -1,
 348729972,
 92737,
 348918990,
 348670607,
 -1,
 -60211,
 348863165,
 92739,
 -1,
 348917724,
 92750,
 349115600,
 348865236,
 92763,
 -1,
 349064965,
 92762,
 349246675,
 349057930,
 -1,
 -60206,
 349197073,
 92745,
 -1,
 349255656,
 92764,
 349443285,
 349185669,
 92760,
 -1,
 349376073,
 92758,
 349574359,
 349381086,
 92741,
 -1,
 349517800,
 92746,
 -60200,
 349537056,
 92738,
 -60199,
 349666558,
 92759,
 -60198,
 349727413,
 92756,
 -60197,
 349773021,
 92747,
 -60196,
 349836846,
 92740,
 -1,
 349900361,
 92742,
 350158847,
 347480403,
 -1,
 350164204,
 350042657,
 -1,
 350229730,
 350121889,
 -1,
 -60191,
 350191688,
 92770,
 -1,
 350238504,
 92771,
 350426341,
 350185455,
 -1,
 -60188,
 350371729,
 92774,
 -1,
 350432379,
 92775,
 350622952,
 350367019,
 -1,
 -60185,
 350574789,
 92772,
 -1,
 350633729,
 92773,
 -60183,
 350585782,
 92768,
 -60182,
 350770538,
 92769,
 -60181,
 350834900,
 92777,
 -1,
 350890139,
 92776,
 -60179,
 350115925,
 92783,
 -1,
 351015503,
 92782,
 351212835,
 347439669,
 -1,
 351278351,
 351160023,
 -1,
 351343877,
 351236184,
 -1,
 351409399,
 351281491,
 -1,
 351474933,
 351347027,
 -1,
 -60172,
 351417226,
 43502,
 -1,
 351473225,
 43501,
 -60170,
 351417226,
 43516,
 -1,
 351604297,
 43515,
 351802618,
 351358725,
 -1,
 -60167,
 351765026,
 43495,
 -1,
 351817578,
 43503,
 351999229,
 351748085,
 -1,
 -60164,
 351941514,
 43500,
 -1,
 351997513,
 43499,
 352195840,
 351940849,
 -1,
 -60161,
 352138122,
 43498,
 -1,
 352194121,
 43497,
 352392451,
 352130589,
 -1,
 -60158,
 352334730,
 43518,
 -1,
 352390729,
 43517,
 -60156,
 352340177,
 43514,
 -1,
 352529743,
 43496,
 352780287,
 351300013,
 -1,
 352785676,
 352653829,
 -1,
 -60152,
 352735564,
 43491,
 -60151,
 352796756,
 43490,
 -60150,
 352858649,
 43488,
 -60149,
 352918588,
 43489,
 -1,
 352982972,
 43492,
 353239039,
 352746984,
 -1,
 -60146,
 353135100,
 43647,
 -1,
 353180732,
 43646,
 353375517,
 351236195,
 -1,
 353441043,
 353333153,
 -1,
 -60142,
 353402952,
 43506,
 -1,
 353449768,
 43507,
 353637654,
 353396719,
 -1,
 -60139,
 353582993,
 43510,
 -1,
 353643643,
 43511,
 353834265,
 353578283,
 -1,
 -60136,
 353786053,
 43508,
 -1,
 353844993,
 43509,
 -60134,
 353797046,
 43504,
 -60133,
 353981802,
 43505,
 -60132,
 354046164,
 43513,
 -1,
 354101403,
 43512,
 354293026,
 353332070,
 -1,
 354358561,
 354250868,
 -1,
 -60128,
 354290524,
 43645,
 -1,
 354355503,
 43644,
 -1,
 354314782,
 43493,
 -1,
 354242089,
 43494,
 -60124,
 351173862,
 983173,
 -60123,
 354647255,
 983212,
 -1,
 354701006,
 983224,
 354883864,
 276830795,
 -1,
 354948767,
 354842042,
 -1,
 355014295,
 354897959,
 -1,
 355079811,
 354970470,
 -1,
 355145112,
 355025562,
 -1,
 355210637,
 355077705,
 -1,
 355276170,
 355156215,
 -1,
 355341642,
 355208198,
 -1,
 355407164,
 355273001,
 75009,
 355532799,
 355337490,
 -1,
 355538228,
 355431866,
 -1,
 -60110,
 355493826,
 75019,
 -60109,
 355541331,
 75018,
 -1,
 355600687,
 75017,
 355800375,
 355495841,
 -1,
 -60106,
 355739269,
 75016,
 -1,
 355799897,
 75015,
 -60104,
 355746516,
 75014,
 -60103,
 355942992,
 75013,
 -60102,
 356001365,
 75012,
 -60101,
 356062830,
 75011,
 -1,
 356127902,
 75010,
 356324680,
 355339094,
 75021,
 356450303,
 356254994,
 -1,
 356455745,
 356349370,
 -1,
 -60096,
 356411330,
 75030,
 -1,
 356458835,
 75029,
 356652355,
 356399636,
 75024,
 -1,
 356581900,
 75025,
 -60092,
 356608626,
 75028,
 -60091,
 356735767,
 75027,
 -60090,
 356798651,
 75026,
 -60089,
 356856087,
 75023,
 -1,
 356918845,
 75022,
 -60087,
 356256442,
 75020,
 -1,
 357042320,
 75008,
 357242207,
 355273408,
 -1,
 357307733,
 357173952,
 -1,
 357373268,
 357240259,
 74993,
 357498879,
 357303570,
 -1,
 357504337,
 357391091,
 -1,
 -60080,
 357456637,
 74997,
 -1,
 357517924,
 74996,
 -60078,
 357463610,
 74998,
 -60077,
 357644820,
 74995,
 -1,
 357708583,
 74994,
 -1,
 357304467,
 74992,
 357963098,
 357240259,
 -1,
 -60073,
 357895004,
 75006,
 -60072,
 357960199,
 75005,
 -60071,
 358025519,
 75004,
 -1,
 358090755,
 75003,
 358290781,
 357895004,
 -1,
 -60068,
 358223006,
 75000,
 -1,
 358287363,
 74999,
 -60066,
 358223296,
 75002,
 -1,
 358419753,
 75001,
 358618478,
 357173251,
 -1,
 358684003,
 358550852,
 -1,
 -60062,
 358615254,
 74974,
 -1,
 358680579,
 74973,
 358880614,
 358615900,
 -1,
 -60059,
 358811795,
 74970,
 -1,
 358877187,
 74969,
 359077225,
 358811951,
 -1,
 -60056,
 359009116,
 74967,
 -1,
 359073939,
 74966,
 -60054,
 359009858,
 74975,
 -60053,
 359206191,
 74972,
 -60052,
 359271576,
 74971,
 -60051,
 359336618,
 74968,
 -1,
 359401613,
 74965,
 359601530,
 358549807,
 -1,
 359667059,
 359532847,
 -1,
 -60047,
 359599428,
 74982,
 -60046,
 359664476,
 74981,
 -1,
 359729155,
 74980,
 359929206,
 359599110,
 -1,
 -60043,
 359861254,
 74985,
 -1,
 359926620,
 74984,
 360125817,
 359860371,
 -1,
 -60040,
 360058307,
 74979,
 -1,
 360122371,
 74978,
 -1,
 360057533,
 74983,
 360387971,
 359533063,
 -1,
 360453503,
 360319680,
 -1,
 -60035,
 360385860,
 74988,
 -60034,
 360451230,
 74987,
 -1,
 360516103,
 74986,
 360715650,
 360385860,
 -1,
 -60031,
 360647360,
 74990,
 -1,
 360712711,
 74989,
 -1,
 360648252,
 74991,
 360977798,
 360320158,
 -1,
 -60027,
 360909657,
 75032,
 -1,
 360974840,
 75031,
 361174409,
 360908947,
 -1,
 -60024,
 361106259,
 74977,
 -1,
 361171626,
 74976,
 -1,
 361106430,
 75007,
 361496575,
 355217694,
 -1,
 -60020,
 361399256,
 74964,
 -1,
 361443956,
 74632,
 361693183,
 355169837,
 -1,
 361698710,
 361591438,
 -1,
 361764241,
 361650927,
 75036,
 -1,
 361694144,
 75037,
 -60014,
 361721988,
 75038,
 -60013,
 361851658,
 74635,
 -60012,
 361903083,
 75035,
 -60011,
 361966510,
 74634,
 -1,
 362029996,
 75034,
 -60009,
 361654927,
 74633,
 -1,
 362165073,
 75033,
 362354128,
 355082579,
 -1,
 362419650,
 362313146,
 -1,
 362485185,
 362361082,
 -1,
 362550689,
 362431130,
 -1,
 362616224,
 362483273,
 -1,
 362681759,
 362564239,
 74911,
 -1,
 362611994,
 74912,
 -1,
 362627322,
 74910,
 -1,
 362575731,
 74913,
 362943911,
 362496169,
 -1,
 363009446,
 362902970,
 -1,
 363074981,
 362965774,
 74908,
 -1,
 363004851,
 74909,
 -1,
 363028462,
 74907,
 -1,
 362943673,
 74906,
 363337132,
 362885361,
 -1,
 363402667,
 363280360,
 74900,
 -59990,
 363358637,
 74902,
 -1,
 363421748,
 74901,
 -1,
 363335241,
 74899,
 363664816,
 363285135,
 -1,
 -59986,
 363608040,
 74916,
 -59985,
 363670341,
 74915,
 -1,
 363730078,
 74914,
 363926964,
 363597385,
 -1,
 363992499,
 363882925,
 74894,
 -1,
 363921602,
 74895,
 -1,
 363942487,
 74893,
 364189111,
 363882479,
 -1,
 -59978,
 364132345,
 74920,
 -1,
 364197128,
 74919,
 364385722,
 364131196,
 -1,
 -59975,
 364328936,
 74904,
 -1,
 364383817,
 74903,
 364582333,
 364323155,
 -1,
 -59972,
 364541927,
 74897,
 -1,
 364591860,
 74896,
 -59970,
 364534874,
 74918,
 -59969,
 364728507,
 74917,
 -59968,
 364788248,
 74905,
 -1,
 364849925,
 74898,
 -1,
 362419746,
 74614,
 365106633,
 362362856,
 -1,
 365172168,
 365054607,
 -1,
 365237703,
 365102354,
 -1,
 -59962,
 365196782,
 74891,
 -1,
 365246996,
 74890,
 -1,
 365169106,
 74892,
 -1,
 365128112,
 74613,
 365625343,
 365039177,
 -1,
 365630927,
 365506801,
 -1,
 365696462,
 365559808,
 -1,
 -59955,
 365654677,
 74889,
 -1,
 365707755,
 74611,
 -1,
 365627911,
 74612,
 -1,
 365561125,
 74888,
 366024184,
 362295537,
 -1,
 366089711,
 365956681,
 -1,
 366155246,
 366021038,
 -1,
 366220759,
 366104554,
 74948,
 366346239,
 366150572,
 -1,
 -59946,
 366228084,
 74950,
 -1,
 366290648,
 74949,
 366482907,
 366166682,
 -1,
 366548442,
 366416299,
 74944,
 -1,
 366478618,
 74945,
 -1,
 366507888,
 74946,
 366745055,
 366424343,
 74939,
 366870527,
 366698497,
 -1,
 -59938,
 366759914,
 74941,
 -1,
 366814001,
 74940,
 367007204,
 366682451,
 -1,
 367072739,
 366966625,
 -1,
 -59934,
 367018298,
 74937,
 -1,
 367082008,
 74936,
 -1,
 367016640,
 74935,
 367334887,
 366939721,
 -1,
 -59930,
 367290850,
 74618,
 -1,
 367349525,
 74617,
 -59928,
 367297488,
 74952,
 -59927,
 367487681,
 74951,
 -59926,
 367546103,
 74947,
 -59925,
 367608432,
 74943,
 -59924,
 367670157,
 74942,
 -59923,
 367733474,
 74938,
 -1,
 367793786,
 74934,
 -1,
 366089777,
 74953,
 368055794,
 366048698,
 -1,
 -59919,
 367993234,
 74957,
 -1,
 368052673,
 74956,
 368252405,
 367998952,
 -1,
 -59916,
 368208326,
 74955,
 -1,
 368259313,
 74620,
 368508927,
 368191109,
 -1,
 -59913,
 368405244,
 74954,
 -1,
 368445941,
 74619,
 368645647,
 365973253,
 -1,
 368711178,
 368589556,
 74639,
 368776713,
 368648684,
 -1,
 368842238,
 368735674,
 75050,
 -59907,
 368797634,
 75052,
 -1,
 368837587,
 75051,
 369038850,
 368783601,
 -1,
 369104385,
 368981992,
 74642,
 -1,
 369060269,
 75043,
 -1,
 369063837,
 75044,
 -59901,
 368990986,
 75049,
 -59900,
 369249189,
 75048,
 -59899,
 369312557,
 75047,
 -59898,
 369377678,
 75046,
 -59897,
 369440219,
 75045,
 -59896,
 369501067,
 75042,
 -1,
 369563265,
 74641,
 -1,
 368709059,
 74640,
 369825294,
 368670248,
 -1,
 -59892,
 369783048,
 983256,
 -59891,
 369846037,
 74643,
 -1,
 369908155,
 983257,
 -1,
 369757819,
 74638,
 370152995,
 368591104,
 -1,
 370218530,
 370083090,
 -1,
 370284053,
 370177466,
 -1,
 370349588,
 370237422,
 74963,
 -1,
 370280751,
 74631,
 -1,
 370279768,
 74962,
 370546200,
 370225393,
 -1,
 -59881,
 370505480,
 74625,
 -1,
 370556516,
 74624,
 370742811,
 370478665,
 -1,
 -59878,
 370698744,
 74623,
 -1,
 370758231,
 74622,
 -59876,
 370701548,
 74630,
 -59875,
 370895635,
 74629,
 -59874,
 370956960,
 74628,
 -59873,
 371018356,
 74627,
 -59872,
 371081472,
 74961,
 -59871,
 371144158,
 74626,
 -1,
 371202542,
 74960,
 -1,
 370170499,
 74607,
 371463736,
 370091653,
 -1,
 371529267,
 371426225,
 -1,
 371594798,
 371485312,
 -1,
 371660328,
 371543030,
 74930,
 -1,
 371615727,
 74931,
 371791402,
 371606228,
 74928,
 -1,
 371737242,
 74929,
 -59861,
 371748637,
 74932,
 -59860,
 371866136,
 74927,
 -59859,
 371930587,
 74926,
 -1,
 371987614,
 74925,
 372244479,
 371552910,
 -1,
 372250162,
 372140015,
 -1,
 -59855,
 372209082,
 74933,
 -1,
 372258056,
 74616,
 -1,
 372192066,
 74615,
 372512310,
 371460526,
 -1,
 -59851,
 372464367,
 74922,
 -1,
 372523628,
 74921,
 -59849,
 372468198,
 74924,
 -1,
 372663662,
 74923,
 372840012,
 371419119,
 -1,
 372905540,
 372781948,
 -1,
 372971072,
 372844167,
 -1,
 373036607,
 372923623,
 -1,
 -59843,
 372992187,
 75061,
 -59842,
 373051263,
 75060,
 -1,
 373110684,
 75059,
 -1,
 372988408,
 75058,
 373364291,
 372930097,
 -1,
 -59838,
 373303003,
 75063,
 -1,
 373368392,
 75062,
 -1,
 373296766,
 75057,
 373626443,
 372838517,
 -1,
 373691978,
 373584526,
 -1,
 -59833,
 373649540,
 75056,
 -59832,
 373713471,
 75055,
 -59831,
 373766680,
 74646,
 -1,
 373827925,
 75054,
 -1,
 373633888,
 75053,
 -1,
 373569625,
 75064,
 374150744,
 372798906,
 -1,
 374216278,
 374104046,
 -1,
 374281811,
 374175205,
 -1,
 374347346,
 374227610,
 -1,
 -59823,
 374306373,
 75072,
 -1,
 374345977,
 75071,
 -1,
 374284883,
 75070,
 374669311,
 374212913,
 -1,
 -59819,
 374567583,
 75069,
 -1,
 374619460,
 75068,
 -59817,
 374164153,
 74648,
 -1,
 374736213,
 74649,
 374937185,
 374083145,
 -1,
 375002719,
 374871581,
 -1,
 375068254,
 374932754,
 -1,
 375133789,
 375018218,
 74608,
 -1,
 375063713,
 74880,
 -1,
 375089934,
 74881,
 -1,
 374999479,
 74609,
 -59808,
 374950769,
 74610,
 -1,
 375333314,
 74882,
 375527017,
 374885007,
 -1,
 375592551,
 375487028,
 -1,
 375658086,
 375522154,
 -1,
 -59803,
 375603478,
 75041,
 -1,
 375664919,
 75040,
 -1,
 375589512,
 74637,
 -59800,
 375535631,
 75039,
 -1,
 375860124,
 74636,
 376051313,
 375461405,
 -1,
 376116848,
 375983689,
 -1,
 376182383,
 376059069,
 -1,
 -59795,
 376144701,
 74886,
 -59794,
 376197307,
 74885,
 -1,
 376245930,
 74884,
 -1,
 376119728,
 74883,
 -1,
 376075729,
 74887,
 376575607,
 376008609,
 -1,
 376641141,
 376534984,
 -1,
 -59788,
 376598971,
 75067,
 -1,
 376648021,
 75066,
 -59786,
 376584294,
 74647,
 -1,
 376770816,
 75065,
 376968828,
 376537915,
 -1,
 377034363,
 376927674,
 -1,
 -59782,
 376966084,
 75075,
 -1,
 377029523,
 75074,
 -1,
 376966790,
 75073,
 377296512,
 376910716,
 -1,
 -59778,
 377256500,
 74621,
 -59777,
 377305147,
 74959,
 -1,
 377359977,
 74958,
 377618431,
 377248382,
 -1,
 -59774,
 377503187,
 74645,
 -1,
 377564064,
 74644,
 377755286,
 355029724,
 -1,
 377820812,
 377693829,
 -1,
 377886347,
 377766720,
 -1,
 377951881,
 377826603,
 -1,
 -59768,
 377903006,
 74855,
 -1,
 377960798,
 74856,
 -59766,
 377910680,
 74854,
 -1,
 378099112,
 74853,
 -1,
 377829831,
 74861,
 378345103,
 377776111,
 -1,
 -59762,
 378290110,
 74859,
 -1,
 378350743,
 74860,
 378541714,
 378295662,
 -1,
 -59759,
 378494833,
 74851,
 -1,
 378549248,
 74852,
 378738325,
 378481963,
 -1,
 -59756,
 378689833,
 74857,
 -1,
 378748766,
 74858,
 -1,
 378687728,
 74862,
 -1,
 377708203,
 74868,
 379066012,
 354967534,
 -1,
 379131547,
 379019246,
 -1,
 -59750,
 379093467,
 127835,
 -1,
 379136410,
 128177,
 -1,
 379079303,
 10160,
 379453439,
 379022820,
 -1,
 -59746,
 379344145,
 128707,
 -1,
 379392917,
 127854,
 379590522,
 354890620,
 -1,
 379655952,
 379528837,
 -1,
 379721482,
 379609070,
 -1,
 379787015,
 379671649,
 -1,
 379852550,
 379743327,
 -1,
 379918006,
 379809697,
 -1,
 379983532,
 379873263,
 -1,
 -59737,
 379943596,
 43960,
 -59736,
 380007866,
 43959,
 -59735,
 380064529,
 43958,
 -59734,
 380123112,
 43957,
 -59733,
 380184197,
 43956,
 -1,
 380243529,
 43955,
 380442291,
 379929242,
 -1,
 -59730,
 380402348,
 43954,
 -59729,
 380466618,
 43953,
 -59728,
 380523281,
 43952,
 -59727,
 380581864,
 43951,
 -59726,
 380642949,
 43950,
 -1,
 380702281,
 43949,
 -59724,
 380385256,
 43944,
 -59723,
 380839557,
 43942,
 -1,
 380898889,
 43940,
 381097661,
 379873263,
 43933,
 -59720,
 381057708,
 43938,
 -59719,
 381121978,
 43937,
 -59718,
 381178641,
 43936,
 -59717,
 381237224,
 43935,
 -59716,
 381298309,
 43934,
 -1,
 381357641,
 43932,
 381556421,
 381046533,
 -1,
 381621952,
 381488713,
 43918,
 -1,
 381563772,
 43920,
 -59711,
 381581996,
 43925,
 -59710,
 381711802,
 43924,
 -59709,
 381768465,
 43923,
 -59708,
 381827048,
 43922,
 -1,
 381888133,
 43921,
 382080717,
 381498236,
 -1,
 -59705,
 382040748,
 43906,
 -59704,
 382105018,
 43905,
 -59703,
 382161681,
 43904,
 -59702,
 382226282,
 43919,
 -59701,
 382285800,
 43903,
 -59700,
 382346885,
 43902,
 -1,
 382406217,
 43901,
 382605013,
 382017875,
 -1,
 -59697,
 382565036,
 43947,
 -59696,
 382629306,
 43946,
 -59695,
 382685969,
 43945,
 -59694,
 382747348,
 43948,
 -59693,
 382810088,
 43943,
 -59692,
 382871173,
 43941,
 -1,
 382930505,
 43939,
 383129308,
 382566870,
 -1,
 -59689,
 383089324,
 5116,
 -59688,
 383153594,
 5115,
 -59687,
 383210257,
 5114,
 -59686,
 383268840,
 5113,
 -59685,
 383329925,
 5112,
 -1,
 383389257,
 43967,
 383588067,
 383089894,
 -1,
 -59682,
 383548076,
 43966,
 -59681,
 383612346,
 43965,
 -59680,
 383669009,
 43964,
 -59679,
 383727592,
 43963,
 -59678,
 383788677,
 43962,
 -1,
 383848009,
 43961,
 384046826,
 383541035,
 -1,
 -59675,
 384006828,
 43931,
 -59674,
 384071098,
 43930,
 -59673,
 384127761,
 43929,
 -59672,
 384186344,
 43928,
 -59671,
 384247429,
 43927,
 -1,
 384306761,
 43926,
 384505585,
 383994511,
 -1,
 -59668,
 384465580,
 5117,
 -59667,
 384529850,
 43917,
 -59666,
 384586513,
 43916,
 -59665,
 384645096,
 43915,
 -59664,
 384706181,
 43914,
 -1,
 384765513,
 43913,
 384964344,
 384451226,
 -1,
 -59661,
 384924332,
 43912,
 -59660,
 384988602,
 43911,
 -59659,
 385045265,
 43910,
 -59658,
 385103848,
 43909,
 -59657,
 385164933,
 43908,
 -1,
 385224265,
 43907,
 385423103,
 384905457,
 -1,
 -59654,
 385383084,
 43900,
 -59653,
 385447354,
 43899,
 -59652,
 385504017,
 43898,
 -59651,
 385562600,
 43897,
 -59650,
 385623685,
 43896,
 -1,
 385683017,
 43894,
 -59648,
 385383084,
 43893,
 -59647,
 385840570,
 43892,
 -59646,
 385897233,
 43891,
 -59645,
 385958144,
 43895,
 -59644,
 386021352,
 43890,
 -59643,
 386082437,
 43889,
 -1,
 386141769,
 43888,
 -1,
 379799289,
 5109,
 386465791,
 379740142,
 -1,
 -59639,
 386367974,
 127800,
 -1,
 386414938,
 127826,
 386602765,
 379659909,
 -1,
 -59636,
 386558195,
 129472,
 -1,
 386622893,
 128227,
 -59634,
 386559589,
 127792,
 -59633,
 386752441,
 127937,
 -1,
 386801071,
 128638,
 386996084,
 379588169,
 -1,
 387061611,
 386941450,
 -1,
 387127107,
 387008215,
 -1,
 387192601,
 387084193,
 -1,
 387258135,
 387149729,
 -1,
 -59626,
 387199895,
 69906,
 -1,
 387255949,
 69905,
 -59624,
 387199895,
 69911,
 -1,
 387387021,
 69910,
 387585822,
 387141381,
 -1,
 -59621,
 387547685,
 69904,
 -59620,
 387600246,
 69909,
 -59619,
 387658010,
 69899,
 -1,
 387714701,
 69914,
 387913508,
 387522899,
 -1,
 387979042,
 387850579,
 -1,
 -59615,
 387920791,
 69908,
 -1,
 387976845,
 69907,
 -59613,
 387920791,
 69913,
 -1,
 388107917,
 69912,
 388306727,
 387875286,
 -1,
 -59610,
 388268581,
 69920,
 -1,
 388304525,
 69921,
 388503338,
 388258430,
 -1,
 -59607,
 388445079,
 69916,
 -1,
 388501133,
 69915,
 388699949,
 388448425,
 -1,
 -59604,
 388641687,
 69896,
 -1,
 388697741,
 69895,
 388896560,
 388644853,
 -1,
 -59601,
 388838295,
 69903,
 -1,
 388894349,
 69902,
 389093171,
 388837617,
 -1,
 -59598,
 389034903,
 69898,
 -1,
 389090957,
 69897,
 389289782,
 389028427,
 -1,
 -59595,
 389231511,
 69901,
 -1,
 389287565,
 69900,
 389486393,
 389223965,
 -1,
 -59592,
 389428119,
 69918,
 -1,
 389484173,
 69917,
 -59590,
 389446913,
 69924,
 -59589,
 389641658,
 69893,
 -59588,
 389703767,
 69925,
 -59587,
 389767243,
 69922,
 -59586,
 389827291,
 69919,
 -59585,
 389890775,
 69923,
 -59584,
 389953512,
 69892,
 -59583,
 390017943,
 69926,
 -59582,
 390080133,
 69894,
 -1,
 390139533,
 69891,
 390338388,
 387064147,
 -1,
 390403922,
 390281761,
 -1,
 390469448,
 390360993,
 -1,
 -59577,
 390430792,
 69944,
 -1,
 390477608,
 69945,
 390666059,
 390424559,
 -1,
 -59574,
 390610833,
 69948,
 -1,
 390671483,
 69949,
 390862670,
 390606123,
 -1,
 -59571,
 390813893,
 69946,
 -1,
 390872833,
 69947,
 -59569,
 390824886,
 69942,
 -59568,
 391009642,
 69943,
 -59567,
 391074004,
 69951,
 -1,
 391129243,
 69950,
 -59565,
 390355029,
 69954,
 -1,
 391254607,
 69953,
 391452513,
 390298284,
 -1,
 391518048,
 391404076,
 -1,
 391583577,
 391450185,
 69927,
 -59560,
 391542202,
 69935,
 -1,
 391591912,
 69933,
 391780187,
 391542202,
 69930,
 -1,
 391738810,
 69931,
 391911261,
 391729937,
 69934,
 -1,
 391854056,
 69936,
 392042335,
 391854056,
 69928,
 -1,
 391985128,
 69929,
 -1,
 391980677,
 69932,
 -1,
 391462365,
 69939,
 392304487,
 391407599,
 -1,
 392370022,
 392247854,
 -1,
 -59548,
 392330318,
 69890,
 -59547,
 392370888,
 69888,
 -1,
 392434448,
 69889,
 -1,
 392308626,
 69952,
 -59544,
 392257477,
 69955,
 -59543,
 392647469,
 69937,
 -59542,
 392710879,
 69940,
 -1,
 392762792,
 69938,
 393019391,
 387014638,
 -1,
 393025392,
 392917008,
 -1,
 393090927,
 392984980,
 128200,
 -1,
 393019493,
 128185,
 -1,
 393029127,
 128201,
 393347071,
 392957854,
 983058,
 393412607,
 393216000,
 -1,
 -59533,
 393314140,
 983139,
 -1,
 393374102,
 983136,
 393549688,
 386938856,
 -1,
 -59530,
 393501949,
 128063,
 -59529,
 393561201,
 128696,
 -1,
 393616810,
 128020,
 -59527,
 393504309,
 127876,
 -1,
 393761666,
 127851,
 393943076,
 379540241,
 -1,
 394008540,
 393890447,
 -1,
 394074075,
 393943042,
 -1,
 394139541,
 394019482,
 -1,
 394205072,
 394073414,
 -1,
 394270594,
 394163700,
 -1,
 -59519,
 394217489,
 7664,
 -1,
 394273588,
 7668,
 394467205,
 394220340,
 -1,
 -59516,
 394414097,
 7661,
 -1,
 394470196,
 7667,
 394663815,
 394401309,
 7656,
 -1,
 394603472,
 7657,
 394794890,
 394595913,
 -1,
 -59511,
 394742322,
 7655,
 -1,
 394790388,
 7666,
 -59509,
 394755302,
 7665,
 -59508,
 394946775,
 7658,
 -59507,
 395008638,
 7662,
 -59506,
 395068089,
 7660,
 -59505,
 395128107,
 7659,
 -1,
 395193244,
 7663,
 395444223,
 394148195,
 -1,
 395450260,
 395318648,
 -1,
 -59501,
 395404241,
 65064,
 -1,
 395461918,
 65063,
 -1,
 395392893,
 6841,
 395712423,
 394074699,
 -1,
 395777958,
 395674415,
 -1,
 395843491,
 395724503,
 -1,
 395909019,
 395805142,
 -1,
 -59494,
 395851752,
 42614,
 -1,
 395914049,
 42617,
 396105629,
 395867578,
 42615,
 -1,
 396051001,
 42612,
 396236703,
 396048360,
 42613,
 -1,
 396187630,
 42655,
 -59488,
 396193027,
 42618,
 -59487,
 396317942,
 42619,
 -59486,
 396375264,
 42616,
 -1,
 396437559,
 42654,
 396689407,
 395801320,
 -1,
 -59483,
 396583878,
 65071,
 -1,
 396641556,
 65070,
 -1,
 395728402,
 65069,
 396892088,
 395653864,
 -1,
 396957618,
 396829572,
 -1,
 397023148,
 396914593,
 -1,
 -59477,
 396984392,
 70504,
 -1,
 397031208,
 70505,
 397219759,
 396963115,
 -1,
 -59474,
 397170885,
 70506,
 -1,
 397229825,
 70507,
 -59472,
 397181878,
 70502,
 -59471,
 397372431,
 70508,
 -1,
 397432170,
 70503,
 397672447,
 396904151,
 -1,
 -59468,
 397573148,
 70515,
 -59467,
 397630112,
 70516,
 -59466,
 397692778,
 70514,
 -59465,
 397754624,
 70513,
 -1,
 397807177,
 70512,
 398006208,
 396841745,
 -1,
 398071743,
 397952068,
 -1,
 -59461,
 398033825,
 66424,
 -59460,
 398093265,
 66426,
 -59459,
 398151733,
 66425,
 -59458,
 398205964,
 66423,
 -1,
 398266882,
 66422,
 -1,
 398023622,
 6839,
 398530506,
 397943123,
 -1,
 398596041,
 398480145,
 -1,
 398661576,
 398554764,
 -1,
 398727111,
 398589952,
 -1,
 -59451,
 398678865,
 6844,
 -59450,
 398743255,
 6840,
 -1,
 398802253,
 7676,
 -1,
 398664041,
 6832,
 -1,
 398622758,
 6835,
 -1,
 398538861,
 6833,
 399185871,
 398487457,
 -1,
 399251406,
 399129223,
 -1,
 -59443,
 399205329,
 65066,
 -1,
 399263006,
 65065,
 -1,
 399205839,
 6836,
 399513555,
 399137604,
 -1,
 -59439,
 399464961,
 6846,
 -59438,
 399513394,
 6845,
 -1,
 399576826,
 6843,
 399775702,
 399461115,
 -1,
 -59435,
 399729617,
 65068,
 -1,
 399787294,
 65067,
 -59433,
 399737192,
 6837,
 -59432,
 399933158,
 6838,
 -59431,
 399997114,
 7669,
 -59430,
 400060104,
 6842,
 -1,
 400112615,
 6834,
 -1,
 394026508,
 128476,
 400365580,
 393961027,
 -1,
 400431114,
 400304717,
 -1,
 400496636,
 400380593,
 -1,
 400562151,
 400453537,
 -1,
 400627683,
 400522470,
 -1,
 -59422,
 400577305,
 66292,
 -1,
 400632383,
 66283,
 400824294,
 400569212,
 -1,
 -59419,
 400777831,
 66293,
 -1,
 400834136,
 66284,
 -1,
 400763221,
 66282,
 401086446,
 400517103,
 -1,
 401151979,
 401031057,
 -1,
 -59414,
 401110435,
 66287,
 -1,
 401146402,
 66296,
 401407999,
 401091707,
 -1,
 -59411,
 401307043,
 66288,
 -1,
 401343010,
 66297,
 401545205,
 401026347,
 -1,
 401610738,
 401494801,
 -1,
 -59407,
 401570230,
 66294,
 -1,
 401631163,
 66285,
 401866751,
 401553384,
 -1,
 -59404,
 401767139,
 66295,
 -1,
 401813727,
 66286,
 402003960,
 401494228,
 -1,
 -59401,
 401962403,
 66290,
 -1,
 401998370,
 66299,
 402200571,
 401942683,
 -1,
 -59398,
 402162134,
 66289,
 -1,
 402194978,
 66298,
 -1,
 402150780,
 66291,
 402462729,
 400434052,
 -1,
 402528256,
 402419617,
 -1,
 -59393,
 402489416,
 66274,
 -1,
 402536232,
 66275,
 402724867,
 402483183,
 -1,
 -59390,
 402669457,
 66278,
 -1,
 402730107,
 66279,
 402921478,
 402664747,
 -1,
 -59387,
 402872517,
 66276,
 -1,
 402931457,
 66277,
 -59385,
 402871658,
 66273,
 -59384,
 403067092,
 66281,
 -1,
 403122331,
 66280,
 -1,
 402420133,
 66272,
 -59381,
 400387181,
 11507,
 -1,
 403315441,
 11506,
 403511320,
 400314117,
 -1,
 403576849,
 403451179,
 -1,
 -59377,
 403536426,
 128533,
 -59376,
 403593401,
 128534,
 -1,
 403647471,
 127882,
 403838996,
 403535050,
 -1,
 -59373,
 403794295,
 983186,
 -1,
 403849749,
 127899,
 404035607,
 403795713,
 -1,
 -59370,
 403996920,
 128119,
 -1,
 404056929,
 128679,
 -1,
 403995440,
 127978,
 404297757,
 403461181,
 -1,
 404363292,
 404240360,
 -1,
 -59365,
 404312182,
 127859,
 -1,
 404366981,
 127850,
 -1,
 404301780,
 127834,
 404625439,
 404258022,
 128004,
 -1,
 404554207,
 128046,
 404756514,
 404583866,
 -1,
 -59359,
 404708526,
 128145,
 -1,
 404757524,
 128715,
 -59357,
 404703499,
 128165,
 -1,
 404889039,
 127864,
 405084300,
 393875017,
 -1,
 405149809,
 405042922,
 -1,
 405215344,
 405096151,
 -1,
 405280819,
 405150283,
 -1,
 405346349,
 405222268,
 -1,
 405411883,
 405278281,
 66873,
 -1,
 405368737,
 66902,
 -59348,
 405363277,
 66889,
 -1,
 405485544,
 66890,
 405674032,
 405307938,
 -1,
 -59345,
 405635542,
 66891,
 -1,
 405699814,
 66911,
 405929983,
 405605961,
 -1,
 -59342,
 405832469,
 66912,
 -1,
 405889006,
 66882,
 406067257,
 405235695,
 -1,
 406132792,
 406008700,
 -1,
 406198327,
 406064713,
 66877,
 -1,
 406143145,
 66896,
 -1,
 406149709,
 66909,
 -1,
 406072615,
 66906,
 406460479,
 406004051,
 -1,
 406526013,
 406422331,
 -1,
 -59332,
 406487630,
 66895,
 -1,
 406525433,
 66901,
 -59330,
 406487601,
 66881,
 -1,
 406656221,
 66867,
 406853700,
 406422331,
 -1,
 406919235,
 406795132,
 -1,
 -59326,
 406862450,
 66871,
 -1,
 406916681,
 66875,
 -1,
 406852550,
 66869,
 407181384,
 406810529,
 -1,
 -59322,
 407142990,
 66899,
 -59321,
 407191437,
 66908,
 -1,
 407245949,
 66872,
 407443532,
 407123944,
 -1,
 -59318,
 407404552,
 66910,
 -59317,
 407462267,
 66876,
 -1,
 407524095,
 66879,
 407705679,
 407405014,
 -1,
 -59314,
 407657000,
 66874,
 -1,
 407705093,
 66913,
 407902290,
 407658240,
 -1,
 -59311,
 407863766,
 66887,
 -1,
 407920622,
 66893,
 408098901,
 407853694,
 -1,
 -59308,
 408043405,
 66914,
 -1,
 408103253,
 66903,
 408295512,
 408044186,
 -1,
 -59305,
 408257240,
 66885,
 -1,
 408293890,
 66878,
 408492123,
 408240297,
 -1,
 -59302,
 408436618,
 66915,
 -1,
 408490841,
 66884,
 408688734,
 408436725,
 -1,
 -59299,
 408631076,
 66883,
 -1,
 408688153,
 66897,
 408885345,
 408629489,
 -1,
 -59296,
 408828605,
 66866,
 -1,
 408892874,
 66904,
 409081956,
 408823429,
 -1,
 -59293,
 409043733,
 66870,
 -1,
 409081373,
 66868,
 409278567,
 409013833,
 -1,
 -59290,
 409229089,
 66888,
 -1,
 409291325,
 66864,
 -59288,
 409239942,
 66880,
 -59287,
 409435159,
 66907,
 -59286,
 409493798,
 66905,
 -59285,
 409556245,
 66898,
 -59284,
 409620992,
 66894,
 -59283,
 409684845,
 66892,
 -59282,
 409744847,
 66886,
 -59281,
 409808292,
 66900,
 -1,
 409868126,
 66865,
 -1,
 405151093,
 66927,
 410130553,
 405102574,
 -1,
 410196086,
 410067285,
 -1,
 410261621,
 410139480,
 128199,
 -1,
 410190240,
 128450,
 -1,
 410201638,
 128451,
 -59273,
 410149722,
 983073,
 -59272,
 410409621,
 127887,
 -1,
 410474812,
 127904,
 410654848,
 410078981,
 983098,
 410720381,
 410590159,
 983097,
 -59268,
 410666000,
 128473,
 -1,
 410714452,
 983170,
 410976255,
 410657107,
 -1,
 -59265,
 410878422,
 127852,
 -1,
 410928256,
 128367,
 411113605,
 410611617,
 128008,
 411238399,
 411042271,
 128049,
 411303935,
 411108706,
 -1,
 -59260,
 411205939,
 128572,
 -1,
 411267272,
 128569,
 411441289,
 411060879,
 -1,
 411506824,
 411380420,
 128247,
 -1,
 411436620,
 128248,
 -1,
 411458668,
 127957,
 -59254,
 411393157,
 11839,
 -59253,
 411649724,
 128197,
 -1,
 411705537,
 127797,
 411900117,
 405029530,
 -1,
 411965644,
 411849489,
 -1,
 412031168,
 411901315,
 -1,
 412096697,
 411959781,
 -1,
 412162206,
 412053409,
 -1,
 412227736,
 412122342,
 -1,
 412293269,
 412177169,
 -1,
 -59244,
 412223483,
 128349,
 -1,
 412287724,
 128337,
 412549119,
 412231977,
 -1,
 -59241,
 412420091,
 128359,
 -1,
 412484332,
 128347,
 412686491,
 412170024,
 -1,
 -59238,
 412616699,
 128350,
 -1,
 412680940,
 128338,
 412942335,
 412625237,
 -1,
 -59235,
 412813307,
 128357,
 -1,
 412877548,
 128345,
 413079717,
 412116975,
 -1,
 413145250,
 413024145,
 -1,
 -59231,
 413075451,
 128353,
 -1,
 413139692,
 128341,
 413401087,
 413084795,
 -1,
 -59228,
 413272059,
 128354,
 -1,
 413336300,
 128342,
 413538476,
 413019435,
 -1,
 413604009,
 413489349,
 -1,
 -59224,
 413534203,
 128351,
 -1,
 413598444,
 128339,
 413859839,
 413548289,
 -1,
 -59221,
 413730811,
 128352,
 -1,
 413795052,
 128340,
 413997235,
 413476485,
 -1,
 414062768,
 413943650,
 -1,
 -59217,
 413992955,
 128358,
 -1,
 414057196,
 128346,
 414318591,
 414005673,
 -1,
 -59214,
 414189563,
 128355,
 -1,
 414253804,
 128343,
 414455990,
 413947242,
 -1,
 -59211,
 414386171,
 128348,
 -1,
 414450412,
 128336,
 414711807,
 414404820,
 -1,
 -59208,
 414582779,
 128356,
 -1,
 414647020,
 128344,
 414908415,
 412057381,
 -1,
 414914750,
 414802844,
 -1,
 414980285,
 414874957,
 128257,
 -1,
 414909872,
 128258,
 -1,
 414908464,
 128472,
 -59201,
 414872689,
 11118,
 -1,
 415114680,
 128259,
 415307975,
 411986205,
 -1,
 415373508,
 415255309,
 -1,
 -59197,
 415326354,
 128235,
 -1,
 415386141,
 128234,
 -59195,
 415332306,
 127746,
 -59194,
 415516980,
 128272,
 -1,
 415570248,
 128213,
 415825919,
 415266571,
 -1,
 -59191,
 415724399,
 127786,
 -59190,
 415788286,
 127784,
 -59189,
 415850637,
 127783,
 -1,
 415909986,
 127785,
 416094418,
 411897417,
 -1,
 416159952,
 416046538,
 -1,
 -59185,
 416103435,
 128079,
 -1,
 416164522,
 127916,
 -59183,
 416116175,
 127963,
 -1,
 416304826,
 128385,
 416546815,
 416036840,
 -1,
 -59180,
 416439203,
 128203,
 -1,
 416502069,
 127867,
 416684270,
 411861462,
 -1,
 416749805,
 416638297,
 -1,
 416815330,
 416705631,
 -1,
 416880860,
 416751955,
 -1,
 -59174,
 416842739,
 1323,
 -59173,
 416897121,
 42649,
 -1,
 416947290,
 1325,
 417143007,
 416818821,
 -1,
 -59170,
 417091394,
 1321,
 -1,
 417153704,
 1327,
 -59168,
 417098401,
 1319,
 -59167,
 417293096,
 42593,
 -1,
 417341544,
 42651,
 417595391,
 416750305,
 -1,
 417601767,
 417472851,
 -1,
 -59163,
 417563635,
 1322,
 -59162,
 417618017,
 42648,
 -1,
 417668186,
 1324,
 417863914,
 417539717,
 -1,
 -59159,
 417812290,
 1320,
 -1,
 417874600,
 1326,
 -59157,
 417819297,
 1318,
 -59156,
 418013992,
 42592,
 -1,
 418062440,
 42650,
 -1,
 416685546,
 127744,
 418322690,
 416636910,
 983074,
 418388216,
 418272017,
 -1,
 418453750,
 418344382,
 -1,
 418519285,
 418381824,
 -1,
 418584820,
 418471266,
 128322,
 -1,
 418514535,
 128321,
 -1,
 418532223,
 10060,
 -1,
 418457522,
 127884,
 -59145,
 418414600,
 128081,
 -1,
 418782755,
 128010,
 418978045,
 418349526,
 -1,
 419043580,
 418921460,
 -1,
 -59141,
 418983250,
 128546,
 -1,
 419044165,
 128575,
 -1,
 418999815,
 128302,
 419305728,
 418915973,
 -1,
 -59137,
 419260620,
 127769,
 -1,
 419308465,
 128179,
 -59135,
 419248377,
 127951,
 -1,
 419434151,
 129408,
 419633425,
 418265064,
 -1,
 419698958,
 419586430,
 -1,
 419764493,
 419644655,
 -1,
 419830026,
 419706856,
 -1,
 419895561,
 419766984,
 -1,
 -59128,
 419833453,
 127568,
 -1,
 419896210,
 127569,
 -1,
 419844196,
 128712,
 -59125,
 419791174,
 11198,
 -59124,
 420094035,
 128320,
 -1,
 420157761,
 11199,
 -1,
 419723810,
 127914,
 420419856,
 419657138,
 127961,
 -1,
 420348089,
 127750,
 -1,
 420368432,
 127910,
 420616468,
 419577956,
 -1,
 -59117,
 420556075,
 64047,
 -1,
 420619909,
 64046,
 -59115,
 420571928,
 983187,
 -59114,
 420754097,
 983200,
 -59113,
 420817181,
 128328,
 -1,
 420879377,
 983171,
 421075948,
 354828954,
 -1,
 421141198,
 421017576,
 -1,
 421206704,
 421089029,
 -1,
 421272237,
 421144197,
 -1,
 421337769,
 421204828,
 -1,
 421403005,
 421271069,
 -1,
 421468526,
 421332995,
 -1,
 421533998,
 421398831,
 -1,
 421599523,
 421464367,
 67090,
 -59102,
 421546639,
 67092,
 -1,
 421604651,
 67091,
 421796134,
 421529747,
 67087,
 -59099,
 421743247,
 67089,
 -1,
 421801259,
 67088,
 421992744,
 421726727,
 67093,
 -1,
 421939855,
 67094,
 -59095,
 421924291,
 67100,
 -59094,
 422055236,
 67098,
 -59093,
 422120606,
 67097,
 -59092,
 422185990,
 67096,
 -59091,
 422251200,
 67095,
 -1,
 422316035,
 67086,
 422517048,
 421464924,
 -1,
 -59088,
 422448579,
 67123,
 -59087,
 422513988,
 67122,
 -59086,
 422579358,
 67121,
 -59085,
 422644742,
 67120,
 -59084,
 422710108,
 67119,
 -59083,
 422775488,
 67118,
 -59082,
 422840839,
 67117,
 -59081,
 422906003,
 67116,
 -1,
 422971395,
 67115,
 423172418,
 422447107,
 -1,
 -59078,
 423103939,
 67080,
 -59077,
 423169348,
 67079,
 -59076,
 423234718,
 67078,
 -59075,
 423300102,
 67077,
 -59074,
 423365468,
 67076,
 -59073,
 423430848,
 67075,
 -59072,
 423496199,
 67074,
 -59071,
 423561519,
 67073,
 -1,
 423626899,
 67072,
 423827787,
 423103168,
 -1,
 -59068,
 423759299,
 67114,
 -59067,
 423824708,
 67113,
 -59066,
 423890078,
 67112,
 -59065,
 423955462,
 67111,
 -59064,
 424020828,
 67110,
 -59063,
 424086208,
 67109,
 -59062,
 424151187,
 67108,
 -1,
 424216579,
 67107,
 424417619,
 423759006,
 -1,
 -59059,
 424349123,
 67136,
 -59058,
 424414532,
 67135,
 -59057,
 424479902,
 67134,
 -59056,
 424545286,
 67133,
 -59055,
 424610496,
 67132,
 -59054,
 424675847,
 67131,
 -1,
 424740867,
 67130,
 424941914,
 424348996,
 -1,
 -59051,
 424873118,
 67142,
 -59050,
 424938502,
 67141,
 -59049,
 425003868,
 67140,
 -59048,
 425068847,
 67139,
 -59047,
 425134227,
 67138,
 -1,
 425199619,
 67137,
 425400673,
 424872966,
 -1,
 -59044,
 425332163,
 67129,
 -59043,
 425397406,
 67128,
 -59042,
 425462790,
 67127,
 -59041,
 425528156,
 67126,
 -59040,
 425592979,
 67125,
 -1,
 425658371,
 67124,
 425859432,
 425331207,
 -1,
 -59037,
 425790915,
 67106,
 -59036,
 425856324,
 67105,
 -59035,
 425921694,
 67104,
 -59034,
 425986752,
 67103,
 -59033,
 426051731,
 67102,
 -1,
 426117123,
 67101,
 426377215,
 425789587,
 -1,
 -59030,
 426249374,
 67085,
 -59029,
 426314758,
 67084,
 -59028,
 426379783,
 67083,
 -59027,
 426444947,
 67082,
 -1,
 426510339,
 67081,
 426770431,
 421398675,
 -1,
 426776947,
 426641711,
 -1,
 -59023,
 426707463,
 67148,
 -59022,
 426772783,
 67147,
 -1,
 426838019,
 67145,
 427039094,
 426708292,
 -1,
 -59019,
 426970436,
 67155,
 -1,
 427034627,
 67154,
 427235705,
 426969773,
 -1,
 -59016,
 427169309,
 67150,
 -1,
 427232841,
 67149,
 -59014,
 427167295,
 67156,
 -59013,
 427363628,
 67153,
 -59012,
 427429019,
 67152,
 -1,
 427493676,
 67144,
 427694552,
 421333852,
 -1,
 427760009,
 427625796,
 -1,
 -59008,
 427691459,
 67324,
 -59007,
 427756868,
 67323,
 -59006,
 427822238,
 67322,
 -59005,
 427887622,
 67321,
 -59004,
 427952988,
 67320,
 -59003,
 428018368,
 67319,
 -59002,
 428083719,
 67318,
 -59001,
 428149039,
 67317,
 -59000,
 428214419,
 67316,
 -1,
 428279811,
 67315,
 428480916,
 427691166,
 -1,
 -58997,
 428412355,
 67314,
 -58996,
 428477764,
 67313,
 -58995,
 428543134,
 67312,
 -58994,
 428608518,
 67311,
 -58993,
 428673884,
 67310,
 -58992,
 428739264,
 67309,
 -58991,
 428804615,
 67308,
 -58990,
 428869935,
 67307,
 -58989,
 428935315,
 67306,
 -1,
 429000707,
 67305,
 429201822,
 428411740,
 -1,
 -58986,
 429133251,
 67298,
 -58985,
 429198494,
 67297,
 -58984,
 429263878,
 67296,
 -58983,
 429329244,
 67295,
 -58982,
 429394624,
 67294,
 -58981,
 429459975,
 67293,
 -58980,
 429525295,
 67292,
 -58979,
 429590675,
 67291,
 -1,
 429656067,
 67290,
 429857192,
 429132295,
 -1,
 -58976,
 429788611,
 67282,
 -58975,
 429854020,
 67281,
 -58974,
 429919390,
 67280,
 -58973,
 429984774,
 67279,
 -58972,
 430050140,
 67278,
 -58971,
 430115520,
 67277,
 -58970,
 430180655,
 67276,
 -58969,
 430246035,
 67275,
 -1,
 430311427,
 67274,
 430512562,
 429787439,
 -1,
 -58966,
 430443971,
 67273,
 -58965,
 430509380,
 67272,
 -58964,
 430574750,
 67271,
 -58963,
 430640134,
 67270,
 -58962,
 430705500,
 67269,
 -58961,
 430770880,
 67268,
 -58960,
 430836231,
 67267,
 -58959,
 430901395,
 67266,
 -1,
 430966787,
 67265,
 431167931,
 430442499,
 -1,
 -58956,
 431099331,
 67258,
 -58955,
 431164740,
 67257,
 -58954,
 431229958,
 67256,
 -58953,
 431295324,
 67255,
 -58952,
 431360704,
 67254,
 -58951,
 431426055,
 67253,
 -58950,
 431491375,
 67252,
 -1,
 431556755,
 67251,
 431757763,
 431098560,
 -1,
 -58947,
 431689155,
 67289,
 -58946,
 431754564,
 67288,
 -58945,
 431819934,
 67287,
 -58944,
 431885148,
 67286,
 -58943,
 431950127,
 67285,
 -58942,
 432015507,
 67284,
 -1,
 432080899,
 67283,
 432282058,
 431689155,
 -1,
 -58939,
 432213316,
 67330,
 -58938,
 432278534,
 67329,
 -58937,
 432343900,
 67328,
 -58936,
 432409280,
 67327,
 -58935,
 432474415,
 67326,
 -1,
 432539795,
 67325,
 432740817,
 432212998,
 -1,
 -58932,
 432672195,
 67304,
 -58931,
 432737604,
 67303,
 -58930,
 432802822,
 67302,
 -58929,
 432868188,
 67301,
 -58928,
 432933568,
 67300,
 -1,
 432998919,
 67299,
 433258495,
 432670867,
 -1,
 -58925,
 433130502,
 67264,
 -58924,
 433195868,
 67263,
 -58923,
 433261063,
 67262,
 -58922,
 433326383,
 67261,
 -58921,
 433391763,
 67260,
 -1,
 433457155,
 67259,
 433658414,
 427624967,
 -1,
 433723879,
 433588371,
 -1,
 433789406,
 433654279,
 -1,
 -58916,
 433723979,
 67173,
 -58915,
 433788445,
 67172,
 -1,
 433851977,
 67171,
 -58913,
 433720771,
 67179,
 -58912,
 433982788,
 67178,
 -58911,
 434048158,
 67177,
 -58910,
 434113542,
 67176,
 -58909,
 434178908,
 67175,
 -58908,
 434244288,
 67174,
 -58907,
 434309423,
 67170,
 -58906,
 434374803,
 67169,
 -1,
 434440195,
 67168,
 434641396,
 433653763,
 -1,
 434706924,
 434572739,
 -1,
 -58902,
 434641483,
 67167,
 -58901,
 434705949,
 67166,
 -1,
 434769481,
 67165,
 -58899,
 434638148,
 67164,
 -58898,
 434900126,
 67163,
 -58897,
 434965510,
 67162,
 -58896,
 435030876,
 67161,
 -58895,
 435096256,
 67160,
 -58894,
 435161607,
 67159,
 -58893,
 435226927,
 67158,
 -1,
 435292307,
 67157,
 435493375,
 434572294,
 -1,
 -58890,
 435424707,
 67229,
 -58889,
 435490116,
 67228,
 -58888,
 435555486,
 67227,
 -58887,
 435620870,
 67226,
 -58886,
 435686236,
 67225,
 -58885,
 435751616,
 67224,
 -58884,
 435816967,
 67223,
 -58883,
 435882287,
 67222,
 -58882,
 435947667,
 67221,
 -1,
 436013059,
 67220,
 436214282,
 435424092,
 -1,
 -58879,
 436145603,
 67219,
 -58878,
 436211012,
 67218,
 -58877,
 436276382,
 67217,
 -58876,
 436341766,
 67216,
 -58875,
 436407132,
 67215,
 -58874,
 436472512,
 67214,
 -58873,
 436537863,
 67213,
 -58872,
 436603183,
 67212,
 -58871,
 436668563,
 67211,
 -1,
 436733955,
 67210,
 436935189,
 436144832,
 -1,
 -58868,
 436866499,
 67209,
 -58867,
 436931908,
 67208,
 -58866,
 436997278,
 67207,
 -58865,
 437062662,
 67206,
 -58864,
 437128028,
 67205,
 -58863,
 437193408,
 67204,
 -58862,
 437258759,
 67203,
 -58861,
 437324079,
 67202,
 -58860,
 437389459,
 67201,
 -1,
 437454851,
 67200,
 437656096,
 436865543,
 -1,
 -58857,
 437587395,
 67199,
 -58856,
 437652804,
 67198,
 -58855,
 437718174,
 67197,
 -58854,
 437783558,
 67196,
 -58853,
 437848924,
 67195,
 -58852,
 437914304,
 67194,
 -58851,
 437979655,
 67193,
 -58850,
 438044975,
 67192,
 -58849,
 438110355,
 67191,
 -1,
 438175747,
 67190,
 438377003,
 437586223,
 -1,
 -58846,
 438308291,
 67189,
 -58845,
 438373700,
 67188,
 -58844,
 438439070,
 67187,
 -58843,
 438504454,
 67186,
 -58842,
 438569820,
 67185,
 -58841,
 438635200,
 67184,
 -58840,
 438700551,
 67183,
 -58839,
 438765871,
 67182,
 -58838,
 438831251,
 67181,
 -1,
 438896643,
 67180,
 439156735,
 438307998,
 -1,
 -58835,
 439027859,
 67231,
 -1,
 439093251,
 67230,
 439294570,
 433589254,
 -1,
 439360058,
 439224467,
 -1,
 -58831,
 439291331,
 67348,
 -58830,
 439356740,
 67347,
 -58829,
 439422110,
 67346,
 -58828,
 439487494,
 67345,
 -58827,
 439552860,
 67344,
 -58826,
 439618240,
 67343,
 -58825,
 439683591,
 67342,
 -58824,
 439748911,
 67341,
 -58823,
 439814291,
 67340,
 -1,
 439879683,
 67339,
 440080964,
 439290716,
 -1,
 -58820,
 440012227,
 67377,
 -58819,
 440077636,
 67376,
 -58818,
 440143006,
 67375,
 -58817,
 440208390,
 67374,
 -58816,
 440273756,
 67373,
 -58815,
 440339136,
 67372,
 -58814,
 440404487,
 67371,
 -58813,
 440469807,
 67370,
 -1,
 440535187,
 67369,
 440736334,
 440011055,
 -1,
 -58810,
 440667587,
 67357,
 -58809,
 440732996,
 67356,
 -58808,
 440798366,
 67355,
 -58807,
 440863750,
 67354,
 -58806,
 440928960,
 67353,
 -58805,
 440994311,
 67352,
 -58804,
 441059631,
 67351,
 -58803,
 441125011,
 67350,
 -1,
 441190403,
 67349,
 441391703,
 440666816,
 -1,
 -58800,
 441322947,
 67368,
 -58799,
 441388356,
 67367,
 -58798,
 441453574,
 67366,
 -58797,
 441518940,
 67365,
 -58796,
 441584320,
 67364,
 -58795,
 441649671,
 67363,
 -58794,
 441714991,
 67362,
 -1,
 441780227,
 67361,
 441981536,
 441321475,
 -1,
 -58791,
 441912771,
 67338,
 -58790,
 441978180,
 67337,
 -58789,
 442043398,
 67336,
 -58788,
 442108608,
 67335,
 -58787,
 442173959,
 67334,
 -58786,
 442239279,
 67333,
 -58785,
 442304659,
 67332,
 -1,
 442370051,
 67331,
 442571366,
 441912326,
 -1,
 -58782,
 442501824,
 67382,
 -58781,
 442567175,
 67381,
 -58780,
 442632495,
 67380,
 -58779,
 442697875,
 67379,
 -1,
 442763267,
 67378,
 443023359,
 442501639,
 -1,
 -58776,
 442895684,
 67360,
 -58775,
 442961054,
 67359,
 -1,
 443026112,
 67358,
 443226757,
 439225502,
 -1,
 443292283,
 443156483,
 -1,
 443357811,
 443223491,
 -1,
 443423346,
 443287402,
 -1,
 -58769,
 443354175,
 67404,
 -58768,
 443419368,
 67403,
 -58767,
 443484755,
 67402,
 -1,
 443550049,
 67401,
 -1,
 443351646,
 67400,
 -58764,
 443288951,
 67399,
 -58763,
 443747533,
 67398,
 -58762,
 443812895,
 67397,
 -58761,
 443878248,
 67396,
 -58760,
 443943628,
 67395,
 -58759,
 444008975,
 67394,
 -58758,
 444074292,
 67393,
 -1,
 444139669,
 67392,
 444340867,
 443222163,
 -1,
 -58755,
 444271786,
 67411,
 -58754,
 444336995,
 67410,
 -58753,
 444402374,
 67409,
 -58752,
 444467835,
 67408,
 -58751,
 444533218,
 67407,
 -58750,
 444598539,
 67406,
 -1,
 444663922,
 67405,
 -58748,
 444271284,
 67413,
 -1,
 444795387,
 67412,
 444996251,
 443157184,
 -1,
 445061777,
 444925955,
 -1,
 -58744,
 444993078,
 67241,
 -58743,
 445058487,
 67240,
 -58742,
 445123875,
 67239,
 -58741,
 445189266,
 67238,
 -58740,
 445254644,
 67237,
 -58739,
 445320009,
 67236,
 -58738,
 445385380,
 67235,
 -58737,
 445450731,
 67234,
 -58736,
 445516067,
 67233,
 -1,
 445581435,
 67232,
 445841407,
 444991635,
 -1,
 -58733,
 445713847,
 67250,
 -58732,
 445779235,
 67249,
 -58731,
 445844626,
 67248,
 -58730,
 445910004,
 67247,
 -58729,
 445975369,
 67246,
 -58728,
 446040740,
 67245,
 -58727,
 446106091,
 67244,
 -58726,
 446171427,
 67243,
 -1,
 446236795,
 67242,
 446438052,
 444927421,
 -1,
 -58723,
 446368926,
 67431,
 -58722,
 446434310,
 67430,
 -58721,
 446499676,
 67429,
 -58720,
 446565056,
 67428,
 -58719,
 446630407,
 67427,
 -58718,
 446695727,
 67426,
 -58717,
 446761107,
 67425,
 -1,
 446826499,
 67424,
 447027880,
 446367891,
 -1,
 -58714,
 446958256,
 67151,
 -58713,
 447023601,
 67146,
 -1,
 447088769,
 67143,
 -1,
 446957704,
 67099,
 447414271,
 421265408,
 -1,
 447421100,
 447311914,
 983068,
 -1,
 447349820,
 983142,
 -1,
 447360467,
 983062,
 447676415,
 421216425,
 -1,
 -58705,
 447555526,
 128391,
 -1,
 447612051,
 128279,
 447814344,
 421146865,
 -1,
 447879879,
 447756154,
 -1,
 447945413,
 447807488,
 -1,
 448010938,
 447884587,
 -1,
 448076471,
 447961336,
 -1,
 -58698,
 448032273,
 128964,
 -1,
 448078137,
 11212,
 448331775,
 448020229,
 -1,
 -58695,
 448228752,
 128943,
 -1,
 448290060,
 128969,
 448469693,
 447967137,
 -1,
 -58692,
 448429556,
 128978,
 -1,
 448477006,
 128960,
 448666304,
 448423919,
 -1,
 -58689,
 448610207,
 128949,
 -1,
 448663972,
 128937,
 -58687,
 448626368,
 128910,
 -58686,
 448815232,
 128648,
 -58685,
 448869147,
 128930,
 -58684,
 448932018,
 128955,
 -1,
 448994404,
 128504,
 449249279,
 447893777,
 128498,
 -1,
 449118477,
 128497,
 -1,
 447812991,
 128626,
 449387210,
 447766080,
 128482,
 -1,
 449344058,
 128132,
 449518285,
 449334241,
 -1,
 -58676,
 449475521,
 6430,
 -1,
 449524599,
 6429,
 -1,
 449467676,
 129409,
 449780614,
 421072457,
 -1,
 449846128,
 449737384,
 -1,
 449911625,
 449800175,
 -1,
 449977152,
 449858383,
 -1,
 450042590,
 449931247,
 -1,
 450108123,
 449976907,
 -1,
 450173656,
 450061793,
 -1,
 450239191,
 450125806,
 43851,
 -1,
 450168569,
 43852,
 -1,
 450179331,
 43830,
 450494463,
 450115535,
 -1,
 -58662,
 450376469,
 983617,
 -1,
 450432943,
 983618,
 -58660,
 450065119,
 43845,
 -58659,
 450564390,
 43872,
 -1,
 450627236,
 42921,
 450829034,
 449975837,
 -1,
 450894563,
 450773789,
 -1,
 450960098,
 450843409,
 43837,
 -1,
 450889513,
 43838,
 -1,
 450897541,
 43826,
 451156712,
 450825801,
 -1,
 451222247,
 451110737,
 -1,
 -58650,
 451159685,
 43827,
 -1,
 451219836,
 43824,
 -1,
 451176757,
 43853,
 -58647,
 451095504,
 42933,
 -1,
 451413592,
 42903,
 451615477,
 450786564,
 -1,
 451681009,
 451564305,
 -1,
 451746543,
 451618487,
 -1,
 -58642,
 451702465,
 43841,
 -1,
 451753710,
 43842,
 452001791,
 451674939,
 43843,
 -1,
 451872553,
 43844,
 452074228,
 451639982,
 -1,
 -58637,
 452014869,
 983615,
 -1,
 452071343,
 983616,
 -1,
 452032384,
 43857,
 452336381,
 451573178,
 -1,
 452401915,
 452263936,
 -1,
 452467450,
 452362032,
 -1,
 -58631,
 452422374,
 43854,
 -1,
 452478270,
 43858,
 -1,
 452400796,
 43855,
 -58628,
 452350737,
 43875,
 -1,
 452671464,
 43856,
 452860677,
 452285201,
 -1,
 452926212,
 452811743,
 -1,
 452991747,
 452855138,
 -1,
 -58623,
 452947649,
 43839,
 -58622,
 452997909,
 983613,
 -1,
 453054383,
 983614,
 -1,
 452929157,
 43874,
 -1,
 452873382,
 42935,
 453384972,
 452805274,
 -1,
 453450507,
 453313890,
 -1,
 -58616,
 453403388,
 42894,
 -58615,
 453463388,
 43833,
 -58614,
 453524834,
 43831,
 -1,
 453584068,
 43832,
 -1,
 453388749,
 43829,
 453843732,
 453319243,
 -1,
 453909265,
 453785051,
 43859,
 454033407,
 453838489,
 -1,
 -58608,
 453927981,
 43860,
 -1,
 453985660,
 43861,
 454230015,
 453838178,
 -1,
 -58605,
 454122198,
 42900,
 -1,
 454170264,
 42899,
 454368026,
 453804382,
 -1,
 454433561,
 454316153,
 43863,
 454557695,
 454361088,
 -1,
 -58600,
 454459304,
 43865,
 -1,
 454496804,
 43864,
 -1,
 454393073,
 43862,
 454761246,
 454327448,
 -1,
 -58596,
 454719294,
 42911,
 -58595,
 454775738,
 42909,
 -1,
 454823897,
 42907,
 455023395,
 454713357,
 -1,
 455088930,
 454950912,
 -1,
 -58591,
 455037771,
 42919,
 -1,
 455090290,
 43849,
 -1,
 455039308,
 43847,
 455351079,
 454971194,
 -1,
 -58587,
 455299915,
 42917,
 -58586,
 455353063,
 42897,
 -1,
 455417970,
 43835,
 455613228,
 455292904,
 -1,
 455678763,
 455561974,
 -1,
 -58582,
 455627706,
 43840,
 -1,
 455676284,
 43876,
 -1,
 455628782,
 43873,
 455940913,
 455553916,
 -1,
 456006448,
 455890520,
 -1,
 -58577,
 455947029,
 983619,
 -1,
 456003503,
 983620,
 -1,
 455935684,
 42901,
 456268596,
 455880945,
 -1,
 -58573,
 456209290,
 983199,
 -1,
 456263332,
 42913,
 456465207,
 456205957,
 -1,
 -58570,
 456413317,
 43836,
 -1,
 456459864,
 43828,
 456661817,
 456402136,
 43848,
 -1,
 456590794,
 43850,
 456792892,
 456592969,
 -1,
 -58565,
 456730303,
 983612,
 -1,
 456786955,
 43825,
 -58563,
 456753675,
 43866,
 -58562,
 456936132,
 43834,
 -58561,
 456999137,
 42915,
 -1,
 457059649,
 42905,
 457310207,
 449935059,
 -1,
 -58558,
 457207713,
 8348,
 -58557,
 457271279,
 8347,
 -58556,
 457333374,
 8346,
 -58555,
 457395973,
 8345,
 -58554,
 457460367,
 8344,
 -58553,
 457523866,
 8343,
 -58552,
 457588905,
 8342,
 -1,
 457651068,
 8341,
 457841514,
 449845985,
 -1,
 457907022,
 457800856,
 -1,
 -58548,
 457865022,
 42910,
 -58547,
 457921466,
 42908,
 -1,
 457969625,
 42906,
 458169170,
 457864452,
 -1,
 -58544,
 458125217,
 42929,
 -58543,
 458178729,
 42928,
 -1,
 458240892,
 42893,
 458431317,
 458123247,
 -1,
 -58540,
 458367007,
 42924,
 -1,
 458426020,
 42920,
 458627928,
 458383342,
 -1,
 -58537,
 458566847,
 42923,
 -1,
 458622628,
 42918,
 458824539,
 458575674,
 -1,
 -58534,
 458773323,
 42916,
 -1,
 458826471,
 42896,
 459021150,
 458764529,
 -1,
 -58531,
 458961802,
 983198,
 -1,
 459015844,
 42912,
 459217761,
 458955339,
 -1,
 -58528,
 459159003,
 42931,
 -1,
 459212137,
 42898,
 459414372,
 459150877,
 -1,
 -58525,
 459353040,
 42932,
 -1,
 459408984,
 42902,
 -58523,
 459363574,
 42934,
 -58522,
 459555484,
 42925,
 -58521,
 459620577,
 42914,
 -58520,
 459685879,
 42930,
 -58519,
 459748222,
 42922,
 -1,
 459812161,
 42904,
 460004207,
 457787154,
 -1,
 460069742,
 459950899,
 -1,
 -58515,
 460027185,
 43002,
 -1,
 460087316,
 43846,
 -1,
 460012773,
 42895,
 -1,
 459942490,
 42999,
 460397433,
 449794851,
 -1,
 460462964,
 460341700,
 -1,
 -58509,
 460411655,
 3807,
 -1,
 460468944,
 3806,
 460659575,
 460402500,
 -1,
 -58506,
 460608789,
 983204,
 -1,
 460658169,
 983205,
 -58504,
 460613264,
 983206,
 -1,
 460802342,
 983207,
 460987265,
 460349422,
 -1,
 461052800,
 460927382,
 -1,
 461118334,
 460986597,
 -1,
 -58499,
 461054816,
 128311,
 -1,
 461118700,
 128309,
 -58497,
 461070900,
 128308,
 -1,
 461264706,
 128310,
 -1,
 460994586,
 8382,
 461511556,
 460942838,
 -1,
 -58493,
 461471558,
 127772,
 -1,
 461533042,
 127767,
 -58491,
 461448822,
 128030,
 -1,
 461641518,
 127991,
 461839312,
 449717893,
 -1,
 461904843,
 461779126,
 -1,
 461970364,
 461864262,
 -1,
 462035873,
 461926305,
 -1,
 462101407,
 461988711,
 -1,
 462166942,
 462030734,
 -1,
 462232476,
 462099484,
 11104,
 462356479,
 462159872,
 -1,
 462363546,
 462257968,
 -1,
 462429074,
 462309718,
 -1,
 -58479,
 462387540,
 11172,
 -1,
 462431636,
 11174,
 462625685,
 462365777,
 -1,
 -58476,
 462584715,
 983233,
 -1,
 462632686,
 11130,
 -58474,
 462584765,
 129072,
 -58473,
 462770052,
 129056,
 -58472,
 462834769,
 129060,
 -58471,
 462894438,
 129068,
 -1,
 462952740,
 129064,
 -58469,
 462320381,
 11120,
 -1,
 463100370,
 11136,
 -58467,
 462183103,
 11140,
 -1,
 463217253,
 11114,
 -1,
 462094510,
 129168,
 -58464,
 462061704,
 11244,
 -1,
 463427230,
 129186,
 463608745,
 461968437,
 -1,
 463674277,
 463563851,
 -1,
 -58460,
 463631381,
 129024,
 -1,
 463678093,
 129040,
 -58458,
 463622618,
 129176,
 -58457,
 463817836,
 129028,
 -58456,
 463881123,
 129032,
 -1,
 463940237,
 129044,
 464133037,
 463541789,
 -1,
 -58453,
 464082989,
 129184,
 -58452,
 464143085,
 11144,
 -1,
 464195419,
 129192,
 464395184,
 464087023,
 -1,
 -58449,
 464346963,
 129080,
 -1,
 464392913,
 129104,
 464591795,
 464347118,
 -1,
 -58446,
 464540540,
 128620,
 -1,
 464599531,
 129190,
 464788406,
 464532814,
 -1,
 -58443,
 464723612,
 129088,
 -1,
 464786460,
 129092,
 464985017,
 464727339,
 -1,
 -58440,
 464938707,
 129194,
 -1,
 464993461,
 129076,
 -58438,
 464944747,
 129172,
 -58437,
 465126879,
 129188,
 -1,
 465182364,
 129084,
 465378246,
 461897728,
 -1,
 465443776,
 465331106,
 -1,
 -58433,
 465400923,
 11108,
 -1,
 465463454,
 129112,
 -58431,
 465404198,
 128398,
 -58430,
 465596803,
 128492,
 -58429,
 465661267,
 128488,
 -58428,
 465717868,
 128709,
 -58427,
 465777736,
 128379,
 -1,
 465834622,
 128494,
 466092031,
 465307498,
 -1,
 -58424,
 465990420,
 8294,
 -58423,
 466050365,
 128269,
 -58422,
 466105473,
 9958,
 -1,
 466169186,
 1422,
 -58420,
 461863696,
 127898,
 -58419,
 466310836,
 128006,
 -58418,
 466374234,
 127819,
 -58417,
 466428703,
 128210,
 -1,
 466489387,
 127811,
 466688998,
 461787921,
 -1,
 466754524,
 466648294,
 -1,
 466820059,
 466692774,
 -1,
 466885594,
 466765059,
 -1,
 466951127,
 466836094,
 -1,
 -58410,
 466889108,
 128393,
 -1,
 466948282,
 128396,
 -58408,
 466890672,
 128395,
 -58407,
 467083221,
 128397,
 -1,
 467146378,
 128394,
 -1,
 466838617,
 128318,
 -1,
 466747642,
 128261,
 467475425,
 466689411,
 128274,
 467540960,
 467418271,
 -1,
 -58401,
 467502006,
 983079,
 -1,
 467555690,
 983076,
 -1,
 467469951,
 128271,
 467803108,
 467434207,
 -1,
 -58397,
 467748560,
 128140,
 -1,
 467810060,
 127977,
 -58395,
 467760941,
 128557,
 -1,
 467945732,
 127853,
 468130795,
 466640878,
 -1,
 -58392,
 468079377,
 983221,
 -58391,
 468142735,
 983216,
 -58390,
 468203496,
 983226,
 -1,
 468264581,
 983218,
 -1,
 468069675,
 983065,
 468524703,
 421031841,
 -1,
 468589987,
 468454985,
 -1,
 468655426,
 468536773,
 -1,
 468720937,
 468610884,
 -1,
 468786225,
 468668165,
 -1,
 468851723,
 468733701,
 -1,
 468917247,
 468799237,
 -1,
 468982775,
 468848201,
 -1,
 -58379,
 468940218,
 983852,
 -58378,
 468989928,
 983849,
 -1,
 469044809,
 983842,
 469244921,
 468940218,
 983845,
 -1,
 469202362,
 983846,
 469375995,
 469193489,
 983850,
 -1,
 469324561,
 983851,
 469507069,
 469317608,
 983843,
 -1,
 469448680,
 983844,
 469696511,
 469444229,
 983847,
 -1,
 469575301,
 983848,
 469769219,
 468848201,
 -1,
 -58367,
 469726650,
 983720,
 -58366,
 469776360,
 983717,
 -1,
 469831241,
 983710,
 470031365,
 469726650,
 983713,
 -1,
 469988794,
 983714,
 470162439,
 469979921,
 983718,
 -1,
 470110993,
 983719,
 470293513,
 470104040,
 983711,
 -1,
 470235112,
 983712,
 470482943,
 470230661,
 983715,
 -1,
 470361733,
 983716,
 470555672,
 468812246,
 -1,
 470621200,
 470486601,
 -1,
 -58354,
 470578618,
 983698,
 -58353,
 470628328,
 983695,
 -1,
 470683209,
 983688,
 470883346,
 470578618,
 983691,
 -1,
 470840762,
 983692,
 471014420,
 470831889,
 983696,
 -1,
 470962961,
 983697,
 471145494,
 470956008,
 983689,
 -1,
 471087080,
 983690,
 471334911,
 471082629,
 983693,
 -1,
 471213701,
 983694,
 471407653,
 470495473,
 -1,
 471473181,
 471338569,
 -1,
 -58341,
 471430586,
 983676,
 -58340,
 471480296,
 983673,
 -1,
 471535177,
 983666,
 471735327,
 471430586,
 983669,
 -1,
 471692730,
 983670,
 471866401,
 471683857,
 983674,
 -1,
 471814929,
 983675,
 471997475,
 471807976,
 983667,
 -1,
 471939048,
 983668,
 472186879,
 471934597,
 983671,
 -1,
 472065669,
 983672,
 472259625,
 471338569,
 -1,
 -58329,
 472217018,
 983742,
 -58328,
 472266728,
 983739,
 -1,
 472321609,
 983732,
 472521771,
 472217018,
 983735,
 -1,
 472479162,
 983736,
 472652845,
 472470289,
 983740,
 -1,
 472601361,
 983741,
 472783919,
 472594408,
 983733,
 -1,
 472725480,
 983734,
 472973311,
 472721029,
 983737,
 -1,
 472852101,
 983738,
 473046105,
 468740079,
 -1,
 473111616,
 472986492,
 -1,
 473177143,
 473042505,
 -1,
 -58315,
 473134522,
 983874,
 -58314,
 473184232,
 983871,
 -1,
 473239113,
 983864,
 473439289,
 473134522,
 983867,
 -1,
 473396666,
 983868,
 473570363,
 473387793,
 983872,
 -1,
 473518865,
 983873,
 473701437,
 473511912,
 983865,
 -1,
 473642984,
 983866,
 473832511,
 473638533,
 983869,
 -1,
 473769605,
 983870,
 -1,
 473785685,
 983920,
 474029133,
 473065455,
 -1,
 474094661,
 473960009,
 -1,
 -58301,
 474052026,
 983885,
 -58300,
 474101736,
 983882,
 -1,
 474156617,
 983875,
 474356807,
 474052026,
 983878,
 -1,
 474314170,
 983879,
 474487881,
 474305297,
 983883,
 -1,
 474436369,
 983884,
 474618955,
 474429416,
 983876,
 -1,
 474560488,
 983877,
 474808319,
 474556037,
 983880,
 -1,
 474687109,
 983881,
 474881105,
 473960009,
 -1,
 -58289,
 474838458,
 983896,
 -58288,
 474888168,
 983893,
 -1,
 474943049,
 983886,
 475143251,
 474838458,
 983889,
 -1,
 475100602,
 983890,
 475274325,
 475091729,
 983894,
 -1,
 475222801,
 983895,
 475405399,
 475215848,
 983887,
 -1,
 475346920,
 983888,
 475594751,
 475342469,
 983891,
 -1,
 475473541,
 983892,
 475667584,
 472990362,
 -1,
 475733108,
 475611802,
 -1,
 475798632,
 475677338,
 -1,
 475864160,
 475729481,
 -1,
 -58274,
 475821498,
 983819,
 -58273,
 475871208,
 983816,
 -1,
 475926089,
 983809,
 476126306,
 475821498,
 983812,
 -1,
 476083642,
 983813,
 476257380,
 476074769,
 983817,
 -1,
 476205841,
 983818,
 476388454,
 476198888,
 983810,
 -1,
 476329960,
 983811,
 476577791,
 476325509,
 983814,
 -1,
 476456581,
 983815,
 476650604,
 475729481,
 -1,
 -58262,
 476607930,
 983830,
 -58261,
 476657640,
 983827,
 -1,
 476712521,
 983820,
 476912750,
 476607930,
 983823,
 -1,
 476870074,
 983824,
 477043824,
 476861201,
 983828,
 -1,
 476992273,
 983829,
 477174898,
 476985320,
 983821,
 -1,
 477116392,
 983822,
 477364223,
 477111941,
 983825,
 -1,
 477243013,
 983826,
 477437048,
 475663945,
 -1,
 -58250,
 477394362,
 983797,
 -58249,
 477444072,
 983794,
 -1,
 477498953,
 983787,
 477699194,
 477394362,
 983790,
 -1,
 477656506,
 983791,
 477830268,
 477647633,
 983795,
 -1,
 477778705,
 983796,
 477961342,
 477771752,
 983788,
 -1,
 477902824,
 983789,
 478150655,
 477898373,
 983792,
 -1,
 478029445,
 983793,
 478223514,
 475611305,
 -1,
 478289038,
 478178750,
 -1,
 478354566,
 478219849,
 983908,
 -58236,
 478311866,
 983919,
 -58235,
 478361576,
 983916,
 -1,
 478416457,
 983909,
 478616712,
 478311866,
 983912,
 -1,
 478574010,
 983913,
 478747786,
 478565137,
 983917,
 -1,
 478696209,
 983918,
 478878860,
 478689256,
 983910,
 -1,
 478820328,
 983911,
 479068159,
 478815877,
 983914,
 -1,
 478946949,
 983915,
 479141010,
 478219849,
 -1,
 -58224,
 479098298,
 983665,
 -58223,
 479148008,
 983662,
 -1,
 479202889,
 983655,
 479403156,
 479098298,
 983658,
 -1,
 479360442,
 983659,
 479534230,
 479351569,
 983663,
 -1,
 479482641,
 983664,
 479665304,
 479475688,
 983656,
 -1,
 479606760,
 983657,
 479854591,
 479602309,
 983660,
 -1,
 479733381,
 983661,
 479927476,
 478179233,
 -1,
 479993000,
 479883169,
 -1,
 480058528,
 479923785,
 -1,
 -58210,
 480015802,
 983709,
 -58209,
 480065512,
 983706,
 -1,
 480120393,
 983699,
 480320674,
 480015802,
 983702,
 -1,
 480277946,
 983703,
 480451748,
 480269073,
 983707,
 -1,
 480400145,
 983708,
 480582822,
 480393192,
 983700,
 -1,
 480524264,
 983701,
 480772095,
 480519813,
 983704,
 -1,
 480650885,
 983705,
 480844972,
 479923785,
 -1,
 -58198,
 480802234,
 983731,
 -58197,
 480851944,
 983728,
 -1,
 480906825,
 983721,
 481107118,
 480802234,
 983724,
 -1,
 481064378,
 983725,
 481238192,
 481055505,
 983729,
 -1,
 481186577,
 983730,
 481369266,
 481179624,
 983722,
 -1,
 481310696,
 983723,
 481558527,
 481306245,
 983726,
 -1,
 481437317,
 983727,
 481631438,
 479879150,
 -1,
 481696962,
 481583086,
 -1,
 481762490,
 481627721,
 -1,
 -58184,
 481719738,
 983841,
 -58183,
 481769448,
 983838,
 -1,
 481824329,
 983831,
 482024636,
 481719738,
 983834,
 -1,
 481981882,
 983835,
 482155710,
 481973009,
 983839,
 -1,
 482104081,
 983840,
 482286784,
 482097128,
 983832,
 -1,
 482228200,
 983833,
 482476031,
 482223749,
 983836,
 -1,
 482354821,
 983837,
 482548934,
 481627721,
 -1,
 -58172,
 482506170,
 983786,
 -58171,
 482555880,
 983783,
 -1,
 482610761,
 983776,
 482811080,
 482506170,
 983779,
 -1,
 482768314,
 983780,
 482942154,
 482759441,
 983784,
 -1,
 482890513,
 983785,
 483073228,
 482883560,
 983777,
 -1,
 483014632,
 983778,
 483262463,
 483010181,
 983781,
 -1,
 483141253,
 983782,
 483335387,
 481591766,
 -1,
 483400915,
 483266121,
 -1,
 -58159,
 483358138,
 983775,
 -58158,
 483407848,
 983772,
 -1,
 483462729,
 983765,
 483663061,
 483358138,
 983768,
 -1,
 483620282,
 983769,
 483794135,
 483611409,
 983773,
 -1,
 483742481,
 983774,
 483925209,
 483735528,
 983766,
 -1,
 483866600,
 983767,
 484114431,
 483862149,
 983770,
 -1,
 483993221,
 983771,
 484187368,
 483293868,
 -1,
 484252896,
 484118089,
 -1,
 -58146,
 484210106,
 983808,
 -58145,
 484259816,
 983805,
 -1,
 484314697,
 983798,
 484515042,
 484210106,
 983801,
 -1,
 484472250,
 983802,
 484646116,
 484463377,
 983806,
 -1,
 484594449,
 983807,
 484777190,
 484587496,
 983799,
 -1,
 484718568,
 983800,
 484966399,
 484714117,
 983803,
 -1,
 484845189,
 983804,
 485039349,
 484137598,
 -1,
 485104877,
 484970057,
 -1,
 -58133,
 485062074,
 983753,
 -58132,
 485111784,
 983750,
 -1,
 485166665,
 983743,
 485367023,
 485062074,
 983746,
 -1,
 485324218,
 983747,
 485498097,
 485315345,
 983751,
 -1,
 485446417,
 983752,
 485629171,
 485439464,
 983744,
 -1,
 485570536,
 983745,
 485818367,
 485566085,
 983748,
 -1,
 485697157,
 983749,
 485891330,
 484985487,
 -1,
 485956858,
 485822025,
 -1,
 -58120,
 485914042,
 983764,
 -58119,
 485963752,
 983761,
 -1,
 486018633,
 983754,
 486219004,
 485914042,
 983757,
 -1,
 486176186,
 983758,
 486350078,
 486167313,
 983762,
 -1,
 486298385,
 983763,
 486481152,
 486291432,
 983755,
 -1,
 486422504,
 983756,
 486670335,
 486418053,
 983759,
 -1,
 486549125,
 983760,
 486743311,
 485834741,
 -1,
 486808839,
 486673993,
 -1,
 -58107,
 486766010,
 983863,
 -58106,
 486815720,
 983860,
 -1,
 486870601,
 983853,
 487070985,
 486766010,
 983856,
 -1,
 487028154,
 983857,
 487202059,
 487019281,
 983861,
 -1,
 487150353,
 983862,
 487333133,
 487143400,
 983854,
 -1,
 487274472,
 983855,
 487522303,
 487270021,
 983858,
 -1,
 487401093,
 983859,
 487595292,
 486683516,
 -1,
 487660820,
 487525961,
 -1,
 -58094,
 487617978,
 983907,
 -58093,
 487667688,
 983904,
 -1,
 487722569,
 983897,
 487922966,
 487617978,
 983900,
 -1,
 487880122,
 983901,
 488054040,
 487871249,
 983905,
 -1,
 488002321,
 983906,
 488185114,
 487995368,
 983898,
 -1,
 488126440,
 983899,
 488374271,
 488121989,
 983902,
 -1,
 488253061,
 983903,
 488505343,
 487529035,
 -1,
 488512801,
 488377929,
 -1,
 -58081,
 488469946,
 983687,
 -58080,
 488519656,
 983684,
 -1,
 488574537,
 983677,
 488774947,
 488469946,
 983680,
 -1,
 488732090,
 983681,
 488906021,
 488723217,
 983685,
 -1,
 488854289,
 983686,
 489037095,
 488847336,
 983678,
 -1,
 488978408,
 983679,
 489226239,
 488973957,
 983682,
 -1,
 489105029,
 983683,
 489357311,
 468655808,
 -1,
 489364783,
 489246469,
 983638,
 489430317,
 489312005,
 983636,
 -1,
 489377541,
 983648,
 -58066,
 489390550,
 983634,
 -1,
 489500913,
 983632,
 489692466,
 489318383,
 983652,
 -58063,
 489646063,
 983651,
 -1,
 489698172,
 983650,
 489889077,
 489636506,
 983643,
 490012671,
 489833114,
 983646,
 -1,
 489898650,
 983645,
 490085687,
 489844641,
 983637,
 -1,
 490041249,
 983635,
 490216761,
 490037230,
 983642,
 -1,
 490168302,
 983647,
 490347835,
 490160297,
 983631,
 -1,
 490302910,
 983654,
 -58052,
 490308054,
 983641,
 -58051,
 490437292,
 983644,
 -58050,
 490494590,
 983639,
 -58049,
 490556047,
 983640,
 -58048,
 490618869,
 983649,
 -58047,
 490681212,
 983653,
 -1,
 490740299,
 983633,
 490937755,
 468599365,
 -1,
 491003260,
 490882775,
 -1,
 491068746,
 490958753,
 -1,
 491134280,
 491024289,
 -1,
 -58041,
 491074442,
 71317,
 -1,
 491130441,
 71316,
 -58039,
 491074442,
 71322,
 -1,
 491261513,
 71321,
 491461967,
 491015941,
 -1,
 -58036,
 491422242,
 71315,
 -58035,
 491474794,
 71320,
 -58034,
 491532567,
 71310,
 -1,
 491589193,
 71325,
 491789653,
 491397459,
 -1,
 491855187,
 491725139,
 -1,
 -58030,
 491795338,
 71319,
 -1,
 491851337,
 71318,
 -58028,
 491795338,
 71324,
 -1,
 491982409,
 71323,
 492182873,
 491720265,
 71296,
 -58025,
 492139962,
 71305,
 -58024,
 492189672,
 71303,
 -1,
 492244553,
 71297,
 492445019,
 492139962,
 71300,
 -1,
 492402106,
 71301,
 492576094,
 492398575,
 -1,
 -58019,
 492516234,
 71335,
 -1,
 492572233,
 71336,
 492772705,
 492527598,
 -1,
 -58016,
 492724284,
 71338,
 -1,
 492768841,
 71332,
 492969316,
 492722814,
 -1,
 -58013,
 492909450,
 71327,
 -1,
 492965449,
 71326,
 493165927,
 492912809,
 -1,
 -58010,
 493106058,
 71307,
 -1,
 493162057,
 71306,
 493362538,
 493109237,
 -1,
 -58007,
 493302666,
 71314,
 -1,
 493358665,
 71313,
 493559148,
 493303784,
 71298,
 -1,
 493500392,
 71299,
 493690223,
 493498609,
 -1,
 -58002,
 493630346,
 71309,
 -1,
 493686345,
 71308,
 493886834,
 493623883,
 -1,
 -57999,
 493826954,
 71312,
 -1,
 493882953,
 71311,
 494083445,
 493819421,
 -1,
 -57996,
 494023562,
 71329,
 -1,
 494079561,
 71328,
 -57994,
 494043682,
 71331,
 -57993,
 494238390,
 71334,
 -57992,
 494293777,
 71304,
 -57991,
 494357208,
 71330,
 -57990,
 494420692,
 71333,
 -57989,
 494482314,
 71337,
 -1,
 494544517,
 71302,
 494738826,
 490939268,
 -1,
 494804352,
 494694305,
 -1,
 -57985,
 494764104,
 71362,
 -1,
 494810920,
 71363,
 495000963,
 494757871,
 -1,
 -57982,
 494944145,
 71366,
 -1,
 495004795,
 71367,
 495197574,
 494939435,
 -1,
 -57979,
 495147205,
 71364,
 -1,
 495206145,
 71365,
 -57977,
 495158198,
 71360,
 -57976,
 495342954,
 71361,
 -57975,
 495407316,
 71369,
 -1,
 495462555,
 71368,
 495656341,
 494697675,
 -1,
 495721871,
 495586889,
 -1,
 -57971,
 495678906,
 71349,
 -57970,
 495728616,
 71347,
 -1,
 495783497,
 71341,
 495984017,
 495678906,
 71344,
 -1,
 495941050,
 71345,
 496115091,
 495925224,
 71342,
 -1,
 496056296,
 71343,
 -57964,
 496063249,
 71348,
 -1,
 496182917,
 71346,
 496435199,
 495610726,
 -1,
 496442777,
 496335900,
 -1,
 -57960,
 496396479,
 71340,
 -1,
 496460037,
 71350,
 -57958,
 496390827,
 71351,
 -1,
 496571152,
 71339,
 496770462,
 490884869,
 -1,
 -57955,
 496710111,
 127818,
 -1,
 496766642,
 127883,
 496967072,
 496703005,
 983061,
 -1,
 496911491,
 127955,
 -57951,
 496927126,
 128661,
 -57950,
 497048493,
 128429,
 -1,
 497098272,
 127790,
 497294889,
 468531176,
 -1,
 497360404,
 497246190,
 -1,
 497425939,
 497301444,
 -1,
 497491428,
 497370839,
 -1,
 497556910,
 497449644,
 -1,
 497622445,
 497505114,
 -1,
 497687979,
 497573870,
 70791,
 -1,
 497639406,
 70792,
 497876991,
 497631898,
 70793,
 -1,
 497762970,
 70794,
 -1,
 497552969,
 70827,
 498015668,
 497512353,
 -1,
 498081202,
 497971105,
 -1,
 -57935,
 498021258,
 70810,
 -1,
 498077257,
 70809,
 -57933,
 498021258,
 70815,
 -1,
 498208329,
 70814,
 498408889,
 497962757,
 -1,
 -57930,
 498369058,
 70808,
 -57929,
 498421610,
 70813,
 -57928,
 498479383,
 70803,
 -1,
 498536009,
 70818,
 498736575,
 498344275,
 -1,
 498802109,
 498671955,
 -1,
 -57924,
 498742154,
 70812,
 -1,
 498798153,
 70811,
 -57922,
 498742154,
 70817,
 -1,
 498929225,
 70816,
 499129795,
 498667081,
 70785,
 -57919,
 499086778,
 70798,
 -57918,
 499136488,
 70796,
 -1,
 499191369,
 70786,
 499391943,
 499083247,
 -1,
 -57915,
 499345484,
 70829,
 -57914,
 499397514,
 70828,
 -1,
 499453513,
 70830,
 499654089,
 499348922,
 70789,
 -1,
 499611066,
 70790,
 499785164,
 499604094,
 -1,
 -57909,
 499725194,
 70820,
 -1,
 499781193,
 70819,
 499981775,
 499728553,
 -1,
 -57906,
 499921802,
 70800,
 -1,
 499977801,
 70799,
 500178386,
 499924981,
 -1,
 -57903,
 500118410,
 70807,
 -1,
 500174409,
 70806,
 500374996,
 500119528,
 70787,
 -1,
 500316136,
 70788,
 500506071,
 500314353,
 -1,
 -57898,
 500446090,
 70802,
 -1,
 500502089,
 70801,
 500702682,
 500439627,
 -1,
 -57895,
 500642698,
 70805,
 -1,
 500698697,
 70804,
 500899293,
 500635165,
 -1,
 -57892,
 500839306,
 70822,
 -1,
 500895305,
 70821,
 -57890,
 500859426,
 70824,
 -57889,
 501047356,
 70825,
 -57888,
 501109521,
 70797,
 -57887,
 501172952,
 70823,
 -57886,
 501236436,
 70826,
 -57885,
 501298058,
 70831,
 -1,
 501360261,
 70795,
 501554679,
 497450187,
 -1,
 501620202,
 501513323,
 -1,
 501685736,
 501571566,
 70837,
 -1,
 501637102,
 70838,
 501874687,
 501629594,
 70839,
 -1,
 501760666,
 70840,
 501947886,
 501550665,
 -1,
 -57876,
 501904826,
 70846,
 -57875,
 501954536,
 70843,
 -1,
 502009417,
 70832,
 502210032,
 501904826,
 70835,
 -1,
 502166970,
 70836,
 502341107,
 502164182,
 -1,
 -57870,
 502289169,
 70845,
 -1,
 502343301,
 70842,
 502537717,
 502282216,
 70833,
 -1,
 502478824,
 70834,
 -57866,
 502485777,
 70844,
 -1,
 502605445,
 70841,
 502799877,
 501490564,
 -1,
 502865403,
 502755233,
 -1,
 -57862,
 502825032,
 70866,
 -1,
 502871848,
 70867,
 503062014,
 502818799,
 -1,
 -57859,
 503005073,
 70870,
 -1,
 503065723,
 70871,
 503258625,
 503000363,
 -1,
 -57856,
 503208133,
 70868,
 -1,
 503267073,
 70869,
 -57854,
 503219126,
 70864,
 -57853,
 503403882,
 70865,
 -57852,
 503468244,
 70873,
 -1,
 503523483,
 70872,
 503717390,
 502754150,
 -1,
 503782921,
 503675932,
 -1,
 -57848,
 503736511,
 70849,
 -1,
 503800069,
 70850,
 503979532,
 503713353,
 -1,
 -57845,
 503937721,
 70852,
 -1,
 503993070,
 70848,
 -57843,
 503927467,
 70851,
 -1,
 504109768,
 70847,
 504307217,
 503647817,
 -1,
 -57840,
 504254766,
 70784,
 -1,
 504305385,
 70854,
 -57838,
 504255663,
 70855,
 -1,
 504443758,
 70853,
 -1,
 497362858,
 128555,
 504700447,
 497293154,
 -1,
 504765979,
 504653807,
 -1,
 504831514,
 504723069,
 -1,
 -57832,
 504777709,
 3982,
 -57831,
 504841258,
 3981,
 -1,
 504905074,
 3983,
 -1,
 504773171,
 3980,
 505217023,
 504712068,
 -1,
 -57827,
 505115607,
 4058,
 -57826,
 505169098,
 4057,
 -1,
 505223195,
 983208,
 505421349,
 504639023,
 -1,
 505486883,
 505366326,
 -1,
 -57822,
 505434897,
 11623,
 -1,
 505489029,
 11622,
 -57820,
 505440597,
 11632,
 -1,
 505618123,
 11647,
 505814567,
 505360859,
 128005,
 -1,
 505741791,
 128047,
 -57816,
 505761013,
 9202,
 -1,
 505879994,
 127915,
 506076743,
 497234812,
 -1,
 506142269,
 506028643,
 -1,
 506207797,
 506068992,
 -1,
 506273329,
 506159460,
 -1,
 -57810,
 506225564,
 128487,
 -57809,
 506283262,
 128486,
 -57808,
 506337074,
 128485,
 -1,
 506400506,
 128484,
 -57806,
 506228065,
 128491,
 -57805,
 506551564,
 128962,
 -57804,
 506613819,
 128423,
 -1,
 506665531,
 128433,
 506920959,
 506136426,
 -1,
 506928700,
 506798421,
 -1,
 506994234,
 506884952,
 -1,
 -57799,
 506946868,
 11162,
 -1,
 507004480,
 11160,
 -57797,
 506946698,
 11161,
 -1,
 507135387,
 11163,
 -1,
 506865969,
 11835,
 507387458,
 506084084,
 -1,
 507452993,
 507314176,
 -1,
 -57792,
 507406471,
 128936,
 -1,
 507458331,
 128929,
 -1,
 507396572,
 129300,
 507715141,
 507344859,
 -1,
 -57788,
 507672722,
 128077,
 -1,
 507716969,
 128078,
 -57786,
 507664549,
 128173,
 -1,
 507849483,
 127777,
 508042847,
 506033594,
 -1,
 508108382,
 507994094,
 -1,
 508173914,
 508055541,
 -1,
 508239439,
 508127215,
 -1,
 508304974,
 508189050,
 -1,
 -57779,
 508263998,
 128597,
 -1,
 508307260,
 128599,
 -1,
 508242252,
 11829,
 508567124,
 508174675,
 -1,
 508632659,
 508508711,
 -1,
 -57774,
 508592200,
 8586,
 -1,
 508639016,
 8587,
 -1,
 508563577,
 11832,
 508894807,
 508514751,
 -1,
 -57770,
 508853822,
 128596,
 -1,
 508897084,
 128598,
 -57768,
 508843072,
 128399,
 -57767,
 509025912,
 11826,
 -1,
 509089913,
 11202,
 509288029,
 508117161,
 -1,
 -57764,
 509230696,
 8378,
 -1,
 509291812,
 129411,
 -1,
 509244143,
 128034,
 -1,
 508053654,
 127799,
 509615734,
 507994094,
 -1,
 509681255,
 509546057,
 -1,
 509746787,
 509627023,
 128650,
 -1,
 509673798,
 128651,
 509877862,
 509680203,
 -1,
 -57755,
 509834085,
 128668,
 -1,
 509886835,
 128434,
 -1,
 509819636,
 128646,
 510140014,
 509629201,
 -1,
 510205549,
 510089854,
 -1,
 510271084,
 510146766,
 -1,
 -57749,
 510209679,
 128032,
 -1,
 510273059,
 127865,
 -1,
 510212062,
 127942,
 -1,
 510150893,
 128654,
 510598773,
 510081000,
 -1,
 510664308,
 510530154,
 -1,
 510729843,
 510621600,
 -1,
 -57742,
 510683096,
 128208,
 -1,
 510734029,
 128681,
 -1,
 510674098,
 128710,
 -1,
 510599864,
 128305,
 -1,
 510556129,
 127930,
 511123080,
 509552261,
 -1,
 511188612,
 511066778,
 -1,
 511254143,
 511125125,
 -1,
 511319677,
 511204429,
 -1,
 511385212,
 511271421,
 128222,
 -1,
 511313593,
 128380,
 -1,
 511333678,
 128384,
 -57730,
 511278166,
 128250,
 -1,
 511535325,
 128301,
 511770623,
 511211371,
 -1,
 511778435,
 511657687,
 -1,
 -57726,
 511731583,
 3162,
 -1,
 511789338,
 3124,
 -1,
 511732605,
 3072,
 512040583,
 511118921,
 -1,
 -57722,
 511991845,
 128198,
 -1,
 512041179,
 127861,
 -1,
 511988066,
 127934,
 512302740,
 511070993,
 -1,
 512368272,
 512252544,
 -1,
 512433807,
 512308106,
 -1,
 512499342,
 512378751,
 -1,
 -57715,
 512452880,
 11833,
 -1,
 512497721,
 11210,
 -1,
 512454561,
 127913,
 -1,
 512393156,
 128285,
 -57711,
 512315568,
 128069,
 -57710,
 512773042,
 127813,
 -57709,
 512836240,
 128508,
 -1,
 512899762,
 128701,
 513089182,
 512261350,
 -1,
 513154717,
 513037073,
 -1,
 513220252,
 513081344,
 -1,
 -57704,
 513179831,
 128109,
 -57703,
 513240417,
 128490,
 -57702,
 513297603,
 128108,
 -57701,
 513357127,
 128149,
 -1,
 513415739,
 128432,
 -1,
 513148805,
 11834,
 -1,
 513097374,
 128256,
 -1,
 513017844,
 128085,
 513810644,
 468474494,
 -1,
 513875944,
 513740361,
 -1,
 513941338,
 513815798,
 -1,
 514006743,
 513874507,
 -1,
 514072252,
 513955369,
 -1,
 514137772,
 514019077,
 -1,
 514203304,
 514092961,
 -1,
 -57689,
 514156741,
 92957,
 -1,
 514209006,
 92971,
 -57687,
 514147353,
 92960,
 -57686,
 514343279,
 92962,
 -57685,
 514399317,
 92968,
 -1,
 514463126,
 92972,
 514662064,
 514077564,
 -1,
 -57682,
 514609041,
 92969,
 -57681,
 514671641,
 92965,
 -1,
 514725270,
 92959,
 514924211,
 514595403,
 -1,
 -57678,
 514864366,
 92967,
 -1,
 514921878,
 92975,
 -57676,
 514884165,
 92964,
 -57675,
 515080565,
 92974,
 -57674,
 515144405,
 92956,
 -57673,
 515203412,
 92961,
 -57672,
 515268381,
 92963,
 -57671,
 515333314,
 92970,
 -57670,
 515394487,
 92966,
 -57669,
 515458073,
 92958,
 -1,
 515511702,
 92973,
 515768319,
 514016072,
 -1,
 515776195,
 515665825,
 -1,
 515841730,
 515729391,
 -1,
 -57664,
 515800528,
 93069,
 -57663,
 515847549,
 93053,
 -1,
 515903143,
 93062,
 -1,
 515782311,
 93061,
 516169415,
 515719337,
 -1,
 -57659,
 516128773,
 93070,
 -57658,
 516183623,
 93058,
 -1,
 516240283,
 93064,
 516431562,
 516129238,
 -1,
 -57655,
 516368377,
 93054,
 -1,
 516428015,
 93068,
 516628173,
 516389548,
 -1,
 -57652,
 516587522,
 93071,
 -1,
 516624623,
 93066,
 516824784,
 516571802,
 -1,
 -57649,
 516767325,
 93055,
 -1,
 516822448,
 93056,
 517021395,
 516764554,
 -1,
 -57646,
 516980738,
 93059,
 -1,
 517032591,
 93065,
 -57644,
 516981200,
 93057,
 -57643,
 517168188,
 93063,
 -57642,
 517230290,
 93060,
 -1,
 517287311,
 93067,
 517480202,
 513960806,
 -1,
 517545699,
 517414113,
 -1,
 517611229,
 517500833,
 -1,
 517676764,
 517571020,
 93044,
 -1,
 517603686,
 93045,
 -1,
 517631286,
 92997,
 517873376,
 517544523,
 -1,
 -57633,
 517830251,
 93043,
 -1,
 517879194,
 92985,
 -57631,
 517824081,
 93046,
 -57630,
 518017550,
 93047,
 -1,
 518075321,
 93042,
 518266605,
 517505350,
 -1,
 518332139,
 518226390,
 -1,
 518397674,
 518268934,
 -1,
 -57625,
 518353841,
 92990,
 -57624,
 518415187,
 92989,
 -57623,
 518476449,
 92988,
 -1,
 518532490,
 92991,
 -1,
 518346311,
 93028,
 -57620,
 518273129,
 93034,
 -1,
 518723000,
 92996,
 518921975,
 518225061,
 -1,
 518987507,
 518877089,
 -1,
 519053042,
 518927228,
 -1,
 -57615,
 519001263,
 92983,
 -1,
 519059561,
 92986,
 -1,
 519006720,
 92984,
 -57612,
 518940962,
 92992,
 -57611,
 519262743,
 92994,
 -57610,
 519326312,
 93027,
 -1,
 519384536,
 92987,
 519577339,
 518877089,
 -1,
 -57607,
 519537035,
 93037,
 -57606,
 519583335,
 93030,
 -1,
 519640470,
 93039,
 519839488,
 519522959,
 -1,
 519905023,
 519776253,
 -1,
 -57602,
 519861456,
 93038,
 -1,
 519925536,
 92993,
 -1,
 519862815,
 93041,
 520167171,
 519786245,
 -1,
 -57598,
 520123635,
 93035,
 -1,
 520183586,
 93033,
 520363782,
 520106876,
 -1,
 -57595,
 520311463,
 93032,
 -1,
 520374186,
 93029,
 -57593,
 520324067,
 93031,
 -57592,
 520505718,
 93040,
 -57591,
 520566972,
 92995,
 -1,
 520623559,
 93036,
 520822581,
 517438641,
 -1,
 520888090,
 520752713,
 -1,
 520953615,
 520846566,
 -1,
 -57586,
 520911532,
 92943,
 -1,
 520951325,
 92942,
 521150226,
 520910266,
 -1,
 -57583,
 521108140,
 92933,
 -1,
 521147933,
 92932,
 521346837,
 521091048,
 -1,
 -57580,
 521304748,
 92939,
 -1,
 521344541,
 92938,
 521543448,
 521277001,
 -1,
 -57577,
 521501356,
 92955,
 -1,
 521541149,
 92954,
 -57575,
 521501356,
 92951,
 -1,
 521672221,
 92950,
 521871136,
 520844730,
 -1,
 521936670,
 521801289,
 -1,
 -57571,
 521894572,
 92945,
 -1,
 521934365,
 92944,
 -57569,
 521894572,
 92935,
 -1,
 522065437,
 92934,
 522264358,
 521818897,
 -1,
 522329892,
 522212113,
 -1,
 -57565,
 522287788,
 92941,
 -1,
 522327581,
 92940,
 -57563,
 522287788,
 92947,
 -1,
 522458653,
 92946,
 522657580,
 522205160,
 -1,
 522723114,
 522587721,
 -1,
 -57559,
 522681004,
 92949,
 -1,
 522720797,
 92948,
 -57557,
 522681004,
 92931,
 -1,
 522851869,
 92930,
 523050802,
 522593925,
 -1,
 523116336,
 522987141,
 -1,
 -57553,
 523074220,
 92929,
 -1,
 523114013,
 92928,
 -57551,
 523074220,
 92937,
 -1,
 523245085,
 92936,
 523501567,
 523009254,
 -1,
 -57548,
 523401900,
 92953,
 -1,
 523441693,
 92952,
 523640643,
 520758148,
 -1,
 523706169,
 523595681,
 -1,
 -57544,
 523665480,
 93010,
 -1,
 523712296,
 93011,
 523902780,
 523659247,
 -1,
 -57541,
 523845521,
 93014,
 -1,
 523906171,
 93015,
 524099391,
 523840811,
 -1,
 -57538,
 524048581,
 93012,
 -1,
 524107521,
 93013,
 -57536,
 524059574,
 93008,
 -57535,
 524244330,
 93009,
 -57534,
 524308692,
 93017,
 -1,
 524363931,
 93016,
 524558159,
 523588273,
 -1,
 524623691,
 524513185,
 -1,
 524689226,
 524560725,
 -1,
 524754761,
 524615680,
 -1,
 -57528,
 524710299,
 93021,
 -1,
 524752889,
 93024,
 -1,
 524707823,
 93019,
 -1,
 524641633,
 93025,
 525082446,
 524564401,
 -1,
 -57523,
 525035503,
 93020,
 -1,
 525075115,
 93023,
 -1,
 525028840,
 93022,
 525402111,
 524503946,
 -1,
 525410131,
 525299617,
 -1,
 -57518,
 525366902,
 92976,
 -1,
 525407668,
 92982,
 525606742,
 525363183,
 -1,
 -57515,
 525563495,
 92980,
 -1,
 525619985,
 92977,
 525803353,
 525549737,
 -1,
 -57512,
 525743346,
 92979,
 -1,
 525806405,
 92978,
 -1,
 525743787,
 92981,
 526065571,
 513897919,
 -1,
 526131086,
 526008986,
 -1,
 526196617,
 526068712,
 -1,
 526262121,
 526134571,
 -1,
 526327656,
 526203680,
 -1,
 526393185,
 526274309,
 72416,
 -1,
 526332145,
 72419,
 -57502,
 526352854,
 72420,
 -57501,
 526482662,
 72418,
 -57500,
 526544801,
 72414,
 -57499,
 526604926,
 72412,
 -57498,
 526666383,
 72415,
 -57497,
 526729882,
 72417,
 -1,
 526794921,
 72413,
 -1,
 526257737,
 72403,
 527048555,
 526218682,
 72409,
 -1,
 526978633,
 72410,
 527179630,
 527003553,
 -1,
 -57491,
 527119242,
 72399,
 -1,
 527175241,
 72398,
 527376241,
 527129214,
 -1,
 -57488,
 527315850,
 72401,
 -1,
 527371849,
 72384,
 527572852,
 527322885,
 -1,
 -57485,
 527511831,
 72391,
 -1,
 527568457,
 72400,
 527769463,
 527515817,
 -1,
 -57482,
 527709066,
 72394,
 -1,
 527765065,
 72385,
 527966073,
 527710184,
 72407,
 -1,
 527896137,
 72411,
 528097148,
 527899211,
 -1,
 -57477,
 528036746,
 72404,
 -1,
 528092745,
 72397,
 -57475,
 528057149,
 72389,
 -57474,
 528251574,
 72390,
 -57473,
 528312396,
 72395,
 -57472,
 528375868,
 72402,
 -57471,
 528438033,
 72408,
 -57470,
 528501464,
 72387,
 -57469,
 528564948,
 72386,
 -57468,
 528626570,
 72392,
 -57467,
 528691479,
 72393,
 -57466,
 528754309,
 72406,
 -57465,
 528818654,
 72388,
 -57464,
 528881198,
 72396,
 -1,
 528944713,
 72405,
 529203199,
 526146072,
 72436,
 529268735,
 529072128,
 -1,
 529276813,
 529156422,
 72435,
 -1,
 529203692,
 72438,
 -1,
 529215031,
 72439,
 529473430,
 526084246,
 -1,
 529538964,
 529429289,
 72428,
 529661951,
 529465344,
 -1,
 529670035,
 529549638,
 72427,
 -1,
 529596908,
 72429,
 -1,
 529608247,
 72430,
 529924095,
 529478336,
 72423,
 -1,
 529793516,
 72426,
 529997723,
 529425916,
 72422,
 530120703,
 529924096,
 -1,
 530128794,
 530008390,
 72421,
 -1,
 530055660,
 72424,
 -1,
 530066999,
 72425,
 530325407,
 529943858,
 72431,
 530448383,
 530251776,
 -1,
 -57442,
 530336075,
 72433,
 -1,
 530394679,
 72434,
 530644991,
 530264768,
 72437,
 530710527,
 530513920,
 -1,
 -57438,
 530610893,
 72432,
 -1,
 530656823,
 72440,
 530849744,
 526010659,
 -1,
 530915279,
 530809640,
 -1,
 530980803,
 530859136,
 -1,
 531046338,
 530937053,
 -1,
 531111852,
 530999279,
 -1,
 531177387,
 531041865,
 -1,
 -57430,
 531123371,
 67695,
 -1,
 531178285,
 67698,
 -1,
 531117634,
 67701,
 531439535,
 531066785,
 -1,
 -57426,
 531377124,
 67688,
 -1,
 531437040,
 67702,
 531636145,
 531379464,
 67684,
 -1,
 531591463,
 67687,
 531767220,
 531566153,
 -1,
 -57421,
 531727018,
 67696,
 -1,
 531777227,
 67680,
 -57419,
 531727270,
 67686,
 -57418,
 531923747,
 67689,
 -57417,
 531987878,
 67685,
 -57416,
 532046583,
 67700,
 -57415,
 532111142,
 67699,
 -57414,
 532175786,
 67697,
 -57413,
 532239082,
 67694,
 -57412,
 532303030,
 67692,
 -57411,
 532366137,
 67691,
 -57410,
 532431139,
 67690,
 -57409,
 532492939,
 67682,
 -57408,
 532557380,
 67693,
 -57407,
 532619811,
 67683,
 -1,
 532682601,
 67681,
 -1,
 530985163,
 67703,
 532946894,
 530928305,
 -1,
 533012426,
 532901793,
 -1,
 533077960,
 532970726,
 -1,
 -57401,
 533025553,
 67706,
 -1,
 533080639,
 67711,
 -57399,
 533018408,
 67707,
 -1,
 533211477,
 67710,
 533405645,
 532950315,
 -1,
 -57396,
 533354693,
 67708,
 -1,
 533413633,
 67709,
 -1,
 533353834,
 67705,
 -1,
 532898998,
 67704,
 -1,
 530842959,
 127796,
 533798872,
 530788755,
 128463,
 533864406,
 533725184,
 -1,
 533929941,
 533823286,
 -1,
 -57388,
 533887457,
 128195,
 -1,
 533937679,
 128479,
 -1,
 533867904,
 128196,
 -57385,
 533817327,
 128464,
 -1,
 534142958,
 128223,
 534323167,
 533751705,
 -1,
 534388702,
 534263931,
 -1,
 -57381,
 534345770,
 983149,
 -57380,
 534392713,
 983145,
 -57379,
 534455567,
 983146,
 -1,
 534517349,
 983148,
 -1,
 534348279,
 127881,
 534781922,
 534277566,
 -1,
 -57375,
 534732156,
 128706,
 -1,
 534784450,
 128755,
 534978532,
 534716755,
 983121,
 -1,
 534913940,
 983120,
 -57371,
 534936808,
 128062,
 -57370,
 535059496,
 128206,
 -57369,
 535121842,
 128060,
 -1,
 535174564,
 128230,
 535371861,
 513819290,
 -1,
 535437395,
 535301705,
 -1,
 535502930,
 535397038,
 -1,
 535568401,
 535457697,
 -1,
 535633922,
 535521246,
 -1,
 535699448,
 535562387,
 127201,
 -57361,
 535629251,
 127219,
 -57360,
 535694660,
 127218,
 -57359,
 535760030,
 127217,
 -57358,
 535825414,
 127216,
 -57357,
 535890780,
 127215,
 -57356,
 535956160,
 127214,
 -57355,
 536021511,
 127213,
 -57354,
 536086831,
 127212,
 -57353,
 536152211,
 127211,
 -1,
 536217603,
 127210,
 536420347,
 535628079,
 127202,
 -57350,
 536348819,
 127221,
 -1,
 536414211,
 127220,
 -57348,
 536350147,
 127209,
 -57347,
 536546628,
 127208,
 -57346,
 536611998,
 127207,
 -57345,
 536677382,
 127206,
 -57344,
 536742748,
 127205,
 -57343,
 536808128,
 127204,
 -1,
 536873479,
 127203,
 537075719,
 535593055,
 -1,
 -57340,
 537029953,
 127138,
 -57339,
 537081159,
 127154,
 -57338,
 537142120,
 127170,
 -1,
 537206298,
 127186,
 537403404,
 537016133,
 -1,
 -57335,
 537357633,
 127139,
 -57334,
 537408839,
 127155,
 -57333,
 537469800,
 127171,
 -1,
 537533978,
 127187,
 537788415,
 537340261,
 -1,
 -57330,
 537685313,
 127146,
 -57329,
 537736519,
 127162,
 -57328,
 537797480,
 127178,
 -1,
 537861658,
 127194,
 538058782,
 535506219,
 -1,
 538124313,
 538006289,
 -1,
 538189848,
 538081729,
 -1,
 -57323,
 538144065,
 127140,
 -57322,
 538195271,
 127156,
 -57321,
 538256232,
 127172,
 -1,
 538320410,
 127188,
 -1,
 538137727,
 127200,
 538640383,
 538066741,
 -1,
 -57317,
 538537281,
 127141,
 -57316,
 538588487,
 127157,
 -57315,
 538649448,
 127173,
 -1,
 538713626,
 127189,
 538910761,
 538011631,
 -1,
 538976292,
 538853272,
 -1,
 -57311,
 538930497,
 127142,
 -57310,
 538981703,
 127158,
 -57309,
 539042664,
 127174,
 -1,
 539106842,
 127190,
 539361279,
 538913920,
 -1,
 -57306,
 539258177,
 127143,
 -57305,
 539309383,
 127159,
 -57304,
 539370344,
 127175,
 -1,
 539434522,
 127191,
 539631668,
 538853545,
 -1,
 539697199,
 539578558,
 -1,
 -57300,
 539651393,
 127148,
 -57299,
 539702599,
 127164,
 -57298,
 539763560,
 127180,
 -1,
 539827738,
 127196,
 540082175,
 539638874,
 -1,
 -57295,
 539979073,
 127150,
 -57294,
 540030279,
 127166,
 -57293,
 540091240,
 127182,
 -1,
 540155418,
 127198,
 540352569,
 539582375,
 -1,
 -57290,
 540306753,
 127149,
 -57289,
 540357959,
 127165,
 -57288,
 540418920,
 127181,
 -1,
 540483098,
 127197,
 540680254,
 540299481,
 -1,
 -57285,
 540634433,
 127145,
 -57284,
 540685639,
 127161,
 -57283,
 540746600,
 127177,
 -1,
 540810778,
 127193,
 541007939,
 540622862,
 -1,
 -57280,
 540962113,
 127147,
 -57279,
 541013319,
 127163,
 -57278,
 541074280,
 127179,
 -1,
 541138458,
 127195,
 541335624,
 540944552,
 -1,
 -57275,
 541289793,
 127144,
 -57274,
 541340999,
 127160,
 -57273,
 541401960,
 127176,
 -1,
 541466138,
 127192,
 541663309,
 541265738,
 -1,
 -57270,
 541617473,
 127137,
 -57269,
 541668679,
 127153,
 -57268,
 541729640,
 127169,
 -1,
 541793818,
 127185,
 541990992,
 541595165,
 -1,
 -57265,
 541934342,
 127183,
 -1,
 541986642,
 127136,
 -57263,
 541949620,
 127199,
 -1,
 542138943,
 127167,
 -1,
 535436208,
 128720,
 -57260,
 535393722,
 983150,
 -1,
 542318931,
 983147,
 542515322,
 535324791,
 -1,
 542580843,
 542459607,
 -1,
 542646364,
 542533615,
 -1,
 542711899,
 542576201,
 -1,
 -57254,
 542657707,
 68493,
 -1,
 542712621,
 68495,
 -1,
 542651970,
 68496,
 542974046,
 542586120,
 68484,
 -1,
 542929191,
 68487,
 -57249,
 542933926,
 68486,
 -57248,
 543064867,
 68488,
 -57247,
 543129022,
 68485,
 -57246,
 543191210,
 68497,
 -57245,
 543251370,
 68494,
 -57244,
 543314666,
 68492,
 -57243,
 543378618,
 68491,
 -57242,
 543441721,
 68490,
 -57241,
 543506723,
 68489,
 -57240,
 543568523,
 68482,
 -57239,
 543629859,
 68483,
 -57238,
 543692649,
 68481,
 -1,
 543756618,
 68480,
 543957109,
 542528177,
 -1,
 544022642,
 543911841,
 -1,
 544088176,
 543980774,
 -1,
 -57233,
 544035601,
 68522,
 -1,
 544090687,
 68526,
 -57231,
 544028456,
 68523,
 -1,
 544221525,
 68525,
 544415860,
 543970666,
 68521,
 -1,
 544342562,
 68527,
 -1,
 544354237,
 68524,
 544612472,
 543895511,
 -1,
 -57225,
 544547874,
 68508,
 -1,
 544612418,
 68507,
 -57223,
 544568634,
 68506,
 -1,
 544762115,
 68505,
 544940177,
 542462737,
 -1,
 545005697,
 544896442,
 -1,
 545071231,
 544961197,
 -1,
 -57218,
 545008978,
 128545,
 -1,
 545069893,
 128574,
 -57216,
 545016411,
 127831,
 -1,
 545201169,
 128093,
 545398917,
 544950189,
 -1,
 545464452,
 545332017,
 128659,
 -1,
 545417258,
 128680,
 -1,
 545412049,
 128110,
 545661064,
 545353633,
 -1,
 -57209,
 545591016,
 128688,
 -1,
 545653522,
 127858,
 545857675,
 545615332,
 -1,
 -57206,
 545790353,
 128238,
 -1,
 545853758,
 128239,
 546054286,
 545806974,
 -1,
 -57203,
 545988496,
 127871,
 -1,
 546046347,
 8297,
 -57201,
 546006947,
 128254,
 -57200,
 546198453,
 128041,
 -1,
 546250175,
 128425,
 546447529,
 544876165,
 -1,
 546513056,
 546398190,
 -1,
 546578591,
 546465775,
 -1,
 546644126,
 546526485,
 -1,
 546709661,
 546570240,
 -1,
 546775194,
 546668336,
 -1,
 -57192,
 546725309,
 128590,
 -57191,
 546778953,
 128591,
 -1,
 546838728,
 128113,
 -57189,
 546726110,
 128588,
 -57188,
 546975903,
 128589,
 -1,
 547035523,
 128583,
 -1,
 546640178,
 128187,
 -1,
 546581682,
 128547,
 -1,
 546516853,
 127917,
 547430565,
 546459397,
 -1,
 -57182,
 547385397,
 9956,
 -57181,
 547449861,
 128532,
 -57180,
 547500870,
 128039,
 -1,
 547554172,
 128390,
 547758248,
 547360329,
 -1,
 -57177,
 547708910,
 127824,
 -1,
 547757073,
 127825,
 -1,
 547693334,
 128694,
 548020411,
 546398190,
 -1,
 548085944,
 547960808,
 -1,
 548151476,
 548043446,
 -1,
 548217011,
 548106433,
 -1,
 548282544,
 548145002,
 -1,
 -57169,
 548210991,
 983166,
 -1,
 548276371,
 983163,
 548536319,
 548208640,
 -1,
 -57166,
 548435302,
 983165,
 -1,
 548492650,
 983162,
 -1,
 548151619,
 983192,
 548798463,
 548097797,
 -1,
 548806839,
 548696333,
 128424,
 -1,
 548733483,
 128438,
 -1,
 548740108,
 128120,
 -57159,
 548033527,
 128711,
 -57158,
 548940640,
 983236,
 -1,
 549000713,
 128255,
 549200071,
 547960808,
 -1,
 549265600,
 549138673,
 128022,
 549388287,
 549191680,
 -1,
 -57153,
 549278165,
 128061,
 -1,
 549334354,
 128055,
 549527747,
 549212138,
 -1,
 -57150,
 549458768,
 127821,
 -1,
 549519743,
 127885,
 549724358,
 549470874,
 -1,
 -57147,
 549667482,
 128138,
 -1,
 549725870,
 128169,
 -1,
 549678699,
 128299,
 549986512,
 549156282,
 -1,
 550052043,
 549937134,
 -1,
 -57142,
 550004972,
 128091,
 -1,
 550067355,
 128156,
 -57140,
 550006713,
 128686,
 -57139,
 550202102,
 128204,
 -57138,
 550246561,
 128226,
 -57137,
 550308143,
 983167,
 -1,
 550373523,
 983164,
 550576339,
 549921107,
 -1,
 -57134,
 550516712,
 983229,
 -1,
 550579499,
 983220,
 -1,
 550521487,
 983193,
 550838790,
 513768108,
 -1,
 550904278,
 550791151,
 -1,
 550969669,
 550832275,
 983237,
 551035106,
 550899139,
 983261,
 -57127,
 550964675,
 983441,
 -57126,
 551030084,
 983440,
 -57125,
 551095454,
 983439,
 -57124,
 551160838,
 983438,
 -57123,
 551226204,
 983437,
 -57122,
 551291584,
 983436,
 -57121,
 551356935,
 983435,
 -57120,
 551422255,
 983434,
 -57119,
 551487635,
 983433,
 -1,
 551553027,
 983432,
 551756013,
 550964548,
 983260,
 -57116,
 551685571,
 983431,
 -57115,
 551750980,
 983430,
 -57114,
 551816350,
 983429,
 -57113,
 551881734,
 983428,
 -57112,
 551947100,
 983427,
 -57111,
 552012480,
 983426,
 -57110,
 552077831,
 983425,
 -57109,
 552143151,
 983424,
 -57108,
 552208531,
 983423,
 -1,
 552273923,
 983422,
 552476920,
 551685278,
 983259,
 -57105,
 552406467,
 983421,
 -57104,
 552471876,
 983420,
 -57103,
 552537246,
 983419,
 -57102,
 552602630,
 983418,
 -57101,
 552667996,
 983417,
 -57100,
 552733376,
 983416,
 -57099,
 552798727,
 983415,
 -57098,
 552864047,
 983414,
 -57097,
 552929427,
 983413,
 -1,
 552994819,
 983412,
 553197827,
 552406022,
 983252,
 -57094,
 553127363,
 983411,
 -57093,
 553192772,
 983410,
 -57092,
 553258142,
 983409,
 -57091,
 553323526,
 983408,
 -57090,
 553388892,
 983407,
 -57089,
 553454272,
 983406,
 -57088,
 553519623,
 983405,
 -57087,
 553584943,
 983404,
 -57086,
 553650323,
 983403,
 -1,
 553715715,
 983402,
 553918734,
 553126748,
 983251,
 -57083,
 553848259,
 983401,
 -57082,
 553913668,
 983400,
 -57081,
 553979038,
 983399,
 -57080,
 554044422,
 983398,
 -57079,
 554109788,
 983397,
 -57078,
 554175168,
 983396,
 -57077,
 554240519,
 983395,
 -57076,
 554305839,
 983394,
 -57075,
 554371219,
 983393,
 -1,
 554436611,
 983392,
 554639641,
 553847488,
 983250,
 -57072,
 554569155,
 983391,
 -57071,
 554634564,
 983390,
 -57070,
 554699934,
 983389,
 -57069,
 554765318,
 983388,
 -57068,
 554830684,
 983387,
 -57067,
 554896064,
 983386,
 -57066,
 554961415,
 983385,
 -57065,
 555026735,
 983384,
 -57064,
 555092115,
 983383,
 -1,
 555157507,
 983382,
 555360548,
 554568199,
 983249,
 -57061,
 555290051,
 983381,
 -57060,
 555355460,
 983380,
 -57059,
 555420830,
 983379,
 -57058,
 555486214,
 983378,
 -57057,
 555551580,
 983377,
 -57056,
 555616960,
 983376,
 -57055,
 555682311,
 983375,
 -57054,
 555747631,
 983374,
 -57053,
 555813011,
 983373,
 -1,
 555878403,
 983372,
 556081455,
 555288879,
 983248,
 -57050,
 556010947,
 983371,
 -57049,
 556076356,
 983370,
 -57048,
 556141726,
 983369,
 -57047,
 556207110,
 983368,
 -57046,
 556272476,
 983367,
 -57045,
 556337856,
 983366,
 -57044,
 556403207,
 983365,
 -57043,
 556468527,
 983364,
 -57042,
 556533907,
 983363,
 -1,
 556599299,
 983362,
 556802362,
 556009619,
 983247,
 -57039,
 556731843,
 983361,
 -57038,
 556797252,
 983360,
 -57037,
 556862622,
 983359,
 -57036,
 556928006,
 983358,
 -57035,
 556993372,
 983357,
 -57034,
 557058752,
 983356,
 -57033,
 557124103,
 983355,
 -57032,
 557189423,
 983354,
 -57031,
 557254803,
 983353,
 -1,
 557320195,
 983352,
 557580287,
 556730371,
 983246,
 -57028,
 557452739,
 983351,
 -57027,
 557518148,
 983350,
 -57026,
 557583518,
 983349,
 -57025,
 557648902,
 983348,
 -57024,
 557714268,
 983347,
 -57023,
 557779648,
 983346,
 -57022,
 557844999,
 983345,
 -57021,
 557910319,
 983344,
 -57020,
 557975699,
 983343,
 -1,
 558041091,
 983342,
 558244233,
 550897967,
 983238,
 558309713,
 558172864,
 983266,
 -57016,
 558239171,
 983491,
 -57015,
 558304580,
 983490,
 -57014,
 558369950,
 983489,
 -57013,
 558435334,
 983488,
 -57012,
 558500700,
 983487,
 -57011,
 558566080,
 983486,
 -57010,
 558631431,
 983485,
 -57009,
 558696751,
 983484,
 -57008,
 558762131,
 983483,
 -1,
 558827523,
 983482,
 559030620,
 558238215,
 983265,
 -57005,
 558960067,
 983481,
 -57004,
 559025476,
 983480,
 -57003,
 559090846,
 983479,
 -57002,
 559156230,
 983478,
 -57001,
 559221596,
 983477,
 -57000,
 559286976,
 983476,
 -56999,
 559352327,
 983475,
 -56998,
 559417647,
 983474,
 -56997,
 559483027,
 983473,
 -1,
 559548419,
 983472,
 559751527,
 558958895,
 983264,
 -56994,
 559680963,
 983471,
 -56993,
 559746372,
 983470,
 -56992,
 559811742,
 983469,
 -56991,
 559877126,
 983468,
 -56990,
 559942492,
 983467,
 -56989,
 560007872,
 983466,
 -56988,
 560073223,
 983465,
 -56987,
 560138543,
 983464,
 -56986,
 560203923,
 983463,
 -1,
 560269315,
 983462,
 560472434,
 559679635,
 983263,
 -56983,
 560401859,
 983461,
 -56982,
 560467268,
 983460,
 -56981,
 560532638,
 983459,
 -56980,
 560598022,
 983458,
 -56979,
 560663388,
 983457,
 -56978,
 560728768,
 983456,
 -56977,
 560794119,
 983455,
 -56976,
 560859439,
 983454,
 -56975,
 560924819,
 983453,
 -1,
 560990211,
 983452,
 561193341,
 560400387,
 983262,
 -56972,
 561122755,
 983451,
 -56971,
 561188164,
 983450,
 -56970,
 561253534,
 983449,
 -56969,
 561318918,
 983448,
 -56968,
 561384284,
 983447,
 -56967,
 561449664,
 983446,
 -56966,
 561515015,
 983445,
 -56965,
 561580335,
 983444,
 -56964,
 561645715,
 983443,
 -1,
 561711107,
 983442,
 561914245,
 561122140,
 983267,
 -56961,
 561843206,
 983498,
 -56960,
 561908572,
 983497,
 -56959,
 561973952,
 983496,
 -56958,
 562039303,
 983495,
 -56957,
 562104623,
 983494,
 -56956,
 562170003,
 983493,
 -1,
 562235395,
 983492,
 -56954,
 561843651,
 983271,
 -56953,
 562367812,
 983270,
 -56952,
 562433182,
 983269,
 -1,
 562498566,
 983268,
 562700692,
 558173635,
 983245,
 -56949,
 562630083,
 983341,
 -56948,
 562695492,
 983340,
 -56947,
 562760862,
 983339,
 -56946,
 562826246,
 983338,
 -56945,
 562891612,
 983337,
 -56944,
 562956992,
 983336,
 -56943,
 563022343,
 983335,
 -56942,
 563087663,
 983334,
 -56941,
 563153043,
 983333,
 -1,
 563218435,
 983332,
 563421599,
 562629956,
 983244,
 -56938,
 563350979,
 983331,
 -56937,
 563416388,
 983330,
 -56936,
 563481758,
 983329,
 -56935,
 563547142,
 983328,
 -56934,
 563612508,
 983327,
 -56933,
 563677888,
 983326,
 -56932,
 563743239,
 983325,
 -56931,
 563808559,
 983324,
 -56930,
 563873939,
 983323,
 -1,
 563939331,
 983322,
 564142506,
 563350686,
 983243,
 -56927,
 564071875,
 983321,
 -56926,
 564137284,
 983320,
 -56925,
 564202654,
 983319,
 -56924,
 564268038,
 983318,
 -56923,
 564333404,
 983317,
 -56922,
 564398784,
 983316,
 -56921,
 564464135,
 983315,
 -56920,
 564529455,
 983314,
 -56919,
 564594835,
 983313,
 -1,
 564660227,
 983312,
 564863413,
 564071430,
 983242,
 -56916,
 564792771,
 983311,
 -56915,
 564858180,
 983310,
 -56914,
 564923550,
 983309,
 -56913,
 564988934,
 983308,
 -56912,
 565054300,
 983307,
 -56911,
 565119680,
 983306,
 -56910,
 565185031,
 983305,
 -56909,
 565250351,
 983304,
 -56908,
 565315731,
 983303,
 -1,
 565381123,
 983302,
 565584320,
 564792156,
 983241,
 -56905,
 565513667,
 983301,
 -56904,
 565579076,
 983300,
 -56903,
 565644446,
 983299,
 -56902,
 565709830,
 983298,
 -56901,
 565775196,
 983297,
 -56900,
 565840576,
 983296,
 -56899,
 565905927,
 983295,
 -56898,
 565971247,
 983294,
 -56897,
 566036627,
 983293,
 -1,
 566102019,
 983292,
 566305227,
 565512896,
 983240,
 -56894,
 566234563,
 983291,
 -56893,
 566299972,
 983290,
 -56892,
 566365342,
 983289,
 -56891,
 566430726,
 983288,
 -56890,
 566496092,
 983287,
 -56889,
 566561472,
 983286,
 -56888,
 566626823,
 983285,
 -56887,
 566692143,
 983284,
 -56886,
 566757523,
 983283,
 -1,
 566822915,
 983282,
 567083007,
 566233607,
 983239,
 -56883,
 566955459,
 983281,
 -56882,
 567020868,
 983280,
 -56881,
 567086238,
 983279,
 -56880,
 567151622,
 983278,
 -56879,
 567216988,
 983277,
 -56878,
 567282368,
 983276,
 -56877,
 567347719,
 983275,
 -56876,
 567413039,
 983274,
 -56875,
 567478419,
 983273,
 -1,
 567543811,
 983272,
 567747065,
 550839941,
 -1,
 567812592,
 567697390,
 -1,
 567878120,
 567771608,
 -1,
 567943655,
 567817550,
 -1,
 568009182,
 567896047,
 -1,
 -56868,
 567956625,
 128636,
 -56867,
 568016799,
 128953,
 -1,
 568070564,
 128941,
 568271329,
 567967319,
 -1,
 -56864,
 568225184,
 128914,
 -1,
 568270060,
 128904,
 568467940,
 568207521,
 -1,
 -56861,
 568421776,
 128959,
 -1,
 568483084,
 128976,
 -56859,
 568419096,
 128637,
 -56858,
 568603419,
 128934,
 -1,
 568667832,
 128947,
 -1,
 567875859,
 128933,
 568983551,
 567833128,
 -1,
 568992239,
 568881057,
 -1,
 569057774,
 568921767,
 -1,
 569123309,
 569014182,
 983069,
 -1,
 569050172,
 983143,
 -1,
 569049689,
 11135,
 -1,
 569008224,
 128678,
 -1,
 568945683,
 11837,
 569507839,
 567747441,
 -1,
 569516533,
 569406254,
 -1,
 -56845,
 569468288,
 7416,
 -56844,
 569517293,
 7417,
 -1,
 569580219,
 7412,
 569835519,
 569469798,
 -1,
 -56841,
 569735414,
 7414,
 -56840,
 569796352,
 7411,
 -1,
 569851992,
 7413,
 570040833,
 567687144,
 -1,
 570106367,
 569975492,
 -1,
 570171902,
 570032128,
 -1,
 -56835,
 570110288,
 127918,
 -1,
 570170016,
 128249,
 -1,
 570104629,
 128252,
 -56832,
 570053784,
 127931,
 -1,
 570366369,
 128243,
 570565123,
 569995169,
 983070,
 -1,
 570517487,
 983144,
 570753023,
 570512511,
 -1,
 -56827,
 570640247,
 127952,
 -1,
 570694356,
 127755,
 570893125,
 550773075,
 -1,
 570958511,
 570849538,
 -1,
 571024001,
 570902231,
 -1,
 571089445,
 570976239,
 113692,
 571154968,
 571015168,
 -1,
 571220493,
 571113277,
 113701,
 -1,
 571146464,
 113702,
 571351567,
 571174817,
 113714,
 -1,
 571278329,
 113715,
 571482641,
 571300478,
 113716,
 -1,
 571409401,
 113717,
 571613715,
 571424937,
 113727,
 -1,
 571540473,
 113728,
 571744789,
 571555829,
 113696,
 -1,
 571671592,
 113710,
 -56810,
 571697135,
 113706,
 -56809,
 571821829,
 113723,
 -1,
 571886223,
 113724,
 572072484,
 571099433,
 -1,
 572138013,
 572008069,
 -1,
 -56805,
 572083973,
 113767,
 -56804,
 572142460,
 113740,
 -1,
 572204677,
 113742,
 572400160,
 572085009,
 -1,
 -56801,
 572357862,
 113730,
 -1,
 572411653,
 113769,
 -56799,
 572356026,
 113752,
 -56798,
 572538869,
 113685,
 -56797,
 572597028,
 113682,
 -1,
 572658178,
 113768,
 -1,
 572012288,
 113737,
 572924464,
 571035397,
 113690,
 572989995,
 572855424,
 -1,
 -56792,
 572945850,
 113761,
 -56791,
 573002513,
 113762,
 -56790,
 573061096,
 113763,
 -1,
 573115977,
 113764,
 573374463,
 572915712,
 -1,
 573383214,
 573262479,
 113694,
 -1,
 573309992,
 113708,
 -56785,
 573341501,
 113698,
 -1,
 573466607,
 113704,
 573645370,
 572866549,
 113691,
 573767679,
 573571072,
 -1,
 573776436,
 573669181,
 113699,
 -1,
 573728772,
 113700,
 573907510,
 573728751,
 113705,
 -1,
 573834756,
 113711,
 574038584,
 573853445,
 113712,
 -1,
 573965352,
 113713,
 574226431,
 573983375,
 113695,
 -1,
 574096424,
 113709,
 574300738,
 573603046,
 113720,
 574366269,
 574247697,
 113757,
 -1,
 574323942,
 113760,
 -56770,
 574306280,
 113758,
 -56769,
 574436220,
 113721,
 -56768,
 574498968,
 113759,
 -56767,
 574557769,
 113756,
 -1,
 574620665,
 113722,
 574825032,
 574250990,
 113675,
 574890566,
 574772432,
 -1,
 -56763,
 574846394,
 113750,
 -1,
 574896104,
 113741,
 -56761,
 574829436,
 113688,
 -1,
 575013928,
 113680,
 575218253,
 574771985,
 113732,
 -56758,
 575175910,
 113754,
 -56757,
 575239610,
 113755,
 -56756,
 575296500,
 113753,
 -1,
 575344201,
 113731,
 575545939,
 575163023,
 113689,
 575668223,
 575471616,
 -1,
 575677009,
 575557381,
 113693,
 -1,
 575603752,
 113707,
 -56750,
 575635261,
 113697,
 -1,
 575760367,
 113703,
 575939159,
 575501754,
 113745,
 -56747,
 575879144,
 113738,
 -56746,
 575943548,
 113751,
 -1,
 575996626,
 113748,
 576201308,
 575893409,
 113667,
 576266843,
 576126976,
 -1,
 -56742,
 576219119,
 113718,
 -1,
 576282633,
 113719,
 -1,
 576205692,
 113681,
 576528993,
 576150142,
 113666,
 576594528,
 576465685,
 -1,
 -56737,
 576540421,
 113765,
 -1,
 576604815,
 113766,
 -1,
 576520914,
 113676,
 576856678,
 576471706,
 113670,
 576922213,
 576804305,
 -1,
 -56732,
 576878010,
 113749,
 -1,
 576927720,
 113743,
 -1,
 576861052,
 113687,
 577184363,
 576798889,
 113669,
 577249898,
 577110016,
 -1,
 -56727,
 577200137,
 113725,
 -1,
 577260175,
 113679,
 -1,
 577192105,
 113684,
 577512046,
 577119877,
 113735,
 -56723,
 577467834,
 113746,
 -1,
 577513093,
 113739,
 577708657,
 577446227,
 113672,
 -56720,
 577647484,
 113683,
 -1,
 577700904,
 113677,
 577905267,
 577667398,
 113665,
 -1,
 577862886,
 113747,
 578036341,
 577862316,
 113673,
 -1,
 577983330,
 113770,
 578167415,
 577976296,
 113734,
 -1,
 578102917,
 113736,
 578298489,
 578106236,
 113664,
 -1,
 578241178,
 113686,
 578429563,
 578236657,
 113674,
 -1,
 578356220,
 113726,
 578560637,
 578366763,
 113668,
 -1,
 578486994,
 113678,
 578691711,
 578489929,
 113729,
 -1,
 578639947,
 113733,
 -56704,
 578650706,
 113744,
 -1,
 578754077,
 113671,
 578953899,
 570953808,
 -1,
 579019410,
 578896538,
 -1,
 579084945,
 578968076,
 -1,
 579150470,
 579042149,
 113816,
 -1,
 579077172,
 113779,
 579281545,
 579093146,
 -1,
 -56696,
 579229142,
 113811,
 -1,
 579288035,
 113814,
 579478156,
 579210825,
 -1,
 -56693,
 579430248,
 113817,
 -1,
 579477822,
 113808,
 -56691,
 579435920,
 113815,
 -56690,
 579629643,
 113809,
 -56689,
 579678997,
 113810,
 -56688,
 579740706,
 113812,
 -1,
 579804396,
 113813,
 -1,
 579020865,
 113776,
 580067998,
 578958847,
 -1,
 580133525,
 580025189,
 113800,
 -1,
 580060212,
 113781,
 580264600,
 580076186,
 -1,
 -56681,
 580212182,
 113795,
 -1,
 580271075,
 113798,
 -56679,
 580222352,
 113799,
 -56678,
 580416075,
 113793,
 -56677,
 580465429,
 113794,
 -56676,
 580527138,
 113796,
 -56675,
 580590828,
 113797,
 -1,
 580652975,
 113792,
 580854439,
 579999086,
 -1,
 580919971,
 580808728,
 -1,
 580985506,
 580866213,
 113784,
 -1,
 580911644,
 113788,
 -1,
 580926066,
 113785,
 -56668,
 580872444,
 113782,
 -56667,
 581125623,
 113783,
 -56666,
 581187584,
 113787,
 -1,
 581248673,
 113786,
 581444266,
 580799780,
 -1,
 -56663,
 581401467,
 113780,
 -1,
 581449436,
 113777,
 -1,
 581395426,
 113778,
 -56660,
 578908506,
 113821,
 -56659,
 581659550,
 113820,
 -56658,
 581721741,
 113823,
 -1,
 581772472,
 113822,
 581968624,
 570905361,
 -1,
 582034142,
 581926920,
 -1,
 582099675,
 581991750,
 -1,
 582165192,
 582053793,
 -1,
 582230727,
 582116199,
 -1,
 582296262,
 582158222,
 -1,
 582361795,
 582226972,
 11107,
 582483967,
 582287360,
 -1,
 582492865,
 582385456,
 -1,
 582558395,
 582437206,
 -1,
 -56646,
 582509797,
 11169,
 -1,
 582567436,
 11168,
 -56644,
 582515645,
 129075,
 -56643,
 582700932,
 129059,
 -56642,
 582765649,
 129063,
 -56641,
 582825318,
 129071,
 -56640,
 582886559,
 11133,
 -1,
 582949156,
 129067,
 -56638,
 582447869,
 11123,
 -1,
 583091853,
 11139,
 -56636,
 582321091,
 11085,
 -56635,
 583228095,
 11143,
 -1,
 583279205,
 11117,
 -1,
 582221998,
 129171,
 -1,
 582189192,
 11247,
 583606992,
 582095925,
 -1,
 583672524,
 583560267,
 -1,
 -56629,
 583627797,
 129027,
 -1,
 583674509,
 129043,
 -56627,
 583619034,
 129179,
 -56626,
 583814252,
 129031,
 -56625,
 583877539,
 129035,
 -1,
 583936653,
 129047,
 584131283,
 583559151,
 -1,
 -56622,
 584081235,
 129083,
 -1,
 584127185,
 129107,
 584327894,
 584070478,
 -1,
 -56619,
 584261276,
 129091,
 -1,
 584324124,
 129095,
 -56617,
 584285803,
 129175,
 -56616,
 584476311,
 128623,
 -56615,
 584527447,
 129079,
 -56614,
 584588956,
 129087,
 -1,
 584652870,
 11147,
 584908799,
 582027220,
 -1,
 -56611,
 584805526,
 128317,
 -1,
 584868438,
 128315,
 585048805,
 581989818,
 -1,
 585114340,
 584980627,
 -1,
 -56607,
 585071470,
 9208,
 -56606,
 585124328,
 11842,
 -56605,
 585185249,
 11840,
 -1,
 585244933,
 10175,
 -1,
 585052729,
 127849,
 585507562,
 584982740,
 128462,
 585629695,
 585434466,
 -1,
 585638633,
 585527581,
 128441,
 -1,
 585564236,
 128442,
 -1,
 585587812,
 128443,
 585835244,
 585445617,
 128021,
 -1,
 585761247,
 128054,
 -56595,
 585792238,
 128330,
 -56594,
 585914145,
 128682,
 -56593,
 585976375,
 128044,
 -1,
 586023641,
 128687,
 586228507,
 581904005,
 -1,
 586294029,
 586185388,
 -1,
 586359558,
 586224151,
 -1,
 586425084,
 586303191,
 -1,
 586490615,
 586380730,
 -1,
 -56586,
 586446654,
 2423,
 -1,
 586491525,
 2422,
 586687226,
 586437393,
 -1,
 -56583,
 586634170,
 2420,
 -1,
 586688133,
 2419,
 -56581,
 586632084,
 2424,
 -1,
 586814960,
 2421,
 587014916,
 586382539,
 -1,
 587080448,
 586970554,
 -1,
 -56577,
 587036478,
 2391,
 -1,
 587081349,
 2390,
 587277059,
 587027217,
 -1,
 -56574,
 587223994,
 2363,
 -1,
 587277957,
 2362,
 -1,
 587208176,
 2383,
 -56571,
 586967984,
 43260,
 -1,
 587481115,
 43261,
 587726847,
 586299604,
 -1,
 587735818,
 587624353,
 -1,
 -56567,
 587694152,
 983085,
 -1,
 587740968,
 983087,
 -56565,
 587689658,
 983160,
 -56564,
 587879786,
 983083,
 -1,
 587935677,
 983089,
 588129043,
 586246127,
 -1,
 588194577,
 588071498,
 -1,
 -56560,
 588152568,
 128468,
 -1,
 588193453,
 128421,
 588447743,
 588131133,
 127964,
 -1,
 588317265,
 127965,
 588522262,
 588071578,
 983119,
 -56555,
 588463985,
 128666,
 -1,
 588524500,
 983118,
 588718873,
 588454475,
 -1,
 -56552,
 588669396,
 128475,
 -1,
 588724528,
 127795,
 -56550,
 588669641,
 127962,
 -1,
 588864404,
 127980,
 589046570,
 586168296,
 -1,
 589112095,
 589005816,
 -1,
 -56546,
 589066098,
 128171,
 -1,
 589114706,
 128565,
 589308706,
 589064367,
 -1,
 -56543,
 589245778,
 128542,
 -1,
 589306402,
 128549,
 589505317,
 589254810,
 -1,
 -56540,
 589451264,
 127244,
 -1,
 589503798,
 127243,
 589701928,
 589435375,
 -1,
 -56537,
 589656220,
 128924,
 -1,
 589720103,
 128160,
 -56535,
 589652513,
 127919,
 -1,
 589835088,
 128754,
 590029622,
 588975689,
 -1,
 590095152,
 589967858,
 -1,
 590160687,
 590053168,
 -1,
 -56530,
 590111674,
 11831,
 -1,
 590169353,
 11830,
 -1,
 590103055,
 128481,
 590422835,
 590040837,
 -1,
 -56526,
 590361296,
 127841,
 -1,
 590420985,
 128131,
 -56524,
 590376987,
 983081,
 -56523,
 590571964,
 128168,
 -1,
 590636648,
 128374,
 590816061,
 589979630,
 -1,
 590881594,
 590762769,
 -1,
 -56519,
 590830781,
 128167,
 -1,
 590892039,
 128042,
 591078204,
 590811270,
 128009,
 -1,
 591004127,
 128050,
 -1,
 591014844,
 128087,
 591274819,
 590748235,
 -1,
 -56513,
 591226863,
 983161,
 -56512,
 591268544,
 983090,
 -56511,
 591333895,
 983088,
 -56510,
 591399215,
 983086,
 -1,
 591464595,
 983084,
 -56508,
 591231705,
 128192,
 -1,
 591611008,
 983082,
 591799375,
 570839825,
 -1,
 591864865,
 591742006,
 -1,
 591930398,
 591790080,
 -1,
 591995838,
 591869881,
 -1,
 592061311,
 591948895,
 -1,
 592126825,
 591996549,
 68809,
 592192336,
 592072453,
 68825,
 592257870,
 592146337,
 68839,
 -1,
 592185311,
 68849,
 -56497,
 592216534,
 68826,
 -1,
 592321099,
 68805,
 592520019,
 592124491,
 68804,
 -56494,
 592472047,
 68806,
 -1,
 592524156,
 68841,
 592716629,
 592479035,
 68847,
 -1,
 592668655,
 68848,
 592847703,
 592670625,
 68838,
 -1,
 592806358,
 68840,
 592978777,
 592799727,
 68836,
 -1,
 592937787,
 68837,
 593109851,
 592923279,
 68824,
 -1,
 593058430,
 68833,
 593240925,
 593052314,
 68822,
 -1,
 593199574,
 68823,
 593371999,
 593178865,
 68813,
 -1,
 593330646,
 68814,
 -56480,
 593328812,
 68846,
 -56479,
 593453038,
 68834,
 -56478,
 593517182,
 68832,
 -56477,
 593576105,
 68819,
 -56476,
 593641461,
 68818,
 -56475,
 593703804,
 68815,
 -56474,
 593767723,
 68812,
 -56473,
 593831557,
 68811,
 -56472,
 593895763,
 68807,
 -1,
 593958429,
 68802,
 594158446,
 592055881,
 68800,
 -56469,
 594104223,
 68808,
 -56468,
 594168763,
 68803,
 -56467,
 594231465,
 68820,
 -1,
 594284105,
 68801,
 594486130,
 594113978,
 68842,
 -56464,
 594441658,
 68843,
 -56463,
 594503663,
 68850,
 -1,
 594563378,
 68821,
 594748277,
 594432785,
 68827,
 -56460,
 594694929,
 68828,
 -1,
 594749421,
 68831,
 594944888,
 594700231,
 -1,
 -56457,
 594900798,
 68845,
 -1,
 594957242,
 68830,
 595141499,
 594890952,
 -1,
 -56454,
 595097406,
 68844,
 -1,
 595153850,
 68829,
 595338109,
 595081192,
 68816,
 -1,
 595277800,
 68817,
 -56450,
 595290845,
 68835,
 -1,
 595402224,
 68810,
 595600309,
 591993569,
 -1,
 595665823,
 595535493,
 68745,
 595731334,
 595611397,
 68761,
 595796868,
 595685281,
 68775,
 -1,
 595724255,
 68785,
 -56443,
 595755478,
 68762,
 -1,
 595860043,
 68741,
 596059017,
 595663435,
 68740,
 -56440,
 596010991,
 68742,
 -1,
 596063100,
 68777,
 596255627,
 596017979,
 68783,
 -1,
 596207599,
 68784,
 596386701,
 596209569,
 68774,
 -1,
 596345302,
 68776,
 596517775,
 596338671,
 68772,
 -1,
 596476731,
 68773,
 596648849,
 596462223,
 68760,
 -1,
 596597374,
 68769,
 596779923,
 596591258,
 68758,
 -1,
 596738518,
 68759,
 596910997,
 596717809,
 68749,
 -1,
 596869590,
 68750,
 -56426,
 596867756,
 68782,
 -56425,
 596991982,
 68770,
 -56424,
 597056126,
 68768,
 -56423,
 597115049,
 68755,
 -56422,
 597180405,
 68754,
 -56421,
 597242748,
 68751,
 -56420,
 597306667,
 68748,
 -56419,
 597370501,
 68747,
 -56418,
 597434707,
 68743,
 -1,
 597497373,
 68738,
 597697444,
 595594825,
 68736,
 -56415,
 597643167,
 68744,
 -56414,
 597707707,
 68739,
 -56413,
 597770409,
 68756,
 -1,
 597823049,
 68737,
 598025128,
 597652922,
 68778,
 -56410,
 597980602,
 68779,
 -56409,
 598042607,
 68786,
 -1,
 598102322,
 68757,
 598287275,
 597971729,
 68763,
 -56406,
 598233873,
 68764,
 -1,
 598288365,
 68767,
 598483886,
 598239175,
 -1,
 -56403,
 598439742,
 68781,
 -1,
 598496186,
 68766,
 598680497,
 598429896,
 -1,
 -56400,
 598636350,
 68780,
 -1,
 598692794,
 68765,
 598877107,
 598620136,
 68752,
 -1,
 598816744,
 68753,
 -56396,
 598829789,
 68771,
 -1,
 598941168,
 68746,
 599195647,
 595546801,
 -1,
 599204794,
 599086442,
 68858,
 599326719,
 599130112,
 -1,
 -56391,
 599224722,
 68863,
 -1,
 599275441,
 68862,
 599466941,
 599141917,
 -1,
 -56388,
 599423708,
 68859,
 -1,
 599470303,
 68861,
 -1,
 599421182,
 68860,
 599729135,
 591944708,
 -1,
 599794670,
 599674136,
 -1,
 599860168,
 599753174,
 -1,
 599925700,
 599796387,
 66415,
 -56381,
 599881146,
 66408,
 -1,
 599930856,
 66416,
 600122310,
 599854665,
 66420,
 -1,
 600076193,
 66417,
 -56377,
 600077754,
 66419,
 -1,
 600205284,
 66407,
 600384461,
 599812079,
 -1,
 600449996,
 600322940,
 -1,
 -56373,
 600397386,
 66405,
 -1,
 600448201,
 66406,
 -1,
 600390251,
 66401,
 600712144,
 600324072,
 66393,
 -56369,
 600647301,
 66418,
 -1,
 600706633,
 66421,
 600908757,
 600645971,
 -1,
 600974292,
 600867643,
 -1,
 -56365,
 600915652,
 66392,
 -1,
 600979107,
 66390,
 -1,
 600921105,
 66387,
 601236440,
 600867643,
 -1,
 -56361,
 601175715,
 66389,
 -1,
 601232627,
 66391,
 601433051,
 601193132,
 -1,
 -56358,
 601380426,
 66398,
 -1,
 601434787,
 66414,
 601629662,
 601386913,
 -1,
 -56355,
 601582593,
 66413,
 -1,
 601624724,
 66402,
 601826272,
 601576209,
 66409,
 -1,
 601772817,
 66410,
 601957346,
 601761413,
 66388,
 -1,
 601894187,
 66411,
 -56349,
 601912762,
 66403,
 -56348,
 602038973,
 66400,
 -56347,
 602102721,
 66399,
 -56346,
 602165301,
 66397,
 -56345,
 602229990,
 66396,
 -56344,
 602293944,
 66395,
 -56343,
 602358302,
 66394,
 -56342,
 602420106,
 66412,
 -56341,
 602485062,
 66386,
 -56340,
 602545313,
 66404,
 -56339,
 602610195,
 66385,
 -1,
 602673666,
 66384,
 -1,
 599747868,
 128435,
 602940444,
 599675334,
 -1,
 603005975,
 602883799,
 -1,
 603071479,
 602959777,
 -1,
 603137013,
 603009916,
 -1,
 -56332,
 603072648,
 68251,
 -1,
 603132207,
 68249,
 -56330,
 603072648,
 68233,
 -1,
 603263115,
 68247,
 603464699,
 603007816,
 -1,
 -56327,
 603392519,
 68239,
 -56326,
 603457839,
 68230,
 -1,
 603523219,
 68234,
 603726846,
 603423549,
 -1,
 -56323,
 603667188,
 68248,
 -1,
 603730812,
 68252,
 603923457,
 603668649,
 -1,
 -56320,
 603861919,
 68237,
 -1,
 603918376,
 68235,
 604120068,
 603861884,
 -1,
 -56317,
 604055688,
 68224,
 -1,
 604115083,
 68226,
 604316679,
 604057841,
 -1,
 -56314,
 604255156,
 68246,
 -1,
 604317698,
 68244,
 604513290,
 604250590,
 -1,
 -56311,
 604455578,
 68245,
 -1,
 604512595,
 68243,
 604709901,
 604442185,
 -1,
 -56308,
 604652794,
 68241,
 -1,
 604715764,
 68242,
 -56306,
 604668505,
 68250,
 -56305,
 604863910,
 68229,
 -56304,
 604923995,
 68238,
 -56303,
 604988089,
 68231,
 -56302,
 605052675,
 68228,
 -56301,
 605114794,
 68236,
 -56300,
 605179014,
 68227,
 -56299,
 605242165,
 68225,
 -56298,
 605302237,
 68240,
 -1,
 605361939,
 68232,
 605618175,
 602952369,
 -1,
 605627419,
 605515681,
 -1,
 -56294,
 605584909,
 68255,
 -1,
 605628757,
 68254,
 -1,
 605574506,
 68253,
 -56291,
 602882482,
 128477,
 -1,
 605830865,
 66335,
 606076927,
 591866534,
 -1,
 -56288,
 605978801,
 128117,
 -1,
 606030697,
 128116,
 606217265,
 591813246,
 -1,
 606282798,
 606152325,
 -1,
 606348333,
 606228231,
 -1,
 606413863,
 606292749,
 -1,
 -56282,
 606363794,
 128236,
 -1,
 606423581,
 128237,
 606610474,
 606350635,
 -1,
 -56279,
 606557323,
 128449,
 -1,
 606616225,
 128194,
 -56277,
 606554415,
 128275,
 -56276,
 606745757,
 128080,
 -1,
 606804296,
 128214,
 -1,
 606298410,
 983190,
 607069232,
 606237231,
 128191,
 -1,
 606994987,
 128440,
 -1,
 607008389,
 9934,
 607265852,
 606167022,
 -1,
 607331387,
 607207381,
 -1,
 607396920,
 607278446,
 -1,
 -56267,
 607349788,
 2933,
 -56266,
 607412064,
 2930,
 -56265,
 607466485,
 2931,
 -1,
 607529160,
 2934,
 607780863,
 607351220,
 -1,
 -56262,
 607677478,
 2935,
 -1,
 607739806,
 2932,
 -1,
 607261294,
 128217,
 607986757,
 607211269,
 -1,
 608052291,
 607919728,
 -1,
 -56257,
 608006318,
 128662,
 -56256,
 608066903,
 128660,
 -56255,
 608120446,
 128753,
 -56254,
 608180766,
 128653,
 -1,
 608245180,
 128664,
 -56252,
 607987338,
 128431,
 -1,
 608372238,
 128283,
 -56250,
 607945030,
 128002,
 -56249,
 608533325,
 128471,
 -56248,
 608598623,
 128228,
 -56247,
 608659657,
 983191,
 -56246,
 608717488,
 128329,
 -56245,
 608780484,
 128076,
 -56244,
 608844405,
 128738,
 -56243,
 608906766,
 127970,
 -56242,
 608969386,
 127842,
 -1,
 609034413,
 128025,
 609232218,
 591741097,
 -1,
 609297720,
 609170300,
 -1,
 609363116,
 609253140,
 -1,
 609428623,
 609306327,
 -1,
 609494106,
 609362259,
 -1,
 609559640,
 609427795,
 -1,
 -56234,
 609497994,
 70347,
 -56233,
 609559006,
 70345,
 -1,
 609619529,
 70344,
 -56231,
 609497994,
 70352,
 -1,
 609750601,
 70351,
 609952864,
 609447841,
 -1,
 610018398,
 609906593,
 -1,
 -56227,
 609956746,
 70343,
 -1,
 610012745,
 70342,
 -56225,
 609956746,
 70350,
 -1,
 610143817,
 70349,
 610346085,
 609898245,
 -1,
 -56222,
 610304546,
 70341,
 -56221,
 610357098,
 70348,
 -56220,
 610414871,
 70335,
 -1,
 610471497,
 70353,
 610673769,
 610274889,
 70320,
 -56217,
 610629050,
 70329,
 -56216,
 610678760,
 70327,
 -1,
 610733641,
 70321,
 610935917,
 610615285,
 -1,
 -56213,
 610877451,
 70339,
 -56212,
 610939786,
 70340,
 -1,
 610995785,
 70338,
 611198065,
 610873585,
 -1,
 -56209,
 611136394,
 70334,
 -56208,
 611201303,
 70333,
 -1,
 611257929,
 70332,
 611460213,
 611128861,
 -1,
 -56205,
 611398538,
 70358,
 -56204,
 611456558,
 70357,
 -1,
 611520073,
 70356,
 611722359,
 611415482,
 70324,
 -1,
 611677626,
 70325,
 611853434,
 611674095,
 -1,
 -56199,
 611791754,
 70364,
 -1,
 611847753,
 70365,
 612050045,
 611803118,
 -1,
 -56196,
 611999804,
 70346,
 -1,
 612044361,
 70361,
 612246656,
 611998334,
 -1,
 -56193,
 612184970,
 70355,
 -1,
 612240969,
 70354,
 612443267,
 612188329,
 -1,
 -56190,
 612381578,
 70331,
 -1,
 612437577,
 70330,
 612639877,
 612382696,
 70322,
 -1,
 612579304,
 70323,
 612770952,
 612571723,
 -1,
 -56185,
 612709258,
 70337,
 -1,
 612765257,
 70336,
 -56183,
 612729378,
 70360,
 -56182,
 612924086,
 70363,
 -56181,
 612979473,
 70328,
 -56180,
 613042904,
 70359,
 -56179,
 613106388,
 70362,
 -56178,
 613168010,
 70366,
 -1,
 613230213,
 70326,
 613426333,
 609362820,
 -1,
 613491859,
 613380001,
 -1,
 -56174,
 613449800,
 70386,
 -1,
 613496616,
 70387,
 613688470,
 613443567,
 -1,
 -56171,
 613629841,
 70390,
 -1,
 613690491,
 70391,
 613885081,
 613625131,
 -1,
 -56168,
 613832901,
 70388,
 -1,
 613891841,
 70389,
 -56166,
 613843894,
 70384,
 -56165,
 614028650,
 70385,
 -56164,
 614093012,
 70393,
 -1,
 614148251,
 70392,
 614343848,
 613383371,
 -1,
 614409378,
 614272585,
 -1,
 -56160,
 614364602,
 70376,
 -56159,
 614414312,
 70374,
 -1,
 614469193,
 70368,
 614671524,
 614364602,
 70371,
 -1,
 614626746,
 70372,
 614802598,
 614610920,
 70369,
 -1,
 614741992,
 70370,
 -56153,
 614748945,
 70375,
 -1,
 614868613,
 70373,
 615120895,
 614296422,
 -1,
 -56150,
 615021639,
 70378,
 -56149,
 615076523,
 70377,
 -1,
 615125776,
 70367,
 615326973,
 609309751,
 -1,
 615392485,
 615270103,
 -1,
 615457973,
 615326035,
 -1,
 615523507,
 615391571,
 -1,
 -56143,
 615461770,
 70167,
 -56142,
 615522782,
 70172,
 -1,
 615583305,
 70166,
 -56140,
 615461770,
 70173,
 -1,
 615714377,
 70171,
 615916731,
 615411617,
 -1,
 615982265,
 615870369,
 -1,
 -56136,
 615920522,
 70165,
 -1,
 615976521,
 70164,
 -56134,
 615920522,
 70170,
 -1,
 616107593,
 70169,
 616309952,
 615862021,
 -1,
 -56131,
 616268322,
 70163,
 -56130,
 616320874,
 70168,
 -56129,
 616378647,
 70157,
 -1,
 616435273,
 70174,
 616637636,
 616238665,
 70144,
 -56126,
 616592826,
 70151,
 -56125,
 616642536,
 70149,
 -1,
 616697417,
 70145,
 616899784,
 616575217,
 -1,
 -56122,
 616838026,
 70156,
 -56121,
 616902935,
 70155,
 -1,
 616959561,
 70154,
 617161932,
 616830493,
 -1,
 -56118,
 617100170,
 70179,
 -56117,
 617158190,
 70178,
 -1,
 617221705,
 70177,
 617424079,
 617110142,
 -1,
 -56114,
 617362314,
 70176,
 -1,
 617418313,
 70175,
 617620690,
 617366170,
 -1,
 -56111,
 617562836,
 70187,
 -1,
 617614921,
 70183,
 617817301,
 617562281,
 -1,
 -56108,
 617755530,
 70153,
 -1,
 617811529,
 70152,
 618013912,
 617758709,
 -1,
 -56105,
 617955339,
 70161,
 -1,
 618008137,
 70160,
 618210523,
 617945675,
 -1,
 -56102,
 618148746,
 70159,
 -1,
 618204745,
 70158,
 -56100,
 618168866,
 70181,
 -56099,
 618363574,
 70184,
 -56098,
 618427834,
 70147,
 -56097,
 618489932,
 70185,
 -56096,
 618553404,
 70182,
 -56095,
 618615569,
 70150,
 -56094,
 618679000,
 70180,
 -56093,
 618739688,
 70146,
 -56092,
 618804106,
 70186,
 -1,
 618866309,
 70148,
 619062511,
 615349451,
 -1,
 619128042,
 618991177,
 -1,
 -56088,
 619083194,
 70195,
 -56087,
 619132904,
 70193,
 -1,
 619187785,
 70188,
 619390188,
 619067368,
 70189,
 -1,
 619329512,
 70190,
 -56083,
 619345338,
 70191,
 -56082,
 619467537,
 70194,
 -1,
 619521669,
 70192,
 619717878,
 619014127,
 -1,
 619783413,
 619657774,
 -1,
 -56078,
 619740231,
 70197,
 -56077,
 619801098,
 70199,
 -56076,
 619860651,
 70198,
 -1,
 619909904,
 70196,
 -1,
 619718546,
 70203,
 620176635,
 619651411,
 -1,
 620242170,
 620124238,
 -1,
 -56071,
 620194051,
 70204,
 -1,
 620241477,
 70201,
 -1,
 620171855,
 70200,
 -56068,
 620134628,
 70202,
 -1,
 620433104,
 70205,
 620691455,
 615271664,
 -1,
 620700974,
 620568300,
 -1,
 620766472,
 620654497,
 -1,
 620832003,
 620720423,
 -1,
 -56062,
 620778257,
 983938,
 -1,
 620826185,
 983936,
 621028614,
 620770172,
 -1,
 -56059,
 620974865,
 983943,
 -1,
 621022793,
 983941,
 -56057,
 620974865,
 983942,
 -1,
 621153865,
 983940,
 621356301,
 620711685,
 -1,
 -56054,
 621314848,
 983934,
 -56053,
 621368081,
 983944,
 -56052,
 621425360,
 983929,
 -1,
 621481545,
 983939,
 621683987,
 621297833,
 -1,
 621749521,
 621622140,
 -1,
 -56048,
 621695761,
 983928,
 -1,
 621743689,
 983926,
 -56046,
 621695761,
 983927,
 -1,
 621874761,
 983925,
 622077209,
 621615691,
 -1,
 622142743,
 622015356,
 -1,
 -56042,
 622088977,
 983933,
 -1,
 622136905,
 983931,
 -56040,
 622088977,
 983932,
 -1,
 622267977,
 983930,
 622470429,
 622028783,
 -1,
 -56037,
 622422092,
 983955,
 -56036,
 622474122,
 983954,
 -1,
 622530121,
 983956,
 622732578,
 622418558,
 -1,
 622798113,
 622670716,
 -1,
 -56032,
 622744337,
 983948,
 -1,
 622792265,
 983946,
 -1,
 622744337,
 983947,
 623060261,
 622674586,
 -1,
 -56028,
 623006481,
 983952,
 -1,
 623054409,
 983958,
 623256872,
 622993747,
 -1,
 -56025,
 623203089,
 983937,
 -1,
 623251017,
 983935,
 -56023,
 623215392,
 983950,
 -56022,
 623410280,
 983953,
 -56021,
 623470224,
 983951,
 -56020,
 623529496,
 983949,
 -56019,
 623588234,
 983957,
 -1,
 623646254,
 983945,
 623846708,
 620641082,
 -1,
 623912241,
 623798244,
 983961,
 -1,
 623870422,
 983962,
 624099327,
 623861502,
 -1,
 -56013,
 623998394,
 983960,
 -1,
 624043653,
 983963,
 624295935,
 623803595,
 -1,
 -56010,
 624186543,
 983964,
 -56009,
 624238122,
 983959,
 -1,
 624299664,
 983965,
 624502092,
 609226313,
 -1,
 624567624,
 624455817,
 -1,
 624633152,
 624498649,
 -1,
 -56004,
 624588218,
 983973,
 -56003,
 624644881,
 983975,
 -56002,
 624703464,
 983972,
 -56001,
 624764549,
 983974,
 -1,
 624823881,
 983971,
 625082367,
 624561737,
 -1,
 625091911,
 624966962,
 -1,
 625157445,
 625045409,
 -1,
 -55996,
 625112506,
 983977,
 -1,
 625169169,
 983978,
 -55994,
 625105534,
 983979,
 -1,
 625286045,
 983976,
 -1,
 625041801,
 110592,
 625550667,
 624513360,
 -1,
 -55990,
 625503084,
 3201,
 -1,
 625559277,
 983203,
 -1,
 625479342,
 128331,
 625812822,
 624441320,
 -1,
 625878357,
 625765822,
 128143,
 625943892,
 625818612,
 -1,
 626009427,
 625880402,
 128535,
 626130943,
 625935714,
 -1,
 -55982,
 626027733,
 128537,
 -1,
 626073087,
 128538,
 -1,
 625941341,
 128573,
 -1,
 625869471,
 128139,
 -1,
 625823326,
 128088,
 626468185,
 625749284,
 128273,
 -55976,
 626399961,
 128287,
 -1,
 626465019,
 128422,
 -1,
 626414396,
 128040,
 626730585,
 609189094,
 -1,
 626795994,
 626658889,
 -1,
 626861513,
 626745615,
 -1,
 626926981,
 626814047,
 -1,
 626992483,
 626885078,
 -1,
 627058017,
 626947514,
 71875,
 -1,
 626999285,
 71886,
 -55966,
 627004177,
 71877,
 -1,
 627117641,
 71876,
 627320169,
 626930556,
 -1,
 627385703,
 627266321,
 -1,
 -55962,
 627337034,
 71899,
 -1,
 627394854,
 71898,
 -55960,
 627326952,
 71897,
 -1,
 627512153,
 71900,
 627713389,
 627248713,
 71873,
 -55957,
 627666849,
 71893,
 -55956,
 627724406,
 71882,
 -1,
 627788431,
 71894,
 627975537,
 627648133,
 71880,
 628097023,
 627920645,
 -1,
 -55952,
 627999190,
 71885,
 -1,
 628051717,
 71888,
 628237684,
 627930554,
 -1,
 -55949,
 628192698,
 71879,
 -1,
 628234827,
 71887,
 628434295,
 628189167,
 -1,
 -55946,
 628387639,
 71901,
 -1,
 628439659,
 71902,
 628630905,
 628380433,
 71881,
 -1,
 628564600,
 71889,
 628761980,
 628576005,
 -1,
 -55941,
 628717572,
 71891,
 -1,
 628764954,
 71872,
 -55939,
 628719320,
 71874,
 -55938,
 628915299,
 71903,
 -55937,
 628978905,
 71890,
 -55936,
 629038670,
 71896,
 -55935,
 629096987,
 71884,
 -55934,
 629160555,
 71878,
 -55933,
 629223703,
 71883,
 -55932,
 629285342,
 71892,
 -1,
 629348846,
 71895,
 629548461,
 626858721,
 -1,
 629613963,
 629506518,
 -1,
 629679497,
 629568954,
 71843,
 -1,
 629620725,
 71854,
 -55926,
 629625617,
 71845,
 -1,
 629739081,
 71844,
 629941649,
 629551996,
 -1,
 630007183,
 629887761,
 -1,
 -55922,
 629958474,
 71867,
 -1,
 630016294,
 71866,
 -55920,
 629948392,
 71865,
 -1,
 630133593,
 71868,
 630334869,
 629870153,
 71841,
 -55917,
 630288289,
 71861,
 -55916,
 630345846,
 71850,
 -1,
 630409871,
 71862,
 630597017,
 630269573,
 71848,
 630718463,
 630542085,
 -1,
 -55912,
 630620630,
 71853,
 -1,
 630673157,
 71856,
 630859164,
 630551994,
 -1,
 -55909,
 630814138,
 71847,
 -1,
 630856267,
 71855,
 631055775,
 630810607,
 -1,
 -55906,
 631009079,
 71869,
 -1,
 631061099,
 71870,
 631252385,
 631001873,
 71849,
 -1,
 631186040,
 71857,
 631383460,
 631197445,
 -1,
 -55901,
 631339012,
 71859,
 -1,
 631386394,
 71840,
 -55899,
 631340760,
 71842,
 -55898,
 631536739,
 71871,
 -55897,
 631600345,
 71858,
 -55896,
 631660110,
 71864,
 -55895,
 631718427,
 71852,
 -55894,
 631781995,
 71846,
 -55893,
 631845143,
 71851,
 -55892,
 631906782,
 71860,
 -1,
 631970286,
 71863,
 632169915,
 629482372,
 -1,
 632235441,
 632123297,
 -1,
 -55888,
 632193096,
 71906,
 -1,
 632239912,
 71907,
 632432052,
 632186863,
 -1,
 -55885,
 632373137,
 71910,
 -1,
 632433787,
 71911,
 632628663,
 632368427,
 -1,
 -55882,
 632576197,
 71908,
 -1,
 632635137,
 71909,
 -55880,
 632587190,
 71904,
 -55879,
 632771946,
 71905,
 -55878,
 632836308,
 71913,
 -1,
 632891547,
 71912,
 633087432,
 632115889,
 -1,
 633152960,
 633040801,
 -1,
 -55874,
 633110029,
 71915,
 -55873,
 633157238,
 71916,
 -1,
 633219413,
 71914,
 633415107,
 633104367,
 -1,
 -55870,
 633356240,
 71919,
 -1,
 633416875,
 71920,
 633611718,
 633351467,
 -1,
 -55867,
 633558942,
 71917,
 -1,
 633616734,
 71918,
 -55865,
 633557252,
 71922,
 -1,
 633743567,
 71921,
 -1,
 633033903,
 71935,
 634004943,
 626815245,
 -1,
 634070478,
 633929728,
 -1,
 -55860,
 634027408,
 127754,
 -55859,
 634068491,
 128702,
 -1,
 634132981,
 128003,
 -1,
 634014896,
 127817,
 634398163,
 633961537,
 -1,
 -55855,
 634355345,
 127987,
 -55854,
 634401854,
 128075,
 -1,
 634460256,
 127988,
 634660310,
 634356128,
 -1,
 -55851,
 634598007,
 127764,
 -1,
 634658816,
 127762,
 634856921,
 634605835,
 -1,
 -55848,
 634794615,
 127766,
 -1,
 634855424,
 127768,
 -1,
 634809899,
 128465,
 635119126,
 626735080,
 -1,
 635184654,
 635052692,
 -1,
 635250153,
 635137327,
 -1,
 635315683,
 635207209,
 -1,
 -55841,
 635272103,
 129159,
 -55840,
 635325488,
 129143,
 -55839,
 635389941,
 129127,
 -55838,
 635450709,
 129151,
 -1,
 635508405,
 129135,
 635764735,
 635250471,
 -1,
 -55835,
 635665319,
 129158,
 -55834,
 635718704,
 129142,
 -55833,
 635783157,
 129126,
 -55832,
 635843925,
 129150,
 -1,
 635901621,
 129134,
 636102134,
 635195839,
 -1,
 636167664,
 636059177,
 -1,
 -55828,
 636124071,
 129156,
 -55827,
 636177456,
 129140,
 -55826,
 636241909,
 129124,
 -55825,
 636302677,
 129148,
 -1,
 636360373,
 129132,
 636616703,
 636102439,
 -1,
 -55822,
 636517287,
 129157,
 -55821,
 636570672,
 129141,
 -55820,
 636635125,
 129125,
 -55819,
 636695893,
 129149,
 -1,
 636753589,
 129133,
 636954108,
 636057948,
 -1,
 -55816,
 636910503,
 129153,
 -55815,
 636963888,
 129137,
 -55814,
 637028341,
 129121,
 -55813,
 637089109,
 129145,
 -1,
 637146805,
 129129,
 637347330,
 636904688,
 -1,
 -55810,
 637303719,
 129154,
 -55809,
 637357104,
 129138,
 -55808,
 637421557,
 129122,
 -55807,
 637482325,
 129146,
 -1,
 637540021,
 129130,
 637740552,
 637290006,
 -1,
 -55804,
 637696935,
 129152,
 -55803,
 637750320,
 129136,
 -55802,
 637814773,
 129120,
 -55801,
 637875541,
 129144,
 -1,
 637933237,
 129128,
 638189567,
 637674910,
 -1,
 -55798,
 638090151,
 129155,
 -55797,
 638143536,
 129139,
 -55796,
 638207989,
 129123,
 -55795,
 638268757,
 129147,
 -1,
 638326453,
 129131,
 638526996,
 635129605,
 -1,
 638592530,
 638460245,
 -1,
 -55791,
 638524595,
 127888,
 -1,
 638589144,
 127788,
 -55789,
 638534108,
 128521,
 -1,
 638723737,
 127863,
 -55787,
 638476873,
 128430,
 -1,
 638857731,
 11838,
 639051327,
 635057020,
 -1,
 639116862,
 638992116,
 -1,
 639182371,
 639068143,
 -1,
 639247902,
 639137767,
 127779,
 639369215,
 639172608,
 -1,
 639378973,
 639244065,
 127781,
 -1,
 639305443,
 127782,
 -1,
 639336371,
 127780,
 639631359,
 639197004,
 -1,
 639641122,
 639508282,
 -1,
 -55775,
 639597549,
 128916,
 -1,
 639650910,
 128917,
 -1,
 639572532,
 128307,
 639903274,
 639115603,
 -1,
 639968807,
 639851067,
 -1,
 -55770,
 639911214,
 128407,
 -1,
 639964758,
 128071,
 640221183,
 639907988,
 -1,
 -55767,
 640121818,
 128922,
 -1,
 640175170,
 128923,
 640362030,
 639845018,
 -1,
 -55764,
 640309848,
 128928,
 -55763,
 640362583,
 128072,
 -1,
 640423227,
 128326,
 640624177,
 640299900,
 -1,
 -55760,
 640558956,
 9989,
 -1,
 640619417,
 128427,
 640820788,
 640560427,
 -1,
 -55757,
 640768267,
 11214,
 -1,
 640829958,
 128174,
 641017399,
 640750626,
 -1,
 -55754,
 640972184,
 129197,
 -1,
 641029482,
 129196,
 -55752,
 640972888,
 128070,
 -55751,
 641168285,
 128382,
 -55750,
 641229818,
 128073,
 -55749,
 641294291,
 10068,
 -55748,
 641358821,
 127985,
 -55747,
 641412332,
 10069,
 -1,
 641473779,
 128906,
 -1,
 639045958,
 128011,
 641738317,
 638997265,
 -1,
 641803849,
 641682063,
 -1,
 641869384,
 641733122,
 128105,
 641934919,
 641820657,
 -1,
 -55740,
 641886351,
 128097,
 -55739,
 641938666,
 128082,
 -55738,
 641998354,
 128090,
 -1,
 642062669,
 128098,
 -1,
 641860997,
 128111,
 -1,
 641804788,
 128698,
 642393676,
 641753070,
 -1,
 -55733,
 642343815,
 128543,
 -1,
 642401341,
 128506,
 -1,
 642336643,
 128058,
 642655829,
 641672837,
 -1,
 642721361,
 642594792,
 -1,
 -55728,
 642658914,
 127947,
 -1,
 642722594,
 983230,
 642917972,
 642651256,
 -1,
 -55725,
 642854226,
 128553,
 -1,
 642915141,
 128576,
 -1,
 642851455,
 128146,
 643180120,
 642605038,
 -1,
 -55721,
 643115396,
 128295,
 -1,
 643175234,
 127873,
 -1,
 643121141,
 983225,
 643442478,
 626679790,
 -1,
 643507892,
 643381224,
 983153,
 643573409,
 643445311,
 -1,
 643638930,
 643530054,
 -1,
 643704437,
 643592097,
 -1,
 643769971,
 643654503,
 -1,
 643835506,
 643696526,
 -1,
 643901040,
 643765276,
 11106,
 644022271,
 643825664,
 -1,
 644032110,
 643923760,
 -1,
 644097638,
 643975510,
 -1,
 -55707,
 644053332,
 11173,
 -1,
 644097428,
 11175,
 644294249,
 644031569,
 -1,
 -55704,
 644250507,
 983234,
 -1,
 644298478,
 11132,
 -55702,
 644250557,
 129074,
 -55701,
 644435844,
 129058,
 -55700,
 644500561,
 129062,
 -55699,
 644560230,
 129070,
 -1,
 644618532,
 129066,
 -55697,
 643986173,
 11122,
 -1,
 644766102,
 11138,
 -55695,
 643848895,
 11142,
 -1,
 644883045,
 11116,
 -1,
 643760302,
 129170,
 -55692,
 643727496,
 11246,
 -1,
 645093022,
 129187,
 645277309,
 643634229,
 -1,
 645342841,
 645229643,
 -1,
 -55688,
 645297173,
 129026,
 -1,
 645343885,
 129042,
 -55686,
 645288410,
 129178,
 -55685,
 645483628,
 129030,
 -55684,
 645546915,
 129034,
 -1,
 645606029,
 129046,
 645801603,
 645207581,
 -1,
 645867137,
 645743335,
 -1,
 -55680,
 645799252,
 11146,
 -1,
 645862428,
 11157,
 -55678,
 645814292,
 129185,
 -1,
 645992283,
 129193,
 646194822,
 645752815,
 -1,
 -55675,
 646143827,
 129082,
 -1,
 646189777,
 129106,
 646391433,
 646143982,
 -1,
 -55672,
 646337404,
 128622,
 -1,
 646396395,
 129189,
 646588044,
 646329678,
 -1,
 -55669,
 646520476,
 129090,
 -1,
 646583324,
 129094,
 646784655,
 646524203,
 -1,
 -55666,
 646735571,
 129195,
 -1,
 646790325,
 129078,
 -55664,
 646741611,
 129174,
 -55663,
 646923743,
 129191,
 -1,
 646979228,
 129086,
 647177884,
 643563520,
 -1,
 647243417,
 647130447,
 -1,
 647308952,
 647172378,
 128360,
 647430143,
 647234914,
 -1,
 -55657,
 647328213,
 128362,
 -1,
 647386521,
 128361,
 -1,
 647243644,
 128489,
 -55654,
 647197059,
 128493,
 -55653,
 647574600,
 128381,
 -1,
 647631486,
 128495,
 647888895,
 647104362,
 -1,
 -55650,
 647787268,
 8295,
 -55649,
 647847229,
 128270,
 -55648,
 647902337,
 9957,
 -1,
 647966050,
 1421,
 648160943,
 643503844,
 127872,
 648282111,
 648085628,
 -1,
 648292006,
 648181805,
 -1,
 -55643,
 648242076,
 11187,
 -1,
 648299774,
 11186,
 648488617,
 648242082,
 -1,
 -55640,
 648443946,
 11189,
 -1,
 648488207,
 11191,
 648685228,
 648430851,
 -1,
 -55637,
 648640554,
 11188,
 -1,
 648684815,
 11190,
 648937471,
 648619284,
 -1,
 -55634,
 648831900,
 11185,
 -1,
 648889598,
 11184,
 649078449,
 648106102,
 128141,
 -1,
 649018361,
 128365,
 649265151,
 649010080,
 -1,
 -55629,
 649142221,
 127832,
 -1,
 649205381,
 127833,
 649406187,
 643442309,
 -1,
 649471696,
 649343633,
 -1,
 -55625,
 649429819,
 127487,
 -55624,
 649494998,
 127486,
 -55623,
 649560390,
 127485,
 -55622,
 649624806,
 127484,
 -55621,
 649689772,
 127483,
 -55620,
 649754042,
 127482,
 -55619,
 649818017,
 127481,
 -55618,
 649881583,
 127480,
 -55617,
 649945070,
 127479,
 -55616,
 650010366,
 127478,
 -55615,
 650074750,
 127477,
 -55614,
 650138385,
 127476,
 -55613,
 650202885,
 127475,
 -55612,
 650267279,
 127474,
 -55611,
 650330778,
 127473,
 -55610,
 650395817,
 127472,
 -55609,
 650461173,
 127471,
 -55608,
 650524648,
 127470,
 -55607,
 650589052,
 127469,
 -55606,
 650653937,
 127468,
 -55605,
 650718507,
 127467,
 -55604,
 650782341,
 127466,
 -55603,
 650846547,
 127465,
 -55602,
 650910283,
 127464,
 -55601,
 650974749,
 127463,
 -1,
 651038281,
 127462,
 651241185,
 649427628,
 -1,
 651306720,
 651176733,
 -1,
 651372250,
 651239765,
 -1,
 651437782,
 651325981,
 -1,
 -55595,
 651393170,
 128402,
 -1,
 651437417,
 128403,
 -55593,
 651394079,
 128404,
 -55592,
 651583646,
 128401,
 -55591,
 651637856,
 128405,
 -1,
 651697784,
 11841,
 651952127,
 651296768,
 -1,
 651962078,
 651839402,
 -1,
 -55587,
 651907053,
 983151,
 -1,
 651964995,
 128968,
 -55585,
 651901784,
 983152,
 -1,
 652090479,
 128639,
 -1,
 651252897,
 128158,
 652355300,
 651195646,
 -1,
 -55581,
 652305308,
 11153,
 -1,
 652363006,
 11152,
 652551911,
 652286539,
 -1,
 -55578,
 652501483,
 128665,
 -1,
 652564310,
 983112,
 -55576,
 652504826,
 128699,
 -55575,
 652692982,
 127895,
 -55574,
 652756969,
 128524,
 -1,
 652812632,
 127822,
 653010693,
 649334345,
 -1,
 653076220,
 652949480,
 -1,
 653141752,
 653027613,
 -1,
 653207282,
 653079596,
 9995,
 653328383,
 653133154,
 -1,
 -55567,
 653220719,
 128406,
 -1,
 653274729,
 128400,
 653469429,
 653150863,
 -1,
 -55564,
 653402537,
 127339,
 -1,
 653466199,
 127338,
 -55562,
 653405844,
 9994,
 -55561,
 653599778,
 11827,
 -1,
 653663864,
 11828,
 653862651,
 653085310,
 -1,
 -55558,
 653816773,
 128740,
 -1,
 653859633,
 128643,
 -1,
 653807509,
 127752,
 654124798,
 653009827,
 128251,
 -1,
 654049557,
 128280,
 654255873,
 654056678,
 -1,
 -55552,
 654200425,
 127949,
 -1,
 654252849,
 127950,
 654452483,
 654186207,
 128007,
 -1,
 654377439,
 128048,
 -55548,
 654405537,
 128000,
 -1,
 654527119,
 128015,
 654714646,
 652956433,
 -1,
 654780169,
 654669810,
 -1,
 -55544,
 654733468,
 128907,
 -1,
 654794451,
 128205,
 654976780,
 654733475,
 -1,
 -55541,
 654933660,
 11215,
 -1,
 654985261,
 11213,
 655173390,
 654928108,
 127801,
 -1,
 655127769,
 127989,
 655304465,
 655116511,
 -1,
 -55536,
 655253488,
 127906,
 -1,
 655303119,
 128478,
 -55534,
 655261146,
 128675,
 -55533,
 655447986,
 128019,
 -55532,
 655498682,
 128640,
 -55531,
 655563091,
 129302,
 -1,
 655627466,
 127840,
 655828776,
 654669242,
 -1,
 655894310,
 655773445,
 -1,
 655959843,
 655833283,
 -1,
 656025376,
 655896669,
 -1,
 656090909,
 655953481,
 -1,
 -55524,
 656026444,
 5880,
 -1,
 656087627,
 5879,
 -55522,
 656037795,
 5876,
 -55521,
 656227933,
 5877,
 -1,
 656287880,
 5878,
 -55519,
 655976877,
 5874,
 -55518,
 656430663,
 5875,
 -1,
 656490665,
 5873,
 656736255,
 655904517,
 -1,
 -55515,
 656620668,
 127933,
 -1,
 656681635,
 127939,
 -55513,
 655831427,
 127945,
 -1,
 656808088,
 8381,
 657008429,
 655770266,
 -1,
 -55510,
 656954129,
 983222,
 -55509,
 657017487,
 983217,
 -55508,
 657078248,
 983227,
 -1,
 657139333,
 983219,
 -1,
 656959471,
 983113,
 657401828,
 643387141,
 -1,
 657467253,
 657335941,
 -1,
 657532774,
 657404255,
 -1,
 657598284,
 657485223,
 -1,
 657663817,
 657540090,
 -1,
 -55500,
 657621819,
 127369,
 -55499,
 657686998,
 127368,
 -55498,
 657752390,
 127367,
 -55497,
 657816806,
 127366,
 -55496,
 657881772,
 127365,
 -55495,
 657946042,
 127364,
 -55494,
 658010017,
 127363,
 -55493,
 658073583,
 127362,
 -55492,
 658137070,
 127361,
 -55491,
 658202366,
 127360,
 -55490,
 658264849,
 127358,
 -55489,
 658329349,
 127357,
 -55488,
 658391209,
 127354,
 -55487,
 658454504,
 127352,
 -55486,
 658518908,
 127351,
 -55485,
 658583793,
 127350,
 -55484,
 658648363,
 127349,
 -55483,
 658712197,
 127348,
 -55482,
 658776403,
 127347,
 -55481,
 658840139,
 127346,
 -55480,
 658904605,
 127345,
 -1,
 658968137,
 127344,
 -55478,
 657620448,
 127375,
 -55477,
 659103816,
 10062,
 -1,
 659164839,
 127374,
 659367781,
 657530136,
 -1,
 -55474,
 659325755,
 127337,
 -55473,
 659390934,
 127336,
 -55472,
 659456326,
 127335,
 -55471,
 659520742,
 127334,
 -55470,
 659585708,
 127333,
 -55469,
 659649978,
 127332,
 -55468,
 659713953,
 127331,
 -55467,
 659777519,
 127330,
 -55466,
 659841006,
 127329,
 -55465,
 659906302,
 127328,
 -55464,
 659968785,
 127326,
 -55463,
 660033285,
 127325,
 -55462,
 660097679,
 127324,
 -55461,
 660161178,
 127323,
 -55460,
 660226217,
 127322,
 -55459,
 660291573,
 127321,
 -55458,
 660355048,
 127320,
 -55457,
 660418801,
 127318,
 -55456,
 660483371,
 127317,
 -55455,
 660547205,
 127316,
 -55454,
 660611411,
 127315,
 -55453,
 660675147,
 127314,
 -55452,
 660739613,
 127313,
 -1,
 660803145,
 127312,
 -1,
 659296123,
 983091,
 661071728,
 657489126,
 -1,
 661137260,
 660996096,
 -1,
 661202795,
 661081699,
 -1,
 -55446,
 661159750,
 127770,
 -1,
 661221234,
 127761,
 -1,
 661145721,
 983063,
 661464943,
 661080190,
 -1,
 -55442,
 661414812,
 11155,
 -1,
 661472510,
 11154,
 -1,
 661417288,
 128240,
 -55439,
 661029294,
 983130,
 -55438,
 661682838,
 128528,
 -55437,
 661741988,
 129299,
 -55436,
 661799578,
 983131,
 -1,
 661855708,
 128084,
 662054829,
 657395273,
 -1,
 662120361,
 661984974,
 -1,
 662185884,
 662062807,
 -1,
 662251394,
 662122045,
 -1,
 -55430,
 662209315,
 67724,
 -55429,
 662268614,
 67740,
 -55428,
 662328042,
 67732,
 -55427,
 662391990,
 67730,
 -55426,
 662455097,
 67728,
 -55425,
 662520099,
 67726,
 -55424,
 662582536,
 67718,
 -55423,
 662640489,
 67714,
 -1,
 662704458,
 67712,
 662906759,
 662202351,
 -1,
 662972294,
 662834761,
 -1,
 -55419,
 662916267,
 67734,
 -1,
 662971181,
 67737,
 -1,
 662910530,
 67741,
 663234442,
 662859681,
 -1,
 -55415,
 663170020,
 67723,
 -1,
 663229936,
 67742,
 663431052,
 663172360,
 67719,
 -1,
 663384359,
 67722,
 663562127,
 663359049,
 -1,
 -55410,
 663519914,
 67735,
 -1,
 663570123,
 67713,
 -55408,
 663520166,
 67721,
 -55407,
 663716643,
 67725,
 -55406,
 663780774,
 67720,
 -55405,
 663839479,
 67739,
 -55404,
 663904038,
 67738,
 -55403,
 663968682,
 67736,
 -55402,
 664031978,
 67733,
 -55401,
 664095926,
 67731,
 -55400,
 664159033,
 67729,
 -55399,
 664224035,
 67727,
 -55398,
 664285835,
 67716,
 -55397,
 664347171,
 67717,
 -1,
 664409961,
 67715,
 664610728,
 662131377,
 -1,
 664676259,
 664563617,
 -1,
 664741793,
 664632550,
 -1,
 -55392,
 664687377,
 67752,
 -1,
 664742463,
 67758,
 -55390,
 664680232,
 67753,
 -1,
 664873301,
 67757,
 665069477,
 664622442,
 67751,
 -1,
 664994338,
 67759,
 665255935,
 665005355,
 -1,
 -55385,
 665147589,
 67754,
 -1,
 665206529,
 67756,
 -1,
 664543359,
 67755,
 -55382,
 662074046,
 127966,
 -55381,
 665406457,
 128219,
 -55380,
 665469097,
 983092,
 -1,
 665533053,
 128133,
 665724890,
 662000401,
 -1,
 665790403,
 665673710,
 -1,
 665855938,
 665743655,
 -1,
 665921473,
 665780224,
 -1,
 665987001,
 665878057,
 -1,
 666052534,
 665935135,
 -1,
 -55372,
 666008631,
 128600,
 -55371,
 666059998,
 128592,
 -1,
 666114545,
 128608,
 666314680,
 666006619,
 11110,
 -1,
 666240305,
 11126,
 -1,
 666265758,
 129108,
 666566655,
 665921319,
 -1,
 666576830,
 666459423,
 -1,
 -55364,
 666532919,
 128602,
 -55363,
 666584286,
 128594,
 -1,
 666638833,
 128610,
 666838976,
 666530907,
 11111,
 -1,
 666764593,
 11127,
 -1,
 666790046,
 129109,
 -1,
 665855823,
 128746,
 -1,
 665789302,
 8379,
 667166670,
 665714688,
 -1,
 667232199,
 667114110,
 -1,
 -55354,
 667172311,
 128370,
 -1,
 667232220,
 128695,
 667428810,
 667162141,
 -1,
 -55351,
 667378106,
 983126,
 -1,
 667433245,
 128691,
 -55349,
 667380975,
 128685,
 -55348,
 667571634,
 128286,
 -55347,
 667635227,
 128245,
 -1,
 667691572,
 128683,
 667887576,
 667119521,
 -1,
 667953109,
 667821701,
 128456,
 668018642,
 667883848,
 128211,
 -1,
 667944413,
 128212,
 668205055,
 667943848,
 -1,
 -55340,
 668086675,
 128457,
 -1,
 668148051,
 128458,
 668401663,
 667884669,
 -1,
 -55337,
 668296248,
 128324,
 -1,
 668353884,
 128323,
 -55335,
 667838700,
 128067,
 -1,
 668487507,
 128689,
 668674014,
 665679290,
 -1,
 668739549,
 668615322,
 983041,
 -1,
 668680858,
 983040,
 -1,
 668692390,
 128297,
 668936161,
 668603933,
 -1,
 -55328,
 668888382,
 983196,
 -1,
 668939132,
 983127,
 -55326,
 668880794,
 983223,
 -55325,
 669074074,
 983066,
 -1,
 669137371,
 127747,
 669329558,
 657335941,
 -1,
 669394976,
 669270682,
 -1,
 669460506,
 669324992,
 -1,
 669525996,
 669404933,
 -1,
 -55319,
 669466675,
 66837,
 -55318,
 669525637,
 66835,
 -55317,
 669590149,
 66821,
 -1,
 669650505,
 66836,
 669853682,
 669462769,
 -1,
 669919216,
 669791100,
 -1,
 -55313,
 669853317,
 66853,
 -1,
 669913564,
 66854,
 -55311,
 669859891,
 66827,
 -1,
 670049925,
 66826,
 670246901,
 669811515,
 -1,
 -55308,
 670184712,
 66852,
 -1,
 670246533,
 66851,
 670443512,
 670199713,
 -1,
 -55305,
 670381320,
 66846,
 -1,
 670443141,
 66845,
 670640123,
 670394351,
 -1,
 -55302,
 670577928,
 66844,
 -1,
 670639749,
 66843,
 670836734,
 670588910,
 -1,
 -55299,
 670785975,
 66842,
 -1,
 670836357,
 66841,
 671033345,
 670778010,
 -1,
 -55296,
 670975104,
 66833,
 -1,
 671032965,
 66832,
 671229956,
 670974121,
 -1,
 -55293,
 671167752,
 66855,
 -1,
 671229573,
 66831,
 671426566,
 671164037,
 66824,
 -1,
 671365096,
 66823,
 671557641,
 671359315,
 -1,
 -55288,
 671495432,
 66822,
 -1,
 671557253,
 66820,
 671754252,
 671488587,
 -1,
 -55285,
 671692040,
 66819,
 -1,
 671753861,
 66818,
 -55283,
 671711702,
 66850,
 -55282,
 671908227,
 66849,
 -55281,
 671972060,
 66848,
 -55280,
 672036282,
 66847,
 -55279,
 672096026,
 66840,
 -55278,
 672160682,
 66839,
 -55277,
 672224017,
 66838,
 -55276,
 672287734,
 66834,
 -55275,
 672350259,
 66830,
 -55274,
 672413672,
 66829,
 -55273,
 672478472,
 66828,
 -55272,
 672542160,
 66825,
 -55271,
 672601850,
 66817,
 -1,
 672665161,
 66816,
 672923647,
 669394565,
 -1,
 672933919,
 672800948,
 -1,
 -55267,
 672887657,
 128294,
 -55266,
 672947426,
 128268,
 -1,
 673007622,
 128161,
 -1,
 672881729,
 128024,
 673261646,
 669347745,
 -1,
 673327180,
 673199706,
 -1,
 673392713,
 673279812,
 -1,
 673458226,
 673325395,
 -1,
 673523755,
 673415995,
 -1,
 673589287,
 673457797,
 43797,
 -1,
 673523333,
 43796,
 -55256,
 673543610,
 43793,
 -55255,
 673665809,
 43798,
 -55254,
 673724392,
 43794,
 -1,
 673779341,
 43795,
 674037759,
 673456932,
 -1,
 674048046,
 673916549,
 43789,
 -1,
 673982085,
 43788,
 -55249,
 674002362,
 43785,
 -55248,
 674124561,
 43790,
 -55247,
 674183144,
 43786,
 -1,
 674238093,
 43787,
 674441274,
 673389464,
 -1,
 674506805,
 674375301,
 43813,
 -1,
 674440837,
 43812,
 674637879,
 674434633,
 43808,
 -1,
 674565705,
 43811,
 -55240,
 674592186,
 43809,
 -55239,
 674714385,
 43814,
 -1,
 674772968,
 43810,
 674965570,
 674371292,
 -1,
 675031101,
 674899589,
 43821,
 -1,
 674965125,
 43820,
 675162175,
 674958921,
 43816,
 -1,
 675089993,
 43819,
 -55232,
 675116474,
 43817,
 -55231,
 675238673,
 43822,
 -1,
 675297256,
 43818,
 675545087,
 674919651,
 -1,
 675555397,
 675423877,
 43781,
 -1,
 675489413,
 43780,
 -55226,
 675509690,
 43777,
 -55225,
 675631889,
 43782,
 -55224,
 675690472,
 43778,
 -1,
 675745421,
 43779,
 676003839,
 673324627,
 -1,
 -55221,
 675904697,
 4958,
 -1,
 675951014,
 4957,
 -55219,
 673284422,
 983047,
 -1,
 676075037,
 983096,
 676276320,
 673206021,
 -1,
 676341851,
 676208981,
 -1,
 676407386,
 676287421,
 -1,
 676472917,
 676360097,
 -1,
 676538452,
 676421914,
 983048,
 -1,
 676462829,
 983095,
 -1,
 676474137,
 983046,
 -55210,
 676423975,
 983134,
 -55209,
 676683313,
 983178,
 -55208,
 676744225,
 983099,
 -55207,
 676808825,
 983064,
 -1,
 676868917,
 983177,
 -1,
 676364143,
 128282,
 677128286,
 676297499,
 -1,
 -55203,
 677070946,
 128388,
 -1,
 677127665,
 128233,
 677380095,
 677076734,
 983051,
 -1,
 677279619,
 983050,
 677455983,
 676219535,
 -1,
 677521513,
 677404233,
 -1,
 677587046,
 677466599,
 128453,
 677707775,
 677512104,
 -1,
 -55195,
 677589395,
 128454,
 -1,
 677650771,
 128455,
 677849192,
 677534390,
 128460,
 -1,
 677799919,
 128461,
 -1,
 677782527,
 128459,
 678100991,
 677467160,
 -1,
 -55189,
 677972998,
 127999,
 -55188,
 678038364,
 127998,
 -55187,
 678103744,
 127997,
 -55186,
 678169095,
 127996,
 -1,
 678234399,
 127995,
 678439036,
 677413190,
 -1,
 678504571,
 678392766,
 -1,
 678570106,
 678439231,
 -1,
 678635637,
 678526551,
 -1,
 -55180,
 678587808,
 128915,
 -1,
 678632684,
 128905,
 678832248,
 678586351,
 -1,
 -55177,
 678772639,
 128954,
 -1,
 678826404,
 128942,
 -55175,
 678769435,
 128935,
 -1,
 678964920,
 128948,
 -1,
 678499595,
 128125,
 -1,
 678452757,
 128529,
 679291013,
 678368089,
 128066,
 679356546,
 679244074,
 -1,
 679422081,
 679284297,
 -1,
 -55168,
 679373595,
 127759,
 -1,
 679431423,
 127758,
 -1,
 679357541,
 127757,
 679739391,
 679281396,
 -1,
 -55164,
 679633782,
 127806,
 -1,
 679693083,
 127805,
 679880840,
 679248466,
 128065,
 -55161,
 679831535,
 128064,
 -1,
 679883444,
 128083,
 680077452,
 679831535,
 -1,
 680142987,
 680008267,
 983104,
 -1,
 680071973,
 983103,
 -1,
 680070729,
 983135,
 680339600,
 680022801,
 -1,
 -55154,
 680292257,
 983049,
 -55153,
 680348303,
 983100,
 -1,
 680411802,
 983067,
 680601747,
 680294910,
 -1,
 -55150,
 680549798,
 127972,
 -1,
 680598334,
 127984,
 -55148,
 680557375,
 127794,
 -55147,
 680745632,
 983179,
 -1,
 680789921,
 128231,
 680995158,
 669266812,
 -1,
 681060586,
 680928901,
 -1,
 681126120,
 680988233,
 -1,
 681191647,
 681082082,
 -1,
 681257129,
 681142255,
 -1,
 681322658,
 681204090,
 -1,
 681388191,
 681279023,
 -1,
 -55138,
 681344055,
 128605,
 -1,
 681384433,
 128613,
 681639935,
 681322285,
 -1,
 -55135,
 681540663,
 128607,
 -1,
 681581041,
 128615,
 681781413,
 681262996,
 -1,
 -55132,
 681733520,
 128952,
 -1,
 681794828,
 128972,
 681978024,
 681709129,
 -1,
 -55129,
 681923110,
 128635,
 -1,
 681986645,
 128940,
 -1,
 681910311,
 128625,
 682240178,
 681198234,
 -1,
 682305709,
 682187276,
 -1,
 -55124,
 682257372,
 10079,
 -1,
 682304617,
 10080,
 682502320,
 682240115,
 -1,
 -55121,
 682443655,
 129052,
 -1,
 682502797,
 129048,
 -55119,
 682441084,
 128627,
 -1,
 682628411,
 128327,
 682830010,
 682167881,
 -1,
 682895545,
 682780525,
 -1,
 682961080,
 682841450,
 129180,
 683081727,
 682885120,
 -1,
 -55113,
 682979696,
 129183,
 -1,
 683029493,
 129182,
 -1,
 682915224,
 129181,
 -1,
 682839714,
 128628,
 683354305,
 682774975,
 -1,
 683419838,
 683310639,
 -1,
 -55107,
 683375671,
 128604,
 -1,
 683416049,
 128612,
 683671551,
 683353901,
 -1,
 -55104,
 683572279,
 128606,
 -1,
 683612657,
 128614,
 683813064,
 683286867,
 -1,
 683878599,
 683758353,
 -1,
 683944134,
 683835444,
 -1,
 -55099,
 683885447,
 129055,
 -1,
 683944589,
 129051,
 -1,
 683886805,
 128178,
 -1,
 683818877,
 10135,
 684271821,
 683747489,
 -1,
 684337356,
 684219651,
 -1,
 -55093,
 684285041,
 128977,
 -1,
 684333192,
 128975,
 -1,
 684289424,
 128958,
 684599504,
 684228183,
 -1,
 -55089,
 684551584,
 128913,
 -1,
 684596460,
 128903,
 684796115,
 684554624,
 -1,
 -55086,
 684737415,
 129053,
 -1,
 684796557,
 129049,
 684992726,
 684750166,
 -1,
 -55083,
 684940401,
 128980,
 -1,
 684988552,
 128979,
 685189337,
 684942621,
 -1,
 -55080,
 685130631,
 129054,
 -1,
 685189773,
 129050,
 685385948,
 685125278,
 -1,
 -55077,
 685338000,
 128946,
 -1,
 685399308,
 128970,
 -55075,
 685333741,
 10133,
 -55074,
 685526532,
 10134,
 -1,
 685587741,
 128633,
 685779175,
 681140206,
 -1,
 685844710,
 685731747,
 -1,
 685910245,
 685801264,
 -1,
 -55069,
 685863631,
 127892,
 -55068,
 685925231,
 128157,
 -1,
 685970460,
 128152,
 -1,
 685843103,
 128159,
 -1,
 685770692,
 128585,
 -1,
 685712919,
 127911,
 -55063,
 681075067,
 127807,
 -1,
 686311360,
 128641,
 686500120,
 680988233,
 -1,
 686565647,
 686452641,
 -1,
 686631182,
 686514442,
 -1,
 686696711,
 686573271,
 -1,
 686762227,
 686647279,
 -1,
 686827762,
 686689865,
 -1,
 -55055,
 686771371,
 67822,
 -1,
 686826285,
 67825,
 -1,
 686765634,
 67828,
 687089910,
 686714785,
 -1,
 -55051,
 687025124,
 67816,
 -1,
 687085040,
 67829,
 687286520,
 687027464,
 67812,
 -1,
 687239463,
 67815,
 687417595,
 687214153,
 -1,
 -55046,
 687375125,
 67823,
 -1,
 687425227,
 67808,
 -55044,
 687375276,
 67814,
 -55043,
 687571747,
 67817,
 -55042,
 687635878,
 67813,
 -55041,
 687693606,
 67826,
 -55040,
 687758250,
 67824,
 -55039,
 687821546,
 67821,
 -55038,
 687885494,
 67820,
 -55037,
 687948601,
 67819,
 -55036,
 688013603,
 67818,
 -55035,
 688075403,
 67810,
 -55034,
 688136746,
 67811,
 -1,
 688199529,
 67809,
 688455679,
 686641841,
 -1,
 688466187,
 688353185,
 -1,
 -55030,
 688422413,
 67838,
 -1,
 688466261,
 67837,
 688662797,
 688412010,
 67835,
 -1,
 688587298,
 67839,
 -1,
 688598681,
 67836,
 -1,
 686562489,
 128035,
 688924948,
 686508687,
 -1,
 688990482,
 688868588,
 128296,
 -1,
 688914521,
 128736,
 -55021,
 688942645,
 128057,
 -1,
 689052183,
 127828,
 -55019,
 688873884,
 128436,
 -55018,
 689200624,
 128587,
 -55017,
 689262544,
 128092,
 -1,
 689323584,
 128135,
 689514813,
 686445329,
 -1,
 689580328,
 689463278,
 -1,
 689645860,
 689520620,
 -1,
 689711395,
 689598369,
 -1,
 689776930,
 689639079,
 -1,
 689842465,
 689731494,
 983059,
 689963007,
 689766400,
 -1,
 -55008,
 689864540,
 983140,
 -1,
 689924502,
 983137,
 -1,
 689767001,
 11134,
 -1,
 689725536,
 128677,
 -1,
 689641579,
 11203,
 690356223,
 689596652,
 128014,
 690421759,
 690225152,
 -1,
 -55001,
 690315343,
 127943,
 -1,
 690367826,
 128052,
 690563374,
 689534394,
 -1,
 690628909,
 690514159,
 -1,
 690694444,
 690559485,
 127968,
 -1,
 690644975,
 127960,
 -1,
 690650960,
 127969,
 -1,
 690578234,
 9203,
 690956595,
 690515873,
 -1,
 691022130,
 690880512,
 -1,
 -54991,
 690969597,
 127798,
 -1,
 691020808,
 127789,
 -1,
 690956515,
 127976,
 691284279,
 690897562,
 -1,
 691349814,
 691227086,
 128616,
 -1,
 691274289,
 128617,
 -1,
 691283589,
 128371,
 691546426,
 691228768,
 -1,
 -54983,
 691476239,
 128029,
 -1,
 691536884,
 127855,
 -54981,
 691498370,
 127973,
 -54980,
 691690110,
 983123,
 -1,
 691739845,
 128298,
 691939663,
 689453032,
 -1,
 692005190,
 691888237,
 -1,
 692070725,
 691935193,
 -1,
 -54975,
 692024762,
 983968,
 -54974,
 692081425,
 983970,
 -54973,
 692140008,
 983967,
 -54972,
 692201093,
 983969,
 -1,
 692260425,
 983966,
 -1,
 691999626,
 110593,
 692529486,
 691941910,
 -1,
 692595019,
 692455274,
 -1,
 692660554,
 692546928,
 128644,
 -1,
 692585843,
 128645,
 -1,
 692598158,
 128096,
 692912127,
 692518912,
 -1,
 -54963,
 692802454,
 983122,
 -1,
 692853192,
 128262,
 -1,
 692459530,
 127802,
 693119315,
 691893690,
 -1,
 -54959,
 693070411,
 128559,
 -54958,
 693129174,
 128175,
 -1,
 693187064,
 129303,
 693436415,
 693071777,
 983060,
 -54955,
 693331951,
 983138,
 -1,
 693387253,
 983141,
 693578225,
 680931569,
 -1,
 693643730,
 693526510,
 -1,
 693709245,
 693571145,
 -1,
 693774779,
 693654159,
 -1,
 693840285,
 693716695,
 -1,
 693905765,
 693795500,
 -1,
 693971297,
 693850970,
 -1,
 694036831,
 693919726,
 70411,
 -1,
 693985262,
 70496,
 694222847,
 693977754,
 70412,
 -1,
 694108826,
 70497,
 694298980,
 693905383,
 -1,
 -54941,
 694232153,
 70495,
 -1,
 694293264,
 70494,
 -1,
 694226505,
 70453,
 694561131,
 693858209,
 -1,
 694626665,
 694513569,
 -1,
 -54936,
 694563722,
 70432,
 -1,
 694619721,
 70431,
 -54934,
 694563722,
 70437,
 -1,
 694750793,
 70436,
 694954352,
 694505221,
 -1,
 -54931,
 694911522,
 70430,
 -54930,
 694964074,
 70435,
 -54929,
 695021847,
 70425,
 -1,
 695078473,
 70440,
 695282038,
 694886739,
 -1,
 695347572,
 695214419,
 -1,
 -54925,
 695284618,
 70434,
 -1,
 695340617,
 70433,
 -54923,
 695284618,
 70439,
 -1,
 695471689,
 70438,
 695675258,
 695209545,
 70405,
 -54920,
 695629242,
 70420,
 -54919,
 695678952,
 70416,
 -1,
 695733833,
 70406,
 695937406,
 695625711,
 -1,
 -54916,
 695887948,
 70455,
 -54915,
 695939978,
 70454,
 -1,
 695995977,
 70456,
 696199552,
 695891386,
 70409,
 -1,
 696153530,
 70410,
 696330627,
 696146558,
 -1,
 -54910,
 696267658,
 70443,
 -1,
 696323657,
 70442,
 696527238,
 696271514,
 -1,
 -54907,
 696468180,
 70451,
 -1,
 696520265,
 70450,
 696723849,
 696467625,
 -1,
 -54904,
 696660874,
 70422,
 -1,
 696716873,
 70421,
 696920460,
 696664053,
 -1,
 -54901,
 696857482,
 70429,
 -1,
 696913481,
 70428,
 697117070,
 696858600,
 70407,
 -1,
 697055208,
 70408,
 697248145,
 697053425,
 -1,
 -54896,
 697185162,
 70424,
 -1,
 697241161,
 70423,
 697444756,
 697178699,
 -1,
 -54893,
 697381770,
 70427,
 -1,
 697437769,
 70426,
 697641367,
 697374237,
 -1,
 -54890,
 697578378,
 70445,
 -1,
 697634377,
 70444,
 -54888,
 697598498,
 70447,
 -54887,
 697786428,
 70448,
 -54886,
 697849415,
 70419,
 -54885,
 697912024,
 70446,
 -54884,
 697971594,
 70457,
 -1,
 698034157,
 70415,
 698231213,
 693796043,
 -1,
 698296739,
 698186859,
 -1,
 698362273,
 698245102,
 70467,
 -1,
 698310638,
 70468,
 698548223,
 698303130,
 70498,
 -1,
 698434202,
 70499,
 698624423,
 698224201,
 -1,
 -54875,
 698578362,
 70476,
 -54874,
 698628072,
 70472,
 -1,
 698682953,
 70462,
 698886569,
 698578362,
 70465,
 -1,
 698840506,
 70466,
 699017643,
 698824680,
 70463,
 -1,
 698955752,
 70464,
 -54868,
 698963527,
 70475,
 -1,
 699082733,
 70471,
 699279801,
 698182502,
 -1,
 699345329,
 699235356,
 -1,
 -54864,
 699295935,
 70403,
 -1,
 699359493,
 70477,
 699541940,
 699275851,
 -1,
 -54861,
 699487449,
 70400,
 -1,
 699535967,
 70401,
 699738551,
 699469385,
 -1,
 -54858,
 699693753,
 70461,
 -1,
 699749102,
 70402,
 -54856,
 699686135,
 70493,
 -1,
 699880107,
 70460,
 -54854,
 699225263,
 70480,
 -1,
 699995545,
 70487,
 -54852,
 693722160,
 127815,
 -1,
 700130865,
 127891,
 700328393,
 693643245,
 -1,
 700393925,
 700268715,
 -1,
 700459458,
 700344303,
 -1,
 -54847,
 700416766,
 65952,
 -1,
 700464439,
 65932,
 -54845,
 700405128,
 65931,
 -54844,
 700598043,
 43877,
 -1,
 700652302,
 895,
 700907519,
 700337927,
 -1,
 -54841,
 700790063,
 128154,
 -54840,
 700848456,
 128215,
 -1,
 700912464,
 127823,
 701114831,
 700266472,
 -1,
 701180366,
 701059419,
 -1,
 701245901,
 701115730,
 128512,
 -1,
 701171460,
 128513,
 -1,
 701176695,
 128568,
 -1,
 701123311,
 128556,
 701562879,
 701059857,
 -1,
 -54831,
 701464319,
 128151,
 -1,
 701528197,
 983109,
 701704672,
 693577349,
 -1,
 701770207,
 701650801,
 -1,
 701835737,
 701712087,
 -1,
 -54826,
 701789709,
 983924,
 -54825,
 701842139,
 4351,
 -54824,
 701904096,
 4350,
 -1,
 701960179,
 4349,
 702163420,
 701787231,
 -1,
 -54821,
 702120725,
 11559,
 -1,
 702156787,
 11565,
 702414847,
 702094049,
 -1,
 -54818,
 702317333,
 4295,
 -1,
 702353395,
 4301,
 -1,
 701713064,
 128142,
 702622182,
 701658554,
 -1,
 702687716,
 702562343,
 -1,
 -54813,
 702629695,
 2809,
 -1,
 702680784,
 2800,
 -54811,
 702627555,
 127928,
 -1,
 702813103,
 128130,
 703015401,
 702567185,
 -1,
 -54808,
 702957451,
 127948,
 -1,
 703010013,
 128016,
 703212012,
 702957862,
 -1,
 -54805,
 703168266,
 127775,
 -1,
 703207165,
 127760,
 703408622,
 703151686,
 128103,
 -1,
 703359043,
 128714,
 -54801,
 703358959,
 983110,
 -54800,
 703477511,
 128123,
 -1,
 703533510,
 127922,
 703736411,
 693513515,
 -1,
 703801877,
 703663689,
 -1,
 703867407,
 703732299,
 -1,
 703932942,
 703800967,
 -1,
 703998473,
 703889195,
 -1,
 704064008,
 703922176,
 -1,
 704129531,
 704016140,
 128539,
 704249855,
 704053263,
 -1,
 -54790,
 704151321,
 128540,
 -1,
 704213591,
 128541,
 704391679,
 704074513,
 -1,
 704457214,
 704338901,
 128558,
 -1,
 704380960,
 128560,
 -1,
 704397498,
 128582,
 704653826,
 704343969,
 -1,
 -54783,
 704591277,
 129298,
 -1,
 704653060,
 128514,
 -54781,
 704603814,
 128580,
 -54780,
 704795005,
 128581,
 -54779,
 704859156,
 128567,
 -54778,
 704924000,
 128548,
 -54777,
 704984335,
 129301,
 -1,
 705044019,
 128531,
 -1,
 704010608,
 128566,
 705309196,
 703948783,
 -1,
 -54773,
 705241058,
 128561,
 -1,
 705304024,
 128523,
 -54771,
 705262055,
 128536,
 -1,
 705448874,
 128134,
 -1,
 703886210,
 127981,
 705702418,
 703824200,
 -1,
 -54767,
 705645287,
 128224,
 -1,
 705706264,
 128439,
 -54765,
 705655115,
 127877,
 -54764,
 705842673,
 128106,
 -1,
 705906915,
 127810,
 706095663,
 703739880,
 -1,
 706161185,
 706043886,
 -1,
 706226716,
 706094725,
 128293,
 706292251,
 706183411,
 -1,
 -54758,
 706242543,
 127878,
 -1,
 706282591,
 127879,
 -1,
 706216400,
 128658,
 706609151,
 706178535,
 -1,
 706619936,
 706502525,
 -1,
 -54753,
 706576198,
 127771,
 -1,
 706637682,
 127763,
 -1,
 706572011,
 8296,
 706882089,
 706101914,
 -1,
 706947622,
 706815623,
 -1,
 -54748,
 706898240,
 983106,
 -54747,
 706948950,
 128193,
 -1,
 707009134,
 128452,
 707264511,
 706890385,
 -1,
 -54744,
 707157543,
 128253,
 -1,
 707211350,
 127902,
 707406382,
 706832367,
 -1,
 707471917,
 707343228,
 128031,
 -54740,
 707411050,
 127907,
 -1,
 707461405,
 127845,
 -1,
 707424469,
 128074,
 -1,
 707340522,
 127953,
 707799612,
 706040593,
 -1,
 707865140,
 707754418,
 -1,
 -54734,
 707812620,
 128966,
 -54733,
 707871971,
 127808,
 -1,
 707927967,
 11156,
 708127288,
 707813358,
 -1,
 708192823,
 708067502,
 127860,
 -1,
 708118231,
 127869,
 -1,
 708135572,
 983071,
 708389434,
 708063473,
 127787,
 -1,
 708326260,
 127745,
 -54725,
 708335627,
 128099,
 -1,
 708461676,
 128448,
 708651591,
 707747822,
 -1,
 708717121,
 708596497,
 -1,
 -54721,
 708673547,
 128550,
 -54720,
 708727403,
 128037,
 -1,
 708784371,
 128056,
 708979269,
 708645326,
 -1,
 -54717,
 708932203,
 128445,
 -54716,
 708992100,
 128444,
 -1,
 709038601,
 128446,
 -54714,
 708917567,
 127844,
 -1,
 709175689,
 127839,
 709372494,
 708592282,
 -1,
 709438027,
 709317393,
 -1,
 -54710,
 709393943,
 127924,
 -1,
 709451239,
 128190,
 -54708,
 709395129,
 128389,
 -54707,
 709589565,
 128563,
 -1,
 709635334,
 128170,
 709831250,
 709328087,
 -1,
 -54704,
 709757447,
 983211,
 -54703,
 709822767,
 983210,
 -1,
 709888147,
 983209,
 710093397,
 709785522,
 -1,
 -54700,
 710049606,
 127773,
 -1,
 710111090,
 127765,
 710290007,
 710043631,
 983107,
 -1,
 710227944,
 983228,
 710421082,
 710223493,
 -1,
 -54695,
 710371159,
 127905,
 -1,
 710415287,
 128552,
 -1,
 710356267,
 983072,
 710683293,
 703690170,
 -1,
 710748822,
 710630014,
 -1,
 710814344,
 710704454,
 -1,
 710879859,
 710766497,
 -1,
 710945394,
 710828903,
 -1,
 711010929,
 710870926,
 -1,
 711076463,
 710939676,
 11105,
 711196671,
 711000064,
 -1,
 711207533,
 711098160,
 -1,
 711273063,
 711149910,
 -1,
 -54682,
 711222501,
 11171,
 -1,
 711280140,
 11170,
 -54680,
 711228349,
 129073,
 -54679,
 711413636,
 129057,
 -54678,
 711478353,
 129061,
 -54677,
 711538022,
 129069,
 -54676,
 711599263,
 11131,
 -1,
 711661860,
 129065,
 -54674,
 711160573,
 11121,
 -1,
 711804512,
 11137,
 -54672,
 711023295,
 11141,
 -1,
 711926373,
 11115,
 -1,
 710934702,
 129169,
 -1,
 710901896,
 11245,
 712256123,
 710808629,
 -1,
 712321655,
 712207435,
 -1,
 -54666,
 712274965,
 129025,
 -1,
 712321677,
 129041,
 -54664,
 712266202,
 129177,
 -54663,
 712461420,
 129029,
 -54662,
 712524707,
 129033,
 -1,
 712583821,
 129045,
 712780414,
 712212062,
 -1,
 -54659,
 712736744,
 129173,
 -1,
 712781937,
 11192,
 712977025,
 712730607,
 -1,
 -54656,
 712925011,
 129081,
 -1,
 712970961,
 129105,
 713173636,
 712914254,
 -1,
 -54653,
 713105052,
 129089,
 -1,
 713167900,
 129093,
 -54651,
 713123479,
 128621,
 -54650,
 713305687,
 129077,
 -54649,
 713367196,
 129085,
 -1,
 713431110,
 11145,
 713632399,
 710739924,
 -1,
 713697932,
 713583691,
 -1,
 -54645,
 713646678,
 128316,
 -1,
 713691337,
 128744,
 -54643,
 713646678,
 128314,
 -54642,
 713838038,
 128742,
 -1,
 713887945,
 128743,
 714091156,
 713555968,
 -1,
 714156691,
 714024212,
 -1,
 -54638,
 714110043,
 11109,
 -1,
 714172574,
 129113,
 -1,
 714085452,
 11193,
 -54635,
 714042194,
 128579,
 -1,
 714365960,
 128319,
 714549916,
 710692613,
 -1,
 714615450,
 714487784,
 -1,
 -54631,
 714567667,
 983115,
 -1,
 714612629,
 129412,
 -54629,
 714546173,
 11217,
 -1,
 714740214,
 128530,
 -1,
 714500079,
 983116,
 715008699,
 710621160,
 -1,
 715074230,
 714952453,
 -1,
 715139750,
 715022055,
 -1,
 715205284,
 715080691,
 -1,
 -54622,
 715156616,
 128289,
 -54621,
 715212618,
 128292,
 -1,
 715266849,
 128288,
 -54619,
 715157401,
 128291,
 -1,
 715412180,
 128290,
 715598510,
 715075434,
 -1,
 715664045,
 715549002,
 -1,
 715729579,
 715616161,
 -1,
 -54614,
 715685960,
 983111,
 -1,
 715732776,
 983108,
 -54612,
 715674986,
 983114,
 -1,
 715861949,
 983105,
 -1,
 715596554,
 128129,
 716122801,
 715530579,
 983129,
 -54608,
 716060845,
 8377,
 -1,
 716123369,
 983128,
 716319412,
 716053067,
 -1,
 -54605,
 716267988,
 128474,
 -1,
 716330236,
 128232,
 -54603,
 716274516,
 9959,
 -1,
 716446101,
 128229,
 716647097,
 715004832,
 -1,
 -54600,
 716584589,
 127954,
 -1,
 716644316,
 127848,
 -54598,
 716604255,
 127982,
 -1,
 716787345,
 128127,
 716974791,
 714948597,
 -1,
 717040325,
 716901961,
 -1,
 717105860,
 716987111,
 -1,
 -54593,
 717057913,
 128304,
 -54592,
 717118886,
 127971,
 -54591,
 717181935,
 128121,
 -54590,
 717238995,
 128122,
 -54589,
 717300764,
 127886,
 -1,
 717364030,
 127983,
 -1,
 717036951,
 127875,
 -54586,
 716986960,
 128377,
 -1,
 717563647,
 128086,
 717761231,
 716931899,
 -1,
 717826766,
 717716710,
 -1,
 717892300,
 717770501,
 -1,
 -54581,
 717832181,
 983214,
 -1,
 717887978,
 983255,
 -54579,
 717843774,
 983213,
 -1,
 718028789,
 983215,
 -1,
 717766051,
 129296,
 718340095,
 717717974,
 -1,
 -54575,
 718223393,
 983235,
 -1,
 718285073,
 128155]
_charnames_1318 = [
6378,
6367,
6376,
6365,
6372,
6361,
6374,
6363,
6377,
6366,
]

_charnames_2112 = [
4980,
4974,
4972,
4973,
4971,
4978,
4963,
4976,
4960,
4962,
4961,
4969,
4968,
4967,
4956,
4977,
4966,
4957,
4965,
4964,
4958,
4959,
4981,
4979,
4970,
4985,
4982,
4984,
-1,
-1,
4983,
]

_charnames_2208 = [
2582,
2583,
2588,
2586,
2590,
2587,
2577,
2573,
2564,
2565,
2571,
2585,
2570,
2576,
2591,
2568,
2589,
2567,
2584,
2592,
2580,
]

_charnames_2275 = [
2607,
2611,
2613,
2609,
2612,
2614,
2610,
2603,
2600,
2606,
2602,
2599,
2605,
2621,
2622,
2620,
2559,
2628,
2629,
2632,
2595,
2616,
2594,
2618,
2624,
2625,
2617,
2626,
2519,
]

_charnames_2383 = [
8963,
-1,
-1,
-1,
-1,
-1,
-1,
8959,
8958,
]

_charnames_3558 = [
1167,
1168,
1159,
1160,
1165,
1166,
1162,
1163,
1170,
1169,
]

_charnames_4295 = [
10717,
-1,
-1,
-1,
-1,
-1,
10718,
]

_charnames_5109 = [
5894,
-1,
-1,
5850,
5849,
5848,
5847,
5846,
5867,
]

_charnames_5873 = [
10018,
10016,
10017,
10013,
10014,
10015,
10012,
10011,
]

_charnames_6832 = [
6087,
6089,
6106,
6088,
6094,
6102,
6103,
6079,
6085,
6036,
6105,
6098,
6084,
6097,
6096,
]

_charnames_7098 = [
1499,
1492,
1493,
1494,
1491,
1490,
3772,
3741,
3767,
3739,
3755,
3771,
3764,
3757,
3736,
3749,
3754,
3760,
3733,
3758,
3768,
3740,
3765,
3769,
3762,
3735,
3751,
3737,
3742,
3746,
3743,
3734,
3753,
3759,
3732,
3747,
3763,
3738,
3745,
3770,
3748,
3756,
3766,
3761,
3791,
3779,
3781,
3780,
3783,
3778,
3782,
3777,
3774,
3775,
3796,
3797,
3794,
3793,
]

_charnames_7360 = [
1482,
1481,
1480,
1486,
1483,
1484,
1485,
1487,
]

_charnames_7411 = [
8695,
8692,
8696,
8694,
-1,
8690,
8691,
]

_charnames_7655 = [
6024,
6021,
6022,
6027,
6030,
6029,
6019,
6028,
6031,
6016,
6026,
6025,
6020,
6017,
6104,
-1,
-1,
-1,
-1,
-1,
-1,
6086,
]

_charnames_8341 = [
6984,
6983,
6982,
6981,
6980,
6979,
6978,
6977,
]

_charnames_9193 = [
4093,
4111,
4119,
4104,
4094,
4112,
4095,
2804,
1537,
7719,
10541,
4061,
4059,
4054,
4063,
8928,
4082,
4079,
]

_charnames_9984 = [
4089,
-1,
-1,
-1,
-1,
9775,
-1,
-1,
-1,
-1,
9973,
9966,
]

_charnames_10060 = [
6388,
-1,
10058,
-1,
-1,
-1,
-1,
4134,
9786,
9788,
]

_charnames_11098 = [
1612,
3875,
1611,
3874,
4189,
1329,
7052,
10849,
9824,
8885,
7102,
10897,
10166,
10174,
1403,
1395,
7069,
10864,
9841,
8901,
6334,
2320,
7066,
10861,
9838,
8897,
-1,
-1,
10167,
10175,
1404,
1396,
7060,
10859,
9832,
8895,
10529,
8685,
7067,
10862,
9839,
8898,
7068,
10863,
9840,
8900,
7083,
10887,
9855,
8922,
2319,
2322,
2321,
2318,
9955,
9954,
10094,
10093,
10803,
9856,
-1,
-1,
7737,
7738,
7736,
7739,
4114,
4120,
4097,
4105,
8890,
8889,
10854,
10853,
7056,
9828,
7057,
9829,
4078,
4077,
4069,
4068,
4074,
4071,
4075,
4072,
9902,
9901,
9893,
9892,
9898,
9895,
9899,
9896,
10877,
10899,
-1,
-1,
-1,
3858,
6410,
6412,
4083,
4108,
7769,
10531,
4135,
4055,
4064,
4062,
4060,
-1,
7821,
4173,
6838,
9995,
9778,
9994,
1474,
10906,
]

_charnames_11559 = [
10714,
-1,
-1,
-1,
-1,
-1,
10715,
]

_charnames_11826 = [
7768,
9974,
9975,
7758,
9006,
9005,
7763,
7820,
7836,
7740,
1535,
8687,
9749,
6281,
8930,
9945,
8929,
]

_charnames_42612 = [
6044,
6045,
6041,
6043,
6049,
6042,
6047,
6048,
]

_charnames_42648 = [
6373,
6362,
6380,
6369,
5184,
5183,
6050,
6046,
]

_charnames_42893 = [
6993,
6919,
7022,
7002,
6949,
7008,
6931,
6930,
6960,
7011,
6889,
7017,
6975,
6989,
6941,
6988,
6940,
6987,
6939,
7005,
6963,
7014,
6974,
7001,
6948,
6999,
6944,
6996,
6877,
7016,
6998,
6995,
7013,
-1,
-1,
6992,
6991,
7015,
7007,
7010,
6888,
7012,
6916,
]

_charnames_43488 = [
5385,
5386,
5384,
5383,
5387,
5409,
5410,
5368,
5380,
5375,
5374,
5372,
5371,
5364,
5363,
5369,
5401,
5402,
5393,
5394,
5399,
5400,
5396,
5397,
5404,
5403,
5379,
5366,
5365,
5378,
5377,
]

_charnames_43744 = [
4650,
4649,
4651,
4644,
4639,
4638,
4648,
4647,
4645,
4642,
4641,
4661,
4660,
4657,
4658,
4656,
4668,
4665,
4664,
4667,
4666,
4659,
4662,
]

_charnames_43777 = [
10309,
10311,
10312,
10308,
10307,
10310,
-1,
-1,
10286,
10288,
10289,
10285,
10284,
10287,
-1,
-1,
10279,
10281,
10282,
10278,
10277,
10280,
]

_charnames_43808 = [
10293,
10295,
10297,
10294,
10292,
10291,
10296,
-1,
10301,
10303,
10305,
10302,
10300,
10299,
10304,
-1,
6886,
6971,
6882,
6885,
6966,
6923,
6871,
6921,
6922,
6920,
6973,
6950,
6965,
6880,
6881,
6912,
6953,
6893,
6894,
6895,
6896,
6875,
7021,
6946,
6967,
6945,
6968,
6869,
6870,
6887,
6904,
6906,
6908,
6900,
6905,
6925,
6927,
6928,
6937,
6933,
6936,
6935,
6972,
5189,
5180,
5177,
5176,
5179,
6876,
6955,
6915,
6907,
6954,
10691,
]

_charnames_43888 = [
5893,
5892,
5891,
5889,
5888,
5887,
5886,
5890,
5885,
5884,
5883,
5882,
5881,
5836,
5835,
5834,
5832,
5831,
5830,
5879,
5878,
5877,
5876,
5875,
5874,
5872,
5871,
5870,
5869,
5868,
5822,
5833,
5823,
5828,
5827,
5826,
5825,
5824,
5865,
5864,
5863,
5862,
5861,
5860,
5820,
5814,
5819,
5818,
5817,
5816,
5815,
5844,
5813,
5843,
5812,
5842,
5811,
5840,
5839,
5838,
5841,
5810,
5809,
5808,
5807,
5806,
5805,
5803,
5802,
5801,
5800,
5799,
5798,
5858,
5857,
5856,
5855,
5854,
5853,
5851,
]

_charnames_64434 = [
2538,
2537,
2528,
2527,
2534,
2533,
2532,
2531,
2545,
2544,
2539,
2526,
2525,
2546,
2542,
2541,
]

_charnames_65063 = [
6035,
6034,
6093,
6092,
6101,
6100,
6054,
6053,
6052,
]

_charnames_66272 = [
6153,
6150,
6142,
6143,
6148,
6149,
6145,
6146,
6152,
6151,
6118,
6114,
6117,
6129,
6132,
6121,
6124,
6137,
6134,
6139,
6113,
6116,
6128,
6131,
6122,
6125,
6138,
6135,
]

_charnames_66384 = [
9197,
9196,
9194,
9172,
9184,
9174,
9171,
9175,
9170,
9165,
9192,
9191,
9190,
9189,
9177,
9188,
9187,
9164,
9181,
9186,
9195,
9162,
9163,
9159,
9154,
9182,
9183,
9185,
9193,
9180,
9178,
9153,
9155,
9157,
9166,
9158,
9156,
9167,
6078,
6077,
6074,
6076,
6075,
]

_charnames_66816 = [
10265,
10264,
10251,
10250,
10248,
10218,
10247,
10245,
10244,
10263,
10225,
10224,
10262,
10261,
10260,
10243,
10240,
10239,
10259,
10217,
10219,
10216,
10258,
10257,
10256,
10237,
10236,
10234,
10233,
10231,
10230,
10255,
10254,
10253,
10252,
10228,
10227,
10222,
10223,
10242,
]

_charnames_66864 = [
6246,
6255,
6239,
6206,
6243,
6211,
6242,
6209,
6215,
6185,
6221,
6210,
6218,
6197,
6231,
6219,
6247,
6205,
6194,
6236,
6234,
6230,
6253,
6224,
6245,
6187,
6188,
6190,
6252,
6225,
6251,
6203,
6198,
6237,
6250,
6213,
6254,
6204,
6186,
6228,
6240,
6249,
6200,
6248,
6214,
6199,
6217,
6191,
6193,
6222,
6227,
6233,
]

_charnames_67072 = [
6465,
6464,
6463,
6462,
6461,
6460,
6459,
6458,
6457,
6509,
6508,
6507,
6506,
6505,
6445,
6435,
6437,
6436,
6432,
6434,
6433,
6438,
6439,
6444,
6443,
6442,
6441,
6824,
6440,
6503,
6502,
6501,
6500,
6499,
6498,
6474,
6473,
6472,
6471,
6470,
6469,
6468,
6467,
6455,
6454,
6453,
6452,
6451,
6450,
6449,
6448,
6447,
6496,
6495,
6494,
6493,
6492,
6491,
6482,
6481,
6480,
6479,
6478,
6477,
6476,
6489,
6488,
6487,
6486,
6485,
6484,
6823,
6524,
6514,
6822,
6513,
6512,
6520,
6519,
6821,
6523,
6522,
6517,
6516,
6521,
6643,
6642,
6641,
6640,
6639,
6638,
6637,
6636,
6635,
6634,
6633,
6630,
6629,
6628,
6621,
6620,
6619,
6627,
6626,
6625,
6624,
6623,
6622,
6698,
6697,
6696,
6695,
6694,
6693,
6692,
6691,
6690,
6689,
6687,
6686,
6685,
6684,
6683,
6682,
6681,
6680,
6679,
6678,
6676,
6675,
6674,
6673,
6672,
6671,
6670,
6669,
6668,
6667,
6665,
6664,
6663,
6662,
6661,
6660,
6659,
6658,
6657,
6656,
6654,
6653,
6652,
6651,
6650,
6649,
6648,
6647,
6646,
6645,
6701,
6700,
6800,
6799,
6798,
6797,
6796,
6795,
6794,
6793,
6792,
6791,
6810,
6809,
6808,
6807,
6806,
6805,
6804,
6803,
6802,
6586,
6585,
6584,
6583,
6582,
6581,
6580,
6579,
6615,
6614,
6613,
6612,
6611,
6610,
6577,
6576,
6575,
6574,
6573,
6572,
6571,
6570,
6569,
6567,
6566,
6565,
6564,
6563,
6562,
6561,
6560,
6559,
6594,
6593,
6592,
6591,
6590,
6589,
6588,
6557,
6556,
6555,
6554,
6553,
6552,
6551,
6550,
6549,
6608,
6607,
6606,
6605,
6604,
6603,
6547,
6546,
6545,
6544,
6543,
6542,
6541,
6540,
6539,
6538,
6536,
6535,
6534,
6533,
6532,
6531,
6530,
6529,
6528,
6527,
6601,
6600,
6599,
6598,
6597,
6596,
6751,
6750,
6749,
6748,
6747,
6746,
6745,
6744,
6713,
6712,
6711,
6710,
6709,
6708,
6707,
6706,
6705,
6704,
6733,
6732,
6731,
6730,
6729,
6728,
6727,
6726,
6725,
6761,
6760,
6759,
6742,
6741,
6740,
6739,
6738,
6737,
6736,
6735,
6723,
6722,
6721,
6720,
6719,
6718,
6717,
6716,
6715,
6757,
6756,
6755,
6754,
6753,
]

_charnames_67392 = [
6778,
6777,
6776,
6775,
6774,
6773,
6772,
6771,
6770,
6769,
6768,
6767,
6766,
6786,
6785,
6784,
6783,
6782,
6781,
6780,
6788,
6787,
]

_charnames_67424 = [
6819,
6818,
6817,
6816,
6815,
6814,
6813,
6812,
]

_charnames_67680 = [
8115,
8129,
8126,
8128,
8111,
8118,
8116,
8112,
8109,
8117,
8125,
8124,
8123,
8127,
8122,
8105,
8114,
8121,
8106,
8120,
8119,
8107,
8110,
8130,
8142,
8141,
8134,
8136,
8139,
8140,
8137,
8135,
10113,
10126,
10112,
10139,
10137,
10138,
10111,
10122,
10129,
10127,
10123,
10120,
10105,
10128,
10110,
10136,
10109,
10135,
10108,
10134,
10107,
10133,
10116,
10125,
10132,
10117,
10131,
10130,
10106,
10118,
10121,
]

_charnames_67751 = [
10147,
10143,
10145,
10150,
10152,
10151,
10146,
10144,
10148,
]

_charnames_67808 = [
10490,
10502,
10500,
10501,
10486,
10493,
10491,
10487,
10484,
10492,
10499,
10498,
10497,
10496,
10480,
10489,
10495,
10481,
10494,
-1,
10482,
10485,
-1,
-1,
-1,
-1,
-1,
10507,
10509,
10506,
10505,
10508,
]

_charnames_67968 = [
4632,
4630,
4628,
4625,
4621,
4622,
4619,
4620,
4624,
4626,
4608,
4609,
4606,
4607,
4614,
4615,
4627,
4617,
4629,
4611,
4612,
4613,
4618,
4623,
4602,
4603,
4600,
4601,
4604,
4631,
4633,
4634,
4561,
4573,
4571,
4568,
4563,
4564,
4575,
4567,
4569,
4557,
4556,
4565,
4570,
4559,
4572,
4554,
4562,
4553,
4560,
4566,
4551,
4550,
4549,
4574,
-1,
-1,
-1,
-1,
4594,
4589,
4577,
4578,
4541,
4480,
4488,
4514,
4522,
4498,
4505,
4535,
4529,
4495,
4485,
4493,
4519,
4527,
4503,
4510,
-1,
-1,
4543,
4482,
4490,
4516,
4524,
4500,
4507,
4537,
4531,
4545,
4484,
4492,
4518,
4526,
4502,
4509,
4539,
4533,
4496,
4486,
4494,
4520,
4528,
4504,
4511,
4540,
4534,
4544,
4483,
4491,
4517,
4525,
4501,
4508,
4538,
4532,
4588,
4581,
4582,
4591,
4592,
4585,
4586,
4595,
4596,
4583,
]

_charnames_68224 = [
9218,
9236,
9219,
9235,
9233,
9230,
9209,
9232,
9238,
9205,
9210,
9216,
9234,
9215,
9231,
9208,
9237,
9227,
9228,
9225,
9222,
9224,
9221,
9206,
9212,
9204,
9229,
9203,
9213,
9243,
9242,
9241,
]

_charnames_68288 = [
4897,
4924,
4923,
4917,
4918,
4921,
4914,
4926,
4952,
4901,
4900,
4913,
4912,
4915,
4893,
4925,
4910,
4904,
4909,
4931,
4920,
4892,
4930,
4929,
4887,
4896,
4898,
4928,
4932,
4888,
4906,
4903,
4907,
4927,
4890,
4889,
4894,
4951,
4950,
-1,
-1,
-1,
-1,
4946,
4948,
4945,
4944,
4947,
4939,
4941,
4937,
4936,
4935,
4938,
4940,
]

_charnames_68480 = [
8298,
8297,
8295,
8296,
8284,
8288,
8286,
8285,
8287,
8294,
8293,
8292,
8291,
8281,
8290,
8282,
8283,
8289,
]

_charnames_68521 = [
8306,
8302,
8304,
8308,
8305,
8303,
8307,
]

_charnames_68736 = [
9119,
9123,
9118,
9121,
9094,
9093,
9095,
9117,
9120,
9088,
9140,
9116,
9115,
9107,
9108,
9114,
9137,
9138,
9113,
9112,
9122,
9127,
9105,
9106,
9103,
9089,
9092,
9128,
9129,
9136,
9133,
9130,
9111,
9104,
9110,
9139,
9101,
9102,
9099,
9090,
9100,
9096,
9124,
9125,
9135,
9132,
9109,
9097,
9098,
9091,
9126,
]

_charnames_68800 = [
9065,
9069,
9064,
9067,
9040,
9039,
9041,
9063,
9066,
9034,
9086,
9062,
9061,
9053,
9054,
9060,
9083,
9084,
9059,
9058,
9068,
9073,
9051,
9052,
9049,
9035,
9038,
9074,
9075,
9082,
9079,
9076,
9057,
9050,
9056,
9085,
9047,
9048,
9045,
9036,
9046,
9042,
9070,
9071,
9081,
9078,
9055,
9043,
9044,
9037,
9072,
]

_charnames_69632 = [
4032,
4033,
4029,
4031,
4030,
3924,
3927,
3946,
3947,
3932,
3933,
3897,
3898,
3899,
3900,
3961,
3926,
3908,
3925,
3942,
3941,
3950,
3949,
3916,
3953,
3952,
3945,
3944,
3914,
3905,
3904,
3921,
3920,
3915,
3907,
3906,
3923,
3922,
3917,
3936,
3935,
3956,
3955,
3959,
3957,
3958,
3939,
3901,
3930,
3929,
3931,
3960,
3938,
3912,
3910,
3911,
4002,
4009,
4005,
4006,
4003,
4004,
3995,
3996,
3997,
3998,
4008,
4001,
4007,
4000,
4010,
4027,
4026,
4040,
4039,
4037,
4041,
4036,
-1,
-1,
-1,
-1,
3983,
3965,
3968,
3978,
3981,
3972,
3974,
3989,
3987,
3970,
3966,
3969,
3979,
3982,
3973,
3975,
3990,
3988,
3986,
3985,
4022,
4023,
4014,
4015,
4020,
4021,
4017,
4018,
4025,
4024,
]

_charnames_69840 = [
1361,
1360,
1373,
1372,
1371,
1370,
1352,
1349,
1365,
1350,
1358,
1363,
1357,
1362,
1369,
1366,
1367,
1348,
1374,
1356,
1368,
1359,
1364,
1355,
1353,
]

_charnames_69872 = [
1385,
1386,
1377,
1378,
1383,
1384,
1380,
1381,
1388,
1387,
-1,
-1,
-1,
-1,
-1,
-1,
5988,
5989,
5987,
5954,
5951,
5946,
5953,
5932,
5931,
5938,
5937,
5916,
5941,
5940,
5935,
5934,
5914,
5910,
5909,
5921,
5920,
5915,
5912,
5911,
5923,
5922,
5917,
5929,
5928,
5944,
5943,
5949,
5925,
5926,
5948,
5950,
5945,
5947,
5952,
5974,
5981,
5982,
5977,
5978,
5983,
5976,
5979,
5975,
5980,
5992,
5994,
5984,
5993,
-1,
5966,
5967,
5958,
5959,
5964,
5965,
5961,
5962,
5969,
5968,
5990,
5971,
5970,
5991,
]

_charnames_69968 = [
5044,
5041,
5036,
5043,
5038,
5022,
5021,
5028,
5027,
5031,
5030,
5025,
5024,
5011,
5001,
5000,
5007,
5006,
5012,
5003,
5002,
5009,
5008,
5013,
5019,
5018,
5034,
5033,
5039,
5016,
5040,
5035,
5037,
5042,
5015,
5047,
5049,
5048,
5045,
]

_charnames_70016 = [
1287,
1282,
1278,
1218,
1221,
1240,
1241,
1226,
1227,
1196,
1197,
1198,
1199,
1256,
1220,
1253,
1219,
1236,
1235,
1244,
1243,
1210,
1247,
1246,
1239,
1238,
1208,
1204,
1203,
1215,
1214,
1209,
1206,
1205,
1217,
1216,
1211,
1230,
1229,
1250,
1249,
1254,
1251,
1252,
1233,
1232,
1200,
1224,
1223,
1225,
1255,
1267,
1270,
1271,
1268,
1269,
1260,
1261,
1262,
1263,
1273,
1266,
1272,
1265,
1279,
1281,
1286,
1283,
1315,
1311,
1310,
1318,
1292,
1294,
1285,
1274,
1313,
1293,
-1,
-1,
1306,
1307,
1298,
1299,
1304,
1305,
1301,
1302,
1309,
1308,
1314,
1284,
1316,
1317,
1291,
1290,
-1,
1154,
1146,
1147,
1152,
1153,
1149,
1150,
1156,
1155,
1132,
1130,
1131,
1140,
1141,
1134,
1135,
1143,
1142,
1138,
1137,
]

_charnames_70144 = [
9408,
9411,
9442,
9437,
9444,
9410,
9440,
9409,
9428,
9427,
9415,
9414,
9413,
9406,
9434,
9433,
9431,
9430,
-1,
9404,
9400,
9399,
9394,
9392,
9405,
9402,
9401,
9396,
9393,
9395,
9407,
9422,
9421,
9419,
9418,
9417,
9441,
9435,
9439,
9425,
9436,
9438,
9443,
9424,
9449,
9450,
9451,
9452,
9454,
9448,
9453,
9447,
9460,
9457,
9459,
9458,
9466,
9465,
9467,
9461,
9464,
9468,
]

_charnames_70272 = [
5274,
5271,
5267,
5273,
5252,
5251,
5258,
-1,
5257,
-1,
5261,
5260,
5255,
5254,
-1,
5244,
5236,
5235,
5230,
5229,
5228,
5245,
5238,
5237,
5232,
5231,
5246,
5249,
5248,
5264,
-1,
5263,
5269,
5265,
5242,
5270,
5266,
5268,
5272,
5240,
5241,
5275,
-1,
-1,
-1,
-1,
-1,
-1,
9317,
9320,
9347,
9348,
9333,
9334,
9358,
9319,
9354,
9318,
9346,
9345,
9328,
9327,
9326,
9315,
9351,
9350,
9324,
9322,
9323,
9313,
9309,
9308,
9303,
9302,
9339,
9301,
9314,
9311,
9310,
9305,
9304,
9316,
9343,
9342,
9332,
9331,
9330,
9355,
9352,
9340,
9356,
9353,
9336,
9337,
9357,
9387,
9377,
9380,
9381,
9378,
9379,
9383,
9376,
9382,
9375,
9386,
9385,
-1,
-1,
-1,
-1,
-1,
9369,
9370,
9361,
9362,
9367,
9368,
9364,
9365,
9372,
9371,
-1,
-1,
-1,
-1,
-1,
-1,
10674,
10675,
10678,
10671,
-1,
10614,
10617,
10636,
10637,
10622,
10623,
10589,
10591,
-1,
-1,
10652,
10616,
-1,
-1,
10649,
10615,
10632,
10631,
10640,
10639,
10606,
10643,
10642,
10635,
10634,
10604,
10600,
10599,
10611,
10610,
10605,
10602,
10601,
10613,
10612,
10607,
-1,
10626,
10625,
10646,
10645,
10650,
10647,
10648,
-1,
10629,
10628,
-1,
10596,
10620,
10619,
10621,
10651,
-1,
-1,
10680,
10677,
10662,
10665,
10666,
10663,
10664,
10655,
10656,
-1,
-1,
10668,
10661,
-1,
-1,
10667,
10660,
10672,
-1,
-1,
10681,
-1,
-1,
-1,
-1,
-1,
-1,
10682,
-1,
-1,
-1,
-1,
-1,
10679,
10595,
10594,
10590,
10592,
10657,
10658,
-1,
-1,
6063,
6065,
6058,
6059,
6061,
6062,
6064,
-1,
-1,
-1,
6071,
6070,
6069,
6067,
6068,
]

_charnames_70784 = [
7695,
7615,
7618,
7634,
7635,
7623,
7624,
7593,
7594,
7595,
7596,
7651,
7617,
7647,
7616,
7630,
7629,
7638,
7637,
7607,
7641,
7640,
7633,
7632,
7605,
7601,
7600,
7612,
7611,
7606,
7603,
7602,
7614,
7613,
7608,
7627,
7626,
7644,
7643,
7648,
7645,
7646,
7649,
7597,
7621,
7620,
7622,
7650,
7661,
7667,
7668,
7662,
7663,
7654,
7655,
7656,
7657,
7670,
7666,
7660,
7669,
7665,
7659,
7693,
7691,
7687,
7688,
7692,
7690,
7698,
7696,
7697,
]

_charnames_70864 = [
7681,
7682,
7673,
7674,
7679,
7680,
7676,
7677,
7684,
7683,
]

_charnames_71040 = [
1009,
1013,
1040,
1041,
1029,
1030,
1004,
1005,
1006,
1007,
1057,
1012,
1053,
1010,
1036,
1035,
1044,
1043,
1017,
1047,
1046,
1039,
1038,
1015,
997,
996,
1022,
1021,
1016,
1001,
1000,
1024,
1023,
1018,
1033,
1032,
1050,
1049,
1054,
1051,
1052,
1055,
1008,
1027,
1026,
1028,
1056,
1097,
1102,
1103,
1100,
1101,
1098,
1099,
-1,
-1,
1105,
1096,
1104,
1095,
1089,
1090,
1085,
1086,
1088,
1087,
1112,
1111,
1081,
1082,
1109,
1108,
1107,
1113,
1064,
1065,
1070,
1069,
1068,
1078,
1079,
1077,
1066,
1076,
1075,
1073,
1072,
1074,
999,
993,
994,
1011,
1093,
1094,
]

_charnames_71168 = [
5090,
5093,
5112,
5113,
5098,
5099,
5068,
5069,
5070,
5071,
5128,
5092,
5125,
5091,
5108,
5107,
5116,
5115,
5082,
5119,
5118,
5111,
5110,
5080,
5076,
5075,
5087,
5086,
5081,
5078,
5077,
5089,
5088,
5083,
5102,
5101,
5122,
5121,
5126,
5123,
5124,
5105,
5072,
5096,
5095,
5097,
5127,
5104,
5138,
5141,
5142,
5139,
5140,
5131,
5132,
5133,
5134,
5144,
5137,
5143,
5136,
5168,
5164,
5165,
5167,
5161,
5160,
5170,
5169,
]

_charnames_71248 = [
5156,
5157,
5148,
5149,
5154,
5155,
5151,
5152,
5159,
5158,
]

_charnames_71296 = [
7509,
7512,
7530,
7531,
7513,
7514,
7547,
7511,
7543,
7510,
7526,
7525,
7534,
7533,
7501,
7537,
7536,
7529,
7528,
7499,
7495,
7494,
7506,
7505,
7500,
7497,
7496,
7508,
7507,
7502,
7523,
7522,
7540,
7539,
7544,
7541,
7520,
7545,
7542,
7516,
7517,
7546,
7519,
7578,
7575,
7566,
7569,
7570,
7567,
7568,
7572,
7565,
7571,
7564,
7576,
7577,
]

_charnames_71360 = [
7558,
7559,
7550,
7551,
7556,
7557,
7553,
7554,
7561,
7560,
]

_charnames_71424 = [
2823,
2822,
2809,
2810,
2817,
2813,
2820,
2819,
2835,
2838,
2826,
2841,
2816,
2837,
2839,
2836,
2808,
2840,
2811,
2832,
2831,
2829,
2814,
2828,
2834,
2825,
-1,
-1,
-1,
2879,
2880,
2878,
2843,
2847,
2850,
2851,
2848,
2849,
2853,
2844,
2852,
2846,
2845,
2874,
-1,
-1,
-1,
-1,
2864,
2865,
2856,
2857,
2862,
2863,
2859,
2860,
2867,
2866,
2883,
2882,
2871,
2872,
2873,
2875,
]

_charnames_71840 = [
9635,
9617,
9636,
9607,
9610,
9609,
9641,
9626,
9621,
9631,
9619,
9642,
9640,
9623,
9608,
9627,
9624,
9632,
9638,
9634,
9643,
9618,
9620,
9644,
9639,
9615,
9614,
9613,
9616,
9629,
9630,
9637,
9595,
9577,
9596,
9567,
9570,
9569,
9601,
9586,
9581,
9591,
9579,
9602,
9600,
9583,
9568,
9587,
9584,
9592,
9598,
9594,
9603,
9578,
9580,
9604,
9599,
9575,
9574,
9573,
9576,
9589,
9590,
9597,
9655,
9656,
9647,
9648,
9653,
9654,
9650,
9651,
9658,
9657,
9663,
9661,
9662,
9668,
9669,
9665,
9666,
9671,
9670,
]

_charnames_72384 = [
8048,
8054,
8066,
8065,
8070,
8060,
8061,
8050,
8067,
8068,
8053,
8062,
8071,
8059,
8045,
8044,
8051,
8047,
8063,
8040,
8058,
8072,
8069,
8055,
8064,
8041,
8042,
8056,
8036,
8039,
8035,
8037,
8031,
8038,
8034,
8032,
8033,
8088,
8086,
8084,
8089,
8090,
8085,
8081,
8079,
8082,
8083,
8091,
8097,
8093,
8094,
8075,
8073,
8095,
8076,
8077,
8098,
]

_charnames_74607 = [
5666,
5723,
5726,
5727,
5581,
5582,
5576,
5569,
5682,
5681,
5606,
5605,
5623,
5620,
5757,
5658,
5657,
5655,
5654,
5664,
5662,
5661,
5660,
5659,
5651,
5516,
5526,
5524,
5522,
5736,
5734,
5646,
5625,
5641,
5640,
5631,
5644,
5762,
5761,
5704,
5749,
5718,
5719,
]

_charnames_74851 = [
5776,
5777,
5770,
5769,
5767,
5768,
5779,
5780,
5773,
5774,
5771,
5781,
-1,
-1,
-1,
-1,
-1,
5782,
]

_charnames_74880 = [
5724,
5725,
5728,
5743,
5742,
5741,
5740,
5744,
5583,
5580,
5574,
5573,
5575,
5555,
5553,
5554,
5564,
5563,
5568,
5547,
5544,
5546,
5545,
5561,
5560,
5567,
5542,
5541,
5539,
5540,
5535,
5533,
5534,
5536,
5551,
5550,
5549,
5566,
5565,
5558,
5557,
5685,
5684,
5687,
5686,
5677,
5676,
5675,
5672,
5673,
5670,
5671,
5674,
5680,
5613,
5603,
5602,
5601,
5612,
5595,
5598,
5597,
5611,
5610,
5592,
5593,
5594,
5609,
5587,
5590,
5589,
5608,
5607,
5614,
5622,
5619,
5617,
5616,
5759,
5758,
5665,
5663,
5652,
5650,
5515,
5485,
5480,
5479,
5484,
5477,
5476,
5483,
5482,
5474,
5473,
5481,
5512,
5511,
5496,
5495,
5490,
5489,
5488,
5497,
5493,
5492,
5502,
5501,
5500,
5505,
5504,
5506,
5460,
5452,
5459,
5458,
5456,
5455,
5457,
5468,
5467,
5470,
5469,
5465,
5464,
5463,
5462,
5513,
5449,
5422,
5435,
5434,
5433,
5432,
5431,
5430,
5429,
5427,
5426,
5425,
5448,
5436,
5447,
5446,
5441,
5442,
5445,
5444,
5443,
5440,
5439,
5509,
5508,
5527,
5525,
5523,
5519,
5520,
5521,
5735,
5733,
5732,
5639,
5632,
5633,
5638,
5637,
5636,
5635,
5634,
5627,
5629,
5628,
5706,
5705,
5703,
5702,
5699,
5695,
5694,
5693,
5692,
5698,
5697,
5707,
5750,
5748,
5747,
5717,
5716,
5714,
5713,
5712,
5755,
5754,
5753,
]

_charnames_82944 = [
2167,
2166,
2165,
2164,
2163,
2162,
2161,
2160,
2159,
2114,
2115,
2124,
2123,
2122,
2121,
2120,
2119,
2118,
2117,
2116,
2112,
2111,
2110,
2109,
2108,
2107,
2102,
2103,
2106,
2105,
2104,
2100,
2099,
2098,
2097,
2096,
2095,
2094,
2093,
2092,
2090,
2091,
2061,
2053,
2054,
2060,
2059,
2058,
2051,
2052,
2048,
2050,
2049,
2057,
2056,
2055,
2157,
2156,
2155,
2154,
2153,
2152,
2151,
2150,
2149,
2148,
2075,
2074,
2073,
2072,
2071,
2070,
2063,
2066,
2065,
2064,
2069,
2068,
2067,
2146,
2145,
2144,
2143,
2142,
2141,
2140,
2139,
2138,
2137,
2135,
2134,
2133,
2132,
2131,
2130,
2129,
2128,
2127,
2126,
2088,
2087,
2086,
2085,
2084,
2083,
2082,
2079,
2080,
2077,
2078,
2081,
1687,
1688,
1685,
1686,
1683,
1684,
1692,
1676,
1679,
1678,
1677,
1680,
1682,
1681,
1691,
1672,
1675,
1674,
1673,
1690,
1689,
1694,
1696,
1695,
1706,
1705,
1704,
1703,
1697,
1698,
1702,
1701,
1700,
1699,
1730,
1729,
1728,
1727,
1726,
1720,
1721,
1725,
1724,
1723,
1722,
1718,
1717,
1716,
1715,
1714,
1708,
1709,
1713,
1712,
1711,
1710,
1796,
1795,
1794,
1793,
1792,
1791,
1790,
1789,
1788,
1787,
1785,
1784,
1783,
1782,
1781,
1780,
1779,
1778,
1777,
1776,
1774,
1773,
1772,
1771,
1770,
1769,
1768,
1767,
1766,
1765,
1763,
1762,
1761,
1760,
1759,
1758,
1757,
1756,
1755,
1754,
1752,
1751,
1750,
1749,
1748,
1747,
1746,
1745,
1744,
1743,
1741,
1740,
1739,
1738,
1737,
1736,
1735,
1734,
1733,
1732,
1939,
1938,
1926,
1928,
1927,
1937,
1936,
1935,
1934,
1931,
1932,
1933,
1929,
1930,
1965,
1964,
1963,
1962,
1961,
1956,
1957,
1954,
1955,
1960,
1959,
1958,
2001,
2000,
1999,
1998,
1997,
1996,
1995,
1991,
1992,
1994,
1993,
2045,
2044,
2043,
2042,
2041,
2040,
2039,
2038,
2037,
2036,
2034,
2033,
2032,
2031,
2030,
2029,
2028,
2027,
2026,
2025,
2023,
2022,
2021,
2020,
2019,
2018,
2017,
2016,
2015,
2014,
1989,
1988,
1987,
1986,
1985,
1984,
1983,
1979,
1980,
1982,
1981,
2012,
2011,
2010,
2009,
2008,
2007,
2006,
2005,
2004,
2003,
1977,
1976,
1975,
1974,
1973,
1972,
1971,
1970,
1969,
1967,
1968,
1952,
1951,
1950,
1949,
1943,
1944,
1948,
1947,
1946,
1945,
1941,
1942,
1890,
1889,
1888,
1887,
1886,
1885,
1884,
1883,
1882,
1880,
1881,
1923,
1922,
1921,
1920,
1919,
1918,
1917,
1916,
1915,
1914,
1878,
1877,
1876,
1875,
1874,
1873,
1872,
1871,
1870,
1868,
1869,
1814,
1813,
1806,
1805,
1804,
1812,
1811,
1810,
1799,
1802,
1801,
1800,
1809,
1808,
1807,
1912,
1911,
1910,
1909,
1908,
1907,
1906,
1905,
1904,
1903,
1866,
1865,
1864,
1863,
1862,
1861,
1860,
1859,
1858,
1856,
1857,
1842,
1841,
1840,
1839,
1833,
1834,
1838,
1837,
1836,
1831,
1832,
1835,
1854,
1844,
1845,
1853,
1852,
1851,
1850,
1849,
1848,
1847,
1846,
1829,
1821,
1822,
1828,
1820,
1819,
1827,
1826,
1816,
1817,
1825,
1824,
1823,
1901,
1900,
1899,
1898,
1897,
1896,
1895,
1894,
1893,
1892,
2271,
2270,
2269,
2268,
2267,
2266,
2265,
2264,
2263,
2262,
2185,
2184,
2194,
2193,
2192,
2191,
2190,
2189,
2188,
2187,
2186,
2260,
2259,
2258,
2257,
2256,
2255,
2254,
2253,
2252,
2251,
2249,
2248,
2247,
2246,
2245,
2244,
2243,
2242,
2241,
2240,
2238,
2237,
2236,
2235,
2234,
2233,
2232,
2231,
2230,
2229,
2172,
2173,
2181,
2180,
2179,
2178,
2177,
2176,
2170,
2171,
2175,
2174,
2227,
2226,
2225,
2224,
2223,
2222,
2221,
2220,
2219,
2218,
2216,
2215,
2214,
2213,
2212,
2211,
2210,
2209,
2208,
2207,
2205,
2204,
2203,
2202,
2201,
2200,
2199,
2198,
2197,
2196,
2280,
2279,
2278,
2277,
2276,
2275,
2274,
2273,
2313,
2312,
2311,
2310,
2309,
2308,
2307,
2306,
2305,
2303,
2302,
2301,
2300,
2299,
2298,
2297,
2296,
2295,
2294,
2292,
2291,
2290,
2289,
2288,
2287,
2286,
2285,
2284,
2283,
2314,
]

_charnames_92160 = [
3458,
3566,
3535,
3536,
3479,
3510,
3555,
3467,
3513,
3532,
3533,
3489,
3551,
3460,
3487,
3494,
3503,
3521,
3454,
3541,
3472,
3519,
3457,
3561,
3560,
3453,
3492,
3527,
3564,
3528,
3499,
3466,
3569,
3565,
3452,
3520,
3504,
3505,
3497,
3545,
3529,
3476,
3538,
3488,
3481,
3537,
3550,
3558,
3518,
3553,
3491,
3542,
3475,
3546,
3498,
3509,
3559,
3572,
3571,
3547,
3517,
3493,
3512,
3450,
3514,
3463,
3525,
3473,
3568,
3459,
3490,
3480,
3502,
3464,
3554,
3516,
3526,
3469,
3486,
3462,
3544,
3470,
3570,
3557,
3482,
3478,
3501,
3606,
3641,
3615,
3616,
3636,
3578,
3625,
3644,
3577,
3626,
3630,
3645,
3634,
3608,
3609,
3647,
3629,
3640,
3613,
3612,
3587,
3580,
3603,
3621,
3648,
3620,
3635,
3631,
3653,
3601,
3598,
3652,
3617,
3642,
3591,
3596,
3597,
3588,
3614,
3581,
3592,
3604,
3628,
3590,
3650,
3579,
3651,
3622,
3585,
3584,
3637,
3599,
3607,
3582,
3624,
3600,
3311,
3348,
3402,
3440,
3309,
3326,
3312,
3435,
3360,
3437,
3352,
3344,
3358,
3430,
3330,
3367,
3386,
3436,
3389,
3403,
3347,
3370,
3321,
3362,
3404,
3397,
3398,
3419,
3331,
3413,
3339,
3409,
3421,
3308,
3442,
3351,
3378,
3345,
3305,
3424,
3363,
3381,
3342,
3411,
3306,
3445,
3325,
3322,
3320,
3446,
3443,
3359,
3444,
3338,
3425,
3408,
3317,
3335,
3393,
3304,
3374,
3371,
3426,
3395,
3337,
3313,
3439,
3307,
3319,
3343,
3396,
3318,
3329,
3377,
3405,
3328,
3416,
3420,
3361,
3375,
3368,
3387,
3357,
3388,
3366,
3401,
3334,
3380,
3379,
3417,
3391,
3392,
3314,
3350,
3427,
3431,
3432,
3412,
3206,
3293,
3153,
3189,
3154,
3267,
3156,
3166,
3147,
3172,
3292,
3141,
3219,
3143,
3238,
3249,
3218,
3159,
3225,
3239,
3284,
3242,
3229,
3191,
3175,
3208,
3200,
3231,
3283,
3157,
3236,
3138,
3253,
3296,
3140,
3298,
3176,
3195,
3262,
3177,
3212,
3197,
3270,
3196,
3188,
3265,
3163,
3204,
3245,
3171,
3251,
3230,
3282,
3237,
3290,
3252,
3139,
3192,
3162,
3235,
3275,
3273,
3169,
3263,
3146,
3193,
3149,
3281,
3276,
3280,
3178,
3181,
3226,
3243,
3151,
3142,
3254,
3201,
3241,
3167,
3250,
3209,
3148,
3261,
3150,
3165,
3158,
3295,
3240,
3287,
3257,
3255,
3170,
3289,
3264,
3202,
3186,
3224,
3211,
3222,
3217,
3244,
3184,
3220,
3182,
3274,
3185,
3221,
3271,
3210,
3266,
3288,
3256,
3183,
3205,
3228,
3299,
2943,
3027,
3007,
3072,
3129,
3067,
2979,
3061,
3116,
2956,
2947,
2975,
3019,
2920,
3086,
3122,
3059,
2929,
2980,
3026,
3079,
3069,
2958,
2935,
2998,
2918,
2934,
2957,
3118,
2952,
2992,
3062,
2924,
3005,
3105,
2919,
2953,
3000,
3066,
2930,
2945,
3020,
3058,
2976,
2941,
2926,
3049,
3106,
3024,
3040,
2993,
3023,
3084,
3060,
3031,
3127,
3124,
3073,
2972,
3017,
3110,
2936,
3056,
3004,
3008,
2961,
2970,
3113,
3022,
3080,
3050,
2963,
3048,
3012,
2946,
2987,
3037,
3075,
3095,
3112,
2915,
3085,
2997,
2921,
3108,
3097,
2966,
2991,
3043,
2928,
2964,
2960,
2994,
3002,
3096,
2969,
3010,
3107,
3093,
3009,
2974,
2916,
3078,
2986,
2967,
3041,
2925,
2983,
3094,
3099,
2950,
3132,
3028,
3130,
3131,
3071,
2982,
3016,
3018,
2942,
3055,
3042,
2931,
3038,
3045,
3046,
3035,
3036,
3083,
2990,
2951,
2977,
3123,
3100,
3128,
3074,
3001,
3119,
3117,
2932,
2937,
3053,
3054,
3092,
2968,
2984,
3068,
3087,
3013,
2996,
2999,
3030,
3088,
3011,
3032,
3098,
3109,
3686,
3724,
3683,
3726,
3691,
3705,
3664,
3716,
3693,
3694,
3701,
3706,
3668,
3660,
3696,
3674,
3673,
3675,
3676,
3682,
3680,
3657,
3656,
3659,
3718,
3671,
3719,
3666,
3710,
3665,
3721,
3711,
3695,
3667,
3689,
3681,
3662,
3663,
3672,
3712,
3725,
3722,
3715,
3714,
3685,
3698,
3690,
3702,
3700,
3699,
3707,
3684,
3677,
3723,
]

_charnames_92736 = [
5306,
5322,
5335,
5324,
5339,
5333,
5340,
5318,
5312,
5329,
5334,
5338,
5313,
5309,
5325,
5321,
5319,
5308,
5307,
5315,
5337,
5304,
5332,
5336,
5331,
5311,
5327,
5326,
5330,
5316,
5305,
-1,
5352,
5353,
5344,
5345,
5350,
5351,
5347,
5348,
5355,
5354,
-1,
-1,
-1,
-1,
5357,
5356,
]

_charnames_92880 = [
3805,
3818,
3828,
3834,
3830,
3808,
3821,
3824,
3817,
3831,
3833,
3810,
3825,
3820,
3823,
3835,
3813,
3827,
3836,
3826,
3809,
3829,
3811,
3837,
3814,
3815,
3812,
3806,
3804,
3832,
-1,
-1,
3844,
3841,
3845,
3840,
3843,
3846,
]

_charnames_92928 = [
7983,
7982,
7979,
7978,
7953,
7952,
7967,
7966,
7985,
7984,
7956,
7955,
7971,
7970,
7950,
7949,
7965,
7964,
7973,
7972,
7977,
7976,
7961,
7960,
7988,
7987,
7959,
7958,
7861,
7846,
7866,
7855,
7848,
7862,
7849,
7863,
7859,
7854,
7865,
7857,
7850,
7853,
7864,
7847,
7851,
7867,
7860,
7858,
8017,
8021,
8024,
8023,
8020,
8025,
8018,
7920,
7922,
7903,
7921,
7926,
7912,
7911,
7910,
7913,
7923,
7934,
7924,
7944,
7916,
7900,
]

_charnames_93008 = [
7999,
8000,
7991,
7992,
7997,
7998,
7994,
7995,
8002,
8001,
-1,
8009,
8012,
8007,
8014,
8013,
8008,
8010,
-1,
7925,
7914,
7941,
7929,
7942,
7940,
7938,
7915,
7937,
7945,
7928,
7933,
7930,
7943,
7935,
7906,
7902,
7898,
7899,
7904,
7905,
-1,
-1,
-1,
-1,
-1,
7872,
7880,
7886,
7887,
7891,
7877,
7889,
7893,
7874,
7873,
7892,
7878,
7890,
7884,
7894,
7881,
7871,
7876,
7883,
]

_charnames_93952 = [
4801,
4812,
4747,
4800,
4804,
4803,
4776,
4811,
4795,
4794,
4714,
4769,
4745,
4746,
4713,
4768,
4725,
4727,
4748,
4774,
4721,
4720,
4783,
4782,
4781,
4780,
4712,
4767,
4711,
4766,
4810,
4792,
4749,
4798,
4797,
4724,
4723,
4773,
4807,
4808,
4791,
4790,
4707,
4762,
4718,
4717,
4708,
4763,
4743,
4750,
4759,
4786,
4785,
4738,
4736,
4709,
4764,
4744,
4787,
4739,
4737,
4734,
4732,
4775,
4733,
4731,
4809,
4777,
4806,
]

_charnames_94032 = [
4726,
4866,
4864,
4865,
4823,
4831,
4830,
4824,
4825,
4845,
4847,
4852,
4851,
4839,
4842,
4843,
4848,
4814,
4815,
4816,
4817,
4819,
4822,
4821,
4818,
4820,
4832,
4833,
4834,
4835,
4836,
4838,
4837,
4849,
4850,
4826,
4827,
4841,
4854,
4840,
4853,
4829,
4844,
4828,
4846,
4855,
4856,
]

_charnames_94095 = [
4859,
4858,
4861,
4860,
4705,
4704,
4703,
4702,
4701,
4700,
4699,
4758,
4757,
4756,
4755,
4754,
4753,
]

_charnames_113664 = [
8823,
8817,
8796,
8791,
8827,
8806,
8801,
8832,
8814,
8819,
8825,
8770,
8800,
8816,
8828,
8809,
8775,
8795,
8738,
8815,
8810,
8737,
8824,
8805,
8774,
8781,
8741,
8752,
8713,
8783,
8748,
8760,
8723,
8785,
8750,
8754,
8755,
8715,
8716,
8786,
8751,
8756,
8725,
8784,
8749,
8761,
8724,
8757,
8758,
8759,
8717,
8718,
8719,
8720,
8793,
8794,
8762,
8766,
8769,
8726,
8727,
8808,
8826,
8721,
8722,
8829,
8734,
8780,
8776,
8830,
8821,
8811,
8822,
8740,
8788,
8813,
8731,
8773,
8732,
8804,
8831,
8787,
8812,
8818,
8790,
8803,
8772,
8789,
8736,
8779,
8777,
8778,
8768,
8763,
8765,
8767,
8764,
8743,
8744,
8745,
8746,
8798,
8799,
8730,
8739,
8735,
8820,
-1,
-1,
-1,
-1,
-1,
8849,
8873,
8874,
8837,
8872,
8852,
8867,
8868,
8864,
8866,
8870,
8869,
8865,
-1,
-1,
-1,
8861,
8857,
8858,
8854,
8859,
8860,
8855,
8856,
8851,
]

_charnames_113808 = [
8843,
8845,
8846,
8839,
8847,
8848,
8840,
8844,
8836,
8842,
-1,
-1,
8876,
8875,
8878,
8877,
1324,
1326,
1325,
1323,
]

_charnames_119262 = [
5295,
5285,
5291,
5293,
5292,
5294,
5288,
5287,
5284,
5283,
5290,
]

_charnames_120832 = [
10,
242,
223,
362,
276,
331,
101,
254,
111,
100,
103,
89,
93,
253,
12,
244,
53,
50,
51,
94,
91,
15,
28,
27,
25,
23,
30,
247,
148,
102,
33,
249,
56,
54,
44,
52,
96,
97,
92,
55,
36,
38,
40,
41,
115,
18,
20,
21,
140,
81,
24,
31,
22,
26,
133,
76,
131,
132,
87,
88,
78,
37,
43,
42,
136,
137,
138,
82,
189,
194,
193,
191,
192,
272,
176,
311,
180,
203,
187,
205,
188,
206,
186,
231,
232,
312,
363,
182,
184,
185,
177,
212,
201,
209,
207,
211,
210,
200,
196,
197,
198,
199,
263,
266,
270,
267,
328,
315,
217,
215,
220,
229,
222,
233,
221,
230,
237,
235,
240,
354,
357,
360,
358,
291,
295,
274,
313,
294,
303,
296,
314,
304,
305,
329,
46,
250,
286,
340,
297,
49,
48,
287,
150,
153,
154,
155,
161,
110,
260,
361,
346,
162,
163,
157,
158,
301,
160,
300,
345,
344,
159,
261,
299,
343,
57,
251,
288,
306,
341,
32,
248,
174,
307,
353,
169,
171,
172,
262,
359,
352,
165,
168,
167,
173,
170,
327,
99,
252,
239,
325,
326,
324,
227,
289,
338,
337,
147,
308,
141,
258,
145,
142,
322,
139,
146,
144,
256,
238,
234,
309,
349,
350,
347,
257,
268,
269,
320,
321,
318,
290,
59,
282,
62,
63,
64,
67,
68,
66,
84,
85,
79,
75,
74,
271,
73,
77,
225,
226,
283,
284,
278,
281,
335,
336,
333,
104,
125,
119,
120,
121,
126,
114,
117,
116,
108,
123,
109,
112,
124,
8,
175,
733,
734,
735,
982,
983,
984,
918,
919,
920,
968,
969,
970,
803,
804,
805,
927,
928,
914,
910,
915,
911,
912,
886,
882,
887,
883,
884,
916,
650,
649,
651,
653,
648,
647,
652,
499,
619,
442,
443,
440,
441,
444,
479,
478,
476,
477,
415,
474,
473,
471,
472,
460,
461,
462,
407,
409,
410,
408,
412,
413,
414,
456,
457,
458,
488,
489,
490,
492,
493,
494,
697,
698,
699,
701,
702,
703,
708,
706,
707,
705,
641,
642,
639,
640,
636,
637,
634,
635,
631,
632,
629,
630,
626,
627,
624,
625,
576,
577,
574,
575,
578,
600,
599,
597,
598,
520,
595,
594,
593,
592,
606,
517,
518,
519,
521,
603,
604,
605,
608,
609,
610,
612,
613,
614,
716,
717,
718,
712,
713,
714,
719,
396,
397,
394,
395,
388,
389,
386,
387,
400,
401,
467,
468,
469,
447,
452,
453,
448,
424,
425,
426,
420,
421,
422,
402,
404,
405,
759,
763,
771,
445,
391,
465,
450,
432,
761,
765,
769,
392,
466,
451,
433,
762,
766,
770,
428,
429,
430,
509,
510,
566,
569,
565,
568,
549,
552,
550,
553,
529,
530,
776,
780,
784,
506,
507,
561,
562,
559,
560,
542,
545,
543,
546,
526,
527,
775,
779,
783,
513,
514,
511,
512,
515,
570,
554,
532,
533,
534,
773,
777,
781,
579,
482,
485,
483,
486,
582,
585,
588,
583,
586,
589,
435,
436,
536,
537,
497,
498,
617,
618,
937,
938,
942,
935,
939,
940,
933,
934,
943,
941,
365,
377,
371,
370,
374,
372,
375,
376,
904,
902,
903,
838,
839,
840,
947,
949,
948,
946,
899,
900,
898,
831,
830,
832,
843,
844,
828,
826,
829,
825,
845,
834,
836,
835,
810,
812,
813,
818,
820,
821,
815,
822,
816,
961,
962,
960,
754,
752,
753,
847,
955,
956,
953,
954,
979,
976,
980,
977,
972,
973,
669,
670,
671,
677,
679,
680,
685,
687,
688,
666,
665,
664,
660,
663,
662,
656,
659,
658,
681,
684,
683,
673,
676,
675,
864,
863,
862,
672,
690,
691,
728,
730,
724,
723,
731,
729,
726,
727,
742,
749,
745,
746,
747,
748,
750,
500,
620,
957,
364,
846,
923,
924,
985,
888,
925,
738,
739,
740,
986,
859,
858,
857,
856,
855,
854,
853,
852,
896,
875,
876,
868,
870,
873,
869,
871,
872,
964,
905,
929,
965,
987,
]

_charnames_121499 = [
895,
894,
893,
892,
891,
-1,
801,
800,
799,
798,
797,
796,
795,
794,
793,
792,
791,
790,
789,
788,
787,
]

_charnames_124928 = [
4338,
4337,
4336,
4268,
4235,
4256,
4287,
4352,
4335,
4334,
4333,
4410,
4419,
4423,
4290,
4443,
4391,
4272,
4286,
4396,
4332,
4331,
4330,
4275,
4236,
4379,
4341,
4328,
4327,
4326,
4383,
4233,
4435,
4397,
4325,
4324,
4323,
4369,
4438,
4367,
4387,
4398,
4404,
4400,
4442,
4353,
4319,
4317,
4316,
4370,
4421,
4399,
4253,
4441,
4312,
4311,
4310,
4247,
4259,
4280,
4380,
4427,
4322,
4321,
4320,
4242,
4350,
4349,
4315,
4314,
4313,
4239,
4279,
4434,
4264,
4309,
4308,
4306,
4376,
4424,
4372,
4270,
4356,
4305,
4304,
4303,
4429,
4251,
4393,
4415,
4302,
4301,
4300,
4254,
4257,
4402,
4243,
4440,
4437,
4299,
4298,
4297,
4420,
4363,
4355,
4294,
4344,
4295,
4234,
4293,
4394,
4248,
4408,
4281,
4405,
4244,
4282,
4444,
4289,
4240,
4292,
4249,
4422,
4388,
4377,
4416,
4374,
4409,
4245,
4432,
4347,
4378,
4426,
4364,
4447,
4366,
4365,
4346,
4277,
4354,
4265,
4231,
4284,
4250,
4283,
4436,
4267,
4389,
4271,
4414,
4288,
4342,
4260,
4359,
4357,
4343,
4371,
4433,
4392,
4403,
4238,
4258,
4291,
4430,
4425,
4375,
4412,
4278,
4386,
4237,
4431,
4261,
4262,
4360,
4413,
4407,
4411,
4446,
4418,
4266,
4269,
4381,
4445,
4385,
4401,
4348,
4345,
4382,
4358,
4246,
4390,
4255,
4368,
4276,
4361,
4232,
4273,
-1,
-1,
4458,
4450,
4451,
4456,
4457,
4453,
4454,
4460,
4459,
4467,
4465,
4470,
4468,
4466,
4471,
4472,
]

_charnames_126464 = [
2506,
2518,
2514,
2372,
-1,
2509,
2497,
2515,
2491,
2508,
2504,
2410,
2513,
2512,
2443,
2507,
2517,
2444,
2511,
2510,
2442,
2495,
2493,
2503,
2494,
2373,
2498,
2516,
2370,
2368,
2369,
2367,
-1,
2468,
2464,
-1,
2457,
-1,
-1,
2458,
-1,
2459,
2455,
2463,
2462,
2461,
2448,
2469,
2466,
2449,
2460,
-1,
2447,
2452,
2451,
2454,
-1,
2467,
-1,
2465,
-1,
-1,
-1,
-1,
-1,
-1,
2487,
-1,
-1,
-1,
-1,
2488,
-1,
2482,
-1,
2485,
-1,
2484,
2475,
2490,
-1,
2476,
2483,
-1,
2474,
-1,
-1,
2486,
-1,
2481,
-1,
2489,
-1,
2480,
-1,
2479,
-1,
2440,
2437,
-1,
2430,
-1,
-1,
2431,
2416,
2433,
2428,
-1,
2436,
2435,
2419,
2441,
2439,
2420,
2434,
-1,
2418,
2415,
2414,
2427,
-1,
2425,
2432,
2438,
2424,
-1,
2423,
-1,
2396,
2409,
2406,
2393,
2390,
2399,
2387,
2391,
2381,
2398,
-1,
2404,
2403,
2402,
2384,
2397,
2408,
2385,
2401,
2400,
2383,
2380,
2378,
2405,
2379,
2394,
2388,
2407,
-1,
-1,
-1,
-1,
-1,
2364,
2360,
2350,
-1,
2353,
2347,
2361,
2341,
2352,
-1,
2358,
2357,
2356,
2344,
2365,
2363,
2345,
2355,
2354,
2343,
2340,
2338,
2359,
2339,
2351,
2348,
2362,
]

_charnames_127136 = [
8271,
8265,
8195,
8200,
8212,
8218,
8224,
8229,
8260,
8250,
8205,
8255,
8235,
8245,
8240,
-1,
-1,
8266,
8196,
8201,
8213,
8219,
8225,
8230,
8261,
8251,
8206,
8256,
8236,
8246,
8241,
8273,
-1,
8267,
8197,
8202,
8214,
8220,
8226,
8231,
8262,
8252,
8207,
8257,
8237,
8247,
8242,
8270,
-1,
8268,
8198,
8203,
8215,
8221,
8227,
8232,
8263,
8253,
8208,
8258,
8238,
8248,
8243,
8272,
8216,
8173,
8184,
8193,
8192,
8191,
8190,
8189,
8188,
8187,
8183,
8182,
8181,
8180,
8179,
8178,
8177,
8176,
8175,
8174,
8186,
8185,
]

_charnames_127280 = [
1438,
-1,
1437,
1436,
1435,
1434,
1433,
1432,
1431,
1430,
1429,
1428,
1427,
-1,
1426,
-1,
1425,
1424,
-1,
1423,
1422,
1421,
-1,
1420,
1419,
1418,
-1,
-1,
-1,
-1,
-1,
1465,
10084,
10083,
10082,
10081,
10080,
10079,
10078,
-1,
10077,
10076,
10075,
10074,
10073,
10072,
10071,
-1,
10070,
10069,
10068,
10067,
10066,
10065,
10064,
10063,
10062,
10061,
9972,
9971,
-1,
-1,
-1,
-1,
10056,
10055,
10054,
10053,
10052,
10051,
10050,
10049,
10048,
-1,
10047,
-1,
-1,
10046,
10045,
-1,
10044,
10043,
10042,
10041,
10040,
10039,
10038,
10037,
10036,
10035,
-1,
-1,
-1,
-1,
10059,
10057,
-1,
1458,
1457,
1471,
1470,
1461,
1460,
1469,
1468,
1467,
1466,
]

_charnames_127462 = [
9935,
9934,
9933,
9932,
9931,
9930,
9929,
9928,
9927,
9926,
9925,
9924,
9923,
9922,
9921,
9920,
9919,
9918,
9917,
9916,
9915,
9914,
9913,
9912,
9911,
9910,
-1,
1464,
1463,
]

_charnames_127538 = [
1446,
1445,
1455,
1452,
1450,
1451,
1447,
1456,
1454,
]

_charnames_127744 = [
6381,
10809,
6340,
10211,
1501,
1500,
6415,
1502,
9979,
4044,
9675,
8709,
4879,
10369,
10368,
10367,
10731,
10090,
9685,
10783,
9684,
10836,
9687,
7043,
9688,
6398,
10089,
10782,
7042,
10835,
1504,
10730,
1335,
7750,
4107,
9753,
9757,
9755,
9756,
6346,
6345,
6347,
6344,
10808,
9745,
10545,
7586,
4207,
5901,
1652,
10387,
8984,
8143,
6283,
10544,
7774,
5896,
9996,
10574,
1503,
4143,
10372,
10371,
10472,
10802,
5061,
10772,
7119,
5300,
7825,
2888,
10683,
4692,
9678,
7580,
7117,
3869,
8385,
9962,
10696,
8358,
8359,
5897,
1528,
10515,
1609,
4693,
8319,
9906,
9907,
6172,
5785,
1533,
1566,
4049,
10822,
10005,
9009,
9293,
1507,
10821,
10796,
1410,
1319,
10936,
8932,
6171,
6009,
6270,
7141,
5790,
10553,
1332,
4188,
8327,
6170,
10805,
7814,
1625,
9747,
6179,
7787,
4197,
6356,
3885,
10806,
4174,
8332,
9889,
9815,
4212,
10948,
6008,
10770,
10777,
10778,
3861,
8158,
6160,
7581,
6389,
8386,
10946,
6263,
9744,
5217,
1632,
10684,
10466,
4171,
4880,
9960,
5298,
1540,
7115,
6163,
4182,
4181,
10792,
2906,
6264,
10840,
9999,
10795,
4870,
5220,
6416,
10471,
2634,
7822,
6413,
7720,
6351,
8351,
8700,
9000,
1613,
4217,
10736,
4161,
10825,
5299,
5276,
1624,
10724,
5297,
7797,
8703,
5296,
10020,
7815,
1665,
3847,
5902,
1645,
10021,
1510,
1569,
7788,
10534,
2891,
10022,
1661,
9807,
10727,
9983,
9984,
6400,
8708,
10798,
10935,
7583,
1646,
6280,
4185,
4208,
10539,
6414,
8985,
6352,
8977,
8978,
10153,
1525,
10538,
10540,
9292,
10943,
10385,
10554,
3863,
2887,
10546,
7139,
6167,
1631,
8986,
10766,
10937,
10947,
10386,
9787,
4133,
9680,
9682,
9997,
4099,
7045,
3891,
4163,
2890,
10350,
10349,
10348,
10347,
10346,
9987,
5197,
9285,
9677,
6173,
7717,
7116,
9985,
6272,
9018,
6391,
9790,
1649,
1648,
10532,
9988,
10728,
1343,
5206,
10002,
6007,
8938,
8380,
4177,
10271,
9294,
1557,
4209,
2315,
10552,
7044,
10794,
7786,
4142,
7773,
10510,
3884,
10815,
4213,
8355,
9561,
8335,
9017,
3880,
8942,
5198,
6174,
7718,
9986,
6273,
9019,
1568,
10535,
5207,
8939,
8383,
10816,
10514,
9804,
4184,
8166,
8382,
8164,
6005,
10374,
10373,
10364,
10200,
5199,
7824,
9783,
9766,
9772,
9785,
10797,
9681,
9290,
7747,
7748,
6350,
9259,
6390,
9796,
10375,
10100,
7838,
10950,
9020,
9557,
4218,
9797,
8393,
10518,
8320,
4993,
2904,
10570,
9795,
9798,
10810,
4203,
4202,
4168,
10732,
4882,
9793,
10771,
4991,
7833,
7831,
8324,
9799,
4045,
8345,
4989,
4988,
9248,
9247,
3881,
6165,
8375,
10944,
10945,
10735,
3886,
10362,
2802,
10938,
1664,
10925,
10725,
9010,
6857,
10156,
10765,
10519,
3888,
1640,
8388,
9556,
7138,
9903,
10719,
9549,
4170,
6176,
9812,
4183,
4050,
7834,
1564,
10704,
10468,
4139,
10694,
10961,
8394,
10467,
9952,
10469,
8999,
10270,
2328,
4176,
1600,
6178,
1570,
9016,
9012,
8389,
10829,
8989,
1554,
7749,
9779,
10577,
5204,
5786,
10438,
6399,
3865,
3868,
3867,
3866,
5203,
5998,
1655,
8349,
4046,
4876,
10826,
9262,
9027,
10788,
9257,
8147,
8149,
6282,
7813,
6259,
5997,
5999,
3889,
6355,
8396,
9992,
8165,
1529,
7793,
4157,
7118,
10192,
10193,
6342,
9260,
10695,
4140,
9275,
4158,
10154,
1628,
4691,
7802,
8151,
10768,
1623,
8397,
5900,
9287,
10933,
8167,
10389,
10931,
10333,
6339,
6338,
9253,
9254,
8329,
8330,
10095,
5209,
5211,
8704,
5212,
10188,
2324,
6278,
6279,
8701,
7805,
9980,
8702,
10791,
8334,
8378,
7837,
6331,
6332,
6335,
2323,
7131,
10573,
1549,
1545,
1548,
1547,
3800,
10269,
7112,
9886,
7136,
6341,
9558,
7132,
9258,
4194,
4196,
4156,
6831,
9981,
3878,
10330,
9284,
1412,
7823,
10187,
9559,
10915,
10913,
10917,
10916,
10914,
10775,
10268,
9814,
10512,
10205,
10556,
8390,
4869,
7806,
6396,
1187,
10942,
7796,
4084,
9762,
7038,
7037,
7039,
7036,
1592,
1593,
10892,
8925,
10890,
8924,
7130,
10901,
6411,
6387,
6386,
10199,
10198,
1642,
9773,
10417,
6422,
9289,
8940,
9547,
5221,
1638,
4474,
4162,
6325,
6292,
6298,
6312,
6315,
6305,
6308,
6322,
6328,
6301,
6319,
6295,
6324,
6291,
6297,
6311,
6314,
6304,
6307,
6321,
6327,
6300,
6318,
6294,
9876,
9879,
9878,
4205,
4206,
9904,
4155,
6271,
4992,
4088,
10181,
10550,
4990,
1604,
9013,
1560,
1561,
10949,
-1,
7108,
7803,
9882,
9784,
4127,
7804,
6353,
3879,
1524,
10332,
10827,
8356,
6830,
4132,
7125,
7129,
7127,
7126,
7128,
7104,
7767,
9969,
9943,
9940,
9941,
9942,
9944,
9968,
9765,
1118,
1117,
1123,
1122,
4115,
4098,
1116,
1119,
1121,
1124,
4121,
4106,
-1,
8976,
9560,
7731,
8373,
8336,
4136,
9776,
1409,
7585,
9748,
9283,
7835,
7732,
7781,
9198,
10516,
1630,
8374,
10769,
9263,
8935,
8936,
8937,
10819,
10818,
10820,
4137,
10811,
9256,
6260,
6261,
10789,
10338,
10340,
10341,
10191,
10195,
10196,
10344,
10342,
10343,
8933,
8144,
8150,
9689,
1558,
1559,
8975,
4875,
5060,
9286,
6333,
6267,
10930,
8983,
6107,
9244,
10000,
8148,
1538,
9007,
6856,
1550,
7728,
7727,
7726,
7725,
7106,
9880,
7832,
7729,
7105,
9881,
7109,
9883,
5218,
6854,
6853,
3856,
3860,
3857,
3859,
3854,
6852,
3855,
9803,
5196,
7826,
1522,
1189,
5219,
10699,
10700,
10753,
1575,
1578,
1579,
1577,
1583,
1581,
9746,
1586,
10763,
9961,
1582,
1585,
1590,
10097,
10363,
10907,
10759,
8354,
6158,
6159,
9551,
10764,
9553,
9554,
10743,
10745,
10746,
8992,
9802,
2327,
8317,
6394,
8350,
10757,
8993,
10814,
2326,
10841,
9810,
1603,
7699,
10702,
7140,
10748,
10576,
10749,
10762,
2895,
10828,
1601,
8990,
10760,
10756,
10701,
6276,
1588,
1589,
6275,
9555,
8318,
6395,
9811,
1608,
1607,
10900,
10754,
10755,
10750,
8348,
1653,
10470,
1551,
10517,
8346,
8347,
8343,
8344,
10164,
1393,
10172,
1401,
7765,
7756,
7766,
7757,
10163,
1392,
10171,
1400,
10428,
10397,
10431,
10400,
10165,
1394,
10173,
1402,
10429,
10398,
10432,
10401,
10548,
10549,
1406,
1407,
7089,
10884,
9863,
8919,
1629,
10408,
6855,
10416,
10425,
1662,
1618,
1619,
1620,
10462,
1621,
10406,
8667,
8676,
5903,
9951,
10003,
10473,
1534,
9978,
10568,
10569,
7782,
4689,
6849,
1523,
7777,
7778,
4200,
9281,
7789,
4204,
4877,
2892,
10779,
8322,
9279,
7584,
9278,
2886,
9282,
9957,
8980,
2635,
7780,
5208,
5193,
1506,
5194,
2905,
1340,
10001,
1553,
10530,
8686,
6166,
8323,
7794,
8941,
10189,
1595,
10186,
8395,
8943,
8326,
10201,
4216,
10185,
4215,
5195,
8360,
10182,
6006,
4473,
9800,
9959,
3883,
7827,
9676,
1333,
3798,
3799,
8160,
5789,
3890,
7107,
7795,
8376,
6409,
4169,
10733,
6177,
1602,
1334,
4195,
4198,
8274,
]

_charnames_128736 = [
10513,
1341,
9291,
5214,
9977,
5215,
10893,
10894,
10891,
1594,
10177,
2900,
2901,
-1,
-1,
-1,
1622,
9280,
9001,
8161,
]

_charnames_128768 = [
2786,
2682,
2799,
2800,
2784,
2671,
2669,
2670,
2667,
2668,
2732,
2735,
2734,
2649,
2749,
2728,
2759,
2762,
2761,
2702,
2651,
2789,
2737,
2738,
2717,
2718,
2796,
2662,
2779,
2780,
2694,
2713,
2700,
2781,
2646,
2692,
2693,
2701,
2653,
2644,
2739,
2753,
2793,
2680,
2647,
2654,
2645,
2736,
2711,
2712,
2705,
2709,
2708,
2707,
2673,
2674,
2764,
2655,
2679,
2714,
2715,
2677,
2729,
2754,
2755,
2787,
2720,
2723,
2722,
2675,
2798,
2660,
2752,
2795,
2783,
2742,
2697,
2756,
2696,
2663,
2698,
2757,
2659,
2792,
2661,
2797,
2768,
2678,
2744,
2727,
2743,
2681,
2657,
2658,
2648,
2748,
2776,
2774,
2775,
2747,
2746,
2685,
2690,
2689,
2688,
2687,
2676,
2726,
2725,
2716,
2767,
2790,
2777,
2763,
2771,
2770,
]

_charnames_128896 = [
4113,
4118,
4096,
4103,
4087,
4688,
4148,
10447,
8672,
10356,
9789,
9991,
4124,
4086,
6848,
4686,
4147,
10446,
8671,
10355,
9760,
9761,
1473,
4126,
4130,
4058,
9768,
9769,
8998,
4125,
4129,
4057,
9771,
7744,
6850,
4687,
4152,
8679,
8677,
10360,
7743,
6847,
4674,
4151,
10407,
8669,
10359,
6840,
4679,
4153,
10458,
8678,
10361,
6846,
4672,
4150,
10403,
8668,
10358,
6851,
4684,
4154,
10444,
8674,
6844,
4682,
7730,
4681,
6837,
4678,
10801,
4677,
9949,
6841,
10459,
4673,
10404,
1188,
4685,
10443,
8675,
10442,
6843,
10453,
10452,
]

_charnames_129024 = [
7075,
10869,
9847,
8906,
7078,
10872,
9850,
8909,
7079,
10873,
9851,
8910,
-1,
-1,
-1,
-1,
7076,
10870,
9848,
8907,
7080,
10874,
9852,
8911,
10415,
10450,
10456,
10437,
10414,
10449,
10455,
10436,
7062,
10856,
9834,
8892,
7063,
10857,
9835,
8893,
7065,
10860,
9837,
8896,
7064,
10858,
9836,
8894,
7061,
10855,
9833,
8891,
7096,
10885,
9870,
8920,
7086,
10879,
9860,
8913,
7099,
10886,
9873,
8921,
7092,
10882,
9866,
8916,
7093,
10883,
9867,
8917,
]

_charnames_129104 = [
7087,
10880,
9861,
8914,
10168,
10176,
1405,
1397,
7103,
10898,
-1,
-1,
-1,
-1,
-1,
-1,
9733,
9721,
9727,
9739,
9709,
9715,
9702,
9696,
9735,
9723,
9729,
9741,
9711,
9717,
9704,
9698,
9732,
9720,
9726,
9738,
9708,
9714,
9701,
9695,
9734,
9722,
9728,
9740,
9710,
9716,
9703,
9697,
9731,
9719,
9725,
9737,
9707,
9713,
9700,
9694,
]

_charnames_129168 = [
7070,
10865,
9842,
8902,
7097,
10876,
9871,
8918,
7077,
10871,
9849,
8908,
10420,
10424,
10423,
10422,
7082,
9857,
7072,
9844,
7098,
9864,
7090,
9872,
7084,
9858,
7095,
9869,
9782,
9781,
]

_charnames_129296 = [
10958,
5205,
10752,
10098,
7745,
10758,
10004,
10578,
988,
]

_charnames_983040 = [
10204,
10203,
1519,
1413,
1517,
1539,
10324,
10316,
10322,
10381,
10335,
10334,
2903,
2902,
2803,
4193,
3876,
4222,
6000,
10525,
10579,
7582,
6828,
10091,
10328,
7147,
10210,
10383,
6826,
8683,
8705,
10807,
10842,
6262,
6382,
1338,
7135,
1344,
1339,
7134,
1,
9011,
9028,
8971,
9026,
8968,
9025,
8969,
9024,
8972,
9023,
10085,
10155,
1637,
1636,
10323,
10317,
6266,
6265,
10327,
10382,
1509,
1508,
10378,
10377,
10924,
10787,
10837,
10922,
10705,
10734,
10921,
9958,
10029,
10923,
10904,
10908,
1542,
8981,
8979,
8163,
8162,
10572,
10555,
4048,
4223,
10184,
10208,
10928,
10926,
10096,
10099,
1516,
1657,
10325,
10379,
6003,
10528,
10580,
6002,
10527,
10581,
6827,
8684,
8706,
8155,
8156,
8276,
8157,
8154,
8275,
9948,
9950,
9818,
1179,
1185,
1659,
1180,
1184,
1658,
8970,
9022,
8370,
8367,
8399,
8369,
8366,
8398,
1654,
1541,
6268,
6423,
4690,
5411,
1520,
1518,
1562,
10329,
10326,
10388,
1515,
1411,
1181,
1666,
1182,
1634,
6162,
6420,
1530,
1511,
9261,
9288,
8371,
8403,
2897,
2898,
10207,
1342,
7004,
6962,
6421,
2801,
1641,
9546,
7029,
7030,
7031,
7032,
7710,
10833,
10832,
10831,
5412,
10956,
10954,
10957,
7144,
10026,
7146,
10028,
8402,
7143,
10025,
10209,
5413,
9816,
7145,
10027,
10838,
8401,
9808,
4872,
4873,
7059,
9831,
10960,
8377,
8406,
8517,
8651,
8640,
8629,
8618,
8607,
8596,
8585,
8506,
8495,
8484,
8473,
8462,
8451,
8440,
4221,
4175,
10955,
5643,
5645,
4220,
8429,
8418,
8407,
8562,
8551,
8540,
8529,
8518,
8573,
8584,
8583,
8582,
8581,
8661,
8660,
8659,
8658,
8657,
8656,
8655,
8654,
8653,
8652,
8650,
8649,
8648,
8647,
8646,
8645,
8644,
8643,
8642,
8641,
8639,
8638,
8637,
8636,
8635,
8634,
8633,
8632,
8631,
8630,
8628,
8627,
8626,
8625,
8624,
8623,
8622,
8621,
8620,
8619,
8617,
8616,
8615,
8614,
8613,
8612,
8611,
8610,
8609,
8608,
8606,
8605,
8604,
8603,
8602,
8601,
8600,
8599,
8598,
8597,
8595,
8594,
8593,
8592,
8591,
8590,
8589,
8588,
8587,
8586,
8516,
8515,
8514,
8513,
8512,
8511,
8510,
8509,
8508,
8507,
8505,
8504,
8503,
8502,
8501,
8500,
8499,
8498,
8497,
8496,
8494,
8493,
8492,
8491,
8490,
8489,
8488,
8487,
8486,
8485,
8483,
8482,
8481,
8480,
8479,
8478,
8477,
8476,
8475,
8474,
8472,
8471,
8470,
8469,
8468,
8467,
8466,
8465,
8464,
8463,
8461,
8460,
8459,
8458,
8457,
8456,
8455,
8454,
8453,
8452,
8450,
8449,
8448,
8447,
8446,
8445,
8444,
8443,
8442,
8441,
8439,
8438,
8437,
8436,
8435,
8434,
8433,
8432,
8431,
8430,
8428,
8427,
8426,
8425,
8424,
8423,
8422,
8421,
8420,
8419,
8417,
8416,
8415,
8414,
8413,
8412,
8411,
8410,
8409,
8408,
8572,
8571,
8570,
8569,
8568,
8567,
8566,
8565,
8564,
8563,
8561,
8560,
8559,
8558,
8557,
8556,
8555,
8554,
8553,
8552,
8550,
8549,
8548,
8547,
8546,
8545,
8544,
8543,
8542,
8541,
8539,
8538,
8537,
8536,
8535,
8534,
8533,
8532,
8531,
8530,
8528,
8527,
8526,
8525,
8524,
8523,
8522,
8521,
8520,
8519,
8580,
8579,
8578,
8577,
8576,
8575,
8574,
]

_charnames_983612 = [
6970,
6913,
6914,
6898,
6899,
6873,
6874,
6958,
6959,
2550,
2554,
2551,
2556,
2555,
2553,
2557,
2552,
2558,
4191,
7481,
7470,
7489,
7469,
7478,
7467,
7477,
7466,
7485,
7486,
7483,
7479,
7474,
7484,
7476,
7475,
7480,
7468,
7487,
7473,
7472,
7471,
7488,
7482,
7313,
7318,
7319,
7314,
7315,
7320,
7321,
7312,
7316,
7317,
7311,
7196,
7201,
7202,
7197,
7198,
7203,
7204,
7195,
7199,
7200,
7194,
7456,
7461,
7462,
7457,
7458,
7463,
7464,
7455,
7459,
7460,
7454,
7183,
7188,
7189,
7184,
7185,
7190,
7191,
7182,
7186,
7187,
7181,
7327,
7332,
7333,
7328,
7329,
7334,
7335,
7326,
7330,
7331,
7325,
7170,
7175,
7176,
7171,
7172,
7177,
7178,
7169,
7173,
7174,
7168,
7339,
7344,
7345,
7340,
7341,
7346,
7347,
7338,
7342,
7343,
7337,
7208,
7213,
7214,
7209,
7210,
7215,
7216,
7207,
7211,
7212,
7206,
7404,
7409,
7410,
7405,
7406,
7411,
7412,
7403,
7407,
7408,
7402,
7417,
7422,
7423,
7418,
7419,
7424,
7425,
7416,
7420,
7421,
7415,
7378,
7383,
7384,
7379,
7380,
7385,
7386,
7377,
7381,
7382,
7376,
7365,
7370,
7371,
7366,
7367,
7372,
7373,
7364,
7368,
7369,
7363,
7287,
7292,
7293,
7288,
7289,
7294,
7295,
7286,
7290,
7291,
7285,
7391,
7396,
7397,
7392,
7393,
7398,
7399,
7390,
7394,
7395,
7389,
7263,
7268,
7269,
7264,
7265,
7270,
7271,
7262,
7266,
7267,
7261,
7275,
7280,
7281,
7276,
7277,
7282,
7283,
7274,
7278,
7279,
7273,
7353,
7358,
7359,
7354,
7355,
7360,
7361,
7352,
7356,
7357,
7351,
7158,
7163,
7164,
7159,
7160,
7165,
7166,
7157,
7161,
7162,
7156,
7430,
7435,
7436,
7431,
7432,
7437,
7438,
7429,
7433,
7434,
7428,
7222,
7227,
7228,
7223,
7224,
7229,
7230,
7221,
7225,
7226,
7220,
7236,
7241,
7242,
7237,
7238,
7243,
7244,
7235,
7239,
7240,
7234,
7248,
7253,
7254,
7249,
7250,
7255,
7256,
7247,
7251,
7252,
7246,
7443,
7448,
7449,
7444,
7445,
7450,
7451,
7442,
7446,
7447,
7441,
7298,
7301,
7306,
7307,
7302,
7303,
7308,
7309,
7300,
7304,
7305,
7299,
7231,
1175,
1174,
1173,
10709,
9490,
9488,
9489,
9487,
9483,
9496,
9494,
9495,
9493,
9481,
9511,
9474,
9510,
9473,
9484,
9479,
9477,
9478,
9476,
9482,
9517,
9504,
9505,
9503,
9515,
9512,
9514,
9507,
9513,
9499,
9498,
9500,
9516,
9508,
9526,
9522,
9519,
9520,
9523,
9525,
9527,
10564,
10562,
10560,
10563,
10561,
9535,
9533,
9531,
9534,
9532,
9542,
9539,
9540,
9541,
5188,
5187,
]

def lookup_charcode(code):
    res = -1
    if code == 895: res = 10692
    elif 1318 <= code <= 1327: res = _charnames_1318[code-1318]
    elif code == 1421: res = 9888
    elif code == 1422: res = 7114
    elif code == 1423: res = 2636
    elif code == 1540: res = 2560
    elif code == 1541: res = 2631
    elif code == 1564: res = 2574
    elif code == 1568: res = 2579
    elif code == 1631: res = 2630
    elif 2112 <= code <= 2142: res = _charnames_2112[code-2112]
    elif 2208 <= code <= 2228: res = _charnames_2208[code-2208]
    elif 2275 <= code <= 2303: res = _charnames_2275[code-2275]
    elif code == 2362: res = 8962
    elif code == 2363: res = 8961
    elif 2383 <= code <= 2391: res = _charnames_2383[code-2383]
    elif code == 2419: res = 8953
    elif code == 2420: res = 8952
    elif code == 2421: res = 8955
    elif code == 2422: res = 8950
    elif code == 2423: res = 8949
    elif code == 2424: res = 8954
    elif code == 2432: res = 4192
    elif code == 2800: res = 10723
    elif code == 2809: res = 10722
    elif code == 2930: res = 9269
    elif code == 2931: res = 9270
    elif code == 2932: res = 9274
    elif code == 2933: res = 9268
    elif code == 2934: res = 9271
    elif code == 2935: res = 9273
    elif code == 3072: res = 7811
    elif code == 3124: res = 7810
    elif code == 3162: res = 7809
    elif code == 3201: res = 9545
    elif code == 3329: res = 5056
    elif code == 3369: res = 5053
    elif code == 3386: res = 5052
    elif code == 3406: res = 5054
    elif code == 3423: res = 5055
    elif 3558 <= code <= 3567: res = _charnames_3558[code-3558]
    elif code == 3806: res = 7027
    elif code == 3807: res = 7026
    elif code == 3980: res = 7706
    elif code == 3981: res = 7704
    elif code == 3982: res = 7703
    elif code == 3983: res = 7705
    elif code == 4057: res = 7709
    elif code == 4058: res = 7708
    elif 4295 <= code <= 4301: res = _charnames_4295[code-4295]
    elif code == 4349: res = 10712
    elif code == 4350: res = 10711
    elif code == 4351: res = 10710
    elif code == 4957: res = 10315
    elif code == 4958: res = 10314
    elif 5109 <= code <= 5117: res = _charnames_5109[code-5109]
    elif 5873 <= code <= 5880: res = _charnames_5873[code-5873]
    elif code == 6429: res = 6860
    elif code == 6430: res = 6859
    elif 6832 <= code <= 6846: res = _charnames_6832[code-6832]
    elif code == 7083: res = 1498
    elif code == 7084: res = 1497
    elif code == 7085: res = 1496
    elif 7098 <= code <= 7155: res = _charnames_7098[code-7098]
    elif code == 7164: res = 3789
    elif code == 7165: res = 3787
    elif code == 7166: res = 3790
    elif code == 7167: res = 3788
    elif 7360 <= code <= 7367: res = _charnames_7360[code-7360]
    elif 7411 <= code <= 7417: res = _charnames_7411[code-7411]
    elif 7655 <= code <= 7676: res = _charnames_7655[code-7655]
    elif code == 8294: res = 7111
    elif code == 8295: res = 9885
    elif code == 8296: res = 10784
    elif code == 8297: res = 8333
    elif 8341 <= code <= 8348: res = _charnames_8341[code-8341]
    elif code == 8377: res = 10927
    elif code == 8378: res = 7771
    elif code == 8379: res = 10178
    elif code == 8380: res = 4994
    elif code == 8381: res = 10023
    elif code == 8382: res = 7040
    elif code == 8586: res = 7761
    elif code == 8587: res = 7762
    elif 9193 <= code <= 9210: res = _charnames_9193[code-9193]
    elif code == 9934: res = 9264
    elif code == 9954: res = 2894
    elif code == 9956: res = 8353
    elif code == 9957: res = 9887
    elif code == 9958: res = 7113
    elif code == 9959: res = 10932
    elif 9984 <= code <= 9995: res = _charnames_9984[code-9984]
    elif code == 10024: res = 1565
    elif 10060 <= code <= 10069: res = _charnames_10060[code-10060]
    elif code == 10079: res = 10411
    elif code == 10080: res = 10412
    elif code == 10133: res = 10460
    elif code == 10134: res = 10461
    elif code == 10135: res = 10439
    elif code == 10160: res = 5787
    elif code == 10175: res = 8931
    elif code == 10187: res = 5058
    elif code == 10189: res = 5059
    elif code == 10190: res = 1441
    elif code == 10191: res = 1440
    elif code == 11085: res = 8899
    elif code == 11086: res = 1331
    elif code == 11087: res = 1330
    elif 11098 <= code <= 11217: res = _charnames_11098[code-11098]
    elif code == 11244: res = 7071
    elif code == 11245: res = 10866
    elif code == 11246: res = 9843
    elif code == 11247: res = 8903
    elif code == 11506: res = 6155
    elif code == 11507: res = 6154
    elif 11559 <= code <= 11565: res = _charnames_11559[code-11559]
    elif code == 11622: res = 7714
    elif code == 11623: res = 7713
    elif code == 11632: res = 7715
    elif code == 11647: res = 7716
    elif 11826 <= code <= 11842: res = _charnames_11826[code-11826]
    elif code == 12728: res = 4167
    elif code == 12729: res = 4166
    elif code == 12730: res = 4165
    elif code == 42592: res = 6379
    elif code == 42593: res = 6368
    elif 42612 <= code <= 42619: res = _charnames_42612[code-42612]
    elif 42648 <= code <= 42655: res = _charnames_42648[code-42648]
    elif 42893 <= code <= 42935: res = _charnames_42893[code-42893]
    elif code == 42999: res = 7023
    elif code == 43000: res = 5185
    elif code == 43001: res = 5178
    elif code == 43002: res = 7020
    elif code == 43260: res = 8964
    elif code == 43261: res = 8965
    elif 43488 <= code <= 43518: res = _charnames_43488[code-43488]
    elif code == 43644: res = 5408
    elif code == 43645: res = 5407
    elif code == 43646: res = 5390
    elif code == 43647: res = 5389
    elif 43744 <= code <= 43766: res = _charnames_43744[code-43744]
    elif 43777 <= code <= 43798: res = _charnames_43777[code-43777]
    elif 43808 <= code <= 43877: res = _charnames_43808[code-43808]
    elif 43888 <= code <= 43967: res = _charnames_43888[code-43888]
    elif code == 64046: res = 6419
    elif code == 64047: res = 6418
    elif 64434 <= code <= 64449: res = _charnames_64434[code-64434]
    elif 65063 <= code <= 65071: res = _charnames_65063[code-65063]
    elif code == 65931: res = 10690
    elif code == 65932: res = 10689
    elif code == 65952: res = 10688
    elif 66272 <= code <= 66299: res = _charnames_66272[code-66272]
    elif code == 66335: res = 9245
    elif 66384 <= code <= 66426: res = _charnames_66384[code-66384]
    elif 66816 <= code <= 66855: res = _charnames_66816[code-66816]
    elif 66864 <= code <= 66915: res = _charnames_66864[code-66864]
    elif code == 66927: res = 6256
    elif 67072 <= code <= 67382: res = _charnames_67072[code-67072]
    elif 67392 <= code <= 67413: res = _charnames_67392[code-67392]
    elif 67424 <= code <= 67431: res = _charnames_67424[code-67424]
    elif 67680 <= code <= 67742: res = _charnames_67680[code-67680]
    elif 67751 <= code <= 67759: res = _charnames_67751[code-67751]
    elif 67808 <= code <= 67839: res = _charnames_67808[code-67808]
    elif 67968 <= code <= 68095: res = _charnames_67968[code-67968]
    elif 68224 <= code <= 68255: res = _charnames_68224[code-68224]
    elif 68288 <= code <= 68342: res = _charnames_68288[code-68288]
    elif 68480 <= code <= 68497: res = _charnames_68480[code-68480]
    elif code == 68505: res = 8313
    elif code == 68506: res = 8312
    elif code == 68507: res = 8311
    elif code == 68508: res = 8310
    elif 68521 <= code <= 68527: res = _charnames_68521[code-68521]
    elif 68736 <= code <= 68786: res = _charnames_68736[code-68736]
    elif 68800 <= code <= 68850: res = _charnames_68800[code-68800]
    elif code == 68858: res = 9142
    elif code == 68859: res = 9147
    elif code == 68860: res = 9149
    elif code == 68861: res = 9148
    elif code == 68862: res = 9145
    elif code == 68863: res = 9144
    elif 69632 <= code <= 69743: res = _charnames_69632[code-69632]
    elif code == 69759: res = 3991
    elif 69840 <= code <= 69864: res = _charnames_69840[code-69840]
    elif 69872 <= code <= 69955: res = _charnames_69872[code-69872]
    elif 69968 <= code <= 70006: res = _charnames_69968[code-69968]
    elif 70016 <= code <= 70132: res = _charnames_70016[code-70016]
    elif 70144 <= code <= 70205: res = _charnames_70144[code-70144]
    elif 70272 <= code <= 70516: res = _charnames_70272[code-70272]
    elif 70784 <= code <= 70855: res = _charnames_70784[code-70784]
    elif 70864 <= code <= 70873: res = _charnames_70864[code-70864]
    elif 71040 <= code <= 71133: res = _charnames_71040[code-71040]
    elif 71168 <= code <= 71236: res = _charnames_71168[code-71168]
    elif 71248 <= code <= 71257: res = _charnames_71248[code-71248]
    elif 71296 <= code <= 71351: res = _charnames_71296[code-71296]
    elif 71360 <= code <= 71369: res = _charnames_71360[code-71360]
    elif 71424 <= code <= 71487: res = _charnames_71424[code-71424]
    elif 71840 <= code <= 71922: res = _charnames_71840[code-71840]
    elif code == 71935: res = 9672
    elif 72384 <= code <= 72440: res = _charnames_72384[code-72384]
    elif 74607 <= code <= 74649: res = _charnames_74607[code-74607]
    elif 74851 <= code <= 74868: res = _charnames_74851[code-74851]
    elif 74880 <= code <= 75075: res = _charnames_74880[code-74880]
    elif 82944 <= code <= 83526: res = _charnames_82944[code-82944]
    elif 92160 <= code <= 92728: res = _charnames_92160[code-92160]
    elif 92736 <= code <= 92783: res = _charnames_92736[code-92736]
    elif 92880 <= code <= 92917: res = _charnames_92880[code-92880]
    elif 92928 <= code <= 92997: res = _charnames_92928[code-92928]
    elif 93008 <= code <= 93071: res = _charnames_93008[code-93008]
    elif 93952 <= code <= 94020: res = _charnames_93952[code-93952]
    elif 94032 <= code <= 94078: res = _charnames_94032[code-94032]
    elif 94095 <= code <= 94111: res = _charnames_94095[code-94095]
    elif code == 110592: res = 9543
    elif code == 110593: res = 10565
    elif 113664 <= code <= 113800: res = _charnames_113664[code-113664]
    elif 113808 <= code <= 113827: res = _charnames_113808[code-113808]
    elif 119262 <= code <= 119272: res = _charnames_119262[code-119262]
    elif 120832 <= code <= 121483: res = _charnames_120832[code-120832]
    elif 121499 <= code <= 121519: res = _charnames_121499[code-121499]
    elif 124928 <= code <= 125142: res = _charnames_124928[code-124928]
    elif 126464 <= code <= 126651: res = _charnames_126464[code-126464]
    elif code == 126704: res = 2500
    elif code == 126705: res = 2501
    elif 127136 <= code <= 127221: res = _charnames_127136[code-127136]
    elif code == 127243: res = 8996
    elif code == 127244: res = 8995
    elif 127280 <= code <= 127386: res = _charnames_127280[code-127280]
    elif 127462 <= code <= 127490: res = _charnames_127462[code-127462]
    elif 127538 <= code <= 127546: res = _charnames_127538[code-127538]
    elif code == 127568: res = 6407
    elif code == 127569: res = 6408
    elif 127744 <= code <= 128720: res = _charnames_127744[code-127744]
    elif 128736 <= code <= 128755: res = _charnames_128736[code-128736]
    elif 128768 <= code <= 128883: res = _charnames_128768[code-128768]
    elif 128896 <= code <= 128980: res = _charnames_128896[code-128896]
    elif 129024 <= code <= 129095: res = _charnames_129024[code-129024]
    elif 129104 <= code <= 129159: res = _charnames_129104[code-129104]
    elif 129168 <= code <= 129197: res = _charnames_129168[code-129168]
    elif 129296 <= code <= 129304: res = _charnames_129296[code-129296]
    elif code == 129408: res = 6401
    elif code == 129409: res = 6861
    elif code == 129410: res = 1633
    elif code == 129411: res = 7772
    elif code == 129412: res = 10905
    elif code == 129472: res = 5899
    elif 983040 <= code <= 983498: res = _charnames_983040[code-983040]
    elif 983612 <= code <= 983981: res = _charnames_983612[code-983612]
    if res == -1: raise KeyError(code)
    return name_of_node(res)

# end output from build_compression_tree
#____________________________________________________________
_names_corrected = {
}
_code_by_name_corrected = {
}

_cjk_prefix = "CJK UNIFIED IDEOGRAPH-"
_hangul_prefix = 'HANGUL SYLLABLE '

_hangul_L = ['G', 'GG', 'N', 'D', 'DD', 'R', 'M', 'B', 'BB',
            'S', 'SS', '', 'J', 'JJ', 'C', 'K', 'T', 'P', 'H']
_hangul_V = ['A', 'AE', 'YA', 'YAE', 'EO', 'E', 'YEO', 'YE', 'O', 'WA', 'WAE',
            'OE', 'YO', 'U', 'WEO', 'WE', 'WI', 'YU', 'EU', 'YI', 'I']
_hangul_T = ['', 'G', 'GG', 'GS', 'N', 'NJ', 'NH', 'D', 'L', 'LG', 'LM',
            'LB', 'LS', 'LT', 'LP', 'LH', 'M', 'B', 'BS', 'S', 'SS',
            'NG', 'J', 'C', 'K', 'T', 'P', 'H']

def _lookup_hangul(syllables):
    l_code = v_code = t_code = -1
    for i in range(len(_hangul_L)):
        jamo = _hangul_L[i]
        if (syllables[:len(jamo)] == jamo and
            (l_code < 0 or len(jamo) > len(_hangul_L[l_code]))):
            l_code = i
    if l_code < 0:
        raise KeyError
    start = len(_hangul_L[l_code])

    for i in range(len(_hangul_V)):
        jamo = _hangul_V[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (v_code < 0 or len(jamo) > len(_hangul_V[v_code]))):
            v_code = i
    if v_code < 0:
        raise KeyError
    start += len(_hangul_V[v_code])

    for i in range(len(_hangul_T)):
        jamo = _hangul_T[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (t_code < 0 or len(jamo) > len(_hangul_T[t_code]))):
            t_code = i
    if t_code < 0:
        raise KeyError
    start += len(_hangul_T[t_code])

    if len(syllables[start:]):
        raise KeyError
    return 0xAC00 + (l_code * 21 + v_code) * 28 + t_code

def _lookup_cjk(cjk_code):
    if len(cjk_code) != 4 and len(cjk_code) != 5:
        raise KeyError
    for c in cjk_code:
        if not ('0' <= c <= '9' or 'A' <= c <= 'F'):
            raise KeyError
    code = int(cjk_code, 16)
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FD5 or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D or 0x2B820 <= code <= 0x2CEA1):
        return code
    raise KeyError

def lookup(name, with_named_sequence=False):
    if name[:len(_cjk_prefix)] == _cjk_prefix:
        return _lookup_cjk(name[len(_cjk_prefix):])
    if name[:len(_hangul_prefix)] == _hangul_prefix:
        return _lookup_hangul(name[len(_hangul_prefix):])

    if not base_mod:
        code = trie_lookup(name)
    else:
        try:
            code = trie_lookup(name)
        except KeyError:
            if name not in _code_by_name_corrected:
                code = base_mod.trie_lookup(name)
            else:
                raise
    if not with_named_sequence and 0xF0200 <= code < 0xF0400:
        raise KeyError
    return code

def name(code):
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FD5 or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D or 0x2B820 <= code <= 0x2CEA1):
        return "CJK UNIFIED IDEOGRAPH-" + hex(code)[2:].upper()
    if 0xAC00 <= code <= 0xD7A3:
        # vl_code, t_code = divmod(code - 0xAC00, len(_hangul_T))
        vl_code = (code - 0xAC00) // len(_hangul_T)
        t_code = (code - 0xAC00) % len(_hangul_T)
        # l_code, v_code = divmod(vl_code,  len(_hangul_V))
        l_code = vl_code // len(_hangul_V)
        v_code = vl_code % len(_hangul_V)
        return ("HANGUL SYLLABLE " + _hangul_L[l_code] +
                _hangul_V[v_code] + _hangul_T[t_code])
    if 0xF0000 <= code < 0xF0400:
        raise KeyError

    if not base_mod:
        return lookup_charcode(code)
    else:
        try:
            return lookup_charcode(code)
        except KeyError:
            if code not in _names_corrected:
                return base_mod.lookup_charcode(code)
            else:
                raise

_db_records = [
('Cc', 'B', 'N', 5),
('Cc', 'BN', 'N', 0),
('Cc', 'S', 'N', 1),
('Cc', 'S', 'N', 5),
('Cc', 'WS', 'N', 5),
('Cf', 'AL', 'N', 8192),
('Cf', 'AN', 'N', 8192),
('Cf', 'BN', 'A', 8192),
('Cf', 'BN', 'N', 8192),
('Cf', 'FSI', 'N', 8192),
('Cf', 'L', 'N', 8192),
('Cf', 'LRE', 'N', 8192),
('Cf', 'LRI', 'N', 8192),
('Cf', 'LRO', 'N', 8192),
('Cf', 'ON', 'N', 8192),
('Cf', 'PDF', 'N', 8192),
('Cf', 'PDI', 'N', 8192),
('Cf', 'R', 'N', 8192),
('Cf', 'RLE', 'N', 8192),
('Cf', 'RLI', 'N', 8192),
('Cf', 'RLO', 'N', 8192),
('Cn', '', 'N', 0),
('Cn', '', 'W', 0),
('Co', 'L', 'A', 0),
('Cs', 'L', 'N', 0),
('Ll', 'L', 'A', 7202),
('Ll', 'L', 'F', 7202),
('Ll', 'L', 'N', 7202),
('Ll', 'L', 'Na', 7202),
('Ll', 'R', 'N', 7202),
('Lm', 'AL', 'N', 15362),
('Lm', 'L', 'A', 15362),
('Lm', 'L', 'A', 15394),
('Lm', 'L', 'H', 14338),
('Lm', 'L', 'H', 15362),
('Lm', 'L', 'N', 12322),
('Lm', 'L', 'N', 15362),
('Lm', 'L', 'N', 15394),
('Lm', 'L', 'W', 15362),
('Lm', 'ON', 'A', 15362),
('Lm', 'ON', 'N', 12290),
('Lm', 'ON', 'N', 15362),
('Lm', 'R', 'N', 15362),
('Lo', 'AL', 'N', 4098),
('Lo', 'AL', 'N', 7170),
('Lo', 'L', 'A', 7202),
('Lo', 'L', 'H', 7170),
('Lo', 'L', 'N', 6146),
('Lo', 'L', 'N', 7170),
('Lo', 'L', 'W', 7170),
('Lo', 'L', 'W', 7234),
('Lo', 'R', 'N', 7170),
('Lt', 'L', 'N', 7186),
('Lu', 'L', 'A', 7178),
('Lu', 'L', 'F', 7178),
('Lu', 'L', 'N', 7178),
('Lu', 'L', 'Na', 7178),
('Lu', 'R', 'N', 7178),
('Mc', 'L', 'N', 6144),
('Mc', 'L', 'W', 6144),
('Me', 'NSM', 'N', 12288),
('Mn', 'L', 'N', 14336),
('Mn', 'NSM', 'A', 14336),
('Mn', 'NSM', 'A', 14368),
('Mn', 'NSM', 'N', 14336),
('Mn', 'NSM', 'W', 14336),
('Nd', 'AN', 'N', 6592),
('Nd', 'EN', 'F', 6592),
('Nd', 'EN', 'N', 6592),
('Nd', 'EN', 'Na', 6592),
('Nd', 'L', 'N', 6592),
('Nd', 'R', 'N', 6592),
('Nl', 'L', 'A', 7240),
('Nl', 'L', 'A', 7264),
('Nl', 'L', 'N', 7232),
('Nl', 'L', 'N', 7240),
('Nl', 'L', 'N', 7264),
('Nl', 'L', 'W', 7232),
('Nl', 'ON', 'N', 7232),
('No', 'AN', 'N', 4160),
('No', 'AN', 'N', 4288),
('No', 'EN', 'A', 4160),
('No', 'EN', 'A', 4288),
('No', 'EN', 'N', 4160),
('No', 'EN', 'N', 4288),
('No', 'L', 'A', 4160),
('No', 'L', 'N', 4160),
('No', 'L', 'N', 6336),
('No', 'L', 'W', 4160),
('No', 'ON', 'A', 4160),
('No', 'ON', 'A', 4288),
('No', 'ON', 'N', 4160),
('No', 'ON', 'N', 4288),
('No', 'ON', 'W', 4160),
('No', 'R', 'N', 4160),
('No', 'R', 'N', 4288),
('Pc', 'ON', 'F', 6144),
('Pc', 'ON', 'N', 6144),
('Pc', 'ON', 'Na', 6144),
('Pc', 'ON', 'W', 6144),
('Pd', 'ES', 'F', 4096),
('Pd', 'ES', 'Na', 4096),
('Pd', 'ES', 'W', 4096),
('Pd', 'ON', 'A', 4096),
('Pd', 'ON', 'N', 4096),
('Pd', 'ON', 'W', 4096),
('Pd', 'R', 'N', 4096),
('Pe', 'ON', 'F', 4608),
('Pe', 'ON', 'H', 4608),
('Pe', 'ON', 'N', 4096),
('Pe', 'ON', 'N', 4608),
('Pe', 'ON', 'Na', 4608),
('Pe', 'ON', 'W', 4096),
('Pe', 'ON', 'W', 4608),
('Pf', 'ON', 'A', 4096),
('Pf', 'ON', 'A', 12288),
('Pf', 'ON', 'N', 4608),
('Pi', 'ON', 'A', 4096),
('Pi', 'ON', 'A', 12288),
('Pi', 'ON', 'N', 4096),
('Pi', 'ON', 'N', 4608),
('Po', 'AL', 'N', 4096),
('Po', 'AN', 'N', 4096),
('Po', 'CS', 'F', 4096),
('Po', 'CS', 'F', 12288),
('Po', 'CS', 'N', 4096),
('Po', 'CS', 'Na', 4096),
('Po', 'CS', 'Na', 12288),
('Po', 'CS', 'W', 4096),
('Po', 'CS', 'W', 12288),
('Po', 'ET', 'A', 4096),
('Po', 'ET', 'F', 4096),
('Po', 'ET', 'N', 4096),
('Po', 'ET', 'Na', 4096),
('Po', 'ET', 'W', 4096),
('Po', 'L', 'N', 4096),
('Po', 'ON', 'A', 4096),
('Po', 'ON', 'A', 12288),
('Po', 'ON', 'A', 14336),
('Po', 'ON', 'F', 4096),
('Po', 'ON', 'F', 12288),
('Po', 'ON', 'H', 4096),
('Po', 'ON', 'N', 4096),
('Po', 'ON', 'N', 14336),
('Po', 'ON', 'Na', 4096),
('Po', 'ON', 'Na', 12288),
('Po', 'ON', 'W', 4096),
('Po', 'ON', 'W', 12288),
('Po', 'R', 'N', 4096),
('Po', 'R', 'N', 12288),
('Ps', 'ON', 'F', 4608),
('Ps', 'ON', 'H', 4608),
('Ps', 'ON', 'N', 4096),
('Ps', 'ON', 'N', 4608),
('Ps', 'ON', 'Na', 4608),
('Ps', 'ON', 'W', 4096),
('Ps', 'ON', 'W', 4608),
('Sc', 'AL', 'N', 4096),
('Sc', 'ET', 'A', 4096),
('Sc', 'ET', 'F', 4096),
('Sc', 'ET', 'H', 4096),
('Sc', 'ET', 'N', 4096),
('Sc', 'ET', 'Na', 4096),
('Sc', 'ET', 'W', 4096),
('Sk', 'AL', 'N', 12288),
('Sk', 'L', 'N', 12288),
('Sk', 'ON', 'A', 12288),
('Sk', 'ON', 'F', 12288),
('Sk', 'ON', 'N', 12288),
('Sk', 'ON', 'Na', 12288),
('Sk', 'ON', 'W', 12288),
('Sm', 'AL', 'N', 4096),
('Sm', 'CS', 'N', 4096),
('Sm', 'ES', 'F', 4096),
('Sm', 'ES', 'N', 4096),
('Sm', 'ES', 'Na', 4096),
('Sm', 'ES', 'W', 4096),
('Sm', 'ET', 'A', 4096),
('Sm', 'ET', 'N', 4096),
('Sm', 'L', 'N', 4096),
('Sm', 'ON', 'A', 4096),
('Sm', 'ON', 'A', 4608),
('Sm', 'ON', 'F', 4096),
('Sm', 'ON', 'F', 4608),
('Sm', 'ON', 'H', 4096),
('Sm', 'ON', 'N', 4096),
('Sm', 'ON', 'N', 4608),
('Sm', 'ON', 'N', 7168),
('Sm', 'ON', 'Na', 4096),
('Sm', 'ON', 'Na', 4608),
('Sm', 'ON', 'W', 4096),
('Sm', 'ON', 'W', 4608),
('So', 'AL', 'N', 4096),
('So', 'ET', 'A', 4096),
('So', 'ET', 'N', 4096),
('So', 'ET', 'N', 7168),
('So', 'L', 'A', 4096),
('So', 'L', 'A', 4104),
('So', 'L', 'A', 4128),
('So', 'L', 'N', 4096),
('So', 'L', 'W', 4096),
('So', 'ON', 'A', 4096),
('So', 'ON', 'F', 4096),
('So', 'ON', 'H', 4096),
('So', 'ON', 'N', 4096),
('So', 'ON', 'Na', 4096),
('So', 'ON', 'W', 4096),
('So', 'R', 'N', 4096),
('Zl', 'WS', 'N', 5),
('Zp', 'B', 'N', 5),
('Zs', 'CS', 'N', 1),
('Zs', 'WS', 'F', 1),
('Zs', 'WS', 'N', 1),
('Zs', 'WS', 'Na', 4097),
]
_db_pgtbl = (
'\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\x0c\r\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f !"#$%&\'()*+,-./0123455565575555'
'555555555555589:5;5<55=5>55555?@55AB555C5555555D555E55F555555555'
'G555H5555555IJ55555555K55555555LM555N\x15OPQRST55555555555555555555'
'55555555555555555555555UVVVVVVVVWWWWWWWWWWWWWWWWWWWWWWWWWXYZ[\\]^'
'_`abcd\x15efghijklkmnopqrstukvkkkkk\x15\x15\x15wxykkkkkkkkkk\x15\x15\x15\x15zkkkkkkkkkkk'
'kkkk\x15\x15{kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk\x15\x15|}kkk~kkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk\x7fkkkkkkkkkkk\x80kkk'
'kkkkkkkkkkkkkkkk\x81\x82\x83\x84\x85\x86\x87\x88((\x89kkkkkkkkkkkkk\x8akkkkk\x8bk\x8c\x8d\x8e\x8f\x90\x91\x92\x93\x94\x95kkkkkk'
'\x96\x975555555\x98\x99\x9a55555555555555555555555\x9b55555\x9c55555555555555555\x9d5555'
'5555555555555555555555555555555555\x9e55555555555555555555555555555'
'55555555555555555555555555555555555555\x9f5555555555555555\xa0\xa15555555'
'55555555555555\xa2\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\x9b5\xa4\xa3\xa3\xa3\xa3\xa5'
'\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3'
'\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3'
'\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3'
'\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa5'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'\xa6\xa7kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\xa8'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\xa8'
)
_db_pages = ( 
'\x01\x01\x01\x01\x01\x01\x01\x01\x01\x02\x00\x03\x04\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x00\x00\x00\x02\xd5\x90\x90\x85\xa2\x85\x90\x91\x9ao\x90\xaf~e\x7f~EEEEEEEEEE\x7f\x90\xbd\xbc\xbd\x90'
'\x9088888888888888888888888888\x9a\x90o\xa9b\xa9\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x9a\xbco\xbc\x01'
'\x01\x01\x01\x01\x01\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\xd2\x88\xa2\xa2\x9e\xa2\xcd\x88\xa6\xcc-x\xbc\x07\xc9\xa9\xc1\xb1RR\xa6\x1b\x88\x8a\xa6R-tYYY\x88'
'77777757777777775777777\xb45777775\x19\x19\x19\x1b\x1b\x1b\x1b\x19\x1b\x19\x19\x19\x1b\x19\x19\x1b\x1b\x19\x1b\x19\x19\x1b\x1b\x1b\xb4\x19\x19\x19\x1b\x19\x1b\x19\x1b'
'7\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x197\x197\x1b7\x1b7\x1b7\x197\x1b7\x1b7\x1b7\x1b7\x1b5\x197\x1b7\x197\x1b7\x1b7\x195\x197\x1b7\x1b\x197\x1b7\x1b7\x1b5'
'\x195\x197\x197\x1b7\x19\x195\x197\x197\x1b7\x1b5\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b5\x197\x1b7\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b77\x1b7\x1b7\x1b\x1b'
'\x1b77\x1b7\x1b77\x1b777\x1b\x1b7777\x1b77\x1b777\x1b\x1b\x1b77\x1b77\x1b7\x1b7\x1b77\x1b7\x1b\x1b7\x1b77\x1b777\x1b7\x1b77\x1b\x1b07\x1b\x1b\x1b'
'000074\x1b74\x1b74\x1b7\x197\x197\x197\x197\x197\x197\x197\x19\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b74\x1b7\x1b777\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b\x1b\x1b77\x1b77\x1b'
'\x1b7\x1b7777\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b0\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%))$$$$$'
"%%\xa8\xa8\xa6\xa8)')''')'))\x1f$\xa8\xa8\xa8\xa8\xa8\xa8\xa6\xa6\xa6\xa6\xa8\xa6\xa8\xa6%%%%%\xa8\xa8\xa8\xa8\xa8\xa8\xa8)\xa8$\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8"
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>?>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>7\x1b7\x1b)\xa87\x1b\x15\x15#\x1b\x1b\x1b\x8e7'
'\x15\x15\x15\x15\xa8\xa87\x8f777\x157\x1577\x1b55555555555555555\x15555555577\x1b\x1b\x1b\x1b\x1b\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19'
'\x19\x19\x1b\x19\x19\x19\x19\x19\x19\x19\x1b\x1b\x1b\x1b\x1b7\x1b\x1b777\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b7\x1b\xb97\x1b77\x1b\x1b777'
'757777777777777755555555555555555555555555555555\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19'
'\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b\xc7@@@@@<<7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'77\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x15777777777777777'
'77777777777777777777777\x15\x15$\x87\x87\x87\x87\x87\x87\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x87h\x15\x15\xcc\xcc\xa1\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@j@'
'\x94@@\x94@@\x94@\x15\x15\x15\x15\x15\x15\x15\x15333333333333333333333333333\x15\x15\x15\x15\x15333\x94\x95\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x06\x06\x06\x06\x06\x06\xb9\xb9\xab\x84\x84\x9d}y\xcc\xcc@@@@@@@@@@@y\x05\x15yy,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
'\x1e,,,,,,,,,,@@@@@@@@@@@@@@@@@@@@@BBBBBBBBBB\x84zzy,,@,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,y,@@@@@@@\x06\xcc@@@@@@\x1e\x1e@@\xcc@@@@,,DDDDDDDDDD,,,\xc0\xc0,'
'yyyyyyyyyyyyyy\x15\x05,@,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,@@@@@@@@@@@@@@@@'
'@@@@@@@@@@@\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,@@@@@@@@@@@,\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'GGGGGGGGGG333333333333333333333333333333333@@@@@@@@@**\xcc\x8e\x8e\x8e*\x15\x15\x15\x15\x15'
'3333333333333333333333@@@@*@@@@@@@@@*@@@*@@@@@\x15\x15\x94\x94\x94\x94\x94\x94\x94\x94\x94\x94\x94\x94\x94\x94\x94\x15'
'3333333333333333333333333@@@\x15\x15\x94\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,,,,,,\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@'
'@@@:000000000000000000000000000000000000000000000000000000@:@0::'
':@@@@@@@@::::@::0@@@@@@@0000000000@@\x87\x87FFFFFFFFFF\x87$00000000000000'
'0@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x150\x15\x15\x150000\x15\x15@0::'
':@@@@\x15\x15::\x15\x15::@0\x15\x15\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x1500\x15000@@\x15\x15FFFFFFFFFF00\xa1\xa1VVVVVV\xc7\xa1\x15\x15\x15\x15'
'\x15@@:\x15000000\x15\x15\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500\x1500\x15\x15@\x15::'
':@@\x15\x15\x15\x15@@\x15\x15@@@\x15\x15\x15@\x15\x15\x15\x15\x15\x15\x150000\x150\x15\x15\x15\x15\x15\x15\x15FFFFFFFFFF@@000@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15@@:\x15000000000\x15000\x150000000000000000000000\x150000000\x1500\x1500000\x15\x15@0::'
':@@@@@\x15@@:\x15::@\x15\x150\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500@@\x15\x15FFFFFFFFFF\x87\xa1\x15\x15\x15\x15\x15\x15\x150\x15\x15\x15\x15\x15\x15'
'\x15@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500000\x15\x15@0:@'
':@@@@\x15\x15::\x15\x15::@\x15\x15\x15\x15\x15\x15\x15\x15@:\x15\x15\x15\x1500\x15000@@\x15\x15FFFFFFFFFF\xc70VVVVVV\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15@0\x15000000\x15\x15\x15000\x150000\x15\x15\x1500\x150\x1500\x15\x15\x1500\x15\x15\x15000\x15\x15\x15000000000000\x15\x15\x15\x15::'
'@::\x15\x15\x15:::\x15:::@\x15\x150\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15FFFFFFFFFFVVV\xcc\xcc\xcc\xcc\xcc\xcc\xa1\xcc\x15\x15\x15\x15\x15'
'@:::\x1500000000\x15000\x1500000000000000000000000\x150000000000000000\x15\x15\x150@@'
'@::::\x15@@@\x15@@@@\x15\x15\x15\x15\x15\x15\x15@@\x15000\x15\x15\x15\x15\x1500@@\x15\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x15\x15\x15[[[[[[[\xc7'
'\x15@::\x1500000000\x15000\x1500000000000000000000000\x150000000000\x1500000\x15\x15@0:='
':::::\x15=::\x15::@@\x15\x15\x15\x15\x15\x15\x15::\x15\x15\x15\x15\x15\x15\x150\x1500@@\x15\x15FFFFFFFFFF\x1500\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15@::\x1500000000\x15000\x1500000000000000000000000000000000000000000\x15\x150::'
':@@@@\x15:::\x15:::@0\x15\x15\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x15\x15\x15\x15000@@\x15\x15FFFFFFFFFFVVVVVV\x15\x15\x15\xc7000000'
'\x15\x15::\x15000000000000000000\x15\x15\x15000000000000000000000000\x15000000000\x150\x15\x15'
'0000000\x15\x15\x15@\x15\x15\x15\x15:::@@@\x15@\x15::::::::\x15\x15\x15\x15\x15\x15FFFFFFFFFF\x15\x15::\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15000000000000000000000000000000000000000000000000@0/@@@@@@@\x15\x15\x15\x15\xa1'
'000000$@@@@@@@@\x87FFFFFFFFFF\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x1500\x150\x15\x1500\x150\x15\x150\x15\x15\x15\x15\x15\x150000\x150000000\x15000\x150\x150\x15\x1500\x150000@0/@@@@@@\x15@@0\x15\x15'
'00000\x15$\x15@@@@@@\x15\x15FFFFFFFFFF\x15\x150000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0\xc7\xc7\xc7\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\xc7\x87\xc7\xc7\xc7@@\xc7\xc7\xc7\xc7\xc7\xc7FFFFFFFFFFVVVVVVVVVV\xc7@\xc7@\xc7@\x99n\x99n::'
'00000000\x15000000000000000000000000000000000000\x15\x15\x15\x15@@@@@@@@@@@@@@:'
'@@@@@\x87@@00000@@@@@@@@@@@\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\x15\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7@\xc7\xc7\xc7\xc7\xc7\xc7\x15\xc7\xc7\x87\x87\x87\x87\x87\xc7\xc7\xc7\xc7\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000::@@@@:@@@@@@:@@::@@0'
'FFFFFFFFFF\x87\x87\x87\x87\x87\x87000000::@@0000@@@0:::00:::::::000@@@@00000000000'
'00@::@@::::::@0:FFFFFFFFFF:::@\xc7\xc777777777777777777777777777777777'
'777777\x157\x15\x15\x15\x15\x157\x15\x150000000000000000000000000000000000000000000\x87$000'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111100000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'000000000\x150000\x15\x150000000\x150\x150000\x15\x1500000000000000000000000000000000'
'000000000\x150000\x15\x15000000000000000000000000000000000\x150000\x15\x150000000\x15'
'0\x150000\x15\x15000000000000000\x150000000000000000000000000000000000000000'
'00000000000000000\x150000\x15\x150000000000000000000000000000000000000000'
'000000000000000000000000000\x15\x15@@@\x87\x87\x87\x87\x87\x87\x87\x87\x87WWWWWWWWWVVVVVVVVVVV\x15\x15\x15'
'0000000000000000\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x1577777777777777777777777777777777'
'777777777777777777777777777777777777777777777777777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15'
'h000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'000000000000000000000000000000000000000000000\x87\x8700000000000000000'
'\xd400000000000000000000000000\x99n\x15\x15\x1500000000000000000000000000000000'
'0000000000000000000000000000000000000000000\x87\x87\x87JJJ00000000\x15\x15\x15\x15\x15\x15\x15'
'0000000000000\x150000@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15000000000000000000@@@\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000\x15000\x15@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000@@:@@@@@@@::'
'::::::@::@@@@@@@@@@@\x87\x87\x87$\x87\x87\x87\xa10@\x15\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x15[[[[[[[[[[\x15\x15\x15\x15\x15\x15'
'\x8e\x8e\x8e\x8e\x8e\x8eh\x8e\x8e\x8e\x8e@@@\x08\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x1500000000000000000000000000000000'
'000$0000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000@0\x15\x15\x15\x15\x150000000000000000'
'000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000\x15@@@::::@@:::\x15\x15\x15\x15::@::::::@@@\x15\x15\x15\x15'
'\xcc\x15\x15\x15\x8e\x8eFFFFFFFFFF000000000000000000000000000000\x15\x1500000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000\x15\x15\x15\x150000000000000000'
'0000000000\x15\x15\x15\x15\x15\x15FFFFFFFFFFW\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'00000000000000000000000@@::@\x15\x15\x87\x8700000000000000000000000000000000'
'000000000000000000000:@:@@@@@@@\x15@:@::@@@@@@@@::::::@@@@@@@@@@\x15\x15@'
'FFFFFFFFFF\x15\x15\x15\x15\x15\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x15\x87\x87\x87\x87\x87\x87\x87$\x87\x87\x87\x87\x87\x87\x15\x15@@@@@@@@@@@@@@<\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@@@:00000000000000000000000000000000000000000000000@:@@@@@:@:::'
'::@::0000000\x15\x15\x15\x15FFFFFFFFFF\x87\x87\x87\x87\x87\x87\x87\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7@@@@@@@@@\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x15\x15\x15'
'@@:000000000000000000000000000000:@@@@::@@:@@@00FFFFFFFFFF000000'
'00000000000000000000000000000000000000@:@@:::@:@@@::\x15\x15\x15\x15\x15\x15\x15\x15\x87\x87\x87\x87'
'000000000000000000000000000000000000::::::::@@@@@@@@::@@\x15\x15\x15\x87\x87\x87\x87\x87'
'FFFFFFFFFF\x15\x15\x15000FFFFFFFFFF000000000000000000000000000000$$$$$$\x87\x87'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x87\x87\x87\x87\x87\x87\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15@@@\x87@@@@@@@@@@@@@:@@@@@@@0000@0000::@00\x15@@\x15\x15\x15\x15\x15\x15'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\x15\x15\x15\x15\x15\x15@@@@'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777'
'\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x157\x157\x157\x157\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x15\x1b\x1b77774\xa8\x1b\xa8'
'\xa8\xa8\x1b\x1b\x1b\x15\x1b\x1b77774\xa8\xa8\xa8\x1b\x1b\x1b\x1b\x15\x15\x1b\x1b7777\x15\xa8\xa8\xa8\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777\xa8\xa8\xa8\x15\x15\x1b\x1b\x1b\x15\x1b\x1b77774\xa8\xa8\x15'
'\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\x08\x08\x08\n\x11ghhggg\x88\x8evs\x98wur\x98w\x88\x88\x88\x8e\x89\x88\x88\x89\xd0\xd1\x0b\x12\x0f\r\x14\xd2\x82\x84\x82\x82\x84\x88\x8e\x8e\x8ext\x88\x8e\x8e\x88a'
'a\x8e\x8e\x8e\xac\x99n\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\xb9\x8ea\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\xd4\x08\x08\x08\x08\x08\x15\x0c\x13\t\x10\x08\x08\x08\x08\x08\x08T%\x15\x15RTTTTT\xae\xae\xb9\x99n '
'TRRRRTTTTT\xae\xae\xb9\x99n\x15%%%%%%%%%%%%%\x15\x15\x15\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa0\xa1\xa1\x9e\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@<<<<@<<<@@@@@@@@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc7\xc9\xcc\xc9\xcc7\xcc\xc9\x1b777\x1b\x1b777\x19\xcc7\xc9\xcc\xbb77777\xcc\xcc\xcc\xc9\xc9\xcc7\xcc5\xcc7\xcc7577\xc3\x1b7777\x1b0000\x1b\xcc\xcc\x1b\x1b77'
'\xba\xb9\xb9\xb9\xb97\x1b\x1b\x1b\x1b\xcc\xb9\xcc\xcc\x1b\xc7[[[YY[[[[[[YYYY[HHHHHHHHHHHHKKKKIIIIIIIIIILLLLLL'
'JJJ7\x1bJJJJY\xcc\xcc\x15\x15\x15\x15\xb4\xb4\xb4\xb4\xb4\xc9\xc9\xc9\xc9\xc9\xb9\xb9\xcc\xcc\xcc\xcc\xb9\xcc\xcc\xb9\xcc\xcc\xb9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xb9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xc9\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xb9\xb9\xcc\xcc\xb4\xcc\xb4\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9'
'\xb4\xba\xb5\xb5\xba\xb9\xb9\xb4\xb5\xba\xba\xb5\xba\xba\xb9\xb4\xb9\xb5\xae\xb2\xb9\xb5\xba\xb9\xb9\xb9\xb5\xba\xba\xb5\xb4\xb5\xb5\xba\xba\xb4\xba\xb4\xba\xb4\xb4\xb4\xb4\xb5\xb5\xba\xb5\xba\xba\xba\xba\xba\xb4\xb4\xb4\xb4\xb9\xba\xb9\xba\xb5\xb5\xba\xba'
'\xba\xba\xba\xba\xba\xba\xba\xba\xb5\xba\xba\xba\xb5\xb9\xb9\xb9\xb9\xb9\xb5\xba\xba\xba\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xba\xb5\xb4\xba\xb9\xb5\xb5\xb5\xb5\xba\xba\xb5\xb5\xb9\xb9\xb5\xb5\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba'
'\xba\xba\xb5\xb5\xba\xba\xb5\xb5\xba\xba\xba\xba\xba\xb9\xb9\xba\xba\xba\xba\xb9\xb9\xb4\xb9\xb9\xba\xb4\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xba\xba\xb9\xb4\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xb9\xb9\xb9\xb9\xb9\xba\xb5'
'\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xba\xba\xba\xba\xba\xb9\xb9\xba\xba\xb9\xb9\xb9\xb9\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xb9\xb9\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x99n\x99n\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xba\xba\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x9cq\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xcc\xb9\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc7\xcc\xcc\xcc\xcc\xcc\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xb9\xb9\xb9\xb9\xb9\xb9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15ZZZZZZZZZYYYYYYYYYYYZZZZZZZZZYYY'
'YYYYYYYYRRRRRRRRRQQQQQQQQQQQ\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\\YYYYYYYYYYZZZZZZZZZYZ'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcc\xcc\xcc\xcc\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcc\xcc\xc9\xc9\xc9\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xc9\xcc\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xc9\xcc\xcc\xc9\xb4\xcc\xcc\xcc\xcc\xc9\xc9\xcc\xcc'
'\xc9\xb4\xcc\xcc\xcc\xcc\xc9\xc9\xc9\xcc\xcc\xc9\xcc\xcc\xc9\xc9\xc9\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xc9\xc9\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9'
'\xcc\xcc\xcc\xcc\xcc\xc9\xc9\xcc\xcc\xc9\xcc\xcc\xcc\xcc\xc9\xc9\xcc\xcc\xcc\xcc\xc9\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xcc\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xc9\xcc\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xc9\xcc\xc9\xc9\xc9\xcc\xc9\xc9\xc9\xc9\xcc\xc9\xc9\xcc\xb4\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc7\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xc9'
'\xcc\xcc\xcc\xcc\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcc\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcc\xc9\xcc\xcc\xcc\xcc\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x99n\x99n\x99n\x99n\x99n\x99n\x99nZZZZZZZZZY'
'\\\\\\\\\\\\\\\\\\[\\\\\\\\\\\\\\\\\\[\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xba\xb9\xb9\xba\xba\x99n\xb9\xba\xba\xb9\xba\xba\xba\xb9\xb9\xb9\xb9\xb9\xba\xba\xba\xba\xb9\xb9\xb9\xb9\xb9\xba\xba\xba\xb9\xb9\xb9\xba\xba\xba\xba\x9ao\x9ao\x9ao\x9ao\x99n\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9'
'\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9'
'\xb9\xb9\xb9\x99n\x9ao\x99n\x99n\x99n\x99n\x99n\x99n\x99n\x99n\x99n\xb9\xb9\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xba\xb9\xb9\xb9\xb9\xb9\xb9\xb9'
'\xba\xba\xba\xba\xba\xba\xb9\xb9\xb9\xba\xb9\xb9\xb9\xb9\xba\xba\xba\xba\xba\xb9\xba\xba\xb9\xb9\x99n\x99n\xba\xb9\xb9\xb9\xb9\xba\xb9\xba\xba\xba\xb9\xb9\xba\xba\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xba\xba\xba\xba\xba\xba\xb9\xb9\x99n\xb9\xb9'
'\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xb9\xba\xba\xba\xba\xb9\xb9\xba\xb9\xba\xb9\xb9\xba\xb9\xba\xba\xba\xba\xb9\xb9\xb9\xb9\xb9\xba\xba\xb9\xb9\xb9\xb9\xb9\xb9\xba\xba\xba\xb9'
'\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xba\xba\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xba\xba\xb9\xb9\xb9\xb9\xba\xba\xba\xba\xb9\xba\xba\xb9\xb9\xba\xba\xb9\xb9\xb9\xb9\xba\xba\xba\xba\xba\xba\xba'
'\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xb9\xb9\xba\xba\xba\xba\xba\xba\xba\xba\xb9\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba'
'\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xb9\xb9\xb9\xb9\xb9\xba\xb9\xba\xb9\xb9\xb9\xba\xba\xba\xba\xba\xb9\xb9\xb9\xb9\xb9\xba\xba\xba\xb9\xb9\xb9\xb9\xba\xb9\xb9\xb9\xba\xba\xba\xba\xba\xb9\xba\xb9\xb9'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9\xb9'
'\xb9\xb9\xb9\xb9\xb9\xcc\xcc\xb9\xb9\xb9\xb9\xb9\xb9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xc9\xc9\xc9\xc9\xc9\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'77777777777777777777777777777777777777777777777\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x157\x1b777\x1b\x1b7\x1b7\x1b7\x1b7777\x1b7\x1b\x1b7\x1b\x1b\x1b\x1b\x1b\x1b%%77'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\xcc\xcc\xcc\xcc\xcc\xcc7\x1b7\x1b@@@7\x1b\x15\x15\x15\x15\x15\x8e\x8e\x8e\x8e[\x8e\x8e'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x1b\x15\x15\x15\x15\x15\x1b\x15\x150000000000000000'
'0000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15$\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@'
'00000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x150000000\x150000000\x150000000\x150000000\x15'
'0000000\x150000000\x150000000\x150000000\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@'
'\x8e\x8extxt\x8e\x8e\x8ext\x8ext\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8eh\x8e\x8eh\x8ext\x8e\x8ext\x99n\x99n\x99n\x99n\x8e\x8e\x8e\x8e\x8e(\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8e\x8ehh\x8e\x8e\x8e\x8e'
'h\x8e\x98\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\x15\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce'
'\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce'
'\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce'
'\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce'
'\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\x15\x15\x15\x15'
'\xd3\x92\x92\x92\xce&1M\x9cq\x9cq\x9cq\x9cq\x9cq\xce\xce\x9cq\x9cq\x9cq\x9cqi\x9bpp\xceMMMMMMMMMAAAA;;i&&&&&\xce\xceMMM&1\x92\xce\xcc'
'\x15111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111\x15\x15AA\xaa\xaa&&1i1111111111111111111111111111111'
'11111111111111111111111111111111111111111111111111111111111\x92&&&1'
'\x15\x15\x15\x15\x1511111111111111111111111111111111111111111\x15\x15\x15111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111\x15\xc8\xc8XXXX\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8111111111111111111111111111\x15\x15\x15\x15\x15'
'\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x151111111111111111'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xce\xce\x15XXXXXXXXXX\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8UUUUUUUU\xce]]]]]]]]]]]]]]]\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xce\xce\xce\xc8'
'XXXXXXXXXX\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8]]]]]]]]]]]]]]]'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xce\xce\xce\xce\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x15'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xce\xce\xce\xce\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xce\xce\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xce'
'1111121111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1112111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111112111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111211111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'2112111212111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111121111111111111111111111111111111111'
'1111111111112111111121211111111111111111111111111111111111111112'
'2111111111111111111111111111111211111111211111111111111111111111'
'1111111111111211111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111112111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111211111111111111111111111111111111111111111111111111111111111'
'1111112111111111111111111111111111111111121212111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1212221111112111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1222211111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111112111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111211111112111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111211111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111122'
'1111111111112221211111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111121'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111112111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111112111111111111111111111111111111111111111111111'
'1111112111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111211111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111121'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111112111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111121111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111211112111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111112111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111112111111111111111111111111111111'
'1111112111112111111111111111111111111111111111111111111121111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111112111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'111111111111111111111&111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111\x15\x15\x15\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce\xce'
'\xce\xce\xce\xce\xce\xce\xce\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000000000000000000000000000$$$$$$\x87\x87'
'000000000000$\x8e\x8e\x8e0000000000000000FFFFFFFFFF00\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b0@<<<\x8e@@@@@@@@@@\x8e)'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b%%@@00000000000000000000000000000000'
'00000000000000000000000000000000000000JJJJJJJJJJ@@\x87\x87\x87\x87\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15'
'\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8)))))))))\xa8\xa87\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b%\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b77\x1b'
'7\x1b7\x1b7\x1b7\x1b)\xa5\xa57\x1b7\x1b07\x1b7\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7777\x15\x1577777\x1b7\x1b\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150%%\x1b00000'
'00@000@0000@00000000000000000000000::@@:\xcc\xcc\xcc\xcc\x15\x15\x15\x15VVVVVV\xc7\xc7\xa1\xc2\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000\x8e\x8e\x8e\x8e\x15\x15\x15\x15\x15\x15\x15\x15'
'::00000000000000000000000000000000000000000000000000::::::::::::'
'::::@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x87\x87FFFFFFFFFF\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@@@@@@000000\x87\x87\x870\x870\x15\x15'
'FFFFFFFFFF0000000000000000000000000000@@@@@@@@\x87\x870000000000000000'
'0000000@@@@@@@@@@@::\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x8711111111111111111111111111111\x15\x15\x15'
'@@@:00000000000000000000000000000000000000000000000@::@@@@::@:::'
':\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x15$FFFFFFFFFF\x15\x15\x15\x15\x87\x8700000@$000000000FFFFFFFFFF00000\x15'
'00000000000000000000000000000000000000000@@@@@@::@@::@@\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000@00000000@:\x15\x15FFFFFFFFFF\x15\x15\x87\x87\x87\x870000000000000000$000000\xc7\xc7\xc70:@:00'
'000000000000000000000000000000000000000000000000@0@@@00@@00000@@'
'0@0\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500$\x87\x8700000000000:@@::\x87\x870$$:@\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15000000\x15\x15000000\x15\x15000000\x15\x15\x15\x15\x15\x15\x15\x15\x150000000\x150000000\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xa5%%%%\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'00000000000000000000000000000000000::@::@::\x87:@\x15\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x15'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000'
'0000000\x15\x15\x15\x150000000000000000000000000000000000000000000000000\x15\x15\x15\x15'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111211111112111121111111'
'1111111111111111111111111111111111111111111111111121111111111111'
'1111111111111111121211111111111111111111111111111111111111111211'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111\x16\x161111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x153@3333333333\xae3333333333333\x1533333\x153\x15'
'33\x1533\x153333333333,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\xa4\xa4\xa4\xa4\xa4\xa4\xa4\xa4\xa4\xa4\xa4\xa4\xa4\xa4'
'\xa4\xa4\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,++++++,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,m\x98'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,++\x9d\xcc\x15\x15'
'>>>>>>>>>>>>>>>>\x92\x92\x92\x93\x92\x92\x92\x9bp\x92\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@@@@\x92iicc\x9bp\x9bp\x9bp\x9bp\x9bp\x9b'
'p\x9bp\x9bp\x92\x92\x9bp\x92\x92\x92\x92ccc\x80\x92\x81\x15\x92\x81\x92\x92i\x9cq\x9cq\x9cq\x86\x92\x92\xb0f\xbf\xbf\xbe\x15\x92\xa3\x86\x92\x15\x15\x15\x15+,+,+\x15+,+,+,+,+,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x15\x15\x08'
'\x15\x8b\x8b\x83\x9f\x83\x8b\x8c\x96k\x8b\xad{d|{CCCCCCCCCC|\x8b\xb7\xb6\xb7\x8b\x8b66666666666666666666666666\x96\x8bk\xa7`'
'\xa7\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x96\xb6k\xb6\x96k\x8d\x97l\x8d\x8d.........."...............'
'..............................!!...............................\x15'
'\x15\x15......\x15\x15......\x15\x15......\x15\x15...\x15\x15\x15\x9f\x9f\xb6\xa7\xca\x9f\x9f\x15\xcb\xb8\xb8\xb8\xb8\xcb\xcb\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x0e\x0e\x0e\xcc\xc9\x15\x15'
'000000000000\x1500000000000000000000000000\x150000000000000000000\x1500\x150'
'00000000000000\x15\x1500000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'00000000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15'
'\x87\x8e\x87\x15\x15\x15\x15VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV\x15\x15\x15\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN[[[[\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc[[\xcc\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7@\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000\x15\x15\x1500000000000000000000000000000000'
'00000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@SSSSSSSSSSSSSSSSSSSSSSSSSSS\x15\x15\x15\x15'
'00000000000000000000000000000000VVVV\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000'
'0J00000000J\x15\x15\x15\x15\x1500000000000000000000000000000000000000@@@@@\x15\x15\x15\x15\x15'
'000000000000000000000000000000\x15\x8700000000000000000000000000000000'
'0000\x15\x15\x15\x1500000000\x87JJJJJ\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'7777777777777777777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b000000000000000000000000000000000000000000000000'
'000000000000000000000000000000\x15\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x150000000000000000'
'000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'333333\x15\x153\x1533333333333333333333333333333333333333333333\x1533\x15\x15\x153\x15\x153'
'3333333333333333333333\x15\x94^^^^^^^^33333333333333333333333\xcf\xcf^^^^^^^'
'3333333333333333333333333333333\x15\x15\x15\x15\x15\x15\x15\x15^^^^^^^^^\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x153333333333333333333\x1533\x15\x15\x15\x15\x15^^^^^'
'3333333333333333333333^^^^^^\x15\x15\x15\x8e33333333333333333333333333\x15\x15\x15\x15\x15\x94'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'33333333333333333333333333333333333333333333333333333333\x15\x15\x15\x15^^33'
'^^^^^^^^^^^^^^^^\x15\x15^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^'
'3@@@\x15@@\x15\x15\x15\x15\x15@@@@3333\x15333\x15333333333333333333333333333\x15\x15\x15\x15@@@\x15\x15\x15\x15@'
'____^^^^\x15\x15\x15\x15\x15\x15\x15\x15\x94\x94\x94\x94\x94\x94\x94\x94\x94\x15\x15\x15\x15\x15\x15\x1533333333333333333333333333333^^\x94'
'33333333333333333333333333333^^^\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'33333333\xcf3333333333333333333333333333@@\x15\x15\x15\x15^^^^^\x94\x94\x94\x94\x94\x94\x94\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'333333333333333333333333333333333333333333333333333333\x15\x15\x15\x8e\x8e\x8e\x8e\x8e\x8e\x8e'
'3333333333333333333333\x15\x15^^^^^^^^3333333333333333333\x15\x15\x15\x15\x15^^^^^^^^'
'333333333333333333\x15\x15\x15\x15\x15\x15\x15\x94\x94\x94\x94\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15^^^^^^^\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'3333333333333333333333333333333333333333333333333333333333333333'
'333333333\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'999999999999999999999999999999999999999999999999999\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x15\x15\x15\x15\x15\x15\x15^^^^^^'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15PPPPPPPPPOOOOOOOOOOOOOOOOOOOOOO\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
':@:00000000000000000000000000000000000000000000000000000@@@@@@@@'
'@@@@@@@\x87\x87\x87\x87\x87\x87\x87\x15\x15\x15\x15\\\\\\\\\\\\\\\\\\[[[[[[[[[[[FFFFFFFFFF\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@'
'@@:000000000000000000000000000000000000000000000:::@@@@::@@\x87\x87\n\x87\x87'
'\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000000000000\x15\x15\x15\x15\x15\x15\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x15'
'@@@000000000000000000000000000000000000@@@@@:@@@@@@@@\x15FFFFFFFFFF'
'\x87\x87\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500000000000000000000000000000000000@\x87\x870\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@:000000000000000000000000000000000000000000000000:::@@@@@@@@@:'
':0000\x87\x87\x87\x87\x87@@@\x87\x15\x15FFFFFFFFFF0\x870\x87\x87\x87\x15VVVVVVVVVVVVVVVVVVVV\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000\x150000000000000000000000000:::@@@::@:@@\x87\x87\x87\x87\x87\x87\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000\x150\x150000\x15000000000000000\x150000000000\x87\x15\x15\x15\x15\x15\x150000000000000000'
'0000000000000000000000000000000@:::@@@@@@@@\x15\x15\x15\x15\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x15'
'@@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500000\x15\x15@0::'
'@::::\x15\x15::\x15\x15:::\x15\x150\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x15\x1500000::\x15\x15@@@@@@@\x15\x15\x15@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000:::@@@@@@:@::::@'
'@:@@00\x870\x15\x15\x15\x15\x15\x15\x15\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000000:::@@@@\x15\x15::::@@:@'
'@\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x870000@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000:::@@@@@@@@::@:@'
'@\x87\x87\x870\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15FFFFFFFFFF\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000@:@::@@@@@@:@\x15\x15\x15\x15\x15\x15\x15\x15'
'FFFFFFFFFF\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000\x15\x15\x15@@@::@@@@:@@@@@\x15\x15\x15\x15FFFFFFFFFFVV\x87\x87\x87\xc7'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1577777777777777777777777777777777'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1bFFFFFFFFFFVVVVVVVVV\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'00000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ'
'JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ\x15\x87\x87\x87\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000\x15FFFFFFFFFF\x15\x15\x15\x15\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15000000000000000000000000000000\x15\x15@@@@@\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000@@@@@@@\x87\x87\x87\x87\x87\xc7\xc7\xc7\xc7'
'$$$$\x87\xc7\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15FFFFFFFFFF\x15VVVVVVV\x15000000000000000000000\x15\x15\x15\x15\x15000'
'0000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'00000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150::::::::::::::::::::::::::::::::::::::::::::::\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@$$$$$$$$$$$$$\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'11\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000\x15\x15\x15\x15\x150000000000000\x15\x15\x15'
'000000000\x15\x15\x15\x15\x15\x15\x150000000000\x15\x15\xc7@@\x87\x08\x08\x08\x08\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x15\x15\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7::@@@\xc7\xc7\xc7::::::\x08\x08\x08\x08\x08\x08\x08\x08@@@@@'
'@@@\xc7\xc7@@@@@@@\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7@@@@\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc@@@\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15VVVVVVVVVVVVVVVVVV\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b777777777777'
'77777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b777777777777777777777777'
'77\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1577\x15\x157\x15\x1577\x15\x157777\x1577777777\x1b\x1b\x1b\x1b\x15\x1b\x15\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b77\x157777\x15\x1577777777\x157777777\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77\x157777\x15'
'77777\x157\x15\x15\x157777777\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777'
'777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7777'
'7777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777'
'7777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777777777777777777777'
'7\xb3\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xba\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb3\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xba\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb3\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xba\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb3\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xba\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb3\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\xba\x1b\x1b\x1b\x1b\x1b\x1b7\x1b\x15\x15DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\xc7\xc7\xc7\xc7@@@@@'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7@\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7@\xc7\xc7\x87\x87\x87\x87\x87\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@\x15@@@@@@@@@@@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'3333333333333333333333333333333333333333333333333333333333333333'
'3333333333333333333333333333333333333333333333333333333333333333'
'3333333333333333333333333333333333333333333333333333333333333333'
'33333\x15\x15^^^^^^^^^@@@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
',,,,\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,\x15,,\x15,\x15\x15,\x15,,,,,,,,,,\x15,,,,\x15,\x15,\x15\x15\x15\x15'
'\x15\x15,\x15\x15\x15\x15,\x15,\x15,\x15,,,\x15,,\x15,\x15\x15,\x15,\x15,\x15,\x15,\x15,,\x15,\x15\x15,,,,\x15,,,,,,,\x15,,,,\x15,,,,\x15,\x15'
',,,,,,,,,,\x15,,,,,,,,,,,,,,,,,\x15\x15\x15\x15\x15,,,\x15,,,,,\x15,,,,,,,,,,,,,,,,,\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xb9\xb9\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'RRRRRRRRRRR[[\x15\x15\x15\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc7\x15\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc4\xc4\xc4\xc4\xc4\xc4\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xcc\xcc\x15\x15\x15\x15\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\xc4\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc8\xc8\xc8\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x15\x15\x15\x15\x15'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x15\x15\x15\x15\x15\x15\x15\xc8\xc8\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xa8\xa8\xa8\xa8\xa8'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\xcc\xcc\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'1211111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111112111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111211111111111111111111111111111'
'1111111111111111111111111111111112111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111112111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1112111111112111111111111111211111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111112111111111111111111211'
'1111111111111111111111111211111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111211111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111112111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111112111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111112111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'11111111111111111111111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111\x16\x1611111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x15\x15'
'\x15\x08\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08'
'\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x15\x15'
)

def _get_record(code):
    return _db_records[ord(_db_pages[(ord(_db_pgtbl[code >> 8]) << 8) + (code & 255)])]

def category(code): return _get_record(code)[0]
def bidirectional(code): return _get_record(code)[1]
def east_asian_width(code): return _get_record(code)[2]
def isspace(code): return _get_record(code)[3] & 1 != 0
def isalpha(code): return _get_record(code)[3] & 2 != 0
def islinebreak(code): return _get_record(code)[3] & 4 != 0
def isnumeric(code): return _get_record(code)[3] & 64 != 0
def isdigit(code): return _get_record(code)[3] & 128 != 0
def isdecimal(code): return _get_record(code)[3] & 256 != 0
def isalnum(code): return _get_record(code)[3] & 66 != 0
def isupper(code): return _get_record(code)[3] & 8 != 0
def istitle(code): return _get_record(code)[3] & 16 != 0
def islower(code): return _get_record(code)[3] & 32 != 0
def iscased(code): return _get_record(code)[3] & 56 != 0
def isxidstart(code): return _get_record(code)[3] & 1024 != 0
def isxidcontinue(code): return _get_record(code)[3] & 2048 != 0
def isprintable(code): return _get_record(code)[3] & 4096 != 0
def mirrored(code): return _get_record(code)[3] & 512 != 0
def iscaseignorable(code): return _get_record(code)[3] & 8192 != 0
_decimal = {
3558: 0,
3559: 1,
3560: 2,
3561: 3,
3562: 4,
3563: 5,
3564: 6,
3565: 7,
3566: 8,
3567: 9,
43504: 0,
43505: 1,
43506: 2,
43507: 3,
43508: 4,
43509: 5,
43510: 6,
43511: 7,
43512: 8,
43513: 9,
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
69872: 0,
69873: 1,
69874: 2,
69875: 3,
69876: 4,
69877: 5,
69878: 6,
69879: 7,
69880: 8,
69881: 9,
69942: 0,
69943: 1,
69944: 2,
69945: 3,
69946: 4,
69947: 5,
69948: 6,
69949: 7,
69950: 8,
69951: 9,
70096: 0,
70097: 1,
70098: 2,
70099: 3,
70100: 4,
70101: 5,
70102: 6,
70103: 7,
70104: 8,
70105: 9,
70384: 0,
70385: 1,
70386: 2,
70387: 3,
70388: 4,
70389: 5,
70390: 6,
70391: 7,
70392: 8,
70393: 9,
70864: 0,
70865: 1,
70866: 2,
70867: 3,
70868: 4,
70869: 5,
70870: 6,
70871: 7,
70872: 8,
70873: 9,
71248: 0,
71249: 1,
71250: 2,
71251: 3,
71252: 4,
71253: 5,
71254: 6,
71255: 7,
71256: 8,
71257: 9,
71360: 0,
71361: 1,
71362: 2,
71363: 3,
71364: 4,
71365: 5,
71366: 6,
71367: 7,
71368: 8,
71369: 9,
71472: 0,
71473: 1,
71474: 2,
71475: 3,
71476: 4,
71477: 5,
71478: 6,
71479: 7,
71480: 8,
71481: 9,
71904: 0,
71905: 1,
71906: 2,
71907: 3,
71908: 4,
71909: 5,
71910: 6,
71911: 7,
71912: 8,
71913: 9,
92768: 0,
92769: 1,
92770: 2,
92771: 3,
92772: 4,
92773: 5,
92774: 6,
92775: 7,
92776: 8,
92777: 9,
93008: 0,
93009: 1,
93010: 2,
93011: 3,
93012: 4,
93013: 5,
93014: 6,
93015: 7,
93016: 8,
93017: 9,
}

_decimal_corrected = {
6618: None,
}
_digit = {
3558: 0,
3559: 1,
3560: 2,
3561: 3,
3562: 4,
3563: 5,
3564: 6,
3565: 7,
3566: 8,
3567: 9,
43504: 0,
43505: 1,
43506: 2,
43507: 3,
43508: 4,
43509: 5,
43510: 6,
43511: 7,
43512: 8,
43513: 9,
69714: 1,
69715: 2,
69716: 3,
69717: 4,
69718: 5,
69719: 6,
69720: 7,
69721: 8,
69722: 9,
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
69872: 0,
69873: 1,
69874: 2,
69875: 3,
69876: 4,
69877: 5,
69878: 6,
69879: 7,
69880: 8,
69881: 9,
69942: 0,
69943: 1,
69944: 2,
69945: 3,
69946: 4,
69947: 5,
69948: 6,
69949: 7,
69950: 8,
69951: 9,
70096: 0,
70097: 1,
70098: 2,
70099: 3,
70100: 4,
70101: 5,
70102: 6,
70103: 7,
70104: 8,
70105: 9,
70384: 0,
70385: 1,
70386: 2,
70387: 3,
70388: 4,
70389: 5,
70390: 6,
70391: 7,
70392: 8,
70393: 9,
70864: 0,
70865: 1,
70866: 2,
70867: 3,
70868: 4,
70869: 5,
70870: 6,
70871: 7,
70872: 8,
70873: 9,
71248: 0,
71249: 1,
71250: 2,
71251: 3,
71252: 4,
71253: 5,
71254: 6,
71255: 7,
71256: 8,
71257: 9,
71360: 0,
71361: 1,
71362: 2,
71363: 3,
71364: 4,
71365: 5,
71366: 6,
71367: 7,
71368: 8,
71369: 9,
71472: 0,
71473: 1,
71474: 2,
71475: 3,
71476: 4,
71477: 5,
71478: 6,
71479: 7,
71480: 8,
71481: 9,
71904: 0,
71905: 1,
71906: 2,
71907: 3,
71908: 4,
71909: 5,
71910: 6,
71911: 7,
71912: 8,
71913: 9,
92768: 0,
92769: 1,
92770: 2,
92771: 3,
92772: 4,
92773: 5,
92774: 6,
92775: 7,
92776: 8,
92777: 9,
93008: 0,
93009: 1,
93010: 2,
93011: 3,
93012: 4,
93013: 5,
93014: 6,
93015: 7,
93016: 8,
93017: 9,
}

_digit_corrected = {
}
_numeric = {
188: 1.0 / 4.0,
189: 1.0 / 2.0,
190: 3.0 / 4.0,
2548: 1.0 / 16.0,
2549: 1.0 / 8.0,
2550: 3.0 / 16.0,
2551: 1.0 / 4.0,
2552: 3.0 / 4.0,
2930: 1.0 / 4.0,
2931: 1.0 / 2.0,
2932: 3.0 / 4.0,
2933: 1.0 / 16.0,
2934: 1.0 / 8.0,
2935: 3.0 / 16.0,
3443: 1.0 / 4.0,
3444: 1.0 / 2.0,
3445: 3.0 / 4.0,
3558: 0.0,
3559: 1.0,
3560: 2.0,
3561: 3.0,
3562: 4.0,
3563: 5.0,
3564: 6.0,
3565: 7.0,
3566: 8.0,
3567: 9.0,
3882: 1.0 / 2.0,
3883: 3.0 / 2.0,
3884: 5.0 / 2.0,
3885: 7.0 / 2.0,
3886: 9.0 / 2.0,
3887: 11.0 / 2.0,
3888: 13.0 / 2.0,
3889: 15.0 / 2.0,
3890: 17.0 / 2.0,
3891: -1.0 / 2.0,
8528: 1.0 / 7.0,
8529: 1.0 / 9.0,
8530: 1.0 / 10.0,
8531: 1.0 / 3.0,
8532: 2.0 / 3.0,
8533: 1.0 / 5.0,
8534: 2.0 / 5.0,
8535: 3.0 / 5.0,
8536: 4.0 / 5.0,
8537: 1.0 / 6.0,
8538: 5.0 / 6.0,
8539: 1.0 / 8.0,
8540: 3.0 / 8.0,
8541: 5.0 / 8.0,
8542: 7.0 / 8.0,
11517: 1.0 / 2.0,
12872: 10.0,
12873: 20.0,
12874: 30.0,
12875: 40.0,
12876: 50.0,
12877: 60.0,
12878: 70.0,
12879: 80.0,
43056: 1.0 / 4.0,
43057: 1.0 / 2.0,
43058: 3.0 / 4.0,
43059: 1.0 / 16.0,
43060: 1.0 / 8.0,
43061: 3.0 / 16.0,
43504: 0.0,
43505: 1.0,
43506: 2.0,
43507: 3.0,
43508: 4.0,
43509: 5.0,
43510: 6.0,
43511: 7.0,
43512: 8.0,
43513: 9.0,
65856: 1.0 / 4.0,
65857: 1.0 / 2.0,
65909: 1.0 / 2.0,
65910: 1.0 / 2.0,
65911: 2.0 / 3.0,
65912: 3.0 / 4.0,
65931: 1.0 / 4.0,
66273: 1.0,
66274: 2.0,
66275: 3.0,
66276: 4.0,
66277: 5.0,
66278: 6.0,
66279: 7.0,
66280: 8.0,
66281: 9.0,
66282: 10.0,
66283: 20.0,
66284: 30.0,
66285: 40.0,
66286: 50.0,
66287: 60.0,
66288: 70.0,
66289: 80.0,
66290: 90.0,
66291: 100.0,
66292: 200.0,
66293: 300.0,
66294: 400.0,
66295: 500.0,
66296: 600.0,
66297: 700.0,
66298: 800.0,
66299: 900.0,
67705: 1.0,
67706: 2.0,
67707: 3.0,
67708: 4.0,
67709: 5.0,
67710: 10.0,
67711: 20.0,
67751: 1.0,
67752: 2.0,
67753: 3.0,
67754: 4.0,
67755: 4.0,
67756: 5.0,
67757: 10.0,
67758: 20.0,
67759: 100.0,
67835: 1.0,
67836: 5.0,
67837: 10.0,
67838: 20.0,
67839: 100.0,
68028: 11.0 / 12.0,
68029: 1.0 / 2.0,
68032: 1.0,
68033: 2.0,
68034: 3.0,
68035: 4.0,
68036: 5.0,
68037: 6.0,
68038: 7.0,
68039: 8.0,
68040: 9.0,
68041: 10.0,
68042: 20.0,
68043: 30.0,
68044: 40.0,
68045: 50.0,
68046: 60.0,
68047: 70.0,
68050: 100.0,
68051: 200.0,
68052: 300.0,
68053: 400.0,
68054: 500.0,
68055: 600.0,
68056: 700.0,
68057: 800.0,
68058: 900.0,
68059: 1000.0,
68060: 2000.0,
68061: 3000.0,
68062: 4000.0,
68063: 5000.0,
68064: 6000.0,
68065: 7000.0,
68066: 8000.0,
68067: 9000.0,
68068: 10000.0,
68069: 20000.0,
68070: 30000.0,
68071: 40000.0,
68072: 50000.0,
68073: 60000.0,
68074: 70000.0,
68075: 80000.0,
68076: 90000.0,
68077: 100000.0,
68078: 200000.0,
68079: 300000.0,
68080: 400000.0,
68081: 500000.0,
68082: 600000.0,
68083: 700000.0,
68084: 800000.0,
68085: 900000.0,
68086: 1.0 / 12.0,
68087: 2.0 / 12.0,
68088: 3.0 / 12.0,
68089: 4.0 / 12.0,
68090: 5.0 / 12.0,
68091: 6.0 / 12.0,
68092: 7.0 / 12.0,
68093: 8.0 / 12.0,
68094: 9.0 / 12.0,
68095: 10.0 / 12.0,
68253: 1.0,
68254: 10.0,
68255: 20.0,
68331: 1.0,
68332: 5.0,
68333: 10.0,
68334: 20.0,
68335: 100.0,
68521: 1.0,
68522: 2.0,
68523: 3.0,
68524: 4.0,
68525: 10.0,
68526: 20.0,
68527: 100.0,
68858: 1.0,
68859: 5.0,
68860: 10.0,
68861: 50.0,
68862: 100.0,
68863: 1000.0,
69243: 1.0 / 2.0,
69244: 1.0 / 4.0,
69245: 1.0 / 3.0,
69246: 2.0 / 3.0,
69714: 1.0,
69715: 2.0,
69716: 3.0,
69717: 4.0,
69718: 5.0,
69719: 6.0,
69720: 7.0,
69721: 8.0,
69722: 9.0,
69723: 10.0,
69724: 20.0,
69725: 30.0,
69726: 40.0,
69727: 50.0,
69728: 60.0,
69729: 70.0,
69730: 80.0,
69731: 90.0,
69732: 100.0,
69733: 1000.0,
69734: 0.0,
69735: 1.0,
69736: 2.0,
69737: 3.0,
69738: 4.0,
69739: 5.0,
69740: 6.0,
69741: 7.0,
69742: 8.0,
69743: 9.0,
69872: 0.0,
69873: 1.0,
69874: 2.0,
69875: 3.0,
69876: 4.0,
69877: 5.0,
69878: 6.0,
69879: 7.0,
69880: 8.0,
69881: 9.0,
69942: 0.0,
69943: 1.0,
69944: 2.0,
69945: 3.0,
69946: 4.0,
69947: 5.0,
69948: 6.0,
69949: 7.0,
69950: 8.0,
69951: 9.0,
70096: 0.0,
70097: 1.0,
70098: 2.0,
70099: 3.0,
70100: 4.0,
70101: 5.0,
70102: 6.0,
70103: 7.0,
70104: 8.0,
70105: 9.0,
70113: 1.0,
70114: 2.0,
70115: 3.0,
70116: 4.0,
70117: 5.0,
70118: 6.0,
70119: 7.0,
70120: 8.0,
70121: 9.0,
70122: 10.0,
70123: 20.0,
70124: 30.0,
70125: 40.0,
70126: 50.0,
70127: 60.0,
70128: 70.0,
70129: 80.0,
70130: 90.0,
70131: 100.0,
70132: 1000.0,
70384: 0.0,
70385: 1.0,
70386: 2.0,
70387: 3.0,
70388: 4.0,
70389: 5.0,
70390: 6.0,
70391: 7.0,
70392: 8.0,
70393: 9.0,
70864: 0.0,
70865: 1.0,
70866: 2.0,
70867: 3.0,
70868: 4.0,
70869: 5.0,
70870: 6.0,
70871: 7.0,
70872: 8.0,
70873: 9.0,
71248: 0.0,
71249: 1.0,
71250: 2.0,
71251: 3.0,
71252: 4.0,
71253: 5.0,
71254: 6.0,
71255: 7.0,
71256: 8.0,
71257: 9.0,
71360: 0.0,
71361: 1.0,
71362: 2.0,
71363: 3.0,
71364: 4.0,
71365: 5.0,
71366: 6.0,
71367: 7.0,
71368: 8.0,
71369: 9.0,
71472: 0.0,
71473: 1.0,
71474: 2.0,
71475: 3.0,
71476: 4.0,
71477: 5.0,
71478: 6.0,
71479: 7.0,
71480: 8.0,
71481: 9.0,
71482: 10.0,
71483: 20.0,
71904: 0.0,
71905: 1.0,
71906: 2.0,
71907: 3.0,
71908: 4.0,
71909: 5.0,
71910: 6.0,
71911: 7.0,
71912: 8.0,
71913: 9.0,
71914: 10.0,
71915: 20.0,
71916: 30.0,
71917: 40.0,
71918: 50.0,
71919: 60.0,
71920: 70.0,
71921: 80.0,
71922: 90.0,
74802: 216000.0,
74803: 432000.0,
74838: 2.0,
74839: 3.0,
74842: 1.0 / 3.0,
74843: 2.0 / 3.0,
74844: 5.0 / 6.0,
74845: 1.0 / 3.0,
74846: 2.0 / 3.0,
74847: 1.0 / 8.0,
74848: 1.0 / 4.0,
74849: 1.0 / 6.0,
74850: 1.0 / 4.0,
74851: 1.0 / 4.0,
74852: 1.0 / 2.0,
74853: 1.0 / 3.0,
74854: 2.0 / 3.0,
74855: 40.0,
74856: 50.0,
74857: 4.0,
74858: 5.0,
74859: 6.0,
74860: 7.0,
74861: 8.0,
74862: 9.0,
92768: 0.0,
92769: 1.0,
92770: 2.0,
92771: 3.0,
92772: 4.0,
92773: 5.0,
92774: 6.0,
92775: 7.0,
92776: 8.0,
92777: 9.0,
93008: 0.0,
93009: 1.0,
93010: 2.0,
93011: 3.0,
93012: 4.0,
93013: 5.0,
93014: 6.0,
93015: 7.0,
93016: 8.0,
93017: 9.0,
93019: 10.0,
93020: 100.0,
93021: 10000.0,
93022: 1000000.0,
93023: 100000000.0,
93024: 10000000000.0,
93025: 1000000000000.0,
125127: 1.0,
125128: 2.0,
125129: 3.0,
125130: 4.0,
125131: 5.0,
125132: 6.0,
125133: 7.0,
125134: 8.0,
125135: 9.0,
127243: 0.0,
127244: 0.0,
}

_numeric_corrected = {
}

def decimal(code):
    try:
        return _decimal[code]
    except KeyError:
        if base_mod is not None and code not in _decimal_corrected:
            return base_mod._decimal[code]
        else:
            raise

def digit(code):
    try:
        return _digit[code]
    except KeyError:
        if base_mod is not None and code not in _digit_corrected:
            return base_mod._digit[code]
        else:
            raise

def numeric(code):
    try:
        return _numeric[code]
    except KeyError:
        if base_mod is not None and code not in _numeric_corrected:
            return base_mod._numeric[code]
        else:
            raise

_toupper = {
604: 42923,
609: 42924,
613: 42893,
614: 42922,
620: 42925,
647: 42929,
669: 42930,
670: 42928,
1011: 895,
1319: 1318,
1321: 1320,
1323: 1322,
1325: 1324,
1327: 1326,
5112: 5104,
5113: 5105,
5114: 5106,
5115: 5107,
5116: 5108,
5117: 5109,
11507: 11506,
11559: 4295,
11565: 4301,
42593: 42592,
42649: 42648,
42651: 42650,
42897: 42896,
42899: 42898,
42903: 42902,
42905: 42904,
42907: 42906,
42909: 42908,
42911: 42910,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
42933: 42932,
42935: 42934,
43859: 42931,
43888: 5024,
43889: 5025,
43890: 5026,
43891: 5027,
43892: 5028,
43893: 5029,
43894: 5030,
43895: 5031,
43896: 5032,
43897: 5033,
43898: 5034,
43899: 5035,
43900: 5036,
43901: 5037,
43902: 5038,
43903: 5039,
43904: 5040,
43905: 5041,
43906: 5042,
43907: 5043,
43908: 5044,
43909: 5045,
43910: 5046,
43911: 5047,
43912: 5048,
43913: 5049,
43914: 5050,
43915: 5051,
43916: 5052,
43917: 5053,
43918: 5054,
43919: 5055,
43920: 5056,
43921: 5057,
43922: 5058,
43923: 5059,
43924: 5060,
43925: 5061,
43926: 5062,
43927: 5063,
43928: 5064,
43929: 5065,
43930: 5066,
43931: 5067,
43932: 5068,
43933: 5069,
43934: 5070,
43935: 5071,
43936: 5072,
43937: 5073,
43938: 5074,
43939: 5075,
43940: 5076,
43941: 5077,
43942: 5078,
43943: 5079,
43944: 5080,
43945: 5081,
43946: 5082,
43947: 5083,
43948: 5084,
43949: 5085,
43950: 5086,
43951: 5087,
43952: 5088,
43953: 5089,
43954: 5090,
43955: 5091,
43956: 5092,
43957: 5093,
43958: 5094,
43959: 5095,
43960: 5096,
43961: 5097,
43962: 5098,
43963: 5099,
43964: 5100,
43965: 5101,
43966: 5102,
43967: 5103,
68800: 68736,
68801: 68737,
68802: 68738,
68803: 68739,
68804: 68740,
68805: 68741,
68806: 68742,
68807: 68743,
68808: 68744,
68809: 68745,
68810: 68746,
68811: 68747,
68812: 68748,
68813: 68749,
68814: 68750,
68815: 68751,
68816: 68752,
68817: 68753,
68818: 68754,
68819: 68755,
68820: 68756,
68821: 68757,
68822: 68758,
68823: 68759,
68824: 68760,
68825: 68761,
68826: 68762,
68827: 68763,
68828: 68764,
68829: 68765,
68830: 68766,
68831: 68767,
68832: 68768,
68833: 68769,
68834: 68770,
68835: 68771,
68836: 68772,
68837: 68773,
68838: 68774,
68839: 68775,
68840: 68776,
68841: 68777,
68842: 68778,
68843: 68779,
68844: 68780,
68845: 68781,
68846: 68782,
68847: 68783,
68848: 68784,
68849: 68785,
68850: 68786,
71872: 71840,
71873: 71841,
71874: 71842,
71875: 71843,
71876: 71844,
71877: 71845,
71878: 71846,
71879: 71847,
71880: 71848,
71881: 71849,
71882: 71850,
71883: 71851,
71884: 71852,
71885: 71853,
71886: 71854,
71887: 71855,
71888: 71856,
71889: 71857,
71890: 71858,
71891: 71859,
71892: 71860,
71893: 71861,
71894: 71862,
71895: 71863,
71896: 71864,
71897: 71865,
71898: 71866,
71899: 71867,
71900: 71868,
71901: 71869,
71902: 71870,
71903: 71871,
}

_toupper_corrected = {
}
_tolower = {
895: 1011,
1318: 1319,
1320: 1321,
1322: 1323,
1324: 1325,
1326: 1327,
4295: 11559,
4301: 11565,
5024: 43888,
5025: 43889,
5026: 43890,
5027: 43891,
5028: 43892,
5029: 43893,
5030: 43894,
5031: 43895,
5032: 43896,
5033: 43897,
5034: 43898,
5035: 43899,
5036: 43900,
5037: 43901,
5038: 43902,
5039: 43903,
5040: 43904,
5041: 43905,
5042: 43906,
5043: 43907,
5044: 43908,
5045: 43909,
5046: 43910,
5047: 43911,
5048: 43912,
5049: 43913,
5050: 43914,
5051: 43915,
5052: 43916,
5053: 43917,
5054: 43918,
5055: 43919,
5056: 43920,
5057: 43921,
5058: 43922,
5059: 43923,
5060: 43924,
5061: 43925,
5062: 43926,
5063: 43927,
5064: 43928,
5065: 43929,
5066: 43930,
5067: 43931,
5068: 43932,
5069: 43933,
5070: 43934,
5071: 43935,
5072: 43936,
5073: 43937,
5074: 43938,
5075: 43939,
5076: 43940,
5077: 43941,
5078: 43942,
5079: 43943,
5080: 43944,
5081: 43945,
5082: 43946,
5083: 43947,
5084: 43948,
5085: 43949,
5086: 43950,
5087: 43951,
5088: 43952,
5089: 43953,
5090: 43954,
5091: 43955,
5092: 43956,
5093: 43957,
5094: 43958,
5095: 43959,
5096: 43960,
5097: 43961,
5098: 43962,
5099: 43963,
5100: 43964,
5101: 43965,
5102: 43966,
5103: 43967,
5104: 5112,
5105: 5113,
5106: 5114,
5107: 5115,
5108: 5116,
5109: 5117,
11506: 11507,
42592: 42593,
42648: 42649,
42650: 42651,
42893: 613,
42896: 42897,
42898: 42899,
42902: 42903,
42904: 42905,
42906: 42907,
42908: 42909,
42910: 42911,
42912: 42913,
42914: 42915,
42916: 42917,
42918: 42919,
42920: 42921,
42922: 614,
42923: 604,
42924: 609,
42925: 620,
42928: 670,
42929: 647,
42930: 669,
42931: 43859,
42932: 42933,
42934: 42935,
68736: 68800,
68737: 68801,
68738: 68802,
68739: 68803,
68740: 68804,
68741: 68805,
68742: 68806,
68743: 68807,
68744: 68808,
68745: 68809,
68746: 68810,
68747: 68811,
68748: 68812,
68749: 68813,
68750: 68814,
68751: 68815,
68752: 68816,
68753: 68817,
68754: 68818,
68755: 68819,
68756: 68820,
68757: 68821,
68758: 68822,
68759: 68823,
68760: 68824,
68761: 68825,
68762: 68826,
68763: 68827,
68764: 68828,
68765: 68829,
68766: 68830,
68767: 68831,
68768: 68832,
68769: 68833,
68770: 68834,
68771: 68835,
68772: 68836,
68773: 68837,
68774: 68838,
68775: 68839,
68776: 68840,
68777: 68841,
68778: 68842,
68779: 68843,
68780: 68844,
68781: 68845,
68782: 68846,
68783: 68847,
68784: 68848,
68785: 68849,
68786: 68850,
71840: 71872,
71841: 71873,
71842: 71874,
71843: 71875,
71844: 71876,
71845: 71877,
71846: 71878,
71847: 71879,
71848: 71880,
71849: 71881,
71850: 71882,
71851: 71883,
71852: 71884,
71853: 71885,
71854: 71886,
71855: 71887,
71856: 71888,
71857: 71889,
71858: 71890,
71859: 71891,
71860: 71892,
71861: 71893,
71862: 71894,
71863: 71895,
71864: 71896,
71865: 71897,
71866: 71898,
71867: 71899,
71868: 71900,
71869: 71901,
71870: 71902,
71871: 71903,
}

_tolower_corrected = {
}
_totitle = {
604: 42923,
609: 42924,
613: 42893,
614: 42922,
620: 42925,
647: 42929,
669: 42930,
670: 42928,
1011: 895,
1319: 1318,
1321: 1320,
1323: 1322,
1325: 1324,
1327: 1326,
5112: 5104,
5113: 5105,
5114: 5106,
5115: 5107,
5116: 5108,
5117: 5109,
11507: 11506,
11559: 4295,
11565: 4301,
42593: 42592,
42649: 42648,
42651: 42650,
42897: 42896,
42899: 42898,
42903: 42902,
42905: 42904,
42907: 42906,
42909: 42908,
42911: 42910,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
42933: 42932,
42935: 42934,
43859: 42931,
43888: 5024,
43889: 5025,
43890: 5026,
43891: 5027,
43892: 5028,
43893: 5029,
43894: 5030,
43895: 5031,
43896: 5032,
43897: 5033,
43898: 5034,
43899: 5035,
43900: 5036,
43901: 5037,
43902: 5038,
43903: 5039,
43904: 5040,
43905: 5041,
43906: 5042,
43907: 5043,
43908: 5044,
43909: 5045,
43910: 5046,
43911: 5047,
43912: 5048,
43913: 5049,
43914: 5050,
43915: 5051,
43916: 5052,
43917: 5053,
43918: 5054,
43919: 5055,
43920: 5056,
43921: 5057,
43922: 5058,
43923: 5059,
43924: 5060,
43925: 5061,
43926: 5062,
43927: 5063,
43928: 5064,
43929: 5065,
43930: 5066,
43931: 5067,
43932: 5068,
43933: 5069,
43934: 5070,
43935: 5071,
43936: 5072,
43937: 5073,
43938: 5074,
43939: 5075,
43940: 5076,
43941: 5077,
43942: 5078,
43943: 5079,
43944: 5080,
43945: 5081,
43946: 5082,
43947: 5083,
43948: 5084,
43949: 5085,
43950: 5086,
43951: 5087,
43952: 5088,
43953: 5089,
43954: 5090,
43955: 5091,
43956: 5092,
43957: 5093,
43958: 5094,
43959: 5095,
43960: 5096,
43961: 5097,
43962: 5098,
43963: 5099,
43964: 5100,
43965: 5101,
43966: 5102,
43967: 5103,
68800: 68736,
68801: 68737,
68802: 68738,
68803: 68739,
68804: 68740,
68805: 68741,
68806: 68742,
68807: 68743,
68808: 68744,
68809: 68745,
68810: 68746,
68811: 68747,
68812: 68748,
68813: 68749,
68814: 68750,
68815: 68751,
68816: 68752,
68817: 68753,
68818: 68754,
68819: 68755,
68820: 68756,
68821: 68757,
68822: 68758,
68823: 68759,
68824: 68760,
68825: 68761,
68826: 68762,
68827: 68763,
68828: 68764,
68829: 68765,
68830: 68766,
68831: 68767,
68832: 68768,
68833: 68769,
68834: 68770,
68835: 68771,
68836: 68772,
68837: 68773,
68838: 68774,
68839: 68775,
68840: 68776,
68841: 68777,
68842: 68778,
68843: 68779,
68844: 68780,
68845: 68781,
68846: 68782,
68847: 68783,
68848: 68784,
68849: 68785,
68850: 68786,
71872: 71840,
71873: 71841,
71874: 71842,
71875: 71843,
71876: 71844,
71877: 71845,
71878: 71846,
71879: 71847,
71880: 71848,
71881: 71849,
71882: 71850,
71883: 71851,
71884: 71852,
71885: 71853,
71886: 71854,
71887: 71855,
71888: 71856,
71889: 71857,
71890: 71858,
71891: 71859,
71892: 71860,
71893: 71861,
71894: 71862,
71895: 71863,
71896: 71864,
71897: 71865,
71898: 71866,
71899: 71867,
71900: 71868,
71901: 71869,
71902: 71870,
71903: 71871,
}

_totitle_corrected = {
}
_special_casing = {
223: ([223], [83, 115], [83, 83]),
304: ([105, 775], [304], [304]),
329: ([329], [700, 78], [700, 78]),
496: ([496], [74, 780], [74, 780]),
912: ([912], [921, 776, 769], [921, 776, 769]),
944: ([944], [933, 776, 769], [933, 776, 769]),
1415: ([1415], [1333, 1410], [1333, 1362]),
7830: ([7830], [72, 817], [72, 817]),
7831: ([7831], [84, 776], [84, 776]),
7832: ([7832], [87, 778], [87, 778]),
7833: ([7833], [89, 778], [89, 778]),
7834: ([7834], [65, 702], [65, 702]),
8016: ([8016], [933, 787], [933, 787]),
8018: ([8018], [933, 787, 768], [933, 787, 768]),
8020: ([8020], [933, 787, 769], [933, 787, 769]),
8022: ([8022], [933, 787, 834], [933, 787, 834]),
8064: ([8064], [8072], [7944, 921]),
8065: ([8065], [8073], [7945, 921]),
8066: ([8066], [8074], [7946, 921]),
8067: ([8067], [8075], [7947, 921]),
8068: ([8068], [8076], [7948, 921]),
8069: ([8069], [8077], [7949, 921]),
8070: ([8070], [8078], [7950, 921]),
8071: ([8071], [8079], [7951, 921]),
8072: ([8064], [8072], [7944, 921]),
8073: ([8065], [8073], [7945, 921]),
8074: ([8066], [8074], [7946, 921]),
8075: ([8067], [8075], [7947, 921]),
8076: ([8068], [8076], [7948, 921]),
8077: ([8069], [8077], [7949, 921]),
8078: ([8070], [8078], [7950, 921]),
8079: ([8071], [8079], [7951, 921]),
8080: ([8080], [8088], [7976, 921]),
8081: ([8081], [8089], [7977, 921]),
8082: ([8082], [8090], [7978, 921]),
8083: ([8083], [8091], [7979, 921]),
8084: ([8084], [8092], [7980, 921]),
8085: ([8085], [8093], [7981, 921]),
8086: ([8086], [8094], [7982, 921]),
8087: ([8087], [8095], [7983, 921]),
8088: ([8080], [8088], [7976, 921]),
8089: ([8081], [8089], [7977, 921]),
8090: ([8082], [8090], [7978, 921]),
8091: ([8083], [8091], [7979, 921]),
8092: ([8084], [8092], [7980, 921]),
8093: ([8085], [8093], [7981, 921]),
8094: ([8086], [8094], [7982, 921]),
8095: ([8087], [8095], [7983, 921]),
8096: ([8096], [8104], [8040, 921]),
8097: ([8097], [8105], [8041, 921]),
8098: ([8098], [8106], [8042, 921]),
8099: ([8099], [8107], [8043, 921]),
8100: ([8100], [8108], [8044, 921]),
8101: ([8101], [8109], [8045, 921]),
8102: ([8102], [8110], [8046, 921]),
8103: ([8103], [8111], [8047, 921]),
8104: ([8096], [8104], [8040, 921]),
8105: ([8097], [8105], [8041, 921]),
8106: ([8098], [8106], [8042, 921]),
8107: ([8099], [8107], [8043, 921]),
8108: ([8100], [8108], [8044, 921]),
8109: ([8101], [8109], [8045, 921]),
8110: ([8102], [8110], [8046, 921]),
8111: ([8103], [8111], [8047, 921]),
8114: ([8114], [8122, 837], [8122, 921]),
8115: ([8115], [8124], [913, 921]),
8116: ([8116], [902, 837], [902, 921]),
8118: ([8118], [913, 834], [913, 834]),
8119: ([8119], [913, 834, 837], [913, 834, 921]),
8124: ([8115], [8124], [913, 921]),
8130: ([8130], [8138, 837], [8138, 921]),
8131: ([8131], [8140], [919, 921]),
8132: ([8132], [905, 837], [905, 921]),
8134: ([8134], [919, 834], [919, 834]),
8135: ([8135], [919, 834, 837], [919, 834, 921]),
8140: ([8131], [8140], [919, 921]),
8146: ([8146], [921, 776, 768], [921, 776, 768]),
8147: ([8147], [921, 776, 769], [921, 776, 769]),
8150: ([8150], [921, 834], [921, 834]),
8151: ([8151], [921, 776, 834], [921, 776, 834]),
8162: ([8162], [933, 776, 768], [933, 776, 768]),
8163: ([8163], [933, 776, 769], [933, 776, 769]),
8164: ([8164], [929, 787], [929, 787]),
8166: ([8166], [933, 834], [933, 834]),
8167: ([8167], [933, 776, 834], [933, 776, 834]),
8178: ([8178], [8186, 837], [8186, 921]),
8179: ([8179], [8188], [937, 921]),
8180: ([8180], [911, 837], [911, 921]),
8182: ([8182], [937, 834], [937, 834]),
8183: ([8183], [937, 834, 837], [937, 834, 921]),
8188: ([8179], [8188], [937, 921]),
64256: ([64256], [70, 102], [70, 70]),
64257: ([64257], [70, 105], [70, 73]),
64258: ([64258], [70, 108], [70, 76]),
64259: ([64259], [70, 102, 105], [70, 70, 73]),
64260: ([64260], [70, 102, 108], [70, 70, 76]),
64261: ([64261], [83, 116], [83, 84]),
64262: ([64262], [83, 116], [83, 84]),
64275: ([64275], [1348, 1398], [1348, 1350]),
64276: ([64276], [1348, 1381], [1348, 1333]),
64277: ([64277], [1348, 1387], [1348, 1339]),
64278: ([64278], [1358, 1398], [1358, 1350]),
64279: ([64279], [1348, 1389], [1348, 1341]),
}

_special_casing_corrected = {
}

def toupper(code):
    try:
        return _toupper[code]
    except KeyError:
        if base_mod is not None and code not in _toupper_corrected:
            return base_mod._toupper.get(code, code)
        else:
            return code

def tolower(code):
    try:
        return _tolower[code]
    except KeyError:
        if base_mod is not None and code not in _tolower_corrected:
            return base_mod._tolower.get(code, code)
        else:
            return code

def totitle(code):
    try:
        return _totitle[code]
    except KeyError:
        if base_mod is not None and code not in _totitle_corrected:
            return base_mod._totitle.get(code, code)
        else:
            return code

def toupper_full(code):
    try:
        return _special_casing[code][2]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][2]
            except KeyError:
                pass
    return [toupper(code)]

def tolower_full(code):
    try:
        return _special_casing[code][0]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][0]
            except KeyError:
                pass
    return [tolower(code)]

def totitle_full(code):
    try:
        return _special_casing[code][1]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][1]
            except KeyError:
                pass
    return [totitle(code)]

_raw_decomposition = {
8341: '<sub> 0068',
8342: '<sub> 006B',
8343: '<sub> 006C',
8344: '<sub> 006D',
8345: '<sub> 006E',
8346: '<sub> 0070',
8347: '<sub> 0073',
8348: '<sub> 0074',
42652: '<super> 044A',
42653: '<super> 044C',
43000: '<super> 0126',
43001: '<super> 0153',
43868: '<super> A727',
43869: '<super> AB37',
43870: '<super> 026B',
43871: '<super> AB52',
64046: '90DE',
64047: '96B7',
69934: '11131 11127',
69935: '11132 11127',
70475: '11347 1133E',
70476: '11347 11357',
70843: '114B9 114BA',
70844: '114B9 114B0',
70846: '114B9 114BD',
71098: '115B8 115AF',
71099: '115B9 115AF',
126464: '<font> 0627',
126465: '<font> 0628',
126466: '<font> 062C',
126467: '<font> 062F',
126469: '<font> 0648',
126470: '<font> 0632',
126471: '<font> 062D',
126472: '<font> 0637',
126473: '<font> 064A',
126474: '<font> 0643',
126475: '<font> 0644',
126476: '<font> 0645',
126477: '<font> 0646',
126478: '<font> 0633',
126479: '<font> 0639',
126480: '<font> 0641',
126481: '<font> 0635',
126482: '<font> 0642',
126483: '<font> 0631',
126484: '<font> 0634',
126485: '<font> 062A',
126486: '<font> 062B',
126487: '<font> 062E',
126488: '<font> 0630',
126489: '<font> 0636',
126490: '<font> 0638',
126491: '<font> 063A',
126492: '<font> 066E',
126493: '<font> 06BA',
126494: '<font> 06A1',
126495: '<font> 066F',
126497: '<font> 0628',
126498: '<font> 062C',
126500: '<font> 0647',
126503: '<font> 062D',
126505: '<font> 064A',
126506: '<font> 0643',
126507: '<font> 0644',
126508: '<font> 0645',
126509: '<font> 0646',
126510: '<font> 0633',
126511: '<font> 0639',
126512: '<font> 0641',
126513: '<font> 0635',
126514: '<font> 0642',
126516: '<font> 0634',
126517: '<font> 062A',
126518: '<font> 062B',
126519: '<font> 062E',
126521: '<font> 0636',
126523: '<font> 063A',
126530: '<font> 062C',
126535: '<font> 062D',
126537: '<font> 064A',
126539: '<font> 0644',
126541: '<font> 0646',
126542: '<font> 0633',
126543: '<font> 0639',
126545: '<font> 0635',
126546: '<font> 0642',
126548: '<font> 0634',
126551: '<font> 062E',
126553: '<font> 0636',
126555: '<font> 063A',
126557: '<font> 06BA',
126559: '<font> 066F',
126561: '<font> 0628',
126562: '<font> 062C',
126564: '<font> 0647',
126567: '<font> 062D',
126568: '<font> 0637',
126569: '<font> 064A',
126570: '<font> 0643',
126572: '<font> 0645',
126573: '<font> 0646',
126574: '<font> 0633',
126575: '<font> 0639',
126576: '<font> 0641',
126577: '<font> 0635',
126578: '<font> 0642',
126580: '<font> 0634',
126581: '<font> 062A',
126582: '<font> 062B',
126583: '<font> 062E',
126585: '<font> 0636',
126586: '<font> 0638',
126587: '<font> 063A',
126588: '<font> 066E',
126590: '<font> 06A1',
126592: '<font> 0627',
126593: '<font> 0628',
126594: '<font> 062C',
126595: '<font> 062F',
126596: '<font> 0647',
126597: '<font> 0648',
126598: '<font> 0632',
126599: '<font> 062D',
126600: '<font> 0637',
126601: '<font> 064A',
126603: '<font> 0644',
126604: '<font> 0645',
126605: '<font> 0646',
126606: '<font> 0633',
126607: '<font> 0639',
126608: '<font> 0641',
126609: '<font> 0635',
126610: '<font> 0642',
126611: '<font> 0631',
126612: '<font> 0634',
126613: '<font> 062A',
126614: '<font> 062B',
126615: '<font> 062E',
126616: '<font> 0630',
126617: '<font> 0636',
126618: '<font> 0638',
126619: '<font> 063A',
126625: '<font> 0628',
126626: '<font> 062C',
126627: '<font> 062F',
126629: '<font> 0648',
126630: '<font> 0632',
126631: '<font> 062D',
126632: '<font> 0637',
126633: '<font> 064A',
126635: '<font> 0644',
126636: '<font> 0645',
126637: '<font> 0646',
126638: '<font> 0633',
126639: '<font> 0639',
126640: '<font> 0641',
126641: '<font> 0635',
126642: '<font> 0642',
126643: '<font> 0631',
126644: '<font> 0634',
126645: '<font> 062A',
126646: '<font> 062B',
126647: '<font> 062E',
126648: '<font> 0630',
126649: '<font> 0636',
126650: '<font> 0638',
126651: '<font> 063A',
127280: '<square> 0041',
127282: '<square> 0043',
127283: '<square> 0044',
127284: '<square> 0045',
127285: '<square> 0046',
127286: '<square> 0047',
127287: '<square> 0048',
127288: '<square> 0049',
127289: '<square> 004A',
127290: '<square> 004B',
127291: '<square> 004C',
127292: '<square> 004D',
127294: '<square> 004F',
127296: '<square> 0051',
127297: '<square> 0052',
127299: '<square> 0054',
127300: '<square> 0055',
127301: '<square> 0056',
127303: '<square> 0058',
127304: '<square> 0059',
127305: '<square> 005A',
127311: '<square> 0057 0043',
127338: '<super> 004D 0043',
127339: '<super> 004D 0044',
127489: '<square> 30B3 30B3',
127490: '<square> 30B5',
127538: '<square> 7981',
127539: '<square> 7A7A',
127540: '<square> 5408',
127541: '<square> 6E80',
127542: '<square> 6709',
127543: '<square> 6708',
127544: '<square> 7533',
127545: '<square> 5272',
127546: '<square> 55B6',
127568: '<circle> 5F97',
127569: '<circle> 53EF',
}

_raw_decomposition_corrected = {
}

def decomposition(code):
    try:
        return _raw_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _raw_decomposition_corrected:
            return base_mod._raw_decomposition.get(code, '')
        else:
            return ''

_composition = {
r_longlong(   65 << 32 |   768):   192,
r_longlong(   65 << 32 |   769):   193,
r_longlong(   65 << 32 |   770):   194,
r_longlong(   65 << 32 |   771):   195,
r_longlong(   65 << 32 |   776):   196,
r_longlong(   65 << 32 |   778):   197,
r_longlong(   67 << 32 |   807):   199,
r_longlong(   69 << 32 |   768):   200,
r_longlong(   69 << 32 |   769):   201,
r_longlong(   69 << 32 |   770):   202,
r_longlong(   69 << 32 |   776):   203,
r_longlong(   73 << 32 |   768):   204,
r_longlong(   73 << 32 |   769):   205,
r_longlong(   73 << 32 |   770):   206,
r_longlong(   73 << 32 |   776):   207,
r_longlong(   78 << 32 |   771):   209,
r_longlong(   79 << 32 |   768):   210,
r_longlong(   79 << 32 |   769):   211,
r_longlong(   79 << 32 |   770):   212,
r_longlong(   79 << 32 |   771):   213,
r_longlong(   79 << 32 |   776):   214,
r_longlong(   85 << 32 |   768):   217,
r_longlong(   85 << 32 |   769):   218,
r_longlong(   85 << 32 |   770):   219,
r_longlong(   85 << 32 |   776):   220,
r_longlong(   89 << 32 |   769):   221,
r_longlong(   97 << 32 |   768):   224,
r_longlong(   97 << 32 |   769):   225,
r_longlong(   97 << 32 |   770):   226,
r_longlong(   97 << 32 |   771):   227,
r_longlong(   97 << 32 |   776):   228,
r_longlong(   97 << 32 |   778):   229,
r_longlong(   99 << 32 |   807):   231,
r_longlong(  101 << 32 |   768):   232,
r_longlong(  101 << 32 |   769):   233,
r_longlong(  101 << 32 |   770):   234,
r_longlong(  101 << 32 |   776):   235,
r_longlong(  105 << 32 |   768):   236,
r_longlong(  105 << 32 |   769):   237,
r_longlong(  105 << 32 |   770):   238,
r_longlong(  105 << 32 |   776):   239,
r_longlong(  110 << 32 |   771):   241,
r_longlong(  111 << 32 |   768):   242,
r_longlong(  111 << 32 |   769):   243,
r_longlong(  111 << 32 |   770):   244,
r_longlong(  111 << 32 |   771):   245,
r_longlong(  111 << 32 |   776):   246,
r_longlong(  117 << 32 |   768):   249,
r_longlong(  117 << 32 |   769):   250,
r_longlong(  117 << 32 |   770):   251,
r_longlong(  117 << 32 |   776):   252,
r_longlong(  121 << 32 |   769):   253,
r_longlong(  121 << 32 |   776):   255,
r_longlong(   65 << 32 |   772):   256,
r_longlong(   97 << 32 |   772):   257,
r_longlong(   65 << 32 |   774):   258,
r_longlong(   97 << 32 |   774):   259,
r_longlong(   65 << 32 |   808):   260,
r_longlong(   97 << 32 |   808):   261,
r_longlong(   67 << 32 |   769):   262,
r_longlong(   99 << 32 |   769):   263,
r_longlong(   67 << 32 |   770):   264,
r_longlong(   99 << 32 |   770):   265,
r_longlong(   67 << 32 |   775):   266,
r_longlong(   99 << 32 |   775):   267,
r_longlong(   67 << 32 |   780):   268,
r_longlong(   99 << 32 |   780):   269,
r_longlong(   68 << 32 |   780):   270,
r_longlong(  100 << 32 |   780):   271,
r_longlong(   69 << 32 |   772):   274,
r_longlong(  101 << 32 |   772):   275,
r_longlong(   69 << 32 |   774):   276,
r_longlong(  101 << 32 |   774):   277,
r_longlong(   69 << 32 |   775):   278,
r_longlong(  101 << 32 |   775):   279,
r_longlong(   69 << 32 |   808):   280,
r_longlong(  101 << 32 |   808):   281,
r_longlong(   69 << 32 |   780):   282,
r_longlong(  101 << 32 |   780):   283,
r_longlong(   71 << 32 |   770):   284,
r_longlong(  103 << 32 |   770):   285,
r_longlong(   71 << 32 |   774):   286,
r_longlong(  103 << 32 |   774):   287,
r_longlong(   71 << 32 |   775):   288,
r_longlong(  103 << 32 |   775):   289,
r_longlong(   71 << 32 |   807):   290,
r_longlong(  103 << 32 |   807):   291,
r_longlong(   72 << 32 |   770):   292,
r_longlong(  104 << 32 |   770):   293,
r_longlong(   73 << 32 |   771):   296,
r_longlong(  105 << 32 |   771):   297,
r_longlong(   73 << 32 |   772):   298,
r_longlong(  105 << 32 |   772):   299,
r_longlong(   73 << 32 |   774):   300,
r_longlong(  105 << 32 |   774):   301,
r_longlong(   73 << 32 |   808):   302,
r_longlong(  105 << 32 |   808):   303,
r_longlong(   73 << 32 |   775):   304,
r_longlong(   74 << 32 |   770):   308,
r_longlong(  106 << 32 |   770):   309,
r_longlong(   75 << 32 |   807):   310,
r_longlong(  107 << 32 |   807):   311,
r_longlong(   76 << 32 |   769):   313,
r_longlong(  108 << 32 |   769):   314,
r_longlong(   76 << 32 |   807):   315,
r_longlong(  108 << 32 |   807):   316,
r_longlong(   76 << 32 |   780):   317,
r_longlong(  108 << 32 |   780):   318,
r_longlong(   78 << 32 |   769):   323,
r_longlong(  110 << 32 |   769):   324,
r_longlong(   78 << 32 |   807):   325,
r_longlong(  110 << 32 |   807):   326,
r_longlong(   78 << 32 |   780):   327,
r_longlong(  110 << 32 |   780):   328,
r_longlong(   79 << 32 |   772):   332,
r_longlong(  111 << 32 |   772):   333,
r_longlong(   79 << 32 |   774):   334,
r_longlong(  111 << 32 |   774):   335,
r_longlong(   79 << 32 |   779):   336,
r_longlong(  111 << 32 |   779):   337,
r_longlong(   82 << 32 |   769):   340,
r_longlong(  114 << 32 |   769):   341,
r_longlong(   82 << 32 |   807):   342,
r_longlong(  114 << 32 |   807):   343,
r_longlong(   82 << 32 |   780):   344,
r_longlong(  114 << 32 |   780):   345,
r_longlong(   83 << 32 |   769):   346,
r_longlong(  115 << 32 |   769):   347,
r_longlong(   83 << 32 |   770):   348,
r_longlong(  115 << 32 |   770):   349,
r_longlong(   83 << 32 |   807):   350,
r_longlong(  115 << 32 |   807):   351,
r_longlong(   83 << 32 |   780):   352,
r_longlong(  115 << 32 |   780):   353,
r_longlong(   84 << 32 |   807):   354,
r_longlong(  116 << 32 |   807):   355,
r_longlong(   84 << 32 |   780):   356,
r_longlong(  116 << 32 |   780):   357,
r_longlong(   85 << 32 |   771):   360,
r_longlong(  117 << 32 |   771):   361,
r_longlong(   85 << 32 |   772):   362,
r_longlong(  117 << 32 |   772):   363,
r_longlong(   85 << 32 |   774):   364,
r_longlong(  117 << 32 |   774):   365,
r_longlong(   85 << 32 |   778):   366,
r_longlong(  117 << 32 |   778):   367,
r_longlong(   85 << 32 |   779):   368,
r_longlong(  117 << 32 |   779):   369,
r_longlong(   85 << 32 |   808):   370,
r_longlong(  117 << 32 |   808):   371,
r_longlong(   87 << 32 |   770):   372,
r_longlong(  119 << 32 |   770):   373,
r_longlong(   89 << 32 |   770):   374,
r_longlong(  121 << 32 |   770):   375,
r_longlong(   89 << 32 |   776):   376,
r_longlong(   90 << 32 |   769):   377,
r_longlong(  122 << 32 |   769):   378,
r_longlong(   90 << 32 |   775):   379,
r_longlong(  122 << 32 |   775):   380,
r_longlong(   90 << 32 |   780):   381,
r_longlong(  122 << 32 |   780):   382,
r_longlong(   79 << 32 |   795):   416,
r_longlong(  111 << 32 |   795):   417,
r_longlong(   85 << 32 |   795):   431,
r_longlong(  117 << 32 |   795):   432,
r_longlong(   65 << 32 |   780):   461,
r_longlong(   97 << 32 |   780):   462,
r_longlong(   73 << 32 |   780):   463,
r_longlong(  105 << 32 |   780):   464,
r_longlong(   79 << 32 |   780):   465,
r_longlong(  111 << 32 |   780):   466,
r_longlong(   85 << 32 |   780):   467,
r_longlong(  117 << 32 |   780):   468,
r_longlong(  220 << 32 |   772):   469,
r_longlong(  252 << 32 |   772):   470,
r_longlong(  220 << 32 |   769):   471,
r_longlong(  252 << 32 |   769):   472,
r_longlong(  220 << 32 |   780):   473,
r_longlong(  252 << 32 |   780):   474,
r_longlong(  220 << 32 |   768):   475,
r_longlong(  252 << 32 |   768):   476,
r_longlong(  196 << 32 |   772):   478,
r_longlong(  228 << 32 |   772):   479,
r_longlong(  550 << 32 |   772):   480,
r_longlong(  551 << 32 |   772):   481,
r_longlong(  198 << 32 |   772):   482,
r_longlong(  230 << 32 |   772):   483,
r_longlong(   71 << 32 |   780):   486,
r_longlong(  103 << 32 |   780):   487,
r_longlong(   75 << 32 |   780):   488,
r_longlong(  107 << 32 |   780):   489,
r_longlong(   79 << 32 |   808):   490,
r_longlong(  111 << 32 |   808):   491,
r_longlong(  490 << 32 |   772):   492,
r_longlong(  491 << 32 |   772):   493,
r_longlong(  439 << 32 |   780):   494,
r_longlong(  658 << 32 |   780):   495,
r_longlong(  106 << 32 |   780):   496,
r_longlong(   71 << 32 |   769):   500,
r_longlong(  103 << 32 |   769):   501,
r_longlong(   78 << 32 |   768):   504,
r_longlong(  110 << 32 |   768):   505,
r_longlong(  197 << 32 |   769):   506,
r_longlong(  229 << 32 |   769):   507,
r_longlong(  198 << 32 |   769):   508,
r_longlong(  230 << 32 |   769):   509,
r_longlong(  216 << 32 |   769):   510,
r_longlong(  248 << 32 |   769):   511,
r_longlong(   65 << 32 |   783):   512,
r_longlong(   97 << 32 |   783):   513,
r_longlong(   65 << 32 |   785):   514,
r_longlong(   97 << 32 |   785):   515,
r_longlong(   69 << 32 |   783):   516,
r_longlong(  101 << 32 |   783):   517,
r_longlong(   69 << 32 |   785):   518,
r_longlong(  101 << 32 |   785):   519,
r_longlong(   73 << 32 |   783):   520,
r_longlong(  105 << 32 |   783):   521,
r_longlong(   73 << 32 |   785):   522,
r_longlong(  105 << 32 |   785):   523,
r_longlong(   79 << 32 |   783):   524,
r_longlong(  111 << 32 |   783):   525,
r_longlong(   79 << 32 |   785):   526,
r_longlong(  111 << 32 |   785):   527,
r_longlong(   82 << 32 |   783):   528,
r_longlong(  114 << 32 |   783):   529,
r_longlong(   82 << 32 |   785):   530,
r_longlong(  114 << 32 |   785):   531,
r_longlong(   85 << 32 |   783):   532,
r_longlong(  117 << 32 |   783):   533,
r_longlong(   85 << 32 |   785):   534,
r_longlong(  117 << 32 |   785):   535,
r_longlong(   83 << 32 |   806):   536,
r_longlong(  115 << 32 |   806):   537,
r_longlong(   84 << 32 |   806):   538,
r_longlong(  116 << 32 |   806):   539,
r_longlong(   72 << 32 |   780):   542,
r_longlong(  104 << 32 |   780):   543,
r_longlong(   65 << 32 |   775):   550,
r_longlong(   97 << 32 |   775):   551,
r_longlong(   69 << 32 |   807):   552,
r_longlong(  101 << 32 |   807):   553,
r_longlong(  214 << 32 |   772):   554,
r_longlong(  246 << 32 |   772):   555,
r_longlong(  213 << 32 |   772):   556,
r_longlong(  245 << 32 |   772):   557,
r_longlong(   79 << 32 |   775):   558,
r_longlong(  111 << 32 |   775):   559,
r_longlong(  558 << 32 |   772):   560,
r_longlong(  559 << 32 |   772):   561,
r_longlong(   89 << 32 |   772):   562,
r_longlong(  121 << 32 |   772):   563,
r_longlong(  168 << 32 |   769):   901,
r_longlong(  913 << 32 |   769):   902,
r_longlong(  917 << 32 |   769):   904,
r_longlong(  919 << 32 |   769):   905,
r_longlong(  921 << 32 |   769):   906,
r_longlong(  927 << 32 |   769):   908,
r_longlong(  933 << 32 |   769):   910,
r_longlong(  937 << 32 |   769):   911,
r_longlong(  970 << 32 |   769):   912,
r_longlong(  921 << 32 |   776):   938,
r_longlong(  933 << 32 |   776):   939,
r_longlong(  945 << 32 |   769):   940,
r_longlong(  949 << 32 |   769):   941,
r_longlong(  951 << 32 |   769):   942,
r_longlong(  953 << 32 |   769):   943,
r_longlong(  971 << 32 |   769):   944,
r_longlong(  953 << 32 |   776):   970,
r_longlong(  965 << 32 |   776):   971,
r_longlong(  959 << 32 |   769):   972,
r_longlong(  965 << 32 |   769):   973,
r_longlong(  969 << 32 |   769):   974,
r_longlong(  978 << 32 |   769):   979,
r_longlong(  978 << 32 |   776):   980,
r_longlong( 1045 << 32 |   768):  1024,
r_longlong( 1045 << 32 |   776):  1025,
r_longlong( 1043 << 32 |   769):  1027,
r_longlong( 1030 << 32 |   776):  1031,
r_longlong( 1050 << 32 |   769):  1036,
r_longlong( 1048 << 32 |   768):  1037,
r_longlong( 1059 << 32 |   774):  1038,
r_longlong( 1048 << 32 |   774):  1049,
r_longlong( 1080 << 32 |   774):  1081,
r_longlong( 1077 << 32 |   768):  1104,
r_longlong( 1077 << 32 |   776):  1105,
r_longlong( 1075 << 32 |   769):  1107,
r_longlong( 1110 << 32 |   776):  1111,
r_longlong( 1082 << 32 |   769):  1116,
r_longlong( 1080 << 32 |   768):  1117,
r_longlong( 1091 << 32 |   774):  1118,
r_longlong( 1140 << 32 |   783):  1142,
r_longlong( 1141 << 32 |   783):  1143,
r_longlong( 1046 << 32 |   774):  1217,
r_longlong( 1078 << 32 |   774):  1218,
r_longlong( 1040 << 32 |   774):  1232,
r_longlong( 1072 << 32 |   774):  1233,
r_longlong( 1040 << 32 |   776):  1234,
r_longlong( 1072 << 32 |   776):  1235,
r_longlong( 1045 << 32 |   774):  1238,
r_longlong( 1077 << 32 |   774):  1239,
r_longlong( 1240 << 32 |   776):  1242,
r_longlong( 1241 << 32 |   776):  1243,
r_longlong( 1046 << 32 |   776):  1244,
r_longlong( 1078 << 32 |   776):  1245,
r_longlong( 1047 << 32 |   776):  1246,
r_longlong( 1079 << 32 |   776):  1247,
r_longlong( 1048 << 32 |   772):  1250,
r_longlong( 1080 << 32 |   772):  1251,
r_longlong( 1048 << 32 |   776):  1252,
r_longlong( 1080 << 32 |   776):  1253,
r_longlong( 1054 << 32 |   776):  1254,
r_longlong( 1086 << 32 |   776):  1255,
r_longlong( 1256 << 32 |   776):  1258,
r_longlong( 1257 << 32 |   776):  1259,
r_longlong( 1069 << 32 |   776):  1260,
r_longlong( 1101 << 32 |   776):  1261,
r_longlong( 1059 << 32 |   772):  1262,
r_longlong( 1091 << 32 |   772):  1263,
r_longlong( 1059 << 32 |   776):  1264,
r_longlong( 1091 << 32 |   776):  1265,
r_longlong( 1059 << 32 |   779):  1266,
r_longlong( 1091 << 32 |   779):  1267,
r_longlong( 1063 << 32 |   776):  1268,
r_longlong( 1095 << 32 |   776):  1269,
r_longlong( 1067 << 32 |   776):  1272,
r_longlong( 1099 << 32 |   776):  1273,
r_longlong( 1575 << 32 |  1619):  1570,
r_longlong( 1575 << 32 |  1620):  1571,
r_longlong( 1608 << 32 |  1620):  1572,
r_longlong( 1575 << 32 |  1621):  1573,
r_longlong( 1610 << 32 |  1620):  1574,
r_longlong( 1749 << 32 |  1620):  1728,
r_longlong( 1729 << 32 |  1620):  1730,
r_longlong( 1746 << 32 |  1620):  1747,
r_longlong( 2344 << 32 |  2364):  2345,
r_longlong( 2352 << 32 |  2364):  2353,
r_longlong( 2355 << 32 |  2364):  2356,
r_longlong( 2503 << 32 |  2494):  2507,
r_longlong( 2503 << 32 |  2519):  2508,
r_longlong( 2887 << 32 |  2902):  2888,
r_longlong( 2887 << 32 |  2878):  2891,
r_longlong( 2887 << 32 |  2903):  2892,
r_longlong( 2962 << 32 |  3031):  2964,
r_longlong( 3014 << 32 |  3006):  3018,
r_longlong( 3015 << 32 |  3006):  3019,
r_longlong( 3014 << 32 |  3031):  3020,
r_longlong( 3142 << 32 |  3158):  3144,
r_longlong( 3263 << 32 |  3285):  3264,
r_longlong( 3270 << 32 |  3285):  3271,
r_longlong( 3270 << 32 |  3286):  3272,
r_longlong( 3270 << 32 |  3266):  3274,
r_longlong( 3274 << 32 |  3285):  3275,
r_longlong( 3398 << 32 |  3390):  3402,
r_longlong( 3399 << 32 |  3390):  3403,
r_longlong( 3398 << 32 |  3415):  3404,
r_longlong( 3545 << 32 |  3530):  3546,
r_longlong( 3545 << 32 |  3535):  3548,
r_longlong( 3548 << 32 |  3530):  3549,
r_longlong( 3545 << 32 |  3551):  3550,
r_longlong( 4133 << 32 |  4142):  4134,
r_longlong( 6917 << 32 |  6965):  6918,
r_longlong( 6919 << 32 |  6965):  6920,
r_longlong( 6921 << 32 |  6965):  6922,
r_longlong( 6923 << 32 |  6965):  6924,
r_longlong( 6925 << 32 |  6965):  6926,
r_longlong( 6929 << 32 |  6965):  6930,
r_longlong( 6970 << 32 |  6965):  6971,
r_longlong( 6972 << 32 |  6965):  6973,
r_longlong( 6974 << 32 |  6965):  6976,
r_longlong( 6975 << 32 |  6965):  6977,
r_longlong( 6978 << 32 |  6965):  6979,
r_longlong(   65 << 32 |   805):  7680,
r_longlong(   97 << 32 |   805):  7681,
r_longlong(   66 << 32 |   775):  7682,
r_longlong(   98 << 32 |   775):  7683,
r_longlong(   66 << 32 |   803):  7684,
r_longlong(   98 << 32 |   803):  7685,
r_longlong(   66 << 32 |   817):  7686,
r_longlong(   98 << 32 |   817):  7687,
r_longlong(  199 << 32 |   769):  7688,
r_longlong(  231 << 32 |   769):  7689,
r_longlong(   68 << 32 |   775):  7690,
r_longlong(  100 << 32 |   775):  7691,
r_longlong(   68 << 32 |   803):  7692,
r_longlong(  100 << 32 |   803):  7693,
r_longlong(   68 << 32 |   817):  7694,
r_longlong(  100 << 32 |   817):  7695,
r_longlong(   68 << 32 |   807):  7696,
r_longlong(  100 << 32 |   807):  7697,
r_longlong(   68 << 32 |   813):  7698,
r_longlong(  100 << 32 |   813):  7699,
r_longlong(  274 << 32 |   768):  7700,
r_longlong(  275 << 32 |   768):  7701,
r_longlong(  274 << 32 |   769):  7702,
r_longlong(  275 << 32 |   769):  7703,
r_longlong(   69 << 32 |   813):  7704,
r_longlong(  101 << 32 |   813):  7705,
r_longlong(   69 << 32 |   816):  7706,
r_longlong(  101 << 32 |   816):  7707,
r_longlong(  552 << 32 |   774):  7708,
r_longlong(  553 << 32 |   774):  7709,
r_longlong(   70 << 32 |   775):  7710,
r_longlong(  102 << 32 |   775):  7711,
r_longlong(   71 << 32 |   772):  7712,
r_longlong(  103 << 32 |   772):  7713,
r_longlong(   72 << 32 |   775):  7714,
r_longlong(  104 << 32 |   775):  7715,
r_longlong(   72 << 32 |   803):  7716,
r_longlong(  104 << 32 |   803):  7717,
r_longlong(   72 << 32 |   776):  7718,
r_longlong(  104 << 32 |   776):  7719,
r_longlong(   72 << 32 |   807):  7720,
r_longlong(  104 << 32 |   807):  7721,
r_longlong(   72 << 32 |   814):  7722,
r_longlong(  104 << 32 |   814):  7723,
r_longlong(   73 << 32 |   816):  7724,
r_longlong(  105 << 32 |   816):  7725,
r_longlong(  207 << 32 |   769):  7726,
r_longlong(  239 << 32 |   769):  7727,
r_longlong(   75 << 32 |   769):  7728,
r_longlong(  107 << 32 |   769):  7729,
r_longlong(   75 << 32 |   803):  7730,
r_longlong(  107 << 32 |   803):  7731,
r_longlong(   75 << 32 |   817):  7732,
r_longlong(  107 << 32 |   817):  7733,
r_longlong(   76 << 32 |   803):  7734,
r_longlong(  108 << 32 |   803):  7735,
r_longlong( 7734 << 32 |   772):  7736,
r_longlong( 7735 << 32 |   772):  7737,
r_longlong(   76 << 32 |   817):  7738,
r_longlong(  108 << 32 |   817):  7739,
r_longlong(   76 << 32 |   813):  7740,
r_longlong(  108 << 32 |   813):  7741,
r_longlong(   77 << 32 |   769):  7742,
r_longlong(  109 << 32 |   769):  7743,
r_longlong(   77 << 32 |   775):  7744,
r_longlong(  109 << 32 |   775):  7745,
r_longlong(   77 << 32 |   803):  7746,
r_longlong(  109 << 32 |   803):  7747,
r_longlong(   78 << 32 |   775):  7748,
r_longlong(  110 << 32 |   775):  7749,
r_longlong(   78 << 32 |   803):  7750,
r_longlong(  110 << 32 |   803):  7751,
r_longlong(   78 << 32 |   817):  7752,
r_longlong(  110 << 32 |   817):  7753,
r_longlong(   78 << 32 |   813):  7754,
r_longlong(  110 << 32 |   813):  7755,
r_longlong(  213 << 32 |   769):  7756,
r_longlong(  245 << 32 |   769):  7757,
r_longlong(  213 << 32 |   776):  7758,
r_longlong(  245 << 32 |   776):  7759,
r_longlong(  332 << 32 |   768):  7760,
r_longlong(  333 << 32 |   768):  7761,
r_longlong(  332 << 32 |   769):  7762,
r_longlong(  333 << 32 |   769):  7763,
r_longlong(   80 << 32 |   769):  7764,
r_longlong(  112 << 32 |   769):  7765,
r_longlong(   80 << 32 |   775):  7766,
r_longlong(  112 << 32 |   775):  7767,
r_longlong(   82 << 32 |   775):  7768,
r_longlong(  114 << 32 |   775):  7769,
r_longlong(   82 << 32 |   803):  7770,
r_longlong(  114 << 32 |   803):  7771,
r_longlong( 7770 << 32 |   772):  7772,
r_longlong( 7771 << 32 |   772):  7773,
r_longlong(   82 << 32 |   817):  7774,
r_longlong(  114 << 32 |   817):  7775,
r_longlong(   83 << 32 |   775):  7776,
r_longlong(  115 << 32 |   775):  7777,
r_longlong(   83 << 32 |   803):  7778,
r_longlong(  115 << 32 |   803):  7779,
r_longlong(  346 << 32 |   775):  7780,
r_longlong(  347 << 32 |   775):  7781,
r_longlong(  352 << 32 |   775):  7782,
r_longlong(  353 << 32 |   775):  7783,
r_longlong( 7778 << 32 |   775):  7784,
r_longlong( 7779 << 32 |   775):  7785,
r_longlong(   84 << 32 |   775):  7786,
r_longlong(  116 << 32 |   775):  7787,
r_longlong(   84 << 32 |   803):  7788,
r_longlong(  116 << 32 |   803):  7789,
r_longlong(   84 << 32 |   817):  7790,
r_longlong(  116 << 32 |   817):  7791,
r_longlong(   84 << 32 |   813):  7792,
r_longlong(  116 << 32 |   813):  7793,
r_longlong(   85 << 32 |   804):  7794,
r_longlong(  117 << 32 |   804):  7795,
r_longlong(   85 << 32 |   816):  7796,
r_longlong(  117 << 32 |   816):  7797,
r_longlong(   85 << 32 |   813):  7798,
r_longlong(  117 << 32 |   813):  7799,
r_longlong(  360 << 32 |   769):  7800,
r_longlong(  361 << 32 |   769):  7801,
r_longlong(  362 << 32 |   776):  7802,
r_longlong(  363 << 32 |   776):  7803,
r_longlong(   86 << 32 |   771):  7804,
r_longlong(  118 << 32 |   771):  7805,
r_longlong(   86 << 32 |   803):  7806,
r_longlong(  118 << 32 |   803):  7807,
r_longlong(   87 << 32 |   768):  7808,
r_longlong(  119 << 32 |   768):  7809,
r_longlong(   87 << 32 |   769):  7810,
r_longlong(  119 << 32 |   769):  7811,
r_longlong(   87 << 32 |   776):  7812,
r_longlong(  119 << 32 |   776):  7813,
r_longlong(   87 << 32 |   775):  7814,
r_longlong(  119 << 32 |   775):  7815,
r_longlong(   87 << 32 |   803):  7816,
r_longlong(  119 << 32 |   803):  7817,
r_longlong(   88 << 32 |   775):  7818,
r_longlong(  120 << 32 |   775):  7819,
r_longlong(   88 << 32 |   776):  7820,
r_longlong(  120 << 32 |   776):  7821,
r_longlong(   89 << 32 |   775):  7822,
r_longlong(  121 << 32 |   775):  7823,
r_longlong(   90 << 32 |   770):  7824,
r_longlong(  122 << 32 |   770):  7825,
r_longlong(   90 << 32 |   803):  7826,
r_longlong(  122 << 32 |   803):  7827,
r_longlong(   90 << 32 |   817):  7828,
r_longlong(  122 << 32 |   817):  7829,
r_longlong(  104 << 32 |   817):  7830,
r_longlong(  116 << 32 |   776):  7831,
r_longlong(  119 << 32 |   778):  7832,
r_longlong(  121 << 32 |   778):  7833,
r_longlong(  383 << 32 |   775):  7835,
r_longlong(   65 << 32 |   803):  7840,
r_longlong(   97 << 32 |   803):  7841,
r_longlong(   65 << 32 |   777):  7842,
r_longlong(   97 << 32 |   777):  7843,
r_longlong(  194 << 32 |   769):  7844,
r_longlong(  226 << 32 |   769):  7845,
r_longlong(  194 << 32 |   768):  7846,
r_longlong(  226 << 32 |   768):  7847,
r_longlong(  194 << 32 |   777):  7848,
r_longlong(  226 << 32 |   777):  7849,
r_longlong(  194 << 32 |   771):  7850,
r_longlong(  226 << 32 |   771):  7851,
r_longlong( 7840 << 32 |   770):  7852,
r_longlong( 7841 << 32 |   770):  7853,
r_longlong(  258 << 32 |   769):  7854,
r_longlong(  259 << 32 |   769):  7855,
r_longlong(  258 << 32 |   768):  7856,
r_longlong(  259 << 32 |   768):  7857,
r_longlong(  258 << 32 |   777):  7858,
r_longlong(  259 << 32 |   777):  7859,
r_longlong(  258 << 32 |   771):  7860,
r_longlong(  259 << 32 |   771):  7861,
r_longlong( 7840 << 32 |   774):  7862,
r_longlong( 7841 << 32 |   774):  7863,
r_longlong(   69 << 32 |   803):  7864,
r_longlong(  101 << 32 |   803):  7865,
r_longlong(   69 << 32 |   777):  7866,
r_longlong(  101 << 32 |   777):  7867,
r_longlong(   69 << 32 |   771):  7868,
r_longlong(  101 << 32 |   771):  7869,
r_longlong(  202 << 32 |   769):  7870,
r_longlong(  234 << 32 |   769):  7871,
r_longlong(  202 << 32 |   768):  7872,
r_longlong(  234 << 32 |   768):  7873,
r_longlong(  202 << 32 |   777):  7874,
r_longlong(  234 << 32 |   777):  7875,
r_longlong(  202 << 32 |   771):  7876,
r_longlong(  234 << 32 |   771):  7877,
r_longlong( 7864 << 32 |   770):  7878,
r_longlong( 7865 << 32 |   770):  7879,
r_longlong(   73 << 32 |   777):  7880,
r_longlong(  105 << 32 |   777):  7881,
r_longlong(   73 << 32 |   803):  7882,
r_longlong(  105 << 32 |   803):  7883,
r_longlong(   79 << 32 |   803):  7884,
r_longlong(  111 << 32 |   803):  7885,
r_longlong(   79 << 32 |   777):  7886,
r_longlong(  111 << 32 |   777):  7887,
r_longlong(  212 << 32 |   769):  7888,
r_longlong(  244 << 32 |   769):  7889,
r_longlong(  212 << 32 |   768):  7890,
r_longlong(  244 << 32 |   768):  7891,
r_longlong(  212 << 32 |   777):  7892,
r_longlong(  244 << 32 |   777):  7893,
r_longlong(  212 << 32 |   771):  7894,
r_longlong(  244 << 32 |   771):  7895,
r_longlong( 7884 << 32 |   770):  7896,
r_longlong( 7885 << 32 |   770):  7897,
r_longlong(  416 << 32 |   769):  7898,
r_longlong(  417 << 32 |   769):  7899,
r_longlong(  416 << 32 |   768):  7900,
r_longlong(  417 << 32 |   768):  7901,
r_longlong(  416 << 32 |   777):  7902,
r_longlong(  417 << 32 |   777):  7903,
r_longlong(  416 << 32 |   771):  7904,
r_longlong(  417 << 32 |   771):  7905,
r_longlong(  416 << 32 |   803):  7906,
r_longlong(  417 << 32 |   803):  7907,
r_longlong(   85 << 32 |   803):  7908,
r_longlong(  117 << 32 |   803):  7909,
r_longlong(   85 << 32 |   777):  7910,
r_longlong(  117 << 32 |   777):  7911,
r_longlong(  431 << 32 |   769):  7912,
r_longlong(  432 << 32 |   769):  7913,
r_longlong(  431 << 32 |   768):  7914,
r_longlong(  432 << 32 |   768):  7915,
r_longlong(  431 << 32 |   777):  7916,
r_longlong(  432 << 32 |   777):  7917,
r_longlong(  431 << 32 |   771):  7918,
r_longlong(  432 << 32 |   771):  7919,
r_longlong(  431 << 32 |   803):  7920,
r_longlong(  432 << 32 |   803):  7921,
r_longlong(   89 << 32 |   768):  7922,
r_longlong(  121 << 32 |   768):  7923,
r_longlong(   89 << 32 |   803):  7924,
r_longlong(  121 << 32 |   803):  7925,
r_longlong(   89 << 32 |   777):  7926,
r_longlong(  121 << 32 |   777):  7927,
r_longlong(   89 << 32 |   771):  7928,
r_longlong(  121 << 32 |   771):  7929,
r_longlong(  945 << 32 |   787):  7936,
r_longlong(  945 << 32 |   788):  7937,
r_longlong( 7936 << 32 |   768):  7938,
r_longlong( 7937 << 32 |   768):  7939,
r_longlong( 7936 << 32 |   769):  7940,
r_longlong( 7937 << 32 |   769):  7941,
r_longlong( 7936 << 32 |   834):  7942,
r_longlong( 7937 << 32 |   834):  7943,
r_longlong(  913 << 32 |   787):  7944,
r_longlong(  913 << 32 |   788):  7945,
r_longlong( 7944 << 32 |   768):  7946,
r_longlong( 7945 << 32 |   768):  7947,
r_longlong( 7944 << 32 |   769):  7948,
r_longlong( 7945 << 32 |   769):  7949,
r_longlong( 7944 << 32 |   834):  7950,
r_longlong( 7945 << 32 |   834):  7951,
r_longlong(  949 << 32 |   787):  7952,
r_longlong(  949 << 32 |   788):  7953,
r_longlong( 7952 << 32 |   768):  7954,
r_longlong( 7953 << 32 |   768):  7955,
r_longlong( 7952 << 32 |   769):  7956,
r_longlong( 7953 << 32 |   769):  7957,
r_longlong(  917 << 32 |   787):  7960,
r_longlong(  917 << 32 |   788):  7961,
r_longlong( 7960 << 32 |   768):  7962,
r_longlong( 7961 << 32 |   768):  7963,
r_longlong( 7960 << 32 |   769):  7964,
r_longlong( 7961 << 32 |   769):  7965,
r_longlong(  951 << 32 |   787):  7968,
r_longlong(  951 << 32 |   788):  7969,
r_longlong( 7968 << 32 |   768):  7970,
r_longlong( 7969 << 32 |   768):  7971,
r_longlong( 7968 << 32 |   769):  7972,
r_longlong( 7969 << 32 |   769):  7973,
r_longlong( 7968 << 32 |   834):  7974,
r_longlong( 7969 << 32 |   834):  7975,
r_longlong(  919 << 32 |   787):  7976,
r_longlong(  919 << 32 |   788):  7977,
r_longlong( 7976 << 32 |   768):  7978,
r_longlong( 7977 << 32 |   768):  7979,
r_longlong( 7976 << 32 |   769):  7980,
r_longlong( 7977 << 32 |   769):  7981,
r_longlong( 7976 << 32 |   834):  7982,
r_longlong( 7977 << 32 |   834):  7983,
r_longlong(  953 << 32 |   787):  7984,
r_longlong(  953 << 32 |   788):  7985,
r_longlong( 7984 << 32 |   768):  7986,
r_longlong( 7985 << 32 |   768):  7987,
r_longlong( 7984 << 32 |   769):  7988,
r_longlong( 7985 << 32 |   769):  7989,
r_longlong( 7984 << 32 |   834):  7990,
r_longlong( 7985 << 32 |   834):  7991,
r_longlong(  921 << 32 |   787):  7992,
r_longlong(  921 << 32 |   788):  7993,
r_longlong( 7992 << 32 |   768):  7994,
r_longlong( 7993 << 32 |   768):  7995,
r_longlong( 7992 << 32 |   769):  7996,
r_longlong( 7993 << 32 |   769):  7997,
r_longlong( 7992 << 32 |   834):  7998,
r_longlong( 7993 << 32 |   834):  7999,
r_longlong(  959 << 32 |   787):  8000,
r_longlong(  959 << 32 |   788):  8001,
r_longlong( 8000 << 32 |   768):  8002,
r_longlong( 8001 << 32 |   768):  8003,
r_longlong( 8000 << 32 |   769):  8004,
r_longlong( 8001 << 32 |   769):  8005,
r_longlong(  927 << 32 |   787):  8008,
r_longlong(  927 << 32 |   788):  8009,
r_longlong( 8008 << 32 |   768):  8010,
r_longlong( 8009 << 32 |   768):  8011,
r_longlong( 8008 << 32 |   769):  8012,
r_longlong( 8009 << 32 |   769):  8013,
r_longlong(  965 << 32 |   787):  8016,
r_longlong(  965 << 32 |   788):  8017,
r_longlong( 8016 << 32 |   768):  8018,
r_longlong( 8017 << 32 |   768):  8019,
r_longlong( 8016 << 32 |   769):  8020,
r_longlong( 8017 << 32 |   769):  8021,
r_longlong( 8016 << 32 |   834):  8022,
r_longlong( 8017 << 32 |   834):  8023,
r_longlong(  933 << 32 |   788):  8025,
r_longlong( 8025 << 32 |   768):  8027,
r_longlong( 8025 << 32 |   769):  8029,
r_longlong( 8025 << 32 |   834):  8031,
r_longlong(  969 << 32 |   787):  8032,
r_longlong(  969 << 32 |   788):  8033,
r_longlong( 8032 << 32 |   768):  8034,
r_longlong( 8033 << 32 |   768):  8035,
r_longlong( 8032 << 32 |   769):  8036,
r_longlong( 8033 << 32 |   769):  8037,
r_longlong( 8032 << 32 |   834):  8038,
r_longlong( 8033 << 32 |   834):  8039,
r_longlong(  937 << 32 |   787):  8040,
r_longlong(  937 << 32 |   788):  8041,
r_longlong( 8040 << 32 |   768):  8042,
r_longlong( 8041 << 32 |   768):  8043,
r_longlong( 8040 << 32 |   769):  8044,
r_longlong( 8041 << 32 |   769):  8045,
r_longlong( 8040 << 32 |   834):  8046,
r_longlong( 8041 << 32 |   834):  8047,
r_longlong(  945 << 32 |   768):  8048,
r_longlong(  949 << 32 |   768):  8050,
r_longlong(  951 << 32 |   768):  8052,
r_longlong(  953 << 32 |   768):  8054,
r_longlong(  959 << 32 |   768):  8056,
r_longlong(  965 << 32 |   768):  8058,
r_longlong(  969 << 32 |   768):  8060,
r_longlong( 7936 << 32 |   837):  8064,
r_longlong( 7937 << 32 |   837):  8065,
r_longlong( 7938 << 32 |   837):  8066,
r_longlong( 7939 << 32 |   837):  8067,
r_longlong( 7940 << 32 |   837):  8068,
r_longlong( 7941 << 32 |   837):  8069,
r_longlong( 7942 << 32 |   837):  8070,
r_longlong( 7943 << 32 |   837):  8071,
r_longlong( 7944 << 32 |   837):  8072,
r_longlong( 7945 << 32 |   837):  8073,
r_longlong( 7946 << 32 |   837):  8074,
r_longlong( 7947 << 32 |   837):  8075,
r_longlong( 7948 << 32 |   837):  8076,
r_longlong( 7949 << 32 |   837):  8077,
r_longlong( 7950 << 32 |   837):  8078,
r_longlong( 7951 << 32 |   837):  8079,
r_longlong( 7968 << 32 |   837):  8080,
r_longlong( 7969 << 32 |   837):  8081,
r_longlong( 7970 << 32 |   837):  8082,
r_longlong( 7971 << 32 |   837):  8083,
r_longlong( 7972 << 32 |   837):  8084,
r_longlong( 7973 << 32 |   837):  8085,
r_longlong( 7974 << 32 |   837):  8086,
r_longlong( 7975 << 32 |   837):  8087,
r_longlong( 7976 << 32 |   837):  8088,
r_longlong( 7977 << 32 |   837):  8089,
r_longlong( 7978 << 32 |   837):  8090,
r_longlong( 7979 << 32 |   837):  8091,
r_longlong( 7980 << 32 |   837):  8092,
r_longlong( 7981 << 32 |   837):  8093,
r_longlong( 7982 << 32 |   837):  8094,
r_longlong( 7983 << 32 |   837):  8095,
r_longlong( 8032 << 32 |   837):  8096,
r_longlong( 8033 << 32 |   837):  8097,
r_longlong( 8034 << 32 |   837):  8098,
r_longlong( 8035 << 32 |   837):  8099,
r_longlong( 8036 << 32 |   837):  8100,
r_longlong( 8037 << 32 |   837):  8101,
r_longlong( 8038 << 32 |   837):  8102,
r_longlong( 8039 << 32 |   837):  8103,
r_longlong( 8040 << 32 |   837):  8104,
r_longlong( 8041 << 32 |   837):  8105,
r_longlong( 8042 << 32 |   837):  8106,
r_longlong( 8043 << 32 |   837):  8107,
r_longlong( 8044 << 32 |   837):  8108,
r_longlong( 8045 << 32 |   837):  8109,
r_longlong( 8046 << 32 |   837):  8110,
r_longlong( 8047 << 32 |   837):  8111,
r_longlong(  945 << 32 |   774):  8112,
r_longlong(  945 << 32 |   772):  8113,
r_longlong( 8048 << 32 |   837):  8114,
r_longlong(  945 << 32 |   837):  8115,
r_longlong(  940 << 32 |   837):  8116,
r_longlong(  945 << 32 |   834):  8118,
r_longlong( 8118 << 32 |   837):  8119,
r_longlong(  913 << 32 |   774):  8120,
r_longlong(  913 << 32 |   772):  8121,
r_longlong(  913 << 32 |   768):  8122,
r_longlong(  913 << 32 |   837):  8124,
r_longlong(  168 << 32 |   834):  8129,
r_longlong( 8052 << 32 |   837):  8130,
r_longlong(  951 << 32 |   837):  8131,
r_longlong(  942 << 32 |   837):  8132,
r_longlong(  951 << 32 |   834):  8134,
r_longlong( 8134 << 32 |   837):  8135,
r_longlong(  917 << 32 |   768):  8136,
r_longlong(  919 << 32 |   768):  8138,
r_longlong(  919 << 32 |   837):  8140,
r_longlong( 8127 << 32 |   768):  8141,
r_longlong( 8127 << 32 |   769):  8142,
r_longlong( 8127 << 32 |   834):  8143,
r_longlong(  953 << 32 |   774):  8144,
r_longlong(  953 << 32 |   772):  8145,
r_longlong(  970 << 32 |   768):  8146,
r_longlong(  953 << 32 |   834):  8150,
r_longlong(  970 << 32 |   834):  8151,
r_longlong(  921 << 32 |   774):  8152,
r_longlong(  921 << 32 |   772):  8153,
r_longlong(  921 << 32 |   768):  8154,
r_longlong( 8190 << 32 |   768):  8157,
r_longlong( 8190 << 32 |   769):  8158,
r_longlong( 8190 << 32 |   834):  8159,
r_longlong(  965 << 32 |   774):  8160,
r_longlong(  965 << 32 |   772):  8161,
r_longlong(  971 << 32 |   768):  8162,
r_longlong(  961 << 32 |   787):  8164,
r_longlong(  961 << 32 |   788):  8165,
r_longlong(  965 << 32 |   834):  8166,
r_longlong(  971 << 32 |   834):  8167,
r_longlong(  933 << 32 |   774):  8168,
r_longlong(  933 << 32 |   772):  8169,
r_longlong(  933 << 32 |   768):  8170,
r_longlong(  929 << 32 |   788):  8172,
r_longlong(  168 << 32 |   768):  8173,
r_longlong( 8060 << 32 |   837):  8178,
r_longlong(  969 << 32 |   837):  8179,
r_longlong(  974 << 32 |   837):  8180,
r_longlong(  969 << 32 |   834):  8182,
r_longlong( 8182 << 32 |   837):  8183,
r_longlong(  927 << 32 |   768):  8184,
r_longlong(  937 << 32 |   768):  8186,
r_longlong(  937 << 32 |   837):  8188,
r_longlong( 8592 << 32 |   824):  8602,
r_longlong( 8594 << 32 |   824):  8603,
r_longlong( 8596 << 32 |   824):  8622,
r_longlong( 8656 << 32 |   824):  8653,
r_longlong( 8660 << 32 |   824):  8654,
r_longlong( 8658 << 32 |   824):  8655,
r_longlong( 8707 << 32 |   824):  8708,
r_longlong( 8712 << 32 |   824):  8713,
r_longlong( 8715 << 32 |   824):  8716,
r_longlong( 8739 << 32 |   824):  8740,
r_longlong( 8741 << 32 |   824):  8742,
r_longlong( 8764 << 32 |   824):  8769,
r_longlong( 8771 << 32 |   824):  8772,
r_longlong( 8773 << 32 |   824):  8775,
r_longlong( 8776 << 32 |   824):  8777,
r_longlong(   61 << 32 |   824):  8800,
r_longlong( 8801 << 32 |   824):  8802,
r_longlong( 8781 << 32 |   824):  8813,
r_longlong(   60 << 32 |   824):  8814,
r_longlong(   62 << 32 |   824):  8815,
r_longlong( 8804 << 32 |   824):  8816,
r_longlong( 8805 << 32 |   824):  8817,
r_longlong( 8818 << 32 |   824):  8820,
r_longlong( 8819 << 32 |   824):  8821,
r_longlong( 8822 << 32 |   824):  8824,
r_longlong( 8823 << 32 |   824):  8825,
r_longlong( 8826 << 32 |   824):  8832,
r_longlong( 8827 << 32 |   824):  8833,
r_longlong( 8834 << 32 |   824):  8836,
r_longlong( 8835 << 32 |   824):  8837,
r_longlong( 8838 << 32 |   824):  8840,
r_longlong( 8839 << 32 |   824):  8841,
r_longlong( 8866 << 32 |   824):  8876,
r_longlong( 8872 << 32 |   824):  8877,
r_longlong( 8873 << 32 |   824):  8878,
r_longlong( 8875 << 32 |   824):  8879,
r_longlong( 8828 << 32 |   824):  8928,
r_longlong( 8829 << 32 |   824):  8929,
r_longlong( 8849 << 32 |   824):  8930,
r_longlong( 8850 << 32 |   824):  8931,
r_longlong( 8882 << 32 |   824):  8938,
r_longlong( 8883 << 32 |   824):  8939,
r_longlong( 8884 << 32 |   824):  8940,
r_longlong( 8885 << 32 |   824):  8941,
r_longlong(12363 << 32 | 12441): 12364,
r_longlong(12365 << 32 | 12441): 12366,
r_longlong(12367 << 32 | 12441): 12368,
r_longlong(12369 << 32 | 12441): 12370,
r_longlong(12371 << 32 | 12441): 12372,
r_longlong(12373 << 32 | 12441): 12374,
r_longlong(12375 << 32 | 12441): 12376,
r_longlong(12377 << 32 | 12441): 12378,
r_longlong(12379 << 32 | 12441): 12380,
r_longlong(12381 << 32 | 12441): 12382,
r_longlong(12383 << 32 | 12441): 12384,
r_longlong(12385 << 32 | 12441): 12386,
r_longlong(12388 << 32 | 12441): 12389,
r_longlong(12390 << 32 | 12441): 12391,
r_longlong(12392 << 32 | 12441): 12393,
r_longlong(12399 << 32 | 12441): 12400,
r_longlong(12399 << 32 | 12442): 12401,
r_longlong(12402 << 32 | 12441): 12403,
r_longlong(12402 << 32 | 12442): 12404,
r_longlong(12405 << 32 | 12441): 12406,
r_longlong(12405 << 32 | 12442): 12407,
r_longlong(12408 << 32 | 12441): 12409,
r_longlong(12408 << 32 | 12442): 12410,
r_longlong(12411 << 32 | 12441): 12412,
r_longlong(12411 << 32 | 12442): 12413,
r_longlong(12358 << 32 | 12441): 12436,
r_longlong(12445 << 32 | 12441): 12446,
r_longlong(12459 << 32 | 12441): 12460,
r_longlong(12461 << 32 | 12441): 12462,
r_longlong(12463 << 32 | 12441): 12464,
r_longlong(12465 << 32 | 12441): 12466,
r_longlong(12467 << 32 | 12441): 12468,
r_longlong(12469 << 32 | 12441): 12470,
r_longlong(12471 << 32 | 12441): 12472,
r_longlong(12473 << 32 | 12441): 12474,
r_longlong(12475 << 32 | 12441): 12476,
r_longlong(12477 << 32 | 12441): 12478,
r_longlong(12479 << 32 | 12441): 12480,
r_longlong(12481 << 32 | 12441): 12482,
r_longlong(12484 << 32 | 12441): 12485,
r_longlong(12486 << 32 | 12441): 12487,
r_longlong(12488 << 32 | 12441): 12489,
r_longlong(12495 << 32 | 12441): 12496,
r_longlong(12495 << 32 | 12442): 12497,
r_longlong(12498 << 32 | 12441): 12499,
r_longlong(12498 << 32 | 12442): 12500,
r_longlong(12501 << 32 | 12441): 12502,
r_longlong(12501 << 32 | 12442): 12503,
r_longlong(12504 << 32 | 12441): 12505,
r_longlong(12504 << 32 | 12442): 12506,
r_longlong(12507 << 32 | 12441): 12508,
r_longlong(12507 << 32 | 12442): 12509,
r_longlong(12454 << 32 | 12441): 12532,
r_longlong(12527 << 32 | 12441): 12535,
r_longlong(12528 << 32 | 12441): 12536,
r_longlong(12529 << 32 | 12441): 12537,
r_longlong(12530 << 32 | 12441): 12538,
r_longlong(12541 << 32 | 12441): 12542,
r_longlong(69785 << 32 | 69818): 69786,
r_longlong(69787 << 32 | 69818): 69788,
r_longlong(69797 << 32 | 69818): 69803,
r_longlong(69937 << 32 | 69927): 69934,
r_longlong(69938 << 32 | 69927): 69935,
r_longlong(70471 << 32 | 70462): 70475,
r_longlong(70471 << 32 | 70487): 70476,
r_longlong(70841 << 32 | 70842): 70843,
r_longlong(70841 << 32 | 70832): 70844,
r_longlong(70841 << 32 | 70845): 70846,
r_longlong(71096 << 32 | 71087): 71098,
r_longlong(71097 << 32 | 71087): 71099,
}

_canon_decomposition = {
64046: [37086],
64047: [38583],
69934: [69937, 69927],
69935: [69938, 69927],
70475: [70471, 70462],
70476: [70471, 70487],
70843: [70841, 70842],
70844: [70841, 70832],
70846: [70841, 70845],
71098: [71096, 71087],
71099: [71097, 71087],
}

_canon_decomposition_corrected = {
}
_compat_decomposition = {
8341: [104],
8342: [107],
8343: [108],
8344: [109],
8345: [110],
8346: [112],
8347: [115],
8348: [116],
42652: [1098],
42653: [1100],
43000: [294],
43001: [339],
43868: [42791],
43869: [43831],
43870: [619],
43871: [43858],
64046: [37086],
64047: [38583],
69934: [69937, 69927],
69935: [69938, 69927],
70475: [70471, 70462],
70476: [70471, 70487],
70843: [70841, 70842],
70844: [70841, 70832],
70846: [70841, 70845],
71098: [71096, 71087],
71099: [71097, 71087],
126464: [1575],
126465: [1576],
126466: [1580],
126467: [1583],
126469: [1608],
126470: [1586],
126471: [1581],
126472: [1591],
126473: [1610],
126474: [1603],
126475: [1604],
126476: [1605],
126477: [1606],
126478: [1587],
126479: [1593],
126480: [1601],
126481: [1589],
126482: [1602],
126483: [1585],
126484: [1588],
126485: [1578],
126486: [1579],
126487: [1582],
126488: [1584],
126489: [1590],
126490: [1592],
126491: [1594],
126492: [1646],
126493: [1722],
126494: [1697],
126495: [1647],
126497: [1576],
126498: [1580],
126500: [1607],
126503: [1581],
126505: [1610],
126506: [1603],
126507: [1604],
126508: [1605],
126509: [1606],
126510: [1587],
126511: [1593],
126512: [1601],
126513: [1589],
126514: [1602],
126516: [1588],
126517: [1578],
126518: [1579],
126519: [1582],
126521: [1590],
126523: [1594],
126530: [1580],
126535: [1581],
126537: [1610],
126539: [1604],
126541: [1606],
126542: [1587],
126543: [1593],
126545: [1589],
126546: [1602],
126548: [1588],
126551: [1582],
126553: [1590],
126555: [1594],
126557: [1722],
126559: [1647],
126561: [1576],
126562: [1580],
126564: [1607],
126567: [1581],
126568: [1591],
126569: [1610],
126570: [1603],
126572: [1605],
126573: [1606],
126574: [1587],
126575: [1593],
126576: [1601],
126577: [1589],
126578: [1602],
126580: [1588],
126581: [1578],
126582: [1579],
126583: [1582],
126585: [1590],
126586: [1592],
126587: [1594],
126588: [1646],
126590: [1697],
126592: [1575],
126593: [1576],
126594: [1580],
126595: [1583],
126596: [1607],
126597: [1608],
126598: [1586],
126599: [1581],
126600: [1591],
126601: [1610],
126603: [1604],
126604: [1605],
126605: [1606],
126606: [1587],
126607: [1593],
126608: [1601],
126609: [1589],
126610: [1602],
126611: [1585],
126612: [1588],
126613: [1578],
126614: [1579],
126615: [1582],
126616: [1584],
126617: [1590],
126618: [1592],
126619: [1594],
126625: [1576],
126626: [1580],
126627: [1583],
126629: [1608],
126630: [1586],
126631: [1581],
126632: [1591],
126633: [1610],
126635: [1604],
126636: [1605],
126637: [1606],
126638: [1587],
126639: [1593],
126640: [1601],
126641: [1589],
126642: [1602],
126643: [1585],
126644: [1588],
126645: [1578],
126646: [1579],
126647: [1582],
126648: [1584],
126649: [1590],
126650: [1592],
126651: [1594],
127280: [65],
127282: [67],
127283: [68],
127284: [69],
127285: [70],
127286: [71],
127287: [72],
127288: [73],
127289: [74],
127290: [75],
127291: [76],
127292: [77],
127294: [79],
127296: [81],
127297: [82],
127299: [84],
127300: [85],
127301: [86],
127303: [88],
127304: [89],
127305: [90],
127311: [87, 67],
127338: [77, 67],
127339: [77, 68],
127489: [12467, 12467],
127490: [12469],
127538: [31105],
127539: [31354],
127540: [21512],
127541: [28288],
127542: [26377],
127543: [26376],
127544: [30003],
127545: [21106],
127546: [21942],
127568: [24471],
127569: [21487],
}

_compat_decomposition_corrected = {
}

def canon_decomposition(code):
    try:
        return _canon_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _canon_decomposition_corrected:
            return base_mod._canon_decomposition.get(code, [])
        else:
            return []
def compat_decomposition(code):
    try:
        return _compat_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _compat_decomposition_corrected:
            return base_mod._compat_decomposition.get(code, [])
        else:
            return []


_named_sequences = [
u'\u0100\u0300',
u'\u0101\u0300',
u'E\u0329',
u'e\u0329',
u'\xc8\u0329',
u'\xe8\u0329',
u'\xc9\u0329',
u'\xe9\u0329',
u'\xca\u0304',
u'\xea\u0304',
u'\xca\u030c',
u'\xea\u030c',
u'\u012a\u0300',
u'\u012b\u0300',
u'i\u0307\u0301',
u'n\u0360g',
u'O\u0329',
u'o\u0329',
u'\xd2\u0329',
u'\xf2\u0329',
u'\xd3\u0329',
u'\xf3\u0329',
u'S\u0329',
u's\u0329',
u'\u016a\u0300',
u'\u016b\u0300',
u'\u0104\u0301',
u'\u0105\u0301',
u'\u0104\u0303',
u'\u0105\u0303',
u'\u0118\u0301',
u'\u0119\u0301',
u'\u0118\u0303',
u'\u0119\u0303',
u'\u0116\u0301',
u'\u0117\u0301',
u'\u0116\u0303',
u'\u0117\u0303',
u'i\u0307\u0300',
u'i\u0307\u0303',
u'\u012e\u0301',
u'\u012f\u0307\u0301',
u'\u012e\u0303',
u'\u012f\u0307\u0303',
u'J\u0303',
u'j\u0307\u0303',
u'L\u0303',
u'l\u0303',
u'M\u0303',
u'm\u0303',
u'R\u0303',
u'r\u0303',
u'\u0172\u0301',
u'\u0173\u0301',
u'\u0172\u0303',
u'\u0173\u0303',
u'\u016a\u0301',
u'\u016b\u0301',
u'\u016a\u0303',
u'\u016b\u0303',
u'\xe6\u0300',
u'\u0254\u0300',
u'\u0254\u0301',
u'\u028c\u0300',
u'\u028c\u0301',
u'\u0259\u0300',
u'\u0259\u0301',
u'\u025a\u0300',
u'\u025a\u0301',
u'\u0626\u0627',
u'\u0626\u0648',
u'\u0626\u0649',
u'\u0626\u06c6',
u'\u0626\u06c7',
u'\u0626\u06c8',
u'\u0626\u06d0',
u'\u0626\u06d5',
u'\u0646\u06a9',
u'\u0995\u09cd\u09b7',
u'\u0b95\u0bcd',
u'\u0b99\u0bcd',
u'\u0b9a\u0bcd',
u'\u0b9e\u0bcd',
u'\u0b9f\u0bcd',
u'\u0ba3\u0bcd',
u'\u0ba4\u0bcd',
u'\u0ba8\u0bcd',
u'\u0baa\u0bcd',
u'\u0bae\u0bcd',
u'\u0baf\u0bcd',
u'\u0bb0\u0bcd',
u'\u0bb2\u0bcd',
u'\u0bb5\u0bcd',
u'\u0bb4\u0bcd',
u'\u0bb3\u0bcd',
u'\u0bb1\u0bcd',
u'\u0ba9\u0bcd',
u'\u0b9c\u0bcd',
u'\u0bb6\u0bcd',
u'\u0bb7\u0bcd',
u'\u0bb8\u0bcd',
u'\u0bb9\u0bcd',
u'\u0b95\u0bcd\u0bb7\u0bcd',
u'\u0b95\u0bbe',
u'\u0b95\u0bbf',
u'\u0b95\u0bc0',
u'\u0b95\u0bc1',
u'\u0b95\u0bc2',
u'\u0b95\u0bc6',
u'\u0b95\u0bc7',
u'\u0b95\u0bc8',
u'\u0b95\u0bca',
u'\u0b95\u0bcb',
u'\u0b95\u0bcc',
u'\u0b99\u0bbe',
u'\u0b99\u0bbf',
u'\u0b99\u0bc0',
u'\u0b99\u0bc1',
u'\u0b99\u0bc2',
u'\u0b99\u0bc6',
u'\u0b99\u0bc7',
u'\u0b99\u0bc8',
u'\u0b99\u0bca',
u'\u0b99\u0bcb',
u'\u0b99\u0bcc',
u'\u0b9a\u0bbe',
u'\u0b9a\u0bbf',
u'\u0b9a\u0bc0',
u'\u0b9a\u0bc1',
u'\u0b9a\u0bc2',
u'\u0b9a\u0bc6',
u'\u0b9a\u0bc7',
u'\u0b9a\u0bc8',
u'\u0b9a\u0bca',
u'\u0b9a\u0bcb',
u'\u0b9a\u0bcc',
u'\u0b9e\u0bbe',
u'\u0b9e\u0bbf',
u'\u0b9e\u0bc0',
u'\u0b9e\u0bc1',
u'\u0b9e\u0bc2',
u'\u0b9e\u0bc6',
u'\u0b9e\u0bc7',
u'\u0b9e\u0bc8',
u'\u0b9e\u0bca',
u'\u0b9e\u0bcb',
u'\u0b9e\u0bcc',
u'\u0b9f\u0bbe',
u'\u0b9f\u0bbf',
u'\u0b9f\u0bc0',
u'\u0b9f\u0bc1',
u'\u0b9f\u0bc2',
u'\u0b9f\u0bc6',
u'\u0b9f\u0bc7',
u'\u0b9f\u0bc8',
u'\u0b9f\u0bca',
u'\u0b9f\u0bcb',
u'\u0b9f\u0bcc',
u'\u0ba3\u0bbe',
u'\u0ba3\u0bbf',
u'\u0ba3\u0bc0',
u'\u0ba3\u0bc1',
u'\u0ba3\u0bc2',
u'\u0ba3\u0bc6',
u'\u0ba3\u0bc7',
u'\u0ba3\u0bc8',
u'\u0ba3\u0bca',
u'\u0ba3\u0bcb',
u'\u0ba3\u0bcc',
u'\u0ba4\u0bbe',
u'\u0ba4\u0bbf',
u'\u0ba4\u0bc0',
u'\u0ba4\u0bc1',
u'\u0ba4\u0bc2',
u'\u0ba4\u0bc6',
u'\u0ba4\u0bc7',
u'\u0ba4\u0bc8',
u'\u0ba4\u0bca',
u'\u0ba4\u0bcb',
u'\u0ba4\u0bcc',
u'\u0ba8\u0bbe',
u'\u0ba8\u0bbf',
u'\u0ba8\u0bc0',
u'\u0ba8\u0bc1',
u'\u0ba8\u0bc2',
u'\u0ba8\u0bc6',
u'\u0ba8\u0bc7',
u'\u0ba8\u0bc8',
u'\u0ba8\u0bca',
u'\u0ba8\u0bcb',
u'\u0ba8\u0bcc',
u'\u0baa\u0bbe',
u'\u0baa\u0bbf',
u'\u0baa\u0bc0',
u'\u0baa\u0bc1',
u'\u0baa\u0bc2',
u'\u0baa\u0bc6',
u'\u0baa\u0bc7',
u'\u0baa\u0bc8',
u'\u0baa\u0bca',
u'\u0baa\u0bcb',
u'\u0baa\u0bcc',
u'\u0bae\u0bbe',
u'\u0bae\u0bbf',
u'\u0bae\u0bc0',
u'\u0bae\u0bc1',
u'\u0bae\u0bc2',
u'\u0bae\u0bc6',
u'\u0bae\u0bc7',
u'\u0bae\u0bc8',
u'\u0bae\u0bca',
u'\u0bae\u0bcb',
u'\u0bae\u0bcc',
u'\u0baf\u0bbe',
u'\u0baf\u0bbf',
u'\u0baf\u0bc0',
u'\u0baf\u0bc1',
u'\u0baf\u0bc2',
u'\u0baf\u0bc6',
u'\u0baf\u0bc7',
u'\u0baf\u0bc8',
u'\u0baf\u0bca',
u'\u0baf\u0bcb',
u'\u0baf\u0bcc',
u'\u0bb0\u0bbe',
u'\u0bb0\u0bbf',
u'\u0bb0\u0bc0',
u'\u0bb0\u0bc1',
u'\u0bb0\u0bc2',
u'\u0bb0\u0bc6',
u'\u0bb0\u0bc7',
u'\u0bb0\u0bc8',
u'\u0bb0\u0bca',
u'\u0bb0\u0bcb',
u'\u0bb0\u0bcc',
u'\u0bb2\u0bbe',
u'\u0bb2\u0bbf',
u'\u0bb2\u0bc0',
u'\u0bb2\u0bc1',
u'\u0bb2\u0bc2',
u'\u0bb2\u0bc6',
u'\u0bb2\u0bc7',
u'\u0bb2\u0bc8',
u'\u0bb2\u0bca',
u'\u0bb2\u0bcb',
u'\u0bb2\u0bcc',
u'\u0bb5\u0bbe',
u'\u0bb5\u0bbf',
u'\u0bb5\u0bc0',
u'\u0bb5\u0bc1',
u'\u0bb5\u0bc2',
u'\u0bb5\u0bc6',
u'\u0bb5\u0bc7',
u'\u0bb5\u0bc8',
u'\u0bb5\u0bca',
u'\u0bb5\u0bcb',
u'\u0bb5\u0bcc',
u'\u0bb4\u0bbe',
u'\u0bb4\u0bbf',
u'\u0bb4\u0bc0',
u'\u0bb4\u0bc1',
u'\u0bb4\u0bc2',
u'\u0bb4\u0bc6',
u'\u0bb4\u0bc7',
u'\u0bb4\u0bc8',
u'\u0bb4\u0bca',
u'\u0bb4\u0bcb',
u'\u0bb4\u0bcc',
u'\u0bb3\u0bbe',
u'\u0bb3\u0bbf',
u'\u0bb3\u0bc0',
u'\u0bb3\u0bc1',
u'\u0bb3\u0bc2',
u'\u0bb3\u0bc6',
u'\u0bb3\u0bc7',
u'\u0bb3\u0bc8',
u'\u0bb3\u0bca',
u'\u0bb3\u0bcb',
u'\u0bb3\u0bcc',
u'\u0bb1\u0bbe',
u'\u0bb1\u0bbf',
u'\u0bb1\u0bc0',
u'\u0bb1\u0bc1',
u'\u0bb1\u0bc2',
u'\u0bb1\u0bc6',
u'\u0bb1\u0bc7',
u'\u0bb1\u0bc8',
u'\u0bb1\u0bca',
u'\u0bb1\u0bcb',
u'\u0bb1\u0bcc',
u'\u0ba9\u0bbe',
u'\u0ba9\u0bbf',
u'\u0ba9\u0bc0',
u'\u0ba9\u0bc1',
u'\u0ba9\u0bc2',
u'\u0ba9\u0bc6',
u'\u0ba9\u0bc7',
u'\u0ba9\u0bc8',
u'\u0ba9\u0bca',
u'\u0ba9\u0bcb',
u'\u0ba9\u0bcc',
u'\u0b9c\u0bbe',
u'\u0b9c\u0bbf',
u'\u0b9c\u0bc0',
u'\u0b9c\u0bc1',
u'\u0b9c\u0bc2',
u'\u0b9c\u0bc6',
u'\u0b9c\u0bc7',
u'\u0b9c\u0bc8',
u'\u0b9c\u0bca',
u'\u0b9c\u0bcb',
u'\u0b9c\u0bcc',
u'\u0bb6\u0bbe',
u'\u0bb6\u0bbf',
u'\u0bb6\u0bc0',
u'\u0bb6\u0bc1',
u'\u0bb6\u0bc2',
u'\u0bb6\u0bc6',
u'\u0bb6\u0bc7',
u'\u0bb6\u0bc8',
u'\u0bb6\u0bca',
u'\u0bb6\u0bcb',
u'\u0bb6\u0bcc',
u'\u0bb7\u0bbe',
u'\u0bb7\u0bbf',
u'\u0bb7\u0bc0',
u'\u0bb7\u0bc1',
u'\u0bb7\u0bc2',
u'\u0bb7\u0bc6',
u'\u0bb7\u0bc7',
u'\u0bb7\u0bc8',
u'\u0bb7\u0bca',
u'\u0bb7\u0bcb',
u'\u0bb7\u0bcc',
u'\u0bb8\u0bbe',
u'\u0bb8\u0bbf',
u'\u0bb8\u0bc0',
u'\u0bb8\u0bc1',
u'\u0bb8\u0bc2',
u'\u0bb8\u0bc6',
u'\u0bb8\u0bc7',
u'\u0bb8\u0bc8',
u'\u0bb8\u0bca',
u'\u0bb8\u0bcb',
u'\u0bb8\u0bcc',
u'\u0bb9\u0bbe',
u'\u0bb9\u0bbf',
u'\u0bb9\u0bc0',
u'\u0bb9\u0bc1',
u'\u0bb9\u0bc2',
u'\u0bb9\u0bc6',
u'\u0bb9\u0bc7',
u'\u0bb9\u0bc8',
u'\u0bb9\u0bca',
u'\u0bb9\u0bcb',
u'\u0bb9\u0bcc',
u'\u0b95\u0bcd\u0bb7',
u'\u0b95\u0bcd\u0bb7\u0bbe',
u'\u0b95\u0bcd\u0bb7\u0bbf',
u'\u0b95\u0bcd\u0bb7\u0bc0',
u'\u0b95\u0bcd\u0bb7\u0bc1',
u'\u0b95\u0bcd\u0bb7\u0bc2',
u'\u0b95\u0bcd\u0bb7\u0bc6',
u'\u0b95\u0bcd\u0bb7\u0bc7',
u'\u0b95\u0bcd\u0bb7\u0bc8',
u'\u0b95\u0bcd\u0bb7\u0bca',
u'\u0b95\u0bcd\u0bb7\u0bcb',
u'\u0b95\u0bcd\u0bb7\u0bcc',
u'\u0bb6\u0bcd\u0bb0\u0bc0',
u'\u0dca\u200d\u0dba',
u'\u0dca\u200d\u0dbb',
u'\u0dbb\u0dca\u200d',
u'\u10e3\u0302',
u'\u17d2\u1780',
u'\u17d2\u1781',
u'\u17d2\u1782',
u'\u17d2\u1783',
u'\u17d2\u1784',
u'\u17d2\u1785',
u'\u17d2\u1786',
u'\u17d2\u1787',
u'\u17d2\u1788',
u'\u17d2\u1789',
u'\u17d2\u178a',
u'\u17d2\u178b',
u'\u17d2\u178c',
u'\u17d2\u178d',
u'\u17d2\u178e',
u'\u17d2\u178f',
u'\u17d2\u1790',
u'\u17d2\u1791',
u'\u17d2\u1792',
u'\u17d2\u1793',
u'\u17d2\u1794',
u'\u17d2\u1795',
u'\u17d2\u1796',
u'\u17d2\u1797',
u'\u17d2\u1798',
u'\u17d2\u1799',
u'\u17d2\u179a',
u'\u17d2\u179b',
u'\u17d2\u179c',
u'\u17d2\u179d',
u'\u17d2\u179e',
u'\u17d2\u179f',
u'\u17d2\u17a0',
u'\u17d2\u17a1',
u'\u17d2\u17a2',
u'\u17d2\u17a7',
u'\u17d2\u17ab',
u'\u17d2\u17ac',
u'\u17d2\u17af',
u'\u17bb\u17c6',
u'\u17b6\u17c6',
u'\u304b\u309a',
u'\u304d\u309a',
u'\u304f\u309a',
u'\u3051\u309a',
u'\u3053\u309a',
u'\u30ab\u309a',
u'\u30ad\u309a',
u'\u30af\u309a',
u'\u30b1\u309a',
u'\u30b3\u309a',
u'\u30bb\u309a',
u'\u30c4\u309a',
u'\u30c8\u309a',
u'\u31f7\u309a',
u'\u02e5\u02e9',
u'\u02e9\u02e5',
]


def lookup_named_sequence(code):
    if 0 <= code - 983552 < len(_named_sequences):
        return _named_sequences[code - 983552]
    else:
        return None

_name_aliases = [
0,
0,
1,
1,
2,
2,
3,
3,
4,
4,
5,
5,
6,
6,
7,
7,
8,
8,
9,
9,
9,
9,
10,
10,
10,
10,
10,
10,
11,
11,
11,
12,
12,
13,
13,
14,
14,
14,
15,
15,
15,
16,
16,
17,
17,
18,
18,
19,
19,
20,
20,
21,
21,
22,
22,
23,
23,
24,
24,
25,
25,
26,
26,
27,
27,
28,
28,
28,
29,
29,
29,
30,
30,
30,
31,
31,
31,
32,
127,
127,
128,
128,
129,
129,
130,
130,
131,
131,
132,
132,
133,
133,
134,
134,
135,
135,
136,
136,
136,
137,
137,
137,
138,
138,
138,
139,
139,
139,
140,
140,
140,
141,
141,
141,
142,
142,
142,
143,
143,
143,
144,
144,
145,
145,
145,
146,
146,
146,
147,
147,
148,
148,
149,
149,
150,
150,
150,
151,
151,
151,
152,
152,
153,
153,
154,
154,
155,
155,
156,
156,
157,
157,
158,
158,
159,
159,
160,
173,
418,
419,
847,
1564,
1801,
3294,
3741,
3743,
3747,
3749,
4048,
6155,
6156,
6157,
6158,
8203,
8204,
8205,
8206,
8207,
8234,
8235,
8236,
8237,
8238,
8239,
8287,
8288,
8294,
8295,
8296,
8297,
8472,
9288,
9289,
11130,
11132,
40981,
65048,
65024,
65025,
65026,
65027,
65028,
65029,
65030,
65031,
65032,
65033,
65034,
65035,
65036,
65037,
65038,
65039,
65279,
65279,
65279,
74452,
74453,
118981,
917760,
917761,
917762,
917763,
917764,
917765,
917766,
917767,
917768,
917769,
917770,
917771,
917772,
917773,
917774,
917775,
917776,
917777,
917778,
917779,
917780,
917781,
917782,
917783,
917784,
917785,
917786,
917787,
917788,
917789,
917790,
917791,
917792,
917793,
917794,
917795,
917796,
917797,
917798,
917799,
917800,
917801,
917802,
917803,
917804,
917805,
917806,
917807,
917808,
917809,
917810,
917811,
917812,
917813,
917814,
917815,
917816,
917817,
917818,
917819,
917820,
917821,
917822,
917823,
917824,
917825,
917826,
917827,
917828,
917829,
917830,
917831,
917832,
917833,
917834,
917835,
917836,
917837,
917838,
917839,
917840,
917841,
917842,
917843,
917844,
917845,
917846,
917847,
917848,
917849,
917850,
917851,
917852,
917853,
917854,
917855,
917856,
917857,
917858,
917859,
917860,
917861,
917862,
917863,
917864,
917865,
917866,
917867,
917868,
917869,
917870,
917871,
917872,
917873,
917874,
917875,
917876,
917877,
917878,
917879,
917880,
917881,
917882,
917883,
917884,
917885,
917886,
917887,
917888,
917889,
917890,
917891,
917892,
917893,
917894,
917895,
917896,
917897,
917898,
917899,
917900,
917901,
917902,
917903,
917904,
917905,
917906,
917907,
917908,
917909,
917910,
917911,
917912,
917913,
917914,
917915,
917916,
917917,
917918,
917919,
917920,
917921,
917922,
917923,
917924,
917925,
917926,
917927,
917928,
917929,
917930,
917931,
917932,
917933,
917934,
917935,
917936,
917937,
917938,
917939,
917940,
917941,
917942,
917943,
917944,
917945,
917946,
917947,
917948,
917949,
917950,
917951,
917952,
917953,
917954,
917955,
917956,
917957,
917958,
917959,
917960,
917961,
917962,
917963,
917964,
917965,
917966,
917967,
917968,
917969,
917970,
917971,
917972,
917973,
917974,
917975,
917976,
917977,
917978,
917979,
917980,
917981,
917982,
917983,
917984,
917985,
917986,
917987,
917988,
917989,
917990,
917991,
917992,
917993,
917994,
917995,
917996,
917997,
917998,
917999,
]


def lookup_with_alias(name, with_named_sequence=False):
    code = lookup(name, with_named_sequence=with_named_sequence)
    if 0 <= code - 983040 < len(_name_aliases):
        return _name_aliases[code - 983040]
    else:
        return code

_casefolds = {
5024: [5024],
5025: [5025],
5026: [5026],
5027: [5027],
5028: [5028],
5029: [5029],
5030: [5030],
5031: [5031],
5032: [5032],
5033: [5033],
5034: [5034],
5035: [5035],
5036: [5036],
5037: [5037],
5038: [5038],
5039: [5039],
5040: [5040],
5041: [5041],
5042: [5042],
5043: [5043],
5044: [5044],
5045: [5045],
5046: [5046],
5047: [5047],
5048: [5048],
5049: [5049],
5050: [5050],
5051: [5051],
5052: [5052],
5053: [5053],
5054: [5054],
5055: [5055],
5056: [5056],
5057: [5057],
5058: [5058],
5059: [5059],
5060: [5060],
5061: [5061],
5062: [5062],
5063: [5063],
5064: [5064],
5065: [5065],
5066: [5066],
5067: [5067],
5068: [5068],
5069: [5069],
5070: [5070],
5071: [5071],
5072: [5072],
5073: [5073],
5074: [5074],
5075: [5075],
5076: [5076],
5077: [5077],
5078: [5078],
5079: [5079],
5080: [5080],
5081: [5081],
5082: [5082],
5083: [5083],
5084: [5084],
5085: [5085],
5086: [5086],
5087: [5087],
5088: [5088],
5089: [5089],
5090: [5090],
5091: [5091],
5092: [5092],
5093: [5093],
5094: [5094],
5095: [5095],
5096: [5096],
5097: [5097],
5098: [5098],
5099: [5099],
5100: [5100],
5101: [5101],
5102: [5102],
5103: [5103],
5104: [5104],
5105: [5105],
5106: [5106],
5107: [5107],
5108: [5108],
5109: [5109],
5112: [5104],
5113: [5105],
5114: [5106],
5115: [5107],
5116: [5108],
5117: [5109],
43888: [5024],
43889: [5025],
43890: [5026],
43891: [5027],
43892: [5028],
43893: [5029],
43894: [5030],
43895: [5031],
43896: [5032],
43897: [5033],
43898: [5034],
43899: [5035],
43900: [5036],
43901: [5037],
43902: [5038],
43903: [5039],
43904: [5040],
43905: [5041],
43906: [5042],
43907: [5043],
43908: [5044],
43909: [5045],
43910: [5046],
43911: [5047],
43912: [5048],
43913: [5049],
43914: [5050],
43915: [5051],
43916: [5052],
43917: [5053],
43918: [5054],
43919: [5055],
43920: [5056],
43921: [5057],
43922: [5058],
43923: [5059],
43924: [5060],
43925: [5061],
43926: [5062],
43927: [5063],
43928: [5064],
43929: [5065],
43930: [5066],
43931: [5067],
43932: [5068],
43933: [5069],
43934: [5070],
43935: [5071],
43936: [5072],
43937: [5073],
43938: [5074],
43939: [5075],
43940: [5076],
43941: [5077],
43942: [5078],
43943: [5079],
43944: [5080],
43945: [5081],
43946: [5082],
43947: [5083],
43948: [5084],
43949: [5085],
43950: [5086],
43951: [5087],
43952: [5088],
43953: [5089],
43954: [5090],
43955: [5091],
43956: [5092],
43957: [5093],
43958: [5094],
43959: [5095],
43960: [5096],
43961: [5097],
43962: [5098],
43963: [5099],
43964: [5100],
43965: [5101],
43966: [5102],
43967: [5103],
}

_casefolds_corrected = {
}


def casefold_lookup(code):
    try:
        return _casefolds[code]
    except KeyError:
        if base_mod is not None and code not in _casefolds_corrected:
            return base_mod._casefolds.get(code, None)
        else:
            return None

_combining = {
1631: 220,
2137: 220,
2138: 220,
2139: 220,
2275: 220,
2276: 230,
2277: 230,
2278: 220,
2279: 230,
2280: 230,
2281: 220,
2282: 230,
2283: 230,
2284: 230,
2285: 220,
2286: 220,
2287: 220,
2288: 27,
2289: 28,
2290: 29,
2291: 230,
2292: 230,
2293: 230,
2294: 220,
2295: 230,
2296: 230,
2297: 220,
2298: 220,
2299: 230,
2300: 230,
2301: 230,
2302: 230,
2303: 230,
4957: 230,
4958: 230,
6832: 230,
6833: 230,
6834: 230,
6835: 230,
6836: 230,
6837: 220,
6838: 220,
6839: 220,
6840: 220,
6841: 220,
6842: 220,
6843: 230,
6844: 230,
6845: 220,
7083: 9,
7142: 7,
7154: 9,
7155: 9,
7412: 230,
7416: 230,
7417: 230,
7655: 230,
7656: 230,
7657: 230,
7658: 230,
7659: 230,
7660: 230,
7661: 230,
7662: 230,
7663: 230,
7664: 230,
7665: 230,
7666: 230,
7667: 230,
7668: 230,
7669: 230,
7676: 233,
11647: 9,
42612: 230,
42613: 230,
42614: 230,
42615: 230,
42616: 230,
42617: 230,
42618: 230,
42619: 230,
42654: 230,
42655: 230,
43766: 9,
65063: 220,
65064: 220,
65065: 220,
65066: 220,
65067: 220,
65068: 220,
65069: 220,
65070: 230,
65071: 230,
66272: 220,
66422: 230,
66423: 230,
66424: 230,
66425: 230,
66426: 230,
68325: 230,
68326: 220,
69702: 9,
69759: 9,
69888: 230,
69889: 230,
69890: 230,
69939: 9,
69940: 9,
70003: 7,
70080: 9,
70090: 7,
70197: 9,
70198: 7,
70377: 7,
70378: 9,
70460: 7,
70477: 9,
70502: 230,
70503: 230,
70504: 230,
70505: 230,
70506: 230,
70507: 230,
70508: 230,
70512: 230,
70513: 230,
70514: 230,
70515: 230,
70516: 230,
70850: 9,
70851: 7,
71103: 9,
71104: 7,
71231: 9,
71350: 9,
71351: 7,
71467: 9,
92912: 1,
92913: 1,
92914: 1,
92915: 1,
92916: 1,
92976: 230,
92977: 230,
92978: 230,
92979: 230,
92980: 230,
92981: 230,
92982: 230,
113822: 1,
125136: 220,
125137: 220,
125138: 220,
125139: 220,
125140: 220,
125141: 220,
125142: 220,
}

_combining_corrected = {
}


def combining(code):
    try:
        return _combining[code]
    except KeyError:
        if base_mod is not None and code not in _combining_corrected:
            return base_mod._combining.get(code, 0)
        else:
            return 0

