'''OpenGL extension AMD.gpu_shader_int16

This module customises the behaviour of the 
OpenGL.raw.GL.AMD.gpu_shader_int16 to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension was developed to allow implementations supporting 16-bit
	integers to expose the feature in GLSL.
	
	The extension introduces the following features for all shader types:
	
	  * new built-in functions to pack and unpack 32-bit integer types into a
	    two-component 16-bit integer vector;
	
	  * new built-in functions to convert half-precision floating-point
	    values to or from their 16-bit integer bit encodings;
	
	  * vector relational functions supporting comparisons of vectors of
	    16-bit integer types; and
	
	  * common functions abs, frexp, ldexp, sign, min, max, clamp, and mix
	    supporting arguments of 16-bit integer types.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/AMD/gpu_shader_int16.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.AMD.gpu_shader_int16 import *
from OpenGL.raw.GL.AMD.gpu_shader_int16 import _EXTENSION_NAME

def glInitGpuShaderInt16AMD():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION