OpenRC Coding Style Guide
=========================

This is the openrc style manual.  It governs the coding style of all code
in this repository.  Follow it.  Contact openrc@gentoo.org for any questions
or fixes you might notice.

## C CODE

The BSD Kernel Normal Form (KNF) style is used [1]. Basically, it is like
K&R/LKML, but wrapped lines that are indented use 4 spaces. Here are the
highlights.

- no trailing whitespace
- indented code use tabs (not line wrapped)
- cuddle the braces (except for functions)
- space after native statements and before paren (for/if/while/...)
- no space between function and paren
- pointer asterisk cuddles the variable, not the type

```
void foo(int c)
{
	int ret = 0;

	if (c > 1000)
		return;

	while (c--) {
		bar(c);
		ret++;
	}

	return ret;
}
```

## COMMIT MESSAGES

The following is an example of a correctly formatted git commit message
for this repository. Most of this information came from this blog post
[2], so I would like to thank the author.

```
Capitalized, short (50 chars or less) summary

More detailed explanatory text, if necessary.  Wrap it to about 72
characters or so.  In some contexts, the first line is treated as the
subject of an email and the rest of the text as the body.  The blank
line separating the summary from the body is critical (unless you omit
the body entirely); tools like rebase can get confused if you run the
two together.

Write your commit message in the imperative: "Fix bug" and not "Fixed
bug."  This convention matches up with commit messages generated by
commands like git merge and git revert.

Further paragraphs come after blank lines.

- Bullet points are okay, too

- Typically a hyphen or asterisk is used for the bullet, preceded by a
  single space, with blank lines in between, but conventions vary here

- Use a hanging indent

Reported-by: User Name <email>
X-[Distro]-Bug: BugID
X-[Distro]-Bug-URL: URL for the bug (on the distribution's web site typically)
```

If you did not write the code and the patch does not include authorship
information in a format git can use, please use the --author option of the
git commit command to make the authorship correct.

The Reported-by tag is required if the person who reported the bug is
different from the author and committer.

  The X-[Distro]-Bug/Bug-URL tags are required if this commit is related
  to a bug reported to us by a specific distribution   of linux or a
  *BSD. Also, [Distro] should be replaced with the name of the
  distribution, e.g. X-Gentoo-Bug.

[1]	http://en.wikipedia.org/wiki/Indent_style#BSD_KNF_style
[2] http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html
