/*
 * Copyright (c) 2003, 2004, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package sun.management.snmp.jvmmib;

//
// Generated by mibgen version 5.0 (06/02/03) when compiling JVM-MANAGEMENT-MIB in standard metadata mode.
//


// jmx imports
//
import com.sun.jmx.snmp.SnmpStatusException;

/**
 * This interface is used for representing the remote management interface for the "JvmThreading" MBean.
 */
public interface JvmThreadingMBean {

    /**
     * Getter for the "JvmThreadCpuTimeMonitoring" variable.
     */
    public EnumJvmThreadCpuTimeMonitoring getJvmThreadCpuTimeMonitoring() throws SnmpStatusException;

    /**
     * Setter for the "JvmThreadCpuTimeMonitoring" variable.
     */
    public void setJvmThreadCpuTimeMonitoring(EnumJvmThreadCpuTimeMonitoring x) throws SnmpStatusException;

    /**
     * Checker for the "JvmThreadCpuTimeMonitoring" variable.
     */
    public void checkJvmThreadCpuTimeMonitoring(EnumJvmThreadCpuTimeMonitoring x) throws SnmpStatusException;

    /**
     * Getter for the "JvmThreadContentionMonitoring" variable.
     */
    public EnumJvmThreadContentionMonitoring getJvmThreadContentionMonitoring() throws SnmpStatusException;

    /**
     * Setter for the "JvmThreadContentionMonitoring" variable.
     */
    public void setJvmThreadContentionMonitoring(EnumJvmThreadContentionMonitoring x) throws SnmpStatusException;

    /**
     * Checker for the "JvmThreadContentionMonitoring" variable.
     */
    public void checkJvmThreadContentionMonitoring(EnumJvmThreadContentionMonitoring x) throws SnmpStatusException;

    /**
     * Getter for the "JvmThreadTotalStartedCount" variable.
     */
    public Long getJvmThreadTotalStartedCount() throws SnmpStatusException;

    /**
     * Getter for the "JvmThreadPeakCount" variable.
     */
    public Long getJvmThreadPeakCount() throws SnmpStatusException;

    /**
     * Getter for the "JvmThreadDaemonCount" variable.
     */
    public Long getJvmThreadDaemonCount() throws SnmpStatusException;

    /**
     * Getter for the "JvmThreadCount" variable.
     */
    public Long getJvmThreadCount() throws SnmpStatusException;

    /**
     * Getter for the "JvmThreadPeakCountReset" variable.
     */
    public Long getJvmThreadPeakCountReset() throws SnmpStatusException;

    /**
     * Setter for the "JvmThreadPeakCountReset" variable.
     */
    public void setJvmThreadPeakCountReset(Long x) throws SnmpStatusException;

    /**
     * Checker for the "JvmThreadPeakCountReset" variable.
     */
    public void checkJvmThreadPeakCountReset(Long x) throws SnmpStatusException;

}
