suite 'Validate Input Chars:', ->

  test 'Invalid chars in XML 1.0', ->
    err () -> xml('test').txt('invalid char \u{0000}')
    err () -> xml('test').txt('invalid char \u{0001}')
    err () -> xml('test').txt('invalid char \u{0002}')
    err () -> xml('test').txt('invalid char \u{0003}')
    err () -> xml('test').txt('invalid char \u{0004}')
    err () -> xml('test').txt('invalid char \u{0005}')
    err () -> xml('test').txt('invalid char \u{0006}')
    err () -> xml('test').txt('invalid char \u{0007}')
    err () -> xml('test').txt('invalid char \u{0008}')
    err () -> xml('test').txt('invalid char \u{000B}')
    err () -> xml('test').txt('invalid char \u{000C}')
    err () -> xml('test').txt('invalid char \u{000E}')
    err () -> xml('test').txt('invalid char \u{000F}')
    err () -> xml('test').txt('invalid char \u{0010}')
    err () -> xml('test').txt('invalid char \u{0011}')
    err () -> xml('test').txt('invalid char \u{0012}')
    err () -> xml('test').txt('invalid char \u{0013}')
    err () -> xml('test').txt('invalid char \u{0014}')
    err () -> xml('test').txt('invalid char \u{0015}')
    err () -> xml('test').txt('invalid char \u{0016}')
    err () -> xml('test').txt('invalid char \u{0017}')
    err () -> xml('test').txt('invalid char \u{0018}')
    err () -> xml('test').txt('invalid char \u{001A}')
    err () -> xml('test').txt('invalid char \u{001B}')
    err () -> xml('test').txt('invalid char \u{001C}')
    err () -> xml('test').txt('invalid char \u{001D}')
    err () -> xml('test').txt('invalid char \u{001E}')
    err () -> xml('test').txt('invalid char \u{001F}')
    err () -> xml('test').txt('invalid char \u{D800}')
    err () -> xml('test').txt('invalid char \u{DFFF}')
    err () -> xml('test').txt('invalid char \u{FFFE}')
    err () -> xml('test').txt('invalid char \u{FFFF}')
    
  test 'Invalid chars in XML 1.1', ->
    err () -> xml('test', { version: '1.1' }).txt('invalid char \u{0000}')
    err () -> xml('test', { version: '1.1' }).txt('invalid char \u{D800}')
    err () -> xml('test', { version: '1.1' }).txt('invalid char \u{DFFF}')
    err () -> xml('test', { version: '1.1' }).txt('invalid char \u{FFFE}')
    err () -> xml('test', { version: '1.1' }).txt('invalid char \u{FFFF}')
    eq(
      xml('root', { headless: true, version: '1.1' }).txt('char_\u{0008}_valid_in_XML_1.1').end()
      '<root>char_\u{0008}_valid_in_XML_1.1</root>'
    )

  test 'Invalid names', ->
    err () -> xml('.test')
    err () -> xml('_?test')