/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.util;

import de.erichseifert.vectorgraphics2d.util.DataUtils;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;

public class FormattingWriter
implements Closeable,
Flushable {
    private final OutputStream out;
    private final String encoding;
    private final String eolString;
    private long position;

    public FormattingWriter(OutputStream outputStream, String string, String string2) {
        this.out = outputStream;
        this.encoding = string;
        this.eolString = string2;
    }

    public FormattingWriter write(String string) throws IOException {
        byte[] byArray = string.getBytes(this.encoding);
        this.out.write(byArray, 0, byArray.length);
        this.position += (long)byArray.length;
        return this;
    }

    public FormattingWriter write(Number number) throws IOException {
        this.write(DataUtils.format(number));
        return this;
    }

    public FormattingWriter writeln() throws IOException {
        this.write(this.eolString);
        return this;
    }

    public FormattingWriter writeln(String string) throws IOException {
        this.write(string);
        this.write(this.eolString);
        return this;
    }

    public FormattingWriter writeln(Number number) throws IOException {
        this.write(number);
        this.write(this.eolString);
        return this;
    }

    public FormattingWriter format(String string, Object ... objectArray) throws IOException {
        this.write(String.format(null, string, objectArray));
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public long tell() {
        return this.position;
    }
}

