function(get_fq_target_name local_name target_name_var)
  file(RELATIVE_PATH rel_path ${LIBC_SOURCE_DIR} ${CMAKE_CURRENT_SOURCE_DIR})
  string(REPLACE "/" "." fq_name "libc.${rel_path}.${local_name}")
  set(${target_name_var} ${fq_name} PARENT_SCOPE)
endfunction(get_fq_target_name)

function(is_relative_target_name target_name output_var)
  string(FIND ${target_name} "." dot_loc)
  string(COMPARE EQUAL "0" ${dot_loc} is_relative)
  set(${output_var} ${is_relative} PARENT_SCOPE)
endfunction(is_relative_target_name)

function(get_fq_dep_name fq_name name)
  is_relative_target_name(${name} "is_relative")
  if(is_relative)
    # Skip over the first '.' character.
    string(SUBSTRING ${name} 1 -1 local_name)
    get_fq_target_name(${local_name} fully_qualified_name)
    set(${fq_name} ${fully_qualified_name} PARENT_SCOPE)
  else()
    set(${fq_name} ${name} PARENT_SCOPE)
  endif()
endfunction(get_fq_dep_name)

function(get_fq_deps_list output_list)
  set(fq_dep_name_list "")
  foreach(dep IN LISTS ARGN)
    get_fq_dep_name(fq_dep_name ${dep})
    list(APPEND fq_dep_name_list ${fq_dep_name})
  endforeach(dep)
  set(${output_list} ${fq_dep_name_list} PARENT_SCOPE)
endfunction(get_fq_deps_list)
