ITK Release 4.8
===============

New Features

------------------------------------------------------------------------

-   Wrapping improvements

`- Wrapping now uses CastXML instead of GCCXML`\
`- The latest GCC, Clang, and MSVC are fully supported`\
` - Details: `[`http://kitware.com/blog/home/post/888`](http://kitware.com/blog/home/post/888)\
`- Cross-compilation and packaging support`\
` - Details: `[`http://kitware.com/blog/home/post/904`](http://kitware.com/blog/home/post/904)\
`- ITK_WRAP_VECTOR_COMPONENTS option to specify number of wrapped vector components`\
`- More classes wrapped`

-   Compiler Support

`- GCC 5.1`\
`- Clang 3.6.0`\
`- Better cross-compilation support (requires CMake 3.3)`\
`- Experimental support for Emscripten (JavaScript)`\
`  - Details: `[`http://kitware.com/blog/home/post/912`](http://kitware.com/blog/home/post/912)\
`- Experimental support for the Raspberry Pi`\
`  - Details: `[`http://kitware.com/blog/home/post/887`](http://kitware.com/blog/home/post/887)\
`- Experimental support for Android`\
`  - Details: `[`http://kitware.com/blog/home/post/893`](http://kitware.com/blog/home/post/893)\
`- Experimental support for MXE/MinGW-w64`\
`  - Details: `[`http://kitware.com/blog/home/post/883`](http://kitware.com/blog/home/post/883)\
`- Experimental support for the POWER8`\
`  - Details: `[`http://kitware.com/blog/home/post/891`](http://kitware.com/blog/home/post/891)

-   New Remote Modules

`- MinimalPathExtraction`\
`  - Insight Journal Article: `[`http://hdl.handle.net/1926/1332`](http://hdl.handle.net/1926/1332)\
`- BridgeNumPy`\
`  - Convert itk.Image to NumPy array’s and back`\
`- LabelErodeDilate`\
`  - Insight Journal Article: `[`http://hdl.handle.net/10380/3399`](http://hdl.handle.net/10380/3399)\
`- ParabolicMorphology`\
`  - Insight Journal Article: `[`http://hdl.handle.net/1926/1370`](http://hdl.handle.net/1926/1370)

-   Infrastructure Improvements

`- An UpdateThirdPartyFromUpstream.sh script for 3rd party updates with Git subtree`\
`  - Details: `[`http://kitware.com/blog/home/post/899`](http://kitware.com/blog/home/post/899)\
`- Minimum required CMake version is now 2.8.9 `\
`- Many more modules can be built as shared libraries`\
`- ITK_USE_SYSTEM_LIBRARIES variable during initial configuration to turn on use of common system third party libraries by default`\
`- Release testing data tarball split from source tarball`\
`- Gold linker used by default on Linux`

-   Filtering Improvements

`- itk::FFTPadImageFilter to automatically pad images for the FFT implementation’s supported greatest prime factor`\
`- itk::AtomicInt class for parallel computation`\
`- Various performance enhancements`

-   Registration Improvements

`- Point set SyN registration`\
`- Point set BSpline SyN registration`

-   Documentation Improvements

`- The ITK Software Guide is now available in HTML`\
`  - Details: `[`http://kitware.com/blog/home/post/890`](http://kitware.com/blog/home/post/890)\
`- Updates to the Software Guide, Doxygen, Wiki and Sphinx Examples`

-   Third Party Library Updates

`- GDCM updated to latest upstream`\
`- KWSys updated to the latest upstream`\
`- MetaIO updated to the latest upstream`\
`- MINC updated to the latest upstream`

-   Style improvements -- ITK gets more stylish with every release!

<!-- -->

-   Improved code coverage -- we are at 85.4%!

<!-- -->

-   -   Lots\* of important bug fixes

Changes from v4.8rc03..v4.8.0

------------------------------------------------------------------------

Davis Vigneault (1):

`     COMP: C++11 Warnings in thirdparty PNG module.`

Matthew McCormick (9):

`     COMP: Fix unused parameter warnings in itkMultiThreaderNoThreads.`\
`     BUG: Do not output CMake log files in itkSystemInformationTest.`\
`     COMP: Work around segfaults with VS12 in RegionOfInterestImageFilter.`\
`     DOC: Update Wiki Examples Remote to June 26, 2015.`\
`     COMP: Update ParabolicMorphology to address doxygen warning.`\
`     COMP: Add missing exports in the ITKFEM module.`\
`     BUG: Use CMAKE_LIBRARY_OUTPUT_DIRECTORY for build tree WrapITK.pth.`\
`     DOC: Document grafting the input image in composite filters.`\
`     DOC: Bump SphinxExample remote module version to 2015-07-02.`

Changes from v4.8rc02..v4.8rc03

------------------------------------------------------------------------

Bradley Lowekamp (3):

`     BUG: Remove reliance on exceptions in StringTools::ToData methods`\
`     BUG: Fix WriteCellsAsBinary and valgrind defects`\
`     COMP: Explicitly export SingleValuedNonLinearVnlOptimizerv4`

Matthew McCormick (4):

`     COMP: Address may be used uninitialized in IdentityTransformTest.`\
`     COMP: Address array subscript above bounds in VTKPolyDataReader.`\
`     COMP: Work around GDCM test segfault with Clang 3.5+.`\
`     BUG: Do not use pthreads with Emscripten.`

Michka Popoff (1):

`     ENH: Update PyInit for Python 3`

Changes from v4.8rc01..v4.8rc02

------------------------------------------------------------------------

Arnaud Gelas (2):

`     BUG: memory leaks when calling itk::Mesh::Graft`\
`     BUG: fix memory leaks in BorderQuadEdgeMeshFilter using itk::AutoPointer`

Bradley Lowekamp (1):

`     Revert selection `“`ENH:`` ``Add`` ``shared`` ``libraries`` ``for`` ``ITK`` ``libraries`”

Davis Vigneault (1):

`     STYLE: Minor typographical changes in ParameterizationQuadEdgeMeshFilter`

Dženan Zukić (1):

`     DOC: Improve docs for ConnectedComponentImageFilter`

Hans Johnson (1):

`     STYLE: Use consistent names in template parameters`

Sean McBride (2):

`     COMP: Update MINC to upstream 85145dca36`\
`     BUG: updated MINC to a77da29`

Changes from v4.7.0..v4.8rc01

------------------------------------------------------------------------

Alexander Hewer (1):

`     COMP: fixed error `“`Dunno`` ``about`` ``this`` ``gcc`”` for gcc 5.1`

Arnaud Gelas (14):

`     ENH: add MinimalPathExtraction as a remote module`\
`     ENH: fix KWStyle errors for SubdivisionQuadEdgeMesh`\
`     COMP: fix warning with non default template parameter for OutputImage`\
`     COMP: missing ';' in itkSetClampMacro`\
`     STYLE: no need to expose internal type`\
`     COMP: fix warning with non default template parameter for OutputImage`\
`     COMP: fix warning with non default template parameter for OutputImage`\
`     BUG: fix BinaryImageToLabelMapFilter with negative OutputBackgroundValue`\
`     DOC: add explanations about input and out filters`\
`     COMP: missing include in IterativeTriangleCellSubdivision`\
`     DOC: Improve documentation for ParameterizationQuadEdgeMeshFilter`\
`     BUG: not all combinations were actually test`\
`     ENH: add an exception in BorderQuadEdgeMeshFilter if no boundaries`\
`     COMP: fix CMake warning in ITKModuleHeaderTest`

Bill Lorensen (7):

`     ENH: Update to KWStyle conformant version`\
`     ENH: Add interpolate capability`\
`     ENH: WikiExamples QuickView Update`\
`     COMP: VTK AUTOINIT redefinition warnings`\
`     COMP: Only require the minimal VTK modules`\
`     COMP: Compiler hidden visibility on Mac compiler`\
`     COMP: EventMacro backward compatibility`

Brad King (25):

`     COMP: Fix variable reference in ITKVtkGlue module files`\
`     ENH: ExternalData: Allow local stores without any URL templates`\
`     ENH: ExternalData: Warn on missing file instead of failing`\
`     ENH: ExternalData: Add support for custom download scripts`\
`     ENH: ExternalData: Add support for custom algorithm-to-URL mapping`\
`     DOC: ExternalData: Update documentation to match CMake copy`\
`     ENH: Teach UpdateThirdPartyFromUpstream to support spaces in path`\
`     ENH: Improve UpdateThirdPartyFromUpstream for initial imports`\
`     ENH: Require CMake 2.8.9 or greater`\
`     ENH: Do not produce ITKGDCM library when using system GDCM`\
`     ENH: Drop gdcm source subtree to prepare for fresh import`\
`     ENH: Add script to update GDCM from upstream`\
`     STYLE: Tell Git not to check whitespace in GDCM`\
`     STYLE: Tell Git about larger files in GDCM`\
`     COMP: Configure GDCM to build inside ITK`\
`     COMP: Fix GDCM to handle older expat library`\
`     COMP: Cleanup CMP0022 warnings in GDCM module`\
`     COMP: Add missing include in GDCM source`\
`     COMP: Teach GDCM to honor ITK_DYNAMIC_LOADING option`\
`     ENH: KWSys: Tell Git not to export .gitattributes`\
`     COMP: Remove cmake_minimum_required calls from GDCM`\
`     COMP: Remove extra CMake policy settings in GDCM`\
`     COMP: Use more standard SSE intrinsics in GDCM copy of OpenJPEG`\
`     COMP: Fix GDCM std::accumulate initial value type`\
`     ENH: Update version of CastXML built for wrapper generation`

Bradley Lowekamp (48):

`     PERF: Use ImageAlgorithm::Copy in ImageSeriesWriter`\
`     BUG: Enable setting all zeroes for fixed parameters for displacement`\
`     ENH: Refactor versor to matrix transform code`\
`     DOC: Clarify that Scale Skew Versor does addition`\
`     COMP: Fix unsafe usage of sprintf`\
`     BUG: Correct Simularity3D Jacobian`\
`     BUG: Ensure OptimizerParameters doesn't leak its helper`\
`     BUG: Fix incorrectly ordering of template parameters`\
`     COMP: check for search.h in libtiff`\
`     BUG: restore the center point fixed parameters for scale transforms`\
`     PERF: Remove frequent dynamic allocations used with std::vector`\
`     COMP: Use _timezone for Visual Studio`\
`     BUG: Restore IO support for BSplineDeformableTransform`\
`     BUG: Enable VectorImage to work with the ImageSeriesWriter`\
`     BUG: Replace std::cout message Warning marco`\
`     BUG: Correct ExtractImageFilters Type macro`\
`     DOC: Separately document IsNull and IsNotNull`\
`     ENH: Modularize KWStyleTests`\
`     BUG: Remove ExhaustiveOptimizer ivar which was unused`\
`     STYLE: Update IOFDF to address KWStyle issues`\
`     BUG: Fix undefined signed integer shift`\
`     BUG: Fix IOFDFInDoxygenGroup test`\
`     BUG: Update MGHImageIO for header guarder style`\
`     BUG: Fix itkFDFImageIOTest link error on windows`\
`     STYLE: Update SCIFIO for KWStyke failures`\
`     BUG: Move LBFGSB callback helper to parent`\
`     BUG: Use base's NumberOfIterations for stopping condition`\
`     BUG: Update AmoebaOptimizer NumberOfIterations`\
`     BUG: Use base's NumberOfIterations for stopping condition`\
`     PERF: Report progress for linear transform only at scanline completion`\
`     BUG: Correct convergence string check`\
`     BUG: Avoid underflow in gradient range calculation`\
`     ENH: Use return by value for ImageAlgorithm::EnlargeRegionOverBox`\
`     BUG: No exception for 0 parameter transforms`\
`     COMP: Address conversion compilation warning`\
`     ENH: Use PrinSelfObjectMacro`\
`     BUG: Use module's libraries for linking header test.`\
`     ENH: Add export specifications to FFT library`\
`     COMP: Address conversion compilation warning`\
`     COMP: This patch address linking errors with WrapITK`\
`     DOC: Improving documentation for the names inputs of the ProcessObject`\
`     BUG: Isolate CannyEdgeDetection's internal filter from external`\
`     PERF: Refactor ExpandImageFilter loop`\
`     ENH: Add AtmoicInt class, use TimeStamp & LightObject`\
`     COMP: Address signed to unsigned comparison warning in AtomicInt Test`\
`     ENH: Move IsPrime and GreatestPrimeFactor to compiled cxx file`\
`     COMP: Add export missing export specifications`\
`     BUG: Fix reading HDF5 images into different dimension.`

Brian Helba (2):

`     ENH: Add scripts for automated updating of ThirdParty libraries`\
`     ENH: Make Vector construction from scalar value explicit`

Christopher Mullins (12):

`     STYLE: Keep codesnippet lines under 80 characters.`\
`     STYLE: Fix Latex blocks in documentation to include newlines.`\
`     COMP: Fix clang warnings`\
`     DOC: Fix Latex underscore for SoftwareGuide`\
`     BUG: Return a correct voronoi partition in Danielsson filter example.`\
`     STYLE: Fix Latex blocks in documentation to include newlines.`\
`     DOC: Use the dilated version of the FivePoints image`\
`     COMP: Use c++11 noexcept declarator.`\
`     COMP: Fix override warnings on clang with GPU module and MINC`\
`     COMP: Fix clang override warnings for Review module.`\
`     COMP: Fix more clang warnings in review module`\
`     COMP: Fix more clang override warnings in Review module.`

Cyril Mory (3):

`     BUG: Fixed itkWarpImageFilter wrong result in some cases`\
`     ENH: Method to compute InputRequestedRegion in itkWarpImageFilter`\
`     ENH: Moved some of itkWarpFilter from private to protected`

David Froger (2):

`     ENH: Check regions in HDF5 streaming test`\
`     BUG: Fix HDF5 write streaming test.`

Davis Vigneault (4):

`     STYLE: Minor style and documentation changes to ITK examples.`\
`     DOC: Minor changes and clarifications to the registration chapter of Book 2.`\
`     STYLE: Minor wording and formatting changes to Software Guide Mesh examples.`\
`     COMP: Build failure using EuclideanDistancePointMetric with mismatched meshes.`

Dženan Zukić (4):

`     COMP: VS 2012+ compile fixes and CMake warnings`\
`     COMP: fixing quote matching in vtkGlue-related .cmake file`\
`     ENH: adding reverse iteration test`\
`     ENH: using scanline iterator instead of linear iterator`

GDCM Upstream (1):

`     GDCM 2015-04-29 (81e551fc)`

Gary JIA (1):

`     BUG: Fix memory leak at GPUCommon`

Gaëtan Lehmann (21):

`     BUG: fix extra carriage return in python callbacks`\
`     ENH: use castxml in wrapping`\
`     COMP: almost fix java build`\
`     ENH: use modern cmake list operations in wrapping`\
`     COMP: hide compiler warnings when building pcre and swig`\
`     COMP: fix the IOFDF module name used in wrapping`\
`     COMP: fix last python runtime warnings about unknown types`\
`     COMP: fix undefined __float128 type with gcc`\
`     BUG: reactivate PythonGetNameOfClass and fix the FDFImageIOFactory name`\
`     COMP: fix warnings due to double MultipleValuedCostFunction wrapper`\
`     BUG: fix ipython custom completion`\
`     BUG: fix runtime information for cross correlation filters`\
`     ENH: let the user choose the tradeoff between size and speed in fft operations`\
`     ENH: update progress in ImageFileReader`\
`     ENH: initialize the progress in ImageFileWriter`\
`     BUG: fix extra line return in terminal progress display`\
`     BUG: fix missing space before `“`done`”` in progress display`\
`     ENH: pass ActualXDimensionIsOdd through the pipeline`\
`     COMP: fixes for SizeGreatestPrimeFactor`\
`     ENH: Add itkFFTPadImageFilter`\
`     ENH: factorize shared code in itk::PadImageFilterBase`

Gert Wollny (1):

`     COMP: defining ITK_USE_FLOAT_SPACE_PRECISION`

Hans Johnson (39):

`     COMP: Add c++11 override designation`\
`     COMP: Identify null pointer assignments`\
`     STYLE: rm explicit void for parameterless function`\
`     STYLE: Use ITK_NULLPTR to utilize c++11 features`\
`     BUG: Incorrect addition of ITK_OVERRIDE`\
`     COMP: Use STREQUAL instead of MATCH`\
`     BUG: return type defaults to zero.`\
`     BUG: ImageType, CofficientImageArray types missing`\
`     DOC: Invalid doxygen return for void function.`\
`     COMP: _Pragma suppress fltpnt equality warnings`\
`     COMP: Allow exact floatpnt equality checks.`\
`     COMP: Avoid floatpnt equality check`\
`     COMP: Floatpnt equality for divisor`\
`     COMP: Avoid unnecessary float pnt equality checks.`\
`     PERF: Improve perf of ANTSNeighborhoodCorrelation`\
`     BUG: Test depending on itkMesh.h in Common`\
`     COMP: Make DCMTK header functions const`\
`     Revert `“`COMP:`` ``VTK`` ``AUTOINIT`` ``redefinition`` ``warnings`”\
`     COMP: VTK and ITK H5 build program collision`\
`     COMP: Create out-of-line virtual method defintions`\
`     COMP: Create out-of-line virtual method macros`\
`     DOC: Clarify strange syntax for itk::MetaEvent`\
`     COMP: Fix ENABLE_SHARED variable name`\
`     STYLE: Remove outdated cmake version support`\
`     STYLE: Move SymmetricEigenAnalysis to Deprecated`\
`     COMP: Prefer modern CMake visibility settings`\
`     STYLE: Use ITK_NOEXCEPTION macro`\
`     ENH: Continue to deprecate ::Zero and ::One`\
`     ENH: Avoid need for const_cast, ensure consistency`\
`     BUG: Incorrect function signature`\
`     COMP: Intel compiler warning suppression`\
`     ENH: Add shared libraries for ITK libraries`\
`     ENH: Remove unnecessary const_cast`\
`     STYLE: Move utility TransformIOHelper to cxx file`\
`     BUG: Missing ITKIOMINC_EXPORT on __Private()`\
`     STYLE: Fixed AnalyzeObjectMap header guard style.`\
`     COMP: Missing exports for templates`\
`     ENH: Update MGHIO for consistency with ITK.`\
`     BUG: Remove shared specifications from TransformIO`

Ivan Setiawan (2):

`     BUG: Fix initial ImageTrueMax to the most negative value.`\
`     BUG: Test case to verify fix of ImageTrueMax in MattesMI.`

Jan Bergmeier (1):

`     DOC: Changed indices for steps in ExhaustiveOptimizer.`

Jon Haitz Legarreta (10):

`     ENH: New test for the BinaryStatisticsKeepNObjectsImageFilter`\
`     ENH: New test for the itkLabelShapeKeepNObjectsImageFilter`\
`     ENH: Add test for itkShapeRelabelImageFilter`\
`     ENH: Add test for the itkLabelStatisticsKeepNObjectsImageFilter`\
`     ENH: Add test for itkBinaryShapeKeepNObjectsImageFilter`\
`     ENH: Add test for itkLabelStatisticsOpeningImageFilter`\
`     DOC: Correct documentation typo.`\
`     ENH: Increase code coverage for itkCustomColormapFunction`\
`     ENH: Increase code coverage for itkCustomColormapFunction`\
`     ENH: New test for the itkMetaGaussianConverter`

Julien Jomier (1):

`     BUG: Output pointer origin is not set causing a memory access error.`

KWSys Robot (3):

`     KWSys 2015-04-19 (4f39791b)`\
`     KWSys 2015-05-12 (b1d560a0)`\
`     KWSys 2015-05-18 (9a6b7c3f)`

Kevin H. Hobbs (1):

`     COMP: new baseline for building against VTK master`

Marius Staring (2):

`     BUG: workaround for 64bit VS2013 Release segfaults`\
`     COMP: workaround for 64bit VS2013 Release ICE`

Matthew McCormick (160):

`     ENH: Add BridgeNumPy Remote Module.`\
`     COMP: Bump AnalyzeObjectMapIO to fix doxygen warning.`\
`     STYLE: Style changes for itkGaussianDerivativeImageFunctionTest.`\
`     ENH: Test GaussianDerivativeImageFunction with unsigned short.`\
`     ENH: Bump CMakeLists.txt version to 4.8.0.`\
`     DOC: Add C++11 macros to doxygen configuration.`\
`     ENH: Remove FindNUMARRAY.cmake.`\
`     STYLE: Too many spaces before semi-colon in PCAShapeSignedDistanceFunction.`\
`     COMP: Bump Wiki Examples revision to fix Doxygen warnings.`\
`     COMP: Fix ITK_OVERRIDE update DebugMacro build errors.`\
`     DOC: Updates to GettingStarted.txt.`\
`     BUG: Remove Testing/Temporary/CTestCostData.txt.`\
`     ENH: Update doxygen.config for Doxygen 1.8.9.1.`\
`     ENH: Bump release branch version to 4.7.1.`\
`     ENH: Bump CMakeLists.txt version to 4.8.0.`\
`     BUG: Clear TransformIO's list of transforms in TransformFileReader.`\
`     DOC: Rename duplicate doxygen section.`\
`     Revert Doxygen version 1.8.9.1 to 1.8.5 config to clean up dashboard`\
`     DOC: Fix Doxygen override, nullptr, noexcept definitions.`\
`     DOC: Note that push access is not required to get patches merged.`\
`     COMP: Fix wrapping runtime warning on unknown itk::Matrix.`\
`     COMP: Add missing types for MeshTraits wrapping.`\
`     COMP: Do not wrap the Container types for CellInterface * types.`\
`     COMP: Add wrapping for CellTraitsInfo.`\
`     COMP: Wrap missing Mesh templates.`\
`     DOC: Clean up some wrapping comments.`\
`     ENH: Add wrapping for ITKImageNoise module.`\
`     STYLE: Clean up inter-definition space for Image,ImageBase,ProcessObject.`\
`     ENH: Fetch source tarball external data from midas3.kitware.com.`\
`     BUG: Fix BridgeNumPy signed / unsigned short correspondance.`\
`     DOC: Improve ImageScanlineIterator documentation.`\
`     ENH: Add missing {Set,Get}Element methods to Array2D.`\
`     BUG: Fix linking SmoothingRecursiveYvvGaussianFilter with install tree.`\
`     BUG: Add CMake export code for ITK_USE_SYSTEM_GDCM.`\
`     ENH: Pass CMAKE_GENERATOR to ExternalProject's.`\
`     ENH: Update LLVM/Clang ExternalProject to 3.6.0.`\
`     ENH: Update MetaIO License from Upstream.`\
`     ENH: Bump MetaIO to latest upstream.`\
`     BUG: Export ITK_FFTW_INCLUDE_PATH as CMake path.`\
`     COMP: Do not include tests/ directory in clang tarball.`\
`     ENH: Add Azure Storage as ExternalData source.`\
`     STYLE: Update SplitComponents module for KWStyle fixes.`\
`     COMP: Fix LevelSetsv4 tests with libc++.`\
`     STYLE: Style fixes for LevelSetsv4 and related classes.`\
`     BUG: Move MagnitudeAndPhaseToComplex filter wrapping to ITKImageIntensity.`\
`     ENH: Document testModules.sh and move to Utilities/Maintenance`\
`     BUG: Fix Python tests on Windows with Ninja generator.`\
`     STYLE: Update IOSTL module for KWStyle test.`\
`     BUG: Set ITK_BUILD_SHARED in ITKConfig.cmake on Windows.`\
`     BUG: Suppress wrapping type conversions warnings with MSVC.`\
`     COMP: Address quoted MSVC variable in GDCM.`\
`     BUG: WrapITK.pth should contain the lib/ directory with VS.`\
`     COMP: Suppress swig build configure warning.`\
`     ENH: Use CMAKE_CROSSCOMPILING_EMULATOR to run HDF5 detection.`\
`     BUG: Do not use EXECUTABLE_OUTPUT_PATH for vcl tests.`\
`     BUG: Do not enable floating point exceptions in tests with MinGW.`\
`     DOC: Update KWStyle location.`\
`     BUG: Add QuickViewTest baseline for Mac.`\
`     ENH: MetaIO use UpdateThirdPartyFromUpstream.sh`\
`     ENH: Arrange MetaIO sources for UpdateThirdPartyFromUpstream.sh.`\
`     ENH: Add root snapshot commit support to UpdateThirdPartyFromUpstream.sh`\
`     COMP: Do not try to generate tiff_fax3sm.c when cross compiling.`\
`     COMP: Android does not currently have posix_memalign.`\
`     COMP: The Android pwd.h passwd struct does not have a pw_gecos entry.`\
`     COMP: Android does not have pthread_setcancelstate.`\
`     COMP: Do not do __errno_location workaround on Android.`\
`     COMP: Removed unused parameters in itkThreadPoolTest.`\
`     BUG: Address detection of TransformReadWriteTest as executable.`\
`     ENH: Set CMP0056 to NEW.`\
`     COMP: Work around test file too big with x64_64-w64-mingw32.`\
`     COMP: Increase itkMattesMutualInformationImageToIMageMetricv4Test tolerance.`\
`     COMP: Address NumericTraits warning related to POWER8 char.`\
`     BUG: Add new ResampleImageFilter9Test baseline for MinGW.`\
`     BUG: Add MinGW baseline for VoronoiPartitioningImageFilterTest1.`\
`     COMP: Fix vnl_sample.cxx for srand48 but no drand48.`\
`     ENH: Add ITK_DYNAMIC_LOADING CMake option.`\
`     COMP: Support S_IRUSR and S_IWUSR.`\
`     COMP: Do not log swig configure output.`\
`     BUG: NumericTraits< char > does not have Self typedef.`\
`     ENH: Do not use TestBigEndian from CMAKE_ROOT.`\
`     COMP: Use sizeof(void *) instead of sizeof(size_t) for address model.`\
`     COMP: Do not use GCC demangling with emscripten.`\
`     ENH: Use try_run to determine if double correction required.`\
`     COMP: Address quoted MSVC variable in GDCM.`\
`     COMP: Suppress Swig configure output.`\
`     COMP: Remove duplicate InternalLabelType typedef.`\
`     COMP: Set CMP0058 to NEW.`\
`     COMP: Add missing InternalLabelType.`\
`     BUG: Specify absolute path to double-conversion-configure.h for install.`\
`     DOC: Clarify the UpdateThirdPartyFromUpstream.sh commit message.`\
`     BUG: Link to VTK 6 rendering backend modules.`\
`     COMP: Pass --quiet to swig's configure script.`\
`     STYLE: Update HigherOrderAccurateGradient module for style fixes.`\
`     ENH: Mark ITK_DYNAMIC_LOADING as an advanced CMake variable.`\
`     COMP: Ignore swig-prefix warnings.`\
`     BUG: GDCM set default ultrasound spacing when not found.`\
`     COMP: Initialize arrays in itkCurvatureFlowFunction.`\
`     BUG: Add VTK modules for annotation rendering.`\
`     BUG: Link vtkRenderingFreeType in the VTK modules.`\
`     COMP: Add itkIntTypes.h header for SizeValueType in itkVnlFFTCommon.h`\
`     STYLE: Style fixes for RayCastHelper::CalcRayIntercepts`\
`     COMP: Run the SWIG configure step in a CMake script.`\
`     ENH: Bump release branch version to 4.7.2.`\
`     STYLE: Bump IOFDF module for style and cleanup.`\
`     BUG: Fix DoxygenInGroup test from .zip release files.`\
`     COMP: Do not wrap exotic QuadEdgeMesh CellInterface types.`\
`     COMP: Remove FFTWGlobalConfiguration param doxygen keyword.`\
`     COMP: Do not reference ::MetaEvent in itkMetaEvent.h docs.`\
`     DOC: itkSymmetricEigenSystem is now in the ITKDeprecated module.`\
`     BUG: Fix TestDriver executable for itkSymmetricEigenSystemTest.`\
`     BUG: Use consistent SizeGreatestPrimeFactor in deconvolution tests.`\
`     COMP: Use signed char in ImageToImageMetricv4 test.`\
`     COMP: Do not include itkDynamicLoader in header tests.`\
`     COMP: Include byteswap.h for Android in GDCM.`\
`     COMP: Use signal.h instead of sys/signal.h in GDCM.`\
`     COMP: Not all versions of Android have posix_memalign.`\
`     COMP: Initialize variable in PointSetToListSampleAdaptorTest.`\
`     COMP: Suppress getpwnam warning with static executables.`\
`     COMP: Tighten LandmarkWarping2 lines for Software Guide.`\
`     ENH: Allow skip of FloatPointExceptions implementation for absent fenv.h.`\
`     COMP: Define feenableexcept for Emscripten.`\
`     BUG: HDF5 do not force CMake CheckTypeSize on include.`\
`     STYLE: Style fixes to itkVideoStream.e`\
`     COMP: Ignore build warnings for libs unfound by emscripten.`\
`     BUG: Run HDF5 H5detect in working directory with the executable.`\
`     BUG: HDF5 use CMAKE_EXECUTABLE_SUFFIX.`\
`     COMP: Work around Emscripten internal compiler crash in VideoStream.`\
`     COMP: Use byteswap.h with GDCM with Emscripten.`\
`     COMP: Recognize Emscripten in socket++.`\
`     BUG: Remove HDF5's own internal CheckTypeSize.cmake.`\
`     ENH: Enable cross-compiling of the wrapping.`\
`     COMP: Missing semi-colon in FFT Hermitian filters.`\
`     ENH: Add ExternalData_NO_SYMLINKS option.`\
`     ENH: Mount local filesystem in the test driver for Emscripten.`\
`     BUG: Do not install wrapping with CMAKE_PREFIX_PATH.`\
`     ENH: Define CPACK_PACKAGE_CONTACT.`\
`     ENH: Add post-commit hook for third party library patches.`\
`     ENH: Pass the CastXML flags directly.`\
`     STYLE: Rename GCC-XML references to CastXML.`\
`     ENH: Send an error when CMAKE_CXX_COMPILER_TARGET is not set.`\
`     ENH: Bump CastXML version for cross-compiling target fix.`\
`     BUG: Use STRING type for PY_SITE_PACKAGES_PATH.`\
`     BUG: Continue when IPython.get_ipython throws an AttributeError.`\
`     ENH: Add ITK_USE_SYSTEM_LIBRARIES`\
`     STYLE: Fix indentation in ITKSetStandardCompilerFlags.cmake.`\
`     COMP: Do not enable ITK_HAVE_SYNC_BUILTINS with Emscripten.`\
`     COMP: Fix MinGW ITK_HAVE_SYNC_BUILTINS detection.`\
`     ENH: Split testing data tarball form source tarball.`\
`     COMP: Do not use ITK_NULLPTR as sentinel.`\
`     ENH: Use gold linker on Linux with GCC.`\
`     COMP: Add try_compile check for gold linker.`\
`     COMP: Do not build dsrc2c.c with -fvisibility-inlines-hidden.`\
`     BUG: Remove shared specifications from IOTransformBase.`\
`     BUG: Required GCC version for gold linker is 4.8.3.`\
`     BUG: Fix ITKIOMINCExport.h capitalization.`\
`     BUG: Add missing include directory required after MINC update.`\
`     BUG: Bring in IOFDF license updates.`\
`     COMP: Add missing HDF5 include for MINC.`\
`     COMP: Add missing HDF5 include directory for ITKIOMINC.`\
`     COMP: Fix itkVTKImageExport.h header name in VtkGlue.i.`

MetaIO Maintainers (2):

`     MetaIO 2015-04-12 (b7969294)`\
`     MetaIO 2015-04-21 (dc4f7d16)`

Michka Popoff (20):

`     COMP: Use c++ style comments in pyBase.i`\
`     ENH: Update to swig 3.0.3`\
`     STYLE: Cleanup up cmake files (if, endif, foreach, endforeach).`\
`     ENH: Update to SWIG 3.0.5`\
`     COMP: Fix PythonReadDicomTagTest on OS X`\
`     ENH: Improve wrapping for Vector image types`\
`     ENH: Cleanup itkComposeImageFilter wrapping`\
`     ENH: Setup correct wrapping of GradientRecursiveGaussianImageFilter`\
`     ENH: Add Get/SetSigmaArray to GradientRecursiveGaussianImageFilter`\
`     ENH: Add checks for base types when wrapping more complex types`\
`     COMP: Fix DiffeomorphicDemonsRegistration Wrapping`\
`     STYLE: Rename ITK_WRAP_DIMS to ITK_WRAP_IMAGE_DIMS`\
`     ENH: Add ITK_WRAP_VECTOR_COMPONENTS option`\
`     STYLE: Replace GCCXML by CASTXML`\
`     BUG: Wrap FixedArray sizes also for vector components`\
`     ENH: Wrap MersenneTwisterRandomVariateGenerator`\
`     ENH: Wrap CustomColormapFunction`\
`     ENH: Update to PCRE 8.37`\
`     ENH: Enable wrapping of 4 dimensional vectors`\
`     ENH: Remove inline namespace fix for Wrapping`

Nick Tustison (10):

`     ENH:  Adding point set reg. capabilities for SyN.`\
`     PERF:  Tolerance for testing needs to be increased.`\
`     BUG:  Coverity divide by zero complaint.`\
`     BUG:  Metric evaluation had an incorrect sign.`\
`     ENH:  Making the point set type visible.`\
`     BUG:  Need to check if maxNorm == 0.`\
`     BUG:  Pixel type shouldn't be initialized with scalar.`\
`     ENH:  Cleaning up point set reg. in BSplineSyN`\
`     ENH:  Adding tangent space calculation for SyN methods.`\
`     BUG:  Added sampling only within the specified mask.`

Niels Dekker (2):

`     BUG: workaround for 64bit VS2013 Release segfault`\
`     COMP: Fixed MSVC warnings, `“`warning`` ``D9025:`` ``overriding`` ``'/W1'`` ``with`` ``'/w'`”

Richard Beare (3):

`     ENH: LabelErodeDilate as a remote module`\
`     ENH: remote.cmake for parabolic morphology`\
`     ENH: Use SHA for LabelErodeDilate module.`

Rolf Eike Beer (2):

`     STYLE: ExternalData: Replace MATCHES with STREQUAL where possible`\
`     STYLE: ExternalData: Clean up duplicate regex matches with CMAKE_MATCH_`<n>

Sean McBride (12):

`     COMP: Changed KWStyle check for header include guard names`\
`     COMP: Remove double underscore in header guards (.h & __itk*_h form)`\
`     COMP: Remove double underscore in header guards (.hxx & __itk*_h form)`\
`     COMP: Remove double underscore in header guards (.in & __itk*_h form)`\
`     COMP: Remove remaining double underscore in header guards (__itk form)`\
`     COMP: Remove unnecessary header guards in .cxx files`\
`     COMP: Manually search for `“`__itk`”` and clean up double underscore usage`\
`     COMP: fixed clang -Wkeyword-macro warning by removing invalid #undef`\
`     COMP: Suppress clang -Wdocumentation-unknown-command false positive`\
`     COMP: properly escape @ char in doxygen comments`\
`     COMP: Escaped @ character in doxygen comments`\
`     BUG: updated libminc SHA to newest`

Ziv Yaniv (1):

`     BUG: Versor initialized with null axis (0,0,0) did not throw exception.`

ITK Sphinx Examples Changelog

------------------------------------------------------------------------

Arnaud Gelas (9):

`     DOC: recommend to use CreateNewExample.py`\
`     ENH: Add one example for BinaryFillholeImageFilter`\
`     add one example to illustrate the usage of LabelSelectionLabelMapFilter`\
`     Apply BinaryMorphologicalClosingFilter on all LabelObjects of given LabelMap`\
`     Add one example to apply morphological closing on specific LabelObject`\
`     fix rst formatting`\
`     Add one example to overlay one label map on top of one image`\
`     Minor fixes in page title`\
`     COMP: Fix sphinx warning (missing '.' for one title)`

Bradley Lowekamp (1):

`     BUG: Fix ITK_WRAP_PYTHON check`

Dženan Zukić (1):

`     Adding DicomSeriesReadImageWrite3`

Matt McCormick (11):

`     ENH: Add option to build Python wrapping in the superbuild.`\
`     COMP: Remove `“`ImageFilter`”` from ApplyGradientRecursiveGaussian.`\
`     COMP: Set CMP0054 to NEW.`\
`     BUG: Fix links to Midas community.`\
`     ENH: Send an error when the source/build path is too long on Windows.`\
`     BUG: Extend the superbuild path limit.`\
`     BUG: Add ITKMetaIO to ComputePeronaMalikAnisotropicDiffusion to create output.`\
`     ENH: Update VTK version to 6.2.0.`\
`     COMP: Do not log ExternalProject steps that generate false positives.`\
`     COMP: Remove unused variables and types.`\
`     ENH: Bump ITK ExternalProject to v4.8.0.`

Michka Popoff (19):

`     ENH: Add GradientRecursiveGaussianImageFilter example`\
`     COMP: Fix failing ApplyGradientRecursiveGaussianImageFilter tests`\
`     DOC: Fix GradientRecursiveGaussianImageFilter documentation`\
`     COMP: Fix missing images in ApplyGradientRecursiveGaussianFilter`\
`     ENH: Add new example with GradientRecursiveGaussianImageFilter`\
`     BUG: Correctly detect and set python_file`\
`     ENH: Add Python code to RemoveHolesNotConnectedToImageBoundaries`\
`     STYLE: Remove example_name and folder variables`\
`     STYLE: Pep8 cleanup for CreateNewExample.py.in`\
`     ENH: Improve CreateNewExample script`\
`     ENH: ADD ComputePeronaMalikAnisotropicDiffusion Python Example`\
`     ENH: Add Anti Alias Python Example`\
`     ENH: Add tests for Python examples in AnisotropicSmoothing`\
`     BUG: Fix PeronaMalik python example`\
`     ENH: Add ApplyColorMap Python example`\
`     ENH: Simplify CMakeLists Python setup`\
`     ENH: Add custom colormap Python example`\
`     ENH: Improve Python SuperBuild`\
`     ENH: Replace double with float in python examples`

ITK Software Guide Changelog

------------------------------------------------------------------------

-   Note that improvements in the Examples/ directory of the ITK
    repository also contribute to the improvements in the Software
    Guide.

Davis Vigneault (1):

`     DOC: Fix typo's in SystemOverview and DataRepresentation.`

Matt McCormick (9):

`     ENH: Update the MetaIO license file location.`\
`     ENH: Add option to build HTML output with tex4ht.`\
`     ENH: Remove the 000- and 001- prefixes to the main .tex files.`\
`     ENH: Add CMake option to turn off the draft watermark.`\
`     ENH: Add some styling to the HTML index.`\
`     DOC: Update Python wrapping information.`\
`     BUG: Fixes to How To Write A Filter.`\
`     ENH: Bump ITK ExternalProject to July 01, 2015.`\
`     COMP: Address missing bracket and backslash escapes.`

ITK Apps Changelog

------------------------------------------------------------------------

Matt McCormick (2):

`     COMP: Fix @only capitalization in External-FLTK.cmake.`\
`     ENH: Bump ITK Superbuild version to 4.8.0.`
