ITK Release 4.5
===============

New Documentation

------------------------------------------------------------------------

-   New edition of the ITK Software Guide.  For the first time since
    version 2.4, a new edition of the ITK Software Guide is available, a
    book that has been a close companion to numerous medical imaging
    graduate students. In addition to numerous updates, the resource now
    has a community contribution mechanism that mirrors the contribution
    process for the ITK repository.  Improvements are welcome to this
    living document. The new edition is available in PDF form and
    downloadable from <http://itk.org/ItkSoftwareGuide.pdf> .

<!-- -->

-   ITK Wiki examples tarball.  A buildable archive of the outstanding
    examples indexed at <http://itk.org/Wiki/ITK/Examples> is available
    to download, build against the current release, and learn from.

<!-- -->

-   ITK Sphinx examples downloads.  Examples available online at
    <http://itk.org/ITKExamples/> are stored in Git version control but
    rendered in HTML, PDF, and EPUB output formats with the Sphinx
    documentation system.  They have CTest unit tests, inline Doxygen
    class descriptions and links to full Doxygen class documentation,
    nightly generated Gitstats, an index, quick search, and a
    contribution mechanism that mirrors ITK or the Software Guide.

<!-- -->

-   ITK repository examples links in Doxygen HTML documentation.  A
    downloadable archive of the Doxygen generated HTML documentation is
    available as usual, but examples from the ITK repository Examples/
    directory are also indexed in the description of every Doxygen
    class.

New Features

------------------------------------------------------------------------

-   ITKv4 registrations can now be run in either 64-bit double or 32-bit
    float modes.  Both double and float transform types are also now
    supported by metrics, optimizers, and IO readers/writers.
-   SpacingValueType -- Previously ITK only supported representing
    physical space as type double.  This patch introduces a typedef to
    encapsulate the concept of space precision to more clearly document
    the intended characteristics of the types.  This is the first step
    toward allowing compile time selection of using single precision
    types for characterizing physical space (origin, spacing, direction
    cosines).  There is an CMake configuration option,
    ITK\_USE\_FLOAT\_SPACE\_PRECISION, to allow building the entire
    toolbox in single precision mode, and currently is intended to
    facilitate future performance testing. NOTE:  Use of
    ITK\_USE\_FLOAT\_SPACE\_PRECISION causes many regression test
    failures, and is not intended for production use at this time.
-   Support for “float” type as physical units type in the Registration
    framework, which makes possible float type displacement fields and
    faster, less memory intensive registrations
-   Many performance improvements in Registration -- significant
    performance improvements made for ImageRegistration. See patch sets
    prefixed by PERF.  False sharing across threads as identified and
    removed.  Unnecessary mutex lock identified and removed.  For one
    common case on real sized data, this resulted in a 70X speed
    increase.
-   Two new Remote modules:
    -   MGHIO -- Partial support for reading/writing image files from
        FreeSurfer (Not a complete implementation, but simple label maps
        and intensity images can be read/written).
    -   SmoothingRecursiveYvvGaussianFilter -- From Insight Journal
        submission: <http://hdl.handle.net/10380/3425>
-   The SCIFIO remote module has also seen nice updates.
-   IO module libraries will now be built as shared libraries with
    BUILD\_SHARED\_LIBS ON
-   MRCImageIO moved out of the Review Module
-   BinShrinkImageFilter added -- From Insight Journal submission:
    <http://hdl.handle.net/10380/3450>
-   WrapITK Python wrapping now supporting GCC 4.8
-   JPEG format now writes out spacing in physical units
-   MINC ImageIO improvements:
    -   Correct handling of missing or damaged minc file
    -   MINCTransformAdapter class to use MINC style transformations
        stored in .xfm files, using native minc general\_transform
        functions, which means that thin-plate spline non-linear
        transformations are accessible and calculation of inverse
        transformation can be done in a way consistent with minc tools.
    -   Ability to store any linear transformation based on
        MatrixOffsetTransformBase<double,3,3> in minc style .xfm file
        (using TransformFileWriter).
-   OtsuThresholding classes made more consistent with other libraries
    -   Now the output of the threshold value may be different from
        previous releases (bug fix)
-   Synchronized with “teem” library 1.11.1, providing NRRD
    functionalities.
-   FlatStructuringElement new option to use a parametric radius in
    Ball() method
-   LevelSetsv4 now has a penalty term for overlap between level sets.
-   Can now read Philips 4D multi-frame DICOM files
-   CMake variable ITK\_BUILD\_ALL\_MODULES was replaced with
      ITK\_BUILD\_DEFAULT\_MODULES (same behavior, more appropriate
    name).
-   Remote Modules were simplified by removing the CMake configuration
    variable Fetch\_{RemoteModuleName} and only requiring
    Module\_{RemoteModuleName}
-   New CTest label “RUNS\_LONG” to makes it possible to exclude long
    running tests with “ctest -LE RUNS\_LONG”
-   Deprecate ITK\_USE\_REVIEW CMake variable in favor of
    Module\_ITKReview
-   Better support for system installed GDCM
-   Preliminary support for Visual Studio 12 (2013)
-   Preliminary support for OSX 10.9 - Maverick   
-   Support for building ITK against a DCMTK 3.6.0 installed on Ubuntu
    using apt-get
-   Improved support for C++11
-   More consistent coding style across the toolkit
-   -   Lots\* of important bug fixes, including 73 issues reported by
        Coverity static analysis

-   And more! See details in the log.

List of changes since v4.5rc03

------------------------------------------------------------------------

Bradley Lowekamp (4):

`     BUG: Fix rounding issue with HistogramPlotter test`\
`     COMP: Remove unused method to manage warning`\
`     COMP: Prevent compile-time numeric warnings in Float Exception test`\
`     BUG: Add new baseline and relax tolerance for histogram plotter`

Brian Helba (2):

`     BUG: Put ImageIOBase helper function in anonymous namespace`\
`     BUG: Remove an invalid test case that will always fail`

Constantine Zakkaroff (1):

`     DOC: ITK Software Guide Reference Label Fix`

Kent Williams (1):

`     COMP: Remove outdated conditionals/pragmas`

Matthew McCormick (9):

`     COMP: Fix BSplineDeformableTransformTest for GCC4.8.2.`\
`     COMP: Disable -Warray-bounds for GCC 4.7, 4.8.`\
`     COMP: Fix HDF5 add_custom_command TARGET does not exist warnings.`\
`     COMP: ImageRegistrationHistogramPlotter HistogramWriter visibility.`\
`     BUG: Do not clobber Git origin pushurl.`\
`     COMP: Fix signed/unsigned comparison in itkBinShrinkImageFilterTest1.`\
`     BUG: Fix BinShrinkImageFilter 32-bit failures with rounding.`\
`     BUG: Make RealTimeClock on Windows report consistent time.`\
`     ENH: Mark ImageRegistrationHistogramPlotterTest as RUNS_LONG.`

Paolo Zaffino (1):

`     ENH: wrap CenteredTransformInitializer 2D images`

Xiaoxiao Liu (2):

`     BUG: itkVTKTetrahedraMeshReader fails on a win64 build.`\
`     BUG: SCIFIO auto image factory registration.`

List of changes since v4.5rc02

------------------------------------------------------------------------

Bill Lorensen (1):

`     ENH: Restore/convert/repair ImageRegistrationHistogramPlotter`

Bradley Lowekamp (5):

`     DOC: Fixing BinShrink image caption`\
`     BUG: Fix up-casting causing inf loop`\
`     BUG: remove HDF5 configuration option propagated to the top`\
`     BUG: initialize member variables in LabelVoting filter`\
`     BUG: Add missing cmake file for MRCIO and wrapITK`

Jean-Christophe Fillion-Robin (1):

`     COMP: Ensure FindDCMTK.cmake provided by ITK is used (build tree case)`

Matthew McCormick (2):

`     ENH: Wrap additional dimensions for TileImageFilter.`\
`     BUG: LeafTreeIterator does not produce correct output.`

Xiaoxiao Liu (1):

`     BUG: Fix remote image IO module registration.`

List of changes since v4.5rc01

------------------------------------------------------------------------

Bill Lorensen (1):

`     COMP: Dead code`

Bradley Lowekamp (6):

`     COMP: Fix C++11 conversion warning.`\
`     STYLE: Use double type in array initializer list for spacing`\
`     COMP: No Vector pixel type for BinShrink`\
`     BUG: Use standard baseline and compare for validation`\
`     BUG: Remove initially available ITK_WRAP_JAVA cmake option`\
`     COMP: Use SimpleNew macro to avoid Clone method`

Brian Helba (1):

`     DOC: Clarified NormalizedCorrelationImageToImageMetric value`

Hans Johnson (1):

`     BUG: SpacePrecision typedef's incorrect.`

Julien Michel (1):

`     BUG: Using static const variable causes ld error when using dynamic libraries`

KWSys Robot (1):

`     KWSys 2013-11-21 (1010d0e3)`

Matt Leotta (1):

`     COMP: Fix improper included header in vcl_memory_tr1.h`

Matthew McCormick (1):

`     BUG: Update VXL update README location.`

List of changes since v4.4.0

------------------------------------------------------------------------

Ali Ghayoor (5):

`     ENH: transform reader/writer filters are templated on output precision type`\
`     BUG: Fix memory leak error in itkHDF5TransformIO`\
`     DOC: Migration guide is updated for multi precision of ITK`\
`     BUG: TvirtualImage mismatch in registrationV4 and metric object`\
`     STYLE: check dynamic cast validation in ITKv4 Registration`

Andinet Enquobahrie (1):

`     BUG: UseSeriesDetails variable not correctly set`

Arnaud Gelas (24):

`     ENH: Converting itk::Point, Size, Index, Vector, Matrix to corresponding OpenCV data structure`\
`     BUG: Check that region for thread is not empty`\
`     COMP: use concept checking instead of runtime checking`\
`     BUG: Fix failure in InteractivePause test`\
`     ENH: updating level sets sparse layer visualization`\
`     ENH: Upgrade doxygen config file`\
`     BUG: fix KWStyle errors in itkVTKVisualize* files`\
`     BUG: Fix visualization of 3D level-sets`\
`     ENH: Add Concept checking for 2D Visualization`\
`     ENH: Use partial template specialization for iso value vis`\
`     BUG: Check that region for thread is not empty`\
`     BUG: Fix failure in InteractivePause test`\
`     BUG: fix include to the corresponding hxx`\
`     COMP: fix compilation error with Set/Get LevelSetDataPointerVector`\
`     ENH: Rename LevelSetDataPointerVector -> LevelSetDomainRegionVector`\
`     PERF: fix cppcheck issues in itk::ImageRegion`\
`     STYLE: fix cppcheck style warning`\
`     STYLE: fix cppcheck errors`\
`     PERF: fix cppcheck perf warning`\
`     PERF: cppcheck copy constructor`\
`     PERF: fix cppcheck issues in itk::ImageRegion`\
`     PERF: cppcheck performance issue`\
`     COMP: fix cppcheck errors member not initialized in constructor`\
`     STYLE: fix cppcheck style warning`

Bill Lorensen (27):

`     ENH: Reduce test times for Debug builds`\
`     COMP: Bad CMake warning`\
`     COMP: Resource leaks`\
`     COMP: Resource leaks`\
`     COMP: Uninitialized scalar variable`\
`     COMP: Unbounded source buffer`\
`     COMP: Destination buffer too small`\
`     COMP: Destination buffer too small`\
`     COMP: Resource leak`\
`     COMP: Resource leak`\
`     COMP: Big parameter passed by value`\
`     COMP: Big parameter passed by value`\
`     COMP: Copy-paste error`\
`     COMP: Copy-paste error`\
`     COMP: Copy-paste error`\
`     COMP: Copy-paste error`\
`     COMP: Copy-paste error`\
`     COMP: Structurally dead code and resource leaks`\
`     COMP: Big parameter passed by value`\
`     COMP: Explicit null dereferenced`\
`     COMP: Logically dead code`\
`     COMP: Logically dead code`\
`     COMP: Logically dead code`\
`     COMP: Logically dead code`\
`     COMP: Format string vulnerability`\
`     COMP: Copy-paste error`\
`     COMP: Dead code`

Brad King (5):

`     ENH: ExternalData: Do not re-stage staged object files`\
`     MetaIO: Removed the deprecated _CM24 CMake variables`\
`     COMP: Cleanup CMP0022 warnings in GDCM module`\
`     COMP: Cleanup CMP0022 warnings in GDCM module static build`\
`     BUG: Do not convert to make-escaped path for internal APIs`

Bradley Lowekamp (55):

`     COMP: Fix ambiguous specialization of GDCM Element`\
`     ENH: Use Tiff version dependent field type enable LSM`\
`     BUG: disable aligned attribute for GCC 4.1`\
`     BUG: Prevent signed integer overflow in vnl urand_`\
`     BUG: enable return value optimzation for VS debug mode`\
`     BUG: increase the image tolerance for deformable test 5`\
`     BUG: fix gradient recusive gaussian in VS debug`\
`     BUG: in NthElementAdaptor pass by reference to modify argument`\
`     BUG: disable aligned attribute for GCC 4.1`\
`     BUG: Prevent signed integer overflow in vnl urand_`\
`     BUG: enable return value optimzation for VS debug mode`\
`     BUG: fix gradient recusive gaussian in VS debug`\
`     BUG: in NthElementAdaptor pass by reference to modify argument`\
`     ENH: Add option ENABLED_SHARED to itk_module for shared libraries`\
`     ENH: Enabling shared IO modules on windows`\
`     DOC: adding Examples directory to ITK Doxygen`\
`     DOC: remove explicit doxygen example commands now automatically added`\
`     BUG: add installation of Export headers`\
`     BUG: Remove ENABLED_SHARED option for IOSpatialObjects module`\
`     BUG: Fix linking of factory register method on static windows`\
`     STYLE: Fix some style errors reported in continuous test`\
`     BUG: Remove Spurious testing file`\
`     COMP: Use relative path for generate output header parameter`\
`     BUG: Enable slice-by-slice streaming for ShrinkImageFilter`\
`     STYLE: Fix ShrinkImageStreamingTest style`\
`     PERF: Flip filter use increment in scanline direction`\
`     PERF: Additional FlipImageFilter performance by using input iterator`\
`     PERF: Move test to IntegratedTest directory`\
`     STYLE: fix typedef alignment`\
`     ENH: Move validation to VerifyInputInformation`\
`     ENH: Improve internal streaming for SliceBySliceImageFilter`\
`     ENH: Enable a VectorImage to be used as displacement field`\
`     BUG: Don't print null bias field`\
`     ENH: Define print of null smart pointers`\
`     BUG: Fix uninitialized m_Spacing in SignedMaurerDistance`\
`     BUG: Fix uninitialized m_Spacing in SignedMaurerDistance`\
`     BUG: Don't print null bias field`\
`     BUG: Verify ConfidenceConnected Seeds`\
`     BUG: Verify seeds in VectorConfidenceConnected`\
`     ENH: Check and use C++11 typetraits first`\
`     COMP: Use memcpy for raw memory copy`\
`     BUG: Use string constructor which calculates str length`\
`     BUG: fix out of bounds access of array`\
`     ENH: Move private constant and method to private header`\
`     ENH: Adding BinShrinkImageFilter.`\
`     COMP: Fix warnings and missing include`\
`     BUG: Fix Valrgrind detected delete mismatch`\
`     ENH: improve coverage for SetShrinkFactor methods`\
`     STYLE: running uncrustify and manual fixups`\
`     ENH: Moving MRCImageIO out of review`\
`     COMP: Fix gcc_xml segfault due to structure alignment`\
`     ENH: adding wrapping support for BinShrink`\
`     BUG: Add missing export specifiers for MRC module`\
`     ENH: Move MRC wrapping out of review`\
`     COMP: VS12 missing header in review`

Brian Helba (45):

`     DOC: Fix instances of class documentation outside itk namespace`\
`     PERF: Discourage DomainThreader from spawning superfluous threads`\
`     DOC: Cleanup docs for ThreadedDomainPartitioner and subclasses`\
`     ENH: Implement ThreadedImageRegionPartitioner using ImageRegionSplitter`\
`     STYLE: Unify style of `“`operator`` ``delete[]`”\
`     STYLE: Remove superfluous return statements at the end of void functions`\
`     STYLE: Fix miscellaneous KWStyle errors`\
`     ENH: Remove superfluous IMMEDIATE option from CMake CONFIGURE_FILE`\
`     STYLE: Replace Unicode in ITK source with ASCII homoglyphs`\
`     ENH: Use MINC API to free memory allocated by MINC`\
`     PERF: Allow delete of NULL pointers`\
`     PERF: Refactor some deletion code`\
`     ENH: Refactor KWStyle testing`\
`     COMP: Make find_package usage compatible with < CMake-2.8.8`\
`     BUG: Prevent CMake cache variable from endlessly accumulating values`\
`     ENH: Rename Utilities/KWStyle/ITK.kws.xml.in to ITK.kws.xml`\
`     DOC: Update Migration guide schema URL`\
`     ENH: Rename ALL_MODULES to DEFAULT_MODULES`\
`     STYLE: Fix class indentation`\
`     BUG: Make KWStyleTest output in a uniform and concise format`\
`     BUG: Update SmoothingRecursiveYvvGaussianFilter to fix CMake warning`\
`     STYLE: Fix some indents in FixedArray::ReverseIterator declaration`\
`     DOC: Fix issues in Transform and TransformBaseTemplate`\
`     BUG: Make ImageIOBase::SetDirection accept const reference parameter`\
`     BUG: Fix uninitialized variables in itkOpenCVBasicTypeBridgeTest`\
`     DOC: Prevent concept checking comments from being parsed by Doxygen`\
`     BUG: Prevent DCMTK from trying to build unnecessary components`\
`     DOC: Update documentation graph font to avoid warnings`\
`     DOC: Move an included STL file out of the itk namespace`\
`     COMP: Fix warning C4789 from VisualStudio 11`\
`     ENH: Add explicit KWStyle testing for Examples directory`\
`     STYLE: Replace indentation tabs with spaces`\
`     STYLE: Fix KWStyle issues in Examples: whitespace`\
`     STYLE: Fix KWStyle issues in Examples: typedef alignment`\
`     STYLE: Fix KWStyle issues in Examples: manual fixes`\
`     BUG: Use KWStyle's GCC-style output for pre-commit style check`\
`     STYLE: Remove trailing whitespace`\
`     BUG: Make SCIFIO module non-default`\
`     BUG: Fix memory leaks in MINCImageIO`\
`     BUG: Fix ostream format modification warnings`\
`     BUG: Fix uninitialized members of MINCImageIO`\
`     DOC: Move Vector documentation from definition to declaration`\
`     BUG: Resource leak`\
`     ENH: Update CMake deprecated commands with new equivalents`\
`     STYLE: Fix initialization list in BSplineBaseTransform constructor`

C Cagatay Bilgin (1):

`     DOC: Modify ShapeLabelObject comments.`

Christina Rossmanith (1):

`     BUG: enable itkLabelGeometryImageFilter to be used in loops`

Constantine Zakkaroff (1):

`     DOC: Correct DICOM Tag List Formatting`

Cory Quammen (2):

`     BUG: Enabled negative background values`\
`     BUG: Fixed memory overusage in LandweberDeconvolutionImageFilter`

Csaba Pinter (1):

`     BUG: GDCM pixel spacing of ultrasound images.`

Cyrille Faucheux (1):

`     BUG: Fix support for RLE-compressed & upper-left BMP.`

Daniel Maleike (3):

`     BUG: Assert unchanged pixels only for non-PALETTE_COLOR images`\
`     BUG: Add test case for GDCMImageIO`\
`     BUG: Assert unchanged pixels only for non-PALETTE_COLOR images`

Dirk Padfield (17):

`     BUG: LabelGeometry cropped images with non-unit spacing incorrectly`\
`     BUG: ProgressAccumulator reports incorrectly for streamed filters`\
`     BUG: LabelGeometry matrix difference tolerance`\
`     ENH: Added progress reporting to Masked FFT NCC`\
`     BUG: LabelGeometry improvements`\
`     BUG: Corrected the MaskedFFTNCC origin`\
`     BUG: Resolved Otsu/OtsuMultiple Discrepancy`\
`     ENH: Deprecated SetProgress and removed Modified call`\
`     ENH: Deprecated SetProgress and removed Modified call`\
`     BUG: ConstPointer assigned to non-const raw pointer`\
`     ENH: Otsu code replaced with OtsuMultiple call`\
`     BUG: ConstPointer assigned to non-const raw pointer`\
`     ENH: Added valley emphasis algorithm to OtsuMultipleThresholds`\
`     BUG: ReachedTargetPoints not set for OneTarget`\
`     ENH: Remove duplicate code in BinaryBall and BinaryCross`\
`     ENH: Added radiusIsParametric  mode to FlatStructuringElement`\
`     ENH: Improved writing speed for TIFF images`

Ethan Brodsky (1):

`     BUG: fixedOrigin corrected in DeformableRegistration examples (ITK-3218)`

Gordon Kindlmann (1):

`     BUG: airOneLinify() infinite loop, synch w/ Teem for its 1.11.1 release`

Hans Johnson (36):

`     ENH: Add Remote Module for r/w of MGH files`\
`     ENH: Provide instructions for linking to issues`\
`     ENH: Feature to allow human readable object names`\
`     BUG: Preserve backwards compatibility with types`\
`     PERF: Optimizer scale caching and avoid copy`\
`     ENH: Support single precision registration`\
`     STYLE: Avoid polluting the ITK namespace`\
`     STYLE: Simplify H5::Exception handeling`\
`     STYLE: Replace expected exceptions with macro`\
`     BUG: ImageSeriesWriter + GDCMImageIO loses info`\
`     BUG: ImageSeriesWriter + GDCMImageIO loses info`\
`     STYLE: ITK_EXPORT had no use`\
`     BUG: Missing ',' in array of strings`\
`     BUG: 'temp' used in exception message after delete`\
`     BUG: Code after exceptions is unreachable`\
`     BUG: Printing size of deleted variable`\
`     BUG: Function should have const signature`\
`     COMP: Remove unused variable`\
`     COMP: Simplify code, and remove compiler warning`\
`     STYLE: Use `“`typename`”` for template parameters`\
`     COMP: Unused Clone and CreateAnother warnings`\
`     STYLE: Prefer initialization to assignement.`\
`     COMP: Const char * ternary operators`\
`     BUG: Derived test class missing required logic`\
`     PERF: Remove false sharing across threads`\
`     PERF: Avoid smart pointer registration penalty`\
`     PERF: Avoid vector copy, and prefer multiplication`\
`     PERF: Reviewing code for facilitating compiler optimizations`\
`     PERF: Avoid upcasting from float to double`\
`     BUG: Match Convergence Window Precision`\
`     COMP: Remove undefined complex types`\
`     COMP: Remove undefined complex types`\
`     COMP: Invalid conversion detected by clang c++11`\
`     COMP: Non standard conversion for -std=c++11`\
`     COMP: Allow single precision space definition`\
`     COMP: Namespace change for SpacePrecisionType`

Ho Cheung (6):

`     BUG: VS11 Debug mode assertions fixes`\
`     BUG: VS10/11 debug assertions for null pointer for std::copy`\
`     BUG: VS11 Debug mode assertions fixes`\
`     BUG: VS10/11 debug assertions for null pointer for std::copy`\
`     ENH: Improve mangling of itktiff library.`\
`     ENH: Improve mangling of itktiff library.`

Irina Vidal-Migallon (3):

`     ENH: Remote module: GPU and CPU Smoothing recursive YVV Gaussian Filter`\
`     ENH: Remote module: GPU and CPU Smoothing recursive YVV Gaussian Filter`\
`     ENH: YVV remote module - Add EXCLUDE_FROM_ALL option to itk_module.`

Jean-Christophe Fillion-Robin (10):

`     BUG: Disable aligned attribute to fix Apple GCC 4.2.1 seg fault`\
`     COMP: Ensure FindDCMTK module works with and without DCMTKConfig.cmake file`\
`     COMP: Make FindDCMTK more verbose`\
`     DOC: Improve FindDCMTK.cmake documentation`\
`     COMP: Ensure DCMTK libraries can be found on system without setting DCMTK_DIR`\
`     COMP: FindDCMTK - Workaround bug in packaging of DCMTK 3.6.0 on Debian.`\
`     COMP: Update ITKDCMTK_EXPORT_CODE_(BUILD|INSTALL) to support system DCMTK`\
`     COMP: FindDCMTK - Exclude -D from DCMTK_DEFINITIONS for easier re-use`\
`     COMP: FindDCMTK - Do not explicitly set DCMTK_DEFINITIONS`\
`     COMP: Associate ITKIODCMTK with DCMTK_DEFINITIONS`

Jim Miller (5):

`     BUG: GDCMImageIO ignore image orienations from MetaDataDictionary`\
`     BUG: Two tests were writing to same filename.`\
`     BUG: GDCMImageIO ignore image orienations from MetaDataDictionary`\
`     BUG: Two tests were writing to same filename.`\
`     ENH: ResampleImageFilter ReferenceImage only needs to match dimension`

Jonathan Guinet (2):

`     BUG: {Opening,Closing}ByReconstructionImageFilter information propagation`\
`     BUG: {Opening,Closing}ByReconstructionImageFilter information propagation`

Julien Michel (1):

`     ENH: Adding a separate template parameter to handle transform precision`

KWSys Robot (1):

`     KWSys 2013-07-10 (beef6819)`

Kent Williams (22):

`     ENH: fix std::string usage`\
`     DOC: Rename DCMTKException DCMTKExceptionOrErrorReturn`\
`     ENH: fix std::string usage`\
`     BUG: Need to set 3rd dir cosine for DICOM images`\
`     ENH: Accomodate Philips 4D Multiframe DICOM files`\
`     BUG: Guard against Divide by Zero`\
`     BUG: Row/Column assignment into ImageDimensions was wrong`\
`     BUG: Guard against Divide by Zero`\
`     BUG: Row/Column assignment into ImageDimensions was wrong`\
`     ENH: Accomodate Philips 4D Multiframe DICOM files`\
`     DOC: Rename DCMTKException DCMTKExceptionOrErrorReturn`\
`     BUG: Need to set 3rd dir cosine for DICOM images`\
`     COMP: Update git tag to incorporate MGHIO origin fix`\
`     COMP: Move TransformFileWriter Specializations to CXX file.`\
`     BUG: Bug fixed in remote MGHImageIO repo, update git tag`\
`     BUG: argument check in LBFGSB too restrictive`\
`     COMP: extend test for HistogramMatchingImageFilter to more pixel types`\
`     COMP: HistogramMatchingFilterTest problem with ITKV3_COMPATIBILITY`\
`     COMP: Make sscanf format & variable match types`\
`     BUG: Fix tests that fail with Intel ICPC compiler on Linux`\
`     ENH: Avoid use of cast in ImageToImageMetricV4`\
`     BUG: DCMTKFileReader erroneously propogating exceptions`

Kishore Mosaliganti (8):

`     ENH: Allow visualization of initial level-set`\
`     ENH: Add Set/GetNumberOfThreads for evolution`\
`     ENH: New binary mask term with test`\
`     ENH: Set/Get number of threads for Whitaker evolution class`\
`     BUG: Non-square images mesh not specified correctly`\
`     ENH: Set the scaling factor of the level-set function`\
`     ENH: Added new overlap penalty term and test`\
`     ENH: Level-set domains different from image domain`

Luis Ibanez (7):

`     STYLE: Fixed miscelaneous style errors.`\
`     DOC: Removed Doxygen \example tags for Tests.`\
`     COMP: Fix warnings in matrix division by scalar.`\
`     COMP: Attempt to fix warning about \param.`\
`     BUG: Fixed while loop condition.`\
`     DOC: Better description of what the code is doing.`\
`     BUG: Memory leak. Reported by Coverity.`

Mark Hiner (5):

`     BUG: Wrong classpath separator on Windows`\
`     BUG: Wrong classpath separator on Windows`\
`     ENH: Updated SCIFIO remote reference`\
`     STYLE: update SCIFIO module name`\
`     BUG: Update loci_tools to 4.4.9`

Mark Palmeri (1):

`     STYLE: correct syntax in Usage line`

Martin Müllenhaupt (2):

`     COMP: host platform source dir check`\
`     COMP: host platform source dir check`

Matt Clarkson (4):

`     ENH: Test upper and lower bound of histogram.`\
`     BUG: Include upper bound in last histogram bin.`\
`     BUG: Updated mean and standard deviation test values.`\
`     BUG: Update test data due to changes in itkHistogram.hxx`

Matthew McCormick (107):

`     ENH: Bump CMakeLists.txt version to 4.5.0.`\
`     BUG: Remove non-existant GeSignaHDx data references.`\
`     ENH: Add server URL to ArchiveTestingData script.`\
`     ENH: Add slicer.kitware.com to the list of ExternalData resources.`\
`     COMP: OpenJPEG #ifdef WIN32 not reliable ITK-3101.`\
`     DOC: Improve grammar in transform float type migration guide.`\
`     STYLE: Style fixes for MINCTransformIO.`\
`     BUG: Remove non-existant GeSignaHDx data references.`\
`     BUG: Regenerate HeaderTests' after .hxx files are removed.`\
`     COMP: Update MINCTransformIO for templated transforms.`\
`     COMP: Do not warn about unused typedefs.`\
`     COMP: Fix argument 'buffer' might be clobbered on GCC 4.8.`\
`     COMP: Wrap TransformBaseTemplate, Transform, and TransformFile{Reader,Writer}.`\
`     DOC: SingelThreaded -> SingleThreaded in Doxygen Group.`\
`     ENH: Change PATCH version for v4.4.1 release.`\
`     BUG: Add missing ITKOpenJPEG dependency for ITKReview Module.`\
`     COMP: ITKOpenJPEG EXCLUDE_FROM_ALL.`\
`     COMP: Fix invalid Doxygen LaTeX formula.`\
`     BUG: Fix Module_Review enable with a single configure.`\
`     COMP: Wrap cost functions for templated precision.`\
`     BUG: Fix Module_Review enable with a single configure.`\
`     DOC: Fix GradientDescentOptimizer doc grammar.`\
`     BUG: Using consistent naming for Transform template name change.`\
`     BUG: Remove unused QUASI_NEWTON_STEP_ERROR.`\
`     COMP: Do not try to include float.h for MinGW.`\
`     STYLE: TScalarType -> TScalar`\
`     COMP: Fix NIFTI CMake variable separation warning.`\
`     ENH: Use Transform::Clone() in ImageToImageMetric.`\
`     COMP: Remove redundant Typename structs. #3195.`\
`     STYLE: Fix include guard in level set visualization.`\
`     ENH: Use file(COPY .. instead of exec_process.`\
`     COMP: Fix transform wrapping errors with ITK_WRAP_double OFF.`\
`     DOC: Fix spelling errors in FourierDescriptors1.cxx.`\
`     BUG: Fix ITK_USE_REVIEW compatibility set syntax.`\
`     COMP: Avoid MetaIO config conflict with USE_SYSTEM_GDCM.`\
`     BUG: itkSingleLevelSetsv4WhitakerImage2DTest output clobber.`\
`     ENH: Test conversion writing float transform with templateless writer.`\
`     BUG: BMPImageIO buffer size computation.`\
`     COMP: Bump GCCXML version.`\
`     Revert `“`BUG:`` ``Exclude`` ``ITKReview`` ``when`` ``ITK_USE_REVIEW`` ``if`` ``off.`”\
`     Revert `“`BUG:`` ``Exclude`` ``ITKReview`` ``when`` ``ITK_USE_REVIEW`` ``if`` ``off.`”\
`     COMP: Do not try to include float.h for MinGW.`\
`     BUG: itkSingleLevelSetsv4WhitakerImage2DTest output clobber.`\
`     COMP: Avoid MetaIO config conflict with USE_SYSTEM_GDCM.`\
`     COMP: Bump GCCXML version.`\
`     ENH: Bump version to 4.4.2.`\
`     COMP: Fix LevelSetsv4Visualization against VTK5.`\
`     BUG: Fix LevelSetsv4Visualization Doxygen group.`\
`     BUG: Add QuickViewTest baseline for dash5ubuntu.`\
`     BUG: Exclude all VTK headers from the header test.`\
`     ENH: Improve ImageRegionReverseConstIterator doc.`\
`     COMP: Add missing wrapping for ImageSourceCommon.`\
`     COMP: Add missing VectorContainer instantiations for PointSet.`\
`     STYLE: Use prefix increment in WeightedCovarianceSampleFilter.`\
`     STYLE: LabelMap related style fixes.`\
`     BUG: LabelMapToLabelImageFilter wrong superclass in itkTypeMacro.`\
`     BUG: MeasurementVectorSizeType in PointSetToListSampleAdaptor.`\
`     BUG: Re-use Superclass typedef's in LabelMapToLabelImageFilter.`\
`     COMP: TranformIOBase unused GetTypeNameString function.`\
`     COMP: TransformFileWriter unused AddToTransformList.`\
`     STYLE: Fix KWStyleCodeTest - unnecessary semi-colons.`\
`     COMP: Update MINCTransformIO for GetTypeNameString method.`\
`     BUG: Fix uninitialized variables in N4BiasFieldCorrectionImageFilter.`\
`     ENH: Remove unused scripts in Utilities/Dart.`\
`     BUG: Fix uninitialized variables in N4BiasFieldCorrectionImageFilter.`\
`     ENH: Add maintenance script to visualize test times.`\
`     ENH: Add a RUNS_LONG label to long running tests.`\
`     BUG: Enable MRC IO in UseITK whenever the ITKReview module is enabled.`\
`     BUG: Fix Wrapping link to VtkGlue with VTK 6.`\
`     COMP: Remove multiple definition of PushBackTransformList.`\
`     COMP: Fix NIFTI CMake variable separation warning.`\
`     BUG: ImageToImageFilter different Input2 pixel type does not stream. #3214`\
`     COMP: Clean up use of Dimensions in MetaImageIO.`\
`     COMP: Conditionalize insane `“`#define`` ``inline`”` in libtiff`\
`     COMP: QuadrilateralCell Out-of-bounds-write.`\
`     COMP: Out-of-bounds access GaussianDerivativeImageFunction.`\
`     ENH: Use CompensatedSummation in GaussianDerivativeImageFunction.`\
`     ENH: Improve const correctness of QuadrilateralCell.`\
`     BUG: Add double-conversion license.`\
`     ENH: Add check for LICENSE change on double-conversion update.`\
`     BUG: Fix removal of temporary double-conversion repository.`\
`     COMP: Catch TestDriver ExceptionObject.`\
`     BUG: Add missing OpenJPEG LICENSE file.`\
`     BUG: Add missing PNG license.`\
`     BUG: AntiAliasBinaryImageFilter needs SetUseImageSpacing(false).`\
`     DOC: Flat refers to binary in FlatStructuringElement.`\
`     BUG: Examples should not have namespace KWStyle check.`\
`     DOC: Recommend newer BSplineTransform over BSplineDeformableTransform.`\
`     COMP: Do not warn about unused typedefs.`\
`     BUG: 14th Ann Incorrect enum declaration.`\
`     COMP: 14th Ann uninitialized scalar field.`\
`     STYLE: Empty lines exceed 3.`\
`     COMP: 14th Ann operator= should return TreeIteratorBase &`\
`     BUG: Incorrect CDash URL in CTestConfig.cmake.`\
`     DOC: Remove reference to missing AddFileNames method.`\
`     COMP: TIFFImageIO: use types defined in itkIntTypes.h.`\
`     COMP: 14th Ann Uninitialized pointer field.`\
`     COMP: 14th Ann m_ChangePosition not initialized in constructor.`\
`     PERF: 14th Ann TreeNode: prefer prefix ++/--`\
`     COMP: 14th Ann *Command m_This not initialized.`\
`     STYLE: 14th Ann Reduce variable scope.`\
`     STYLE: 14th Ann reduce scope of variables.`\
`     STYLE: 14th Ann operator= return Self &.`\
`     PERF: 14th Ann prefix ++ operator on non-primative types.`\
`     STYLE: 14th Ann reduce variable scope.`\
`     ENH: Bump GCCXML to latest version.`\
`     ENH: Update doxygen.config for 1.8.5.`

Mickael Savinaud (1):

`     COMP: fix compiler error from visual studio 2013`

Nick Tustison (2):

`     ENH:  Added B-spline registration test.`\
`     ENH:  Accessing optimizer weights from the methods.`

Olivier Commowick (4):

`     COMP: Add cmake tr1 namespace check for macos clang`\
`     COMP: Use ZeroValue instead of Zero for clang macos 10.9 compilation`\
`     COMP: Use ZeroValue instead of Zero for clang macos 10.9 compilation`\
`     COMP: Add cmake tr1 namespace check for macos clang`

Pew-Thian Yap (1):

`     BUG: Defined equality and inequality operators.`

Sean McBride (1):

`     COMP: Fixed compiler error in C++11`

Simon Alexander (1):

`     COMP: compilation failures encountered with Visual Studio 2013`

Stephen Aylward (7):

`     BUG: Fixed bugs in Form and hidden virtual funcs in Image`\
`     COMP: Fixed unused variable warnings in tests`\
`     COMP: Disable tests since paths are set wrong in VTK`\
`     BUG: Fixed bugs in Form and hidden virtual funcs in Image`\
`     COMP: Fixed unused variable warnings in tests`\
`     COMP: Disable tests since paths are set wrong in VTK`\
`     COMP: Fix warnings from VTK dashboard, contributed by Sean McBride`

Sureerat Reaungamornrat (1):

`     ENH: Make SetFixedImageRegion a virtual function`

Taylor Braun-Jones (1):

`     COMP: Remove unused TransformFileWriter::m_Precision ivar`

Tobias Maier (2):

`     BUG: VTKImageIO did not respect endianness for streamed writing/reading`\
`     BUG: Uninitialized value in VTKImageIOStreamTest`

Vladimir S. FONOV (6):

`     BUG: Fixing small bugs in MINC IO Module`\
`     COMP: Fixed building review statistics with gcc 4.7.`\
`     BUG: Fixed bugs in Modules/IO/MINC and Modules/ThirdParty/MINC`\
`     ENH: Added adapter class to use general_transform API from MINC`\
`     ENH: Added adapter class to use general_transform API from MINC`\
`     BUG: Fixed error handling in MINC IO`

Xiaoxiao Liu (30):

`     DOC: Add a comment for `“`ITK_Common_EXPORTS`”\
`     ENH: Add a unit test for VectorImageToImageAdaptor.`\
`     COMP: Relax tolerance for a regression test.`\
`     ENH: Exclude ITKGDCM module when system GDCM is ON.`\
`     BUG: Exclude ITKReview when ITK_USE_REVIEW if off.`\
`     BUG: A fix for using sys installed GDCM.`\
`     BUG: ITK_USE_Review did not turn Review module ON.`\
`     ENH: Simplify the steps to build remote modules.`\
`     ENH: Turn remote module LSTK off by default.`\
`     ENH: Deprecate ITK_USE_REVIEW.`\
`     DOC: Migration guide for ITK_USE_REVIEW deprecation.`\
`     ENH: Remote module names need to be consistent.`\
`     COMP: New baseline image for MultiResImageRegistrationTest.`\
`     PERF: Remove redundant CMake variables.`\
`     DOC: Sort the module enabling messages by names.`\
`     ENH: Exclude ITKGDCM module when system GDCM is ON.`\
`     BUG: A fix for using sys installed GDCM.`\
`     COMP: New baseline image for MultiResImageRegistrationTest.`\
`     ENH: Remove `“`ITK`”` prefix from remote modules.`\
`     BUG: Update LSTK module tag.`\
`     STYLE: Extract module dependency code to a separate file.`\
`     COMP: Fix LSTK warning.`\
`     COMP: Fix cmake warnings on EXCLUDE_FROM_ALL.`\
`     DOC: Better warning message for ITK_BUILD_ALL_MODULES.`\
`     BUG: Coverity resrouce leak in itkQuadEdgeTest1.`\
`     COMP: Fix coverity bug in itkQuadEdgeTest.`\
`     BUG: Resource leak in testMetaObject.cxx.`\
`     COMP: Coverity scan resource leak in itkQuadEdgeTest.`\
`     BUG: Fix typos in globalIndexNames.`\
`     BUG: Fix typos in globalIndexNames.`

List of changes in ITKApps since v4.4.0-apps

------------------------------------------------------------------------

Bill Lorensen (1):

`     ENH: Bump ITK version to 4.5.0`

Matt McCormick (4):

`     COMP: Add missing header to MIMApplicationBase.txx.`\
`     COMP: Add missing this-> to derived method calls.`\
`     STYLE: LandmarkRegistrator: whitespace towards ITK Style.`\
`     COMP: Better use of typedefs in LandmarkRegistrator.`
