// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package gitlab

import (
	"context"

	"code.forgejo.org/f3/gof3/v3/f3"
	"code.forgejo.org/f3/gof3/v3/id"
	"code.forgejo.org/f3/gof3/v3/kind"
	"code.forgejo.org/f3/gof3/v3/tree/generic"
)

type forge struct {
	common

	ownersKind map[string]kind.Kind
}

func newForge() generic.NodeDriverInterface {
	return &forge{
		ownersKind: make(map[string]kind.Kind),
	}
}

func (o *forge) Equals(context.Context, generic.NodeInterface) bool { return true }
func (o *forge) Get(context.Context) bool                           { return true }
func (o *forge) Put(context.Context) id.NodeID                      { return id.NewNodeID("forge") }
func (o *forge) Patch(context.Context)                              {}
func (o *forge) Delete(context.Context)                             {}
func (o *forge) NewFormat() f3.Interface                            { return &f3.Forge{} }
func (o *forge) FromFormat(f3.Interface)                            {}

func (o *forge) ToFormat() f3.Interface {
	return &f3.Forge{
		Common: f3.NewCommon("forge"),
		URL:    o.String(),
	}
}

func (o *forge) String() string {
	options := o.GetTreeDriver().(*treeDriver).options
	return options.GetURL()
}
