/* $Id$ 
 *
 * Abort: Abort simulation on error (intermediate opcode)
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __ABORT_HPP_INCLUDED
#define __ABORT_HPP_INCLUDED

#include "intermediate/opcodes/OpCode.hpp"

namespace intermediate {

//! Abort the simulation on error.
/** This intermediate opcode can be used to wishfully determinate
 *  the simulation with on errors.
 *  Example usage would be runtime subtype checks that fail.
 *
 *  Read operands: None
 *  Write operands: None
 *
 *  Operation: Immediately abort simulation with an error.
 */
class Abort : public OpCode {
public:
	//! c'tor
	Abort() {}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}
};

}; /* namespace intermediate */

#endif /* __ABORT_HPP_INCLUDED */
