include(CheckCXXCompilerFlag)
include(CheckCXXSourceCompiles)

macro(enable_cflags_if_supported)
    foreach(flag ${ARGN})
        check_cxx_compiler_flag("${flag}" CXXFLAG_${flag}_SUPPORTED)
        if(CXXFLAG_${flag}_SUPPORTED)
            add_compile_options("${flag}")
        endif()
    endforeach()
endmacro()

macro(enable_linker_flags_if_supported)
    set(_old_CMAKE_REQUIRED_LINK_OPTIONS "${CMAKE_REQUIRED_LINK_OPTIONS}")
    foreach(flag ${ARGN})
        set(CMAKE_REQUIRED_LINK_OPTIONS "${flag}")
        check_cxx_source_compiles("int main(){return 0;}" LDCFLAG_${flag}_SUPPORTED)
        if(LDCFLAG_${flag}_SUPPORTED)
            add_link_options(${flag})
        else()
            set(CMAKE_REQUIRED_LINK_OPTIONS "LINKER:${flag}")
            check_cxx_source_compiles("int main(){return 0;}" LDCFLAG_LINKER_${flag}_SUPPORTED)
            if(LDFLAG_LINKER_${flag}_SUPPORTED)
                add_link_options(LINKER:${flag})
            endif()
        endif()
    endforeach()
    set(CMAKE_REQUIRED_LINK_OPTIONS "${_old_CMAKE_REQUIRED_LINK_OPTIONS}")
endmacro()

macro(enable_target_linker_flags_if_supported target access)
    set(_old_CMAKE_REQUIRED_LINK_OPTIONS "${CMAKE_REQUIRED_LINK_OPTIONS}")
    foreach(flag ${ARGN})
        set(CMAKE_REQUIRED_LINK_OPTIONS "${flag}")
        check_cxx_source_compiles("int main(){return 0;}" LDCFLAG_${flag}_SUPPORTED)
        if(LDCFLAG_${flag}_SUPPORTED)
            target_link_options(${target} ${access} ${flag})
        else()
            set(CMAKE_REQUIRED_LINK_OPTIONS "LINKER:${flag}")
            check_cxx_source_compiles("int main(){return 0;}" LDCFLAG_LINKER_${flag}_SUPPORTED)
            if(LDFLAG_LINKER_${flag}_SUPPORTED)
                target_link_options(${target} ${access} LINKER:${flag})
            endif()
        endif()
    endforeach()
    set(CMAKE_REQUIRED_LINK_OPTIONS "${_old_CMAKE_REQUIRED_LINK_OPTIONS}")
endmacro()
