/*

Boost Software License - Version 1.0 - August 17th, 2003

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

*/
module derelict.sdl.macinit.selectors;

version(DigitalMars) version(OSX) version = darwin;

version (darwin):

import derelict.sdl.macinit.runtime;
import derelict.sdl.macinit.string;
import derelict.util.compat;

package:
version = SDL_USE_NIB_FILE;
// Classes
id class_NSApplication;
id class_NSAutoreleasePool;
id class_NSDictionary;
id class_NSEnumerator;
id class_NSGeometry;
id class_NSMenu;
id class_NSMenuItem;
id class_NSNotification;
id class_NSObject;
id class_NSProcessInfo;
id class_NSString;
id class_SDLApplication;

// Selectors
SEL sel_stringWithCharacters_length;
SEL sel_addItem;
SEL sel_addItemWithTitle_action_keyEquivalent;
SEL sel_alloc;
SEL sel_class;
SEL sel_getCharacters_range;
SEL sel_hasSubmenu;
SEL sel_init;
SEL sel_initWithTitle;
SEL sel_itemArray;
SEL sel_length;
SEL sel_mainMenu;
SEL sel_nextObject;
SEL sel_objectEnumerator;
SEL sel_objectForKey;
SEL sel_poseAsClass;
SEL sel_processInfo;
SEL sel_processName;
SEL sel_rangeOfString;
SEL sel_release;
SEL sel_run;
SEL sel_setAppleMenu;
SEL sel_setDelegate;
SEL sel_setKeyEquivalentModifierMask;
SEL sel_setMainMenu;
SEL sel_setSubmenu;
SEL sel_setTitle;
SEL sel_setWindowsMenu;
SEL sel_sharedApplication;
SEL sel_sizeToFit;
SEL sel_stringByAppendingString;
SEL sel_submenu;
SEL sel_title;
SEL sel_UTF8String;
SEL sel_separatorItem;
SEL sel_stop;
SEL sel_terminate;
SEL sel_setupWorkingDirectory;
version (SDL_USE_NIB_FILE) SEL sel_fixMenu;
SEL sel_application;
SEL sel_applicationDidFinishLaunching;
SEL sel_initWithTitle_action_keyEquivalent;

static this ()
{
    class_NSApplication = objc_getClass!("NSApplication");
    class_NSAutoreleasePool = objc_getClass!("NSAutoreleasePool");
    class_NSDictionary = objc_getClass!("NSDictionary");
    class_NSEnumerator = objc_getClass!("NSEnumerator");
    class_NSGeometry = objc_getClass!("NSGeometry");
    class_NSMenu = objc_getClass!("NSMenu");
    class_NSMenuItem = objc_getClass!("NSMenuItem");
    class_NSNotification = objc_getClass!("NSNotification");
    class_NSObject = objc_getClass!("NSObject");
    class_NSProcessInfo = objc_getClass!("NSProcessInfo");
    class_NSString = objc_getClass!("NSString");

    sel_stringWithCharacters_length = sel_registerName!("stringWithCharacters:length:");
    sel_addItem = sel_registerName!("addItem:");
    sel_addItemWithTitle_action_keyEquivalent = sel_registerName!("addItemWithTitle:action:keyEquivalent:");
    sel_alloc = sel_registerName!("alloc");
    sel_class = sel_registerName!("class");
    sel_getCharacters_range = sel_registerName!("getCharacters:range:");
    sel_hasSubmenu = sel_registerName!("hasSubmenu");
    sel_init = sel_registerName!("init");
    sel_initWithTitle = sel_registerName!("initWithTitle:");
    sel_itemArray = sel_registerName!("itemArray");
    sel_length = sel_registerName!("length");
    sel_mainMenu = sel_registerName!("mainMenu");
    sel_nextObject = sel_registerName!("nextObject");
    sel_objectEnumerator = sel_registerName!("objectEnumerator");
    sel_objectForKey = sel_registerName!("objectForKey:");
    sel_poseAsClass = sel_registerName!("poseAsClass:");
    sel_processInfo = sel_registerName!("processInfo");
    sel_processName = sel_registerName!("processName");
    sel_rangeOfString = sel_registerName!("rangeOfString");
    sel_release = sel_registerName!("release");
    sel_run = sel_registerName!("run");
    sel_setAppleMenu = sel_registerName!("setAppleMenu:");
    sel_setDelegate = sel_registerName!("setDelegate:");
    sel_setKeyEquivalentModifierMask = sel_registerName!("setKeyEquivalentModifierMask:");
    sel_setMainMenu = sel_registerName!("setMainMenu:");
    sel_setSubmenu = sel_registerName!("setSubmenu:");
    sel_setTitle = sel_registerName!("setTitle:");
    sel_setWindowsMenu = sel_registerName!("setWindowsMenu:");
    sel_sharedApplication = sel_registerName!("sharedApplication");
    sel_sizeToFit = sel_registerName!("sizeToFit");
    sel_stringByAppendingString = sel_registerName!("stringByAppendingString:");
    sel_submenu = sel_registerName!("submenu");
    sel_title = sel_registerName!("title");
    sel_UTF8String = sel_registerName!("UTF8String");
    sel_separatorItem = sel_registerName!("separatorItem");
    sel_stop = sel_registerName!("stop:");
    sel_terminate = sel_registerName!("terminate:");
    sel_setupWorkingDirectory = sel_registerName!("setupWorkingDirectory");
    version (SDL_USE_NIB_FILE) sel_fixMenu = sel_registerName!("fixMenu");
    sel_application = sel_registerName!("application:openFile:");
    sel_applicationDidFinishLaunching = sel_registerName!("applicationDidFinishLaunching:");
    sel_initWithTitle_action_keyEquivalent = sel_registerName!("initWithTitle:action:keyEquivalent:");
}