/*
 * This file was automatically generated by EvoSuite
 * Fri Jun 08 20:06:34 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.StringWriter;
import java.nio.CharBuffer;
import java.util.NoSuchElementException;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.biojava.bio.seq.homol.SimilarityPairFeature;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.BioJavaSequence;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.plot.CumulativeATSkewAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.SequenceChangeListener;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class CumulativeATSkewAlgorithm_ESTest extends CumulativeATSkewAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      byte[] byteArray0 = new byte[8];
      byteArray0[0] = (byte)86;
      byteArray0[1] = (byte)123;
      byteArray0[2] = (byte)0;
      byteArray0[3] = (byte) (-84);
      byteArray0[4] = (byte)112;
      byteArray0[5] = (byte)10;
      byteArray0[6] = (byte) (-83);
      byteArray0[7] = (byte) (-83);
      FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("internal error (feature key change may have been lost) - unexpected exception: ");
      Bases bases0 = new Bases(emblStreamSequence0);
      bases0.reverseComplement();
      Strand strand0 = bases0.getForwardStrand();
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      cumulativeATSkewAlgorithm0.getDefaultMaxWindowSize();
      cumulativeATSkewAlgorithm0.getDefaultWindowSize();
      cumulativeATSkewAlgorithm0.getMinimumInternal();
      cumulativeATSkewAlgorithm0.getDefaultMinWindowSize();
      cumulativeATSkewAlgorithm0.getDefaultStepSize(0);
      float[] floatArray0 = new float[7];
      floatArray0[0] = (float) 1;
      floatArray0[1] = 1762.1F;
      floatArray0[2] = (float) (byte)86;
      floatArray0[3] = (float) (byte)112;
      floatArray0[4] = (float) 5;
      floatArray0[5] = (float) 5;
      floatArray0[6] = (float) (byte)123;
      cumulativeATSkewAlgorithm0.getValues(0, 1, floatArray0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("`FDaeqG,J mcW");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      cumulativeATSkewAlgorithm0.getMinimumInternal();
      cumulativeATSkewAlgorithm0.getAverage();
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      byte[] byteArray0 = new byte[8];
      byteArray0[0] = (byte)86;
      byteArray0[1] = (byte)123;
      byteArray0[2] = (byte)86;
      byteArray0[3] = (byte) (-84);
      byteArray0[4] = (byte)112;
      byteArray0[5] = (byte)7;
      byteArray0[6] = (byte) (-83);
      byte byte0 = (byte) (-8);
      byteArray0[7] = (byte) (-8);
      boolean boolean0 = FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      assertEquals(8, byteArray0.length);
      assertFalse(boolean0);
      assertArrayEquals(new byte[] {(byte)86, (byte)123, (byte)86, (byte) (-84), (byte)112, (byte)7, (byte) (-83), (byte) (-8)}, byteArray0);
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("internal error (feature key change may have been lost) - unexpected exception: ");
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(79, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(79, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertNotNull(bases0);
      
      bases0.removeSequenceChangeListener((SequenceChangeListener) null);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(79, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(65, emblStreamSequence0.getOtherCount());
      
      bases0.reverseComplement();
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNotNull(strand0);
      
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNotNull(cumulativeATSkewAlgorithm0);
      
      Integer integer0 = cumulativeATSkewAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5000, (int)integer0);
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNotNull(integer0);
      
      Integer integer1 = cumulativeATSkewAlgorithm0.getDefaultWindowSize();
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(60, (int)integer1);
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNotNull(integer1);
      assertFalse(integer1.equals((Object)integer0));
      
      float[] floatArray0 = new float[5];
      floatArray0[0] = (float) (-5);
      floatArray0[1] = 1.0F;
      floatArray0[2] = (float) (byte)7;
      floatArray0[3] = (float) 1;
      floatArray0[4] = (float) (byte) (-8);
      // Undeclared exception!
      cumulativeATSkewAlgorithm0.getValues((byte)112, 8713, floatArray0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      byte[] byteArray0 = new byte[8];
      byteArray0[0] = (byte)86;
      byteArray0[1] = (byte)123;
      byteArray0[2] = (byte)0;
      byteArray0[3] = (byte) (-84);
      byteArray0[4] = (byte)112;
      byteArray0[5] = (byte)10;
      byteArray0[6] = (byte) (-83);
      byteArray0[7] = (byte) (-8);
      boolean boolean0 = FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      assertEquals(8, byteArray0.length);
      assertFalse(boolean0);
      assertArrayEquals(new byte[] {(byte)86, (byte)123, (byte)0, (byte) (-84), (byte)112, (byte)10, (byte) (-83), (byte) (-8)}, byteArray0);
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("internal error (feature key change may have been lost) - unexpected exception: ");
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNotNull(bases0);
      
      bases0.reverseComplement();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertNotNull(strand0);
      
      emblStreamSequence0.setFromChar(bases0.letter_index);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(5, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(5, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertNotNull(cumulativeATSkewAlgorithm0);
      
      Integer integer0 = cumulativeATSkewAlgorithm0.getDefaultMaxWindowSize();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5000, (int)integer0);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(5, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertNotNull(integer0);
      
      Integer integer1 = cumulativeATSkewAlgorithm0.getDefaultWindowSize();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(60, (int)integer1);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(5, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertNotNull(integer1);
      assertFalse(integer1.equals((Object)integer0));
      
      Float float0 = cumulativeATSkewAlgorithm0.getMinimumInternal();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals((-1.0F), (float)float0, 0.01F);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(5, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertNotNull(float0);
      
      float[] floatArray0 = new float[5];
      floatArray0[0] = (float) (byte) (-84);
      floatArray0[1] = (float) (byte)86;
      cumulativeATSkewAlgorithm0.setRevCompDisplay(false);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(5, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      
      floatArray0[2] = (float) (byte)86;
      floatArray0[3] = (float) (byte)0;
      floatArray0[4] = (float) (byte)10;
      cumulativeATSkewAlgorithm0.getValues(1, 10, floatArray0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, floatArray0.length);
      assertArrayEquals(new float[] {0.0F, 86.0F, 86.0F, 0.0F, 10.0F}, floatArray0, 0.01F);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(5, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      
      Integer integer2 = cumulativeATSkewAlgorithm0.getDefaultStepSize(10);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(5, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertNull(integer2);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      char[] charArray0 = new char[6];
      charArray0[0] = '*';
      charArray0[1] = 'B';
      charArray0[2] = 'A';
      charArray0[3] = 'e';
      charArray0[4] = 'D';
      charArray0[5] = '}';
      Short short0 = new Short((short)80);
      assertEquals((short)80, (short)short0);
      assertNotNull(short0);
      
      Integer integer0 = GVTAttributedCharacterIterator.TextAttribute.ARABIC_NONE;
      assertEquals(0, (int)integer0);
      assertNotNull(integer0);
      
      PartialSequence partialSequence0 = new PartialSequence(charArray0, (-1633), (-1633), short0, integer0);
      assertEquals(6, charArray0.length);
      assertArrayEquals(new char[] {'*', 'B', 'A', 'e', 'D', '}'}, charArray0);
      assertEquals(0, partialSequence0.getGCount());
      assertEquals((short)80, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(6, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((-1633), partialSequence0.length());
      assertEquals(0, (int)partialSequence0.getPhase());
      assertNotNull(partialSequence0);
      
      Bases bases0 = new Bases(partialSequence0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(6, charArray0.length);
      assertArrayEquals(new char[] {'*', 'B', 'A', 'e', 'D', '}'}, charArray0);
      assertEquals(0, partialSequence0.getGCount());
      assertEquals((short)80, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(6, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((-1633), partialSequence0.length());
      assertEquals(0, (int)partialSequence0.getPhase());
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(6, charArray0.length);
      assertArrayEquals(new char[] {'*', 'B', 'A', 'e', 'D', '}'}, charArray0);
      assertEquals(0, partialSequence0.getGCount());
      assertEquals((short)80, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(6, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((-1633), partialSequence0.length());
      assertEquals(0, (int)partialSequence0.getPhase());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      Marker marker0 = strand0.makeMarker(2);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(6, charArray0.length);
      assertArrayEquals(new char[] {'*', 'B', 'A', 'e', 'D', '}'}, charArray0);
      assertEquals(0, partialSequence0.getGCount());
      assertEquals((short)80, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(6, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((-1633), partialSequence0.length());
      assertEquals(0, (int)partialSequence0.getPhase());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, marker0.getPosition());
      assertNotNull(marker0);
      
      Strand strand1 = marker0.getStrand();
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(6, charArray0.length);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertArrayEquals(new char[] {'*', 'B', 'A', 'e', 'D', '}'}, charArray0);
      assertEquals(0, partialSequence0.getGCount());
      assertEquals((short)80, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(6, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((-1633), partialSequence0.length());
      assertEquals(0, (int)partialSequence0.getPhase());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, marker0.getPosition());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertNotNull(strand1);
      
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand1);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(6, charArray0.length);
      assertArrayEquals(new char[] {'*', 'B', 'A', 'e', 'D', '}'}, charArray0);
      assertEquals(0, partialSequence0.getGCount());
      assertEquals((short)80, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(6, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((-1633), partialSequence0.length());
      assertEquals(0, (int)partialSequence0.getPhase());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, marker0.getPosition());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertNotNull(cumulativeATSkewAlgorithm0);
      
      // Undeclared exception!
      try { 
        cumulativeATSkewAlgorithm0.getValues(4947, 1, (float[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.CumulativeATSkewAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("0l?x^Hm(>y0");
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(11, genbankStreamSequence0.getOtherCount());
      assertNotNull(genbankStreamSequence0);
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(11, genbankStreamSequence0.getOtherCount());
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(11, genbankStreamSequence0.getOtherCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      Bases bases1 = strand0.getBases();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(11, genbankStreamSequence0.getOtherCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(bases1);
      
      Strand strand1 = bases1.getReverseStrand();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(11, genbankStreamSequence0.getOtherCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertNotNull(strand1);
      assertFalse(strand1.equals((Object)strand0));
      
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand1);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(11, genbankStreamSequence0.getOtherCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(cumulativeATSkewAlgorithm0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      float[] floatArray0 = new float[0];
      // Undeclared exception!
      try { 
        cumulativeATSkewAlgorithm0.getValues(97, 0, floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 0
         //
         verifyException("uk.ac.sanger.artemis.plot.CumulativeATSkewAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      byte[] byteArray0 = new byte[8];
      byteArray0[0] = (byte)86;
      byteArray0[1] = (byte)123;
      byteArray0[2] = (byte)0;
      byteArray0[3] = (byte) (-84);
      byteArray0[4] = (byte)112;
      byteArray0[5] = (byte)10;
      byteArray0[6] = (byte) (-83);
      byteArray0[7] = (byte) (-8);
      boolean boolean0 = FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      assertEquals(8, byteArray0.length);
      assertFalse(boolean0);
      assertArrayEquals(new byte[] {(byte)86, (byte)123, (byte)0, (byte) (-84), (byte)112, (byte)10, (byte) (-83), (byte) (-8)}, byteArray0);
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("internal error (feature key change may have been lost) - unexpected exception: ");
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertNotNull(bases0);
      
      bases0.reverseComplement();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertNotNull(strand0);
      
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(cumulativeATSkewAlgorithm0);
      
      Integer integer0 = cumulativeATSkewAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(5000, (int)integer0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(integer0);
      
      Integer integer1 = cumulativeATSkewAlgorithm0.getDefaultWindowSize();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(60, (int)integer1);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(integer1);
      assertFalse(integer1.equals((Object)integer0));
      
      Float float0 = cumulativeATSkewAlgorithm0.getMinimumInternal();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals((-1.0F), (float)float0, 0.01F);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(float0);
      
      float[] floatArray0 = new float[5];
      floatArray0[0] = (float) (byte) (-84);
      floatArray0[1] = (float) (byte)86;
      cumulativeATSkewAlgorithm0.setRevCompDisplay(false);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      
      floatArray0[2] = (float) (byte)86;
      floatArray0[3] = (float) (byte)0;
      floatArray0[4] = (float) (byte)10;
      cumulativeATSkewAlgorithm0.getValues(1, 10, floatArray0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(5, floatArray0.length);
      assertArrayEquals(new float[] {2.0F, 86.0F, 86.0F, 0.0F, 10.0F}, floatArray0, 0.01F);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      
      Integer integer2 = cumulativeATSkewAlgorithm0.getDefaultStepSize(10);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertNull(integer2);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNotNull(genbankStreamSequence0);
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertNotNull(strand0);
      
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(cumulativeATSkewAlgorithm0);
      
      cumulativeATSkewAlgorithm0.setRevCompDisplay(false);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      
      Integer integer0 = cumulativeATSkewAlgorithm0.getDefaultWindowSize();
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(60, (int)integer0);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(integer0);
      
      Float float0 = cumulativeATSkewAlgorithm0.getMinimumInternal();
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals((-1.0F), (float)float0, 0.01F);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(float0);
      
      int int0 = cumulativeATSkewAlgorithm0.getValueCount();
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, int0);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      
      int int1 = cumulativeATSkewAlgorithm0.getValueCount();
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, int1);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertTrue(int1 == int0);
      
      Integer integer1 = cumulativeATSkewAlgorithm0.getDefaultWindowSize();
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(60, (int)integer1);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(integer1);
      assertFalse(integer1.equals((Object)int1));
      assertTrue(integer1.equals((Object)integer0));
      assertFalse(integer1.equals((Object)int0));
      
      cumulativeATSkewAlgorithm0.setScalingFlag(false);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      
      boolean boolean0 = FileSystemHandling.shouldAllThrowIOExceptions();
      assertTrue(boolean0);
      
      cumulativeATSkewAlgorithm0.setUserMax((-278.0F));
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals((-278.0F), cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      
      Float float1 = cumulativeATSkewAlgorithm0.getMaximumInternal();
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1.0F, (float)float1, 0.01F);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals((-278.0F), cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(float1);
      assertNotEquals((float)float1, (float)float0, 0.01F);
      
      Integer integer2 = cumulativeATSkewAlgorithm0.getDefaultStepSize(60);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(6, (int)integer2);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals((-278.0F), cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(integer2);
      assertFalse(integer2.equals((Object)integer0));
      assertFalse(integer2.equals((Object)int0));
      assertFalse(integer2.equals((Object)int1));
      assertFalse(integer2.equals((Object)integer1));
      
      Float float2 = cumulativeATSkewAlgorithm0.getAverage();
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0.0F, (float)float2, 0.01F);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals((-278.0F), cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(float2);
      assertNotEquals((float)float2, (float)float1, 0.01F);
      assertNotEquals((float)float2, (float)float0, 0.01F);
      
      Integer integer3 = cumulativeATSkewAlgorithm0.getDefaultStepSize(1);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals((-278.0F), cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertNull(integer3);
      
      float[] floatArray0 = new float[4];
      floatArray0[0] = (-278.0F);
      floatArray0[1] = (float) 5;
      floatArray0[2] = (float) 60;
      floatArray0[3] = (float) (-2244);
      cumulativeATSkewAlgorithm0.getValues((-1389), (-2244), floatArray0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(4, floatArray0.length);
      assertArrayEquals(new float[] {0.0F, 5.0F, 60.0F, (-2244.0F)}, floatArray0, 0.01F);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals((-278.0F), cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      
      Float float3 = cumulativeATSkewAlgorithm0.getMinimumInternal();
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals((-1.0F), (float)float3, 0.01F);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals((-278.0F), cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(float3);
      assertNotEquals((float)float3, (float)float2, 0.01F);
      assertEquals((float)float3, (float)float0, 0.01F);
      assertNotEquals((float)float3, (float)float1, 0.01F);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("internal error - unexpected exception: ", "internal error - unexpected exception: ");
      assertEquals(33, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(2, fastaStreamSequence0.getCCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(39, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(33, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(2, fastaStreamSequence0.getCCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(39, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(33, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(2, fastaStreamSequence0.getCCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(39, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(33, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(2, fastaStreamSequence0.getCCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(39, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(cumulativeATSkewAlgorithm0);
      
      Integer integer0 = cumulativeATSkewAlgorithm0.getDefaultMaxWindowSize();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(5000, (int)integer0);
      assertEquals(33, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(2, fastaStreamSequence0.getCCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(39, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(integer0);
      
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("start position is greater than end position: ");
      assertEquals(45, rawStreamSequence0.length());
      assertEquals(3, rawStreamSequence0.getACount());
      assertEquals(1, rawStreamSequence0.getGCount());
      assertEquals(6, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(35, rawStreamSequence0.getOtherCount());
      assertNotNull(rawStreamSequence0);
      
      Bases bases1 = new Bases(rawStreamSequence0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(45, rawStreamSequence0.length());
      assertEquals(3, rawStreamSequence0.getACount());
      assertEquals(1, rawStreamSequence0.getGCount());
      assertEquals(6, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(35, rawStreamSequence0.getOtherCount());
      assertNotNull(bases1);
      assertFalse(bases1.equals((Object)bases0));
      
      Strand strand1 = bases1.getForwardStrand();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(45, rawStreamSequence0.length());
      assertEquals(3, rawStreamSequence0.getACount());
      assertEquals(1, rawStreamSequence0.getGCount());
      assertEquals(6, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(35, rawStreamSequence0.getOtherCount());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertNotNull(strand1);
      assertFalse(bases1.equals((Object)bases0));
      assertFalse(strand1.equals((Object)strand0));
      
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm1 = new CumulativeATSkewAlgorithm(strand1);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(45, rawStreamSequence0.length());
      assertEquals(3, rawStreamSequence0.getACount());
      assertEquals(1, rawStreamSequence0.getGCount());
      assertEquals(6, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(35, rawStreamSequence0.getOtherCount());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertFalse(cumulativeATSkewAlgorithm1.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm1.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm1.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm1.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm1.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm1.isUserMaxMin());
      assertEquals("at_skew", cumulativeATSkewAlgorithm1.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm1.scalingFlag());
      assertNotNull(cumulativeATSkewAlgorithm1);
      assertFalse(bases1.equals((Object)bases0));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(cumulativeATSkewAlgorithm1.equals((Object)cumulativeATSkewAlgorithm0));
      
      Float float0 = cumulativeATSkewAlgorithm1.getAverage();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertNotSame(cumulativeATSkewAlgorithm1, cumulativeATSkewAlgorithm0);
      assertEquals((-0.33333334F), (float)float0, 0.01F);
      assertEquals(45, rawStreamSequence0.length());
      assertEquals(3, rawStreamSequence0.getACount());
      assertEquals(1, rawStreamSequence0.getGCount());
      assertEquals(6, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(35, rawStreamSequence0.getOtherCount());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertFalse(cumulativeATSkewAlgorithm1.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm1.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm1.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm1.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm1.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm1.isUserMaxMin());
      assertEquals("at_skew", cumulativeATSkewAlgorithm1.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm1.scalingFlag());
      assertNotNull(float0);
      assertFalse(bases1.equals((Object)bases0));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(cumulativeATSkewAlgorithm1.equals((Object)cumulativeATSkewAlgorithm0));
      
      StringWriter stringWriter0 = new StringWriter(0);
      assertEquals("", stringWriter0.toString());
      assertNotNull(stringWriter0);
      
      StringWriter stringWriter1 = stringWriter0.append('s');
      assertSame(stringWriter0, stringWriter1);
      assertSame(stringWriter1, stringWriter0);
      assertEquals("s", stringWriter0.toString());
      assertEquals("s", stringWriter1.toString());
      assertNotNull(stringWriter1);
      
      CharBuffer charBuffer0 = CharBuffer.allocate(0);
      assertEquals(0, charBuffer0.remaining());
      assertFalse(charBuffer0.isReadOnly());
      assertEquals(0, charBuffer0.arrayOffset());
      assertEquals(0, charBuffer0.length());
      assertEquals(0, charBuffer0.limit());
      assertFalse(charBuffer0.hasRemaining());
      assertEquals("", charBuffer0.toString());
      assertEquals(0, charBuffer0.position());
      assertFalse(charBuffer0.isDirect());
      assertEquals(0, charBuffer0.capacity());
      assertTrue(charBuffer0.hasArray());
      assertNotNull(charBuffer0);
      
      float[] floatArray0 = new float[9];
      floatArray0[0] = (float) 's';
      floatArray0[2] = (float) 0;
      floatArray0[3] = (float) 's';
      floatArray0[5] = (float) 's';
      floatArray0[6] = (float) 0;
      floatArray0[8] = (float) 0;
      Integer integer1 = cumulativeATSkewAlgorithm1.getDefaultMinWindowSize();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertNotSame(cumulativeATSkewAlgorithm1, cumulativeATSkewAlgorithm0);
      assertEquals(10, (int)integer1);
      assertEquals(45, rawStreamSequence0.length());
      assertEquals(3, rawStreamSequence0.getACount());
      assertEquals(1, rawStreamSequence0.getGCount());
      assertEquals(6, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(35, rawStreamSequence0.getOtherCount());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertFalse(cumulativeATSkewAlgorithm1.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm1.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm1.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm1.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm1.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm1.isUserMaxMin());
      assertEquals("at_skew", cumulativeATSkewAlgorithm1.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm1.scalingFlag());
      assertNotNull(integer1);
      assertFalse(integer1.equals((Object)integer0));
      assertFalse(bases1.equals((Object)bases0));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(cumulativeATSkewAlgorithm1.equals((Object)cumulativeATSkewAlgorithm0));
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      SimilarityPairFeature.EmptyPairwiseAlignment similarityPairFeature_EmptyPairwiseAlignment0 = (SimilarityPairFeature.EmptyPairwiseAlignment)SimilarityPairFeature.EMPTY_PAIRWISE;
      assertEquals("", similarityPairFeature_EmptyPairwiseAlignment0.seqString());
      assertEquals(0, similarityPairFeature_EmptyPairwiseAlignment0.length());
      assertNotNull(similarityPairFeature_EmptyPairwiseAlignment0);
      
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence(similarityPairFeature_EmptyPairwiseAlignment0);
      assertEquals("", similarityPairFeature_EmptyPairwiseAlignment0.seqString());
      assertEquals(0, similarityPairFeature_EmptyPairwiseAlignment0.length());
      assertNotNull(bioJavaSequence0);
      
      Bases bases0 = new Bases(bioJavaSequence0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals("", similarityPairFeature_EmptyPairwiseAlignment0.seqString());
      assertEquals(0, similarityPairFeature_EmptyPairwiseAlignment0.length());
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals("", similarityPairFeature_EmptyPairwiseAlignment0.seqString());
      assertEquals(0, similarityPairFeature_EmptyPairwiseAlignment0.length());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertNotNull(strand0);
      
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals("", similarityPairFeature_EmptyPairwiseAlignment0.seqString());
      assertEquals(0, similarityPairFeature_EmptyPairwiseAlignment0.length());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertNotNull(cumulativeATSkewAlgorithm0);
      
      int int0 = cumulativeATSkewAlgorithm0.getValueCount();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, int0);
      assertEquals("", similarityPairFeature_EmptyPairwiseAlignment0.seqString());
      assertEquals(0, similarityPairFeature_EmptyPairwiseAlignment0.length());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      
      // Undeclared exception!
      try { 
        cumulativeATSkewAlgorithm0.getAverage();
        fail("Expecting exception: NoSuchElementException");
      
      } catch(NoSuchElementException e) {
         //
         // There is no parser for the empty alphabet. Attempted to retrieve token
         //
         verifyException("org.biojava.bio.symbol.EmptyAlphabet", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      byte[] byteArray0 = new byte[8];
      byteArray0[0] = (byte)121;
      byteArray0[1] = (byte)123;
      byteArray0[2] = (byte)0;
      byteArray0[3] = (byte) (-84);
      byteArray0[4] = (byte)112;
      byteArray0[5] = (byte)10;
      byteArray0[6] = (byte) (-83);
      byteArray0[7] = (byte) (-8);
      boolean boolean0 = FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      assertEquals(8, byteArray0.length);
      assertFalse(boolean0);
      assertArrayEquals(new byte[] {(byte)121, (byte)123, (byte)0, (byte) (-84), (byte)112, (byte)10, (byte) (-83), (byte) (-8)}, byteArray0);
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("internal error (feature key change may have been lost) - unexpected exception: ");
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNotNull(bases0);
      
      bases0.reverseComplement();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(7, emblStreamSequence0.getACount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertNotNull(cumulativeATSkewAlgorithm0);
      
      Integer integer0 = cumulativeATSkewAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5000, (int)integer0);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertNotNull(integer0);
      
      Integer integer1 = cumulativeATSkewAlgorithm0.getDefaultWindowSize();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(60, (int)integer1);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertNotNull(integer1);
      assertFalse(integer1.equals((Object)integer0));
      
      Float float0 = cumulativeATSkewAlgorithm0.getMinimumInternal();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals((-1.0F), (float)float0, 0.01F);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertNotNull(float0);
      
      Integer integer2 = cumulativeATSkewAlgorithm0.getDefaultStepSize(1958);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(195, (int)integer2);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertNotNull(integer2);
      assertFalse(integer2.equals((Object)integer1));
      assertFalse(integer2.equals((Object)integer0));
      
      float[] floatArray0 = new float[9];
      floatArray0[0] = 1074.6826F;
      floatArray0[1] = (float) 1;
      floatArray0[2] = (float) (-5);
      floatArray0[3] = (float) (byte) (-8);
      floatArray0[4] = (float) (-5);
      floatArray0[5] = (-2463.2F);
      floatArray0[6] = (-723.1209F);
      floatArray0[7] = (float) (byte) (-8);
      floatArray0[8] = (float) 2;
      // Undeclared exception!
      try { 
        cumulativeATSkewAlgorithm0.getValues(3733, 1, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 0 > end: -3732
         //
         verifyException("uk.ac.sanger.artemis.plot.CumulativeATSkewAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      byte[] byteArray0 = new byte[8];
      byteArray0[0] = (byte)86;
      byteArray0[1] = (byte)123;
      byteArray0[2] = (byte)0;
      byteArray0[3] = (byte) (-84);
      byteArray0[4] = (byte)112;
      byteArray0[5] = (byte)7;
      byteArray0[6] = (byte) (-83);
      byteArray0[7] = (byte) (-8);
      boolean boolean0 = FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      assertEquals(8, byteArray0.length);
      assertFalse(boolean0);
      assertArrayEquals(new byte[] {(byte)86, (byte)123, (byte)0, (byte) (-84), (byte)112, (byte)7, (byte) (-83), (byte) (-8)}, byteArray0);
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("internal error (feature key change may have been lost) - unexpected exception: ");
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(79, emblStreamSequence0.length());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(79, emblStreamSequence0.length());
      assertNotNull(bases0);
      
      bases0.removeSequenceChangeListener((SequenceChangeListener) null);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(79, emblStreamSequence0.length());
      
      bases0.reverseComplement();
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(7, emblStreamSequence0.getACount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(cumulativeATSkewAlgorithm0);
      
      Integer integer0 = cumulativeATSkewAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5000, (int)integer0);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(integer0);
      
      Integer integer1 = cumulativeATSkewAlgorithm0.getDefaultWindowSize();
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(60, (int)integer1);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(integer1);
      assertFalse(integer1.equals((Object)integer0));
      
      Float float0 = cumulativeATSkewAlgorithm0.getMinimumInternal();
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals((-1.0F), (float)float0, 0.01F);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(float0);
      
      Integer integer2 = cumulativeATSkewAlgorithm0.getDefaultStepSize((byte) (-8));
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNull(integer2);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      byte[] byteArray0 = new byte[8];
      byteArray0[0] = (byte)86;
      byteArray0[1] = (byte)123;
      byteArray0[2] = (byte)0;
      byteArray0[3] = (byte) (-84);
      byteArray0[4] = (byte)112;
      byteArray0[5] = (byte)10;
      byteArray0[6] = (byte) (-83);
      byteArray0[7] = (byte) (-8);
      boolean boolean0 = FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      assertEquals(8, byteArray0.length);
      assertFalse(boolean0);
      assertArrayEquals(new byte[] {(byte)86, (byte)123, (byte)0, (byte) (-84), (byte)112, (byte)10, (byte) (-83), (byte) (-8)}, byteArray0);
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("internal error (feature key change may have been lost) - unexpected exception: ");
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertNotNull(bases0);
      
      bases0.reverseComplement();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(cumulativeATSkewAlgorithm0);
      
      Integer integer0 = cumulativeATSkewAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5000, (int)integer0);
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(integer0);
      
      Integer integer1 = cumulativeATSkewAlgorithm0.getDefaultWindowSize();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(60, (int)integer1);
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(integer1);
      assertFalse(integer1.equals((Object)integer0));
      
      Float float0 = cumulativeATSkewAlgorithm0.getMinimumInternal();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals((-1.0F), (float)float0, 0.01F);
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(float0);
      
      float[] floatArray0 = new float[5];
      floatArray0[0] = (float) (byte) (-84);
      floatArray0[1] = (float) (byte)86;
      floatArray0[2] = (float) (byte)86;
      floatArray0[3] = (float) (byte)0;
      floatArray0[4] = (float) (byte)10;
      cumulativeATSkewAlgorithm0.getValues(1, 10, floatArray0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, floatArray0.length);
      assertArrayEquals(new float[] {2.0F, 86.0F, 86.0F, 0.0F, 10.0F}, floatArray0, 0.01F);
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      SimilarityPairFeature.EmptyPairwiseAlignment similarityPairFeature_EmptyPairwiseAlignment0 = (SimilarityPairFeature.EmptyPairwiseAlignment)SimilarityPairFeature.EMPTY_PAIRWISE;
      assertEquals(0, similarityPairFeature_EmptyPairwiseAlignment0.length());
      assertEquals("", similarityPairFeature_EmptyPairwiseAlignment0.seqString());
      assertNotNull(similarityPairFeature_EmptyPairwiseAlignment0);
      
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence(similarityPairFeature_EmptyPairwiseAlignment0);
      assertEquals(0, similarityPairFeature_EmptyPairwiseAlignment0.length());
      assertEquals("", similarityPairFeature_EmptyPairwiseAlignment0.seqString());
      assertNotNull(bioJavaSequence0);
      
      Bases bases0 = new Bases(bioJavaSequence0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(0, similarityPairFeature_EmptyPairwiseAlignment0.length());
      assertEquals("", similarityPairFeature_EmptyPairwiseAlignment0.seqString());
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, similarityPairFeature_EmptyPairwiseAlignment0.length());
      assertEquals("", similarityPairFeature_EmptyPairwiseAlignment0.seqString());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, similarityPairFeature_EmptyPairwiseAlignment0.length());
      assertEquals("", similarityPairFeature_EmptyPairwiseAlignment0.seqString());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertNotNull(cumulativeATSkewAlgorithm0);
      
      int int0 = cumulativeATSkewAlgorithm0.getValueCount();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, int0);
      assertEquals(0, similarityPairFeature_EmptyPairwiseAlignment0.length());
      assertEquals("", similarityPairFeature_EmptyPairwiseAlignment0.seqString());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      
      float[] floatArray0 = new float[8];
      floatArray0[0] = (float) 0;
      floatArray0[1] = (float) 1;
      floatArray0[2] = (float) 2;
      floatArray0[3] = (float) 1;
      floatArray0[4] = (float) 1;
      floatArray0[5] = (float) 2;
      floatArray0[6] = (float) 2;
      floatArray0[7] = (float) (-5);
      cumulativeATSkewAlgorithm0.getValues(5, (-5), floatArray0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(8, floatArray0.length);
      assertArrayEquals(new float[] {0.0F, 1.0F, 2.0F, 1.0F, 1.0F, 2.0F, 2.0F, (-5.0F)}, floatArray0, 0.01F);
      assertEquals(0, similarityPairFeature_EmptyPairwiseAlignment0.length());
      assertEquals("", similarityPairFeature_EmptyPairwiseAlignment0.seqString());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      
      Integer integer0 = cumulativeATSkewAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5000, (int)integer0);
      assertEquals(0, similarityPairFeature_EmptyPairwiseAlignment0.length());
      assertEquals("", similarityPairFeature_EmptyPairwiseAlignment0.seqString());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertNotNull(integer0);
      assertFalse(integer0.equals((Object)int0));
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      byte[] byteArray0 = new byte[8];
      byteArray0[0] = (byte)86;
      byteArray0[1] = (byte) (-105);
      byteArray0[2] = (byte)0;
      byteArray0[3] = (byte) (-84);
      byteArray0[4] = (byte)112;
      byteArray0[5] = (byte)10;
      byteArray0[6] = (byte) (-83);
      byteArray0[7] = (byte) (-8);
      boolean boolean0 = FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      assertEquals(8, byteArray0.length);
      assertFalse(boolean0);
      assertArrayEquals(new byte[] {(byte)86, (byte) (-105), (byte)0, (byte) (-84), (byte)112, (byte)10, (byte) (-83), (byte) (-8)}, byteArray0);
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("internal error (feature key change may have been lost) - unexpected exception: ");
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertNotNull(bases0);
      
      bases0.reverseComplement();
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(cumulativeATSkewAlgorithm0);
      
      Integer integer0 = cumulativeATSkewAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5000, (int)integer0);
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(integer0);
      
      Integer integer1 = cumulativeATSkewAlgorithm0.getDefaultWindowSize();
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(60, (int)integer1);
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(integer1);
      assertFalse(integer1.equals((Object)integer0));
      
      Float float0 = cumulativeATSkewAlgorithm0.getMinimumInternal();
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals((-1.0F), (float)float0, 0.01F);
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(float0);
      
      Float float1 = cumulativeATSkewAlgorithm0.getMaximumInternal();
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1.0F, (float)float1, 0.01F);
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(float1);
      assertNotEquals((float)float1, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      byte[] byteArray0 = new byte[8];
      byteArray0[0] = (byte)86;
      byteArray0[1] = (byte)123;
      byteArray0[2] = (byte)0;
      byteArray0[3] = (byte) (-84);
      byteArray0[4] = (byte)112;
      byteArray0[5] = (byte)10;
      byteArray0[6] = (byte) (-83);
      byteArray0[7] = (byte) (-8);
      boolean boolean0 = FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      assertEquals(8, byteArray0.length);
      assertFalse(boolean0);
      assertArrayEquals(new byte[] {(byte)86, (byte)123, (byte)0, (byte) (-84), (byte)112, (byte)10, (byte) (-83), (byte) (-8)}, byteArray0);
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("internal error (feature key change may have been lost) - unexpected exception: ");
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertNotNull(bases0);
      
      bases0.reverseComplement();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertNotNull(cumulativeATSkewAlgorithm0);
      
      Range range0 = new Range((byte) (-83), (byte)86);
      assertEquals(170, range0.getCount());
      assertEquals(86, range0.getEnd());
      assertEquals((-83), range0.getStart());
      assertNotNull(range0);
      
      String string0 = strand0.getRawSubSequence(range0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@nnnnnanngnnnhnagnnnnnannnnasnnnnnnvnnbtdnrtknncntdgnrnmnnyaatnnnnynyynnntnynann@@@@@@@", string0);
      assertEquals(170, range0.getCount());
      assertEquals(86, range0.getEnd());
      assertEquals((-83), range0.getStart());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(string0);
      
      Integer integer0 = cumulativeATSkewAlgorithm0.getDefaultMaxWindowSize();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5000, (int)integer0);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertNotNull(integer0);
      
      Integer integer1 = cumulativeATSkewAlgorithm0.getDefaultWindowSize();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(60, (int)integer1);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertNotNull(integer1);
      assertFalse(integer1.equals((Object)integer0));
      
      Float float0 = cumulativeATSkewAlgorithm0.getAverage();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0.16666667F, (float)float0, 0.01F);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertNotNull(float0);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      byte[] byteArray0 = new byte[8];
      byteArray0[0] = (byte)86;
      byteArray0[1] = (byte)123;
      byteArray0[2] = (byte)0;
      byteArray0[3] = (byte) (-84);
      byteArray0[4] = (byte)112;
      byteArray0[5] = (byte)10;
      byteArray0[6] = (byte) (-83);
      byteArray0[7] = (byte) (-8);
      boolean boolean0 = FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      assertEquals(8, byteArray0.length);
      assertFalse(boolean0);
      assertArrayEquals(new byte[] {(byte)86, (byte)123, (byte)0, (byte) (-84), (byte)112, (byte)10, (byte) (-83), (byte) (-8)}, byteArray0);
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("internal error (feature key change may have been lost) - unexpected exception: ");
      assertEquals(79, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(79, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(5, emblStreamSequence0.getACount());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNotNull(bases0);
      
      bases0.reverseComplement();
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(79, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(79, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertNotNull(strand0);
      
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(79, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertNotNull(cumulativeATSkewAlgorithm0);
      
      Integer integer0 = cumulativeATSkewAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5000, (int)integer0);
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(79, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertNotNull(integer0);
      
      Integer integer1 = cumulativeATSkewAlgorithm0.getDefaultWindowSize();
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(60, (int)integer1);
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(79, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertNotNull(integer1);
      assertFalse(integer1.equals((Object)integer0));
      
      Float float0 = cumulativeATSkewAlgorithm0.getMinimumInternal();
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals((-1.0F), (float)float0, 0.01F);
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(79, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertNotNull(float0);
      
      Integer integer2 = cumulativeATSkewAlgorithm0.getDefaultMinWindowSize();
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(10, (int)integer2);
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(79, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertNotNull(integer2);
      assertFalse(integer2.equals((Object)integer1));
      assertFalse(integer2.equals((Object)integer0));
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("r5(s:3'Zd6");
      assertEquals(10, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(10, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getACount());
      assertNotNull(rawStreamSequence0);
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(10, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(10, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getACount());
      assertNotNull(bases0);
      
      boolean boolean0 = FileSystemHandling.appendLineToFile((EvoSuiteFile) null, "");
      assertFalse(boolean0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(10, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(10, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getACount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertNotNull(strand0);
      
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(10, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(10, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getACount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertNotNull(cumulativeATSkewAlgorithm0);
      
      Float float0 = cumulativeATSkewAlgorithm0.getAverage();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0.0F, (float)float0, 0.01F);
      assertEquals(10, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(10, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getACount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertNotNull(float0);
      
      Float float1 = cumulativeATSkewAlgorithm0.getAverage();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0.0F, (float)float1, 0.01F);
      assertEquals(10, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(10, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getACount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertNotNull(float1);
      assertEquals((float)float1, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = null;
      try {
        cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNotNull(genbankStreamSequence0);
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertNotNull(cumulativeATSkewAlgorithm0);
      
      cumulativeATSkewAlgorithm0.setRevCompDisplay(false);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      
      int int0 = cumulativeATSkewAlgorithm0.getValueCount();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, int0);
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      
      int int1 = cumulativeATSkewAlgorithm0.getValueCount();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, int1);
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertTrue(int1 == int0);
      
      Integer integer0 = cumulativeATSkewAlgorithm0.getDefaultWindowSize();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(60, (int)integer0);
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertNotNull(integer0);
      assertFalse(integer0.equals((Object)int0));
      assertFalse(integer0.equals((Object)int1));
      
      boolean boolean0 = FileSystemHandling.shouldAllThrowIOExceptions();
      assertTrue(boolean0);
      
      cumulativeATSkewAlgorithm0.setUserMax((-278.0F));
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals((-278.0F), cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      
      Float float0 = cumulativeATSkewAlgorithm0.getMaximumInternal();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1.0F, (float)float0, 0.01F);
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals((-278.0F), cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertNotNull(float0);
      
      Integer integer1 = cumulativeATSkewAlgorithm0.getDefaultStepSize(60);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(6, (int)integer1);
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals((-278.0F), cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertNotNull(integer1);
      assertFalse(integer1.equals((Object)int1));
      assertFalse(integer1.equals((Object)int0));
      assertFalse(integer1.equals((Object)integer0));
      
      Float float1 = cumulativeATSkewAlgorithm0.getAverage();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0.0F, (float)float1, 0.01F);
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals((-278.0F), cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertNotNull(float1);
      assertNotEquals((float)float1, (float)float0, 0.01F);
      
      Integer integer2 = cumulativeATSkewAlgorithm0.getDefaultStepSize(1);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals((-278.0F), cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertNull(integer2);
      
      Float float2 = cumulativeATSkewAlgorithm0.getMinimumInternal();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals((-1.0F), (float)float2, 0.01F);
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals((-278.0F), cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertNotNull(float2);
      assertNotEquals((float)float2, (float)float1, 0.01F);
      assertNotEquals((float)float2, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      byte[] byteArray0 = new byte[8];
      byteArray0[0] = (byte)80;
      byteArray0[1] = (byte)123;
      byteArray0[2] = (byte)0;
      byteArray0[3] = (byte) (-84);
      byteArray0[4] = (byte)123;
      byteArray0[5] = (byte)10;
      byteArray0[6] = (byte) (-92);
      byteArray0[7] = (byte) (-29);
      boolean boolean0 = FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      assertEquals(8, byteArray0.length);
      assertFalse(boolean0);
      assertArrayEquals(new byte[] {(byte)80, (byte)123, (byte)0, (byte) (-84), (byte)123, (byte)10, (byte) (-92), (byte) (-29)}, byteArray0);
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("internal error (feature key change may have been lost) - unexpected exception: ");
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(5, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(5, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(65, emblStreamSequence0.getOtherCount());
      assertNotNull(bases0);
      
      bases0.reverseComplement();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertNotNull(cumulativeATSkewAlgorithm0);
      
      Integer integer0 = cumulativeATSkewAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5000, (int)integer0);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertNotNull(integer0);
      
      Integer integer1 = cumulativeATSkewAlgorithm0.getDefaultWindowSize();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(60, (int)integer1);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertNotNull(integer1);
      assertFalse(integer1.equals((Object)integer0));
      
      Float float0 = cumulativeATSkewAlgorithm0.getMinimumInternal();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals((-1.0F), (float)float0, 0.01F);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      assertNotNull(float0);
      
      float[] floatArray0 = new float[5];
      floatArray0[1] = (float) (byte) (-84);
      floatArray0[1] = (float) (byte)80;
      floatArray0[2] = (float) (byte)80;
      floatArray0[3] = (float) (byte)0;
      cumulativeATSkewAlgorithm0.getValues(1, 11, floatArray0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, floatArray0.length);
      assertArrayEquals(new float[] {2.0F, 80.0F, 80.0F, 0.0F, 0.0F}, floatArray0, 0.01F);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
      
      cumulativeATSkewAlgorithm0.getValues(1133, 2614, floatArray0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, floatArray0.length);
      assertArrayEquals(new float[] {0.16666667F, 80.0F, 80.0F, 0.0F, 0.0F}, floatArray0, 0.01F);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getGCount());
      assertEquals(7, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(79, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(63, emblStreamSequence0.getOtherCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(3.4028235E38F, cumulativeATSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, cumulativeATSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeATSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeATSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative AT Skew, (A-T)/(A+T)", cumulativeATSkewAlgorithm0.getAlgorithmName());
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertFalse(cumulativeATSkewAlgorithm0.isRevCompDisplay());
      assertEquals("at_skew", cumulativeATSkewAlgorithm0.getAlgorithmShortName());
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      byte[] byteArray0 = new byte[8];
      byteArray0[0] = (byte)86;
      byteArray0[1] = (byte)123;
      byteArray0[2] = (byte)0;
      byteArray0[3] = (byte) (-84);
      byteArray0[4] = (byte)112;
      byteArray0[5] = (byte)10;
      byteArray0[6] = (byte) (-83);
      byteArray0[7] = (byte) (-8);
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("internal error (feature key change may have been lost) - unexpected exception: ");
      Bases bases0 = new Bases(emblStreamSequence0);
      bases0.reverseComplement();
      Strand strand0 = bases0.getForwardStrand();
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      cumulativeATSkewAlgorithm0.getDefaultMaxWindowSize();
      cumulativeATSkewAlgorithm0.getDefaultWindowSize();
      cumulativeATSkewAlgorithm0.getMinimumInternal();
      cumulativeATSkewAlgorithm0.getDefaultMinWindowSize();
      cumulativeATSkewAlgorithm0.getDefaultMinWindowSize();
      cumulativeATSkewAlgorithm0.getAverage();
      cumulativeATSkewAlgorithm0.getDefaultMinWindowSize();
      float[] floatArray0 = new float[6];
      floatArray0[0] = (float) (-5);
      floatArray0[1] = (float) 2;
      floatArray0[2] = (float) (byte)10;
      floatArray0[3] = (float) 2;
      floatArray0[4] = (float) (byte)0;
      floatArray0[5] = (float) (byte) (-83);
      // Undeclared exception!
      try { 
        cumulativeATSkewAlgorithm0.getValues((byte)86, (byte)10, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 0 > end: -76
         //
         verifyException("uk.ac.sanger.artemis.plot.CumulativeATSkewAlgorithm", e);
      }
  }
}
