/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 13:22:51 GMT 2018
 */

package uk.ac.sanger.artemis.components;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.event.AdjustmentEvent;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.ScoreChangeListener;
import uk.ac.sanger.artemis.components.ScoreScrollbar;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class ScoreScrollbar_ESTest extends ScoreScrollbar_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      ScoreScrollbar scoreScrollbar0 = new ScoreScrollbar((-602), (-602));
      ScoreChangeListener scoreChangeListener0 = mock(ScoreChangeListener.class, new ViolatedAssumptionAnswer());
      scoreScrollbar0.addScoreChangeListener(scoreChangeListener0);
      ScoreChangeListener scoreChangeListener1 = mock(ScoreChangeListener.class, new ViolatedAssumptionAnswer());
      scoreScrollbar0.addScoreChangeListener(scoreChangeListener1);
      AdjustmentEvent adjustmentEvent0 = new AdjustmentEvent(scoreScrollbar0, (-602), 0, 0);
      scoreScrollbar0.adjustmentValueChanged(adjustmentEvent0);
      assertEquals(0, adjustmentEvent0.getAdjustmentType());
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      ScoreScrollbar scoreScrollbar0 = new ScoreScrollbar((-3639), (-3639));
      scoreScrollbar0.addScoreChangeListener((ScoreChangeListener) null);
      AdjustmentEvent adjustmentEvent0 = new AdjustmentEvent(scoreScrollbar0, 0, 0, 12304, true);
      // Undeclared exception!
      try { 
        scoreScrollbar0.adjustmentValueChanged(adjustmentEvent0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.ScoreScrollbar", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      ScoreScrollbar scoreScrollbar0 = null;
      try {
        scoreScrollbar0 = new ScoreScrollbar((-15), 10, (-15), (-15));
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // orientation must be one of: VERTICAL, HORIZONTAL
         //
         verifyException("javax.swing.JScrollBar", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      ScoreScrollbar scoreScrollbar0 = new ScoreScrollbar(0, 0, 0, 0);
      assertFalse(scoreScrollbar0.isFocusTraversalPolicyProvider());
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      ScoreScrollbar scoreScrollbar0 = new ScoreScrollbar(0, 0, 82, 82);
      AdjustmentEvent adjustmentEvent0 = new AdjustmentEvent(scoreScrollbar0, 0, 0, 82);
      ScoreChangeListener scoreChangeListener0 = mock(ScoreChangeListener.class, new ViolatedAssumptionAnswer());
      scoreScrollbar0.addScoreChangeListener(scoreChangeListener0);
      scoreScrollbar0.adjustmentValueChanged(adjustmentEvent0);
      assertFalse(adjustmentEvent0.getValueIsAdjusting());
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      ScoreScrollbar scoreScrollbar0 = new ScoreScrollbar(0, 0, 82, 82);
      scoreScrollbar0.removeScoreChangeListener((ScoreChangeListener) null);
      assertFalse(scoreScrollbar0.isFocusTraversalPolicyProvider());
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      ScoreScrollbar scoreScrollbar0 = null;
      try {
        scoreScrollbar0 = new ScoreScrollbar(8918, 0);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // invalid range properties
         //
         verifyException("javax.swing.DefaultBoundedRangeModel", e);
      }
  }
}
