/*
 * Copyright (c) 2022, ARM Limited and Contributors. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <errno.h>
#include <stdint.h>
#include <string.h>

/* Using hardcoded token values for AEM FVP */
static uint8_t platform_token[] = {
	0xD2, 0x84, 0x40, 0xA0, 0x59, 0x02, 0x46, 0xA9,
	0x19, 0x01, 0x09, 0x78, 0x1C, 0x68, 0x74, 0x74,
	0x70, 0x3A, 0x2F, 0x2F, 0x61, 0x72, 0x6D, 0x2E,
	0x63, 0x6F, 0x6D, 0x2F, 0x43, 0x43, 0x41, 0x2D,
	0x53, 0x53, 0x44, 0x2F, 0x31, 0x2E, 0x30, 0x2E,
	0x30, 0x0A, 0x58, 0x20, 0x07, 0x06, 0x05, 0x04,
	0x03, 0x02, 0x01, 0x00, 0x0F, 0x0E, 0x0D, 0x0C,
	0x0B, 0x0A, 0x09, 0x08, 0x17, 0x16, 0x15, 0x14,
	0x13, 0x12, 0x11, 0x10, 0x1F, 0x1E, 0x1D, 0x1C,
	0x1B, 0x1A, 0x19, 0x18, 0x19, 0x09, 0x5C, 0x58,
	0x40, 0x7F, 0x45, 0x4C, 0x46, 0x02, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x00, 0x3E, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x50, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xA0, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x38,
	0x00, 0x09, 0x00, 0x40, 0x00, 0x1C, 0x00, 0x1B,
	0x00, 0x19, 0x01, 0x00, 0x58, 0x21, 0x01, 0x07,
	0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00, 0x0F,
	0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x17,
	0x16, 0x15, 0x14, 0x13, 0x12, 0x11, 0x10, 0x1F,
	0x1E, 0x1D, 0x1C, 0x1B, 0x1A, 0x19, 0x18, 0x19,
	0x09, 0x61, 0x58, 0x21, 0x01, 0x07, 0x06, 0x05,
	0x04, 0x03, 0x02, 0x01, 0x00, 0x0F, 0x0E, 0x0D,
	0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x17, 0x16, 0x15,
	0x14, 0x13, 0x12, 0x11, 0x10, 0x1F, 0x1E, 0x1D,
	0x1C, 0x1B, 0x1A, 0x19, 0x18, 0x19, 0x09, 0x5B,
	0x19, 0x30, 0x03, 0x19, 0x09, 0x62, 0x67, 0x73,
	0x68, 0x61, 0x2D, 0x32, 0x35, 0x36, 0x19, 0x09,
	0x5F, 0x84, 0xA5, 0x01, 0x62, 0x42, 0x4C, 0x05,
	0x58, 0x20, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02,
	0x01, 0x00, 0x0F, 0x0E, 0x0D, 0x0C, 0x0B, 0x0A,
	0x09, 0x08, 0x17, 0x16, 0x15, 0x14, 0x13, 0x12,
	0x11, 0x10, 0x1F, 0x1E, 0x1D, 0x1C, 0x1B, 0x1A,
	0x19, 0x18, 0x04, 0x65, 0x33, 0x2E, 0x34, 0x2E,
	0x32, 0x02, 0x58, 0x20, 0x07, 0x06, 0x05, 0x04,
	0x03, 0x02, 0x01, 0x00, 0x0F, 0x0E, 0x0D, 0x0C,
	0x0B, 0x0A, 0x09, 0x08, 0x17, 0x16, 0x15, 0x14,
	0x13, 0x12, 0x11, 0x10, 0x1F, 0x1E, 0x1D, 0x1C,
	0x1B, 0x1A, 0x19, 0x18, 0x06, 0x67, 0x73, 0x68,
	0x61, 0x2D, 0x32, 0x35, 0x36, 0xA4, 0x01, 0x62,
	0x4D, 0x31, 0x05, 0x58, 0x20, 0x07, 0x06, 0x05,
	0x04, 0x03, 0x02, 0x01, 0x00, 0x0F, 0x0E, 0x0D,
	0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x17, 0x16, 0x15,
	0x14, 0x13, 0x12, 0x11, 0x10, 0x1F, 0x1E, 0x1D,
	0x1C, 0x1B, 0x1A, 0x19, 0x18, 0x04, 0x63, 0x31,
	0x2E, 0x32, 0x02, 0x58, 0x20, 0x07, 0x06, 0x05,
	0x04, 0x03, 0x02, 0x01, 0x00, 0x0F, 0x0E, 0x0D,
	0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x17, 0x16, 0x15,
	0x14, 0x13, 0x12, 0x11, 0x10, 0x1F, 0x1E, 0x1D,
	0x1C, 0x1B, 0x1A, 0x19, 0x18, 0xA4, 0x01, 0x62,
	0x4D, 0x32, 0x05, 0x58, 0x20, 0x07, 0x06, 0x05,
	0x04, 0x03, 0x02, 0x01, 0x00, 0x0F, 0x0E, 0x0D,
	0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x17, 0x16, 0x15,
	0x14, 0x13, 0x12, 0x11, 0x10, 0x1F, 0x1E, 0x1D,
	0x1C, 0x1B, 0x1A, 0x19, 0x18, 0x04, 0x65, 0x31,
	0x2E, 0x32, 0x2E, 0x33, 0x02, 0x58, 0x20, 0x07,
	0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00, 0x0F,
	0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x17,
	0x16, 0x15, 0x14, 0x13, 0x12, 0x11, 0x10, 0x1F,
	0x1E, 0x1D, 0x1C, 0x1B, 0x1A, 0x19, 0x18, 0xA4,
	0x01, 0x62, 0x4D, 0x33, 0x05, 0x58, 0x20, 0x07,
	0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00, 0x0F,
	0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x17,
	0x16, 0x15, 0x14, 0x13, 0x12, 0x11, 0x10, 0x1F,
	0x1E, 0x1D, 0x1C, 0x1B, 0x1A, 0x19, 0x18, 0x04,
	0x61, 0x31, 0x02, 0x58, 0x20, 0x07, 0x06, 0x05,
	0x04, 0x03, 0x02, 0x01, 0x00, 0x0F, 0x0E, 0x0D,
	0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x17, 0x16, 0x15,
	0x14, 0x13, 0x12, 0x11, 0x10, 0x1F, 0x1E, 0x1D,
	0x1C, 0x1B, 0x1A, 0x19, 0x18, 0x19, 0x09, 0x60,
	0x6C, 0x77, 0x68, 0x61, 0x74, 0x65, 0x76, 0x65,
	0x72, 0x2E, 0x63, 0x6F, 0x6D, 0x58, 0x40, 0x84,
	0x32, 0x12, 0x5B, 0x92, 0x6B, 0x20, 0xD8, 0x14,
	0xC1, 0xC1, 0x8C, 0x3C, 0x73, 0xB8, 0x29, 0x0F,
	0x42, 0xBC, 0x0B, 0x25, 0x87, 0x5C, 0x4F, 0xA4,
	0xFA, 0xD9, 0xDE, 0xC1, 0x2B, 0x20, 0xED, 0xDF,
	0x1C, 0xDD, 0x1A, 0x09, 0xBD, 0xA0, 0x25, 0x48,
	0xC6, 0xBB, 0x99, 0xA1, 0x30, 0x4F, 0x2C, 0xDC,
	0x89, 0xE8, 0xB7, 0xFF, 0x32, 0xE9, 0x3F, 0xBB,
	0xC6, 0xBF, 0x9D, 0x38, 0x68, 0xE1, 0xB2,
};

int plat_rmmd_get_cca_attest_token(uintptr_t buf, size_t *len,
				   uintptr_t hash, size_t hash_size)
{
	(void)hash;
	(void)hash_size;

	if (*len < sizeof(platform_token)) {
		return -EINVAL;
	}

	(void)memcpy((void *)buf, platform_token, sizeof(platform_token));
	*len = sizeof(platform_token);

	return 0;
}
