// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/services/ad_group_ad_service.proto

package services // import "google.golang.org/genproto/googleapis/ads/googleads/v0/services"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import common "google.golang.org/genproto/googleapis/ads/googleads/v0/common"
import resources "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [AdGroupAdService.GetAdGroupAd][google.ads.googleads.v0.services.AdGroupAdService.GetAdGroupAd].
type GetAdGroupAdRequest struct {
	// The resource name of the ad to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAdGroupAdRequest) Reset()         { *m = GetAdGroupAdRequest{} }
func (m *GetAdGroupAdRequest) String() string { return proto.CompactTextString(m) }
func (*GetAdGroupAdRequest) ProtoMessage()    {}
func (*GetAdGroupAdRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_ad_service_f5afe93c5fff3c55, []int{0}
}
func (m *GetAdGroupAdRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAdGroupAdRequest.Unmarshal(m, b)
}
func (m *GetAdGroupAdRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAdGroupAdRequest.Marshal(b, m, deterministic)
}
func (dst *GetAdGroupAdRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAdGroupAdRequest.Merge(dst, src)
}
func (m *GetAdGroupAdRequest) XXX_Size() int {
	return xxx_messageInfo_GetAdGroupAdRequest.Size(m)
}
func (m *GetAdGroupAdRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAdGroupAdRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAdGroupAdRequest proto.InternalMessageInfo

func (m *GetAdGroupAdRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [AdGroupAdService.MutateAdGroupAds][google.ads.googleads.v0.services.AdGroupAdService.MutateAdGroupAds].
type MutateAdGroupAdsRequest struct {
	// The ID of the customer whose ads are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on individual ads.
	Operations           []*AdGroupAdOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *MutateAdGroupAdsRequest) Reset()         { *m = MutateAdGroupAdsRequest{} }
func (m *MutateAdGroupAdsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupAdsRequest) ProtoMessage()    {}
func (*MutateAdGroupAdsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_ad_service_f5afe93c5fff3c55, []int{1}
}
func (m *MutateAdGroupAdsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupAdsRequest.Unmarshal(m, b)
}
func (m *MutateAdGroupAdsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupAdsRequest.Marshal(b, m, deterministic)
}
func (dst *MutateAdGroupAdsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupAdsRequest.Merge(dst, src)
}
func (m *MutateAdGroupAdsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupAdsRequest.Size(m)
}
func (m *MutateAdGroupAdsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupAdsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupAdsRequest proto.InternalMessageInfo

func (m *MutateAdGroupAdsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateAdGroupAdsRequest) GetOperations() []*AdGroupAdOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

// A single operation (create, update, remove) on an ad group ad.
type AdGroupAdOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Configuration for how policies are validated.
	PolicyValidationParameter *common.PolicyValidationParameter `protobuf:"bytes,5,opt,name=policy_validation_parameter,json=policyValidationParameter,proto3" json:"policy_validation_parameter,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*AdGroupAdOperation_Create
	//	*AdGroupAdOperation_Update
	//	*AdGroupAdOperation_Remove
	Operation            isAdGroupAdOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *AdGroupAdOperation) Reset()         { *m = AdGroupAdOperation{} }
func (m *AdGroupAdOperation) String() string { return proto.CompactTextString(m) }
func (*AdGroupAdOperation) ProtoMessage()    {}
func (*AdGroupAdOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_ad_service_f5afe93c5fff3c55, []int{2}
}
func (m *AdGroupAdOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupAdOperation.Unmarshal(m, b)
}
func (m *AdGroupAdOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupAdOperation.Marshal(b, m, deterministic)
}
func (dst *AdGroupAdOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupAdOperation.Merge(dst, src)
}
func (m *AdGroupAdOperation) XXX_Size() int {
	return xxx_messageInfo_AdGroupAdOperation.Size(m)
}
func (m *AdGroupAdOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupAdOperation.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupAdOperation proto.InternalMessageInfo

func (m *AdGroupAdOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *AdGroupAdOperation) GetPolicyValidationParameter() *common.PolicyValidationParameter {
	if m != nil {
		return m.PolicyValidationParameter
	}
	return nil
}

type isAdGroupAdOperation_Operation interface {
	isAdGroupAdOperation_Operation()
}

type AdGroupAdOperation_Create struct {
	Create *resources.AdGroupAd `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type AdGroupAdOperation_Update struct {
	Update *resources.AdGroupAd `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type AdGroupAdOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*AdGroupAdOperation_Create) isAdGroupAdOperation_Operation() {}

func (*AdGroupAdOperation_Update) isAdGroupAdOperation_Operation() {}

func (*AdGroupAdOperation_Remove) isAdGroupAdOperation_Operation() {}

func (m *AdGroupAdOperation) GetOperation() isAdGroupAdOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *AdGroupAdOperation) GetCreate() *resources.AdGroupAd {
	if x, ok := m.GetOperation().(*AdGroupAdOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *AdGroupAdOperation) GetUpdate() *resources.AdGroupAd {
	if x, ok := m.GetOperation().(*AdGroupAdOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *AdGroupAdOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*AdGroupAdOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AdGroupAdOperation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AdGroupAdOperation_OneofMarshaler, _AdGroupAdOperation_OneofUnmarshaler, _AdGroupAdOperation_OneofSizer, []interface{}{
		(*AdGroupAdOperation_Create)(nil),
		(*AdGroupAdOperation_Update)(nil),
		(*AdGroupAdOperation_Remove)(nil),
	}
}

func _AdGroupAdOperation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AdGroupAdOperation)
	// operation
	switch x := m.Operation.(type) {
	case *AdGroupAdOperation_Create:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Create); err != nil {
			return err
		}
	case *AdGroupAdOperation_Update:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Update); err != nil {
			return err
		}
	case *AdGroupAdOperation_Remove:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Remove)
	case nil:
	default:
		return fmt.Errorf("AdGroupAdOperation.Operation has unexpected type %T", x)
	}
	return nil
}

func _AdGroupAdOperation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AdGroupAdOperation)
	switch tag {
	case 1: // operation.create
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.AdGroupAd)
		err := b.DecodeMessage(msg)
		m.Operation = &AdGroupAdOperation_Create{msg}
		return true, err
	case 2: // operation.update
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.AdGroupAd)
		err := b.DecodeMessage(msg)
		m.Operation = &AdGroupAdOperation_Update{msg}
		return true, err
	case 3: // operation.remove
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Operation = &AdGroupAdOperation_Remove{x}
		return true, err
	default:
		return false, nil
	}
}

func _AdGroupAdOperation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AdGroupAdOperation)
	// operation
	switch x := m.Operation.(type) {
	case *AdGroupAdOperation_Create:
		s := proto.Size(x.Create)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupAdOperation_Update:
		s := proto.Size(x.Update)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupAdOperation_Remove:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Remove)))
		n += len(x.Remove)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Response message for an ad group ad mutate.
type MutateAdGroupAdsResponse struct {
	// All results for the mutate.
	Results              []*MutateAdGroupAdResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *MutateAdGroupAdsResponse) Reset()         { *m = MutateAdGroupAdsResponse{} }
func (m *MutateAdGroupAdsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupAdsResponse) ProtoMessage()    {}
func (*MutateAdGroupAdsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_ad_service_f5afe93c5fff3c55, []int{3}
}
func (m *MutateAdGroupAdsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupAdsResponse.Unmarshal(m, b)
}
func (m *MutateAdGroupAdsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupAdsResponse.Marshal(b, m, deterministic)
}
func (dst *MutateAdGroupAdsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupAdsResponse.Merge(dst, src)
}
func (m *MutateAdGroupAdsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupAdsResponse.Size(m)
}
func (m *MutateAdGroupAdsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupAdsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupAdsResponse proto.InternalMessageInfo

func (m *MutateAdGroupAdsResponse) GetResults() []*MutateAdGroupAdResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the ad mutate.
type MutateAdGroupAdResult struct {
	// The resource name returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateAdGroupAdResult) Reset()         { *m = MutateAdGroupAdResult{} }
func (m *MutateAdGroupAdResult) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupAdResult) ProtoMessage()    {}
func (*MutateAdGroupAdResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_ad_service_f5afe93c5fff3c55, []int{4}
}
func (m *MutateAdGroupAdResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupAdResult.Unmarshal(m, b)
}
func (m *MutateAdGroupAdResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupAdResult.Marshal(b, m, deterministic)
}
func (dst *MutateAdGroupAdResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupAdResult.Merge(dst, src)
}
func (m *MutateAdGroupAdResult) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupAdResult.Size(m)
}
func (m *MutateAdGroupAdResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupAdResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupAdResult proto.InternalMessageInfo

func (m *MutateAdGroupAdResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetAdGroupAdRequest)(nil), "google.ads.googleads.v0.services.GetAdGroupAdRequest")
	proto.RegisterType((*MutateAdGroupAdsRequest)(nil), "google.ads.googleads.v0.services.MutateAdGroupAdsRequest")
	proto.RegisterType((*AdGroupAdOperation)(nil), "google.ads.googleads.v0.services.AdGroupAdOperation")
	proto.RegisterType((*MutateAdGroupAdsResponse)(nil), "google.ads.googleads.v0.services.MutateAdGroupAdsResponse")
	proto.RegisterType((*MutateAdGroupAdResult)(nil), "google.ads.googleads.v0.services.MutateAdGroupAdResult")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AdGroupAdServiceClient is the client API for AdGroupAdService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AdGroupAdServiceClient interface {
	// Returns the requested ad in full detail.
	GetAdGroupAd(ctx context.Context, in *GetAdGroupAdRequest, opts ...grpc.CallOption) (*resources.AdGroupAd, error)
	// Creates, updates, or removes ads. Operation statuses are returned.
	MutateAdGroupAds(ctx context.Context, in *MutateAdGroupAdsRequest, opts ...grpc.CallOption) (*MutateAdGroupAdsResponse, error)
}

type adGroupAdServiceClient struct {
	cc *grpc.ClientConn
}

func NewAdGroupAdServiceClient(cc *grpc.ClientConn) AdGroupAdServiceClient {
	return &adGroupAdServiceClient{cc}
}

func (c *adGroupAdServiceClient) GetAdGroupAd(ctx context.Context, in *GetAdGroupAdRequest, opts ...grpc.CallOption) (*resources.AdGroupAd, error) {
	out := new(resources.AdGroupAd)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.AdGroupAdService/GetAdGroupAd", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adGroupAdServiceClient) MutateAdGroupAds(ctx context.Context, in *MutateAdGroupAdsRequest, opts ...grpc.CallOption) (*MutateAdGroupAdsResponse, error) {
	out := new(MutateAdGroupAdsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.AdGroupAdService/MutateAdGroupAds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AdGroupAdServiceServer is the server API for AdGroupAdService service.
type AdGroupAdServiceServer interface {
	// Returns the requested ad in full detail.
	GetAdGroupAd(context.Context, *GetAdGroupAdRequest) (*resources.AdGroupAd, error)
	// Creates, updates, or removes ads. Operation statuses are returned.
	MutateAdGroupAds(context.Context, *MutateAdGroupAdsRequest) (*MutateAdGroupAdsResponse, error)
}

func RegisterAdGroupAdServiceServer(s *grpc.Server, srv AdGroupAdServiceServer) {
	s.RegisterService(&_AdGroupAdService_serviceDesc, srv)
}

func _AdGroupAdService_GetAdGroupAd_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAdGroupAdRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdGroupAdServiceServer).GetAdGroupAd(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.AdGroupAdService/GetAdGroupAd",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdGroupAdServiceServer).GetAdGroupAd(ctx, req.(*GetAdGroupAdRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdGroupAdService_MutateAdGroupAds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateAdGroupAdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdGroupAdServiceServer).MutateAdGroupAds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.AdGroupAdService/MutateAdGroupAds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdGroupAdServiceServer).MutateAdGroupAds(ctx, req.(*MutateAdGroupAdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AdGroupAdService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v0.services.AdGroupAdService",
	HandlerType: (*AdGroupAdServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAdGroupAd",
			Handler:    _AdGroupAdService_GetAdGroupAd_Handler,
		},
		{
			MethodName: "MutateAdGroupAds",
			Handler:    _AdGroupAdService_MutateAdGroupAds_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v0/services/ad_group_ad_service.proto",
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/services/ad_group_ad_service.proto", fileDescriptor_ad_group_ad_service_f5afe93c5fff3c55)
}

var fileDescriptor_ad_group_ad_service_f5afe93c5fff3c55 = []byte{
	// 648 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0x41, 0x6f, 0xd3, 0x30,
	0x14, 0x26, 0x2d, 0x0c, 0xcd, 0x1d, 0xd2, 0x64, 0x34, 0x11, 0x0a, 0x12, 0x55, 0xe0, 0x30, 0x95,
	0xc9, 0xae, 0xba, 0x21, 0xb4, 0x8e, 0x1d, 0xba, 0xc3, 0x3a, 0x0e, 0x83, 0x12, 0xd0, 0x0e, 0xa8,
	0x52, 0xe4, 0xd5, 0x5e, 0x14, 0x2d, 0x89, 0x83, 0xed, 0x54, 0x9a, 0xa6, 0x5d, 0x40, 0xe2, 0x8c,
	0xc4, 0x3f, 0xe0, 0x06, 0xff, 0x83, 0x0b, 0x57, 0xc4, 0x3f, 0xe0, 0x87, 0xa0, 0xc4, 0x71, 0x28,
	0xdd, 0xa2, 0xb2, 0xdd, 0x9e, 0xed, 0xf7, 0x7d, 0xef, 0xf9, 0xfb, 0xfc, 0x0c, 0x7a, 0x3e, 0xe7,
	0x7e, 0xc8, 0x30, 0xa1, 0x12, 0xeb, 0x30, 0x8b, 0x26, 0x1d, 0x2c, 0x99, 0x98, 0x04, 0x63, 0x26,
	0x31, 0xa1, 0x9e, 0x2f, 0x78, 0x9a, 0x78, 0x84, 0x7a, 0xc5, 0x26, 0x4a, 0x04, 0x57, 0x1c, 0xb6,
	0x34, 0x00, 0x11, 0x2a, 0x51, 0x89, 0x45, 0x93, 0x0e, 0x32, 0xd8, 0xe6, 0xe3, 0x2a, 0xf6, 0x31,
	0x8f, 0x22, 0x1e, 0xe3, 0x84, 0x87, 0xc1, 0xf8, 0x44, 0xd3, 0x35, 0xd7, 0xab, 0x92, 0x05, 0x93,
	0x3c, 0x15, 0x33, 0xbd, 0x14, 0xa0, 0xfb, 0x06, 0x94, 0x04, 0x98, 0xc4, 0x31, 0x57, 0x44, 0x05,
	0x3c, 0x96, 0xc5, 0x69, 0xd1, 0x21, 0xce, 0x57, 0x87, 0xe9, 0x11, 0x3e, 0x0a, 0x58, 0x48, 0xbd,
	0x88, 0xc8, 0x63, 0x9d, 0xe1, 0xf4, 0xc0, 0xed, 0x01, 0x53, 0x7d, 0x3a, 0xc8, 0x68, 0xfb, 0xd4,
	0x65, 0xef, 0x52, 0x26, 0x15, 0x7c, 0x08, 0x6e, 0x99, 0xaa, 0x5e, 0x4c, 0x22, 0x66, 0x5b, 0x2d,
	0x6b, 0x75, 0xd1, 0x5d, 0x32, 0x9b, 0x2f, 0x48, 0xc4, 0x9c, 0x4f, 0x16, 0xb8, 0xb3, 0x9f, 0x2a,
	0xa2, 0x58, 0x89, 0x97, 0x86, 0xe0, 0x01, 0x68, 0x8c, 0x53, 0xa9, 0x78, 0xc4, 0x84, 0x17, 0xd0,
	0x02, 0x0e, 0xcc, 0xd6, 0x73, 0x0a, 0xdf, 0x00, 0xc0, 0x13, 0x26, 0x74, 0xbb, 0x76, 0xad, 0x55,
	0x5f, 0x6d, 0x74, 0x37, 0xd0, 0x3c, 0x45, 0x51, 0x59, 0xe9, 0xa5, 0x01, 0xbb, 0x53, 0x3c, 0xce,
	0x87, 0x3a, 0x80, 0xe7, 0x53, 0xe0, 0x16, 0x68, 0xa4, 0x09, 0x25, 0x8a, 0xe5, 0x57, 0xb7, 0xaf,
	0xb7, 0xac, 0xd5, 0x46, 0xb7, 0x69, 0xaa, 0x19, 0x75, 0xd0, 0x6e, 0xa6, 0xce, 0x3e, 0x91, 0xc7,
	0x2e, 0xd0, 0xe9, 0x59, 0x0c, 0x4f, 0xc0, 0x3d, 0xed, 0x93, 0x37, 0x21, 0x61, 0x40, 0x73, 0x46,
	0x2f, 0x21, 0x82, 0x44, 0x4c, 0x31, 0x61, 0xdf, 0xc8, 0xc9, 0x36, 0x2b, 0x5b, 0xd7, 0x56, 0xa3,
	0x61, 0x4e, 0x71, 0x50, 0x32, 0x0c, 0x0d, 0x81, 0x7b, 0x37, 0xa9, 0x3a, 0x82, 0xbb, 0x60, 0x61,
	0x2c, 0x18, 0x51, 0x5a, 0xff, 0x46, 0x77, 0xad, 0xb2, 0x4a, 0xf9, 0x46, 0xfe, 0x2a, 0xb4, 0x77,
	0xcd, 0x2d, 0xd0, 0x19, 0x8f, 0xbe, 0x90, 0x5d, 0xbb, 0x1a, 0x8f, 0x46, 0x43, 0x1b, 0x2c, 0x08,
	0x16, 0xf1, 0x09, 0xb3, 0xeb, 0x99, 0xa1, 0xd9, 0x89, 0x5e, 0xef, 0x34, 0xc0, 0x62, 0x69, 0x83,
	0x13, 0x01, 0xfb, 0xfc, 0xbb, 0x90, 0x09, 0x8f, 0x25, 0x83, 0xaf, 0xc0, 0x4d, 0xc1, 0x64, 0x1a,
	0x2a, 0x63, 0xfa, 0xd3, 0xf9, 0xa6, 0xcf, 0x90, 0xb9, 0x39, 0xde, 0x35, 0x3c, 0xce, 0x33, 0xb0,
	0x72, 0x61, 0xc6, 0x7f, 0xbd, 0xe2, 0xee, 0xc7, 0x3a, 0x58, 0x2e, 0x81, 0xaf, 0x75, 0x49, 0xf8,
	0xd5, 0x02, 0x4b, 0xd3, 0x73, 0x01, 0x9f, 0xcc, 0xef, 0xf2, 0x82, 0x39, 0x6a, 0x5e, 0x4a, 0x68,
	0x67, 0xe3, 0xfd, 0xcf, 0xdf, 0x9f, 0x6b, 0x08, 0xae, 0x65, 0x53, 0x7f, 0xfa, 0x4f, 0xeb, 0xdb,
	0x66, 0x74, 0x24, 0x6e, 0x63, 0x52, 0xca, 0x8a, 0xdb, 0x67, 0xf0, 0xbb, 0x05, 0x96, 0x67, 0xe5,
	0x86, 0x9b, 0x97, 0x56, 0xd5, 0x8c, 0x6e, 0xb3, 0x77, 0x15, 0xa8, 0x76, 0xd7, 0xe9, 0xe5, 0x37,
	0xd8, 0x70, 0x70, 0xfe, 0xc9, 0x95, 0x2d, 0x9f, 0x4e, 0xfd, 0x05, 0xdb, 0xed, 0xb3, 0xa9, 0x0b,
	0xf4, 0xa2, 0x9c, 0xaa, 0x67, 0xb5, 0x77, 0x7e, 0x59, 0xe0, 0xd1, 0x98, 0x47, 0x73, 0xab, 0xef,
	0xac, 0xcc, 0xda, 0x35, 0xcc, 0x06, 0x78, 0x68, 0xbd, 0xdd, 0x2b, 0xa0, 0x3e, 0x0f, 0x49, 0xec,
	0x23, 0x2e, 0x7c, 0xec, 0xb3, 0x38, 0x1f, 0x6f, 0xf3, 0xa3, 0x26, 0x81, 0xac, 0xfe, 0xeb, 0xb7,
	0x4c, 0xf0, 0xa5, 0x56, 0x1f, 0xf4, 0xfb, 0xdf, 0x6a, 0xad, 0x81, 0x26, 0xec, 0x53, 0x89, 0x74,
	0x98, 0x45, 0x07, 0x1d, 0x54, 0x14, 0x96, 0x3f, 0x4c, 0xca, 0xa8, 0x4f, 0xe5, 0xa8, 0x4c, 0x19,
	0x1d, 0x74, 0x46, 0x26, 0xe5, 0x70, 0x21, 0x6f, 0x60, 0xfd, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x1d, 0x5f, 0xf4, 0x20, 0x6b, 0x06, 0x00, 0x00,
}
