# Copyright (c) 2001, Stanford University
# All rights reserved.
#
# See the file LICENSE.txt for information on redistributing this software.

import sys

import apiutil

apiutil.CopyrightC()

print """
/* DO NOT EDIT - THIS FILE GENERATED BY THE getprocaddress.py SCRIPT */

#include "chromium.h"
#include "cr_error.h"
#include "cr_string.h"
#include "cr_version.h"
#include "stub.h"
#include "dri_glx.h"
#if defined(VBOXOGL_DRI) || defined(VBOXOGL_FAKEDRI)
#include "cr_gl.h"
#include "fakedri_drv.h"
#endif

struct name_address {
  const char *name;
  CR_PROC address;
};

static struct name_address functions[] = {
"""


keys = apiutil.GetAllFunctions(sys.argv[1]+"/APIspec.txt")
for func_name in keys:
	if "Chromium" == apiutil.Category(func_name):
		continue
	if "VBox" == apiutil.Category(func_name):
		continue
	if func_name == "BoundsInfoCR":
		continue
	if "GL_chromium" == apiutil.Category(func_name):
		pass #continue

	wrap = apiutil.GetCategoryWrapper(func_name)
	name = "gl" + func_name
	address = "VBOXGLTAG(gl" + func_name + ")"
	if wrap:
		print '#ifdef CR_%s' % wrap
	print '\t{ "%s", (CR_PROC) %s },' % (name, address)
	if wrap:
		print '#endif'


print "\t/* Chromium binding/glue functions */"

for func_name in keys:
	if (func_name == "Writeback" or
		func_name == "BoundsInfoCR" or
		func_name == "GetUniformsLocations"):
		continue
	if apiutil.Category(func_name) == "Chromium":
		print '\t{ "cr%s", (CR_PROC) cr%s },' % (func_name, func_name)


print """
	{ NULL, NULL }
};

CR_PROC CR_APIENTRY crGetProcAddress( const char *name )
{
	int i;
	stubInit();

	for (i = 0; functions[i].name; i++) {
		if (crStrcmp(name, functions[i].name) == 0) {
			return functions[i].address;
		}
	}


#define GLXAPI_ENTRY(Func) if (!crStrcmp(name, "glX"#Func)) return (CR_PROC) &VBOXGLXENTRYTAG(glX##Func);
#include "fakedri_glxfuncsList.h"
#undef GLXAPI_ENTRY

    /*CR_EXT_texture_from_pixmap*/
    if (!crStrcmp( name, "glXBindTexImageEXT" )) return (CR_PROC) VBOXGLXTAG(glXBindTexImageEXT);
    if (!crStrcmp( name, "glXReleaseTexImageEXT" )) return (CR_PROC) VBOXGLXTAG(glXReleaseTexImageEXT);

#if defined(Linux) && defined(CR_EXT_framebuffer_blit)
    /* Hacky way to make gnome3 happy on ubuntu 11.04, even though glBlitFramebuffer is part of OpenGL 3.0 spec,
     * it expects to find glBlitFramebuffer and not glBlitFramebufferEXT after checking for EXT_framebuffer_blit support.
     * Untill 3.0 support, it's better to go this way instead of adding an alias to src/VBox/GuestHost/OpenGL/glapi_parser/apispec.txt.
     */
    if (!crStrcmp(name, "glBlitFramebuffer")) return crGetProcAddress("glBlitFramebufferEXT");
#endif

    if (name) crDebug("Returning NULL for %s", name);
	return NULL;
}

"""



# XXX should crGetProcAddress really handle WGL/GLX functions???

print_foo = """
/* As these are Windows specific (i.e. wgl), define these now.... */
#ifdef WINDOWS
	{
		wglGetExtensionsStringEXTFunc_t wglGetExtensionsStringEXT = NULL;
		wglChoosePixelFormatFunc_t wglChoosePixelFormatEXT = NULL;
		wglGetPixelFormatAttribivEXTFunc_t wglGetPixelFormatAttribivEXT = NULL;
		wglGetPixelFormatAttribfvEXTFunc_t wglGetPixelFormatAttribfvEXT = NULL;
		if (!crStrcmp( name, "wglGetExtensionsStringEXT" )) return (CR_PROC) wglGetExtensionsStringEXT;
		if (!crStrcmp( name, "wglChoosePixelFormatEXT" )) return (CR_PROC) wglChoosePixelFormatEXT;
		if (!crStrcmp( name, "wglGetPixelFormatAttribivEXT" )) return (CR_PROC) wglGetPixelFormatAttribivEXT;
		if (!crStrcmp( name, "wglGetPixelFormatAttribfvEXT" )) return (CR_PROC) wglGetPixelFormatAttribfvEXT;
	}
#endif
"""
