# You MUST have specified ROOT_DIR before including this file

BIN_DIR = $$ROOT_DIR/bin
BUILD_DIR = $$ROOT_DIR/build/$$TARGET
DESTDIR = $$BIN_DIR

UI_DIR = $$ROOT_DIR/build

LIBPATH += $$BIN_DIR
INCLUDEPATH += $$ROOT_DIR/src $$UI_DIR

CONFIG( breakpad ) {
    linux*:QMAKE_CXXFLAGS_RELEASE = -Os -freorder-blocks -fno-reorder-functions -fomit-frame-pointer -gstabs+
    mac*:QMAKE_CXXFLAGS_RELEASE = -Os -g -fomit-frame-pointer
    win32 {
        QMAKE_CXXFLAGS_RELEASE = -Zi -Oy -Ox -GL -MD -DNDEBUG
        QMAKE_LFLAGS_RELEASE = /ltcg
    }

	QMAKE_CFLAGS_RELEASE = $$QMAKE_CXXFLAGS_RELEASE

	unix {
		# optimise mpg decoding
		QMAKE_CFLAGS_RELEASE += -O3
		QMAKE_CFLAGS_RELEASE -= -Os
	}
	
	INCLUDEPATH += $$ROOT_DIR/src/breakpad $$ROOT_DIR/src/breakpad/external/src
}
else {
    DEFINES += NBREAKPAD
}

CONFIG(debug, debug|release) {
    mac* {
		#speeds up debug builds by only compiling x86
		CONFIG += x86
		CONFIG -= ppc
	}

    linux* {
        QMAKE_CXXFLAGS_DEBUG = -ggdb
    }
    
    unix:EXT = _debug
    else:EXT = d

	!macx-xcode:TARGET = $$TARGET$$EXT

    OBJECTS_DIR = $$BUILD_DIR/debug
    MOC_DIR = $$BUILD_DIR/debug

	#if debug is specified first, remove the release stuff! --mxcl
	CONFIG -= release

	VERSION_UPDATE_PATTERN = *.*.*.*

    CONFIG -= app_bundle
}

CONFIG(release, release|debug) {
    OBJECTS_DIR = $$BUILD_DIR/release
    MOC_DIR = $$BUILD_DIR/release
    
	win32:contains( TEMPLATE, app ) {
		MKSPEC = $$(QMAKESPEC)
		IS_2005 = $$find( MKSPEC, .*msvc2005 )
		isEmpty( IS_2005 ) {
			# If we're building with 2003.NET, no manifest will have been embedded so use -outputresource
			QMAKE_POST_LINK = mt.exe -manifest trustInfo.manifest \
									 -outputresource:"$${DESTDIR}/$${TARGET}.exe;$${LITERAL_HASH}1"							 
		} else {
			# If we're building with 2005, the linker has embedded a manifest and we need -updateresource
			QMAKE_POST_LINK = mt.exe -manifest trustInfo.manifest \
									 -updateresource:"$${DESTDIR}/$${TARGET}.exe;$${LITERAL_HASH}1"	
		}
	}
}

release:CONFIG += warn_off

win32 {
	# Build pdb files also for release builds
    QMAKE_LFLAGS_RELEASE += /DEBUG
    
    # Make the linker tell us what it's doing
    QMAKE_LFLAGS_DEBUG += /VERBOSE:LIB
    
    # Removes warnings about standard library usage
    DEFINES += _CRT_SECURE_NO_DEPRECATE _SCL_SECURE_NO_DEPRECATE
    
    # Prevents windows.h from including winsock.h as it will clash with
    # Winsock2.h which is included by the player listener.
    DEFINES += _WINSOCKAPI_
    
	# In order to request the proper priviliges on Vista, we need to embed the
	# default linker-generated manifest and then merge it with our hand-written
	# one containing the trustInfo section. The merging will be specified with a
	# QMAKE_POST_LINK directive in the project pro.
    CONFIG += embed_manifest_exe
}

linux* {
    DEFINES += LINUX
}

mac {
	DEFINES += MACOSX
}
