/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffFXBase;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;

public class TiffProfileFXM
extends TiffFXBase {
    public TiffProfileFXM() {
        this._profileText = "TIFF-FX (Profile M)";
        this._mimeClass = 1;
    }

    @Override
    public boolean satisfiesThisProfile(IFD iFD) {
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        if (!this.satisfiesClass(tiffIFD)) {
            return false;
        }
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        if (!this.satisfiesImageWidth(tiffIFD, new int[]{864, 1024, 1216, 1728, 2048, 2432, 2592, 3072, 3456, 3648, 4096, 4864})) {
            return false;
        }
        if (!this.satisfiesNewSubfileType(tiffIFD, new long[]{16L, 18L})) {
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, new int[]{3, 4, 7, 9, 10})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tiffIFD, new int[]{1, 3, 4})) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tiffIFD, new int[]{2, 3, -1})) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, new int[]{0, 1, 2, 5, 10})) {
            return false;
        }
        if (!this.satisfiesFillOrder(tiffIFD, new int[]{1, 2})) {
            return false;
        }
        int n = nisoImageMetadata.getBitsPerSample()[0];
        if (n > 16) {
            return false;
        }
        int[] nArray = tiffIFD.getImageLayer();
        if (nArray == null || nArray[0] < 1 || nArray[0] > 3) {
            return false;
        }
        if (tiffIFD.getStripRowCounts() != null && nisoImageMetadata.getRowsPerStrip() != -1L) {
            return false;
        }
        return tiffIFD.getIndexed() != 1 || nisoImageMetadata.getColormapRedValue() != null;
    }
}

