/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.core.Settings;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.timing.Pause;
import org.fest.swing.util.Platform;
import org.fest.swing.util.TimeoutWatch;

@Deprecated
public class DragAndDrop {
    private final Robot robot;
    public static final int DRAG_THRESHOLD = Platform.isWindows() || Platform.isMacintosh() ? 10 : 16;

    @Deprecated
    public DragAndDrop(Robot robot) {
        this.robot = robot;
    }

    @Deprecated
    @RunsInEDT
    public void drag(Component target, Point where) {
        this.robot.pressMouse(target, where, MouseButton.LEFT_BUTTON);
        int dragDelay = this.settings().dragDelay();
        if (dragDelay > this.delayBetweenEvents()) {
            Pause.pause(dragDelay);
        }
        this.mouseMove(target, where.x, where.y);
        this.robot.waitForIdle();
    }

    @Deprecated
    private void mouseMove(Component target, int x, int y) {
        if (Platform.isWindows() || Platform.isMacintosh()) {
            this.mouseMoveOnWindowsAndMacintosh(target, x, y);
            return;
        }
        this.mouseMove(target, this.point(x + DRAG_THRESHOLD / 2, y + DRAG_THRESHOLD / 2), this.point(x + DRAG_THRESHOLD, y + DRAG_THRESHOLD), this.point(x + DRAG_THRESHOLD / 2, y + DRAG_THRESHOLD / 2), this.point(x, y));
    }

    @Deprecated
    @RunsInEDT
    private void mouseMoveOnWindowsAndMacintosh(Component target, int x, int y) {
        Dimension size = target.getSize();
        int dx = this.distance(x, size.width);
        int dy = this.distance(y, size.height);
        if (dx == 0 && dy == 0) {
            dx = DRAG_THRESHOLD;
        }
        this.mouseMove(target, this.point(x + dx / 4, y + dy / 4), this.point(x + dx / 2, y + dy / 2), this.point(x + dx, y + dy), this.point(x + dx + 1, y + dy));
    }

    @Deprecated
    private int distance(int coordinate, int dimension) {
        return coordinate + DRAG_THRESHOLD < dimension ? DRAG_THRESHOLD : 0;
    }

    @Deprecated
    private Point point(int x, int y) {
        return new Point(x, y);
    }

    @Deprecated
    @RunsInEDT
    public void drop(Component target, Point where) {
        int delayBetweenEvents;
        this.dragOver(target, where);
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(this.settings().eventPostingDelay() * 4);
        while (!this.robot.isDragging()) {
            if (watch.isTimeOut()) {
                throw ActionFailedException.actionFailure("There is no drag in effect");
            }
            Pause.pause();
        }
        int dropDelay = this.settings().dropDelay();
        if (dropDelay > (delayBetweenEvents = this.delayBetweenEvents())) {
            Pause.pause(dropDelay - delayBetweenEvents);
        }
        this.robot.releaseMouseButtons();
        this.robot.waitForIdle();
    }

    @Deprecated
    private int delayBetweenEvents() {
        return this.settings().delayBetweenEvents();
    }

    @Deprecated
    private Settings settings() {
        return this.robot.settings();
    }

    @Deprecated
    public void dragOver(Component target, Point where) {
        this.dragOver(target, where.x, where.y);
    }

    @Deprecated
    private void dragOver(Component target, int x, int y) {
        this.robot.moveMouse(target, x - 4, y);
        this.robot.moveMouse(target, x, y);
    }

    @Deprecated
    private void mouseMove(Component target, Point ... points) {
        for (Point p : points) {
            this.robot.moveMouse(target, p.x, p.y);
        }
    }
}

