/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.data;

import org.fest.util.Strings;

public class TableCell {
    public final int row;
    public final int column;

    public static TableCellBuilder row(int row) {
        return new TableCellBuilder(row);
    }

    protected TableCell(int row, int column) {
        this.row = row;
        this.column = column;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableCell)) {
            return false;
        }
        TableCell other = (TableCell)obj;
        if (this.row != other.row) {
            return false;
        }
        return this.column == other.column;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + this.row;
        return result;
    }

    public String toString() {
        return Strings.concat((Object[])new Object[]{"[row=", String.valueOf(this.row), ", column=", String.valueOf(this.column), "]"});
    }

    public static class TableCellBuilder {
        private final int row;

        TableCellBuilder(int row) {
            this.row = row;
        }

        public TableCell column(int column) {
            return new TableCell(this.row, column);
        }
    }
}

