package xm::pfe::dpansreflist;
use strict;
use xm::o;

BEGIN {
    print sjdfkgsahsjdhfaskjdhlkhkfslflladls ;
}

sub DESC
{"
  scan the Annex F of the Draft Proposal On Forth - Html Version.
  generate an xm-table with the html-links and forth-xrefs.
  a --dpans=url will get prepended to the internal href-links that 
  have been scanned out. The result is printed. The arg can be
  the dpansf-file itself or the dirpath to it.
"} 

sub ARGS { return xm::o::args_command(@_,DESC); }

sub dirname
{
    my $in = $_[0];
    
    if ($in !~ /\//)
    {
	return ".";
    }else{
	$in =~ s{ /[^/]*$ } {}x ;
	return $in;
    }
}

sub mklist
{
    my $F;
    my $dir;
    ($F, $dir) = @_;
    my $line;
    
    my $out = "";

    if ( -d $F )  {
	if ( -f "$F/dpansf.html" )	{ $F .= "/dpansf.html"; }
	elsif ( -f "$F/dpansf.htm" )	{ $F .= "/dpansf.htm"; }
	else { return ""; } # oh no
    }
    if (not length $dir)  {
	if (defined $o{dpans} and length $o{dpans}) { $dir = $o{dpans}; }
	else { $dir = dirname($F); }
    }

    return "" if not open F, "<$F";
    print STDERR "<reading $F>\n";
    while ($line = <F>)
    {
#        if ($line =~ m{^\s+ 
#		  (\<A \s+ href=dpans\d+\.html\#[\d\.]+\> [\d\.]+ \<\/A\>) 
#		      \s+ ([^\s]+) \s }ix)
        if ($line =~ m{^\s+ 
   (<A \s+ href=dpans\d+\.html?\#[\d\.]+>  [\d\.]+ </A>) \s+  (\S+) }ix)
        {
	    my $ref = $1;
	    my $key = $2;
     
	    $key =~ s{<B>.*</B>} {};
	    
	    $ref =~ s/href=dpans/"href=".$dir."\/dpans"/e;
	    $ref =~ s:<A:<a:;
	    $ref =~ s:</A:</a:;
    
	    $out .= "<DPANSITEM><LINKDPANSLINK>".$ref."</DPANSLINK>\n"
		."<DPANSXREF>".$key."</DPANSXREF></DPANSITEM>\n";
        }
    }
    return $out;
}


sub DO
{
    my $args = shift; # an array-refer

    my $out = "";
    my $f;
    for $f (@$args)
    {
	$out .= mklist ($f);
    }
    
    return $out;
} 

1;

