package xm::grabitemxdoc;
use strict;
use xm::o;

sub DESC
{"
  will look for all global CDOC-comments that do not belong to any ITEMCDEF.
  Mark these as ITEMXDOC, and leave the rest to other scan-modules.
"}

sub ARGS { return xm::o::args_stdin(@_, DESC); }

sub DO
{
    my $in = shift;

    # use-CDEFS style    
    $in =~ s{(^|</ITEMCDEF\b[^<>]*>(?!<ITEMCDEF\b))
		 ( (?:.(?!</?(?:CDOC|ITEMCDEF)\b))*.? )
		     ((?:\ *<CDOC\b[^<>]*> 
		       (?:.(?!</?CDOC\b))*.
		       </CDOC\b[^<>]*> \ *\s?)+)
		     } 
         { 
	      print STDERR "."; $1.$2."<ITEMXDOC>".$3."</ITEMXDOC>" 
	 }gsex;

    while(
	  $in =~ s{(^|</ITEMXDOC\b[^<>]*(?=>))
		       ( (?:.(?!</?(?:CDOC|ITEMCDEF|ITEMXDOC)\b))*.? )
			   ((?:\ *<CDOC\b[^<>]*> 
			     (?:.(?!</?CDOC\b))*. 
			     </CDOC\b[^<>]*> \ *\s?)+)
			   } 
	  { 
	      print STDERR "."; $1.$2."<ITEMXDOC>".$3."</ITEMXDOC>" 
	  }gsex
    ) { };
    
    # delete any ITEMXDOC that does not start on the line. this is "mgex" instead of "sgex"
    while(
    $in =~ s{(^\s*\S+.*) 
		 (<ITEMXDOC>(?!</ITEMXDOC\b)) 
		     ((?:.(?!</?ITEMXDOC\b))*.?) 
			 (</ITEMXDOC>)}
	  { print STDERR ","; $1.$3 }gmex
    ) { };

    return $in;
} 

1;



