#!/bin/sh
## (c) Copyright 2009 - 2012 Xilinx, Inc. All rights reserved.
##
## This file contains confidential and proprietary information
## of Xilinx, Inc. and is protected under U.S. and 
## international copyright and other intellectual property
## laws.
##
## DISCLAIMER
## This disclaimer is not a license and does not grant any
## rights to the materials distributed herewith. Except as
## otherwise provided in a valid license issued to you by
## Xilinx, and to the maximum extent permitted by applicable
## law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
## WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
## AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
## BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
## INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
## (2) Xilinx shall not be liable (whether in contract or tort,
## including negligence, or under any other theory of
## liability) for any loss or damage of any kind or nature
## related to, arising under or in connection with these
## materials, including for any direct, or any indirect,
## special, incidental, or consequential loss or damage
## (including loss of data, profits, goodwill, or any type of
## loss or damage suffered as a result of any action brought
## by a third party) even if such damage or loss was
## reasonably foreseeable or Xilinx had been advised of the
## possibility of the same.
##
## CRITICAL APPLICATIONS
## Xilinx products are not designed or intended to be fail-
## safe, or for use in any application requiring fail-safe
## performance, such as life-support or safety devices or
## systems, Class III medical devices, nuclear facilities,
## applications related to the deployment of airbags, or any
## other applications that could lead to death, personal
## injury, or severe property or environmental damage
## (individually and collectively, "Critical
## Applications"). Customer assumes the sole risk and
## liability of any use of Xilinx products in Critical
## Applications, subject only to applicable laws and
## regulations governing limitations on product liability.
##
## THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
## PART OF THIS FILE AT ALL TIMES.

# Clean up the run directory
rm -rf results
mkdir results
rm -f ten_gig_eth_pcs_pma_example_design.ngc

#####################################################
# Design Flow
####################################################
echo Synthesizing example design with XST
xst -ifn xst.scr
cp ten_gig_eth_pcs_pma_example_design.ngc results

#####################################################
# Copy the netlist generated by Coregen
#####################################################
echo 'Copying the CoreGEN generated netlist to the results directory'
cd results
cp ../../../ten_gig_eth_pcs_pma.ngc ten_gig_eth_pcs_pma.ngc

#  Copy the constraints files generated by Coregen
echo 'Copying constraints file from example design directory to the results directory.'
cp ../../example_design/ten_gig_eth_pcs_pma_example_design.ucf .

echo 'Running ngdbuild'
ngdbuild ten_gig_eth_pcs_pma_example_design

echo 'Running map'
map ten_gig_eth_pcs_pma_example_design -o mapped.ncd

echo 'Running par'
par mapped.ncd routed mapped.pcf

echo 'Running trce'
trce -e 10 routed -o routed mapped.pcf

echo 'Running design through bitgen'
bitgen -g UnconstrainedPins:Allow routed.ncd routed.bit mapped.pcf

echo 'Running netgen to create gate level model'
netgen -ofmt verilog -pcf mapped.pcf -sim -dir . -tm ten_gig_eth_pcs_pma_example_design -sdf_anno false routed.ncd routed.v
#####################################################
