/* tracker-utils.c generated by valac 0.34.4, the Vala compiler
 * generated from tracker-utils.vala, do not modify */

/**/
/* Copyright 2010, Martyn Russell <martyn@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <time.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))



#define secs_per_day ((60 * 60) * 24)
gchar* uri_get_selected (GtkTreeModel* model, GtkTreePath* path, gint col);
void uri_launch (const gchar* uri);
void tracker_model_launch_selected (GtkTreeModel* model, GtkTreePath* path, gint col);
void tracker_model_launch_selected_parent_dir (GtkTreeModel* model, GtkTreePath* path, gint col);
gchar* tracker_time_format_from_iso8601 (const gchar* s);
gchar* tracker_time_format_from_seconds (const gchar* seconds_str);
GdkPixbuf* tracker_pixbuf_new_from_file (GtkIconTheme* theme, const gchar* filename, gint size, gboolean is_image);
GdkPixbuf* tracker_pixbuf_new_from_name (GtkIconTheme* theme, const gchar* name, gint size);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


gchar* uri_get_selected (GtkTreeModel* model, GtkTreePath* path, gint col) {
	gchar* result = NULL;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	const gchar* uri = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (model != NULL, NULL);
#line 24 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = model;
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = path;
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	gtk_tree_model_get_iter (_tmp0_, &_tmp2_, _tmp1_);
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	iter = _tmp2_;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp3_ = model;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp4_ = iter;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp5_ = col;
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	gtk_tree_model_get (_tmp3_, &_tmp4_, _tmp5_, &uri, -1);
#line 31 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp6_ = g_strdup (uri);
#line 31 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	result = _tmp6_;
#line 31 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	return result;
#line 94 "tracker-utils.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 987 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 987 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 988 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 988 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 988 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 988 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 990 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 990 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 121 "tracker-utils.c"
		gchar* _tmp4_ = NULL;
#line 991 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 991 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 991 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 129 "tracker-utils.c"
	} else {
#line 993 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = -1;
#line 993 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 135 "tracker-utils.c"
	}
}


void uri_launch (const gchar* uri) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GError * _inner_error_ = NULL;
#line 34 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_if_fail (uri != NULL);
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = uri;
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = string_index_of (_tmp0_, "://", 0);
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp1_ < 1) {
#line 152 "tracker-utils.c"
		gchar** command = NULL;
		const gchar* _tmp2_ = NULL;
		gchar** _tmp3_ = NULL;
		gchar** _tmp4_ = NULL;
		gint command_length1 = 0;
		gint _command_size_ = 0;
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		const gchar* _tmp6_ = NULL;
		GPid child_pid = 0;
		gchar** argv = NULL;
		gchar** _tmp7_ = NULL;
		gint argv_length1 = 0;
		gint _argv_size_ = 0;
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		GPid _tmp22_ = 0;
#line 38 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp2_ = uri;
#line 38 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
#line 38 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		command = _tmp4_;
#line 38 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		command_length1 = _vala_array_length (_tmp3_);
#line 38 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_command_size_ = command_length1;
#line 39 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp5_ = command;
#line 39 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp5__length1 = command_length1;
#line 39 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp6_ = _tmp5_[0];
#line 39 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		g_debug ("tracker-utils.vala:39: Attempting to spawn_async() '%s'", _tmp6_);
#line 42 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp7_ = g_new0 (gchar*, 1 + 1);
#line 42 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		argv = _tmp7_;
#line 42 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		argv_length1 = 1;
#line 42 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_argv_size_ = argv_length1;
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp8_ = argv;
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp8__length1 = argv_length1;
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp9_ = command;
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp9__length1 = command_length1;
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp10_ = _tmp9_[0];
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_g_free0 (_tmp8_[0]);
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp8_[0] = _tmp11_;
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp12_ = _tmp8_[0];
#line 219 "tracker-utils.c"
		{
			gchar** _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			GPid _tmp14_ = 0;
#line 46 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp13_ = argv;
#line 46 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp13__length1 = argv_length1;
#line 46 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			g_spawn_async ("/usr/bin", _tmp13_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp14_, &_inner_error_);
#line 46 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			child_pid = _tmp14_;
#line 46 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 234 "tracker-utils.c"
				goto __catch22_g_error;
			}
		}
		goto __finally22;
		__catch22_g_error:
		{
			GError* e = NULL;
			gchar** _tmp15_ = NULL;
			gint _tmp15__length1 = 0;
			const gchar* _tmp16_ = NULL;
			GError* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			GError* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			const gchar* _tmp21_ = NULL;
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			e = _inner_error_;
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_inner_error_ = NULL;
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp15_ = command;
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp15__length1 = command_length1;
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp16_ = _tmp15_[0];
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp17_ = e;
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp18_ = _tmp17_->code;
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp19_ = e;
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp20_ = _tmp19_->code;
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp21_ = g_strerror (_tmp20_);
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			g_warning ("tracker-utils.vala:53: Could not launch '%s', %d->%s", _tmp16_, _tmp18_, _tmp21_);
#line 54 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_g_error_free0 (e);
#line 54 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 54 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
#line 54 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			return;
#line 280 "tracker-utils.c"
		}
		__finally22:
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			g_clear_error (&_inner_error_);
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			return;
#line 295 "tracker-utils.c"
		}
#line 57 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp22_ = child_pid;
#line 57 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		g_debug ("tracker-utils.vala:57: Launched application with PID:%d", (gint) _tmp22_);
#line 58 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 58 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
#line 58 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		return;
#line 307 "tracker-utils.c"
	}
	{
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp23_ = uri;
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		g_debug ("tracker-utils.vala:62: Attempting to launch application for uri:'%s'", _tmp23_);
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp24_ = uri;
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		g_app_info_launch_default_for_uri (_tmp24_, NULL, &_inner_error_);
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 322 "tracker-utils.c"
			goto __catch23_g_error;
		}
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
#line 61 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		e = _inner_error_;
#line 61 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_inner_error_ = NULL;
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp25_ = e;
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp26_ = _tmp25_->message;
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp27_ = g_strconcat ("Could not launch application: ", _tmp26_, NULL);
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp28_ = _tmp27_;
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		g_warning ("tracker-utils.vala:65: %s", _tmp28_);
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_g_free0 (_tmp28_);
#line 61 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_g_error_free0 (e);
#line 352 "tracker-utils.c"
	}
	__finally23:
#line 61 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 61 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 61 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		g_clear_error (&_inner_error_);
#line 61 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		return;
#line 363 "tracker-utils.c"
	}
}


void tracker_model_launch_selected (GtkTreeModel* model, GtkTreePath* path, gint col) {
	gchar* uri = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_if_fail (model != NULL);
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_if_fail (path != NULL);
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = model;
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = path;
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp2_ = col;
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp3_ = uri_get_selected (_tmp0_, _tmp1_, _tmp2_);
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	uri = _tmp3_;
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_debug ("tracker-utils.vala:71: Selected uri:'%s'", uri);
#line 73 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	uri_launch (uri);
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_g_free0 (uri);
#line 394 "tracker-utils.c"
}


void tracker_model_launch_selected_parent_dir (GtkTreeModel* model, GtkTreePath* path, gint col) {
	gchar* uri = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	GFile* f = NULL;
	GFile* _tmp4_ = NULL;
	GFile* p = NULL;
	GFile* _tmp5_ = NULL;
	gchar* parent_uri = NULL;
	gchar* _tmp6_ = NULL;
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_if_fail (model != NULL);
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_if_fail (path != NULL);
#line 77 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = model;
#line 77 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = path;
#line 77 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp2_ = col;
#line 77 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp3_ = uri_get_selected (_tmp0_, _tmp1_, _tmp2_);
#line 77 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	uri = _tmp3_;
#line 78 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_debug ("tracker-utils.vala:78: Selected uri:'%s'", uri);
#line 80 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp4_ = g_file_new_for_uri (uri);
#line 80 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	f = _tmp4_;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp5_ = g_file_get_parent (f);
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	p = _tmp5_;
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp6_ = g_file_get_uri (p);
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	parent_uri = _tmp6_;
#line 84 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_debug ("tracker-utils.vala:84: Parent uri:'%s'", parent_uri);
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	uri_launch (parent_uri);
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_g_free0 (parent_uri);
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_g_object_unref0 (p);
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_g_object_unref0 (f);
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_g_free0 (uri);
#line 450 "tracker-utils.c"
}


static gchar* g_time_format (struct tm *self, const gchar* format) {
	gchar* result = NULL;
	gchar* buffer = NULL;
	gchar* _tmp0_ = NULL;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	gchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar* _tmp4_ = NULL;
#line 2758 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (format != NULL, NULL);
#line 2759 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 64);
#line 2759 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	buffer = _tmp0_;
#line 2759 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	buffer_length1 = 64;
#line 2759 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_buffer_size_ = buffer_length1;
#line 2760 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = buffer;
#line 2760 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1__length1 = buffer_length1;
#line 2760 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = format;
#line 2760 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	strftime (_tmp1_, _tmp1__length1, _tmp2_, &(*self));
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = buffer;
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3__length1 = buffer_length1;
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	buffer = (g_free (buffer), NULL);
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 496 "tracker-utils.c"
}


gchar* tracker_time_format_from_iso8601 (const gchar* s) {
	gchar* result = NULL;
	struct tm t = {0};
	const gchar* _tmp0_ = NULL;
	GTimeVal tv_now = {0};
	GTimeVal tv_then = {0};
	const gchar* _tmp1_ = NULL;
	glong diff_sec = 0L;
	GTimeVal _tmp2_ = {0};
	glong _tmp3_ = 0L;
	GTimeVal _tmp4_ = {0};
	glong _tmp5_ = 0L;
	glong diff_days = 0L;
	glong _tmp6_ = 0L;
	glong diff_days_abs = 0L;
	glong _tmp7_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp9_ = 0L;
	glong _tmp12_ = 0L;
#line 88 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 89 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	memset (&t, 0, sizeof (struct tm));
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = s;
#line 90 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	strptime (_tmp0_, "%FT%T", &t);
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_get_current_time (&tv_now);
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_get_current_time (&tv_now);
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_get_current_time (&tv_then);
#line 96 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = s;
#line 96 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_time_val_from_iso8601 (_tmp1_, &tv_then);
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp2_ = tv_now;
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp3_ = _tmp2_.tv_sec;
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp4_ = tv_then;
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp5_ = _tmp4_.tv_sec;
#line 98 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	diff_sec = _tmp3_ - _tmp5_;
#line 99 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp6_ = diff_sec;
#line 99 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	diff_days = _tmp6_ / secs_per_day;
#line 100 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp7_ = diff_days;
#line 100 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp8_ = labs (_tmp7_);
#line 100 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	diff_days_abs = _tmp8_;
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp9_ = diff_days_abs;
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp9_ > ((glong) 7)) {
#line 561 "tracker-utils.c"
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp10_ = _ ("%x");
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp11_ = g_time_format (&t, _tmp10_);
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		result = _tmp11_;
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		return result;
#line 572 "tracker-utils.c"
	}
#line 111 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp12_ = diff_days_abs;
#line 111 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp12_ == ((glong) 0)) {
#line 578 "tracker-utils.c"
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp13_ = _ ("Today");
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp14_ = g_strdup (_tmp13_);
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		result = _tmp14_;
#line 112 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		return result;
#line 589 "tracker-utils.c"
	} else {
		gboolean future = FALSE;
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		future = FALSE;
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp15_ = diff_days;
#line 116 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		if (_tmp15_ < ((glong) 0)) {
#line 117 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			future = TRUE;
#line 602 "tracker-utils.c"
		}
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp16_ = diff_days;
#line 119 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		if (_tmp16_ <= ((glong) 1)) {
#line 608 "tracker-utils.c"
			gboolean _tmp17_ = FALSE;
#line 120 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp17_ = future;
#line 120 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			if (_tmp17_) {
#line 614 "tracker-utils.c"
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
#line 121 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp18_ = _ ("Tomorrow");
#line 121 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp19_ = g_strdup (_tmp18_);
#line 121 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				result = _tmp19_;
#line 121 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				return result;
#line 625 "tracker-utils.c"
			} else {
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp20_ = _ ("Yesterday");
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp21_ = g_strdup (_tmp20_);
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				result = _tmp21_;
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				return result;
#line 637 "tracker-utils.c"
			}
		} else {
			gboolean _tmp22_ = FALSE;
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp22_ = future;
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			if (_tmp22_) {
#line 645 "tracker-utils.c"
				glong _tmp23_ = 0L;
				const gchar* _tmp24_ = NULL;
				glong _tmp25_ = 0L;
				gchar* _tmp26_ = NULL;
#line 127 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp23_ = diff_days_abs;
#line 127 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp24_ = ngettext ("%ld day from now", "%ld days from now", (gulong) _tmp23_);
#line 127 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp25_ = diff_days_abs;
#line 127 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp26_ = g_strdup_printf (_tmp24_, _tmp25_);
#line 127 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				result = _tmp26_;
#line 127 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				return result;
#line 662 "tracker-utils.c"
			} else {
				glong _tmp27_ = 0L;
				const gchar* _tmp28_ = NULL;
				glong _tmp29_ = 0L;
				gchar* _tmp30_ = NULL;
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp27_ = diff_days_abs;
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp28_ = ngettext ("%ld day ago", "%ld days ago", (gulong) _tmp27_);
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp29_ = diff_days_abs;
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp30_ = g_strdup_printf (_tmp28_, _tmp29_);
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				result = _tmp30_;
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				return result;
#line 680 "tracker-utils.c"
			}
		}
	}
}


gchar* tracker_time_format_from_seconds (const gchar* seconds_str) {
	gchar* result = NULL;
	gdouble seconds = 0.0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gdouble total = 0.0;
	gint d = 0;
	gint h = 0;
	gint m = 0;
	gint s = 0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	GString* output = NULL;
	GString* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp18_ = 0;
	gint _tmp23_ = 0;
	const gchar* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	GString* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	GString* _tmp36_ = NULL;
	gssize _tmp37_ = 0L;
	gchar* str = NULL;
	GString* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
#line 136 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (seconds_str != NULL, NULL);
#line 137 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = seconds_str;
#line 137 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = atoi (_tmp0_);
#line 137 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	seconds = (gdouble) _tmp1_;
#line 141 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp2_ = seconds;
#line 141 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp2_ == 0.0) {
#line 737 "tracker-utils.c"
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp3_ = _ ("Less than one second");
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		result = _tmp4_;
#line 142 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		return result;
#line 748 "tracker-utils.c"
	}
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp5_ = seconds;
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	total = _tmp5_;
#line 146 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp6_ = total;
#line 146 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	s = ((gint) _tmp6_) % 60;
#line 147 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp7_ = total;
#line 147 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	total = _tmp7_ / 60;
#line 148 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp8_ = total;
#line 148 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	m = ((gint) _tmp8_) % 60;
#line 149 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp9_ = total;
#line 149 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	total = _tmp9_ / 60;
#line 150 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp10_ = total;
#line 150 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	h = ((gint) _tmp10_) % 24;
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp11_ = total;
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	d = ((gint) _tmp11_) / 24;
#line 153 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp12_ = g_string_new ("");
#line 153 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	output = _tmp12_;
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp13_ = d;
#line 155 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp13_ > 0) {
#line 786 "tracker-utils.c"
		GString* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp14_ = output;
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp15_ = d;
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp16_ = g_strdup_printf (" %dd", _tmp15_);
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp17_ = _tmp16_;
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		g_string_append (_tmp14_, _tmp17_);
#line 156 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_g_free0 (_tmp17_);
#line 803 "tracker-utils.c"
	}
#line 159 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp18_ = h;
#line 159 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp18_ > 0) {
#line 809 "tracker-utils.c"
		GString* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
#line 160 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp19_ = output;
#line 160 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp20_ = h;
#line 160 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp21_ = g_strdup_printf (" %.2d", _tmp20_);
#line 160 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp22_ = _tmp21_;
#line 160 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		g_string_append (_tmp19_, _tmp22_);
#line 160 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_g_free0 (_tmp22_);
#line 826 "tracker-utils.c"
	}
#line 163 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp23_ = m;
#line 163 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp23_ > 0) {
#line 832 "tracker-utils.c"
		const gchar* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		GString* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp25_ = h;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		if (_tmp25_ > 0) {
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp24_ = ":";
#line 845 "tracker-utils.c"
		} else {
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp24_ = "";
#line 849 "tracker-utils.c"
		}
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp26_ = output;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp27_ = m;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp28_ = g_strdup_printf ("%s%.2d", _tmp24_, _tmp27_);
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp29_ = _tmp28_;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		g_string_append (_tmp26_, _tmp29_);
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_g_free0 (_tmp29_);
#line 863 "tracker-utils.c"
	}
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp31_ = m;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp31_ > 0) {
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp30_ = ":";
#line 871 "tracker-utils.c"
	} else {
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp30_ = "0:";
#line 875 "tracker-utils.c"
	}
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp32_ = output;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp33_ = s;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp34_ = g_strdup_printf ("%s%.2d", _tmp30_, _tmp33_);
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp35_ = _tmp34_;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_string_append (_tmp32_, _tmp35_);
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_g_free0 (_tmp35_);
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp36_ = output;
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp37_ = _tmp36_->len;
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp37_ < ((gssize) 1)) {
#line 895 "tracker-utils.c"
		const gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp38_ = _ ("Less than one second");
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp39_ = g_strdup (_tmp38_);
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		result = _tmp39_;
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_g_string_free0 (output);
#line 171 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		return result;
#line 908 "tracker-utils.c"
	}
#line 174 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp40_ = output;
#line 174 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp41_ = _tmp40_->str;
#line 174 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp42_ = g_strdup (_tmp41_);
#line 174 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	str = _tmp42_;
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp43_ = str;
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp44_ = g_strchug (_tmp43_);
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp45_ = g_strdup (_tmp44_);
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	result = _tmp45_;
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_g_free0 (str);
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_g_string_free0 (output);
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	return result;
#line 932 "tracker-utils.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 182 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	return self ? g_object_ref (self) : NULL;
#line 939 "tracker-utils.c"
}


GdkPixbuf* tracker_pixbuf_new_from_file (GtkIconTheme* theme, const gchar* filename, gint size, gboolean is_image) {
	GdkPixbuf* result = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GdkPixbuf* pixbuf = NULL;
	gpointer _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GFile* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GdkPixbuf* _tmp54_ = NULL;
	GtkIconTheme* _tmp55_ = NULL;
	gint _tmp56_ = 0;
	GdkPixbuf* _tmp57_ = NULL;
	GError * _inner_error_ = NULL;
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (theme != NULL, NULL);
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = filename;
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = g_file_new_for_uri (_tmp0_);
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	file = _tmp1_;
#line 182 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp2_ = NULL;
#line 182 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gdk_pixbuf_get_type ()) ? ((GdkPixbuf*) _tmp2_) : NULL);
#line 182 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	pixbuf = _tmp3_;
#line 184 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp4_ = is_image;
#line 184 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp4_) {
#line 979 "tracker-utils.c"
		GdkPixbuf* _tmp18_ = NULL;
		{
			GdkPixbuf* _tmp5_ = NULL;
			GFile* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			GdkPixbuf* _tmp11_ = NULL;
			GdkPixbuf* _tmp12_ = NULL;
			GdkPixbuf* _tmp13_ = NULL;
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp6_ = file;
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp7_ = g_file_get_path (_tmp6_);
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp8_ = _tmp7_;
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp9_ = size;
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp10_ = size;
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp11_ = gdk_pixbuf_new_from_file_at_size (_tmp8_, _tmp9_, _tmp10_, &_inner_error_);
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp12_ = _tmp11_;
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_g_free0 (_tmp8_);
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp5_ = _tmp12_;
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1011 "tracker-utils.c"
				goto __catch24_g_error;
			}
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp13_ = _tmp5_;
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp5_ = NULL;
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (pixbuf);
#line 186 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			pixbuf = _tmp13_;
#line 185 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (_tmp5_);
#line 1024 "tracker-utils.c"
		}
		goto __finally24;
		__catch24_g_error:
		{
			GError* e = NULL;
			GError* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
#line 185 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			e = _inner_error_;
#line 185 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_inner_error_ = NULL;
#line 188 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp14_ = e;
#line 188 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp15_ = _tmp14_->message;
#line 188 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp16_ = g_strconcat ("Error loading icon pixbuf: ", _tmp15_, NULL);
#line 188 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp17_ = _tmp16_;
#line 188 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			g_warning ("tracker-utils.vala:188: %s", _tmp17_);
#line 188 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_g_free0 (_tmp17_);
#line 185 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_g_error_free0 (e);
#line 1052 "tracker-utils.c"
		}
		__finally24:
#line 185 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 185 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (pixbuf);
#line 185 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (file);
#line 185 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 185 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			g_clear_error (&_inner_error_);
#line 185 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			return NULL;
#line 1067 "tracker-utils.c"
		}
#line 191 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp18_ = pixbuf;
#line 191 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		if (_tmp18_ != NULL) {
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			result = pixbuf;
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (file);
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			return result;
#line 1079 "tracker-utils.c"
		}
	}
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp19_ = file;
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp20_ = g_file_query_exists (_tmp19_, NULL);
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp20_) {
#line 1088 "tracker-utils.c"
		{
			GFileInfo* file_info = NULL;
			GFile* _tmp21_ = NULL;
			GFileInfo* _tmp22_ = NULL;
			GFileInfo* _tmp23_ = NULL;
#line 198 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp21_ = file;
#line 198 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp22_ = g_file_query_info (_tmp21_, "standard::icon", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 198 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			file_info = _tmp22_;
#line 198 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1102 "tracker-utils.c"
				goto __catch25_g_error;
			}
#line 202 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp23_ = file_info;
#line 202 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			if (_tmp23_ != NULL) {
#line 1109 "tracker-utils.c"
				GIcon* icon = NULL;
				GFileInfo* _tmp24_ = NULL;
				GIcon* _tmp25_ = NULL;
				GIcon* _tmp26_ = NULL;
#line 203 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp24_ = file_info;
#line 203 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp25_ = g_file_info_get_icon (_tmp24_);
#line 203 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				_tmp26_ = _g_object_ref0 (_tmp25_);
#line 203 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				icon = _tmp26_;
#line 1122 "tracker-utils.c"
				{
					GIcon* _tmp27_ = NULL;
#line 206 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
					_tmp27_ = icon;
#line 206 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, g_file_icon_get_type ())) {
#line 1129 "tracker-utils.c"
						GdkPixbuf* _tmp28_ = NULL;
						GIcon* _tmp29_ = NULL;
						GFile* _tmp30_ = NULL;
						gchar* _tmp31_ = NULL;
						gchar* _tmp32_ = NULL;
						GdkPixbuf* _tmp33_ = NULL;
						GdkPixbuf* _tmp34_ = NULL;
						GdkPixbuf* _tmp35_ = NULL;
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp29_ = icon;
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp30_ = g_file_icon_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, g_file_icon_get_type (), GFileIcon));
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp31_ = g_file_get_path (_tmp30_);
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp32_ = _tmp31_;
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp33_ = gdk_pixbuf_new_from_file (_tmp32_, &_inner_error_);
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp34_ = _tmp33_;
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
						_g_free0 (_tmp32_);
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp28_ = _tmp34_;
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1156 "tracker-utils.c"
							goto __catch26_g_error;
						}
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp35_ = _tmp28_;
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp28_ = NULL;
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
						_g_object_unref0 (pixbuf);
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
						pixbuf = _tmp35_;
#line 206 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
						_g_object_unref0 (_tmp28_);
#line 1169 "tracker-utils.c"
					} else {
						GIcon* _tmp36_ = NULL;
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
						_tmp36_ = icon;
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, g_themed_icon_get_type ())) {
#line 1176 "tracker-utils.c"
							GdkPixbuf* _tmp37_ = NULL;
							GtkIconTheme* _tmp38_ = NULL;
							GIcon* _tmp39_ = NULL;
							gchar** _tmp40_ = NULL;
							gchar** _tmp41_ = NULL;
							const gchar* _tmp42_ = NULL;
							gint _tmp43_ = 0;
							GdkPixbuf* _tmp44_ = NULL;
							GdkPixbuf* _tmp45_ = NULL;
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp38_ = theme;
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp39_ = icon;
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp41_ = _tmp40_ = g_themed_icon_get_names (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, g_themed_icon_get_type (), GThemedIcon));
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp42_ = _tmp41_[0];
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp43_ = size;
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp44_ = gtk_icon_theme_load_icon (_tmp38_, _tmp42_, _tmp43_, GTK_ICON_LOOKUP_USE_BUILTIN, &_inner_error_);
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp37_ = _tmp44_;
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1202 "tracker-utils.c"
								goto __catch26_g_error;
							}
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp45_ = _tmp37_;
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
							_tmp37_ = NULL;
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
							_g_object_unref0 (pixbuf);
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
							pixbuf = _tmp45_;
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
							_g_object_unref0 (_tmp37_);
#line 1215 "tracker-utils.c"
						}
					}
				}
				goto __finally26;
				__catch26_g_error:
				{
					GError* e = NULL;
					GError* _tmp46_ = NULL;
					const gchar* _tmp47_ = NULL;
					gchar* _tmp48_ = NULL;
					gchar* _tmp49_ = NULL;
#line 205 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
					e = _inner_error_;
#line 205 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
					_inner_error_ = NULL;
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
					_tmp46_ = e;
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
					_tmp47_ = _tmp46_->message;
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
					_tmp48_ = g_strconcat ("Error loading icon pixbuf: ", _tmp47_, NULL);
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
					_tmp49_ = _tmp48_;
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
					g_warning ("tracker-utils.vala:212: %s", _tmp49_);
#line 212 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
					_g_free0 (_tmp49_);
#line 205 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
					_g_error_free0 (e);
#line 1245 "tracker-utils.c"
				}
				__finally26:
#line 205 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 205 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
					_g_object_unref0 (icon);
#line 205 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
					_g_object_unref0 (file_info);
#line 1254 "tracker-utils.c"
					goto __catch25_g_error;
				}
#line 202 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
				_g_object_unref0 (icon);
#line 1259 "tracker-utils.c"
			}
#line 197 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (file_info);
#line 1263 "tracker-utils.c"
		}
		goto __finally25;
		__catch25_g_error:
		{
			GError* e = NULL;
			GError* _tmp50_ = NULL;
			const gchar* _tmp51_ = NULL;
			gchar* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
#line 197 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			e = _inner_error_;
#line 197 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_inner_error_ = NULL;
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp50_ = e;
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp51_ = _tmp50_->message;
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp52_ = g_strconcat ("Error looking up file for pixbuf: ", _tmp51_, NULL);
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_tmp53_ = _tmp52_;
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			g_warning ("tracker-utils.vala:216: %s", _tmp53_);
#line 216 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_g_free0 (_tmp53_);
#line 197 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_g_error_free0 (e);
#line 1291 "tracker-utils.c"
		}
		__finally25:
#line 197 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 197 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (pixbuf);
#line 197 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			_g_object_unref0 (file);
#line 197 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 197 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			g_clear_error (&_inner_error_);
#line 197 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
			return NULL;
#line 1306 "tracker-utils.c"
		}
	}
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp54_ = pixbuf;
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	if (_tmp54_ != NULL) {
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		result = pixbuf;
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_g_object_unref0 (file);
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		return result;
#line 1319 "tracker-utils.c"
	}
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp55_ = theme;
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp56_ = size;
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp57_ = tracker_pixbuf_new_from_name (_tmp55_, "text-x-generic", _tmp56_);
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	result = _tmp57_;
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_g_object_unref0 (pixbuf);
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_g_object_unref0 (file);
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	return result;
#line 1335 "tracker-utils.c"
}


GdkPixbuf* tracker_pixbuf_new_from_name (GtkIconTheme* theme, const gchar* name, gint size) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf = NULL;
	gpointer _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (theme != NULL, NULL);
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp0_ = NULL;
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gdk_pixbuf_get_type ()) ? ((GdkPixbuf*) _tmp0_) : NULL);
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	pixbuf = _tmp1_;
#line 1355 "tracker-utils.c"
	{
		GdkPixbuf* _tmp2_ = NULL;
		GtkIconTheme* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		GdkPixbuf* _tmp6_ = NULL;
		GdkPixbuf* _tmp7_ = NULL;
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp3_ = theme;
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp4_ = name;
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp5_ = size;
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp6_ = gtk_icon_theme_load_icon (_tmp3_, _tmp4_, _tmp5_, GTK_ICON_LOOKUP_USE_BUILTIN, &_inner_error_);
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp2_ = _tmp6_;
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1375 "tracker-utils.c"
			goto __catch27_g_error;
		}
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp7_ = _tmp2_;
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp2_ = NULL;
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_g_object_unref0 (pixbuf);
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		pixbuf = _tmp7_;
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_g_object_unref0 (_tmp2_);
#line 1388 "tracker-utils.c"
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		e = _inner_error_;
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_inner_error_ = NULL;
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp8_ = name;
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp9_ = e;
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_tmp10_ = _tmp9_->message;
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		g_warning ("tracker-utils.vala:234: Could not load default icon pixbuf from theme " \
"for '%s': %s", _tmp8_, _tmp10_);
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_g_error_free0 (e);
#line 1411 "tracker-utils.c"
	}
	__finally27:
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		_g_object_unref0 (pixbuf);
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		g_clear_error (&_inner_error_);
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
		return NULL;
#line 1424 "tracker-utils.c"
	}
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	result = pixbuf;
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-utils.vala"
	return result;
#line 1430 "tracker-utils.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



