@echo off

set FILENAME=%1

set COLOR=0.8,0.8,0.8
set PREVIEW=\PreviewEnvironment{definice} \PreviewEnvironment{veta} \PreviewEnvironment{definition} \PreviewEnvironment{figure} \PreviewEnvironment{theorem} 

set FBOXLENGTHS=\fboxrule=5pt\fboxsep=10pt

set FANCYOPTIONS=mouseover,movetips

echo "--------------------------"
echo "------ pdflatex ----------"
echo "--------------------------"
pdflatex %1.tex 
echo "-------------------------------------------"
echo "------ pdflatex with preview.sty ----------"
echo "-------------------------------------------"
pdflatex "\AtBeginDocument{\usepackage[pdftex,active,tightpage,floats,displaymath]{preview} %PREVIEW% \definecolor{backgroundcolor}{rgb}{%COLOR%}\pagecolor{backgroundcolor}\definecolor{shadethmcolor}{rgb}{%COLOR%} \definecolor{shaderulecolor}{rgb}{%COLOR%}} \input %1.tex"


findstr /b "\newlabel" %1.aux > %1.tmp
copy %1.pdf %1-tmp.pdf

echo "----------------------------------------------"
echo "------ pdflatex genearting tooltips ----------"
echo "----------------------------------------------"
pdflatex "\documentclass{minimal}\usepackage[papersize={5in,5in},margin=1pt]{geometry}\usepackage[createtips]{fancytooltips}\usepackage{color,graphicx}\begin{document} %FBOXLENGTHS%\relax \definecolor{backgroundcolor}{rgb}{%COLOR%}\gdef\savemaplabels#1#2#3#4{\xdef\temp{#2}} \def\maplabelstoall#1#2{\savemaplabels#2 \setbox0=\hbox{\colorbox{backgroundcolor}{\includegraphics[page=\temp]{%1-tmp.pdf}}}\pdfpagewidth=\wd0 \pdfpageheight=\ht0 \advance \pdfpageheight by \dp0 \copy0 \keytip{#1}\newpage} \let\newlabel\maplabelstoall \input %1.tmp\end{document}"

echo "----------------------------------------------"
echo "------ pdflatex final compilation 1 ----------"
echo "----------------------------------------------"
pdflatex "\PassOptionsToPackage{active,filename=minimal,%FANCYOPTIONS%}{fancytooltips}\input %1.tex"
echo "----------------------------------------------"
echo "------ pdflatex final compilation 2 ----------"
echo "----------------------------------------------"
pdflatex "\PassOptionsToPackage{active,filename=minimal,%FANCYOPTIONS%}{fancytooltips}\input %1.tex"
echo "----------------------------------------------"
echo "------ pdflatex final compilation 3 ----------"
echo "----------------------------------------------"
pdflatex "\PassOptionsToPackage{active,filename=minimal,%FANCYOPTIONS%}{fancytooltips}\input %1.tex"
echo "----------------------------------------------"
echo "------ pdflatex final compilation 4 ----------"
echo "----------------------------------------------"
pdflatex "\PassOptionsToPackage{active,filename=minimal,%FANCYOPTIONS%}{fancytooltips}\input %1.tex"

