.TH PDFETEX 1 "8 January 2007" "pdftex 1.40" "Web2C @VERSION@"
.\"=====================================================================
.if n .ds MF Metafont
.if t .ds MF M\s-2ETAFONT\s0
.if t .ds TX \fRT\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X\fP
.if n .ds TX TeX
.if n .ds MF Metafont
.if t .ds MF M\s-2ETAFONT\s0
.ie t .ds OX \fIT\v'+0.25m'E\v'-0.25m'X\fP\" for troff
.el .ds OX TeX\" for nroff
.\" the same but obliqued
.\" BX definition must follow TX so BX can use TX
.if t .ds BX \fRB\s-2IB\s0\fP\*(TX
.if n .ds BX BibTeX
.\" LX definition must follow TX so LX can use TX
.if t .ds LX \fRL\\h'-0.36m'\\v'-0.15v'\s-2A\s0\\h'-0.15m'\\v'0.15v'\fP\*(TX
.if n .ds LX LaTeX
.if t .ds AX \fRA\\h'-0.1667m'\\v'0.20v'M\\v'-0.20v'\\h'-0.125m'S\fP\*(TX
.if n .ds AX AmSTeX
.if t .ds AY \fRA\\h'-0.1667m'\\v'0.20v'M\\v'-0.20v'\\h'-0.125m'S\fP\*(LX
.if n .ds AY AmSLaTeX
.\"=====================================================================
.SH NAME
pdfetex, pdfeinitex, pdfevirtex \- PDF output from e-TeX
.SH SYNOPSIS
.B pdfetex
.RI [ options ]
[\fB&\fR \fIformat\fR ]
[ \fIfile\fR | \fB\e\fR \fIcommands\fR ]
.\"=====================================================================
.SH DESCRIPTION
Run the pdfe\*(TX typesetter on
.IR file ,
usually creating
.IR file.pdf .
If the file argument has no extension, ".tex" will be appended to it. 
Instead of a filename, a set of pdfe\*(TX commands can be given, the first
of which must start with a backslash.
With a 
.BI & format
argument pdfe\*(TX uses a different set of precompiled commands,
contained in
.IR format.fmt ;
it is usually better to use the
.B -fmt
.I format
option instead.
.PP
pdfe\*(TX is a version of e-\*(TX that can create
.I PDF
files as well as
.I DVI
files.
.PP
In
.I DVI
mode, pdfe\*(TX can be used as a complete replacement of the e-\*(TX
engine.
.PP
The typical use of pdfe\*(TX is with a pregenerated formats for which
PDF output has been enabled.  The
.B pdfetex
command uses the equivalent of the plain e-\*(TX format, and the
.B pdfelatex
command uses the equivalent of the e-\*(LX format.
To generate formats, use the
.B -ini
switch.
.PP
The 
.B pdfeinitex
and
.B pdfevirtex
commands are pdfe\*(TX's analogues to the
.B einitex
and
.B evirtex
commands.  In this installation, they are symbolic links to the
.B pdfetex
executable.  These symbolic links may not exist at all.
.PP
In
.I PDF
mode, pdfe\*(TX can natively handle the
.IR PDF ,
.IR JPG ,
.IR JBIG2 ,
and
.I PNG
graphics formats.  pdfe\*(TX cannot include PostScript or Encapsulated
PostScript (EPS) graphics files; first convert them to PDF using 
.BR epstopdf (1).
pdfe\*(TX's handling of its command-line arguments is similar to that of
of the other \*(TX programs in the
.I web2c
implementation.
.\"=====================================================================
.SH OPTIONS
This version of pdfe\*(TX understands the following command line options.
.TP
.B -draftmode
.rb
Sets \epdfdraftmode so pdf\*(TX doesn't write a PDF and doesn't read any
included images, thus speeding up execution.
.TP
.B -enc
.rb
Enable the enc\*(TX extensions.  This option is only effective in
combination with
.TP
.B -etex
.rb
Enable the e-\*(TX extensions.  This option is only effective in
combination with
.BR -ini .
See
.BR etex (1).
.TP
.BR -ini .
For documentation of the enc\*(TX extensions see
.BR http://www.olsak.net/enctex.html .
.B -file-line-error
.rb
Print error messages in the form
.I file:line:error
which is similar to the way many compilers format them.
.TP
.B -no-file-line-error
.rb
Disable printing error messages in the
.I file:line:error
style.
.TP
.B -file-line-error-style
.rb
This is the old name of the
.B -file-line-error
option.
.TP
.BI -fmt \ format
.rb
Use
.I format
as the name of the format to be used, instead of the name by which
pdfe\*(TX was called or a
.I %&
line.
.TP
.B -halt-on-error
.rb
Exit with an error code when an error is encountered during processing.
.TP
.B -help
.rb
Print help message and exit.
.TP
.B -ini
.rb
Start in
.I INI
mode, which is used to dump formats.  The
.I INI
mode can be used for typesetting, but no format is preloaded, and
basic initializations like setting catcodes may be required.
.TP
.BI -interaction \ mode
.rb
Sets the interaction mode.  The mode can be either
.IR batchmode ,
.IR nonstopmode ,
.IR scrollmode ,
and
.IR errorstopmode .
The meaning of these modes is the same as that of the corresponding
\ecommands.
.TP
.B -ipc
.rb
Send DVI or PDF output to a socket as well as the usual output file.
Whether this option is available is the choice of the installer.
.TP
.B -ipc-start
.rb
As
.BR -ipc ,
and starts the server at the other end as well.  Whether this option
is available is the choice of the installer.
.TP
.BI -jobname \ name
.rb
Use
.I name
for the job name, instead of deriving it from the name of the input file.
.TP
.BI -kpathsea-debug \ bitmask
.rb
Sets path searching debugging flags according to the bitmask.  See the
.I Kpathsea
manual for details.
.TP
.BI -mktex \ fmt
.rb
Enable
.RI mktex fmt ,
where
.I fmt
must be either
.I tex
or
.IR tfm .
.TP
.B -mltex
.rb
Enable ML\*(TX extensions.  Only effective in combination with
.BR -ini .
.TP
.BI -no-mktex \ fmt
.rb
Disable
.RI mktex fmt ,
where
.I fmt
must be either
.I tex
or
.IR tfm .
.TP
.BI -output-comment \ string
.rb
In
.I DVI
mode, use
.I string
for the
.I DVI
file comment instead of the date.  This option is ignored
in
.I PDF
mode.
.TP
.BI -output-directory \ directory
.rb Write output files in
.I directory
instead of the current directory.  Look up input files in
.I directory
first, the along the normal search path.
.TP
.BI -output-format \ format
.rb
Set the output format mode, where
.I format
must be either
.I pdf
or
.IR dvi .
This also influences the set of graphics formats understood by pdfe\*(TX.
.TP
.B -parse-first-line
.rb
If the first line of the main input file begins with
.I %&
parse it to look for a dump name or a
.B -translate-file
option.
.TP
.B -no-parse-first-line
.rb
Disable parsing of the first line of the main input file.
.TP
.BI -progname \ name
.rb
Pretend to be program
.IR name .
This affects both the format used and the search paths.
.TP
.B -recorder
.rb
Enable the filename recorder.
This leaves a trace of the files opened for input and output
in a file with extension
.IR .fls .
.TP
.B -shell-escape
.rb
Enable the
.BI \ewrite18{ command }
construct.  The
.I command
can be any shell command.  This construct is normally
disallowed for security reasons.
.TP
.B -no-shell-escape
.rb
Disable the
.BI \ewrite18{ command }
construct, even if it is enabled in the
.I texmf.cnf
file.
.TP
.B -src-specials
.rb
In
.I DVI
mode, insert source specials into the
.I DVI
file.
This option is ignored in
.I PDF
mode.
.TP
.BI -src-specials \ where
.rb
In
.I DVI
mode, insert source specials in certain placed of the
.I DVI
file.
.I where
is a comma-separated value list:
.IR cr ,
.IR display ,
.IR hbox ,
.IR math ,
.IR par ,
.IR parent ,
or
.IR vbox .
This option is ignored in
.I PDF
mode.
.TP
.BI -translate-file \ tcxname
.rb
Use the
.I tcxname
translation table to set the mapping of input characters and
re-mapping of output characters.
.TP
.BI -default-translate-file \ tcxname
.rb
Like
.B -translate-file
except that a
.I %&
line can overrule this setting.
.TP
.B -version
.rb
Print version information and exit.
.\"=====================================================================
.SH ENVIRONMENT
See the Kpathsearch library documentation (the `Path specifications'
node) for precise details of how the environment variables are used.
The
.B kpsewhich
utility can be used to query the values of the variables.
.PP
One caveat: In most pdfe\*(TX formats, you cannot use ~ in a filename you
give directly to pdfe\*(TX, because ~ is an active character, and hence is
expanded, not taken as part of the filename.  Other programs, such as
\*(MF, do not have this problem.
.PP
.TP
TEXMFOUTPUT
Normally, pdfe\*(TX puts its output files in the current directory.  If
any output file cannot be opened there, it tries to open it in the
directory specified in the environment variable TEXMFOUTPUT.
There is no default value for that variable.  For example, if you say
.I pdfetex paper
and the current directory is not writable, if TEXMFOUTPUT has
the value
.IR /tmp ,
pdfe\*(TX attempts to create
.I /tmp/paper.log
(and
.IR /tmp/paper.pdf ,
if any output is produced.)
.TP
TEXINPUTS
Search path for
.I \einput
and
.I \eopenin
files.
This should probably start with ``.'', so
that user files are found before system files.  An empty path
component will be replaced with the paths defined in the
.I texmf.cnf
file.  For example, set TEXINPUTS to ".:/home/usr/tex:" to prepend the
current directory and ``/home/user/tex'' to the standard search path.
.TP
TEXFORMATS
Search path for format files.
.TP
TEXPOOL
search path for
.B pdfetex
internal strings.
.TP
TEXEDIT
Command template for switching to editor.  The default, usually
.BR vi ,
is set when pdfe\*(TX is compiled.
.TP
TFMFONTS
Search path for font metric
.RI ( .tfm )
files.
.\"=====================================================================
.SH FILES
The location of the files mentioned below varies from system to
system.  Use the
.B kpsewhich
utility to find their locations.
.TP
.I pdfetex.pool
Text file containing pdfe\*(TX's internal strings.
.TP
.I pdftex.map
Filename mapping definitions.
.TP
.I *.tfm
Metric files for pdfe\*(TX's fonts.
.TP
.I *.fmt
Predigested pdfe\*(TX format (.\|fmt) files.
.br
.\"=====================================================================
.SH NOTES
Starting with version 1.40, pdf\*(TX incorporates the e-\*(TX
extensions, and pdfe\*(TX is just a copy of pdf\*(TX.  See 
.BR pdftex (1).
This manual page is not meant to be exhaustive.  The complete
documentation for this version of pdfe\*(TX can be found in the 
.IR "pdf\*(TX manual"
and the info manual
.IR "Web2C: A TeX implementation" .
.\"=====================================================================
.SH BUGS
This version of pdfe\*(TX implements a number of optional extensions.
In fact, many of these extensions conflict to a greater or lesser
extent with the definition of pdfe\*(TX.  When such extensions are
enabled, the banner printed when pdfe\*(TX starts is changed to print
.B pdfeTeXk
instead of
.BR pdfeTeX .
.PP
This version of pdfe\*(TX fails to trap arithmetic overflow when
dimensions are added or subtracted.  Cases where this occurs are rare,
but when it does the generated
.I DVI
file will be invalid.  Whether a generated
.I PDF
file would be usable is unknown.
.\"=====================================================================
.SH AVAILABILITY
pdfe\*(TX is available for a large variety of machine architectures
and operation systems.
pdfe\*(TX is part of all major \*(TX distributions.
.P
Information on how to get pdfe\*(TX and related information
is available at the
.B http://www.pdftex.org
.IR "pdf\*(TX"
website.
.P
The following pdf\*(TX related mailing list is available:
.BR pdftex@tug.org .
This is a mailman list;
to subscribe send a message containing
.I subscribe
to
.BR pdftex-request@tug.org .
More about the list can be found at the
.B "http://tug.org/mailman/listinfo/pdftex"
.I mailing list
website.
.\"=====================================================================
.SH "SEE ALSO"
.BR etex (1),
.BR mf (1),
.BR pdftex (1),
.BR tex (1).
.\"=====================================================================
.SH AUTHORS
The primary authors of pdfe\*(TX are Han The Thanh, Petr Sojka,
Jiri Zlatuska, and Peter Breitenlohner (e\*(TX).
.PP
\*(TX was designed by Donald E. Knuth,
who implemented it using his \*(WB system for Pascal programs.
It was ported to Unix at Stanford by Howard Trickey, and
at Cornell by Pavel Curtis.
The version now offered with the Unix \*(TX distribution is that
generated by the \*(WB to C system
.RB ( web2c ),
originally written by Tomas Rokicki and Tim Morgan.
.PP
The enc\*(TX extensions were written by Petr Olsak.
.\" vim: syntax=nroff
