/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.LCount;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.events.MutationEventImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;

public abstract class ParentNode
extends ChildNode {
    static final long serialVersionUID = 2815829867152120872L;
    protected DocumentImpl ownerDocument;
    protected ChildNode firstChild = null;
    protected transient int fCachedLength = -1;
    protected transient ChildNode fCachedChild;
    protected transient int fCachedChildIndex = -1;

    protected ParentNode(DocumentImpl documentImpl) {
        super(documentImpl);
        this.ownerDocument = documentImpl;
    }

    public ParentNode() {
    }

    public Node cloneNode(boolean bl) {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        ParentNode parentNode = (ParentNode)super.cloneNode(bl);
        parentNode.ownerDocument = this.ownerDocument;
        parentNode.firstChild = null;
        parentNode.fCachedChildIndex = -1;
        parentNode.fCachedLength = -1;
        if (bl) {
            ChildNode childNode = this.firstChild;
            while (childNode != null) {
                parentNode.appendChild(childNode.cloneNode(true));
                childNode = childNode.nextSibling;
            }
        }
        return parentNode;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    DocumentImpl ownerDocument() {
        return this.ownerDocument;
    }

    void setOwnerDocument(DocumentImpl documentImpl) {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        super.setOwnerDocument(documentImpl);
        this.ownerDocument = documentImpl;
        ChildNode childNode = this.firstChild;
        while (childNode != null) {
            childNode.setOwnerDocument(documentImpl);
            childNode = childNode.nextSibling;
        }
    }

    public boolean hasChildNodes() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.firstChild != null;
    }

    public NodeList getChildNodes() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this;
    }

    public Node getFirstChild() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.firstChild;
    }

    public Node getLastChild() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.lastChild();
    }

    final ChildNode lastChild() {
        return this.firstChild != null ? this.firstChild.previousSibling : null;
    }

    final void lastChild(ChildNode childNode) {
        if (this.firstChild != null) {
            this.firstChild.previousSibling = childNode;
        }
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        return this.internalInsertBefore(node, node2, 65535);
    }

    Node internalInsertBefore(Node node, Node node2, int n) throws DOMException {
        Object object;
        NodeImpl nodeImpl;
        Object object2;
        boolean bl = this.ownerDocument.errorChecking;
        if (node.getNodeType() == 11) {
            if (bl) {
                Node node3 = node.getFirstChild();
                while (node3 != null) {
                    if (!this.ownerDocument.isKidOK(this, node3)) {
                        throw new DOMException(3, "DOM006 Hierarchy request error");
                    }
                    node3 = node3.getNextSibling();
                }
            }
            while (node.hasChildNodes()) {
                this.insertBefore(node.getFirstChild(), node2);
            }
            return node;
        }
        if (node == node2) {
            node2 = node2.getNextSibling();
            this.removeChild(node);
            this.insertBefore(node, node2);
            return node;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (bl) {
            if (this.isReadOnly()) {
                throw new DOMException(7, "DOM001 Modification not allowed");
            }
            if (node.getOwnerDocument() != this.ownerDocument) {
                throw new DOMException(4, "DOM005 Wrong document");
            }
            if (!this.ownerDocument.isKidOK(this, node)) {
                throw new DOMException(3, "DOM006 Hierarchy request error");
            }
            if (node2 != null && node2.getParentNode() != this) {
                throw new DOMException(8, "DOM008 Not found");
            }
            boolean bl2 = true;
            object2 = this;
            while (bl2 && object2 != null) {
                bl2 = node != object2;
                object2 = ((NodeImpl)object2).parentNode();
            }
            if (!bl2) {
                throw new DOMException(3, "DOM006 Hierarchy request error");
            }
        }
        NodeImpl.EnclosingAttr enclosingAttr = null;
        if (this.ownerDocument.mutationEvents && (n & 2) != 0) {
            object2 = LCount.lookup("DOMAttrModified");
            if (((LCount)object2).captures + ((LCount)object2).bubbles + ((LCount)object2).defaults > 0) {
                enclosingAttr = this.getEnclosingAttr();
            }
        }
        if ((nodeImpl = ((ChildNode)(object2 = (ChildNode)node)).parentNode()) != null) {
            nodeImpl.removeChild((Node)object2);
        }
        ChildNode childNode = (ChildNode)node2;
        ((NodeImpl)object2).ownerNode = this;
        ((NodeImpl)object2).isOwned(true);
        if (this.firstChild == null) {
            this.firstChild = object2;
            ((NodeImpl)object2).isFirstChild(true);
            ((ChildNode)object2).previousSibling = object2;
        } else if (childNode == null) {
            object = this.firstChild.previousSibling;
            ((ChildNode)object).nextSibling = object2;
            ((ChildNode)object2).previousSibling = object;
            this.firstChild.previousSibling = object2;
        } else if (node2 == this.firstChild) {
            this.firstChild.isFirstChild(false);
            ((ChildNode)object2).nextSibling = this.firstChild;
            ((ChildNode)object2).previousSibling = this.firstChild.previousSibling;
            this.firstChild.previousSibling = object2;
            this.firstChild = object2;
            ((NodeImpl)object2).isFirstChild(true);
        } else {
            object = childNode.previousSibling;
            ((ChildNode)object2).nextSibling = childNode;
            ((ChildNode)object).nextSibling = object2;
            childNode.previousSibling = object2;
            ((ChildNode)object2).previousSibling = object;
        }
        this.changed();
        if (this.fCachedLength != -1) {
            ++this.fCachedLength;
        }
        if (this.fCachedChildIndex != -1) {
            if (this.fCachedChild == childNode) {
                this.fCachedChild = object2;
            } else {
                this.fCachedChildIndex = -1;
            }
        }
        if (this.ownerDocument.mutationEvents) {
            if ((n & 1) != 0) {
                Object object3;
                object = LCount.lookup("DOMNodeInserted");
                if (((LCount)object).captures + ((LCount)object).bubbles + ((LCount)object).defaults > 0) {
                    object3 = new MutationEventImpl();
                    object3.initMutationEvent("DOMNodeInserted", true, false, this, null, null, null, (short)0);
                    ((NodeImpl)object2).dispatchEvent((Event)object3);
                }
                object = LCount.lookup("DOMNodeInsertedIntoDocument");
                if (((LCount)object).captures + ((LCount)object).bubbles + ((LCount)object).defaults > 0) {
                    object3 = this;
                    if (enclosingAttr != null) {
                        object3 = (NodeImpl)((Object)enclosingAttr.node.getOwnerElement());
                    }
                    if (object3 != null) {
                        Object object4 = object3;
                        while (object4 != null) {
                            object3 = object4;
                            object4 = ((NodeImpl)object4).getNodeType() == 2 ? (ElementImpl)((AttrImpl)object4).getOwnerElement() : ((NodeImpl)object4).parentNode();
                        }
                        if (((NodeImpl)object3).getNodeType() == 9) {
                            MutationEventImpl mutationEventImpl = new MutationEventImpl();
                            mutationEventImpl.initMutationEvent("DOMNodeInsertedIntoDocument", false, false, null, null, null, null, (short)0);
                            this.dispatchEventToSubtree((Node)object2, mutationEventImpl);
                        }
                    }
                }
            }
            if ((n & 2) != 0) {
                this.dispatchAggregateEvents(enclosingAttr);
            }
        }
        this.checkNormalizationAfterInsert((ChildNode)object2);
        return node;
    }

    public Node removeChild(Node node) throws DOMException {
        return this.internalRemoveChild(node, 65535);
    }

    Node internalRemoveChild(Node node, int n) throws DOMException {
        Object object;
        Object object2;
        DocumentImpl documentImpl = this.ownerDocument();
        if (documentImpl.errorChecking) {
            if (this.isReadOnly()) {
                throw new DOMException(7, "DOM001 Modification not allowed");
            }
            if (node != null && node.getParentNode() != this) {
                throw new DOMException(8, "DOM008 Not found");
            }
        }
        documentImpl.removedChildNode(node);
        ChildNode childNode = (ChildNode)node;
        NodeImpl.EnclosingAttr enclosingAttr = null;
        if (documentImpl.mutationEvents) {
            object2 = LCount.lookup("DOMAttrModified");
            if (((LCount)object2).captures + ((LCount)object2).bubbles + ((LCount)object2).defaults > 0) {
                enclosingAttr = this.getEnclosingAttr();
            }
            if ((n & 1) != 0) {
                object2 = LCount.lookup("DOMNodeRemoved");
                if (((LCount)object2).captures + ((LCount)object2).bubbles + ((LCount)object2).defaults > 0) {
                    object = new MutationEventImpl();
                    object.initMutationEvent("DOMNodeRemoved", true, false, this, null, null, null, (short)0);
                    childNode.dispatchEvent((Event)object);
                }
                object2 = LCount.lookup("DOMNodeRemovedFromDocument");
                if (((LCount)object2).captures + ((LCount)object2).bubbles + ((LCount)object2).defaults > 0) {
                    object = this;
                    if (enclosingAttr != null) {
                        object = (NodeImpl)((Object)enclosingAttr.node.getOwnerElement());
                    }
                    if (object != null) {
                        NodeImpl nodeImpl = ((NodeImpl)object).parentNode();
                        while (nodeImpl != null) {
                            object = nodeImpl;
                            nodeImpl = nodeImpl.parentNode();
                        }
                        if (((NodeImpl)object).getNodeType() == 9) {
                            MutationEventImpl mutationEventImpl = new MutationEventImpl();
                            mutationEventImpl.initMutationEvent("DOMNodeRemovedFromDocument", false, false, null, null, null, null, (short)0);
                            this.dispatchEventToSubtree(childNode, mutationEventImpl);
                        }
                    }
                }
            }
        }
        if (this.fCachedLength != -1) {
            --this.fCachedLength;
        }
        if (this.fCachedChildIndex != -1) {
            if (this.fCachedChild == childNode) {
                --this.fCachedChildIndex;
                this.fCachedChild = childNode.previousSibling();
            } else {
                this.fCachedChildIndex = -1;
            }
        }
        if (childNode == this.firstChild) {
            childNode.isFirstChild(false);
            this.firstChild = childNode.nextSibling;
            if (this.firstChild != null) {
                this.firstChild.isFirstChild(true);
                this.firstChild.previousSibling = childNode.previousSibling;
            }
        } else {
            object2 = childNode.previousSibling;
            object = childNode.nextSibling;
            ((ChildNode)object2).nextSibling = object;
            if (object == null) {
                this.firstChild.previousSibling = object2;
            } else {
                ((ChildNode)object).previousSibling = object2;
            }
        }
        object2 = childNode.previousSibling();
        childNode.ownerNode = documentImpl;
        childNode.isOwned(false);
        childNode.nextSibling = null;
        childNode.previousSibling = null;
        this.changed();
        if (documentImpl.mutationEvents && (n & 2) != 0) {
            this.dispatchAggregateEvents(enclosingAttr);
        }
        this.checkNormalizationAfterRemove((ChildNode)object2);
        return childNode;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        NodeImpl.EnclosingAttr enclosingAttr = null;
        if (this.ownerDocument.mutationEvents) {
            LCount lCount = LCount.lookup("DOMAttrModified");
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                enclosingAttr = this.getEnclosingAttr();
            }
        }
        this.internalInsertBefore(node, node2, 1);
        if (node != node2) {
            this.internalRemoveChild(node2, 1);
        }
        if (this.ownerDocument.mutationEvents) {
            this.dispatchAggregateEvents(enclosingAttr);
        }
        return node2;
    }

    private int nodeListGetLength() {
        if (this.fCachedLength == -1) {
            ChildNode childNode;
            if (this.fCachedChildIndex != -1 && this.fCachedChild != null) {
                this.fCachedLength = this.fCachedChildIndex;
                childNode = this.fCachedChild;
            } else {
                childNode = this.firstChild;
                this.fCachedLength = 0;
            }
            while (childNode != null) {
                ++this.fCachedLength;
                childNode = childNode.nextSibling;
            }
        }
        return this.fCachedLength;
    }

    public int getLength() {
        return this.nodeListGetLength();
    }

    private Node nodeListItem(int n) {
        if (this.fCachedChildIndex != -1 && this.fCachedChild != null) {
            if (this.fCachedChildIndex < n) {
                while (this.fCachedChildIndex < n && this.fCachedChild != null) {
                    ++this.fCachedChildIndex;
                    this.fCachedChild = this.fCachedChild.nextSibling;
                }
            } else if (this.fCachedChildIndex > n) {
                while (this.fCachedChildIndex > n && this.fCachedChild != null) {
                    --this.fCachedChildIndex;
                    this.fCachedChild = this.fCachedChild.previousSibling();
                }
            }
            return this.fCachedChild;
        }
        this.fCachedChild = this.firstChild;
        this.fCachedChildIndex = 0;
        while (this.fCachedChildIndex < n && this.fCachedChild != null) {
            this.fCachedChild = this.fCachedChild.nextSibling;
            ++this.fCachedChildIndex;
        }
        return this.fCachedChild;
    }

    public Node item(int n) {
        return this.nodeListItem(n);
    }

    protected final NodeList getChildNodesUnoptimized() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return new NodeList(){

            public int getLength() {
                return ParentNode.this.nodeListGetLength();
            }

            public Node item(int n) {
                return ParentNode.this.nodeListItem(n);
            }
        };
    }

    public void normalize() {
        if (this.isNormalized()) {
            return;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        ChildNode childNode = this.firstChild;
        while (childNode != null) {
            childNode.normalize();
            childNode = childNode.nextSibling;
        }
        this.isNormalized(true);
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        super.setReadOnly(bl, bl2);
        if (bl2) {
            if (this.needsSyncChildren()) {
                this.synchronizeChildren();
            }
            ChildNode childNode = this.firstChild;
            while (childNode != null) {
                if (childNode.getNodeType() != 5) {
                    childNode.setReadOnly(bl, true);
                }
                childNode = childNode.nextSibling;
            }
        }
    }

    protected void synchronizeChildren() {
        this.needsSyncChildren(false);
    }

    protected final void synchronizeChildren(int n) {
        boolean bl = this.ownerDocument.mutationEvents;
        this.ownerDocument.mutationEvents = false;
        this.needsSyncChildren(false);
        DeferredDocumentImpl deferredDocumentImpl = (DeferredDocumentImpl)this.ownerDocument;
        NodeImpl nodeImpl = null;
        ChildNode childNode = null;
        int n2 = deferredDocumentImpl.getLastChild(n);
        while (n2 != -1) {
            ChildNode childNode2 = (ChildNode)((Object)deferredDocumentImpl.getNodeObject(n2));
            if (childNode == null) {
                childNode = childNode2;
            } else {
                ((ChildNode)nodeImpl).previousSibling = childNode2;
            }
            childNode2.ownerNode = this;
            childNode2.isOwned(true);
            childNode2.nextSibling = nodeImpl;
            nodeImpl = childNode2;
            n2 = deferredDocumentImpl.getPrevSibling(n2);
        }
        if (childNode != null) {
            this.firstChild = nodeImpl;
            nodeImpl.isFirstChild(true);
            this.lastChild(childNode);
        }
        deferredDocumentImpl.mutationEvents = bl;
    }

    void checkNormalizationAfterInsert(ChildNode childNode) {
        if (childNode.getNodeType() == 3) {
            ChildNode childNode2 = childNode.previousSibling();
            ChildNode childNode3 = childNode.nextSibling;
            if (childNode2 != null && childNode2.getNodeType() == 3 || childNode3 != null && childNode3.getNodeType() == 3) {
                this.isNormalized(false);
            }
        } else if (!childNode.isNormalized()) {
            this.isNormalized(false);
        }
    }

    void checkNormalizationAfterRemove(ChildNode childNode) {
        ChildNode childNode2;
        if (childNode != null && childNode.getNodeType() == 3 && (childNode2 = childNode.nextSibling) != null && childNode2.getNodeType() == 3) {
            this.isNormalized(false);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.needsSyncChildren(false);
        this.fCachedLength = -1;
        this.fCachedChildIndex = -1;
    }
}

