/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.ParaProfTrial;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PrefSpacingPanel
extends JPanel
implements ChangeListener {
    private ParaProfTrial trial = null;
    int xPanelSize = 600;
    int yPanelSize = 200;
    int barXStart = -1;
    int barXCoord = -1;
    int yCoord = -1;
    int barSpacing = -1;
    int barHeight = -1;
    Color tmpColor;

    public PrefSpacingPanel(ParaProfTrial paraProfTrial) {
        this.trial = paraProfTrial;
        this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
        this.setPreferredSize(new Dimension(this.xPanelSize, this.yPanelSize));
        this.setBackground(Color.white);
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        int n;
        String string;
        int n2;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.trial.getPreferences().setBarDetails(graphics2D);
        this.barSpacing = this.trial.getPreferences().getBarSpacing();
        this.barHeight = this.trial.getPreferences().getBarHeight();
        this.yCoord = 25 + this.barHeight;
        Font font = new Font(this.trial.getPreferences().getParaProfFont(), this.trial.getPreferences().getFontStyle(), this.barHeight);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int n3 = 0;
        for (n2 = 0; n2 < 3; ++n2) {
            string = "n,c,t    0,0," + n2;
            n = fontMetrics.stringWidth(string);
            if (n3 >= n) continue;
            n3 = n;
        }
        this.barXCoord = this.barXStart = n3 + 25;
        for (n2 = 0; n2 < 3; ++n2) {
            string = "n,c,t    0,0," + n2;
            n = fontMetrics.stringWidth(string);
            graphics2D.drawString(string, this.barXStart - n - 5, this.yCoord);
            for (int i = 0; i < 3; ++i) {
                this.tmpColor = this.trial.getColorChooser().getColor(i);
                graphics2D.setColor(this.tmpColor);
                graphics2D.fillRect(this.barXCoord, this.yCoord - this.barHeight, 40, this.barHeight);
                this.barXCoord += 30;
            }
            this.barXCoord = this.barXStart;
            graphics2D.setColor(Color.black);
            this.yCoord += this.barSpacing;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize + 10, this.yPanelSize + 10);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.trial.getPreferences().updateFontSize();
        this.repaint();
    }
}

