/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.MapMath;
import com.jhlabs.map.proj.Projection;
import com.jhlabs.map.proj.ProjectionException;
import java.awt.geom.Point2D;

public class URMFPSProjection
extends Projection {
    private static final double C_x = 0.8773826753;
    private static final double Cy = 1.139753528477;
    private double n = 0.8660254037844386;
    private double C_y;

    public Point2D.Double project(double lplam, double lpphi, Point2D.Double out) {
        out.y = MapMath.asin(this.n * Math.sin(lpphi));
        out.x = 0.8773826753 * lplam * Math.cos(lpphi);
        out.y = this.C_y * lpphi;
        return out;
    }

    public Point2D.Double projectInverse(double xyx, double xyy, Point2D.Double out) {
        out.y = MapMath.asin(Math.sin(xyy /= this.C_y) / this.n);
        out.x = xyx / (0.8773826753 * Math.cos(xyy));
        return out;
    }

    public boolean hasInverse() {
        return true;
    }

    public void initialize() {
        super.initialize();
        if (this.n <= 0.0 || this.n > 1.0) {
            throw new ProjectionException("-40");
        }
        this.C_y = 1.139753528477 / this.n;
    }

    public void setN(double n) {
        this.n = n;
    }

    public double getN() {
        return this.n;
    }

    public String toString() {
        return "Urmaev Flat-Polar Sinusoidal";
    }
}

