/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.proj.Projection;
import com.jhlabs.map.proj.ProjectionException;
import java.awt.geom.Point2D;

public class HatanoProjection
extends Projection {
    private static final int NITER = 20;
    private static final double EPS = 1.0E-7;
    private static final double ONETOL = 1.000001;
    private static final double CN = 2.67595;
    private static final double CS = 2.43763;
    private static final double RCN = 0.3736990601468637;
    private static final double RCS = 0.4102345310814193;
    private static final double FYCN = 1.75859;
    private static final double FYCS = 1.93052;
    private static final double RYCN = 0.5686373742600607;
    private static final double RYCS = 0.5179951515653813;
    private static final double FXC = 0.85;
    private static final double RXC = 1.1764705882352942;

    public Point2D.Double project(double lplam, double lpphi, Point2D.Double out) {
        double c = Math.sin(lpphi) * (lpphi < 0.0 ? 2.43763 : 2.67595);
        for (int i = 20; i > 0; --i) {
            double th1 = (lpphi + Math.sin(lpphi) - c) / (1.0 + Math.cos(lpphi));
            lpphi -= th1;
            if (Math.abs(th1) < 1.0E-7) break;
        }
        out.x = 0.85 * lplam * Math.cos(lpphi *= 0.5);
        out.y = Math.sin(lpphi) * (lpphi < 0.0 ? 1.93052 : 1.75859);
        return out;
    }

    public Point2D.Double projectInverse(double xyx, double xyy, Point2D.Double out) {
        double th = xyy * (xyy < 0.0 ? 0.5179951515653813 : 0.5686373742600607);
        if (Math.abs(th) > 1.0) {
            if (Math.abs(th) > 1.000001) {
                throw new ProjectionException("I");
            }
            th = th > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        } else {
            th = Math.asin(th);
        }
        out.x = 1.1764705882352942 * xyx / Math.cos(th);
        th += th;
        out.y = (th + Math.sin(th)) * (xyy < 0.0 ? 0.4102345310814193 : 0.3736990601468637);
        if (Math.abs(out.y) > 1.0) {
            if (Math.abs(out.y) > 1.000001) {
                throw new ProjectionException("I");
            }
            out.y = out.y > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        } else {
            out.y = Math.asin(out.y);
        }
        return out;
    }

    public boolean hasInverse() {
        return true;
    }

    public String toString() {
        return "Hatano Asymmetrical Equal Area";
    }
}

