/*
 * Decompiled with CFR 0.152.
 */
package cadyts.interfaces.dracula;

import cadyts.calibrators.filebased.ChoiceFileWriter;
import cadyts.interfaces.dracula.DraculaAgent;
import cadyts.interfaces.dracula.DraculaCalibrator;
import cadyts.interfaces.dracula.DraculaPlan;
import cadyts.interfaces.dracula.DraculaPopulation;
import cadyts.interfaces.dracula.DraculaRoutes;
import cadyts.interfaces.dracula.DraculaTravelTimes;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;

class DraculaChoiceWriter
implements ChoiceFileWriter<DraculaAgent, DraculaPlan> {
    private final DraculaCalibrator calibrator;
    private String choiceFile;
    private PrintWriter writer = null;
    private long agentCnt = 0L;

    DraculaChoiceWriter(DraculaCalibrator calibrator) {
        if (calibrator == null) {
            throw new IllegalArgumentException("calibrator is null");
        }
        this.calibrator = calibrator;
    }

    private String tmpFileName() {
        return String.valueOf(this.choiceFile) + ".TMP";
    }

    @Override
    public void open(String choiceFile) throws IOException {
        this.choiceFile = choiceFile;
        this.writer = new PrintWriter(this.tmpFileName());
        this.agentCnt = 0L;
    }

    @Override
    public void write(DraculaAgent agent, DraculaPlan plan) throws IOException {
        this.writer.print(agent.getId());
        this.writer.print("\t");
        this.writer.print(agent.getDepartureTime_s() - this.calibrator.getWarmUp_s());
        this.writer.print("\t");
        this.writer.print(plan.getRoute().getId());
        if (agent.getMisc() != null) {
            String[] stringArray = agent.getMisc();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String misc = stringArray[n2];
                this.writer.print("\t");
                this.writer.print(misc);
                ++n2;
            }
        }
        this.writer.println();
        ++this.agentCnt;
    }

    @Override
    public void close() throws IOException {
        String line;
        this.writer.flush();
        this.writer.close();
        BufferedReader reader = new BufferedReader(new FileReader(this.tmpFileName()));
        this.writer = new PrintWriter(this.choiceFile);
        this.writer.println(this.agentCnt);
        while ((line = reader.readLine()) != null) {
            this.writer.println(line);
        }
        this.writer.flush();
        this.writer.close();
        reader.close();
        boolean tmpDel = new File(this.tmpFileName()).delete();
        if (!tmpDel) {
            Logger.getLogger(this.getClass().getName()).warning("could not delete temporary file " + this.tmpFileName());
        }
    }

    public static void main(String[] args) throws Exception {
        DraculaCalibrator calibrator = new DraculaCalibrator(null, null, 3600);
        DraculaRoutes routes = new DraculaRoutes("C:\\dracula\\otley\\otley.dem", calibrator);
        System.out.println("LOADED ROUTES FROM .DEM FILE");
        calibrator.setRoutes(routes);
        DraculaTravelTimes travelTimes = new DraculaTravelTimes("C:\\dracula\\otley\\otley.ltt", calibrator);
        System.out.println("LOADED TRAVEL TIMES FROM .LTT FILE");
        calibrator.setTravelTimes(travelTimes);
        DraculaPopulation r = new DraculaPopulation(calibrator);
        System.out.println("LOADED TRAVEL DEMAND FROM .VEH FILE");
        Iterable<DraculaAgent> s = r.getPopulationSource("C:\\dracula\\otley\\otley.veh");
        DraculaChoiceWriter w = new DraculaChoiceWriter(calibrator);
        w.open("C:\\dracula\\otley\\otley.veh.test");
        for (DraculaAgent a : s) {
            w.write(a, (DraculaPlan)a.getPlans().get(0));
        }
        w.close();
        System.out.println("WROTE C:\\dracula\\otley\\otley.veh.test");
        System.out.println("DONE");
    }
}

