/*
 * Decompiled with CFR 0.152.
 */
package bioroute.pathgenerator.metropolishastings;

import bioroute.pathgenerator.metropolishastings.MHPath;
import cadyts.supply.network.Link;
import cadyts.supply.network.Network;
import cadyts.utilities.config.Config;
import cadyts.utilities.math.metropolishastings.MHWeight;
import cadyts.utilities.math.networks.LinkCost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MHLinkCostPathWeight
implements LinkCost,
MHWeight<MHPath> {
    private static final String LINKCOST_ELEMENT = "linkcost";
    private static final String ATTRIBUTE_ELEMENT = "attribute";
    private static final String COEFFICIENT_ELEMENT = "coefficient";
    private Double scale = null;
    private List<String> attributes = null;
    private List<Double> coefficients = null;
    private Map<Link, Double> link2weight = null;

    public void configure(Config config) {
        this.scale = Double.parseDouble(config.get("pathgenerator", "scale"));
        this.attributes = config.getListView("pathgenerator", LINKCOST_ELEMENT, ATTRIBUTE_ELEMENT);
        this.coefficients = new ArrayList<Double>(this.attributes.size());
        int i = 0;
        while (i < this.attributes.size()) {
            this.coefficients.add(Double.parseDouble(config.get(i, "pathgenerator", LINKCOST_ELEMENT, COEFFICIENT_ELEMENT)));
            ++i;
        }
    }

    public void initialize(Network network) {
        this.link2weight = new HashMap<Link, Double>();
        for (Link link : network.getLinks()) {
            double weight = 0.0;
            int i = 0;
            while (i < this.attributes.size()) {
                weight += this.coefficients.get(i) * Double.parseDouble(link.getAttr(this.attributes.get(i)));
                ++i;
            }
            this.link2weight.put(link, weight);
        }
    }

    @Override
    public double getCost(Link link) {
        return this.link2weight.get(link);
    }

    @Override
    public double logWeight(MHPath path) {
        double pathCost = 0.0;
        for (Link link : path.getLinks()) {
            pathCost += this.getCost(link);
        }
        return -this.scale.doubleValue() * pathCost - Math.log(path.pointCombinationSize());
    }
}

