/*
 * Decompiled with CFR 0.152.
 */
package ui.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import simulation.VehicleType;
import ui.dialogs.DlgAddEditVehicleType;

public class DlgManageVehicleTypes
extends JDialog {
    private static final long serialVersionUID = 1L;
    private List<VehicleType> vehicleTypes = null;
    private JButton btnDelete = null;
    private JButton btnEdit = null;
    private JButton btnNew = null;
    private JButton btnOK = null;
    private JPanel jContentPane = null;
    private JLabel lblVehicleTypes = null;
    private JList lstVehicleTypes = null;
    private JScrollPane scrlVehicleTypes = null;

    public DlgManageVehicleTypes(Frame owner, List<VehicleType> vehicleTypes) {
        super(owner);
        this.initialize();
        this.vehicleTypes = vehicleTypes;
        this.lstVehicleTypes.setModel(new DefaultComboBoxModel<Object>(this.vehicleTypes.toArray()));
        this.setVisible(true);
    }

    public List<VehicleType> getVehicleTypes() {
        return this.vehicleTypes;
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton();
            this.btnDelete.setBounds(new Rectangle(174, 90, 101, 22));
            this.btnDelete.setEnabled(false);
            this.btnDelete.setToolTipText("Delete the currently selected vehicle type");
            this.btnDelete.setHorizontalAlignment(2);
            this.btnDelete.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/deletevehicletype.png")));
            this.btnDelete.setText("Delete...");
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgManageVehicleTypes.this.DeleteVehicleType((VehicleType)DlgManageVehicleTypes.this.lstVehicleTypes.getSelectedValue());
                }
            });
        }
        return this.btnDelete;
    }

    private JButton getBtnEdit() {
        if (this.btnEdit == null) {
            this.btnEdit = new JButton();
            this.btnEdit.setBounds(new Rectangle(174, 59, 101, 22));
            this.btnEdit.setEnabled(false);
            this.btnEdit.setHorizontalAlignment(2);
            this.btnEdit.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/editvehicletype.png")));
            this.btnEdit.setToolTipText("Edit the currently selected vehicle type");
            this.btnEdit.setText("Edit...");
            this.btnEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgManageVehicleTypes.this.EditVehicleType((VehicleType)DlgManageVehicleTypes.this.lstVehicleTypes.getSelectedValue());
                }
            });
        }
        return this.btnEdit;
    }

    private JButton getBtnNew() {
        if (this.btnNew == null) {
            this.btnNew = new JButton();
            this.btnNew.setBounds(new Rectangle(174, 26, 101, 22));
            this.btnNew.setHorizontalAlignment(2);
            this.btnNew.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/addvehicletype.png")));
            this.btnNew.setToolTipText("Create a new vehicle type");
            this.btnNew.setText("New...");
            this.btnNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgManageVehicleTypes.this.NewVehicleType();
                }
            });
        }
        return this.btnNew;
    }

    private JButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JButton();
            this.btnOK.setBounds(new Rectangle(174, 136, 101, 22));
            this.btnOK.setText("OK");
            this.btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgManageVehicleTypes.this.OKClicked();
                }
            });
        }
        return this.btnOK;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.lblVehicleTypes = new JLabel();
            this.lblVehicleTypes.setBounds(new Rectangle(10, 3, 120, 21));
            this.lblVehicleTypes.setText("Vehicle types:");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getScrlVehicleTypes(), null);
            this.jContentPane.add((Component)this.lblVehicleTypes, null);
            this.jContentPane.add((Component)this.getBtnNew(), null);
            this.jContentPane.add((Component)this.getBtnEdit(), null);
            this.jContentPane.add((Component)this.getBtnDelete(), null);
            this.jContentPane.add((Component)this.getBtnOK(), null);
        }
        return this.jContentPane;
    }

    private JList getLstVehicleTypes() {
        if (this.lstVehicleTypes == null) {
            this.lstVehicleTypes = new JList();
            this.lstVehicleTypes.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    DlgManageVehicleTypes.this.SelectedVehicleTypeChanged();
                }
            });
        }
        return this.lstVehicleTypes;
    }

    private JScrollPane getScrlVehicleTypes() {
        if (this.scrlVehicleTypes == null) {
            this.scrlVehicleTypes = new JScrollPane();
            this.scrlVehicleTypes.setBounds(new Rectangle(9, 26, 160, 134));
            this.scrlVehicleTypes.setViewportView(this.getLstVehicleTypes());
        }
        return this.scrlVehicleTypes;
    }

    private void initialize() {
        this.setSize(289, 198);
        this.setResizable(false);
        this.setModal(true);
        this.setTitle("Select vehicle types");
        this.setContentPane(this.getJContentPane());
    }

    protected void DeleteVehicleType(VehicleType type) {
        if (type.getName().equals("Default")) {
            JOptionPane.showMessageDialog(this, "The default vehicle type can not be deleted");
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to delete the vehicle type " + type.getName() + "?") == 0) {
            this.vehicleTypes.remove(type);
            ((DefaultComboBoxModel)this.lstVehicleTypes.getModel()).removeElement(type);
            this.lstVehicleTypes.updateUI();
        }
    }

    protected void EditVehicleType(VehicleType selectedVehicleType) {
        DlgAddEditVehicleType dlg = new DlgAddEditVehicleType((Dialog)this, selectedVehicleType);
        if (dlg.getAnswer() == 0) {
            this.lstVehicleTypes.updateUI();
        }
    }

    protected void NewVehicleType() {
        DlgAddEditVehicleType dlg = new DlgAddEditVehicleType(this);
        if (dlg.getAnswer() == 0) {
            this.vehicleTypes.add(dlg.getVehicleType());
            ((DefaultComboBoxModel)this.lstVehicleTypes.getModel()).addElement(dlg.getVehicleType());
            this.lstVehicleTypes.updateUI();
        }
    }

    protected void OKClicked() {
        this.setVisible(false);
    }

    protected void SelectedVehicleTypeChanged() {
        if (this.lstVehicleTypes.getSelectedValues().length == 0) {
            this.btnEdit.setEnabled(false);
            this.btnDelete.setEnabled(false);
        } else {
            this.btnEdit.setEnabled(true);
            this.btnDelete.setEnabled(true);
        }
    }
}

