/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import classes.Constants;
import helpers.MultipleTripExpander;
import helpers.RandomNumberProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import roadnetwork.Edge;
import simulation.Child;
import simulation.House;
import simulation.JobType;
import simulation.Person;
import simulation.Route;
import simulation.SUMOInstructionList;
import simulation.Trip;
import simulation.VehicleType;
import trafficdefinition.School;

public class Adult
extends Person {
    private boolean canDrive;
    private List<Child> childrenToPickupFromSchool = null;
    private List<Child> childrenToTakeToSchool = null;
    private boolean hasJob;
    private House home = null;
    private JobType job;
    private Edge jobLocation = null;
    private VehicleType vehicle = null;

    public Adult(House house, float possibilityAdultIsDriver, float possibilityAdultHasJob) {
        Random r = RandomNumberProvider.getRandom();
        this.canDrive = r.nextFloat() <= possibilityAdultIsDriver;
        this.hasJob = r.nextFloat() <= possibilityAdultHasJob;
        this.home = house;
    }

    public boolean canDrive() {
        return this.canDrive;
    }

    public boolean canPickupChildFromSchool(School school) {
        if (this.vehicle == null) {
            return false;
        }
        if (this.childrenToPickupFromSchool != null) {
            return false;
        }
        if (!this.hasJob) {
            return true;
        }
        float distanceToTravel = school.getClosestEdge().DistanceFrom(this.jobLocation);
        int estimatedTravelTime = Math.round(distanceToTravel / Constants.averageSpeed);
        return this.job.getEndingTime() + estimatedTravelTime <= school.getTimeClosing() + school.amountOfTimeChildCanWaitAfterSchool();
    }

    public boolean canTakeChildToSchool(School school, int amountOfTimeAdultAllowedToBeLate) {
        if (this.vehicle == null) {
            return false;
        }
        if (this.childrenToTakeToSchool != null) {
            return false;
        }
        if (!this.hasJob) {
            return true;
        }
        if (school.getTimeOpening() < this.job.getStartingTime()) {
            float distanceToTravel = school.getClosestEdge().DistanceFrom(this.jobLocation);
            int estimatedTravelTime = Math.round(distanceToTravel / Constants.averageSpeed);
            if (school.getTimeOpening() + estimatedTravelTime <= this.job.getStartingTime() + amountOfTimeAdultAllowedToBeLate) {
                return true;
            }
        }
        return false;
    }

    public void createTrips(String color, SUMOInstructionList<Trip> tripsList, SUMOInstructionList<Route> routesList, int counter) throws Exception {
        int timeOfDepartureFromHouse;
        float distanceHomeWork;
        float distanceHomeSchool;
        School school;
        if (this.vehicle == null) {
            return;
        }
        if (this.hasJob && this.childrenToTakeToSchool != null) {
            ArrayList<Edge> tripEdges;
            school = this.childrenToTakeToSchool.get(0).getSchool();
            distanceHomeSchool = this.home.getAddress().DistanceFrom(school.getClosestEdge());
            distanceHomeWork = this.home.getAddress().DistanceFrom(this.jobLocation);
            int estimatedTravelTimeSchoolHomeWork = Math.round((distanceHomeSchool + distanceHomeWork) / Constants.averageSpeed);
            int estimatedTravelTimeHomeSchool = Math.round(distanceHomeSchool / Constants.averageSpeed);
            int estimatedTravelTimeHomeWork = Math.round(distanceHomeWork / Constants.averageSpeed);
            int timeBetweenSchoolOpeningAndJobStarting = this.job.getStartingTime() - school.getTimeOpening();
            int timeOfDepartureFromHouseToSchool = Math.max(0, school.getTimeOpening() - estimatedTravelTimeHomeSchool);
            if (estimatedTravelTimeSchoolHomeWork + 1200 > timeBetweenSchoolOpeningAndJobStarting) {
                tripEdges = new ArrayList<Edge>();
                tripEdges.add(this.home.getAddress());
                tripEdges.add(school.getClosestEdge());
                tripEdges.add(this.jobLocation);
                String route = MultipleTripExpander.ExpandTrips(tripEdges);
                routesList.add(new Route(timeOfDepartureFromHouseToSchool, "<vehicle id=\"home-school-work-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(counter) + "\" type=\"" + this.vehicle.getName() + "\" depart=\"" + String.valueOf(timeOfDepartureFromHouseToSchool) + "\" color=\"" + color + "\">" + "<route color=\"" + color + "\">" + route + "</route>" + "</vehicle>"));
            } else {
                tripEdges = new ArrayList();
                tripEdges.add(this.home.getAddress());
                tripEdges.add(school.getClosestEdge());
                tripEdges.add(this.home.getAddress());
                String route = MultipleTripExpander.ExpandTrips(tripEdges);
                routesList.add(new Route(timeOfDepartureFromHouseToSchool, "<vehicle id=\"home-school-home-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(counter) + "\" type=\"" + this.vehicle.getName() + "\" depart=\"" + String.valueOf(timeOfDepartureFromHouseToSchool) + "\" color=\"" + color + "\">" + "<route color=\"" + color + "\">" + route + "</route>" + "</vehicle>"));
                int timeOfDepartureFromHouseToWork = Math.max(0, this.job.getStartingTime() - estimatedTravelTimeHomeWork);
                tripsList.add(new Trip(timeOfDepartureFromHouseToWork, "<tripdef id=\"house-work-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(counter) + "\" depart=\"" + String.valueOf(timeOfDepartureFromHouseToWork) + "\" from=\"" + this.home.getAddress().getId() + "\" to=\"" + this.jobLocation.getId() + "\" color=\"" + color + "\" type=\"" + this.vehicle.getName() + "\" />\n"));
            }
        } else if (this.hasJob && this.childrenToTakeToSchool == null) {
            float distanceToTravel = this.home.getAddress().DistanceFrom(this.jobLocation);
            int estimatedTravelTime = Math.round(distanceToTravel / Constants.averageSpeed);
            int timeOfDepartureFromHouse2 = Math.max(0, this.job.getStartingTime() - estimatedTravelTime);
            tripsList.add(new Trip(timeOfDepartureFromHouse2, "<tripdef id=\"house-work-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(counter) + "\" depart=\"" + String.valueOf(timeOfDepartureFromHouse2) + "\" from=\"" + this.home.getAddress().getId() + "\" to=\"" + this.jobLocation.getId() + "\" color=\"" + color + "\" type=\"" + this.vehicle.getName() + "\" />\n"));
        } else if (!this.hasJob && this.childrenToTakeToSchool != null) {
            school = this.childrenToTakeToSchool.get(0).getSchool();
            distanceHomeSchool = this.home.getAddress().DistanceFrom(school.getClosestEdge());
            int estimatedTravelTimeHomeSchool = Math.round(distanceHomeSchool / Constants.averageSpeed);
            timeOfDepartureFromHouse = Math.max(0, school.getTimeOpening() - estimatedTravelTimeHomeSchool);
            ArrayList<Edge> tripEdges = new ArrayList<Edge>();
            tripEdges.add(this.home.getAddress());
            tripEdges.add(school.getClosestEdge());
            tripEdges.add(this.home.getAddress());
            String route = MultipleTripExpander.ExpandTrips(tripEdges);
            routesList.add(new Route(timeOfDepartureFromHouse, "<vehicle id=\"home-school-home-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(counter) + "\" type=\"" + this.vehicle.getName() + "\" depart=\"" + String.valueOf(timeOfDepartureFromHouse) + "\" color=\"" + color + "\">" + "<route color=\"" + color + "\">" + route + "</route>" + "</vehicle>"));
        }
        if (this.hasJob && this.childrenToPickupFromSchool == null) {
            tripsList.add(new Trip(this.job.getEndingTime(), "<tripdef id=\"work-house-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(counter) + "\" depart=\"" + String.valueOf(this.job.getEndingTime()) + "\" from=\"" + this.jobLocation.getId() + "\" to=\"" + this.home.getAddress().getId() + "\" color=\"" + color + "\" type=\"" + this.vehicle.getName() + "\" />\n"));
        } else if (this.hasJob && this.childrenToPickupFromSchool != null) {
            int timeBetweenJobEndingAndSchoolClosing;
            school = this.childrenToPickupFromSchool.get(0).getSchool();
            distanceHomeSchool = this.home.getAddress().DistanceFrom(school.getClosestEdge());
            int estimatedTravelTimeWorkSchoolHome = Math.round((distanceHomeSchool + (distanceHomeWork = (float)this.home.getAddress().DistanceFrom(this.jobLocation))) / Constants.averageSpeed);
            if (estimatedTravelTimeWorkSchoolHome + 1200 > (timeBetweenJobEndingAndSchoolClosing = school.getTimeClosing() - this.job.getEndingTime())) {
                ArrayList<Edge> tripEdges = new ArrayList<Edge>();
                tripEdges.add(this.jobLocation);
                tripEdges.add(school.getClosestEdge());
                tripEdges.add(this.home.getAddress());
                String route = MultipleTripExpander.ExpandTrips(tripEdges);
                routesList.add(new Route(this.job.getEndingTime(), "<vehicle id=\"work-school-home-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(counter) + "\" type=\"" + this.vehicle.getName() + "\" depart=\"" + String.valueOf(this.job.getEndingTime()) + "\" color=\"" + color + "\">" + "<route color=\"" + color + "\">" + route + "</route>" + "</vehicle>"));
            } else {
                tripsList.add(new Trip(this.job.getEndingTime(), "<tripdef id=\"work-house-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(counter) + "\" depart=\"" + String.valueOf(this.job.getEndingTime()) + "\" from=\"" + this.jobLocation.getId() + "\" to=\"" + this.home.getAddress().getId() + "\" color=\"" + color + "\" type=\"" + this.vehicle.getName() + "\" />\n"));
                int estimatedTravelTime = Math.round(distanceHomeSchool / Constants.averageSpeed);
                int timeOfDepartureFromHouse3 = Math.max(0, school.getTimeClosing() - estimatedTravelTime);
                ArrayList<Edge> tripEdges = new ArrayList<Edge>();
                tripEdges.add(this.home.getAddress());
                tripEdges.add(school.getClosestEdge());
                tripEdges.add(this.home.getAddress());
                String route = MultipleTripExpander.ExpandTrips(tripEdges);
                routesList.add(new Route(timeOfDepartureFromHouse3, "<vehicle id=\"home-school-home-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(counter) + "\" type=\"" + this.vehicle.getName() + "\" depart=\"" + String.valueOf(timeOfDepartureFromHouse3) + "\" color=\"" + color + "\">" + "<route color=\"" + color + "\">" + route + "</route>" + "</vehicle>"));
            }
        } else if (!this.hasJob && this.childrenToPickupFromSchool != null) {
            school = this.childrenToPickupFromSchool.get(0).getSchool();
            float distanceToTravel = this.home.getAddress().DistanceFrom(school.getClosestEdge());
            int estimatedTravelTime = Math.round(distanceToTravel / Constants.averageSpeed);
            timeOfDepartureFromHouse = Math.max(0, school.getTimeClosing() - estimatedTravelTime);
            ArrayList<Edge> tripEdges = new ArrayList<Edge>();
            tripEdges.add(this.home.getAddress());
            tripEdges.add(school.getClosestEdge());
            tripEdges.add(this.home.getAddress());
            String route = MultipleTripExpander.ExpandTrips(tripEdges);
            routesList.add(new Route(timeOfDepartureFromHouse, "<vehicle id=\"home-school-home-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(counter) + "\" type=\"" + this.vehicle.getName() + "\" depart=\"" + String.valueOf(timeOfDepartureFromHouse) + "\" color=\"" + color + "\">" + "<route color=\"" + color + "\">" + route + "</route>" + "</vehicle>"));
        }
    }

    public JobType getJob() {
        return this.job;
    }

    public Edge getJobLocation() {
        return this.jobLocation;
    }

    public boolean hasJob() {
        return this.hasJob;
    }

    public void pickupChildrenFromSchool(List<Child> children) {
        this.childrenToPickupFromSchool = children;
    }

    public void setHasJob(boolean hasJob) {
        this.hasJob = hasJob;
    }

    public void setJobLocation(JobType job, Edge jobLocation) {
        this.jobLocation = jobLocation;
        this.job = job;
    }

    public void setVehicle(VehicleType vehicle) {
        this.vehicle = vehicle;
    }

    public void takeChildrenToSchool(List<Child> children) {
        this.childrenToTakeToSchool = children;
    }

    public VehicleType getVehicle() {
        return this.vehicle;
    }
}

