//------------------------------------------------------------------------------
// GrB_Type_wait: wait for a user-defined GrB_Type to complete
//------------------------------------------------------------------------------

// SuiteSparse:GraphBLAS, Timothy A. Davis, (c) 2017-2020, All Rights Reserved.
// http://suitesparse.com   See GraphBLAS/Doc/License.txt for license.

//------------------------------------------------------------------------------

// In SuiteSparse:GraphBLAS, a user-defined GrB_Type has no pending operations
// to wait for.  All this method does is verify that the type is properly
// initialized.

#include "GB.h"

GrB_Info GrB_Type_wait      // no work, just check if the GrB_Type is valid
(
    GrB_Type *type
)
{ 

    //--------------------------------------------------------------------------
    // check inputs
    //--------------------------------------------------------------------------

    GB_WHERE ("GrB_Type_wait (&type)") ;
    GB_RETURN_IF_NULL (type) ;
    GB_RETURN_IF_NULL_OR_FAULTY (*type) ;

    //--------------------------------------------------------------------------
    // return result
    //--------------------------------------------------------------------------

    return (GrB_SUCCESS) ;
}

