--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--
--  file:    movedefs.lua
--  brief:   moveinfo.tdf lua parser
--  author:  Dave Rodgers
--
--  Copyright (C) 2007.
--  Licensed under the terms of the GNU GPL, v2 or later.
--
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------

local moveInfo = {}


local TDF = VFS.Include('gamedata/parse_tdf.lua')

local moveTdf, err = TDF.Parse('gamedata/moveinfo.tdf')
if (moveTdf == nil) then
  error('Error parsing moveinfo.tdf: ' .. err)
end


--------------------------------------------------------------------------------
--------------------------------------------------------------------------------

local i = 0
while (true) do
  local move = moveTdf['class' .. i]
  if (type(move) ~= 'table') then
    break
  end
  i = i + 1
  moveInfo[i] = move
end


--------------------------------------------------------------------------------
--------------------------------------------------------------------------------

return moveInfo

--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
