# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v5/xml_fictionbook.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: Fictionbook XML rendition

=end
module SiSU_XML_Fictionbook
  require_relative 'se_hub_particulars'                 # se_hub_particulars.rb
    include SiSU_Particulars
  require_relative 'ao'                                 # ao.rb
  require_relative 'se'                                 # se.rb
    include SiSU_Env
  require_relative 'txt_shared'                         # txt_shared.rb
    include SiSU_TextUtils
  require_relative 'xml_shared'                         # xml_shared.rb
    include SiSU_XML_Munge
  class Source
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::CombinedSingleton.instance.get_all(opt)
    end
    def read
      begin
        @md,@ao_array=@particulars.md,@particulars.ao_array
        @env=@particulars.env
        report
        SiSU_XML_Fictionbook::Source::Scroll.new(@ao_array,@md).songsheet
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.selections.str,@opt.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
        Dir.chdir(@opt.f_pth[:pth])
      end
    end
    private
    def report
      unless @opt.act[:quiet][:set]==:on
        tool=(@opt.act[:verbose][:set]==:on \
        || @opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on) \
        ? "#{@env.program.fictionbook_viewer} #{@md.file.output_path.xml_fictionbook.dir}/#{@md.file.base_filename.xml_fictionbook}"
        : "[#{@opt.f_pth[:lng_is]}] #{@opt.fno}"
        (@opt.act[:verbose][:set]==:on \
        || @opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on) \
        ? SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            'Fictionbook',
            tool
          ).green_hi_blue
        : SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            'Fictionbook',
            tool
          ).green_title_hi
        if (@opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            @opt.fns,
            "#{@md.file.output_path.xml_fictionbook.dir}/#{@md.file.base_filename.xml_fictionbook}"
          ).flow
        end
      end
    end
    class Scroll <Source
      def initialize(data='',md='')
        @data,@md=data,md
        @trans=SiSU_XML_Munge::Trans.new(@md)
        @particulars=SiSU_Particulars::CombinedSingleton.instance.get_all(md.opt)
        @env=@particulars.env
      end
      def songsheet
        @t='sisu'
        data=@data
        if @md.opt.act[:verbose_plus][:set]==:on
          structure_collapsed(data)
        end
        head
        endnotes=extract_endnotes
        images_base64=extract_images
        data=markup_text(data)
        structure_build_collapsed(data,endnotes,images_base64)
      end
      def spaces
        Ax[:spaces]
      end
      def tags
        # collapsed -->
        def collapsed
          %w[ 0 1 2 3 4 5 ]
        end
        def fictionbook
          [
            'section',
            'section',
            'section',
            'section',
            'section',
            'section',
            'section'
          ]
        end
        self
      end
      def put(line)
        puts line if @md.opt.act[:verbose_plus][:set]==:on
      end
      def head
        version=SiSU_Env::InfoVersion.instance.get_version
        rb_ver=SiSU_Env::InfoVersion.instance.rbversion
        date_available=if defined? @md.date.available; "\n     <p>#{@md.date.available} Initial version</p>"
        else ''
        end
        date_modified=if defined? @md.date.modified; "\n      <p>#{@md.date.modified} Last Modified</p>"
        else ''
        end
        coverpageimage=if defined? @md.make.cover_image[:cover]
          %{\n    <coverpage><image href="##{@md.make.cover_image[:cover]}" /></coverpage>}
        else ''
        end
        if defined? @md.authors \
        and @md.authors.length > 0
          authors=[]
          @md.authors.each do |author|
            authors << '    <author>'
            if not author[:others].empty?
              authors << %{      <first-name>#{author[:others]}</first-name>}
            end
            if not author[:the].empty?
              authors << %{      <last-name>#{author[:the]}</last-name>}
            end
            authors << '    </author>'
          end
          authors=authors.join("\n")
        end
        <<-WOK
<?xml version="1.0" encoding="UTF-8"?>
<FictionBook xmlns:xl="http://www.w3.org/1999/xlink"
 xmlns="http://www.gribuser.ru/xml/fictionbook/2.0">
<description>
  <title-info>
    <genre match="100">***</genre>
#{authors}
    <book-title>#{@md.title.full}</book-title>#{coverpageimage}
    <annotation>
    </annotation>
    <date value="#{@md.date.published}">#{@md.date.published}</date>
  </title-info>
     <document-info>
    <author>
      <first-name/>
      <last-name/>
      <nickname/>
    </author>
    <program-used>#{version[:project]} #{version[:version]} and #{rb_ver}</program-used>
    <date value="#{version[:date]}">#{version[:date]}</date>
    <src-url>#{@md.file.output_path.manifest.url}/#{@md.file.base_filename.manifest}</src-url>
    <id></id>
    <version>1.0</version>
    <history>#{date_available}#{date_modified}
    </history>
  </document-info>
</description>
<body>
        WOK
      end
      def extract_endnotes                                #work on
        endnotes,endnotes_raw,endnotes_b=[],[],[]
        @data.each do |para|
          endnotes_raw << para.obj.scan(/#{Mx[:en_a_o]}(.+?)#{Mx[:en_a_c]}/m)
          endnotes_b << para.obj.scan(/#{Mx[:en_b_o]}(.+?)#{Mx[:en_b_c]}/m)
        end
        endnotes_raw.flatten.each do |en|
          en=@trans.markup_fictionbook(en)
          endnotes << en.gsub(/([\d+*]+)\s+(.+)/m,
            %{<section id="footnote\\1">\n
<title><p>\\1.</p></title>\n
<p>\\2</p>\n
</section>})
        end
        endnotes_raw=[]
        endnotes
      end
      def extract_images                                #work on
        begin
          require 'base64'
        rescue LoadError
          SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
            error('base64 NOT FOUND (LoadError)')
        end
        images_raw,images_base64_fb2=[],[]
        images_base64={}
        if defined? @md.make.cover_image[:cover]
          images_raw << @md.make.cover_image[:cover]
        end
        @data.each do |para|
          images_raw << para.obj.scan(/#{Mx[:lnk_o]}\s*(\S+?\.(?:png|jpg|gif)).+?#{Mx[:lnk_c]}(?:#{Mx[:url_o]}\S+?#{Mx[:url_c]}|#{Mx[:rel_o]}\S+?#{Mx[:rel_c]}|image)/m)
        end
        images_raw.flatten.sort.each do |img|
          imgpth=@env.url.images_local + '/' + img
          open(imgpth)
          if FileTest.file?(imgpth)
            images_base64[img]=Base64.encode64(File.read(imgpth))
          end
        end
        images_raw=[]
        images_base64.each_key do |k|
          imgtype=case k
          when /\.jpg/ then 'jpeg'
          when /\.png/ then 'png'
          when /\.gif/ then 'gif'
          else              'jpeg'
          end
          images_base64_fb2 << %{<binary content-type="image/#{imgtype}" id="#{k}">#{images_base64[k]}
</binary>
}
        end
        images_base64_fb2.join("\n")
      end
      def markup_text(data)
        data.each_with_index do |o,i|
          if o.is ==:heading || o.is ==:para
            o.obj=@trans.markup_fictionbook(o.obj,o.is) #unless o.obj==nil
          end
        end
        data
      end
      def tail(images_base64_fb2)
        <<-WOK
</body>
#{images_base64_fb2}
</FictionBook>
        WOK
      end
      def output(o,comment='')
         puts o.lc == (0..6) \
         ? "#{spaces*o.lc}<#{o.lc}>[#{o.ocn}] #{o.ln} #{o.obj}</#{o.lc}>#{comment}"
         : "<#{o.lc}>[#{o.ocn}] #{o.ln} #{o.obj}</#{o.lc}>#{comment}"
      end
      def structure_collapsed(data)
        puts "\ncollapsed structure, heading outline --->\n\n"
        data.each_with_index do |o,i|
          if  (o.is ==:heading || o.is ==:heading_insert)
            output(o)
          end
        end
      end
      def endnotes_build(endnotes,filename_fictionbook)
        if endnotes.length > 0
          filename_fictionbook.puts %{</body><body name="notes">}
          endnotes.each do |en|
            filename_fictionbook.puts SiSU_TextUtils::Wrap.new(en,80,6).line_wrap
          end
        end
      end
      def structure_build_collapsed(data,endnotes,images_base64)
        file=SiSU_Env::FileOp.new(@md)
        filename_fictionbook=file.write_file.xml_fictionbook
        h=0
        doc_position=:head
        filename_fictionbook.puts head
        data.each_with_index do |o,i|
          ocn=if @make.build.ocn?
            (defined? o.ocn and not o.ocn.nil?) \
            ? "\n#{Dx[:ocn_o]}#{o.ocn}#{Dx[:ocn_c]}"
            : ''
          else ''
          end
          if  o.is ==:heading
            unless doc_position==:head
              filename_fictionbook.puts structure_build_tag_close(o.lc,h)
            end
            doc_position=:body_and_tail
            filename_fictionbook.puts %{#{spaces*o.lc}<#{tags.fictionbook[o.lc]}>
#{spaces*o.lc}<title>
}
            filename_fictionbook.puts SiSU_TextUtils::Wrap.new("<p>#{o.obj}#{ocn}</p>",80,(o.lc*2+2)).line_wrap
            filename_fictionbook.puts %{#{spaces*o.lc}</title>}
            h=o.lc
          elsif  o.is ==:heading_insert \
          and o.obj =~/Endnotes/ \
          and o.ln == 1
            break
          elsif (o.of ==:para or o.of ==:block)
            filename_fictionbook.puts SiSU_TextUtils::Wrap.new("<p>#{o.obj}#{ocn}</p>",80,6).line_wrap
          end
        end
        filename_fictionbook.puts structure_build_tag_close(0,h)
        endnotes_build(endnotes,filename_fictionbook)
        filename_fictionbook.puts tail(images_base64)
        filename_fictionbook.close
      end
      def structure_build_tag_close(lc,h)
        x=[]
        case h
        when 0
          x << "#{spaces*0}</#{tags.fictionbook[0]}>" if (lc <= 0)
        when 1
          x << "#{spaces*1}</#{tags.fictionbook[1]}>" if (lc <= 1)
          x << "#{spaces*0}</#{tags.fictionbook[0]}>" if (lc <= 0)
        when 2
          x << "#{spaces*2}</#{tags.fictionbook[2]}>" if (lc <= 2)
          x << "#{spaces*1}</#{tags.fictionbook[1]}>" if (lc <= 1)
          x << "#{spaces*0}</#{tags.fictionbook[0]}>" if (lc <= 0)
        when 3
          x << "#{spaces*3}</#{tags.fictionbook[3]}>" if (lc <= 3)
          x << "#{spaces*2}</#{tags.fictionbook[2]}>" if (lc <= 2)
          x << "#{spaces*1}</#{tags.fictionbook[1]}>" if (lc <= 1)
          x << "#{spaces*0}</#{tags.fictionbook[0]}>" if (lc <= 0)
        when 4
          x << "#{spaces*4}</#{tags.fictionbook[4]}>" if (lc <= 4)
          x << "#{spaces*3}</#{tags.fictionbook[3]}>" if (lc <= 3)
          x << "#{spaces*2}</#{tags.fictionbook[2]}>" if (lc <= 2)
          x << "#{spaces*1}</#{tags.fictionbook[1]}>" if (lc <= 1)
          x << "#{spaces*0}</#{tags.fictionbook[0]}>" if (lc <= 0)
        when 5
          x << "#{spaces*5}</#{tags.fictionbook[5]}>" if (lc <= 5)
          x << "#{spaces*4}</#{tags.fictionbook[4]}>" if (lc <= 4)
          x << "#{spaces*3}</#{tags.fictionbook[3]}>" if (lc <= 3)
          x << "#{spaces*2}</#{tags.fictionbook[2]}>" if (lc <= 2)
          x << "#{spaces*1}</#{tags.fictionbook[1]}>" if (lc <= 1)
          x << "#{spaces*0}</#{tags.fictionbook[0]}>" if (lc <= 0)
        when 6
          x << "#{spaces*6}</#{tags.fictionbook[6]}>" if (lc <= 6)
          x << "#{spaces*5}</#{tags.fictionbook[5]}>" if (lc <= 5)
          x << "#{spaces*4}</#{tags.fictionbook[4]}>" if (lc <= 4)
          x << "#{spaces*3}</#{tags.fictionbook[3]}>" if (lc <= 3)
          x << "#{spaces*2}</#{tags.fictionbook[2]}>" if (lc <= 2)
          x << "#{spaces*1}</#{tags.fictionbook[1]}>" if (lc <= 1)
          x << "#{spaces*0}</#{tags.fictionbook[0]}>" if (lc <= 0)
        end
        x.join("\n")
      end
    end
  end
end
__END__
