# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v5/manpage.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: manpage text generation, stripped manpage output (unix,
     linefeed)

=end
module SiSU_Manpage
  require_relative 'ao'                                 # ao.rb
  require_relative 'se'                                 # se.rb
    include SiSU_Env
  include SiSU_Param
  require_relative 'manpage_format'                     # manpage_format.rb
    include SiSU_ManpageFormat
  require_relative 'shared_metadata'                    # shared_metadata.rb
  require_relative 'generic_parts'                      # generic_parts.rb
  require_relative 'txt_shared'                         # txt_shared.rb
  @@alt_id_count,@@alt_id_count,@@tablehead,@@number_of_cols=0,0,0,0
  @@tablefoot=''
  class Source
    def initialize(opt)
      @opt=opt
      if @opt.fns =~/(.+?)\.(?:-|ssm\.)?sst$/
        @@notes=:end
      else
        puts "#{sf} not a processed file type"
      end
    end
    def read
      begin
        @md=SiSU_Param::Parameters.new(@opt).get
        @env=SiSU_Env::InfoEnv.new(@opt.fns)
        tool=(@opt.act[:verbose][:set]==:on \
        || @opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on) \
        ?  "#{@env.program.text_editor} #{@md.file.output_path.manpage.dir}/#{@md.file.base_filename.manpage}"
        : "[#{@opt.f_pth[:lng_is]}] #{@opt.fno}"
        (@opt.act[:verbose][:set]==:on \
        || @opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on) \
        && @opt.act[:quiet][:set]==:on \
        ? SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            'Manpage',
            tool
          ).green_hi_blue
        : SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            'Manpage',
            tool
          ).green_title_hi
        if (@opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            @opt.fns,
            "#{@md.file.output_path.manpage.dir}/#{@md.file.base_filename.manpage}"
          ).flow
        end
        @ao_array=SiSU_AO::Source.new(@opt).get # ao file drawn here
        SiSU_Manpage::Source::Scroll.new(@md,@ao_array).songsheet
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.selections.str,@opt.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
        Dir.chdir(@opt.f_pth[:pth])
      end
    end
    private
    class Scroll <Source
      include SiSU_Parts_Generic
      include SiSU_TextUtils
      @@endnotes={ para: [], end: [] }
      def initialize(md,data)
        @md,@data=md,data
        @tab="\t"
        @@notes=:end
        @manpage={ body: [], open: [], close: [], head: [], metadata: [], tail: [], endnotes: [] }
      end
      def songsheet
        manpage=markup(@data)
        publish(manpage)
      end
      def break_line
        "\n"
      end
      # Used for extraction of endnotes from paragraphs
      def extract_endnotes(dob='')
        para=dob.obj.gsub(/#{Mx[:br_line]}/,"\n")
        notes=para.scan(/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]})([\d*+]+(?:\s|\n)+.+?)(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/m)
        @n=[]
        notes.flatten.each do |n| #high cost to deal with <br> appropriately within manpage, consider
          n=n.dup.to_s
          if n =~/#{Mx[:br_line]}|#{Mx[:br_nl]}/
            fix = n.split(/#{Mx[:br_line]}|#{Mx[:br_nl]}/) #watch #added
            fix.each do |x|
              unless x.empty?; @n << x
              end
            end
          else                 @n << n
          end
        end
        notes=@n.flatten
        notes.each do |e|
          util=(e.to_s =~/^\[[\d*+]+\]:/) \
          ? (SiSU_TextUtils::Wrap.new(e.to_s,78,4,1))
          : (SiSU_TextUtils::Wrap.new(e.to_s,78,0,1))
          wrap=util.line_wrap
          wrap=if wrap =~ /^\s*[\d*+]+\s+.+?\s*\Z/m
            wrap.gsub(/(^|&nbsp;|#{Mx[:nbsp]}|\s|\*)\\\*/,'\1\\\\\*'). #man page requires
              gsub(/\s(.[BI])\s/,' ').
              gsub(/\s\.(\S+)/,' \\.\1').
              gsub(/^\s*([\d*+]+)\s+(.+?)\s*\Z/m, <<GSUB
.TP
.BI \\1.
\\2
GSUB
                      )
          else
            wrap.gsub(/^\s*(.+)\Z/m, <<GSUB
\\1
GSUB
                      )
          end
          @@endnotes[:para] << wrap
          @@endnotes[:end] << wrap << "\n.BR"
          @@endnotes
        end
      end
      def manpage_metadata
        @manpage[:metadata]=SiSU_Metadata::Summary.new(@md).manpage.metadata
      end
      def manpage_tail
        @manpage[:tail] <<<<WOK
#{break_line}
.TP
.SH SEE ALSO
       sisu(1),
       sisu-epub(1),
       sisu-harvest(1),
       sisu-html(1),
       sisu-odf(1),
       sisu-pdf(1),
       sisu-pg(1),
       sisu-sqlite(1),
       sisu-txt(1).
       sisu_vim(7)
.TP
.SH HOMEPAGE
       More information about SiSU can be found at <http://www.sisudoc.org/> or <http://www.jus.uio.no/sisu/>
.TP
.SH SOURCE
       <http://git.sisudoc.org/>
.TP
.SH AUTHOR
       SiSU is written by Ralph Amissah <ralph@amissah.com>
WOK
      end
      def manpage_structure(dob='',hname='') #% Used to extract the structure of a document
        if dob.is==:heading
          lv=dob.ln
          dob.ln + 2
        else lv=nil
        end
        wrapped=if dob.is==:para \
        || dob.is==:heading
          paragraph=dob.obj
          if dob.is==:para
            if dob.indent =~/[1-9]/ \
            and dob.indent == dob.hang
              util=if dob.bullet_
                SiSU_TextUtils::Wrap.new("* #{paragraph}",78,dob.indent.to_i*2)
              else SiSU_TextUtils::Wrap.new(paragraph,78,dob.indent.to_i*2)
              end
            elsif dob.hang =~/[0-9]/ \
            and dob.indent != dob.hang                     # NOT yet implemented
              util=SiSU_TextUtils::Wrap.new(paragraph,78,dob.indent.to_i*2)
            else
              util=if dob.bullet_
                SiSU_TextUtils::Wrap.new("* #{paragraph}",78,0)
              else SiSU_TextUtils::Wrap.new(paragraph,78,0)
              end
            end
          else util=SiSU_TextUtils::Wrap.new(paragraph,78,0)
          end
          w=util.line_wrap
          w=w.gsub(/^(\\\.)/,' \1')
          w
        end
        if lv
          times=wrapped.length
          times=78 if times > 78
          @manpage[:body] << case lv
          when 0    then '.SH ' << wrapped.upcase << break_line << break_line
          when 1..3 then '.SH ' << wrapped.upcase << break_line << break_line
          when 4    then '.SH ' << wrapped.upcase << break_line << break_line
          when 5..6 then '.SH ' << wrapped.upcase << break_line << break_line
          end
        else
          @manpage[:body] << if  wrapped =~/^\.BI\s/ # main text, contents, body KEEP
            '.TP' << break_line << wrapped.gsub(/(^\.B)I\s/,'\1 ') # sleight ... simpler output (check gsub!)
          else
            break_line + '.BR' + break_line << wrapped
          end
        end
        if @@endnotes[:para] \
        and @@notes==:foot #edit out to switch off endnotes following paragraph to which they belong
          @@endnotes[:para].each { |e| @manpage[:body] << e << break_line }
        elsif @@endnotes[:para] \
        and @@notes==:end
        end
        @@endnotes[:para]=[]
      end
      def markup(data)                                                       # Used for major markup instructions
        SiSU_Env::InfoEnv.new(@md.fns)
        @data_mod,@endnotes,@level,@cont,@copen,@manpage_contents_close=Array.new(6){[]}
        (0..6).each { |x| @cont[x]=@level[x]=false }
        (4..6).each { |x| @manpage_contents_close[x]='' }
        #manpage_tail # stop call
        table_message='[table omitted, see other document formats]'
        #manpage_metadata
        data.each do |dob|
          if dob.is==:comment \
          || dob.is==:heading_insert
            dob.obj=''
          end
          dob.obj=dob.obj.gsub(/.+?<-#>/,'').                                           # remove dummy headings (used by html) #check
            gsub(/#{Mx[:fa_superscript_o]}(.+?)#{Mx[:fa_superscript_c]}/,'^\1^').
            gsub(/#{Mx[:fa_subscript_o]}(.+?)#{Mx[:fa_subscript_c]}/,'[\1]').
            gsub(/#{Mx[:fa_insert_o]}(.+?)#{Mx[:fa_insert_c]}/,'++\1++').
            gsub(/#{Mx[:fa_strike_o]}(.+?)#{Mx[:fa_strike_c]}/,'--\1--').
            gsub(/#{Mx[:fa_cite_o]}(.+?)#{Mx[:fa_cite_c]}/,'"\1"').
            gsub(/#{Mx[:fa_monospace_o]}(.+?)#{Mx[:fa_monospace_c]}/,'\1').
            gsub(/\A\s*#{Mx[:fa_italics_o]}(.+?)#{Mx[:fa_italics_c]}#{Mx[:br_line]}([,.:!?](?: |$))?/m,
              "#{Mx[:br_line]}.I \\1\\2#{Mx[:br_line]}").
            gsub(/\s*#{Mx[:fa_italics_o]}(.+?)#{Mx[:fa_italics_c]}([,.:!?](?: |$))?/m,
              "#{Mx[:br_line]}.I \\1\\2#{Mx[:br_line]}").
            gsub(/\A\s*#{Mx[:fa_bold_o]}(.+?)#{Mx[:fa_bold_c]}([,.:!?](?: |$))?#{Mx[:br_line]}/m,
              "\n.BI \\1\\2#{Mx[:br_line]}").
            gsub(/\s*#{Mx[:fa_bold_o]}(.+?)#{Mx[:fa_bold_c]}([,.:!?](?: |$))?/m,
              "#{Mx[:br_line]}.B \\1\\2#{Mx[:br_line]}").
            gsub(/\s*#{Mx[:fa_underscore_o]}(.+?)#{Mx[:fa_underscore_c]}([,.:!?](?: |$))?/,
              "\n.I \\1\\2#{Mx[:br_line]}")
          unless dob.is==:code
            dob.obj=dob.obj.gsub(/(?:^|\s)#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}([,.:!?](?: |$))?/,
                "\\1 #{the_text.url_open}\\2#{the_text.url_close}\\3").
              gsub(/(^|#{Mx[:gl_c]}|\s)#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}([,.:!?](?: |$))?/,
                "\\1#{the_text.url_open}\\2#{the_text.url_close}\\3")
            @manpage[:endnotes]=extract_endnotes(dob)
            dob.obj=dob.obj.gsub(/#{Mx[:en_a_o]}([\d*+]+)\s*(?:.+?)#{Mx[:en_a_c]}/m,'[^\1]'). # endnote marker marked up
              gsub(/#{Mx[:en_b_o]}([\d*+]+)\s*(?:.+?)#{Mx[:en_b_c]}/m,'[^\1]'). # endnote marker marked up
              gsub(/#{Mx[:gl_o]}#amp#{Mx[:gl_c]}/,'&'). ##{Mx[:gl_o]}#095#{Mx[:gl_c]}
              gsub(/#{Mx[:gl_o]}#033#{Mx[:gl_c]}/,'!').
              gsub(/#{Mx[:gl_o]}#035#{Mx[:gl_c]}/,'#').
              gsub(/#{Mx[:gl_o]}#042#{Mx[:gl_c]}/,'*').
              gsub(/#{Mx[:gl_o]}#045#{Mx[:gl_c]}/,'-').
              gsub(/#{Mx[:gl_o]}#092#{Mx[:gl_c]}/,'\e').
              gsub(/#{Mx[:gl_o]}#047#{Mx[:gl_c]}/,'/').
              gsub(/#{Mx[:gl_o]}#095#{Mx[:gl_c]}/,'_').
              gsub(/#{Mx[:gl_o]}#123#{Mx[:gl_c]}/,'{').
              gsub(/#{Mx[:gl_o]}#125#{Mx[:gl_c]}/,'}').
              gsub(/#{Mx[:gl_o]}#126#{Mx[:gl_c]}/,'~').
              gsub(/#{Mx[:gl_o]}#169#{Mx[:gl_c]}/,'©')
          else
            dob.obj=dob.obj.gsub(/\\/,'\e').
              gsub(/(?:#{Mx[:br_line]}|#{Mx[:br_nl]})\s*/,"\n")                          # watch
          end
          dob.obj=dob.obj.gsub(/(^|&nbsp;|#{Mx[:nbsp]}|\s|\*)\\\*/,'\1\\\\\*').          #man page requires
            gsub(/┆/,'|').
            gsub(/^(\.\S{3,})/m,' \1')                                                   # ^\. used by interpreter, disable when use not intended
          dob.obj=dob.obj.gsub(/&#126;/,'~') if dob.obj #manpages use this
          if dob.is ==:code
            dob.obj=dob.obj.gsub(/(^|[^}])_([<>])/m,'\1\2'). # _> _<
              gsub(/(^|[^}])_([<>])/m,'\1\2'). # _<_<
              gsub(/(?:#{Mx[:br_line]}|#{Mx[:br_nl]})+(\s*)/m,"\n\\1").                  # watch
              gsub(/\A(.+?)\s*\Z/m,".nf\n\\1\n.fi")
          end
          dob.obj=dob.obj.gsub(/(?:#{Mx[:br_line]}|#{Mx[:br_nl]})+\s*/m,"\n\n")          # watch
          dob.obj=dob.obj.gsub(/#{Mx[:gl_o]}:name#\S+?#{Mx[:gl_c]}/mi,'').               #added
            gsub(/#{Mx[:br_page]}\s*|#{Mx[:br_page_new]}|#{Mx[:br_page_line]}/,'').      # remove page breaks, you may wish to have a line across the page break instead
            gsub(/(^|#{Mx[:gl_c]}|\s)#{Mx[:url_o]}_(\S+?)#{Mx[:url_c]}/,'\1\2').
            gsub(/<a href=".+?">(.+?)<\/a>/m,'\1').
            gsub(/#{Mx[:mk_o]}name#\S+?#{Mx[:mk_c]}/,'').                                # remove name links
            gsub(/&nbsp;|#{Mx[:nbsp]}/,' ').                                             # decide on
            gsub(/(?:^|[^_\\])#{Mx[:lnk_o]}\s*(\S+?\.(?:png|jpg|gif)) .+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/,'    [ \1 ]'). #"[ #{dir.url.images_local}\/\\1 ]")
            gsub(/(?:^|[^_\\])#{Mx[:lnk_o]}\s*(\S+?\.(?:png|jpg|gif)) .+?#{Mx[:lnk_c]}image/,'    [ \1 ]'). #"[ #{dir.url.images_local}\/\\1 ]")
            gsub(/^(?:^|[^_\\])#{Mx[:lnk_o]}\s*\S+?\.(?:png|jpg|gif)\s+.+?"(.*?)"\s*#{Mx[:lnk_c]}\S+/,'[image: "\1"]')
          if dob.obj !~/(^#{Rx[:meta]}|#{Mx[:br_eof]}|#{Mx[:br_endnotes]})/
            if dob.obj =~@regx #/.+?<~\d+;\w\d+;\w\d+>.*/ #watch change
              paranum=dob.obj[@regx,3]
              @p_num=SiSU_ManpageFormat::ParagraphNumber.new(paranum)
            end
            SiSU_ManpageFormat::FormatTextObject.new(@md,dob) #check
            if dob.is==:heading
              manpage_structure(dob)
            elsif dob.is==:para
              manpage_structure(dob)
            else
              if dob.obj =~/#{table_message}/
                @manpage[:body] << dob.obj << break_line
              end
            end
            if (dob.obj =~/<a name="n\d+">/ \
            and dob.obj =~/^(-\{{2}~\d+|<!e[:_]\d+!>)/) # -endnote
              dob.obj=''
            end
            if dob.obj
              dob.obj=dob.obj.gsub(/(?:#{Mx[:br_line]}|#{Mx[:br_nl]})\s*/,"\n\n").                                   # watch
                gsub(/#{Mx[:gl_o]}#126#{Mx[:gl_c]}/,'~').
                gsub(/#{Mx[:gl_o]}#123#{Mx[:gl_c]}/,'{').
                gsub(/#{Mx[:pa_o]}\S+#{Mx[:pa_c]}/,' ')
              unless dob.is ==:code
                dob.obj=dob.obj.gsub(/<!.+!>/,' ').
                  gsub(/<:\S+>/,' ')
              end
            end
            dob
          end
        end
        @manpage
      end
      def publish(manpage)
        content=[]
        date=if defined? @md.date.modified \
        and @md.date.modified
          @md.date.modified
        elsif defined? @md.date.published \
        and @md.date.published
          @md.date.published
        else SiSU_Env::InfoDate.new.year #date missing decide on action
        end
        proj=SiSU_Env::InfoVersion.instance.get_version
        manpage[:open] = %{.TH "#{@md.fnb}" "#{@md.make.manpage['section']}" "#{date}" "#{proj[:version]}" "#{@md.title.main}"#{@md.make.manpage['name']}#{@md.make.manpage['synopsis']}}
        content << manpage[:open]
        content << manpage[:head]
        content << manpage[:body]
        content << @@endnotes[:end] if @@notes==:end
        content << manpage[:metadata]
        content << manpage[:tail]
        Output.new(@md,content).manpage
        @@endnotes={ para: [], end: [] }
      end
    end
    class Output <Source
      include SiSU_Param
      include SiSU_Env
      def initialize(md,content)
        @md,@content=md,content
      end
      def manpage                                                            #%manpage output
        SiSU_Env::FileOp.new(@md).mkdir
        filename_manpage=SiSU_Env::FileOp.new(@md).write_file.manpage
        @sisu=[]
        emptyline=0
        @content.each do |para|                                                # this is a hack
          if para.is_a?(Array) \
          and para.length > 0
            para.each do |line|
              if line
                line=line.gsub(/[ \t]+$/m,'').
                  gsub(/^\A[ ]*\Z/m,'')
                (line=~/^\A\Z/) \
                ? (emptyline+=1)
                : emptyline=0
                if emptyline < 2                     #remove additional empty lines
                  filename_manpage.puts line           #unix manpage
                end
              end
            end
          else filename_manpage.puts para          #unix manpage # /^([*=-]|\.){5}/
          end
        end
        filename_manpage.close
      end
    end
  end
end
__END__
